(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11871,        404]
NotebookOptionsPosition[      9026,        312]
NotebookOutlinePosition[     10438,        351]
CellTagsIndexPosition[     10353,        346]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Text and Font Options" :> 
          Documentation`HelpLookup["paclet:tutorial/TextAndFontOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Text and Font Options\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AutoIndent" :> 
          Documentation`HelpLookup["paclet:ref/AutoIndent"], "LineIndent" :> 
          Documentation`HelpLookup["paclet:ref/LineIndent"], 
          "ParagraphSpacing" :> 
          Documentation`HelpLookup["paclet:ref/ParagraphSpacing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AutoIndent\"\>", 
       2->"\<\"LineIndent\"\>", 
       3->"\<\"ParagraphSpacing\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Text Layout Options" :> 
          Documentation`HelpLookup["paclet:guide/TextLayoutOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Text Layout Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ParagraphIndent", "ObjectName",
 CellID->1898],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ParagraphIndent",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ParagraphIndent"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies how far in printer\[CloseCurlyQuote]s points to indent \
the first line of each paragraph of text. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->985]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
A new paragraph is taken to start at the beginning of a cell, and after every \
explicit Return character in your text. \
\>", "Notes",
 CellID->21447],

Cell[TextData[{
 "Negative settings for ",
 Cell[BoxData[
  ButtonBox["ParagraphIndent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParagraphIndent"]], "InlineFormula"],
 " make the first line of each paragraph stick out to the left. "
}], "Notes",
 CellID->1084]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->245051068],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->382062733],

Cell["\<\
Use varying amounts of indentation for the first line of a paragraph:\
\>", "ExampleText",
 CellID->443474887],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"TextCell", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"Table", "[", 
        RowBox[{"\"\<abcd \>\"", ",", 
         RowBox[{"{", "40", "}"}]}], "]"}], "]"}], ",", "\"\<Text\>\"", ",", 
      RowBox[{"CellMargins", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"100", ",", "100"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "6"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"ParagraphIndent", "\[Rule]", "ind"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"ind", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "12"}], ",", "0", ",", "12"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139215310],

Cell["\<\
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
\>", "Text",
 CellMargins->{{100, 100}, {6, 6}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ParagraphIndent->-12,
 CellID->57641611],

Cell["\<\
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
\>", "Text",
 CellMargins->{{100, 100}, {6, 6}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ParagraphIndent->0,
 CellID->5444961],

Cell["\<\
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
\>", "Text",
 CellMargins->{{100, 100}, {6, 6}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ParagraphIndent->12,
 CellID->11562559]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24828],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AutoIndent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutoIndent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LineIndent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LineIndent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParagraphSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParagraphSpacing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15338]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->592],

Cell[TextData[ButtonBox["Text and Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TextAndFontOptions"]], "Tutorials",
 CellID->18725]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->867778903],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "MoreAbout",
 CellID->125960623]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParagraphIndent - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 6, 7.8477212}", "context" -> "System`", 
    "keywords" -> {
     "indentation", "paragraph shape", "paragraph indentation", 
      "first line indentation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ParagraphIndent is an option for Cell which specifies how far in printer\
\\[CloseCurlyQuote]s points to indent the first line of each paragraph of \
text. ", "synonyms" -> {"paragraph indent"}, "title" -> "ParagraphIndent", 
    "type" -> "Symbol", "uri" -> "ref/ParagraphIndent"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4309, 140, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->245051068]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10210, 339}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1982, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2605, 77, 52, 1, 70, "ObjectName",
 CellID->1898],
Cell[2660, 80, 664, 19, 70, "Usage",
 CellID->985]
}, Open  ]],
Cell[CellGroupData[{
Cell[3361, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3839, 121, 161, 4, 70, "Notes",
 CellID->21447],
Cell[4003, 127, 269, 8, 70, "Notes",
 CellID->1084]
}, Closed]],
Cell[CellGroupData[{
Cell[4309, 140, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->245051068],
Cell[CellGroupData[{
Cell[4694, 154, 148, 5, 70, "ExampleSection",
 CellID->382062733],
Cell[4845, 161, 120, 3, 70, "ExampleText",
 CellID->443474887],
Cell[4968, 166, 827, 25, 70, "Input",
 CellID->139215310],
Cell[5798, 193, 354, 9, 70, "Text",
 CellID->57641611],
Cell[6155, 204, 351, 9, 70, "Text",
 CellID->5444961],
Cell[6509, 215, 353, 9, 70, "Text",
 CellID->11562559]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6911, 230, 311, 9, 70, "SeeAlsoSection",
 CellID->24828],
Cell[7225, 241, 720, 26, 70, "SeeAlso",
 CellID->15338]
}, Open  ]],
Cell[CellGroupData[{
Cell[7982, 272, 312, 9, 70, "TutorialsSection",
 CellID->592],
Cell[8297, 283, 150, 3, 70, "Tutorials",
 CellID->18725]
}, Open  ]],
Cell[CellGroupData[{
Cell[8484, 291, 319, 9, 70, "MoreAboutSection",
 CellID->867778903],
Cell[8806, 302, 148, 3, 70, "MoreAbout",
 CellID->125960623]
}, Open  ]],
Cell[8969, 308, 27, 0, 70, "History"],
Cell[8999, 310, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

