(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14650,        502]
NotebookOptionsPosition[     11463,        398]
NotebookOutlinePosition[     12876,        437]
CellTagsIndexPosition[     12791,        432]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Text and Font Options" :> 
          Documentation`HelpLookup["paclet:tutorial/TextAndFontOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Text and Font Options\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LineSpacing" :> 
          Documentation`HelpLookup["paclet:ref/LineSpacing"], 
          "ParagraphIndent" :> 
          Documentation`HelpLookup["paclet:ref/ParagraphIndent"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LineSpacing\"\>", 
       2->"\<\"ParagraphIndent\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Text Layout Options" :> 
          Documentation`HelpLookup["paclet:guide/TextLayoutOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Text Layout Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ParagraphSpacing", "ObjectName",
 CellID->5416],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ParagraphSpacing",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ParagraphSpacing"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["StyleBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style",
       ButtonNote->"ObsLink: StyleForm -> Style"]], "InlineFormula"],
     " which specifies how much extra space to leave between successive \
paragraphs of text. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5893]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ParagraphSpacing", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["c", "TI"], ",", "0"}], "}"}]}]], "InlineFormula"],
 " leaves an extra space of ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " times the height of the font in the paragraph. "
}], "Notes",
 CellID->1949],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ParagraphSpacing", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     StyleBox["n", "TI"]}], "}"}]}]], "InlineFormula"],
 " leaves an extra space of exactly ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " printer\[CloseCurlyQuote]s points. "
}], "Notes",
 CellID->30971],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ParagraphSpacing", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["c", "TI"], ",", 
     StyleBox["n", "TI"]}], "}"}]}]], "InlineFormula"],
 " leaves an extra space of ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " times the height of the font plus ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " printer\[CloseCurlyQuote]s points. "
}], "Notes",
 CellID->10844],

Cell["\<\
Paragraph breaks are taken to occur whenever an explicit Return character \
appears in a block of text. \
\>", "Notes",
 CellID->22777],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParagraphSpacing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParagraphSpacing"]], "InlineFormula"],
 " is added to ",
 Cell[BoxData[
  ButtonBox["LineSpacing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LineSpacing"]], "InlineFormula"],
 " to determine spacing between paragraphs. "
}], "Notes",
 CellID->19285],

Cell[TextData[{
 "A typical default setting is ",
 Cell[BoxData[
  RowBox[{"ParagraphSpacing", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26200],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParagraphSpacing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParagraphSpacing"]], "InlineFormula"],
 " applies only to ordinary text, not ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. "
}], "Notes",
 CellID->14590],

Cell[TextData[{
 "Extra space specified by ",
 Cell[BoxData[
  ButtonBox["ParagraphSpacing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParagraphSpacing"]], "InlineFormula"],
 " is inserted before the first line of each paragraph. No extra space is \
inserted if the paragraph is at the beginning of a cell or a string. "
}], "Notes",
 CellID->10285]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->545787860],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->41378321],

Cell["\<\
Create cells with varying amounts of space between paragraphs:\
\>", "ExampleText",
 CellID->358510056],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"TextCell", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"StringJoin", "[", 
         RowBox[{"#", ",", "\"\<\\n\>\"", ",", "#"}], "]"}], "&"}], "[", 
       RowBox[{"Table", "[", 
        RowBox[{"\"\<abcd \>\"", ",", 
         RowBox[{"{", "30", "}"}]}], "]"}], "]"}], ",", "\"\<Text\>\"", ",", 
      RowBox[{"CellMargins", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"100", ",", "100"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "6"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"CellFrame", "\[Rule]", "True"}], ",", 
      RowBox[{"ParagraphSpacing", "\[Rule]", "par"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"par", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183431151],

Cell["\<\
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd 
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
\>", "Text",
 CellFrame->True,
 CellMargins->{{100, 100}, {6, 6}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ParagraphSpacing->0,
 CellID->108388011],

Cell["\<\
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd 
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
\>", "Text",
 CellFrame->True,
 CellMargins->{{100, 100}, {6, 6}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ParagraphSpacing->1,
 CellID->205455072],

Cell["\<\
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd 
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
\>", "Text",
 CellFrame->True,
 CellMargins->{{100, 100}, {6, 6}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ParagraphSpacing->2,
 CellID->7474737]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9729],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LineSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LineSpacing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParagraphIndent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParagraphIndent"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24008]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28325],

Cell[TextData[ButtonBox["Text and Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TextAndFontOptions"]], "Tutorials",
 CellID->17118]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->596947498],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "MoreAbout",
 CellID->807861563]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParagraphSpacing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 6, 8.1446038}", "context" -> "System`", 
    "keywords" -> {
     "inter-paragraph spacing", "interparagraph spacing", "paragraph skip", 
      "\\parskip (TeX)"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ParagraphSpacing is an option for Cell, StyleBox and Style which \
specifies how much extra space to leave between successive paragraphs of \
text. ", "synonyms" -> {"paragraph spacing"}, "title" -> "ParagraphSpacing", 
    "type" -> "Symbol", "uri" -> "ref/ParagraphSpacing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6565, 229, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->545787860]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12648, 425}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1871, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2494, 75, 53, 1, 70, "ObjectName",
 CellID->5416],
Cell[2550, 78, 978, 30, 70, "Usage",
 CellID->5893]
}, Open  ]],
Cell[CellGroupData[{
Cell[3565, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4043, 130, 331, 11, 70, "Notes",
 CellID->1949],
Cell[4377, 143, 328, 11, 70, "Notes",
 CellID->30971],
Cell[4708, 156, 439, 15, 70, "Notes",
 CellID->10844],
Cell[5150, 173, 145, 4, 70, "Notes",
 CellID->22777],
Cell[5298, 179, 368, 12, 70, "Notes",
 CellID->19285],
Cell[5669, 193, 210, 8, 70, "Notes",
 CellID->26200],
Cell[5882, 203, 287, 10, 70, "Notes",
 CellID->14590],
Cell[6172, 215, 356, 9, 70, "Notes",
 CellID->10285]
}, Closed]],
Cell[CellGroupData[{
Cell[6565, 229, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->545787860],
Cell[CellGroupData[{
Cell[6950, 243, 147, 5, 70, "ExampleSection",
 CellID->41378321],
Cell[7100, 250, 113, 3, 70, "ExampleText",
 CellID->358510056],
Cell[7216, 255, 905, 25, 70, "Input",
 CellID->183431151],
Cell[8124, 282, 473, 11, 70, "Text",
 CellID->108388011],
Cell[8600, 295, 473, 11, 70, "Text",
 CellID->205455072],
Cell[9076, 308, 471, 11, 70, "Text",
 CellID->7474737]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9596, 325, 310, 9, 70, "SeeAlsoSection",
 CellID->9729],
Cell[9909, 336, 471, 17, 70, "SeeAlso",
 CellID->24008]
}, Open  ]],
Cell[CellGroupData[{
Cell[10417, 358, 314, 9, 70, "TutorialsSection",
 CellID->28325],
Cell[10734, 369, 150, 3, 70, "Tutorials",
 CellID->17118]
}, Open  ]],
Cell[CellGroupData[{
Cell[10921, 377, 319, 9, 70, "MoreAboutSection",
 CellID->596947498],
Cell[11243, 388, 148, 3, 70, "MoreAbout",
 CellID->807861563]
}, Open  ]],
Cell[11406, 394, 27, 0, 70, "History"],
Cell[11436, 396, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

