(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    188383,       6095]
NotebookOptionsPosition[    162116,       5198]
NotebookOutlinePosition[    164651,       5253]
CellTagsIndexPosition[    164564,       5248]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Internet Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InternetConnectivity"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathematica Internet Connectivity\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IsotopeData" :> 
          Documentation`HelpLookup["paclet:ref/IsotopeData"], "ElementData" :> 
          Documentation`HelpLookup["paclet:ref/ElementData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IsotopeData\"\>", 
       2->"\<\"ElementData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integrated Data Sources" :> 
          Documentation`HelpLookup["paclet:guide/DataCollections"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integrated Data Sources\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ParticleData", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ParticleData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ParticleData"], "[", 
       RowBox[{
        StyleBox["name", "TI"], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the specified property for a subatomic particle \
or family of particles with the specified name. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ParticleData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ParticleData"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["name", "TI"], ",", 
          StyleBox["q", "TI"]}], "}"}], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the specified property for a version of the \
particle with charge ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Typical forms of names for long-lived particles include ",
 Cell[BoxData["\"\<Electron\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Photon\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<MuonNeutrino\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<ElectronNeutrinoBar\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<PiZero\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<OmegaMinus\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->808132238],

Cell[TextData[{
 "Generic names such as ",
 Cell[BoxData["\"\<PiMeson\>\""], "InlineFormula"],
 " can be used to refer to charge multiplets. ",
 Cell[BoxData["\"\<PiMinus\>\""], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<PiMeson\>\"", ",", " ", 
    RowBox[{"-", "1"}]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12921596],

Cell[TextData[{
 "Excited-state hadrons are referred to by names such as ",
 Cell[BoxData["\"\<K1Meson1400\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->305076519],

Cell[TextData[{
 "Quarks are referred to as ",
 Cell[BoxData["\"\<UpQuark\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<StrangeQuark\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<BottomQuark\>\""], "InlineFormula"],
 ", etc. Gauge bosons are ",
 Cell[BoxData["\"\<Gluon\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<WBoson\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<ZBoson\>\""], "InlineFormula"],
 ", etc."
}], "Notes",
 CellID->55906669],

Cell[TextData[{
 "Distinct antiparticles are referred to by names that end in Bar, such as ",
 Cell[BoxData["\"\<KZeroBar\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->930067760],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParticleData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParticleData"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParticleData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParticleData"], "[", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " give a list of all known particles in order of increasing mass."
}], "Notes",
 CellID->516899279],

Cell["Basic properties include:", "Notes",
 CellID->175856496],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Charge\>\"", Cell[
    "charge", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HalfLife\>\"", Cell[
    "half\[Hyphen]life in seconds", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Lifetime\>\"", Cell[
    "lifetime in seconds", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Mass\>\"", Cell[
    "mass in MeV", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<QuarkContent\>\"", Cell[
    "list of constituent quarks", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Symbol\>\"", Cell[
    "standard particle symbol", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Width\>\"", Cell[
    "decay width in MeV", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->904365843],

Cell["Quantum numbers include:", "Notes",
 CellID->57311337],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BaryonNumber\>\"", Cell[TextData[{
     "baryon number ",
     Cell[BoxData[
      FormBox["B", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Bottomness\>\"", Cell[
    "bottom number (b quark content)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Charm\>\"", Cell[TextData[{
     "charm ",
     Cell[BoxData[
      FormBox["C", TraditionalForm]], "InlineMath"],
     " (c quark content)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CParity\>\"", Cell[TextData[{
     "charge conjugation parity ",
     Cell[BoxData[
      FormBox["C", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GParity\>\"", Cell[TextData[{
     "isospin parity ",
     Cell[BoxData[
      FormBox["G", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hypercharge\>\"", Cell[TextData[{
     "hypercharge ",
     Cell[BoxData[
      FormBox["Y", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Isospin\>\"", Cell[TextData[{
     "isospin ",
     Cell[BoxData[
      FormBox["I", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IsospinProjection\>\"", Cell[
    TextData[{
     "isospin projection ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["I", "3"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LeptonNumber\>\"", Cell[TextData[{
     "lepton number ",
     Cell[BoxData[
      FormBox["L", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Parity\>\"", Cell[TextData[{
     "spin parity ",
     Cell[BoxData[
      FormBox["P", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Spin\>\"", Cell[TextData[{
     "spin angular momentum ",
     Cell[BoxData[
      FormBox["J", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Strangeness\>\"", Cell[TextData[{
     "strangeness ",
     Cell[BoxData[
      FormBox["S", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Topness\>\"", Cell[
    "top number (t quark content)", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, {
     None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True}}}},
 CellID->567883567],

Cell["Properties for long-lived particles include:", "Notes",
 CellID->47209957],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ChargeRadius\>\"", Cell[
    "charge radius in fm", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GFactor\>\"", Cell[
    "g factor", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->140518205],

Cell["Related particle properties include:", "Notes",
 CellID->444174937],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Antiparticle\>\"", Cell[
    "antiparticle of the given particle", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ChargeStates\>\"", Cell[
    "list of charges of particles in the same isospin multiplet", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Excitations\>\"", Cell[
    "particles with the same internal quantum numbers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IsospinMultiplet\>\"", Cell[
    "list of particles in the same isospin multiplet", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->18942721],

Cell["Decay-related properties include:", "Notes",
 CellID->299455928],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DecayModes\>\"", Cell[
    "list of observed decay modes and branching ratios", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DecayType\>\"", Cell[TextData[{
     "dominant decay type (",
     Cell[BoxData["\"\<Strong\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<Weak\>\""], "InlineFormula"],
     ", ...)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FullDecayModes\>\"", Cell[
    "list of all decay modes, including unobserved ones ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnobservedDecayModes\>\"", Cell[
    "list of unobserved decay modes and upper bounds", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->218008144],

Cell[TextData[{
 "Each decay mode is by default specified in the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["3", "TR"]]}], "}"}], ",", 
    StyleBox["b", "TI"]}], "}"}]], "InlineFormula"],
 " where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are decay products, and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " is the branching ratio."
}], "Notes",
 CellID->327232522],

Cell[TextData[{
 "In ",
 Cell[BoxData["\"\<FullDecayModes\>\""], "InlineFormula"],
 ", branching ratios of unobserved modes are given as ",
 Cell[BoxData["0."], "InlineFormula"],
 " with a precision corresponding to the measured upper bound."
}], "Notes",
 CellID->308869449],

Cell["\<\
Names\[Hyphen]related properties include:\
\>", "Notes",
 CellID->71633798],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<FullSymbol\>\"", Cell[
    "standard particle symbol, including approximate mass", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GenericFullSymbol\>\"", Cell[
    "standard particle symbol, with mass but not charge state", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GenericSymbol\>\"", Cell[
    "standard particle symbol, excluding charge state ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PDGNumber\>\"", Cell[
    "PDG Monte Carlo particle number", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StandardName\>\"", Cell[TextData[{
     "standard ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " name"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Symbol\>\"", Cell[
    "standard particle symbol", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->119957635],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParticleData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParticleData"], "[", "\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\>\"", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives a list of particles in the specified class. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParticleData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParticleData"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", "\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " depending on whether the particle corresponding to ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " is in the specified class."
}], "Notes",
 CellID->482514198],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParticleData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParticleData"], "[", "\"\<Classes\>\"", "]"}]], 
  "InlineFormula"],
 " gives a list of names of classes."
}], "Notes",
 CellID->434747015],

Cell[TextData[{
 "Basic classes of particles include: ",
 Cell[BoxData["\"\<Lepton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Hadron\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<GaugeBoson\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Quark\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Meson\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Baryon\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Stable\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<LongLived\>\""], "InlineFormula"],
 " (stable for >",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "20"}]], TraditionalForm]], "InlineMath"],
 " seconds), ",
 Cell[BoxData["\"\<Fermion\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Boson\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->329416671],

Cell[TextData[{
 "Specific classes of particles include: ",
 Cell[BoxData["\"\<UnflavoredMeson\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<UnflavoredBaryon\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<StrangeMeson\>\""], "InlineFormula"],
 " (meson with nonzero strangeness but zero charm, etc.), ",
 Cell[BoxData["\"\<StrangeBaryon\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<CharmedMeson\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<CharmedBaryon\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<CCBarMeson\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<StrangeCharmedMeson\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<StrangeCharmedBaryon\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<BottomMeson\>\""], "InlineFormula"],
 ", etc."
}], "Notes",
 CellID->443994758],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParticleData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParticleData"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"ann\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives various annotations associated with a property. Typical annotations \
include:"
}], "Notes",
 CellID->276644756],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Description\>\"", Cell[TextData[{
     Cell[BoxData[Cell["", "TableText"]]],
     "short textual description of the property"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Interval\>\"", Cell[TextData[{
     "uncertainty range given by ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Interval",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Interval"], "[", 
       StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LongDescription\>\"", Cell[
    "longer textual description of the property ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Note\>\"", Cell[
    "additional information about the property", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Units\>\"", Cell[
    "units in which the value is given", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsName\>\"", Cell[
    "English name for the units used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsNotation\>\"", Cell[
    "notation for the units used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsStandardName\>\"", Cell[
    TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " standard name for the units used"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->524183967]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25556635],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->100043458],

Cell["Find the mass of the muon in MeV:", "ExampleText",
 CellID->259621278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Muon\>\"", ",", "\"\<Mass\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->612530324],

Cell[BoxData["105.658369`9.000000000000002"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->518629544]
}, Open  ]],

Cell["The lifetime of the muon in seconds:", "ExampleText",
 CellID->648775118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Muon\>\"", ",", "\"\<Lifetime\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->77985915],

Cell[BoxData["2.19704`5.999999999999999*^-6"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2118106482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->267700537],

Cell["Find the primary quark content of the proton:", "ExampleText",
 CellID->374902405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Proton\>\"", ",", "\"\<QuarkContent\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1231026364],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"DownQuark\"\>", ",", "\<\"UpQuark\"\>", 
    ",", "\<\"UpQuark\"\>"}], "}"}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179226655]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->536340148],

Cell["A list of leptons:", "ExampleText",
 CellID->437409149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", "\"\<Lepton\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175754708],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"TauNeutrino\"\>", ",", "\<\"TauNeutrinoBar\"\>", 
   ",", "\<\"MuonNeutrino\"\>", ",", "\<\"MuonNeutrinoBar\"\>", 
   ",", "\<\"ElectronNeutrino\"\>", ",", "\<\"ElectronNeutrinoBar\"\>", 
   ",", "\<\"Electron\"\>", ",", "\<\"Positron\"\>", ",", "\<\"Muon\"\>", 
   ",", "\<\"MuonBar\"\>", ",", "\<\"TauLepton\"\>", 
   ",", "\<\"TauLeptonBar\"\>"}], "}"}]], "Output",
 ImageSize->{555, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1490317491]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ParticleData", "[", 
    RowBox[{"#", ",", "\"\<FullSymbol\>\""}], "]"}], "&"}], "/@", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205313043],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Vs1OwzAMdpt2WyfoGAwEt8GFCzwCVzjxENWEtB0QaOydeEHuoWmdkn1x
+sMQkxbXn50vtuMmfS5265fXYrdZFcunbfG+3qw+lo9v2xJSERHp8j+/pPJZ
s6bNj+jBjMrqms5B/xzglQCalYNRY8BnjCvAj8shFfzzAG54YvLXtTjynwh+
rj46UEc+XK+Kx4tqCnrM0UuzDW6qQckPTo1l1m5xuJIAbv3nTgxGjoXM23A7
71TIza8A7h/aUZ902JEP/d0+IqF/soH+Er9R055+El8i4OMAPmIebjBqHgf6
jFvilvDwbsYBb4NnAbsCe8UrdvO008PlsJFLuI0Vd6arvxGPHa4228SL2Foy
0eJXG89Am5ni3shB3zsL9/jDFstxwXIBa+KpUelpo9ck1WnuoznMxVMOz9RI
Sz3mx3zmIYseSJ9ZxiflfNJgXr/Ltt8b9d/ZDsrujyohdztWArtf+iJos+Oq
Q+2H8pt7VfG7Z2XfCh7puv/s11C/in2JXjj3iuO5Z3nH8pblNcsbLd9Y9aWi
AyNF32ZZY1g=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{255, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->462064175]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121316636],

Cell["A list of baryons:", "ExampleText",
 CellID->50641208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ParticleData", "[", "\"\<Baryon\>\"", "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->197540885],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"Proton\"\>", ",", "\<\"ProtonBar\"\>", ",", "\<\"Neutron\"\>",
     ",", 
    RowBox[{"\[LeftSkeleton]", "569", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"LambdaB\"\>", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"LambdaBBar\"\>", ",", "0"}], "}"}]}], "}"}],
  Short]], "Output",
 ImageSize->{461, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->853008557]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(21)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Names and Classes",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(14)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->223414956],

Cell["\<\
Obtain a list of all the elementary particles sorted by mass:\
\>", "ExampleText",
 CellID->388487866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"ParticleData", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->965276982],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"Gluon\"\>", ",", "\<\"TauNeutrino\"\>", 
    ",", "\<\"TauNeutrinoBar\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "997", "\[RightSkeleton]"}], 
    ",", "\<\"TopQuark\"\>", ",", "\<\"TopQuarkBar\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->2061473774]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2129357358],

Cell[BoxData["1002"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1836042567]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->729121065],

Cell["\<\
Use a string name to refer to long-lived and ground state particles:\
\>", "ExampleText",
 CellID->1202493590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Electron\>\"", ",", "\"\<StandardName\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341165213],

Cell[BoxData["\<\"Electron\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1174899826]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<PiPlus\>\"", ",", "\"\<StandardName\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->66881834],

Cell[BoxData["\<\"PiPlus\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->429241417]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<DeltaPlusPlus\>\"", ",", "\"\<StandardName\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->970578699],

Cell[BoxData["\<\"DeltaPlusPlus\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->862925246]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1877465249],

Cell["Find excited states of mesons and baryons:", "ExampleText",
 CellID->1581214572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<RhoZero\>\"", ",", "\"\<Excitations\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->363179979],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"RhoZero\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"RhoMeson1450\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"RhoMeson1700\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"RhoMeson1900\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"RhoMeson1965\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"RhoMeson2000\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"RhoMeson2150\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"RhoMeson2280\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"RhoMeson2265\"\>", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{577, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1227541331]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1565172262],

Cell["Find charge multiplet members:", "ExampleText",
 CellID->872987079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<RhoPlus\>\"", ",", "\"\<IsospinMultiplet\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1323015331],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"RhoMinus\"\>", ",", "\<\"RhoZero\"\>", 
   ",", "\<\"RhoPlus\"\>"}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->411753388]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Proton\>\"", ",", "\"\<IsospinMultiplet\>\""}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->964700188],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Neutron\"\>", ",", "\<\"Proton\"\>"}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1146881482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80951963],

Cell["Get a list of properties for a charge multiplet:", "ExampleText",
 CellID->796049673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", "\"\<RhoMeson1450\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->383733301],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"RhoMeson1450\"\>", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"RhoMeson1450\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"RhoMeson1450\"\>", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{397, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1971336149]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<RhoMeson1450\>\"", ",", "\"\<Charge\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1396757386],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->868950327]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2046058871],

Cell["\<\
Use a list to specify the charge state of excited state mesons and baryons:\
\>", "ExampleText",
 CellID->455805486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<RhoMeson1450\>\"", ",", "1"}], "}"}], ",", 
   "\"\<Charge\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337857866],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1559346289]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Nucleon2100P11\>\"", ",", "1"}], "}"}], ",", 
   "\"\<IsospinProjection\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1744347390],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42651235]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->403572485],

Cell["\<\
Use the list form as an alternate standard name for ground state particles:\
\>", "ExampleText",
 CellID->1089398169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<PiZero\>\"", ",", "\"\<AlternateStandardNames\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69452061],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"PiMeson\"\>", ",", "0"}], "}"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1727252194]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<PiMeson\>\"", ",", "0"}], "}"}], ",", 
   "\"\<StandardName\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->204525552],

Cell[BoxData["\<\"PiZero\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->243684412]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1128285409],

Cell["Find the antiparticle of a particle:", "ExampleText",
 CellID->202008792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<PiPlus\>\"", ",", "\"\<Antiparticle\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2137604884],

Cell[BoxData["\<\"PiMinus\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352597655]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<SigmaPlus\>\"", ",", "\"\<Antiparticle\>\""}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->215814863],

Cell[BoxData["\<\"SigmaBarMinus\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1201405512]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1562166464],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Bar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bar"]], "InlineFormula"],
 " to specify the antiparticle of a particle:"
}], "ExampleText",
 CellID->196692226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", "\"\<Sigma1660P11Bar\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->611051374],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Sigma1660P11Bar\"\>", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Sigma1660P11Bar\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Sigma1660P11Bar\"\>", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{460, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1381191090]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Sigma1660P11Bar\>\"", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", "\"\<StandardName\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->828909649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Sigma1660P11Bar\"\>", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1527909207]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5384326],

Cell["Find the PDG Monte Carlo number:", "ExampleText",
 CellID->714428600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Proton\>\"", ",", "\"\<PDGNumber\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300053908],

Cell[BoxData["2212"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2108074870]
}, Open  ]],

Cell["Use the PDG number as an alternate standard name:", "ExampleText",
 CellID->1782881421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"2212", ",", "\"\<StandardName\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1048716156],

Cell[BoxData["\<\"Proton\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1229131884]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1260376418],

Cell["Find the standard symbol for a particle:", "ExampleText",
 CellID->367763318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<RhoMeson1450\>\"", ",", "1"}], "}"}], ",", 
   "\"\<Symbol\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540149560],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw8AIxvwQDkP0fyAJj
3v//QTQziA0GDFwERIAkAxMQc0BFIRSIZAIRSPpY6agCJAoSZEGTZQTLcmIV
ZQeSrEBBfGqwi/IikQyMADsTr5Q=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{13, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54831428]
}, Open  ]],

Cell["Without the charge:", "ExampleText",
 CellID->1550971742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<RhoMeson1450\>\"", ",", "1"}], "}"}], ",", 
   "\"\<GenericSymbol\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1025560508],

Cell[BoxData["\<\"\[Rho]\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->767946133]
}, Open  ]],

Cell["Include approximate mass and charge:", "ExampleText",
 CellID->835165974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<RhoMeson1450\>\"", ",", "1"}], "}"}], ",", 
   "\"\<FullSymbol\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2045248578],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFU80OgjAMLv8QTbx6MIZ38MAb6MmHWIgJHIwGeX9sRyejTDQa45K1+0r7
faWMo2qr01m1danyQ6OuVV3e8v2lwVDgAUCBe7UGPHd40rvoOvIBnfWCjIyF
NwJnk4pUZGwFTkcVaMHHHYksH03EcQr77EP2Mj9h1t4ZBslo41DgWAcHzGTT
yAzn913Q89i83x+0IXpg/jpP5vLTTtyTDwzppEdZ33dg7oy8KzLbxuB4v/c0
ZZWn8xYvsj7TnmMZtJfjKeKiPy1hTxyhnKxQJuGea+dUcEcLy4J3B8SVTrQ=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->33077754]
}, Open  ]],

Cell["Include approximate mass but no charge:", "ExampleText",
 CellID->328728244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<RhoMeson1450\>\"", ",", "1"}], "}"}], ",", 
   "\"\<GenericFullSymbol\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1607656824],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Rho]\"\>", "\[InvisibleSpace]", "\<\"(1450)\"\>"}],
  Row[{"\[Rho]", "(1450)"}]]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1606141172]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1181639303],

Cell["Find the list of particle classes:", "ExampleText",
 CellID->2030481712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", "\"\<Classes\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->643499107],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Baryon\"\>", ",", "\<\"BBBarMeson\"\>", ",", "\<\"Boson\"\>", 
   ",", "\<\"BottomBaryon\"\>", ",", "\<\"BottomMeson\"\>", 
   ",", "\<\"CCBarMeson\"\>", ",", "\<\"CharmedBaryon\"\>", 
   ",", "\<\"CharmedMeson\"\>", ",", "\<\"Fermion\"\>", 
   ",", "\<\"GaugeBoson\"\>", ",", "\<\"Hadron\"\>", ",", "\<\"Lepton\"\>", 
   ",", "\<\"LongLived\"\>", ",", "\<\"Meson\"\>", ",", "\<\"Neutrino\"\>", 
   ",", "\<\"Pentaquark\"\>", ",", "\<\"Quark\"\>", ",", "\<\"Stable\"\>", 
   ",", "\<\"StrangeBaryon\"\>", ",", "\<\"StrangeCharmedBaryon\"\>", 
   ",", "\<\"StrangeCharmedMeson\"\>", ",", "\<\"StrangeMeson\"\>", 
   ",", "\<\"UnflavoredBaryon\"\>", ",", "\<\"UnflavoredMeson\"\>"}], 
  "}"}]], "Output",
 ImageSize->{555, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->545235014]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->444277140],

Cell["Find the list of long-lived particles:", "ExampleText",
 CellID->165251361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", "\"\<LongLived\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->683268756],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Photon\"\>", ",", "\<\"Electron\"\>", ",", "\<\"Positron\"\>", 
   ",", "\<\"Muon\"\>", ",", "\<\"MuonBar\"\>", ",", "\<\"PiZero\"\>", 
   ",", "\<\"PiMinus\"\>", ",", "\<\"PiPlus\"\>", ",", "\<\"KMinus\"\>", 
   ",", "\<\"KPlus\"\>", ",", "\<\"KLong\"\>", ",", "\<\"KShort\"\>", 
   ",", "\<\"Eta\"\>", ",", "\<\"Proton\"\>", ",", "\<\"ProtonBar\"\>", 
   ",", "\<\"Neutron\"\>", ",", "\<\"NeutronBar\"\>", ",", "\<\"EtaPrime\"\>",
    ",", "\<\"Lambda\"\>", ",", "\<\"LambdaBar\"\>", 
   ",", "\<\"SigmaBarMinus\"\>", ",", "\<\"SigmaPlus\"\>", 
   ",", "\<\"SigmaBarZero\"\>", ",", "\<\"SigmaZero\"\>", 
   ",", "\<\"SigmaBarPlus\"\>", ",", "\<\"SigmaMinus\"\>", 
   ",", "\<\"XiBarZero\"\>", ",", "\<\"XiZero\"\>", ",", "\<\"XiBarPlus\"\>", 
   ",", "\<\"XiMinus\"\>", ",", "\<\"Omega\"\>", ",", "\<\"OmegaBar\"\>", 
   ",", "\<\"TauLepton\"\>", ",", "\<\"TauLeptonBar\"\>", 
   ",", "\<\"DZero\"\>", ",", "\<\"DZeroBar\"\>", ",", "\<\"DMinus\"\>", 
   ",", "\<\"DPlus\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"DSMeson\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"DSMesonBar\"\>", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", "\<\"DStarMinus\"\>", 
   ",", "\<\"DStarPlus\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"LambdaC\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"LambdaCBar\"\>", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"XiC\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"XiCBar\"\>", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"XiC\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"XiCBar\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"OmegaC\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"OmegaCBar\"\>", ",", "0"}], "}"}], ",", "\<\"J/Psi\"\>", ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"XiCC\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"XiCCBar\"\>", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", "\<\"BMinus\"\>", ",", "\<\"BPlus\"\>",
    ",", "\<\"BZero\"\>", ",", "\<\"BZeroBar\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BSMeson\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BSMesonBar\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"LambdaB\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"LambdaBBar\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BCMeson\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BCMesonBar\"\>", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", "\<\"Upsilon\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UpsilonMeson2S\"\>", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UpsilonMeson3S\"\>", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{544, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->452158549]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1871688224],

Cell["Find masses of the quarks:", "ExampleText",
 CellID->1123519512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", "\"\<Quark\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168730113],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"UpQuark\"\>", ",", "\<\"UpQuarkBar\"\>", 
   ",", "\<\"DownQuark\"\>", ",", "\<\"DownQuarkBar\"\>", 
   ",", "\<\"StrangeQuark\"\>", ",", "\<\"StrangeQuarkBar\"\>", 
   ",", "\<\"CharmQuark\"\>", ",", "\<\"CharmQuarkBar\"\>", 
   ",", "\<\"BottomQuark\"\>", ",", "\<\"BottomQuarkBar\"\>", 
   ",", "\<\"TopQuark\"\>", ",", "\<\"TopQuarkBar\"\>"}], "}"}]], "Output",
 ImageSize->{543, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1631589957]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Quark\>\"", ",", "\"\<Mass\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1840751042],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.2`1.9999999999999998", ",", "2.2`1.9999999999999998", ",", 
   "5.`1.9999999999999998", ",", "5.`1.9999999999999998", ",", 
   "95.`1.9999999999999998", ",", "95.`1.9999999999999998", ",", 
   "1250.`3.9999999999999996", ",", "1250.`3.9999999999999996", ",", 
   "4200.`3.9999999999999996", ",", "4200.`3.9999999999999996", ",", 
   "174200.`5.999999999999999", ",", "174200.`5.999999999999999"}], 
  "}"}]], "Output",
 ImageSize->{510, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->913718756]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties and Annotations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1961895733],

Cell["Get a list of properties for a particular particle:", "ExampleText",
 CellID->1387662854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Positron\>\"", ",", "\"\<Properties\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->777180758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Antiparticle\"\>", ",", "\<\"BaryonNumber\"\>", 
   ",", "\<\"Bottomness\"\>", ",", "\<\"Charge\"\>", 
   ",", "\<\"ChargeRadius\"\>", ",", "\<\"ChargeStates\"\>", 
   ",", "\<\"Charm\"\>", ",", "\<\"CParity\"\>", ",", "\<\"DecayModes\"\>", 
   ",", "\<\"DecayType\"\>", ",", "\<\"Excitations\"\>", 
   ",", "\<\"FullDecayModes\"\>", ",", "\<\"FullSymbol\"\>", 
   ",", "\<\"GenericFullSymbol\"\>", ",", "\<\"GenericSymbol\"\>", 
   ",", "\<\"GFactor\"\>", ",", "\<\"GParity\"\>", ",", "\<\"HalfLife\"\>", 
   ",", "\<\"Hypercharge\"\>", ",", "\<\"Isospin\"\>", 
   ",", "\<\"IsospinMultiplet\"\>", ",", "\<\"IsospinProjection\"\>", 
   ",", "\<\"LeptonNumber\"\>", ",", "\<\"Lifetime\"\>", ",", "\<\"Mass\"\>", 
   ",", "\<\"Memberships\"\>", ",", "\<\"Parity\"\>", 
   ",", "\<\"PDGNumber\"\>", ",", "\<\"QuarkContent\"\>", ",", "\<\"Spin\"\>",
    ",", "\<\"Strangeness\"\>", ",", "\<\"Symbol\"\>", ",", "\<\"Topness\"\>",
    ",", "\<\"UnobservedDecayModes\"\>", ",", "\<\"Width\"\>"}], 
  "}"}]], "Output",
 ImageSize->{522, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215572395]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1921459603],

Cell["Get a list of property annotations:", "ExampleText",
 CellID->112464035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Eta\>\"", ",", "\"\<Mass\>\"", ",", "\"\<Properties\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->397426885],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Description\"\>", ",", "\<\"Interval\"\>", 
   ",", "\<\"LongDescription\"\>", ",", "\<\"Note\"\>", ",", "\<\"Units\"\>", 
   ",", "\<\"UnitsName\"\>", ",", "\<\"UnitsNotation\"\>", 
   ",", "\<\"UnitsStandardName\"\>"}], "}"}]], "Output",
 ImageSize->{360, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320330276]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->575071077],

Cell["Get a short textual description of a property:", "ExampleText",
 CellID->298397443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Eta\>\"", ",", "\"\<CParity\>\"", ",", "\"\<Description\>\""}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44910077],

Cell[BoxData["\<\"C parity\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49445703]
}, Open  ]],

Cell["Get a longer textual description:", "ExampleText",
 CellID->826150189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{
  "\"\<Eta\>\"", ",", "\"\<CParity\>\"", ",", "\"\<LongDescription\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17124444],

Cell[BoxData["\<\"charge conjugation parity C\"\>"], "Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2105242579]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->336008823],

Cell["Find the units in which a property value is given:", "ExampleText",
 CellID->725709153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Neutron\>\"", ",", "\"\<Mass\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1229972329],

Cell[BoxData["939.56536`7.999999999999999"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->871457281]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Neutron\>\"", ",", "\"\<Mass\>\"", ",", "\"\<Units\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->560816081],

Cell[BoxData["\<\"MegaelectronVolts\"\>"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->744049227]
}, Open  ]],

Cell["Get the units in proper textual form:", "ExampleText",
 CellID->98478505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Neutron\>\"", ",", "\"\<Mass\>\"", ",", "\"\<UnitsName\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1250211495],

Cell[BoxData["\<\"megaelectron volts\"\>"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->438081708]
}, Open  ]],

Cell["Get units as notation:", "ExampleText",
 CellID->433423136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{
  "\"\<Neutron\>\"", ",", "\"\<Mass\>\"", ",", "\"\<UnitsNotation\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->826445282],

Cell[BoxData["\<\"MeV\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1265324440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59265178],

Cell[TextData[{
 "Uncertainty is represented using ",
 Cell[BoxData[
  ButtonBox["Interval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interval"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->244694112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Neutron\>\"", ",", "\"\<Mass\>\"", ",", "\"\<Interval\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493396966],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
   "939.565249482421875`7.999999985893885", ",", 
    "939.565470517578125`8.000000014106114"}], "}"}], "]"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1924790486]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Property Values",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29302194],

Cell[TextData[{
 "A property value can be any valid ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression:"
}], "ExampleText",
 CellID->553589695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Muon\>\"", ",", "\"\<Mass\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->529027222],

Cell[BoxData["105.658369`9.000000000000002"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->260039794]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Photon\>\"", ",", "\"\<Lifetime\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->609521478],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->359596113]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<KShort\>\"", ",", "\"\<QuarkContent\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1563433475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"StrangeQuark\"\>", ",", "\<\"DownQuarkBar\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"DownQuark\"\>", ",", "\<\"StrangeQuarkBar\"\>"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{416, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->712888533]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->94476489],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 " to find out the number of significant digits for a property:"
}], "ExampleText",
 CellID->5758993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Proton\>\"", ",", "\"\<Mass\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->607479222],

Cell[BoxData["938.27203`7.999999999999999"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->706307518]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->388541687],

Cell[BoxData["7.999999999999999`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1768338057]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->380610788],

Cell[TextData[{
 "A property that is not applicable to a particle has the value ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<NotApplicable\>\"", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->812600388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<Electron\>\"", ",", "\"\<QuarkContent\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->978788],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"NotApplicable\"\>", "]"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1431533166]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->528642111],

Cell[TextData[{
 "A property that is unknown for a particle has the value ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<Unknown\>\"", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9731214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<UpQuark\>\"", ",", "\"\<Lifetime\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78474866],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"Unknown\"\>", "]"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1518623621]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1020263627],

Cell["\<\
Find the list of particle names matching a string expression:\
\>", "ExampleText",
 CellID->210372128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", "\"\<Delta*\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77964217],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DeltaBarMinus\"\>", ",", "\<\"DeltaBarMinusMinus\"\>", 
   ",", "\<\"DeltaBarPlus\"\>", ",", "\<\"DeltaBarZero\"\>", 
   ",", "\<\"DeltaMinus\"\>", ",", "\<\"DeltaPlus\"\>", 
   ",", "\<\"DeltaPlusPlus\"\>", ",", "\<\"DeltaZero\"\>"}], "}"}]], "Output",\

 ImageSize->{434, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->664053552]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[TextData[{
 "Masses of known ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", 
    OverscriptBox["c", "_"]}], TraditionalForm]], "InlineMath"],
 " mesons:"
}], "ExampleText",
 CellID->13490252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Sort", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ParticleData", "[", 
      RowBox[{"#", ",", "\"\<Mass\>\""}], "]"}], "&"}], "/@", 
    RowBox[{"ParticleData", "[", "\"\<CCBarMeson\>\"", "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60383476],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 2980.4}, {2., 3096.916}, {3., 3414.76}, {4., 3510.66}, {5.,
      3525.93}, {6., 3556.2}, {7., 3638.}, {8., 3686.093}, {9., 3771.1}, {10.,
      3871.2}, {11., 3929.}, {12., 3943.}, {13., 4039.}, {14., 4153.}, {15., 
     4259.}, {16., 4421.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 3000.},
  PlotRange->{{0., 16.}, {2980.4, 4421.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275535005]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141672607],

Cell["\<\
Log plot of the estimated effective masses of quarks and antiquarks:\
\>", "ExampleText",
 CellID->582992215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"Sort", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ParticleData", "[", 
      RowBox[{"#", ",", "\"\<Mass\>\""}], "]"}], "&"}], "/@", 
    RowBox[{"ParticleData", "[", "\"\<Quark\>\"", "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14991414],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWL1OwzAQdpP+QIugqKV0QarYW5hYEGJAwIRYQMxVhdQOpaj0CRiY4AEo
iAl4ASp4ABaYWJl5keCfpHYutpO0aSmNFCff2d+d73zn/BxUO/XTZrXTqFVL
++3qeb1RuyjttdpYZMYQQj18nhcRvrfwHT17loWvYlvGbRx3LRNkkjH0QAXc
GLacXPP4SroNG+dsjEyqhh6G3Y9QRdCGJNqXSBPnGEkkeY/EAFoWSZPqYzbI
tsjmsQYYedvbQnT2BQz7Y5S2DqQ5WWxcdpzYe+fkNwOyGGTpiWW59bywrqY0
EuH99lotK30qAu7AcfeMcM+gorDn5LMzHycepsXzWsQsvb11AzO6q5ESGw/9
nIRjTIDjPv1+OCx/0u2NZX7S/S8MDsuXW9VlEZTOUvz0+LW9dXtz/e7BlxrW
yfEzHrW7c+/BOtbnx0/r7OXt9duD5aww3silqz4+NjQstY86ltpHOYvNO2O5
n44J+3pHe+dIq93RIO6OgUfgOOzIoyXusYkhMmSapEnLnUX6+KS00UcBVmPT
cldTGuDDSO3w+ksDPIwdApl+XqlpgKPyI6q489WGbxrTVQ18BwzDZA9s54C1
oI+SEWptgq9VNHr5jhv9PI8sfS1vjNSuurZHa1dd88yu+HUKM2iS663ps5or
GpZ6LXQsdSTlLJ03JKLicywjHZXU5gS5nfkDHq9RxfhEX8KEbFxQawHZzvuj
k6OEG1fm6rwgVetcsHUN0psFUvhNNQk18/9zLyyP7pOIvzcGtQUx/CKW5yDM
PTlL9m9IxFcUq3c29vBXZSNjq3c4zhZZcOZMi3rHY1qyCr+Zn+wvEIr9AvVj
NQE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15913191]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35271260],

Cell["Plot mass against spin for all known unflavored mesons:", "ExampleText",
 CellID->103959454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Tooltip", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ParticleData", "[", 
         RowBox[{"#", ",", "\"\<Spin\>\""}], "]"}], ",", 
        RowBox[{"ParticleData", "[", 
         RowBox[{"#", ",", "\"\<Mass\>\""}], "]"}]}], "}"}], ",", 
      RowBox[{"ParticleData", "[", 
       RowBox[{"#", ",", "\"\<Symbol\>\""}], "]"}]}], "]"}], "&"}], "/@", 
   RowBox[{"ParticleData", "[", "\"\<UnflavoredMeson\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131712852],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJyV1j1oU1EUB/CLi0E6vKFDkAwpFOmQQVDkIdVeJGAEkSAdHBziJ5m0CIqI
Q9wqaC1aaxK1RpvCw6GDdCjSpYMfSIYOBYsKKjiIqBSnTKXpu+fccv4keN6B
cPhxzjvnvsujdODs5ZMXdhhj3nV+W5ljOWqesF9Llv2ynv11+MqZnp4/+v1G
f+YWeX0kTsPjau/biqtsjtveuz7Ojh36e1fWGxPe9Von3mi9PlLoHHf+8z1Z
X56U5yvclz7wIJlDrY2N9//Zrsf3sXNKvm8ILqpt43k1tV2kH8rzVhI6Yhvj
3mdazt87Lfvz2477j/l+lxegv6U1RepRMgfgLPgOm/Yt+rrLq+Chquz/WZV1
U5POg6tsen4poVe1TrncV5f1NJu+1wGt6XnLTrnv7ZzWFGsw75vWdH/BY6Xp
+Yu+7qICLj7R2uXT4Pdsuu82m/YHT5Wm50O26e4S+DfMG5qRHp6R/UVwiU37
z8PzjYReALdg3xfY19aaIvuMHLgcsvn7hHpea9Pdx8Gj3i7KUC/Dea5Df5NN
79eE8/Ss0/xFqJuGrKe9jTT156Ceg7qFeaNa0/uWYH75P74E+2/C/Ncw/0NC
t2Aeeg2cei7Ptxuc8XZ5D5v2HYT+U1BHV2BeTwfd65Nsur8p6O9p6o+05v8H
YF4E53kF/Usw7y14BfpX4P4+Qf0H7PsH52nDfPQGuO+FnO9N8/ZD3bvfJjP/
vWJTHIH5BV+3YBdjMM+b9gWz5LTLgwkdgnNz5IzL1+agP7KbdVKZyA==
      "]]}, {}}, {
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1971.}}]},
      SubscriptBox["\"f\"", "\"1\""]],
     Annotation[#, 
      Subscript["f", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 134.9766}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Pi]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["0", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Pi]", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 139.57018}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Pi]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"-\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Pi]", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 139.57018}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Pi]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"+\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Pi]", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 547.51}}]},
      "\"\[Eta]\""],
     Annotation[#, "\[Eta]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 775.5}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"-\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 775.5}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"+\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 775.5}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["0", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 782.65}}]},
      "\"\[Omega]\""],
     Annotation[#, "\[Omega]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 800.}}]},
      SubscriptBox["\"f\"", "\"0\""]],
     Annotation[#, 
      Subscript["f", "0"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 957.78}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Eta]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"\[Prime]\"", Power, Editable -> True, Selectable -> True]], 
       
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Eta]", "\[Prime]"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 980.}}]},
      SubscriptBox["\"f\"", "\"0\""]],
     Annotation[#, 
      Subscript["f", "0"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 984.7}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"0\"", "\"-\""], 
       Subsuperscript["a", "0", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "0", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 984.7}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"0\"", "0"], 
       Subsuperscript["a", "0", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "0", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 984.7}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"0\"", "\"+\""], 
       Subsuperscript["a", "0", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "0", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1019.46}}]},
      "\"\[Phi]\""],
     Annotation[#, "\[Phi]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1072.4}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1170.}}]},
      SubscriptBox["\"h\"", "\"1\""]],
     Annotation[#, 
      Subscript["h", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1229.5}}]},
      InterpretationBox[
       SubsuperscriptBox["\"b\"", "\"1\"", "\"-\""], 
       Subsuperscript["b", "1", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["b", "1", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1229.5}}]},
      InterpretationBox[
       SubsuperscriptBox["\"b\"", "\"1\"", "0"], 
       Subsuperscript["b", "1", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["b", "1", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1229.5}}]},
      InterpretationBox[
       SubsuperscriptBox["\"b\"", "\"1\"", "\"+\""], 
       Subsuperscript["b", "1", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["b", "1", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1230.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"1\"", "\"-\""], 
       Subsuperscript["a", "1", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "1", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1230.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"1\"", "0"], 
       Subsuperscript["a", "1", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "1", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1230.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"1\"", "\"+\""], 
       Subsuperscript["a", "1", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "1", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1275.4}}]},
      SubscriptBox["\"f\"", "\"2\""]],
     Annotation[#, 
      Subscript["f", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1281.8}}]},
      SubscriptBox["\"f\"", "\"1\""]],
     Annotation[#, 
      Subscript["f", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1294.}}]},
      "\"\[Eta]\""],
     Annotation[#, "\[Eta]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1300.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Pi]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"-\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Pi]", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1300.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Pi]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["0", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Pi]", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1300.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Pi]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"+\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Pi]", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1318.3}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"2\"", "\"-\""], 
       Subsuperscript["a", "2", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "2", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1318.3}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"2\"", "0"], 
       Subsuperscript["a", "2", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "2", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1318.3}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"2\"", "\"+\""], 
       Subsuperscript["a", "2", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "2", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1350.}}]},
      SubscriptBox["\"f\"", "\"0\""]],
     Annotation[#, 
      Subscript["f", "0"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1376.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Pi]\"", "\"1\"", "\"-\""], 
       Subsuperscript["\[Pi]", "1", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Pi]", "1", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1376.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Pi]\"", "\"1\"", "0"], 
       Subsuperscript["\[Pi]", "1", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Pi]", "1", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1376.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Pi]\"", "\"1\"", "\"+\""], 
       Subsuperscript["\[Pi]", "1", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Pi]", "1", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1386.}}]},
      SubscriptBox["\"h\"", "\"1\""]],
     Annotation[#, 
      Subscript["h", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1409.8}}]},
      "\"\[Eta]\""],
     Annotation[#, "\[Eta]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1420.}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1425.}}]},
      "\"\[Omega]\""],
     Annotation[#, "\[Omega]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1426.3}}]},
      SubscriptBox["\"f\"", "\"1\""]],
     Annotation[#, 
      Subscript["f", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1453.}}]},
      SubscriptBox["\"f\"", "\"2\""]],
     Annotation[#, 
      Subscript["f", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1459.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"-\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1459.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["0", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1459.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"+\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1474.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"0\"", "\"-\""], 
       Subsuperscript["a", "0", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "0", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1474.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"0\"", "0"], 
       Subsuperscript["a", "0", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "0", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1474.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"0\"", "\"+\""], 
       Subsuperscript["a", "0", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "0", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1476.}}]},
      "\"\[Eta]\""],
     Annotation[#, "\[Eta]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1480.}}]},
      SubscriptBox["\"f\"", "\"0\""]],
     Annotation[#, 
      Subscript["f", "0"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1507.}}]},
      SubscriptBox["\"f\"", "\"0\""]],
     Annotation[#, 
      Subscript["f", "0"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1518.}}]},
      SubscriptBox["\"f\"", "\"1\""]],
     Annotation[#, 
      Subscript["f", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1525.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"f\"", "\"2\"", "\"\[Prime]\""], 
       Subsuperscript["f", "2", "\[Prime]"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["f", "2", "\[Prime]"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1546.}}]},
      SubscriptBox["\"f\"", "\"2\""]],
     Annotation[#, 
      Subscript["f", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1594.}}]},
      SubscriptBox["\"h\"", "\"1\""]],
     Annotation[#, 
      Subscript["h", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1600.}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1617.}}]},
      SubscriptBox["\"\[Eta]\"", "\"2\""]],
     Annotation[#, 
      Subscript["\[Eta]", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1638.}}]},
      SubscriptBox["\"f\"", "\"2\""]],
     Annotation[#, 
      Subscript["f", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1647.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"1\"", "\"-\""], 
       Subsuperscript["a", "1", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "1", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1647.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"1\"", "0"], 
       Subsuperscript["a", "1", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "1", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1647.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"1\"", "\"+\""], 
       Subsuperscript["a", "1", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "1", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1653.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Pi]\"", "\"1\"", "\"-\""], 
       Subsuperscript["\[Pi]", "1", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Pi]", "1", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1653.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Pi]\"", "\"1\"", "0"], 
       Subsuperscript["\[Pi]", "1", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Pi]", "1", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1653.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Pi]\"", "\"1\"", "\"+\""], 
       Subsuperscript["\[Pi]", "1", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Pi]", "1", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 1667.}}]},
      SubscriptBox["\"\[Omega]\"", "\"3\""]],
     Annotation[#, 
      Subscript["\[Omega]", "3"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1670.}}]},
      "\"\[Omega]\""],
     Annotation[#, "\[Omega]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1672.4}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Pi]\"", "\"2\"", "\"-\""], 
       Subsuperscript["\[Pi]", "2", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Pi]", "2", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1672.4}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Pi]\"", "\"2\"", "0"], 
       Subsuperscript["\[Pi]", "2", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Pi]", "2", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1672.4}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Pi]\"", "\"2\"", "\"+\""], 
       Subsuperscript["\[Pi]", "2", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Pi]", "2", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1680.}}]},
      "\"\[Phi]\""],
     Annotation[#, "\[Phi]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 1688.8}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Rho]\"", "\"3\"", "\"-\""], 
       Subsuperscript["\[Rho]", "3", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Rho]", "3", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 1688.8}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Rho]\"", "\"3\"", "0"], 
       Subsuperscript["\[Rho]", "3", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Rho]", "3", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 1688.8}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Rho]\"", "\"3\"", "\"+\""], 
       Subsuperscript["\[Rho]", "3", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Rho]", "3", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1718.}}]},
      SubscriptBox["\"f\"", "\"0\""]],
     Annotation[#, 
      Subscript["f", "0"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1720.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"-\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1720.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["0", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1720.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"+\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1732.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"2\"", "\"-\""], 
       Subsuperscript["a", "2", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "2", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1732.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"2\"", "0"], 
       Subsuperscript["a", "2", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "2", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1732.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"2\"", "\"+\""], 
       Subsuperscript["a", "2", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "2", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1753.5}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1760.}}]},
      "\"\[Eta]\""],
     Annotation[#, "\[Eta]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1812.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Pi]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"-\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Pi]", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1812.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Pi]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["0", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Pi]", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1812.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Pi]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"+\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Pi]", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1815.}}]},
      SubscriptBox["\"f\"", "\"2\""]],
     Annotation[#, 
      Subscript["f", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1842.}}]},
      SubscriptBox["\"\[Eta]\"", "\"2\""]],
     Annotation[#, 
      Subscript["\[Eta]", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 1854.}}]},
      SubscriptBox["\"\[Phi]\"", "\"3\""]],
     Annotation[#, 
      Subscript["\[Phi]", "3"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1860.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"-\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1860.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["0", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1860.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"+\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 1870.}}]},
      SubscriptBox["\"a\"", "\"3\""]],
     Annotation[#, 
      Subscript["a", "3"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1870.}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1880.}}]},
      SubscriptBox["\"\[Pi]\"", "\"2\""]],
     Annotation[#, 
      Subscript["\[Pi]", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1915.}}]},
      SubscriptBox["\"f\"", "\"2\""]],
     Annotation[#, 
      Subscript["f", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1930.}}]},
      SubscriptBox["\"a\"", "\"1\""]],
     Annotation[#, 
      Subscript["a", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1935.}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1940.}}]},
      SubscriptBox["\"\[Rho]\"", "\"2\""]],
     Annotation[#, 
      Subscript["\[Rho]", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1944.}}]},
      SubscriptBox["\"f\"", "\"2\""]],
     Annotation[#, 
      Subscript["f", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 1945.}}]},
      SubscriptBox["\"\[Omega]\"", "\"3\""]],
     Annotation[#, 
      Subscript["\[Omega]", "3"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1960.}}]},
      SubscriptBox["\"b\"", "\"1\""]],
     Annotation[#, 
      Subscript["b", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1960.}}]},
      SubscriptBox["\"h\"", "\"1\""]],
     Annotation[#, 
      Subscript["h", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1960.}}]},
      "\"\[Omega]\""],
     Annotation[#, "\[Omega]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1965.}}]},
      "\"\[Rho]\""],
     Annotation[#, "\[Rho]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1971.}}]},
      SubscriptBox["\"f\"", "\"1\""]],
     Annotation[#, 
      Subscript["f", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1975.}}]},
      SubscriptBox["\"\[Omega]\"", "\"2\""]],
     Annotation[#, 
      Subscript["\[Omega]", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 1982.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Rho]\"", "\"3\"", "\"-\""], 
       Subsuperscript["\[Rho]", "3", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Rho]", "3", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 1982.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Rho]\"", "\"3\"", "0"], 
       Subsuperscript["\[Rho]", "3", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Rho]", "3", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 1982.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Rho]\"", "\"3\"", "\"+\""], 
       Subsuperscript["\[Rho]", "3", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Rho]", "3", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 1992.}}]},
      SubscriptBox["\"f\"", "\"0\""]],
     Annotation[#, 
      Subscript["f", "0"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 1998.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"X\"", Power, Editable -> True, Selectable -> True], 
        TagBox["0", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["X", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2000.}}]},
      "\"\[Rho]\""],
     Annotation[#, "\[Rho]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 2001.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"4\"", "\"-\""], 
       Subsuperscript["a", "4", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "4", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 2001.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"4\"", "0"], 
       Subsuperscript["a", "4", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "4", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 2001.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"4\"", "\"+\""], 
       Subsuperscript["a", "4", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "4", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2001.}}]},
      SubscriptBox["\"f\"", "\"2\""]],
     Annotation[#, 
      Subscript["f", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2003.}}]},
      SubscriptBox["\"a\"", "\"2\""]],
     Annotation[#, 
      Subscript["a", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2005.}}]},
      SubscriptBox["\"\[Pi]\"", "\"2\""]],
     Annotation[#, 
      Subscript["\[Pi]", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 2010.}}]},
      "\"\[Eta]\""],
     Annotation[#, "\[Eta]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2010.}}]},
      SubscriptBox["\"f\"", "\"2\""]],
     Annotation[#, 
      Subscript["f", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2014.}}]},
      SubscriptBox["\"\[Pi]\"", "\"1\""]],
     Annotation[#, 
      Subscript["\[Pi]", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 2025.}}]},
      SubscriptBox["\"a\"", "\"0\""]],
     Annotation[#, 
      Subscript["a", "0"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2025.}}]},
      SubscriptBox["\"b\"", "\"3\""]],
     Annotation[#, 
      Subscript["b", "3"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 2025.}}]},
      SubscriptBox["\"f\"", "\"4\""]],
     Annotation[#, 
      Subscript["f", "4"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2025.}}]},
      SubscriptBox["\"h\"", "\"3\""]],
     Annotation[#, 
      Subscript["h", "3"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2030.}}]},
      SubscriptBox["\"\[Eta]\"", "\"2\""]],
     Annotation[#, 
      Subscript["\[Eta]", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2048.}}]},
      SubscriptBox["\"f\"", "\"3\""]],
     Annotation[#, 
      Subscript["f", "3"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2060.}}]},
      SubscriptBox["\"a\"", "\"2\""]],
     Annotation[#, 
      Subscript["a", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 2060.}}]},
      SubscriptBox["\"f\"", "\"0\""]],
     Annotation[#, 
      Subscript["f", "0"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2070.}}]},
      SubscriptBox["\"a\"", "\"3\""]],
     Annotation[#, 
      Subscript["a", "3"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 2070.}}]},
      "\"\[Pi]\""],
     Annotation[#, "\[Pi]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2080.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"X\"", Power, Editable -> True, Selectable -> True], 
        TagBox["0", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["X", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2090.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Pi]\"", "\"2\"", "\"-\""], 
       Subsuperscript["\[Pi]", "2", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Pi]", "2", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2090.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Pi]\"", "\"2\"", "0"], 
       Subsuperscript["\[Pi]", "2", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Pi]", "2", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2090.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Pi]\"", "\"2\"", "\"+\""], 
       Subsuperscript["\[Pi]", "2", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Pi]", "2", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2096.}}]},
      SubscriptBox["\"a\"", "\"1\""]],
     Annotation[#, 
      Subscript["a", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 2100.}}]},
      "\"\[Eta]\""],
     Annotation[#, "\[Eta]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 2100.}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 2103.}}]},
      SubscriptBox["\"f\"", "\"0\""]],
     Annotation[#, 
      Subscript["f", "0"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2110.}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2141.}}]},
      SubscriptBox["\"f\"", "\"2\""]],
     Annotation[#, 
      Subscript["f", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2149.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"-\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2149.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["0", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2149.}}]},
      TagBox[
       SuperscriptBox[
        TagBox["\"\[Rho]\"", Power, Editable -> True, Selectable -> True], 
        TagBox["\"+\"", Power, Editable -> True, Selectable -> True]], 
       InterpretTemplate[Superscript[#, #2]& ], Editable -> False, Selectable -> 
       False]],
     Annotation[#, 
      Superscript["\[Rho]", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2150.}}]},
      "\"\[Omega]\""],
     Annotation[#, "\[Omega]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2150.}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2156.}}]},
      SubscriptBox["\"f\"", "\"2\""]],
     Annotation[#, 
      Subscript["f", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2180.}}]},
      SubscriptBox["\"a\"", "\"2\""]],
     Annotation[#, 
      Subscript["a", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 2189.}}]},
      SubscriptBox["\"f\"", "\"0\""]],
     Annotation[#, 
      Subscript["f", "0"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 2190.}}]},
      "\"\[Eta]\""],
     Annotation[#, "\[Eta]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2195.}}]},
      SubscriptBox["\"\[Omega]\"", "\"2\""]],
     Annotation[#, 
      Subscript["\[Omega]", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2205.}}]},
      "\"\[Omega]\""],
     Annotation[#, "\[Omega]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 2220.}}]},
      "\"\[Eta]\""],
     Annotation[#, "\[Eta]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2220.}}]},
      SubscriptBox["\"h\"", "\"1\""]],
     Annotation[#, 
      Subscript["h", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2240.}}]},
      SubscriptBox["\"b\"", "\"1\""]],
     Annotation[#, 
      Subscript["b", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2240.}}]},
      SubscriptBox["\"\[Pi]\"", "\"2\""]],
     Annotation[#, 
      Subscript["\[Pi]", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2240.}}]},
      SubscriptBox["\"\[Rho]\"", "\"2\""]],
     Annotation[#, 
      Subscript["\[Rho]", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 2240.}}]},
      SubscriptBox["\"\[Rho]\"", "\"4\""]],
     Annotation[#, 
      Subscript["\[Rho]", "4"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2248.}}]},
      SubscriptBox["\"\[Eta]\"", "\"2\""]],
     Annotation[#, 
      Subscript["\[Eta]", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2250.}}]},
      SubscriptBox["\"\[Omega]\"", "\"3\""]],
     Annotation[#, 
      Subscript["\[Omega]", "3"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 2250.}}]},
      SubscriptBox["\"\[Omega]\"", "\"4\""]],
     Annotation[#, 
      Subscript["\[Omega]", "4"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 2250.}}]},
      SubscriptBox["\"\[Pi]\"", "\"4\""]],
     Annotation[#, 
      Subscript["\[Pi]", "4"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2260.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Rho]\"", "\"3\"", "\"-\""], 
       Subsuperscript["\[Rho]", "3", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Rho]", "3", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2260.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Rho]\"", "\"3\"", "0"], 
       Subsuperscript["\[Rho]", "3", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Rho]", "3", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2260.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Rho]\"", "\"3\"", "\"+\""], 
       Subsuperscript["\[Rho]", "3", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Rho]", "3", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2260.}}]},
      "\"\[Rho]\""],
     Annotation[#, "\[Rho]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 2260.}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2265.}}]},
      SubscriptBox["\"a\"", "\"2\""]],
     Annotation[#, 
      Subscript["a", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2270.}}]},
      SubscriptBox["\"a\"", "\"1\""]],
     Annotation[#, 
      Subscript["a", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2275.}}]},
      SubscriptBox["\"h\"", "\"3\""]],
     Annotation[#, 
      Subscript["h", "3"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2280.}}]},
      SubscriptBox["\"\[Omega]\"", "\"3\""]],
     Annotation[#, 
      Subscript["\[Omega]", "3"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2280.}}]},
      "\"\[Rho]\""],
     Annotation[#, "\[Rho]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 2285.}}]},
      "\"\[Eta]\""],
     Annotation[#, "\[Eta]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2290.}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2297.}}]},
      SubscriptBox["\"f\"", "\"2\""]],
     Annotation[#, 
      Subscript["f", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 2300.}}]},
      SubscriptBox["\"a\"", "\"4\""]],
     Annotation[#, 
      Subscript["a", "4"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2300.}}]},
      SubscriptBox["\"\[Rho]\"", "\"3\""]],
     Annotation[#, 
      Subscript["\[Rho]", "3"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2303.}}]},
      SubscriptBox["\"f\"", "\"3\""]],
     Annotation[#, 
      Subscript["f", "3"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2310.}}]},
      SubscriptBox["\"a\"", "\"3\""]],
     Annotation[#, 
      Subscript["a", "3"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2310.}}]},
      SubscriptBox["\"f\"", "\"1\""]],
     Annotation[#, 
      Subscript["f", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 2330.}}]},
      SubscriptBox["\"\[Eta]\"", "\"4\""]],
     Annotation[#, 
      Subscript["\[Eta]", "4"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2330.}}]},
      "\"\[Omega]\""],
     Annotation[#, "\[Omega]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5., 2330.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Rho]\"", "\"5\"", "\"-\""], 
       Subsuperscript["\[Rho]", "5", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Rho]", "5", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5., 2330.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Rho]\"", "\"5\"", "0"], 
       Subsuperscript["\[Rho]", "5", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Rho]", "5", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5., 2330.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"\[Rho]\"", "\"5\"", "\"+\""], 
       Subsuperscript["\[Rho]", "5", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["\[Rho]", "5", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 2332.}}]},
      SubscriptBox["\"f\"", "\"4\""]],
     Annotation[#, 
      Subscript["f", "4"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 2337.}}]},
      SubscriptBox["\"f\"", "\"0\""]],
     Annotation[#, 
      Subscript["f", "0"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2340.}}]},
      SubscriptBox["\"a\"", "\"1\""]],
     Annotation[#, 
      Subscript["a", "1"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2340.}}]},
      SubscriptBox["\"f\"", "\"2\""]],
     Annotation[#, 
      Subscript["f", "2"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0., 2360.}}]},
      "\"\[Pi]\""],
     Annotation[#, "\[Pi]", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 2360.}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5., 2440.}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 2450.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"6\"", "\"-\""], 
       Subsuperscript["a", "6", "-"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "6", "-"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 2450.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"6\"", "0"], 
       Subsuperscript["a", "6", 0], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "6", 0], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 2450.}}]},
      InterpretationBox[
       SubsuperscriptBox["\"a\"", "\"6\"", "\"+\""], 
       Subsuperscript["a", "6", "+"], Editable -> False]],
     Annotation[#, 
      Subsuperscript["a", "6", "+"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 2460.}}]},
      SubscriptBox["\"f\"", "\"6\""]],
     Annotation[#, 
      Subscript["f", "6"], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 2710.}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7., 2747.}}]},
      "\"X\""],
     Annotation[#, "X", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 3100.}}]},
      SubscriptBox["\"f\"", "\"6\""]],
     Annotation[#, 
      Subscript["f", "6"], "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 7.}, {0., 3100.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244203790]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->539077246],

Cell["\<\
Rank plot of particle lifetimes, notably showing no evidence of time \
quantization:\
\>", "ExampleText",
 CellID->694925812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"Reverse", "[", 
   RowBox[{"Sort", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ParticleData", "[", 
       RowBox[{"#", ",", "\"\<Lifetime\>\""}], "]"}], "&"}], "/@", 
     RowBox[{"ParticleData", "[", "]"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->304845745],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWd1vVEUUn+7dj9Z+okRQlCAPxoQXAzYxmm5329rSlqYRVEKRmAbQEqRt
SsVEAuJXaIy+yEv3FgIliDyZGAi+kviiD8ZXn/1HrufMmbl39uy53bldtdi0
c3dmzu+cM+ec+c3s7dTs8tzpc7PLZ07O7hlbml2cO3Py/J7RhSUYCtqUUg/g
7+xOBZ8j+KT/HkQRPN12P7R5mMrBMwfPwDy34SxORPbHne1lffvsSxnvgWcg
WHGfSh3AtkA241ZjVCD38WNPvaceiE5sii7CD9fVCs7bQ9vHFLbhU4+9knmV
XSazqhT7mhrX/2tU+j0QDTb5fBPfW4lNd0T17WtnK2KS1UeMRZB1TVtUH/v/
y7wV4r5n5LcyMgcimYk35n3L75zHN+L9NL5PeL/xVNrNVnxNHL2q+9/f+WNw
oPbtN7+oDi21C9rvlKU9jsk/Zv3gMfNH9u/9Uz/C0JE375gY86g+06S/02t+
qLIGQ5DMFCuU79vrv09O3Pp65VGKlFwrrY/K1SZLHX37Lki9MXzdSFFY7Y/d
PU+L2JWrjwC7OH/fYPVeTt3t+PEpo29Fjx+auAX46mCYCe/2v8KmQCul3+Hq
5rV9qfsHR2+QKpXDJvj54Z9mvuSptxDRfUbaMdhFO3mte6Qamrl2T91Fp69S
bLj9K04taJPUlGuTB2/g1BOkJ0iy7jKeuAr4WGBjl3V/emrdWClCo7mfYtxw
Uy4y/EXd/2j5ocEXoIHoh+hpCBsIpzsTfQ4yJ2i7wPLYbtYcjo2s4VSv1tQn
xlrSt8RW12ECGYLK+Q9/Uk9q+DaDbsZT55h3qC2wazVZ2R5JO/YUi1KPGyVw
JLJ81YA8ofvvztwzyD7XpkE+LyKPR8R3oeNtiWVmr4h8hyEBVStY5OHpdZze
JyKndH9kaM0gu514n5j5gb59NaDGWXS63DWazPeLyFGWEfS0yJCviciBqH53
dQl1OyQiX2c11emsEYKjxmIU1tSrLH9FIQvjop1+loWi3Qum0g6LqJeZdyWh
0t4SkftYFjpY7o7RVvM6ZV5i0W13vTB50fW5Ca5/kekuCDvivQy60X+uM2A5
PZ1BH3b3sqznWe4+8NRnz6P6qHOWeyGq33VkjUzh1JynNX5CNbtH7mYVk3ei
BtbVWdKT4YRq1ieLlbLdEzl7JkKBRpahvU4azZkl9/4BfsOFBu4MaiHR0vB9
S9STB6BVsqrPHOGMahZN1ER1R0WMY4saas+nnKku0YegOkA+rKrzkbS/n9Me
Ga7U3CPL7dJyMe/A77Io96yOT1x1xrYsu4NVir3LWAaUPdkhZrtaXjXzsi3N
RaX4TKDMghLM7AURsZ3iN8iqasDa+VhEUZVxzkhytwGqOFyJoxZSFD5Jlebe
XBQl9U0mHzMOpO9Sqhzu00tOUTZjc/19ve6ujncn0pCdv+nb/+hInJ/Vyy1p
ivMGUWxJU3D8GEbv0MRN9amnnpifHY7DCOI4ipHepIJ99XIm5u9a+C2e7FTL
lgHIThbm5R5wtiI+ox1cHVyDWJONBq5lfW6nj0XkSitaYsYjLXrU400a19br
rI0Ukj7LuzZ2nHcRR7t+qFIzY1SBfNclksl30nRJFcwcvWvO0M9EKfntgf4v
RXxjDNXnqVLoS/qsCo5M36aLWoqOf+v9R7fuJ+8/vthAihikUq4ZKT8uI2xy
VhI2O2OQnsnxm5psay3q+e3Xvxbm7+MJtVk91zxxlrHsXcIylS8+61sM0vtP
MhFp9LudZZdtvLdx/8JI4obrepTeLKu2vwHcxj/7\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223600155]
}, Open  ]],

Cell["\<\
A log-log rank plot, illustrating the difference between different forms of \
decay:\
\>", "ExampleText",
 CellID->42629892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{
   RowBox[{"Reverse", "[", 
    RowBox[{"Sort", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ParticleData", "[", 
        RowBox[{"#", ",", "\"\<Lifetime\>\""}], "]"}], "&"}], "/@", 
      RowBox[{"ParticleData", "[", "]"}]}], "]"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->789903368],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWUtPFEEQHnZm2BWQdTUCvjHx4MEDxoPxsC8WNaKoMfEZiK5EA4kKIqDx
YqIxIQoxykUGEsFXNJ6MRq8mXvRgvHr2j4zVr+nemt7dnpWND7L0THXX91V3
dVV3LfQVx4cuXC6ODw8WO/ePFUeHhgevde4bGYMuu8GyrPfwe7HDgncf3ujv
e9+Hp9p2QWvDUAyeMXja/Jng/ZZD1fiPGCXajgYV5ygb9beU6afkZMCnPyE+
p8zs1Kdl7SStI1mYvuC1kExeG5Fs6/QTKqPaVmOPVxjX6beY6LuBPu+lc24M
zxGzxyJ5R8gkgBrIs54eDq0pZrimuni4Zp/95V7Gs4zgB9eX+W6yL/+1nyVC
9UoJj2Mwlwq8BoimiDvyT3m4pjPOxM9Rz4sm7Wy0qMieWm5fd/n6uzHhyztU
REy5O7TS3d1aBl/ubnaq2GF3drgSUdvN0E6DblMgqV5rQ3IKyc1VxtuRvBLJ
CSrnMl42PQcfyyENHo88qz26vVesJIQVLieNrB6jck/3PEftoqhsZq4iKk/l
/jOvOCotUPnMYzKU1KJ2U/lI3xJHbYAmnk17gCQdHnldKZjuTX0i6tu0TDuo
PDH+gTOthSZJmfJZ7+OHH2Q4rUVuR8hWaFYIJLd5WIvcipDNdKY5Om1C4LKV
ZLwrl94S1dNalk4qv3j+Xdm1WI4gu3Pz3P6gFrkF2Y8JpJtPezn6OXjgCSze
GqL40spbZBmOMsrq5kUUQTgRhhEKrXy6kNc1SKZzdoPV5TJzhG20RrZNlC2I
siyb29UIbETcWDon+BTynjVmyEIqGPWbCq6YGPuh3kUWwnwHTNnVW6v8KW8j
eQPlDSIBljPOkLbccfW0dMRQxbnorUBUMiuwLGZF3SXj2dpPl74d7F2EALcm
amJZ78u8mZn+bE1S3CrqRHVVZmtjbCePvwS2vYUFzpbyS28avNcM9fXLz5Er
78guMxTO09nf7tWv1Syf9SuLnnv6tUbnma0zjuwREUu9I3pNWeJIxvGCZcZb
Nd8iM66uHRX6doGjdx3VCs5BCKxJiQ7VqtgjrOaR91aM3n4QYXycnQ0ig0QN
5yKWNi0Lu3TIEDsbcD6kEMplNULaO3b0GYnN61pUEqEaka0bWlSzzhZAve4s
+RRy88zozQpoln18ktD0FBb4TG+VRzVCrp0/9waqo0J+vqd7AY7K27553tc7
zzAuod1JCCo+ficCrx1Eq6xuHBRfpnwi88vd1zaaN7XjQO0UbNJdQ0vxqhra
7E0E0cEqhr7exYH+12B3yjc6U6JbdCGyTp14KaPwvq85NQzYtKfNcuNKTiLY
p1BkTfvqSVNyV0t2ANooghhOzT3CbqNTYUZqxZkW2y/QYNtkPZAafK7ylnwY
siHXr+/F8ZoS62CpcHbgzSOqVz3aWoVGULJFRgZFWhSkvGer67u+mu3YF9Xx
CV3EaH2K/2LgWOH/FujRHUZabb7+fJGjeN1hrXZff0v+fgUZvbed7wz2URSf
1K4lY2g5Lf1h//LqPdxL6nJeQTb8AsSKgLs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->267901651]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132095931],

Cell["\<\
Approximate density of known particles as a function of mass:\
\>", "ExampleText",
 CellID->828536897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"BinCounts", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ParticleData", "[", 
       RowBox[{"#", ",", "\"\<Mass\>\""}], "]"}], "&"}], "/@", 
     RowBox[{"ParticleData", "[", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3000", ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17610974],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->736162536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14853860],

Cell["Number of known particles with each successive spin:", "ExampleText",
 CellID->634861799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Sort", "[", 
    RowBox[{"Tally", "[", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ParticleData", "[", 
          RowBox[{"#", ",", "\"\<Spin\>\""}], "]"}], "&"}], "/@", 
        RowBox[{"ParticleData", "[", "]"}]}], ",", "_Missing"}], "]"}], "]"}],
     "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323348109],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWTtv1EAQ9p19uQMJODsgKNOEf4EQQkBFBQn1KUJKhCAonKhDy6MEKeJZ
cPwBIuih4VHQhiINTYpAESQkpAiZ3Zvdm73x2l77vLYPrDvbu/P4ZnZmZ9f2
xV5/+er1Xn9lqTd3Ya13c3ll6dbc+dU11uU2HMfZZP/+CYfdh+xu+N8MQ3aN
nufZ2WUMPrt64srbRzmV34TDw+mK/ll2bYqrSj881HaS9PpK29Fo9Umbaj3C
Tx62HScwwqVcOr2exp4oHpU8pMWjXF0xSqod3P9jlvDoOPpKlKQduqjqtXcj
VumyQZcFdNz9iCaI17yhfUEMH2hR85giP0/o5aM+4OEAemtEF1Fy+XUGer/v
/mI/ILip3KNebi+TAyKEvxkvfTAqvbf3e2fnp4JLEfb3/zT/D9krC6/Y/bmz
T0xkG6Eu7m0RjwMZ+h0X9XYknXlQBR3aHz98Yyxv32wJfqQ3Dbz+urVr0B+1
anv7R6LV+enQHrz8cvrUxr277yJeBVPhZZoXQGdJzOgsiWO8fPb0M6M/uP++
1l7GezHK0NUbr3UZGhB59JLX9U4tvKPWY0xojALCX8+YgT2LlwdizGVbxuB4
ja3GsaXtelp9puZWlTHL0iphNWOUVrmqtCq+XlZjFa1zVVqBdapKKzBC5c6l
RSs+p81Qm6jxM9AmavwMs4NK96yIUkTWxGsvxwf7KK0QnvBdMWKtUlA7Cgp/
Km8SVNouxgqss1VagXXW3AreLAYd5yegz4i4D1HH3hx5BXt/bYQXfStje+QB
u634aiPXAaXoeWtbaxF1cjo9nyat+aOEVa9IG/Ept0itWJ3yaYVaCvst7vHt
CbTg/mkSLegRajGJ5Z1cmNMkZXsUfJkLTJDnghkWLHvykCuF3B15MjPgBbmh
zujaqq5vo/Wvra6K4++eC8OYYI2dBMdk/zINfmTHkV+kHCWL8u616z7j/mWp
qsaOrmidDFLjbwBMpegT/OONTwJ7XTsa8E164ZLcD6wnYswSjGTuRyVQVV8m
1wiTWh6SNW3GgyytMK7SzlKR8mtT67Q1m7DqhlmfPRUt+i/7GbSoldlTLEmP
U9k5Va8M11HVKvEwgQvffSRxYXVALu7DCwhY4y+/z3jK\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->289039950]
}, Open  ]],

Cell["Result for mesons:", "ExampleText",
 CellID->148024783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Sort", "[", 
    RowBox[{"Tally", "[", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ParticleData", "[", 
          RowBox[{"#", ",", "\"\<Spin\>\""}], "]"}], "&"}], "/@", 
        RowBox[{"ParticleData", "[", "\"\<Meson\>\"", "]"}]}], ",", 
       "_Missing"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->109384751],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{0., 95.}, {1., 121.}, {2., 77.}, {3., 33.}, {4., 
   21.}, {5., 8.}, {6., 6.}, {7., 1.}, {0., 0.}, {1., 0.}, {2., 0.}, {3., 
   0.}, {4., 0.}, {5., 0.}, {6., 0.}, {7., 0.}, {0., 95.}, {1., 121.}, {2., 
   77.}, {3., 33.}, {4., 21.}, {5., 8.}, {6., 6.}, {7., 
   1.}}, {{{}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{9, 1}], LineBox[{10, 2}], 
      LineBox[{11, 3}], LineBox[{12, 4}], LineBox[{13, 5}], LineBox[{14, 6}], 
      LineBox[{15, 7}], LineBox[{16, 8}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[{17, 18, 19, 20, 21, 22, 23, 24}]}, {}}}],
  
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 7.}, {0., 121.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1210926334]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->308016100],

Cell[TextData[{
 "Find all particles with lifetimes above ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "16"}]], TraditionalForm]], "InlineMath"],
 " seconds:"
}], "ExampleText",
 CellID->182051882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ParticleData", "[", 
    RowBox[{"#", ",", "\"\<FullSymbol\>\""}], "]"}], "&"}], "/@", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"ParticleData", "[", "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"ParticleData", "[", 
       RowBox[{"#", ",", "\"\<Lifetime\>\""}], "]"}], ">", 
      SuperscriptBox["10", 
       RowBox[{"-", "16"}]]}], "&"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->93459939],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWs1uEzEQ3mY3SZsm/ckflFZQDgUkfiRucEdw4gwXDlGF1B4QqPRMxVvw
Otx4EV4CkEy860mcz2PPeneDKiI1znwzHo9nvGN7tq9nl2fvP8wuz09nx68u
Zp/Ozk8/H7/8eDGH0o0kad1KkuTkZjL/rea/8j/6HM3/CvLX/K81Z91ZIH/0
r3QhnRSyP+ffGpyY9jcrtQfobiQ9AXos8JHeMbNpe/CMwW26Cl+TLdOmAh/7
NzVf1LvrwQfzrywCX0ZVa/O1U9NOgKZ2H7S2bDyz16VGcU1kkXgL6LSkHOkr
NRvH6qF/LkvUrBA/x/X9ppEnn6FUR+B3VbHy8Inw4W2zEvoefJsZn8MlPTgu
rjyfHM5P87sJLV36cLOKkEoLKW48zk6pDzdO2+MzjfcYH3O4pAdt5dZOGTmt
T5N5h4X3it/4FCEt9m3bz4zm3c7bLYXPBz2fm41yug5n28vpebX1KmgjC9qi
BLUdIU7dBuV0JCivpCVtwD4rM3Pi3Atyt2xfe7lVNFMGzoIjoBSvq9xMfbt/
keHdlb7DI4Fz0w477igCHdbWkO+L3cVKsL8r8yYB3o1rMGdeA+ZAPjpcprTp
w1xuE1DshXsC8nFvuI4rR6P23YLaA6u9Djau5Dnlnm1tHPPk8jRXJ5p4msJo
Dq6hpyYCfcDQOvmNoR158LGgH33aTCQ0X099YLXr8Dzu3THj4L0r1xXcV3A0
XF/IHwn8SYS15WbafLZZz/p44viau3PHSowq9Bk7yBD6/A/rAqX6NXTxdki1
mS2gl6e7zHhUt8eqWHVcxSUpidN9OzMz0qb2lZst+wa376f607LwiWmnRk+q
lvd2Tbcs/cS37fLhlBdHppUqWbz33oBWzO2PodcLoL8AjXsF0qesFYcmZs9B
ele5VT/OqntG7hBwqg4+ZfRz1u54xrtv8EcqlNEkX2rRgeCfmbKrxW+FmKJG
nJP++TXXpMzniKHoBkboNEfxSa7DpbsentmkajXKx9JTgZYyDj1jvqqzrxbI
2cXhsdV7rP7HVrObli9SHhdte03T3R2r2l3GSyH8BrRYPxZqwZZFhGNOJEvx
bOKbAbX7HoukSjfiWSl/4irS/uLeLfhwWo32jsVVLiUZqXLMeTFWXpN040N+
R+Bjf7uCjD5EWbQNT5/kW5xTx4MvqrQr9XFvHbgBqU5pqTbzJPgq4hLOPVHd
CjgXaw7P48K+Q6D9pkqmQdypU4Z4zrl2uwa3TpWWq3+Fq7bcns2PHJ7x+rlh
q9z3B1tejvzOwa/tX74vUIH16ZMrEh6uAxwFT5DsKcTxNX+zcyvrEwdx78su
4t7DuTOYX2JhS0m766P8aOjL2BPYOmr+IV4+t+A7WZqrXJvjUTyLTYHWHkqT
ZfWI6NS0dCfMTLuuKNsVGk3vAY21v9jIDmGe2O6ykUibmVdFH3CxCt14JT6d
f7l3Kk3gfRhvHTGU5heirRg7/9mCJ0g9R3v9x2RlqkUNTYt+KlPTxFtEv0Sf
kVo9eZOFVTGa+57VhuIXW1VFPlvfr6Evvg6cv1100CsufhWrvXwdl+/7Dvqi
/909ue4+zktUfO/ShIQYmweqWJt3TatzJtWNqc6b38vaarGui4SQ2Vxr1XeS
ZPH0r97m9ln0BCzAKCFNu3hLrVamV+7+yXK39+HUX9tq/y9Y8T3woqEq+ibr
4yugsR78A2jM2w8tWo+EeRnrhMeVrPimVjO2rzqNmZXih+dZbvfg+hfW2lXd
74KmvC6eS0qee1b02PgLJRlmhA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{538, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34958568]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->640101909],

Cell[TextData[{
 "Plot the strangeness versus ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", "3"], TraditionalForm]], "InlineMath"],
 " for scalar mesons with masses below 1 GeV:"
}], "ExampleText",
 CellID->434558014],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"ParticleData", "[", "\"\<Meson\>\"", "]"}], ",", 
       RowBox[{"\"\<KLong\>\"", "|", "\"\<KShort\>\""}]}], "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"ParticleData", "[", 
         RowBox[{"#", ",", "\"\<Mass\>\""}], "]"}], "<", "1000"}], "&&", 
       RowBox[{
        RowBox[{"ParticleData", "[", 
         RowBox[{"#", ",", "\"\<Spin\>\""}], "]"}], "\[Equal]", "0"}]}], 
      "&"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->862079956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"ParticleData", "[", 
       RowBox[{"#", ",", "\"\<Symbol\>\""}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ParticleData", "[", 
         RowBox[{"#", ",", "\"\<IsospinProjection\>\""}], "]"}], ",", 
        RowBox[{"ParticleData", "[", 
         RowBox[{"#", ",", "\"\<Strangeness\>\""}], "]"}]}], "}"}]}], "]"}], 
    "&"}], "/@", 
   RowBox[{"s", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "9"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1320268814],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVc1OwzAMzppmgzfguCuwIQY8A4WidYMhxLhVE9J2QKCxIxJCjDeaxGP1
EUKcpmmaOKXHHRapTvyTz3bi1MN0NX9+SVeLWdqNlunbfDF7716+LoWItggh
G/H9HhCx5mIlvw3nYnbph6BUGJBQsmoMJHOI6obAMMAsBkjP5HyE6hKYQy0V
i/PSuiIfKY8XWg/cGDia2xXhBGI+KVEM7dhBDRxJ3+M/KTKmZcZBgUBLy+Oa
85l4vMGZgjiSWFmWfcpBQklc+28PzrqSve9ed3Q76cSqpMCqtqlc3gNt65rW
FKwfc87CGBm4RdWauDeI371cHZpOAKeNVHxs4e8je+HlseZ7mZVf5Z1zVfwy
bsdSRW7kR5EzYGo/FlOgz5mif4g71L7D8zccG1HpLY6PxPRNHtT9EaZTUftw
X9OGMT1V6mIbanxHm1C8e6wlg/fRn1KHdy2kh1d6aF3Xru2gvn5NVe3F3Ozb
OrN/umhk+WWWviflp47Xa0cSNtx5hUQGfzuf/W1DXNxuoE7ny7h10voDRJz3
iQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31782756]
}, Open  ]],

Cell["Vector mesons:", "ExampleText",
 CellID->1176738053],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"ParticleData", "[", "\"\<Meson\>\"", "]"}], ",", 
       RowBox[{"\"\<KLong\>\"", "|", "\"\<KShort\>\""}]}], "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"ParticleData", "[", 
         RowBox[{"#", ",", "\"\<Mass\>\""}], "]"}], "<", "1100"}], "&&", 
       RowBox[{
        RowBox[{"ParticleData", "[", 
         RowBox[{"#", ",", "\"\<Spin\>\""}], "]"}], "\[Equal]", "1"}]}], 
      "&"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1259551548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"ParticleData", "[", 
       RowBox[{"#", ",", "\"\<Symbol\>\""}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ParticleData", "[", 
         RowBox[{"#", ",", "\"\<IsospinProjection\>\""}], "]"}], ",", 
        RowBox[{"ParticleData", "[", 
         RowBox[{"#", ",", "\"\<Strangeness\>\""}], "]"}]}], "}"}]}], "]"}], 
    "&"}], "/@", 
   RowBox[{"v", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "9"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1536558757],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVs1OAjEQLnRX1CfwyAlREzEBvRvx58ACixzURJMNMYGD0SAnD3qTx+FC
4pFHq512uj+dLtmbHmiy08706zez25lug2g2fn6JZpNRVL2eRm/jyei9evU6
lSZeYowt5fOzx+RYyJF6lkLInsoPKbkEME+p2JpKqTnnuqD4wGkaWFuq33fO
9aD3YqscnCbojL2PHs/iedBC0LjGAZ+fXSdbWSpHCWcKGxIf3LyVr/UkzsOc
qLwUJwxvLAbdDCiPt7Z21YB4LVte68p8jCwwC/ALhVosFl+qMQ8EX61WuKpM
eHU0DYt9mIObZ75uXhZt5P+Rt9bOPinr0LI+6k1OWULMqJ6F3BVx2WC+0prq
W2t2RFI4pqUx6lCRTyB0NiOeVE4fs894hwZ6h0SwTaK06wfOrS2zlpxRFdXT
aokjyLxLQHB6PUf0AH0FqHMrFuWH3ROWgRNXwZ3pWl8DJOyWb06LwoxFcQ/o
8U78fV5vZHFp/pzZrP1WivqPkPyfJ3OZvOg6mZoxmpvKzrkR1FN5FZ8CjrsA
9exlLZiJl8J1Qyj6J25b0fgpXQh6ZhwoXEPk3RjaJGpzu7ArXjOdELzt8Xz9
G6XOQdA1a5Owdgq9F10XOnEt/PafIskwVvoFguFtoA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->169035438]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["Get values of multiple properties for a list of particles:", \
"ExampleText",
 CellID->316513968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vals", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"ParticleData", "[", 
       RowBox[{"#", ",", "prop"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"prop", ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Symbol\>\"", ",", "\"\<Charge\>\"", ",", "\"\<Mass\>\""}], 
         "}"}]}], "}"}]}], "]"}], "&"}], "/@", 
   RowBox[{"ParticleData", "[", "\"\<Quark\>\"", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241955977],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"u\"\>", ",", 
     FractionBox["2", "3"], ",", "2.2`1.9999999999999998"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     OverscriptBox["\<\"u\"\>", "_"], ",", 
     RowBox[{"-", 
      FractionBox["2", "3"]}], ",", "2.2`1.9999999999999998"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"d\"\>", ",", 
     RowBox[{"-", 
      FractionBox["1", "3"]}], ",", "5.`1.9999999999999998"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     OverscriptBox["\<\"d\"\>", "_"], ",", 
     FractionBox["1", "3"], ",", "5.`1.9999999999999998"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"s\"\>", ",", 
     RowBox[{"-", 
      FractionBox["1", "3"]}], ",", "95.`1.9999999999999998"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     OverscriptBox["\<\"s\"\>", "_"], ",", 
     FractionBox["1", "3"], ",", "95.`1.9999999999999998"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"c\"\>", ",", 
     FractionBox["2", "3"], ",", "1250.`3.9999999999999996"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     OverscriptBox["\<\"c\"\>", "_"], ",", 
     RowBox[{"-", 
      FractionBox["2", "3"]}], ",", "1250.`3.9999999999999996"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"b\"\>", ",", 
     RowBox[{"-", 
      FractionBox["1", "3"]}], ",", "4200.`3.9999999999999996"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     OverscriptBox["\<\"b\"\>", "_"], ",", 
     FractionBox["1", "3"], ",", "4200.`3.9999999999999996"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"t\"\>", ",", 
     FractionBox["2", "3"], ",", "174200.`5.999999999999999"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     OverscriptBox["\<\"t\"\>", "_"], ",", 
     RowBox[{"-", 
      FractionBox["2", "3"]}], ",", "174200.`5.999999999999999"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{458, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1801049038]
}, Open  ]],

Cell[TextData[{
 "Display the data as a formatted table using ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->613113541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "[", 
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"Prepend", "[", 
     RowBox[{"vals", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<\>\"", ",", "\"\<charge\>\"", ",", "\"\<mass\>\""}], 
       "}"}]}], "]"}], ",", 
    RowBox[{"Frame", "\[Rule]", "All"}], ",", 
    RowBox[{"Background", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"LightBlue", ",", "White"}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", "\[Rule]", "LightYellow"}], "}"}]}], "}"}]}], 
      "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1367561668],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   TagBox[GridBox[{
      {"\<\"\"\>", "\<\"charge\"\>", "\<\"mass\"\>"},
      {"\<\"u\"\>", 
       FractionBox["2", "3"], "2.2`1.9999999999999998"},
      {
       OverscriptBox["\<\"u\"\>", "_"], 
       RowBox[{"-", 
        FractionBox["2", "3"]}], "2.2`1.9999999999999998"},
      {"\<\"d\"\>", 
       RowBox[{"-", 
        FractionBox["1", "3"]}], "5.`1.9999999999999998"},
      {
       OverscriptBox["\<\"d\"\>", "_"], 
       FractionBox["1", "3"], "5.`1.9999999999999998"},
      {"\<\"s\"\>", 
       RowBox[{"-", 
        FractionBox["1", "3"]}], "95.`1.9999999999999998"},
      {
       OverscriptBox["\<\"s\"\>", "_"], 
       FractionBox["1", "3"], "95.`1.9999999999999998"},
      {"\<\"c\"\>", 
       FractionBox["2", "3"], "1250.`3.9999999999999996"},
      {
       OverscriptBox["\<\"c\"\>", "_"], 
       RowBox[{"-", 
        FractionBox["2", "3"]}], "1250.`3.9999999999999996"},
      {"\<\"b\"\>", 
       RowBox[{"-", 
        FractionBox["1", "3"]}], "4200.`3.9999999999999996"},
      {
       OverscriptBox["\<\"b\"\>", "_"], 
       FractionBox["1", "3"], "4200.`3.9999999999999996"},
      {"\<\"t\"\>", 
       FractionBox["2", "3"], "174200.`5.999999999999999"},
      {
       OverscriptBox["\<\"t\"\>", "_"], 
       RowBox[{"-", 
        FractionBox["2", "3"]}], "174200.`5.999999999999999"}
     },
     ColumnsEqual->False,
     GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{
          RGBColor[0.87, 0.94, 1], 
          GrayLevel[1]}}, "RowsIndexed" -> {1 -> RGBColor[1, 1, 0.85]}},
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"]], "Text", "TR"],
  Text[
   Grid[{{"", "charge", "mass"}, {"u", 
      Rational[2, 3], 2.2`1.9999999999999998}, {
      OverBar["u"], 
      Rational[-2, 3], 2.2`1.9999999999999998}, {"d", 
      Rational[-1, 3], 5.`1.9999999999999998}, {
      OverBar["d"], 
      Rational[1, 3], 5.`1.9999999999999998}, {"s", 
      Rational[-1, 3], 95.`1.9999999999999998}, {
      OverBar["s"], 
      Rational[1, 3], 95.`1.9999999999999998}, {"c", 
      Rational[2, 3], 1250.`4.000000000000001}, {
      OverBar["c"], 
      Rational[-2, 3], 1250.`4.000000000000001}, {"b", 
      Rational[-1, 3], 4200.`3.9999999999999996}, {
      OverBar["b"], 
      Rational[1, 3], 4200.`3.9999999999999996}, {"t", 
      Rational[2, 3], 174200.`5.999999999999999}, {
      OverBar["t"], 
      Rational[-2, 3], 174200.`5.999999999999999}}, Frame -> All, 
    Background -> {None, {{{
         RGBColor[0.87, 0.94, 1], 
         GrayLevel[1]}}, {1 -> RGBColor[1, 1, 0.85]}}}]]]], "Output",
 ImageSize->{111, 347},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1449177201]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135815337],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DeleteCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeleteCases"]], "InlineFormula"],
 " to filter out nonmissing data:"
}], "ExampleText",
 CellID->146537355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"DeleteCases", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"ParticleData", "[", 
         RowBox[{"#", ",", "prop"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"prop", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<FullSymbol\>\"", ",", "\"\<Isospin\>\""}], "}"}]}], 
         "}"}]}], "]"}], "&"}], "/@", 
     RowBox[{"ParticleData", "[", "\"\<Hadron\>\"", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"_", ",", "_Missing"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1805150387],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWNtOwkAQXdpCEVQuojExGozxI/RNH/TJXzAhxAQejAZ50K/HTm1xOZ1l
ZktVJKFltzNn5kzPXtiH0Xzy9DyaT8ej4f1s9DqZjt+Gdy+zpCusGVN7N8b0
j03ye5H8Sr/0+Ui+xkTJNUi66tn9PLuTxa31zJiQrmHuvUg97fYFtOlyA33B
LyN1hTb6twT7jhDvSsDbFZjWhfgYb1N85IPP9VUmnfSY6lI/ZtkT7K8dfsju
ksmL/PrKPLR4mCfyX1Ol+rKd2phChWNoN5ILOWEMbDdV6M2S6FiZACuaYRAW
8Q5NkT/6YC7YznE4DdpxIscd/biKae188sL8QmhL8WKlnW4splYFXZDySck7
gnfksONR256orYxpkN0bLGrKMPr2LvQASuyRhX/lNu91VYMfwdo34suuerau
TGO1dVHdOGewXivaOAQLHEV7IsKRAiHIVLhcRfiZt9DbAF9pvd0Wje67Oa6p
rS8bHTuc8UIVgz0VA/SqpXbSHGu3DaNBtF+3azSMArn9lT3j0fOI4eyun+2N
u6NtnSd5DfrUtjp25ax4Depmwm3T4AGXZXGVxnG6smpHjBXO+Binujkk35st
s/hXCuTXF6maP6lAsoqTpvTGsD6530DwO2FzT/eMK7o7Bz8772XlqpzPEOuH
dOTLQ8erWL+/1FCbq5SHlk4Fe15Dun3GmfA+Gmueu+u/yR4HrTqsla+uJB7V
r/8YQTc+yinMPvMhVIoVMKzxpI3+b0WWPY4+Ul6+Fwuz53RH1di7/xRjZUUM
LE9Ecp2r9Cx77PePzGUQOSJ3HZHLnRrim8EdCF3KnfqWR8bTcEQaLFyn48dM
jMcvr9onPvqOlA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{376, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->63660713]
}, Open  ]],

Cell[TextData[{
 "Alternatively use ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["Except",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Except"]], "InlineFormula"],
 " to filter out missing data: "
}], "ExampleText",
 CellID->75974750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"Cases", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"ParticleData", "[", 
         RowBox[{"#", ",", "prop"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"prop", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<FullSymbol\>\"", ",", "\"\<Isospin\>\""}], "}"}]}], 
         "}"}]}], "]"}], "&"}], "/@", 
     RowBox[{"ParticleData", "[", "\"\<Hadron\>\"", "]"}]}], ",", 
    RowBox[{"Except", "[", 
     RowBox[{"{", 
      RowBox[{"_", ",", "_Missing"}], "}"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->424408147],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWNtOwkAQXdpCEVQuojExGozxI/RNH/TJXzAhxAQejAZ50K/HTm1xOZ1l
ZktVJKFltzNn5kzPXtiH0Xzy9DyaT8ej4f1s9DqZjt+Gdy+zpCusGVN7N8b0
j03ye5H8Sr/0+Ui+xkTJNUi66tn9PLuTxa31zJiQrmHuvUg97fYFtOlyA33B
LyN1hTb6twT7jhDvSsDbFZjWhfgYb1N85IPP9VUmnfSY6lI/ZtkT7K8dfsju
ksmL/PrKPLR4mCfyX1Ol+rKd2phChWNoN5ILOWEMbDdV6M2S6FiZACuaYRAW
8Q5NkT/6YC7YznE4DdpxIscd/biKae188sL8QmhL8WKlnW4splYFXZDySck7
gnfksONR256orYxpkN0bLGrKMPr2LvQASuyRhX/lNu91VYMfwdo34suuerau
TGO1dVHdOGewXivaOAQLHEV7IsKRAiHIVLhcRfiZt9DbAF9pvd0Wje67Oa6p
rS8bHTuc8UIVgz0VA/SqpXbSHGu3DaNBtF+3azSMArn9lT3j0fOI4eyun+2N
u6NtnSd5DfrUtjp25ax4Depmwm3T4AGXZXGVxnG6smpHjBXO+Binujkk35st
s/hXCuTXF6maP6lAsoqTpvTGsD6530DwO2FzT/eMK7o7Bz8772XlqpzPEOuH
dOTLQ8erWL+/1FCbq5SHlk4Fe15Dun3GmfA+Gmueu+u/yR4HrTqsla+uJB7V
r/8YQTc+yinMPvMhVIoVMKzxpI3+b0WWPY4+Ul6+Fwuz53RH1di7/xRjZUUM
LE9Ecp2r9Cx77PePzGUQOSJ3HZHLnRrim8EdCF3KnfqWR8bTcEQaLFyn48dM
jMcvr9onPvqOlA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{376, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->782139505]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5874536],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " to plot a list of property values:"
}], "ExampleText",
 CellID->535512214],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"ParticleData", "[", 
    RowBox[{"\"\<Hadron\>\"", ",", "\"\<Spin\>\""}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->914027012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"s", "//", "Sort"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1864310337],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFFslOFEG06epZUBQ0ioBAMFES0MSDetQZhlUjITExJkQkI5pAooAjLvHk
RSVGDx40YXDUwRU5GAPBmzHxggfj1bM/0r73uqaX6q7prgFx0vO6X72t3lo1
mJ0Zv3w1OzMxlm3rz2WnxyfGrrf1TeVgiVVpmrYC/zsNGnyb8EX/FdOEtx92
ADSAQYe3Dm/G3y1IRYJZ+olUNx62bpCtToQxS6cNybLGgnH8bPLuJIJEI4K4
W+LfylXR+kHlfTbw2GsJ25o0Mv/Pr0NluGRe+egh1tezS6wPXcFOZV41KlpB
frYJ3lvedKyjMlS8ol6MuadC1NhV7lunKZ818gnV6vIs+oRyT8aksJtFWqVW
ZTdmVoGQOj6n7UTAulLznOspccUAftLs1mYLxZ/En9eSCJiF4Gec8NSJPA9D
tWA1scG46NVm64sHxrZdwA8IeHOIVlHesYK5/Vgmn/JVlNxB1IG+AmQZE90i
ZPtmoI46APuA87aUqrFL2SVeAc2lCjgzVETSLaW9Ozy8hPnPCJQQO4wJ+GHB
3z3k7+lTRU4fkWpBFKX3gsSogi0nDvWlOExe+YykC5G0yP1yRYY5kYlVUAUD
Ju95HpVGoQq6A3X0E55Jz3OpJgC9AXphNmRSFIEGoRJ6QvbmXzV45v1V4UKU
q+KiUBXbyf+eTIHTj5AWUUrnVYHSOCWPSbn8tpyq2FaKycjweyQd5Y64T5Ng
r8Ssq3WTyHON8LdvfnliMDqyxOn7y0idO/uOS9UCaPdYyxHHj7U/JzG8JX/T
qfzD2W9maRIq1QDz+RsW88VIXHcJPz/8gfsSpwg8fvSd01sCo44KULKauHu7
n3u4wyrPsnn/3tcuqxpiFJ2ezPyX1d9IapXu3OV9hV0fXAcPCB8aLPIoJIVe
2CWVqgHOeo+FWeLKTS+nLe8SQq3vVs59+TkYFu0nprfPmZDhWtM9Y1AQJeJC
Zmt5HdhDxxd9y47T47qQ1brASlLp8GinRvn8PxMybQgdvyVQB97/sCZqpFR3
xpnQ7VsjVODG9n4eQczuangg39w32URHGUPIelLBmt3Pfb0FSDm3Fj3fpMSX
b/sWr5jnAqmz8wwP3He4P6IkegszaE5O1WJ2dq2rjEuT4n0uPB5lT8EXCAz7
1gIjKiGRQiGL276twCPj9tuAG0x3Om/NrYSnDjcrh6+I6pzOujC59EAdLwl3
TmddqGndbyNun9TwWBPLCNmfSgxEivpdbcEVCexkQyqF6IIrAuB3GW6/DYjE
1OQy9q8RoVIWXculn/emWslpTDsx7OkFV3Im5cOJxTw6X5M0n0Z06w6W5nuv
+gtN57AM\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->509370127]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Missing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Missing"]], "InlineFormula"],
 " data is automatically excluded in plotting functions: "
}], "ExampleText",
 CellID->94821444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cases", "[", 
   RowBox[{"s", ",", "_Missing"}], "]"}], "//", "Length"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->957919056],

Cell[BoxData["151"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->900021100]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4200064],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogPlot"]], "InlineFormula"],
 " when the data spans many orders of magnitude:"
}], "ExampleText",
 CellID->671567693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"ParticleData", "[", 
    RowBox[{"\"\<Hadron\>\"", ",", "\"\<Mass\>\""}], "]"}], "//", "Sort"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1765939808],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWN1vVEUUn/be3e62pRSogl9JQ/CBBwuaEBMDbLctrbVaJKhoEWVT0JJg
WWtNjDEalALGIprgx26pfARRQ0JCSvTNmPiiD8ZXn/1HxjNn5s7ce+65t7vb
XWy29+7cOb/z+ZuzM/e50vzM8bdK8yemS/1jc6XyzInpd/pHT83BI69NCHEX
/stbBHyX8A3/70oJ9/B1AK4+TLXDvR3unrnfp2bVhAz+wrObyDi49yU8fxBt
7VDXjNZpr2hZePxYfd0Y9aQGxHp1yYYRteF6G8Rtxuc76/az1+RedFhriZn5
/+J6PEUq0RqdX8X6WqLbIDXHarXTWFT1WlHReHXIr61GA/cod+hlJtwVamZE
w7HtkHxPSe9QQSeifS29Q8X74+Yg4j//+HdkaKmwpzIytCy+dXPGX5gQ7XDR
M8rKFZhoi8mhOjLuI+N1q8jT8cN1ylP91H4m5vWrUz9idMK7sPi7kfoqMQfC
2zd8OS5lGHB24dfBvVUQO3jgxjdu1lUSZpWW1eeEb4gjBFPp4J6JapgYv6p9
hDoaHy+hmvao3Cr85PhKNABjPLD0dRO1qyFGPfXyD6B6YvxKM7WLjvBqOvTi
TTABlRStswEpOjW78svP/7TQxvc3/oY4gLfGBhLDcIZyJcKZ1GwgL3MklrF9
yyD07DPX4mvDVhAEkmeFB6tjqLg0e/IOs76clIspRcofLqp+pT26ZOWCOH1c
BTBlMF+me6U1mfVdLCyZ+S9YlMeinK2LLMpnUa8fuWXmP2dRurtdv/ZXAuoC
i8oytnivcHPmHyvdKuxRXevI4Z94uRw6Y3Nu6sNbV7JZ0oU+Tdaq/CyidZEh
XfgcokzLNn+BCpbVId2dOJ46dFNHJjQjYGDmz0q7JmO1rXNFhsbdQb2KYasu
ojNNs6qGPfjcVk+FF8n6Jy2JsddltuKsOk6edlZjO5ha92LcXs5EWnF5dSv1
I2cztoPzGrSJZ7MQO7PE5gdaTajj+pLfl2VkaFfnzZVXBrXGHOkc70luldyP
Y7VFU8uvKtaRKr/Noh7A/FsUfHoI7iSLeyTiY1VlutqFSNieGJkZFrlNhrlf
VV2nmic2j7PI7eirRcKnk+COsrjHgsyMDl9WFrvJajvMonZG6qr9zJEIp1jk
LgaZJ6x4gUU+JaPdqJvEN4ko7l1FUn/bHdGofVlP+DSmqZmVIdbLGPcb6QFF
knnVWLuJ9RHJ9IEGbavhGOGXb3niek8BddTT4WqJdpLUnbJzd0usHmDY1kly
/KSpcHp3a8T6SzLaB/LE8i5Ju1/qfjOk+RVbx702rg6S0Sckt4pei/gU758D
LOooiaSLrNjtLGpaXXybfdsFnY+Psrg3marlyd5jK4vEfuzbNWWz4tjdz+LK
MU9zBPcQi5uXtoNUXDZdD9zCot4l2XTxub7bxyLfRz8tEj4Zkhce9yGOD+6/
XrDrPlK/jSzqNImO7tI3sKiPGdQmVhL3Vhm7M9cHkQRfzgSciPjiMt3DohZk
fB+N+0t2/5u02hYIH1X2tL1m96vzWF/7Gwfn99bYwbNEZnRk2WYemG4yE+5H
tew1035v0A7wrBqqmrbSpJM8jcn2xLCtZmfvM/Rd7aTREpCwq25OLUp91g+v
+RzL4UXHiYp+xdDJyuFJ0nNvTNKk3PuBNKmgbtUUKRpDR7I+1bd0DNB48qwc
nuC9p0e/U2ktwC/mmqWen4SeV4FTd6rUG8du6xeOqVKOxylS/sT4VXu85yuq
5aBSw4NLOhu83EUSQZrU+XO/gVR5diVVyr2lule6HB95qWqTnoq2/wCz0zY3
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24985974]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28051594],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["IsotopeData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IsotopeData"]], "InlineFormula"],
 " to find information about the nuclear isotopes:"
}], "ExampleText",
 CellID->193367025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IsotopeData", "[", "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->301495298],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"Neutron\"\>", ",", "\<\"Hydrogen1\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "3178", "\[RightSkeleton]"}], 
    ",", "\<\"Ununseptium292\"\>", ",", "\<\"Ununoctium293\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{420, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->532207049]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsotopeData", "[", "\"\<Properties\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1129350733],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AtomicMass\"\>", ",", "\<\"AtomicNumber\"\>", 
   ",", "\<\"BindingEnergy\"\>", ",", "\<\"BranchingRatios\"\>", 
   ",", "\<\"DaughterNuclides\"\>", ",", "\<\"DecayEnergies\"\>", 
   ",", "\<\"DecayModes\"\>", ",", "\<\"DecayModeSymbols\"\>", 
   ",", "\<\"DecayProducts\"\>", ",", "\<\"ExcitedStateEnergies\"\>", 
   ",", "\<\"ExcitedStateHalfLives\"\>", ",", "\<\"ExcitedStateLifetimes\"\>",
    ",", "\<\"ExcitedStateParities\"\>", ",", "\<\"ExcitedStateSpins\"\>", 
   ",", "\<\"ExcitedStateWidths\"\>", ",", "\<\"FullSymbol\"\>", 
   ",", "\<\"HalfLife\"\>", ",", "\<\"IsotopeAbundance\"\>", 
   ",", "\<\"Lifetime\"\>", ",", "\<\"MagneticMoment\"\>", 
   ",", "\<\"MassExcess\"\>", ",", "\<\"MassNumber\"\>", 
   ",", "\<\"Memberships\"\>", ",", "\<\"Name\"\>", 
   ",", "\<\"NeutronNumber\"\>", ",", "\<\"Parity\"\>", 
   ",", "\<\"QuadrupoleMoment\"\>", ",", "\<\"QuantumStatistics\"\>", 
   ",", "\<\"Spin\"\>", ",", "\<\"Stable\"\>", ",", "\<\"Symbol\"\>", 
   ",", "\<\"Width\"\>"}], "}"}]], "Output",
 ImageSize->{576, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->534482788]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsotopeData", "[", 
  RowBox[{"\"\<Uranium238\>\"", ",", "\"\<DecayModes\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->776831264],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AlphaEmission\"\>", ",", "\<\"SpontaneousFission\"\>", 
   ",", "\<\"DoubleBetaDecay\"\>"}], "}"}]], "Output",
 ImageSize->{363, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->128122515]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->274708332],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ElementData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ElementData"]], "InlineFormula"],
 " to find physical and chemical properties of an element:"
}], "ExampleText",
 CellID->1950066989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ElementData", "[", "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->429846371],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"Hydrogen\"\>", ",", "\<\"Helium\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "114", "\[RightSkeleton]"}], 
    ",", "\<\"Ununseptium\"\>", ",", "\<\"Ununoctium\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{357, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->1576495311]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ElementData", "[", "\"\<Properties\>\"", "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2027947256],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"Abbreviation\"\>", ",", "\<\"AbsoluteBoilingPoint\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "83", "\[RightSkeleton]"}], 
    ",", "\<\"YoungModulus\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{402, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->503455291]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Uranium\>\"", ",", "\"\<Density\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1641565555],

Cell[BoxData["19050.`5.000000000000002"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->487506657]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Using nonstandard particle and property names will not work: \
\>", "ExampleText",
 CellID->1329051991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<pi plus\>\"", ",", "\"\<HalfLife\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46500988],

Cell[BoxData[
 RowBox[{
  RowBox[{"ParticleData", "::", "\<\"notent\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"\\\\\\\"pi plus\\\\\\\"\\\"\\) is not a known entity, \
class, or tag for \\!\\(ParticleData\\). Use \\!\\(ParticleData\\)[] for a \
list of entities.\"\>"}]], "Message", "MSG",
 CellID->874270894],

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\<\"pi plus\"\>", ",", "\<\"HalfLife\"\>"}], "]"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->787802684]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<PiPlus\>\"", ",", " ", "\"\<half life\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->222925477],

Cell[BoxData[
 RowBox[{
  RowBox[{"ParticleData", "::", "\<\"notprop\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"\\\\\\\"half life\\\\\\\"\\\"\\) is not a known \
property for \\!\\(ParticleData\\). Use \
\\!\\(ParticleData\\)[\\\"Properties\\\"] for a list of properties.\"\>"}]], \
"Message", "MSG",
 CellID->1363026233],

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\<\"PiPlus\"\>", ",", "\<\"half life\"\>"}], "]"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1173835482]
}, Open  ]],

Cell["Use string functions to find the standardized names: ", "ExampleText",
 CellID->173046581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"ParticleData", "[", "]"}], ",", 
    RowBox[{
     RowBox[{"StringMatchQ", "[", 
      RowBox[{"#", ",", 
       RowBox[{"___", "~~", "\"\<pi\>\"", "~~", "___", "~~", "\"\<plus\>\""}],
        ",", 
       RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}], "&"}]}], "]"}], "//",
   "Quiet"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->135247669],

Cell[BoxData[
 RowBox[{"{", "\<\"PiPlus\"\>", "}"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1868164632]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"ParticleData", "[", 
    RowBox[{"\"\<PiPlus\>\"", ",", "\"\<Properties\>\""}], "]"}], ",", 
   RowBox[{
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"#", ",", 
      RowBox[{"___", "~~", "\"\<half\>\"", "~~", "___"}], ",", 
      RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->57009403],

Cell[BoxData[
 RowBox[{"{", "\<\"HalfLife\"\>", "}"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2032050884]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParticleData", "[", 
  RowBox[{"\"\<PiPlus\>\"", ",", "\"\<HalfLife\>\""}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1260968962],

Cell[BoxData["1.804500000000000000001`5.000000000000002*^-8"], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1246769147]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90344104],

Cell[TextData[{
 "Arithmetical operations cannot be carried out on ",
 Cell[BoxData[
  ButtonBox["Missing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Missing"]], "InlineFormula"],
 " entries:"
}], "ExampleText",
 CellID->46301994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"10", 
  RowBox[{"ParticleData", "[", 
   RowBox[{"\"\<GaugeBoson\>\"", ",", "\"\<Lifetime\>\""}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1739347100],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"10", " ", 
    RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}]}], ",", 
   "\[Infinity]", ",", "3.07600000000001`3.9999999999999996*^-24", ",", 
   "3.07600000000001`3.9999999999999996*^-24", ",", 
   "2.6379`5.000000000000002*^-24"}], "}"}]], "Output",
 ImageSize->{469, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1451109850]
}, Open  ]],

Cell[TextData[{
 "Remove the ",
 Cell[BoxData[
  ButtonBox["Missing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Missing"]], "InlineFormula"],
 " entries before performing operations: "
}], "ExampleText",
 CellID->85509328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteCases", "[", 
  RowBox[{
   RowBox[{"ParticleData", "[", 
    RowBox[{"\"\<GaugeBoson\>\"", ",", "\"\<Lifetime\>\""}], "]"}], ",", 
   "_Missing"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->548645387],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\[Infinity]", ",", "3.076`3.9999999999999996*^-25", ",", 
   "3.076`3.9999999999999996*^-25", ",", "2.6379`5.000000000000002*^-25"}], 
  "}"}]], "Output",
 ImageSize->{294, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1978953618]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"10", " ", "%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->60605648],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\[Infinity]", ",", "3.07600000000001`3.9999999999999996*^-24", ",", 
   "3.07600000000001`3.9999999999999996*^-24", ",", 
   "2.6379`5.000000000000002*^-24"}], "}"}]], "Output",
 ImageSize->{294, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->46732990]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IsotopeData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IsotopeData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElementData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ElementData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"],
  FontSlant->"Italic"],
 ButtonBox[" Internet Connectivity",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[ButtonBox["ParticleData Source Information",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
ParticleDataSourceInformation.html"], None}]], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Integrated Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataCollections"]], "MoreAbout",
 CellID->335847743]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParticleData - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 11.3665082}", "context" -> "System`", 
    "keywords" -> {
     "antiparticle", "bar meson", "baryon", "baryon number", "boson", 
      "bottom baryon", "bottom meson", "bottomness", "charge", 
      "charge multiplet members", "charge radius", "charge states", "charm", 
      "charmed baryon", "charmed meson", "chi meson", 
      "decay mode upper bounds", "decay modes", "decay type", "decay types", 
      "delta meson", "elementary particles", "eta meson", "excitations", 
      "fermion", "gauge boson", "hadron", "half-life", "HEP", 
      "high-energy physics", "hyper charge", "hypercharge", "isospin", 
      "isospin projection", "lambda", "lepton", "lepton number", "lifetime", 
      "mass", "memberships", "meson", "nucleon", "number", "omega", 
      "omega meson", "parity", "particle physics", "PDG", "pentaquark", 
      "phi meson", "pi meson", "psi meson", "quark", "quark content", 
      "resonance particles", "rho meson", "Rosenfeld tables", "sigma", "spin",
       "stable particle", "strange baryon", "strange meson", "strangeness", 
      "subatomic physics", "topness", "unflavored baryon", "unflavored meson",
       "unstable particle", "upsilon meson"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ParticleData[name, \" property\"] gives the specified property for a \
subatomic particle or family of particles with the specified name. \
ParticleData[{name, q}, \" property\"] gives the specified property for a \
version of the particle with charge q.", "synonyms" -> {"particle data"}, 
    "title" -> "ParticleData", "type" -> "Symbol", "uri" -> 
    "ref/ParticleData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[21875, 652, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->25556635]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 164421, 5241}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1890, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2513, 75, 1577, 37, 70, "ObjectNameGrid"],
Cell[4093, 114, 1217, 36, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5347, 155, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5825, 172, 483, 15, 70, "Notes",
 CellID->808132238],
Cell[6311, 189, 379, 12, 70, "Notes",
 CellID->12921596],
Cell[6693, 203, 169, 5, 70, "Notes",
 CellID->305076519],
Cell[6865, 210, 462, 15, 70, "Notes",
 CellID->55906669],
Cell[7330, 227, 184, 5, 70, "Notes",
 CellID->930067760],
Cell[7517, 234, 559, 19, 70, "Notes",
 CellID->516899279],
Cell[8079, 255, 62, 1, 70, "Notes",
 CellID->175856496],
Cell[8144, 258, 1049, 23, 70, "2ColumnTableMod",
 CellID->904365843],
Cell[9196, 283, 60, 1, 70, "Notes",
 CellID->57311337],
Cell[9259, 286, 2806, 74, 70, "2ColumnTableMod",
 CellID->567883567],
Cell[12068, 362, 80, 1, 70, "Notes",
 CellID->47209957],
Cell[12151, 365, 462, 11, 70, "2ColumnTableMod",
 CellID->140518205],
Cell[12616, 378, 73, 1, 70, "Notes",
 CellID->444174937],
Cell[12692, 381, 837, 16, 70, "2ColumnTableMod",
 CellID->18942721],
Cell[13532, 399, 70, 1, 70, "Notes",
 CellID->299455928],
Cell[13605, 402, 967, 20, 70, "2ColumnTableMod",
 CellID->218008144],
Cell[14575, 424, 725, 27, 70, "Notes",
 CellID->327232522],
Cell[15303, 453, 275, 7, 70, "Notes",
 CellID->308869449],
Cell[15581, 462, 85, 3, 70, "Notes",
 CellID->71633798],
Cell[15669, 467, 1155, 24, 70, "2ColumnTableMod",
 CellID->119957635],
Cell[16827, 493, 971, 32, 70, "Notes",
 CellID->482514198],
Cell[17801, 527, 261, 9, 70, "Notes",
 CellID->434747015],
Cell[18065, 538, 812, 28, 70, "Notes",
 CellID->329416671],
Cell[18880, 568, 810, 23, 70, "Notes",
 CellID->443994758],
Cell[19693, 593, 464, 14, 70, "Notes",
 CellID->276644756],
Cell[20160, 609, 1678, 38, 70, "2ColumnTableMod",
 CellID->524183967]
}, Closed]],
Cell[CellGroupData[{
Cell[21875, 652, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25556635],
Cell[CellGroupData[{
Cell[22259, 666, 148, 5, 70, "ExampleSection",
 CellID->100043458],
Cell[22410, 673, 76, 1, 70, "ExampleText",
 CellID->259621278],
Cell[CellGroupData[{
Cell[22511, 678, 153, 4, 28, "Input",
 CellID->612530324],
Cell[22667, 684, 185, 5, 36, "Output",
 CellID->518629544]
}, Open  ]],
Cell[22867, 692, 79, 1, 70, "ExampleText",
 CellID->648775118],
Cell[CellGroupData[{
Cell[22971, 697, 156, 4, 28, "Input",
 CellID->77985915],
Cell[23130, 703, 187, 5, 36, "Output",
 CellID->2118106482]
}, Open  ]],
Cell[23332, 711, 125, 3, 70, "ExampleDelimiter",
 CellID->267700537],
Cell[23460, 716, 88, 1, 70, "ExampleText",
 CellID->374902405],
Cell[CellGroupData[{
Cell[23573, 721, 164, 4, 70, "Input",
 CellID->1231026364],
Cell[23740, 727, 287, 9, 36, "Output",
 CellID->179226655]
}, Open  ]],
Cell[24042, 739, 125, 3, 70, "ExampleDelimiter",
 CellID->536340148],
Cell[24170, 744, 61, 1, 70, "ExampleText",
 CellID->437409149],
Cell[CellGroupData[{
Cell[24256, 749, 121, 3, 70, "Input",
 CellID->175754708],
Cell[24380, 754, 544, 12, 54, "Output",
 CellID->1490317491]
}, Open  ]],
Cell[CellGroupData[{
Cell[24961, 771, 196, 7, 28, "Input",
 CellID->205313043],
Cell[25160, 780, 773, 17, 38, "Output",
 Evaluatable->False,
 CellID->462064175]
}, Open  ]],
Cell[25948, 800, 125, 3, 70, "ExampleDelimiter",
 CellID->121316636],
Cell[26076, 805, 60, 1, 70, "ExampleText",
 CellID->50641208],
Cell[CellGroupData[{
Cell[26161, 810, 152, 5, 70, "Input",
 CellID->197540885],
Cell[26316, 817, 509, 15, 36, "Output",
 CellID->853008557]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26874, 838, 222, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[27121, 849, 239, 7, 70, "ExampleSubsection",
 CellID->223414956],
Cell[27363, 858, 112, 3, 70, "ExampleText",
 CellID->388487866],
Cell[CellGroupData[{
Cell[27500, 865, 135, 4, 70, "Input",
 CellID->965276982],
Cell[27638, 871, 423, 12, 36, "Output",
 CellID->2061473774]
}, Open  ]],
Cell[CellGroupData[{
Cell[28098, 888, 103, 3, 70, "Input",
 CellID->2129357358],
Cell[28204, 893, 162, 5, 36, "Output",
 CellID->1836042567]
}, Open  ]],
Cell[28381, 901, 125, 3, 70, "ExampleDelimiter",
 CellID->729121065],
Cell[28509, 906, 120, 3, 70, "ExampleText",
 CellID->1202493590],
Cell[CellGroupData[{
Cell[28654, 913, 165, 4, 70, "Input",
 CellID->341165213],
Cell[28822, 919, 174, 5, 36, "Output",
 CellID->1174899826]
}, Open  ]],
Cell[CellGroupData[{
Cell[29033, 929, 162, 4, 70, "Input",
 CellID->66881834],
Cell[29198, 935, 171, 5, 36, "Output",
 CellID->429241417]
}, Open  ]],
Cell[CellGroupData[{
Cell[29406, 945, 173, 5, 70, "Input",
 CellID->970578699],
Cell[29582, 952, 178, 5, 36, "Output",
 CellID->862925246]
}, Open  ]],
Cell[29775, 960, 126, 3, 70, "ExampleDelimiter",
 CellID->1877465249],
Cell[29904, 965, 86, 1, 70, "ExampleText",
 CellID->1581214572],
Cell[CellGroupData[{
Cell[30015, 970, 163, 4, 70, "Input",
 CellID->363179979],
Cell[30181, 976, 833, 23, 54, "Output",
 CellID->1227541331]
}, Open  ]],
Cell[31029, 1002, 126, 3, 70, "ExampleDelimiter",
 CellID->1565172262],
Cell[31158, 1007, 73, 1, 70, "ExampleText",
 CellID->872987079],
Cell[CellGroupData[{
Cell[31256, 1012, 172, 5, 70, "Input",
 CellID->1323015331],
Cell[31431, 1019, 261, 8, 36, "Output",
 CellID->411753388]
}, Open  ]],
Cell[CellGroupData[{
Cell[31729, 1032, 169, 5, 70, "Input",
 CellID->964700188],
Cell[31901, 1039, 232, 7, 36, "Output",
 CellID->1146881482]
}, Open  ]],
Cell[32148, 1049, 124, 3, 70, "ExampleDelimiter",
 CellID->80951963],
Cell[32275, 1054, 91, 1, 70, "ExampleText",
 CellID->796049673],
Cell[CellGroupData[{
Cell[32391, 1059, 127, 3, 70, "Input",
 CellID->383733301],
Cell[32521, 1064, 440, 14, 36, "Output",
 CellID->1971336149]
}, Open  ]],
Cell[CellGroupData[{
Cell[32998, 1083, 164, 4, 70, "Input",
 CellID->1396757386],
Cell[33165, 1089, 232, 8, 36, "Output",
 CellID->868950327]
}, Open  ]],
Cell[33412, 1100, 126, 3, 70, "ExampleDelimiter",
 CellID->2046058871],
Cell[33541, 1105, 126, 3, 70, "ExampleText",
 CellID->455805486],
Cell[CellGroupData[{
Cell[33692, 1112, 216, 7, 70, "Input",
 CellID->337857866],
Cell[33911, 1121, 159, 5, 36, "Output",
 CellID->1559346289]
}, Open  ]],
Cell[CellGroupData[{
Cell[34107, 1131, 230, 7, 70, "Input",
 CellID->1744347390],
Cell[34340, 1140, 177, 6, 51, "Output",
 CellID->42651235]
}, Open  ]],
Cell[34532, 1149, 125, 3, 70, "ExampleDelimiter",
 CellID->403572485],
Cell[34660, 1154, 127, 3, 70, "ExampleText",
 CellID->1089398169],
Cell[CellGroupData[{
Cell[34812, 1161, 175, 5, 70, "Input",
 CellID->69452061],
Cell[34990, 1168, 243, 8, 36, "Output",
 CellID->1727252194]
}, Open  ]],
Cell[CellGroupData[{
Cell[35270, 1181, 217, 7, 70, "Input",
 CellID->204525552],
Cell[35490, 1190, 171, 5, 36, "Output",
 CellID->243684412]
}, Open  ]],
Cell[35676, 1198, 126, 3, 70, "ExampleDelimiter",
 CellID->1128285409],
Cell[35805, 1203, 79, 1, 70, "ExampleText",
 CellID->202008792],
Cell[CellGroupData[{
Cell[35909, 1208, 164, 4, 70, "Input",
 CellID->2137604884],
Cell[36076, 1214, 172, 5, 36, "Output",
 CellID->352597655]
}, Open  ]],
Cell[CellGroupData[{
Cell[36285, 1224, 168, 5, 70, "Input",
 CellID->215814863],
Cell[36456, 1231, 179, 5, 36, "Output",
 CellID->1201405512]
}, Open  ]],
Cell[36650, 1239, 126, 3, 70, "ExampleDelimiter",
 CellID->1562166464],
Cell[36779, 1244, 219, 8, 70, "ExampleText",
 CellID->196692226],
Cell[CellGroupData[{
Cell[37023, 1256, 130, 3, 70, "Input",
 CellID->611051374],
Cell[37156, 1261, 449, 14, 36, "Output",
 CellID->1381191090]
}, Open  ]],
Cell[CellGroupData[{
Cell[37642, 1280, 245, 8, 70, "Input",
 CellID->828909649],
Cell[37890, 1290, 246, 8, 36, "Output",
 CellID->1527909207]
}, Open  ]],
Cell[38151, 1301, 123, 3, 70, "ExampleDelimiter",
 CellID->5384326],
Cell[38277, 1306, 75, 1, 70, "ExampleText",
 CellID->714428600],
Cell[CellGroupData[{
Cell[38377, 1311, 160, 4, 70, "Input",
 CellID->300053908],
Cell[38540, 1317, 162, 5, 36, "Output",
 CellID->2108074870]
}, Open  ]],
Cell[38717, 1325, 93, 1, 70, "ExampleText",
 CellID->1782881421],
Cell[CellGroupData[{
Cell[38835, 1330, 154, 4, 70, "Input",
 CellID->1048716156],
Cell[38992, 1336, 172, 5, 36, "Output",
 CellID->1229131884]
}, Open  ]],
Cell[39179, 1344, 126, 3, 70, "ExampleDelimiter",
 CellID->1260376418],
Cell[39308, 1349, 83, 1, 70, "ExampleText",
 CellID->367763318],
Cell[CellGroupData[{
Cell[39416, 1354, 216, 7, 70, "Input",
 CellID->540149560],
Cell[39635, 1363, 360, 10, 70, "Output",
 Evaluatable->False,
 CellID->54831428]
}, Open  ]],
Cell[40010, 1376, 63, 1, 70, "ExampleText",
 CellID->1550971742],
Cell[CellGroupData[{
Cell[40098, 1381, 224, 7, 70, "Input",
 CellID->1025560508],
Cell[40325, 1390, 171, 5, 36, "Output",
 CellID->767946133]
}, Open  ]],
Cell[40511, 1398, 79, 1, 70, "ExampleText",
 CellID->835165974],
Cell[CellGroupData[{
Cell[40615, 1403, 221, 7, 70, "Input",
 CellID->2045248578],
Cell[40839, 1412, 515, 13, 70, "Output",
 Evaluatable->False,
 CellID->33077754]
}, Open  ]],
Cell[41369, 1428, 82, 1, 70, "ExampleText",
 CellID->328728244],
Cell[CellGroupData[{
Cell[41476, 1433, 228, 7, 70, "Input",
 CellID->1607656824],
Cell[41707, 1442, 274, 8, 36, "Output",
 CellID->1606141172]
}, Open  ]],
Cell[41996, 1453, 126, 3, 70, "ExampleDelimiter",
 CellID->1181639303],
Cell[42125, 1458, 78, 1, 70, "ExampleText",
 CellID->2030481712],
Cell[CellGroupData[{
Cell[42228, 1463, 122, 3, 70, "Input",
 CellID->643499107],
Cell[42353, 1468, 877, 17, 88, "Output",
 CellID->545235014]
}, Open  ]],
Cell[43245, 1488, 125, 3, 70, "ExampleDelimiter",
 CellID->444277140],
Cell[43373, 1493, 81, 1, 70, "ExampleText",
 CellID->165251361],
Cell[CellGroupData[{
Cell[43479, 1498, 124, 3, 70, "Input",
 CellID->683268756],
Cell[43606, 1503, 2958, 69, 190, "Output",
 CellID->452158549]
}, Open  ]],
Cell[46579, 1575, 126, 3, 70, "ExampleDelimiter",
 CellID->1871688224],
Cell[46708, 1580, 70, 1, 70, "ExampleText",
 CellID->1123519512],
Cell[CellGroupData[{
Cell[46803, 1585, 120, 3, 70, "Input",
 CellID->168730113],
Cell[46926, 1590, 541, 12, 54, "Output",
 CellID->1631589957]
}, Open  ]],
Cell[CellGroupData[{
Cell[47504, 1607, 155, 4, 70, "Input",
 CellID->1840751042],
Cell[47662, 1613, 594, 14, 36, "Output",
 CellID->913718756]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48305, 1633, 248, 7, 70, "ExampleSubsection",
 CellID->1961895733],
Cell[48556, 1642, 95, 1, 70, "ExampleText",
 CellID->1387662854],
Cell[CellGroupData[{
Cell[48676, 1647, 163, 4, 70, "Input",
 CellID->777180758],
Cell[48842, 1653, 1187, 22, 122, "Output",
 CellID->215572395]
}, Open  ]],
Cell[50044, 1678, 126, 3, 70, "ExampleDelimiter",
 CellID->1921459603],
Cell[50173, 1683, 78, 1, 70, "ExampleText",
 CellID->112464035],
Cell[CellGroupData[{
Cell[50276, 1688, 182, 5, 70, "Input",
 CellID->397426885],
Cell[50461, 1695, 414, 10, 54, "Output",
 CellID->320330276]
}, Open  ]],
Cell[50890, 1708, 125, 3, 70, "ExampleDelimiter",
 CellID->575071077],
Cell[51018, 1713, 89, 1, 70, "ExampleText",
 CellID->298397443],
Cell[CellGroupData[{
Cell[51132, 1718, 185, 5, 70, "Input",
 CellID->44910077],
Cell[51320, 1725, 172, 5, 36, "Output",
 CellID->49445703]
}, Open  ]],
Cell[51507, 1733, 76, 1, 70, "ExampleText",
 CellID->826150189],
Cell[CellGroupData[{
Cell[51608, 1738, 192, 6, 70, "Input",
 CellID->17124444],
Cell[51803, 1746, 194, 5, 36, "Output",
 CellID->2105242579]
}, Open  ]],
Cell[52012, 1754, 125, 3, 70, "ExampleDelimiter",
 CellID->336008823],
Cell[52140, 1759, 93, 1, 70, "ExampleText",
 CellID->725709153],
Cell[CellGroupData[{
Cell[52258, 1764, 157, 4, 70, "Input",
 CellID->1229972329],
Cell[52418, 1770, 184, 5, 36, "Output",
 CellID->871457281]
}, Open  ]],
Cell[CellGroupData[{
Cell[52639, 1780, 181, 5, 70, "Input",
 CellID->560816081],
Cell[52823, 1787, 183, 5, 36, "Output",
 CellID->744049227]
}, Open  ]],
Cell[53021, 1795, 79, 1, 70, "ExampleText",
 CellID->98478505],
Cell[CellGroupData[{
Cell[53125, 1800, 186, 5, 70, "Input",
 CellID->1250211495],
Cell[53314, 1807, 184, 5, 36, "Output",
 CellID->438081708]
}, Open  ]],
Cell[53513, 1815, 65, 1, 70, "ExampleText",
 CellID->433423136],
Cell[CellGroupData[{
Cell[53603, 1820, 192, 6, 70, "Input",
 CellID->826445282],
Cell[53798, 1828, 169, 5, 36, "Output",
 CellID->1265324440]
}, Open  ]],
Cell[53982, 1836, 124, 3, 70, "ExampleDelimiter",
 CellID->59265178],
Cell[54109, 1841, 216, 8, 70, "ExampleText",
 CellID->244694112],
Cell[CellGroupData[{
Cell[54350, 1853, 184, 5, 70, "Input",
 CellID->493396966],
Cell[54537, 1860, 322, 10, 36, "Output",
 CellID->1924790486]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54908, 1876, 235, 7, 70, "ExampleSubsection",
 CellID->29302194],
Cell[55146, 1885, 158, 6, 70, "ExampleText",
 CellID->553589695],
Cell[CellGroupData[{
Cell[55329, 1895, 153, 4, 70, "Input",
 CellID->529027222],
Cell[55485, 1901, 185, 5, 36, "Output",
 CellID->260039794]
}, Open  ]],
Cell[CellGroupData[{
Cell[55707, 1911, 159, 4, 70, "Input",
 CellID->609521478],
Cell[55869, 1917, 168, 5, 36, "Output",
 CellID->359596113]
}, Open  ]],
Cell[CellGroupData[{
Cell[56074, 1927, 164, 4, 70, "Input",
 CellID->1563433475],
Cell[56241, 1933, 385, 13, 36, "Output",
 CellID->712888533]
}, Open  ]],
Cell[56641, 1949, 124, 3, 70, "ExampleDelimiter",
 CellID->94476489],
Cell[56768, 1954, 247, 8, 70, "ExampleText",
 CellID->5758993],
Cell[CellGroupData[{
Cell[57040, 1966, 155, 4, 70, "Input",
 CellID->607479222],
Cell[57198, 1972, 184, 5, 36, "Output",
 CellID->706307518]
}, Open  ]],
Cell[CellGroupData[{
Cell[57419, 1982, 105, 3, 70, "Input",
 CellID->388541687],
Cell[57527, 1987, 176, 5, 36, "Output",
 CellID->1768338057]
}, Open  ]],
Cell[57718, 1995, 125, 3, 70, "ExampleDelimiter",
 CellID->380610788],
Cell[57846, 2000, 297, 10, 70, "ExampleText",
 CellID->812600388],
Cell[CellGroupData[{
Cell[58168, 2014, 162, 4, 70, "Input",
 CellID->978788],
Cell[58333, 2020, 213, 6, 36, "Output",
 CellID->1431533166]
}, Open  ]],
Cell[58561, 2029, 125, 3, 70, "ExampleDelimiter",
 CellID->528642111],
Cell[58689, 2034, 283, 10, 70, "ExampleText",
 CellID->9731214],
Cell[CellGroupData[{
Cell[58997, 2048, 159, 4, 70, "Input",
 CellID->78474866],
Cell[59159, 2054, 207, 6, 36, "Output",
 CellID->1518623621]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[59427, 2067, 244, 7, 70, "ExampleSection",
 CellID->1020263627],
Cell[59674, 2076, 112, 3, 70, "ExampleText",
 CellID->210372128],
Cell[CellGroupData[{
Cell[59811, 2083, 120, 3, 70, "Input",
 CellID->77964217],
Cell[59934, 2088, 430, 11, 54, "Output",
 CellID->664053552]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60413, 2105, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[60643, 2114, 194, 8, 70, "ExampleText",
 CellID->13490252],
Cell[CellGroupData[{
Cell[60862, 2126, 320, 10, 70, "Input",
 CellID->60383476],
Cell[61185, 2138, 704, 19, 135, "Output",
 CellID->275535005]
}, Open  ]],
Cell[61904, 2160, 125, 3, 70, "ExampleDelimiter",
 CellID->141672607],
Cell[62032, 2165, 119, 3, 70, "ExampleText",
 CellID->582992215],
Cell[CellGroupData[{
Cell[62176, 2172, 318, 10, 70, "Input",
 CellID->14991414],
Cell[62497, 2184, 1070, 22, 70, "Output",
 Evaluatable->False,
 CellID->15913191]
}, Open  ]],
Cell[63582, 2209, 124, 3, 70, "ExampleDelimiter",
 CellID->35271260],
Cell[63709, 2214, 98, 1, 70, "ExampleText",
 CellID->103959454],
Cell[CellGroupData[{
Cell[63832, 2219, 585, 17, 70, "Input",
 CellID->131712852],
Cell[64420, 2238, 47944, 1429, 70, "Output",
 CellID->244203790]
}, Open  ]],
Cell[112379, 3670, 125, 3, 70, "ExampleDelimiter",
 CellID->539077246],
Cell[112507, 3675, 135, 4, 70, "ExampleText",
 CellID->694925812],
Cell[CellGroupData[{
Cell[112667, 3683, 343, 10, 70, "Input",
 CellID->304845745],
Cell[113013, 3695, 2022, 37, 70, "Output",
 Evaluatable->False,
 CellID->223600155]
}, Open  ]],
Cell[115050, 3735, 134, 4, 70, "ExampleText",
 CellID->42629892],
Cell[CellGroupData[{
Cell[115209, 3743, 416, 12, 70, "Input",
 CellID->789903368],
Cell[115628, 3757, 1774, 33, 70, "Output",
 Evaluatable->False,
 CellID->267901651]
}, Open  ]],
Cell[117417, 3793, 125, 3, 70, "ExampleDelimiter",
 CellID->132095931],
Cell[117545, 3798, 112, 3, 70, "ExampleText",
 CellID->828536897],
Cell[CellGroupData[{
Cell[117682, 3805, 397, 12, 70, "Input",
 CellID->17610974],
Cell[118082, 3819, 2709, 48, 70, "Output",
 Evaluatable->False,
 CellID->736162536]
}, Open  ]],
Cell[120806, 3870, 124, 3, 70, "ExampleDelimiter",
 CellID->14853860],
Cell[120933, 3875, 95, 1, 70, "ExampleText",
 CellID->634861799],
Cell[CellGroupData[{
Cell[121053, 3880, 493, 15, 70, "Input",
 CellID->323348109],
Cell[121549, 3897, 1355, 26, 70, "Output",
 Evaluatable->False,
 CellID->289039950]
}, Open  ]],
Cell[122919, 3926, 61, 1, 70, "ExampleText",
 CellID->148024783],
Cell[CellGroupData[{
Cell[123005, 3931, 513, 15, 70, "Input",
 CellID->109384751],
Cell[123521, 3948, 991, 24, 140, "Output",
 CellID->1210926334]
}, Open  ]],
Cell[124527, 3975, 125, 3, 70, "ExampleDelimiter",
 CellID->308016100],
Cell[124655, 3980, 223, 8, 70, "ExampleText",
 CellID->182051882],
Cell[CellGroupData[{
Cell[124903, 3992, 470, 15, 70, "Input",
 CellID->93459939],
Cell[125376, 4009, 2008, 37, 70, "Output",
 Evaluatable->False,
 CellID->34958568]
}, Open  ]],
Cell[127399, 4049, 125, 3, 70, "ExampleDelimiter",
 CellID->640101909],
Cell[127527, 4054, 221, 7, 70, "ExampleText",
 CellID->434558014],
Cell[127751, 4063, 640, 19, 70, "Input",
 CellID->862079956],
Cell[CellGroupData[{
Cell[128416, 4086, 624, 19, 70, "Input",
 CellID->1320268814],
Cell[129043, 4107, 765, 17, 70, "Output",
 Evaluatable->False,
 CellID->31782756]
}, Open  ]],
Cell[129823, 4127, 58, 1, 70, "ExampleText",
 CellID->1176738053],
Cell[129884, 4130, 641, 19, 70, "Input",
 CellID->1259551548],
Cell[CellGroupData[{
Cell[130550, 4153, 624, 19, 70, "Input",
 CellID->1536558757],
Cell[131177, 4174, 867, 18, 70, "Output",
 Evaluatable->False,
 CellID->169035438]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[132093, 4198, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[132334, 4207, 103, 2, 70, "ExampleText",
 CellID->316513968],
Cell[CellGroupData[{
Cell[132462, 4213, 508, 16, 70, "Input",
 CellID->241955977],
Cell[132973, 4231, 1960, 58, 111, "Output",
 CellID->1801049038]
}, Open  ]],
Cell[134948, 4292, 340, 13, 70, "ExampleText",
 CellID->613113541],
Cell[CellGroupData[{
Cell[135313, 4309, 714, 22, 70, "Input",
 CellID->1367561668],
Cell[136030, 4333, 2861, 76, 368, "Output",
 CellID->1449177201]
}, Open  ]],
Cell[138906, 4412, 125, 3, 70, "ExampleDelimiter",
 CellID->135815337],
Cell[139034, 4417, 223, 8, 70, "ExampleText",
 CellID->146537355],
Cell[CellGroupData[{
Cell[139282, 4429, 632, 19, 70, "Input",
 CellID->1805150387],
Cell[139917, 4450, 1088, 22, 70, "Output",
 Evaluatable->False,
 CellID->63660713]
}, Open  ]],
Cell[141020, 4475, 348, 13, 70, "ExampleText",
 CellID->75974750],
Cell[CellGroupData[{
Cell[141393, 4492, 662, 20, 70, "Input",
 CellID->424408147],
Cell[142058, 4514, 1089, 22, 70, "Output",
 Evaluatable->False,
 CellID->782139505]
}, Open  ]],
Cell[143162, 4539, 123, 3, 70, "ExampleDelimiter",
 CellID->5874536],
Cell[143288, 4544, 221, 8, 70, "ExampleText",
 CellID->535512214],
Cell[143512, 4554, 201, 7, 70, "Input",
 CellID->914027012],
Cell[CellGroupData[{
Cell[143738, 4565, 132, 4, 70, "Input",
 CellID->1864310337],
Cell[143873, 4571, 1563, 30, 70, "Output",
 Evaluatable->False,
 CellID->509370127]
}, Open  ]],
Cell[145451, 4604, 229, 7, 70, "ExampleText",
 CellID->94821444],
Cell[CellGroupData[{
Cell[145705, 4615, 161, 5, 70, "Input",
 CellID->957919056],
Cell[145869, 4622, 160, 5, 36, "Output",
 CellID->900021100]
}, Open  ]],
Cell[146044, 4630, 123, 3, 70, "ExampleDelimiter",
 CellID->4200064],
Cell[146170, 4635, 238, 8, 70, "ExampleText",
 CellID->671567693],
Cell[CellGroupData[{
Cell[146433, 4647, 227, 7, 70, "Input",
 CellID->1765939808],
Cell[146663, 4656, 2042, 38, 70, "Output",
 Evaluatable->False,
 CellID->24985974]
}, Open  ]],
Cell[148720, 4697, 124, 3, 70, "ExampleDelimiter",
 CellID->28051594],
Cell[148847, 4702, 240, 8, 70, "ExampleText",
 CellID->193367025],
Cell[CellGroupData[{
Cell[149112, 4714, 130, 4, 70, "Input",
 CellID->301495298],
Cell[149245, 4720, 395, 11, 36, "Output",
 CellID->532207049]
}, Open  ]],
Cell[CellGroupData[{
Cell[149677, 4736, 125, 3, 70, "Input",
 CellID->1129350733],
Cell[149805, 4741, 1188, 22, 122, "Output",
 CellID->534482788]
}, Open  ]],
Cell[CellGroupData[{
Cell[151030, 4768, 164, 4, 70, "Input",
 CellID->776831264],
Cell[151197, 4774, 285, 8, 36, "Output",
 CellID->128122515]
}, Open  ]],
Cell[151497, 4785, 125, 3, 70, "ExampleDelimiter",
 CellID->274708332],
Cell[151625, 4790, 249, 8, 70, "ExampleText",
 CellID->1950066989],
Cell[CellGroupData[{
Cell[151899, 4802, 130, 4, 70, "Input",
 CellID->429846371],
Cell[152032, 4808, 387, 11, 36, "Output",
 CellID->1576495311]
}, Open  ]],
Cell[CellGroupData[{
Cell[152456, 4824, 156, 5, 70, "Input",
 CellID->2027947256],
Cell[152615, 4831, 377, 11, 36, "Output",
 CellID->503455291]
}, Open  ]],
Cell[CellGroupData[{
Cell[153029, 4847, 159, 4, 70, "Input",
 CellID->1641565555],
Cell[153191, 4853, 181, 5, 36, "Output",
 CellID->487506657]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[153421, 4864, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[153655, 4873, 113, 3, 70, "ExampleText",
 CellID->1329051991],
Cell[CellGroupData[{
Cell[153793, 4880, 159, 4, 70, "Input",
 CellID->46500988],
Cell[153955, 4886, 301, 6, 70, "Message",
 CellID->874270894],
Cell[154259, 4894, 249, 7, 36, "Output",
 CellID->787802684]
}, Open  ]],
Cell[CellGroupData[{
Cell[154545, 4906, 165, 4, 70, "Input",
 CellID->222925477],
Cell[154713, 4912, 314, 7, 70, "Message",
 CellID->1363026233],
Cell[155030, 4921, 250, 7, 36, "Output",
 CellID->1173835482]
}, Open  ]],
Cell[155295, 4931, 96, 1, 70, "ExampleText",
 CellID->173046581],
Cell[CellGroupData[{
Cell[155416, 4936, 421, 13, 70, "Input",
 CellID->135247669],
Cell[155840, 4951, 194, 6, 36, "Output",
 CellID->1868164632]
}, Open  ]],
Cell[CellGroupData[{
Cell[156071, 4962, 417, 12, 70, "Input",
 CellID->57009403],
Cell[156491, 4976, 196, 6, 36, "Output",
 CellID->2032050884]
}, Open  ]],
Cell[CellGroupData[{
Cell[156724, 4987, 160, 4, 70, "Input",
 CellID->1260968962],
Cell[156887, 4993, 203, 5, 36, "Output",
 CellID->1246769147]
}, Open  ]],
Cell[157105, 5001, 124, 3, 70, "ExampleDelimiter",
 CellID->90344104],
Cell[157232, 5006, 237, 8, 70, "ExampleText",
 CellID->46301994],
Cell[CellGroupData[{
Cell[157494, 5018, 186, 6, 70, "Input",
 CellID->1739347100],
Cell[157683, 5026, 443, 12, 39, "Output",
 CellID->1451109850]
}, Open  ]],
Cell[158141, 5041, 229, 8, 70, "ExampleText",
 CellID->85509328],
Cell[CellGroupData[{
Cell[158395, 5053, 238, 7, 70, "Input",
 CellID->548645387],
Cell[158636, 5062, 329, 10, 39, "Output",
 CellID->1978953618]
}, Open  ]],
Cell[CellGroupData[{
Cell[159002, 5077, 92, 3, 70, "Input",
 CellID->60605648],
Cell[159097, 5082, 350, 10, 39, "Output",
 CellID->46732990]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[159508, 5099, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[159827, 5110, 467, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[160331, 5132, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[160652, 5143, 299, 9, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[160988, 5157, 326, 9, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[161317, 5168, 238, 5, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[161592, 5178, 299, 8, 70, "MoreAboutSection"],
Cell[161894, 5188, 150, 3, 70, "MoreAbout",
 CellID->335847743]
}, Open  ]],
Cell[162059, 5194, 27, 0, 70, "History"],
Cell[162089, 5196, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

