(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44523,       1369]
NotebookOptionsPosition[     37810,       1141]
NotebookOutlinePosition[     39059,       1177]
CellTagsIndexPosition[     38973,       1172]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PartitionsP" :> 
          Documentation`HelpLookup["paclet:ref/PartitionsP"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"PartitionsP\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PartitionsQ", "ObjectName",
 CellID->4698],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PartitionsQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PartitionsQ"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the number ",
     Cell[BoxData[
      RowBox[{
       StyleBox["q", "TI"], 
       RowBox[{"(", 
        StyleBox["n", "TI"], ")"}]}]], "InlineFormula"],
     " of partitions of the integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " into distinct parts. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25616]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PartitionsQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsQ"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25921293],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->456023349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PartitionsQ", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "2", ",", "2", ",", "3", ",", "4", ",", "5", 
   ",", "6", ",", "8", ",", "10", ",", "12", ",", "15"}], "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87517677]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->349984149],

Cell["Plot the number of restricted partitions:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"PartitionsQ", "[", "k", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd0HtMlXUcx/GHA4rcBOUmYIeriFAkF7mIyOcg9+u5n0OFOYfNcZiZQOQF
eAxUoIUmG2ECQ2sdlKCwQQoEJ0RllkiwMkKFyKSIi7gTIjCp1vf3hz3bs2ev
vX+fPc8e191vSvcIOI7L+Of+9/nf9SiCe/7C81yFmdCFZ5G+D+mc1f9sAzPD
xkMTFbPkddTnyOsR8P7UE5HuKdkFAhfvBbOGJbIbshvCIi6dZ+/1gJ2ipb1Z
IyB7Ir92sMPuF0OyF5zjkkPtLq4ge+P4B5qth52NyS+i91p4Xk7bKrIvThUb
Xh5JNyVvhqb3cufgFTOyH+pFV69dd7Ag+yMr8tTXq8+tJgfA3Lo7b/8fluRA
+l4r8has/V3X3SBdQw7CXFmTfbqeORhjZ4O2DFesJYcg8cvZBEmwNTkUxkIj
ec8A81a0RLwxfyTLhhyGoMmH9z4ztiVvw8if2lxVNXM4/W878nZUhbZXTnUz
R+C431fCO2J7MvB2s/C04h6ZB0wieydSNOuoi/DS0aGdZnoyL8LixYn+E0cc
qEfi5z05wgwjR+qRqDl9tq64hMztQL7nzvYhMyfqO3BL57JytpzMRaHpr7gC
H8v11KPwwKTGM6CczEXj11aromnzF6hHw8FJXBJYSuZikDH+XkihkZB6DC5Y
VgmrC8lcLHLbxdtC5lmPxfInxZzpfmfqcYgO1hyTj5P5ODy1PfD6W74u1OPh
X/Sk8+ZeMh8PYWvY9oHzrCdgdLFN63iX9QTctX1F+NjGlXoiPp9zmOWTyXwi
kur3avcdYz0JjSPZByY6WE9CXN/wmKOe9WTcyGrJbfF2o56MV1tvNE3vInMp
uH/TpHC0kvUUfLQyKj/mO9ZT4VFzbiDVwJ16KoTYNWYdRObEcNqs7UzLJEOM
0qXX9iXVsvNizH8cu1H/PVknhsWzrnd8VnjQXoKcGb7TOoQMCex/yLt1KZPM
SzB5MKt1ppqsk0DwYVX3cB/bS7HoU3ihiNtAeykWRKMxt/3IvBRTIT+evL2b
rJNCOzRefbKCzMmg7hEHzV9lexnqRG0ljnq2l0E1ZdG75O5Jexmmt/vVl8vI
nBw6XUnl/XfJkENW9u0XM81kXo4yeWF66yjby1Fv02UbbrmR9gqUzt4pLgkn
Q4H+0ZH4cg2ZV2Dy0YY05RmyToFPvXQv/3ad7ZVwspHU+evZXgl9b2xYtKsX
7ZXI7nGQu6aQdUpMPRhy6zpE5lRYHOz4xkNLhgo5j7WHFYNsr0JteEFB4jLb
q3Cw3yXQ3GcT7dXwNDXIP6MkQ41sS/WmmaNkXo1Mv9jaNY1knRr5fQZXBD+x
fRrcl4ucugTe+BtLkKHD
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0., 100.}, {0., 13.005364284384603`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69576827]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Compute the number of partitions for large numbers:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PartitionsQ", "[", "100000", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[\
"42494159403332317292526619504218136903700576932083624292980870857936616016516\
019121515022089648672327193383380680571759727227416036821183744674051457194041\
711141429085626371124196057902283995836976239181670821800000403741232325992196\
887134172550"], "Output",
 ImageSize->{583, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->421593393]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PartitionsQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsQ"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PartitionsQ", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4", ",", "6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->375338545]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->111713188],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->821082527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PartitionsQ", "[", "n", "]"}], "//", "TraditionalForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->282656848],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox["q",
    PartitionsQ], "(", "n", ")"}], TraditionalForm]], "Output",
 ImageSize->{24, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->373678618]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["\<\
Compare cumulative counts of even and odd partitions into distinct parts:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Accumulate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"PartitionsQ", "[", "k", "]"}], ",", "2"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1000"}], "}"}]}], "]"}], "]"}], "/", 
   RowBox[{"Range", "[", "1000", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->574494195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Plot the ratio of the number of partitions with its asymptotic value:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"PartitionsQ", "[", "k", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"4", " ", 
           RowBox[{"3", "^", 
            RowBox[{"(", 
             RowBox[{"1", "/", "4"}], ")"}]}], 
           RowBox[{"k", "^", 
            RowBox[{"(", 
             RowBox[{"3", "/", "4"}], ")"}]}]}], ")"}]}], ")"}], 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"Pi", " ", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"k", "/", "3"}], "]"}]}], ")"}]}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWetrHUUUn2T33uSmjyTaJjENtSWIUEQRQaiY3tym3trWikVCoSh6SZUE
tJa0oB/8UEGtqAURinRjShNr/FCttvWF0iL4Jfkg/g9C/471zJnZ2ZmzZ1/J
rTW9bHbv7JzfeT8myeHW6enX3mydnplq7dg/2zo5PTN1akfzrVl45XUIIW7D
z3tDAr6H8A1/hsMwFJ78hh+xLG+Cvq3Km//R2T/qYxfgOvfpn7cy6I5OLim6
Rn0upusEsi7cX1n+Z6IxB/tw5/kgnff68atA9OKRyyKLqlEPlLQsKv/QgUtG
95uOTt2RTorR+J7gJssH6TzY1tL6YO3Ddqfm4+nnCPIzOLI7TNbRc1vK+yF4
eowU+5mma3PfvDJI9Mt1Re2bO/KMUHQtvz7gWlIAMYBJYCOK4QZXiRsopWG0
lqXQIZ/pvvNfeH7R5Et/aT8M6txQyZcw657xm8zAWkjr574CvBJW0P0cq9bi
tSGteSk5bc4y9JrVTcr6bDU2eCXo73ZmJX2lRkZ9LBC9/1Hc0QcVsy4Ymf+d
53wzIaGX9Yb8HMmeWtF0olMoa2qlTSt3aslVD8peXPhLlQPcf2etQTqrZjKo
fEP1ystXfsugA6mKDi5FJ+OwAmRVFtWVyAk4WYhOqY4HonRkagRV5bhkrPPo
1zu/bta3GxAKk2R8TAdPubOsN/tK7pelL2stxfPWbwydvIVafYpQjJL1wRJ8
zfkXGuivhk5W3ya5qoDXTR2AaPELywtp/WebFxUhKJtFZ/Pk6TbDzbNqR777
0dEOe73/4Qe3DKefWU69htNzBxf0uxuplC7Hn1i6PjcewNbVTJ2p7f4BNqTI
7Hd5wZVBl+B5naXFE0PFxELH7Zqj4/2J2Mr5qWh0E8YPfvXjySKEH8YdXwqt
EOmKs+3FfXvnxQ8K70yxqsVbvaGTL2+9BWXNnrxhZEEwxPeMrIrWVqlrbaA9
WTK2ooxnJr50PH+VkeGz9nQyPop8h7w9EwWcFqmcC5xLOFkDicyBX77Fd2Wl
JCOXOA/ZcZAyvk1kUzV0p71vPel5TFSOt644/NQMjTJYZb2h0ZMWMl3z+MZQ
25zzUEssahuLijvT1yxqhEVBNej9y44925Ha+FBTg92a+itWhkKZahO0Zy6w
qAejvDvQnI9RsWaXWNROXB87uuTIirvqRceeUVYz6HSaep6VMUo084kX5ljU
Q7iGHG9gI02gLrCoh+P4WKjYC1849uwi0aQyzrMydhF7qiTfPg/zOy6tFlrh
jzgyAi0jtuOzMKX30q5Xqhc/FmdDEFsWZ945RmrUhaP+x3djufN4qKtBnfhE
F+H+McO9SJcUBSx7IvJnUzb9QHQT2WfvoOwnQ101DWl3JDuO5ft3UPZux+eB
qJFcPRPSXKX9PHrSDH2aWNVDPPpuaFfauFz5Jp/h6iGd5h1Db0uZQJzRH64N
xIJTLG5/AreR4E6wuEOh3XUC2bE1Mo7XjGPZEeJhidhEbJtiZU0yyF7ixZdY
5LFIy711REIfDvpI75pkka8SJHS8oJ8gDzv2TZM4S8QW4ssJVhZ62O1hwVaC
3M0i3w7tPqSQg8Snj7LIM8Sn0GOCYYLc6dj3CSKiiYHVGWwnWuLpu2BHl0/u
DH2eeB7yPxghmuk/IOd3dWvt5ewvkvhBNgebQW6NkUV7ed45+hrxXU0l457g
xBu41c3IKHzuZdZyubwWnkxcSvPLjM5yIlOKno/j/8XJ3RWz4mnKvF3v/JSr
og8X07xZpfiwldOGGbveuMdVtH50Lldj2XlwL9TE6vkVr6a0vwatPrpcNNuX
O3eH+9qqKfJ5G3zcprn0N5LcTtxFx7+XSRui\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{229, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->393978750]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Visualize ",
 Cell[BoxData["p"], "InlineFormula"],
 "\[Hyphen]adic valuations of the number of partitions:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], "@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"IntegerExponent", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"PartitionsQ", "[", "n", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "120"}], "}"}]}], "]"}], ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "2", ",", "120"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztWWtyxCAI/rY36ZV6hL1Af7bH705jFBEVHxgzLTM7iStvENG8Pz8/nm8A
vl6/79fv8Q9lWOYhC0GjPMv0SF7my9gD7qCjDHMzQMXtvs7aBVo9+O9xFbx2
u2FPrXG1Xkq7PvdKFghvLVT2YCtrj2jltdhDv2ZYoDbSV4j5bKbLHMY3jfAf
BbCntRxTbk1CkHlfCTCX3sH7Bgu4qOIS/bVCNnXmtQm/TAYX1yceSuLJxlk2
9eOUV7DthDlZUOM6DWYxFk6vKA63g179xKZGYlYRoJDfqCLaSbSMZdZ7h3j8
4oqcj/Y2dQlMO3ejRqHmV12DYXv9zWC6e4MuGFCdwgrHSXNMR1kQSPrUXQkj
BzHjTqFA1O2uyxfrdQoU+tMMIs/hi1oPjdgaTtv8/A14HASB078S2Jar9u8a
BgVm8Dpzl3t+jBqyDchlaeX98xLIaT/UPvbc43Xf/Vlsx0V+9w74Adp9Z1Nb
u2+2yRjSXJ6uVaSMP+ZP+bw3fp/TcRdAEa++V4EUTJv7jZRk5T3DrPO+DaqG
SBGB9PxLilFsL8h7IDpHCO9kyXe2erbn0IQCbNzCfVI2kiVldy6ruZdndbnW
ZbnIc6OttnpK3yv2nRfGq838vr3SP4tZMiD6ij522FP5BdPJOrE2N54T5KA/
kn8b+6tKnFb0OTJ/uW5U+w2GwOtUPF2zRKroyd6nAFX5ibYebqfQb4Aj0P03
dWKig1TCwQhb9sGCV+uuihoJiQM4XkmCOq7I4Tav1+y+oNO0Vp/7O4mMGg0M
muqkOOG/jDzo15U4pGDjlCUCK1GYnDswqBsJl/QR1iNi/Qm/eMXGsvyrUx45
DWR9uC941QL5CfTiyFnFskKsNvCxYiogcmWc1/AGc4bgqCQZTkub84rFRcir
WGzwKcJxhzwdOo7jD8u1cCaCN9SrTAzwGOyro+PI3eb9TOQRHmlguH8IU5xS
cFrhhj4wzjIcDoB3/zF0ZMfD6X8MTwPppEP5Ae9SN9A=
   "], {{0, 0}, {120, 119}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->{225, Automatic}]], "Output",
 ImageSize->{229, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->326320716]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PartitionsQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsQ"]], "InlineFormula"],
 " gives the length of ",
 Cell[BoxData[
  ButtonBox["IntegerPartitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFormula"],
 " with nonrepeating parts:"
}], "ExampleText",
 CellID->173257980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", "5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68128658],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102364804]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PartitionsQ", "[", "5", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->485295486],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37084460]
}, Open  ]],

Cell["Generate the explicit partitions:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"IntegerPartitions", "[", "5", "]"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Max", "[", 
      RowBox[{"Length", "/@", 
       RowBox[{"Split", "@", " ", "#"}]}], "]"}], "==", "1"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2295436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Model ",
 Cell[BoxData[
  ButtonBox["PartitionsQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsQ"]], "InlineFormula"],
 " based on the definition:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"IntegerPartitions", "[", "n", "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Sort", "[", "#", "]"}], "==", 
        RowBox[{"Union", "[", "#", "]"}]}], "&"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", 
   ",", "8", ",", "10", ",", "12", ",", "15"}], "}"}]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94982689]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PartitionsQ", "[", "n", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", 
   ",", "8", ",", "10", ",", "12", ",", "15"}], "}"}]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->239375996]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PartitionsQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsQ"]], "InlineFormula"],
 " evaluates only for explicit integers:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PartitionsQ", "[", "12.1", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"PartitionsQ", "[", "12.1`", "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->528941994]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " to find implicit integers in arguments:"
}], "ExampleText",
 CellID->270319749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PartitionsQ", "[", 
  RowBox[{"12", " ", "+", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"E", " ", "+", " ", "1"}], ")"}], "^", "2"}], "-", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"E", " ", "+", " ", "1"}], ")"}], "^", "2"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"PartitionsQ", "[", 
  RowBox[{"11", "-", 
   RowBox[{"2", " ", "\[ExponentialE]"}], "-", 
   SuperscriptBox["\[ExponentialE]", "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"]}], "]"}]], "Output",
 ImageSize->{223, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->153177019]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->63616441],

Cell[BoxData["15"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->513478486]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Successive differences of ",
 Cell[BoxData[
  ButtonBox["PartitionsQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsQ"]], "InlineFormula"],
 " modulo 2:"
}], "ExampleText",
 CellID->19768499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"NestList", "[", 
     RowBox[{"Differences", ",", 
      RowBox[{"PartitionsQ", "[", 
       RowBox[{"Range", "[", "100", "]"}], "]"}], ",", "100"}], "]"}], ",", 
    "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->602961573],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztWFuS4zYMHFVykVwpR9hKvnP/v8wmUYqG0Q9wJEEeU1Uomw+QYDfQlP3b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   "], {{0, 0}, {100, 101}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->Small]], "Output",
 ImageSize->{184, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->498065665]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153493948],

Cell[TextData[{
 "A \"random\" walk based on ",
 Cell[BoxData[
  ButtonBox["PartitionsQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->166750205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "#", "]"}], ",", 
      RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
   RowBox[{"Accumulate", "[", 
    RowBox[{"Exp", "[", 
     RowBox[{"3.4", " ", "Pi", "  ", "I", " ", 
      RowBox[{"PartitionsQ", "[", 
       RowBox[{"Range", "[", "500", "]"}], "]"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167776127],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40690258]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27479],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["PartitionsP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsP"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->19593]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24815],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->6064]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->16226],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/PartitionFunctionQ.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/PartitionsQ/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->658128831],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->160364680]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PartitionsQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 15.7728710}", "context" -> "System`", 
    "keywords" -> {"partitions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PartitionsQ[n] gives the number q (n) of partitions of the integer n \
into distinct parts. ", "synonyms" -> {"partitions q"}, "title" -> 
    "PartitionsQ", "type" -> "Symbol", "uri" -> "ref/PartitionsQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4056, 141, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->25921293]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38831, 1165}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1743, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2366, 74, 48, 1, 70, "ObjectName",
 CellID->4698],
Cell[2417, 77, 741, 24, 70, "Usage",
 CellID->25616]
}, Open  ]],
Cell[CellGroupData[{
Cell[3195, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3673, 123, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[3808, 129, 211, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[4056, 141, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25921293],
Cell[CellGroupData[{
Cell[4440, 155, 148, 5, 70, "ExampleSection",
 CellID->456023349],
Cell[CellGroupData[{
Cell[4613, 164, 203, 6, 28, "Input"],
Cell[4819, 172, 323, 9, 36, "Output",
 CellID->87517677]
}, Open  ]],
Cell[5157, 184, 125, 3, 70, "ExampleDelimiter",
 CellID->349984149],
Cell[5285, 189, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[5374, 193, 270, 8, 28, "Input"],
Cell[5647, 203, 1873, 40, 166, "Output",
 CellID->69576827]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7569, 249, 200, 6, 70, "ExampleSection"],
Cell[7772, 257, 74, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[7871, 261, 92, 2, 70, "Input"],
Cell[7966, 265, 411, 9, 88, "Output",
 CellID->421593393]
}, Open  ]],
Cell[8392, 277, 105, 2, 70, "ExampleDelimiter"],
Cell[8500, 281, 196, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[8721, 291, 144, 4, 70, "Input"],
Cell[8868, 297, 213, 7, 36, "Output",
 CellID->375338545]
}, Open  ]],
Cell[9096, 307, 125, 3, 70, "ExampleDelimiter",
 CellID->111713188],
Cell[9224, 312, 203, 7, 70, "ExampleText",
 CellID->821082527],
Cell[CellGroupData[{
Cell[9452, 323, 147, 5, 70, "Input",
 CellID->282656848],
Cell[9602, 330, 260, 9, 50, "Output",
 CellID->373678618]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9911, 345, 207, 6, 70, "ExampleSection"],
Cell[10121, 353, 104, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[10250, 359, 405, 12, 70, "Input"],
Cell[10658, 373, 2217, 40, 70, "Output",
 Evaluatable->False,
 CellID->574494195]
}, Open  ]],
Cell[12890, 416, 105, 2, 70, "ExampleDelimiter"],
Cell[12998, 420, 100, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[13123, 426, 788, 25, 70, "Input"],
Cell[13914, 453, 2079, 38, 70, "Output",
 Evaluatable->False,
 CellID->393978750]
}, Open  ]],
Cell[16008, 494, 105, 2, 70, "ExampleDelimiter"],
Cell[16116, 498, 144, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16285, 506, 554, 17, 70, "Input"],
Cell[16842, 525, 1357, 28, 244, "Output",
 CellID->326320716]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18248, 559, 217, 6, 70, "ExampleSection"],
Cell[18468, 567, 371, 12, 70, "ExampleText",
 CellID->173257980],
Cell[CellGroupData[{
Cell[18864, 583, 112, 3, 70, "Input",
 CellID->68128658],
Cell[18979, 588, 645, 21, 36, "Output",
 CellID->102364804]
}, Open  ]],
Cell[CellGroupData[{
Cell[19661, 614, 107, 3, 70, "Input",
 CellID->485295486],
Cell[19771, 619, 157, 5, 36, "Output",
 CellID->37084460]
}, Open  ]],
Cell[19943, 627, 56, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[20024, 631, 306, 10, 70, "Input"],
Cell[20333, 643, 334, 12, 36, "Output",
 CellID->2295436]
}, Open  ]],
Cell[20682, 658, 105, 2, 70, "ExampleDelimiter"],
Cell[20790, 662, 199, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[21014, 673, 423, 13, 70, "Input"],
Cell[21440, 688, 313, 9, 36, "Output",
 CellID->94982689]
}, Open  ]],
Cell[CellGroupData[{
Cell[21790, 702, 203, 6, 70, "Input"],
Cell[21996, 710, 314, 9, 36, "Output",
 CellID->239375996]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22359, 725, 210, 6, 70, "ExampleSection"],
Cell[22572, 733, 201, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[22798, 743, 90, 2, 70, "Input"],
Cell[22891, 747, 200, 6, 36, "Output",
 CellID->528941994]
}, Open  ]],
Cell[23106, 756, 226, 8, 70, "ExampleText",
 CellID->270319749],
Cell[CellGroupData[{
Cell[23357, 768, 341, 11, 70, "Input"],
Cell[23701, 781, 407, 12, 39, "Output",
 CellID->153177019]
}, Open  ]],
Cell[CellGroupData[{
Cell[24145, 798, 103, 3, 70, "Input",
 CellID->63616441],
Cell[24251, 803, 159, 5, 36, "Output",
 CellID->513478486]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24459, 814, 208, 6, 70, "ExampleSection"],
Cell[24670, 822, 223, 8, 70, "ExampleText",
 CellID->19768499],
Cell[CellGroupData[{
Cell[24918, 834, 330, 10, 70, "Input",
 CellID->602961573],
Cell[25251, 846, 2798, 52, 202, "Output",
 CellID->498065665]
}, Open  ]],
Cell[28064, 901, 125, 3, 70, "ExampleDelimiter",
 CellID->153493948],
Cell[28192, 906, 216, 8, 70, "ExampleText",
 CellID->166750205],
Cell[CellGroupData[{
Cell[28433, 918, 472, 15, 70, "Input",
 CellID->167776127],
Cell[28908, 935, 6495, 111, 70, "Output",
 Evaluatable->False,
 CellID->40690258]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35464, 1053, 311, 9, 70, "SeeAlsoSection",
 CellID->27479],
Cell[35778, 1064, 202, 6, 70, "SeeAlso",
 CellID->19593]
}, Open  ]],
Cell[CellGroupData[{
Cell[36017, 1075, 314, 9, 70, "TutorialsSection",
 CellID->24815],
Cell[36334, 1086, 155, 3, 70, "Tutorials",
 CellID->6064]
}, Open  ]],
Cell[CellGroupData[{
Cell[36526, 1094, 321, 9, 70, "RelatedLinksSection",
 CellID->16226],
Cell[36850, 1105, 189, 4, 70, "RelatedLinks"],
Cell[37042, 1111, 200, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37279, 1120, 319, 9, 70, "MoreAboutSection",
 CellID->658128831],
Cell[37601, 1131, 137, 3, 70, "MoreAbout",
 CellID->160364680]
}, Open  ]],
Cell[37753, 1137, 27, 0, 70, "History"],
Cell[37783, 1139, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

