(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13058,        437]
NotebookOptionsPosition[     10242,        348]
NotebookOutlinePosition[     11672,        387]
CellTagsIndexPosition[     11587,        382]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"PassEventsUp" :> 
         Documentation`HelpLookup["paclet:ref/PassEventsUp"], "EventHandler" :> 
         Documentation`HelpLookup["paclet:ref/EventHandler"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"PassEventsUp\"\>", 
      2->"\<\"EventHandler\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PassEventsDown", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PassEventsDown",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PassEventsDown"]], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["EventHandler",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
     " which specifies whether events handled by a particular event handler \
should be passed down to event handlers nested inside."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15941]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible settings are:", "Notes",
 CellID->7131],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "pass all events down", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "pass no events down", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "pass events down only to explicit ",
     Cell[BoxData[
      ButtonBox["EventHandler",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
     " constructs "
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->15749],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"PassEventsDown", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " prevents events from being passed to built-in event handlers in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end that implement operations such as editing."
}], "Notes",
 CellID->31539]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->74529760],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->52996912],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
 " intercepts the specified event:"
}], "ExampleText",
 CellID->1860688024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"EventHandler", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "pt", "]"}], ",", ".1"}], "]"}], "}"}], ",",
        
       RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
     RowBox[{"\"\<MouseDown\>\"", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{"pt", "=", 
        RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}]}], ")"}]}]}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->926751754],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {0.40000000000000013`, 
  0.43333333333333335`}}, 
  TagBox[
   GraphicsBox[DiskBox[Dynamic[$CellContext`pt$$], 0.1],
    PlotRange->1],
   EventHandlerTag[{
    "MouseDown" :> ($CellContext`pt$$ = MousePosition["Graphics"]), 
     PassEventsDown -> Automatic, PassEventsUp -> True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->499049474]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1277701597],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  ButtonBox["PassEventsDown",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PassEventsDown"]], "InlineFormula"],
 " allows graphics editing to receive mouse events: "
}], "ExampleText",
 CellID->7027772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"EventHandler", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "pt", "]"}], ",", ".1"}], "]"}], "}"}], ",",
        
       RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
     RowBox[{"\"\<MouseDown\>\"", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{"pt", "=", 
        RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}]}], ")"}]}], 
     ",", 
     RowBox[{"PassEventsDown", "\[Rule]", "True"}]}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1600867983],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {0, 0}}, 
  TagBox[
   GraphicsBox[DiskBox[Dynamic[$CellContext`pt$$], 0.1],
    PlotRange->1],
   EventHandlerTag[{
    "MouseDown" :> ($CellContext`pt$$ = MousePosition["Graphics"]), 
     PassEventsDown -> True, PassEventsDown -> Automatic, PassEventsUp -> 
     True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325750749]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13245],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PassEventsUp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PassEventsUp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EventHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EventHandler"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14726]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PassEventsDown - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 18.0854302}", "context" -> "System`", 
    "keywords" -> {
     "intercepting mouse events", "intercepting keyboard events", 
      "intercepting menu commands"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PassEventsDown is an option to EventHandler which specifies whether \
events handled by a particular event handler should be passed down to event \
handlers nested inside.", "synonyms" -> {"pass events down"}, "title" -> 
    "PassEventsDown", "type" -> "Symbol", "uri" -> "ref/PassEventsDown"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5578, 173, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->74529760]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11445, 375}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 685, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1308, 43, 1579, 37, 70, "ObjectNameGrid"],
Cell[2890, 82, 690, 19, 70, "Usage",
 CellID->15941]
}, Open  ]],
Cell[CellGroupData[{
Cell[3617, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4095, 123, 54, 1, 70, "Notes",
 CellID->7131],
Cell[4152, 126, 984, 28, 70, "2ColumnTableMod",
 CellID->15749],
Cell[5139, 156, 402, 12, 70, "Notes",
 CellID->31539]
}, Closed]],
Cell[CellGroupData[{
Cell[5578, 173, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->74529760],
Cell[CellGroupData[{
Cell[5962, 187, 147, 5, 70, "ExampleSection",
 CellID->52996912],
Cell[6112, 194, 235, 8, 70, "ExampleText",
 CellID->1860688024],
Cell[CellGroupData[{
Cell[6372, 206, 731, 23, 65, "Input",
 CellID->926751754],
Cell[7106, 231, 509, 14, 201, "Output",
 CellID->499049474]
}, Open  ]],
Cell[7630, 248, 126, 3, 70, "ExampleDelimiter",
 CellID->1277701597],
Cell[7759, 253, 250, 8, 70, "ExampleText",
 CellID->7027772],
Cell[CellGroupData[{
Cell[8034, 265, 793, 25, 70, "Input",
 CellID->1600867983],
Cell[8830, 292, 498, 14, 70, "Output",
 CellID->325750749]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9389, 313, 311, 9, 70, "SeeAlsoSection",
 CellID->13245],
Cell[9703, 324, 467, 17, 70, "SeeAlso",
 CellID->14726]
}, Open  ]],
Cell[10185, 344, 27, 0, 70, "History"],
Cell[10215, 346, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

