(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47525,       1830]
NotebookOptionsPosition[     37485,       1475]
NotebookOutlinePosition[     38895,       1514]
CellTagsIndexPosition[     38809,       1509]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
          "NotebookApply" :> 
          Documentation`HelpLookup["paclet:ref/NotebookApply"], "Hyperlink" :> 
          Documentation`HelpLookup["paclet:ref/Hyperlink"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Button\"\>", 
       2->"\<\"NotebookApply\"\>", 
       3->"\<\"Hyperlink\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Palettes" :> 
          Documentation`HelpLookup["paclet:guide/Palettes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Custom Interface Construction\"\>", 
       3->"\<\"Palettes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PasteButton", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PasteButton",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PasteButton"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a button that pastes ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " whenever it is pressed. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PasteButton",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PasteButton"], "[", 
       RowBox[{
        StyleBox["label", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays with ",
     Cell[BoxData[
      StyleBox["label", "TI"]], "InlineFormula"],
     " on the button. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->4202]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default pasted at the current insertion point in your input \
notebook. "
}], "Notes",
 CellID->23753],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PasteButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PasteButton"], "[", 
   RowBox[{
    StyleBox["notebook", "TI"], ",", 
    StyleBox["label", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " pastes to the specified notebook. "
}], "Notes",
 CellID->22249],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PasteButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PasteButton"]], "InlineFormula"],
 " evaluates its arguments in an ordinary way, so that ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is immediately evaluated. "
}], "Notes",
 CellID->5058],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " contains a selection placeholder, it will be replaced by your current \
selection when the paste is done. "
}], "Notes",
 CellID->16575],

Cell[TextData[{
 "Selection placeholders are represented by the character ",
 Cell[BoxData["\[SelectionPlaceholder]"], "InlineFormula"],
 " or ",
 Cell[TextData[ButtonBox["\\[SelectionPlaceholder]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SelectionPlaceholder"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->8090],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["label", "TI"]], "InlineFormula"],
 " can be any expression. "
}], "Notes",
 CellID->24638],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PasteButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PasteButton"]], "InlineFormula"],
 " takes the same options as ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6823]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->42477684],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->571507636],

Cell["Create a button that will paste its contents:", "ExampleText",
 CellID->596779275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PasteButton", "[", "1", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->665792386],

Cell[BoxData[
 ButtonBox["1",
  BaseStyle->"Paste"]], "Output",
 ImageSize->{14, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116493174]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->453632767],

Cell["Supply a different label:", "ExampleText",
 CellID->785320463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PasteButton", "[", 
  RowBox[{"\"\<aaa\>\"", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->726987488],

Cell[BoxData[
 ButtonBox["\<\"aaa\"\>",
  BaseStyle->"Paste",
  ButtonData->"1"]], "Output",
 ImageSize->{26, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->541361442]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14820],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PasteButton Content",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->144842811],

Cell["Use any expression as a label:", "ExampleText",
 CellID->993536701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PasteButton", "[", "a", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[MathematicaIcon]\>\"", ",", "Large"}], "]"}], ",", 
       "\"\<string\>\"", ",", 
       RowBox[{"Framed", "[", 
        RowBox[{"x", "+", "y"}], "]"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Rectangle", "[", "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1889358125],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox[
    StyleBox["\<\"\[MathematicaIcon]\"\>",
     StripOnInput->False,
     FontSize->Large],
    BaseStyle->"Paste"], ",", 
   ButtonBox["\<\"string\"\>",
    BaseStyle->"Paste"], ",", 
   ButtonBox[
    FrameBox[
     RowBox[{"x", "+", "y"}],
     StripOnInput->False],
    BaseStyle->"Paste"], ",", 
   ButtonBox[
    GraphicsBox[RectangleBox[{0, 0}],
     ImageSize->20],
    BaseStyle->"Paste"]}], "}"}]], "Output",
 ImageSize->{171, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->491022120]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PasteButton Control",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1540953033],

Cell["Paste the result of an evaluation:", "ExampleText",
 CellID->1274152426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PasteButton", "[", 
  RowBox[{
   RowBox[{"HoldForm", "[", 
    RowBox[{"Integrate", "[", 
     RowBox[{"x", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2120379545],

Cell[BoxData[
 ButtonBox[
  TagBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    RowBox[{"x", 
     RowBox[{"\[DifferentialD]", "x"}]}]}],
   HoldForm],
  BaseStyle->"Paste",
  ButtonData->FractionBox["1", "2"]]], "Output",
 ImageSize->{49, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102596757]
}, Open  ]],

Cell["Paste a graphics object:", "ExampleText",
 CellID->90265984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PasteButton", "[", 
    RowBox[{"p", ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"p", "[", "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Rectangle", ",", "Disk"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->976938306],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["Rectangle",
    BaseStyle->"Paste",
    ButtonData->GraphicsBox[
      RectangleBox[{0, 0}]]], ",", 
   ButtonBox["Disk",
    BaseStyle->"Paste",
    ButtonData->GraphicsBox[
      DiskBox[{0, 0}]]]}], "}"}]], "Output",
 ImageSize->{105, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106807188]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->279167576],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1440961975],

Cell["Different predefined alignment options:", "ExampleText",
 CellID->569627317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PasteButton", "[", 
      RowBox[{"\"\<y\>\"", ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "50"}], "}"}]}], ",", 
       RowBox[{"Alignment", "\[Rule]", "a"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->618910655],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   ButtonBox["\<\"y\"\>",
    Alignment->Top,
    BaseStyle->"Paste",
    ImageSize->{Automatic, 50}], "xxx", 
   ButtonBox["\<\"y\"\>",
    Alignment->Center,
    BaseStyle->"Paste",
    ImageSize->{Automatic, 50}], "xxx", 
   ButtonBox["\<\"y\"\>",
    Alignment->Bottom,
    BaseStyle->"Paste",
    ImageSize->{Automatic, 50}]}],
  Row[{
    PasteButton["y", ImageSize -> {Automatic, 50}, Alignment -> Top], 
    PasteButton["y", ImageSize -> {Automatic, 50}, Alignment -> Center], 
    PasteButton["y", ImageSize -> {Automatic, 50}, Alignment -> Bottom]}, 
   "xxx"]]], "Output",
 ImageSize->{88, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->279280199]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22264276],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Default",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Default"]], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Pressed\>\""], "InlineFormula"],
 " appearance:"
}], "ExampleText",
 CellID->207020871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PasteButton", "[", 
    RowBox[{"\"\<xxx\>\"", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", "\"\<Pressed\>\""}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->449021595],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    BaseStyle->"Paste"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->"Pressed",
    BaseStyle->"Paste"]}], "}"}]], "Output",
 ImageSize->{74, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174914568]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->194028038],

Cell["Change the background colors:", "ExampleText",
 CellID->366214924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PasteButton", "[", 
    RowBox[{"\"\<xxx\>\"", ",", 
     RowBox[{"Background", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Green", ",", "Gray", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->528656858],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    Background->RGBColor[1, 0.5, 0.5],
    BaseStyle->"Paste"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Background->RGBColor[0, 1, 0],
    BaseStyle->"Paste"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Background->GrayLevel[0.5],
    BaseStyle->"Paste"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Background->RGBColor[1, 1, 0],
    BaseStyle->"Paste"]}], "}"}]], "Output",
 ImageSize->{140, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->946957111]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5534595],

Cell["Align with the surrounding text:", "ExampleText",
 CellID->19113093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Framed", "@", 
      RowBox[{"PasteButton", "[", 
       RowBox[{"\"\<b\>\"", ",", 
        RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340562913],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FrameBox[
    ButtonBox["\<\"b\"\>",
     BaseStyle->"Paste",
     BaselinePosition->Top],
    StripOnInput->False], "xxx", 
   FrameBox[
    ButtonBox["\<\"b\"\>",
     BaseStyle->"Paste",
     BaselinePosition->Center],
    StripOnInput->False], "xxx", 
   FrameBox[
    ButtonBox["\<\"b\"\>",
     BaseStyle->"Paste",
     BaselinePosition->Bottom],
    StripOnInput->False]}],
  Row[{
    Framed[
     PasteButton["b", BaselinePosition -> Top]], 
    Framed[
     PasteButton["b", BaselinePosition -> Center]], 
    Framed[
     PasteButton["b", BaselinePosition -> Bottom]]}, "xxx"]]], "Output",
 ImageSize->{118, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9129975]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->73988460],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["PasteButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PasteButton"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PasteButton", "[", "\"\<xxx\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94729581],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  BaseStyle->"Paste"]], "Output",
 ImageSize->{26, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->539456101]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26745135],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the button is disabled but visible in its current state:"
}], "ExampleText",
 CellID->576258550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PasteButton", "[", 
  RowBox[{"\"\<xxx\>\"", ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227336428],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  BaseStyle->"Paste",
  Enabled->False]], "Output",
 ImageSize->{26, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2110215520]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Evaluator",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->97213496],

Cell["By default the paste operation takes place in the front end:", \
"ExampleText",
 CellID->96906759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PasteButton", "[", "\"\<xxx\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1786402438],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  BaseStyle->"Paste"]], "Output",
 ImageSize->{26, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145285184]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->70979564],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["FrameMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameMargins"]], "InlineFormula"],
 " you make the button content area larger:"
}], "ExampleText",
 CellID->592492429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PasteButton", "[", 
    RowBox[{"\"\<xxx\>\"", ",", 
     RowBox[{"FrameMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10", ",", "20"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2099775161],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    BaseStyle->"Paste",
    FrameMargins->0], ",", 
   ButtonBox["\<\"xxx\"\>",
    BaseStyle->"Paste",
    FrameMargins->5], ",", 
   ButtonBox["\<\"xxx\"\>",
    BaseStyle->"Paste",
    FrameMargins->10], ",", 
   ButtonBox["\<\"xxx\"\>",
    BaseStyle->"Paste",
    FrameMargins->20]}], "}"}]], "Output",
 ImageSize->{194, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153036230]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->308463628],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["ImageMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
 " you make the button area larger:"
}], "ExampleText",
 CellID->33301087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PasteButton", "[", 
    RowBox[{"\"\<xxx\>\"", ",", 
     RowBox[{"ImageMargins", "\[Rule]", "m"}], ",", 
     RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10", ",", "20"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23634922],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    Background->RGBColor[1, 0.5, 0.5],
    BaseStyle->"Paste",
    ImageMargins->0], ",", 
   ButtonBox["\<\"xxx\"\>",
    Background->RGBColor[1, 0.5, 0.5],
    BaseStyle->"Paste",
    ImageMargins->5], ",", 
   ButtonBox["\<\"xxx\"\>",
    Background->RGBColor[1, 0.5, 0.5],
    BaseStyle->"Paste",
    ImageMargins->10], ",", 
   ButtonBox["\<\"xxx\"\>",
    Background->RGBColor[1, 0.5, 0.5],
    BaseStyle->"Paste",
    ImageMargins->20]}], "}"}]], "Output",
 ImageSize->{210, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91537179]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->347779171],

Cell["Use preset values:", "ExampleText",
 CellID->91656306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PasteButton", "[", 
    RowBox[{"\"\<xxx\>\"", ",", 
     RowBox[{"ImageSize", "\[Rule]", "i"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234360116],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    BaseStyle->"Paste",
    ImageSize->Tiny], ",", 
   ButtonBox["\<\"xxx\"\>",
    BaseStyle->"Paste",
    ImageSize->Small], ",", 
   ButtonBox["\<\"xxx\"\>",
    BaseStyle->"Paste",
    ImageSize->Medium], ",", 
   ButtonBox["\<\"xxx\"\>",
    BaseStyle->"Paste",
    ImageSize->Large]}], "}"}]], "Output",
 ImageSize->{140, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1254005492]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292736021],

Cell["Or use any values:", "ExampleText",
 CellID->27069804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PasteButton", "[", 
     RowBox[{"\"\<xxx\>\"", ",", 
      RowBox[{"ImageSize", "\[Rule]", "i"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"50", ",", "100", ",", "150", ",", "200"}], "}"}]}], "}"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->289053222],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ButtonBox["\<\"xxx\"\>",
      BaseStyle->"Paste",
      ImageSize->50]},
    {
     ButtonBox["\<\"xxx\"\>",
      BaseStyle->"Paste",
      ImageSize->100]},
    {
     ButtonBox["\<\"xxx\"\>",
      BaseStyle->"Paste",
      ImageSize->150]},
    {
     ButtonBox["\<\"xxx\"\>",
      BaseStyle->"Paste",
      ImageSize->200]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{204, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->594074714]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1372330],

Cell["\<\
By setting the second element you can also control the height:\
\>", "ExampleText",
 CellID->16996013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PasteButton", "[", 
  RowBox[{"\"\<xxx\>\"", ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "50"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->643525534],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  BaseStyle->"Paste",
  ImageSize->{Automatic, 50}]], "Output",
 ImageSize->{26, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->962243295]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->180520251],

Cell["Set a fully custom size: ", "ExampleText",
 CellID->167047478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PasteButton", "[", 
     RowBox[{"xxx", ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "30", ",", "40"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"30", ",", "40", ",", "60"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->395912750],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ButtonBox["xxx",
      BaseStyle->"Paste",
      ImageSize->{30, 20}], 
     ButtonBox["xxx",
      BaseStyle->"Paste",
      ImageSize->{40, 20}], 
     ButtonBox["xxx",
      BaseStyle->"Paste",
      ImageSize->{60, 20}]},
    {
     ButtonBox["xxx",
      BaseStyle->"Paste",
      ImageSize->{30, 30}], 
     ButtonBox["xxx",
      BaseStyle->"Paste",
      ImageSize->{40, 30}], 
     ButtonBox["xxx",
      BaseStyle->"Paste",
      ImageSize->{60, 30}]},
    {
     ButtonBox["xxx",
      BaseStyle->"Paste",
      ImageSize->{30, 40}], 
     ButtonBox["xxx",
      BaseStyle->"Paste",
      ImageSize->{40, 40}], 
     ButtonBox["xxx",
      BaseStyle->"Paste",
      ImageSize->{60, 40}]}
   }],
  "Grid"]], "Output",
 ImageSize->{150, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45561038]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12531],

Cell["Make paste buttons for a collection of country strings:", "ExampleText",
 CellID->365888480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PasteButton", "/@", 
  RowBox[{"CountryData", "[", "\"\<G8\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->662152396],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"Canada\"\>",
    BaseStyle->"Paste"], ",", 
   ButtonBox["\<\"France\"\>",
    BaseStyle->"Paste"], ",", 
   ButtonBox["\<\"Germany\"\>",
    BaseStyle->"Paste"], ",", 
   ButtonBox["\<\"Italy\"\>",
    BaseStyle->"Paste"], ",", 
   ButtonBox["\<\"Japan\"\>",
    BaseStyle->"Paste"], ",", 
   ButtonBox["\<\"Russia\"\>",
    BaseStyle->"Paste"], ",", 
   ButtonBox["\<\"UnitedKingdom\"\>",
    BaseStyle->"Paste"], ",", 
   ButtonBox["\<\"UnitedStates\"\>",
    BaseStyle->"Paste"]}], "}"}]], "Output",
 ImageSize->{457, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->906640147]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->69718096],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\[SelectionPlaceholder]"], "InlineFormula"],
 " to replace it with the current selection:"
}], "ExampleText",
 CellID->859908795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PasteButton", "[", 
  RowBox[{"Sqrt", "[", "\[SelectionPlaceholder]", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->590907686],

Cell[BoxData[
 ButtonBox[
  SqrtBox["\[SelectionPlaceholder]"],
  BaseStyle->"Paste"]], "Output",
 ImageSize->{33, 26},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->381787547]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->244797202],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PasteButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PasteButton"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->520037490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PasteButton", "[", "\"\<xxx\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288180852],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  BaseStyle->"Paste"]], "Output",
 ImageSize->{26, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->517891074]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<xxx\>\"", ",", 
   RowBox[{"NotebookWrite", "[", 
    RowBox[{
     RowBox[{"ButtonNotebook", "[", "]"}], ",", "\"\<\\\"xxx\\\"\>\""}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11651140],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/xxx",
  ButtonFrame->"DialogBox",
  ButtonFunction:>NotebookWrite[
    ButtonNotebook[], "\"xxx\""],
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{32, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->427118406]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->374633238],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PasteButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PasteButton"]], "InlineFormula"],
 " does not evaluate its arguments on each click:"
}], "ExampleText",
 CellID->484071818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ";", 
  RowBox[{"PasteButton", "[", 
   RowBox[{"\"\<xxx\>\"", ",", 
    RowBox[{"x", "++"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272416039],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  BaseStyle->"Paste",
  ButtonData->"0"]], "Output",
 ImageSize->{26, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124183205]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3123],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookApply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookApply"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hyperlink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hyperlink"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24287]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31395],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->31736767],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->435872452],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->413261735],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->29207258]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PasteButton - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 20.1792338}", "context" -> "System`", 
    "keywords" -> {
     "pasting formulae", "pasting graphics", "pasting replacement text", 
      "pasting text", "SelectionPlaceholder"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PasteButton[expr] represents a button that pastes expr whenever it is \
pressed. PasteButton[label, expr] displays with label on the button. ", 
    "synonyms" -> {"paste button"}, "title" -> "PasteButton", "type" -> 
    "Symbol", "uri" -> "ref/PasteButton"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8053, 255, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->42477684]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38667, 1502}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2371, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2994, 83, 1576, 37, 70, "ObjectNameGrid"],
Cell[4573, 122, 1017, 32, 70, "Usage",
 CellID->4202]
}, Open  ]],
Cell[CellGroupData[{
Cell[5627, 159, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6105, 176, 187, 6, 70, "Notes",
 CellID->23753],
Cell[6295, 184, 371, 12, 70, "Notes",
 CellID->22249],
Cell[6669, 198, 317, 10, 70, "Notes",
 CellID->5058],
Cell[6989, 210, 223, 7, 70, "Notes",
 CellID->16575],
Cell[7215, 219, 341, 10, 70, "Notes",
 CellID->8090],
Cell[7559, 231, 133, 5, 70, "Notes",
 CellID->24638],
Cell[7695, 238, 321, 12, 70, "Notes",
 CellID->6823]
}, Closed]],
Cell[CellGroupData[{
Cell[8053, 255, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->42477684],
Cell[CellGroupData[{
Cell[8437, 269, 148, 5, 70, "ExampleSection",
 CellID->571507636],
Cell[8588, 276, 88, 1, 70, "ExampleText",
 CellID->596779275],
Cell[CellGroupData[{
Cell[8701, 281, 107, 3, 28, "Input",
 CellID->665792386],
Cell[8811, 286, 193, 7, 40, "Output",
 CellID->116493174]
}, Open  ]],
Cell[9019, 296, 125, 3, 70, "ExampleDelimiter",
 CellID->453632767],
Cell[9147, 301, 68, 1, 70, "ExampleText",
 CellID->785320463],
Cell[CellGroupData[{
Cell[9240, 306, 140, 4, 70, "Input",
 CellID->726987488],
Cell[9383, 312, 222, 8, 70, "Output",
 CellID->541361442]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9654, 326, 216, 7, 70, "ExampleSection",
 CellID->14820],
Cell[CellGroupData[{
Cell[9895, 337, 240, 7, 70, "ExampleSubsection",
 CellID->144842811],
Cell[10138, 346, 73, 1, 70, "ExampleText",
 CellID->993536701],
Cell[CellGroupData[{
Cell[10236, 351, 624, 19, 70, "Input",
 CellID->1889358125],
Cell[10863, 372, 603, 23, 70, "Output",
 CellID->491022120]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11515, 401, 241, 7, 70, "ExampleSubsection",
 CellID->1540953033],
Cell[11759, 410, 78, 1, 70, "ExampleText",
 CellID->1274152426],
Cell[CellGroupData[{
Cell[11862, 415, 421, 13, 70, "Input",
 CellID->2120379545],
Cell[12286, 430, 373, 14, 70, "Output",
 CellID->102596757]
}, Open  ]],
Cell[12674, 447, 66, 1, 70, "ExampleText",
 CellID->90265984],
Cell[CellGroupData[{
Cell[12765, 452, 366, 12, 70, "Input",
 CellID->976938306],
Cell[13134, 466, 404, 15, 70, "Output",
 CellID->106807188]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[13599, 488, 222, 7, 70, "ExampleSection",
 CellID->279167576],
Cell[CellGroupData[{
Cell[13846, 499, 231, 7, 70, "ExampleSubsection",
 CellID->1440961975],
Cell[14080, 508, 82, 1, 70, "ExampleText",
 CellID->569627317],
Cell[CellGroupData[{
Cell[14187, 513, 565, 17, 70, "Input",
 CellID->618910655],
Cell[14755, 532, 758, 24, 70, "Output",
 CellID->279280199]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15562, 562, 230, 7, 70, "ExampleSubsection",
 CellID->22264276],
Cell[15795, 571, 249, 9, 70, "ExampleText",
 CellID->207020871],
Cell[CellGroupData[{
Cell[16069, 584, 366, 12, 70, "Input",
 CellID->449021595],
Cell[16438, 598, 355, 13, 70, "Output",
 CellID->174914568]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16842, 617, 231, 7, 70, "ExampleSubsection",
 CellID->194028038],
Cell[17076, 626, 72, 1, 70, "ExampleText",
 CellID->366214924],
Cell[CellGroupData[{
Cell[17173, 631, 381, 12, 70, "Input",
 CellID->528656858],
Cell[17557, 645, 561, 19, 70, "Output",
 CellID->946957111]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18167, 670, 235, 7, 70, "ExampleSubsection",
 CellID->5534595],
Cell[18405, 679, 74, 1, 70, "ExampleText",
 CellID->19113093],
Cell[CellGroupData[{
Cell[18504, 684, 486, 15, 70, "Input",
 CellID->340562913],
Cell[18993, 701, 777, 29, 70, "Output",
 CellID->9129975]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19819, 736, 227, 7, 70, "ExampleSubsection",
 CellID->73988460],
Cell[20049, 745, 212, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[20286, 757, 116, 3, 70, "Input",
 CellID->94729581],
Cell[20405, 762, 203, 7, 70, "Output",
 CellID->539456101]
}, Open  ]],
Cell[20623, 772, 124, 3, 70, "ExampleDelimiter",
 CellID->26745135],
Cell[20750, 777, 354, 12, 70, "ExampleText",
 CellID->576258550],
Cell[CellGroupData[{
Cell[21129, 793, 180, 5, 70, "Input",
 CellID->227336428],
Cell[21312, 800, 222, 8, 70, "Output",
 CellID->2110215520]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21583, 814, 229, 7, 70, "ExampleSubsection",
 CellID->97213496],
Cell[21815, 823, 104, 2, 70, "ExampleText",
 CellID->96906759],
Cell[CellGroupData[{
Cell[21944, 829, 118, 3, 70, "Input",
 CellID->1786402438],
Cell[22065, 834, 203, 7, 70, "Output",
 CellID->145285184]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22317, 847, 232, 7, 70, "ExampleSubsection",
 CellID->70979564],
Cell[22552, 856, 242, 8, 70, "ExampleText",
 CellID->592492429],
Cell[CellGroupData[{
Cell[22819, 868, 369, 12, 70, "Input",
 CellID->2099775161],
Cell[23191, 882, 506, 19, 70, "Output",
 CellID->153036230]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23746, 907, 233, 7, 70, "ExampleSubsection",
 CellID->308463628],
Cell[23982, 916, 233, 8, 70, "ExampleText",
 CellID->33301087],
Cell[CellGroupData[{
Cell[24240, 928, 421, 13, 70, "Input",
 CellID->23634922],
Cell[24664, 943, 661, 23, 70, "Output",
 CellID->91537179]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25374, 972, 230, 7, 70, "ExampleSubsection",
 CellID->347779171],
Cell[25607, 981, 60, 1, 70, "ExampleText",
 CellID->91656306],
Cell[CellGroupData[{
Cell[25692, 986, 381, 12, 70, "Input",
 CellID->234360116],
Cell[26076, 1000, 509, 19, 70, "Output",
 CellID->1254005492]
}, Open  ]],
Cell[26600, 1022, 125, 3, 70, "ExampleDelimiter",
 CellID->292736021],
Cell[26728, 1027, 60, 1, 70, "ExampleText",
 CellID->27069804],
Cell[CellGroupData[{
Cell[26813, 1032, 412, 13, 70, "Input",
 CellID->289053222],
Cell[27228, 1047, 581, 25, 70, "Output",
 CellID->594074714]
}, Open  ]],
Cell[27824, 1075, 123, 3, 70, "ExampleDelimiter",
 CellID->1372330],
Cell[27950, 1080, 112, 3, 70, "ExampleText",
 CellID->16996013],
Cell[CellGroupData[{
Cell[28087, 1087, 238, 7, 70, "Input",
 CellID->643525534],
Cell[28328, 1096, 233, 8, 70, "Output",
 CellID->962243295]
}, Open  ]],
Cell[28576, 1107, 125, 3, 70, "ExampleDelimiter",
 CellID->180520251],
Cell[28704, 1112, 68, 1, 70, "ExampleText",
 CellID->167047478],
Cell[CellGroupData[{
Cell[28797, 1117, 573, 19, 70, "Input",
 CellID->395912750],
Cell[29373, 1138, 901, 38, 70, "Output",
 CellID->45561038]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[30335, 1183, 223, 7, 70, "ExampleSection",
 CellID->12531],
Cell[30561, 1192, 98, 1, 70, "ExampleText",
 CellID->365888480],
Cell[CellGroupData[{
Cell[30684, 1197, 150, 4, 70, "Input",
 CellID->662152396],
Cell[30837, 1203, 692, 23, 70, "Output",
 CellID->906640147]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31578, 1232, 236, 7, 70, "ExampleSection",
 CellID->69718096],
Cell[31817, 1241, 169, 5, 70, "ExampleText",
 CellID->859908795],
Cell[CellGroupData[{
Cell[32011, 1250, 160, 4, 70, "Input",
 CellID->590907686],
Cell[32174, 1256, 227, 8, 70, "Output",
 CellID->381787547]
}, Open  ]],
Cell[32416, 1267, 125, 3, 70, "ExampleDelimiter",
 CellID->244797202],
Cell[32544, 1272, 326, 12, 70, "ExampleText",
 CellID->520037490],
Cell[CellGroupData[{
Cell[32895, 1288, 117, 3, 70, "Input",
 CellID->288180852],
Cell[33015, 1293, 203, 7, 70, "Output",
 CellID->517891074]
}, Open  ]],
Cell[CellGroupData[{
Cell[33255, 1305, 262, 8, 70, "Input",
 CellID->11651140],
Cell[33520, 1315, 381, 13, 70, "Output",
 CellID->427118406]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33950, 1334, 230, 7, 70, "ExampleSection",
 CellID->374633238],
Cell[34183, 1343, 230, 7, 70, "ExampleText",
 CellID->484071818],
Cell[CellGroupData[{
Cell[34438, 1354, 208, 7, 70, "Input",
 CellID->272416039],
Cell[34649, 1363, 222, 8, 70, "Output",
 CellID->124183205]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34932, 1378, 310, 9, 70, "SeeAlsoSection",
 CellID->3123],
Cell[35245, 1389, 704, 26, 70, "SeeAlso",
 CellID->24287]
}, Open  ]],
Cell[CellGroupData[{
Cell[35986, 1420, 314, 9, 70, "TutorialsSection",
 CellID->31395],
Cell[36303, 1431, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[36465, 1436, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[36650, 1444, 318, 9, 70, "MoreAboutSection",
 CellID->31736767],
Cell[36971, 1455, 141, 3, 70, "MoreAbout",
 CellID->435872452],
Cell[37115, 1460, 168, 3, 70, "MoreAbout",
 CellID->413261735],
Cell[37286, 1465, 127, 3, 70, "MoreAbout",
 CellID->29207258]
}, Open  ]],
Cell[37428, 1471, 27, 0, 70, "History"],
Cell[37458, 1473, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

