(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11087,        405]
NotebookOptionsPosition[      8008,        303]
NotebookOutlinePosition[      9378,        342]
CellTagsIndexPosition[      9294,        337]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Naming and Finding Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamingAndFindingFiles"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Naming and Finding Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$Path" :> Documentation`HelpLookup["paclet:ref/$Path"], 
          "SetDirectory" :> 
          Documentation`HelpLookup["paclet:ref/SetDirectory"], "$Input" :> 
          Documentation`HelpLookup["paclet:ref/$Input"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"$Path\"\>", 2->"\<\"SetDirectory\"\>", 
       3->"\<\"$Input\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Path", "ObjectName",
 CellID->20003],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Path",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Path"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Get",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Get"]], "InlineFormula"],
     " and related functions which gives a list of directories to search in \
attempting to find an external file. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5161]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"Path", ":>", 
   ButtonBox["$Path",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Path"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11896],

Cell[TextData[{
 "The possible settings for ",
 Cell[BoxData[
  ButtonBox["Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Path"]], "InlineFormula"],
 " are the same as those for ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26141]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->98331045],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->124333319],

Cell["When looking up a file, search a particular directory:", "ExampleText",
 CellID->213265492],

Cell[BoxData[
 RowBox[{
  RowBox[{"dir", " ", "=", " ", "$TemporaryPrefix"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91402715],

Cell["\<\
Create a file for this example so there is something to search for:\
\>", "ExampleText",
 CellID->186284614],

Cell[BoxData[
 RowBox[{"Put", "[", 
  RowBox[{
   RowBox[{"47", "!"}], ",", 
   RowBox[{"ToFileName", "[", 
    RowBox[{
     RowBox[{"{", "dir", "}"}], ",", "\"\<fact\>\""}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->42723088],

Cell["With the default system search path the file is not found:", \
"ExampleText",
 CellID->325290840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Get", "[", "\"\<fact\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->510661342],

Cell[BoxData[
 RowBox[{
  RowBox[{"Get", "::", "\<\"noopen\"\>"}], ":", 
  " ", "\<\"Cannot open \\!\\(\\\"fact\\\"\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/noopen\\\", ButtonNote -> \
\\\"Get::noopen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->131968370],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->421027787]
}, Open  ]],

Cell[TextData[{
 "The file is found when the ",
 Cell[BoxData[
  ButtonBox["Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Path"]], "InlineFormula"],
 " option is set to the directory:"
}], "ExampleText",
 CellID->528275575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Get", "[", 
  RowBox[{"\"\<fact\>\"", ",", 
   RowBox[{"Path", "\[Rule]", "dir"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->31938980],

Cell[BoxData["258623241511168180642964355153611979969197632389120000000000"], \
"Output",
 ImageSize->{465, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->197077374]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4770],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Path",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Path"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Input"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32313]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2150],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "Tutorials",
 CellID->28432]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Path - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 20.6167450}", "context" -> "System`", 
    "keywords" -> {
     "directories of files", "path for files", "search path", 
      "search path for files", "search path of directories"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Path is an option for Get and related functions which gives a list of \
directories to search in attempting to find an external file. ", 
    "synonyms" -> {}, "title" -> "Path", "type" -> "Symbol", "uri" -> 
    "ref/Path"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3788, 134, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->98331045]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9152, 330}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1373, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1996, 61, 42, 1, 70, "ObjectName",
 CellID->20003],
Cell[2041, 64, 634, 19, 70, "Usage",
 CellID->5161]
}, Open  ]],
Cell[CellGroupData[{
Cell[2712, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3190, 105, 221, 9, 70, "Notes",
 CellID->11896],
Cell[3414, 116, 337, 13, 70, "Notes",
 CellID->26141]
}, Closed]],
Cell[CellGroupData[{
Cell[3788, 134, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->98331045],
Cell[CellGroupData[{
Cell[4172, 148, 148, 5, 70, "ExampleSection",
 CellID->124333319],
Cell[4323, 155, 97, 1, 70, "ExampleText",
 CellID->213265492],
Cell[4423, 158, 136, 4, 70, "Input",
 CellID->91402715],
Cell[4562, 164, 118, 3, 70, "ExampleText",
 CellID->186284614],
Cell[4683, 169, 246, 9, 70, "Input",
 CellID->42723088],
Cell[4932, 180, 103, 2, 70, "ExampleText",
 CellID->325290840],
Cell[CellGroupData[{
Cell[5060, 186, 110, 3, 70, "Input",
 CellID->510661342],
Cell[5173, 191, 356, 7, 70, "Message",
 CellID->131968370],
Cell[5532, 200, 164, 5, 36, "Output",
 CellID->421027787]
}, Open  ]],
Cell[5711, 208, 233, 8, 70, "ExampleText",
 CellID->528275575],
Cell[CellGroupData[{
Cell[5969, 220, 167, 5, 70, "Input",
 CellID->31938980],
Cell[6139, 227, 220, 6, 36, "Output",
 CellID->197077374]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6420, 240, 310, 9, 70, "SeeAlsoSection",
 CellID->4770],
Cell[6733, 251, 694, 26, 70, "SeeAlso",
 CellID->32313]
}, Open  ]],
Cell[CellGroupData[{
Cell[7464, 282, 313, 9, 70, "TutorialsSection",
 CellID->2150],
Cell[7780, 293, 156, 3, 70, "Tutorials",
 CellID->28432]
}, Open  ]],
Cell[7951, 299, 27, 0, 70, "History"],
Cell[7981, 301, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

