(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16996,        600]
NotebookOptionsPosition[     13326,        475]
NotebookOutlinePosition[     14711,        514]
CellTagsIndexPosition[     14626,        509]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pattern sequences" :> 
          Documentation`HelpLookup["paclet:tutorial/PatternSequences"], 
          "Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Pattern sequences\"\>", 
       2->"\<\"Patterns and Transformation Rules\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Repeated" :> Documentation`HelpLookup["paclet:ref/Repeated"], 
          "Optional" :> Documentation`HelpLookup["paclet:ref/Optional"], 
          "Alternatives" :> 
          Documentation`HelpLookup["paclet:ref/Alternatives"], "Pattern" :> 
          Documentation`HelpLookup["paclet:ref/Pattern"], "Sequence" :> 
          Documentation`HelpLookup["paclet:ref/Sequence"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Repeated\"\>", 
       2->"\<\"Optional\"\>", 3->"\<\"Alternatives\"\>", 4->"\<\"Pattern\"\>",
        5->"\<\"Sequence\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"],
           "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Patterns\"\>", 
       2->"\<\"New in 6.0: Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PatternSequence", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PatternSequence",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PatternSequence"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["p", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["p", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]is a pattern object which represents a sequence of \
arguments matching ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7534]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PatternSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PatternSequence"], "[", "]"}]], "InlineFormula"],
 " represents a sequence of zero length."
}], "Notes",
 CellID->27770]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->534737057],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->430035128],

Cell["Replace a subsequence in a list:", "ExampleText",
 CellID->191203870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "a", ",", "b", ",", "c", ",", "d", ",", "c", ",", "d", ",", "a", ",", 
    "b"}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x__", ",", 
     RowBox[{"PatternSequence", "[", 
      RowBox[{"c", ",", "d", ",", "c"}], "]"}], ",", "y__"}], "}"}], 
   "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "y"}], "}"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->650702251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "0", ",", "d", ",", "a", ",", "b"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->256041523]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->400093388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "a", ",", "b", ",", "a", ",", "b", ",", "a", ",", "b", ",", "a", ",", "b", 
    ",", "a", ",", "b"}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PatternSequence", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ".."}], "}"}], "->", 
   RowBox[{"x", "+", "y"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1661],

Cell[BoxData[
 RowBox[{"a", "+", "b"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2432]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28221],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", "|", 
    RowBox[{"PatternSequence", "[", "]"}]}], "]"}], ":=", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16139],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32666]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22237],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "a", "}"}], ",", 
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", "|", 
     RowBox[{"PatternSequence", "[", "]"}]}], "}"}], "->", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24404],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7048]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20067],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Repeated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Repeated"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Optional",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Optional"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Alternatives",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Alternatives"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pattern"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30265]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2851],

Cell[TextData[ButtonBox["Pattern sequences",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternSequences"]], "Tutorials",
 CellID->13997],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->164035558],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->149912251],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->320043140]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PatternSequence - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 24.6949744}", "context" -> "System`", 
    "keywords" -> {
     "match sequentially", "repeated pattern", "sequence of patterns", 
      "zero or more patterns"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PatternSequence[p_1, p_2, ...] is a pattern object which represents a \
sequence of arguments matching p_1, p_2, ....", 
    "synonyms" -> {"pattern sequence"}, "title" -> "PatternSequence", "type" -> 
    "Symbol", "uri" -> "ref/PatternSequence"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6516, 192, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->534737057]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14483, 502}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2437, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3060, 82, 1580, 37, 70, "ObjectNameGrid"],
Cell[4643, 121, 1076, 36, 70, "Usage",
 CellID->7534]
}, Open  ]],
Cell[CellGroupData[{
Cell[5756, 162, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6234, 179, 245, 8, 70, "Notes",
 CellID->27770]
}, Closed]],
Cell[CellGroupData[{
Cell[6516, 192, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->534737057],
Cell[CellGroupData[{
Cell[6901, 206, 148, 5, 70, "ExampleSection",
 CellID->430035128],
Cell[7052, 213, 75, 1, 70, "ExampleText",
 CellID->191203870],
Cell[CellGroupData[{
Cell[7152, 218, 446, 15, 28, "Input",
 CellID->650702251],
Cell[7601, 235, 247, 8, 36, "Output",
 CellID->256041523]
}, Open  ]],
Cell[7863, 246, 125, 3, 70, "ExampleDelimiter",
 CellID->400093388],
Cell[CellGroupData[{
Cell[8013, 253, 391, 13, 28, "Input",
 CellID->1661],
Cell[8407, 268, 175, 6, 36, "Output",
 CellID->2432]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8631, 280, 216, 7, 70, "ExampleSection",
 CellID->28221],
Cell[8850, 289, 180, 6, 70, "Input",
 CellID->30160],
Cell[CellGroupData[{
Cell[9055, 299, 93, 3, 70, "Input",
 CellID->16139],
Cell[9151, 304, 154, 5, 36, "Output",
 CellID->32666]
}, Open  ]],
Cell[CellGroupData[{
Cell[9342, 314, 88, 3, 70, "Input",
 CellID->22237],
Cell[9433, 319, 154, 5, 36, "Output",
 CellID->32048]
}, Open  ]],
Cell[9602, 327, 121, 3, 70, "ExampleDelimiter",
 CellID->24848],
Cell[CellGroupData[{
Cell[9748, 334, 355, 13, 70, "Input",
 CellID->24404],
Cell[10106, 349, 257, 9, 36, "Output",
 CellID->7048]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10424, 365, 311, 9, 70, "SeeAlsoSection",
 CellID->20067],
Cell[10738, 376, 1192, 44, 70, "SeeAlso",
 CellID->30265]
}, Open  ]],
Cell[CellGroupData[{
Cell[11967, 425, 313, 9, 70, "TutorialsSection",
 CellID->2851],
Cell[12283, 436, 144, 3, 70, "Tutorials",
 CellID->13997],
Cell[12430, 441, 178, 3, 70, "Tutorials",
 CellID->244552785]
}, Open  ]],
Cell[CellGroupData[{
Cell[12645, 449, 319, 9, 70, "MoreAboutSection",
 CellID->164035558],
Cell[12967, 460, 128, 3, 70, "MoreAbout",
 CellID->149912251],
Cell[13098, 465, 156, 3, 70, "MoreAbout",
 CellID->320043140]
}, Open  ]],
Cell[13269, 471, 27, 0, 70, "History"],
Cell[13299, 473, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

