(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11739,        425]
NotebookOptionsPosition[      8919,        332]
NotebookOutlinePosition[     10267,        370]
CellTagsIndexPosition[     10182,        365]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"], "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Putting Constraints on Patterns\"\>", 
       2->"\<\"String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Condition" :> Documentation`HelpLookup["paclet:ref/Condition"],
           "Element" :> Documentation`HelpLookup["paclet:ref/Element"], 
          "Except" :> Documentation`HelpLookup["paclet:ref/Except"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Condition\"\>", 
       2->"\<\"Element\"\>", 3->"\<\"Except\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:guide/Patterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "PatternTest ",
 StyleBox["(?)", "OperatorCharacter"]
}], "ObjectName",
 CellID->397],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["p", "TI"], "?", 
       StyleBox["test", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]is a pattern object that stands for any expression \
which matches ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ", and on which the application of ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11096]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Any result for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["test", "TI"], "[", 
   StyleBox["pval", "TI"], "]"}]], "InlineFormula"],
 " other than ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " is taken to signify failure. "
}], "Notes",
 CellID->16594],

Cell[TextData[{
 "The operator ",
 Cell[BoxData["?"], "InlineFormula"],
 " has a high precedence. Thus ",
 Cell[BoxData[
  RowBox[{"_", "^", 
   RowBox[{"_", "?", "t"}]}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"_", "^", 
   RowBox[{"(", 
    RowBox[{"_", "?", "t"}], ")"}]}]], "InlineFormula"],
 " not ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"_", "^", "_"}], ")"}], "?", "t"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17653],

Cell[TextData[{
 "In a form such as ",
 Cell[BoxData[
  RowBox[{"__", "?", 
   StyleBox["test", "TI"]}]], "InlineFormula"],
 " every element in the sequence matched by ",
 Cell[BoxData["__"], "InlineFormula"],
 " must yield ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " when ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " is applied. "
}], "Notes",
 CellID->14520]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34455176],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->223879684],

Cell[TextData[{
 "Find cases of any expression which satisfies the ",
 Cell[BoxData[
  ButtonBox["NumberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberQ"]], "InlineFormula"],
 " test:"
}], "ExampleText",
 CellID->224061180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3.5", ",", "x", ",", "y", ",", "4"}], "}"}], 
   ",", 
   RowBox[{"_", "?", "NumberQ"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->377929560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3.5`", ",", "4"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12287935]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4953],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Condition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Condition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Except",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Except"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10824]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30503],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->13472],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->120061360],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->25106081]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PatternTest (?) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 25.3668666}", "context" -> "System`", 
    "keywords" -> {
     "pattern condition", "question mark", "restricted pattern"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "p?test is a pattern object that stands for any expression which matches \
p, and on which the application of test gives True. ", 
    "synonyms" -> {"pattern test", "?"}, "title" -> "PatternTest", "type" -> 
    "Symbol", "uri" -> "ref/PatternTest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5357, 188, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->34455176]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10040, 358}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2050, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2673, 77, 102, 4, 70, "ObjectName",
 CellID->397],
Cell[2778, 83, 765, 25, 70, "Usage",
 CellID->11096]
}, Open  ]],
Cell[CellGroupData[{
Cell[3580, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4058, 130, 338, 13, 70, "Notes",
 CellID->16594],
Cell[4399, 145, 464, 19, 70, "Notes",
 CellID->17653],
Cell[4866, 166, 454, 17, 70, "Notes",
 CellID->14520]
}, Closed]],
Cell[CellGroupData[{
Cell[5357, 188, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34455176],
Cell[CellGroupData[{
Cell[5741, 202, 148, 5, 70, "ExampleSection",
 CellID->223879684],
Cell[5892, 209, 235, 8, 70, "ExampleText",
 CellID->224061180],
Cell[CellGroupData[{
Cell[6152, 221, 249, 8, 28, "Input",
 CellID->377929560],
Cell[6404, 231, 225, 7, 36, "Output",
 CellID->12287935]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6690, 245, 310, 9, 70, "SeeAlsoSection",
 CellID->4953],
Cell[7003, 256, 692, 26, 70, "SeeAlso",
 CellID->10824]
}, Open  ]],
Cell[CellGroupData[{
Cell[7732, 287, 314, 9, 70, "TutorialsSection",
 CellID->30503],
Cell[8049, 298, 170, 3, 70, "Tutorials",
 CellID->13472],
Cell[8222, 303, 139, 3, 70, "Tutorials",
 CellID->8153]
}, Open  ]],
Cell[CellGroupData[{
Cell[8398, 311, 319, 9, 70, "MoreAboutSection",
 CellID->120061360],
Cell[8720, 322, 127, 3, 70, "MoreAbout",
 CellID->25106081]
}, Open  ]],
Cell[8862, 328, 27, 0, 70, "History"],
Cell[8892, 330, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

