(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12246,        443]
NotebookOptionsPosition[      9305,        343]
NotebookOutlinePosition[     10492,        378]
CellTagsIndexPosition[     10407,        373]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date and Time Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DateAndTimeFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Date and Time Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Animator" :> Documentation`HelpLookup["paclet:ref/Animator"], 
          "FinishDynamic" :> 
          Documentation`HelpLookup["paclet:ref/FinishDynamic"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Animator\"\>", 
       2->"\<\"FinishDynamic\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Input & Output in Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/BasicInputAndOutputInPrograms"], "Flow Control" :> 
          Documentation`HelpLookup["paclet:guide/FlowControl"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Basic Input & Output in Programs\"\>", 
       2->"\<\"Flow Control\"\>", 
       3->"\<\"Procedural Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Pause", "ObjectName",
 CellID->14812],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Pause",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Pause"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]pauses for at least ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " seconds. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20641]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Pause",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pause"]], "InlineFormula"],
 " is accurate only down to a granularity of at least ",
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 " seconds. "
}], "Notes",
 CellID->25304],

Cell[TextData[{
 "The time elapsed during the execution of ",
 Cell[BoxData[
  ButtonBox["Pause",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pause"]], "InlineFormula"],
 " is counted in ",
 Cell[BoxData[
  ButtonBox["SessionTime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SessionTime"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AbsoluteTiming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteTiming"]], "InlineFormula"],
 ", but not in ",
 Cell[BoxData[
  ButtonBox["TimeUsed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeUsed"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Timing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Timing"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4496],

Cell[TextData[{
 "Under multitasking operating systems, there may be a delay of significantly \
more than ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " seconds when you execute ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Pause",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pause"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->60543918],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->218761809],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Pause",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pause"]], "InlineFormula"],
 " takes no cpu time:"
}], "ExampleText",
 CellID->152977156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Pause", "[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->605675000],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.6375789613221059`*^-15", ",", "Null"}], "}"}]], "Output",
 ImageSize->{147, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52100084]
}, Open  ]],

Cell["It does use wall clock time:", "ExampleText",
 CellID->103598275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Pause", "[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->225327683],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0001728`7.4516200330992115", ",", "Null"}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->163422277]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31565],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Animator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FinishDynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FinishDynamic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12537],

Cell[TextData[ButtonBox["Date and Time Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DateAndTimeFunctions"]], "Tutorials",
 CellID->18551]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->242252572],

Cell[TextData[ButtonBox["Basic Input & Output in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], "MoreAbout",
 CellID->419375256],

Cell[TextData[ButtonBox["Flow Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "MoreAbout",
 CellID->108138499],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->418542174]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pause - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 26.0075080}", "context" -> "System`", 
    "keywords" -> {"alarm", "sleep", "suspend", "wait"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Pause[n] pauses for at least n seconds. ", "synonyms" -> {}, "title" -> 
    "Pause", "type" -> "Symbol", "uri" -> "ref/Pause"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5455, 187, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->60543918]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10265, 366}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2189, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2812, 81, 43, 1, 70, "ObjectName",
 CellID->14812],
Cell[2858, 84, 540, 18, 70, "Usage",
 CellID->20641]
}, Open  ]],
Cell[CellGroupData[{
Cell[3435, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3913, 124, 349, 12, 70, "Notes",
 CellID->25304],
Cell[4265, 138, 755, 28, 70, "Notes",
 CellID->4496],
Cell[5023, 168, 395, 14, 70, "Notes",
 CellID->23162]
}, Closed]],
Cell[CellGroupData[{
Cell[5455, 187, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->60543918],
Cell[CellGroupData[{
Cell[5839, 201, 148, 5, 70, "ExampleSection",
 CellID->218761809],
Cell[5990, 208, 190, 7, 70, "ExampleText",
 CellID->152977156],
Cell[CellGroupData[{
Cell[6205, 219, 134, 4, 28, "Input",
 CellID->605675000],
Cell[6342, 225, 229, 7, 39, "Output",
 CellID->52100084]
}, Open  ]],
Cell[6586, 235, 71, 1, 70, "ExampleText",
 CellID->103598275],
Cell[CellGroupData[{
Cell[6682, 240, 142, 4, 28, "Input",
 CellID->225327683],
Cell[6827, 246, 234, 7, 36, "Output",
 CellID->163422277]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7122, 260, 311, 9, 70, "SeeAlsoSection",
 CellID->31565],
Cell[7436, 271, 461, 17, 70, "SeeAlso",
 CellID->18938]
}, Open  ]],
Cell[CellGroupData[{
Cell[7934, 293, 314, 9, 70, "TutorialsSection",
 CellID->12537],
Cell[8251, 304, 154, 3, 70, "Tutorials",
 CellID->18551]
}, Open  ]],
Cell[CellGroupData[{
Cell[8442, 312, 319, 9, 70, "MoreAboutSection",
 CellID->242252572],
Cell[8764, 323, 173, 3, 70, "MoreAbout",
 CellID->419375256],
Cell[8940, 328, 135, 3, 70, "MoreAbout",
 CellID->108138499],
Cell[9078, 333, 155, 3, 70, "MoreAbout",
 CellID->418542174]
}, Open  ]],
Cell[9248, 339, 27, 0, 70, "History"],
Cell[9278, 341, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

