(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36264,       1081]
NotebookOptionsPosition[     31432,        917]
NotebookOutlinePosition[     33005,        958]
CellTagsIndexPosition[     32920,        953]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Ordering in Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/OrderingInLists"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Ordering in Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sort" :> Documentation`HelpLookup["paclet:ref/Sort"], 
          "Signature" :> Documentation`HelpLookup["paclet:ref/Signature"], 
          "RandomSample" :> 
          Documentation`HelpLookup["paclet:ref/RandomSample"], "Tuples" :> 
          Documentation`HelpLookup["paclet:ref/Tuples"], "Reverse" :> 
          Documentation`HelpLookup["paclet:ref/Reverse"], "RotateLeft" :> 
          Documentation`HelpLookup["paclet:ref/RotateLeft"], "Factorial" :> 
          Documentation`HelpLookup["paclet:ref/Factorial"], "Subfactorial" :> 
          Documentation`HelpLookup["paclet:ref/Subfactorial"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Sort\"\>", 2->"\<\"Signature\"\>", 
       3->"\<\"RandomSample\"\>", 4->"\<\"Tuples\"\>", 5->"\<\"Reverse\"\>", 
       6->"\<\"RotateLeft\"\>", 7->"\<\"Factorial\"\>", 
       8->"\<\"Subfactorial\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ListManipulation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Discrete Mathematics\"\>", 
       3->"\<\"Rearranging & Restructuring Lists\"\>", 
       4->"\<\"New in 6.0: List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Permutations", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Permutations",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Permutations"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list of all possible permutations of the \
elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Permutations",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Permutations"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives all permutations containing at most ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Permutations",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Permutations"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         StyleBox["n", "TI"], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives all permutations containing exactly ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->11957]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "There are ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "!"}]], "InlineFormula"],
 " permutations of a list of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " distinct elements. "
}], "Notes",
 CellID->15503],

Cell[TextData[{
 "Repeated elements are treated as identical. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->28224,
  ButtonNote->"28224"]
}], "Notes",
 CellID->19491],

Cell[TextData[{
 "The object ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " need not have head ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10482],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Permutations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Permutations"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is effectively equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Permutations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Permutations"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Length",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Length"], "[", 
      StyleBox["list", "TI"], "]"}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->41953822],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Permutations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Permutations"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives permutations of between ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " elements."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->998249111]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->210943267],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->408720793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Permutations", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25032],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "b", ",", "a"}], "}"}]}], "}"}]], "Output",
 ImageSize->{419, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18102]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20476],

Cell["Repeated elements are treated as identical:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->28224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Permutations", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "a", ",", "b"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9081],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a", ",", "a"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31623],

Cell["Use any expressions as elements:", "ExampleText",
 CellID->27632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Permutations", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "2"}], ",", 
    RowBox[{"x", "+", "1"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     SuperscriptBox["x", "2"], ",", 
     RowBox[{"1", "+", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"1", "+", "x"}], ",", 
     SuperscriptBox["x", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "2"], ",", "x", ",", 
     RowBox[{"1", "+", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "2"], ",", 
     RowBox[{"1", "+", "x"}], ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", "x", ",", 
     SuperscriptBox["x", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", 
     SuperscriptBox["x", "2"], ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{569, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22602]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Permutations", "[", 
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3282],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "c", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "a", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "c", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "a", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "b", ",", "a"}], "]"}]}], "}"}]], "Output",
 ImageSize->{461, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19989]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Permutations", "[", 
  RowBox[{"Range", "[", "5", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3179],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{528, 407},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->488628741]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Permutations", "[", 
   RowBox[{"Range", "[", "5", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23399],

Cell[BoxData["120"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28350]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"5", "!"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30132],

Cell[BoxData["120"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28945]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8496],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Signature",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Signature"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomSample",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomSample"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tuples",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tuples"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotateLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotateLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factorial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factorial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subfactorial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subfactorial"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2829],

Cell[TextData[ButtonBox["Ordering in Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrderingInLists"]], "Tutorials",
 CellID->27027]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Permutations",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Permutations"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->182590940],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->889308962],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->99509805],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->370565935],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->405158384]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Permutations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 28.3825688}", "context" -> "System`", 
    "keywords" -> {
     "k-subsets", "perm", "permutations of lists", "permute", 
      "rearrangements", "reordering of lists", "reorderings", 
      "selecting objects with ordering", "subset permutations"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Permutations[list] generates a list of all possible permutations of the \
elements in list. Permutations[list, n] gives all permutations containing at \
most n elements. Permutations[list, {n}] gives all permutations containing \
exactly n elements.", "synonyms" -> {}, "title" -> "Permutations", "type" -> 
    "Symbol", "uri" -> "ref/Permutations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12212, 345, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->210943267]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32776, 946}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2965, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3588, 92, 4196, 83, 70, "ObjectNameGrid"],
Cell[7787, 177, 1527, 48, 70, "Usage",
 CellID->11957]
}, Open  ]],
Cell[CellGroupData[{
Cell[9351, 230, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9829, 247, 248, 10, 70, "Notes",
 CellID->15503],
Cell[10080, 259, 198, 7, 70, "Notes",
 CellID->19491],
Cell[10281, 268, 262, 11, 70, "Notes",
 CellID->10482],
Cell[10546, 281, 775, 26, 70, "Notes",
 CellID->41953822],
Cell[11324, 309, 851, 31, 70, "Notes",
 CellID->998249111]
}, Closed]],
Cell[CellGroupData[{
Cell[12212, 345, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->210943267],
Cell[CellGroupData[{
Cell[12597, 359, 148, 5, 70, "ExampleSection",
 CellID->408720793],
Cell[CellGroupData[{
Cell[12770, 368, 161, 5, 28, "Input",
 CellID->25032],
Cell[12934, 375, 594, 19, 36, "Output",
 CellID->18102]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13577, 400, 216, 7, 70, "ExampleSection",
 CellID->20476],
Cell[13796, 409, 130, 2, 70, "ExampleText",
 CellID->28224],
Cell[CellGroupData[{
Cell[13951, 415, 160, 5, 70, "Input",
 CellID->9081],
Cell[14114, 422, 387, 13, 36, "Output",
 CellID->22195]
}, Open  ]],
Cell[14516, 438, 121, 3, 70, "ExampleDelimiter",
 CellID->31623],
Cell[14640, 443, 71, 1, 70, "ExampleText",
 CellID->27632],
Cell[CellGroupData[{
Cell[14736, 448, 211, 7, 70, "Input",
 CellID->28343],
Cell[14950, 457, 912, 31, 39, "Output",
 CellID->22602]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15911, 494, 239, 7, 70, "ExampleSection",
 CellID->15369],
Cell[CellGroupData[{
Cell[16175, 505, 165, 5, 70, "Input",
 CellID->3282],
Cell[16343, 512, 624, 19, 36, "Output",
 CellID->19989]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17016, 537, 223, 7, 70, "ExampleSection",
 CellID->21599],
Cell[CellGroupData[{
Cell[17264, 548, 135, 4, 70, "Input",
 CellID->3179],
Cell[17402, 554, 8500, 143, 70, "Output",
 Evaluatable->False,
 CellID->488628741]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25951, 703, 233, 7, 70, "ExampleSection",
 CellID->24652],
Cell[CellGroupData[{
Cell[26209, 714, 170, 5, 70, "Input",
 CellID->23399],
Cell[26382, 721, 156, 5, 36, "Output",
 CellID->28350]
}, Open  ]],
Cell[CellGroupData[{
Cell[26575, 731, 83, 3, 70, "Input",
 CellID->30132],
Cell[26661, 736, 156, 5, 36, "Output",
 CellID->28945]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26878, 748, 310, 9, 70, "SeeAlsoSection",
 CellID->8496],
Cell[27191, 759, 1930, 71, 70, "SeeAlso",
 CellID->5646]
}, Open  ]],
Cell[CellGroupData[{
Cell[29158, 835, 313, 9, 70, "TutorialsSection",
 CellID->2829],
Cell[29474, 846, 143, 3, 70, "Tutorials",
 CellID->27027]
}, Open  ]],
Cell[CellGroupData[{
Cell[29654, 854, 305, 8, 70, "RelatedLinksSection"],
Cell[29962, 864, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30368, 881, 319, 9, 70, "MoreAboutSection",
 CellID->182590940],
Cell[30690, 892, 147, 3, 70, "MoreAbout",
 CellID->889308962],
Cell[30840, 897, 150, 3, 70, "MoreAbout",
 CellID->99509805],
Cell[30993, 902, 177, 3, 70, "MoreAbout",
 CellID->370565935],
Cell[31173, 907, 164, 3, 70, "MoreAbout",
 CellID->405158384]
}, Open  ]],
Cell[31352, 913, 50, 0, 70, "History"],
Cell[31405, 915, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

