(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30110,       1118]
NotebookOptionsPosition[     23298,        873]
NotebookOutlinePosition[     24569,        911]
CellTagsIndexPosition[     24484,        906]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Mathematical Constants" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalConstants"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Mathematical Constants\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Degree" :> Documentation`HelpLookup["paclet:ref/Degree"], "E" :> 
          Documentation`HelpLookup["paclet:ref/E"], "N" :> 
          Documentation`HelpLookup["paclet:ref/N"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Degree\"\>", 2->"\<\"E\"\>", 
       3->"\<\"N\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Constants" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalConstants"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Mathematical Constants\"\>", 
       2->"\<\"Mathematical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Pi ",
 StyleBox["(\[Pi])", "OperatorCharacter"]
}], "ObjectName",
 CellID->25816],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Pi",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
     " \[LineSeparator]is ",
     Cell[BoxData[
      StyleBox["\[Pi]", "TR"]], "InlineFormula"],
     ", with numerical value ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[TildeEqual]", "3.14159"}], TraditionalForm]], "InlineMath"],
     
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8884]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Mathematical constant treated as numeric by ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " and as a constant by ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20373],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 " can be evaluated to any numerical precision using ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20031],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 " can be entered in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData["\[Pi]"], "InlineFormula"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]pi\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]p\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Pi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Pi"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->22604],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 " is printed as ",
 Cell[BoxData["\[Pi]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9783]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->305293763],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->203903766],

Cell[TextData[{
 "Pi can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]p\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->31657],

Cell[CellGroupData[{

Cell[BoxData["Pi"], "Input",
 CellLabel->"In[1]:=",
 CellID->4141],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->289509749]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8477],

Cell["Evaluate to any precision:", "ExampleText",
 CellID->14023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27272],

Cell[BoxData["3.\
1415926535897932384626433832795028841971693993751058209849474090732`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162141916]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11435],

Cell["Do an exact numerical computation:", "ExampleText",
 CellID->13549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"Pi", "^", "100"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12517],

Cell[BoxData["51878483143196131920862615246303013562686760680406"], "Output",
 ImageSize->{388, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->209838339]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30867],

Cell[TextData[{
 "Find the millionth digit of ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 " in base 10:"
}], "ExampleText",
 CellID->219286146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"RealDigits", "[", 
   RowBox[{"Pi", ",", "10", ",", "1", ",", 
    RowBox[{"-", 
     RowBox[{"10", "^", "6"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131027014],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41792725]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12891],

Cell["Find an area of a circle:", "ExampleText",
 CellID->157653732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[LessEqual]", 
     RowBox[{"r", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"r", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177851900],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", 
  SuperscriptBox["r", "2"]}]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->390134065]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->782623707],

Cell[TextData[{
 "The first 20 digits of ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 " in base 10:"
}], "ExampleText",
 CellID->30369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"Pi", ",", "10", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1538],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "3", ",", "1", ",", "4", ",", "1", ",", "5", ",", "9", ",", "2", ",", "6",
      ",", "5", ",", "3", ",", "5", ",", "8", ",", "9", ",", "7", ",", "9", 
     ",", "3", ",", "2", ",", "3", ",", "8", ",", "4"}], "}"}], ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388306978]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"Pi", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32212],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "7", ",", "15", ",", "1", ",", "292", ",", "1", ",", "1", ",", 
   "1", ",", "2", ",", "1", ",", "3", ",", "1", ",", "14", ",", "2", ",", "1",
    ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248114803]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12693],

Cell["Trigonometric functions have arguments in radians:", "ExampleText",
 CellID->23409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Pi", "/", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11620],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["2"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51642709]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22662],

Cell[TextData[{
 "Many mathematical functions and operations give results involving ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zeta", "[", "2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16100],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "2"], "6"]], "Output",
 ImageSize->{22, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34565602]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10842],

Cell[BoxData[
 SqrtBox["\[Pi]"]], "Output",
 ImageSize->{29, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48489962]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10089],

Cell["Various symbolic relations are automatically used:", "ExampleText",
 CellID->29494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pi", ">", "3"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22642],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->209764144]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pi", "\[Element]", "Algebraics"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21486],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->664817]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27964],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 " is treated as a constant in differentiation:"
}], "ExampleText",
 CellID->11486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{"Pi", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1271],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->821377311]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3445],

Cell[TextData[{
 "Walk corresponding to the binary digits of ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->11788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Accumulate", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "^", 
    RowBox[{"First", "[", 
     RowBox[{"RealDigits", "[", 
      RowBox[{"Pi", ",", "2", ",", "200"}], "]"}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17349],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd1k1OFFEUxfEXRw4dOHDgoCTGGGOM39/Ko0UEkQ9bBUWFAkFw5BbuUmon
vqHLqCW4BDV9Dsn9d0JuDr/cuq+7q9+rSwc/p0dnSim///39r7PXn3nVX/pH
VW2zcrZmP2fX6zz8AvyiXXM6+Bz8sl31Ss3ruFrzOq7Br6P/Bq5/E/NvYf23
7W1W7sDvwu95vvJ9+AP4Q/gj+GP4E/hT+DOs77ldr3l4zR7O/nwW7LMaC/AJ
3Nmf/wtVfT/h7PtkEb4Ifwl39vWX4EvwV3BnX39ZVfdpLMNX0L8Cf41+Z9/n
q6q6z2MV/gbuPKe6pqrfQazB19G/Dt+Ab8A38/XrZvZwVn+Dl7fod9bvNOAN
Xqaq+h3XafZwdj+8vEO/s/aBgDdn979Hv7P74c3Z/R/Q7+x+Z+1DDV62stet
7AFvzt7HtlW1j9Xt7AFv8PIR8509H96c3f8J8521j4az9tHm7H10R1X7aN3J
Hs7uh5fP2auz5zv7/cPLF/Q7e76z1tecvc9/xfqd3e/s9cPLLvp3s4ez++Fl
D+vfyx7OXr+z199n7/rs1VnnWA8P+ABv8NHZ5+B+9m4/e3XWOdk765wMZ52T
g7POyeasc3KEl4PsnbPO0Qrv4eGsc3aAN/SPzp7/DfOdPd9Z1++ddY6Hs87t
Ad7go/LpOX+oqnO9O8xe4b1dOewTzYc3+AgvR9k7ZT9HVHhv93z4gP4GH9Ff
vqv6/Sufvn+7cg8P9A/whv4RXo4x/zivr8J7u+fb/f3DG3yElxPMP8F8+0Tz
7cph13PdYFdudj3XjfDy49T/AuqcJEU=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  PlotRange->{{0., 200.}, {-3., 40.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{364, 221},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{Automatic, Automatic}},
 CellLabel->"Out[1]=",
 CellID->72039018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30954],

Cell["Terms in the continued fraction:", "ExampleText",
 CellID->31504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"ContinuedFraction", "[", 
    RowBox[{"Pi", ",", "400"}], "]"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3281],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd2EmuXDUUgGHDiGENGDDI4PKEEEIoKvqeODQJhCZFCEnoLyGPJoG8AhIC
YuIl1BK8hFqCl1BL8BJqCQjV+Z/kPxPryznurn19Xe/xmydXjh9OKW0eSun/
8vBvf+5QPpLjP6I8k8f/PxvlIo/1Hj04/xH//5jiZ+RJPlK/Tyj+pMbxlOJP
h59RSXtnlb+Un1X+c/Lz8gvyi2rvpfDnUb6s/FeU/6r8msb9epTM/40omfeb
qv9WmHU6p/5zlLFORU7nD2W7EfHzav/tsb0ip3fUPmb870YZ+6Zg2n9vdMGM
70KUsY/KhTE/XQzHvisXFX9f48eM7wPVx9S/pPqXFP9Q48fs248Ul9PHimPG
94nicroc5vlcVnw1OmPmo3jDPP9PVV8uONa3YfbHldEZx/wKpn/lp8+ijP2d
5YLjPW+Y+V89eLoV9cPso3JV/WO/18wf8/zkpvx0TeO/NsYLpj7m3Liu/q+P
+UXxhtk/N1QfU1/xJqcvwnFOZ0x9zPpjzqMv1T+mvtww342vVB9znmDqy+nr
KOOczZjnj2O8TfH0jfrHvG+Y/jHn2LdjPGP6x3H+NMz6fTc6Y+rLDfMdnsf+
J8x+xEeHcsach6pfcYyn4ei/h0/Pue/H+ITju5sVn3GMp+D4LlflNxzj62o/
3VT/mOeJY74zju9qUf0qN7mr/fTD6EnOmPlj3g8c+60qv8ld9dOtMc45yH0j
Kz5j+sdx/6jKb8rviqfjcOy36XiMZxzfy1nxIlfM/pM75t7041h/wpxnOOrP
mPnjuAdWtdfkLqef1D/m/VN8lotcMectZv6Y9f9Z/eP4vmfFZ8z3VfGK45xq
mPVXfvpF/WP2v+Izjnt0Ubzi2L9N8a720+0o4/2ebo/5Gcf9YVa8YM4/xRuO
3wVd+enOmD/J+c6YP+OjQ1mUX3GsX8OxXj18+h34Ncr4nTRhfsdhnj/mfoZ5
/zHfKxzj7Wov/TZ6krM8ywXHeCvme638Lqe743ymu2M8yzOO31lF9avym9wx
638yejoZ8zPm/FG8yFVuqt8VT+vRCxzn34Sj/lL5WfGV4jOO+a0VLzjO943i
Fcd6bhVv8k7u8h5z//l9jC/kCcf4l4pnHH+XWGHWS/lrzP1J8Q2O+VbFtzh+
pzYc59NO+V3t7XG8L4m/08T8Fpj5y0vM9wmz/sqf1f5a+UX5G+VXeav8pvgO
x/w6ju/zXvXTn6MXOOpPOOa7VH4O538P5Yp43Mdm5a8x9wd5o/wqb+Um7+Su
+ewVT/fG/hf3xviEef8x9wPM/sfxvGbVX6v9Im/kqvFtMfcb9bfT+Do+OpR7
tZ/uj+0t7o/xSfEl5n6s/BWO5zHj+L2+xtyf5I36q5j5q7+m+jvFO47nsVc8
/TV6IU+Y/Y+5n+EY30qe1d5aLsrfKF5x/N1ri1l/5e/UXld8r3h6MMYX8vRg
zF/KGcd5vlL9Gcd+WSteMOuP+T2n/K3cVH+n8XXl7+X09+gF5j6k+FLO8gqz
/oqv5SJv5Cpv8dGhbIrvMPddzWeP+Xv6P6f1/wP5JLfb
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{229, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->195648136]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->568],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/E"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5994]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15791],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->25422],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathematicalConstants"]], "Tutorials",
 CellID->8010]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->20987],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#12154"], None}]], "RelatedLinks",
 CellID->196037434],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Pi.html"], None}], "IT"]], "RelatedLinks",\

 CellID->244083008],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Constants/Pi/"], None}]], "RelatedLinks",\

 CellID->576306042]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->308541622],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalConstants"]], "MoreAbout",
 CellID->29047720],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->500862083]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pi (\[Pi]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 34.7889828}", "context" -> "System`", 
    "keywords" -> {
     "Chudnovsky formula", "M_PI", "M_PI_2", "M_PI_4", "M_1_PI", "M_2_PI", 
      "M_2_SQRTPI"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Pi is \\[Pi], with numerical value \\[TildeEqual] 3.14159. ", 
    "synonyms" -> {}, "title" -> "Pi", "type" -> "Symbol", "uri" -> 
    "ref/Pi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6008, 211, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->305293763]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24341, 899}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2225, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2848, 80, 99, 4, 70, "ObjectName",
 CellID->25816],
Cell[2950, 86, 605, 21, 70, "Usage",
 CellID->8884]
}, Open  ]],
Cell[CellGroupData[{
Cell[3592, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4070, 129, 350, 13, 70, "Notes",
 CellID->20373],
Cell[4423, 144, 317, 12, 70, "Notes",
 CellID->20031],
Cell[4743, 158, 865, 31, 70, "Notes",
 CellID->22604],
Cell[5611, 191, 360, 15, 70, "Notes",
 CellID->9783]
}, Closed]],
Cell[CellGroupData[{
Cell[6008, 211, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->305293763],
Cell[CellGroupData[{
Cell[6393, 225, 148, 5, 70, "ExampleSection",
 CellID->203903766],
Cell[6544, 232, 195, 7, 70, "ExampleText",
 CellID->31657],
Cell[CellGroupData[{
Cell[6764, 243, 66, 2, 28, "Input",
 CellID->4141],
Cell[6833, 247, 162, 5, 36, "Output",
 CellID->289509749]
}, Open  ]],
Cell[7010, 255, 120, 3, 70, "ExampleDelimiter",
 CellID->8477],
Cell[7133, 260, 65, 1, 70, "ExampleText",
 CellID->14023],
Cell[CellGroupData[{
Cell[7223, 265, 118, 4, 70, "Input",
 CellID->27272],
Cell[7344, 271, 235, 7, 36, "Output",
 CellID->162141916]
}, Open  ]],
Cell[7594, 281, 121, 3, 70, "ExampleDelimiter",
 CellID->11435],
Cell[7718, 286, 73, 1, 70, "ExampleText",
 CellID->13549],
Cell[CellGroupData[{
Cell[7816, 291, 123, 4, 70, "Input",
 CellID->12517],
Cell[7942, 297, 208, 5, 36, "Output",
 CellID->209838339]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8199, 308, 216, 7, 70, "ExampleSection",
 CellID->30867],
Cell[8418, 317, 164, 6, 70, "ExampleText",
 CellID->219286146],
Cell[CellGroupData[{
Cell[8607, 327, 231, 7, 70, "Input",
 CellID->131027014],
Cell[8841, 336, 179, 6, 36, "Output",
 CellID->41792725]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9069, 348, 223, 7, 70, "ExampleSection",
 CellID->12891],
Cell[9295, 357, 68, 1, 70, "ExampleText",
 CellID->157653732],
Cell[CellGroupData[{
Cell[9388, 362, 576, 18, 70, "Input",
 CellID->177851900],
Cell[9967, 382, 208, 7, 36, "Output",
 CellID->390134065]
}, Open  ]],
Cell[10190, 392, 125, 3, 70, "ExampleDelimiter",
 CellID->782623707],
Cell[10318, 397, 155, 6, 70, "ExampleText",
 CellID->30369],
Cell[CellGroupData[{
Cell[10498, 407, 137, 4, 70, "Input",
 CellID->1538],
Cell[10638, 413, 453, 13, 36, "Output",
 CellID->388306978]
}, Open  ]],
Cell[11106, 429, 121, 3, 70, "ExampleDelimiter",
 CellID->13776],
Cell[CellGroupData[{
Cell[11252, 436, 134, 4, 70, "Input",
 CellID->32212],
Cell[11389, 442, 399, 10, 36, "Output",
 CellID->248114803]
}, Open  ]],
Cell[11803, 455, 121, 3, 70, "ExampleDelimiter",
 CellID->12693],
Cell[11927, 460, 89, 1, 70, "ExampleText",
 CellID->23409],
Cell[CellGroupData[{
Cell[12041, 465, 119, 4, 70, "Input",
 CellID->11620],
Cell[12163, 471, 189, 7, 55, "Output",
 CellID->51642709]
}, Open  ]],
Cell[12367, 481, 121, 3, 70, "ExampleDelimiter",
 CellID->22662],
Cell[12491, 486, 187, 6, 70, "ExampleText",
 CellID->25128],
Cell[CellGroupData[{
Cell[12703, 496, 96, 3, 70, "Input",
 CellID->16100],
Cell[12802, 501, 205, 7, 54, "Output",
 CellID->34565602]
}, Open  ]],
Cell[CellGroupData[{
Cell[13044, 513, 295, 10, 70, "Input",
 CellID->10842],
Cell[13342, 525, 172, 6, 38, "Output",
 CellID->48489962]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13563, 537, 233, 7, 70, "ExampleSection",
 CellID->10089],
Cell[13799, 546, 89, 1, 70, "ExampleText",
 CellID->29494],
Cell[CellGroupData[{
Cell[13913, 551, 89, 3, 70, "Input",
 CellID->22642],
Cell[14005, 556, 161, 5, 36, "Output",
 CellID->209764144]
}, Open  ]],
Cell[CellGroupData[{
Cell[14203, 566, 107, 3, 70, "Input",
 CellID->21486],
Cell[14313, 571, 159, 5, 36, "Output",
 CellID->664817]
}, Open  ]],
Cell[14487, 579, 121, 3, 70, "ExampleDelimiter",
 CellID->27964],
Cell[14611, 584, 206, 7, 70, "ExampleText",
 CellID->11486],
Cell[CellGroupData[{
Cell[14842, 595, 117, 4, 70, "Input",
 CellID->1271],
Cell[14962, 601, 158, 5, 36, "Output",
 CellID->821377311]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15169, 612, 223, 7, 70, "ExampleSection",
 CellID->3445],
Cell[15395, 621, 164, 6, 70, "ExampleText",
 CellID->11788],
Cell[CellGroupData[{
Cell[15584, 631, 328, 11, 70, "Input",
 CellID->17349],
Cell[15915, 644, 1348, 31, 242, "Output",
 CellID->72039018]
}, Open  ]],
Cell[17278, 678, 121, 3, 70, "ExampleDelimiter",
 CellID->30954],
Cell[17402, 683, 71, 1, 70, "ExampleText",
 CellID->31504],
Cell[CellGroupData[{
Cell[17498, 688, 234, 7, 70, "Input",
 CellID->3281],
Cell[17735, 697, 2057, 41, 161, "Output",
 CellID->195648136]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19853, 745, 309, 9, 70, "SeeAlsoSection",
 CellID->568],
Cell[20165, 756, 663, 26, 70, "SeeAlso",
 CellID->5994]
}, Open  ]],
Cell[CellGroupData[{
Cell[20865, 787, 314, 9, 70, "TutorialsSection",
 CellID->15791],
Cell[21182, 798, 163, 3, 70, "Tutorials",
 CellID->25422],
Cell[21348, 803, 153, 3, 70, "Tutorials",
 CellID->8010]
}, Open  ]],
Cell[CellGroupData[{
Cell[21538, 811, 321, 9, 70, "RelatedLinksSection",
 CellID->20987],
Cell[21862, 822, 271, 6, 70, "RelatedLinks",
 CellID->196037434],
Cell[22136, 830, 191, 5, 70, "RelatedLinks",
 CellID->244083008],
Cell[22330, 837, 202, 5, 70, "RelatedLinks",
 CellID->576306042]
}, Open  ]],
Cell[CellGroupData[{
Cell[22569, 847, 319, 9, 70, "MoreAboutSection",
 CellID->308541622],
Cell[22891, 858, 154, 3, 70, "MoreAbout",
 CellID->29047720],
Cell[23048, 863, 155, 3, 70, "MoreAbout",
 CellID->500862083]
}, Open  ]],
Cell[23218, 869, 50, 0, 70, "History"],
Cell[23271, 871, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

