(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    106502,       3331]
NotebookOptionsPosition[     92829,       2859]
NotebookOutlinePosition[     94553,       2902]
CellTagsIndexPosition[     94467,       2897]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Piecewise Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/PiecewiseFunctions"], 
          "Conditionals" :> 
          Documentation`HelpLookup["paclet:tutorial/Conditionals"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Piecewise Functions\"\>", 
       2->"\<\"Conditionals\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Which" :> Documentation`HelpLookup["paclet:ref/Which"], 
          "PiecewiseExpand" :> 
          Documentation`HelpLookup["paclet:ref/PiecewiseExpand"], "Boole" :> 
          Documentation`HelpLookup["paclet:ref/Boole"], "If" :> 
          Documentation`HelpLookup["paclet:ref/If"], "Max" :> 
          Documentation`HelpLookup["paclet:ref/Max"], "Clip" :> 
          Documentation`HelpLookup["paclet:ref/Clip"], "UnitStep" :> 
          Documentation`HelpLookup["paclet:ref/UnitStep"], "Abs" :> 
          Documentation`HelpLookup["paclet:ref/Abs"], "Sign" :> 
          Documentation`HelpLookup["paclet:ref/Sign"], "Floor" :> 
          Documentation`HelpLookup["paclet:ref/Floor"], 
          "InterpolatingFunction" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingFunction"], 
          "$MaxPiecewiseCases" :> 
          Documentation`HelpLookup["paclet:ref/$MaxPiecewiseCases"], 
          "Interval" :> Documentation`HelpLookup["paclet:ref/Interval"], 
          "UniformDistribution" :> 
          Documentation`HelpLookup["paclet:ref/UniformDistribution"], 
          "TriangularDistribution" :> 
          Documentation`HelpLookup["paclet:ref/TriangularDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Which\"\>", 
       2->"\<\"PiecewiseExpand\"\>", 3->"\<\"Boole\"\>", 4->"\<\"If\"\>", 
       5->"\<\"Max\"\>", 6->"\<\"Clip\"\>", 7->"\<\"UnitStep\"\>", 
       8->"\<\"Abs\"\>", 9->"\<\"Sign\"\>", 10->"\<\"Floor\"\>", 
       11->"\<\"InterpolatingFunction\"\>", 12->"\<\"$MaxPiecewiseCases\"\>", 
       13->"\<\"Interval\"\>", 14->"\<\"UniformDistribution\"\>", 
       15->"\<\"TriangularDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"], 
          "Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Inequalities\"\>", 3->"\<\"Logic & Boolean Algebra\"\>", 
       4->"\<\"Numerical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Piecewise", "ObjectName",
 CellID->16937],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Piecewise",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Piecewise"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["cond", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["cond", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a piecewise function with values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in the regions defined by the conditions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["cond", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Piecewise",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Piecewise"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["val", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["cond", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses default value ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " if none of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["cond", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " apply. The default for ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData["0"], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->4599]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["cond", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are typically inequalities such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[LessEqual]", "x", "<", "b"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->31499],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["cond", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are evaluated in turn, until one of them is found to yield ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13192],

Cell[TextData[{
 "If all preceding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["cond", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " yield ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", then the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["val", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " corresponding to the first ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["cond", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " that yields ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " is returned as the value of the piecewise function. "
}], "Notes",
 CellID->30554],

Cell[TextData[{
 "If any of the preceding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["cond", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " do not literally yield ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " function is returned in symbolic form. "
}], "Notes",
 CellID->19124],

Cell[TextData[{
 "Only those ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["val", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " explicitly included in the returned form are evaluated. "
}], "Notes",
 CellID->31],

Cell[TextData[{
 "Elements of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["val", "TI"], 
     StyleBox["i", "TI"]], ",", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"]}], "}"}]], "InlineFormula"],
 " are dropped, as are all elements after the first ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["val", "TI"], 
     StyleBox["i", "TI"]], ",", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28066],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"], "[", 
   StyleBox["conds", "TI"], "]"}]], "InlineFormula"],
 " automatically evaluates to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"], "[", 
   RowBox[{
    StyleBox["conds", "TI"], ",", "0"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->774770502],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " can be used in such functions as ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ", as well as their numeric analogs. "
}], "Notes",
 CellID->26429],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " can be input in the form ",
 Cell[BoxData[
  RowBox[{"\[Piecewise]", GridBox[{
     {
      StyleBox[
       SubscriptBox["v", 
        StyleBox["1", "TR"]], "TI"], 
      StyleBox[
       SubscriptBox["c", 
        StyleBox["1", "TR"]], "TI"]},
     {
      StyleBox[
       SubscriptBox["v", 
        StyleBox["2", "TR"]], "TI"], 
      StyleBox[
       SubscriptBox["c", 
        StyleBox["2", "TR"]], "TI"]},
     {
      StyleBox["\[Ellipsis]", "TR"], ""}
    }]}]], "InlineFormula"],
 ". The piecewise operator ",
 Cell[BoxData["\[Piecewise]"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]pw\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Piecewise]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Piecewise"]], "InlineCharacterName"],
 ". The grid of values and conditions can be constructed by first entering ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Comma", "KeyEvent"],
 ", then using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 Cell[BoxData[
  FormBox[
   DynamicBox[ToBoxes[
     If[$OperatingSystem === "MacOSX", "Return", "Enter"], StandardForm],
    ImageSizeCache->{36., {0., 8.}}], TraditionalForm]], "KeyEvent",
  ShowStringCharacters->False],
 " and ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Comma", "KeyEvent"],
 ". "
}], "Notes",
 CellID->12722],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " is normally output as ",
 Cell[BoxData[
  RowBox[{"\[Piecewise]", GridBox[{
     {
      StyleBox[
       SubscriptBox["v", 
        StyleBox["1", "TR"]], "TI"], 
      StyleBox[
       SubscriptBox["c", 
        StyleBox["1", "TR"]], "TI"]},
     {
      StyleBox[
       SubscriptBox["v", 
        StyleBox["2", "TR"]], "TI"], 
      StyleBox[
       SubscriptBox["c", 
        StyleBox["2", "TR"]], "TI"]},
     {
      StyleBox["\[Ellipsis]", "TR"], ""}
    }]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29556]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->378090748],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->70272305],

Cell["\<\
Set up a piecewise function with different pieces below and above zero:\
\>", "ExampleText",
 CellID->807528759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "^", "2"}], ",", 
        RowBox[{"x", "<", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"x", ">", "0"}]}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90260051],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WEtsVUUYHnpOH1KotbW2FKQXykvl0pZSKAj2IbXpi1IfsCAsamPSLhSD
daMLdaMb3ehGN7LwkfhYQCQYE0yMJEQSI4mRxKiJwcTgQmIicdHE5Pr9/8yc
mfOfYbppJPTcc+b83zf/fP9j5t6p2cX5p56eXVyYmy2Nnp59dn5h7rnSI6dO
YyhZpZQ6j7+X2hTuK7jjv/OVCj6L1xpcUxhsx2eCz2nzuc2Mp2xVS1ca5iel
dnjPdDstnrcJe82iEvOIf1X20UOVzJxyXLJvF8+a9o6IDyEWuYaqFWQhVVXq
RpdXbGsB4ZSvMnj6PCqeqwsRPSGYj0VGSblzHI8a8b5aPP/f7zmmNTdu/H3u
7DWMToydOf7Ehy++8EXVmXe/Ta5+9zvbnjzx0Scff7/ivqw0n5cTkSxup0vt
rVtLWPHck59iuW+8funLi79gRNdfNWzx8Nablxfmz/780586ZyKMet4JxsL+
tVe/gowgJWw9z5bZXvvhD8wJaprtUcaN0TWF7fOLF/Du8ws/NoT4E0QAcYCj
aoZxo4xD5BAt4K5881tjKLbpzZv/vPLyRZDDlKtBjfD40tK/77x9BZSXvv61
KaRsCkq8/uD9qzCdYuRhHkdaZOPNoRgZbniF9U4yctgbP/XMZ/ClRSDr2OL6
9b+gOiSEQOOMHGI7jAOGOVWrwK3mZ8iGSOKq9VSDPIqlaSdUm0BxXFJMgqkw
IehZTzXAdkh+qApv1bqKrn+OSQomrBxLwCtWUR1ie/DAHii1XsxzJz/Db+Cg
p1ZQHeRRRAZrgo9qg0A12tgibHAQhqyfepDtMG4y816Ba7JaYDbSgrVTB3gU
9tACWLVRoJrzWsCQVVD72Q5rxiDla4fR4h6rBfigBV6xCqrfzoNVkX1JzNPq
aUF5zCqofQK1SaDavCyGCSLF61F7BW6zwLXbXNVeImLsn+qz+WRW1Slw622m
ZkFjD9Ueq71OX7XFqLHRixWSAI7yDKrXZgbsQ12kw2ao6a7Mr3bzKGYHG7Vf
uS+WbKyy9rTbw0EiCEu35FVi9y0Pv7kQu27G91RMjwFvNo+HS8XzFpHXXczC
XAme4T3dylhKlq02trDHf9yUmafLag0vQ7FNK2535vlQ+9QbdjJ6l9UQaMS5
EGHpxQ4b8axn3e/xoChQSnS7HA+jqJMjMGj/cJyZVVlo22m8lzsVe59gW8Jq
aDvmfcaMwinkEXWknQJVthmBKXUnY1XVAzb/TNWXzazdNgOyTtbp2bsMKot5
ekTEOSZ6zdRxIBPd7hIozstcdXBmqfsqpgOCjSLcJXC62lx1dHgoCIHSoFuJ
6rNaQGkdSe6QJk9cBLqNFv2FiHH1mx0eUoKENO8R8+y3kTKdrN1DgQrzOsUc
6oDN9mw/5t5mahzKIhyZZh6O+2RuN+YObDqK87JX4A4V8rrFwzk/e40avGfm
dmDeGUytY7WQyMXGzTNkc8DswLwLmWpxEe4TqGEbK0yl+3qjh3NVJ3HZGQRL
wo6L5fHebHoExkFGt3sFLjv1AKTPS2sZp3uU6xb7BG7UqoKQIXBYUL2Hc1GT
OD6HJMgOk8F8TjF9FSTQimLWL1DjXgbr/l7n4Vx1Uuangf7Op61cf+cuY3Yb
vZfL3FQBniN2dabaqz0WUMOvUKbKjjhtM173d3ijv0PqE4irR5lRiclIPiFT
f0et0K0+aetTD8jgG7gLGSK/1x7zUJgQ02a+574JSg00boOI2J5KuHv71i57
Dwat9ClRn8gqplKJ87j3Ft0S7c++LXK0W23MXvtQxMpFLGy1jkcxHSal24GI
leMayHndJjgGgxxtgiNs1Sq4hoJW3AWpcpEHtMMNR6xcrg3nvG6xHIgu5dLD
QY4WwRG2ultwHY5YOa6wVbPgGolYOa6R3Nr0W4iD5mXfFjmahNaUbclt87tp
mfiFa+8uHnXdR8YzhnJ1YPOtxniorfS3XldLklv2JB/l6lTmTtgj/W3O9YLB
qFba2nWcsaBVg430zPR7tE+O52LYICI8HuRYK7JlImLlIh2zchEOW63hUbfb
Tua8XiMiNxnkqLdqYuV0OxWxciqGrVYLFY9ErJyaMSunQNhK/4Lp+q/8pdG3
ckqEreqEEkcjVtjVsS3f3qpW5MJMLjK1IgdmIhzuhCizLlxTugpcJcrMiaHy
VRI62fjWOIhigdbaP8fke8NjldheHX/7uBg9yaPFX/bVqv8ALroCSg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112203393]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->181844988],

Cell["Find the derivative of a piecewise function:", "ExampleText",
 CellID->966066121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "^", "2"}], ",", 
        RowBox[{"x", "<", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"x", ">", "0"}]}], "}"}]}], "}"}], "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->247752391],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV81OwkAQLtstBQJK1BiP3DyY+Bh68miMJ22ICRyMDWLsrTc9EY48Akce
wUfgMXiMut3ulO10ui1FjZu02/nZb2a/mV3CjTcdPT170/HQG1xPPH80Hr4O
rl4mQmU3LMuaiefizBLfkfiSzyyKxKy/7fjNgyD4kmOz2Xxs9XYYhpEcVlO8
HAFhOdKshnQSM1PWeOZi5mKO9baSwZ7AJgPLdim6jVB7mgx2hlCZlkF+Vy0I
oWTp5aSygjFotbUydRd5KV8X+doa4taL75GNbYh+REU3yIzYHf8b/gxZkfaf
59CQQb8Kj6X7/B0mnYL8i/R1mYOzVxTroDZHcH9U4ybtUb7VW1lLtfqSXgz4
qMQSnQuN7pBaijWcQ5atAi3NHdd98Q3JkQ52hW9WkFlKgxzKUrSaikYhHxbw
mo0ETDOUU3nP9JCM7ZdIPs7VE5/jEzIu/E52VZbnaFUsx9f0Kbn6899qYV8P
qAr4Vm5nqpJwtlgslsslWHXvxxzLrsKV9SnocYZyw6iewuiouVmK5fv+fD43
YbUq5FXWg/ndNpHHPui4Mv09sN52WAsVCyLTefwPPWzubLgHgb9bJOPOcIz7
pXtOnpZMB9zlNNBp7o410HODmtxrWOkeavZEE2G2a+SJOeQV+OhQa0zx+Gq1
CuVYr9c4ov57TVXZdGq6pM10VuAfynuk90ryz8tqfAM7ySFM\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394029382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->229387714],

Cell[TextData[{
 "Use ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]pw\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " to enter \[Piecewise] and ",
 StyleBox["Control", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Comma", "KeyEvent"],
 " and then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["Control", "KeyEvent"], 
    StyleBox["+", "KeyEventDelimiter"], 
    DynamicBox[ToBoxes[
      If[$OperatingSystem === "MacOSX", "Return", "Enter"], StandardForm],
     ImageSizeCache->{36., {0., 8.}}]}], TraditionalForm]], "KeyEvent",
  ShowStringCharacters->False],
 " for each additional piecewise case:"
}], "ExampleText",
 CellID->371889260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Piecewise]", GridBox[{
     {"v1", "d1"},
     {"v2", "d2"},
     {"v3", "d3"}
    }]}], "//", "InputForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9003486],

Cell["Piecewise[{{v1, d1}, {v2, d2}, {v3, d3}}, 0]", "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->244590145]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31826],

Cell["Define a piecewise function:", "ExampleText",
 CellID->692567804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pw", "=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], "/", "x"}], ",", " ", 
        RowBox[{"x", "<", "0"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"x", "\[Equal]", "0"}]}], "}"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"x", "^", "2"}]}], "/", "100"}], " ", "+", "1"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->982287796],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdV81OAjEQrttdQKMGI4oGY0g00URRiUa9aGJi9OTVExdCTOBgJMiBG4/A
kUfgyCP4CDwGj1Hb7izbnXahCzEkNqHdaWe+b9qZ/vBWbdc/PqvtRq1afG1V
m/VG7bv48tXiXXSFEFLhv6c9wr8Z/5K/CmO89esirz3e6QiJilFZNLkktamo
3U6n8yPLeDwuiJ70RE9qEb+OYAj5IsSg3W4X1A/+BYJYB4ePuvbrqFi/G3tT
EBthIyAoyBS4fAO/CB6Xt54RKYO8uEAynSE7hgxJWzF54LP0i/KcAX/Xpf9c
Br0NG488FKE5fbKavZHLW2iFJ/lhnofWa8e0LSo3lAnJIw0HuH1yWaAnGBEc
wiBlxZgDqx2NGccjb8RLg/2ugiM2375R+1BjuTHqHcEcrmJHVc/MWsdI63IB
LZWRxPplh2U+H5bR60e43+8PBgMGsRSJe8aiGZVj4ZkVWIVYq2jW5wzHOAX2
Ss7yIve3efcAR7PZ7PV6Jo4SU7I2BmNW5gcY6cTezULWVyC3ABqOxvYCWM8J
bIOd/crU6C83b/VT6sGoF5xGj3OM2nL81RxvWTTeOPc9Nu18v9O8z7Awz23v
Jamr3PAFUSk3fFbBnPhoiX2v2CT1aw/x5rTZrqHVMt/R8ejaC0SRt1Bksgmw
MxA1B1r83ovOgmo9+DY+Scit3l5T3l8RTpeFLwqV+5RNy8A1I/rsGTkxbOWQ
xR0Oh11ZRqNRJoqoxMZNMMdr2WyiFcIvWJwJ5YkVNXgcZGfQ+hz+fzSy8gue
uW5s\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{92, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131782736]
}, Open  ]],

Cell["Evaluate it at specific points:", "ExampleText",
 CellID->657109895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pw", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "5"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", "5"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40157904],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "5", "]"}], "5"], ",", "1", ",", 
   FractionBox["3", "4"]}], "}"}]], "Output",
 ImageSize->{105, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144047193]
}, Open  ]],

Cell["Plot it:", "ExampleText",
 CellID->28906311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"pw", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->47888533],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->389098393]
}, Open  ]],

Cell["Refine it under assumptions:", "ExampleText",
 CellID->157116695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{"pw", ",", " ", 
   RowBox[{"x", "<", 
    RowBox[{"-", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->775211676],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sin", "[", "x", "]"}], "x"]], "Output",
 ImageSize->{51, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->228555634]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10372683],

Cell[TextData[{
 "Automatic simplification of ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->194830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Piecewise", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e1", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e2", ",", "d2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e3", ",", "d3"}], "}"}]}], "}"}], ",", "e"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182490224],

Cell[BoxData["e1"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248358922]
}, Open  ]],

Cell["Remove unreachable cases:", "ExampleText",
 CellID->13402949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Piecewise", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e1", ",", "d1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e2", ",", "d2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e3", ",", " ", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e4", ",", "d4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e5", ",", "d5"}], "}"}]}], "}"}], ",", "e"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->270469175],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVktuwjAQNXZSKvGvaNUl+56gXbFqVz1EhCrBompEWbDLEbLMEVhyhB6B
Y3CM1ONPMZMHQf0JS/F4xvab8XhekudkMX15TRazSTJ6mifpdDZ5Hz2+zbVJ
NYQQY/3c3Qo9LvXIPOOy1DLsFfXRcrn8MG273d7v7CrLstI00dRdJKxdadl1
kvTYSSncQNgm3R4JES+MTlFZPaIu/tIdTJetUjW69P44cq3/S6a3T/Fcifd0
37SVx/B9n/HxPFf2UFyUqx7wIN38gdNhK6wYAm7WnFE6jy5Vws74e5RBzSno
pwNjapnk77xUb2YI0XxdU5RNLW/gqoeztXqe+proOBnyks7XN6rNSVEUq9XK
767nZBtacW2EfvajDP3ETMd3ytkwCLDTNM3z3GPHvpx43UEehKv6MKuYQzzq
FtMlWNM7eGuIK4QYvlVRrroQEWfQnG6PFTynGM2zol/uM3IAV58DD36DHXVf
DPj2/kmF/SH2/zACemCMOIIfrdfrzLTNZkMeFGAQ3RnnBK9ii3mNrOzLU901
dPiDclfrJK/MrP1rEo1PdfQX8A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{64, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->232042126]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Piecewise", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e1", ",", "d1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e2", ",", "d2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e3", ",", 
       RowBox[{"d2", "&&", "d3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e4", ",", "d4"}], "}"}]}], "}"}], ",", "e"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->33791510],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVktuAjEMDZkZqMq/op9NJa7RdsOqXfUQI1QJFlVHlAW7OQJLjsCSI/QI
HINjpPk4THCcgX5AjDTj2LGfHcdO5jWdjt7e0+l4mPZfJmk2Gg8/+88fEymK
KoyxgXwf7pgcCznS70AISd1vpL7xbDb70s9ms6lKSSyVe5JGzGgkQDmDATMP
B11eYEV5ngv9sKrmlV/D3yI+2sNzi+zI4v/zlGx5WNDhvpTp9a99JOUZ82wo
Tyo3cXgVtNTzVxNmj29w5sEDpICZGbsfHIrAVoePe6/TV+D5ue0F7Wo2Hm/2
8WylKo9quQlkpSHMLsfAt0krXLUXiL8kdxJbtQ7CVpFUJVsnMTnMhuPc1qxn
2wgi+tJOOFZP15xMbg010Jo4qUX7sJWeOBjKS1PsnmoCdXI46jalhXpoP0oH
/LeBJkBpbVN9BnmxWCyXSzV8cqSFrivNsmw+nxfS43WAPd+aQN3bIiqvAHzy
HqvSHD8J4pskFj7Zu0Fs2/OuNh011vpJZ+Co64jnhA7d2bYragQi7gqMSJ87
dAb16na6FOeURmtBfLZL7K1D78A53ASn6A7M/7nCjoh9mo4gPaCOKMGPV6tV
rp/1eq084JtCQGWX3RQFJv5fK7sZCqse4HdFUeuKXulZ87fOKt/Oq20l\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{64, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->811809967]
}, Open  ]],

Cell[TextData[{
 "Remove ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " conditions:"
}], "ExampleText",
 CellID->190370060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Piecewise", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e1", ",", "d1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e2", ",", "d2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e3", ",", "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e4", ",", "d4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e5", ",", "d5"}], "}"}]}], "}"}], ",", "e"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->37343957],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"e1", "d1"},
    {"e2", "d2"},
    {"e4", "d4"},
    {"e5", "d5"},
    {"e", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{68, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->747074678]
}, Open  ]],

Cell["Merge cases with the same values:", "ExampleText",
 CellID->361415468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Piecewise", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e1", ",", "d1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e23", ",", "d2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e23", ",", "d3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e4", ",", "d4"}], "}"}]}], "}"}], ",", "e"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->228995683],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"e1", "d1"},
    {"e23", 
     RowBox[{"d2", "||", "d3"}]},
    {"e4", "d4"},
    {"e", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{95, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->141209690]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->414130022],

Cell["\<\
If values are not specified in a region, they are assumed to be zero:\
\>", "ExampleText",
 CellID->39581900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sqrt", "[", "x", "]"}], ",", 
       RowBox[{"x", ">", "0"}]}], "}"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->605167665],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WE2IHUUQ7n0z89bEjQkJZl1NdCNxV43GGDX+G40m6+5LfPFnDRg8rIuw
e9BIXC8Kohe96EUvejEXFWI8bEhIECKIATEgBoIBUUEiSDwYBIOHBeH5VVf3
TE9NzZvMU3zsvunuqfq6uuqr6u63Y2pu5tnnpuZmp6eGx/ZOvTAzO/3i8LY9
ezEU9RljDuP/1csM2h207P/hTgfP4ncT3zEERvGM8Gy754gbj61UP33TsO0Z
c23Qp2Zb9EeEPKOYyHXxafhuoDXs5pTjEn1U9Bl2URcbNBS5hsZ/iEJeNXE2
Wu2xawoamecbTp+eO0U/KYnrboH/pB0lT81jsC+zkmROfvsr/kxCX0G/Kfr/
93vuH9h/yhGpKdYk+0nN93Xlq94HsQ9GLxH9laLPbKal8ioHK/Sr8NiKp+zo
6e9+c6i7gtGzZ/90WVgczWR1BqWj5879lR9tpHipzPEvf1Y0P/rwpDL65htf
KKPTz3yajbbcLGF9oFVEPg+o0Rrft7Dwt9OY6MisSoRuEsz04w+/l+rJqFJ2
UrdMvl/IpzZ/fuyn1187Vl/v/PkFLK1UL9ZX6kZ4cZM5LzbFs7Hvg28mM+87
TfByz/OHgvEknQPmwCjzhPbu7beOH5w/rb878fUvL80dCd8103f47Jr8GFR8
vGAJf8jK7J21u+PYC0VqPlbkShIiGCWajPHKy585xj5agwVFHIAAqhsO6cWC
jVm0OVrU3Nkt2gGLya4ozYyjR7532VSmnwSxL86P/IEvkeC19dmuA5+ceved
r6jZzsVCclt6Lxazt3NxbgrsRzKGFGpyhqFLNYWfduRmukhEYbuKwatBhZ2d
mS+XYixkPPKemq0uUrD36d37KadaOXsWC2sncl6VpyUtLoyAREY6U3O8G69K
62WGhGyDpVRne0e62PZRJVArqPlwLSQCGhCrGuuCECleGfBrQajJ62X6VeeG
JZ181m/Lxcef4KQW7+MgMyhNza0qM1gKnoaNZ878USK11PbxHlyklTykSi0T
dj6YSpF9y+3b99874fbnLSoGS6F+o4pT84EuUrAEVtO5QpdaIay+P2fPpfYt
QovJiGmbc169ENYzAm+41LyvFsOKZyw4Bu6h5r09Iw2KqN9TghRWWHoOWT0U
AJQBat7dswVDIoJ3/UskxAZ8AphDKjtfXCGk71Q5IaXuUKVWeSlehrldlVrd
cSx0Upty/LpKzHSbiiGlblWlhgMpBMjcokqt8VIII8JvNubsWeuZgRMONTek
3ozSU053vjMC1N0+cZNF2C6kosq42rso7TdYDWXe+ho4ZBffaFBnUJopr2/s
0Q7G4R2WqsgNPeLw3Rt1BtWIbkTresS5zvMJ60JVMdenEdL4vs5HG9UHUWXt
AifsmuhU43w1qkpZD1IthCdoFxhRpdb7dUIK3uc4pvza4K1HVMmetSrGzcKe
q1Wpjd4enALIo2tUKZsFdKqBPaidnCUFKZt3tO/ALprxytSrkvfGiLueQ9jk
+ebiu1qNrzwzSxRbQ+g0gJVTdq5SUaSWP1vYOhUj2nAtyg0Wfbmqr5+4s76t
oREqDdZC9WaoJxS7O8QwAqbAszBrUMWp5rzd6Wjnc75dmUZH4/zmgIGoQ7wD
FyJu93mqU47NK1Qpe2ag7MfMdJdcrkpt8X7HKZL9viyVI4u2en+CqVSZl6oo
VioG+1A5GWWJKjcm0AZyc43nUbC0xam3Ui5X3kUnAgZQ1iy6YB6G/Zb3C8IP
N+Mm01/KAO0mam9EMXsfEFhUUs4g5Sba9ryBp4jHsaodd/R7pL13Rsxf+lUm
qqWd/7Wo6tbJ0sVfUE3fP7+Vv0g=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182303502]
}, Open  ]],

Cell["This specifies that the default value should be 1:", "ExampleText",
 CellID->18249243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Piecewise", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Sqrt", "[", "x", "]"}], ",", 
        RowBox[{"x", ">", "0"}]}], "}"}], "}"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->287426805],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWEmIFVcULX/9/jFxTrRtx3yH7lYT53k2tmm1W21dJFlIFp0m0L1Qg7Yb
3ehGN7oxm7jRhQM4LBRFCShIBFEQhRBBNBAUgllEAhEXDULl3Pveq1d1/636
9o8Lm99V71ade+q+O716tbmzt/v7HZ29PV2d5fW7O3/o7unaU27dtRuXwgFB
EFzF//6GAOMII/6/GkU4Vx5LOBYBaMY5xLnDnpvs9SKjPqAjXWYpCKYlZBp2
CLlJ4A1LEFoRfwUnJrTK9pnyumRvFrKh/TDHBo1FzqHwDlnIq0HRX63uscYK
De/5gtWn81Yh1zFqu2D7Wr3KtoV9fW9evnxNw205qEe//dXTfSkbZWL0zVdn
X7z4l4ZbGUVXL3N8SwJfJ+T37b6Zz7Nn/3y7/RzZP/B/8r9rexN5lVMJMss4
h0JMCROLbIXl6ZunyFgbljOnHx7/6V7kcjcDhXRAUqRRhTgfkFJILBpuUTnM
rG/e+P3ggRvVUMjjbR2nXr3qy0CZJx49cvvypUc03JyDevrk767vLqZRhTgL
cAsAGm5SOUx3vP3LH/v3/VwNBavhHxRgBmqg8HV7Dgos4AJjBsr0sh+P3blw
/lcatuWgPJeO+khwbWRUu/WT7Ng+4pLBP8cw8NMq+17qiqyFQSKyG/rFRLYN
FlHvH0PSFsOEwCP8NFyfwxQqXjH6KE9YQl7J0q/WX4aI+LSm4uNWEV3Lx6RV
jf1Qwf1lDsrnt44axjKIQEfDdTkocMEr8E0GaniUrrsWFTVCRGhtDsrHQUd9
zDJKEwVKwy9yUN4TOuoTln2vW6OiRgrrV+egfBx11CiWUTQoHRquSuXI29Rw
Pcu+i6+Maq2beuHv2plGs+w75ooMJlf7JXsew3q7dl55+OBPGi6v2YIGlrHy
YaGludTOZGy6fu3x4UO3aLgsFaFSlFxLvdZYkSNL1egbFNZLWElZ6VHEOZ7v
whVwCA2XqByEKpw8cT/7Luc9OJAgwWIVNcF5C5Gn1XuRipoYpWt7Ycpa8x7j
O9ICleNTYY+OKjt7kNbkl/kqapLzz97eaxTjeSpqMsu+u81NWT2V76LcUfQ0
nKNyTHFWwx6sUBZFOUCggkBr+TBVeHg2M2wSqLBqNjaKOc9iWPzGhBv4BS10
IC0rkwLzWhm8DmF5zZ7K96GZCV44DtHCL2ihA2lZmUqVea0MXpzcXij5PvB5
jfNtdp5Hzt27+7xmHmMPPA/7KIKfxRHMq+LpIg9nqNkxw3kfKIrJ9FSGscUh
bMcM6O40lcOg/MrTrKJmilxuUlGcE4kVsVFFcQaGaGpobXGGxlZzlST61xSV
Y46Ijo6a61C2eiarqHkiQpNU1HyBKqesXujihbs4mm5TwSFRE+NckNUc0Bqs
ZNMiwTBBzcqiYJIsiwXLeJVFahWFvESwjFNZtL01iUuF9ti31k7KywTLGJWl
epUuT/BQdBviyORV6QqhNVqN+spE5tDKU5/KnNWJu5TJo1QOg/L5PlJFrXEo
9GgUl3mrrEDx22yi/kaoqBaHwgpPw+Epq/l9PsQt27WHqRwGhUaM3kIdaKiK
4n0GdSBYTSvUEBXFeyH7TkIdcbCK4r2b7Yi0VxiUsrrNxcu8tJpdaAVHWyIi
sMrsidNVWhejTTpVZEa7iwRmjmZo9uj9rjD+/kD9FF4m/5VUFsruopLTW5z3
rV/rMrWTvaIU+W+/7G/ryaKqXYz0yuAvgPaNnrTDfmnzV0bawWDSNCzEEXD7
1zyvme+dlV+3gwH/AZHF+PA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->55591517]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->510868280],

Cell["Compute limits of piecewise functions:", "ExampleText",
 CellID->2207936],

Cell[BoxData[
 RowBox[{
  RowBox[{"pw", "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{
        RowBox[{"Abs", "[", "z", "]"}], "\[LessEqual]", "1"}]}], "}"}], "}"}],
     "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->93174911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"pw", ",", 
   RowBox[{"z", "\[Rule]", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->35875877],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->512647280]
}, Open  ]],

Cell["\<\
Compute the limit in the direction of the positive imaginary axis:\
\>", "ExampleText",
 CellID->420480245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"pw", ",", 
   RowBox[{"z", "\[Rule]", "I"}], ",", 
   RowBox[{"Direction", "\[Rule]", "I"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->235578352],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->36053368]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176420804],

Cell["Compute the series of a piecewise function:", "ExampleText",
 CellID->184022927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Piecewise", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], ",", 
        RowBox[{"x", "\[LessEqual]", "0"}]}], "}"}], "}"}], ",", 
     RowBox[{"E", "^", "x"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111260802],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{449, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37183769]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->290329989],

Cell["Integrate a piecewise function:", "ExampleText",
 CellID->20405899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"int", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Piecewise", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"E", "^", "x"}], ",", 
         RowBox[{
          RowBox[{"x", "^", "2"}], "\[LessEqual]", "1"}]}], "}"}], "}"}], ",",
       
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7649316],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWM1u00AQdr3rJG1p89NCIoREkFrBFXGlHAsSqrhwg0tUIbUHRFQqlANS
HiHHwBPkwCHqE/AIeYwc8wjL7nqGrMdje4NdVEvxeHfHs/PN7M7nzdng+uLT
58H15fmg//pqMLy4PP/aP/1ypbvEVhAEN/p30gv0s9JP9nejlJbuXZi7HI1G
v+21XC5bukdo5el6XIzHY2WvoGXbxlbc/pGpJfNtyLWNLL22voV6lJ/jHYzu
gjzL1HL93SXtt+xbj4hWpG+RbmJsJEgBOKMkIvAoBCmJtQPn7Qik0YvdiK8Q
LD9m/du37cViMbaXHbJtx193RtcDY71jlVx/cU7fXoopTOWU+nBI2qKgjRF0
+56w0ag5cQzEarVKREW3nRki4rvB0oB+Nmop5DUOOcERMnpe+PnoF0aArleK
0Dw2vdAZy4KJRfWooszVXYSGxmTPC9ltruO/u9xzVh53U62rjARJqxBWH4kz
elcd6jfqxYr2IhZwLfRZb9vE3hGLtEO0aP1tp+JNs/vca/ZjiElHJVnB1Nq6
li+8rGTzULFWC2b8yY7+ugO9BsemzB5nYzqdzmYztLFm9pCLFMPssd5wOJxM
JuYRs8Qz+3uSwzeZWnkr65R9K4vZ76scZie7hnKIgt1l+ncYfXdPIVfhvIL1
siy/d5V/LfKri0XtB6TdcPAmVwTNE8c01XP8nqqS44uigbPR/hpEZRvkDsiG
Vwx8WJ5W+c1Y/l+zXHdwIK7yeGjUKZeU4flNkbKIEusac+qXS8r1aXv7xA7L
/iUQNVWyMlGEfvuScmMPrDXZLLAZ3MDnp6V8wlgj+0iQEcguyGdOf7H1bipz
373eu/tfEUcqycOjTK08Hv7GvmVWd/mT9EsyjqyK9bfHzm3PC//59HuS0qD7
jZ5ieN+RB1lGquys+koleaqueD7LiW/lJ030CbmG1pIyvtxelpER6de1462c
z+fx14z+wLtH9Mqd+ej+2Cbj/Jo7YKNRdJL7wNo6VPy57CPIh1Yr/i8y2PoD
c10gHA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{177, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->473751903]
}, Open  ]],

Cell["\<\
Integration constants are chosen to make the result continuous:\
\>", "ExampleText",
 CellID->448714350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"int", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->452065565],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->170123928]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->219723520],

Cell["Compute a definite integral of a piecewise function:", "ExampleText",
 CellID->303878304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "<", "1"}]}], "}"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->307508434],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227820115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46103887],

Cell["Laplace transform of a piecewise function:", "ExampleText",
 CellID->405374291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sqrt", "[", "t", "]"}], ",", 
       RowBox[{"t", ">", "0"}]}], "}"}], "}"}], "]"}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128275628],

Cell[BoxData[
 FractionBox[
  SqrtBox["\[Pi]"], 
  RowBox[{"2", " ", 
   SuperscriptBox["s", 
    RowBox[{"3", "/", "2"}]]}]]], "Output",
 ImageSize->{41, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->379404532]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->735029652],

Cell["Solve a piecewise differential equation:", "ExampleText",
 CellID->745546671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
     RowBox[{"x", "[", "t", "]"}]}], "==", 
    RowBox[{"Piecewise", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Sqrt", "[", "t", "]"}], ",", 
        RowBox[{"t", ">", "0"}]}], "}"}], "}"}], "]"}]}], ",", 
   RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->615059915],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Piecewise]", GridBox[{
          {"0", 
           RowBox[{"t", "\[LessEqual]", "0"}]},
          {
           RowBox[{
            RowBox[{
             SqrtBox["t"], " ", 
             RowBox[{"Cos", "[", "t", "]"}]}], "-", 
            RowBox[{
             SqrtBox[
              FractionBox["\[Pi]", "2"]], " ", 
             RowBox[{"FresnelC", "[", 
              RowBox[{
               SqrtBox[
                FractionBox["2", "\[Pi]"]], " ", 
               SqrtBox["t"]}], "]"}]}]}], 
           TagBox["True",
            "PiecewiseDefault",
            AutoDelete->False,
            DeletionWarning->True]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{1.}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.84]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"\[Piecewise]", GridBox[{
         {"0", 
          RowBox[{"t", "\[LessEqual]", "0"}]},
         {
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SqrtBox[
              FractionBox["\[Pi]", "2"]]}], " ", 
            RowBox[{"FresnelS", "[", 
             RowBox[{
              SqrtBox[
               FractionBox["2", "\[Pi]"]], " ", 
              SqrtBox["t"]}], "]"}]}], "+", 
           RowBox[{
            SqrtBox["t"], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}]}], 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->False,
           DeletionWarning->True]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}},
           "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}], " ", 
      RowBox[{"Sin", "[", "t", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{507, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->809544961]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8739657],

Cell["Reduce a piecewise equation:", "ExampleText",
 CellID->253080921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"Piecewise", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"0", "<", "x", "<", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x", "^", "3"}], ",", 
          RowBox[{"1", "<", "x", "<", "2"}]}], "}"}]}], "}"}], "]"}]}], 
    "\[Equal]", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16113946],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "1"}]}], "||", 
  RowBox[{"x", "\[Equal]", "1"}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}]}]}]}]], "Output",
 ImageSize->{217, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104079813]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"Piecewise", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"0", "<", "x", "<", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "^", "3"}], ",", 
         RowBox[{"1", "<", "x", "<", "2"}]}], "}"}]}], "}"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7727846],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10419576]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->632752625],

Cell[TextData[{
 "Integrating an implicitly piecewise integrand can give an explicit ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " result:"
}], "ExampleText",
 CellID->94656176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{"x", ",", 
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "^", "3"}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->859269190],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFV81OGzEQNtldlkDbHPiXKhG1tIifK3CD8CM4cegB+qNeIlQVDhERcMgt
j5BjHiHHPAKPkMfIYxiPPSbe2XHqJWprKXY8+803n8fr2d2L+uPNr0b98fa6
Xj2/rzdvbq8fqmd398oUTQkhGur3ZUWo/1L907+GlGo0fUX1kTIu4XisrRH0
cavVetJtOByWwQIAqZvGu/OjkV/UbrfROqO6WIEWcTz2oiyXQC3u/IT1AkUl
dXUZRx41+yrdv1nrIvFdw5wBLsERlBhH00q48uUgxiqZR3+YlzCCa1tlI6V6
rvYSdUW6U3OHGdYwTXCpxtVqNcS9DVGYvMwxEWEaX5UNNlYyUcYhq7F/HTkr
HylFHfMwiUcRRE5DCWOaoLqhxV4BbnBYYSPRs7mAXvnIdB82C/PB/bAd5JWP
fhrkt4prPWTRM6jlPfE6YNHr0pw+nmvd4YCk11jUJ4zIX/0cpIOvJ3/LOocZ
/O696irmUW8I6tsEKDei8OoK4yqSh33MA30G2DNuT1ciR7Uvsackx7YnubOf
Ioeur5m7nUadJnMTxZzIbrfb6/WktM9Cf/39wKpIUMUsjmVn9MXM5sm/Mnvi
7JzePy5ns9nsdDp+TqonzmXNRuOVh+1Jhewv5eJ3gn0ryWjbYqNtBLHZHdmR
5p7ckM5zxov+6VeWuMqshK8snj6zedQ7grqaAOVGFF5dYVz/vnZC5n9MkMmw
ShbG9b9q567kayRUAf+biD6PY6sg/17lf4MaVws/ymy1Swtw78tsVSsX8M2v
0q2RoSw0w2xtDOTK16rDAt42f/AtNP4ts2hNAjx/L1bIai9Z1JgKEff7/bZu
g8GA4gzbvGMdVaEFltN8DYupZxkMUk0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{109, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->376065142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38782911],

Cell["Symbolic minimization can give piecewise functions:", "ExampleText",
 CellID->322806400],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"Minimize", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", "b"}], ",", "x"}], "]"}],
  FormatType->StandardForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->106641986],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Wc1y0zAQVizbSUoKlBQK7YECh97KDJfQK+Wf4R0aOsy0BwZIemCAd+CF
GHg0Y8srR/m0thShJDOJrNX+/3ntvJ9eXXz8NL26PJ8evppNv1xcns8PX36e
lSDZE6I3E0Ic3BXldVFeqW/1mZff+hKvtspfWaI9oFWWa0ZrIuhC1J+kvEzL
9Yxwc8IV2QJH8RaSsDODKjUkpMa5KQH30sldAtftFew4VaCUMFLNWnmsUJyQ
8ibgSMc+IWkm7AXxPQD4AGmrn6zZkxIdUINWuawPWITb53TOmnPCQm+soo3s
kH4rggcn5MHMWIVFiRZgtrZ7b9tHR2cMnsN+7fHu0Jg9jx/zDg28Ksdp5wns
WY2dmTBSQDMF4mVABXwG2LEjn7X4uw0eGmndU9tkXf8vL00cUfKLpW+Xbjq8
p59DYtj0Kiu3klY5fj7jLOiOJq8Lzz1joVx0V/VinBg/bLGvRlQfw+JELKaC
U58opqbWmEspwLR8nDH03tZLdlBz0jjON4I98DRKBO4v+0nYHfM17Ic+nu/o
uHh+DPuxU6M30SyvRpm35Ncth116yhgR/hGcHxG/d1G0+8p5zcpnnROoO06C
v710Qj/rCpnTipGTVqRGgKHnuL8O+b1i0cTqWsoB40cL5wpvSKt5zkksH6OU
pF6rteb+Z4s3MJ9xAvvjZasr/ijd7vjXACMs5i49cNbF8+NlvYrlvNwF7F8O
bo82p3NHpW9Gyypvqn6yR2vV9yRTZW10mHcDot9xWNcnvA8rytX9D+FDokd9
wryi6tiaNm6z0IwkG/dKQU/BFi5WB8rlZ5+KKmnlidMod8ewqc5YaM7awnNw
2cJPfXlhdHHrlPXHWqM3DrKNj9OwMN4XrDVOYVrzeg2KxT1ssxG5U9TPfzEr
KCOe66iZKfGOWSW5wXMTdcG97+KzKWZl4Fy0/k4Ws0K4e1xojMy3wVJ7hiaX
Oo/26GQ32ILm/mtR7xSLd8ONdDbPwzXQ1cFroGey5XerY+DxOEjyPZZqwkK/
BUnYZ6lU3qo3z5VFTwq/SWaf8E5o/e5Jp2On/KuA9T8tovcPpkBOiA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{370, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99453195]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17777],

Cell["Compute the volume of an ellipsoid:", "ExampleText",
 CellID->161684625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "/", 
          RowBox[{"a", "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"y", "^", "2"}], "/", 
          RowBox[{"b", "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"z", "^", "2"}], "/", 
          RowBox[{"c", "^", "2"}]}]}], "\[LessEqual]", "1"}]}], "}"}], "}"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"a", ">", "0"}], "&&", 
     RowBox[{"b", ">", "0"}], "&&", 
     RowBox[{"c", ">", "0"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->223642391],

Cell[BoxData[
 RowBox[{
  FractionBox["4", "3"], " ", "a", " ", "b", " ", "c", " ", 
  "\[Pi]"}]], "Output",
 ImageSize->{57, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->336581153]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22338],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 " converts nested piecewise functions into a single piecewise function:"
}], "ExampleText",
 CellID->216819620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pw", "=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"x", "\[GreaterEqual]", "0"}]}], "}"}], "}"}], ",", "2"}],
         "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Piecewise", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"x", "\[LessEqual]", "1"}]}], "}"}], "}"}], ",", 
           RowBox[{"x", "/", "2"}]}], "]"}], "^", "2"}], "\[GreaterEqual]", 
        RowBox[{"1", "/", "2"}]}]}], "}"}], "}"}], ",", "3"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52736705],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWL1PFEEUH253Ob7vgMScqAkoldJZGAoNWGgD6l9APIkJFMYLUtBdSWNC
SWJDSUmsrrSkpKSkpKSkXN/Me7M79/bN7dyKxk242Zmd997v/d5788Fme3/n
85f2/u52e/HtXruzs7v9bfHN1z0YikaUUj34e95S8J7Cm/nrpSm07m+kf+OD
g4Nf5rm+vh6FkQgmr1GrZyTU1hS9KHxq8BpD+y7XFXW73dQ8SmtSWjS1jyK9
KspGScrfr5Edd+yDaG+CzXoVYqmA71/bSrz8jRHj64IuPR778RdGZQtlXtTI
EpoyD43YL1qjFngv6pcz4KVu49xKkfOPorY62dIo69B+Emf9/A9GtwipnDtb
zFt51qbpHx8fO7FQ8cnJCVbq5eXlONPz1PShhFFIPRb1bpj+7e3t6elpmmUq
6KXvPCeemT6sECCiX5cGaAWVYF7S6mLVObBi+hcXFzjFo3WMeNR5pNNoOg1f
k5pG19HREekq83OF2V70InKl5AyfYbOqrHGzpn9zc0PRjBn+VeZfi7hJDAbU
BqIUZZ4rddZvhCAuXSsRM0S11+v5MQMqyqUWk3ex55xz7DwGQWx71170HGi6
urqSMD9Mw3MOZcF50nWfIYkd/zqdDgav4B/vTwv+DLv+N6xXHi/rNnJd8xj6
TX8AhmEz2tRKhGuXn52yiuN1O8Utp6F7VjOIE6jAPk6gPwwnpTWjWakBKS4b
KqvjauvPpHFn0A5r1tvo8PCQKpH7/qiybwlRr31aYFJhEbb7vI6s3uefsPkh
WIetD4vYvw+5FtZKEI0X+G8yDeFZmhCyKeK2KSKsk9RrNo7zYEWifWCS5s0U
EPIMuefYdcfnvPbdWesijpwhF4eOcYusTdM4Mg4DtMJG5gf6JD/yZyhwCNeS
PhZWCEeDcMhsD5sPq8w7mcOqWnmEdPbZKrw7K9Vq2Z7cbLxtdic0bmu9+VdR
8L5hrC/uo5LE0Lvo3aJ0ayGriUqYTOXgZl5x1/Vhm6BW3oeCsdH3lqvtDqJq
V8VBzJ2fn+OyUkCXpP0520jlHLY5nsnjEWHADSLKVrgcrVQhoRkJBukexX0Y
LXAyWxjhJypeC6gzv4nKfs0zqSURb9mtzEZsntpxpy1igvPLQExzJL1MnOP9
BLZCOvWUWbf9SWYd5fKbtt2rH4goNmyM3Bt3nJ21z87OkoAo2VWAM4HW4H7e
d/POv8uYNpnnto59uc6t8hzB0wPQSnnIs3chRxGDw+g5ULBhmaR5L0S9wB1F
TNb7XYiTyuLxQ5TB/3+qkd89X/kR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{183, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314080079]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", "pw", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->83971907],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"1", 
     RowBox[{
      RowBox[{
       FractionBox["1", 
        SqrtBox["2"]], "\[LessEqual]", "x", "\[LessEqual]", "1"}], "||", 
      RowBox[{"x", "\[GreaterEqual]", 
       SqrtBox["2"]}]}]},
    {"2", 
     RowBox[{
      RowBox[{"x", "\[LessEqual]", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["2"]]}]}], "||", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["2"]], "\[LessEqual]", "x", "\[LessEqual]", "1"}], "||", 
      RowBox[{"x", "\[GreaterEqual]", 
       SqrtBox["2"]}]}]},
    {"3", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{237, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->846226381]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9252347],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Clip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clip"]], "InlineFormula"],
 " are piecewise functions of real arguments:"
}], "ExampleText",
 CellID->969637580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Min", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"Max", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
    RowBox[{"UnitStep", "[", "x", "]"}], ",", 
    RowBox[{"Clip", "[", 
     RowBox[{"x", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114714105],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Wj1vkzEQdvLmTdI0bfohPsYWWgQUmJiBMoAKlIX+gIYKqR0QqHRiyY6Q
CgOCLQsswE9Ayk/oABNLfoqxX/sS+3z+yBeRUr/2a989Pt+d7y7dbZ8cvnjZ
Pjk6aK89PG6/Pjw6eLP24NWxGMpKjJV+M8a2LjLxzMVT8ZWfP+KrHvFTW/6t
9Hq909NT8ffs7OxvMdLpdHrFp9/vfxjMLIuBmmhzQXhBtJloM92XbZnpB6Y+
ZfFYEe13OZQJmgUaznI9t6zbUWjtO2hYDvvkevpiwW8wqsgE+oDFHPuJMFcL
uQzfM9aaApfn1m7q6G0SB2f3sZ3UtHSXpkLd3sEcept0EiSPnNCbyZHntAZF
z1Vyrfjl4Yxi5GnaMyoXtZNVrizjEbctFMserE2xKD7ctkOJQS74gdBjex2f
cuFv2Dm0fkcjv+BICWvbL4TsfHTFcTHc0PyxhY3ieS4bKGui/1av3SYwyfcn
BYmKea4G57oen4YX2dTIvqBxjOyd5pkXyDBljLBm9Fkq0qi/SMX6Hu87HbOl
D5N5IDjz2aCtkrwpxKN6htnilvqT2fbO1C0+nlfYmCnauI+4hvpzfOhJ5cJ1
3W7p9iYx3+zfRv3G1PZR0yik9BqcvnMvof4Nog/rMWo5Pj8VtDuoX/egnee2
TixHZAu6B7EAeGpAhsdytF56sVz7wFzTycAnIrzYVnMtHRMvjFc9dOaQNIFv
kw9vaZMePpXKGPuF+NykG9uvOlVsGXB7PdatkopIE0S+IFIDZSlg+5aNrRgr
ypqv66dyZ13mjFhRH00Bn5szC/YBaLCUmyRX52bx0i3k0O12ae5NcnTR4QnS
pO+FFFnRK1vOPErL4rItGWyVtlXRjD3uWjnsFbQArMV8XzXk6MGRD2br0TI5
mhOUMUc4z4FGR+9g7IXAuuDEaO1QEZOdv6RqB9grxN51HsI7soS8/MyT8O9M
ziqJVmqE0grKc2DNYJlQjf39fek5in1YOgkyXXHewFn5sUSjLIsevmNAtmnx
mE8X4Gag5St1oSxUYRQP0eLGTe/FF9s/RDFLhhQjtubYfOy2B7sPaLh1ArQv
x5KlvVJsv37501pFnwjOdnA84O4pfNOpmoVdEaByuYZn3OU3j2bQmUySdSRI
K7w7TDUtRrzOlWZe4Up7IIay8wpTIlB9cGe1SFxwxuBFK+RaSRF8bTyWiGkG
FSHGIwlKP+AEFMoFZwTHjrRVYRlABNhCq9Osb7yTxjkIVAG2SR53xpL7erpc
jVXYu2+SVO5OURa4mob1BVc3cYaxrGV3X/fv6Ravg3PfMNZRVT3Qg6t8WM/y
ZwhJNQ3nXnfv32GmOXxDe7AlPuuKkSkFiFBxHBmOzf8vxmVHonCb0B5rtuhS
Tpz2zuG4azLUZt0VtDlkdVAJtm8G7BPjGgoW5K+7PgnSkJ5Sig7/avOxmLfL
bR9wC+HDlXu1Cn7rMGMOSgY4LsY1g9QaRBnR9dVc9hBasL2m0YZu0rqm89Ta
pVsD9lcnKIrjZd7unEnqFc+QZGgLSa0rhGO3XUt65u8SoYw9HD2Pmo/6OHEe
y9QnkRTOscMZXFhObtYa9m4pcblcvYrGw1SxNCD3W9AtoA1n9/ZOU+yJ1vXw
rZSUx7lcRsjhpmtFaRXBoexYpd/vd4pPt9uF+8jne+mshvrVMC3L8fnfRN8j
/ydEYTfyskWjjecdShJfyXd0hP8pQOcbt6Pdz9z0/XKu+o8WVvoHcI8lvA==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{467, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225882600]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->151129220],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " are piecewise functions when their arguments are assumed to be real:"
}], "ExampleText",
 CellID->48769526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Reals"}], "]"}], ",", 
   RowBox[{"PiecewiseExpand", "/@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Abs", "[", "x", "]"}], ",", 
      RowBox[{"Sign", "[", "x", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33381609],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVV9tOwzAMTW/r7gzBYBISGhMvSPwCGvAAvPAR1YS0PSDQ2NfsZ0OSOiM7
NU03ChKVOtepc3Ls2k72nK3mL6/ZajHLxo/L7H2+mH2MH96WaigKhBBrdZ+N
hHqW6sncaymVdH/b6jdSrxIlQyVDkkMaj5RMSOpx8yDyS9vGSh6QbYNsjwBL
jwttIM0lmmTfNlAxWcVgZWbFX7oQp2AReXTLwR07ZLi4+nFh1SbxS7WabN5Q
GKyPidGRAfqUkvWoiifsWrv4MqTVOi7HAipyDP/Ik4Qyp4oHrdJvsJ8H1fJr
k5n81yiM+jwq5lfKRLYuH7GqTxiUcANvLpihV9ATBh6/sOYHNXpxXogZVsIQ
9JaH7VXN7FLKntB2NaZSruVXp919lRuPR/g+R8U42V47JWl72y3YBXlEqNdL
Wy2OxRPoGkFvOnpm8O3aZQhTloMvLojCx+E/oXTldiWhjrmt84mr0L7Me2wH
5mN+xvInedmTWJv9wkj5DoodE/3oFvDsbtBg8fbfDdxzzsDhvIm6l7tFwVj2
5Ha9NWtk3gfG5XulL9qWafsXYlwlV7jsrCNnOmDBn0t4v9wTasRUJOr83mdP
ycgV65OfvX3OvGNtJoB8wVqZTBb3xGZCuJfSPZPn/w1E8Akpulpi\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{154, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182504483]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28050206],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["KroneckerDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KroneckerDelta"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DiscreteDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiscreteDelta"]], "InlineFormula"],
 " are piecewise functions of complex arguments:"
}], "ExampleText",
 CellID->947506887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"KroneckerDelta", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"DiscreteDelta", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->342926192],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlVl9LwzAQT9tlrdMx6x/0QWEPgiAiexP8AAqizz6XIayIOOa+6z5OvCaX
ml0vNh1DEAtNepe73/1yl93yXCxnr+/FspwW44dFMZ+V08/x/ccCVEkkhFjB
e3Iq4FvBl35XSsE8gDEB8QXnudb2YIyFmUWlVvrRVq5cop3UXglZbfN+I3L8
T1GuYOiBeE70O0R+9NiFRbkm8pkytRsQ/RNj1z1aHwYJ4i5GiXHeJ3ZHypy7
PtFngXjWP0XZENNutY2ro3Gsv2R3GTO75HK2pxe/ZSFytEwR3yTIPpqFrO1x
SaJPFhylK/q6d9LQ2Mh9Fjf14zosIweczzk910MnV5IgCqxxM+4oEPXYz1rW
MVAbs1qXv59PZVW12mr/Jgfc6QlhnDfqwteDr3NoXrIOmLSCdCdpg7Fk0buc
oLYOQztE89cxYqMdslral9rR/aegrS+GcqK+YZ2XMqcdc8hW5mCjrFBsfh+2
N0tnDmWwnRzcbrS7C9brZos8bWbuMCO5Z/0S1yfqp3+rv3Tn+U0U9zbr3nXX
b6/mPiyiL7LKvEE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{215, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101424965]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332283978],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 " is a piecewise function of a Boolean argument:"
}], "ExampleText",
 CellID->288145478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"Boole", "[", "a", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171421025],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwqACxuAQDkP0fyAJj
lf//gTQzkGQGcuXgPAYQ9z8YDGJRNiDBCuTyQmlGsComIMkE5HGhqeYBEaxw
PlgtRDWURFLLSUW9INexwFWj+4GDBJsI6eWFxiMzUaqFsapih4aeKM1jEpHi
IKmQgREATzdohA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{36, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29236432]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->398863191],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Which",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Which"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Switch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Switch"]], "InlineFormula"],
 " can be interpreted as piecewise functions: "
}], "ExampleText",
 CellID->474547059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{"a", ",", "x", ",", "y"}], "]"}], ",", 
    RowBox[{"Which", "[", 
     RowBox[{"a", ",", "x", ",", "b", ",", "y", ",", "c", ",", "z"}], "]"}], 
    ",", 
    RowBox[{"Switch", "[", 
     RowBox[{"u", ",", "v", ",", "x", ",", "w", ",", "y"}], "]"}]}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217246397],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1Wd1u0zAUdpqk6TraDbbBxA0VPxIIhARi7HYTgnFBX4A/tZqQtgsEGuOa
e24qeIHeAe8AUh+hj9A3YLxBsBO7sU8+N16SVmqdc+zz48/Hx8dpf3h69O79
8PT4cNg7OBl+PDo+/NR79uGEs3yPMe8VY+zuNuPPMX9KvuLzmn/TR/rUF7/B
ZDIZjUb8dzqdir7VeV+DMyPehlxVV3B9pTNmTckPxTjeMj8RE92sAXhNIu9L
+chRXtgR4j9z3rFwrjUdzi5DbpjMNvNAqjc4a6Ulm1Dyh+Fti2CwRujQbl1y
578JRnluRDQGlTWGROMvY0YrpBdFSaDQoX5pNEUG+12khfabvka5NXPDv4zv
DYXnAjnovSWCNiSOj+PiXSnIlvRB7U6Ib5Ctcl4ikha3Zfs1GblF9OxIf64S
/vWCue4S+h6hXybW2tps9N6O5Ksc4sdmvlDRHMg1dvFQ6bi/wCa1sU7G0N0X
SV3nyXHUhr7Cgt6SOtsJrWINxWQDRLhfQKO4vSgR/Gyx0QE6dGRUXlKnRYX8
Sqx0NW2ZLbUHUlDUB+8utQqJBzk0KKr6+jJXdKFNF3yptY4Vu5DgI/g0M1c/
W+waQgV2TmYDylBcG+7oGzFBs587/iHLMgPE3bBzAerBtYJeF5U8wXJS1eO8
HOILvAGZE5/ZDci1YY8tngd/mreXtQ4Zt84YV1Wuuaa5DCsR10bFWc0hWl/q
WbfgjO20iZYuHOVWq6kzLySt0t2Bui/ViGVyCzD2Mc28tJpZibPqSgi+Bf06
vQe93a95DhEnr0jU2jGuu99o/Tp/X6L8RLa0mnfzYofQLYsXVe+Iqp67A+zp
9AjOAtXbwsJurNfA/JLLb7uz2SxdbYltnXe+25o90X4nfnmaunTeNBvtAXyF
5vrvi1jDQ2JHzMDjpPDcs2Kd2xk+n8JgMBBYt3LYlb0pYsypx98g5kVxrnDH
bxWox+VPFlRlPyA0jnHXGeDagJ4jtttiU1utVPJRrd7Ru1iP0DTflLOGThyx
XDcsXlyLs3xRpKfoJrgpkX1eynMd/9QGrv1vxguqqLy8wx3NtZ48KDUvVRPg
Oso2m8VStvvP5hL8Fvk3KO2p/b6wXNSXFE2O88PVMZ6J/jZDVSuoZryleYrG
rRIa17G41nwa628E1LvD33DsC2PMH2mlb3CbMc5Cf41R+TsnxvjMkFJ5G8cb
Hqti+KyifRbwc/1L8hmPx/o7T32l/iXjhbT9Xwjm/Qcgn7Vf\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{347, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->617771542]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->261509589],

Cell[TextData[{
 "Convert ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FractionalPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionalPart"]], "InlineFormula"],
 " for finite ranges:"
}], "ExampleText",
 CellID->358402805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", "3"}], "}"}], ",", 
   RowBox[{"PiecewiseExpand", "/@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Floor", "[", "x", "]"}], ",", 
      RowBox[{"Ceiling", "[", "x", "]"}], ",", 
      RowBox[{"Round", "[", "x", "]"}], ",", 
      RowBox[{"IntegerPart", "[", "x", "]"}], ",", 
      RowBox[{"FractionalPart", "[", "x", "]"}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->320213802],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{480, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->612278110]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20239171],

Cell[TextData[{
 "Convert ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Quotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quotient"]], "InlineFormula"],
 " when the number of cases is finite:"
}], "ExampleText",
 CellID->221978717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"0", "\[LessEqual]", "k", "\[LessEqual]", 
    RowBox[{"3", "m"}]}], ",", 
   RowBox[{"PiecewiseExpand", "/@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"k", ",", "m"}], "]"}], ",", 
      RowBox[{"Quotient", "[", 
       RowBox[{"k", ",", "m"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->372437897],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WUtPFEEQHmZ2dpfXAoLyjusDNSLoRVDBeNDoQYkX4QwhJhAlEiSBxOj6
D0g0hiNHjvwE/4AJdy4cOfIT2u6eqp3emuqe2YHdhO3pV9VX1dVV3w4LK9tr
HzdWttdXV6pvtlY219ZXv1Zff9mSQ0Gb53kn8m9xyJPPQj7pvxMhZGt+d6jv
wu7u7l/9OTs7+xePB7VaTeiPF8ovX4rwCnoaPt2yU5LtoGwD2QayDaHVq4N4
tS8fC7L9wcovahwKY9T3vB6tNhqpf3vDel+8Lkjp+6DZHPtpRxDEmkpgSyE/
jrDeh13ZkahFvZesOWyJ933iI2JtYtSBwPC+D9EVGFGkvikCXyTiEkZwJgAp
tVS96nEy4Ql6ZkusZx6z0vHWTInonsxr6fKe7e3tye/j4+OhJqTtKGly20jO
PT7xpXvHh5bNluFERkUUkxjvVXbXO9baOyCrZMzWj8wbIWfGr7qeQ18nkRz1
5QRkuSheZZ9EAN03fgm6R0F2e2bZNAJQcjvMjRkSfeuJ4DlyvqBZv8z6Kw0r
auDPrWLIUP3+Jk6XxmAPtAPCFYN89VM4sEKo290F/RDaQWJrCDr6hHGPC7Ed
njfDandn59ji0BiNpXaza2nM6L2BTEg1/dHqdZ94gD+RXtMiQ+qs3R6m0oZk
d5G1p0JWlQFZFGnn5+cNFsg+rMNa1U32VwD7MMw/tWJWm65wfktg7GFWKdlD
gs8GiIHPm8nzpyh4jtLL+BNRcOMYlw4UpEJTHL5IVuw+sqZk8Y2ZNa417x9j
tcmb6i6LbmNi1LTAnkswvnn9aEE/WD8MLfYxtzT6tyAM7kRrQENWuAv7FmCH
jrkE72PlGPP3QMpDw8JYyyhzkuk63gKi+y2QvdNimbQW5pP4icy3g4b3uaUp
XB0XkvKZzJed0ii/jaTt7+8fHh6qxw1h5ldZESR3PT09rWdtrHpFwVc9JS/A
ymGMt0WuN06gSOx4wp78MxFX8ORN7WJHO4jufrCpyK5WSNUPaIWwzeGjzc1N
6Qs3Us0Fl5eXlccoF6KVDFlXCfdBNqScEjNHF4uKejgtWmZZ7HMiZoYuzGZN
wch1/h7PjIneT0RENVBEJcFXOczStFo0lzm4yk3vGpWTVt3y+cjNkfl7kK3a
UR7WHB5k1hXBV8F8/ucZOLJ3NasYuKq8IdwgNY6/b3QNaaipY7lQXIyJR7Fi
59hUO5/hJkyb6C+pfBYxXJzGsflWiVpk59y2THULbJiG+essdhtDQi4+kAnj
uOAzE2JoZFXp3LtPJGtHrG3U0OYbEXi5nLoiklmF1lebzy/Coc23b/b8MeHU
RNnyiGjMD26PzRrnEdk9n77esOu5cLHKKitjBhC/yLHXzWLT99Aq6N7Rund2
Wdke/gegw34aublGcyyuFQjwXUNWhkbldbYAE2VgNHPb/WBjWFm9wL1HoHzW
HlHNnnYWJlW+kMZs7Ij3p8l+FMoeaDGrYctHAM9u5hgPhJBfvYL8RRFV3YOD
gylBs+INVk+ymj3QK9Lf+1HfLZH+Tbs+w6MaZ4Z3dJRlL8L4bauWAG8Mg/Vb
Rl/Mk300nh1ySA2fFMlYpWwlXZp6nCbSr2aSgqf2SMTRp/rf49WFo6Oj6BTk
Yc8YvojQ/tJPr4i233r0JUj7o3vR/5G9tv8YFxM6\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{218, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216280552]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18361],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Which",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Which"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PiecewiseExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PiecewiseExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Boole",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boole"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Max",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Max"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnitStep",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnitStep"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sign",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sign"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolatingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolatingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxPiecewiseCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxPiecewiseCases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interval",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interval"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UniformDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UniformDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TriangularDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TriangularDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13132]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13818],

Cell[TextData[ButtonBox["Piecewise Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PiecewiseFunctions"]], "Tutorials",
 CellID->21875],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Conditionals"]], "Tutorials",
 CellID->10900]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Piecewise",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Piecewise"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->685246220],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->4248210],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "MoreAbout",
 CellID->559236928],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->34376628],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->11885618]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Piecewise - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 33.8983350}", "context" -> "System`", 
    "keywords" -> {
     "box function", "boxcar function", "discontinuous functions", "FEM", 
      "finite elements", "hybrid systems", "interval-defined functions", 
      "ramp function", "saturation function", "sawtooth function", 
      "sectionally defined functions", "square wave", "step function", 
      "switching", "triangle wave"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Piecewise[{{val_1, cond_1}, {val_2, cond_2}, ...}] represents a \
piecewise function with values val_i in the regions defined by the conditions \
cond_i. Piecewise[{{val_1, cond_1}, ...}, val] uses default value val if none \
of the cond_i apply. The default for val is 0. ", "synonyms" -> {}, "title" -> 
    "Piecewise", "type" -> "Symbol", "uri" -> "ref/Piecewise"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15088, 514, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->378090748]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 94323, 2890}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3775, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4398, 105, 47, 1, 70, "ObjectName",
 CellID->16937],
Cell[4448, 108, 2388, 77, 70, "Usage",
 CellID->4599]
}, Open  ]],
Cell[CellGroupData[{
Cell[6873, 190, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7351, 207, 315, 13, 70, "Notes",
 CellID->31499],
Cell[7669, 222, 338, 13, 70, "Notes",
 CellID->13192],
Cell[8010, 237, 734, 28, 70, "Notes",
 CellID->30554],
Cell[8747, 267, 494, 18, 70, "Notes",
 CellID->19124],
Cell[9244, 287, 220, 8, 70, "Notes",
 CellID->31],
Cell[9467, 297, 601, 23, 70, "Notes",
 CellID->28066],
Cell[10071, 322, 463, 17, 70, "Notes",
 CellID->774770502],
Cell[10537, 341, 864, 32, 70, "Notes",
 CellID->26429],
Cell[11404, 375, 2162, 74, 70, "Notes",
 CellID->12722],
Cell[13569, 451, 1482, 58, 70, "Notes",
 CellID->29556]
}, Closed]],
Cell[CellGroupData[{
Cell[15088, 514, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->378090748],
Cell[CellGroupData[{
Cell[15473, 528, 147, 5, 70, "ExampleSection",
 CellID->70272305],
Cell[15623, 535, 122, 3, 70, "ExampleText",
 CellID->807528759],
Cell[CellGroupData[{
Cell[15770, 542, 487, 17, 28, "Input",
 CellID->90260051],
Cell[16260, 561, 2465, 44, 148, "Output",
 Evaluatable->False,
 CellID->112203393]
}, Open  ]],
Cell[18740, 608, 125, 3, 70, "ExampleDelimiter",
 CellID->181844988],
Cell[18868, 613, 87, 1, 70, "ExampleText",
 CellID->966066121],
Cell[CellGroupData[{
Cell[18980, 618, 408, 15, 28, "Input",
 CellID->247752391],
Cell[19391, 635, 931, 19, 64, "Output",
 Evaluatable->False,
 CellID->394029382]
}, Open  ]],
Cell[20337, 657, 125, 3, 70, "ExampleDelimiter",
 CellID->229387714],
Cell[20465, 662, 688, 21, 70, "ExampleText",
 CellID->371889260],
Cell[CellGroupData[{
Cell[21178, 687, 197, 8, 70, "Input",
 CellID->9003486],
Cell[21378, 697, 204, 5, 50, "Output",
 CellID->244590145]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21631, 708, 217, 7, 70, "ExampleSection",
 CellID->31826],
Cell[21851, 717, 71, 1, 70, "ExampleText",
 CellID->692567804],
Cell[CellGroupData[{
Cell[21947, 722, 567, 20, 70, "Input",
 CellID->982287796],
Cell[22517, 744, 1008, 21, 70, "Output",
 Evaluatable->False,
 CellID->131782736]
}, Open  ]],
Cell[23540, 768, 74, 1, 70, "ExampleText",
 CellID->657109895],
Cell[CellGroupData[{
Cell[23639, 773, 343, 12, 70, "Input",
 CellID->40157904],
Cell[23985, 787, 290, 10, 51, "Output",
 CellID->144047193]
}, Open  ]],
Cell[24290, 800, 50, 1, 70, "ExampleText",
 CellID->28906311],
Cell[CellGroupData[{
Cell[24365, 805, 215, 7, 70, "Input",
 CellID->47888533],
Cell[24583, 814, 2998, 53, 70, "Output",
 Evaluatable->False,
 CellID->389098393]
}, Open  ]],
Cell[27596, 870, 71, 1, 70, "ExampleText",
 CellID->157116695],
Cell[CellGroupData[{
Cell[27692, 875, 175, 6, 70, "Input",
 CellID->775211676],
Cell[27870, 883, 208, 7, 51, "Output",
 CellID->228555634]
}, Open  ]],
Cell[28093, 893, 124, 3, 70, "ExampleDelimiter",
 CellID->10372683],
Cell[28220, 898, 220, 8, 70, "ExampleText",
 CellID->194830],
Cell[CellGroupData[{
Cell[28465, 910, 354, 12, 70, "Input",
 CellID->182490224],
Cell[28822, 924, 159, 5, 36, "Output",
 CellID->248358922]
}, Open  ]],
Cell[28996, 932, 67, 1, 70, "ExampleText",
 CellID->13402949],
Cell[CellGroupData[{
Cell[29088, 937, 489, 16, 70, "Input",
 CellID->270469175],
Cell[29580, 955, 788, 17, 70, "Output",
 Evaluatable->False,
 CellID->232042126]
}, Open  ]],
Cell[CellGroupData[{
Cell[30405, 977, 446, 15, 70, "Input",
 CellID->33791510],
Cell[30854, 994, 877, 18, 70, "Output",
 Evaluatable->False,
 CellID->811809967]
}, Open  ]],
Cell[31746, 1015, 195, 8, 70, "ExampleText",
 CellID->190370060],
Cell[CellGroupData[{
Cell[31966, 1027, 484, 16, 70, "Input",
 CellID->37343957],
Cell[32453, 1045, 893, 29, 94, "Output",
 CellID->747074678]
}, Open  ]],
Cell[33361, 1077, 76, 1, 70, "ExampleText",
 CellID->361415468],
Cell[CellGroupData[{
Cell[33462, 1082, 419, 14, 70, "Input",
 CellID->228995683],
Cell[33884, 1098, 904, 29, 78, "Output",
 CellID->141209690]
}, Open  ]],
Cell[34803, 1130, 125, 3, 70, "ExampleDelimiter",
 CellID->414130022],
Cell[34931, 1135, 119, 3, 70, "ExampleText",
 CellID->39581900],
Cell[CellGroupData[{
Cell[35075, 1142, 382, 13, 70, "Input",
 CellID->605167665],
Cell[35460, 1157, 2071, 38, 70, "Output",
 Evaluatable->False,
 CellID->182303502]
}, Open  ]],
Cell[37546, 1198, 92, 1, 70, "ExampleText",
 CellID->18249243],
Cell[CellGroupData[{
Cell[37663, 1203, 412, 14, 70, "Input",
 CellID->287426805],
Cell[38078, 1219, 2005, 37, 70, "Output",
 Evaluatable->False,
 CellID->55591517]
}, Open  ]],
Cell[40098, 1259, 125, 3, 70, "ExampleDelimiter",
 CellID->510868280],
Cell[40226, 1264, 79, 1, 70, "ExampleText",
 CellID->2207936],
Cell[40308, 1267, 305, 11, 70, "Input",
 CellID->93174911],
Cell[CellGroupData[{
Cell[40638, 1282, 154, 5, 70, "Input",
 CellID->35875877],
Cell[40795, 1289, 158, 5, 36, "Output",
 CellID->512647280]
}, Open  ]],
Cell[40968, 1297, 117, 3, 70, "ExampleText",
 CellID->420480245],
Cell[CellGroupData[{
Cell[41110, 1304, 203, 6, 70, "Input",
 CellID->235578352],
Cell[41316, 1312, 157, 5, 36, "Output",
 CellID->36053368]
}, Open  ]],
Cell[41488, 1320, 125, 3, 70, "ExampleDelimiter",
 CellID->176420804],
Cell[41616, 1325, 86, 1, 70, "ExampleText",
 CellID->184022927],
Cell[CellGroupData[{
Cell[41727, 1330, 429, 14, 70, "Input",
 CellID->111260802],
Cell[42159, 1346, 2232, 41, 70, "Output",
 Evaluatable->False,
 CellID->37183769]
}, Open  ]],
Cell[44406, 1390, 125, 3, 70, "ExampleDelimiter",
 CellID->290329989],
Cell[44534, 1395, 73, 1, 70, "ExampleText",
 CellID->20405899],
Cell[CellGroupData[{
Cell[44632, 1400, 443, 15, 70, "Input",
 CellID->7649316],
Cell[45078, 1417, 1257, 25, 70, "Output",
 Evaluatable->False,
 CellID->473751903]
}, Open  ]],
Cell[46350, 1445, 114, 3, 70, "ExampleText",
 CellID->448714350],
Cell[CellGroupData[{
Cell[46489, 1452, 205, 7, 70, "Input",
 CellID->452065565],
Cell[46697, 1461, 2567, 46, 70, "Output",
 Evaluatable->False,
 CellID->170123928]
}, Open  ]],
Cell[49279, 1510, 125, 3, 70, "ExampleDelimiter",
 CellID->219723520],
Cell[49407, 1515, 95, 1, 70, "ExampleText",
 CellID->303878304],
Cell[CellGroupData[{
Cell[49527, 1520, 573, 19, 70, "Input",
 CellID->307508434],
Cell[50103, 1541, 162, 5, 36, "Output",
 CellID->227820115]
}, Open  ]],
Cell[50280, 1549, 124, 3, 70, "ExampleDelimiter",
 CellID->46103887],
Cell[50407, 1554, 85, 1, 70, "ExampleText",
 CellID->405374291],
Cell[CellGroupData[{
Cell[50517, 1559, 327, 11, 70, "Input",
 CellID->128275628],
Cell[50847, 1572, 267, 10, 58, "Output",
 CellID->379404532]
}, Open  ]],
Cell[51129, 1585, 125, 3, 70, "ExampleDelimiter",
 CellID->735029652],
Cell[51257, 1590, 83, 1, 70, "ExampleText",
 CellID->745546671],
Cell[CellGroupData[{
Cell[51365, 1595, 484, 16, 70, "Input",
 CellID->615059915],
Cell[51852, 1613, 3140, 92, 133, "Output",
 CellID->809544961]
}, Open  ]],
Cell[55007, 1708, 123, 3, 70, "ExampleDelimiter",
 CellID->8739657],
Cell[55133, 1713, 71, 1, 70, "ExampleText",
 CellID->253080921],
Cell[CellGroupData[{
Cell[55229, 1718, 536, 18, 70, "Input",
 CellID->16113946],
Cell[55768, 1738, 438, 16, 51, "Output",
 CellID->104079813]
}, Open  ]],
Cell[CellGroupData[{
Cell[56243, 1759, 565, 19, 70, "Input",
 CellID->7727846],
Cell[56811, 1780, 2940, 52, 70, "Output",
 Evaluatable->False,
 CellID->10419576]
}, Open  ]],
Cell[59766, 1835, 125, 3, 70, "ExampleDelimiter",
 CellID->632752625],
Cell[59894, 1840, 258, 8, 70, "ExampleText",
 CellID->94656176],
Cell[CellGroupData[{
Cell[60177, 1852, 246, 8, 70, "Input",
 CellID->859269190],
Cell[60426, 1862, 1098, 22, 70, "Output",
 Evaluatable->False,
 CellID->376065142]
}, Open  ]],
Cell[61539, 1887, 124, 3, 70, "ExampleDelimiter",
 CellID->38782911],
Cell[61666, 1892, 94, 1, 70, "ExampleText",
 CellID->322806400],
Cell[CellGroupData[{
Cell[61785, 1897, 247, 9, 70, "Input",
 CellID->106641986],
Cell[62035, 1908, 1304, 25, 70, "Output",
 Evaluatable->False,
 CellID->99453195]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63388, 1939, 223, 7, 70, "ExampleSection",
 CellID->17777],
Cell[63614, 1948, 78, 1, 70, "ExampleText",
 CellID->161684625],
Cell[CellGroupData[{
Cell[63717, 1953, 1087, 34, 70, "Input",
 CellID->223642391],
Cell[64807, 1989, 238, 8, 51, "Output",
 CellID->336581153]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[65094, 2003, 233, 7, 70, "ExampleSection",
 CellID->22338],
Cell[65330, 2012, 261, 7, 70, "ExampleText",
 CellID->216819620],
Cell[CellGroupData[{
Cell[65616, 2023, 804, 26, 70, "Input",
 CellID->52736705],
Cell[66423, 2051, 1521, 29, 70, "Output",
 Evaluatable->False,
 CellID->314080079]
}, Open  ]],
Cell[CellGroupData[{
Cell[67981, 2085, 111, 3, 70, "Input",
 CellID->83971907],
Cell[68095, 2090, 1348, 43, 100, "Output",
 CellID->846226381]
}, Open  ]],
Cell[69458, 2136, 123, 3, 70, "ExampleDelimiter",
 CellID->9252347],
Cell[69584, 2141, 573, 22, 70, "ExampleText",
 CellID->969637580],
Cell[CellGroupData[{
Cell[70182, 2167, 451, 14, 70, "Input",
 CellID->114714105],
Cell[70636, 2183, 1981, 37, 70, "Output",
 Evaluatable->False,
 CellID->225882600]
}, Open  ]],
Cell[72632, 2223, 125, 3, 70, "ExampleDelimiter",
 CellID->151129220],
Cell[72760, 2228, 356, 12, 70, "ExampleText",
 CellID->48769526],
Cell[CellGroupData[{
Cell[73141, 2244, 349, 11, 70, "Input",
 CellID->33381609],
Cell[73493, 2257, 874, 18, 70, "Output",
 Evaluatable->False,
 CellID->182504483]
}, Open  ]],
Cell[74382, 2278, 124, 3, 70, "ExampleDelimiter",
 CellID->28050206],
Cell[74509, 2283, 374, 12, 70, "ExampleText",
 CellID->947506887],
Cell[CellGroupData[{
Cell[74908, 2299, 291, 9, 70, "Input",
 CellID->342926192],
Cell[75202, 2310, 777, 17, 70, "Output",
 Evaluatable->False,
 CellID->101424965]
}, Open  ]],
Cell[75994, 2330, 125, 3, 70, "ExampleDelimiter",
 CellID->332283978],
Cell[76122, 2335, 218, 7, 70, "ExampleText",
 CellID->288145478],
Cell[CellGroupData[{
Cell[76365, 2346, 143, 4, 70, "Input",
 CellID->171421025],
Cell[76511, 2352, 409, 11, 70, "Output",
 Evaluatable->False,
 CellID->29236432]
}, Open  ]],
Cell[76935, 2366, 125, 3, 70, "ExampleDelimiter",
 CellID->398863191],
Cell[77063, 2371, 454, 17, 70, "ExampleText",
 CellID->474547059],
Cell[CellGroupData[{
Cell[77542, 2392, 431, 13, 70, "Input",
 CellID->217246397],
Cell[77976, 2407, 1480, 28, 70, "Output",
 Evaluatable->False,
 CellID->617771542]
}, Open  ]],
Cell[79471, 2438, 125, 3, 70, "ExampleDelimiter",
 CellID->261509589],
Cell[79599, 2443, 720, 28, 70, "ExampleText",
 CellID->358402805],
Cell[CellGroupData[{
Cell[80344, 2475, 527, 15, 70, "Input",
 CellID->320213802],
Cell[80874, 2492, 2700, 48, 70, "Output",
 Evaluatable->False,
 CellID->612278110]
}, Open  ]],
Cell[83589, 2543, 124, 3, 70, "ExampleDelimiter",
 CellID->20239171],
Cell[83716, 2548, 345, 13, 70, "ExampleText",
 CellID->221978717],
Cell[CellGroupData[{
Cell[84086, 2565, 422, 13, 70, "Input",
 CellID->372437897],
Cell[84511, 2580, 1899, 35, 70, "Output",
 Evaluatable->False,
 CellID->216280552]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86471, 2622, 311, 9, 70, "SeeAlsoSection",
 CellID->18361],
Cell[86785, 2633, 3680, 134, 70, "SeeAlso",
 CellID->13132]
}, Open  ]],
Cell[CellGroupData[{
Cell[90502, 2772, 314, 9, 70, "TutorialsSection",
 CellID->13818],
Cell[90819, 2783, 148, 3, 70, "Tutorials",
 CellID->21875],
Cell[90970, 2788, 135, 3, 70, "Tutorials",
 CellID->10900]
}, Open  ]],
Cell[CellGroupData[{
Cell[91142, 2796, 305, 8, 70, "RelatedLinksSection"],
Cell[91450, 2806, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91850, 2823, 319, 9, 70, "MoreAboutSection",
 CellID->685246220],
Cell[92172, 2834, 134, 3, 70, "MoreAbout",
 CellID->4248210],
Cell[92309, 2839, 136, 3, 70, "MoreAbout",
 CellID->559236928],
Cell[92448, 2844, 156, 3, 70, "MoreAbout",
 CellID->34376628],
Cell[92607, 2849, 148, 3, 70, "MoreAbout",
 CellID->11885618]
}, Open  ]],
Cell[92770, 2855, 29, 0, 70, "History"],
Cell[92802, 2857, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

