(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    111442,       3547]
NotebookOptionsPosition[     95926,       2996]
NotebookOutlinePosition[     97434,       3036]
CellTagsIndexPosition[     97348,       3031]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Logical and Piecewise Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LogicalAndPiecewiseFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Logical and Piecewise Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Piecewise" :> Documentation`HelpLookup["paclet:ref/Piecewise"],
           "Expand" :> Documentation`HelpLookup["paclet:ref/Expand"], 
          "$MaxPiecewiseCases" :> 
          Documentation`HelpLookup["paclet:ref/$MaxPiecewiseCases"], 
          "Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "LogicalExpand" :> 
          Documentation`HelpLookup["paclet:ref/LogicalExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Piecewise\"\>", 2->"\<\"Expand\"\>",
        3->"\<\"$MaxPiecewiseCases\"\>", 4->"\<\"Simplify\"\>", 
       5->"\<\"LogicalExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraic Transformations\"\>", 
       2->"\<\"Inequalities\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PiecewiseExpand", "ObjectName",
 CellID->28237],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PiecewiseExpand",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PiecewiseExpand"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]expands nested piecewise functions in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to give a single piecewise function. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PiecewiseExpand",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PiecewiseExpand"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["assum", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]expands piecewise functions using assumptions. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PiecewiseExpand",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PiecewiseExpand"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["assum", "TI"], ",", 
        StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]does the expansion over the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6272]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The result from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PiecewiseExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PiecewiseExpand"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is normally ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " where none of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " contain ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1792],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 " converts such functions as ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Which",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Which"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12200],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PiecewiseExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PiecewiseExpand"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["assum", "TI"], ",", 
    StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
 " assumes that both the input and output of every function appearing in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is in the domain ",
 Cell[BoxData[
  StyleBox["dom", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26343],

Cell[TextData[{
 "Common choices for ",
 Cell[BoxData[
  StyleBox["dom", "TI"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Reals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complexes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17519],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 " attempts to simplify combinations of conditions that appear in ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7481],

Cell["The following options can be given: ", "Notes",
 CellID->3370],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Assumptions"], 
    ButtonBox["$Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Assumptions"], Cell[TextData[{
     "default assumptions to append to ",
     Cell[BoxData[
      StyleBox["assum", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TimeConstraint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TimeConstraint"], "30", Cell["\<\
for how many seconds to try simplifying each set of conditions \
\>", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->8991]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->204555231],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->73732482],

Cell["\<\
Expand a nested piecewise expression to a single piecewise function:\
\>", "ExampleText",
 CellID->895155080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Piecewise", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Piecewise", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"x", "<", "1"}]}], "}"}], "}"}], ",", "2"}], "]"}], ",", 
      RowBox[{"x", ">", "0"}]}], "}"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74651977],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVs1OAjEQLrsLu/ypMcbgjQQvyCMYyHrRkyefYIMkEGLcIAdu+wgceQSO
PIKPwGPwGLXdnUozO5WuEGOT7bTT9vtmpjOF52g+Hr1F88kwaj/Nong8GX60
H99nQuWWGGNT8fVaTIy5GKXflHMh9d6VvbdYLD7TttvtXvd6N0kSnjbmi84V
ECFIuV4G6TAYsKw5YuiBzCNVZCePctUY4DL3WwunzHNH4Ws6j+SroV0DG6ac
fX/NVTbGL4CIPxBYUu+Z7ae1hb1wgAmCwLIVdSMOJIPKEtsM6Kdh3bPkY35F
oqnMlFb6Ql6Tu0b/VhuA/TIqMihNbl9h3VSVxWm1Wq3XazmsorjR8T5Du35T
cT2Nf+8R5vfR/NyG+WAF6txxHC+XS4o7QHMrr40V2TXeoI6BbWgSHEUr1Y4Z
V24Dze0r986Kj86sOj9UyfdW6KqypRe+eiEOnuojj8rE7ZjfJh9OhTkf1Epg
vjUSTecOAaMGko5fMayAF7cLx2yQ87aCdhyDjm/k4gislyPOqhe2juzB9erB
vg7/KVMwOp43cjENDHx2tY3nTUBTeVk/KWr1pLbmY4FfKpxvGo+32WyStG23
W/UmYAZ8p5ck3g3SdshdLcC4BZn90mT/l1npC84OI14=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{107, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74886745]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->870838768],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVktuwjAQNfmQUn5SN6U7JBZV1XuUbsodIoQEi6oRZcEuR2DJEVhyhB4h
x8gxXE8yA854gEhFFZawzcTz3vj5YfIRr+azz3i1mMbD8TJO5ovp9/Dta2lC
fkMpNTGf14Eyc21mxWeitRnt3oc+WK/XP0XL83x8jPtpmuqiqch0voHo4QjP
Qxw9hRNVNs9MAzM+ikhN6CBVU1OIq/xDFLNOf/eQx449iXz3bFWnDpNT339z
hSf1u0PF+wIWxIPT9TtRmeHSLjxkKqmKhhF6AoiQMBDxZQe0YQyOLK7mLyIa
OROqjMDy4qr3m42CGiHu39YwxDg9L8+q1GS73e52O9q9q2XH0bLJtORnbKNX
vWav6mFt5MFzKEmSbDYbmLbYqq6VTWguCteJo7h+ic5WdcnlLUH/y4rV8/ao
Vi45eYQVyHfMLXj2vJO7uA+uGN1QpDA/0QDzPRGdu6QjKk0eKH4XFXeQZznr
X9hCXXUysbevyEGYdv3X3od0ElX1+Fny+8RiD/b7fVq0LMuiWvx9XXXGg4jO
3xFkrGcxl+4cYPJx1eHfEt+FVOMXK8gCcA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{78, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->180484406]
}, Open  ]],

Cell[TextData[{
 "Convert a composition of special piecewise functions to a single ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->448183362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"Max", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"UnitStep", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->363411343],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"Max", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"UnitStep", "[", "y", "]"}]}], "]"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->429565081]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->31075914],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdV01OAjEUHpgpCPKjbMQdJq4UrmBcoRsT3Ro3E2IiC+MESWRDOAJLjsCS
I3gEjsExaqfTB53XN0PHn1nYZNrp6+s3X19fP8qdP355fvXHw4HfuRn5wctw
8N7pv42EyS04jjMVz2XbEe9cvMlnyrloo7omak8Y71V7Kq1uWHuTyeRTls1m
Uw4tbjhbFucB9du7ee5sNlPWA+R1KKqi6BZVy9B4RVRht6zGI0A5vJ1D2aA9
JvD0PlP4XiLbEKUuV7+bteMj18O2I9FgtIqYv2tYTJ+WhllU3zCxXZKpvhuh
V0NhVFVbSubJtrOUtUhamcaKAaL2xZIar2RlHYtBHcWAjq/+bQmB+sCllbhv
WWJLx65mYGNW3+Nu5sURiYMz2cuwIsh6lfaqQK7A2aG/CxGEfPDQrAaJ3czA
rkv6XmVA6CkO1zztdH/kan3khp5qo09oN2n1hJhDrPNWzxCfKbxdXKVeuIvF
Yrlc8sRTnZ9+2p1DV+NuKn6T562f6RHR2QZBMJ/PKbZ/pZqAS0chRTX3ZEG+
ignrS4tw1hP3mxqJ15WF5//UzD6PNLNHjt6ieHVJr3DXWYJW6lpmq5FYYwG/
pHDs7r3m7aGKPOjfcxtljN1xNET6znNixRfuZRUd+8d6qOtf+q03G0uIAH0X
tdHBeERh1YzEs+Nm7nj6iq1UL1F59kbRW61WM1nW6zXOFHxW7O6alOqZKofP
TxrTBvI9I30vUhAgI84Vly7XT2n0j9cpfAGShrzt\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{125, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->39428336]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12193],

Cell["\<\
Expand a piecewise function with piecewise values and piecewise conditions:\
\>", "ExampleText",
 CellID->190006806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Piecewise", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Piecewise", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"x", "\[GreaterEqual]", "0"}]}], "}"}], "}"}], ",", "2"}], 
       "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Piecewise", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"x", ",", 
             RowBox[{"x", "\[LessEqual]", "1"}]}], "}"}], "}"}], ",", 
          RowBox[{"x", "/", "2"}]}], "]"}], "^", "2"}], "\[GreaterEqual]", 
       RowBox[{"1", "/", "2"}]}]}], "}"}], "}"}], ",", "3"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->349598872],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWL1PFEEUH253Ob7vgMScqAkoldJZGAoNWGgD6l9APIkJFMYLUtBdSWNC
SWJDSUmsrrSkpKSkpKSkXN/Me7M79/bN7dyKxk242Zmd997v/d5788Fme3/n
85f2/u52e/HtXruzs7v9bfHN1z0YikaUUj34e95S8J7Cm/nrpSm07m+kf+OD
g4Nf5rm+vh6FkQgmr1GrZyTU1hS9KHxq8BpD+y7XFXW73dQ8SmtSWjS1jyK9
KspGScrfr5Edd+yDaG+CzXoVYqmA71/bSrz8jRHj64IuPR778RdGZQtlXtTI
EpoyD43YL1qjFngv6pcz4KVu49xKkfOPorY62dIo69B+Emf9/A9GtwipnDtb
zFt51qbpHx8fO7FQ8cnJCVbq5eXlONPz1PShhFFIPRb1bpj+7e3t6elpmmUq
6KXvPCeemT6sECCiX5cGaAWVYF7S6mLVObBi+hcXFzjFo3WMeNR5pNNoOg1f
k5pG19HREekq83OF2V70InKl5AyfYbOqrHGzpn9zc0PRjBn+VeZfi7hJDAbU
BqIUZZ4rddZvhCAuXSsRM0S11+v5MQMqyqUWk3ex55xz7DwGQWx71170HGi6
urqSMD9Mw3MOZcF50nWfIYkd/zqdDgav4B/vTwv+DLv+N6xXHi/rNnJd8xj6
TX8AhmEz2tRKhGuXn52yiuN1O8Utp6F7VjOIE6jAPk6gPwwnpTWjWakBKS4b
KqvjauvPpHFn0A5r1tvo8PCQKpH7/qiybwlRr31aYFJhEbb7vI6s3uefsPkh
WIetD4vYvw+5FtZKEI0X+G8yDeFZmhCyKeK2KSKsk9RrNo7zYEWifWCS5s0U
EPIMuefYdcfnvPbdWesijpwhF4eOcYusTdM4Mg4DtMJG5gf6JD/yZyhwCNeS
PhZWCEeDcMhsD5sPq8w7mcOqWnmEdPbZKrw7K9Vq2Z7cbLxtdic0bmu9+VdR
8L5hrC/uo5LE0Lvo3aJ0ayGriUqYTOXgZl5x1/Vhm6BW3oeCsdH3lqvtDqJq
V8VBzJ2fn+OyUkCXpP0520jlHLY5nsnjEWHADSLKVrgcrVQhoRkJBukexX0Y
LXAyWxjhJypeC6gzv4nKfs0zqSURb9mtzEZsntpxpy1igvPLQExzJL1MnOP9
BLZCOvWUWbf9SWYd5fKbtt2rH4goNmyM3Bt3nJ21z87OkoAo2VWAM4HW4H7e
d/POv8uYNpnnto59uc6t8hzB0wPQSnnIs3chRxGDw+g5ULBhmaR5L0S9wB1F
TNb7XYiTyuLxQ5TB/3+qkd89X/kR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{183, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->507389241]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->805893054],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"1", 
     RowBox[{
      RowBox[{
       FractionBox["1", 
        SqrtBox["2"]], "\[LessEqual]", "x", "\[LessEqual]", "1"}], "||", 
      RowBox[{"x", "\[GreaterEqual]", 
       SqrtBox["2"]}]}]},
    {"2", 
     RowBox[{
      RowBox[{"x", "\[LessEqual]", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["2"]]}]}], "||", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["2"]], "\[LessEqual]", "x", "\[LessEqual]", "1"}], "||", 
      RowBox[{"x", "\[GreaterEqual]", 
       SqrtBox["2"]}]}]},
    {"3", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{237, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2755341]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83535809],

Cell[TextData[{
 "Convert ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->690244425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"Max", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->372097708],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWbFu2zAQZSzKsl3Hjgs46Jh2KNAhaNdOaZd26kcYQYFkKGqkGbz5Ezx6
ajt6NPoF/YN6yT/4M1hSurOo05GVIiYxigiwKD4d78Q78vhIf5pcX3z+Mrm+
PJ+cfLyaTC8uz7+dfPh6paHoQAhxo39vnwn9rPRT+rtRSpf2PTJ3OZvNfqfX
drttayTWwn1dRiKTiKFsCXgQ2dXSj1KX33Nd0Xw+V+kljCZhmiq8TJtBKrVD
oZW73gI7NvYztL1Sq4exGPt9SbzC2TG4dPeohPLWElWMtbkf0i9AGalwPACC
b0xj0+AHa6NH9HXNTeb1cgzWrJ4uWHuiy0SXv1ipP3uLJuAlE80Yygj6Y/de
As7FpsVgOG9H0I76Owa8XVEfyo9Ar4QSv1+yveNnSJ9FByzagW/hNcWKjpqo
hPAthyyK3k3YtzKwtZjEpMNKRW7PWm157xkLGC1qqQXedXwXoLt7IYPkaOy1
S3uI/u26/VvHLtEcO78HR3kTD5sYSlHOuz3lG6FUC42EZ7yQ7Ogel9QXrA2r
PmK1+Geax0eN5jfNS/zqWMWLHFM4ZLV1OW238+o/I4cerTv6TKTNaDM9MOqO
oH7E6sB5FSsrhjKfLVnedrdvk/aJJU1XAi6XVO3VGSt7TDS+ZKVOiRQ/nni7
78CLx9CfV1A/hTqukvwqlq3c2dhaLper1co8biw0l7XR6XS6WCxyNDx7wDyL
7KEPZWj2gLuCRNVjDbae/5c1VFvH9449VPRwgUPUXFnvjkn4GUxtJuG3G45P
lGRNft+xiprjOAy38POXBqtgMIbBrew9VsfAId0h9ftgGRVmxm1tBeAXZYaA
O89h6Q3PF6tzjmqZinIQXl9INkLj/ZzUn7K6qrGVMZGi9TrsBT3yAsqx4tnM
GOqIV2E1+4jiXq5PSsTbqh6bwVw+VM3YjK3nPtkMHaeeXeAjqwnCavznQI+s
ht+nunkMnl+47frWQrQRlrkUtD7IaQi3vts78KCM7w74SeDTD7ler+fptdls
MMe7WUlCbPEeoywFc3UzbmJracJI3hBZnnGcsWid85DXqsgc3ivf+Uf236A4
+AtOKrrx\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{212, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299296047]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165905118],

Cell["\<\
Expand functions with infinite numbers of pieces over a finite region: \
\>", "ExampleText",
 CellID->247422714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Floor", "[", "x", "]"}], ",", 
   RowBox[{"0", "<", "x", "<", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221852118],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVktugzAQNRhC/tm0apapqqqVeo+mm+YOKKqULKqiNAt2HIElR2DJEXoE
jsExXNv1NGYwuKhZxBIeMx4/2zPvIV7D4+7tPTzut+FqfQij3X77uXr+OHAX
dQghG/48LQkfMz6Sz4YxbvWeit6L4/hLtqqq1ic/TZKEyUYC3lEOMeXW5dZV
1ufW5xbml8bVA9GJMAaNKCzi/Xr5QMbRk2doXHdj3GOM1k7UCYfKTtH8dS+U
sWbtKLDnrHHDAOGZ84V3GRmyrs//7W7mKtz2yDFU+Y51VfvlYr0iA77igq+x
10f5HaF8+uq+Ek9GEZplWZ7nkJUWdje8GNljmCHAHTOqq52gzjcddY7eAVPH
Bn6KT4UjrIYcRVGapkwxrwsZMgd8BqZOGsi4FjbkgZ6HWoawOiCSGvfB0Xif
AL1TVufClfUmHV+3hve+o6ptapsr+8B0Fl6ivs6rOk/FmbNj4/x5lNZ3V1AW
VhpmobmGNvQ2teG7/u/sdsVhzWi68IqiSGQryxLH2Wpk1x5GwO9d+pop1IWy
j0zX08//EHG+AUFJ/Gc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{78, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165861075]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"PrimePi", "[", "x", "]"}], ",", 
   RowBox[{"0", "<", "x", "<", "6"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->187010840],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVktOwzAQdeKk/xaQQHRZgYAF96Dd0DtEFVK7QESli+xyhCxzhC57BI6Q
Y+QYZux6iDNxk2aBVEvx2OPxsz0zb5T3YLf++Ax2m1Uwm2+DcL1Zfc/evrag
4g5jbAnf65TBWMBIfUshQJo9l70XRdGPanmezws9j+NYqMa60HGAGIF0Qbpa
+iB9kLg+te7uyE6aCWxMYzHvTwsDZccLTc+67956xoDsHeob9rQckfW7VigD
Qzaj4Jnjygu7eqVf6y96St/idbpuzttE4eGsvRjfR5DeyRgsLlYr3+7riHCd
ab72pOlZ6klf2ys8ZcV4mqb7/R69ciKvK1qK7AmaG5g1dlTXuEE500zUG8v9
XYKNmSmLhCOlgRyGYZIkwpJT12TORZkZmKPDCjKNBUUeW+5Y9gzlQzkqTeyZ
kHn3xEswB6gP7afU1LSK9vksROTYRMsXceSaa7W+BFbVc20kCo6155qtpprW
/8myprPHZI6YzSxrQqa5ij5rzzKKfEXmHXEu29DSiIt3OBxi1bIso3yilaKJ
b7eVt1Av2GP9VBNBrCny1cilIreO/z7M+QUC2u12\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{78, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106163194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268165512],

Cell["\<\
Expand a Boolean expression that implies a finite number of possible cases: \
\>", "ExampleText",
 CellID->229979767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"0", "<", 
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"x", "+", 
      RowBox[{"Round", "[", 
       RowBox[{"x", "^", "2"}], "]"}]}], "]"}], "-", "x"}], "<", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->652596927],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "<", "x", "\[LessEqual]", 
   FractionBox["3", 
    SqrtBox["2"]]}], "||", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], "<", "x", "<", "2"}], "||", 
  RowBox[{
   RowBox[{"-", "2"}], "<", "x", "<", 
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["2"]]}]}], "||", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["3", 
     SqrtBox["2"]]}], "\[LessEqual]", "x", "<", 
   RowBox[{"-", "2"}]}]}]], "Output",
 ImageSize->{374, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180405948]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->655319122],

Cell["Expand assuming real parameters:", "ExampleText",
 CellID->92858253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{
     RowBox[{"Abs", "[", "x", "]"}], ",", 
     RowBox[{"Abs", "[", "y", "]"}]}], "]"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->130507080],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81SFDEQDjs7u/y4IFggJ4vSi/hTWlpqeRG4SHnwDfSwhVbBQdkCDtz2
ETjyCBx5BB+Bx+Ax4mYmYWe+9Ez+JuxiOVU7M0k63Z1OpzP9Eb72T/Z//uqf
HOz1N3aP+oP9g73jjc+HR6OqZIaxmWPG2Md1Nnrno7fsJ66T0Y+xe6N7W1b9
yGoWxT1RVDx77GUtibi3T09P/2TX9fV1F2hXRzdRFJSpfLaYfGH51SpIfDfm
mwyHQ8llVvZ6CNwTQ7kluaP2H0gpRd2ZrbT0pix7OcprjykZW/OWmNbar0P2
o6QJi7Wrx6XVVstMeT7zOTt1reIMSZkFKlmjWhLJR5C/JyU90uxIzcFuZd+u
JPxCUojb74m29Hi+PlZgVA9k/Tf5XIf2WSi3oTwH5deSz1YFv5TUbgmo7kMZ
vew7lFEKRhDUGkf1FsrbBv5tq1Fk5bFP8bJP4hg7hI6i2OXlaMeLHl+oS4A/
zkzqyA/1qeKXGsaBtoeIBVqL3ql8xtDWll8L9EKPwvI8MWrKOrkIynMon2iV
bTV6WZaUajfL9NAiaqr1S7SajlYTzlNxqOeEHmHlMbVWIWcn4ghsOOk0GHWU
L87xse+brUV7kFo3xd2eER6lokRX0qdAPy/b0+pxpzfUsrZF1nYKkm7iUTDH
oq6dWs6hXpbw8uzUeEIU/V04pzCrKEnNwayVpWgPy77gS/6M+52y2LJGqeTT
NrSZGfNMOO47Rq2a8p8FXreimtbaxK/kczg6MhKGRKUe2Rf9Ro/nS1Zj87dA
WRq1d3vy1XqhnWneze+I9ftXzLGYeJv3RXql4CzReaydXwp8Qs8rIcLx8hdg
j+xDe6paoyk8S9/+Vr1sJXp5UO1XuHmlheiLfdugwWLA2Ok5fwxUmySv5w61
iKy4Zp1rDrI+WWlA56VPiJGL4kt4IjfX3H8N+G1X8KUxAHHLsYsceTk/P7+4
uFAth4WWcp9iy2AwODs7K7fYYyRop1c8xzC2+SSxEfTbN1DegfJ0YCEY8TJf
r4w3gjqVUcElS8fsuioL98VQTFk/6j2dWIivdREDWSZGV9TPDuvQv78QI9e/
ZihszC8rt8u5/fETKm+x0/4uoCLNzYNOs8Jr1pznnq9mAGOWWudFtCc8A7fP
uH1xlPDcfvpQkOYsZUJB3FBJP49S+BkdV9xz0/os3AU5aTLbnxYsJMw6amWt
aHyVt9N62iOyrvtc/Vqwyqw982Y/zzRLVza+rT0vBu5RPwZ3vKM++w+JTu5f
3ebdnMrUm8JB6CyfzFDuEOJhp78fAoJzFuItmFnSeMQzsnaLrL2riIhCLl7I
5w6fLkRkUi3/ERHx2gwiIjDn4vquPx0Sen4hNjKCWEBcJCRU+1iIiAkf8kNI
emVbMJtzIeHnFWIiIyq3t/tLW/NfheFjug0EpAo/WoD6kL98Fc+JUOu4eD6k
ubMJk0FG4p5Cah5Dmhwy0sQJpEVe71FhpzdiISN67q9sFfdUURhOFAsJMeNE
bvl8c/tbM2c0bhchaSLPD9/77HaP6UBG7DAl75NJ7cvLy2F2XV1dKSzS7nvc
7sRGfGyEzLAiYyMhp1ViYiEYrVy+i55C7b+LfWwSciaPdYjX/H/F2MxfobcP
jA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{371, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36670847]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25516],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28608],

Cell["\<\
Assumptions can be given both as an argument and as an option value:\
\>", "ExampleText",
 CellID->565056155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Floor", "[", "x", "]"}], ",", 
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"x", "<", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237031262],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylVNtuwjAMdRtCC+3Yy2BIvIDQpH3JNiaNf6gQEjygIeD/g5M6nWssJqBS
e+LbiWs7+alOm/WuOm1X1fTzUO0329Vx+vF7QJVJAGCJ72QMuHa4Cu/SOUT+
Nfg1aOoiWsQCMUVMCS3po/21iQIf5sITrGAbOfgAlB47f141C4/L1Th9j0zI
A8owJ+wJ+1hlyYX8RNF9xsbtei5yr+LiTzPiK4TnSOXrK/yyC9xeCnl4Q1dm
N9bci3NCvaZfQRtz/W4k7rO4otX5HtHGaS0JLUNeV9nHDvmlKqucjYHSNcnW
noo4q5nag/t2jZPGueNEcz9zF7t17fPRc3rlHss9u6iUzF6e/qTZzyin9r/O
GNeegxdEf2V61ppZMkj57UoH453yTPhOWdYdqO9dSM5PmOlC\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{78, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->350184002]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53304432],

Cell[TextData[{
 "The default value of ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " option is ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->279368443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"0", "<", "x", "<", "3"}], ",", 
   RowBox[{"PiecewiseExpand", "[", 
    RowBox[{"Floor", "[", "x", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->359819269],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylVNtuwjAMdRtCC+3Yy2BIvIDQpH3JNiaNf6gQEjygIeD/g5M6nWssJqBS
e+LbiWs7+alOm/WuOm1X1fTzUO0329Vx+vF7QJVJAGCJ72QMuHa4Cu/SOUT+
Nfg1aOoiWsQCMUVMCS3po/21iQIf5sITrGAbOfgAlB47f141C4/L1Th9j0zI
A8owJ+wJ+1hlyYX8RNF9xsbtei5yr+LiTzPiK4TnSOXrK/yyC9xeCnl4Q1dm
N9bci3NCvaZfQRtz/W4k7rO4otX5HtHGaS0JLUNeV9nHDvmlKqucjYHSNcnW
noo4q5nag/t2jZPGueNEcz9zF7t17fPRc3rlHss9u6iUzF6e/qTZzyin9r/O
GNeegxdEf2V61ppZMkj57UoH453yTPhOWdYdqO9dSM5PmOlC\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{78, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->650735177]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192956252],

Cell[TextData[{
 "When assumptions are given as an argument, ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 " is used as well:"
}], "ExampleText",
 CellID->373032043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "<", "3"}], ",", 
   RowBox[{"PiecewiseExpand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Floor", "[", "x", "]"}], "+", 
      RowBox[{"Round", "[", "y", "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "^", "2"}], "<", "2"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71170035],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{452, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120994481]
}, Open  ]],

Cell[TextData[{
 "Specifying assumptions as an option value prevents using ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8600092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "<", "3"}], ",", 
   RowBox[{"PiecewiseExpand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Floor", "[", "x", "]"}], "+", 
      RowBox[{"Round", "[", "y", "]"}]}], ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{
       RowBox[{"y", "^", "2"}], "<", "2"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->398567800],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Floor", "[", "x", "]"}]}], 
     RowBox[{"y", "<", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}]},
    {
     RowBox[{"Floor", "[", "x", "]"}], 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], "\[LessEqual]", "y", "\[LessEqual]", 
      FractionBox["1", "2"]}]},
    {
     RowBox[{"1", "+", 
      RowBox[{"Floor", "[", "x", "]"}]}], 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{173, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28819917]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->17888],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option allows local setting of system options related to piecewise \
functions:"
}], "ExampleText",
 CellID->28413153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SystemOptions", "[", "\"\<PiecewiseOptions\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52084067],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"PiecewiseOptions\"\>", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"BooleanResult\"\>", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"\<\"ConditionSimplifier\"\>", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"\<\"DirectExpansionCrossovers\"\>", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"10", ",", "7.`", ",", "False"}], "}"}]}], ",", 
     RowBox[{"\<\"EliminateConditions\"\>", "\[Rule]", "True"}], ",", 
     RowBox[{"\<\"ExpandSpecialPiecewise\"\>", "\[Rule]", "True"}], ",", 
     RowBox[{"\<\"FactorInequalities\"\>", "\[Rule]", "True"}], ",", 
     RowBox[{"\<\"OrderlessConditions\"\>", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"\<\"RefineConditions\"\>", "\[Rule]", "True"}], ",", 
     RowBox[{"\<\"Simplification\"\>", "\[Rule]", "True"}], ",", 
     RowBox[{"\<\"StrictCalculus\"\>", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"\<\"ValueSimplifier\"\>", "\[Rule]", "Together"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{558, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1231622]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38619452],

Cell["\<\
With the default condition simplifier, some conditions may not be simplified: \
\
\>", "ExampleText",
 CellID->67597828],

Cell[BoxData[
 RowBox[{
  RowBox[{"pw", "=", 
   RowBox[{"Min", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"2", "x"}], "-", "2"}], ",", 
     RowBox[{"Max", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", 
         RowBox[{"x", "^", "2"}]}], "-", 
        RowBox[{"3", "x"}], "+", "4"}], ",", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", "3"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->857037900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", "pw", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->267261033],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWjtvE0EQPvv8iF958HRIQgwVBQQhBC0FKA9BCpIOkJAVRUoKhBUi4c4S
1ChlfkLKCCFqChqo8hN4FfkZx83dTrz+bta753MRS9m72Z2d187Ozuxlvb2/
s/2mvb+71W6t7LU7O7tb71rLb/fCLj/nebkfnuc9anrhexC+RX/0+xn+xa/4
5lNb6Ha736Lf6enpRNjjhxMn1bMYPvPhM6+eZZrhM+UgGi+GYAHwLqr5vhr3
VX/MMv4RbkGRet6Xx+/1eop6FbjVI5ZnsCJVjLToY3nehCCly7zLMM+3wKyx
3kfNpqhNKWxKylZFQUq2YVmNl2C8rMavuEiZ0DadnMn5FwzSVgQpdbiUWWru
lH0k4jewitOKYykxghaXVsDuEXm1hgYbJ3rNsuv8JRvzbtJ31bBxetLwlAEv
FttTQukzfTWT0DecZJ0UdZ0Ve+sgTz1hZ8k7t0Q5KkriKSXxXNCPWDqFWtiU
FbgtUloTeL4XMVdBd+rsZqRJzfdzOvJb2fSXcVTXUcZ6BVgfAC4APAfwZ4CL
IpeXgPVRmqXBswB/kaSyctF18YRIPR4uNl0w0qJFMbq5SfECsD4BjLoiV5Tq
K8C+yLURxHHeNb+QdNfH8bShTMIln0E6NcUfIyqfapzPUJsX+nygx/pcy2jV
WgZ99PGZEfWqZ7Snnl+6eUfyVJF8ZeTscADjKmBUxkZ5GjAa1hl+oieZ12Ce
3AQ4rXdVx6Yv6Ufrjn7moqe86qNIgfnHlEgZrSL7ItmSKxq08bCsXc/qCcY1
yhvmS1UB5z96P+4kPUM9awcy1H4v06wAzdgiYWXoxT8/akJYkzmLn7HOpqiB
OnNmXwzMtnLVuZCS9yT0y/WK7EOxnQ4PD4+OjugVowDKYKqhsNYy+RJGFVOt
xvN5l2J9IfqUwbfpuZDRHzCHt8nNa4J1k01ujEY2Pux3ckQatub9uCGdtOlq
0fTnVi1wrYSTtNi2YuQeYluZF1HCDD+td9QzaIMnQFqP4XxlFN68uyhiFzxT
zhP7S6fTOTg4kCTEdcDafxJgvgvAeRgbXOlgjoEZMWeC+GQ6uLc440cvyBoz
XPWZt8iPdFEfE12UX6ocRs145bylBRRxxeXsFWc1RayHFunHk1m6yXIdsG4A
jFW3W23BO3tGPW86WFPCo9hbFCyWtWqvWviRVSiqSNYgEPNUuepfsWi9BPCG
RUtci7sAvwZ40UnKZQ2LPAJj5B0Y30wp5RLMfw0w+qmbLYdJSa90N3x2rmn9
eF7iGqANcX/IN2bUnNd7R7opZQXWjBi6jmbMroC5mhFT5+4NldOdptkaHJlM
34n45LkHMHr5QuB2p9MI3O508E6L73SwqvknapXiLmcgi7qf6OGqYz4xkrxL
kL9W2O8Sklk4aol5gqy16XbADwarzAfqWQ36MaF/22CuxPVqtO+fcuXL1bOt
8mU/wJsG1OGvqLGtbkCNuUrAGhLPR9fvkCw9Z9+XnKRmXe1ZfdIf0S42Tdy/
Uya90FT5uq0FV1KYu96Gfjof+Uu1nhvbvlM2DPSxhsC99EeUXo4YeMO/DvCi
OGsRsOTvlfIe5niMty3PAG4pPMzImsqaGvXC8fFxL/qdnJzcstB9AjA1uYgW
5i1oi8cwTp1RbEjkZU/Vii0bedFb/N8jXu4/yyBnsQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{456, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->553438113]
}, Open  ]],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to simplify conditions:"
}], "ExampleText",
 CellID->256530812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"pw", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ConditionSimplifier\>\"", "\[Rule]", "Reduce"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->339759927],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytV9tOAjEQLZTdBblrvL+A8QvUTzCoibx7eSLEBB6MBnnxf9QHf7K2ZQrl
dJZdwE3Y7tw6Z6bTmdAfTEcvr4PpeDjo3EwG76Px8KPTe5toliwIIX71r3sk
9LfSX/b3q5Re/XdTv6UWNWiN9FrUa5HWxGgZgbKPlUeaLIHeHtlLkkvi2w8x
e4xuSa8XliWJqoCHmnUzp8nc+BWlhZYQZQZZHrt9sJMZtIvS513NI/C5sX7F
lJuIQehylpA8BnlC8oM8CINI82MMbXdTkOLZYDXEWyOOluoh8LV0ci3yFgcS
zDSX+ewqKNLZpeQ24PK4fd9cbt2N8W/OKrlZjbiZojeDbB+wlGR5mQtng43x
mOXWYK9akF+sxmsWQ4WQui50qhbdyNer6leiyR67yx3QD6zWLcT7uMVeX5br
8vwzp3yd7xVcfj/kfgJdArr7j1Z1NbuLefs96nHzwKfdPnGKH0QpwT727OW8
6LkowmrlYtp4woRdZImzw8WViQijD/sVWiTsvpLNistdGj9tDvlzytCHajEV
inm7LuTPt6+CvMCix77HZoKZSTi7MAoXJaLIOpvIs+P88FG0GDTrTaxNqrFM
GLEq0Xt2/bmd3Nnx96+dQeNsayh+1iEfc8zmYs1ugvMl+wz57tJkuR2wPWe1
smqNn76LW26OqE45a9N6xniWTP2grxPld9Y+SJ8s997jGiTPK3Rn/y9E4Q8p
2mwY\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{170, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->132022670]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->198612935],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " to simplify values:"
}], "ExampleText",
 CellID->35085023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pw", "=", 
  RowBox[{
   RowBox[{"UnitStep", "[", 
    RowBox[{"x", "+", "1"}], "]"}], "-", 
   RowBox[{
    RowBox[{"UnitStep", "[", 
     RowBox[{"x", "-", "1"}], "]"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], ")"}]}], "+", 
   "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178753563],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}], " ", 
   RowBox[{"UnitStep", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
  RowBox[{"UnitStep", "[", 
   RowBox[{"1", "+", "x"}], "]"}]}]], "Output",
 ImageSize->{362, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49867902]
}, Open  ]],

Cell["Trigonometric identities are not recognized:", "ExampleText",
 CellID->333691978],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", "pw", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32152411],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV71uE0EQvtzenWOMY4RAMjSYCiSUAiEhpQYlDfAOVoSUFAgrpHDnBlKF
uPQDEMmlH4Ga6h7Dj7Hs7s04689z2r3IhVfy7e3e7Df/M+vPw8uzr9+Gl+en
w8HJxXB0dn76Y3D8/cJsqb0kSUrzO+wn5l2bN/crtTbze/NMzbJD8yGsv6yo
EmVPueG++us3ge+fHIqyz2w8Hv91Y7lc5mYnN2Q9M1vyjGZLmZk5dydWOCRT
SnMGXJ541IkbivArIB58TDVGVx6mIroKphopyf3iTl81mUwIobCP3OdnzxyI
u2mDXZQ0XdeL1QddWNeNk7jeAr+nsFaBtSTbS9GmLaAqyDsoYyZqUgT0Zx8j
XYe47G/FfnVcoqwmx0jQbij5QZS9LIoS/FunQX9H7ZPX5mgbMLpRdtlmnkj2
5ZoUla+NM3FV7SL1ki33AJAfwjrXdzU+Y47R1Tel0z3BH1yVsRo36x7M4VGN
7asDbgASZ8VAtEuTqv8YeGMfRX+jNdJ7YHTXrSRE2VtRr5Znr4z4+jcHjLwe
eEgLGdsJYNiYapnlO1Gij0B9BOtj8dQHj8qKdwTrky3y+rczu5WPZ7PZfD5n
b9pwvKbZ76N+rGOW+7chRoXuvBHlN4AhYa5HZJu4Y9fyuY5Go+l0al+R6krL
d4J9Qm156HU6hjsoalUQWttDrdch1Id+18hebNgK813q1eHqfR3wkd+RpKoj
c5FrIVruVRQW158bkuC19mrGTuRY3C5n2k+wKEYA3zn7IgpG1S+NccERg/0t
Du9Kr+dKW8s51QyNc+N+Mm3qiFGKtzcPN1ssFhM3yrLEfxHoi2ciDt6Z/4hU
XcK4pfm5263+fSd7/wEFTF8e\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{207, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75049474]
}, Open  ]],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " to simplify values:"
}], "ExampleText",
 CellID->38999179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"pw", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ValueSimplifier\>\"", "\[Rule]", "Simplify"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->43000480],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVc1OwzAMzppk7dYVOCK4TMCFN0DAGS6Dd6gmpE0wwcbeP7it01VfXFo6
IrWOHfvzb9qXfL962+T79TKfP+/yr9V6+T1/+tyRSI+UUlt6Ls8V7R3tymfr
HNHmW9Nb09GYqCWaMa+ZL2ikeKOqFdHWEL2vEVRh4spVIilb82x2AlpohXzE
fpqyR9FfDPxpH09BfP18JcD3ykr0ZVvrNwE+EzCL6pj2PAKp7GkK/Ax7wJ4q
V+ViiT/x0/Mg4suTkBbUHLTC2i9EtJh9FVHGRF9FrfdS6uPb1FxT5+MXqYyH
0jvgDfC3/2jlb2YKtbcs9+d4DxBdgz12P3WHG989+bOgi2PQQPyu+EyAOOFI
z4RMuiPM2DppybcrHgv2CdfHHhXNtIE2JBpvP6wmYdfigdUJu5UKGcsRaiF/
abqPmSac9gsxGvx+X//RC+pXqL7XN0zxi44oV82c+b+sRj8ZuwwU\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{113, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->154457246]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->207328952],

Cell[TextData[{
 "By default, conditions produced by ",
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 " are not disjoint and cannot be reordered:"
}], "ExampleText",
 CellID->252155765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pw", "=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Piecewise", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"{", 
                RowBox[{"4", ",", "a"}], "}"}], "}"}], ",", "2"}], "]"}], ",",
             "b"}], "}"}], "}"}], ",", "3"}], "]"}], ",", "c"}], "}"}], "}"}],
     ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181231574],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWL1uGkEQXt+PjxAcN5HjFJFoUsRuY6ewAziFXVniFZBDZBcRGKOIjgew
JTpTWZSUPEIegZJH4DE2O/vjWy/D3bBByCdxu7M3+83MtzNzJy4b3evm70b3
5qpRvug02tc3V3fl81ZHLIVbjLEn8TvZZ2LOxUz+njgXo30P4R71er2/8prP
54/petjv97m82La4xQLiVowhU89jPQZMT5i6AjGN9LiIVJAyeKPkjiOHOXJg
kK21aH2W4mdZB7RpW/F/MQfsRMvjwFdXthRoS5oMpp6Ykwl0Opg8ycdvSWJT
eZH19yhOoq1BViZi3EO1hq9gVUYcTadTVWez2ew+g5nRaGRFCDTUOL3uvpCQ
oaIX86Hm8O5TjYck+0VnV4ViObc6N207JvMNMrB1hmCvWrU0i3lR0qv4gGQP
z6jvPK+2T0jophIgisTg5u56kFrK4nA4HI/HMH2ToZViZWm12+3BYLBci+bX
JrUKmj/zJt/h9I5SRy0kUhafDOLzIWUiPVc8H945Wj4d5pv2fT/DrzRy16/E
kXcpHuV2nmNU64OXh+77kcTZ0v701dH+mOGTeEPV63XMJ1feQXxYtY/RPMMy
2d7l9rmSI9P73BHqJX6GeV7h2f8WxsxueMFVzflZNV0SOIAu+dMLBXoruF4l
7TZfYTU04goZw/ag+kqwXGYqPM0ce/3UG81kg0pMGuMojiXXvFCgwk3uAF1l
HesPLzS3KovoKTS9sKG2tk01rRFzEQu6XOSNKTPxRbWXVvU4Euh9eU0mE1Pd
th3jJYi/UpxIqKt9oqV/cvT/yPEzV+erJPtfAbb1D9RpNIY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{157, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75482528]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", "pw", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->134158232],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV01OAjEULjMtw79bF0aIP9zAKK50o9HEnW7YTYgJLIwTZMFujsCSI7Dk
CB6BY3CM2jfTMqXzBqZADE1o+17fT/t+PuDNH/U/v/zRoOe3nod+0B/0flpP
30PBcguEkK74dE6J2HOxiz5dzsWqzy7MdDwe/0ZjuVwywWFCuC5Wl8QSTK4O
kRsSD0dsqVgvE1tuGIY8GqQU0eA3phsG7W6hHelB510fzhNb0fJB/+2L7RU5
iA7NfkeKu5snR3qKXUVDctQJWASFq1z2qzDRhE5H/Qa140lvUJWeWG9Rqfej
5XoySg25dlCpIpq5Gsq9Qy1UjGia9P0BtUpaTna9H9QDzZTG4/GyMcKvG7IS
19p0Op3NZrD90LiJrM4NgmAymSTcw1cGvFHHW1XpCme53oUGD/SaFpHDKwkQ
f70n3RSHoZrnmZnQc1w3aE+ztZrXUCvh4giH+zWxpmbQ5jk1aJs3lg3dKqpb
zOER+5Y7Q31m9Y6qGKatKnsxZDdRe3iNtA0vLVRXdVtb+rxApY4BeXFuWd6/
xu26DjLItFhvk1e/nmiujFbQjOzen3k08Spw0fuCbFGcVo1779/RzMIC/tbs
G2fgoAUygBWao59tYumlMoGjcx4MsdeCcwx5Csld6Xw+D6OxWCx0TAf7dY5j
D9gFsRLCX8ekuCMaht1H7HXkRFp5kGt0G/kPhhT+AFYQ/H8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{90, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->799576591]
}, Open  ]],

Cell["This makes the conditions disjoint:", "ExampleText",
 CellID->181786566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"pw", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<OrderlessConditions\>\"", "\[Rule]", "True"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->107646819],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV8FOwkAQLdstLQLqyRhDlHggelCv4sXoQU/+gqYBEzgYG+TArZ/AkU/g
yCf4CXwGn1F3t7t0mU7ptiGRTejuTGfm7czOzJY3fzz4/PLHw57ffh35wWDY
+2m/fI8Yy65YltVnv+6pxdYRW4lfP4rYrD9t/qSTyeRXjNVq5TGOzYQbcuYS
jpyJJRdWPAhbUjbfJLbsMAwjMawDQXPcmG4A2s6hiUTQeXcoUpU9qkyoaYLg
rGnpiDlGWvewNKKTGTdXnEliA0fh0aHZ/qS4OJanWcb8IRIphhJDctQbbpEr
3BrZr6d8g9F/RO3UJBrXd9n8hEq97y3XlVE6lLMbbVbTRqw1ngOiw4+BH+0F
ioLnaAPlOqmTsFOcI1TzHMWG1Q5pV7OV5ANBuVWg6+xwHx6gKbbPktjcNlF9
KKUDvTJBxnpgy8hvXilUyzRlDfWPJrEvlltXmDWNbqO2VDVcIxHhe7xEteLK
iqMxm83m8zlffmjcRFbnBkEwnU4T7u6rm8fGkedepLrVPWAqDzNI4ZICJ1a+
G+CVYKJ5jGra6K5hfsI7vUgfwe9Hp4AFs26AewI7Dfz+yetEOFZeF4FWuTzN
3GMNSNdLYWZ1KiiXt9ci0TXtd+n+5gEJLGK2yh7DquoAG2eAbqK2VB/syJ20
jLT24Xtmex+EX5Eqol1UC8b/BI3wvZEuRIb30cN/W9nmF10sFqEYy+USdh4s
pnStD99C+llI8Xwiqh+n3sb/CK3KHz3UuxU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->57735742]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227735288],

Cell[TextData[{
 "By default, all special piecewise functions are converted to ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->255163144],

Cell[BoxData[
 RowBox[{
  RowBox[{"pw", "=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"x", ">", "0"}], ",", 
     RowBox[{"UnitStep", "[", 
      RowBox[{"x", "-", "1"}], "]"}], ",", 
     RowBox[{"Max", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->322366141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", "pw", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->222385778],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdV81OAjEQLnTLAvKjnPBGojf1FYwn9GKiV+NlQ0zgYNwgiVzIPgJHHoEj
j+Aj8Bg8Rm27LZTpsGtj2INNtrOdnfnmp9PZ3cdoMnx7jyajQdS7H0fxcDT4
7PU/xoJFS4SQmbiuukTcc3GnrhnngqZzQ8yBYD5peq64VM7BdDr9VmOz2YSS
Q6W2GuQZrLs7PZokieZWgdSJmMpiWdaUCcoElehUU8lPgZTaVhbjGXoG7NTA
mmn84KCXEqWpot5pEVIHOEqfbdepkELf16MOx5XpaKvGeohiU9RjezekVEtj
1DKxmMXd6ZZRLrOQ5MMKsFixLHp5vZeDpmXlMJpte7sL1tr40nHwQ+6f2woq
23Cws/ctz2e3Hk5RHFjJeAXikZiq12WvR53vn53fWTCZNHURAJQWaqvt4e01
KnvrgXCjfbjjWaf9q1DuC3f6qvX0FeQe76Im5ybXRXVRiJvmU/ULulgslssl
P3iqi++j8MRVURvUisF9A7R50X3U7FW+t3Ecz+dzzNtjdU9jB++IGd0zpxqK
6ZwmrqzM+p60Y/ZKGKeP3/+zd/pw5W6zjN5onvdRbfid6r7tYVXCjvY7XPO9
Y07A31DqFpo/ihtjyHO9ClarVaLGer2G/wRY7vNz1gLcC1TKxHyp6YPipv8w
pPQDyZqs7w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{125, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20696096]
}, Open  ]],

Cell[TextData[{
 "This converts ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 ", but not ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->71038135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"pw", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ExpandSpecialPiecewise\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"If", ",", "UnitStep"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->404499686],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVVFLw0AMvvWuu61uRX0SZDAUH8RfoYI++QP0rQxhVaQy9//PXJfr0jSu
7Wqhl+ZLLvkuJNeXbLt+/8q2+SpbPm+y73W++lk+FRuA9EgpVcB7eaHg28FX
+RbOgbyGNQL1xGva4+WjLCwGVIP2u8qbeiVoTRhumH5b7tawejBGuXMLTwSK
RRkFo6liIFqzkgyTFgYztt9ziEFa5KIrhnTX2C8x5RCY/oHu+WIOGk328Gym
hBXdMW/sECstcxl0Go2MxixGwE8JrgTmKTuZPZLnPoP3Ml2Z1WrGeyFws4Tj
MG7/1xGpGImfoNkXkyPrHIXS4hSGGQ1z0m0aZ06aaJ6Pz+CU2fv2Mud+znwW
TL/qEV++o84w6wLljTt0e+QlGk77WWnU5+MAKscbgvqq+QLcO/k2DHa5JvyO
faj3hDCT/LbqFvcRWYWeHhYlIdH6R2me0bo2VlrIJlW8vVIpQ19FrznGfHNk
VtXu/65GvwvB/Nw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{111, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->119314731]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5561923],

Cell["\<\
By default, explicitly Boolean valued piecewise functions are given as \
Boolean expressions:\
\>", "ExampleText",
 CellID->248983132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "\[LessEqual]", 
   RowBox[{"Max", "[", 
    RowBox[{"x", ",", "y"}], "]"}], "\[LessEqual]", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116636326],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "-", "y"}], "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"x", "\[LessEqual]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "-", "y"}], "<", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[LessEqual]", "1"}]}], ")"}]}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->612529564]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<BooleanResult\>\"", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the expression is represented using ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->525996262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "\[LessEqual]", 
    RowBox[{"Max", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "\[LessEqual]", "1"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<BooleanResult\>\"", "\[Rule]", "False"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26678944],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylVctOwzAQdOMkbaEPKvEo4tIbEXckvgBOXOCKkKIKqT0gUOkFOPTTjZ3s
Bne8SkKIlNg7Xo+na3t6n29XL6/5dr3MF3eb/H21Xn4sbt82FtI9pdTOvhdz
ZfvG9op3Z4xtM/uNbfhYRFfuq91o8aiHAtX268CxbRPbptT2IZvxhNoJzdMU
uzZS1FHlE9H6p9VKPuMU4gOIE2I8FPA6HlwH44iU+dhcVMi/OQZ8QMr8Grnf
OyR80EVhUsXE1k4jcqekwWlR8S+uqhGsc3d1Seu95YqlIhePtqlbxPsh1ytA
u509x+XCcil+hpDVdBIj0uuxEMIjfPvOWqm8hHhkcI/xzGQi74RWz6h1cV+R
QwTZnwXKir+ryM/5qkFlPkSfTOkV5+LoM8TyXUAPi6Ha6GEjGD8CvtTj09U2
/vUs6WCXmhxtHMyYmdBxXLeIgzOvRZ1t3Iz9QbqNEy+Pq+i7354rttRU516R
x4k1ZS2zoFI8M/mHij23EtmxNuGOTcX1ucZNNdLM0OBR/umV/j/RLfz8sZE8
DmfVKT2BXPSn65q5x2bfg26Mf8d2ZW7vB7ppdjM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{127, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81603445]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<BooleanResult\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", all values are assumed to be Boolean:"
}], "ExampleText",
 CellID->350046196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"If", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->642611037],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9VM0OgjAMLgMkUSQeDJJ44Wy8qQdeQE8+BDEmcDAa5P1nN8pPRlETDUu2
tl/XfqMdO6dldr2lZX5J41ORPrL88oyP9wIh2wKABOc6AtQlanomUqLsrjau
Nro8kgFJhbskBZAC1RCoOiTJoUKkHjBRi9vYFBYYu8wo0xZ1/g7mDPN17MU3
TL3zjc3l/qF+qkbO8NfwaI9Pdd5hGAQxUCmg8tR9EdDeHZvNG+oytna/xsvB
OA/NkPXuNFqf4NBY3T37Nyif7xfUpW4GJPlz8131WXQ1aoa5rPo/HMP9i9MP
vGqr5qMbUF2g+nWJNOIbOTcanRHjVravFFgvR8Z7Yg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->133560445]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<BooleanResult\>\"", "\[Rule]", "True"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->210221758],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "&&", "b"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"c", "&&", 
    RowBox[{"!", "a"}]}], ")"}]}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->144866578]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TimeConstraint",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9499],

Cell["Simplification of a piecewise function can take a long time:", \
"ExampleText",
 CellID->282745970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PiecewiseExpand", "[", 
   RowBox[{
    RowBox[{"Max", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "6"}], "+", 
       RowBox[{"y", "^", "6"}], "+", 
       RowBox[{"z", "^", "6"}], "-", 
       RowBox[{"x", " ", "y", " ", "z"}]}], ",", "0"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
     RowBox[{"1", "/", "4"}]}]}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->375930197],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"55.562000000000005`", ",", 
   RowBox[{
    SuperscriptBox["x", "6"], "+", 
    SuperscriptBox["y", "6"], "-", 
    RowBox[{"x", " ", "y", " ", "z"}], "+", 
    SuperscriptBox["z", "6"]}]}], "}"}]], "Output",
 ImageSize->{174, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11902581]
}, Open  ]],

Cell["\<\
If neither of the cases can be eliminated, checking this may still take a \
long time:\
\>", "ExampleText",
 CellID->494098244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PiecewiseExpand", "[", 
   RowBox[{
    RowBox[{"Max", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "6"}], "+", 
       RowBox[{"y", "^", "6"}], "+", 
       RowBox[{"z", "^", "6"}], "-", 
       RowBox[{"x", " ", "y", " ", "z"}]}], ",", "0"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
     RowBox[{"1", "/", "2"}]}]}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->131296158],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV91OwjAU7toNQf5lgNEL8QF8ABOBO000PsRCTODCaJA3N954M9uthfL1
bGwkgEu29js/Pe05p2fta7Sav71Hq8UsGj0to8/5YvY1evxYSpLwGPMeGGPD
Syb7sewlr3rG8mVsKr9Ckn4T5Msvl+heIWEkY/at6UEiJYCL0j+A+QG1buTH
l9C0z4Ane416C3gE+GUHf1zI6h3gGuBAe53rtgH8M8A9kEe+Gi/IoXePbK8O
9Gqc5mKlsPeU1XOgJ9r+BjPWJNahNPuOZFVzkjGCNSdlkutwpS5ObL9hR8Ph
BoV8y3WEhI6Ib40pdMQNXRCjVjNW3NDj2hFmOhMMnWs/2HxceYUYR3XDI9lp
x1Y9LOhjDlRB6nKSKuz5bmWMoClg3eiqtqbbFrHW7ZH6mVbRT7tw7wQ28/cB
RtSznJemA0pQ9iom2rkRIOtoboWg8yp09Og64c4I96Mr0fuHcyL9RlZFecxJ
IphGEXca7kcysnSGlIqrqSocWlUtxNoJ5lF9w7WlTU1NOmtpBQItHVjSzRPY
7Gb7y9lR6DOMhalsdcfb5p9j5tYBTTs/lf0B4AngsKR8h1xlsf8n+sIHXANb
u3MNd+OhV9+Ny5zF6L8WTa2DpTK6bcILKkeGup3Gm5MVRb8utBr71COsPYb0
vIxU3QFgvIuEJeWvCs0e7zKtkj7az8ox73y0ln13VcztO6sSTG+8zPsDmc6L
EA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{316, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->496716580]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->542943071],

Cell["\<\
This restricts the time used for a single condition check; the result may be \
less simplified:\
\>", "ExampleText",
 CellID->334985144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PiecewiseExpand", "[", 
   RowBox[{
    RowBox[{"Max", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "6"}], "+", 
       RowBox[{"y", "^", "6"}], "+", 
       RowBox[{"z", "^", "6"}], "-", 
       RowBox[{"x", " ", "y", " ", "z"}]}], ",", "0"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
     RowBox[{"1", "/", "4"}]}], ",", 
    RowBox[{"TimeConstraint", "\[Rule]", "1"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98459912],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV81OwkAQ3nZb5B+RAkYP4sUHMNF4EW+aaHyIhpjAwWiQNzdevNSddheW
r2PZkgg2aXe/mdmZnb+2+xwvpi+v8WI2iUcP8/h9Opt8jO7f5ookPSG8KyHE
8FioeaJm6U3XtbqFuFFPqUjfKQrU01fokpA0kon41PQwlZLARekvwP4frjpT
j0BBMz4CHm+l9RzwCPDTBv6tk9ULwDXAoY66r8cm8A8A90Ae+aQvLKB3d2yv
AfRqktVixTl6ZLUO9HR1sMJCtBg/aGU/J1nVnFRHuORkTNaPvNTRnu037Wzk
uKFTbH2dIZms+l5qLLVugzGDnKdNrc/OrNAVYOi+9t/mo8cVRg9Nox3Z6Vjx
cI2tD1TJrjWRDpw0c5aMXzTW9Nhm/FqvuL4dkTUOxmQT7u3BZnGtY/a8jC6z
Ybk3S6LupKfyS08Xdz1fM1FuHd/7YU4Oey0v0fuHe2K/KeybTv26pBnLsoZd
hB1QY/VQqsm8z3K5SrW/Z2akrpdLh81Fc8O1pQMjHdjSBEItHVrSrT3Y7LLR
4LsF3/AY9yqri4+3zFVDB7TZ9UkrBoDHgKOS8ofsvty+iRgfvnJ5zwPYx679
7iZl/qx4H/gO295fqsShHu+S1R8RRz912rf5O2no0XSF6euiqNN0ABjPDlFJ
+ROnXePZo10yNttZ2eUZjV9lnzWJuX7GJMHshCq8H+6KZow=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{309, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->339581018]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PiecewiseExpand", "[", 
   RowBox[{
    RowBox[{"Max", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "6"}], "+", 
       RowBox[{"y", "^", "6"}], "+", 
       RowBox[{"z", "^", "6"}], "-", 
       RowBox[{"x", " ", "y", " ", "z"}]}], ",", "0"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
     RowBox[{"1", "/", "2"}]}], ",", 
    RowBox[{"TimeConstraint", "\[Rule]", "1"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->546718945],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV11PwjAU7doV+UZkgNEH8cUfYKLxRXzTROOPIMQEHowG+efGF19mu7VQ
Ti9jIwFcsnXn3tPb3o926+toPnl7H82n49HgaTb6nEzHX4PHj5kSiYCx4IYx
1j9l6j1Wb8mtr1t1M3annkKJfhMUqidX6FojYZkx+zZymbAEaJH9A5jvsNeF
eoQK2vYZ8HArq5eAB4BfNujvc416BbgCWJqoc9PWQX8EuAN81Gt7MkPe3vN4
NZCX47QWS7mjp0etgjzpHS4xYw3CD92z6zHLRpPYkAtNqiT98FknBx6/7mbD
08pcseUmQyJernubGcF8fkhkkvK4buy6GWamEqycmzi4evS8RNjRr9Gexmk5
cckbYw5SQfa1EQ9JLbkyIA/WL91WTNsk/FqtvK4bkRUNxmQT7hxgzOyax6gF
qVykzWJuDqNK2tHRLtncOGxqfWfvAHTdRF4/eh+QHg/Xm8/o/MM5kd8XctdT
vzFJ1tLMYdXjequQdvj6eWfk0u4UHFq9A4iFAXvpd6t12aFlhy5bA2nY0mE3
DjBmm4wOvXJw98cYlklbwss/9sMdw82FttADPAQcFeQf56oI+guJkaFr190p
qHhite3a43Zc5A+LXjH06kJP6b4twl9dfX3TPsTLPyNKfp5r3sJ4WXO8tStD
rpmFi3uA8QwRFeSf5Zo1nkGaBWOz3Sj7PKvRvdwzp1aunjU1MT2psuAPzARv
gw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{309, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->620124556]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22338],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 " returns a single ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->216819620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pw", "=", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{"x", "\[GreaterEqual]", 
     RowBox[{"y", "^", "2"}]}], "]"}], "+", 
   RowBox[{"Piecewise", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Max", "[", 
          RowBox[{"x", ",", "y"}], "]"}], ",", 
         RowBox[{"x", "\[GreaterEqual]", "0"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"UnitStep", "[", 
          RowBox[{"x", "+", "2"}], "]"}], ",", 
         RowBox[{"x", ">", 
          RowBox[{"-", "5"}]}]}], "}"}]}], "}"}], ",", "y"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52736705],

Cell[BoxData[
 RowBox[{
  RowBox[{"Boole", "[", 
   RowBox[{"x", "\[GreaterEqual]", 
    SuperscriptBox["y", "2"]}], "]"}], "+", 
  RowBox[{"\[Piecewise]", GridBox[{
     {
      RowBox[{"Max", "[", 
       RowBox[{"x", ",", "y"}], "]"}], 
      RowBox[{"x", "\[GreaterEqual]", "0"}]},
     {
      RowBox[{"UnitStep", "[", 
       RowBox[{"2", "+", "x"}], "]"}], 
      RowBox[{"x", ">", 
       RowBox[{"-", "5"}]}]},
     {"y", 
      TagBox["True",
       "PiecewiseDefault",
       AutoDelete->False,
       DeletionWarning->True]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxItemSize->{
     "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.84]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}]}]}]], "Output",
 ImageSize->{254, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144711556]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", "pw", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->83971907],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlW81uFEcQHu/MrG28trET8ZMf1oAQUkQCcThFCZgowAGiHOAGF4v/A2Eh
JPLNUvIAPhHnARL5FifHIEV5BN/yAiBZyUt0pme62J6va2aqZ8a7SKzkmanp
6uqvqrurq7rHX60+vX/n4erTB7dWly4/WR3cf3Dr26VLj54kr8KJIJhYDoLg
3qEgeVbJU/qnf58kf9lj9tRLrlFS+IWmQuJSQQT0Pyl3mBatra39nf52d3cn
ge+CXE64vr5u3k4BVz+5dBKyY+5xco+Tu25NsyE/thJC/a6pP2fq/1GIQnMf
TUUOpWX1bflp+/ErOmMK0BaIKnLkzgDHDCv3dxat3ZrmOmbQT1l3f4yxqb0P
LIf1fivGlNPwKCOvPirS7W0RGr6tJQfjZCOLub06beTNq7LRFpvSTAD9jih3
5DcfeTgf9kF5D2ge8Uqtto+JZF9QspmtpUWFc0JfPhxryTcG33O2dADa/Mly
0Win3uqrcm9I4zcTlDmETsk7ui8AGpT7K4sunVXOHK/jL2OnXui8cXkWleVJ
Ktv4hdWBLHZcSXxmbL0d+tsO+5b6btLY0kZJs6W4JRnacl+KdsEZ1DW1Fx3L
TpXK5bFJRkO5zlV43RGwv1COr2UlM03mfYlb3yOQQlFH3tOjnj64eU98zkMC
+dsVVTbX9WW8/lTrFJmxXzZK/iq2U8laJJNCMVBf5ft1P9SeUX5Rak8NfUTM
jBtcpSMj90cWJbbmxjkLRi6u9vViih5bCzG7Hp2iI97L/CDSjaJK8rL2PNVS
ZlXTiI76w34/bbVavWr4abLg2Gmu1E5VOswBTd6RdChfQ2TY3RE2z0rrNeqN
eaDJ+u7Kg9lU2EC3vsrPRT2iUh8eGzHpjyq1kx+iP0FMGL/x66BMv0+BXqiF
mPcBJzxwUW9+zuCR+FDql5OqzDdeglovWK6LFpdG/LKBLH0Z7cqZxqPh5ubm
1taWfjyvspXzP6s0v/7bWvxrcQ0Gg42NDeqdOitf3YyEVsJZc99kdZbm9X7r
Xb1sBGcI7wF5PbAu7eDUW9XqZCnT0CLOrp9Z3G2tYdJMZUYN91Psct6q08DV
d1DVWaX8sxSKDhaB8ycWNcZN76u9WX/K8hSU8hbQz1jkfN/K1pdl9m3xbNEC
P2Mka/KsufNj9k1YAbDkNOC8DfR7QD8EOmKlfgRcd4F+B+hHQIcjlHpYZWsg
7nR9ad4fgfdV0QaWXzVy+iI07wIX+rPLQCO6qmgMy78GGlF2WJRFO/7oHVL0
Q4+nRrNHSZFG18jFHRqRjQpR4zlR26jJGoia7wkcbVyPcNFYJ6+jeH1oth+L
UdYk20bVmK0qd3WTnaG1qxtvP8Qu61WaKRjtYa/SGc7o9qpnrfL2e5L0qTpp
tLP4tjRqs/8QrzuK0M9zmre5j09Rd8zKbavfis5i2fNRL9y8PdrpnYiVjT3k
epnRnGFQDjIq34kn1ZJzeB892pxnrzKg3CnKXB6R2tPzG1Hu1WLfFepVdX5P
c7MdjdrsRTyBOcjKPgNc/ChrOh+WgP4YaD5nlelNY+oEo68mlxkNQ0a6b0bS
V1lGwunCyZdlY1cZLcqys+tAH6rV6hWL1pZHKdjqNeA/LGoVs+QrQB8AGrPm
a0CjbfgsWl9ej5PV78z9Mcu1Atp8D/SArVUWy9l+qAf0Xu8rdz3lIN6qL2Zu
stYQxSROJDT+vWx+JZPIds/m/L7auSGyo5050egZ3/55M4ldlcfu992QzF5c
pmLbba/37/l8pEoKae77vVI9m0jm4mjPD/ixJbF986+mZDakeVXk1cdxdsFb
DaXg919NvtSS2Up2LvIB+/a8R7tV5+qnzJ2+A7NWrmh7e3s9/e3s7FyE+tlZ
B0Zm2TkJRokZr37M/tcgmPgfPnK1Dw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{306, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->97235721]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9252347],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Clip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clip"]], "InlineFormula"],
 " are piecewise functions of real arguments:"
}], "ExampleText",
 CellID->969637580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Min", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"Max", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
    RowBox[{"UnitStep", "[", "x", "]"}], ",", 
    RowBox[{"Clip", "[", 
     RowBox[{"x", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114714105],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Wj1vkzEQdvLmTdI0bfohPsYWWgQUmJiBMoAKlIX+gIYKqR0QqHRiyY6Q
CgOCLQsswE9Ayk/oABNLfoqxX/sS+3z+yBeRUr/2a989Pt+d7y7dbZ8cvnjZ
Pjk6aK89PG6/Pjw6eLP24NWxGMpKjJV+M8a2LjLxzMVT8ZWfP+KrHvFTW/6t
9Hq909NT8ffs7OxvMdLpdHrFp9/vfxjMLIuBmmhzQXhBtJloM92XbZnpB6Y+
ZfFYEe13OZQJmgUaznI9t6zbUWjtO2hYDvvkevpiwW8wqsgE+oDFHPuJMFcL
uQzfM9aaApfn1m7q6G0SB2f3sZ3UtHSXpkLd3sEcept0EiSPnNCbyZHntAZF
z1Vyrfjl4Yxi5GnaMyoXtZNVrizjEbctFMserE2xKD7ctkOJQS74gdBjex2f
cuFv2Dm0fkcjv+BICWvbL4TsfHTFcTHc0PyxhY3ieS4bKGui/1av3SYwyfcn
BYmKea4G57oen4YX2dTIvqBxjOyd5pkXyDBljLBm9Fkq0qi/SMX6Hu87HbOl
D5N5IDjz2aCtkrwpxKN6htnilvqT2fbO1C0+nlfYmCnauI+4hvpzfOhJ5cJ1
3W7p9iYx3+zfRv3G1PZR0yik9BqcvnMvof4Nog/rMWo5Pj8VtDuoX/egnee2
TixHZAu6B7EAeGpAhsdytF56sVz7wFzTycAnIrzYVnMtHRMvjFc9dOaQNIFv
kw9vaZMePpXKGPuF+NykG9uvOlVsGXB7PdatkopIE0S+IFIDZSlg+5aNrRgr
ypqv66dyZ13mjFhRH00Bn5szC/YBaLCUmyRX52bx0i3k0O12ae5NcnTR4QnS
pO+FFFnRK1vOPErL4rItGWyVtlXRjD3uWjnsFbQArMV8XzXk6MGRD2br0TI5
mhOUMUc4z4FGR+9g7IXAuuDEaO1QEZOdv6RqB9grxN51HsI7soS8/MyT8O9M
ziqJVmqE0grKc2DNYJlQjf39fek5in1YOgkyXXHewFn5sUSjLIsevmNAtmnx
mE8X4Gag5St1oSxUYRQP0eLGTe/FF9s/RDFLhhQjtubYfOy2B7sPaLh1ArQv
x5KlvVJsv37501pFnwjOdnA84O4pfNOpmoVdEaByuYZn3OU3j2bQmUySdSRI
K7w7TDUtRrzOlWZe4Up7IIay8wpTIlB9cGe1SFxwxuBFK+RaSRF8bTyWiGkG
FSHGIwlKP+AEFMoFZwTHjrRVYRlABNhCq9Osb7yTxjkIVAG2SR53xpL7erpc
jVXYu2+SVO5OURa4mob1BVc3cYaxrGV3X/fv6Ravg3PfMNZRVT3Qg6t8WM/y
ZwhJNQ3nXnfv32GmOXxDe7AlPuuKkSkFiFBxHBmOzf8vxmVHonCb0B5rtuhS
Tpz2zuG4azLUZt0VtDlkdVAJtm8G7BPjGgoW5K+7PgnSkJ5Sig7/avOxmLfL
bR9wC+HDlXu1Cn7rMGMOSgY4LsY1g9QaRBnR9dVc9hBasL2m0YZu0rqm89Ta
pVsD9lcnKIrjZd7unEnqFc+QZGgLSa0rhGO3XUt65u8SoYw9HD2Pmo/6OHEe
y9QnkRTOscMZXFhObtYa9m4pcblcvYrGw1SxNCD3W9AtoA1n9/ZOU+yJ1vXw
rZSUx7lcRsjhpmtFaRXBoexYpd/vd4pPt9uF+8jne+mshvrVMC3L8fnfRN8j
/ydEYTfyskWjjecdShJfyXd0hP8pQOcbt6Pdz9z0/XKu+o8WVvoHcI8lvA==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{467, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232362104]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->151129220],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " are piecewise functions when their arguments are assumed to be real:"
}], "ExampleText",
 CellID->48769526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Reals"}], "]"}], ",", 
   RowBox[{"PiecewiseExpand", "/@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Abs", "[", "x", "]"}], ",", 
      RowBox[{"Sign", "[", "x", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33381609],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVV9tOwzAMTW/r7gzBYBISGhMvSPwCGvAAvPAR1YS0PSDQ2NfsZ0OSOiM7
NU03ChKVOtepc3Ls2k72nK3mL6/ZajHLxo/L7H2+mH2MH96WaigKhBBrdZ+N
hHqW6sncaymVdH/b6jdSrxIlQyVDkkMaj5RMSOpx8yDyS9vGSh6QbYNsjwBL
jwttIM0lmmTfNlAxWcVgZWbFX7oQp2AReXTLwR07ZLi4+nFh1SbxS7WabN5Q
GKyPidGRAfqUkvWoiifsWrv4MqTVOi7HAipyDP/Ik4Qyp4oHrdJvsJ8H1fJr
k5n81yiM+jwq5lfKRLYuH7GqTxiUcANvLpihV9ATBh6/sOYHNXpxXogZVsIQ
9JaH7VXN7FLKntB2NaZSruVXp919lRuPR/g+R8U42V47JWl72y3YBXlEqNdL
Wy2OxRPoGkFvOnpm8O3aZQhTloMvLojCx+E/oXTldiWhjrmt84mr0L7Me2wH
5mN+xvInedmTWJv9wkj5DoodE/3oFvDsbtBg8fbfDdxzzsDhvIm6l7tFwVj2
5Ha9NWtk3gfG5XulL9qWafsXYlwlV7jsrCNnOmDBn0t4v9wTasRUJOr83mdP
ycgV65OfvX3OvGNtJoB8wVqZTBb3xGZCuJfSPZPn/w1E8Akpulpi\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{154, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->513481137]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28050206],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["KroneckerDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KroneckerDelta"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DiscreteDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiscreteDelta"]], "InlineFormula"],
 " are piecewise functions of complex arguments:"
}], "ExampleText",
 CellID->947506887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"KroneckerDelta", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"DiscreteDelta", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->342926192],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlVl9LwzAQT9tlrdMx6x/0QWEPgiAiexP8AAqizz6XIayIOOa+6z5OvCaX
ml0vNh1DEAtNepe73/1yl93yXCxnr+/FspwW44dFMZ+V08/x/ccCVEkkhFjB
e3Iq4FvBl35XSsE8gDEB8QXnudb2YIyFmUWlVvrRVq5cop3UXglZbfN+I3L8
T1GuYOiBeE70O0R+9NiFRbkm8pkytRsQ/RNj1z1aHwYJ4i5GiXHeJ3ZHypy7
PtFngXjWP0XZENNutY2ro3Gsv2R3GTO75HK2pxe/ZSFytEwR3yTIPpqFrO1x
SaJPFhylK/q6d9LQ2Mh9Fjf14zosIweczzk910MnV5IgCqxxM+4oEPXYz1rW
MVAbs1qXv59PZVW12mr/Jgfc6QlhnDfqwteDr3NoXrIOmLSCdCdpg7Fk0buc
oLYOQztE89cxYqMdslral9rR/aegrS+GcqK+YZ2XMqcdc8hW5mCjrFBsfh+2
N0tnDmWwnRzcbrS7C9brZos8bWbuMCO5Z/0S1yfqp3+rv3Tn+U0U9zbr3nXX
b6/mPiyiL7LKvEE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{215, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->369418008]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332283978],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 " is a piecewise function of a Boolean argument:"
}], "ExampleText",
 CellID->288145478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"Boole", "[", "a", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171421025],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwqACxuAQDkP0fyAJj
lf//gTQzkGQGcuXgPAYQ9z8YDGJRNiDBCuTyQmlGsComIMkE5HGhqeYBEaxw
PlgtRDWURFLLSUW9INexwFWj+4GDBJsI6eWFxiMzUaqFsapih4aeKM1jEpHi
IKmQgREATzdohA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{36, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->379227675]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->398863191],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Which",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Which"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Switch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Switch"]], "InlineFormula"],
 " can be interpreted as piecewise functions: "
}], "ExampleText",
 CellID->474547059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{"a", ",", "x", ",", "y"}], "]"}], ",", 
    RowBox[{"Which", "[", 
     RowBox[{"a", ",", "x", ",", "b", ",", "y", ",", "c", ",", "z"}], "]"}], 
    ",", 
    RowBox[{"Switch", "[", 
     RowBox[{"u", ",", "v", ",", "x", ",", "w", ",", "y"}], "]"}]}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217246397],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1Wd1u0zAUdpqk6TraDbbBxA0VPxIIhARi7HYTgnFBX4A/tZqQtgsEGuOa
e24qeIHeAe8AUh+hj9A3YLxBsBO7sU8+N16SVmqdc+zz48/Hx8dpf3h69O79
8PT4cNg7OBl+PDo+/NR79uGEs3yPMe8VY+zuNuPPMX9KvuLzmn/TR/rUF7/B
ZDIZjUb8dzqdir7VeV+DMyPehlxVV3B9pTNmTckPxTjeMj8RE92sAXhNIu9L
+chRXtgR4j9z3rFwrjUdzi5DbpjMNvNAqjc4a6Ulm1Dyh+Fti2CwRujQbl1y
578JRnluRDQGlTWGROMvY0YrpBdFSaDQoX5pNEUG+12khfabvka5NXPDv4zv
DYXnAjnovSWCNiSOj+PiXSnIlvRB7U6Ib5Ctcl4ikha3Zfs1GblF9OxIf64S
/vWCue4S+h6hXybW2tps9N6O5Ksc4sdmvlDRHMg1dvFQ6bi/wCa1sU7G0N0X
SV3nyXHUhr7Cgt6SOtsJrWINxWQDRLhfQKO4vSgR/Gyx0QE6dGRUXlKnRYX8
Sqx0NW2ZLbUHUlDUB+8utQqJBzk0KKr6+jJXdKFNF3yptY4Vu5DgI/g0M1c/
W+waQgV2TmYDylBcG+7oGzFBs587/iHLMgPE3bBzAerBtYJeF5U8wXJS1eO8
HOILvAGZE5/ZDci1YY8tngd/mreXtQ4Zt84YV1Wuuaa5DCsR10bFWc0hWl/q
WbfgjO20iZYuHOVWq6kzLySt0t2Bui/ViGVyCzD2Mc28tJpZibPqSgi+Bf06
vQe93a95DhEnr0jU2jGuu99o/Tp/X6L8RLa0mnfzYofQLYsXVe+Iqp67A+zp
9AjOAtXbwsJurNfA/JLLb7uz2SxdbYltnXe+25o90X4nfnmaunTeNBvtAXyF
5vrvi1jDQ2JHzMDjpPDcs2Kd2xk+n8JgMBBYt3LYlb0pYsypx98g5kVxrnDH
bxWox+VPFlRlPyA0jnHXGeDagJ4jtttiU1utVPJRrd7Ru1iP0DTflLOGThyx
XDcsXlyLs3xRpKfoJrgpkX1eynMd/9QGrv1vxguqqLy8wx3NtZ48KDUvVRPg
Oso2m8VStvvP5hL8Fvk3KO2p/b6wXNSXFE2O88PVMZ6J/jZDVSuoZryleYrG
rRIa17G41nwa628E1LvD33DsC2PMH2mlb3CbMc5Cf41R+TsnxvjMkFJ5G8cb
Hqti+KyifRbwc/1L8hmPx/o7T32l/iXjhbT9Xwjm/Qcgn7Vf\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{347, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169559438]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->261509589],

Cell[TextData[{
 "Convert ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FractionalPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionalPart"]], "InlineFormula"],
 " for finite ranges:"
}], "ExampleText",
 CellID->358402805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", "3"}], "}"}], ",", 
   RowBox[{"PiecewiseExpand", "/@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Floor", "[", "x", "]"}], ",", 
      RowBox[{"Ceiling", "[", "x", "]"}], ",", 
      RowBox[{"Round", "[", "x", "]"}], ",", 
      RowBox[{"IntegerPart", "[", "x", "]"}], ",", 
      RowBox[{"FractionalPart", "[", "x", "]"}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->320213802],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{480, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6480126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20239171],

Cell[TextData[{
 "Convert ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Quotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quotient"]], "InlineFormula"],
 " when the number of cases is finite:"
}], "ExampleText",
 CellID->221978717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"0", "\[LessEqual]", "k", "\[LessEqual]", 
    RowBox[{"3", "m"}]}], ",", 
   RowBox[{"PiecewiseExpand", "/@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"k", ",", "m"}], "]"}], ",", 
      RowBox[{"Quotient", "[", 
       RowBox[{"k", ",", "m"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->372437897],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WUtPFEEQHmZ2dpfXAoLyjusDNSLoRVDBeNDoQYkX4QwhJhAlEiSBxOj6
D0g0hiNHjvwE/4AJdy4cOfIT2u6eqp3emuqe2YHdhO3pV9VX1dVV3w4LK9tr
HzdWttdXV6pvtlY219ZXv1Zff9mSQ0Gb53kn8m9xyJPPQj7pvxMhZGt+d6jv
wu7u7l/9OTs7+xePB7VaTeiPF8ovX4rwCnoaPt2yU5LtoGwD2QayDaHVq4N4
tS8fC7L9wcovahwKY9T3vB6tNhqpf3vDel+8Lkjp+6DZHPtpRxDEmkpgSyE/
jrDeh13ZkahFvZesOWyJ933iI2JtYtSBwPC+D9EVGFGkvikCXyTiEkZwJgAp
tVS96nEy4Ql6ZkusZx6z0vHWTInonsxr6fKe7e3tye/j4+OhJqTtKGly20jO
PT7xpXvHh5bNluFERkUUkxjvVXbXO9baOyCrZMzWj8wbIWfGr7qeQ18nkRz1
5QRkuSheZZ9EAN03fgm6R0F2e2bZNAJQcjvMjRkSfeuJ4DlyvqBZv8z6Kw0r
auDPrWLIUP3+Jk6XxmAPtAPCFYN89VM4sEKo290F/RDaQWJrCDr6hHGPC7Ed
njfDandn59ji0BiNpXaza2nM6L2BTEg1/dHqdZ94gD+RXtMiQ+qs3R6m0oZk
d5G1p0JWlQFZFGnn5+cNFsg+rMNa1U32VwD7MMw/tWJWm65wfktg7GFWKdlD
gs8GiIHPm8nzpyh4jtLL+BNRcOMYlw4UpEJTHL5IVuw+sqZk8Y2ZNa417x9j
tcmb6i6LbmNi1LTAnkswvnn9aEE/WD8MLfYxtzT6tyAM7kRrQENWuAv7FmCH
jrkE72PlGPP3QMpDw8JYyyhzkuk63gKi+y2QvdNimbQW5pP4icy3g4b3uaUp
XB0XkvKZzJed0ii/jaTt7+8fHh6qxw1h5ldZESR3PT09rWdtrHpFwVc9JS/A
ymGMt0WuN06gSOx4wp78MxFX8ORN7WJHO4jufrCpyK5WSNUPaIWwzeGjzc1N
6Qs3Us0Fl5eXlccoF6KVDFlXCfdBNqScEjNHF4uKejgtWmZZ7HMiZoYuzGZN
wch1/h7PjIneT0RENVBEJcFXOczStFo0lzm4yk3vGpWTVt3y+cjNkfl7kK3a
UR7WHB5k1hXBV8F8/ucZOLJ3NasYuKq8IdwgNY6/b3QNaaipY7lQXIyJR7Fi
59hUO5/hJkyb6C+pfBYxXJzGsflWiVpk59y2THULbJiG+essdhtDQi4+kAnj
uOAzE2JoZFXp3LtPJGtHrG3U0OYbEXi5nLoiklmF1lebzy/Coc23b/b8MeHU
RNnyiGjMD26PzRrnEdk9n77esOu5cLHKKitjBhC/yLHXzWLT99Aq6N7Rund2
Wdke/gegw34aublGcyyuFQjwXUNWhkbldbYAE2VgNHPb/WBjWFm9wL1HoHzW
HlHNnnYWJlW+kMZs7Ij3p8l+FMoeaDGrYctHAM9u5hgPhJBfvYL8RRFV3YOD
gylBs+INVk+ymj3QK9Lf+1HfLZH+Tbs+w6MaZ4Z3dJRlL8L4bauWAG8Mg/Vb
Rl/Mk300nh1ySA2fFMlYpWwlXZp6nCbSr2aSgqf2SMTRp/rf49WFo6Oj6BTk
Yc8YvojQ/tJPr4i233r0JUj7o3vR/5G9tv8YFxM6\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{218, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->623163517]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27769],

Cell["\<\
The number of cases in the expanded form may grow exponentially:\
\>", "ExampleText",
 CellID->605718436],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"i_Integer", ",", " ", "n_Integer", ",", " ", "x_"}], "]"}], " ", ":=",
   " ", "\n", "  ", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "^", 
       RowBox[{"(", 
        RowBox[{"i", " ", "-", " ", "1"}], ")"}]}], ",", " ", 
      RowBox[{"Or", " ", "@@", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"j", "<=", "x", "<", " ", 
          RowBox[{"j", "+", 
           RowBox[{"2", "^", 
            RowBox[{"(", 
             RowBox[{"i", "-", "1"}], ")"}]}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"2", "^", 
            RowBox[{"(", 
             RowBox[{"i", "-", "1"}], ")"}]}], ",", 
           RowBox[{"2", "^", "n"}], ",", 
           RowBox[{"2", "^", "i"}]}], "}"}]}], "]"}]}]}], "}"}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30251226],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " element of ",
 Cell[BoxData[
  StyleBox["sums", "TI"]], "InlineFormula"],
 " is a sum of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " piecewise functions with two cases each:"
}], "ExampleText",
 CellID->197207495],

Cell[BoxData[
 RowBox[{
  RowBox[{"sums", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"i", ",", "n", ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "n"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45936071],

Cell[TextData[{
 "The number of cases in the expanded form of the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " element of ",
 Cell[BoxData[
  StyleBox["sums", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["2", "n"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->750346187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"First", "[", 
      RowBox[{"PiecewiseExpand", "[", "#", "]"}], "]"}], "]"}], "+", "1"}], 
   "&"}], "/@", "sums"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->652104710],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "4", ",", "8", ",", "16", ",", "32", ",", "64", ",", "128", ",", 
   "256", ",", "512", ",", "1024"}], "}"}]], "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->951662]
}, Open  ]],

Cell[TextData[{
 "This shows graphs of summands in the fourth element of ",
 Cell[BoxData[
  StyleBox["sums", "TI"]], "InlineFormula"],
 "; their sum is shown in red:"
}], "ExampleText",
 CellID->217143722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "@", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"i", ",", "4", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "4"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "16"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "16"}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]",
    
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "@", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"i", ",", "4", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "4"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "16"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->58723793],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWl9onEUQ38uX5LvWquQSsYJCHiTEUtuaR/GhD1orYlvBv08ag5A+NAn1
RLQPxRbahyoFodqCVCnEs2lKU5JeqjU0VgSFkkDaUKgPMUK4VhoCibEeFtaZ
nf3+7N5+f+8aQY/NfDc7u7+ZnZ3dnW8vL3Tmu9/e1Znf2dXZ+uzuzr7unV3v
tG7p3Q1VVoaxzD7G2J61DL5z+Cb+8LMf/uhrnG85oHXQdRM8LXhukM86Wb9e
8qxeNJefK4JpQlrv6EVpBz4sr2Z9RYs6rcU6jbc0/sVEdrWsmF0v1Ryx6T9o
+yY5WxvjafBayH6vrqil/nYb4mlq8FuMEfhKlSOmCHZWZYd8Pi6fFveiv04G
Pz71GU1r/QPc2R0aY2pudnvoO8sVTeOg6/kBqFxrlLY4tUe/+AQKs5EgPzjy
ORRmI0H+y5ETUJiNBPkLk0NQWBaJkPcPQgE5ECEf/xYKs5EgPzB+CQqzkSA/
MTcNhdlIkB890Q+F2UiQnxobhsKySJD/fuwCFGYjQX7utwkozEYi5Cd/ggJy
IEI+8QsUkANBfnJiDgqzkfi8YGteeVB6K6t6R0r1mNX5jRr/qMtfvAgFtAEJ
0Z7VeF1eLf9v468yevW7hF7W+eZYqIOBrXBVnTZKyf5SaVFGTxaIGINVLt/x
1TFraams9Jm+ekOJuNnZhUhMwKgKE3hFDu0VeTD+Q4G+qnPWgnVqYKq3ZxgK
s5FY7+aL8/PLinYpzwo5qJBojY7H9nzwjSc/dvRnxboofMCrCh94BR8aQ5c4
+MHeMUUSeYufOcMpRcxysZlPTsp2n1UZrdXG9AiQenmeBM95TkhnLk0N9xyB
wnJIkJetxXlu/fDRKSlvEvJi/lh56U9PvliaV/pfPn5e6T899KMiv3H1VynP
+axjodZW5BoWmCB3/5zY/ckkT74we1PKm4Rc1doi6sBypc/y/KKCeaf8t5Q3
azYY8x+LLyzIMyArzgBeKkn5x8aRjGo8ZhPISjSIps2boQAaEIuPjiZGi/Ym
Roqa08SbhXMyhhp4WBwGxzL2GYulyYn0h8kr4NOtW31eOXxYttsfywJEWU2z
MzOTqGdtVytybaLV8h/zxdP54ZM9rA2JBQxUoYjk4+cPQL0nh2RIokZFpdkW
RH0MQNpF/a2b12WW1SayrPJfS1Wh+3ceyx0jb22VO6VNOyUENrV/PxDFvzM0
GHWvkTp0qT82K3vdr9Xq66S63kWD17yZN/VG1hxF9wZYYs6l+LVrSgbqnUa9
Lpq/l77OnRh9gtC6u+XuY9M627FDQXPeVLLce3MJs7HfP5aKWLovonfB5PVY
KKjz61S9g+Igvi3Y+5xwddj+mm5sX2n8PZF6nqR5hZxl714oMHNAxJlF8jdS
24HjXGPUjw2lXghN0muT3oMH+e3bKHozlV7da6u5eS8we1dftfq6LPhHFbJm
9MjK0NAteiBt0loUufqmPwDPDDyxZybQNtNpada9sivrGZrbQkHNVGCuqd3L
qdH9/NOkBcLFy65eqwly+tFXj7JN8BNz08cvD0Bh25FY12/NSLlzW+VkWPF3
MWy9XdQDmoJeWvxdtqu8q6vNvhSdT24zzCbxJH/eqNdZL2G7NFZLdMiVzbnz
c9x/DtUqG659Fp0sP07eitYP7v7KaeCu3C2BKGjZ67F6Z7n660JUHkOWr6rw
pb4j6nwtcbxZiNcf2aGIcaa152ziHndXE7JvcWf1Km9hfX2y3VPcmXn//bbu
keQj6yK9kNMqOa77Dkd69XhN68Fa4uD4zxr8keatOV0r1NRD/oNNkfnfw9rb
ZRbWsWKWqHscegYbOTkTfkzvEyHzYrs8QUigBAgh86ifd+9RpfuuhafXuljI
OpKzoiQi5MP6+5ZIzVl7avT/Q1zvo8HrGSjMD7V7JJaODwmlVArISeKhJB2P
c8YHe8w5WfTZjXcXkzS246H4b3cOEQw4jfnvwd08gH61cfIA9b8KjGdCoz8W
iYacpgniX4t0HnlSx1i5wZhaFpHAziFuvk8xz5V20geMKiQ/qvitujGi7xEy
Rs/e3Ztu+vXPfysUdDuE9Z8SGqxWZfUWCgra3Vh3WLVL1OA3ugFmmX8AuNQS
8Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->17015840]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30079],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxPiecewiseCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxPiecewiseCases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogicalExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogicalExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24399]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29145],

Cell[TextData[ButtonBox["Logical and Piecewise Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LogicalAndPiecewiseFunctions"]], "Tutorials",
 CellID->19984]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->507553290],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->202245992],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "MoreAbout",
 CellID->59392098]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PiecewiseExpand - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 33.0076872}", "context" -> "System`", 
    "keywords" -> {
     "conditionals", "de-nesting", "denesting", "expansion", "flattening", 
      "PNF"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "PiecewiseExpand[expr] expands nested piecewise functions in expr to give \
a single piecewise function. PiecewiseExpand[expr, assum] expands piecewise \
functions using assumptions. PiecewiseExpand[expr, assum, dom] does the \
expansion over the domain dom. ", "synonyms" -> {"piecewise expand"}, "title" -> 
    "PiecewiseExpand", "type" -> "Symbol", "uri" -> "ref/PiecewiseExpand"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9440, 319, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->204555231]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 97205, 3024}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2363, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2986, 82, 53, 1, 70, "ObjectName",
 CellID->28237],
Cell[3042, 85, 1474, 44, 70, "Usage",
 CellID->6272]
}, Open  ]],
Cell[CellGroupData[{
Cell[4553, 134, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5031, 151, 919, 35, 70, "Notes",
 CellID->1792],
Cell[5953, 188, 1054, 42, 70, "Notes",
 CellID->12200],
Cell[7010, 232, 538, 18, 70, "Notes",
 CellID->26343],
Cell[7551, 252, 387, 16, 70, "Notes",
 CellID->17519],
Cell[7941, 270, 372, 12, 70, "Notes",
 CellID->7481],
Cell[8316, 284, 68, 1, 70, "Notes",
 CellID->3370],
Cell[8387, 287, 1016, 27, 70, "3ColumnTableMod",
 CellID->8991]
}, Closed]],
Cell[CellGroupData[{
Cell[9440, 319, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->204555231],
Cell[CellGroupData[{
Cell[9825, 333, 147, 5, 70, "ExampleSection",
 CellID->73732482],
Cell[9975, 340, 119, 3, 70, "ExampleText",
 CellID->895155080],
Cell[CellGroupData[{
Cell[10119, 347, 419, 14, 28, "Input",
 CellID->74651977],
Cell[10541, 363, 865, 18, 64, "Output",
 Evaluatable->False,
 CellID->74886745]
}, Open  ]],
Cell[CellGroupData[{
Cell[11443, 386, 111, 3, 28, "Input",
 CellID->870838768],
Cell[11557, 391, 796, 17, 64, "Output",
 Evaluatable->False,
 CellID->180484406]
}, Open  ]],
Cell[12368, 411, 257, 8, 70, "ExampleText",
 CellID->448183362],
Cell[CellGroupData[{
Cell[12650, 423, 247, 8, 70, "Input",
 CellID->363411343],
Cell[12900, 433, 336, 11, 36, "Output",
 CellID->429565081]
}, Open  ]],
Cell[CellGroupData[{
Cell[13273, 449, 110, 3, 28, "Input",
 CellID->31075914],
Cell[13386, 454, 983, 20, 64, "Output",
 Evaluatable->False,
 CellID->39428336]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14418, 480, 216, 7, 70, "ExampleSection",
 CellID->12193],
Cell[14637, 489, 126, 3, 70, "ExampleText",
 CellID->190006806],
Cell[CellGroupData[{
Cell[14788, 496, 758, 25, 70, "Input",
 CellID->349598872],
Cell[15549, 523, 1521, 29, 70, "Output",
 Evaluatable->False,
 CellID->507389241]
}, Open  ]],
Cell[CellGroupData[{
Cell[17107, 557, 111, 3, 70, "Input",
 CellID->805893054],
Cell[17221, 562, 1346, 43, 100, "Output",
 CellID->2755341]
}, Open  ]],
Cell[18582, 608, 124, 3, 70, "ExampleDelimiter",
 CellID->83535809],
Cell[18709, 613, 311, 13, 70, "ExampleText",
 CellID->690244425],
Cell[CellGroupData[{
Cell[19045, 630, 185, 5, 70, "Input",
 CellID->372097708],
Cell[19233, 637, 1318, 26, 70, "Output",
 Evaluatable->False,
 CellID->299296047]
}, Open  ]],
Cell[20566, 666, 125, 3, 70, "ExampleDelimiter",
 CellID->165905118],
Cell[20694, 671, 122, 3, 70, "ExampleText",
 CellID->247422714],
Cell[CellGroupData[{
Cell[20841, 678, 201, 6, 70, "Input",
 CellID->221852118],
Cell[21045, 686, 780, 17, 70, "Output",
 Evaluatable->False,
 CellID->165861075]
}, Open  ]],
Cell[CellGroupData[{
Cell[21862, 708, 203, 6, 70, "Input",
 CellID->187010840],
Cell[22068, 716, 800, 17, 70, "Output",
 Evaluatable->False,
 CellID->106163194]
}, Open  ]],
Cell[22883, 736, 125, 3, 70, "ExampleDelimiter",
 CellID->268165512],
Cell[23011, 741, 127, 3, 70, "ExampleText",
 CellID->229979767],
Cell[CellGroupData[{
Cell[23163, 748, 295, 10, 70, "Input",
 CellID->652596927],
Cell[23461, 760, 582, 22, 55, "Output",
 CellID->180405948]
}, Open  ]],
Cell[24058, 785, 125, 3, 70, "ExampleDelimiter",
 CellID->655319122],
Cell[24186, 790, 74, 1, 70, "ExampleText",
 CellID->92858253],
Cell[CellGroupData[{
Cell[24285, 795, 262, 9, 70, "Input",
 CellID->130507080],
Cell[24550, 806, 1862, 35, 70, "Output",
 Evaluatable->False,
 CellID->36670847]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26461, 847, 218, 7, 70, "ExampleSection",
 CellID->25516],
Cell[CellGroupData[{
Cell[26704, 858, 228, 7, 70, "ExampleSubsection",
 CellID->28608],
Cell[26935, 867, 119, 3, 70, "ExampleText",
 CellID->565056155],
Cell[CellGroupData[{
Cell[27079, 874, 266, 8, 70, "Input",
 CellID->237031262],
Cell[27348, 884, 625, 14, 70, "Output",
 Evaluatable->False,
 CellID->350184002]
}, Open  ]],
Cell[27988, 901, 124, 3, 70, "ExampleDelimiter",
 CellID->53304432],
Cell[28115, 906, 353, 13, 70, "ExampleText",
 CellID->279368443],
Cell[CellGroupData[{
Cell[28493, 923, 238, 7, 70, "Input",
 CellID->359819269],
Cell[28734, 932, 625, 14, 70, "Output",
 Evaluatable->False,
 CellID->650735177]
}, Open  ]],
Cell[29374, 949, 125, 3, 70, "ExampleDelimiter",
 CellID->192956252],
Cell[29502, 954, 250, 8, 70, "ExampleText",
 CellID->373032043],
Cell[CellGroupData[{
Cell[29777, 966, 394, 13, 70, "Input",
 CellID->71170035],
Cell[30174, 981, 2709, 48, 70, "Output",
 Evaluatable->False,
 CellID->120994481]
}, Open  ]],
Cell[32898, 1032, 246, 8, 70, "ExampleText",
 CellID->8600092],
Cell[CellGroupData[{
Cell[33169, 1044, 434, 14, 70, "Input",
 CellID->398567800],
Cell[33606, 1060, 1239, 40, 82, "Output",
 CellID->28819917]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34894, 1106, 223, 7, 70, "ExampleSubsection",
 CellID->17888],
Cell[35120, 1115, 261, 9, 70, "ExampleText",
 CellID->28413153],
Cell[CellGroupData[{
Cell[35406, 1128, 131, 3, 70, "Input",
 CellID->52084067],
Cell[35540, 1133, 1122, 23, 105, "Output",
 CellID->1231622]
}, Open  ]],
Cell[36677, 1159, 124, 3, 70, "ExampleDelimiter",
 CellID->38619452],
Cell[36804, 1164, 130, 4, 70, "ExampleText",
 CellID->67597828],
Cell[36937, 1170, 488, 18, 70, "Input",
 CellID->857037900],
Cell[CellGroupData[{
Cell[37450, 1192, 112, 3, 70, "Input",
 CellID->267261033],
Cell[37565, 1197, 1903, 35, 70, "Output",
 Evaluatable->False,
 CellID->553438113]
}, Open  ]],
Cell[39483, 1235, 212, 8, 70, "ExampleText",
 CellID->256530812],
Cell[CellGroupData[{
Cell[39720, 1247, 261, 8, 70, "Input",
 CellID->339759927],
Cell[39984, 1257, 948, 20, 70, "Output",
 Evaluatable->False,
 CellID->132022670]
}, Open  ]],
Cell[40947, 1280, 125, 3, 70, "ExampleDelimiter",
 CellID->198612935],
Cell[41075, 1285, 357, 13, 70, "ExampleText",
 CellID->35085023],
Cell[CellGroupData[{
Cell[41457, 1302, 448, 16, 70, "Input",
 CellID->178753563],
Cell[41908, 1320, 525, 18, 39, "Output",
 CellID->49867902]
}, Open  ]],
Cell[42448, 1341, 87, 1, 70, "ExampleText",
 CellID->333691978],
Cell[CellGroupData[{
Cell[42560, 1346, 111, 3, 70, "Input",
 CellID->32152411],
Cell[42674, 1351, 1089, 22, 70, "Output",
 Evaluatable->False,
 CellID->75049474]
}, Open  ]],
Cell[43778, 1376, 211, 8, 70, "ExampleText",
 CellID->38999179],
Cell[CellGroupData[{
Cell[44014, 1388, 258, 8, 70, "Input",
 CellID->43000480],
Cell[44275, 1398, 691, 15, 70, "Output",
 Evaluatable->False,
 CellID->154457246]
}, Open  ]],
Cell[44981, 1416, 125, 3, 70, "ExampleDelimiter",
 CellID->207328952],
Cell[45109, 1421, 273, 8, 70, "ExampleText",
 CellID->252155765],
Cell[CellGroupData[{
Cell[45407, 1433, 600, 20, 70, "Input",
 CellID->181231574],
Cell[46010, 1455, 1052, 21, 70, "Output",
 Evaluatable->False,
 CellID->75482528]
}, Open  ]],
Cell[CellGroupData[{
Cell[47099, 1481, 112, 3, 70, "Input",
 CellID->134158232],
Cell[47214, 1486, 930, 19, 70, "Output",
 Evaluatable->False,
 CellID->799576591]
}, Open  ]],
Cell[48159, 1508, 78, 1, 70, "ExampleText",
 CellID->181786566],
Cell[CellGroupData[{
Cell[48262, 1513, 259, 8, 70, "Input",
 CellID->107646819],
Cell[48524, 1523, 979, 20, 70, "Output",
 Evaluatable->False,
 CellID->57735742]
}, Open  ]],
Cell[49518, 1546, 125, 3, 70, "ExampleDelimiter",
 CellID->227735288],
Cell[49646, 1551, 246, 8, 70, "ExampleText",
 CellID->255163144],
Cell[49895, 1561, 327, 11, 70, "Input",
 CellID->322366141],
Cell[CellGroupData[{
Cell[50247, 1576, 112, 3, 70, "Input",
 CellID->222385778],
Cell[50362, 1581, 894, 19, 70, "Output",
 Evaluatable->False,
 CellID->20696096]
}, Open  ]],
Cell[51271, 1603, 437, 18, 70, "ExampleText",
 CellID->71038135],
Cell[CellGroupData[{
Cell[51733, 1625, 319, 9, 70, "Input",
 CellID->404499686],
Cell[52055, 1636, 716, 16, 70, "Output",
 Evaluatable->False,
 CellID->119314731]
}, Open  ]],
Cell[52786, 1655, 123, 3, 70, "ExampleDelimiter",
 CellID->5561923],
Cell[52912, 1660, 144, 4, 70, "ExampleText",
 CellID->248983132],
Cell[CellGroupData[{
Cell[53081, 1668, 241, 7, 70, "Input",
 CellID->116636326],
Cell[53325, 1677, 608, 20, 36, "Output",
 CellID->612529564]
}, Open  ]],
Cell[53948, 1700, 393, 14, 70, "ExampleText",
 CellID->525996262],
Cell[CellGroupData[{
Cell[54366, 1718, 386, 12, 70, "Input",
 CellID->26678944],
Cell[54755, 1732, 800, 17, 70, "Output",
 Evaluatable->False,
 CellID->81603445]
}, Open  ]],
Cell[55570, 1752, 265, 9, 70, "ExampleText",
 CellID->350046196],
Cell[CellGroupData[{
Cell[55860, 1765, 174, 5, 70, "Input",
 CellID->642611037],
Cell[56037, 1772, 560, 13, 70, "Output",
 Evaluatable->False,
 CellID->133560445]
}, Open  ]],
Cell[CellGroupData[{
Cell[56634, 1790, 317, 10, 70, "Input",
 CellID->210221758],
Cell[56954, 1802, 298, 11, 36, "Output",
 CellID->144866578]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[57301, 1819, 230, 7, 70, "ExampleSubsection",
 CellID->9499],
Cell[57534, 1828, 105, 2, 70, "ExampleText",
 CellID->282745970],
Cell[CellGroupData[{
Cell[57664, 1834, 741, 24, 70, "Input",
 CellID->375930197],
Cell[58408, 1860, 378, 12, 39, "Output",
 CellID->11902581]
}, Open  ]],
Cell[58801, 1875, 137, 4, 70, "ExampleText",
 CellID->494098244],
Cell[CellGroupData[{
Cell[58963, 1883, 741, 24, 70, "Input",
 CellID->131296158],
Cell[59707, 1909, 948, 20, 70, "Output",
 Evaluatable->False,
 CellID->496716580]
}, Open  ]],
Cell[60670, 1932, 125, 3, 70, "ExampleDelimiter",
 CellID->542943071],
Cell[60798, 1937, 146, 4, 70, "ExampleText",
 CellID->334985144],
Cell[CellGroupData[{
Cell[60969, 1945, 797, 26, 70, "Input",
 CellID->98459912],
Cell[61769, 1973, 931, 19, 70, "Output",
 Evaluatable->False,
 CellID->339581018]
}, Open  ]],
Cell[CellGroupData[{
Cell[62737, 1997, 798, 26, 70, "Input",
 CellID->546718945],
Cell[63538, 2025, 948, 20, 70, "Output",
 Evaluatable->False,
 CellID->620124556]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[64547, 2052, 233, 7, 70, "ExampleSection",
 CellID->22338],
Cell[64783, 2061, 343, 12, 70, "ExampleText",
 CellID->216819620],
Cell[CellGroupData[{
Cell[65151, 2077, 688, 23, 70, "Input",
 CellID->52736705],
Cell[65842, 2102, 1214, 38, 64, "Output",
 CellID->144711556]
}, Open  ]],
Cell[CellGroupData[{
Cell[67093, 2145, 111, 3, 70, "Input",
 CellID->83971907],
Cell[67207, 2150, 2135, 39, 70, "Output",
 Evaluatable->False,
 CellID->97235721]
}, Open  ]],
Cell[69357, 2192, 123, 3, 70, "ExampleDelimiter",
 CellID->9252347],
Cell[69483, 2197, 573, 22, 70, "ExampleText",
 CellID->969637580],
Cell[CellGroupData[{
Cell[70081, 2223, 451, 14, 70, "Input",
 CellID->114714105],
Cell[70535, 2239, 1981, 37, 70, "Output",
 Evaluatable->False,
 CellID->232362104]
}, Open  ]],
Cell[72531, 2279, 125, 3, 70, "ExampleDelimiter",
 CellID->151129220],
Cell[72659, 2284, 356, 12, 70, "ExampleText",
 CellID->48769526],
Cell[CellGroupData[{
Cell[73040, 2300, 349, 11, 70, "Input",
 CellID->33381609],
Cell[73392, 2313, 874, 18, 70, "Output",
 Evaluatable->False,
 CellID->513481137]
}, Open  ]],
Cell[74281, 2334, 124, 3, 70, "ExampleDelimiter",
 CellID->28050206],
Cell[74408, 2339, 374, 12, 70, "ExampleText",
 CellID->947506887],
Cell[CellGroupData[{
Cell[74807, 2355, 291, 9, 70, "Input",
 CellID->342926192],
Cell[75101, 2366, 777, 17, 70, "Output",
 Evaluatable->False,
 CellID->369418008]
}, Open  ]],
Cell[75893, 2386, 125, 3, 70, "ExampleDelimiter",
 CellID->332283978],
Cell[76021, 2391, 218, 7, 70, "ExampleText",
 CellID->288145478],
Cell[CellGroupData[{
Cell[76264, 2402, 143, 4, 70, "Input",
 CellID->171421025],
Cell[76410, 2408, 410, 11, 70, "Output",
 Evaluatable->False,
 CellID->379227675]
}, Open  ]],
Cell[76835, 2422, 125, 3, 70, "ExampleDelimiter",
 CellID->398863191],
Cell[76963, 2427, 454, 17, 70, "ExampleText",
 CellID->474547059],
Cell[CellGroupData[{
Cell[77442, 2448, 431, 13, 70, "Input",
 CellID->217246397],
Cell[77876, 2463, 1480, 28, 70, "Output",
 Evaluatable->False,
 CellID->169559438]
}, Open  ]],
Cell[79371, 2494, 125, 3, 70, "ExampleDelimiter",
 CellID->261509589],
Cell[79499, 2499, 720, 28, 70, "ExampleText",
 CellID->358402805],
Cell[CellGroupData[{
Cell[80244, 2531, 527, 15, 70, "Input",
 CellID->320213802],
Cell[80774, 2548, 2698, 48, 70, "Output",
 Evaluatable->False,
 CellID->6480126]
}, Open  ]],
Cell[83487, 2599, 124, 3, 70, "ExampleDelimiter",
 CellID->20239171],
Cell[83614, 2604, 345, 13, 70, "ExampleText",
 CellID->221978717],
Cell[CellGroupData[{
Cell[83984, 2621, 422, 13, 70, "Input",
 CellID->372437897],
Cell[84409, 2636, 1899, 35, 70, "Output",
 Evaluatable->False,
 CellID->623163517]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86357, 2677, 226, 7, 70, "ExampleSection",
 CellID->27769],
Cell[86586, 2686, 115, 3, 70, "ExampleText",
 CellID->605718436],
Cell[86704, 2691, 945, 29, 70, "Input",
 CellID->30251226],
Cell[87652, 2722, 399, 15, 70, "ExampleText",
 CellID->197207495],
Cell[88054, 2739, 413, 14, 70, "Input",
 CellID->45936071],
Cell[88470, 2755, 426, 16, 70, "ExampleText",
 CellID->750346187],
Cell[CellGroupData[{
Cell[88921, 2775, 258, 9, 70, "Input",
 CellID->652104710],
Cell[89182, 2786, 300, 9, 36, "Output",
 CellID->951662]
}, Open  ]],
Cell[89497, 2798, 206, 6, 70, "ExampleText",
 CellID->217143722],
Cell[CellGroupData[{
Cell[89728, 2808, 999, 31, 70, "Input",
 CellID->58723793],
Cell[90730, 2841, 2351, 43, 70, "Output",
 Evaluatable->False,
 CellID->17015840]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[93142, 2891, 311, 9, 70, "SeeAlsoSection",
 CellID->30079],
Cell[93456, 2902, 1214, 44, 70, "SeeAlso",
 CellID->24399]
}, Open  ]],
Cell[CellGroupData[{
Cell[94707, 2951, 314, 9, 70, "TutorialsSection",
 CellID->29145],
Cell[95024, 2962, 170, 3, 70, "Tutorials",
 CellID->19984]
}, Open  ]],
Cell[CellGroupData[{
Cell[95231, 2970, 319, 9, 70, "MoreAboutSection",
 CellID->507553290],
Cell[95553, 2981, 161, 3, 70, "MoreAbout",
 CellID->202245992],
Cell[95717, 2986, 135, 3, 70, "MoreAbout",
 CellID->59392098]
}, Open  ]],
Cell[95867, 2992, 29, 0, 70, "History"],
Cell[95899, 2994, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

