(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26611,        658]
NotebookOptionsPosition[     23962,        568]
NotebookOutlinePosition[     25152,        604]
CellTagsIndexPosition[     25067,        599]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LightPink" :> Documentation`HelpLookup["paclet:ref/LightPink"],
           "ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
          "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], "Hue" :> 
          Documentation`HelpLookup["paclet:ref/Hue"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LightPink\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Hue\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Pink", "ObjectName",
 CellID->6361],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Pink",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Pink"]], "InlineFormula"],
     "\[LineSeparator]represents the color pink in graphics or style \
specifications. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Pink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pink"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{"1", ",", "0.5", ",", "0.5"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->462276934]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->233146148],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->455888035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Pink", ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->81396958]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Pink"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245967023],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->13068495]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Pink", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->82364862],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0.5], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->224782285,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27445],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LightPink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LightPink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2524]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->413328406],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->48910538]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pink - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 35.6015036}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Pink represents the color pink in graphics or style specifications. ", 
    "synonyms" -> {}, "title" -> "Pink", "type" -> "Symbol", "uri" -> 
    "ref/Pink"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3695, 121, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->233146148]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24924, 592}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1660, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2283, 63, 41, 1, 70, "ObjectName",
 CellID->6361],
Cell[2327, 66, 440, 14, 70, "Usage",
 CellID->32421]
}, Open  ]],
Cell[CellGroupData[{
Cell[2804, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3282, 102, 376, 14, 70, "Notes",
 CellID->462276934]
}, Closed]],
Cell[CellGroupData[{
Cell[3695, 121, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->233146148],
Cell[CellGroupData[{
Cell[4080, 135, 148, 5, 70, "ExampleSection",
 CellID->455888035],
Cell[CellGroupData[{
Cell[4253, 144, 182, 6, 28, "Input",
 CellID->511908593],
Cell[4438, 152, 266, 8, 121, "Output",
 CellID->81396958]
}, Open  ]],
Cell[CellGroupData[{
Cell[4741, 165, 265, 8, 28, "Input",
 CellID->245967023],
Cell[5009, 175, 2349, 43, 109, "Output",
 Evaluatable->False,
 CellID->13068495]
}, Open  ]],
Cell[CellGroupData[{
Cell[7395, 223, 185, 6, 70, "Input",
 CellID->82364862],
Cell[7583, 231, 13791, 231, 129, 90, 2, "CachedBoxData", "BoxData", "Output",
 CellID->224782285]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21435, 469, 311, 9, 70, "SeeAlsoSection",
 CellID->27445],
Cell[21749, 480, 1657, 62, 70, "SeeAlso",
 CellID->2524]
}, Open  ]],
Cell[CellGroupData[{
Cell[23443, 547, 319, 9, 70, "MoreAboutSection",
 CellID->413328406],
Cell[23765, 558, 123, 3, 70, "MoreAbout",
 CellID->48910538]
}, Open  ]],
Cell[23903, 564, 29, 0, 70, "History"],
Cell[23935, 566, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

