(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64445,       1410]
NotebookOptionsPosition[     60457,       1277]
NotebookOutlinePosition[     61825,       1316]
CellTagsIndexPosition[     61739,       1311]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Coordinate Systems for Two\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CoordinateSystemsForTwoDimensionalGraphics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Coordinate Systems for Two\[Hyphen]Dimensional Graphics\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PlotRange" :> Documentation`HelpLookup["paclet:ref/PlotRange"],
           "AspectRatio" :> 
          Documentation`HelpLookup["paclet:ref/AspectRatio"], "Scaled" :> 
          Documentation`HelpLookup["paclet:ref/Scaled"], "ImageScaled" :> 
          Documentation`HelpLookup["paclet:ref/ImageScaled"], 
          "SphericalRegion" :> 
          Documentation`HelpLookup["paclet:ref/SphericalRegion"], 
          "PlotRangePadding" :> 
          Documentation`HelpLookup["paclet:ref/PlotRangePadding"], 
          "PlotRangeClipping" :> 
          Documentation`HelpLookup["paclet:ref/PlotRangeClipping"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PlotRange\"\>", 
       2->"\<\"AspectRatio\"\>", 3->"\<\"Scaled\"\>", 
       4->"\<\"ImageScaled\"\>", 5->"\<\"SphericalRegion\"\>", 
       6->"\<\"PlotRangePadding\"\>", 
       7->"\<\"PlotRangeClipping\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PlotRegion", "ObjectName",
 CellID->27443],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PlotRegion",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PlotRegion"]], "InlineFormula"],
     "\[LineSeparator]is an option for graphics functions that specifies what \
region of the final display area a plot should fill. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19448]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PlotRegion", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["sx", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["sx", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["sy", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["sy", "TI"], 
        StyleBox["max", "TI"]]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies the region in scaled coordinates that the plot should fill in \
the final display area. "
}], "Notes",
 CellID->26392],

Cell["The scaled coordinates run from 0 to 1 in each direction. ", "Notes",
 CellID->13531],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"PlotRegion", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies that the plot should fill the whole display area. "
}], "Notes",
 CellID->10204],

Cell[TextData[{
 "When the plot does not fill the whole display area, the remainder of the \
area is rendered according to the setting for the option ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19695]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->398196156],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->5226283],

Cell["The contents of a graphic use the whole region:", "ExampleText",
 CellID->1713052246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "False"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->901872819],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
  Background->RGBColor[0.87, 0.94, 1],
  Frame->True,
  FrameTicks->False]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->308536883]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->961237306],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Background->RGBColor[0.87, 0.94, 1]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->129517761,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->233725037],

Cell["\<\
Limit the contents of the graphic to the middle half of the region in each \
direction:\
\>", "ExampleText",
 CellID->2103326840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "False"}], ",", 
   RowBox[{"PlotRegion", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.25", ",", "0.75"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.25", ",", "0.75"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1489181399],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
  Background->RGBColor[0.87, 0.94, 1],
  Frame->True,
  FrameTicks->False,
  PlotRegion->{{0.25, 0.75}, {0.25, 0.75}}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->94079064]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"PlotRegion", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.25", ",", "0.75"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.25", ",", "0.75"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->208694192],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Background->RGBColor[0.87, 0.94, 1],
  PlotRegion->{{0.25, 0.75}, {0.25, 0.75}}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->212211298,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->384683769],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImagePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImagePadding"]], "InlineFormula"],
 " can also be used to add padding around a graphic:"
}], "ExampleText",
 CellID->1454328113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "False"}], ",", 
   RowBox[{"ImagePadding", "\[Rule]", "30"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->885886613],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
  Background->RGBColor[0.87, 0.94, 1],
  Frame->True,
  FrameTicks->False,
  ImagePadding->30]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->100250854]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"ImagePadding", "\[Rule]", "30"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->181202964],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Background->RGBColor[0.87, 0.94, 1],
  ImagePadding->30]], "Output",
 ImageSize->{154, 158},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->508592463,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVe2dYVFm6LsfumTPnTLpz55w5M/eZ0JPOxKVgbrXbtrvtZG8wZ7GVjYii
ICBZiZKRKFmS5JxzzlBgEYqcM0UuoKgqar/Pvbs22GOXdI/971yfYllrr2+v
9b7rC2utvb+irhnf1L5zzVhX69pbHxteM7ipq2X01kf6huylN/5FRUXFn/0L
+7kK+/3/st+4P/++ebAN/1+VF9hym7a29kGudpYt32BrKm+wX7S5fyoHuJbT
m3Jvbv6/cfXkZu27iprixo3bVN7mWjU2e/ueovbmRuuGwH6undq8+/tf035s
s/2Hitp3vmzfHGMfJ/PJ5hg//gaZjzb7+d8voVR83aZU381Jf7DZ43/+E+ld
nPSRzb5//lrShzel/49S6xtK9Z2c9KFNJL98LekDm33/Rqn1TaW6Gie9f1P6
t0qt31Gqq3LSezaR/P61pHdt9v3fSq3fVarv4KRVN/v+s1LrvyrVt3PS2zf7
/ttrSf99U5ootX5Pqc61q/xlE8mO15L+02bfO5Va/02p/ndO+o+b0ruVWv9d
qf63L6Vf9qddr3/XV/zoV4orPz5F6MuEvkHoO4Q2IrQ5oW0I7UBoZ0K7E9qL
0D6E9uXKx4R+RUvfV6r/9R9jveJvv1Bc/YkGoU+/GFKf0CaEtiK0HTfeY24Y
f0IHEzqM0JGEfkboWHbUbXFs8UYMoSMIvZX/fBsU/6W4+osNFJcIrUXo2xxx
Cw6FE6E9OBSBhA7lxosmdDyhk7fTaYTOIHQWoXO20zmqijKb0Knb6X+K5i+v
aG0rDlz8+TVFaHVCnyW0JjdBdwl9n5sge0K7EtqT0E+42fkHLkKnEzp7O52n
Shfsoot30mVqdPlOukKNrtilKEt30PnbaXaYHymNx3mUyh+UrirHA0XkfIMF
pfJrdrquvKS0h4R+RGg3QntzGgvl1MXqKkmVTttJZ6nReWp0ETs8C2IPXb2X
rttP179NNxygGw/SvAM0j6uy4+Sr0j98LWTK0URx1zYFst9u6PJLcKaEfsBZ
sBunyAAOXBSh47jZymA1t4su2EOX7Kcr9tPVB+i6d+jGw3TzezT/CN36Pt32
AS04Sgs+pNs/UOBrOUzX7aVVlDH+aUuMyt7x7y8w/oHFeJLQZzjD1+Z8zeQF
TFfFHGoHkBtPVXWiVG/Gqd1MVtPNUNPN2aNbuF+39IBu5aGbtYdvNhzRafpQ
m/8R3fYJ3fEZ3XWM7v6c7qXoPnW6X12BtPdzuutTuuX9V+bzv7fEqhwTv/dC
0388wRnghm/oEdpYYYA37MlNF3LLk+j5kzuhRD9SVT92l0HynnsZ+wxz9xkW
HjAsffde5ZF7tR/ea/zY4Pmn+q3H7grU9bqO3+49eav/tM7gGe3hc/TIeXr0
vALrKPv9LD1wku6haJUfvBZe5Tj73Rd4f3ecm1gW7zWirUt07pFb5kTPlug7
EYPHxNCPGAcTk8jtprFqZkm7zdP3meccsCh8x7L0iEXlhxa1H1vwjpnz1c3b
Tph1nDLpPnO/77zR4EXD4csGo1fujGvenvxCd/raDXbYbdNfsDFoUpMeu0QP
nHkV9R+3RK0c7xX+9aYC9Z/ZWT5PtK8SXR2id5fom5B7D4mxIzF132Huo2oR
qGYVpvYweqd1wl6b1AO2We/a5h+xK/3QvvJj+9pjdo3qds9P2Ladse04Z9Nz
0br/8oOhq1aj1ywmtMymtO8LbxjN6hjM3bzLDrugq7Ogqz1/k57VpoVa9Mgl
Wjk6bY1beQ1548Vs/5UiN84Q3SvkDk0M9IiRETGxJOZ2xMqVWHup2vrvtA/d
4xC11zF+n3PKQefMwy55H7gWf+xaccytRt2t4YRr8xnX1vOuHZdcejSd+79w
GtJ6NKrtMHnTfvqWzczth3N3LBf1zZcMTNiRl+/dXbl3e+XezWV9eukOPadL
j19/BT2HW0V55/GDr651L7D/nSI3NYjeOWJwlRjdJGYGxMqUPLQmto7EwYM4
+aq6BO1yC9/jEfP246RDXunveeV86F34qXcZ5VN9wrf+tE/TOZ+WSz4CTe/u
a979tNeQjueo7uNJPXfhXbdZA5cFQ8clY4fl+7arpg/ZocVmJhJzQ6m5vtj0
ltjkxup9ekGfntR5hcHvt2TA+fCujToLnfvcoMgtiuifIEYXiakWsdIjNsbE
wZI42RFX1+0e3js8/Xd7h+7ziTroF3/4Ser7AVkfBeR/FliiHlR5KqjuXDDv
YhD/SlD7taAuOqhPJ3DwVsDoHf8J/SfThn5zxj4LJl5LZo9XLNzFVi6SB07s
0GvW1lIby3UbU7nNPelDPekD3TULesmYHtamX7GPrVn86EX8U6WIDkVuU8RA
g5icIZaaxEaHOBgQF9Md7g9VPR+pebvv9PPd5R+0PzD8UFDMkZCko08zPgnL
/Ty88Hh42emI6vMRDVcim7+IbNWK6NCJ6L0VMXgnYsQgbNzw6fT90FmzkAWL
4CWrwOWHT1ZtfCV23jKHxyyKdUcnmaO93Mla7mghdzSWP7ors9OVWGsvmdFc
ZGZFtrYfbq3cxU06C1tPnRieIGaniPUF4nCdON8i7kbEy2KHr62av/PuIM+9
If77wkIPhUe9Fxl/NCrl0+gs9Zj8kzElZ2MrL8bVacbxrsfzteMEunHdenH9
+nHDRrFj92OmzKJnLJ/NP4gS2USu2IWvOjxdcwyWOgfKXfxZHHJ3T8bDjXns
zHjYyT0eMO6mcDNYd9KV2t+YN9vYhb18EvsndrT7hfmwCjA+TixPEtuzxOky
cdcmXneInwkJeLAjxEHtqdvuCJ/9UUGHosPei40+Gpf4WUKaRmLOqaTCc8ll
l5Krr6Y0aKU266S23k7tvJvaey9l8H7KqFnKhGWy8EHSnE3ion38yqO4VafY
NddoqXvU+uNwxvOpgoy3P+Pjy/h6ws+N8X3E+NrAxxye9+TutySP6Dc2uSjv
PH739Xz2UESb8wUjijw4TuxPE5cLxPMq8b1JAgxIiBkJt1GLctoT7fF2rN87
CSFHkiI+So49lpqskZZxOj3vQmbxlcyKa1m12lmNN7P5etntBtndRtn9JtnD
FlnjD7KmbDJn7TMWHqWLnNPEbqlrHslrnolS73i5byyeRLNQmIAwJjCYCQpA
kA+CPBDkjCA7+FvA757c8+aqI7sjZKWU19cNPr/bis9eTj+6HB8rijieJG7n
iPdl4n+dhNzeHma0I8pCLcZud7zL24me76b4v5/29OOMZ8ey4o9np57Jzb6Q
V6CZX3q9oOpGQd2twqa7ha33ijruF/aYFQ5YFo5YF07YFQgf5c855y255q54
5Kx5ZUt8MqV+6TL/VHlgMoITWTQIjUZYJMLDEB6EcD+EeyHcFU/tEWKBAIN1
rxvK69g3sNnHmdo9jsojinicJL7nSeAV8lR7R+SdnTH3d8U/2JPssC/N7VCG
95GswI9ywo7lRR8vSDxTmHahKEezpFCrtOxGafWtsoa7Zc8Ny9tMyjstyvse
lA/ZlI/Zl005lc24li64l4g8i8U+RdInhdKAfFlQnjwkR/40C+EZCjZRSXgW
j+hoxEQgJhQxAYjxxjNXRNkj3AJBd5bd6VdW5t9+IyPWcyw4Ou4U8TtJgi+Q
8C9ItM6OeH21JNPdadb7Mh0P5ri/l+d7tCDoWFHE8ZLYM2VJF8szNCtytSqL
daorblfX6Nc0GtXwTWsFlrXdD2v77WqHH9WMO9dMu9XMPa5e9K5a9qtc86+Q
BZXLQkrXw4rlEUVMVAGi8xCTrSAVn4qEJCTGITEKSWFIDEKCD+LdEGuPSBN5
kM5rMuLWxv2cxd2niP0GI4qEnCYRl0jMdZKouz31nlqm2d4cm4P5Tu8VPT5a
4vdZWYhGReSZqriL1SmatZladfk69SV6DZUGjXXGjU1mvBYrXodNU49904Aj
b8SVN+HBm/Hizfs2Lvk3rAbWS0Lq1sNq1yOq16Mq5dHlTGwZ4ouRWKgglZKN
1AykpSAtAenRSA9HWhBSfZDkingbRN77FpzeZiM1Rawp4rZBiCJRp0jcJZJ0
naTfVs023JtncaDQ9nCJy4flnp9V+mtUh56ue3axIV6zMVWLl6XTVKDXXGrA
rzLm15u1NFu1tNq0dDq09jq1Drq2jj5umfRumfFrWQjgi4Kfi582SyOa5FE8
eUyjPK5enlDLJFUjpRKpZQpOGYXIykN2FrLTkJOEnBhkhyMrCBk+SHVCgpX0
6Y1XdrPfzMuUDQoU8aFIMEUiKRJ/kqRc3JGppZart6vQ6O0Sy3fL7T+scv20
1lu9PuBU49MLTc80nydo8dN0WrL1WgsN2suMBdXmggarjmabjjaHzi7nzj63
ziHPzjGfzqknHbNBHYshguWw9rXINll0qzy2RZ7AZ5KamRQek96IjHpk1Sh4
5ZYjrxj5BSjIQWEGCpJREIv8COQFIssTaQ7yGIOv4aX8HOmHm7xYZT2mSBBH
Ko4iqad2ZF3amUfvKbqzr+z+oSqrI7UOH9e7UTzvU82B5/lhV1qjr7cn6gjS
b3fmGHQVGneXm/fUPOhttO197tDb7tzX7d7X79U37Ns37t83Hdw797R3MaJn
Jap7LaZ7Pb5LntTBpAiYtDYmoxXZfOQ0I69RwauoBsWVKC5FSSFKc1GagdJk
lMSiKBwF/shxQ4rFa/Li9HWA2zQ4UeQJRcJYXuok5TjJOr09//LOEu29FXff
rjE5XP/gKM/hWLPbiRafc22BlwXh1zpjbnQn3e7NMOjLNe4vMhuoeDBYazvU
+GiI7zIkcB/u9hru9xseCRieCB4Whg3NRw4tRQ+uxg1IEgbkyf1MWi+T0cNk
dTG5ncgXoLANRXwFtbJGlNehohqV5agsRmUeKjNRmYzyGJSGosgHWXbfjpkZ
pzHWt6I3aJ0k+We2l15Rq7yxr/buO40mHzY//LTlkUab+5kO30tdQV/0hGv3
xd4aSNYfzDAeyjUbKbYarbAdq300xnMZ57uPC7zGe/wmBgImRkImJsLGhZHj
8zHjorix1cRRacqIPH2EyRpicgaZvH6msA/FPSjtQplAwayKj+om1DSgtgZ1
FagrRm0eajNRk4iqKJQFosBVOXa89fXMDnK26McZYiJFMo+T/FOk9OyOKs09
dTcO8vSPPDf9pO2heofjqS6PC71+V/uD6cEI3eHYuyPJRmMZpuN5VhPFNpMV
DlO1LtM89+kWL6HAT9gTKBwIEY6ECyeihMIY4Xz8tChpejV1SpoxKc+eYHLH
mYJRpmiEKRlC+SAq+lDVo2BWJ0B9Kxqa0dgIXi14FeAVozEPDWmoi0d1GEq9
xanGr1jkN7Nz5NyM9bE0iuRpkJJTOyrP76rX3N+kc5ivf7Td7PMu65O9juf6
Pa4M+mmNBN8ci7gzHms4mWw6lWkpzLOeKXaYrXSeq3Of53nNt/jNdwQu9IQu
DIYvjEYtTMYuzCTMLyTPi9LmxJmz0pxZef4MUzjNFE8xZRNMxTiqRlEzjLpB
BbvGHjR1orkNz/l4zgO/FvwKPC9Gcw6aUlD/DFX+0mzLb8nOnfO0ZIpkU6T4
uGrlmd11F/Y1XT3YqvO+wODTbjONPuszg46Xhj2+GPO7MRF8eyrCQBh7fybZ
Yi7Tej7PfqHYabHSfanOS9TkJ2oJEHWELPeELw9GLY/GLk8mLM+kiBbSRaIs
kThnSZq/KC9aYErnmfJZpmoGNULUTaJhHLxRBbvnA+D3orULbQK08dHGQ3st
2srRWoCWTDTFoy50vcD+27Bjz9uerLdRJJ0i+dT2cnXV2tN7eBcOtFw93KFz
tEf/837Tk0PWF0YdNSc86Cm/W8Jg/bkI4/lY88Xkh0uZdqI8p+Vit5VKz9U6
XzEvQNwSIu4IX+uJWhuMXRtNWJtMWZtJFy9kiUW5YnHBqrR4RV62zFSImOol
pnYB9fOKQ7TKD9E6gvZBCPrQ0Y1OATr56OShsxodpWjPQ0syeBFMmevX8Hpr
q+j/J249i6dIFrW9hNpRTanyTu5uOX+g4+r7PTqfDuhrDJueHbO+POV4Xehx
c9b3zkKw4VKEqSjWaiXZdjXTcS3Pda34saTCR1oXIOOFyFrCZB1Rsp7Y9YGE
9dGU9cl02UyWbD5XJiqQioul0jLJeuWavFrMwVD5CZ4vomUebbMQCBVq6xxD
9zC6+9HTjV4BevnoaUB3JbqK0J6B59ELeQ+/Dbc/cLGfNcc8ansFtaOeUuOf
2Cs4/07P1aMDOp+P6J8aN70w/fDqrKP2vPvtRV8DUbDJaoSlONZakuwgzXBZ
z/OQF/vIK/yZ2mCGF4aWKAhi0JOAgRSMpGMiCzN5mC+EqIQRlzMco58yjVKm
WQK+GK0raBehYxFdc+ieUbDrG0f/MPr7MdCNgXb0N6O/Dr2l6MpBS9wru8Zv
4PVbigSwqzRFiihSTe1oUt/ZpvF297n3+q9+MqKjMXH37LTJ5dmH1xce3RS5
313xMRIHmUvCH8pi7OVJTkyGO5PrzRQ/YSqCmNqnDC8S/BgIEtCdjIF0jGRh
IhfCwo1BVX4mrcV6PSPnMcxzBi1ytMkgkKBTjO4V9C4pIA3MKrgNjWN4GMN9
GO7EcCuGGtFfid4CtCcoP6H4zZa8uJP+LznvKqVIHbWjRX1vh8ahvtMfDF8+
NqF9cvruhbn7VxcfaC873Ba73ZP4mMiCrOThtvIYR3miK5PuyeT6MUWBTHko
UxPBNEaDH4/2ZHSngfOcX8yVY6kKK7WQNGCdB/lzhmll0M6gQ46udfTK0LeG
gVUMijC8gBGO09g4xoYw1osxAUabMVSD/iJ0JL/yzOUbGP2CXcMoUkGRRkqt
XX1/z/HDgyc/Gr+kPk2fmbtzecn4+orVTbHDXambsczbfD3goTzMQR7twiR6
MGk+TE4AUxjClIUzNc+YxrhNjfyqPxfDBRgvwXQ55qqwWIuVBqw1QfYc8laG
ETDoZNDNoFeO/nUMyjAsxagYY8sYX8AER2xyFJMDmOjCeAtG6zFYIu9M+Tas
fqaIFqSS2tFM7epQf7tf473RU59OXTw+e/3c4m3NFWPtNcvbUrt7MhfTdS8r
ub+t/Kkj88yNSfBi0p4w2UFMYdjGU5O3mlPRlqGw/74CDBVjrAxTVZitxWID
lpsg5kPaCrkA6GLQw6CPwYAcQ3KMrGNMhgkpJsWYWsb0goKUcALCEUz3YrId
4zwMlUo7ErfmpPzulXsr/VOKZFCkitrBp/Z0UQeGTrw/fuYz4YVTC9cuLt+6
tmaoIzW/I7M1Wnc2l3taM08cmFAXJuox4n039fL70mhUJaA+BU3paM1GRz56
izBYhtFKTNZgph7zTRDxsdoKiQDrXUAP0A8MMhhmMMpgXI6JdUzJMC3BjBgz
IszOK3jNjmFmAMIOTDZhpHy5LeZrNLUlqx9z2yg2RrRQu3uogyPqH06douYu
nBF9cXn1ptaaga7UzGDd2kTuZMU8tt14VKvyx+RgZIYh7xmK41CZhLo08LLQ
kgdBEXpKMVCBkRpM1EPIw9xzLLViRYC1Lsh6wCj4AMPAGDDBYJLBtBzCdczK
MCfB/Crml7DAmeDcEGa6MNW8PlL2ynu6rfn8L0XxfYWKVFuonf3UoVHqI+Fx
jcWz51Y0NdduaEvv6q2bGMo3tPEXXxcEPUa4L2ICkRSKjEjksgeJRJSnoiYT
jbngs7GpBN0V6K/GcL3CYqafY7YViwIsd0HcA2k/5CyZkQ0ywBQgBGYZzMkx
v44FKRbXsLSMpXksTnGUutkupMMl34bP9xThbnurgs8749THs+rHRWfOr17+
QsKx+LuVBext4OoIbzcEeCHsCaKDkciezZ8hJx6FyShLR3U2GvLRXKzY3nRW
obcWg42KcDXZgpl2zHdC1IPVfkgGsa7MBZgHFoAlOZbWIZJgeRXLixAJsajY
Ra1PN890Z7wem58oijcpwldQeXeC+mSeY7D9ui5zywCGJrCwgq0dnJ3h6QF/
X4QGICoU8ZFIiUFWIvJTUcIeiHJRV4imUrRUQlCjWPsHWJvnY6IN052K+V3s
w/IgxCOQjkE+CUwDM8Acx2OR5QEssx8GKzKsrGFFhOVZLI2xQKRTPOW3cb/+
Wh6cF6hpnFw5eVFyVkuueQs696BvBtOHsHaAoys8POHrh+AgRIQh9hmS4pGR
jNx0FOWgvAA1JWgsB78a7fXo4qGPj6E2jHVgqhszfZgfgGgYq2OQTEA2DfkM
mDlOCSx+EYd/BVgFxHKIJYx4GStzEI3J5ru5DeCWHH69hedzs69IgaDUeqh3
WH0sUKfExy/JTtPMpdugDXHHHPetYfUIDm5w9Ya3PwJCEBaB6BgkJCItFdmZ
KMhDaRGqylBfiaZatDaioxk9rRgQYKQLE72YHsDcMGssWJ6AeAqSGcjmsL4A
+RIY0ZdMoLKNWYPKvzJrMka8wqzOyUSj4rmOvo08AOX3d1tz+kHfS0+n/0Zt
b6cOjrFGRp0UU5eZUzRzQY+5ZgRdCxjawtwJNh5w9sHjQDx5ipAoRMYhLgkp
6cjMRl4+iotRUY7aajTWg9+Edj662tDXiaEejPZjcgjCUcyPY2kKK0KIZyFZ
gHQRMhHWV8CwjNYUjCRQ+S4jBSNZZ9ZWZKuza0vDUxNNytkEyru6rdn9W99L
OVh/pfYPUUdnqRMsNbkGzZzVYzSNmRuWuGsHE2c8eIxHfnAPgk8YAp8hLB7R
KUjMQFoucgpRWIqySlTVor4Rzc1obUWHAD1dGGB3ZoMYH8EUu5xMYn4aS7NY
mYd4ERIRpCuQrmJ9DXIJtsmlUPnOupSRS9ela8viFeHsXO8r+QjKu/Cteb14
P8LFEFVqZwf1vpDSWFG/JNOg5SfuMOeNcc0Kt+xg6AILT9g+gXMwPCPwJAah
iYhKRVwWUvKRWYy8chRXo6IeNTw0sifWNrR1orMHvf0YHMLIKMYnMD2NmRnM
z2FpEcsirK5gbRWSNUgkkEkhl0HKfqRyiUS2IhbNL00oZzK8HqdtmxGCW1//
zK6pFLVEXZBSWnINPea0Ma5Y4YY99F1h4oWH/ngUAvdI+MQiKAnh6YjORmIB
0kqQXYGCGpQ2oKoZdS3gCcDvQnsfugbRN4LBcYxOYkKI6TnMLCiWzcVliFax
IsaqBKtSbFuTsVoSy5gVqVwkkcwuz/VOdb2S96D87uNVRgoPVLwl+Y8+7ix4
VEidXaOuyajbzCkjXLDENXvccoWhF8z9YRsK5yh4xuFJMkIyEJmD2EIklyKj
Erm1KGpE+XNUt6G+A009aOmHYAjdo+ibwOA0RmYwPo+pRQjZfc0K5sXc6imF
iDW2bSKWy5uLMmZeIpteXRmYG1PWhDKPX33J48usvj9SGkvUFSmlyxw3xGlL
XLYH7Yo7XrjvjwehcIiCaxy8kxGQgae5eFaE+DKkVCGrDnk8FPNR3o6aTjT0
onkArcMQsCfRSfQJMTiL4XmMLWGC3WiuQsjuzCSYVaCeU6BmvwklzLhY0rsw
o7wvU9bGr7Zccbg8qN9T51YpbTllgBPmOGMLTRfoeMHAH6ahsI6CYxzcU+Cb
iaA8hBchuhwJ1UirR1YT8ltQIkBFF2r60DCI5hG0jEMwhS4heufQv4ChJYws
Y2wV42uYYIPWtkkW/Jvs5nlMgmHxeteiSDkCK/vFBm7lkwCH+y3qipi6DcoE
GtY474RrnrjlD8NQmEfBNg7OKXicCb88BBcjohwxNUhqQFozsltRIEBJt+Jh
W80gGkbRNA7+FNpm0MGelhfRK0L/MgZXsW2IDbbfGZZgSIKBNfSuonVh5ZV1
cGvEv33ZPt6itGTs9FJWOOWAix647ofbITCKhGUc7JLhnAnPPDwpRkg5ImoQ
04DEZqS1IluA/G4U96F8CNWjqJsAbwrNM2iZQ/sCOpbQuaw4CveIsa2bXeje
6FxF2zLqZlY29t/fkNG1gVH5verPNqyBllD3oWGDUy646A2tQOiFwzgWlkmw
y4BLLjyL8KQcIdWIqEdMMxJbkSZAVjfy+lA0iNIRVI6jZgr1QjTOoWkB/CW0
iNCyrHgqwZbPl1G/wGQPz27s25TyS15F+YeXZ/I3lCmjbo+THrjwBFqh0HsG
owRYpsEuB86FeFwKvyoE1yO8CdEtiG9HShcyepEziPwRFI2hbBIVQiie2c2h
bgF1i6hfRO0iqhdQLGRU/mOLePsqIuWsVW7efk4ZrVMO0PDEuUBcC8etWBgm
wzwTNvlwLIFHJXxqEdCI0OeIbENsJxJ7kNqPjCFkjyJvHAWTKJpGyQy2lcyy
vRfNIHf6H71/AyYu93cjF03ZQ35OWcooT5wMwpVI3IjH3VSYZONBIexL4VIF
z3r4NSGoBU/bEdmFmF7E9yNpCCkjSBtD+jjSJ5A2gcRRcNnI3/my983YvRHR
//yyfv5zQ4byxelwXI3DzVQYZMO0EA/LYF8F53p48ODDh38bgjoR2o2wXkT0
I7wfYf0I6Npk8zUj/VWJo3L+NWc/3z8fh2upuJ0LwyKYluFBNWzr8KgRjk1w
asajps23G1/Jgt3o/2+bTJT7VVVaszaklTOGlXPH1TZ725B+kZWsLKWcG7yh
TVWlq8r+/NW+1ZRalbM8FUgVdDee6u3cvFdZ6i+bUhvZMMpZyFvlXCnUtJGn
uafvpTx9peeIij438qH3KbUqr7S/3JT+av65stR/bY68h5M6oNSqHI1/utnn
xq8RDiq1KsfFH232/S4nfajvH79oUM6LU/T5ASf17pYW+71NmY85mRdZ/S/n
6mzbHOsYJ3Fks3acq/1P+N3Hty1V/uX/AcCV82w=\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32581],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AspectRatio",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AspectRatio"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageScaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageScaled"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalRegion"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRangePadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRangePadding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRangeClipping",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRangeClipping"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31598]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27294],

Cell[TextData[ButtonBox["Coordinate Systems for Two\[Hyphen]Dimensional \
Graphics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/CoordinateSystemsForTwoDimensionalGraphics"]], "Tutorials",\

 CellID->5450]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with PlotRegion",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=PlotRegion"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PlotRegion - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 10, 22.8855000}", "context" -> "System`", 
    "keywords" -> {
     "margins for plots", "plot volume", "size of plots", "volume bounds", 
      "volume limits"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PlotRegion is an option for graphics functions that specifies what \
region of the final display area a plot should fill. ", 
    "synonyms" -> {"plot region"}, "title" -> "PlotRegion", "type" -> 
    "Symbol", "uri" -> "ref/PlotRegion"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5181, 168, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->398196156]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 61596, 1304}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1994, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2617, 72, 48, 1, 70, "ObjectName",
 CellID->27443],
Cell[2668, 75, 498, 14, 70, "Usage",
 CellID->19448]
}, Open  ]],
Cell[CellGroupData[{
Cell[3203, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3681, 111, 693, 24, 70, "Notes",
 CellID->26392],
Cell[4377, 137, 91, 1, 70, "Notes",
 CellID->13531],
Cell[4471, 140, 360, 12, 70, "Notes",
 CellID->10204],
Cell[4834, 154, 310, 9, 70, "Notes",
 CellID->19695]
}, Closed]],
Cell[CellGroupData[{
Cell[5181, 168, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->398196156],
Cell[CellGroupData[{
Cell[5566, 182, 146, 5, 70, "ExampleSection",
 CellID->5226283],
Cell[5715, 189, 91, 1, 70, "ExampleText",
 CellID->1713052246],
Cell[CellGroupData[{
Cell[5831, 194, 355, 10, 28, "Input",
 CellID->901872819],
Cell[6189, 206, 342, 11, 171, "Output",
 CellID->308536883]
}, Open  ]],
Cell[CellGroupData[{
Cell[6568, 222, 205, 6, 70, "Input",
 CellID->961237306],
Cell[6776, 230, 27751, 460, 184, 101, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->129517761]
}, Open  ]],
Cell[34542, 693, 125, 3, 70, "ExampleDelimiter",
 CellID->233725037],
Cell[34670, 698, 139, 4, 70, "ExampleText",
 CellID->2103326840],
Cell[CellGroupData[{
Cell[34834, 706, 578, 17, 70, "Input",
 CellID->1489181399],
Cell[35415, 725, 385, 12, 171, "Output",
 CellID->94079064]
}, Open  ]],
Cell[CellGroupData[{
Cell[35837, 742, 427, 13, 70, "Input",
 CellID->208694192],
Cell[36267, 757, 7994, 136, 184, 145, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->212211298]
}, Open  ]],
Cell[44276, 896, 125, 3, 70, "ExampleDelimiter",
 CellID->384683769],
Cell[44404, 901, 236, 7, 70, "ExampleText",
 CellID->1454328113],
Cell[CellGroupData[{
Cell[44665, 912, 407, 11, 70, "Input",
 CellID->885886613],
Cell[45075, 925, 362, 12, 171, "Output",
 CellID->100250854]
}, Open  ]],
Cell[CellGroupData[{
Cell[45474, 942, 257, 7, 70, "Input",
 CellID->181202964],
Cell[45734, 951, 11264, 190, 179, 121, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->508592463]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57059, 1148, 311, 9, 70, "SeeAlsoSection",
 CellID->32581],
Cell[57373, 1159, 1734, 62, 70, "SeeAlso",
 CellID->31598]
}, Open  ]],
Cell[CellGroupData[{
Cell[59144, 1226, 314, 9, 70, "TutorialsSection",
 CellID->27294],
Cell[59461, 1237, 214, 6, 70, "Tutorials",
 CellID->5450]
}, Open  ]],
Cell[CellGroupData[{
Cell[59712, 1248, 305, 8, 70, "RelatedLinksSection"],
Cell[60020, 1258, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[60400, 1273, 27, 0, 70, "History"],
Cell[60430, 1275, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

