(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    114674,       2380]
NotebookOptionsPosition[    109760,       2220]
NotebookOutlinePosition[    111205,       2259]
CellTagsIndexPosition[    111118,       2254]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Graphics Directives and Options" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsDirectivesAndOptions"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Graphics Directives and Options\"\>", 
       3->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PlotMarkers" :> 
          Documentation`HelpLookup["paclet:ref/PlotMarkers"], "FillingStyle" :> 
          Documentation`HelpLookup["paclet:ref/FillingStyle"], "MeshStyle" :> 
          Documentation`HelpLookup["paclet:ref/MeshStyle"], "BoundaryStyle" :> 
          Documentation`HelpLookup["paclet:ref/BoundaryStyle"], 
          "ColorFunction" :> 
          Documentation`HelpLookup["paclet:ref/ColorFunction"], "Joined" :> 
          Documentation`HelpLookup["paclet:ref/Joined"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PlotMarkers\"\>", 2->"\<\"FillingStyle\"\>", 
       3->"\<\"MeshStyle\"\>", 4->"\<\"BoundaryStyle\"\>", 
       5->"\<\"ColorFunction\"\>", 6->"\<\"Joined\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Data Visualization\"\>", 
       2->"\<\"Function Visualization\"\>", 
       3->"\<\"Graphics Options & Styling\"\>", 
       4->"\<\"Plotting Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PlotStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PlotStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
     "\[LineSeparator]is an option for plotting and related functions that \
specifies styles in which objects are to be drawn. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10468]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PlotStyle", "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 " specifies that a graphics directive ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " should be used to draw all the main objects in a plot."
}], "Notes",
 CellID->2425],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PlotStyle", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that successive directives ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " should be used cyclically for successive objects."
}], "Notes",
 CellID->6204],

Cell["The directives that can be given include:", "Notes",
 CellID->31844],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Dashing",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dashing"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["w", "TI"], "1"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[
    "dashing specification ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Directive",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Directive"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "composite graphics directive", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["EdgeForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EdgeForm"], "[", 
     StyleBox["g", "TI"], "]"}], Cell[
    "edge-drawing specification ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["FaceForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FaceForm"], "[", 
     StyleBox["g", "TI"], "]"}], Cell[
    "face-drawing specification ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Glow",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Glow"], "[", 
     StyleBox["c", "TI"], "]"}], Cell["glow color", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", 
     StyleBox["i", "TI"], "]"}], Cell["intensity", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Hue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hue"], "[", 
     StyleBox["h", "TI"], "]"}], Cell["hue ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Opacity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Opacity"], "[", 
     StyleBox["a", "TI"], "]"}], Cell["opacity ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["PointSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PointSize"], "[", 
     StyleBox["d", "TI"], "]"}], Cell["point size ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Red",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Red"], Cell[",", "TableText"], " ", 
     ButtonBox["Blue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Blue"], Cell[", etc.", "TableText"]}], Cell[
    "named colors", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["RGBColor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RGBColor"], "[", 
     RowBox[{
      StyleBox["r", "TI"], ",", 
      StyleBox["g", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell["RGB color ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Specularity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Specularity"], "[", 
     StyleBox["s", "TI"], "]"}], Cell["surface specularity", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Thickness",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Thickness"], "[", 
     StyleBox["w", "TI"], "]"}], Cell["line thickness ", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True}}}},
 CellID->30921],

Cell[TextData[{
 "For individual ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", a list of directives is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Directive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directive"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 ". For a single ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ", a list of directives must be given as ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["list", "TI"], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26962],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can apply to points, lines and surfaces. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->31911],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PlotStyle", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " specifies that the main objects in a plot should not be drawn explicitly, \
though mesh and filling are not affected."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->19169],

Cell[TextData[{
 "If an explicit setting is given for ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ContourShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourShading"]], "InlineFormula"],
 ", it is used in preference to the setting for ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->23922]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->367972868],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->184632603],

Cell["\<\
Plot and related function will automatically style multiple curves: \
\>", "ExampleText",
 CellID->592170946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "@", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "3"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24799594],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169394343]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157799115],

Cell["Explictly style different curves: ", "ExampleText",
 CellID->42124364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "@", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "3"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "15"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", "Dashed", ",", "Thick"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->370380378],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110256197]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2137756568],

Cell["Add specularity to a surface: ", "ExampleText",
 CellID->960744390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "40"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "25"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329333774],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->334153372]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1150743658],

Cell["Use tranparency to show hidden features:", "ExampleText",
 CellID->310935124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1.16", "^", "v"}], " ", 
      RowBox[{"Cos", "[", "v", "]"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Cos", "[", "u", "]"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"1.16", "^", "v"}]}], " ", 
      RowBox[{"Sin", "[", "v", "]"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Cos", "[", "u", "]"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"1.16", "^", "v"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", "u", "]"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "15"}], ",", "6"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0.6", "]"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "25"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1058915917],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{173, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9594269]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134181233],

Cell["Use tranparency to show overlapping regions:", "ExampleText",
 CellID->59893911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", " ", "t", " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{"r", " ", "t", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"6", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "2"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Blue"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1184922654],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVm1toXeeVx3fOObrZlmVZtmzp6EiyZFny/e44bqVzMq4nk2Y6aTqT3pIw
ddLO2DOTpE3dUDKlpC/Tl/Zl5iUGM05Ra/BMHlxcPARcMGMIFYQITA1mxmAq
ENVDisFFDwKD5re+y/72XntvHTspncYkW/q0917/dV/ru+zPnTxz6hsvnzxz
+qWTw0+8dvKbp06/9O3hP3/1Nf5UfiSKol/w/082R/y+zG/m/18sL/Mzee3j
WuZWVDFD96/L/bXEzxI/u9242417EuPkc1251HrMoF+ucnPZ/IvKatwpl0oY
W6rJJ7qbvrFRPdHVlGZnE67WmdfWc614sVZ4utU9V26K2+6ebPl/k+mTbI/+
NJ1l633rmlLvKnyyx91Z/2AcZrATPt6SvBe5KGnO18p66snTfXM+M7xsWPZR
X3L+LD/Xup/lhDReTyVnx+TYP9el6BjtRdksk7wKB29HMS+O48hHTUKCUq4E
ldy/fpx3//AUP4nvPhjFRzKWW86JUu2t+nl9/2HH4v35nEzJpeN3v1uc/WD+
P//jxvl/f/87Z668+srll158pz55Vt7okJ/l06cu8VfuRSWeicozv5r73//5
UF7+TIq2ePUx+fPa3/723i+v3v63f32P904cP/fM09NP/9Xl57763tf+9v1X
Xp775qvzZ7794ZtvitI65Ef5tW8t8EduRSUeidqe+fyVpz4rTLzw3MUf/su1
n1+6CWBUdxhZSQ57Sf7ryq0fvHkVvCdOXHj2b65+/aUb0P3+9+9H7QaHN/gp
v3bJpf311++e+vtbX/nyddCeevL8P7/xLnoA6tOFOjsgl7bf/OYumoA5kL70
xWv/cPr2G28sRp0Ko0cubd/73tI//eMdhAfjS89e+PGPrqPu6LFChL1yaUWW
n/10FoQnn7iISmC0W1HfJJfW73733t994ybahRNIw/uRQsq7jdde/+87VkUv
PD8D2WiDottv6CIPdGEZFlD/73+/dDBj652G3tLSfR5Asr/+wrsowvKVoFeT
SwtIqBlUzIn2on2FtpwwVAFEwzzPW8gY9SmqQ4YqlsV+qAjLiYfsjXlsW87r
rloV1rYEFhKgaKwVVRXWiFwqGBF1WKDdMU57k+jW4zG5VFAYerVwNYW2NYGG
sgilnTGaJWf/+drSDF2Gowb15q8XCG0UinGHFOo2g4oy4evsWzMYddxr8KFl
3GLQ0CoJ4HN/eYlY36LQxg0a1nvx5Cx6xyUn0hrN9AzacsNmTCaCX6I8GlUI
2w0CguKVZC7CaVsaIZO92xTCoOEDRSAF+QhSWxXGTjMma8EDicfYNnhfstbr
zrVmxsQB9hDutynKuwz3OAfJBY9DlaOZ6LM0wMVPJI7HFY09ZowfgYHljVXy
I67fS0oCARCzTChae82YOMScZEhDKz/H9JkxDKN0Eki0Q1Hab8ZkQ3IQiNFQ
IaXNZoz7U35I4k7bgdIBMybjcB/zGnulNWQpEK5UIdHQLkXhoBnjnlAAJxoo
1FCvp0SilWy0W1E65PWDriUPDRRKZbt87IEmJdfsUZQOmzF34BnvjqqFlDYk
eBJKexWlI54SESCU+jP60RT2KQqPmjHu4ChsLtTPem8rfFEo7VeUjuZQypeq
2/sPmhRNH1CUHkvoRzS9qZCSmbeU8TGsi42dtQOlY54SSGL93iaUyMWkx+B5
4pNRJBWvRXqWim1sbLtxMOEPyGKsnta9pUksEQrysPGoDvgkaIhBLPJ4/RwN
UH3qMk/Xp65GLY36+zRkU1f4E//Z23gRT5NC6KCcB8ABsSex1VNor7XeC8GR
7shEaQe6QELaphPHp+tT79Snrjfqtxr1+UbjflRqNCwFfsqvHXJpb9QXeKQ+
9V596hLckCZhBbFtpCEKGWXZ9aTpuuxXQXRe71T2N3m8FS1D+/jj5+tT1xr1
243GYpviZ61cWhv1OZih98MP4YScvcPnG1TtPTW3zkTZWWHuLL9MPiapxjWz
BRDsb1R2FfxoteKsWy4Y70M44ynUK7aa8BGBBSQ7B75ya3xTPmW4xgzoLSjx
Qn7M8IcWcRF0gv+guKhT8bdBLhW0ig1xJ2QbV94br1R9BJ2tNmPyMwyIp5ka
2oKnYZL65EVxMLyrS/HU63haqE+9iylx6W2+mqF+H5Mf1Y6WJ4KEkBWyo773
MUq6AUPdip/Njh9seBlHpJgY3ZZRLAVYyHV9DH5WmTFNENkx9Jv4FVDi8I2l
HsVPvxnjbSiHFspqNZHLAje+E/GrEDreOnyWpA2TOcyIr6o01eLNGxVy1Wqi
cb8+NYO3oIlRn3XIyD63pHOdlY8WmziRh4d994efStA0lnoVSs3Jt2Dj2HV3
QdtrCjNbu/K3Ya8ZdNmo37SWTCANBnneIzR5xfaq6AJdSl/RuVxUFywW7SEs
xnMSiRu4Jm1GfQpr2El129X+LSpLrilEsr0p9Y43Raoh37mQPRqNe84fAtIW
h/QhnEgWtUgM3Lx9dcZG7Sq3DXoEPF4QqgphxCI07tkG3+k5xOeqQgu1Kgul
kZaiAYU06pAWkTUgESoEjEfK11qrsk/N28dpraaQtjqkJYcUaxlPWBmpxUcR
JUpkqvnsjnawgvWyBNKYl4n7Yp8hJVNHE6SQ42v+zUb9TuzPCaRt3k6uMxtU
MqWRQobgtlujGTBvoEIiRIgNKYRxH6uulxhUsvgMlJWl4r0a3gKS8YRLUhWG
FdKEQ7pFIgiyB59rL9RaRXlCVdlni0LabsbkXtfx1VT8tBUilVU+tTKRo8mX
ITI1EtK6WVzNaxtms0h+TmlmvmS0IAteJOUUrY0ohB0+F7jcMeBlf+rJ89Il
thbap5yrteBrGmmnQ/J5fkBl7dZYFsk/5ZxqZBFRHeLIy2YtSlYHjUf4XJBB
lOxtstCAqkUBcW0uUhjbGs2MnLqXJ6tG3uW9Hq0GWUlplF8fpxbZ73Pl7Yf5
Tjg5E+gPUfBOyEoBebfyTcvpC8/P/Oyns0m6DypzyPn9efZtaTTuSuGUScjl
+uQ5oCfPRi38ZuYh10wHdzdkNJfVq95yzL7S+vC1W9vecoNTkqbk5T5fh+uT
F+Js0M5vcIO5jx29eGD/dV6fGJ/fsuV+eXiYu/zCcNfOWwcPXOMB02DSzy2O
Op2lPTlYq5LiLpNvW+Mx/3iFF6sqrodch3gDbuFrfNtCSTgSSvw0zMmlZWzs
7v59dL4XTDZd9JVa6S1YM3DWuZxYS0px9Murt2ld7JsmoS3EPRSdzV2UBeTo
6GJFcbRKLhV0tmf3DaOq2S1OT1dpAINHhHgK3PhsVFI5oi9kowvJTu720Ucv
oZSoVfGwxvAwMrK0b++MaQAWhxK9S+Ah5Cvfybp8ldIEbMJsv6pYA75uHDp4
FaSoTfGw1oxxHIk4qsGQ04KvgJYe5W32g3kfR48UcPDM09O4rI6kqucAv4x9
IcFBlxljIslzdN2DqtJZeqRVmugcDsJaJtM1WhDnRfxGM5OcL8wfOXwFe0cd
Cn+dGXPn8KF3Bb/m86rrZ7QflDN+YP5kS3kmg/X7vorx1q33rN8l0LvNGMuI
A6D/mvLCPu8BJ46f85milCe9nUI5fPpqWcGI8Rns3nUz9vsE/nozhjPX63p/
kagK2g/Vv1SkfduWuedJ5yb5LLt5AJI9dvQdgVqt8HvMmOhwVa6aq30oQ39F
/LNvzchs0D5vJjxzAZ9cTWLMw99gxgQgGSDgowwMHvQfepJCfLtE5vBlAknp
aLjZs8gz+anz4n1rcvG5Y3LGYhwtvo/oU7WklO99KXTqk5SKgF6/g2/HGSeB
vtGMJQXabBHHCgEfo8taPPnHipnrezb1BF81DATdz+zdM1uMHmT3sXL/8fq5
2PcqJ45PM2GyQLmaT6GH7OvRr2yfmMtD782VPWQ+Kzs15eavFz46uiT+YnQj
+3mp8P15cV8hCClwGj22+srYkxcI6zzsTWZs0t2dZIzOUnqDz4U63NzmDy63
xSYYzeJOwPbrP1buON7yO4ACLky/NP0gtt8UZ70k14Ss64D7/KoYcZXkwnRI
qfUtdRpCxeHZRmINbYVI2GzGn3oMZu4ls4YUtMDPKy/PfefMleb8vP1gvNrG
pThjwQ5VOfD66BF63uvcr8+bjEp9NrqXS5koxVNld79PLuU4ZKMH1Jzs+D8/
U5i/vebi/C0Nw+R0nOF8t9Cn6tVAE10lOGCmBhHHAby4itCn9GE4qFjbWYtt
yuUh9EyBhwIv5jmedsgkALMwGLKxz95x7TZp41yB7Hm4qayBabCWQwuR6yvP
TdenxX3Szh3CUFO06nJxb0pCpyz0+5mH83KPOEtnJpqNO0P6ZakHDydfGtGu
4cTdA2LF3TAzlTkmSNR8EoCZF1RA37f3/Ujmmff6clGJDybIzVB/8Kbkb4tK
tJKAkrORJUTFY/ivRCxFFZj49LFp2dqK4vwvTUxADbO0rC3t7MOGTapTdBVl
2KHek10s2ci6q/exfFZK95o0mkw1mlnUtpu216ZKmY0pv7aXRfA1dbPqZmsr
6NK281XffZv+NIuwSfUMVobXX7/7wnMXcxAyc24e4+FUp0uzmrf24KM8VanK
cU5uihT2UHWPno/ETR7J60HTSOEsTNhF6Q++YDqrAoRJma8FhLBTWHwawMoS
Vnurar6p14p6ndb8il2c32d+Nbey1qxMYaeqquyjV+B6ndbSKzpx99gUKawr
a5/TSBtzZ+my1/jsBSGVPY1h179s4g0rZiQYs4KUXRndmCtL3I8YWVZaV7Zt
UZCFDt6skC5mkDYoWaqeM7duGWSR+lmOsud5LKItnkG2oD29kr1BzbCqyk4B
UZ921nuJFeWLNb9SYHZ7s6v1PSqzV/1c3e0HDK2IHGT/8Y98ZNZU/tM7EOt9
X4l2w/pzWMuoLfv1ymayWuSwXxDvspiFlrkMcrfPiyTfsLYeqliQNdWTZHaQ
QvzFiLKDFK+TaMTgswNKu8MpxKwdNXLIZoPeh52sepdsnUNO71iEbBaQ/fl1
jWj3GMO+z6CX1e2c6h3ArlxE2Wl9elrW6dJnxMIeY5Bp2Hcmpgbcz+yXdvoZ
AIEiM4ohVQOGCzOARTp96tJr31oISKbaXJLVar0LvMZnAO5LKz+sOo/i827t
yifNTmvFrX1JCN7Xe9urfcdnt88zO6cjhVh2rz7UUIuFhQgms357R+/Wd7he
b57btEjx7naYG4xkrLTK52m3Im1PR5DZsZoR6o4+jdDmUJD5CoGBUCM5MuVb
yqKF3Q97PgT9CZrIdFP2hNcpxBaHSFMuB8WJzlHvrQzlfPHWQi2u8hnTnQsz
J0ta7flk2kaC14Au6nMyJQtsThjRNZDw5Lz6mPLJYlx76iScuTIngNrRkcGd
RlhpH+o3TJ+62C5o7YJev4Mf2b0Xe76KfmWbn+tTbSXWxgpR1yj9mvNQchob
QvwJXmQGafZ0ZMVCjn3xa8ns8UAFK+Bc7gz9dp/p7XqMQvXfxiQrrz0HSBC6
nFIy4yg+g7dD+clYoZ90eq90O+ZHFKXtXiPYX05tjBdqRJ99O5xLKUhZTMnW
q9AzHVKUJnzWcec7JjL6sqcdw+6JPqM47vWHSsXOE4X66VaVSp+bjD0G/ckJ
oR0xL5LB/D5kXg3s9vGCjcTjNeWxRE2Uk2zhtLrJVyuehNJje46UWY87gaHP
kVqscLbgYbFk2KMw9KnXrar727Hs+5OHl2dDAiuc0AxY+lzT7oeUJzne6LHw
FTmVqk8WjyisPR8Dq9f7BJN9WT/T56GTp67kZPy+lLclz6Npb9vsI8Iexsqc
+h7yfoxG5STx/kxM2W81CV6XKfQJ9EEfU7YIGgornIt3tV36j+2KUnxWw51A
T38hk6RUNRrGNhRvBEMx+rR+NaExpDdfNOXTqnn5aGQlHvW3A/HKC/dFQ0cy
Ghoy3MAx6YJYQkn6ywazRpH6euJIoZaGDTUC0n6phNFGFLVe36e8eHKWh3i0
+Osn8+2IfFPE7IAGBOWGU3yB4kZD0X76c/atGRR7rJCi+falBRFQq6UYzkEF
ij2eIo/80Hx1U/wN2FiaImVU/GxAUVxnKi1YIMZEzTd3aWvE3ztRpHkO+1MP
nRUDtbW+blNrmCeCLNTqhVbZYahif7I2U0PCXqjqb7NW+94Hw6FK+60Xyv+z
Qtl3yaUNbglrSxp/Rm3SyfYo6m3mYr9/g22EAwC7Sn92ohDBfP/WAQIujtJ4
BRC0EvqQtQqnbDopblJq7bd8vAFzyIKS/iKj8UM+GlEP7JAvS4/Xz5lVVYtj
v0Isxyf6o4pcVsveahRxC5F5Vo58T57lbcq7+0LxqUJ7HPUZc/aDeYnKsvmS
0n5vyX9RRS6t+DKvcMvuI+BizxTq6U/jO9Io+lP/CveT8D3xH/Nb5LfNb9Ej
/wfR0a6r\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144212589]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10430],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotMarkers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotMarkers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FillingStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FillingStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeshStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoundaryStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BoundaryStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Joined",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Joined"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19451]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19951],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Graphics Directives and Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsDirectivesAndOptions"]], "Tutorials",
 CellID->10342],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with PlotStyle",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=PlotStyle"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->112330744],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->394381337],

Cell[TextData[ButtonBox["Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionVisualization"]], "MoreAbout",
 CellID->33872706],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->138178336],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->588315822]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PlotStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 10, 23.3698874}", "context" -> "System`", 
    "keywords" -> {
     "color lines", "color of curves", "color of lines", "dashed lines", 
      "dashing", "line color", "shading", "style of curves", "style of lines",
       "styles of multiple curves"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PlotStyle is an option for plotting and related functions that specifies \
styles in which objects are to be drawn. ", "synonyms" -> {"plot style"}, 
    "title" -> "PlotStyle", "type" -> "Symbol", "uri" -> "ref/PlotStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16815, 466, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->367972868]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 110974, 2247}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3091, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3714, 95, 4193, 83, 70, "ObjectNameGrid"],
Cell[7910, 180, 491, 14, 70, "Usage",
 CellID->10468]
}, Open  ]],
Cell[CellGroupData[{
Cell[8438, 199, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8916, 216, 291, 9, 70, "Notes",
 CellID->2425],
Cell[9210, 227, 543, 19, 70, "Notes",
 CellID->6204],
Cell[9756, 248, 74, 1, 70, "Notes",
 CellID->31844],
Cell[9833, 251, 4624, 129, 70, "2ColumnTableMod",
 CellID->30921],
Cell[14460, 382, 732, 25, 70, "Notes",
 CellID->26962],
Cell[15195, 409, 341, 10, 70, "Notes",
 CellID->31911],
Cell[15539, 421, 442, 12, 70, "Notes",
 CellID->19169],
Cell[15984, 435, 794, 26, 70, "Notes",
 CellID->23922]
}, Closed]],
Cell[CellGroupData[{
Cell[16815, 466, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->367972868],
Cell[CellGroupData[{
Cell[17200, 480, 148, 5, 70, "ExampleSection",
 CellID->184632603],
Cell[17351, 487, 119, 3, 70, "ExampleText",
 CellID->592170946],
Cell[CellGroupData[{
Cell[17495, 494, 394, 13, 28, "Input",
 CellID->24799594],
Cell[17892, 509, 6276, 107, 126, "Output",
 Evaluatable->False,
 CellID->169394343]
}, Open  ]],
Cell[24183, 619, 125, 3, 70, "ExampleDelimiter",
 CellID->157799115],
Cell[24311, 624, 76, 1, 70, "ExampleText",
 CellID->42124364],
Cell[CellGroupData[{
Cell[24412, 629, 521, 17, 47, "Input",
 CellID->370380378],
Cell[24936, 648, 6463, 110, 126, "Output",
 Evaluatable->False,
 CellID->110256197]
}, Open  ]],
Cell[31414, 761, 126, 3, 70, "ExampleDelimiter",
 CellID->2137756568],
Cell[31543, 766, 73, 1, 70, "ExampleText",
 CellID->960744390],
Cell[CellGroupData[{
Cell[31641, 771, 665, 20, 47, "Input",
 CellID->329333774],
Cell[32309, 793, 26345, 436, 165, "Output",
 Evaluatable->False,
 CellID->334153372]
}, Open  ]],
Cell[58669, 1232, 126, 3, 70, "ExampleDelimiter",
 CellID->1150743658],
Cell[58798, 1237, 83, 1, 70, "ExampleText",
 CellID->310935124],
Cell[CellGroupData[{
Cell[58906, 1242, 1168, 36, 83, "Input",
 CellID->1058915917],
Cell[60077, 1280, 37469, 618, 237, "Output",
 Evaluatable->False,
 CellID->9594269]
}, Open  ]],
Cell[97561, 1901, 125, 3, 70, "ExampleDelimiter",
 CellID->134181233],
Cell[97689, 1906, 86, 1, 70, "ExampleText",
 CellID->59893911],
Cell[CellGroupData[{
Cell[97800, 1911, 829, 25, 47, "Input",
 CellID->1184922654],
Cell[98632, 1938, 6687, 114, 182, "Output",
 Evaluatable->False,
 CellID->144212589]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[105380, 2059, 311, 9, 70, "SeeAlsoSection",
 CellID->10430],
Cell[105694, 2070, 1463, 53, 70, "SeeAlso",
 CellID->19451]
}, Open  ]],
Cell[CellGroupData[{
Cell[107194, 2128, 314, 9, 70, "TutorialsSection",
 CellID->19951],
Cell[107511, 2139, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[107652, 2144, 170, 3, 70, "Tutorials",
 CellID->10342],
Cell[107825, 2149, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[108019, 2157, 305, 8, 70, "RelatedLinksSection"],
Cell[108327, 2167, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108727, 2184, 319, 9, 70, "MoreAboutSection",
 CellID->112330744],
Cell[109049, 2195, 147, 3, 70, "MoreAbout",
 CellID->394381337],
Cell[109199, 2200, 154, 3, 70, "MoreAbout",
 CellID->33872706],
Cell[109356, 2205, 163, 3, 70, "MoreAbout",
 CellID->138178336],
Cell[109522, 2210, 143, 3, 70, "MoreAbout",
 CellID->588315822]
}, Open  ]],
Cell[109680, 2216, 50, 0, 70, "History"],
Cell[109733, 2218, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

