(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44436,       1708]
NotebookOptionsPosition[     35336,       1377]
NotebookOutlinePosition[     36530,       1412]
CellTagsIndexPosition[     36444,       1407]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Minus" :> Documentation`HelpLookup["paclet:ref/Minus"], 
          "Subtract" :> Documentation`HelpLookup["paclet:ref/Subtract"], 
          "AddTo" :> Documentation`HelpLookup["paclet:ref/AddTo"], 
          "Increment" :> Documentation`HelpLookup["paclet:ref/Increment"], 
          "Total" :> Documentation`HelpLookup["paclet:ref/Total"], 
          "Accumulate" :> Documentation`HelpLookup["paclet:ref/Accumulate"], 
          "Sum" :> Documentation`HelpLookup["paclet:ref/Sum"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Minus\"\>", 2->"\<\"Subtract\"\>", 
       3->"\<\"AddTo\"\>", 4->"\<\"Increment\"\>", 5->"\<\"Total\"\>", 
       6->"\<\"Accumulate\"\>", 7->"\<\"Sum\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arithmetic Functions" :> 
          Documentation`HelpLookup["paclet:guide/ArithmeticFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix Operations" :> 
          Documentation`HelpLookup["paclet:guide/MatrixOperations"], 
          "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Arithmetic Functions\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Matrices and Linear Algebra\"\>", 
       4->"\<\"Matrix Operations\"\>", 
       5->"\<\"Operations on Vectors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "Plus ",
     StyleBox["(+)", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "+", 
       StyleBox["y", "TI"], "+", 
       StyleBox["z", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]represents a sum of terms. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " has attributes ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26226],

Cell[TextData[{
 "The default value for arguments of ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", as used in ",
 Cell[BoxData["x_."], "InlineFormula"],
 " patterns, is ",
 Cell[BoxData["0"], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->29907,
  ButtonNote->"29907"]
}], "Notes",
 CellID->7193],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plus"], "[", "]"}]], "InlineFormula"],
 " is taken to be ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17882],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plus"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27876],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "+", "0"}]], "InlineFormula"],
 " evaluates to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", but ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "+", "0.0"}]], "InlineFormula"],
 " is left unchanged. "
}], "Notes",
 CellID->15760],

Cell[TextData[{
 "In mixed fractions such as 1",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]]],
 ", the implicit addition can be entered as 1 ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]+\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    FractionBox["1", "2"]}], TraditionalForm]]],
 " or 1 ",
 Cell[BoxData[
  RowBox[{"\\", 
   RowBox[{"[", "ImplicitPlus", "]"}]}]], "InlineCharacterName"],
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    FractionBox["1", "2"]}], TraditionalForm]]],
 ". This evaluates to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "+", 
    FractionBox["1", "2"]}], TraditionalForm]]],
 ", but implicit addition is an operator with much higher precedence than ",
 Cell[BoxData["+"], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->8738],

Cell[TextData[{
 "Unlike other functions, ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " applies built\[Hyphen]in rules before user\[Hyphen]defined ones. As a \
result, it is not possible to make definitions such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", "+", "2"}], "=", "5"}], TraditionalForm]]],
 ". "
}], "Notes",
 CellID->14557]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->178625878],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->224178319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", "2", "+", "3"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31258],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14345],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->17901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "+", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "x"}], ",", 
   RowBox[{"2", "+", "x"}], ",", 
   RowBox[{"3", "+", "x"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22216]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"10", ",", "20", ",", "30"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25956],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11", ",", "22", ",", "33"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23239]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23725],

Cell[TextData[{
 "Explicit ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "[", 
  RowBox[{"1", ",", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28532],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221398104]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8716],

Cell["If any number is approximate, the whole result will be:", "ExampleText",
 CellID->21762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "+", "2", "+", 
  RowBox[{"3", "/", "4"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10287],

Cell[BoxData["3.75`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104745415]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4738],

Cell["Complex numbers add their components:", "ExampleText",
 CellID->25530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "+", "I"}], ")"}], "+", 
  RowBox[{"(", 
   RowBox[{"3", "-", 
    RowBox[{"7", "I"}]}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4605],

Cell[BoxData[
 RowBox[{"5", "-", 
  RowBox[{"6", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148357314]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->29569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"c", ",", "d"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32407],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", "c"}], ",", 
   RowBox[{"b", "+", "d"}]}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->556814125]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "+", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19413],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", "x"}], ",", 
   RowBox[{"b", "+", "x"}], ",", 
   RowBox[{"c", "+", "x"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->713291301]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "+", "x"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25785],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", "x"}], ",", 
     RowBox[{"b", "+", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "+", "x"}], ",", 
     RowBox[{"d", "+", "x"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->632587006]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28348],

Cell["Matrices add element-wise:", "ExampleText",
 CellID->18593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20799],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "a"}], ",", 
     RowBox[{"2", "+", "b"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "c"}], ",", 
     RowBox[{"4", "+", "d"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65181350]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26664],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " sorts its arguments:"
}], "ExampleText",
 CellID->32599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "+", "c", "+", "a"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->608],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->578753554]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24014],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "3"], "+", 
  SuperscriptBox["x", "4"], "+", 
  SuperscriptBox["x", "5"]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->446095763]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "i"}], " ", 
    RowBox[{"y", "^", "j"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3212],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", "y"}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", "y"}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", "y"}], "+", 
  RowBox[{"x", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"x", " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox["y", "3"]}]}]], "Output",
 ImageSize->{324, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->252149039]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22622],

Cell["Display terms in a sum in a traditional order:", "ExampleText",
 CellID->8327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"x", "^", "n"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22492],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["x", "5"], "+", 
   SuperscriptBox["x", "4"], "+", 
   SuperscriptBox["x", "3"], "+", 
   SuperscriptBox["x", "2"], "+", "x", "+", "1"}], TraditionalForm]], "Output",\

 ImageSize->{124, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->439449258]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "i"}], " ", 
     RowBox[{"y", "^", "j"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26999],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["y", "3"], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    SuperscriptBox["y", "2"], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"y", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    SuperscriptBox["y", "3"], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    SuperscriptBox["y", "2"], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"y", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    SuperscriptBox["y", "3"], " ", "x"}], "+", 
   RowBox[{
    SuperscriptBox["y", "2"], " ", "x"}], "+", 
   RowBox[{"y", " ", "x"}]}], TraditionalForm]], "Output",
 ImageSize->{303, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->680798187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11271],

Cell["Display a sum without evaluation:", "ExampleText",
 CellID->18386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldForm", "[", 
  RowBox[{"1", "+", "3", "+", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2192],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", "3", "+", "2"}],
  HoldForm]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->441657987]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16217],

Cell[TextData[{
 "Display the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of a sum:"
}], "ExampleText",
 CellID->32524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"a", "+", "b", "+", "c", "+", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14988],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->96615248]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15089],

Cell["Find the length of a sum:", "ExampleText",
 CellID->7688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"a", "+", "b", "+", "c", "+", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22414],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45973972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20268],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Total",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Total"]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " to a list:"
}], "ExampleText",
 CellID->4346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Plus", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25358],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c", "+", "d"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84788287]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27745],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c", "+", "d"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->838336568]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10797],

Cell[TextData[{
 "Pattern matching works with ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->30825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "+", "b", "+", "c", "+", "d"}], "/.", 
  RowBox[{
   RowBox[{"a", "+", "d"}], "\[Rule]", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29647],

Cell[BoxData[
 RowBox[{"b", "+", "c", "+", "x"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->621248360]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "+", "b", "+", "c", "+", "d"}], "/.", 
  RowBox[{
   RowBox[{"a", "+", "c", "+", "x_"}], "\[Rule]", 
   RowBox[{"f", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7237],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"b", "+", "d"}], "]"}]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16393811]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", 
    RowBox[{"a", "+", "b"}], ",", 
    RowBox[{"a", "+", "b", "+", "c"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"a", "+", "x_."}], "\[Rule]", 
   RowBox[{"f", "[", "x", "]"}]}]}]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 CellLabel->"In[3]:=",
 CellID->29907],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "0", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", "+", "c"}], "]"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->132128062]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4549],

Cell[TextData[{
 "Distribute a function over",
 " ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"c", "+", "d"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19039],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"c", "+", "d"}]}], "]"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156189163]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ",", 
    RowBox[{"c", "+", "d"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30012],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "c"}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "d"}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"b", ",", "c"}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"b", ",", "d"}], "]"}]}]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->287500220]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11431],

Cell[TextData[{
 "Distribute ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " through a head:"
}], "ExampleText",
 CellID->32476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"f", "+", "g"}], ")"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->691],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"f", "+", "g"}], ")"}], "[", "x", "]"}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->522787376]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Through", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"f", "+", "g"}], ")"}], "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2845],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x", "]"}], "+", 
  RowBox[{"g", "[", "x", "]"}]}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->416170446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4416],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Accumulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accumulate"]], "InlineFormula"],
 " makes a cumulative sum:"
}], "ExampleText",
 CellID->7774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"Plus", ",", " ", "0", ",", " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", " ", "b", ",", " ", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17056],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "a", ",", 
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}]}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->639193494]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accumulate", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6872],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->459589654]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16868],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subtract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subtract"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AddTo"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Increment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Increment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Accumulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accumulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24521]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->826088810],

Cell[TextData[ButtonBox["Arithmetic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ArithmeticFunctions"]], "MoreAbout",
 CellID->78664212],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->80936440],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->16909390],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "MoreAbout",
 CellID->42774371],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->36738512]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Plus (+) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 10, 26.0105800}", "context" -> "System`", 
    "keywords" -> {"addition", "mixed fractions", "plus"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "x + y + z represents a sum of terms. ", "synonyms" -> {"+"}, "title" -> 
    "Plus", "type" -> "Symbol", "uri" -> "ref/Plus"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11430, 337, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->178625878]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36300, 1400}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2328, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2951, 75, 4255, 86, 70, "ObjectNameGrid"],
Cell[7209, 163, 426, 14, 70, "Usage",
 CellID->29938]
}, Open  ]],
Cell[CellGroupData[{
Cell[7672, 182, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8150, 199, 556, 22, 70, "Notes",
 CellID->26226],
Cell[8709, 223, 421, 16, 70, "Notes",
 CellID->7193],
Cell[9133, 241, 246, 10, 70, "Notes",
 CellID->17882],
Cell[9382, 253, 278, 12, 70, "Notes",
 CellID->27876],
Cell[9663, 267, 319, 13, 70, "Notes",
 CellID->15760],
Cell[9985, 282, 983, 34, 70, "Notes",
 CellID->8738],
Cell[10971, 318, 422, 14, 70, "Notes",
 CellID->14557]
}, Closed]],
Cell[CellGroupData[{
Cell[11430, 337, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->178625878],
Cell[CellGroupData[{
Cell[11815, 351, 148, 5, 70, "ExampleSection",
 CellID->224178319],
Cell[CellGroupData[{
Cell[11988, 360, 98, 3, 28, "Input",
 CellID->31258],
Cell[12089, 365, 154, 5, 36, "Output",
 CellID->13419]
}, Open  ]],
Cell[12258, 373, 121, 3, 70, "ExampleDelimiter",
 CellID->14345],
Cell[12382, 378, 198, 7, 70, "ExampleText",
 CellID->17901],
Cell[CellGroupData[{
Cell[12605, 389, 143, 5, 28, "Input",
 CellID->189],
Cell[12751, 396, 282, 10, 36, "Output",
 CellID->22216]
}, Open  ]],
Cell[CellGroupData[{
Cell[13070, 411, 205, 7, 70, "Input",
 CellID->25956],
Cell[13278, 420, 212, 7, 36, "Output",
 CellID->23239]
}, Open  ]],
Cell[13505, 430, 121, 3, 70, "ExampleDelimiter",
 CellID->23725],
Cell[13629, 435, 187, 8, 70, "ExampleText",
 CellID->8125],
Cell[CellGroupData[{
Cell[13841, 447, 129, 4, 70, "Input",
 CellID->28532],
Cell[13973, 453, 158, 5, 36, "Output",
 CellID->221398104]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14180, 464, 215, 7, 70, "ExampleSection",
 CellID->8716],
Cell[14398, 473, 94, 1, 70, "ExampleText",
 CellID->21762],
Cell[CellGroupData[{
Cell[14517, 478, 122, 4, 70, "Input",
 CellID->10287],
Cell[14642, 484, 162, 5, 36, "Output",
 CellID->104745415]
}, Open  ]],
Cell[14819, 492, 120, 3, 70, "ExampleDelimiter",
 CellID->4738],
Cell[14942, 497, 76, 1, 70, "ExampleText",
 CellID->25530],
Cell[CellGroupData[{
Cell[15043, 502, 201, 8, 70, "Input",
 CellID->4605],
Cell[15247, 512, 215, 7, 36, "Output",
 CellID->148357314]
}, Open  ]],
Cell[15477, 522, 120, 3, 70, "ExampleDelimiter",
 CellID->3799],
Cell[15600, 527, 198, 7, 70, "ExampleText",
 CellID->29569],
Cell[CellGroupData[{
Cell[15823, 538, 182, 7, 70, "Input",
 CellID->32407],
Cell[16008, 547, 251, 9, 36, "Output",
 CellID->556814125]
}, Open  ]],
Cell[CellGroupData[{
Cell[16296, 561, 145, 5, 70, "Input",
 CellID->19413],
Cell[16444, 568, 286, 10, 36, "Output",
 CellID->713291301]
}, Open  ]],
Cell[CellGroupData[{
Cell[16767, 583, 237, 9, 70, "Input",
 CellID->25785],
Cell[17007, 594, 406, 15, 36, "Output",
 CellID->632587006]
}, Open  ]],
Cell[17428, 612, 121, 3, 70, "ExampleDelimiter",
 CellID->28348],
Cell[17552, 617, 65, 1, 70, "ExampleText",
 CellID->18593],
Cell[CellGroupData[{
Cell[17642, 622, 386, 15, 70, "Input",
 CellID->20799],
Cell[18031, 639, 405, 15, 36, "Output",
 CellID->65181350]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18485, 660, 227, 7, 70, "ExampleSection",
 CellID->26664],
Cell[18715, 669, 186, 7, 70, "ExampleText",
 CellID->32599],
Cell[CellGroupData[{
Cell[18926, 680, 96, 3, 70, "Input",
 CellID->608],
Cell[19025, 685, 190, 6, 36, "Output",
 CellID->578753554]
}, Open  ]],
Cell[CellGroupData[{
Cell[19252, 696, 201, 7, 70, "Input",
 CellID->24014],
Cell[19456, 705, 317, 10, 36, "Output",
 CellID->446095763]
}, Open  ]],
Cell[CellGroupData[{
Cell[19810, 720, 299, 11, 70, "Input",
 CellID->3212],
Cell[20112, 733, 758, 27, 36, "Output",
 CellID->252149039]
}, Open  ]],
Cell[20885, 763, 121, 3, 70, "ExampleDelimiter",
 CellID->22622],
Cell[21009, 768, 84, 1, 70, "ExampleText",
 CellID->8327],
Cell[CellGroupData[{
Cell[21118, 773, 247, 8, 70, "Input",
 CellID->22492],
Cell[21368, 783, 369, 12, 52, "Output",
 CellID->439449258]
}, Open  ]],
Cell[CellGroupData[{
Cell[21774, 800, 350, 12, 70, "Input",
 CellID->26999],
Cell[22127, 814, 825, 28, 52, "Output",
 CellID->680798187]
}, Open  ]],
Cell[22967, 845, 121, 3, 70, "ExampleDelimiter",
 CellID->11271],
Cell[23091, 850, 72, 1, 70, "ExampleText",
 CellID->18386],
Cell[CellGroupData[{
Cell[23188, 855, 132, 4, 70, "Input",
 CellID->2192],
Cell[23323, 861, 213, 8, 36, "Output",
 CellID->441657987]
}, Open  ]],
Cell[23551, 872, 121, 3, 70, "ExampleDelimiter",
 CellID->16217],
Cell[23675, 877, 200, 8, 70, "ExampleText",
 CellID->32524],
Cell[CellGroupData[{
Cell[23900, 889, 143, 4, 70, "Input",
 CellID->14988],
Cell[24046, 895, 366, 13, 50, "Output",
 CellID->96615248]
}, Open  ]],
Cell[24427, 911, 121, 3, 70, "ExampleDelimiter",
 CellID->15089],
Cell[24551, 916, 63, 1, 70, "ExampleText",
 CellID->7688],
Cell[CellGroupData[{
Cell[24639, 921, 141, 4, 70, "Input",
 CellID->22414],
Cell[24783, 927, 157, 5, 36, "Output",
 CellID->45973972]
}, Open  ]],
Cell[24955, 935, 121, 3, 70, "ExampleDelimiter",
 CellID->20268],
Cell[25079, 940, 302, 12, 70, "ExampleText",
 CellID->4346],
Cell[CellGroupData[{
Cell[25406, 956, 192, 6, 70, "Input",
 CellID->25358],
Cell[25601, 964, 199, 6, 36, "Output",
 CellID->84788287]
}, Open  ]],
Cell[CellGroupData[{
Cell[25837, 975, 164, 5, 70, "Input",
 CellID->27745],
Cell[26004, 982, 200, 6, 36, "Output",
 CellID->838336568]
}, Open  ]],
Cell[26219, 991, 121, 3, 70, "ExampleDelimiter",
 CellID->10797],
Cell[26343, 996, 199, 8, 70, "ExampleText",
 CellID->30825],
Cell[CellGroupData[{
Cell[26567, 1008, 185, 6, 70, "Input",
 CellID->29647],
Cell[26755, 1016, 190, 6, 36, "Output",
 CellID->621248360]
}, Open  ]],
Cell[CellGroupData[{
Cell[26982, 1027, 224, 7, 70, "Input",
 CellID->7237],
Cell[27209, 1036, 207, 7, 36, "Output",
 CellID->16393811]
}, Open  ]],
Cell[CellGroupData[{
Cell[27453, 1048, 338, 11, 70, "Input",
 CellID->29907],
Cell[27794, 1061, 326, 11, 36, "Output",
 CellID->132128062]
}, Open  ]],
Cell[28135, 1075, 120, 3, 70, "ExampleDelimiter",
 CellID->4549],
Cell[28258, 1080, 203, 9, 70, "ExampleText",
 CellID->12546],
Cell[CellGroupData[{
Cell[28486, 1093, 164, 6, 70, "Input",
 CellID->19039],
Cell[28653, 1101, 256, 9, 36, "Output",
 CellID->156189163]
}, Open  ]],
Cell[CellGroupData[{
Cell[28946, 1115, 204, 7, 70, "Input",
 CellID->30012],
Cell[29153, 1124, 409, 14, 36, "Output",
 CellID->287500220]
}, Open  ]],
Cell[29577, 1141, 121, 3, 70, "ExampleDelimiter",
 CellID->11431],
Cell[29701, 1146, 197, 8, 70, "ExampleText",
 CellID->32476],
Cell[CellGroupData[{
Cell[29923, 1158, 138, 5, 70, "Input",
 CellID->691],
Cell[30064, 1165, 232, 8, 36, "Output",
 CellID->522787376]
}, Open  ]],
Cell[CellGroupData[{
Cell[30333, 1178, 175, 6, 70, "Input",
 CellID->2845],
Cell[30511, 1186, 236, 8, 36, "Output",
 CellID->416170446]
}, Open  ]],
Cell[30762, 1197, 120, 3, 70, "ExampleDelimiter",
 CellID->4416],
Cell[30885, 1202, 200, 7, 70, "ExampleText",
 CellID->7774],
Cell[CellGroupData[{
Cell[31110, 1213, 215, 6, 70, "Input",
 CellID->17056],
Cell[31328, 1221, 282, 9, 36, "Output",
 CellID->639193494]
}, Open  ]],
Cell[CellGroupData[{
Cell[31647, 1235, 158, 5, 70, "Input",
 CellID->6872],
Cell[31808, 1242, 272, 9, 36, "Output",
 CellID->459589654]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32141, 1258, 311, 9, 70, "SeeAlsoSection",
 CellID->16868],
Cell[32455, 1269, 1654, 62, 70, "SeeAlso",
 CellID->24521]
}, Open  ]],
Cell[CellGroupData[{
Cell[34146, 1336, 319, 9, 70, "MoreAboutSection",
 CellID->826088810],
Cell[34468, 1347, 150, 3, 70, "MoreAbout",
 CellID->78664212],
Cell[34621, 1352, 154, 3, 70, "MoreAbout",
 CellID->80936440],
Cell[34778, 1357, 162, 3, 70, "MoreAbout",
 CellID->16909390],
Cell[34943, 1362, 144, 3, 70, "MoreAbout",
 CellID->42774371],
Cell[35090, 1367, 151, 3, 70, "MoreAbout",
 CellID->36738512]
}, Open  ]],
Cell[35256, 1373, 50, 0, 70, "History"],
Cell[35309, 1375, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

