(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13661,        481]
NotebookOptionsPosition[     10490,        379]
NotebookOutlinePosition[     11804,        415]
CellTagsIndexPosition[     11719,        410]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators without Built\[Hyphen]in Meanings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperatorsWithoutBuiltInMeanings"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators without Built\[Hyphen]in Meanings\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MinusPlus" :> 
          Documentation`HelpLookup["paclet:ref/MinusPlus"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MinusPlus\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "PlusMinus ",
     StyleBox["(\[PlusMinus])", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PlusMinus",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PlusMinus"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays as ",
     Cell[BoxData[
      RowBox[{"\[PlusMinus]", 
       StyleBox["x", "TI"]}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PlusMinus",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PlusMinus"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", "\[Ellipsis]"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"x", "\[PlusMinus]", "y"}], "\[PlusMinus]", "\[Ellipsis]"}], 
       TraditionalForm]]],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlusMinus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlusMinus"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " has no built-in meaning."
}], "Notes",
 CellID->18965936],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[PlusMinus]", "y"}], TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlusMinus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlusMinus"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->932906596],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[PlusMinus]", TraditionalForm]]],
 " can be entered as ",
 Cell[TextData[ButtonBox["\\[PlusMinus]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/PlusMinus"]], "InlineCharacterName"],
 " or ",
 Cell["", "InlineCharacterName"],
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]+-\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->583052225]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->36696101],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->22418022],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlusMinus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlusMinus"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is formatted using the ",
 Cell[BoxData["\[PlusMinus]"], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["\\[PlusMinus]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/PlusMinus"]], "InlineCharacterName"],
 ") operator character."
}], "ExampleText",
 CellID->48075793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlusMinus", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->403198446],

Cell[BoxData[
 RowBox[{"a", "\[PlusMinus]", "b"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78675382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93495016],

Cell[TextData[{
 "Define a meaning for ",
 Cell[BoxData[
  ButtonBox["PlusMinus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlusMinus"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->247498656],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlusMinus", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "-", "b"}], ",", 
     RowBox[{"a", "+", "b"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97609925],

Cell["This is now interpreted as an interval: ", "ExampleText",
 CellID->328830337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "\[PlusMinus]", "b"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->312230015],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "-", "b"}], ",", 
    RowBox[{"a", "+", "b"}]}], "}"}], "]"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->571537675]
}, Open  ]],

Cell["Clear the definition:", "ExampleText",
 CellID->131853060],

Cell[BoxData[
 RowBox[{"Clear", "[", "PlusMinus", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->43540610]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9428],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["MinusPlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MinusPlus"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->24207]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "Tutorials",\

 CellID->341631938],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->400354195]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PlusMinus (\[PlusMinus]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 10, 25.2136846}", "context" -> "System`", 
    "keywords" -> {"plus minus", "tolerance", "measurement tolerance"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "PlusMinus[x] displays as \\[PlusMinus]x. PlusMinus[x, y, ...] displays \
as x \\[PlusMinus] y \\[PlusMinus] ....", "synonyms" -> {"plus minus"}, 
    "title" -> "PlusMinus", "type" -> "Symbol", "uri" -> "ref/PlusMinus"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6436, 211, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->36696101]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11577, 403}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1346, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1969, 61, 1652, 40, 70, "ObjectNameGrid"],
Cell[3624, 103, 1081, 36, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4742, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5220, 161, 335, 12, 70, "Notes",
 CellID->18965936],
Cell[5558, 175, 405, 15, 70, "Notes",
 CellID->932906596],
Cell[5966, 192, 433, 14, 70, "Notes",
 CellID->583052225]
}, Closed]],
Cell[CellGroupData[{
Cell[6436, 211, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->36696101],
Cell[CellGroupData[{
Cell[6820, 225, 147, 5, 70, "ExampleSection",
 CellID->22418022],
Cell[6970, 232, 518, 17, 70, "ExampleText",
 CellID->48075793],
Cell[CellGroupData[{
Cell[7513, 253, 128, 4, 28, "Input",
 CellID->403198446],
Cell[7644, 259, 190, 6, 36, "Output",
 CellID->78675382]
}, Open  ]],
Cell[7849, 268, 124, 3, 70, "ExampleDelimiter",
 CellID->93495016],
Cell[7976, 273, 207, 8, 70, "ExampleText",
 CellID->247498656],
Cell[8186, 283, 290, 10, 70, "Input",
 CellID->97609925],
Cell[8479, 295, 83, 1, 70, "ExampleText",
 CellID->328830337],
Cell[CellGroupData[{
Cell[8587, 300, 103, 3, 70, "Input",
 CellID->312230015],
Cell[8693, 305, 290, 10, 36, "Output",
 CellID->571537675]
}, Open  ]],
Cell[8998, 318, 64, 1, 70, "ExampleText",
 CellID->131853060],
Cell[9065, 321, 108, 3, 70, "Input",
 CellID->43540610]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9222, 330, 310, 9, 70, "SeeAlsoSection",
 CellID->9428],
Cell[9535, 341, 198, 6, 70, "SeeAlso",
 CellID->24207]
}, Open  ]],
Cell[CellGroupData[{
Cell[9770, 352, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[10091, 363, 191, 4, 70, "Tutorials",
 CellID->341631938],
Cell[10285, 369, 133, 3, 70, "Tutorials",
 CellID->400354195]
}, Open  ]],
Cell[10433, 375, 27, 0, 70, "History"],
Cell[10463, 377, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

