(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    148199,       3691]
NotebookOptionsPosition[    137294,       3312]
NotebookOutlinePosition[    138637,       3351]
CellTagsIndexPosition[    138550,       3346]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Primitives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"], 
          "Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"], 
          "The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Primitives\"\>", 
       2->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>", 
       3->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Locator" :> Documentation`HelpLookup["paclet:ref/Locator"], 
          "Inset" :> Documentation`HelpLookup["paclet:ref/Inset"], 
          "PlotMarkers" :> Documentation`HelpLookup["paclet:ref/PlotMarkers"],
           "PointSize" :> 
          Documentation`HelpLookup["paclet:ref/PointSize"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Locator\"\>", 2->"\<\"Inset\"\>", 
       3->"\<\"PlotMarkers\"\>", 4->"\<\"PointSize\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Objects" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsObjects"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Objects\"\>", 
       2->"\<\"Symbolic Graphics Language\"\>", 
       3->"\<\"New in 6.0: Graphics Primitives & Directives\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Point", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Point",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Point"], "[", 
       StyleBox["coords", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics primitive that represents a point. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Point",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Point"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["coords", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["coords", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a collection of points. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->9488]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The coordinates can be given either in the ordinary form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "}"}]], "InlineFormula"],
 " or in scaled form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->21173097]
}], "Notes",
 CellID->3477],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " can be used to specify coordinates in two dimensions. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->371331526]
}], "Notes",
 CellID->16714],

Cell[TextData[{
 "Points are rendered if possible as circular regions. Their diameters can be \
specified using the graphics directive ",
 Cell[BoxData[
  ButtonBox["PointSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PointSize"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->846],

Cell["\<\
Point diameters are not accounted for in hidden surface elimination for three\
\[Hyphen]dimensional graphics. \
\>", "Notes",
 CellID->30475],

Cell[TextData[{
 "Shading and coloring of points can be specified using ",
 Cell[BoxData[
  ButtonBox["CMYKColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CMYKColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->15082],

Cell[TextData[{
 "Individual coordinates and lists of coordinates in points can be ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->27831]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->571230613],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->517990702],

Cell["A single point:", "ExampleText",
 CellID->11093713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Point", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->384599799],

Cell[BoxData[
 GraphicsBox[PointBox[{0, 0}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->3880399]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->556406487],

Cell["Multiple points:", "ExampleText",
 CellID->31786828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Point", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}], ",", 
       RowBox[{"2", 
        RowBox[{"\[Pi]", "/", "10"}]}]}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->101268031],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAFiGwkGIPs/kAXG
W/7/B9LIZDWIZG5vbwdKZ2RkMPCh8VWRVCkoKABFOTg4oKoQfGRV27dvd3Bw
mD9/PlQVgq+KYTsuMgvNFQZofBEkVQhXGKDxkVUhXGGAxhch2lWkksxorg5G
4weh8ZmRdCF8EYzGD0LjI+tC+CoYjR+ExmemgX9FCMRaFpIq3LGGrAp3rGWR
6DZVAum8GkkV7nSOrAp3Oq/GsJ2BEQB3paa8\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69177400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->92325663],

Cell["Points in 3D:", "ExampleText",
 CellID->638029486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Point", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"Cos", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}], ",", 
       RowBox[{"2", 
        RowBox[{"\[Pi]", "/", "10"}]}]}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181275214],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVWA1v1EYQ3fh8dwQSLiRc7ghBuRJERflQ0qRBfDdUgSJaENDypfJxAdOk
NAUFWoFAqFWrVkJFqFUr9Yfw91bUO34bb57XZydSzjc37z3v7szOjv1l9+lS
tNJ9unyv2zm72n28tHzvSefMo9X4p0qfUupd/P+sreLv7+Nv8v9Oa63Uf/Fn
EEXRmFj/xp+V2FKV+Eskf2qHeP6GJzSW+ZIAVFu8b+Gte71/wruFvC3xvsYI
thorTLwJYFT8f4A9lOP/Df4RY1XX/LhHUzC/ADPqjMB8DcgeFvQroHeUQr8A
epy8FbK3CfoZ0BPkDcmW2aqfsDa7S6GfQHsPeatkNwT9GOgPyVsjW+KiVoDe
X6CdoL8D+lCB9qCgvwV6mrx1sgcEHWFNZkuhF6E9R95NZEtuqjtAHymF/gbo
4+TtJ3uzoG8AfcrnZba6CvTpUugrQC/4xsnzUJewgucK0LKi6gK0z5dCnwf6
gi8anAnqc6AvkXeQbMkytQD0V6XQp4G+Rt6tZMteUqeAvukZtzGT8Z7AyiW7
N66iztyD2PzYEx1jci0QWx2Ft2OuMXtTjkrNHUNG5TC8k2D356hUgOPsTFRm
4Y0crxwE8QfHLmFMg2F375AXdYhQXEM5GglrP7G8VSbD2ofoWBbvWj9rL9AX
sW5NnT2tzNcG2TITNQn0ZbCHYfO9/OwO0DNgd3Bt4PdtpVR26bTGGbZd8+2l
2GNAP8C1VYrVItZYKVYTETK/hmBVorTfyGfadb2P686czOBakLAbOWzOED97
gNhjGD3vC2b3Cbvfw/bFltUSdi2HzbH1s3l1FkmlgowZIRznfqIWInpdUqlB
hcfEZ1Wq4laYW6TWIRbXK0dlXTd4g3Qmy+tU137FmL7WaQdobsI9EudNdmYa
2ROgsoRQM+4DhOPOJVHjM4NjOa+TU6NK857yqPfFplH1K/O58imUA1Ke2bAy
z2zeoxjgTjyi3socgROkPOfMgVextzLnyRHKhZMbVuR98ImjaK6fkT8sVOT9
OU2KZ8lfKVTk+nGQFLn7CwoVuRruI0XuEIsV+Uzdo9fvq8s9FLOZwP2KPYtt
nK9qX2Xwa5labnb6LprjzQ1ocA1ukdZtzRXPr8NVeIR0Fh1//miaZDdI5QFm
7Gfzc/YWYi/3ZHMHUif2Ss+4tsm2fW8bcf0Btp/tPvOb1QnAND890s47EOX2
LPzsP6rTHtJUobu4d72QaaNlct1UxtuOUm/mkLM6IRR6MwYdhrkOZxg7ibEZ
2pbRLGTUaVTtQkZIoxr3M9KdANz3uMOEFx8CsdYZKI66MR8CuTeDaMLD+WL7
348yDNux8um6CKWDGYbdY3wC2bcS0xmG7Uy5ets3E7MZhu1Gucu+jlEdzjBs
BzpMDNsjHcsw7I7jGpLszPSpeU47J6pyd53dr5l6qNInVXkzIvuTM8hE0+yd
Kegv5CLt+4dzukwlWQD6C0Hz6cRVax53vyho7g25Qp6E9hVBc6/HK3lUO2eU
RCjwrLd9MyCnUKZj4njOQPOWoDkH+WllCtpdQXOHw2erfUKwJ/Z9YXEXEyDC
rGbZH+CeS8IewKzzWPa5/qGguXfgHbNbp6eDyjyD8kgnoL0qaJ4tr904tH8U
tO0VGGVr0HNBcTfAVcTWo5eC5jOf88fWop8FzXnCuWnr0K+C5kz19aJmJL8L
uoXZ+fp1Y74WlJyy63qZGlTeiN99mxDh9YAx/xKv2cXV2PpHLNX3P8SilYQ=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->187688654]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->349546455],

Cell["Differently styled points:", "ExampleText",
 CellID->105301427],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}], ",", 
       RowBox[{"2", 
        RowBox[{"\[Pi]", "/", "10"}]}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->583788358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Small", "]"}], ",", 
      RowBox[{"Point", "[", "p", "]"}]}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Small", "]"}], ",", "Pink", ",", 
      RowBox[{"Point", "[", "p", "]"}]}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", 
      RowBox[{"Point", "[", "p", "]"}]}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Pink", ",", 
      RowBox[{"Point", "[", "p", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->630768990],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWL1OG0EQXnM22CghKBayA1JCcyEuQFRRFBpX5B+RjgJFdkgUkECJCA/g
AgkKHoAOP4ALqlCSiIKSB6AgEQVKGiLRJNVkf2bPe8vc3Z4NiiXvrL85z36z
NzP786q+tvh+pb62tFAffbJa/7S4tPB5dPrjKoe8DGOZr4yx+2XG+8B78is+
3/hXddu9B6KX29nZGRwc5M/l8/mNjQ2WI9GaROHoCDY3odGA9XU4OMBnbXQk
GGFM9Ly9vT2mPp5octwe6I/Q5aQqQNm8/BccHwuTjQbv8ibHLQf/4joOSJVG
WVmO+oK3PdxcH8p3QvIn+1DWpe1qtRpiVC6XA9NCpxgFqGbUbIYZbW21GTWb
mpFGUzHiYyGjrBiawN4oDty64pDljUdgw9bsz83NhXydnJwMSAud8jVAta+t
VtjX7e22r62W9lWj6Kvo3iPjRzE9OTlRqOLSu7+/HxhVOuEpK5i4bWmGjDmc
ifNzhSrWvdxom7XUiRlihRBuWbodeHIXiOgtmNF7dnZWq9V4xPCJPDw8xHyw
UY+yY8T7cyDivRCK94sL2N0V8cdfy+mpzjsL9Sg7RobcsjyzssCI92KCHhmH
88GI/GKCXjHJgsqIKZQjKGdBZcYISvnGrWwYIrCXcDkbhgisH8eRs4izpusk
OLKxssrIn2KCHucunF9GJhUT9P0W3x7SC9HInLRzzgtyC0eK1iPTcE55Qe5o
ppF6d6Z3gMqbEonOkLFfItGbzgy+OD35wfq9nPB7xdmqiLQVlAWgKmglBeqF
LNkVrpICzTp5sJgwD70QXwH9TvShfYQA8hBf//xO9KF9h6w0UvZYHi5Z77AP
4iuo34k+a+5T2qNE11m/S73tZUbNgaeEChjFZALlOMoBUNVyAuU4ygG4XLfH
HLEbcLmWjzligiffHksPMuQb9DryJLrO+13qVfWMXgf8LvX0u7Uz+zvErxF+
l3r0MnIN8TvR58z9XTtnbd9+ALW+VFKgA0CtOpUUqFt9FY3bCvULqPWgRKL0
TrpEolNOo/+E+DpeTNCTO2GjQhcT9I9SsPx/u980LK9u1/vYaVRRY0XVG0b5
GlS1G0Y5C/FV67p3v/Tc6ZOEG3urGsWeNunbEPI0m7Rzjj110jcp5KnWqH4P
wTzJ/AaqRpGnT/oOJvZsS++7yTMnfVcTe6KtSg/+AJF513Q7M22MeHW3L0+l
VX12zKNcwPjLo3wLRJZc083MdApGjvczRqTPUxEade9iRK5i9ReoiKVvUWpk
/NE3Ic+kdTGQfe/JMv8AdlMZbw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->404742557]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->78583763],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Point Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->574713873],

Cell["A single point:", "ExampleText",
 CellID->19036412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Point", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->823254087],

Cell[BoxData[
 GraphicsBox[PointBox[{0, 0}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->662102289]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->180961554],

Cell["Multiple points:", "ExampleText",
 CellID->86360336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Point", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91097190],

Cell[BoxData[
 GraphicsBox[PointBox[{{0, 0}, {1, 1}, {2, 2}, {3, 3}}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->323614526]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Point Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3955787],

Cell["Points with different sizes:", "ExampleText",
 CellID->333605483],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "t"}], ",", "t"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71789691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "i", "]"}], ",", 
      RowBox[{"Point", "[", "p", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->388135036],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {PointSize[Tiny], 
     PointBox[{{2, 1}, {4, 2}, {6, 3}, {8, 4}, {10, 5}, {12, 6}, {14, 7}, {16,
       8}, {18, 9}, {20, 10}}]}], ",", 
   GraphicsBox[
    {PointSize[Small], 
     PointBox[{{2, 1}, {4, 2}, {6, 3}, {8, 4}, {10, 5}, {12, 6}, {14, 7}, {16,
       8}, {18, 9}, {20, 10}}]}], ",", 
   GraphicsBox[
    {PointSize[Medium], 
     PointBox[{{2, 1}, {4, 2}, {6, 3}, {8, 4}, {10, 5}, {12, 6}, {14, 7}, {16,
       8}, {18, 9}, {20, 10}}]}], ",", 
   GraphicsBox[
    {PointSize[Large], 
     PointBox[{{2, 1}, {4, 2}, {6, 3}, {8, 4}, {10, 5}, {12, 6}, {14, 7}, {16,
       8}, {18, 9}, {20, 10}}]}]}], "}"}]], "Output",
 ImageSize->{452, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->9831777]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->897646445],

Cell["Scaled point size:", "ExampleText",
 CellID->684693210],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "t"}], ",", "t"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->455326927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "i", "]"}], ",", 
      RowBox[{"Point", "[", "p", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{".005", ",", ".05", ",", ".1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->617660970],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {PointSize[0.005], 
     PointBox[{{2, 1}, {4, 2}, {6, 3}, {8, 4}, {10, 5}, {12, 6}, {14, 7}, {16,
       8}, {18, 9}, {20, 10}}]}], ",", 
   GraphicsBox[
    {PointSize[0.05], 
     PointBox[{{2, 1}, {4, 2}, {6, 3}, {8, 4}, {10, 5}, {12, 6}, {14, 7}, {16,
       8}, {18, 9}, {20, 10}}]}], ",", 
   GraphicsBox[
    {PointSize[0.1], 
     PointBox[{{2, 1}, {4, 2}, {6, 3}, {8, 4}, {10, 5}, {12, 6}, {14, 7}, {16,
       8}, {18, 9}, {20, 10}}]}]}], "}"}]], "Output",
 ImageSize->{341, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->291359940]
}, Open  ]],

Cell["Point size in printer's point:", "ExampleText",
 CellID->30262912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsolutePointSize", "[", "i", "]"}], ",", 
      RowBox[{"Point", "[", "p", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "10"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->234987309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsolutePointSize[1], 
     PointBox[{{2, 1}, {4, 2}, {6, 3}, {8, 4}, {10, 5}, {12, 6}, {14, 7}, {16,
       8}, {18, 9}, {20, 10}}]}], ",", 
   GraphicsBox[
    {AbsolutePointSize[5], 
     PointBox[{{2, 1}, {4, 2}, {6, 3}, {8, 4}, {10, 5}, {12, 6}, {14, 7}, {16,
       8}, {18, 9}, {20, 10}}]}], ",", 
   GraphicsBox[
    {AbsolutePointSize[10], 
     PointBox[{{2, 1}, {4, 2}, {6, 3}, {8, 4}, {10, 5}, {12, 6}, {14, 7}, {16,
       8}, {18, 9}, {20, 10}}]}]}], "}"}]], "Output",
 ImageSize->{341, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->732045698]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->670714399],

Cell["Colored points:", "ExampleText",
 CellID->704116176],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "t"}], ",", "t"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1032683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Point", "[", "p", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Cyan"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->742855166],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0, 0], 
     PointBox[{{2, 1}, {4, 2}, {6, 3}, {8, 4}, {10, 5}, {12, 6}, {14, 7}, {16,
       8}, {18, 9}, {20, 10}}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 1, 0], 
     PointBox[{{2, 1}, {4, 2}, {6, 3}, {8, 4}, {10, 5}, {12, 6}, {14, 7}, {16,
       8}, {18, 9}, {20, 10}}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], 
     PointBox[{{2, 1}, {4, 2}, {6, 3}, {8, 4}, {10, 5}, {12, 6}, {14, 7}, {16,
       8}, {18, 9}, {20, 10}}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 1, 1], 
     PointBox[{{2, 1}, {4, 2}, {6, 3}, {8, 4}, {10, 5}, {12, 6}, {14, 7}, {16,
       8}, {18, 9}, {20, 10}}]}]}], "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->69017983]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Coordinate Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->573582274],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->21173097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "\[Rule]", "Large"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".2"}], "}"}], "]"}], ",", 
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", ".8"}], "}"}], "]"}]}], "}"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31772655],

Cell[BoxData[
 GraphicsBox[
  {PointSize[Large], PointBox[{Scaled[{0, 0.2}], Scaled[{1, 0.8}]}]},
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->14431506]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "\[Rule]", "Large"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".2", ",", "0"}], "}"}], "]"}], ",", 
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", ".8", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->61274159],

Cell[BoxData[
 Graphics3DBox[
  {PointSize[Large], Point3DBox[{Scaled[{0, 0.2, 0}], Scaled[{1, 0.8, 1}]}]},
  Axes->True]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->278859707,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->572861043],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " coordinates in 2D:"
}], "ExampleText",
 CellID->6166460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "\[Rule]", "Large"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ImageScaled", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".2"}], "}"}], "]"}], ",", 
        RowBox[{"ImageScaled", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", ".8"}], "}"}], "]"}]}], "}"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->284038649],

Cell[BoxData[
 GraphicsBox[
  {PointSize[Large], 
   PointBox[{ImageScaled[{0, 0.2}], ImageScaled[{1, 0.8}]}]},
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->117462]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31232281],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " coordinates in 2D:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->371331526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "\[Rule]", "Large"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{"Offset", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"20", ",", "20"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459813749],

Cell[BoxData[
 GraphicsBox[
  {PointSize[Large], PointBox[Offset[{20, 20}, {0, 0}]]},
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->508730510]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1339],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Point",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Point"]], "InlineFormula"],
 " to indicate features, e.g. zeros of a function:"
}], "ExampleText",
 CellID->425117191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"5", "Pi"}]}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", " ", "Pi"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->644909817],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->519677998]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->346079769],

Cell[TextData[{
 "A simple point classification, visualized using ",
 Cell[BoxData[
  ButtonBox["Point",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Point"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->430832121],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"red", ",", "green"}], "}"}], "=", 
   RowBox[{"Last", "@", 
    RowBox[{"Reap", "@", 
     RowBox[{"Scan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "^", "2"}], "+", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "^", "3"}]}], "<", "2"}], "&&",
            
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "<", "1"}]}], ",", 
          RowBox[{"Sow", "[", 
           RowBox[{"#", ",", "\"\<Red\>\""}], "]"}], ",", 
          RowBox[{"Sow", "[", 
           RowBox[{"#", ",", "\"\<Green\>\""}], "]"}]}], "]"}], "&"}], ",", 
       RowBox[{"RandomReal", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5000", ",", "2"}], "}"}]}], "]"}]}], "]"}]}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->519405138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Point", "[", "red", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"Green", ",", 
      RowBox[{"Point", "[", "green", "]"}]}], "}"}]}], "}"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->10405249],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->130119689]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->366408624],

Cell["Same idea in 3D:", "ExampleText",
 CellID->485596498],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"red", ",", "green"}], "}"}], "=", 
   RowBox[{"Last", "@", 
    RowBox[{"Reap", "@", 
     RowBox[{"Scan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "^", "2"}], "+", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "^", "3"}], "-", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "^", "2"}]}], ">", "0"}], ",", 
          RowBox[{"Sow", "[", 
           RowBox[{"#", ",", "\"\<Red\>\""}], "]"}], ",", 
          RowBox[{"Sow", "[", 
           RowBox[{"#", ",", "\"\<Green\>\""}], "]"}]}], "]"}], "&"}], ",", 
       RowBox[{"RandomReal", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10000", ",", "3"}], "}"}]}], "]"}]}], "]"}]}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->745223823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Point", "[", "red", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"Green", ",", 
      RowBox[{"Point", "[", "green", "]"}]}], "}"}]}], "}"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->288281788],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->469338991]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21799767],

Cell["Visualize the result of cluster analysis: ", "ExampleText",
 CellID->55477103],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.1"}], ",", "2.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.9", ",", 
       RowBox[{"-", "0.8"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.2", ",", 
       RowBox[{"-", "3.7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.3", ",", "3.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.9", ",", "5.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.1", ",", 
       RowBox[{"-", "4.8"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.8", ",", "3.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.6", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.1", ",", 
       RowBox[{"-", "5.2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9"}], ",", "2.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.9", ",", "4.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.3"}], ",", "3.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5"}], ",", "3."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.6", ",", 
       RowBox[{"-", "5.5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.2", ",", "1.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7"}], ",", "1.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9", ",", "2.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5"}], ",", "3.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.8", ",", "1.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.6", ",", 
       RowBox[{"-", "5.1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "3.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.7", ",", "0.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "3."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.9", ",", "3.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.5", ",", "1.4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.2", ",", "1.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.1"}], ",", "2.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.8", ",", "2.4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.3", ",", 
       RowBox[{"-", "3.5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.2", ",", 
       RowBox[{"-", "4.6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.3", ",", 
       RowBox[{"-", "4.9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "3.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7", ",", "2.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.2", ",", 
       RowBox[{"-", "4.3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2."}], ",", "0.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.2"}], ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.6"}], ",", "1.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5"}], ",", "3.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.8", ",", "0.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.3", ",", "2.4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.1"}], ",", "2.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.3"}], ",", "2.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.4", ",", "3.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.5", ",", "0.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.1", ",", "2.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1."}], ",", "1.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.4"}], ",", "4.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.2", ",", "2.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.6"}], ",", "2.4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.6", ",", 
       RowBox[{"-", "5.1"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177473525],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c1", ",", "c2", ",", "c3", ",", "c4"}], "}"}], "=", 
   RowBox[{"FindClusters", "[", "data", "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8760494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Point", "[", "c1", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", "c2", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"Point", "[", "c3", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Yellow", ",", 
       RowBox[{"Point", "[", "c4", "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->733081931],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], 
    PointBox[{{-1.1, 2.6}, {-0.9, 2.3}, {-2.3, 3.9}, {-2.5, 3.}, {-0.7, 
     1.3}, {0.9, 2.8}, {-1.5, 3.3}, {-0.8, 3.2}, {-1.1, 2.6}, {0.7, 
     2.1}, {-2., 0.5}, {-1.2, 2.}, {-1.6, 1.8}, {-3.5, 3.7}, {-0.1, 
     2.1}, {-1.3, 2.5}, {0.1, 2.9}, {-1., 1.6}, {-1.4, 4.5}, {-1.6, 2.4}}]}, 
   {RGBColor[0, 1, 0], 
    PointBox[{{3.9, -0.8}, {5.6, 0.1}, {5.2, 1.9}, {3.8, 1.2}, {4.7, 0.7}, {
     4.5, 1.4}, {4.2, 1.3}, {4.8, 2.4}, {4.8, 0.2}, {3.5, 0.2}}]}, 
   {RGBColor[0, 0, 1], 
    PointBox[{{4.2, -3.7}, {4.1, -4.8}, {3.1, -5.2}, {2.6, -5.5}, {
     2.6, -5.1}, {3.3, -3.5}, {3.2, -4.6}, {3.3, -4.9}, {3.2, -4.3}, {
     2.6, -5.1}}]}, 
   {RGBColor[1, 1, 0], 
    PointBox[{{3.3, 3.5}, {3.9, 5.2}, {3.8, 3.7}, {2.9, 4.1}, {3., 3.}, {3.9, 
     3.6}, {3., 3.5}, {3.3, 2.4}, {4.4, 3.9}, {3.2, 2.5}}]}},
  Axes->True]], "Output",
 ImageSize->{184, 210},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->452030750]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21738],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " to visualize 1D sequences:"
}], "ExampleText",
 CellID->209367998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "k", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->623717237],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzt1UtOwlAYxfHGEUMGDBgwQEIIIYTwfj8qvk00isb4SqwoapTELXQVjrsU
lsISXIKa+7836VkDTcjpj9OW0psv3Z5/zRZbnud9/33+02w/E3b8eCYkU2SS
zMj3BTJNluS4GpklG2SO7JB5ciTXnZBFk+E0/jvhHi7jfVzBh7iKT+L3FZ7i
Oj6L3+fqHDfxBW6Z9Ge4TX8Z/1+rK9zl+Gvcwze4j2/xgPOth/gO85z8ezzG
D5jntnrEvskgMBni7BP9Dj0OcTSnn5pcY7sO0TP9Lue/0OM19linaEGPg1d6
1i3Cdh3Xb/QH3O87PY6wxzqvbY+DD/oj+k96HCzpj7metZsPu/lxJsRJcUqc
FmfEWXFOnBcXxEVxSVwWV8RVcU1cFzfETXFL3BZ3xF1xT9wXD8RD8Ug8Fk/E
ftyh2M6H68V2PlwvtvPherGdD9eL7Xy4Xmznw/ViOx+uF9v5cL3YzofbNu8P
4837w/Sb94e53tL/Bao9uFA=
   "], {{{}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{51, 1}], LineBox[{52, 2}], 
      LineBox[{53, 3}], LineBox[{54, 4}], LineBox[{55, 5}], LineBox[{56, 6}], 
      LineBox[{57, 7}], LineBox[{58, 8}], LineBox[{59, 9}], LineBox[{60, 10}],
       LineBox[{61, 11}], LineBox[{62, 12}], LineBox[{63, 13}], 
      LineBox[{64, 14}], LineBox[{65, 15}], LineBox[{66, 16}], 
      LineBox[{67, 17}], LineBox[{68, 18}], LineBox[{69, 19}], 
      LineBox[{70, 20}], LineBox[{71, 21}], LineBox[{72, 22}], 
      LineBox[{73, 23}], LineBox[{74, 24}], LineBox[{75, 25}], 
      LineBox[{76, 26}], LineBox[{77, 27}], LineBox[{78, 28}], 
      LineBox[{79, 29}], LineBox[{80, 30}], LineBox[{81, 31}], 
      LineBox[{82, 32}], LineBox[{83, 33}], LineBox[{84, 34}], 
      LineBox[{85, 35}], LineBox[{86, 36}], LineBox[{87, 37}], 
      LineBox[{88, 38}], LineBox[{89, 39}], LineBox[{90, 40}], 
      LineBox[{91, 41}], LineBox[{92, 42}], LineBox[{93, 43}], 
      LineBox[{94, 44}], LineBox[{95, 45}], LineBox[{96, 46}], 
      LineBox[{97, 47}], LineBox[{98, 48}], LineBox[{99, 49}], 
      LineBox[{100, 50}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
       113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
       127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
       141, 142, 143, 144, 145, 146, 147, 148, 149, 150}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 50.}, {0., 229.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45231482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->131722856],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPointPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPointPlot3D"]], "InlineFormula"],
 " to visualize 2D sequences:"
}], "ExampleText",
 CellID->165685061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sinc", "[", "m", "]"}], 
      RowBox[{"Sinc", "[", "n", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", ".4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", ".4"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74748353],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->630766405]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27124],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PointSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PointSize"]], "InlineFormula"],
 " is a scaled size that refers to the width of the graphic:"
}], "ExampleText",
 CellID->306091572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", "0.5", "]"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "0.2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116671014],

Cell[BoxData[
 GraphicsBox[
  {PointSize[0.5], PointBox[{0, 0}]},
  AspectRatio->0.2,
  Frame->True,
  ImageSize->{253., Automatic}]], "Output",
 ImageSize->{257, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"HoldForm[Out[1]= ]",
 CellID->101825208]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", "0.5", "]"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->255730262],

Cell[BoxData[
 GraphicsBox[
  {PointSize[0.5], PointBox[{0, 0}]},
  AspectRatio->3,
  Frame->True,
  ImageSize->{111.6708108108108, Automatic}]], "Output",
 ImageSize->{116, 269},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9382492]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["AbsolutePointSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsolutePointSize"]], "InlineFormula"],
 " to control the size: "
}], "ExampleText",
 CellID->233623084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AbsolutePointSize", "[", "15", "]"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "0.2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->204202000],

Cell[BoxData[
 GraphicsBox[
  {AbsolutePointSize[15], PointBox[{0, 0}]},
  AspectRatio->0.2,
  Frame->True,
  ImageSize->{281., Automatic}]], "Output",
 ImageSize->{285, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"HoldForm[Out[3]= ]",
 CellID->111364949]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1005],

Cell["A random point collection:", "ExampleText",
 CellID->14747443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
      RowBox[{"PointSize", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0.1"}], "}"}], "]"}], "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", "2", "}"}]}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "200", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->442545438],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"HoldForm[Out[1]= ]",
 CellID->805543890]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->474177224],

Cell["Disperse a grid of points from a moving center:", "ExampleText",
 CellID->130340021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"g", "=", 
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", "1.5", ",", ".1"}], "]"}], ",", "2"}], 
      "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Animate", "[", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"pt", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", "q", "]"}], ",", 
           RowBox[{"Sin", "[", "q", "]"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PointSize", "[", "Small", "]"}], ",", 
           RowBox[{"Point", "[", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"#", "+", 
                 RowBox[{"3", " ", 
                  RowBox[{"(", 
                   RowBox[{"#", "-", "pt"}], ")"}], " ", 
                  RowBox[{"2", "^", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "5"}], " ", 
                    RowBox[{"Norm", "[", 
                    RowBox[{"#", "-", "pt"}], "]"}]}], ")"}]}]}]}], ")"}], 
               "&"}], ",", "g"}], "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "1.7"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->587740247],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`q$$ = 4.221569057273358, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`q$$], 0, 2 Pi}}, Typeset`size$$ = {180., {88., 92.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`q$3821$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`q$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`q$$, $CellContext`q$3821$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Module[{$CellContext`pt$ = {
           Cos[$CellContext`q$$], 
           Sin[$CellContext`q$$]}}, 
        Graphics[{
          PointSize[Small], 
          Point[
           
           Map[# + (3 (# - $CellContext`pt$)) 
             2^((-5) Norm[# - $CellContext`pt$])& , CompressedData["
1:eJyF20+KLVkRgPGnrsQtaDu7kHtwCYLaMzcjeNs/4DYciUOhdeLIkULCBcFB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            "]]]}, PlotRange -> 1.7]], 
      "Specifications" :> {{$CellContext`q$$, 0, 2 Pi, AnimationRunning -> 
         False, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {125., 130.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 257},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4347815]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12406],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotMarkers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotMarkers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PointSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PointSize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24560]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3839],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Primitives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]], "Tutorials",
 CellID->595610080],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "Tutorials",
 CellID->815154705],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Point",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Point"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->185150126],

Cell[TextData[ButtonBox["Graphics Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsObjects"]], "MoreAbout",
 CellID->50249718],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->96751891],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->837483891]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Point - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 10, 28.7293996}", "context" -> "System`", 
    "keywords" -> {
     "dot", "point", "pointillistic rendering", "graphics point", 
      "graphics dot"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Point[coords] is a graphics primitive that represents a point. \
Point[{coords_1, coords_2, ...}] represents a collection of points. ", 
    "synonyms" -> {}, "title" -> "Point", "type" -> "Symbol", "uri" -> 
    "ref/Point"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12333, 352, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->571230613]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 138406, 3339}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2908, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3531, 93, 4189, 83, 70, "ObjectNameGrid"],
Cell[7723, 178, 1031, 32, 70, "Usage",
 CellID->9488]
}, Open  ]],
Cell[CellGroupData[{
Cell[8791, 215, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9269, 232, 1034, 40, 70, "Notes",
 CellID->3477],
Cell[10306, 274, 305, 10, 70, "Notes",
 CellID->16714],
Cell[10614, 286, 291, 9, 70, "Notes",
 CellID->846],
Cell[10908, 297, 151, 4, 70, "Notes",
 CellID->30475],
Cell[11062, 303, 856, 31, 70, "Notes",
 CellID->15082],
Cell[11921, 336, 375, 11, 70, "Notes",
 CellID->27831]
}, Closed]],
Cell[CellGroupData[{
Cell[12333, 352, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->571230613],
Cell[CellGroupData[{
Cell[12718, 366, 148, 5, 70, "ExampleSection",
 CellID->517990702],
Cell[12869, 373, 57, 1, 70, "ExampleText",
 CellID->11093713],
Cell[CellGroupData[{
Cell[12951, 378, 185, 6, 28, "Input",
 CellID->384599799],
Cell[13139, 386, 238, 7, 121, "Output",
 CellID->3880399]
}, Open  ]],
Cell[13392, 396, 125, 3, 70, "ExampleDelimiter",
 CellID->556406487],
Cell[13520, 401, 58, 1, 70, "ExampleText",
 CellID->31786828],
Cell[CellGroupData[{
Cell[13603, 406, 442, 15, 28, "Input",
 CellID->101268031],
Cell[14048, 423, 491, 12, 81, "Output",
 Evaluatable->False,
 CellID->69177400]
}, Open  ]],
Cell[14554, 438, 124, 3, 70, "ExampleDelimiter",
 CellID->92325663],
Cell[14681, 443, 56, 1, 70, "ExampleText",
 CellID->638029486],
Cell[CellGroupData[{
Cell[14762, 448, 489, 16, 28, "Input",
 CellID->181275214],
Cell[15254, 466, 1982, 37, 141, "Output",
 Evaluatable->False,
 CellID->187688654]
}, Open  ]],
Cell[17251, 506, 125, 3, 70, "ExampleDelimiter",
 CellID->349546455],
Cell[17379, 511, 69, 1, 70, "ExampleText",
 CellID->105301427],
Cell[17451, 514, 413, 14, 70, "Input",
 CellID->583788358],
Cell[CellGroupData[{
Cell[17889, 532, 910, 27, 83, "Input",
 CellID->630768990],
Cell[18802, 561, 1573, 30, 59, "Output",
 Evaluatable->False,
 CellID->404742557]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20424, 597, 219, 7, 70, "ExampleSection",
 CellID->78583763],
Cell[CellGroupData[{
Cell[20668, 608, 240, 7, 70, "ExampleSubsection",
 CellID->574713873],
Cell[20911, 617, 57, 1, 70, "ExampleText",
 CellID->19036412],
Cell[CellGroupData[{
Cell[20993, 622, 185, 6, 70, "Input",
 CellID->823254087],
Cell[21181, 630, 240, 7, 121, "Output",
 CellID->662102289]
}, Open  ]],
Cell[21436, 640, 125, 3, 70, "ExampleDelimiter",
 CellID->180961554],
Cell[21564, 645, 58, 1, 70, "ExampleText",
 CellID->86360336],
Cell[CellGroupData[{
Cell[21647, 650, 416, 14, 70, "Input",
 CellID->91097190],
Cell[22066, 666, 266, 7, 121, "Output",
 CellID->323614526]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22381, 679, 232, 7, 70, "ExampleSubsection",
 CellID->3955787],
Cell[22616, 688, 71, 1, 70, "ExampleText",
 CellID->333605483],
Cell[22690, 691, 297, 11, 70, "Input",
 CellID->71789691],
Cell[CellGroupData[{
Cell[23012, 706, 430, 14, 70, "Input",
 CellID->388135036],
Cell[23445, 722, 870, 24, 77, "Output",
 CellID->9831777]
}, Open  ]],
Cell[24330, 749, 125, 3, 70, "ExampleDelimiter",
 CellID->897646445],
Cell[24458, 754, 61, 1, 70, "ExampleText",
 CellID->684693210],
Cell[24522, 757, 298, 11, 70, "Input",
 CellID->455326927],
Cell[CellGroupData[{
Cell[24845, 772, 408, 14, 70, "Input",
 CellID->617660970],
Cell[25256, 788, 710, 20, 78, "Output",
 CellID->291359940]
}, Open  ]],
Cell[25981, 811, 72, 1, 70, "ExampleText",
 CellID->30262912],
Cell[CellGroupData[{
Cell[26078, 816, 408, 13, 70, "Input",
 CellID->234987309],
Cell[26489, 831, 726, 20, 79, "Output",
 CellID->732045698]
}, Open  ]],
Cell[27230, 854, 125, 3, 70, "ExampleDelimiter",
 CellID->670714399],
Cell[27358, 859, 58, 1, 70, "ExampleText",
 CellID->704116176],
Cell[27419, 862, 296, 11, 70, "Input",
 CellID->1032683],
Cell[CellGroupData[{
Cell[27740, 877, 386, 13, 70, "Input",
 CellID->742855166],
Cell[28129, 892, 875, 24, 75, "Output",
 CellID->69017983]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29053, 922, 245, 7, 70, "ExampleSubsection",
 CellID->573582274],
Cell[29301, 931, 242, 9, 70, "ExampleText",
 CellID->21173097],
Cell[CellGroupData[{
Cell[29568, 944, 552, 18, 70, "Input",
 CellID->31772655],
Cell[30123, 964, 307, 9, 162, "Output",
 CellID->14431506]
}, Open  ]],
Cell[CellGroupData[{
Cell[30467, 978, 574, 18, 70, "Input",
 CellID->61274159],
Cell[31044, 998, 3017, 55, 194, 133, 3, "CachedBoxData", "BoxData", "Output",
 CellID->278859707]
}, Open  ]],
Cell[34076, 1056, 125, 3, 70, "ExampleDelimiter",
 CellID->572861043],
Cell[34204, 1061, 209, 8, 70, "ExampleText",
 CellID->6166460],
Cell[CellGroupData[{
Cell[34438, 1073, 563, 18, 70, "Input",
 CellID->284038649],
Cell[35004, 1093, 319, 10, 162, "Output",
 CellID->117462]
}, Open  ]],
Cell[35338, 1106, 124, 3, 70, "ExampleDelimiter",
 CellID->31232281],
Cell[35465, 1111, 249, 9, 70, "ExampleText",
 CellID->371331526],
Cell[CellGroupData[{
Cell[35739, 1124, 477, 15, 70, "Input",
 CellID->459813749],
Cell[36219, 1141, 296, 9, 163, "Output",
 CellID->508730510]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[36576, 1157, 222, 7, 70, "ExampleSection",
 CellID->1339],
Cell[36801, 1166, 228, 8, 70, "ExampleText",
 CellID->425117191],
Cell[CellGroupData[{
Cell[37054, 1178, 649, 21, 70, "Input",
 CellID->644909817],
Cell[37706, 1201, 3519, 62, 70, "Output",
 Evaluatable->False,
 CellID->519677998]
}, Open  ]],
Cell[41240, 1266, 125, 3, 70, "ExampleDelimiter",
 CellID->346079769],
Cell[41368, 1271, 225, 8, 70, "ExampleText",
 CellID->430832121],
Cell[41596, 1281, 1309, 41, 70, "Input",
 CellID->519405138],
Cell[CellGroupData[{
Cell[42930, 1326, 338, 12, 70, "Input",
 CellID->10405249],
Cell[43271, 1340, 28675, 474, 70, "Output",
 Evaluatable->False,
 CellID->130119689]
}, Open  ]],
Cell[71961, 1817, 125, 3, 70, "ExampleDelimiter",
 CellID->366408624],
Cell[72089, 1822, 59, 1, 70, "ExampleText",
 CellID->485596498],
Cell[72151, 1825, 1162, 36, 70, "Input",
 CellID->745223823],
Cell[CellGroupData[{
Cell[73338, 1865, 341, 12, 70, "Input",
 CellID->288281788],
Cell[73682, 1879, 7203, 122, 70, "Output",
 Evaluatable->False,
 CellID->469338991]
}, Open  ]],
Cell[80900, 2004, 124, 3, 70, "ExampleDelimiter",
 CellID->21799767],
Cell[81027, 2009, 84, 1, 70, "ExampleText",
 CellID->55477103],
Cell[81114, 2012, 4129, 134, 70, "Input",
 CellID->177473525],
Cell[85246, 2148, 224, 7, 70, "Input",
 CellID->8760494],
Cell[CellGroupData[{
Cell[85495, 2159, 610, 19, 70, "Input",
 CellID->733081931],
Cell[86108, 2180, 1017, 22, 231, "Output",
 CellID->452030750]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[87174, 2208, 233, 7, 70, "ExampleSection",
 CellID->21738],
Cell[87410, 2217, 213, 8, 70, "ExampleText",
 CellID->209367998],
Cell[CellGroupData[{
Cell[87648, 2229, 313, 10, 70, "Input",
 CellID->623717237],
Cell[87964, 2241, 2399, 46, 136, "Output",
 CellID->45231482]
}, Open  ]],
Cell[90378, 2290, 125, 3, 70, "ExampleDelimiter",
 CellID->131722856],
Cell[90506, 2295, 227, 8, 70, "ExampleText",
 CellID->165685061],
Cell[CellGroupData[{
Cell[90758, 2307, 527, 16, 70, "Input",
 CellID->74748353],
Cell[91288, 2325, 6601, 112, 70, "Output",
 Evaluatable->False,
 CellID->630766405]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[97938, 2443, 226, 7, 70, "ExampleSection",
 CellID->27124],
Cell[98167, 2452, 237, 7, 70, "ExampleText",
 CellID->306091572],
Cell[CellGroupData[{
Cell[98429, 2463, 396, 12, 70, "Input",
 CellID->116671014],
Cell[98828, 2477, 339, 11, 150, "Output",
 CellID->101825208]
}, Open  ]],
Cell[CellGroupData[{
Cell[99204, 2493, 394, 12, 70, "Input",
 CellID->255730262],
Cell[99601, 2507, 285, 10, 290, "Output",
 CellID->9382492]
}, Open  ]],
Cell[99901, 2520, 226, 8, 70, "ExampleText",
 CellID->233623084],
Cell[CellGroupData[{
Cell[100152, 2532, 403, 12, 70, "Input",
 CellID->204202000],
Cell[100558, 2546, 293, 10, 103, "Output",
 CellID->111364949]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[100900, 2562, 223, 7, 70, "ExampleSection",
 CellID->1005],
Cell[101126, 2571, 68, 1, 70, "ExampleText",
 CellID->14747443],
Cell[CellGroupData[{
Cell[101219, 2576, 599, 18, 70, "Input",
 CellID->442545438],
Cell[101821, 2596, 24266, 402, 70, "Output",
 Evaluatable->False,
 CellID->805543890]
}, Open  ]],
Cell[126102, 3001, 125, 3, 70, "ExampleDelimiter",
 CellID->474177224],
Cell[126230, 3006, 90, 1, 70, "ExampleText",
 CellID->130340021],
Cell[CellGroupData[{
Cell[126345, 3011, 1699, 49, 70, "Input",
 CellID->587740247],
Cell[128047, 3062, 5356, 102, 70, "Output",
 CellID->4347815]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133464, 3171, 311, 9, 70, "SeeAlsoSection",
 CellID->12406],
Cell[133778, 3182, 941, 35, 70, "SeeAlso",
 CellID->24560]
}, Open  ]],
Cell[CellGroupData[{
Cell[134756, 3222, 313, 9, 70, "TutorialsSection",
 CellID->3839],
Cell[135072, 3233, 197, 4, 70, "Tutorials",
 CellID->595610080],
Cell[135272, 3239, 197, 4, 70, "Tutorials",
 CellID->815154705],
Cell[135472, 3245, 162, 3, 70, "Tutorials",
 CellID->659944600]
}, Open  ]],
Cell[CellGroupData[{
Cell[135671, 3253, 305, 8, 70, "RelatedLinksSection"],
Cell[135979, 3263, 355, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[136371, 3280, 319, 9, 70, "MoreAboutSection",
 CellID->185150126],
Cell[136693, 3291, 142, 3, 70, "MoreAbout",
 CellID->50249718],
Cell[136838, 3296, 161, 3, 70, "MoreAbout",
 CellID->96751891],
Cell[137002, 3301, 197, 4, 70, "MoreAbout",
 CellID->837483891]
}, Open  ]],
Cell[137214, 3308, 50, 0, 70, "History"],
Cell[137267, 3310, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

