(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     63031,       1637]
NotebookOptionsPosition[     57291,       1440]
NotebookOutlinePosition[     58688,       1478]
CellTagsIndexPosition[     58602,       1473]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AbsolutePointSize" :> 
          Documentation`HelpLookup["paclet:ref/AbsolutePointSize"], 
          "Thickness" :> Documentation`HelpLookup["paclet:ref/Thickness"], 
          "Disk" :> Documentation`HelpLookup["paclet:ref/Disk"], 
          "PlotRangeClipping" :> 
          Documentation`HelpLookup["paclet:ref/PlotRangeClipping"], "Point" :> 
          Documentation`HelpLookup["paclet:ref/Point"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AbsolutePointSize\"\>", 2->"\<\"Thickness\"\>", 
       3->"\<\"Disk\"\>", 4->"\<\"PlotRangeClipping\"\>", 
       5->"\<\"Point\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Graphics Directives\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PointSize", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PointSize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PointSize"], "[", 
       StyleBox["d", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies that points \
which follow are to be shown if possible as circular regions with diameter ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     ". The diameter ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " is given as a fraction of the total width of the plot. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29023]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PointSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PointSize"]], "InlineFormula"],
 " can be used in both two\[Hyphen] and three\[Hyphen]dimensional graphics, \
as well as in ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " specifications. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->1476],

Cell[TextData[{
 "The following symbolic forms for ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " can be used: ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 ". These specify absolute point sizes independent of the total width of the \
graphic. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->9963]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->38474970],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->701633082],

Cell["\<\
Specify the point sizes as a fraction of the total width of the graphic: \
\>", "ExampleText",
 CellID->350973787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "r", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.02", ",", "0.05", ",", "0.1", ",", "0.3"}], "}"}]}], "}"}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337080148],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {PointSize[0.02], PointBox[{0, 0}]}], ",", 
   GraphicsBox[
    {PointSize[0.05], PointBox[{0, 0}]}], ",", 
   GraphicsBox[
    {PointSize[0.1], PointBox[{0, 0}]}], ",", 
   GraphicsBox[
    {PointSize[0.3], PointBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->646701371]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "r", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.02", ",", "0.05", ",", "0.1", ",", "0.3"}], "}"}]}], "}"}]}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->956986626],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {PointSize[0.02], Point3DBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydmG1PE0EQgK/tXSkFLLQWitS2gogiiIgCkhgTP+gnf0SDTSDRaJC/f9Hd
vbm+PDu025L0uLmdeW5vd2Z2dr/3728Gv/r3t9f93re7/p+b2+u/va+/78yj
UiGKoh/m97MVmft/5s79vqRpGpUGg0Hq/qKuvUSfzTUxD3tO+mSuRSOV5H/2
9MpcrWEyRjBXIVyKbkVtPZfWqpXi4dvNTce1nwl71UrJsF0YT53OqTBqU3RO
RKeu6rSdzpG86zFGogh522kfCnErSPtA2NtoLUFuOe19YbeDtPdEu4PWGLLr
adSTnvTQmkDedNodYe8Fae8Iex+tZchNp70t7JdB2luifYjWJchu9tzVPjxC
awVyw2nXhX0SpL0u2qdoXYbsfC1ak56cobUKecNprwj7PEh7WbQv0boCed1p
V0T7agZ7pD0erx9nvKM2spqIY/ZtFfKjkZ0XlxfhtlMi8D3kNU32/IjRw/kL
ozBO3mlfwC/0KIwIel5NmxuPQvntQhSONmNmHXJVpTBW3kDe0PS9caAPHi9E
oVcxZ9S1EfAo9IfXC1HoD8x2DchLKoUz+QoyV7iySuFMMk/rFHo8v5sU+xab
MCqqNb/3QBl1KzJaE5XGHr+AvCx9UaN4blpZ+kYv1WlNyFxDS0Kjh+i0TcjP
STO3jA6dxPpmL9WrpMya88B6pysjzP7p1k8g5/UF6yCOXazSdpQvs6Jab8yk
sTZrCI2ZLYz2FHItHat756axElwRGvOCTuPoslJcEhojO4z2DHLu17QOo+2O
yeYaFYfRa/Y0osOICSOz4rXUooHaMbRvaSnfMZvSlK9ljcI+hdHqqe7BjM2M
xncyJ+Q+x3qQOTiMZn0uVvIVvSaMVkl1n1uMlgiNWYgZMYxWFBqzFWnFB2nJ
wN+9cfXVrXfl3fQMRnpm7T4oe+jiUPPEXcicP5/USfU1mH2aTcrzO9dfjjhr
LZ9kc3us+DJXVeZXn5TvJNl7rvYkFTzShpDoF6xpWC/kpMmR1Nbg+UlVGSeu
8qzSOI4+KV8VuMqy9uT66JNiITEiWAtzJyKk0e5TOFxxWJnT2zKOxdDvwiyn
+Rv3FpZQMKK1nPQYu5rRmvubsmc9bX20t9xnJR7Bjr5d32jJfV7sWXIV6s5N
4HjSA7hjLXmE/IyDltwxFz1Lejj9mDv3ccLo3IZW7tQgGfdIO6+ZDbMYKwp3
bjFxlpLZMRMxdh+yyysX6n8Yk0e9Y5ZirslPbjPt/ASNWhcTo8RWvsP2pDTU
bgqTWnYu43y98b6eo3Ocju8vOcbM2jZb2enKzmHyE0pq7QszO4XjnDPD9YSZ
nWO2hUmttjBdFeF5PmOrJdrZKXlXmNRqyJtdLKuVN2sGy3SriJc5WCfk9Z3L
icMzaGqVpQcu9ifymfW0WBjOY92KWh7IiWEUFf4DE/DxsA==\
\>"]], ",", 
   Graphics3DBox[
    {PointSize[0.05], Point3DBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydmW1PE0EQgK+9KwUKUsr7W1tAFBFERAU1xsQP+skf0ZAmkGg0yN+/6O3s
bHt9dtMuJeHo3M48u92dnZldfvQebvu/eg93N73u9/ven9u7m7/db7/vi1dp
JUmSfvH7czMpPv8rPsnv1zzPk7Tf7+fyk3TNI/lSPGvFy32RPhfPaiGl+te+
/aRSrUQonkq4Lp7mZd1I2YBffOhI+3u1bsDatl6q9aJn3Zb2C7VuGqk2aFfG
nuicq05rjM6p9rOKWahC3hbtEyVuRGkfq/YWWlPI0p4c6Uh20JpB3hTtQ2W3
o7S7yu6itQZZvlfSVvZhlPauah+hdQbyumhv6Uieo7UOeU20N5R9EqW9ptqn
aJ2FLGudtHQkr9A6B3lFtJvKvojSXlT22wna4plJQ9lXUdpzqv0BrfOQl0V7
VrU/orUBuTnQLu9F9jHGamSPXkNvAfLS0M7bl5yFMbZjdiBnfhHykyCFO/My
ZEWq543cJ2+monD/0POWQvPkUSi/norCeTqH3ITcCFLoz9x5y5DngxT6+VkU
hbNJr2LMaIXG7lHoVS8hr4Tm0aPQH0jhWMIUriRjJsdSD1K4ki+monANjgO9
GFE2nH2tJO4d9se84SIt895MkMYs/wzyfF6qWSbS1iAzA9aVRo8N09YhP4Wc
5aWKaCKNFYrk8mGMVhZXO8zahHxQPAyKaxO2ZvXTVmuOUOy8+oXV0LaOnJGa
axGm7Qbm3Ij03zjaHmRXUTDOxdFYyT1RGiNVHK0D2Xk2o8R0NOfZjExhGtdq
H3KaD9c0TRIvBpGaBakHJdmEFncyyaYmsv41XlIraGZlQqeAeIoZk8mRGWIg
Y0Ac0WbnAonVoVcz+sXRl/JwFOPutzTWYYxiC0pjzqMnxdFmdQ5pzfwTR6vp
2LgKpKdRtKrStieMbTLNeTMjBL06THLR+gDvGQnC1h39FiHquBrG0sq+3VYS
8wP9jfnNJ+0oiVXp40kbOjc813AtSap6pNU8HF9ZEzCa+6TlPBxbWatwzD7J
ZRDue1Zj3NmONNpXGoh4jyfVdca5K1hnMof6JFcPcVew7g2eFBO/FmJWYhVO
TkU4BkNv4VmC1WTF+y70klhCLmtt4gMJPBUxF1jCuBxqPvKExr2rc5DbfEhr
nhJZVVhrjoy1Bk+sHLOl1HUM01nT21gn8uxtKJVCNNaWQM9n3co7gKpHcLdA
tJQ7iFrZWyUfiA3jEit1uQUZuZmxdq6Cof67kjzsZVL1FLZinmMUcve/Vrul
ErWu9L2dI7ayDzOSbKDt7gOpdaFa4s3eSYmZ7Ey17Q3ApjKpZSKhWSR7l8Po
Fsovg7rF8xX6Ule17Q2qu28NeVzNRVbvNMEI4jKfvW3vKJNaK6olmTVYt7Oi
MCOQM7rEEvc/A86FYUqMs5l2xEPntF127khcM76VaR/i2ZITZ/p6F5oklf+V
jhBo\
\>"]], ",", 
   Graphics3DBox[
    {PointSize[0.1], Point3DBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylmFtPE0EUgKc3Slu5lIstFGgRUUARUQSMMTE+6JM/oiFNINFokL+/0Z0z
Z8vyzZFusQmlZ+fMN7Mz5zbzbXhzOfoxvLm6GA6+Xg9/XV5d/B58+XmdPqqU
nHOj9O9716W//6S/5O9zkiSuMhqNEvm4gf9yn9LvavpwW6SP6bdXqaT/y+n/
oPNBpZk7T89VdzbHTb9dX1pPVbdltp5o65yXquM5pT+2pP1Y2Qteqo3blbEp
OkfKWLpH51B1VvDuZcjron2goz5GawXymmjvKXutkPausntorULuivaOsrcK
aW/n9yXXWoPcEe0tnckTtM5AllVwG8reLaS9puznaK1DXhXtjrIPCmmvqvbh
BG3Za7ekMzlC6yzkZdFeVPabQtrzqn2C1gZksUzX0pmcorUJuS3aDWW/L6yd
f3oOuQV5UXrRYznWPb3u+CpHewR54bZf5J9n0J2DPB/NNDH8ljtQjEIPfWv1
IjWi0BdpOzaF1ko/OrbWkGscUSi/hrwIuWVS+Ib0nWIU2uQryG3ITZNCe59E
aZgUWjJjh03hntCqXkJestYxotAeXjyIQntg7FyGXDcp3Ml9g+KjkD0Hrtqe
QfeiOFp4/I958J2ZN+aURF+bMWl892eQm0ozfTDKlquQmQHrSqOl2jTWFE8h
V5VGW7NpHcg7gsjHWN/IXbZZXci+LvAo1kw1szern76OzRnavdch97Q34zz3
ItBoFRvGmvs3mbSzNm0TclZRML4Vo7GSC7kyrcuTkA/H1TArmYnkPmTvszMp
mJGiGI015NjHXPjUnIsiGVegapK3IZez9UyJfHObyLztrd7vr3/+fxRqeZrf
obJhydNRZnWOtGjuxnTUmq4dI+DDqJ5Wd0HPimiMq8Wofm7eWkR9lH1oO2RX
CrEbOlPmD8qBxrVn7K3pHjFGM88Vo2V2zdg2PS2LC4wdjOs2aSexz3mMC3bv
vq5JPodzF7iXNmlD58EoTBq9N9Dy42fZgXUqd4CkckTqKon14fSkFV0nrgWr
BZ6NYlI7sW2aVQznHJPmlcT4x+qKfh6TsrMrawRWfMyJGen2SV3Xifcf05Oy
Sol5jzUsSaVAiqok+gcralpb4HgMrYXnAtaZoaf3aO4pzyWM69oTT+lBxSiM
rXx/nrTot/r+SciO7M0zI6uA0Jsz417y/OoppVT0vQOhruOzJ8/Plagn7YJV
42RCU8dmT94AlKOejAKsnuUmopa3UMkB0pexiD4pdyF37mdCv+y2ivrvcvLt
KMwtjCHZvW7QbqtkaeXZ4e2Z6xnpzpQWtFeS3P0u2JWxFnM2s5vfTb+goWZh
Lceo7T3IL2G4B+jqDKi1r1rhRod53sopfgbhxq6XxPfi/ucgydUg0dmDMain
zHBvzfqAcaej7HD33tcZUGtZtSSqRNU6/XheZyA5RWJIeRSf05vKlMgYsmtk
3VmFLD4vedOT8lmorGOJhUsW85LcWjpX+gue/Qgc\
\>"]], ",", 
   Graphics3DBox[
    {PointSize[0.3], Point3DBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVme1PE0EQh5de3ygWKOWlFFqKvAgoIoogMSbGD/rJP4KQJpBoNMi/f9Gd
3Slcn92jB98kQW5uf/vc3N7szO76/eL2avjz4vb68mLw7ebi99X15Z/B1183
9lYyZYwZ2t8fHWOv/9or9/slTdPScDjctH+N+ayWSeyF/Ss3B67lk/03sXcS
Vfi7H9Wqjt09V6suVuIxAt1wradKaohV9q1e0HftJ9q7mdN+rP3nxKrctesz
ek5zpIyFjAdyWYLddepDVS8WUh/o85fRmsBedeo9Za8WUu+qeg2tZdgdp95S
T3porcBecerN7DeaqO4r+zlaq7DdKJh1Ze9OYHt1V9V7E9hLTr2inhygtQbb
fT3XR9iHhdRtVR+htQ677dTz6slxIfWssk/QOg3bxaiZUfYpWhuwW049rezz
wurs3Q+wZ2DPP/iMZ7DdPPRjMDZb+ZQH+gWz+AzaJuzZ+74PzFeOfDEKZ+a7
WC9SAwpn7NvY23N0AgrnDyMvTmGs055EmYlS6NubJ1EYi5x587AbUQrj/DXs
VuypAYVxz5xRjMK4fgWbNciNY5DrGFUvYbdh16IUfgPmzGIUfoP9COWuvge9
OWrM8qMsml1jxP3gyLnKlNhVi9qcz00lc+5Vo3SOhfjdMCaIioZS+d3jVK4h
xKc5E+bgWppZBQXUaN1E5C6YMBbLSmU0VaLUFdji46LRd7rP5crkd40zO5H3
XDZeJ0iOT5zC1ZK0dyylpL7Q8zilC1sCblUoQ7+Ofei7xYlcl4k/XUtkxMVp
VPVIfzKpn7EtxJGKvSFJGyPb+J9uhLQEu5xL6v0XvakaaG/5uqVItOX3Wpdn
2ltciXDs8wkS5WWXHe/zHHXMXPm0JfWnYsJYpk9JlCK7hpZS6mZyFs2nzCpF
cizXEsz0+ZSGjk8zklOZoTyF30J2TVX1Rd6MGZjVL5+SKKUdqRqPoFhTvhOr
GWt5nDBIx6upzFnJ4exNuxSlyT6ujAoqRKk1HF3WmDhxVf3D/sD+zBsTRA/H
wDOzK4WO8jjeopSYYKXk6iwkLqX5NbNmpaxFk4ktHUWOGHfHsXcYJ82qb8xb
L2AzhkPSaH/J+szVGedUSKoribWQq0SSppQ0nrdknPpPIwUrFJ5VcPXLrOM5
gtlBC1ffXGf5nlIb+CW4+me+1J64uw2bOxHmbk8ZncU9rTfvbsLmnkr0U9aU
3p7Ad+PJEvd25YBQ0zfYgJI71CToyZhYh839dikgNPTZj+/JDMAM4U4MKtno
lMTsZ1IzjZ8HurOKsfMTr2feZn57H/TzPrL+MINkz5nEO9+rpd5Rfab3vYpZ
m9V7XL2Yxs9iR+fAXsX34ntLRFRGlcntXIRJlUS+DIbfqU/K3Puq9ic43C0w
O2+rB/5MbU09oGqgTH/S2UMrM9Co3vqT5X4anpvL5Yo+2Z9/Tzq/bStzy6lH
p75UzanK5S+3DgmyPuqLeODyos9WQXzXlejOhcxOGv5PQqIKF+uuhlWHek5o
zNQ/QJqcLg==\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->91870151]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->345355434],

Cell[TextData[{
 "Set the sizes of points in plots using ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17948056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{"5", ",", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "0.03", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->865203689],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointSize[0.03], 
    PointBox[{{1., 2.}, {2., 4.}, {3., 3.}, {4., 4.}, {5., 4.}, {6., 0.}, {7.,
      5.}, {8., 2.}, {9., 2.}, {10., 2.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {0., 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275698380]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7975],

Cell["Symbolic values for predefined absolute point sizes:", "ExampleText",
 CellID->391795552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "r", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->565490267],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {PointSize[Tiny], PointBox[{0, 0}]}], ",", 
   GraphicsBox[
    {PointSize[Small], PointBox[{0, 0}]}], ",", 
   GraphicsBox[
    {PointSize[Medium], PointBox[{0, 0}]}], ",", 
   GraphicsBox[
    {PointSize[Large], PointBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->426402853]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19096],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PointSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PointSize"]], "InlineFormula"],
 " defines the point size as a fraction of the total width of the graphic:"
}], "ExampleText",
 CellID->700468751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", "0.5", "]"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181254742],

Cell[BoxData[
 GraphicsBox[
  {PointSize[0.5], PointBox[{0, 0}]},
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1660582]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134153521],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsolutePointSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsolutePointSize"]], "InlineFormula"],
 " defines the point size in units of printer's points:"
}], "ExampleText",
 CellID->107669690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"AbsolutePointSize", "[", "15", "]"}], ",", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<15 points\>\"", ",", "Black", ",", 
        RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.3"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->468146],

Cell[BoxData[
 GraphicsBox[
  {AbsolutePointSize[15], PointBox[{0, 0}], InsetBox[
    StyleBox["\<\"15 points\"\>",
     StripOnInput->False,
     FrontFaceColor->GrayLevel[0],
     BackFaceColor->GrayLevel[0],
     GraphicsColor->GrayLevel[0],
     FontSize->15,
     FontColor->GrayLevel[0]], {0, 0.3}]}]], "Output",
 ImageSize->{184, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->423884547]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17016],

Cell["Large points can be clipped by a frame: ", "ExampleText",
 CellID->394082784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", ".05", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165494616],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointSize[0.05], 
    PointBox[{{1., 1.}, {2., 1.}, {3., 0.}, {4., 1.}, {5., 1.}, {6., 0.}, {7.,
      0.}, {8., 0.}, {9., 1.}, {10., 0.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 10.}, {0., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12112938]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["PlotRangeClipping",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangeClipping"]], "InlineFormula"],
 " to control clipping at the PlotRange boundary:"
}], "ExampleText",
 CellID->90243826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", ".05", "]"}]}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37721937],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointSize[0.05], 
    PointBox[{{1., 1.}, {2., 0.}, {3., 0.}, {4., 0.}, {5., 1.}, {6., 0.}, {7.,
      0.}, {8., 0.}, {9., 0.}, {10., 0.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {0., 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->223241901]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192343460],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PointSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PointSize"]], "InlineFormula"],
 " is a scaled size that refers to the width of the graphic:"
}], "ExampleText",
 CellID->306091572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", "0.5", "]"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "0.2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116671014],

Cell[BoxData[
 GraphicsBox[
  {PointSize[0.5], PointBox[{0, 0}]},
  AspectRatio->0.2,
  Frame->True]], "Output",
 ImageSize->{154, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->155172741]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", "0.5", "]"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->255730262],

Cell[BoxData[
 GraphicsBox[
  {PointSize[0.5], PointBox[{0, 0}]},
  AspectRatio->5,
  Frame->True]], "Output",
 ImageSize->{73, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->270463216]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["AbsolutePointSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsolutePointSize"]], "InlineFormula"],
 " to control the size: "
}], "ExampleText",
 CellID->233623084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AbsolutePointSize", "[", "15", "]"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "0.2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->204202000],

Cell[BoxData[
 GraphicsBox[
  {AbsolutePointSize[15], PointBox[{0, 0}]},
  AspectRatio->0.2,
  Frame->True]], "Output",
 ImageSize->{184, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->886897390]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
      RowBox[{"PointSize", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0.1"}], "}"}], "]"}], "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", "2", "}"}]}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "200", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488596850],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->822560394]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23529],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsolutePointSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsolutePointSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thickness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thickness"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Disk",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Disk"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRangeClipping",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRangeClipping"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Point",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Point"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9266]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14177],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "Tutorials",
 CellID->815154705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with PointSize",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=PointSize"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->208132870],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->478817413]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PointSize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 10, 30.3388158}", "context" -> "System`", 
    "keywords" -> {"size of points", "styling of points"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PointSize[d] is a graphics directive which specifies that points which \
follow are to be shown if possible as circular regions with diameter d. The \
diameter d is given as a fraction of the total width of the plot. ", 
    "synonyms" -> {"point size"}, "title" -> "PointSize", "type" -> "Symbol", 
    "uri" -> "ref/PointSize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9796, 263, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->38474970]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 58460, 1466}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2254, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2877, 81, 4193, 83, 70, "ObjectNameGrid"],
Cell[7073, 166, 792, 22, 70, "Usage",
 CellID->29023]
}, Open  ]],
Cell[CellGroupData[{
Cell[7902, 193, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8380, 210, 523, 16, 70, "Notes",
 CellID->1476],
Cell[8906, 228, 853, 30, 70, "Notes",
 CellID->9963]
}, Closed]],
Cell[CellGroupData[{
Cell[9796, 263, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->38474970],
Cell[CellGroupData[{
Cell[10180, 277, 148, 5, 70, "ExampleSection",
 CellID->701633082],
Cell[10331, 284, 124, 3, 70, "ExampleText",
 CellID->350973787],
Cell[CellGroupData[{
Cell[10480, 291, 479, 16, 28, "Input",
 CellID->337080148],
Cell[10962, 309, 491, 16, 123, "Output",
 CellID->646701371]
}, Open  ]],
Cell[CellGroupData[{
Cell[11490, 330, 495, 17, 28, "Input",
 CellID->956986626],
Cell[11988, 349, 6728, 124, 131, "Output",
 CellID->91870151]
}, Open  ]],
Cell[18731, 476, 125, 3, 70, "ExampleDelimiter",
 CellID->345355434],
Cell[18859, 481, 223, 8, 70, "ExampleText",
 CellID->17948056],
Cell[CellGroupData[{
Cell[19107, 493, 299, 9, 70, "Input",
 CellID->865203689],
Cell[19409, 504, 568, 17, 146, "Output",
 CellID->275698380]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20026, 527, 215, 7, 70, "ExampleSection",
 CellID->7975],
Cell[20244, 536, 95, 1, 70, "ExampleText",
 CellID->391795552],
Cell[CellGroupData[{
Cell[20364, 541, 487, 16, 70, "Input",
 CellID->565490267],
Cell[20854, 559, 497, 16, 123, "Output",
 CellID->426402853]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21400, 581, 233, 7, 70, "ExampleSection",
 CellID->19096],
Cell[21636, 590, 251, 7, 70, "ExampleText",
 CellID->700468751],
Cell[CellGroupData[{
Cell[21912, 601, 344, 11, 70, "Input",
 CellID->181254742],
Cell[22259, 614, 274, 9, 163, "Output",
 CellID->1660582]
}, Open  ]],
Cell[22548, 626, 125, 3, 70, "ExampleDelimiter",
 CellID->134153521],
Cell[22676, 631, 248, 7, 70, "ExampleText",
 CellID->107669690],
Cell[CellGroupData[{
Cell[22949, 642, 545, 16, 70, "Input",
 CellID->468146],
Cell[23497, 660, 449, 14, 64, "Output",
 CellID->423884547]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23995, 680, 226, 7, 70, "ExampleSection",
 CellID->17016],
Cell[24224, 689, 83, 1, 70, "ExampleText",
 CellID->394082784],
Cell[CellGroupData[{
Cell[24332, 694, 298, 9, 70, "Input",
 CellID->165494616],
Cell[24633, 705, 545, 16, 141, "Output",
 CellID->12112938]
}, Open  ]],
Cell[25193, 724, 258, 8, 70, "ExampleText",
 CellID->90243826],
Cell[CellGroupData[{
Cell[25476, 736, 357, 10, 70, "Input",
 CellID->37721937],
Cell[25836, 748, 541, 16, 141, "Output",
 CellID->223241901]
}, Open  ]],
Cell[26392, 767, 125, 3, 70, "ExampleDelimiter",
 CellID->192343460],
Cell[26520, 772, 237, 7, 70, "ExampleText",
 CellID->306091572],
Cell[CellGroupData[{
Cell[26782, 783, 396, 12, 70, "Input",
 CellID->116671014],
Cell[27181, 797, 295, 10, 83, "Output",
 CellID->155172741]
}, Open  ]],
Cell[CellGroupData[{
Cell[27513, 812, 394, 12, 70, "Input",
 CellID->255730262],
Cell[27910, 826, 241, 9, 237, "Output",
 CellID->270463216]
}, Open  ]],
Cell[28166, 838, 226, 8, 70, "ExampleText",
 CellID->233623084],
Cell[CellGroupData[{
Cell[28417, 850, 403, 12, 70, "Input",
 CellID->204202000],
Cell[28823, 864, 250, 9, 71, "Output",
 CellID->886897390]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29122, 879, 224, 7, 70, "ExampleSection",
 CellID->26905],
Cell[CellGroupData[{
Cell[29371, 890, 599, 18, 70, "Input",
 CellID->488596850],
Cell[29973, 910, 23872, 395, 70, "Output",
 Evaluatable->False,
 CellID->822560394]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53906, 1312, 311, 9, 70, "SeeAlsoSection",
 CellID->23529],
Cell[54220, 1323, 1209, 44, 70, "SeeAlso",
 CellID->9266]
}, Open  ]],
Cell[CellGroupData[{
Cell[55466, 1372, 314, 9, 70, "TutorialsSection",
 CellID->14177],
Cell[55783, 1383, 197, 4, 70, "Tutorials",
 CellID->815154705]
}, Open  ]],
Cell[CellGroupData[{
Cell[56017, 1392, 305, 8, 70, "RelatedLinksSection"],
Cell[56325, 1402, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56725, 1419, 319, 9, 70, "MoreAboutSection",
 CellID->208132870],
Cell[57047, 1430, 149, 3, 70, "MoreAbout",
 CellID->478817413]
}, Open  ]],
Cell[57211, 1436, 50, 0, 70, "History"],
Cell[57264, 1438, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

