(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    978475,      19063]
NotebookOptionsPosition[    951503,      18127]
NotebookOutlinePosition[    953029,      18168]
CellTagsIndexPosition[    952941,      18163]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Special Plots" :> 
          Documentation`HelpLookup["paclet:tutorial/SomeSpecialPlots"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Some Special Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListPolarPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListPolarPlot"], 
          "ParametricPlot" :> 
          Documentation`HelpLookup["paclet:ref/ParametricPlot"], 
          "RevolutionPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/RevolutionPlot3D"], 
          "SphericalPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/SphericalPlot3D"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ListPolarPlot\"\>", 
       2->"\<\"ParametricPlot\"\>", 3->"\<\"RevolutionPlot3D\"\>", 
       4->"\<\"SphericalPlot3D\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "New in 6.0: Function Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FunctionVisualization"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Function Visualization\"\>", 
       2->"\<\"New in 6.0: Function Visualization\"\>", 
       3->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PolarPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolarPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolarPlot"], "[", 
       RowBox[{
        StyleBox["r", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["\[Theta]", "TR"], ",", 
          SubscriptBox[
           StyleBox["\[Theta]", "TR"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["\[Theta]", "TR"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a polar plot of a curve with radius ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " as a function of angle ",
     Cell[BoxData[
      StyleBox["\[Theta]", "TR"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolarPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolarPlot"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["\[Theta]", "TR"], ",", 
          SubscriptBox[
           StyleBox["\[Theta]", "TR"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["\[Theta]", "TR"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes a polar plot of curves with radius functions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The angle ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " is measured in radians, counterclockwise from the positive ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis. "
}], "Notes",
 CellID->3469382],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " position corresponding to ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", " ", 
    RowBox[{"cos", "(", "\[Theta]", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", " ", 
    RowBox[{"sin", "(", "\[Theta]", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". The value of ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " need not be between 0 and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->49764058],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolarPlot"]], "InlineFormula"],
 " treats the variable ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " as local, effectively using ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24417],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolarPlot"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", and evaluates functions only after assigning specific numerical values to \
",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->29397],

Cell[TextData[{
 "In some cases it may be more efficient to use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to evaluate functions symbolically before specific numerical values are \
assigned to ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->8125],

Cell[TextData[{
 "No curve is drawn in any region where a function evaluates to ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->41],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolarPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes: "
}], "Notes",
 CellID->7406],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw axes ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AxesOrigin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AxesOrigin"], 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], Cell[
    "the origin where axes cross", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to determine the coloring of curves ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunctionScaling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunctionScaling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to scale arguments to ",
     Cell[BoxData[
      ButtonBox["ColorFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EvaluationMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EvaluationMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "expression to evaluate at every function evaluation ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Exclusions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exclusions"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "points in ",
     Cell[BoxData[
      FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
     " to exclude"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ExclusionsStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExclusionsStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what to draw at excluded points ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxRecursion",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxRecursion"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of recursive subdivisions allowed ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Mesh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mesh"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how many mesh points to draw on each curve ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeshFunctions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshFunctions"], 
    RowBox[{"{", 
     RowBox[{"#3", "&"}], "}"}], Cell[
    "how to determine the placement of mesh points ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeshShading",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshShading"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to shade regions between mesh points ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeshStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the style for mesh points ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method to use for refining curves", "TableText"]},
   {Cell[" ", "TableRowIcon"], 
    ButtonBox["PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PerformanceGoal"], 
    ButtonBox["$PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$PerformanceGoal"], Cell[
    "aspects of performance to try to optimize", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "initial number of sample points ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the range of values to include", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRangeClipping",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangeClipping"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to clip at the plot range ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives to specify the style for each curve ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RegionFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RegionFunction"], 
    RowBox[{"(", 
     RowBox[{
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"], "&"}], ")"}], Cell[
    "how to determine whether a point should be included", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision used in internal computations ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True}}}},
 CellID->11410],

Cell[TextData[{
 "Interactive labeling can be specified for curves using ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Annotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Annotation"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28463],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolarPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolarPlot"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Tooltip",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tooltip"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["f", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["f", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["\[Theta]", "TR"], ",", 
      SubscriptBox[
       StyleBox["\[Theta]", "TR"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["\[Theta]", "TR"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " specifies that the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " should be displayed as tooltip labels for the corresponding curves. "
}], "Notes",
 CellID->32048],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["label", "TI"]}], "]"}]], "InlineFormula"],
 " specifies an explicit tooltip label for a curve. "
}], "Notes",
 CellID->4690],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolarPlot"]], "InlineFormula"],
 " initially evaluates functions at a number of equally spaced sample points \
specified by ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 ". Then it uses an adaptive algorithm to choose additional sample points, \
subdividing a given interval at most ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " times. "
}], "Notes",
 CellID->4969],

Cell[TextData[{
 "You should realize that with the finite number of sample points used, it is \
possible for ",
 Cell[BoxData[
  ButtonBox["PolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolarPlot"]], "InlineFormula"],
 " to miss features in your function. To check your results, you should try \
increasing the settings for ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5344],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"], "[", 
   RowBox[{"PolarPlot", "::", 
    StyleBox["accbend", "TI"]}], "]"}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["PolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolarPlot"]], "InlineFormula"],
 " print a message if it is unable to reach a certain smoothness of curve."
}], "Notes",
 CellID->40938333],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolarPlot"]], "InlineFormula"],
 " will explicitly draw a point at every position on each curve where each \
function was sampled. "
}], "Notes",
 CellID->28599],

Cell[TextData[{
 "The arguments supplied to functions in ",
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 " are ",
 Cell[BoxData[Cell[TextData[{
   Cell[BoxData[
    StyleBox["x", "TI"]], "InlineFormula"],
   ", ",
   Cell[BoxData[
    StyleBox["y", "TI"]], "InlineFormula"],
   ", ",
   Cell[BoxData[
    StyleBox["\[Theta]", "TR"]], "InlineFormula"],
   ", ",
   Cell[BoxData[
    StyleBox["r", "TI"]], "InlineFormula"]
  }], "TableText"]],
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
    "RowsIndexed" -> {}}}],
 ". Functions in ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " are by default supplied with scaled versions of these arguments. "
}], "Notes",
 CellID->14643],

Cell["The functions are evaluated all along each curve. ", "Notes",
 CellID->10155],

Cell[TextData[{
 "With the default settings ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exclusions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exclusions"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExclusionsStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExclusionsStyle"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolarPlot"]], "InlineFormula"],
 " breaks curves at discontinuities it detects. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exclusions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exclusions"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " joins across discontinuities."
}], "Notes",
 CellID->131709506],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolarPlot"]], "InlineFormula"],
 " normally returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      ButtonBox["Line",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Line"], "[", 
      StyleBox["\[Ellipsis]", "TR"], "]"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14537]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->492602635],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->283694230],

Cell["Make a polar plot: ", "ExampleText",
 CellID->156902310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"3", "t"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40083349],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9106892]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47427109],

Cell["Make several polar plots: ", "ExampleText",
 CellID->272734889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"1", "/", "10"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"10", "t"}], "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175386796],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->682596414]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1361751124],

Cell["Style the curves:", "ExampleText",
 CellID->1217914989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"1", "/", "10"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"10", "t"}], "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Green", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Dashed", ",", "Thick", ",", "Orange"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1830580566],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95747394]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sampling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->74545675],

Cell["More points are sampled when the function changes quickly:", \
"ExampleText",
 CellID->269159930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"12", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172764079],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->405328006]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130517886],

Cell["The plot range is selected automatically: ", "ExampleText",
 CellID->582383891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "\[Theta]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11813271],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFnM9rXVUQx2+T95L+StM2/ZGkrUl/2NY/QlyIioiIoLgQF7EI7UIrtW50
oxu70Y1uLEi78Af4Y1ERKkIFsSAWigWxUFSQChIXFsHioiDE79y5735fJ3Pf
m8l7bQNJ7nnvnM+ZM2dmzo977n104fjh555fOH7k0ML8Q8cWXjx85NBL8w8e
PYaPRlcVRXEUv1emC1wv4ar8Pbq0hP9r5e/offeeXCp/ipHTpy7eU34mefSz
g/Jn7ML3v798/Kx+9NSTHy0u/jOWJHx59sqJN75pILRrwudnLr/15vliIIZm
a2B8+smP77z9XV+GNrhkCELKSttGSqaWKwt4ZS/98MfRF75w6w8zLv/055HD
ZxragNahjX3bgM/x7S1koJVoa1/G9es3Hnn49GAM/OC6gfHM0x9fvfp3A2Os
m/H4Y+9fu/bvPK5agLRcWt0zfWla7+4uStFI7S7Xm6oamW2QcdSkD5TpGzf+
e+D+9+Syh3XdVAusGza+19CktCSVqp2foapVedTlMufpiAyID9J7RYu05TpS
vrphH36rmy/eKb05AlTbZdZxMCyzBrSDLq2OZ2GalvBpdWQL01RDPg0oADM0
DVk+rY42YZpah0979ZWvzn/7W4am/iE0WjeEhch9KN1jW5lGJEM8k8v9rmyk
ZKjM5VNZa4Zax9YGarMUvaivv3bu63O/elRN069HE1RaiE9V68pST7574cMP
LjVTYUYwpiyVnuZT1eezVMriUSU2tRI06ktKC2y/0XNGNvap32IdTeLUUZO+
26UeevazX37+K0vVMb6ZikCAcJClMlpYqqY5Asd6San0JZ+K6QUmGVkqrd6n
chTLUGnVPpXfZ6iUxaeyLRkqzAbG06GM1NZPfWdo7FtfRtppjKq5aKf7XCpj
fobKmG+pmtbJeE0JUhk1fCqjTZwqEc3qU2noInRUVkbGT09GqW0sQaMF+S2m
JWVkpCX5VFpSjGpz2Zn3PmNJGSpnWUIVH1IajBamK5cxfbYr7dsW7zW9Fqd1
l7It1jRH6AyV0danss9jVM3F8WaPS61XrykqLcVSNU0/H09QdYUllzuWdNZg
11ZKp3dk6BwhdhqqXdXuMb2YqYWybVmKraG1Nsa4WG3jpnd3OLVI7bsNLUNn
NPfo3Wmthb65OlELx9hYLfS+TC0sJXsb3hpb6Vx5Zui0990ulfO3GFVz0cvm
DVXT6HrUir/FmgSVLfSpnBNlqCzlU1lrhsoW+lRGrxhVc3G9MFfZgtK4zlib
oDGuzBkZNc04kqFSFp9K34xR1xo7vMtQNQ07hgeLvtclqHBfOHEzlTtNGSo1
4FPZizGq5qJP7TLUXUYD6xNU9rFPpQYyVMRTZBRZfCptIEbVXJxH2HFQ05yH
TCSo9H+hiE+pjPT7GE1zcXVixwRNQycAIUuxIUFlL/lU9lKGClkgLuymgUqL
i1E3GL3NGqqmOZ5NJqi0KJ9KWWPUSSPrjKHOGFk3JqiU1acylsWoG42s04Y6
bWTdlKCi9+EzYo9CEej2jm1ApfCoYnOIpnVyBbrdyKhpxtsYVXMxXm4zVE1D
Ssgq+p5KUNFmtFys36cyRsWomotj6lZD1TQ9eUuIqrm4ptxiqJqGOUFc0cDW
BBX5YYpwm2XUqY5tQK8AVRqx1PHKYjpkuZR9T4mhE9X/eh8U16Jryb/R1DZZ
5S2xEAqtrW4Ljlak0ZqECxWjGOmsUKoZlxaRu53l7PumO13rln2iNHQwjEv0
Zu+1TZh0GYXGugm67rFz8XUmXXLbci+4q6hKWP8r9dZJ9myHrNRaHU0tJ7a7
7/TLp5OV7krp290FTp+6WK37Vib7SnRe9lYLMlY6L6p4abRclUGgKIpqlXL7
ZCx3XUqEbv002kJLTQARravUhtsgXfkJ4iFcF4HP1ljK2hZPK4pqWe6sGG2L
esk5XmtEBS2LLt3s5cwDqapq15s66tkWoi78rugut776rxZSOXj5ox5u41c5
32uhlegBBD7owdqF3qVGjEcOmBsudO7dLzKWuVqQD5EPgRpVrDHk1Z264UJo
Clo7HyLPlV/B7jEEYGkIuWR0tfZd+mQbIJg/iKhD+tLuhfg1lPsxEgMgFsQH
QfTs7uKMYcQAG70FKGwYlewN1VHuRm7EmIFC0Dy+QGW4gK40qqBWJFE9vgIe
n6Cq/S5bNLtQB7O1niasjSa+L6njakjQN+Yl0IxMdEykrcuO6xCFgRZ5MTFG
UsZG20NZOervHb0yl1oHxMPsQbtEIqRvHfgGTYGKMVCKDe3uUYOxbJmBocMw
S1kmQWnnLbQe36MTUclcyCLUFyE5ehvloEHri+s6NeskvYh5oq5BNF7AhJbF
LI0naD/qlfbsClF1tYD80J14lhs/ZWaEfhCb3hmiznRaCK+WfrPjmqbhC9Uq
bTZEne6UqmaMdt6kaa79ZkJUmYnLfQWZBQtsk6FMhyjbTKnNRjZNc7a7PUTV
2StnZVOGqmnutvvzUn+2iyywFAkA/mwX9SFwiaVlqFzL+TNz1Aerl1pjM/Op
qnfsmkRLc40XWz1oL/Auo7/S4Q5+bKWzqaOvavVg13rbTMszVGsxpG53LS62
yuWKvLPKVSvnrkFmzdxvJU59x6gaHXj/xd814BowsxfBUj6VtcaoG0wpfzeG
tWb2eOjXPpW1xqgTpu/9XS7Kmtk7a773U49b1a5ijKqjGXcH/R1O7i5mdjgZ
NW7e4aSvZWiMeL6M1HeMqrMD7pn7O8bspfg+tMRRuwOvNO5TZXa1mcuXkfup
MaqmuWvt3y1gdI7fg5CWz7k02mXmjgbvVvkysuUx6hrTciurprnfn7n/xD1G
n8oRJEPlbqBQBKo03j+N0VabUv7dQY5LmXuO9HOPKjaRkbHf3VaeE8/I2Hxn
WFcxPHMzzLvY7L2V3Xn3qKLPWMvHjT5nl/wzIoOcEmBUjp1FoMYytbB3ep/a
YC+v7ARK7JzLieTJE62F/n8rT9Owt2O1cM6YqYV6lv7wzoYonefnYvR2p1R1
hsE/18XaM6fF2FKfyllghsoRfZgn29iLPpWjaYbK+1mDnxDsnhMO5xSjRiXG
B//EJeNNhtrvdCj7PkOlR/tU9n2c2nzKln2ekfFEn5PAnAtlqOwFn0q/z1D7
nbAmZZinwTlGD+PEOvV950/V0/58Ku03Q2Vs8qmcn2WoXGf51JU9WcGRwqeu
7CkQ5rJUtQHa8TCfrqHPDfNJIOo9Q216Wolx9M49SdXvaS9afVxGkeGAS6Pn
3vmn59iXw3zSjz40zKcSmWuYT1DydPcAT3s2PIkqMV6fbw09iRp+OpazsihN
x55hPbmrFuzTOO4M44lnnlHKPOE9wLPYQRbjT+65edlJ8J5XSDzP7lD7vZ9A
6RwPo3Sd59inT/z3Eyymn/VXn2h6P0H2nQr6bb/3Eii19vm+VI0p5f5Pz/cR
BN4rsexNF6JXbx0ceOMFWRpsBnvzxmKvN4DUsWYAxonYm0h6vFVlOIw6NvVm
dL1dpmOJ4be69HwzTb3f69XfPTKt7B07gxPYDlVVQzt6viuIDO2y4omyTB3b
TJli1f8pSPOt\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{111, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396594425]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->616106199],

Cell["Ranges where the function becomes nonreal are excluded:", "ExampleText",
 CellID->369531415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", "\[Theta]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"Im", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", "\[Theta]"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->453187265],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179638243]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->342693763],

Cell["\<\
The curve is split when there are discontinuities in the function:\
\>", "ExampleText",
 CellID->353351085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Floor", "[", "\[Theta]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30552953],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWluIXlcVPpn/n8ufdNJkJmljrtPWJmmSJplpLlUzmSQzuWsu1Rprrek0
CAmilRpf9EVf9EVf9MVAaR+8gJeHiKEiVBALYkEsiAVRQSpIfbAIFh8CwvFb
l/2vNd9/MjNpacGQ/Dn7nL2+dV97nX32h2avXv7UZ2avXrk0O3b8mdnPXb5y
6fNjx55+BrdaS6qquoF/z62pcF3jSv/dqGv8/2n5bclY/1THunf7cPO4jlbp
nNde+9cbb/xHLj/SSDNaZl166sc3b/63epRmDev4Rz/8/Z//9E+53Jeonv7s
T1/53d/lspGq/2cv/BGoFx79/rVvvwwO1R6lHdG5ePa1r/5SLj9KtHfKz8Dr
r//7e9995YnHf3Dl8nXMhWjjSr1SZ2MIWChWXSBqRe9/9Q//ADqmPP/cb998
82a1K9F+65u/hjpyecHttVppgIbZQfOg0qxQGkgDUcQ+HyN+d8lPG/ON9ifX
X92R6L70xZ+/9Ku/yiXTrSl03/j6SzASBN6mdKp9C8bGTbl8hOjaNF6rNzEf
doLKEHFrwvnC1Rde/s3fFoOzvnjFhKm2KMpyvQsVoIhcnsZPG0R9/n8L/q/6
4ShojyF+wa7qk7stC7uurhJjkBFzq80JG+w8ss6q3zGADYGF4MLv1OQ1CbOq
hRAyHpV4rE/uDZ4/+x08BwJGxlo8pB6R+ZBZ/Phe5TZMdv2g/Azi+S9e/MtX
vvzi6ZPP4wF8IcyFw0CTvQZBD93AC4Y9Ov2sJYDFj1gJ+kmc35c4RgScUv0g
JNhBcvyCNQRoeRQyx46Oge/2WZ2sKFzvVS53kF4nlAvsAEUQj5ATXDAcXMD/
itaCOBYy1T0J3UStS83oBxzcCB1gL2SG51Vg3VdyFMoL1phiLSscQCh+Uqw2
UtEKBB6MuiXuJ/pNiR7zkcByOZMiH7cQbqtJDsbZmHAi7o4oDmZBCAv+uwln
c8GBvyU3NijOUr2LMfh3cbySSpS/h1C2FP09StYnFGQuUk8uD1MsrSWUrSkK
JLrXKUqHbGsokMJzYB2hPFBiCxrVpYo4SlTmQ0Vvr5fr3T/b5X8kQaaKSnOR
eG0rKJgicat2qYZI4ieJaruO4VTUXdFgTaIKCZlKa28LoY/IlMu7E1VkIlNp
pU+rmVaQarDIjdogEs42Uln8deuOU8EU0FYuZ91mugKltWd1mh13mcfOYgXk
iPDIVDAMwqAulUViBoaSy1WEwrz1udcb5C+wAwUx47aV3Jca39+IFjJltFgp
TuoYQYKsksvlCaVqQN1NMo4m1Lh7osjoqEMuI1czHu8mmTM63IcklsvjpMMI
oUilluE4SaXzXKOIF0MDNAKry5PQ8ni8xJNX8owad7VqpiqitbcdKL2WnSAt
VybcqKaGG5V+pG5elQwtMqxT5PPc6U/otpzK5dF6blZwPZoo/kE1CNSIzYwa
lXumWNx7wVKftM9M+WxomATAbnQ4GpzlWSNoUtU2kGwPkaUMLSq2obVJgxmK
uGZUPPHunGtvRo01psi4kdCmyF6ZOjCnyV6MYvUeCrhMrS6K8DSNIjuaqWMd
aCUZIq46dfTc8v9dhMK1WmqdhHfpDUZ8zDWuPFdP+b2+JEFEg3KYkzGjPXe4
k+C1oJOeVwWB30LSc5Z2JHG0djd7LCK15dp6AoSAWk+bnwzXc3v0IfJbuc81
kqsd67QyeaLILl3VXNkjn4qnVzXbO1nHrBn1dFkD5zxma65osrZzlBo5V0K8
MuRY65GslaLTJIuKc7uSrUw2aGl0BneLTlsFInM7PTIx5irHNL9STN7Szl1p
e2Z034D9ieV/q1G6pXVkbZcucbDVIlarMr/IPHoLuvJcO1u/tyRJgLtod+TS
uuyI5jFCss43sj1bOfpdQ4k+4u2gIG4BdGuUqH3zocR60owSzw3Fy6v+uY5/
S+ZiezJwj3G74753eP4t6V3Xd43f/6l9KKLeoteH3uH5t+vVt4z/dq36bvNr
9qLXhQ5RNa0DbDXp05YuMO9wGXufNl9V4j4/3jmbUZsrJldvMPaO1FCj22tG
jXeX5jWz29cmS+SOvawuxj26q4yGpgXrqFyeIZmbZTo6/awxnNNlxup+hnjx
WnyoyAygboz09H+GEutUM0rImlHCV2cKLyztspeyvNgvx+NgFxV/0ACAI1au
6oDOjfU2cwi/6d6t7Ln6Sqh7n3cgGiAEnID1z6qTbZ6CDpJgKkQ6QBpm/Fjz
zhYN/M1FNWhDPTgZUoKRdQ8Ad4kOKkW8gWbc4HaOtON+zuwb/V9Gifeq8yTt
ikaUiJiMEu9254uOFu49KFM6jt4q97QRvbbPDxthluzN3tmIErmR34Xjze+R
EiGQBRzn7N4ESvg/o8Qb4IeLLPAPTKNRIX4ye8SbQqaOtwD9XiVfSGBY+Bgw
3H0fJIvkXQLb1pdL/b7UxhixCGgYmCur4EjlHEj0gXqhWBii4VbVtCdmkkSd
MkkGSM+PJ6qqAWWyWN3r2kBCCas+TlRiPRlOUmwHtej2BFHxmjRJkZ55x6rw
iQVQDpDtBhNKvKk8pmLn9xC2hOFE9hqOvYXHGvNY3bxH9QHiN5Sowz6812pU
kRmZKjQq+7ldHl6RNKZ85Yn6/STxeD/xyFRRP5jqfcRraaKKPbVmqqhtmSrW
AqZ6uDyHvvLurDnn63T442IjVeiVqSJ6LrrtbLbVKNFHvzL5l5Cw3SeJx36y
UlBJfLNE+4j3cOIRu3Q2BrlH/XlC2UvW0DrouwBR/Tpk6WaUWB0zCvknZeA5
QtlDGmll9y90UblZlnN13hOFx31dWJGow28sw1mSwXYtoxZlFGB75eYvY4wy
4T6zHe61ZM3jNJv3qcZJw4wSeboQyu4y37/e2BeBdSSL7HmWei/ERgX7eUXP
VLHXO5N4VQ31yU5erCfbz9TN1cxm2/5xrDDTi5gd2s3U81vDqDZSnJ6aZ5b1
KdIbnKrzqZNN+jTOk5wkjIdLrHgUW6UYI1ucIKr9xNNy/x6KRvb5vkLl33+H
ExW8BSzJBKbaS1SWrfeSRY8R1R6isuy0L+HRKR6tczbGbMsjPamQOiD22kSx
nVPZl5z7yQrTRDWeLC5UI4kqLMpU3fywYuCRvrlg+denI0Rl3wbRa7lt7dug
ffnGGBLI3cM1fRNFpxZfN7eW2cCQ1eEQ8dhR/Ac0GMq/8T5Q5MVdWdemiMq+
J0N/6CPvIvY9eVuiEl4HiUpR5WwA/AcLY4p9vd6eokE02ls3Z+PWwhW9p3TA
9rV+R9HQbatVdd5+SO3uvTDkAKmdHniQfDvRiCRA5m87FCKS2FmInYUeoGLL
8QUl0YhuozxCI/QDIN2kE7vfb3FTfLnL+bJFNPva8AAshzBGENlJk/Ein1t0
F9GxHJsKDjS3Yxl26mYixS2kVJy+Bj20QrbtvJN1lGohX+Esx1AJvRoEna4z
clbMTsDAH+JBOy1lc/HAs+Mh562xJmdykBgwNMiADAiNLq9SUMDPjUwQR82h
AUgEYSEUelqkC5xt58z2lwjtnl7ZTfRaJeTkEsDBHfQQGqYRL6n/rVP0kzSA
wYOdhKH1dggPYCc7VQIlwA6zIYlK7B0xnnqEWZ0FIzvC1LOfpZGxDHrhOfyO
fsD2C+xcFZBBKjmpVrU3gjbGEB6MwVUjQGorZst7Wd/U5LWqDRUsIjBPGjuN
ZvxvJxH0LNmQnRuDITBCuOIRRIDDtDu3GiDWgLHwF/e19rdhWkzDX7AU5O6O
A1SWisKn3qYUTatX2yoAzAbYLWQHW1WPlLyCKphX4rFnnq4J/ZhnxrKjkb46
8Vw7rQUFYAs7rSVROdY490SJMrgCuJAC9QCJuKHOq/tpnQUlkOhws80CKJ9S
MswzaTYwbS8ImvH5KputXfOQ7elAOXjIjvWBACqWL0nN/Y6eP+3Y7hKoEEJ2
9s1OBYrW2vHMW9kMSd9N5fQp6Oycn7X+rUXSX0pyykO7+9QiqRc7r3DRzrq6
0fNbLfkf9tLhZg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 158},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277404433]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324058600],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " to control adaptive sampling:"
}], "ExampleText",
 CellID->868277022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PolarPlot", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "mr"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"mr", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"pp", ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "10"}], "}"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389502305],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{1., 0.}, {0.05996308887680144, 
         0.9982005950571021}, {-0.9999749232327282, -0.007081871624039709}, \
{-0.034369644073556596`, -0.99940918925446}, {
         0.9944047760427348, -0.10563683724628652`}, {
         1., -2.4492935982947064`*^-16}}]}},
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{-0.9999749232327282, 1.}, {-0.99940918925446, 
       0.9982005950571021}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], 
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{1., 0.}, {0.7829108051944013, 0.6221339655651781}, {
         0.17054761579185446`, 0.9853494358590327}, {-0.4867106704313184, 
         0.8735632337090983}, {-0.9225714372486704, 
         0.3858263121832448}, {-0.947090689177945, -0.32096608305620894`}, \
{-0.5391554419054319, -0.842206274889803}, {
         0.16095581032789916`, -0.9869616138035406}, {
         0.770368495985692, -0.6375989181238804}, {
         0.9997611394248145, -0.021855527813271023`}, {
         1., -2.4492935982947064`*^-16}}]}},
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{-0.947090689177945, 1.}, {-0.9869616138035406, 
       0.9853494358590327}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}]},
    {
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{1., 0.}, {0.9295155494896142, 0.3687829215907652}, {
         0.7279983134859591, 0.6855789200096509}, {0.4238559552852132, 
         0.9057296115117687}, {0.05996308887680144, 
         0.9982005950571021}, {-0.34240013028368216`, 
         0.9395542298248236}, {-0.68815243343058, 
         0.725566143341578}, {-0.9201286711851919, 
         0.39161617492510836`}, {-0.9999749232327282, -0.007081871624039709}, \
{-0.9251307703373695, -0.37964859775190196`}, {-0.7166906915175492, \
-0.6973911762361904}, {-0.404755020934184, -0.9144251598838301}, \
{-0.034369644073556596`, -0.99940918925446}, {
         0.3339190235299524, -0.9426017641214147}, {
         0.6558384846571028, -0.7549012399265714}, {
         0.8866858355800292, -0.4623723921059144}, {
         0.9944047760427348, -0.10563683724628652`}, {
         0.9968514008178483, -0.07929239993526206}, {
         0.9986002143106957, -0.05289245672714173}, {
         0.9996499923249876, -0.02645548798741278}, {
         1., -2.4492935982947064`*^-16}}]}},
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{-0.9999749232327282, 1.}, {-0.99940918925446, 
       0.9982005950571021}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], 
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{1., 0.}, {0.9859434973537157, 0.16707908314903924`}, {
         0.9441691599481529, 0.32946107114923207`}, {0.8758513899518876, 
         0.4825809183125112}, {0.7829108051944013, 0.6221339655651781}, {
         0.6573859392496688, 0.7535540636721634}, {0.510149105264919, 
         0.8600859784913382}, {0.3460632022511028, 0.9382112022608301}, {
         0.17054761579185446`, 0.9853494358590327}, {0.0014589574669642224`, 
         0.9999989357209884}, {-0.16767172697719682`, 
         0.9858428840198038}, {-0.3319725297038937, 
         0.9432890540666723}, {-0.4867106704313184, 
         0.8735632337090983}, {-0.6248298061722743, 
         0.7807609834761968}, {-0.7456479336198936, 
         0.6663401226763872}, {-0.845819701121121, 
         0.5334688680657734}, {-0.9225714372486704, 
         0.3858263121832448}, {-0.9768930830807698, 
         0.2137285760700899}, {-0.9993988139079435, 
         0.03467002681561854}, {-0.9893556524663307, -0.1455176722357841}, \
{-0.947090689177945, -0.32096608305620894`}, {-0.87977738770628, \
-0.47538589385962426`}, {-0.7874990317046473, -0.6163158890246486}, \
{-0.6728741633425868, -0.7397569602957541}, {-0.5391554419054319, \
-0.842206274889803}, {-0.377097791740211, -0.9261734478296473}, \
{-0.20247781944537319`, -0.9792868490042368}, {-0.021112669513092312`, \
-0.9997771027514237}, {0.16095581032789916`, -0.9869616138035406}, {
         0.33452296255008146`, -0.9423875994126392}, {
         0.4973477798942735, -0.8675512583324615}, {
         0.6442015668442546, -0.7648557650141675}, {
         0.770368495985692, -0.6375989181238804}, {
         0.8658260267084721, -0.5003451723302826}, {
         0.9370830871472572, -0.34910641326473213`}, {
         0.9821479903805653, -0.18810987478443777`}, {
         0.9997611394248145, -0.021855527813271023`}, {
         0.9998656385862092, -0.016392216890709726`}, {
         0.999940283073148, -0.010928416518085453`}, {
         0.9999850706568444, -0.005464289837300488}, {
         1., -2.4492935982947064`*^-16}}]}},
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{-0.9993988139079435, 1.}, {-0.9997771027514237, 
       0.9999989357209884}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}]}
   }],
  "Grid"]], "Output",
 ImageSize->{212, 209},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->581420140]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6387897],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to focus in on areas of interest: "
}], "ExampleText",
 CellID->214993069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"Exp", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "pr"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"pr", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "50", ",", "250"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->41892276],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->102457925]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->176579689],

Cell["Multiple curves are automatically colored to be distinct:", \
"ExampleText",
 CellID->150311282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74897845],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->846013056]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4217391],

Cell["Provide explicit styling to different curves and regions:", \
"ExampleText",
 CellID->63093614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Red", ",", "Dashed"}], "]"}], ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Purple", ",", "Thick"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235628210],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33027935]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->947263323],

Cell["Add labels:", "ExampleText",
 CellID->335188046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Sin", "[", 
     RowBox[{"4", "\[Theta]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575371355],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 205},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149554668]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->699549274],

Cell[TextData[{
 "Provide an interactive ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " for each curve:"
}], "ExampleText",
 CellID->213196035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tooltip", "[", "1", "]"}], ",", 
     RowBox[{"Tooltip", "[", "2", "]"}], ",", 
     RowBox[{"Tooltip", "[", "3", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162853632],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJw123c81W/YB3CiFAmpVCo00FIo7S6hYWREaf2yUkJmJaKkpFDZeySyZe9x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       "]],
      RowBox[{"{", 
        RowBox[{
          RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]],
     Annotation[#, {
       Cos[$CellContext`\[Theta]], 
       Sin[$CellContext`\[Theta]]}, "Tooltip"]& ]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJw1m3c4lv/7/4lSJKRSqdBAS6G0OxUNIyNK652VkmQWZZSUVBTZu0S2zKxw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       "]],
      RowBox[{"{", 
        RowBox[{
          RowBox[{"2", " ", 
            RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
          RowBox[{"2", " ", 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}]],
     Annotation[#, {
      2 Cos[$CellContext`\[Theta]], 2 Sin[$CellContext`\[Theta]]}, 
      "Tooltip"]& ]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJw1m3dYT2/cx7/7pPpRRghJhEIlUlr33ZAyQlJCIdJANJARSZSkXSKlKdJO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       "]],
      RowBox[{"{", 
        RowBox[{
          RowBox[{"3", " ", 
            RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
          RowBox[{"3", " ", 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}]],
     Annotation[#, {
      3 Cos[$CellContext`\[Theta]], 3 Sin[$CellContext`\[Theta]]}, 
      "Tooltip"]& ]}},
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-2.9999996494055186`, 3.}, {-2.999999577843614, 
   2.9999996348234657`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->668952026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->383190062],

Cell["Create an overlay mesh:", "ExampleText",
 CellID->28724436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{"\[Theta]", ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394612338],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->710609877]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65033741],

Cell["Style the areas between mesh levels:", "ExampleText",
 CellID->25420136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{"\[Theta]", ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "20"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "20"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Orange", ",", "Yellow"}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->245937364],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239620435]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197602998],

Cell["Color by parameter values:", "ExampleText",
 CellID->191004617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{"\[Theta]", ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "\[Theta]"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"\[Theta]", "/", 
        RowBox[{"(", 
         RowBox[{"2", "Pi"}], ")"}]}], "]"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->915108523],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->587289992]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(25)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->460171944],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->299104015],

Cell[TextData[{
 "Color the curve by scaled ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " value:"
}], "ExampleText",
 CellID->57293869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"4", "\[Theta]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "t", ",", "r"}], "}"}], ",", 
         RowBox[{"Hue", "[", "x", "]"}]}], "]"}], ",", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "t", ",", "r"}], "}"}], ",", 
         RowBox[{"Hue", "[", "y", "]"}]}], "]"}], ",", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "t", ",", "r"}], "}"}], ",", 
         RowBox[{"Hue", "[", "t", "]"}]}], "]"}], ",", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "t", ",", "r"}], "}"}], ",", 
         RowBox[{"Hue", "[", "r", "]"}]}], "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2070922090],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 377},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"(Head) Out[1]=",
 CellID->40686799]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84102783],

Cell["Use a named color gradient:", "ExampleText",
 CellID->96209800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111562539],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->401919490]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187580093],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->147068490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143803984],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89047030]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->393865318],

Cell[TextData[{
 "Use red for the parameter ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", ">", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->44372465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "t", ",", "r"}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"t", ">", "Pi"}], ",", "Red", ",", "Black"}], "]"}]}], 
     "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33895657],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51683351]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunctionScaling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9272582],

Cell["Color the curve by angle:", "ExampleText",
 CellID->205032714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{"\[Theta]", ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "t", ",", "r"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"t", "/", 
        RowBox[{"(", 
         RowBox[{"2", "Pi"}], ")"}]}], "]"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->835889671],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396173008]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EvaluationMonitor",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->452392779],

Cell["Find the list of parameter values evaluated:", "ExampleText",
 CellID->28145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reap", "[", 
   RowBox[{
    RowBox[{"PolarPlot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"4", "\[Theta]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", "\[Theta]", "]"}]}]}], "]"}], ";"}], "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23281],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"Null", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.12333038743279022`", ",", 
       RowBox[{"\[LeftSkeleton]", "1819", "\[RightSkeleton]"}], ",", 
       "6.283122725939391`"}], "}"}], "}"}]}], "}"}],
  Short]], "Output",
 ImageSize->{287, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->531218640]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->911956050],

Cell["Find the coordinate values: ", "ExampleText",
 CellID->5447],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{"Reap", "[", 
     RowBox[{"PolarPlot", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"4", "\[Theta]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
       RowBox[{"EvaluationMonitor", " ", ":>", " ", 
        RowBox[{"Sow", "[", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"4", "\[Theta]"}], "]"}], 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], "]"}]}]}], 
      "]"}], " ", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "data", " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19718],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->174981644]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->569319435],

Cell["Count how many times the function is evaluated:", "ExampleText",
 CellID->172041979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k", "=", "0"}], "}"}], ",", 
   RowBox[{
    RowBox[{"PolarPlot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"4", "\[Theta]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"k", "++"}]}]}], "]"}], ";", "k"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1723218239],

Cell[BoxData["1822"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1359802463]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Exclusions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->534777178],

Cell["Automatically determine exclusions:", "ExampleText",
 CellID->24278928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Floor", "[", "\[Theta]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->679024267],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38939775]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MaxRecursion",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->106839402],

Cell[TextData[{
 "Each level of ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " will adaptively subdivide the initial mesh into a finer mesh:"
}], "ExampleText",
 CellID->95077555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", " ", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"4", "\[Theta]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"6", "Pi"}]}], "}"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "i"}], ",", 
     RowBox[{"Mesh", "->", "All"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "6"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191953008],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->772870780]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mesh",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->292772160],

Cell["Show the initial and final sampling meshes:", "ExampleText",
 CellID->60296518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}], ",", 
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30195],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36952217]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145200893],

Cell[TextData[{
 "Use 10 mesh points evenly spaced in the ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->11427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "\[Theta]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29355],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->581416460]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->510286224],

Cell[TextData[{
 "Use an explicit list of values for the mesh in the ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->238138513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "\[Theta]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Pi", "/", "4"}], ",", 
       RowBox[{"5", 
        RowBox[{"Pi", "/", "4"}]}]}], "}"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50003947],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->351371202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->522255988],

Cell[TextData[{
 "Use explicit value and style for the ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " mesh:"
}], "ExampleText",
 CellID->665100961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "\[Theta]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Pi", "/", "4"}], ",", 
         RowBox[{"PointSize", "[", "Large", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"5", 
          RowBox[{"Pi", "/", "4"}]}], ",", "Red"}], "}"}]}], "}"}], "}"}]}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1243532340],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11874403]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshFunctions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->301207513],

Cell[TextData[{
 "Use a mesh evenly spaced in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " directions:"
}], "ExampleText",
 CellID->1059804450],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"4", "\[Theta]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", "f", "}"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "15"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "t", ",", "r"}], "}"}], ",", "x"}], 
        "]"}], ",", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "t", ",", "r"}], "}"}], ",", "y"}], 
        "]"}], ",", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "t", ",", "r"}], "}"}], ",", "t"}], 
        "]"}], ",", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "t", ",", "r"}], "}"}], ",", "r"}], 
        "]"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->904022932],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxcmnc8lf///4uoVFYokZJCdomG3p7RMFIUKcpOGkYKUYSIShHJKnvLJtlP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     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2QfcjuX/xvHHnpmRUfYqm4yE7BmKQmTvPUsITZRNhLL3yFbILCNE2aNF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         "]]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{1823, 1824, 1825, 1826, 1827, 1828, 1829, 1830, 1831, 1832, 
         1833, 1834, 1835, 1836, 1837, 1838, 1839, 1840, 1841, 1842, 1843, 
         1844, 1845, 1846, 1847, 1848, 1849, 1850, 1851, 1852, 1853, 1854, 
         1855, 1856, 1857, 1858, 1859, 1860, 1861, 1862, 1863, 1864, 1865, 
         1866, 1867, 1868, 1869, 1870, 1871, 1872, 1873, 1874, 1875, 1876, 
         1877, 1878, 1879, 1880, 1881, 1882, 1883, 1884, 1885, 1886, 1887, 
         1888, 1889, 1890, 1891, 1892, 1893, 1894, 1895, 1896, 1897, 1898, 
         1899, 1900, 1901, 1902, 1903, 1904, 1905, 1906, 1907, 
         1908}]}, {}, {}}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-0.9285018761393408, 
     0.9285011586539766}, {-0.9285019867536777, 0.9285019007297314}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxcmnc8lf///4uoVFYokZJCdomG3p7RMFIUKcpOGkYKUYSIShHJKnvLJtlP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     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2QXYVkXbheGXTpGWUOmQ7hKQ7lBaWkrpVFTAJpQGUUHp7lQBSRWQVGkQ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         "]]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{1823, 1824, 1825, 1826, 1827, 1828, 1829, 1830, 1831, 1832, 
         1833, 1834, 1835, 1836, 1837, 1838, 1839, 1840, 1841, 1842, 1843, 
         1844, 1845, 1846, 1847, 1848, 1849, 1850, 1851, 1852, 1853, 1854, 
         1855, 1856, 1857, 1858, 1859, 1860, 1861, 1862, 1863, 1864, 1865, 
         1866, 1867, 1868, 1869, 1870, 1871, 1872, 1873, 1874, 1875, 1876, 
         1877, 1878, 1879, 1880, 1881, 1882, 1883, 1884, 1885, 1886, 1887, 
         1888, 1889, 1890, 1891, 1892, 1893, 1894, 1895, 1896, 1897, 1898, 
         1899, 1900, 1901, 1902, 1903, 1904, 1905, 1906, 1907, 
         1908}]}, {}, {}}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-0.9285018761393408, 
     0.9285011586539766}, {-0.9285019867536777, 0.9285019007297314}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxcmnc8lf///4uoVFYokZJCdomG3p7RMFIUKcpOGkYKUYSIShHJKnvLJtlP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     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2HfAj+X7xvHHzkiZGWWv7Jm9N6Eoe4siMkultI1soih771khqzJCVDYl
pFKpCNn0e52/7x935/U+juO8PZ97XNd1l7tr3+bPJUpISCiWIiEh6uykCQn7
EickPJ88IWEU4WyyhIT7aCfwHn5XPDZJQsIi/KhcKbUDvwcvGa8U74K+VPRH
6MWNV9K/p0+VLyt3kP6f8WbebTyS/zF/IO0DXB53w7lxZxklYY6e/Qaj8V7c
TWacTBPa0zg5Lo0v8ks4ytEO6UmgbcF3DN+V+QQP0jMVV8BP4Ty4S6L/jybM
1fMNHoO/xk/JjGc0pT2DU+Ay+B9+Sccq/AOexn+Ef1h/IryVd5WXB9+ljzL+
lP6x6/K8bC31OV5S130avyK/O/9Del7+Q2pD/iW1q3N9xb/C/xqv4T+ljudn
0h8/c57/fEt/gT5W/mf5h3n307+n7ZPpTpvgHItxM9nSakd+T949vLK8S3pT
08vTSxmvpp+Mv0u+Bf01enn5I2pi+jaZazJ5457SRxuvp38i+4Ke2mpf3oe8
SrwevI9o+Xg51Ea8y2o359nN/5e/D6/ld1cn8DP7HayE+cbf0QfTx8n/QkxH
+wHv5/fAE/UvwY/JlVE78XvxUvLK8S7rS0OvQC9tvIb+Y/xN8hXkjtKT4M/j
ZXCM4W/Ag/kfkSrjp3H+uAd8p0pYoOcAHo+/wc86Usk9IneFVsZRkXYs7jft
C5zIMT2eJ8dC+kH9E2jf4jzE3mpq5ygv/y+9rKMS7bhsMtqX8V44ZsS9cyyi
H3KOibTvcB9HGv0VZK/G++CoTDshl5y2PZ53x1iZjfhFvTP5VfAzuADO6cc1
lu8ut4d+lb6OnlJuMf2w8STer7z0cQ3oTxtPkluq9/F439XOvFvxvPPv5Vfk
j8XX9N6rVuT/HvMFXss/FdcfT9f/hPo6P41rUkX/98Yp+G/Sd8hfl88X19V4
nPFnvE95L+mto/bjzdJXldeTV5CeK+aumLNiLqFfi/eS3oM+kZ5Kfol6hPYi
7T25c3IZ4j7xnjF+T88yXnOZcmoRf18X/u143mXSylSSGYev60+rVuL/Ee8W
Xsc/Hc8CnuEcT6pv8O91nqr6fzC+h/8Wfaf8Dfn8ce+Nxxtv4r2sry6/P322
nmr0XvRCMSfG/IWvx7uIU/OXyh01nsw7hHvyJ/Nb0Prh+3BlfINfwVGNdlJP
StqueNYdc2jV5Z6lPRxzYrxPtGVyx/AUfBj3kpki8wStP74fV8E3411wVKf9
GNea9hVO4ZggsxkP0TOXXwP3xoVxbr+zScxVcvvoN+I+x++kT4rrJr9cPU57
ifa+3G9yGeM+xjtp/L6e5bwnY66OeZV3Rx3AT8evyh+f/H9r4S399xlXljkf
9w5/LHMm3j080zlaqm/y08rXcI5Txqn5b9N3y9+ULxD30Xii8RbeK/rmydbE
fXAR3Iu/H9/E63Fa/opYc2M95B3Fvfkf8FvSBuL0uBq+He+1oybtdLwntD04
pWM+rZbcc7Si+p6N30RbGWtCrIH4WMwVMlNlWtEG4Qy4Or7Dr+KoRTsT15i2
N9Z2xySZrfhVPQv4tXFfXAzn8fubyveO+ZB+i76ftiGel3ifeA/E2qRvVczf
9Jfp0+R/l89EO4mP85/D0/SvwK3lysdaEWtqrKP8jPwa/An4rv771cIxV8j8
aVyV9onMTzHn4VnO0Up9i19b/09x/2JdlbslVzDuofF7xtvoQ+XrxTNCXyhf
h96PPp1WnJc31lJen5i7ebd539A28nqqk3lZ/D3p9K6O30UfQv9Q/g/5zLQf
8Ql+X/yh/pW4TaxH6lOxrsZays/Er8mfiP/Tny5+H7+a8ae8s7zZ+lrT36bX
0XNWvS/W1HhPHZPlPsevyS3i18X9cQkcG8H0tDXxN8V6h7/Hgx2Z5WrFBole
nV7X8Ge5++PexjzuWBzPjmMt/ZTcdNoP+EXHA/pryyai16DndU3q0X+RTRfX
LOZIx5K4p4519NOyM2gn8UuOLM5RRzYxvSa9Pu1XufS0b+PZdkyR+QK/LrOU
Xw8PwCVx31gb8R38Gc7E/1j/mVj7eOd5D8Rvp/cz/kiubTybOCuui5Pg9K5v
NblaetbTf6bvoM3htVHfiWvu9zXQd844A/8d+nex35UvRPsJ34/fx1/Gex/z
v/766sCY5/Uv01+fP5A/g16Kny/2Nvx+eg/w7sZvp22KeUSdEvslfZ/Ev0Gb
JfenXJa4J/T+xtP1tONVlO9OH0LPRq9Hn0RLysugVo93RP8G3i+xdvqbdtLn
8tuqw+L+0xrq/804o8ww+oHYb8f+k3YWp8Mf4O38DTFn6m+gDoq9iP7l+hvw
B/Fn0kvz88f+gd9f70Hef7zN9AdkP43zGs/mncYD+DP47Wmv4Oy4Pk4WewCZ
RrTfY69MOxjPuGOqzI5YX2VW8Bvi53EZPICfhbZez894Dj6DB8rMlOlAexU/
iBvg5LEOyzSm/RHXn3YIZ3BMk9kZa4LMSn4j/AIuG/N4rMOxsdWzBWc13GD8
S6x/vL94WeM+0gcZz9LXkVfJtelBH0p/iN6Q/h4tBS+jWoP3l1rPOTbyf431
G8/jt1OHxzvnuj+qP5d6PuZjmeG8w3ru6ikcvx1nxB/iXfyN8Ww7R8OYe/mr
9DfmDeaVoxeI/RB9UOwB6ImMt9KzyW00/jXWPt5Z/Dx/tr5OtNdwDtwI3xPv
gEwT2p8xd9KO4EyOj2S+imdMZjX/UfwifiS+V/nZaZ/pOYfnxzcQfkFmjkxn
2us4J26MU8YzKNOU9peerLSjOHPsy2V2x/WQWcNvgl/C5eP7in8EJ9azDT/I
32T8W6yDvL952eIexrxpPFffKtelC7+y+nTS/23634hrz3+UP5meKuYjtSb/
7/j2c67P+Odif4Tn89urI2K+099M/9/G2fgj6Mfk89P/01Mk/n3aA/F9gPfE
fBe9ztEo1hL+Wv1NeS/zZsX3EK+g2oI3OPYcvCTxvUX7PPYOsafCD+nbHPv1
eNdoC2UvyGaP+xtzvfE851wd+yuZKuozvET+tjf5uflN+FPoqfmZ1Vr8C2oj
59rE/42/Gy/gd1BHxhyq/zH9F4yz80fG/kA+PsCKxnNiPFPv3vD0rWM1w0Nw
xdjHx14HJ5X9Ir49+VtiPx7rYOzv8Vvx7SXTVE8aemP647SLcg/STuCssQ+M
58ixNfaGcotjr4nfduTV30z2Xvqj9Oa0f+K60b7HBfyObLEnifvv2Bb7FNkl
sffB7zjyOcdj8mnpTegtaJfkctB+iOc81nvaY3Kv0CrFnpeWm/Z5vPux9sX+
ItZNmfky3WjDcH78OL4PN5XZjH/HC+Nbi39Zf058kpco9sLx241nyX1N30R7
N66NOji+xfye9foe578a+4/YM/MLqU/wr6gv6z/OT4YP4C/5vdUP4r3Tn0f/
F/Hcx7xKXyZ/Uf7BWLPwef7LeIHzr4k9kVxVtSd/OK8Arznv/VhTY41Qa/Oa
Oc8W3h+8RfSO8bfTn9RzRc1Ff5f2o1zi2M/FfTKerWdfrDe0UXEf4xnzd74Y
e3l1g/7mMkNl5vCqyDwc3xX8f9UhznGCnxwfxNv5fdSp8b7qz6v/y3jm6UPp
y+X/kX8ongXeEOOFzt2dX43fiz6CXpDegp6O/pierfg8XhzfIvx/5XLjU7wc
8a3G349H8zfyW+DXcNV4d/n5aNv1XIw1MNYb/IrMIpketJG4EH4Cp8ePy7Si
XdWTh3Ya53TMlfkGj5H5jP8Efh1Xi/sZe0icQs+OWNf5O4z/ifUw5kv8Kn+x
/NO0d/HD+EmcAWfx++vIN5fdRv+TvoTeKe4NvbX8NTUvfRTtjFwStUTMR2ou
PE/ft/wteGy8U+pL/JTuxSb9T8aeLOZkmbmx75EprLaUuaoOjX2szD34EN4Z
e+X4XsEF9O9UL9FWyV2SyxH3lj7UeIlzPsMbhQvjljgjbiH7Of4LL419I/+6
vnz4p3iX4/uN/x0ex9/Mb4nfxDVizeQXpO3ScznWw3hn8GsyS2V60kbjIrgV
zhTvt0xb2g09+WlncR7HApkDeLzMFn4r/BauGWsmvxDtq3iXYz2MZxW/LrNM
phdtDC6KW+PMsY9xberGeyb7Bf1v+jJ6Z/poejv5m3Ht4tmk/SyXVC0Za7ea
Fy/Ud5C/FU+IuSrmEX4q92mr/tb8t/nzYv3gF1Fb8a/FPjqebbmTMilph2m7
Yv8f3134Yf27412N60hbK39ZNmfcR94bxsud+9n41uE/Sx9LL0ZvQ/8g1tbY
18Qei9dS/5e8C7w98T7zuqhjYk/s72iv95ZxwXhH6L/IJ4v9fOwb1Hx4kf5D
/G14ov5mMY/wU+vfpr8N/x3+/Jjb+EXV1vzrsZ/W/yM/Ff6K14/2kXFhfXvi
GY71MH4jflNuhfP0po3DxXFbnAW3kulAu62nEO3X2FPEc0prKzeMVkfuLVoR
2t643vhjfAWPd5SQayeXld6a3pF2J6457Vysf/FMxD7A7yqqfh2/QfYT+r94
gqOkc7SXzxbvBb0T7W78Htpv8dzH9aa1kxtOqyv3Nq0YbZ/cDfwpvhprusxK
mT60ibgU7oCzxzeMTGfaf3qK0H6PZ92xWOZwfAvJbOe3xyNwPVzMtW0j/47c
KXpq4yO03bz+6vTYn/htxfXtN74Z7xB9fVwj+Vy00/ha7BfwKuddi5+Tq6H2
5ifWP4lfmt+RP5X+ID+7Wj/ma7Wd823nX+TvxSv4XWN+43fRG//DvCjvD7nk
8U0V98B4Cf1IfC/EGkJ/JeZl8Q70kfT69OL0tvRh8X1FT2N8lLaHN0CdEXsC
f2OJ2Aep3+BbvDd4G+I+6slNO4Ovx54Gr3budbivXE21Dz+J3vf4Zfid+NPo
D8WeWm0Qa4Ta3vl28P/hr+R1o43jddWXiF6Mfl4mBb1MPCPGS+lHY18tv1Ou
I34XN8DD+SVp38rejnUR38DDZNbI9KNNxmVxZ5wj9qAy3WiJacVpf8bz71iG
j8VeVmYXvxMehRviEfxStO/8O3diXcQ38XCZtTL9aVNwOdwF54z9icxOfCm+
GfBT/CS4BP6Ld4/fWNb5ihovpx+PPU+sy/RX492X70wfTV8Q+2leiXhW4p2I
fbS+M/x78TG8lz9QnRn7HveitP4Dxnfpm2Rv4RHy65xvAO19/AjuinPFGiyz
C1+O/T7uzk+KS+K/eSmdu5zzFTNeQT8Rc6dc81hT6bvlu9DHxP6T1phXMu55
vDexV9P3Ez8tPo6/5g9SZ8Ve2N9bRv//ARodmOI=
         "]]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{1823, 1824, 1825, 1826, 1827, 1828, 1829, 1830, 1831, 1832, 
         1833, 1834, 1835, 1836, 1837}]}, {}, {}}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-0.9285018761393408, 
     0.9285011586539766}, {-0.9285019867536777, 0.9285019007297314}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxcmnc8lf///4uoVFYokZJCdomG3p7RMFIUKcpOGkYKUYSIShHJKnvLJtlP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     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2QW0UFXXheFLl6KESKg0qHQognQ3SEtJNyIlIIpIdwoCSkungBJSSqcK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         "]]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{1823, 1824, 1825, 1826, 1827, 1828, 1829, 1830, 1831, 1832, 
         1833, 1834, 1835, 1836, 1837, 1838, 1839, 1840, 1841, 1842, 1843, 
         1844, 1845, 1846, 1847, 1848, 1849, 1850, 1851, 1852, 1853, 1854, 
         1855, 1856, 1857, 1858, 1859, 1860, 1861, 1862, 1863, 1864, 1865, 
         1866, 1867, 1868, 1869, 1870, 1871, 1872, 1873, 1874, 1875, 1876, 
         1877, 1878, 1879, 1880, 1881, 1882, 1883, 1884, 1885, 1886, 1887, 
         1888, 1889, 1890, 1891, 1892, 1893, 1894, 1895, 1896, 1897, 1898, 
         1899, 1900, 1901, 1902, 1903, 1904, 1905, 1906, 1907, 1908, 1909, 
         1910, 1911, 1912, 1913, 1914, 1915, 1916, 1917, 1918, 1919, 1920, 
         1921, 1922, 1923, 1924, 1925, 1926, 1927, 1928, 1929, 1930, 1931, 
         1932, 1933, 1934, 1935, 1936, 1937, 1938, 1939, 1940, 1941, 
         1942}]}, {}, {}}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-0.9285018761393408, 
     0.9285011586539766}, {-0.9285019867536777, 0.9285019007297314}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Input",
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"In[2]:=",
 CellID->96703418],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->800535565],

Cell[TextData[{
 "Show five mesh levels in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction (red) and ten in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction (blue):"
}], "ExampleText",
 CellID->245904027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red"}], "]"}], ",", 
      "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50730917],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylXAuUl8V1//w/98UuC7vsLsojohZBFkQQRRehBLUahEQjEE+j1Nag1qho
rI/Gx4lK2ujRJiaFqKU5VqmaY2ixoWltY2JPjxxa8zCmPSZqsVbAKJYi4rIs
//7u/Gbmzv/ut6tp9yzL95i5r7lz7507d76lq69f83tXrb7+8ktXTz5r7epr
1lx+6XWTz7x6LR4Vj8iy7Gn5153huoYr9+/pWg3/r5K/Rbl3P9nKEZ6eLH+b
+vsP/eiF/3r0L3705BM/xUXtwIHaunW1hQtrN95Ye/fdHtOz2/UxjdDtrza/
tPHP/mXb868DnIObzZW/1a3f/fcVn37s6s9v2bB+29e++s+4+Obxq7KiUFwU
EITalYeluXbffTXHHH4fmXYh+t57z3PA8oXrv/vJZY+AXOLI5rjeeLHu7mff
eWd/VpL78sAFF8betbPPznI5KddWroytDi5ewr7Fffv6QSwgEnZ2knv6D8/8
8o7bn2E3/KnUtm6NfR/++HVALTAFRVeA8tD5XxJWC+R30yaPm1iAAkzI5WyH
xf0tQoCQmPBRjVhuuw19X/rZrt++6PFfvPy2ldY4127nzv+5fM1mjEDsUDXw
UiwYb4wIxexphXwBnNAS6J3uHm/wfseOd7MWdw/CQb5cnphAvfR3vo2Gctli
oHYaqB3uHjSjC/5mo0L7c39ro0I9MbQCB3LZGlqBU6Glw0Ad6+7BK94L1DZ3
DxJEsXE5K4H63A9fu+Xm78llW0ILYHsoCnVMkCOgCi+jzeilUCFUiFYu2QqD
BvTo66FYqCABhGh7zBdosYWKR3ghl+1G+u0GarsZXd5DKzBpLFSVSz4tCjWf
F3TG/YdBxWhArqJ/FmpbkCvey2iONaOdD3VszugJ0DYzKh8NWofhvNXQ2Bq0
HzRqe0gCuqBQZ3GU1oktWLp0L7W9BNwnzvoJHq1ZUxtl4Lr5UWKP6dNeA0DO
kM9ftZcd6iBPniztKpXDfnZ2dvbjvqGhluXC9e1LpUHfvrt7wLdPocJOHH/8
vosvfsW32rJlcFzn7gce6B8Gqr5n+9tu3TFlyn9v3DjcvBpnNLolF6rq8rgR
5pVKnNZPLU2zgdoctA7GUmZzlxnhFKramy5Dez5UpY3tgQKKq1Bnm6eW1iYD
tSnQCh2VedUVZsSSxQ/JZWpb1QZYWpv8DGjKpVFnaQoN/hrOVC67DY2NhsZG
Q2O3GbUUqs4T2yofqr7vNqNEqPS7GCIMlHIEKuD/ZWwt1Ibw3nu8HtM/haq4
uo3cGnKhqry7Da+zE6iq7Wyl9icfKpQaqh3aFxBynJRAAw/gVC7JCYy4OHhc
Vg20qqGpx0AnjXNycKac5UNVyXQbqk5KoKrP6TajYKFWckdJNTKFevPNH3h7
yFafXP66v694rS9zdjhLOnfOG74d71dc+L6P4AiNdrFaPexbHXXUoLeLFUNj
OWkvdpftJ0wI7VOosKMnnPDeyhUv+1a47+rafc89+4eB+tRTAx0dux58cNC3
v+GGV447bq/YUUJ1Ua3YJkhZZlyP14x8aKpxhAahQunkktBOrtVbD44ODBTM
lEKxUFXT2F4jiLkJVLUtxK2Wr2Sgxrg64Smdg4Q6r1Zvi8KcsDSWcuea2qiT
E2gatUv8UXCBuELLJDqPWmQxoCO6Kwa1VykG1WQXg5QUSuY1ABbIoysaPMUA
AU3UuipEhyE7xcwwsR0lt67IxwexJPhiy2S8us2cS/GoHFuHgQ+hjMCPjFiP
GUnCP7VWb09GDYFf9mPkZOafFnJlplbM+sNTElzKSz6u8ISUWm4KAYa3d9ZX
EtP8HK6Eh2rgpcwXEfEQ/bUcnJrAtdGBtrJyKRg6bPRBqFxV0j7CjnLtD4gF
aEZWROBxRt8G9MncfQMmPUYTlKIdZm/sNsnBPm/pDm+NGbvdccchf+9oqUba
8MOuq1Yd8G15P3v265mD1RBBAw2QASWX+qQLFIEuUEe6KqQLVunOOwfZrZpw
N3HiYTwsFA4x8QCRFQDSzSu8lzWcu29Df6YN0A761tz8Hs09BWayHD5jMJE+
oNDvn3JFoJ5lKOekRryGa1sm3MkNO6UHfIuD22aw4RlMaVfXQTQqFsU8gEZQ
Sq5Jf5F0im64+wr5gWwaG/c5crxU3KwtQaSLF/1g+vT31q8fcJaq8thj7/f2
7ofngniB4fvLrrKZGTdW5a2f+87C7Psbs0uEyXXrPM/wc0cf/e7aa3fm8HzP
V3ZNmvSO+DTPs8vlbM3OFjgXPB2yL0mG57lzPpcV4ECy4upLfgqq/ujL+7w9
xboD/nX+qdtgrhwn3lqDVRhoiQO5dsLVG33naL7l7bkLfNxHLtJcj2SEOslb
mIV+bgYL1pnbJ0agby1eqph2zz7d+72O8J6pKlLq57vOXAelIc0fffuCW2Bj
QEhYCZbTt7VNm/yaMvrtGqMfRy7daDZSP4AFRUDx5yvvKppslJ+PMUIoJjTX
+2IsMUJyiXqHHrDDoAhDA1m7NXeJbTYsvBY9HeySRuDB++oTJ7ESrNxXFt3U
f9MfArSD0oTXMEwADQSELsQG9D3GNpJmwtbYZrKTCO7JO8XrMwO6oqSENOIJ
3lLhdBoJjUngggCYGMlffKxW75cKCU3qeY92faPs8FTGzmZgKBXNJgWaVIds
JsJlesrEEwckm2IoT2nSvsc6bOgL2OAHbUcb+ZIexR7oUQo7jL60hR54xHzL
ca6FxlQpLboS/w3XDyEsiAZyAGBmR2OvsfUzIdKi0htrerQmtKAVKJzqWmis
XEh0XrNDUwMt6ISuANBqxtiNW0lX7IEWjYRjFqwuDgECACEtxxttS+efSnya
64fmpAW62hL64VYgO64rHAHaYtJlc1zNQX54BF7ByXTXQiMHUlA2Izo9UICp
gq4QC7MiGpc6XiscYVLAFSnHQyPxpjDnMcZgGnSdYKRUSijQvOOMMI7oBOuK
R01mPNoTrQyxvdN/b+uiXvucZGMYP4Cj5ve6FmoNSIn4HfEKvfXtwRJzEBAG
aBIaHQUlehXKQPqNMbrvVv8loIic9Bqdpeeomn6uVQMoxyMI5fWXd6VBA3VG
o3rHbYVjQFoIqd2MR5EkJRHInlffxDtIAYzNNKNQUcpEEqfN/zdGYK5dBZr9
l/MuWZfdKA+zPwVEjmJsRstQ+eIXDzoflcWlOi0Gb4879pcwCY6fCqKECO7x
WatA9syk5YwZ/4GWjHOYU2G8Jat2l5UrD164YnL2moRg2QHx4aRH1/KkhxEc
6OEFXtDuaA6gzGFZuTJCO7TkTJ9LPfLIAK1BKSnBWy1YcHjpJ14MNIt39kFQ
dsk/XfnlsIaPGQTSgvvx438FWp56amDsmJ0Io0iLZgpIyz/e8PUITXz9zGBb
li97vq9vEA1JDWcJxgpjirnBdn5naeCRR/GIGyp27U+7ibkOUqhFbcbmcIRw
DwAAM7Dlb+ifZwZths6IH3IU+IwvpiZQyOyLuV1AkwlbMrOT+IVixIfOErYG
TvyeQVxJ4V58e8zrglNMJGL0+WzONrRlK9HdyHn0iF7HaaVpRDifWo2N5Nqb
mDDV0SnlRgygg+F5kLXT3c+CAVykGW1pVzQzvyVYkCz8jDK+IK7mwY9AODHg
ID+Ysw6rt3a0l8o3aQZLoNl6zuagQTIxXdQQvQwAy0gWkpHVMYRs8V7k5XB6
K0gLz20z164KWaIfnS6g+d2/5uBZgJXa555U405fzfkyP6bkAv3QFL947bD5
uIDyB1o0cHOzyid06aq50QcBJ/2Hw1mJsmBTiHdWaAnksPmgzmHycSNEBOni
FRpwXnHXk2pCGxt3ExhwONziFZz6AhuZnBlGh74FABwGv3oBzXiC536Xm/YE
eAEf76iYusOA1bJcOu9UiZoDyNRB50fKkSe6IGLyazNGqIia0UH0gT3AD4nF
U1mHNhp8zt6UMZJoBeiQg7DJvujFmA6EiiY5PNmRrhsoZNz6vc0/OXTnXdGj
hXxQXs5ufMDF0MzvCcc8u8/ZVAOneM8IULgZPwLcMgWXeMMfbH6ByxxIROTk
MGcTwsx45tzf17Wgrp2HZudsJpyShiyYzuDM0FZ+56ASxoPS9K3Gfyj0Qs17
z7gefObjvws9d3RnE13/dH1bygLzCdAhUHsCNRhLkO3te8jGM9MA5eDcxKsj
8+msxCdoA7FuP6bPr0vPPtu3PErpbEpXtTvve5DrOYYUMea2OWy9Jw0rVrxJ
EJdddtj5DUYQGcOS5In8zj9154ThKWfmCisWCGHH+sfsipqUT3JUxCUrda0y
fvwhEg2NkhmrOU+OSIhDZPu2pE8yhhd80tHRzzZ4MpRK+mTREffDXBACmKKh
x9HHtV8LHkLT0Rr6ITY2y2jUMN/jyt21L6Nlb29t0qSBmb0uw+GgltzwZJ2d
+xFzuCdlWPrZs/52ypT+qVNrErE4OltTOvEXJgRIgAqqTh9PQtDB0eVWYIWg
hphqkBjsHQSPeSx0yju3ypdcGB6Ll4tz2mdXqR3gBO9l7n8swCxDeWG3oKcA
K7aj4N+4NSgtbAPg4i3aYCWFIYPmgTM8ZJWRzRHGuhY6Cs2MxSUInkJ1xdd1
5EJwcBtADQgGMpLImQ/iHU3cIWvEUDE0gSxAHNpAIhDAG9ffPqTCijkVWsGY
5uAqgWEREDpvMyq1F7uvuQXwWLcFDGgG4QOnSJG7dPOCNcAjiAlc/utxC4i9
tOP4UxAQ4AWYdfgb6M9ffPTvM2IoFP5kwVoIK67oCeXVeWc6COWXJswGRBam
id3lLsJpQyzC81f/MSIfEMk0McZZssT0sOyNX+ChdwQVA0U3i2mxD5fLXkqM
2skNfiVvLDAamCHGkAI4hEBJ/921X7Xznhn20808KweshJqRLkqVieci4Lqc
GJ9kJZfzRjNOfD+aXPK5V/KnTGb5q5lx2F50jEl7cF029JzO0S96A4+fzfh3
hLu1e4z5e7f/93un3W1Rx/CzZf7F0AmwgFkBBsAkaGfg7Uc9F0aFFWl4erhQ
3NfQCi3ObddCrcJTwEyT/dzm+OtFl+V4brsP9P+Vgu3PnMJ089Rpn0SPTOND
EhJ/ds7l6O+dv8jnODqCXfIReZZBlzi10DPW67295LwYlVS2tU9nHSYAQ61h
CGwtistCsU6gCb0xyyEqjAlExegE9kgSQVu3Wq2nbQFqRvNUK9o7UMUliqOq
1eSm0RhDw5gUmEAgeMZ8BZ+sV+gNnHLJCCUHClgtqDY4qBi9Jue0r8Ga19te
2mXxEZ2mr4PVgPegFdKEKIGMfINERwczcJJ7AYDohGB3WPXK7C9eoaPbnAny
rfNCwIB+YgBc+wZ05GhTKQGWvDlc9M2NjEk++9mDXHQxkU3H7LPJMWoZ3/OS
ZJPpk9Pohj4ZdB07ZTubSibG9W4EHEDjaIMjEHP9dft9C3phF5m05O5QMRQp
FmUBEnK8GsMg6hguhmFNGp+4Xi0YZ+BuaRHc5fJg7ibcRKWnKfVUL37mapAO
XVt77cvz5h1E/OB8uMTWF5y/va11T0/PAYlCiJvRSnv7PjyiH8eTiRPfHz16
36JFL0jk5HpLHmb+/ENXXvGfhL1t1VrrV5MYtZLG0vB9oJ85W8CjYYOIxRJo
nIwH0B+mLlxbWU3A+yWrCRMNu7+SIYGk7u77g8zORZexLjOPwX1dsaDDrijw
HkOPtpJFmEZTlczRe+dcCSCy2iT28WGWcB0HGmS+h0nk+pe5wqc1ENwNBnc1
jAtTz7T3fm5FUEAJwXCxC5FwvcXVEjPgnMYxJ1zhjht+mTwCWbkrU18lTflx
4TwjyIILeabk/dp0XBg/2mJMrbjCh20Ap7jjbkG0ppj9Ma9coY0GbAo55FLr
diK45o67YNxRClmHCou+mbtgVjvmEhi0ccVfifU5THYAwawEE8gHbodDdyy4
uwYmXD6lgltKpuZSEiCuOdAEZORSnsS8BYSARpj2zMeAZIADjQDtcPgcELrR
TKI9c6WUnmT1ok30lddxZwIYmal22adqzMngB0aQdDLz6jmhzJgHYh6ZGTcW
rceMm0ziEJUXuaKWrCEzbvLG+VKgiPXrPkNVMBBODLJhlhwNHVZfL8zMnPiZ
WG3vaaZX0CwiMWMQsvAzKmDymciYZwQa9It5RobtQgtzfezHMFjzcoz4RdZ2
P4kZThnMLONuBWnXPGTMS6a5VeEZlDB7yOxqPEGA5xK4kWdOJ+lXCpbNW4TW
YPuykNVlVlmzkMWgB6Q98kzbItw5nD7bRfsqkuilgQku48A119161ZNAJLpV
CmPuM8fUEpAMKrj31mbGvBzmxZqLN2ElFH1Qbxghfx6AuW2uHeiJp059BS98
xj/ZvXj9ihvr6hXPPcfTUQkePIslNKRG68GZ8d9z693p1orP+IPauL2S7D/4
+sZq1dcnl/ef96mcnRCtDs/dCUH3dCcEnjlnJ2T/gsV+J4S7L1IJQ0qqgcLl
y56HM4XH5Sgx+37fmbfU7WCUgo6ddeZzp512KOx8VJ544oOOjl2iqm5r5K47
93L8uMOyoG87hrAU/FeEuGHhtTQ81Axp3dc3CBeP1kllTHKixMmzyrmFkZeC
IbOOM6ckvOVlHM3kQLuZwZGuWDkRTS/xFaNX8ntrpEp3/WaE+cCsWvRuWkHm
cFaYDiAt3JUd4y12Y+JfmAJNtZjDKZjLxkqcEPoxTQNmY826r68fk1g0t6Z2
C1Z2j1JKTs8w787VGzgEoBnGJnJ1FOerr4ScHqw9uAHqaKN1t4q7z74YxsmA
85q7z1obTS8D0bJ0A0xMN7hSCtQeTgu2mqEP+rWYUSAm75izkJdESMDCMy8r
rZloDjxRIYBqep4NHlKLw7oEnq1jzDPKjMrYANnUJSiMeKoJPeIJLL8jwON1
AmdqgOuz6Wmdjda2u/i9bodCT19xTkTplHQcAk2q55Sf1hq3JjRFoTM2TzjJ
r7M5xvWNuymAIDSNNrrQEcbU75gHmrSmgRk9raBpGwJXNOZYw8lItT/AzsUW
IEjfMYYf0qTzYbjaH62WaA80oYfWOY1U+6MjOsnNmliPBDIYWI81us3dLq20
CFQppE5va5jXJLhYvOWztHbUbMWNq4yz50vBOIhgth3Yx9JcuTaDC87YPPW8
Pa++6avfYiU1SfTcap0Paevf+97js1b1z+/zOVdmMGKNHNAMPQlrT32kM5Ox
TTxt1GBOrmLUKFNfoZe8FR/Op1FL6ig3FWH5fUscPXR/+ISL7Aq1M8xzH+sm
lTVl7trqaj+NRXDPVMfPe3+TMA8uXuJhckdy3cxNPhDJXG2knymu9+mn73Ij
7GoUBeVFn9lJoJ4Pt1b2ocwEXw/a1P+pT0fufnHMXKZCIjmcebGO2Md89Ftc
0WIcmD6oVA7HXfwqJMsDc8XiIY7u9i89OGTlTJ4md73vwyOXoaqr7pUakKGV
rlr54Tlz62cfGJUPhbPMyar6Z7fcz/nfEuqNJV/EqLinZ4CEYqiSOpsGdJ85
8/2ln3iRWVLYJibyxLhkTSyWZkaZyVS5uPznLKO1+z5uB6/08EN7jxnz6sZl
38Ej6ggajOvcff/9B3K43LJlcOyYnXJmhRonUdZFj0zreOXmm37VY+A7fE3f
+tZ7rC3mDgbT5qQb5Dq6G2Asmavm/sIF528Hk4j5GJs1BavGGnXmCX3um5XQ
zO2LVh9jZgtrWtVD5dfKq90ZZ2b3lKBPEbesV4ibKQtmBmMlga/Wt+cU1X7m
USDW0p58S2v/9SmhGVs+hB/1NF2GH0I91TwVnRtuFzwrQtWYDhgGmz21otSm
JzD06dATGJUwSh51/ukY4x0S+oknnlrxfmi4UyusqBkejz3BppSnp2PULw+H
h/VSAa6evtEKT3umivDnBT68Vx96mkhPx/hy6JyxoUdSj2fPrOjJJdG+0bk4
HDxPW/5JLo3quoNsvZ4T/slBQ3xE3e4pT88nBdcwFLpKxp6HSqFrPGTPeeZD
1XOjPWYk0zNt9uSbzqn8k3L2ZJ3aHEKda7Szx8gvH6pKgO11DqQnD+kLFy18
q+7U4+rVA8OcPORhmUsvDScPV1/ylvf8eackA25WLHz0U5J63iWFumH9Hizc
JQcfcMspD7mvP8kJNzJnzgdLlvxYT1NOnrznhi/sTqDpCTO1QflnV7UOm6Oj
Na/pKVPbStcD+VDtuWU915ie3rWncXUO5kPVmW/HPD1hbHGrx8k/YTz8GcYU
qtV61ep8qIo1/zR0/JZJnYdQDvPPg5vTJokVS0+Z21OMOo/zoeqYW95SqCqX
eMbH2xy7U9po3lsLmEK1Hlyx1J/at9hVnik09cjjDA32ewVNuTRqJmKkryAo
LflfQbC06qilUNWCWVrtdyCazXsb66RQVcrjDC35X5fQmcz2mnsZ+uUOsaNs
xdp0sZP5X8KwZxnVjo701Y729gPZh3+1o1j80K92TJr0DsJuH4mz2ps1U/lf
GWFJ1fLlL4V9+OLXH3j7qKPetl/usN9Y0Zxdm4HLnQKt087/Kkoe1BBzCLA2
M6If7YstY8L84M7aMN+qMVnBZD6lULVVe+DY7w7Y7+rYcyMjfQFHfXu70eT8
r/UoFN5rXJNC1eh0tNH8/C8LDd9+pK8g6ay1X0HivXoTm93Ltyjx+zl+tPK/
2MSdaFnNE2r+d1VUB1oCVF99mv91KYXKeaHxd2pTVf+ak9EQqPlfwuI+l6wl
SIV6n/TrImoTXVRTTZNJT37zh9wyHPLdM4exytrab9z7bFoIrWslf84o9d5a
C+S/TJZkibYtvwLNw5fJuIf+44tvqMsilYO8QJfW9s0JGsHKaf9dtT1nLdO+
w31Xra4WYs+8MwC6mECTMUm/dcF6cvlKAk97n9G3Yf2y22taBRGzNMN8KS7J
rjy+/CZWajKnAI7EgqXfl0gq8dy9Zi7GG+g2sxF3gevqEX+db+7xK33ZEf8L
VTETzQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169067544]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshShading",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->33174899],

Cell[TextData[{
 "Alternate red and blue arcs in the ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->351997637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->413205558],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433717958]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45049747],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to remove segments:"
}], "ExampleText",
 CellID->323578077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->740997133],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36182044]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->92424864],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":  "
}], "ExampleText",
 CellID->101485524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->704368403],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->594799939]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->340907862],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for styling:"
}], "ExampleText",
 CellID->649526388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Green"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122170518],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->694022332]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->396031902],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for some segments by setting ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->471593942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Yellow"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1946430847],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62041805]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->569574655],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->117954844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "\[Theta]", ",", "r"}], "}"}], ",", 
      RowBox[{"Hue", "[", "\[Theta]", "]"}]}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->313117170],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1017086803]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->437002195],

Cell["Automatically choose the mesh style:", "ExampleText",
 CellID->37436979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199280146],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->422889348]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->264850292],

Cell[TextData[{
 "Use a red mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->12231612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1608970669],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->493873382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86860238],

Cell[TextData[{
 "Use a red mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction and a blue mesh in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->187069462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1615129237],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->389871262]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->271034964],

Cell[TextData[{
 "Use big red mesh levels in the ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->2133487437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1417585583],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->476694663]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PerformanceGoal",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->108763122],

Cell["Generate a higher-quality plot:", "ExampleText",
 CellID->153330426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"PolarPlot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"8", "\[Theta]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", 
      RowBox[{"2", "Pi"}]}], "}"}], ",", 
    RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77547222],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{262, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217122318]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108815668],

Cell["Emphasize performance, possibly at the cost of quality:", "ExampleText",
 CellID->41034161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"PolarPlot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"8", "\[Theta]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", 
      RowBox[{"2", "Pi"}]}], "}"}], ",", 
    RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->502356967],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.006325000000003911`", ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdlnk4FAoXxtGi9BFJJVRUUqkoS5JOpNJVaaGErkQJlRBFFNnKWkxaLlKy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       "]]}},
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-0.9803723185736427, 
     0.9804534250419442}, {-0.9800362331456026, 0.9803292339432086}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{266, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->548544896]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotPoints",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->84058811],

Cell["Use more initial points to get a smoother plot:", "ExampleText",
 CellID->232590798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"2", "\[Theta]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "i"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "15", ",", "25", ",", "50"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269859248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{0., 0.}, {0.7626731933458819, 0.6060523051392986}, {
       0.05732071155171966, 0.33117396879624333`}, {
       0.4138720309376352, -0.7428302103326321}, {
       0.6567829152488086, -0.2746715537293464}, {-0.5758008109117354, \
-0.19513710039673385`}, {-0.48963950997699046`, -0.7648582128359949}, \
{-0.05113798073683855, 0.3135719294125796}, {-0.7567886244062836, 
       0.6263594769052809}, {-0.043690176424671136`, 
       0.0009551000017518961}, {-4.898425415289509*^-16, 
       1.19972857745771*^-31}}]}},
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-0.7567886244062836, 
     0.7626731933458819}, {-0.7648582128359949, 0.6263594769052809}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{0., 0.}, {0.6902880147673789, 0.31796549901745147`}, {
       0.605749074894988, 0.7627462934567868}, {0.1047860153959811, 
       0.4391692530225657}, {0.07305535818987781, -0.37152145603692616`}, {
       0.5927063381464095, -0.7655061494615788}, {
       0.7255024483677116, -0.376105464706424}, {
       0.016550849134204418`, -0.0001369793762847206}, {-0.707767682878346, \
-0.34463676296263035`}, {-0.6222298765461851, -0.7581488945827144}, \
{-0.09338678544919356, -0.4165680291259972}, {-0.08907199027592193, 
       0.40755644305378347`}, {-0.5746724838363648, 
       0.7681504931717141}, {-0.7165448380735826, 
       0.3595346980374239}, {-0.06517236132641191, 
       0.0021271127003248567`}, {-4.898425415289509*^-16, 
       1.19972857745771*^-31}}]}},
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-0.7165448380735826, 
     0.7255024483677116}, {-0.7655061494615788, 0.7681504931717141}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{0., 0.}, {0.46736303768490195`, 0.12023366302865254`}, {
       0.750507785463936, 0.4344877988875007}, {0.711099764822528, 
       0.7029977425349978}, {0.45498203523983644`, 0.7568987527746692}, {
       0.1372964503336002, 0.49576407405618117`}, {0.000590723474760262, 
       0.03436456720983765}, {0.12494533692815969`, -0.47547233778735}, {
       0.4361773398467974, -0.7510815188125027}, {
       0.7011930843218728, -0.7127829639691081}, {
       0.7490118290338575, -0.43019385944496846`}, {
       0.4912270346514546, -0.13446318431804902`}, {
       0.03603457057715033, -0.0006495616117605873}, {-0.4681769210432347, \
-0.12070095374589744`}, {-0.7408992362555906, -0.40915921312253983`}, \
{-0.7122427813433143, -0.7017771186270513}, {-0.4339752368020886, \
-0.7503320680549603}, {-0.14099664599824183`, -0.5015891475926081}, \
{-0.000012577309745341818`, -0.005015414460164777}, {-0.11944250530174448`, 
       0.4659801437290021}, {-0.43543053206458016`, 
       0.750828954929639}, {-0.7138291514262163, 
       0.7000485886673884}, {-0.7502297541702445, 
       0.43367782494037066`}, {-0.4667803418345226, 
       0.11989986731865133`}, {-4.898425415289509*^-16, 
       1.19972857745771*^-31}}]}},
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-0.7502297541702445, 
     0.750507785463936}, {-0.7510815188125027, 0.7568987527746692}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{0., 0.}, {0.24231258350423532`, 0.03003695064377462}, {
       0.47557056203593245`, 0.12500317321201773`}, {0.6418184428742745, 
       0.2577495544171047}, {0.7407457125249641, 0.40879125248469744`}, {
       0.7687324120830845, 0.5688287721256483}, {0.7233151103276559, 
       0.6887862396968842}, {0.6103095236706777, 0.7616025590182707}, {
       0.45807045225341536`, 0.7577541151605647}, {0.30456240636332554`, 
       0.6806164987116603}, {0.15411721685589494`, 0.5213817962450803}, {
       0.051922852992206295`, 0.3158710749395311}, {0.0033385454544584154`, 
       0.0816110598365622}, {0.01663748620836763, -0.18127021344175429`}, {
       0.08899999776561283, -0.40740378991087417`}, {
       0.21977503311571955`, -0.6039456825442292}, {
       0.3788871526893854, -0.7269242479546755}, {
       0.5299087599024822, -0.7694451226354202}, {
       0.6681283093165626, -0.737501612935354}, {
       0.749512352386423, -0.6449871508609738}, {
       0.7661859724394332, -0.49769864211699355`}, {
       0.7006095672615442, -0.3332850544753637}, {
       0.5679874663029088, -0.18874920845913468`}, {
       0.35943669042773996`, -0.06810737044253891}, {
       0.12454194290731982`, -0.007801034617305031}, {-0.1189090662430333, \
-0.007107605380620143}, {-0.3683334711683068, -0.07173002948634749}, \
{-0.561653035014536, -0.18370223858756493`}, {-0.7055411203408956, \
-0.34103517169098874`}, {-0.7671855501639901, -0.5047763632581763}, \
{-0.7518713129959511, -0.6394692292651475}, {-0.6652550609937047, \
-0.739195497999572}, {-0.5361734686195322, -0.7696860292527734}, \
{-0.38651448028201396`, -0.7307031924557762}, {-0.22574404096905293`, \
-0.6103194353306532}, {-0.10193297585416243`, -0.4336670724228618}, \
{-0.018697501695980313`, -0.19201397712829218`}, {-0.0015511955784204405`, 
       0.05566669690837549}, {-0.0443573970818246, 
       0.29282513467733523`}, {-0.14993249690100344`, 
       0.5152098783857795}, {-0.2880258383784397, 
       0.667828294291727}, {-0.45537003283540856`, 
       0.7570077671123147}, {-0.60813829304396, 
       0.76215898842119}, {-0.7147542958096601, 
       0.6990215100967891}, {-0.7683247373335889, 
       0.5730541468897575}, {-0.7466981414498695, 
       0.42383862853968435`}, {-0.6547759906362054, 
       0.27232779840577664`}, {-0.4827325764874765, 
       0.1292706152804628}, {-0.2699458618271065, 
       0.03749485134117544}, {-0.008010248829566052, 
       0.00003208281513914857}, {-4.898425415289509*^-16, 
       1.19972857745771*^-31}}]}},
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-0.7683247373335889, 
     0.7687324120830845}, {-0.7696860292527734, 0.76215898842119}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{452, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->41557373]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->128315927],

Cell[TextData[{
 "Show the curve where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "12"}], "\[LessEqual]", "x", "\[LessEqual]", "12"}], 
   TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "12"}], "\[LessEqual]", "y", "\[LessEqual]", "12"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1213642703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{"\[Theta]", ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "12"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20474098],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46965649]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23150485],

Cell["\<\
With the natural range of values, the fine detail around the origin is not \
visible: \
\>", "ExampleText",
 CellID->406967595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "\[Theta]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19296386],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93849943]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to focus in on areas of interest: "
}], "ExampleText",
 CellID->287721820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"Exp", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "pr"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"pr", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "50", ",", "250"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->47703644],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->9397653]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->164733175],

Cell["Use different style directives:", "ExampleText",
 CellID->144211486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"4", "\[Theta]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "ps"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ps", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Thick", ",", "Dashed", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", "Thick"}], "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42985262],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->606212115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19034328],

Cell["\<\
By default different styles are chosen for multiple curves and regions:\
\>", "ExampleText",
 CellID->702451365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", 
     RowBox[{"-", "\[Theta]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210197233],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylm2+Ip9V1xx/n9/vNzP535zezMzs7u7PurrpmNdWapH+tTTcmTUOQQKQN
IS+MBPRFkjbVNxaKpZC8sVBSChFEobEp+fNiQ8QksAGJrSiIgkQSopAoCUZQ
BJcISwKTz7nfc59z58yz62w6zM4+f+49f7/n3HPvc+9Hb7/7zs989va777rj
9qMf+sLtf3/nXXf849EPfv4LPBpd1nXdo/x7aKXjeoOr8u8TGxsb3ciuyk/3
d/an297TGfszOX/+t889+0v9vvzym93HStuPl3fc8/Thh575t/uf+PznvlM6
z9x80wPd5JbTD/JAv5/65Ne7sT2d40qPHvjK0//9yHP0ffXVt7oPFoq32t9d
3P/g7Ev/8eUn77rzDF3UAQbfPvMCrSHf7bF2u8WZX8hAjEZ/e9vXPvLhh9X6
6adeeeONX7+/0P2I/Z3nFrpf+uLjH7v1q7T8l/vOfvMbz7/wo1/NJp0X7M+O
c+fOS6977n6MDkhBzyd++DNs0d1UqP61/Z2DKoIhKo0g+d3HfsKTbmeiuVza
IjHv/+ne72MayNLP2v5poXaL/Z2FulpADYMi3d5E6VBph3a8phHK0oFuf1So
nC4+wYIYhLcSuZvwtPiF/2f4f5JoHim9UFfG4e+LP329e2+h+P76DqGwGrbG
Mt28PR0HBdHegpzm/mihQ1/EvePT30Juk+zG0vnmQg0eQgYvRjwx8uNt8bEG
xyoN5IQ+nr6hdCi+GmNI0abBnkuW/crSA5vgYGyABn9QOv5ZeY4P4QkCoL3v
kmlfXXrgMawOyND9utLxT8pzHIvF4cnz/ZdM+5rSA9QhH7pzcap0/ONqEwwF
UGCy35ExugBCTlXr0oOYoEeh3RXUjaCB+pYZ1lO/a6sWdKIrBE6WfgVbI3rQ
DwW7K1K/d1fJERvDAJurSr/3lHY4gH7IX7xu3a5Pz4vHuj+s3IkVUTme+NxQ
5YAP4didKP30FL/60ytTr5Yuv1wU9LkU4MSluCr1k/RQhK5FftG6K1gaCf2W
C69OvWQrecuolkiShUbkARKJReTJ1Ot9jQ4EgzzTFWyNuKeXZbJrUi/5kzcg
3TQvmUFedF59r8mvfvTzrv6cve+/uvnvfO4/u8mTXz7zzEPfe+6Rs7989sU3
X35NyBlhJRBgl2uF4qlKEWQaxWLhudd/+oufPPb041/8n299+v4HbvqHM3f+
u9GegV43eunss1Dkt5u1Pzuf/8bjPH/6K4/C9euf/NKDp+/h4on7vwmB8+fe
NhvOwFHc3lUtiC2MW0HB3CtP/Zj2X7vtX+EGTzrCf0sMlfw7/9vzv4HrC2f+
j4YPf/heGKInBrjS+ZSs7NbE//AxnxT/zmIF9Xrs7geg8Narb+QRZ1rboRRK
f/XWf4Y6t8ed+mqhLg9DFxwYTpRREZsuCCTFux2J9oFC+9dvvAVtWtGWhqhz
hdM+WGhfXf2Oh22Q1YhAM3ohDvKbt3cn2gcrDniPHXG6SVDkGhFvhKNdLjcc
GNUZdO3ycIkhvCpbIuDgSDfhBU6GOt426keqpCAH/Dj1q2r8w7ZH2RjJ8C3Y
xOaXe6YQXyhBD6o45Ei1q+ewYjGP+cBMkWaMRZAGIwKVhSTveqUMqmgB88Jr
hK/wmOFhqVA+UTWAn42zhfJIsmLCbjHRvaLqAlFIw2CtyRh2udjQVVlllwU1
I9Skn0XiUqKrXIgBJGyxmSFC1I5XLCOl6X9QUp97GxRbQC4nauIOH8LQtJCM
GnHtslhLo3Sju6jiHmQgHruVRPXKxuoQhr20Iq9hU8uhLV2gBcDsUnRwkut+
0L0vFBLK2BqubiNlNrssY6yPRlBn4DXde2qIAB69V0h5smoBVcshek/OI4Xa
5eUN1YiA5SqLFHMcpNHbLO62OZjiX1SPJj8tN7Ia1bVEVbkQi37/3ofIBE6V
8oJ4sst9DVUe8WKjZhHTEKpmt8OJ6qlKVYnUqUb/EtteHSArGgRVaWheOuBe
ytXHtY3MgZLwT0s9ywxc6bJRs9VFqqXrBrkEpkrd6Plnsw42QhkOxwOy1/r0
uqorFjSMLNdIQAfDcUs9cudSg5GNmhOzDl4TEmjgbY4ILlL7zOpEE2GGXfGl
AmCEt8uS092fYIvy3yy6VG1Bdq5xMlMrzjlaYGPwzRNmaAS5XRfOcxhLMzFe
EFQ8szgX9sky6AFVlwIT8tIudzVShMUlBTmPJLVRM9q8tCUzowHTPRxulUon
FNjMSLUmIpALSejCBQMZw0zgIhDf8g6JFmscEdO95Sc+Ae06DGh2yhgq0WPz
L3Iw1Xw7mo6A1c9++HxIELzKbLHLWV3aK6X0+B2ruuAXA2SslVw4xgL9XEc0
8TtkzPsHkvdbzpGZFpPFFDl9Cd/NJb6lvc/fMCpwFk6JIsIvdAm0t3yBHI/s
clpRx8Bs0ioCNUswcO3w/NB7EBMjskdF4GQp4ajURN4qjZpWV1Ig2OVyfe/V
++AcfkyMQBUtuejHRKLE5F1KUdTyjXF5MflV2hDwXsnvSnz7DC3A+L0K5dA2
Rpv5hqtUCdsCQGCYo8BkzbWdxjCQLKg515BaWvAGFsF1tVqAwIxWgXzJGnX/
nsT1UO0PV6vuhADVPtEftwMKu5xruEZETyvqKV2jl3BkFs6V5lpFp9eUK0nq
xYSn4NrXS020LFYdfJzel7gdTtz6EdszjfoTEqAo6xj1lHRU6Ra9YuTY57HS
18vux+VB3YLubMMNJ6LGRs0sjUUXUyxdnnRcr+jxyldoi3EsW1RchbEYW6cJ
6eoVeTNzPZqkOpAwO61SkYUy14weFTJxH+/3J651JiVupCAS0ZC0k55boIZE
x/AaXKL1EJe2cvaMeu5tPGIj6qLTbXUKNCzU1kxDg1tYKs9ljlVPeFUpbiRK
0uVQ/0nDNdX8TfROB6XKM5LIZLJRjCLTagOAaVK1XHEpjg2q4YfpAJZHvtZV
pAOWVikfrnFHeulnayPMC+yDTmg3brjnSCEVkBDiPmF6j3SGMTCDgxY7iA3c
wzUX9I75iRa4wyIx0k3d67LEomtWRDMDlR/JHRE/6612pBgs7Sa8gL2WCWxM
K5QnSIpKoBV5Ta79TqPYoBnxJJ9GmbJ206w670lxJPsVK8+1q5oenPzIdogD
e7vMaxuzg3iy2r3rbJFIIymKMD7bnHSa+qt6i7qnvLfZJm6wmOo21dcSanfV
2Ec4aWG69evVF9Nm3Ed822OLTjFu7686uUX3VBmZERMWADdnipmKYx8/Fhsr
doM6yTNRh4226ZnIXsOeiZgsmXoMnvCExVrnoyJ6+Tw15/JRiraCdFt4uOgK
uDwec8ALaeJpa0CTOUfrjkENMLpnwM4ljpn2Hu8p3aPGnlZNcdfF7B8V4u8n
dWuH+SHpR4J1bSoPREWYK0DNLiK2++r8wdP3XEyP0Fx6LG40c0cbfbs2L4UO
894uy645FeDVKLLJApFnd2+yfsJNF182VPtF3SoZV6psDvEsm7jF6NzLpHpm
k0wxa85VjqjGKLpQLey55GKyRBZcSBiXLOAQriFLrvd1n2srsiKQjvsYx4q3
fHRjKu+EFwY0sPFH36ai0uq2zHJE/5bTDwKloBSzL72Pyr7ln3vl0TXVoeM3
X37NV5S6LXPZPIoP1yjxXnK4a8rPGf5dplsNuxYAKt89a+UsFvcl28/39/ww
6WMSIDr5u0AaTfiRnN2F2m7hTCDq0ZZ1qcH2Nvo/9b+2suNfenJ+zb36ex9e
Lvi+5eI5Q3ExaKF8H1mG6uidevSa9Fazas40uWzIcwQqcS7kbPJM1BXb8UxU
DdvzjFaSLskzuld63b5niG+rfd7JM5IiVsK3RT+kUpm8pdf+TVYXDVzob7Vi
11pRle5w7khzo039VLJrlIucN1h7T9oKzCJpqZEtZ/w8K4zMM0322iqTMnRf
JfjsXnRzdo95/HIjTaxdD/cKTWUxcAE67PLyLdIIzZIm5vGiG7ViHmtaaTbP
OrbOeSIC+hUMxtj+S8UmafQpe3/Cg+jk0WZYmpzRI4/m+U6/UuVf8urKSPsF
4f8jSZ6fxmwte6ld/erXoSKGNBFxXr+fLBee4ee11QNVFm0M6dpdMUK1+Cg9
Bt+oVoaxojwSs2Zfeejn7PJGxFGRY6wY1c6SXVUSsCyXiUasHg1HQ+SLVpLA
wTBOEBP9+m8SE+1VgTCuiJ1OtnLWdcQXr9Uv1hcWKr68osy1YytNrreiNpRd
orIqVeAsCOU9ptMK+LfPvDBjA8cEjBHQSMnzPoc1ETqcvYAGAMkyhV2nNW43
zRxRg8rSLHSoaqrtft2MbfibAHYyixfrvSx0oQALWXIVHPhuZck5JOqwjJvj
HsUZpaIec/q8clns6mN0YFe9MC9qBbf4bpL3DS0MejOwlavK4Gpz2H6FeNPX
tqiFjw1yyytROf9G/1bHvK6cvy0G4vIeLOXE7c8gxHVuUNb8VSssO8w1j/2x
syNn95ZrrNnmtdf8HfVo4qpxMa80x3g6TZhuuUb+X0woUo6NkWo9cdUMPL4f
qX/kynbGbZcHG648xci27tD38m9ryylSjnik7Bu0UVQw02QjcdNsPDJLntMu
J6p5Z4DPt/tsuTRgWYuJ1YZb/k4Quq1Ubi5N3t2wp3oEgFgWyV/kRC/tCfC1
nvCuWsU6xkq1gfsxf4XfXSPNV4L6L3qOWdGL7NtyDXRI1sh4K/U9uhjVvOtE
a136pm7v8zf17M/VhmuMeuIaUa0ZN8GFOWxXUN41sbP6cxPXGGkW3Z/aEafW
kWPyt0p900Ya8iRpBIJ5X5HGX17gdDyAyCtJz8XkvdWGc2S//gs0UwWrSf1r
8CNn6Yi2/d6TPqa1pW7L1yFxg5VWW0THfZG/c0ZNcKjqSRMEolXe5VXGvzHy
Ak5+abo6oKdZdq3hGCNM2YfCuFziz1aD4ISIOMq8lNeINQ9X5kIeLg4lzEqD
qGKkp5Ae2bm3qn9dLF8bbScjrgLv2mNU9/bF7Bqx9TlBkagojj1dS9UHnlfX
Gt75C3Z8Yyw5fQfv9U0FIbUdlAhoVj2L5vP66sMttJATG+qDy/D+m8CvJFGW
iTlbX0t7Jj1WfaANo0SKLZnOUPIUnNo+WVsPtfuJvvtwi+CxezLw1o+XHq+H
GwkC3YqaGHlOVpT6mn+eva8n2x2o0eBjubjsTagWl6it8u7hutep/8LtqBD1
mHscaaiHZivJ9ran84KnFZockkdZUd+XNMrU857ubCHpEHO5rMN6w4Wn2hIa
+94aLjMD9l+r0eYjzHLSQdRVlaQR2XTwvdTvSlQPVez46t1ytbB/dSnY8lwQ
9UG/u8cjP3t1tcrqezZWUv+W6uYdY+2uFkOkERU3AOTcVipSQbKhQHvi+/rZ
94v1+zT963feI29UZgCm2kVdL2rTZF210n4QJNyyT1++1i4Um5GrfVSH2u2f
97aUVnYqAM1QmkR2ItFVLDO8MwbZNG41+ed4Q5d736O6VnWnl0mb5yLTyleH
oPrdV2EF0V1KNtUeabREXn1vzLX4QsPZTmmsJTvotISsFbMP7bDW2Adpksx6
oqtVep2bwVK0WEso0PkN4VcLmBs1ssfYgGpQlA87qvZWimBAp2UOVyv6lwCd
HxHaIp+vb6YIJAZrO9vRJ8rAwWJAOSjqyJZ67CAt9pxAHfthDPJVxE+qqCbK
+MFhPUVZQbxHT+QbjTTYmnTIpEEH0NwjwWGuaUUhrIVJn3mFN3UyZ7Xazfep
6qwEEunsnHZ16uDclv0bZWy1E3FKbFq28FNumtNGZa7zQ4cablZtFjvuAHH9
8T/+9icFbZ1K/oAnaUB7PVGnm0GtkhmR0rKNIk/7v41byZR1n1fhZv4pMsyh
SX+CEEfBE8G7eVvbmGd4tFOLXceFdrNiOdS5utL3Kljnqg43/gdgfkZHJwkt
3mftz8jLuU67I66pUYmkRqnsdXZ8QQmoAgCd2GosfbJa0/nrzNjRihk8alq/
L/WS1KqgrFeRL3CABJZv3pt6KTsSgu45nX07Vi1AxFqR8Z7U60SjARGsM1We
u+QB+ypxY+p1vOYBZDELlpNWPlbrCICNvTekXseqBr7/XqcKJTeyeSV/veeK
YiWbUaCPDFVk95N4mmkQ2Qjx7sRnvVrd5wzFvn7KjqdwpzyH3rWpnzIikosy
FzqtWVBpeznoJpKnUk8hljLSdSinAv1UHb5CAwyFijUPXuiEp8YmfUPXGRKd
OtU5O40JCniNCtHznU8ZrmymwcWfl47XV57Yhedot3rJtA9UGr2mf1E6FlxM
9FynePoV3G2dFtWYCcJUfiPbX5YOBQkTLKv5i597WrpkufdXOoCWuQgxYHT+
qnQuqJlF3v7oFo3qeaJL4qLvZ8BJ03EdweL2A6V7wYrNxXiIC3hLZsBkezcu
ftZzV+1H4oEq4mMM+n2oUC2+nUMzvWViowNBpt/guGNt0RQTIIEOe1m++JtC
7Wb7uxNbED46qaTtb3DklnZ+cqvb2349Ar68wnu00aY57UzjCe0/WigXG+zQ
oT01ow3ENf+y84pj2000gbHOFfJrEWYHprqdXd0FRw/Iq4ckgrnOvxcNfI5l
uUr0sIbigF9EKvTMJJdy6l5PHxUILvsddh56gw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 158},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130129650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42903131],

Cell["\<\
Explicitly specify the style for different curves and regions:\
\>", "ExampleText",
 CellID->24232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", 
     RowBox[{"-", "\[Theta]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Purple", ",", "Orange"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1371551769],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 158},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->370972193]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81270665],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->32342228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{"4", "\[Theta]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "t", ",", "r"}], "}"}], ",", 
      RowBox[{"Hue", "[", "r", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1019673507],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12461813]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->444346277],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->43022358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->830578371],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26886994]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RegionFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->537905511],

Cell[TextData[{
 "Show the plot where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", " ", ">", 
    FractionBox["1", "2"]}], TraditionalForm]], "InlineMath"],
 StyleBox[":",
  Deletable->True]
}], "ExampleText",
 CellID->1386283524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", "\[Theta]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "t", ",", "r"}], "}"}], ",", 
      RowBox[{"r", ">", "0.5"}]}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2085822262],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100579649]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->191873435],

Cell["Evaluate functions using machine-precision arithmetic:", "ExampleText",
 CellID->188014557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"2", "\[Theta]"}], "+", 
     RowBox[{"10", "^", "16"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "MachinePrecision"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->904774868],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122275566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->173823983],

Cell["Evaluate functions using arbitrary-precision arithmetic:", "ExampleText",
 CellID->681982236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"2", "\[Theta]"}], "+", 
     RowBox[{"10", "^", "16"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1269758651],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293326244]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Plot a circle:", "ExampleText",
 CellID->903762329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->379048554],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->395758000]
}, Open  ]],

Cell["A spiral:", "ExampleText",
 CellID->906191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{"\[Theta]", ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205417942],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydmVuIlVUUx7fnnDkzo2Ne8zLeRk3zbnajBM0wFTFRM9M0s0kCfSjD7KVe
6qVe6qUgEiQfukCXByMwAoNIiIRIiISoIAzCHpIg6UEITr+11t6z91nzjTM6
jN/sb+/1X2vt/1p77f1tt/YfO/TU0/3HDh/s79t0tP/ZQ4cPPte38chRuuqj
Qghv8e/QtEC7RUv/3dlqtUJdWvoTDsgjDN1bozPUaVy8+Pf57/8ItZPvfFc7
8sxnob571wf3rTnOb+iWR+f+fR/S/+ILXyDx+emfEL5y5WrYqJpul2fnpUv/
fHnmV/QhB8QAplFU1xmP9rvl0WMmz379GxKvvvIVwls2n8Ts88dO08PQ1av/
3a/6V6j/vKL/9dfOhhpSof7yS2cwJqp7ZbwL/ee+/R0omjasP3H40Kk33/jm
wo9/rlUdS9VH0wESAZ6fnroAKtQiE3NUBsjHH/0AHHeQQR5UWK1aFsuzA5s4
PDAcmo7fufJowo/Z2rHtXcTx7R7VsVBH0Yl1Iwk+ee1yWm5JWhiGE+b8/nvn
L1/+9y7VoqMdwPCVIWiBzzAmzmSRjjK342+fwzxOyOgdipzXjoQklIaxzvoS
eTSYAC4S9V9+/muVouem/gHoOIdcphLE9eCTnxhypSKV3QbsQi0OgZwQvV1Z
IGxkuSJmaT+eMjtAQHucrYZ7v63wjkwAqnEPM1UOBViA9nDTMHpWJcsoQRWx
Uz4s06QfXvEIUiVqjbSKgv3InDp4FYXKeYMpEUJ+aWhswnS1SHTpJK6hZFF0
+JzSqNdxhHjAVLhV5aZpLxTTKyshMerRd6sXWCMg5CKNBYqfqnLwxWQkCyYW
ePl7r46TgIxjxbIuTNFe0odgydqYPAybpgWy0CLrZb5quVl7IZg0kuZMh1qd
uMYKIjQ096I1ZgFUmrOir2uSVzAqtalPpSdpL+GK0rOdFUPBHetQaoFmqfEA
os9Jr018Iy0rSrUp66FOFDEjzb7o0TrtR6slr+VzGJ8iiZ+tVC0KG+tSZmAD
KeMl5odxKLOb51BaKaVGEmFBzVCU5TmRJe9ldvOjZ+uddG8hjVt0SbM35rDP
pgE0Hsq8NJdjBYH/GE/PdN29P5DmGX3TXA62wtGKbsmtqXF9+ZyqR982JI7R
IrxoRmsdVA9j3s4eYl1sdNamFOgczznD5PemVlxFZKo0NbPD6BQxPBPdPs71
6NPmmGslirCwyBOLVTHYrO+4TepKU/PcdtYitxZVoiwfZL2XKLqgKqHEsy2O
nYkqbfsU7uGkNBc7G1vifErprNtLP6jvtkCkqasjdLp5LIkebXWcltKZsyXO
xtbokUk3EwdsjNJcWiFd5s64ApVzYl7My47o2bbEFShp3lSgKM64LM35ha0Q
0aVt08ICYhlJU9dUlEIFilJONNKWc4283OaiXWrLM1lYkZfyur3Vvp57CnSO
VxW6fN+e2GQbFR9MS8PFQPeVRkYNZmZHq32NjSn05Fxc0Grfv3a67BtdoNhB
2NikudzZeshpLVFZVzUqz9RQ9dTLcVEydkX07GHHbnchnSO9wtnY6WyUqMyN
R4ktyf8sLW8roye7VJoKik5pdhU6OXhxXKrSaai8V3QWqNxbjcrMlqhcyxbG
DExr6xE36xJFl31Y2InoGqvBtJD0pL40m5VaZO8eydoybaQCCTG0tiqf5HV3
q70udNzQjHbHSI7ctkeXMyh9yJ6Nj3z4k+H02O9PbdPjeM1506iM9IQCLfWw
t0JbOe6t6Zmhs6wbPG1ht83HPtRasW5UxXe6e6/ypBHnPciiJXSbxVzDJ1X4
XBtqLp4Lb4kjDoWkzRILlGU6lKXyfcYQsUrnPNOXK1y9sJL3Yt1F22q152ra
IIkZ0ZL3oOa4Ki3aVFOW1AotvfHvrIqY5dzL9dC0Wv6z4VBCpOnr96P6nvek
EpXPFh6112mtFahc3ZdHz/Zpf66PpXReidU2MkuGsh0yr7BlCcXakvP0Xpcd
hpJLo4S104q8dzqLvlb43XhE482Bd6bGnPGj28kN9z1/Q3avU/8oZaTp2PSn
wlpik+oizSlu3G6qmi7uS2Pcxa5U6r2FFPlN2siZwNvyJ409iup0WeBPuYbK
WV+iSE6mJrbSSdqYy+cSk+5yNvxp3Z/+dheofM6sRuXzlqG6E6MxP9NXh7GT
92mTHu0s+92tw3leovL3QjUq7w6Gsu8/nI2xntOy+tho8zDHx1A9TtccZ6v6
RJGzYE+hJX9bj0xLZtG0jE0RgTCpBVXf4mlGgzPN7gHsm1rQvs56H+w9f/to
Jc03FlGL3++8llqaefzusrUyPvkS71BSjU9nw3Sa1coazxPMG/bknk/vb3Id
4sf2scdUWr9Q4/2i3YrNbpdHmMqPgMlPTnkRb9vSzZP2mWDYr5L6Ld8wPxjA
fd35ZE/EEL+IPq6Sel8hd5+sT/qRtF1b7vhCkHPMEyqn544G78iRYwwPeGP3
rHrraLJqq0ka0s3yRi3izE5zqwvTzIsp21CMfAj9+kdj3WW3zga3C2AohtCG
TLvL7uztUnbD+hPwyRAQH9EDqtFujMmDAVhD/mOgMaCUsHZGJs3/6/lfjDDq
fzk1c50=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->205642350]
}, Open  ]],

Cell["An oscillation around a circle: ", "ExampleText",
 CellID->11026438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"1", "/", "10"}], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"10", "\[Theta]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->718642031],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[3]=",
 CellID->327056756]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1723324061],

Cell[TextData[{
 "Archimedean spirals of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "=", 
    RowBox[{"a", "  ", 
     SuperscriptBox["\[Theta]", 
      RowBox[{"1", "/", "n"}]]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->795546138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"\[Theta]", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", "20"}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"r", "\[Equal]", 
       RowBox[{"\[Theta]", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}]}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PolarPlot", "[", 
    RowBox[{"\[Theta]", ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", "20"}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"r", "\[Equal]", "\[Theta]"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167368668],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->43303981]
}, Open  ]],

Cell[TextData[{
 "Archimedean spirals of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "=", 
    RowBox[{"a", " ", "/", " ", 
     SuperscriptBox["\[Theta]", 
      RowBox[{"1", "/", "n"}]]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->585340452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"\[Theta]", "^", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0.1", ",", "25"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], ",", "2.5"}], "}"}], ",", "All"}], 
       "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"r", "\[Equal]", 
       RowBox[{"\[Theta]", "^", 
        RowBox[{"-", "1"}]}]}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"\[Theta]", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0.1", ",", "25"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], "/", "5"}], ",", "2.5"}], "}"}], ",", "All"}], 
       "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"r", "\[Equal]", 
       RowBox[{"\[Theta]", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], ")"}]}]}]}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->510755144],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->181962554]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->311150177],

Cell[TextData[{
 "Logarithmic spirals have the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "=", 
    RowBox[{"a", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"b", " ", "\[Theta]"}]]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->378344394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{"\[Theta]", "/", "10"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "30"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"r", "\[Equal]", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"\[Theta]", "/", "10"}], ")"}]}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135151191],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228245017]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->309276630],

Cell[TextData[{
 "Create a Guilloch\[EAcute] pattern ",
 ButtonBox["[more info]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/GuillochePattern.html"], None}],
 ":"
}], "ExampleText",
 CellID->1787935020],

Cell[BoxData[
 RowBox[{
  RowBox[{"guilloche", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_", ",", "e_", ",", "f_"}], 
     "}"}], ",", 
    RowBox[{"o", ":", 
     RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
  RowBox[{"PolarPlot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Flatten", "[", 
      RowBox[{"{", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"a", " ", "x"}], "+", "d"}], "]"}]}], ")"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"b", "+", 
               RowBox[{"Sin", "[", 
                RowBox[{
                 RowBox[{"b", " ", "x"}], "+", "e"}], "]"}]}], ")"}], "-", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"Sin", "[", 
                RowBox[{
                 RowBox[{"a", " ", "x"}], "+", "d"}], "]"}]}], ")"}]}], ")"}],
            " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"f", "+", 
              RowBox[{"Sin", "[", 
               RowBox[{
                RowBox[{"a", " ", "x"}], "+", 
                RowBox[{"n", "/", "Pi"}]}], "]"}]}], ")"}], "/", "2"}]}]}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "0", ",", "19"}], "}"}]}], "]"}], "}"}], "]"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", " ", "Pi"}]}], "}"}], ",", "o", ",", 
    RowBox[{"Axes", "\[Rule]", "None"}], ",", 
    RowBox[{"Frame", "\[Rule]", "False"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->283838235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"guilloche", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "8", ",", "20", ",", "4.7", ",", "1.8", ",", "1"}], 
    "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Darker", "[", 
     RowBox[{"Green", ",", "0.5"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1213238898],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149548127]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->597514546],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolarPlot"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " for curves:"
}], "ExampleText",
 CellID->71264896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{"\[Theta]", ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]", " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
       RowBox[{"\[Theta]", " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33614225],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->595561146]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->253825343],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPolarPlot"]], "InlineFormula"],
 " for data: "
}], "ExampleText",
 CellID->1112749563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{"\[Theta]", ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0", ",", 
        RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"PolarPlot", "[", 
    RowBox[{"\[Theta]", ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->789105347],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->203142114]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88476759],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 " for function and parametric surfaces:"
}], "ExampleText",
 CellID->85481619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ")"}], 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24486205],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->321718622]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"Cos", "[", "u", "]"}], " ", 
      RowBox[{
       RowBox[{"Cos", "[", "v", "]"}], "^", "3"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{
       RowBox[{"Cos", "[", "v", "]"}], "^", "2"}], " ", 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"Tan", "[", "v", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->704574670],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{152, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->549631156]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10530632],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RevolutionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RevolutionPlot3D"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SphericalPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalPlot3D"]], "InlineFormula"],
 " for cylindrical and spherical coordinates:"
}], "ExampleText",
 CellID->374378446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{"\[Phi]", "+", " ", 
      RowBox[{"Sin", "[", "r", "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22233769],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVfHd0lFeWpwyIaGyc3e5gezzunu7pnp3u7TNnTm84vTt7enbPboFxwsaN
DTbYGAwYk2xyMjmaKIIACZGUkVCWUJaQhHLOpZJUUpUqZ6l+Z/fd+71PiA+w
Pfvf6JS++sJ773v3vpvvfaVbsHrxomULVn/+yYJX/vWrBV8u/vyTVa/8ZcVX
4tb4x0JCQpLF/44XQ8T5/xVn/J8MQDz43uMScRwvGo8T3+PE97/w3aV0nCAu
wX/yecj4e3f+/O+i3RIJ1Xj5PU1+h4xftGiRbPkfueU3Y/EgHv6R764VR3rN
BB5d6SOOss/qMaOPfTfPZcLoG8TJH7j9SvmOqXQVOvpcjvl7brNctnnioW3+
cRT68SHqi/m1SvsxUI3TXP+Omy6WPSdoZjxd03q85vq33HuR7D3pB3pP0Fz/
Pff+bxJbLz9k9i9oeoRqrn/DTf/8wKr/VI71c037iZrrXz+i/0/knF7RtJ+k
uf67R/R/Hgp9vKppP1lz/atH9H9Gzl9LQS9r+k/RXP/yEePNkOP9+gf6v37f
ijwhofh7Taupmuu/5V4zHzFn7Tunaa5f497/W/b+g+bp45rrv+HW/1PO7I8/
qvVf8HB+1L5LS6+8eiz5qNOfNE+1nPXKKO6p9X/RPH1Sc80rya1U6TJ2Zv9J
03qG5voX3PsnuF9GvySvQzWj/ecfGO3nPBr1/n7Z+azEOkmkGaPvuTfOU5rr
n/EwT2OMrPze8Z+S8yd6m0qSYIa5A0OdsHTB2g2bHvYeOAxw9sLVR/09/fAa
4RuAfxABE4ZNCFVluJQfT2tm9NMfCekTcibEn5NozJc6a9FdD30DehphaEJv
M/pbYGzDQDsGO2DqhLkLQ92w6GHtgc0Aey8cPEmXEW4jPAPwDsJngt+MgBnj
AkNCmA1bMGylj5jgiE1IJ1W+j5nxSz9yxo9D1WAYlZ6vScyHvFpfTvea7qK5
Cq3VaKtBey0669HVgO5G6JvQ04zeFvS1ob8dxg4MdGKwC6ZuDOkx1AOLAdZe
2Ppg76dxnANwDcA9CI8JXjN84iPAGee3COb2WxGw0UeAMGzHiAMjTgTFxwWI
j1uZtJZPf/IjoZyCh8sYomBe+9/eLUZVCarvoLYMdRU0RmMVmqvRUoPWOrTX
o6MBnY3oakJ3M/Qt6GmDoR29HejrQl83+vUw9mDAgMFeDPbB1A+zEUMDNI7V
BJsZdjMcQ3AOwWWB2wKPFV4r/AxxwM5AOzBOgBwSKiAOugliApph8dzT8mNg
f3GUl8daJCqkr8nvkBeLclGSh9IClBWivBh3S1B5B9VlqKlA3V0GtBpNtWiu
Q0sDWhrR2oTWFrS1or0NHe3o6EBnF7q68TSNNs1mg90Ohx1OB9wOmrjPCb8L
ARdG3DRxnq+CYy/ER1x7SYX7GBj+02oz1tasg2gR/0ad+TO5WcjLRsFtFOWh
OB+lhbhThPISVJSisgxVFaiuRG01jVtfj/pGNDShoRmNrUJfUv8Jbb1o60N7
P9qMGNcmFuPxtkG0mdBuoj4dQ+gcQpcFeit6rDDY0GeH0a7Qw1RFFhAfuuH2
wOuBz0u9RhgoAmc8/IxxrW5/nqF5TbsOM9JTkZmO7EzczkbebeTnojAfxYUo
KcKdEpTdQXkFKipRWYOqOlQ1gLg6ZHptJ2q7UNuNGj2qe1BtQFUvKvtQ0Yfy
PtzpQ4n4CO4aVypgLBUwPiV6lQ7iziDKxMeEchMqTKgyo3YIDRY0W9FmR5cD
PU5avAE3TGLNGOYJbh+8PgR8GPFhkoBuLKdoZfZzDOUrWiifSErCrVtITUV6
OjIzkJWFnBzk5iI/HwVFKCxBcRlKKlBaqeD5ufIWwmppO0o6USQ+XSjsRqEe
BT3INyDXgBwDsg3INCDdgBQDEvWI7UZMF2504nqnwvYhT1/vQnQXYrrpWbwe
yb3INCJnAHmDKDShxIyyIdy1EMB1NjTa0e5Ej0eZwUS3H14//H4MBxD0IxjA
OIY96A9KetVaf88y7D/Hw3Xwy6pEnR4bj/hEJCYhKRm3UpCShrQMZGQhKwfZ
ecgpRG4J8sokDNOL61HUiIIm5LUgtw057YSYzC6kdyG1Gyl6JAq4O1XaXphg
mxdtfe+q9c1IC8MRqvuud/ZF51vX/B/EDi+6NRLC+mfajW6COmMAtwUqzDRk
jR3NTnR50OeFSXClIv0dAbgD8AbEtcBDSOhIACOBoMDBiH/kYTh4ZlTyEuiv
qzA/fj2G3hGbgPibSEjGzRQkpyIlA6nZSM9FRj4yixRKmZpbg9u1yK5HViMy
m5HeirR2pHQguRPxnQr1j1+a4Xs7qpelIF93mdDDQISwnp804IXRS4AQP3vQ
4ka1Q+Jz/Oyj1o+ueIiP+X2TBSZSjbhtQvEQKm1ocKDdDYNXaj97AE4Jf0Ac
xg8HglIbavmbbQOWvvdBPi3yOq5E41oszSUmEXFJSEhBYhqSMpF8Gyn5CpGE
TMmsRFYtMuqR2oiUZtxqRVI7EjsQ3S5nPnFFtk8hPMHz9Xo09yi2xDSzGZYh
Gt5uYwnMQtjphNMFIaVcHsUSCJnc54dARoMLdx3ItyCJla8AQIF0VnhwYRJG
cToxqQ9ZgygQDGJDs8CIT4En1MYY8QTgC3Brrc3PVhvLgYdxwasqXqaGR+Hi
NUTeQFQMrsbhRiITSBriM5GYo9DC5NQypFYirRYpDUhuQmIL4ttxvU15OnFL
6bCCj+I2lLWhsl3h3Be7uqDvRq9QvQaYemHph80IhzAyWL57LZBGhR0BBymo
YTeGPRj2koijBn4ieQEjvyW004tGNyocElmjGjVkqu7E8IIEqb4udxAVFVhQ
5UCLZxRb460B1XrS6mm2mplqHmZjj0qLyWEROHsZ56/g4nVERCMqDteScCNF
scQm3SzBzXIkVSG5DjcbkdCMuFZJURO33/Eqk8tuQV4TSRHu84pQhuKrrQWd
rehme6W/g+wzMxubwtJ09rONOUjNhGUp7EphTo4o1hdbIUEPq/CQkKCPZOOI
HwEmCSEtLIF7XrcCrALb4+Kebpd7TiS+zKKeF9uQ3E8Iq3GhVSDMTze1HhN7
OXykmf9KxcmU4+E4eQmnI3E2Cuev4cINRMbjSjKupamwx5UgrhzxVYivR1wj
YlqUWU3aWR5QcJLWhMwG5NQhr1rKul+U15CWralFfS2a6lh2CHu2CQa2ZIVl
Lsxyi3AceuA0kMvgMTKChKdgxogFQRuCdgQdbJ7ej6NxAkkhE4OBoBAfvkDQ
6Q9aWYtooyehKoQTdbt970ZgJaPqSifSB/m+1utj617a+Ap50uk9PB06i6Pn
cewiTkTg9GWcuYrwGFxKxOUUCfOk63m4UUwvia5GdD1uNOFyi/psV4XkrwRG
RkoV0iskfp8sLENpGcrLUVmO2grUV6KJLS7hBOgb0dtE7sxgG4Y6YO0StM6U
rBAL08vIsH/Y7x/xsBJRY2FTVTh0h4fnxyqz0PqA9yCmp9SLYwwk9vecwv4w
HDqHIxdw7BJOXEbYdZyLw8UkKbmichBViCt3cLUSV+skJJMO145szDeScG5A
bDXi7+JmmXz2eEYhsguRV4jCQpQWoYJt5Joy1FeguZLBrVU00gyHHq5ekAfJ
xr3wyYa/lyIUXTTsD/j9TJAEoooHbVRm+r1VvufNyLaj8nTytyew+zT2ncHB
8zhyEcejcCoaZxIkPV3KxKU8RBQjsgJRtYhqlr0OVI0oa3y9ATeqcOMOYooR
W6Bwy5SUHKRnIzuHDNNCdhbKi1BZgppSqZOeEx6sWGyjWOx2mDthFU618Kj7
SH54FfnBTunIqOvGaAiqaAhhzhgvOEPQBEtXcdBq1p9rrh+/jwa0UUBuPUU8
2HwE245h50nsDsO+szh4EUev4ES0pO7Qc+k4n4MLhbhUjss18u6UsBbsr5Ri
82ojrlQh6g6i8nHlttoiLgMJ6cwPaUjPQHYWcrNReJucKYVqXqovQ/NdtDE/
EDO0oF+Ijw6YhT8vnHnhyRvhHISbLRavDT4HFGfJ70bAg4AXw6yIRphZOPww
XiET4MEYmxY70+6XCfLuBEkvHEMhU3HDYWw+iq3HseMUdp3Bvgs4FCWlxukU
nM3G+QJcLENENSIaaTJnWoKHKh0KhBMu1yJSPBMtsmSfKym4lowbNxEj7Ds2
I1LZr8nJkHibUZaPymLU3CHmaapCay01Iunair4O9HdjoIdcZPMALCZYLRyx
YdhDhTZ2+4NCVrj9LJC0ET8tBliOsH1Gbw6VGnaixIDqGYfMWH8Em77D1hPY
EYbdF7A/imZ0LBGn03E2D+GluFiFSw1083wbjtd5GfbpkQ2IqMTFYoTfxpkU
fpqAC/G4FIvIGFyJxY04xCVI/nhcOKrC0b5TSP61cK6FZy3kZGs9y452dAtL
Ra9YcaFGJ/pd6HOh341+jxLYV+JPZp9qc2rjHFrImTYUm/y+uIc2Dj9Z4oJ9
Unr9V/uw9iC13HgMW8OwM1xdtaMCHVk4W4DwclxiNXChHWGNLtIY3b4YA925
xEspUHYqTcHspJM3cPoazlzB+ats5F3H1WjJHVOFv5uVgdwcFihF5LRX3UVt
DRoa0dyqyMUpnQPoNKFDuKUWNFpQb6MXVNlw16qAGzK1zIZSK92tsKHSTua9
sFE7vOhmztHqSS2eJitokbEt+lNkAtRYl3wwAffyOQ/Y+tPFg+W7sXI/1hzC
10epw7YLdNwfjSNJOJWDM8U4X6nKjQvtwbB6qziL7/HF9bIJVIOwIhzPlC2e
OXQNh6NwNIK016kInBFWXxQuXaGmN2IQz6ZmWhqyMpF7GwUFKClF+V1U1kpa
m1Tfi9p+1A6ixoy7ZpSa2bMbJ/lIobKr3bjZT+aEsLzohla/ajE16UdS1DRJ
UTzeq+L+4p34Yje+3I/Vh/HNSWwJp157onH4Fk7l4kwpzrN8vNSBC23E1fFt
hqRefwLHOMOrcbwAh9Owj72mPZF03HsOB4RuD8fxCzh1UeJs8uXruB6LuEQk
3WK/OIf85/w70kOoaEN5J8p6UMrjFg4qWSkxz8mqFJjwToS0CEOUPAlB8QsN
FiaOYkG11dV8BrV+QtU4n2zFZzuxdA9W7Mfa49hwjl66S9U4z4WVIZxZKLIT
Ea1ucZLU3p3a57vJjlh4DY4VYH8KdrGrvP0Ctp2hk29PY28YDp5RIT4TgfAr
5Dddi0PsTSSxLsoslHq+qA6lrSjuRFEPCvqQZ1Tim2KWv9LA9DPNdeio1NTq
jbHXT0qYWRJNE/c/3oZPd2LJHqw8inVhNJcdNwiKY3kIq5CU+ZMbdTXJba3i
LMUYjOuhRseLsTcV26JZ5pzDhlNY/x02H2OAT9DxYBiOheN0BIkQ4fZcE56z
8JlzVO2dU43cRuS3I68bt/uUKY5XnXo517/7AYgZthCVErSQajmDZQYZsvM2
YcE2LPoWSw9g1Uma6+Yo7L6JI7dxmiPEUV241k0n8Y11yspnDgwns7Nwsgz7
MrAlGl9fpMs1J7DqMNYcxDeHsOkwU8sJHDiDo8K/icQ5ITkTcD1VwjwxpYxa
ZLUgp4sCX5KSQyaMWO7FULW5NYpHUHpXWV2tVfC0XE1e9V+K+3PW44PN+Gg7
Fu3B8u9o2G8isD0O+zJx4o6ELZoXMLGlWRzz+4fyzcOZpmAsA3wwD9sSsIZh
W34UX+zHsr34ci9W72M0HaGjsFAPC/CE4xYr7XJhbiYIH7YOqW0MCE1f8b3t
/RhmQGHooxu/1UBHETe61NqA40dXdiy04yX/Piuh5l4Uvn5zLd5dj7kC8B1Y
zGpwTTg2Xse3KThaxB5YF2J5HsntHeJY1Gdgq/+ZdVfp5uLDhC5BEIsFTXzL
3fdj4xFsZ0I+HAGhDsXJ5UzcKESc8C8apBabHN7sFA8MviAp/JCQXj0d3Y08
y99pYGIv+CHW8aNhHXv9vISZPU6KBb+xFu9swPtb8PFeeunKs1gXhW03IZZQ
XF7tQjzrqPQuvTiW9HZLvssbQjLL0v352JQgKXPq/D2Ytw3zt+LjrfRs6U4I
g+Kbw2Rb7QmXkZDwNIoHENg0D44HxDAlNVpMfT6K14nz9m4yjjo4vTRy10s9
/0ED71SJB61Olspcq9M111ouf1HiJeRJcW/WWrwl6GA7PmEi+OoiNsVjbw5O
sa8nEJLSR7qiQN8ufccKO26bKbIsLnZmYtVVfHJc1fdzNmHuRszbyBSyEyv2
Yu1hsq32RsrVn3SjEomtTFVGMQaZVE3mXlYkYtaFzcokH4B/oqR5rY2jADpx
DHy8YBp4R63f6TPX4k0BLNPrsrNYH41dGTjGIkaYJ6n9pJQLDXLdn6obMosv
Aa8gAIXXN6VgKTP6nJ00kDh5+2s6frQZi3bgi70qlMeSEM40Fc+wpg0ipdej
6IXJZg9lWcTZ7RKkpSKV+cQQ66N3/uMYiqX11uZeFXjHWvlaOEOeENe6L2nM
2Rsxdw+vaQS2JOFgIYc8enCrn9zfwn4TQ/lEg7m/yWYXZ1UO5HNI9Vg5vknC
ovN0/uYWzFyDWatHJe/EtSz+90bjRCYiyhAro0wTi3v1CsnZ2W0zuxW7NvTC
GUmLtogW+vq9XEttXcq4H4aN4yQroFutRmsWncTa69iZgeOshJL6kT04rDyb
XjvQLb5aLYNtdhI4tS4UWpDAZPtNMhacpZOZG+WKEWfO2YAPt2HJIXqw9TL2
JyGsANfYbckxo8AcUOKzDq/bG5AgtbIVcyUNRy9Ijo/e6ZGc9zu5htp413MP
hfuHZBnDTwjVLYduFd7aIvXIhgTsZUqL1kOoJAX2abWmviazoW2or8Nm7nIS
lzW6UWKlZJA435AioZ6gWx7UfUGOlu4rGRv5nPXVzhh8l41LdyXsoqfix9jd
dp9Pmo5DDrT0Ipf9oB1nsWIbr/evHyGxn30o1FrdzFCSmhGzElN6U5GsF5V4
0+TqIVvTkLHdQmpRb7f0uAjVLR4Fy0zLuq+hWxrUfc4gfRmctQ5zd7BuuoBd
N3Ga9VqmkeBRoDU6LeLL56WBlPiD1Y7Ofplx2fV+mxQqr0uaHfVF5Ro/81Co
SB6p1RpqTQnrH93nI7qVmL2NXvRFBLYKumGpnzaAYhYJjVZrm3Wg20qhuV6n
VcYCiFuZMQ+VYkWsahnpFgd1nwYlrlYH39sBzoZN6nc7rW6HMj/4KX8Z8KgW
ZGUrEktppE/24a1Fw4z6V+VsH4i+0U1xy88LrpVE97h1rOTVapp7EunTEd2y
4KwtLHiFzs2kkxg9ss0oZ0e31WbrspkY3ikmjwxGtXlx144MtiI3ZWJBuLSt
XyDYvwy+xYhcewUHshBRQ+fCQ27hSoEhr+BSL2NgRCABXgy76L5pEE2dyL6L
S1kKof2cZjhpdEWFqSeOyzPwtowGKLWCIZQhGRatPD6emtZOVrCh1btaHlaz
KEwPFOrRfTKsWxKcyeryc0EPjJV4A/IsTNMhvzE6SQMNuUmADflIbBv8aHJT
2i5emWkM3jlAJ7qPSXfpFhI/z9xMd1ZF4UAOnWQbKUHTybaGk4PPSh6TahIY
WW62pfV63OWo12kO8Mz8mnn+JUn5HD9r4pxQlglXWRsuS8d754PUappKLw5/
0OUfdvn84zR+yUNrKGVc714rbebspVF5IBacNe3C8xDiS+GLas5PdTs9fU7b
oMum0PgLNq/P7hu2cG5F70O1HfmcA9tdgAXsVOs+8+vm+ZRBZ66XvLibcX97
APUu6NVM8ORhjkbSfNhWDTrgt8BulLK+SNgyBRC6nkF/foy8VyLJdS4UWZDY
h7Oc2J8fi9lHmWE/HuLxR/3xiSb/iNUXsHv9dq/H6nGqMYUx+HrskfiiEX6q
3tctGhHaQZEbL4jrBAMKrah10vt73L4Bt3OIZYPD63L6fE5fwOmn7BWh0Yta
B3I5kr/1NuZw7EI3X1ot0z67gB3sdecYUWNHDwtLT4BKBBT+UjA2AXYMD1GW
yKyXsYbCckRnU+v1kXznGUlRrOEpQGPzDfd7fF1uEjOlViT1qVlr3VbG1gfm
ELWuVrEyhS5TQl5GX8Dk9Q15PGYGioDW1uU9NiqRvz+WM0rnJKfnHsNXcWwU
6sn2q2HRYfAETB5SFA4PKVS3z+fxD3v8QWdArRvQe1GnoFCRth+xqaib5+CF
GZbVCu4ABFnBR0hTVh9WqrvzsC3R14bmeplNPJ2AXVcV7zBEqfdSozgskaxe
76DbrXd5Gux+6ZMohPZxHOacxqztilxw6d4z0clf+5To7MU2pBhRbIMgzw4W
Cr2ewIDHY3TZ+xwmcAZTa2c/NirtH+ZPvCBnJkvQBKy0bu8cxrLr2F8ibYhK
OyPRS49sXq/L6/Gw2vX5h33+EV8gqKRSuQ1qbbIOJ1T3gVU316lbQdLti6sS
s0/dMaPNBROzps8nUytwAqxLAoPwsL822EbVhg2VKClWBG4oxvhRocwHbiFd
jS5bh90qef4qC9aVGfggCrrD0G1UQPIqa6p7q183d4DuHBr5SI1yTRY8XmBB
tZOyugSBy2NwUNhTa/tpY9kKXqfjno9OD9WYW8jTi6OwI5dGzBgkPamMPuAL
CpZx+Xxen5+g9QcC/uGAfyRAeVbK4SszbbRDoOkWu5vfqPHWKbq5ZOp/eALr
OXaY1YtqC/RuWFSZN4FK1xyUxhsZkjl/RxdMrehpQGsV9SnMQ2oGbnDCo/uj
ZYrvpoGRcOtkPhl0WoRil/R5tdN/iA3GhTF4Lwy6XYxbYb8s8On+6lKqZnTv
mnQLbOLsjUOYz2FBQdXCss81SznW6XTf066aHNBDcftAfaxoNCpJdfO5wIQj
xRONvqCFNZiXMEo0N25EfI0XCnMkEPSrnD7B5EWXC7VW5PYrOHpqCZdy6ObS
qi86i52seQuNaLZTeiOEa+c8LlA5p5WqV31GNWvf24A29rXv5CM3iyrGFGkS
+w8LQ5S/yZL7WYLZvV5BsQKrSqucnj7ZSqHEOWfwxn6eymoIO1i3QOg6j+49
h1z9D+265X7dFrx3Gp/epGaXOyGsT2E3SRnWYhkYY608kGH6XplA8EyXHDZq
Qeo+ISJdECnzT9kmEqftzLBmP1UF+PxBQbwjqmESpA8JiWGuRVPw3e9Gq53K
9zINUgcsjJaW1mfh2M0sUsjy0+BQfUOXDV4LlQsTKfbA0oHBFonz8RUFKMhG
RqqUMlNWM8rmbsIbaxULIaibT+ro7O8WKnATeQx5A2aPp99l19tIoOZ2d0ic
rbiFBVfw7mlVGujWgbzUT4PCKJOWxntO3QcuxSrQHcKH15msm3Gzj4qNxHmD
xcrEAMX/J1p+THwTjh+lwbTW5VRJ2U+renLG7D1YwmiK6ybfV6hNRW3buW4l
EMCIP6jgOigrMzgvzWWP3lF5oHegfghlA8gyKFm76XkG1JmpWnSAxa3VDJtS
3dsDUwcVQfTUo71K4vbxvDmHlJXaexKbOd67aBve/wazVymCdUT3IXvWk1UI
9W5/t8vTabewvprxeQzmX8R7JzCLg3aKGahbouCXOtPlBx7dPK/uY69uWUBZ
k/cjsSZ7VHeKFe/rknjSeqaTfySuVYttvMwhKlGG94/iq2RqcquPuEhI6H7W
Si6uFRtmA4lMSEVi+SgA78WIF34vFakpGBY022pBlYlKPJUY21unsY6t8PQu
lPaizogukxp3NPbCqKfqpd4WdNVTKbq4W1mE4tvISQeZL6MVNVPrWWDW2chp
yepoXJWCpdFYFIEPT2POIaXNc7r1EK62bhmjlXFKJx8N6z4K6D4O6BYP61ay
Oj9KRL7uNtOTAUVDI2X9Bn6JBp+T/j9od7yUGi+pM39i/lls5EKgzAEyHdo9
GGC8CuvJT+WY0i4PKhKC6qqVWuthN3xuuFwqL/YxiVYPoNCATNbsM7cGF12X
MjarE+UG1MtcSsjkjk60t6CV8991FZS/LspFTqas5w2/jBPnsf8UtnKQZPm3
+GQz3luHN1cqQgMSd3NdSg3xVT3nHY0oNI8oVLgkEos48CR9+Nmb8cbXmLUK
ui+h+0IIbElVRNifBMmbE37Pch79W7wdhkXxdB7RKXxiLmHR1o5N/DfQMovs
Reof77yhKNjc7/AN+0KZwm20U/HkoIr4AJtnSvWKYr8yJIT3ieCC96DQcE6q
7XA7FJxN15vRMoiaftzh0NMbu4JLGIarnBS83YayTlSrtcsTyisowVtYSIXS
Sv9L1xAWgUNnsYvDjkJQL92FBVvxPjtuEm2L5WpP0y1labB/ZC7LveO8kLcM
ZGeuuIilo/nED/fh/Z14ZzPe/hpvrsEbX2HmChpJYv9THnsxdEuhU9Z2O2Ye
xQeXsZJ9oLgeLofWWsmh/xbsa3dYkZJ/Zy9WsFbOMFIFarsbRllTOcHHFYdU
TSbuqJ7DFAXlI04qNBp2kHVBoscKm0X1oVr7UceYV65DY+qR0ojMRuTUo7BB
yugZSdmITaVWF2IQdhXHIrE/HNtPsyF8EIv3YP5OShEQ9whp8bWM+M7cgTeO
4l12qg/U4EKzW4lwL2JtOm873t+MORvwjsDxasxeKTmbFmwpf75g1CoaVwx1
GO9fxDIWphEdwVu9Xq0PPOEB/KrWh2oxv6bq6llb8Dkr2Zs9KBmiAmeZvXD7
4eOi/iBvXhC0q+6nCZkqzN4RxuCwlfx83xCVKwmXyDII04ASE5w267i0O8Rf
ZCVusOWWUIH4O7hZivhCWfc3ftY+zDqAt47LOuSpa0/hq++w/BCW7MWnu/Ax
hyU/2IQ56/HOOgUzT876kuWA8lkJgRndBkbObrz9HeZF4Au2uc9yTuGB2OP4
B7DzFB7ur/1MpcFJn1y8B02lBe0uTkkpPOJmJRVUcUQ7j4SDJfn68REL+fl+
M7wm2sXkNNK+Jmsf1R73G2DQo7sb7Bk8fbKYKj7OFuJsPtWHiFsn03H0Fg7c
xN547IzGZvZxV0di+UV8fgGfXsDHav5s/jV1fgq9bzuDzaew/hjWHcGqg1ix
D1/soQzkwu1qPchbazGb8xVvrOGTdaDwmjLa7IPqaNRWG4cfiz9ZFRHyYC03
VUnwm55M0tNmikYHul0YYMfM4YXHQ9FWhS2pANIB2NkrVWwZ/yDVSrqNVC1o
74XVQJvDTN0wdlE9mGjR1UoKqLmZKoNqG/Ai087BC9h3DrvCqGxty3FsPEpp
xjUHsHIvlu9WZjN9HmfeiNvW490NeHsT3tqM2cyybx3A3JNYEIElcSomLrW4
JDxqjvR+6NVK9lHJ9PZeuQEko4/2jzQ7oHfJnIDHzXueWAYp7CM8HCIPM0U1
eHa/cRpo36FVj6EuDHbCyPs5DC20f6yzEW31aKlFYzXqqlB9l6pry8tQWoqi
YuQXIjefJWIOUrOQnEG7COJuISYJ1xNxJY7Kzy5cx7mrCIvCyQhqefg8DpzF
ntP49iTVQm4+Iuurlu3Ckp34dDsTi3CBt+Gv2/DBDs4GKrJh3iksvISlMVid
Ri3CGjnWy7G1+3acKzh6YSyOiNTfOSDLStMMKDWhyUZbi4yqJfK42wmPAz7G
UIAFjOAevwm+QXIGPf1w9yq1/C8PMnp6m9HThO4GdNTRZsPmKgpkCKOkugx3
S2n3WmkhivJRwNmfbOHNZCA1DckpSExG3E1Ex9P+i8vREBo0/ArORuL0JSoj
UuTRtE2Hsf4Q1h3EqgP4ch+VLCzZQ4L+M65aWHhQjWF9fAKLzmFxJJbFYI2s
NB9bKURhHwUfo7bbmN2TL6u4mXNYllXf7Ea+EdVDaLFBb5eYf8Jmg8MKpwWu
IdqxIASKywhXP7GJw0DF59ZuWDph7sA0prmqEtwtQlkBFaAWsfd3OwtZ6UhP
Rcotpc30I+eogGjvabIcdhzH1mNU+Lj+KImONUex6jusPIYvj8sZTFhyDl9E
YMV1rLo5uut83OhaqxKT1lqJS6X1oNhIRWfiotuqVgabzRgy0V5HixGWPuJv
Sw9taTV30Q7XgTZ1XRtpI2xnHdprKKbSfBcN5ai7o8SoQp5NTkJiItVTRsfi
WjSiriPiKsKjaEvE6QicuESjHBKG6DnsOYtvz2B7GLaEYVMYNpyRmZzVEVh1
BaujFf3++n28/QsJC+lKpoXQvF7aOVdtRLMJHSYJy2/6+tHHwrxfT5WqfZ3M
s23oaaH9AZ0NtBG0tZb2hTZWUn1rbRmqS8lkLitCSQHtUxTtc7Npl19GOu2C
S76lkmYC1XFFxVCNEzHvNbI5TnLN35HLOCiMjwiJ5U1XsPEGNsRiQyI23FKg
eQ1j8qq8605Lda+qkE1M64ZwVsv6UCXMoH409ise7M872mlHZ2sLWprQ1IjG
ejTUUT1mdRUq76KinLYglpaguAiFBchjAZSVg/QspGRS8VlCKmJTEH2Lyn+j
khB5ExcTcT5R8takfbHYE4dvE7DzJnbcwvZ0bMtSsKrOXamtex737z1Xq3Zf
V+c/ObEdaZ243Y3iHtzpQYUelXpUd+MX/PRUKk6k4js23A6lY38G9mRiVw7G
YmnqqKz6/l3BoQ/BI82D8TUlppn2IYmz9DZktCKzhXapZTUhu0nIiduNCHlB
mJPZdciqQWY10quQdhepFbjF2c3EO4grQXQxrhfhSiEiC3AhH+fzyR44nY+T
eTiWj6P5OFSg4O9v5cyVXQ/qPpgf3vmu2oLamj9qR2Wr4yJrMC5SeMuhEVW4
VImLnN0+V6EUtf4SYyoufgS+psi3va55G82a5A9l/0NlpODHjHfv11Pu4V/7
yxn/Xc7xpz9yTDWurPW2X9KM+1/luC+PUqUaX1XzNdqZ/VQzwp/kCMrvUPxB
9tDWHv6TbKX8YscfMSYbOqbVH2Qr5ZdN/knCoK0WUfH7H7jVP8uxnte0UqsR
lF+c+ZOkJW0u+3XZ6p+51e/lWFPlt9YLeVW25l+EUH415r5VmIYxvzKjqTKm
fn9+RL/p8n1an16tZvwfj+j35EPWR7ur/Fn57v/1iDHUX43QUpA2BjxDjqN7
xDjPYuzOvvtzAtRv9n0YfgEP380yWbZ+h1v/H4z5TZtF93bXUYv3ucXMsRhQ
whlssM3jp2+oMMm+C/iu8gtNf8H9EvgzvvuvD8ClxcvCfxftxv5myz3ovv83
q0Ie+398DQ0z\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4814476]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalPlot3D", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"1", "/", "5"}], 
     RowBox[{"Sin", "[", 
      RowBox[{"3", "v"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->115824534],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->590747737]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->631831970],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " for implicit curves and regions:"
}], "ExampleText",
 CellID->6917181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "4"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{"1", "<", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "4"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58342368],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdmQlwVuUVhmOgglMjlDo4CWrKMkirQBFC46AcKEtHxbIItjpqKTaKFMJq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     "], {{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       TagBox[
        TooltipBox[LineBox[CompressedData["
1:eJwl1WV7EAQUBeCN0d0N2+jubkY3jG4YnaM7N7q7u7tbCSUUbEFBwZYOpcOA
dw8f3nN/wTk3NCIyvH9gQEDAHhFzYxFEbOIQl3jEJwEJSURikpCUZCQnBSlJ
RWrSkJZ0pCcDGclEZrKQlWBCCCUb2clBTnKRmzzkJR/5KUBBClGYIhSlGMUp
QUlKUZoylKUc5alARSpRmSpUJYxqVKcGNalFbepQl3rUpwENaURjmhBOU5rR
nBa0pBWtaUNb2tGeDnSkE52JoAtd6UZ3etCTXvSmD33pR38iGcBABjGYIQxl
GMMZwUhGMZoxjGUc45nARKKIZhKTmcJUpjGdGcxkFrOZw1zmMZ8FLGQRi1nC
UpaxnBWsZBWrWcNa1rGeDWxkE5vZwla2sZ0d7GQXu9nDXvaxnwMc5BCHOcJR
jnGcE3zAh5zkFKc5w0d8zFnOcZ4LfMKnXOQSn/E5X/AlX/E13/Atl7nCd3zP
Va7xAz9ynRv8xM/8wq/8xu/8wZ/c5Ba3ucNd7nGfBzzkEX/xN495wlOe8ZwX
vOQVr3nDP/zLf/zPW2LKH0gsgohNHOISj/gkICGJSEwSkpKM5KQgJalITRrS
ko70ZCAjmchMFrISTAihZCM7OchJLnKTh7zkIz8FKEghClOEohSjOCUoSSlK
U4aylKM8FahIJSpThaqEUY3q1KAmtahNHepSj/o0oCGNaEwTwmlKM5rTgpa0
ojVtaEs72tOBjnSiMxF0oSvd6E4PetKL3vShL/2IGe9IBjCQQQxmCEMZxnBG
MJJRjGYMYxnHeCYwkSiimcRkpjCVaUxnBjOZxWzmMJd5zGcBC1nEYpawlGUs
ZwUrWcVq1rCWdaxnAxvZxGa2sJVtbGcHO9nF7sD3f+sdAOa+Cw==
          "]],
         RowBox[{
           RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}], "\[Equal]", "4"}]],
        Annotation[#, $CellContext`x^2 + $CellContext`y^2 == 4, 
         "Tooltip"]& ]}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-2, 2}, {-2, 2}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyd23+w39OZB/DrR+2wzdZmdXH9WCySrJ/N5GpGw1GxWGPaK7WRql4WUZIs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     "], {{
       {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmwncl1P6xp9zzpNtEkmWNkoRyhaVFlKE7Em2UIkoMqGkSClkqZAlDFMx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           "]], PolygonBox[CompressedData["
1:eJwtmHnAllMaxt/znKMpzbQog5DS0AwzsjSUmUq078tMVNoLQ5tKYYSaKCFl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           "]], PolygonBox[{{1068, 420, 1067, 374, 405}}]}]}, {}, {}, {}}, 
      {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwl1FWUlWUYhuHNDF3ScACsBdIp3SgKHHhCxwkn1EIapKRcLEoJFRDlgEHp
7g6lpEEaVBqkQ3oAGeB6Fwf33M/zfnv/e8/3f/8u1rFPy97pEonEIH82JScS
X4aTEol78nq+hI3yBtzGLaw1u4D18jrkwL8omN4ar8FqZEILbDFvztPxE5ph
ptkK15gqL+KiehEUxlu9qfkmuQlPxmfYqzfmV9Yb8Ub9E56Ehtijf8zPrdeP
76zX44mogz/0uvzM+kfyU67C83iC+ez4PnoN+Vt8g2rYbVadH1q/yP/FvnAB
8wv8QP+Hz+McftX/4r9xGmdxBr+Yn+ITGGqfZ+kn5RQ+xsdxBEfxZ+yR+SE+
jAO4rx/k/D53P9/T9/Hd+H+4Mk7KI7gquntdFe7B43mutcryY67Ej7hW3Ge5
Jp/S52CaXlt/Ir/AGj2VT2M+ftQbWH8pv8Za/X8+gwWYrn9qPU2uKr/hatwL
PfGdtcVmP8tJ8sjYN30JZph9riejrpyeL6Ml0umZuR5f4Wu4isFxHSTjun4T
NzAi3o878mj7vcH178pfm2VARtyP+xn3EKP0TPEZsUd6K84V+4D2yKLvQm65
NefhDrGv8nbXTpFnoWt8nlkXHsNzeCyPQ9s443qbOO9xb7BA3h17J+/nhXpv
uQT6xPOhHzBfJB+KfdL7y6XiecVS/XDM49zwcn2QXAal5YmYFPuOyVgWe4bv
5SG8Asvj/HnvKrOhcnnsQFY9G4bJqaiAnchuVhY3vScHv4jzgF3IqZfDLWsf
8Kt4hpLf/8aUj+eNK/Bt67ni7Fh7Hc8ncusV455Zy8NpZm/i2UZePR+Gy29R
MX4TkDCrxKv5hPetlFfhq/jfzI6a3cAP8hR0i+8e+8NfxHeVV/Ixr1kqD4j/
UR/I42IPsUw/Yn2x3Df2Ru8X9xUl4zzrB+PeyT2xPc573CMuiQ/jDMX58Zrr
KKa304vz7PjNQCf8btY53h8ZBfEchcx/423Yimd4Gtm1rmGLvBmP8DCy2ZWk
97/p7wAD1dcI
        "]], 
       LineBox[{1077, 1049, 1135, 728, 1136, 1078, 1079, 1050, 1137, 729, 
        1138, 1080, 1081, 1051, 1139, 730, 1140, 912, 840, 1141, 841, 1142, 
        769, 913, 684, 1178, 845, 774, 846, 1179, 685, 916, 688, 1182, 853, 
        779, 854, 1183, 689, 920, 780, 1147, 855, 1144, 1146, 1145, 921, 1148,
         1089, 1090, 1088, 1092, 1091, 1150, 1096, 1097, 1095, 1099, 1098, 
        1152, 1103, 1104, 1102, 1106, 1105, 1154, 923, 701, 1185, 789, 897, 
        898, 702, 1186, 860, 790, 794, 1204, 793, 740, 704, 1188, 866, 795, 
        800, 799, 900, 899, 1162, 874, 1159, 1161, 1160, 933, 711, 1126, 1127,
         1123, 1125, 1124, 710, 1121, 1122, 1118, 1120, 1119, 709, 1116, 1117,
         1113, 1115, 1114, 708, 932, 705, 1189, 873, 798, 931, 871, 1224, 872,
         792, 865, 1213, 864, 927, 862, 1223, 863, 788, 859, 1212, 858, 924, 
        787, 857, 1184, 700, 922, 698, 738, 1060, 1059, 1101, 1100, 695, 736, 
        1058, 1057, 1094, 1093, 692, 734, 1056, 1055, 1087, 1086, 690, 732, 
        782, 1084, 783, 1085, 778, 919, 851, 1211, 852, 896, 777, 1181, 687, 
        915, 843, 1209, 844, 895, 773, 1177, 683, 911, 768, 839, 1174, 679, 
        727, 1134, 1076, 1077}]}}],
    AspectRatio->1,
    Frame->True,
    Method->{"TransparentPolygonMesh" -> True, "AxesInFront" -> True},
    PlotRange->{{-2, 2}, {-2, 2}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{330, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1966099791]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], "]"}], "-", 
    RowBox[{"2", 
     RowBox[{"Cos", "[", 
      RowBox[{"4", "\[Theta]"}], "]"}]}], "+", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"\[Theta]", "/", "12"}], "]"}], "5"]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"20", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58574956],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 204},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->535190490]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108743675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"\[Theta]", "+", "i"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"2", 
         RowBox[{"Pi", "/", "16"}]}]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "t", ",", "r"}], "}"}], ",", 
      RowBox[{"Hue", "[", "r", "]"}]}], "]"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "False"}], ",", 
   RowBox[{"RegionFunction", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "t", ",", "r"}], "}"}], ",", 
      RowBox[{"r", "<", "0.555"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "20"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1758260051],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140105259]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPolarPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPolarPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParametricPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParametricPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RevolutionPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RevolutionPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Some Special Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeSpecialPlots"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with PolarPlot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=PolarPlot"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionVisualization"]], "MoreAbout",
 CellID->709293889],

Cell[TextData[ButtonBox["New in 6.0: Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FunctionVisualization"]], "MoreAbout",
 CellID->9360947],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->86299350]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolarPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 10, 37.5577506}", "context" -> "System`", 
    "keywords" -> {
     "Archimedean spiral", "Guilloche", "logarithmic spiral", 
      "polar coordinates", "spirals"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PolarPlot[r, {\\[Theta], \\[Theta]_min, \\[Theta]_max}] generates a \
polar plot of a curve with radius r as a function of angle \\[Theta]. \
PolarPlot[{f_1, f_2, ...}, {\\[Theta], \\[Theta]_min, \\[Theta]_max}] makes a \
polar plot of curves with radius functions f_1, f_2, ....", 
    "synonyms" -> {"polar plot"}, "title" -> "PolarPlot", "type" -> "Symbol", 
    "uri" -> "ref/PolarPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[24087, 782, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->492602635]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 952797, 18156}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2549, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3172, 88, 1574, 37, 70, "ObjectNameGrid"],
Cell[4749, 127, 2222, 71, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[7008, 203, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7486, 220, 272, 9, 70, "Notes",
 CellID->3469382],
Cell[7761, 231, 862, 34, 70, "Notes",
 CellID->49764058],
Cell[8626, 267, 414, 15, 70, "Notes",
 CellID->24417],
Cell[9043, 284, 461, 16, 70, "Notes",
 CellID->29397],
Cell[9507, 302, 381, 12, 70, "Notes",
 CellID->8125],
Cell[9891, 316, 224, 8, 70, "Notes",
 CellID->41],
Cell[10118, 326, 361, 12, 70, "Notes",
 CellID->7406],
Cell[10482, 340, 6751, 185, 70, "3ColumnTableMod",
 CellID->11410],
Cell[17236, 527, 489, 18, 70, "Notes",
 CellID->28463],
Cell[17728, 547, 1044, 36, 70, "Notes",
 CellID->32048],
Cell[18775, 585, 315, 11, 70, "Notes",
 CellID->4690],
Cell[19093, 598, 638, 19, 70, "Notes",
 CellID->4969],
Cell[19734, 619, 635, 20, 70, "Notes",
 CellID->5344],
Cell[20372, 641, 454, 15, 70, "Notes",
 CellID->40938333],
Cell[20829, 658, 495, 18, 70, "Notes",
 CellID->28599],
Cell[21327, 678, 1057, 36, 70, "Notes",
 CellID->14643],
Cell[22387, 716, 83, 1, 70, "Notes",
 CellID->10155],
Cell[22473, 719, 1000, 35, 70, "Notes",
 CellID->131709506],
Cell[23476, 756, 574, 21, 70, "Notes",
 CellID->14537]
}, Closed]],
Cell[CellGroupData[{
Cell[24087, 782, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->492602635],
Cell[CellGroupData[{
Cell[24472, 796, 148, 5, 70, "ExampleSection",
 CellID->283694230],
Cell[24623, 803, 62, 1, 70, "ExampleText",
 CellID->156902310],
Cell[CellGroupData[{
Cell[24710, 808, 238, 8, 28, "Input",
 CellID->40083349],
Cell[24951, 818, 4277, 74, 184, "Output",
 Evaluatable->False,
 CellID->9106892]
}, Open  ]],
Cell[29243, 895, 124, 3, 70, "ExampleDelimiter",
 CellID->47427109],
Cell[29370, 900, 69, 1, 70, "ExampleText",
 CellID->272734889],
Cell[CellGroupData[{
Cell[29464, 905, 400, 14, 28, "Input",
 CellID->175386796],
Cell[29867, 921, 7293, 124, 201, "Output",
 Evaluatable->False,
 CellID->682596414]
}, Open  ]],
Cell[37175, 1048, 126, 3, 70, "ExampleDelimiter",
 CellID->1361751124],
Cell[37304, 1053, 61, 1, 70, "ExampleText",
 CellID->1217914989],
Cell[CellGroupData[{
Cell[37390, 1058, 599, 20, 47, "Input",
 CellID->1830580566],
Cell[37992, 1080, 7292, 124, 201, "Output",
 Evaluatable->False,
 CellID->95747394]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45333, 1210, 222, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[45580, 1221, 228, 7, 70, "ExampleSubsection",
 CellID->74545675],
Cell[45811, 1230, 103, 2, 70, "ExampleText",
 CellID->269159930],
Cell[CellGroupData[{
Cell[45939, 1236, 275, 9, 70, "Input",
 CellID->172764079],
Cell[46217, 1247, 13942, 233, 70, "Output",
 Evaluatable->False,
 CellID->405328006]
}, Open  ]],
Cell[60174, 1483, 125, 3, 70, "ExampleDelimiter",
 CellID->130517886],
Cell[60302, 1488, 85, 1, 70, "ExampleText",
 CellID->582383891],
Cell[CellGroupData[{
Cell[60412, 1493, 253, 8, 70, "Input",
 CellID->11813271],
Cell[60668, 1503, 3824, 67, 70, "Output",
 Evaluatable->False,
 CellID->396594425]
}, Open  ]],
Cell[64507, 1573, 125, 3, 70, "ExampleDelimiter",
 CellID->616106199],
Cell[64635, 1578, 98, 1, 70, "ExampleText",
 CellID->369531415],
Cell[CellGroupData[{
Cell[64758, 1583, 658, 21, 70, "Input",
 CellID->453187265],
Cell[65419, 1606, 6406, 109, 70, "Output",
 Evaluatable->False,
 CellID->179638243]
}, Open  ]],
Cell[71840, 1718, 125, 3, 70, "ExampleDelimiter",
 CellID->342693763],
Cell[71968, 1723, 117, 3, 70, "ExampleText",
 CellID->353351085],
Cell[CellGroupData[{
Cell[72110, 1730, 234, 7, 70, "Input",
 CellID->30552953],
Cell[72347, 1739, 4255, 74, 70, "Output",
 Evaluatable->False,
 CellID->277404433]
}, Open  ]],
Cell[76617, 1816, 125, 3, 70, "ExampleDelimiter",
 CellID->324058600],
Cell[76745, 1821, 357, 13, 70, "ExampleText",
 CellID->868277022],
Cell[CellGroupData[{
Cell[77127, 1838, 650, 20, 70, "Input",
 CellID->389502305],
Cell[77780, 1860, 5360, 117, 230, "Output",
 CellID->581420140]
}, Open  ]],
Cell[83155, 1980, 123, 3, 70, "ExampleDelimiter",
 CellID->6387897],
Cell[83281, 1985, 223, 8, 70, "ExampleText",
 CellID->214993069],
Cell[CellGroupData[{
Cell[83529, 1997, 466, 15, 70, "Input",
 CellID->41892276],
Cell[83998, 2014, 4254, 74, 70, "Output",
 Evaluatable->False,
 CellID->102457925]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[88301, 2094, 233, 7, 70, "ExampleSubsection",
 CellID->176579689],
Cell[88537, 2103, 102, 2, 70, "ExampleText",
 CellID->150311282],
Cell[CellGroupData[{
Cell[88664, 2109, 274, 9, 70, "Input",
 CellID->74897845],
Cell[88941, 2120, 7130, 121, 70, "Output",
 Evaluatable->False,
 CellID->846013056]
}, Open  ]],
Cell[96086, 2244, 123, 3, 70, "ExampleDelimiter",
 CellID->4217391],
Cell[96212, 2249, 101, 2, 70, "ExampleText",
 CellID->63093614],
Cell[CellGroupData[{
Cell[96338, 2255, 539, 16, 70, "Input",
 CellID->235628210],
Cell[96880, 2273, 7324, 124, 70, "Output",
 Evaluatable->False,
 CellID->33027935]
}, Open  ]],
Cell[104219, 2400, 125, 3, 70, "ExampleDelimiter",
 CellID->947263323],
Cell[104347, 2405, 54, 1, 70, "ExampleText",
 CellID->335188046],
Cell[CellGroupData[{
Cell[104426, 2410, 481, 15, 70, "Input",
 CellID->575371355],
Cell[104910, 2427, 7398, 125, 70, "Output",
 Evaluatable->False,
 CellID->149554668]
}, Open  ]],
Cell[112323, 2555, 125, 3, 70, "ExampleDelimiter",
 CellID->699549274],
Cell[112451, 2560, 219, 8, 70, "ExampleText",
 CellID->213196035],
Cell[CellGroupData[{
Cell[112695, 2572, 386, 12, 70, "Input",
 CellID->162853632],
Cell[113084, 2586, 58629, 987, 70, "Output",
 CellID->668952026]
}, Open  ]],
Cell[171728, 3576, 125, 3, 70, "ExampleDelimiter",
 CellID->383190062],
Cell[171856, 3581, 65, 1, 70, "ExampleText",
 CellID->28724436],
Cell[CellGroupData[{
Cell[171946, 3586, 267, 8, 70, "Input",
 CellID->394612338],
Cell[172216, 3596, 4877, 84, 70, "Output",
 Evaluatable->False,
 CellID->710609877]
}, Open  ]],
Cell[177108, 3683, 124, 3, 70, "ExampleDelimiter",
 CellID->65033741],
Cell[177235, 3688, 78, 1, 70, "ExampleText",
 CellID->25420136],
Cell[CellGroupData[{
Cell[177338, 3693, 488, 14, 70, "Input",
 CellID->245937364],
Cell[177829, 3709, 6256, 107, 70, "Output",
 Evaluatable->False,
 CellID->239620435]
}, Open  ]],
Cell[184100, 3819, 125, 3, 70, "ExampleDelimiter",
 CellID->197602998],
Cell[184228, 3824, 69, 1, 70, "ExampleText",
 CellID->191004617],
Cell[CellGroupData[{
Cell[184322, 3829, 649, 18, 70, "Input",
 CellID->915108523],
Cell[184974, 3849, 5060, 87, 70, "Output",
 Evaluatable->False,
 CellID->587289992]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[190095, 3943, 223, 7, 70, "ExampleSection",
 CellID->460171944],
Cell[CellGroupData[{
Cell[190343, 3954, 234, 7, 70, "ExampleSubsection",
 CellID->299104015],
Cell[190580, 3963, 381, 15, 70, "ExampleText",
 CellID->57293869],
Cell[CellGroupData[{
Cell[190986, 3982, 1270, 37, 70, "Input",
 CellID->2070922090],
Cell[192259, 4021, 23533, 390, 70, "Output",
 Evaluatable->False,
 CellID->40686799]
}, Open  ]],
Cell[215807, 4414, 124, 3, 70, "ExampleDelimiter",
 CellID->84102783],
Cell[215934, 4419, 69, 1, 70, "ExampleText",
 CellID->96209800],
Cell[CellGroupData[{
Cell[216028, 4424, 347, 11, 70, "Input",
 CellID->111562539],
Cell[216378, 4437, 5532, 95, 70, "Output",
 Evaluatable->False,
 CellID->401919490]
}, Open  ]],
Cell[221925, 4535, 125, 3, 70, "ExampleDelimiter",
 CellID->187580093],
Cell[222053, 4540, 340, 12, 70, "ExampleText",
 CellID->147068490],
Cell[CellGroupData[{
Cell[222418, 4556, 462, 13, 70, "Input",
 CellID->143803984],
Cell[222883, 4571, 6983, 119, 70, "Output",
 Evaluatable->False,
 CellID->89047030]
}, Open  ]],
Cell[229881, 4693, 125, 3, 70, "ExampleDelimiter",
 CellID->393865318],
Cell[230009, 4698, 188, 7, 70, "ExampleText",
 CellID->44372465],
Cell[CellGroupData[{
Cell[230222, 4709, 691, 20, 70, "Input",
 CellID->33895657],
Cell[230916, 4731, 2879, 51, 70, "Output",
 Evaluatable->False,
 CellID->51683351]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[233844, 4788, 239, 7, 70, "ExampleSubsection",
 CellID->9272582],
Cell[234086, 4797, 68, 1, 70, "ExampleText",
 CellID->205032714],
Cell[CellGroupData[{
Cell[234179, 4802, 645, 18, 70, "Input",
 CellID->835889671],
Cell[234827, 4822, 5060, 87, 70, "Output",
 Evaluatable->False,
 CellID->396173008]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[239936, 4915, 238, 7, 70, "ExampleSubsection",
 CellID->452392779],
Cell[240177, 4924, 83, 1, 70, "ExampleText",
 CellID->28145],
Cell[CellGroupData[{
Cell[240285, 4929, 479, 15, 70, "Input",
 CellID->23281],
Cell[240767, 4946, 439, 14, 36, "Output",
 CellID->531218640]
}, Open  ]],
Cell[241221, 4963, 125, 3, 70, "ExampleDelimiter",
 CellID->911956050],
Cell[241349, 4968, 66, 1, 70, "ExampleText",
 CellID->5447],
Cell[241418, 4971, 848, 26, 70, "Input",
 CellID->18716],
Cell[CellGroupData[{
Cell[242291, 5001, 108, 3, 70, "Input",
 CellID->19718],
Cell[242402, 5006, 6508, 111, 70, "Output",
 Evaluatable->False,
 CellID->174981644]
}, Open  ]],
Cell[248925, 5120, 125, 3, 70, "ExampleDelimiter",
 CellID->569319435],
Cell[249053, 5125, 90, 1, 70, "ExampleText",
 CellID->172041979],
Cell[CellGroupData[{
Cell[249168, 5130, 513, 16, 70, "Input",
 CellID->1723218239],
Cell[249684, 5148, 162, 5, 36, "Output",
 CellID->1359802463]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[249895, 5159, 231, 7, 70, "ExampleSubsection",
 CellID->534777178],
Cell[250129, 5168, 77, 1, 70, "ExampleText",
 CellID->24278928],
Cell[CellGroupData[{
Cell[250231, 5173, 256, 8, 70, "Input",
 CellID->679024267],
Cell[250490, 5183, 3018, 54, 70, "Output",
 Evaluatable->False,
 CellID->38939775]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[253557, 5243, 233, 7, 70, "ExampleSubsection",
 CellID->106839402],
Cell[253793, 5252, 265, 8, 70, "ExampleText",
 CellID->95077555],
Cell[CellGroupData[{
Cell[254083, 5264, 603, 18, 70, "Input",
 CellID->191953008],
Cell[254689, 5284, 16796, 280, 70, "Output",
 Evaluatable->False,
 CellID->772870780]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[271534, 5570, 225, 7, 70, "ExampleSubsection",
 CellID->292772160],
Cell[271762, 5579, 85, 1, 70, "ExampleText",
 CellID->60296518],
Cell[CellGroupData[{
Cell[271872, 5584, 600, 18, 70, "Input",
 CellID->30195],
Cell[272475, 5604, 8081, 137, 70, "Output",
 Evaluatable->False,
 CellID->36952217]
}, Open  ]],
Cell[280571, 5744, 125, 3, 70, "ExampleDelimiter",
 CellID->145200893],
Cell[280699, 5749, 181, 6, 70, "ExampleText",
 CellID->11427],
Cell[CellGroupData[{
Cell[280905, 5759, 295, 9, 70, "Input",
 CellID->29355],
Cell[281203, 5770, 4039, 70, 70, "Output",
 Evaluatable->False,
 CellID->581416460]
}, Open  ]],
Cell[285257, 5843, 125, 3, 70, "ExampleDelimiter",
 CellID->510286224],
Cell[285385, 5848, 196, 6, 70, "ExampleText",
 CellID->238138513],
Cell[CellGroupData[{
Cell[285606, 5858, 457, 15, 70, "Input",
 CellID->50003947],
Cell[286066, 5875, 3885, 68, 70, "Output",
 Evaluatable->False,
 CellID->351371202]
}, Open  ]],
Cell[289966, 5946, 125, 3, 70, "ExampleDelimiter",
 CellID->522255988],
Cell[290094, 5951, 177, 6, 70, "ExampleText",
 CellID->665100961],
Cell[CellGroupData[{
Cell[290296, 5961, 631, 21, 70, "Input",
 CellID->1243532340],
Cell[290930, 5984, 3965, 69, 70, "Output",
 Evaluatable->False,
 CellID->11874403]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[294944, 6059, 234, 7, 70, "ExampleSubsection",
 CellID->301207513],
Cell[295181, 6068, 395, 15, 70, "ExampleText",
 CellID->1059804450],
Cell[295579, 6085, 1227, 38, 70, "Input",
 CellID->904022932],
Cell[296809, 6125, 182516, 3017, 70, "Input",
 CellID->96703418],
Cell[479328, 9144, 125, 3, 70, "ExampleDelimiter",
 CellID->800535565],
Cell[479456, 9149, 275, 9, 70, "ExampleText",
 CellID->245904027],
Cell[CellGroupData[{
Cell[479756, 9162, 743, 24, 70, "Input",
 CellID->50730917],
Cell[480502, 9188, 9249, 156, 70, "Output",
 Evaluatable->False,
 CellID->169067544]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[489800, 9350, 231, 7, 70, "ExampleSubsection",
 CellID->33174899],
Cell[490034, 9359, 173, 6, 70, "ExampleText",
 CellID->351997637],
Cell[CellGroupData[{
Cell[490232, 9369, 424, 13, 70, "Input",
 CellID->413205558],
Cell[490659, 9384, 8561, 144, 70, "Output",
 Evaluatable->False,
 CellID->433717958]
}, Open  ]],
Cell[499235, 9531, 124, 3, 70, "ExampleDelimiter",
 CellID->45049747],
Cell[499362, 9536, 198, 8, 70, "ExampleText",
 CellID->323578077],
Cell[CellGroupData[{
Cell[499585, 9548, 424, 13, 70, "Input",
 CellID->740997133],
Cell[500012, 9563, 5319, 91, 70, "Output",
 Evaluatable->False,
 CellID->36182044]
}, Open  ]],
Cell[505346, 9657, 124, 3, 70, "ExampleDelimiter",
 CellID->92424864],
Cell[505473, 9662, 330, 12, 70, "ExampleText",
 CellID->101485524],
Cell[CellGroupData[{
Cell[505828, 9678, 476, 14, 70, "Input",
 CellID->704368403],
Cell[506307, 9694, 10420, 175, 70, "Output",
 Evaluatable->False,
 CellID->594799939]
}, Open  ]],
Cell[516742, 9872, 125, 3, 70, "ExampleDelimiter",
 CellID->340907862],
Cell[516870, 9877, 348, 12, 70, "ExampleText",
 CellID->649526388],
Cell[CellGroupData[{
Cell[517243, 9893, 476, 14, 70, "Input",
 CellID->122170518],
Cell[517722, 9909, 8521, 144, 70, "Output",
 Evaluatable->False,
 CellID->694022332]
}, Open  ]],
Cell[526258, 10056, 125, 3, 70, "ExampleDelimiter",
 CellID->396031902],
Cell[526386, 10061, 479, 18, 70, "ExampleText",
 CellID->471593942],
Cell[CellGroupData[{
Cell[526890, 10083, 551, 16, 70, "Input",
 CellID->1946430847],
Cell[527444, 10101, 10240, 172, 70, "Output",
 Evaluatable->False,
 CellID->62041805]
}, Open  ]],
Cell[537699, 10276, 125, 3, 70, "ExampleDelimiter",
 CellID->569574655],
Cell[537827, 10281, 336, 12, 70, "ExampleText",
 CellID->117954844],
Cell[CellGroupData[{
Cell[538188, 10297, 721, 20, 70, "Input",
 CellID->313117170],
Cell[538912, 10319, 6151, 105, 70, "Output",
 Evaluatable->False,
 CellID->1017086803]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[545112, 10430, 230, 7, 70, "ExampleSubsection",
 CellID->437002195],
Cell[545345, 10439, 78, 1, 70, "ExampleText",
 CellID->37436979],
Cell[CellGroupData[{
Cell[545448, 10444, 318, 10, 70, "Input",
 CellID->199280146],
Cell[545769, 10456, 7764, 131, 70, "Output",
 Evaluatable->False,
 CellID->422889348]
}, Open  ]],
Cell[553548, 10590, 125, 3, 70, "ExampleDelimiter",
 CellID->264850292],
Cell[553676, 10595, 159, 6, 70, "ExampleText",
 CellID->12231612],
Cell[CellGroupData[{
Cell[553860, 10605, 468, 14, 70, "Input",
 CellID->1608970669],
Cell[554331, 10621, 8761, 148, 70, "Output",
 Evaluatable->False,
 CellID->493873382]
}, Open  ]],
Cell[563107, 10772, 124, 3, 70, "ExampleDelimiter",
 CellID->86860238],
Cell[563234, 10777, 263, 9, 70, "ExampleText",
 CellID->187069462],
Cell[CellGroupData[{
Cell[563522, 10790, 572, 18, 70, "Input",
 CellID->1615129237],
Cell[564097, 10810, 9720, 163, 70, "Output",
 Evaluatable->False,
 CellID->389871262]
}, Open  ]],
Cell[573832, 10976, 125, 3, 70, "ExampleDelimiter",
 CellID->271034964],
Cell[573960, 10981, 177, 6, 70, "ExampleText",
 CellID->2133487437],
Cell[CellGroupData[{
Cell[574162, 10991, 480, 15, 70, "Input",
 CellID->1417585583],
Cell[574645, 11008, 7947, 134, 70, "Output",
 Evaluatable->False,
 CellID->476694663]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[582641, 11148, 236, 7, 70, "ExampleSubsection",
 CellID->108763122],
Cell[582880, 11157, 74, 1, 70, "ExampleText",
 CellID->153330426],
Cell[CellGroupData[{
Cell[582979, 11162, 384, 12, 70, "Input",
 CellID->77547222],
Cell[583366, 11176, 11148, 187, 70, "Output",
 Evaluatable->False,
 CellID->217122318]
}, Open  ]],
Cell[594529, 11366, 125, 3, 70, "ExampleDelimiter",
 CellID->108815668],
Cell[594657, 11371, 97, 1, 70, "ExampleText",
 CellID->41034161],
Cell[CellGroupData[{
Cell[594779, 11376, 383, 12, 70, "Input",
 CellID->502356967],
Cell[595165, 11390, 4634, 85, 199, "Output",
 CellID->548544896]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[599848, 11481, 230, 7, 70, "ExampleSubsection",
 CellID->84058811],
Cell[600081, 11490, 90, 1, 70, "ExampleText",
 CellID->232590798],
Cell[CellGroupData[{
Cell[600196, 11495, 575, 18, 70, "Input",
 CellID->269859248],
Cell[600774, 11515, 6537, 132, 135, "Output",
 CellID->41557373]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[607360, 11653, 230, 7, 70, "ExampleSubsection",
 CellID->128315927],
Cell[607593, 11662, 388, 15, 70, "ExampleText",
 CellID->1213642703],
Cell[CellGroupData[{
Cell[608006, 11681, 250, 7, 70, "Input",
 CellID->20474098],
Cell[608259, 11690, 3180, 56, 70, "Output",
 Evaluatable->False,
 CellID->46965649]
}, Open  ]],
Cell[611454, 11749, 124, 3, 70, "ExampleDelimiter",
 CellID->23150485],
Cell[611581, 11754, 137, 4, 70, "ExampleText",
 CellID->406967595],
Cell[CellGroupData[{
Cell[611743, 11762, 232, 7, 70, "Input",
 CellID->19296386],
Cell[611978, 11771, 2765, 49, 70, "Output",
 Evaluatable->False,
 CellID->93849943]
}, Open  ]],
Cell[614758, 11823, 223, 8, 70, "ExampleText",
 CellID->287721820],
Cell[CellGroupData[{
Cell[615006, 11835, 466, 15, 70, "Input",
 CellID->47703644],
Cell[615475, 11852, 4252, 74, 70, "Output",
 Evaluatable->False,
 CellID->9397653]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[619776, 11932, 230, 7, 70, "ExampleSubsection",
 CellID->164733175],
Cell[620009, 11941, 74, 1, 70, "ExampleText",
 CellID->144211486],
Cell[CellGroupData[{
Cell[620108, 11946, 605, 19, 70, "Input",
 CellID->42985262],
Cell[620716, 11967, 17845, 297, 70, "Output",
 Evaluatable->False,
 CellID->606212115]
}, Open  ]],
Cell[638576, 12267, 124, 3, 70, "ExampleDelimiter",
 CellID->19034328],
Cell[638703, 12272, 122, 3, 70, "ExampleText",
 CellID->702451365],
Cell[CellGroupData[{
Cell[638850, 12279, 300, 10, 70, "Input",
 CellID->210197233],
Cell[639153, 12291, 6902, 117, 70, "Output",
 Evaluatable->False,
 CellID->130129650]
}, Open  ]],
Cell[646070, 12411, 124, 3, 70, "ExampleDelimiter",
 CellID->42903131],
Cell[646197, 12416, 109, 3, 70, "ExampleText",
 CellID->24232],
Cell[CellGroupData[{
Cell[646331, 12423, 410, 13, 70, "Input",
 CellID->1371551769],
Cell[646744, 12438, 6910, 117, 70, "Output",
 Evaluatable->False,
 CellID->370972193]
}, Open  ]],
Cell[653669, 12558, 124, 3, 70, "ExampleDelimiter",
 CellID->81270665],
Cell[653796, 12563, 335, 12, 70, "ExampleText",
 CellID->32342228],
Cell[CellGroupData[{
Cell[654156, 12579, 584, 17, 70, "Input",
 CellID->1019673507],
Cell[654743, 12598, 8621, 145, 70, "Output",
 Evaluatable->False,
 CellID->12461813]
}, Open  ]],
Cell[663379, 12746, 125, 3, 70, "ExampleDelimiter",
 CellID->444346277],
Cell[663507, 12751, 331, 12, 70, "ExampleText",
 CellID->43022358],
Cell[CellGroupData[{
Cell[663863, 12767, 476, 14, 70, "Input",
 CellID->830578371],
Cell[664342, 12783, 10419, 175, 70, "Output",
 Evaluatable->False,
 CellID->26886994]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[674810, 12964, 235, 7, 70, "ExampleSubsection",
 CellID->537905511],
Cell[675048, 12973, 230, 9, 70, "ExampleText",
 CellID->1386283524],
Cell[CellGroupData[{
Cell[675303, 12986, 580, 17, 70, "Input",
 CellID->2085822262],
Cell[675886, 13005, 5385, 92, 70, "Output",
 Evaluatable->False,
 CellID->100579649]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[681320, 13103, 237, 7, 70, "ExampleSubsection",
 CellID->191873435],
Cell[681560, 13112, 97, 1, 70, "ExampleText",
 CellID->188014557],
Cell[CellGroupData[{
Cell[681682, 13117, 401, 13, 70, "Input",
 CellID->904774868],
Cell[682086, 13132, 5210, 89, 70, "Output",
 Evaluatable->False,
 CellID->122275566]
}, Open  ]],
Cell[687311, 13224, 125, 3, 70, "ExampleDelimiter",
 CellID->173823983],
Cell[687439, 13229, 99, 1, 70, "ExampleText",
 CellID->681982236],
Cell[CellGroupData[{
Cell[687563, 13234, 385, 12, 70, "Input",
 CellID->1269758651],
Cell[687951, 13248, 5345, 92, 70, "Output",
 Evaluatable->False,
 CellID->293326244]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[693357, 13347, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[693587, 13356, 57, 1, 70, "ExampleText",
 CellID->903762329],
Cell[CellGroupData[{
Cell[693669, 13361, 216, 7, 70, "Input",
 CellID->379048554],
Cell[693888, 13370, 3575, 63, 70, "Output",
 Evaluatable->False,
 CellID->395758000]
}, Open  ]],
Cell[697478, 13436, 49, 1, 70, "ExampleText",
 CellID->906191],
Cell[CellGroupData[{
Cell[697552, 13441, 223, 7, 70, "Input",
 CellID->205417942],
Cell[697778, 13450, 2896, 52, 70, "Output",
 Evaluatable->False,
 CellID->205642350]
}, Open  ]],
Cell[700689, 13505, 74, 1, 70, "ExampleText",
 CellID->11026438],
Cell[CellGroupData[{
Cell[700788, 13510, 355, 12, 70, "Input",
 CellID->718642031],
Cell[701146, 13524, 4022, 70, 70, "Output",
 Evaluatable->False,
 CellID->327056756]
}, Open  ]],
Cell[705183, 13597, 126, 3, 70, "ExampleDelimiter",
 CellID->1723324061],
Cell[705312, 13602, 271, 10, 70, "ExampleText",
 CellID->795546138],
Cell[CellGroupData[{
Cell[705608, 13616, 870, 25, 70, "Input",
 CellID->167368668],
Cell[706481, 13643, 10800, 181, 70, "Output",
 Evaluatable->False,
 CellID->43303981]
}, Open  ]],
Cell[717296, 13827, 280, 10, 70, "ExampleText",
 CellID->585340452],
Cell[CellGroupData[{
Cell[717601, 13841, 1491, 47, 70, "Input",
 CellID->510755144],
Cell[719095, 13890, 5303, 91, 70, "Output",
 Evaluatable->False,
 CellID->181962554]
}, Open  ]],
Cell[724413, 13984, 125, 3, 70, "ExampleDelimiter",
 CellID->311150177],
Cell[724541, 13989, 286, 10, 70, "ExampleText",
 CellID->378344394],
Cell[CellGroupData[{
Cell[724852, 14003, 494, 15, 70, "Input",
 CellID->135151191],
Cell[725349, 14020, 6866, 117, 70, "Output",
 Evaluatable->False,
 CellID->228245017]
}, Open  ]],
Cell[732230, 14140, 125, 3, 70, "ExampleDelimiter",
 CellID->309276630],
Cell[732358, 14145, 239, 8, 70, "ExampleText",
 CellID->1787935020],
Cell[732600, 14155, 1766, 53, 70, "Input",
 CellID->283838235],
Cell[CellGroupData[{
Cell[734391, 14212, 333, 10, 70, "Input",
 CellID->1213238898],
Cell[734727, 14224, 39887, 658, 70, "Output",
 Evaluatable->False,
 CellID->149548127]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[774663, 14888, 237, 7, 70, "ExampleSection",
 CellID->597514546],
Cell[774903, 14897, 348, 12, 70, "ExampleText",
 CellID->71264896],
Cell[CellGroupData[{
Cell[775276, 14913, 647, 20, 70, "Input",
 CellID->33614225],
Cell[775926, 14935, 6596, 112, 70, "Output",
 Evaluatable->False,
 CellID->595561146]
}, Open  ]],
Cell[782537, 15050, 125, 3, 70, "ExampleDelimiter",
 CellID->253825343],
Cell[782665, 15055, 208, 8, 70, "ExampleText",
 CellID->1112749563],
Cell[CellGroupData[{
Cell[782898, 15067, 495, 15, 70, "Input",
 CellID->789105347],
Cell[783396, 15084, 4408, 76, 70, "Output",
 Evaluatable->False,
 CellID->203142114]
}, Open  ]],
Cell[787819, 15163, 124, 3, 70, "ExampleDelimiter",
 CellID->88476759],
Cell[787946, 15168, 364, 13, 70, "ExampleText",
 CellID->85481619],
Cell[CellGroupData[{
Cell[788335, 15185, 584, 21, 70, "Input",
 CellID->24486205],
Cell[788922, 15208, 27248, 451, 70, "Output",
 Evaluatable->False,
 CellID->321718622]
}, Open  ]],
Cell[CellGroupData[{
Cell[816207, 15664, 733, 24, 70, "Input",
 CellID->704574670],
Cell[816943, 15690, 23275, 386, 70, "Output",
 Evaluatable->False,
 CellID->549631156]
}, Open  ]],
Cell[840233, 16079, 124, 3, 70, "ExampleDelimiter",
 CellID->10530632],
Cell[840360, 16084, 388, 13, 70, "ExampleText",
 CellID->374378446],
Cell[CellGroupData[{
Cell[840773, 16101, 425, 14, 70, "Input",
 CellID->22233769],
Cell[841201, 16117, 13460, 225, 70, "Output",
 Evaluatable->False,
 CellID->4814476]
}, Open  ]],
Cell[CellGroupData[{
Cell[854698, 16347, 410, 14, 70, "Input",
 CellID->115824534],
Cell[855111, 16363, 34149, 564, 70, "Output",
 Evaluatable->False,
 CellID->590747737]
}, Open  ]],
Cell[889275, 16930, 125, 3, 70, "ExampleDelimiter",
 CellID->631831970],
Cell[889403, 16935, 356, 13, 70, "ExampleText",
 CellID->6917181],
Cell[CellGroupData[{
Cell[889784, 16952, 840, 28, 70, "Input",
 CellID->58342368],
Cell[890627, 16982, 27787, 473, 70, "Output",
 CellID->1966099791]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[918463, 17461, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[CellGroupData[{
Cell[918716, 17472, 506, 16, 70, "Input",
 CellID->58574956],
Cell[919225, 17490, 18285, 304, 70, "Output",
 Evaluatable->False,
 CellID->535190490]
}, Open  ]],
Cell[937525, 17797, 125, 3, 70, "ExampleDelimiter",
 CellID->108743675],
Cell[CellGroupData[{
Cell[937675, 17804, 1278, 35, 70, "Input",
 CellID->1758260051],
Cell[938956, 17841, 9033, 152, 70, "Output",
 Evaluatable->False,
 CellID->140105259]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[948050, 18000, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[948369, 18011, 997, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[949403, 18051, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[949724, 18062, 149, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[949910, 18070, 305, 8, 70, "RelatedLinksSection"],
Cell[950218, 18080, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[950618, 18097, 299, 8, 70, "MoreAboutSection"],
Cell[950920, 18107, 155, 3, 70, "MoreAbout",
 CellID->709293889],
Cell[951078, 18112, 172, 3, 70, "MoreAbout",
 CellID->9360947],
Cell[951253, 18117, 178, 3, 70, "MoreAbout",
 CellID->86299350]
}, Open  ]],
Cell[951446, 18123, 27, 0, 70, "History"],
Cell[951476, 18125, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

