(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    178647,       4399]
NotebookOptionsPosition[    165969,       3986]
NotebookOutlinePosition[    167645,       4033]
CellTagsIndexPosition[    167528,       4027]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Zeta" :> Documentation`HelpLookup["paclet:ref/Zeta"], 
          "PolyGamma" :> Documentation`HelpLookup["paclet:ref/PolyGamma"], 
          "LerchPhi" :> Documentation`HelpLookup["paclet:ref/LerchPhi"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Zeta\"\>", 
       2->"\<\"PolyGamma\"\>", 3->"\<\"LerchPhi\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Recurrence and Sum Functions" :> 
          Documentation`HelpLookup["paclet:guide/RecurrenceAndSumFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"], 
          "Zeta Functions & Polylogarithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/ZetaFunctionsAndPolylogarithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mathematical Functions\"\>", 
       2->"\<\"Recurrence and Sum Functions\"\>", 
       3->"\<\"Special Functions\"\>", 
       4->"\<\"Zeta Functions & Polylogarithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PolyLog", "ObjectName",
 CellID->7933],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolyLog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolyLog"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the polylogarithm function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["Li", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolyLog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolyLog"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["p", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Nielsen generalized polylogarithm function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["S", 
         RowBox[{"n", ",", "p"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20444]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Li", "n"], "(", "z", ")"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      SuperscriptBox["z", "k"], "/", 
      SuperscriptBox["k", "n"]}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->14486],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["S", 
      RowBox[{"n", ",", "p"}]], "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"n", "+", "p", "-", "1"}]], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "!", "p", "!"}], ")"}]}], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "1"], 
      RowBox[{
       SuperscriptBox["log", 
        RowBox[{"n", "-", "1"}]], 
       RowBox[{"(", "t", ")"}], 
       RowBox[{
        RowBox[{
         SuperscriptBox["log", "p"], "(", 
         RowBox[{"1", "-", "z", "t"}], ")"}], "/", "t"}], " ", "d", 
       "\[InvisibleSpace]", "t"}]}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->18025],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["S", 
      RowBox[{"n", "-", "1", ",", "1"}]], "(", "z", ")"}], "=", 
    RowBox[{
     SubscriptBox["Li", "n"], "(", "z", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->32364],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyLog"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->4000],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["PolyLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyLog"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->328880693],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolyLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyLog"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolyLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyLog"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->335997339],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->487760768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"3", ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "24"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"Log", "[", "2", "]"}]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", "2", "]"}], "3"]}], "+", 
    RowBox[{"21", " ", 
     RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{265, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175855336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44961329]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235490961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->307849572],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"z", "+", 
   FractionBox[
    SuperscriptBox["z", "2"], "4"], "+", 
   FractionBox[
    SuperscriptBox["z", "3"], "9"], "+", 
   FractionBox[
    SuperscriptBox["z", "4"], "16"], "+", 
   FractionBox[
    SuperscriptBox["z", "5"], "25"], "+", 
   FractionBox[
    SuperscriptBox["z", "6"], "36"], "+", 
   FractionBox[
    SuperscriptBox["z", "7"], "49"], "+", 
   FractionBox[
    SuperscriptBox["z", "8"], "64"], "+", 
   FractionBox[
    SuperscriptBox["z", "9"], "81"], "+", 
   FractionBox[
    SuperscriptBox["z", "10"], "100"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "11"],
    SeriesData[$CellContext`z, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {1, 
    Rational[1, 4], 
    Rational[1, 9], 
    Rational[1, 16], 
    Rational[1, 25], 
    Rational[1, 36], 
    Rational[1, 49], 
    Rational[1, 64], 
    Rational[1, 81], 
    Rational[1, 100]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{343, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->579354668]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Simple exact values are generated automatically:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"2", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180640071],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "2"], "6"]], "Output",
 ImageSize->{22, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4634522]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"2", ",", "I"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->831017084],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ImaginaryI]", " ", "Catalan"}], "-", 
  FractionBox[
   SuperscriptBox["\[Pi]", "2"], "48"]}]], "Output",
 ImageSize->{95, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->218518673]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{
   RowBox[{"-", "2"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"z", "+", 
   SuperscriptBox["z", "2"]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "z"}], ")"}], "3"]]], "Output",
 ImageSize->{55, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->92081379]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate with large order and arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"50", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"11147697225254007513111810575214137741411", " ", 
    SuperscriptBox["\[Pi]", "50"]}], 
   "80293206052523318035137285558410989749156973742055751680000000000"]}]], \
"Output",
 ImageSize->{516, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->653949760]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"2", ",", 
   RowBox[{"10.", "^", "1000"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2.6509457653710653081012353`15.50304315979885*^6"}], "-", 
  RowBox[{
  "7233.7844124154648114985`12.939007878423899", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31155520]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate to high precision:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"3", ",", 
     RowBox[{"22", "/", "10"}]}], "]"}], ",", "30"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"2.996958257052249106455643471862309494593392458354`30.\
128604568742176", "-", 
  RowBox[{
  "0.976509112810976378535052458419879194750415754617`29.64160017528955", " ",
    "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{462, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->371115682]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->284729499],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"3", ",", "2.20000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"2.99695825705224910645564347186125625635`22.708743407337455", "-", 
  RowBox[{
  "0.97650911281097637853505245841987919475`21.990467000920724", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{364, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14026673]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate for complex order and arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{
   RowBox[{"3.2", "-", "I"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"3.4473112125125276`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.35256695078099265`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->567397358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolyLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyLog"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"4", ",", 
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.5", ",", "0.7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.2026055828608338`", ",", "0.5174790616738993`", ",", 
   "0.7362172409491383`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->269495924]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->178530565],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->159939814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PolyLog", "[", 
   RowBox[{"n", ",", "z"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52335610],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    InterpretationBox["Li",
     PolyLog,
     Editable->False,
     Selectable->False], "n"], "(", "z", ")"}], TraditionalForm]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->464082242]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Ordinary polylogarithm function",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->109632089],

Cell["Infinite arguments give symbolic results:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"2", ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->858164]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolyLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyLog"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"2", ",", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{"Exp", "[", "z", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "z", "]"}], "^", "5"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->331647718],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["\[Pi]", "2"], "12"]}], "+", 
   RowBox[{
    RowBox[{"Log", "[", "2", "]"}], " ", "z"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "4"]}], "+", 
      RowBox[{"Log", "[", "2", "]"}]}], ")"}], " ", 
    SuperscriptBox["z", "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["11", "24"]}], "+", 
      RowBox[{"Log", "[", "2", "]"}]}], ")"}], " ", 
    SuperscriptBox["z", "3"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["5", "8"]}], "+", 
      FractionBox[
       RowBox[{"13", " ", 
        RowBox[{"Log", "[", "2", "]"}]}], "12"]}], ")"}], " ", 
    SuperscriptBox["z", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "5"],
    SeriesData[$CellContext`z, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {Rational[-1, 12] Pi^2, 
    Log[2], Rational[-1, 4] + Log[2], Rational[-11, 24] + Log[2], 
    Rational[-5, 8] + Rational[13, 12] Log[2]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{516, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->260502306]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate derivatives exactly: ", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Derivative", "[", 
     RowBox[{"2", ",", "0"}], "]"}], "[", "PolyLog", "]"}], "[", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"EulerGamma", " ", 
   SuperscriptBox[
    RowBox[{"Log", "[", "2", "]"}], "2"]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Log", "[", "2", "]"}], "3"], "3"], "+", 
  RowBox[{
   RowBox[{"Log", "[", "4", "]"}], " ", 
   RowBox[{"StieltjesGamma", "[", "1", "]"}]}]}]], "Output",
 ImageSize->{366, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->307304880]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion at branch cuts:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", "z"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"z", ",", "2", ",", "3"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", "\[Pi]", " ", 
     RowBox[{"Floor", "[", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Arg", "[", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "z"}], "]"}], 
        RowBox[{"2", " ", "\[Pi]"}]]}], "]"}], " ", 
     RowBox[{"Log", "[", "2", "]"}]}], "+", 
    RowBox[{"2", " ", "\[Pi]", " ", 
     RowBox[{"Floor", "[", 
      FractionBox[
       RowBox[{"\[Pi]", "+", 
        RowBox[{"Arg", "[", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "z"}], "]"}]}], 
       RowBox[{"2", " ", "\[Pi]"}]], "]"}], " ", 
     RowBox[{"Log", "[", "2", "]"}]}], "+", 
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"PolyLog", "[", 
         RowBox[{"2", ",", "2"}], "]"}]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[Pi]", " ", 
        RowBox[{"(", 
         RowBox[{"z", "-", "2"}], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}], "-", "\[Pi]"}], ")"}], 
        " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"z", "-", "2"}], ")"}], "2"]}], "+", 
       RowBox[{
        FractionBox["1", "24"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "\[ImaginaryI]"}], "+", "\[Pi]"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"z", "-", "2"}], ")"}], "3"]}], "+", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", 
          RowBox[{"z", "-", "2"}], "]"}], "4"],
        SeriesData[$CellContext`z, 2, {}, 0, 4, 1],
        Editable->False]}],
      SeriesData[$CellContext`z, 2, {
       Complex[0, 1] PolyLog[2, 2], Rational[1, 2] Pi, 
        Rational[1, 8] (Complex[0, -2] - Pi), 
        Rational[1, 24] (Complex[0, 4] + Pi)}, 0, 4, 1],
      Editable->False], ")"}]}], ")"}]}]], "Output",
 ImageSize->{561, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212128097]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22040815],

Cell["Series expansion at infinity:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[Pi]", "2"], "3"], "+", 
     RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
      RowBox[{"Log", "[", 
       FractionBox["1", "z"], "]"}]}], "-", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        FractionBox["1", "z"], "]"}], "2"]}]}], ")"}], "-", 
   FractionBox["1", "z"], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "z"], ")"}], "2"]}], "-", 
   RowBox[{
    FractionBox["1", "9"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "z"], ")"}], "3"]}], "-", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "z"], ")"}], "4"]}], "-", 
   RowBox[{
    FractionBox["1", "25"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "z"], ")"}], "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "z"], "]"}], "6"],
    SeriesData[$CellContext`z, 
     DirectedInfinity[1], {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   DirectedInfinity[1], {
   Rational[1, 3] Pi^2 + Complex[0, 1] Pi Log[$CellContext`z^(-1)] + 
    Rational[-1, 2] Log[$CellContext`z^(-1)]^2, -1, 
    Rational[-1, 4], 
    Rational[-1, 9], 
    Rational[-1, 16], 
    Rational[-1, 25]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{513, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->771205674]
}, Open  ]],

Cell["Give the result for an arbitrary symbolic direction:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"DirectedInfinity", "[", "w", "]"}], ",", "3"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["\[Pi]", "2"], "6"]}], "-", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
          RowBox[{"Floor", "[", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"Arg", "[", "w", "]"}], 
             RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}], "+", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
          RowBox[{"Floor", "[", 
           FractionBox[
            RowBox[{"\[Pi]", "+", 
             RowBox[{"Arg", "[", "w", "]"}]}], 
            RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "-", 
         RowBox[{"Log", "[", 
          FractionBox["1", "z"], "]"}]}], ")"}], "2"]}]}], ")"}], "-", 
   FractionBox["1", "z"], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "z"], ")"}], "2"]}], "-", 
   RowBox[{
    FractionBox["1", "9"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "z"], ")"}], "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "z"], "]"}], "4"],
    SeriesData[$CellContext`z, 
     DirectedInfinity[$CellContext`w], {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   DirectedInfinity[$CellContext`w], {
   Rational[-1, 6] Pi^2 + 
    Rational[-1, 2] (Complex[0, 1] Pi + 
       Complex[0, 2] Pi Floor[Rational[-1, 2] Pi^(-1) Arg[$CellContext`w]] + 
       Complex[0, 2] Pi 
        Floor[Rational[1, 2] Pi^(-1) (Pi + Arg[$CellContext`w])] - 
       Log[$CellContext`z^(-1)])^2, -1, 
    Rational[-1, 4], 
    Rational[-1, 9]}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{485, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->155899377]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Nielsen generalized polylogarithm function",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell["Special cases:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"0", ",", "p", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "z"}], "]"}]}], ")"}], "p"], 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "p"}], "]"}]]], "Output",
 ImageSize->{97, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->431120683]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"1", ",", "3", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[Pi]", "4"], "90"], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "z"}], "]"}], "3"], " ", 
   RowBox[{"Log", "[", "z", "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "z"}], "]"}], "2"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "-", "z"}]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "z"}], "]"}], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"3", ",", 
     RowBox[{"1", "-", "z"}]}], "]"}]}], "-", 
  RowBox[{"PolyLog", "[", 
   RowBox[{"4", ",", 
    RowBox[{"1", "-", "z"}]}], "]"}]}]], "Output",
 ImageSize->{376, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->151878957]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", "2", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "2"], "8"], "+", 
   FractionBox[
    SuperscriptBox["z", "3"], "18"], "+", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox["z", "4"]}], "384"], "+", 
   FractionBox[
    SuperscriptBox["z", "5"], "60"], "+", 
   FractionBox[
    RowBox[{"137", " ", 
     SuperscriptBox["z", "6"]}], "12960"], "+", 
   FractionBox[
    SuperscriptBox["z", "7"], "140"], "+", 
   FractionBox[
    RowBox[{"363", " ", 
     SuperscriptBox["z", "8"]}], "71680"], "+", 
   FractionBox[
    RowBox[{"761", " ", 
     SuperscriptBox["z", "9"]}], "204120"], "+", 
   FractionBox[
    RowBox[{"7129", " ", 
     SuperscriptBox["z", "10"]}], "2520000"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "11"],
    SeriesData[$CellContext`z, 0, {}, 2, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
    Rational[1, 8], 
    Rational[1, 18], 
    Rational[11, 384], 
    Rational[1, 60], 
    Rational[137, 12960], 
    Rational[1, 140], 
    Rational[363, 71680], 
    Rational[761, 204120], 
    Rational[7129, 2520000]}, 2, 11, 1],
  Editable->False]], "Output",
 ImageSize->{456, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->688826329]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["\<\
Plot of the absolute value of the dilogarithm function in the complex plane: \
\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFfXVYVU33tt3d+thdqI8d6AK7u7sbW+zuVuzu7sTCMVFsEEHAoCQE5NB1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   "], {{{}, 
     {RGBColor[0.3579579129750273, 0.16962535615170876`, 0.6201334665158631], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1uIlVUYhv/tPv7/3uWgZQadjJKaFEpSkKgZtPGMY+mIc1BTgzxEjlpa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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlk0tI1VEQxuc+zPs//39BFGKbyspeS6tV9FhkSEkv2mQPsoKCIgMrCoWi
hyVBBJV1g9R7e5imLlpFi2zVQsFa9TBaRIUvECKCu+z3MYsPZs43M+ec+Waq
jjTtOZ02szqQBYuD2SLwNmM2BNYnZt9zZpUps/0ETMRm7Zw9Lzd7Q+KayKye
+GliJ+Df4Q+BHrgXYBuxk+Q/JP812I4/hZ/HHodvI3aAs0/UO1Vmdo/6o2AQ
uwn0wP/DD7PMXhGzlbu+kf+L+36DO3BXIn/bceJ/wI3gd1B7HXdchb8BGlSb
s07yu8Au4neCpcTO053YzdRvw77AWTHjObW8rTJ4rQPwHfjFyN+umBVw3WA3
+e/xL5N/Dv42fDf+auJbQL7cezAX/itvPAE3Qs5aYqs5G8eezPpftyR+l/5s
1O4BDXCPyRkmPp94L2ao9yXnNVVrb9a1m+FsNOMa9uI/IaeXvxyEL+CXgZL5
m6vhKsg/Sexf6tXgVwXXXprWYq8CUynveXPkPVTv9Kf+4BpKu8O6H3t57H9R
zjH4o2BByt+k3meD90Ya3CX2fuxaP017LzRTmiX15KK05OwM/CPuG4tcM2nV
So0W7Hb4ibRr3klvukAdvatJubbLiPmQdY1vwp3HL2V8hufwltnBY0vkn4W7
FPtsS8O+4D1U7w6BovoZvNc/ydlIvQ3gD3Yf8fPJXRg5pzuvxz6Dmr19/GEJ
3I7E366cj3DPIr9bM6HZvxZ7rHaggrteBr9bO6i/tibeC/25gN2duHb68y1q
RcFnRTs4CNef+C5qxz4zGyvhC2mfgU1wmxN/u84exK6JtFDPp4mvT3x3tbMD
wTWX1o0ghT0Y3JbGmlXtpHZRMzsc+8xqVjWDYznfYe2uZk5aaIe0O9LkPwIp
o0E=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4870417389250822, 0.39406726845512674`, 0.8015763995475895], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmWmQlcUVhr975y5zv3sBwUhcUjEq+6JoTKoC4sKSSlSMLMNqACOV/IhA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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslVUQhr97e297v4UloCwRFQg7ikCMRg2LSH8IgkakUFQwYlyitIig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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6022769207248746, 0.5893536136020158, 0.9103754208898416], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgm0VcWVhs+77w7vnnORdAChBZkUQUxsAXlIIAxphQg4RlCRhEQBV5Sg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lw1+URxr/5Hfl9L4pHoV60xQPBzrSCCLbRtmopEpFAlMOEEUGgU8sh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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6971834017484781, 0.7418419205977166, 0.912538996341223], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgm0VtV1x+/3vvHe+8UAaloeiu/BairKIGCrGKSgKGQtI4MmkhFQICJz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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlwts1uUVxv/9Lv3+t0xnRjJR0YpmKjiwqJQhOJE4luC4qigiFW1BLAUv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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7890870761351474, 0.8558203964439591, 0.902178701599607], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXuU1VUVx38z9/G793cvgYRPXoEPJBAUZgQlefhieEiBWClaSCVPQQ0z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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmwT3UYxo/7u/f+zjm/YxLKFrKMXXdkCcmeNVO2aWxZc21ZaqRIYWS4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         "],
         VertexColors->None], PolygonBox[{{3265, 3069, 1574, 2017, 2179}},
         VertexColors->None]}]}, 
     {RGBColor[0.8743195374985135, 0.8842431512092833, 0.8639946352884085], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGuMVVcVx8+9595zzz332GrBFjUMI4xf2tJaH8BgURmgHRhoTFEbDYPC
aIQpsTxSI69SiIYytY2tH6yVGhoj0CKJUXkMIqXUUEh4JCrUaqEFSy1NMWqf
McX6//Ffk37YOfvuvfba6/lfa9+Pzr/j1m9XkyT5RSVJUn2X6McozZ/TvLOZ
JGNbSTJMax2NJPmYxl9FdD7x2mX6ztD3fq116fuMxkmNBVrfprOPlEmyQ2e2
af82jcPa+7zWbyiSZLTm383Ms0d73Vq7Wnv/0PyuzPs3ik9/PUkOab4uMS1n
kIF5R5x9o5Yk60UzXGOL1u5LfWaWvoX2xus7Tue2a+8vVe9BM7lqvTnXJv4r
q95H/s7U+ozT+Jfkurn0mTFx72U6NzH0Haz43DNxlnu2p177ucYEDIxN8yT5
cemzyDA59GpPfTdnN+rsROm8Sb9fEv2NssuA6AdE80DDdIvFY0np3//UOKBx
rm49sAP+Wai1ozpzT8XyYjPuXSq6JRoPi+4p6dXXtM+h3Rv00zL7LQ0bbdYo
tX6T7nyz5d8LxGNV1X7/nHg8KTlHar4y83dsxAb7Dyb2wesaN+h3f2q7YJOH
xO/hluVi74T2dmj9U+L36cK/kW9TxGWvfu9JbfuNkudx3f1byTpctPs0n6u9
e1PTdVZt21GpfYCuF1rmN6lifsckxhW6+1GN01r/s+JlinRYrL1Vsv9Vudfh
MUWjTeNB8fieeN2uM2Mlw+2F42xm6nhcqrOPZdbpfZqvFe1PW7Y5cTUhddz8
RGuPtExTS31+afhrTMQ2fLZm9hlxPqtuH9+rewdKx/sK8VjZ8h53QIt90AN9
NlR8ZljExhSde7XpmNqdOaeG7p6ROia5f3Pdv7eKdrB0PLwme+wrnDdTM9+x
IWJmaszxzzupZZlTWH/m2DGRPKeqpmENOXtFM7fwmTOiLQpjC/JMjtgjf8kn
4v+8dL22dH7PE+38wnzx7bjS/u0KG8N/rc5ep29P4lwlzr6q+U266xOF95Ad
HdDxT+KzW3x21R1b00KvRsN0VTBK+6tL5ytx94fcsXdQ87tLxzgYMC5whNg/
MRT/4ru1YQy4JbUe5Md5jWlaf1nfH4A3penmiHeHRlXzr2nt6xrrNH+hakwl
D9Hh1xXrCHY+XjF+HpW8xzLnGneTW+hO3I2I2BsfcmGbDs1PyZZj9H2+5rOn
9X0WDNGoa/0a6djeMt3IwFDy/Ts1YxC/F9SsB5hysOHznIUXMi0BPwtjIrj0
b80vF98jnBXtMY2zNcfviYjh3sh75DySmc8lXJUsf9N4sm6ZX6h5Hdmfjzlr
+IR5veHz5Di4cCT4vCkZhkmG45p/SPyuavnuMzXzWV9xvGcNn031rQVOtuns
YNO+/H3qmod/Lu03HDPg9L6GbUIcEU/we7XhnHgu4rAW9Dsz88C/4BMxTg5R
Iy/5iVqmOw9rLEqt//66fbdcZ68I3N8v2Z4o7B+wG9oy7HM0/Pu2/HCocNyg
Xz10pC7gS2R+R/bY1XRMTxLtiNJ3ICuxuSRsm8Vap2g+U1gGbFwPmkv2CJpF
1NDA4aebzp/+sN226BlG1N1jUE+Q8a3cclKLBprW6amK96k106IeEn9f0f5r
4Iv2ztVcF6lx1KXpQU+93VOzLNQEvsjT33AsQo/+/TFfWHf96xbdbHoW8Z+t
+dOS57DGFnBT63NknzXRC/DFbnNDt59Vja9jopeYLvqRhfsNcgB+j0qGlxvW
B2w4CUbmznOwcPsQtujOrtI19fviM6ww/+n6zihsh0Mt77HeJ37f0FgW92A7
7kJv7IA/NtVsT/aoeeTh4sDALOKW+waitmLvAxHb8xvOeWraS7r/XGF+F3Pr
gPyf1PdZjR/VjIt8waYTkfPg0rvgessyXSTempYNXOgL+dFjfszZ65MsTyTO
YXz+K817de7twnubM9c0cqon+jl+s8cZzu4A9+vGq1WBscTLwcAw9JobfoL/
sqjf1KvRknds05iBnRoR56n8Uy1dxwYz30Ffx3dnzH+pc39s+ff1mne0HLPU
QHivCzw/Evh5OGIY2S6Cf+I/Onevgs/wF/4jxvHv9bLBf1vOaTACrADTwIU3
ArvpWR6LfmO09ror7hnoQVjHL8T3rszxi/zog70+qLu/nBvH9up7PPc7gt6N
HFsUtuQtMD1w7EDdWFYPO6EX9kRfMIp7uI+4/U/hfCNm6e2oB9SCv9ccE9B3
6c77c2PqD/WdonGhYd/iK/y7oemcIX4/jI1z1xf6sluiFs/X2rW542xB1KJ7
4q2APXgvHIm8ge/a0lgMtn5W59bnzl1kuS/kmRf2xK5fLPwWolbPjZoBLkwV
7QO5+/qTEY9g0ayQDXx4qzCuEYPfCp6Xx/ulPfJxduG+fGTgDLWEWIZ2XtBz
H+vYlvp2OmoceHMhMPSb+n1rxf3yQLxT4E/OkEvEJHF0Js7Sl5wKvHqxZt/g
l1r0TtTKs7GOPanzfWFfxrLwO/vngqZbPrq55T6d+tkfOLMo7ihDxjs12ivG
A/IRXsQisY5sXyrc89ErbWz57UG8T4k3Au+vScGLOkBMz4x83xq9dFu8A7oi
xybE24Bc4608sek+e1TIQvzDDzueSsxzd/Tb8NsaOUUPzjo4AL/2kIcaT36g
BzVnc/gRv+0K3+FT4uCVxDwGgw+5RY/GefKZu5CZ+rUle4/flvDjnaE7coJz
yIrugyEbv8EedEbf9zfdt5EH3SEfWATWU7OpH+Qu8UeNoz+idyeWuXNzyMA7
amHU073Ko9+U7jX/Vxi7+4biLd6cy+PNgo4Pla673ENPsCJz33t35r6/J+zf
Hj5dlfmNCi19KnlM77orsAy932347UevBe2KoN9TWj5kG950v3g88PGVwAT0
QhfsSX2ZEXWBt8iEwCsw+EJuHKafuq1wbzAT22hcWfd78vXAImIFfXui3o8L
HGDemb7He3zwBycmBA3YO9TXsNYZ68jYH3J2RUwTbz3I0LQv2iLOh/7n6Aoa
erHuqDv0yB+JPrmUTl/InWvQXBk+LcTvxcK16C7tj8+NER1Rh4ht/vNZnbk3
QNfl8T/Px0Xbnzvv6WPAJHJ/RfgR3+HndfHGY47v6SXIxbORj92RH/jqDvH7
QG6sIi/aQkfyaWfUtf3y8+80FoiuV6OVuzatySwrcl6jtatz401nvEt4W7G/
Jv7DQsZV8Z/I6IgV3rbrIj6Rk4HMnOU/JvpZaj5v0O1Nx+Z1umds7lq0OmQg
zpFjdcT5/wH3UXjN
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVVUUhnfvbem+5x5QWsWqAWV4gg44lYDDA4gFtMYAwkutsdUIxak8
kCgCiiYNrVWLMSpUgzGKgkRTrMYaCgJRTFSiBhNqi6JMJtSoaOChBb/fvw9/
7lpnrb32mved2PDowkcyIYQ2UAjOJCFcnAvh64IQ6hG0Qj+dhvBQNoR34B+I
IVSCZcUhNIEdyL/Lh9BdFMInoBJ6Jt9K0W0BYzh7NzYrodePCuEc9CXID2K/
kW9T0J+PznJsHceBFHoROuORPYn+aPjF8JPg18Ev5O4UtHD+CPpXcv4KsAH+
EHwZ9OV506P5VsFdE+F/hj8KaqD3gzfxtQScjb5Td21D/05kf3HmeeItQ14G
fT6xrz8iPwZ9AmzB1j74r5BXgmOFzlEp9NnEuVOM57G3C/tzuWcj2IlsPjiF
7rJC+3Jf4uTLp93QVXz7F34V6IOelLfve5B/jvwMdt4ucI5+ylvnfxlYgHw6
Pvye9R3l0F+CJuhfsHET8jz+PE68rdgIOddItelWPNg6AN7A9tYi+z4sH6Jj
UC5lU7aU01LVU/FmfUa5mIzOb4XOyVB0DVW7Luz3orsncWyK4UF0L8D3wM/i
vpPQSc65XYS9a+GHo8+qh66BPxddK/VEGXQ9yNI/WXy4EfksMAZ5H/wUZPeA
ZvhMsWO/GXlJ8UgO4P/kvnZ0t/JtFHxbavoA9gdHaqZafYPOTmTvoV8E3YdO
C/IhfueCU2AG/Jro/A/Af4b+bcQ4QTMDxmKri9+lyLeDpuiZ0iz1ghLkC7C/
TrOFfDfnu8Bh+FXovQ79bs6xdvNtLN/WRt+1HgyP6En/C1ABvRJ8W+yZ/UD5
4I4hzveA44l7Xr2unn45tQ+6ewf6H474LF93gRrFk3oXKGc3ILsOvMTZQ1nH
fkt0LpSDWnzdiP0V2J/HmQLOZkE1uV+txYNsOPFsqQe0C6oS51o7oRFb00AD
9P0gk9pH+SYb+eidoF2gGn+KrDd1XyhH4/i9gO4R7hoAryB7NXVvq0c0a0+A
2iLP3Db8jZpXbH/Euc3IOsFK5Js4Px7fJoBabFfDN0DXJLatGX6Y+6ZH13Iv
KMPWzMS9qJ5bgmw2OA3dn3Fte1L3kmr2PXediJ7Nj7lzanRNVUvloDw6J8pF
IzgIvQ+fm7HVjwuDmh3VmPvast5ld2BzXJF32v7omqqWmtkOZM9oPyBfDgbg
p8EPEMte+Hp8r0scu3rmBc7eCv7QvkZ+F/Sl0bFoJ5/m7GPE04G8Ff066CFs
Vmfd08/mfKfuUk9sgn4t712tHDen7hH1hmxUQ88AWzKO8SLO/514N+iNkmwt
6Cy2jnZPVc5viXbQ6rzfJL1FqrFifU4zVOyYf4U/qh0Y/GaplvPAyaxr2p56
J2gX6IxmqSE695op7YIf8n77tBOuhr4KTM46h1NzzqlyKZvazfemnlXNRzl0
BUgK3VOqnWZUs6ka1nL29rxnRzVcgW9LwD9Zn5kTXRPVYhCbHdE9qN5TjbQb
66J3n3akdtWL0braWZdBL45+CzUjsn194lnWHUv1XuXc66qhYuvP+61RjJqV
7TnvIs2M/gu8n3Pv6j/BU8g3wL+V8Ru0JvXO165XzQ4nfoP09miHzEY+J3Xv
6Ex79AyrFpqZ49CdqWdTb/5/Oj4mIw==
         "],
         VertexColors->None], 
        PolygonBox[{{3168, 3070, 2194, 2159, 1922}, {2886, 2888, 1298, 2132, 
         2078}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVE1vTWEQnuu2PXPec0IaEqUsLPADsNDWP2gpaw4hFjYsWvED8BuU3mIj
6dWWakNiw4IE3UhJWFyJDRZu76ZcFtLE8+QZsZjMnHnnfeaZj/fsOXvpxMVN
ZlZB6pBHmVkbju+QadizvWYd2FfcbBfkMYJa8P+CrEIe1HX+GdLFdx++c9gf
eswu424zzhizvWa2gphW/X+OtfAvlWbPIYeQ4yHkBeQC+IxCz7iw70CPuXLT
1wj/J+BlyJeAtQH7D+QAMJu52TIwn+D7N+LWM9n3Io4x5EmOP2FXOH8FGa+p
DyvRi8PJbAA4P/rMzuFsrKa7NwuzW5CJ6BF7xZqYh/nYpwbOpyGT0QvGMj+5
vsV5FzjfUMe7QjWwFp7R3w59FDKHWrxUf4lDDPJYxN2XkKvo1THozOWvog7e
fQ3sN4X4ZXXNjTmItdyreY3g3nVXfzgT3uVc1mJOxFkFxkIuDHI/HfzNlZt5
6TufKb4b37Tpq8LmznC3OoHdDvwlYPQn1TIeuek/A/9+F9Ys8s+U2kNy/9gj
/twpzoc5tyB20uVnz+7nqpXn7C9j1mM+rGUbcm5N4sUa2FvOlzvRjD7P56qf
8dzriZjnl0y9SFFHK/CfIe9TyHHXXLOY6/tCe8k+c8c7ufb8NuyDrtm04m3x
zhHwKkrxph5Jsoegh5PysU72gXxPwlclvYG7wNvswvvXa850H3x7XfNgvxdj
f04lvT3yGYa+5qpvBzgPFHorU+Bwo9T7aEB/dc1h0PWP4Fx2InawECfu/Ua8
ud2uPWPtfwG5wqPp
         "],
         VertexColors->None], 
        PolygonBox[{{2494, 2580, 942, 735}, {2165, 2107, 2020, 522}, {2053, 
         2063, 521, 500}, {2654, 2653, 105, 1019}, {3223, 2268, 1994, 1969}, {
         3096, 2621, 988, 1779}, {2619, 2617, 1779, 987}, {2620, 2278, 1031, 
         988}, {2181, 2126, 2039, 950}, {2164, 2124, 2037, 521}, {3256, 3027, 
         950, 2034}, {2437, 3016, 1448, 1947}, {2843, 2839, 500, 1239}, {2087,
          2148, 1893, 1887}, {2163, 2144, 1887, 1999}, {2840, 2973, 1397, 
         1238}, {3229, 2475, 774, 949}, {2126, 2208, 2011, 2039}, {3017, 3015,
          746, 1448}, {2125, 2206, 2001, 2038}, {2062, 2207, 2038, 2011}, {
         2061, 2075, 949, 774}, {2839, 2841, 1238, 500}, {2268, 2618, 987, 
         1994}, {3015, 3224, 1969, 746}, {2180, 2163, 1999, 2020}, {2100, 
         2165, 522, 2001}, {2433, 2652, 1019, 1021}, {2085, 2161, 1991, 
         1886}, {2474, 3228, 1459, 774}, {2056, 2048, 333, 355}, {2973, 2969, 
         1395, 1397}, {2970, 2968, 677, 1395}, {2971, 2433, 1021, 1396}, {
         3026, 2476, 775, 1031}, {2055, 2053, 500, 333}, {2477, 3256, 2034, 
         775}, {2968, 2972, 1396, 677}, {2204, 2061, 774, 2037}, {2244, 2494, 
         735, 131}, {2148, 2086, 1886, 1893}, {2277, 2842, 1239, 1459}, {3258,
          3250, 2101, 2074}, {3260, 3258, 2074, 2168}, {2579, 2437, 1947, 
         942}},
         VertexColors->None], 
        PolygonBox[{{3251, 3260, 2168, 2077, 950}, {3257, 2472, 949, 2076, 
         2129}},
         VertexColors->None]}]}}, {{}, {}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2226, 2577, 2224, 2244, 2494, 2580, 2579, 2437, 3016, 3017, 
         3015, 3224, 3223, 2268, 2618, 2619, 2617, 3096, 2621, 3083, 2620, 
         2278, 3026, 2476, 3025, 2477, 3256, 3027, 2473, 3251, 3260, 3258, 
         3250, 3263}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2541, 2243, 2223, 2653, 2654, 2652, 2433, 2971, 2972, 2968, 
         2970, 2969, 2973, 2840, 2841, 2839, 2843, 2842, 2277, 3228, 2474, 
         3080, 2475, 3229, 2472, 3257, 3262}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2236, 2255, 2499, 2403, 3053, 3126, 3127, 3198, 3197, 2919, 
         2815, 2816, 2813, 2328, 2814, 2397, 2808, 2324, 2806, 2323, 2807, 
         2393, 2803, 2320, 2801, 2319, 2802, 2387, 2791, 2314, 2788, 2790, 
         2789, 2894, 2545, 2892, 2893, 2891, 2381, 2962, 2436, 2961, 2435, 
         3212, 3213, 3078, 3211, 3210, 2544, 3143, 3142, 3062, 2442, 3201, 
         2504, 2505, 2350, 2851, 2351, 2852, 3145, 2607, 3066, 2285, 2739, 
         2633, 2634, 2352, 3167, 3168, 3070, 3261, 3069, 3265}],
        "2.5`"],
       Annotation[#, 2.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2570, 2529, 2530, 2362, 2861, 2361, 2862, 2939, 2938, 2863, 
         2751, 2752, 2750, 2291, 2753, 2367, 2643, 3084, 2295, 2760, 2296, 
         2609, 2368, 2644, 3085, 2300, 2774, 2301, 2610, 2374, 2645, 3086, 
         2304, 2777, 2611, 2613, 2612, 2646, 2667, 3117, 3116, 3049, 2489, 
         2590, 2589, 2377, 2647, 2487, 3068, 3164, 2378, 2578, 3221, 3074, 
         3075, 3073, 3185, 3184, 2540, 3139, 3138, 3060, 2441, 3200, 2502, 
         2503, 2348, 2849, 2349, 2850, 3034, 3035, 3036, 2847, 2848, 2347, 
         3037, 2346, 2632, 2631, 2658, 2657, 3012, 2887, 2888, 2886, 3259, 
         3264}],
        "2.5`"],
       Annotation[#, 2.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2209, 3098, 2745, 2287, 2744, 2288, 3204, 3205, 3038, 3099, 
         2210, 2528, 2212, 3103, 3041, 2449, 3206, 2364, 2532, 2365, 2872, 
         2366, 2873, 2294, 3094, 2594, 2595, 2662, 2663, 2463, 3014, 2464, 
         2664, 2456, 3247, 2457, 3237, 3238, 3239, 2220, 3190, 3191, 3076, 
         2414, 3192, 2404, 2925, 2405, 2688, 2689, 2690, 3110, 2941, 2416, 
         2940, 2417, 2559, 2558, 3183, 2407, 2929, 2931, 2930, 2991, 2539, 
         2272, 3137, 3059, 2440, 3199, 2500, 2501, 2343, 2625, 2344, 2626, 
         2666, 3033, 2485, 2844, 2845, 2846, 2486, 2624, 2623, 2622, 2458, 
         2656, 2459, 3165, 3266}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2920, 2921, 2828, 2330, 2827, 2329, 3178, 3179, 3052, 3125, 
         2232, 2254, 3175, 3176, 3072, 2402, 3177, 2327, 2520, 2395, 2914, 
         2396, 2915, 2708, 2707, 2322, 2805, 3123, 3124, 2250, 2703, 2702, 
         2800, 2799, 2228, 2246, 2698, 2697, 2787, 2786, 2225, 3129, 3128, 
         3054, 2411, 2563, 2562, 2603, 2602, 2668, 2488, 2568, 2567, 2576, 
         2585, 2274, 2508, 2484, 2587, 2432, 2566, 2446, 2974, 2976, 2975, 
         2275, 2586, 2276, 3144, 3063, 3227, 3226, 2605, 2604, 3065, 2284, 
         2738, 2627, 2628, 2345, 3166, 3252, 3267}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV01dsj1EYx/HXbkskLkgkCInaF9SMlVhxh9bebVNN0JbQqtESdSGxW7T2
BS2hZqjR1l4RaiZEzJAmuCOEKuFzLr79nud3nue8r9f/dEpdlJTVIIqinv6c
iImiihZRVIqxsVH0BI8xtHkUjeAhPBzDUK2eqm8aPqg78RHzj+SD1Xfiougu
buK7/Abfxi2UqR/q66MvAb3RD31RJU9y1hB+p25nXWXmq5lKvoxqHFLX6Omu
pwe6YZC6EpftdVWf01eBFeipviLvxefVF7AynKO+Ki/lN2YLPG8dytTbwjvg
LTrI2uO9fBJPxDdzq5xxWHbN+gh/1DvZ3hT0Vw/EAPywn6c3H6vR0f5hWa3+
co5X1+rboV5vPZo/YQxGyEdhJJ7r/SPL0JOJBbIMLEQ5jmNZyPQUe04JduGv
Okt/erD9xViEk/gs+4JczNRbIFuLx571KvwOeLe8C2ZgOpY6awk26cvXs4Hz
eCMPlm/h1erNvIa3crY8B7nWy7HHOXvx1Pmv9TzjRHUSJmCAbIL+RNSHb6ke
b32GD/IpjuPTfIj3cWtz+3keH+Db5jJ5Bc/nbF7AOTxNzyC0NRsr62wdH55t
LxHjkSR/jpaYFWbCN+J5ZtJwzzufR4L1d7Ot7BdyEZL1pWA25mIOXti/oL/e
/h/8RhvZMfPlOIrk0MM14d5YpyDNbHp4Ll6qq+zFWsehKWLQDJXyxtwEDdAI
DXFJ/ttcPUpwM/zWPGM76tQ31A/0XOed3qm1rI7nhG+qZy6n8wy+Gn7v4T6h
SFaIX+Heqe87ozrcHbOTwl0O9wUTw93Gz/Bv44vhHob3De+GcfJzXIGzKFZv
Cd+Uf4T/d/yTp8pS8B89FanA
         "]],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3044, 2370, 3163, 2880, 2687, 2762, 2761, 2879, 2241, 2216, 
         3106, 3043, 3162, 3161, 2302, 2775, 2303, 2776, 2885, 2884, 2514, 
         2222, 3111, 3046, 2376, 2493, 2242, 3113, 3112, 2778, 2306, 2691, 
         2692, 2693, 3118, 2781, 2309, 2694, 2695, 2696, 3119, 3120, 2542, 
         2543, 2453, 2992, 2994, 2993, 2546, 2889, 2890, 2785, 2311, 2784, 
         2312, 3215, 3216, 3050, 3121, 2227, 2550, 2229, 2793, 2794, 2792, 
         2315, 3171, 2390, 3092, 2389, 2795, 2316, 2699, 2901, 2247, 2902, 
         2796, 2797, 2700, 2903, 2248, 2904, 2905, 2798, 2317, 2701, 2906, 
         3051, 2391, 2678, 2679, 2680, 2516, 2517, 2385, 2675, 2676, 2677, 
         2245, 2497, 2384, 2672, 2673, 2674, 2515, 2547, 2380, 2977, 2447, 
         2736, 2737, 2280, 2978, 2279, 3029, 3030, 3028, 2478, 3032, 2483, 
         2665, 2482, 3031, 2655, 2614, 2615, 2783, 2782, 2310, 3087, 2639, 
         3091, 2357, 3090, 2638, 3089, 2637, 2606, 2353, 2635, 2379, 2780, 
         2308, 2779, 2307, 2834, 2336, 2726, 2725, 2724, 2832, 2831, 2989, 
         2571, 2572, 2468, 3019, 3021, 3020, 2261, 2830, 2260, 2717, 2716, 
         2829, 2332, 3088, 2735, 3132, 3056, 2337, 3149, 2331, 3248, 3249, 
         3240, 3254, 2270, 2583, 2271, 3193, 3194, 3077, 2415, 2671, 2670, 
         2669, 2371, 2535, 2534, 2985, 2450, 2984, 2451, 2986, 2299, 2772, 
         2298, 2773, 3108, 2218, 2770, 2771, 2767, 2769, 2768, 2217, 2765, 
         2766, 2763, 2297, 2764, 3107, 3044}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3047, 2281, 3146, 2305, 3148, 2283, 3064, 2282, 3147, 2465, 
         3079, 2466, 3222, 2424, 2950, 2951, 2947, 2949, 2948, 3022, 2964, 
         2965, 2963, 2967, 2966, 2425, 3196, 2953, 2427, 2952, 2426, 2507, 
         2273, 2584, 3141, 3140, 3061, 2471, 3225, 2506, 3018, 2467, 2729, 
         2730, 2731, 2582, 2269, 3131, 2728, 2434, 2960, 2727, 2560, 3095, 
         2408, 2569, 2443, 2588, 2495, 2496, 2444, 3244, 3246, 3245, 2438, 
         2732, 2733, 2734, 2561, 2659, 2660, 2608, 2286, 2591, 2592, 2593, 
         2354, 2636, 2355, 2853, 2356, 2854, 2335, 2601, 2629, 3055, 2267, 
         2630, 2266, 2838, 2341, 2837, 2342, 3232, 3233, 3081, 3231, 3230, 
         2575, 2573, 2574, 2470, 3023, 2469, 3024, 2265, 2833, 2264, 2723, 
         2722, 2334, 2836, 2340, 2835, 2339, 2522, 2333, 3150, 2338, 3057, 
         3133, 3134, 2445, 3136, 3135, 3058, 2439, 2600, 2263, 2565, 2721, 
         2720, 2599, 2422, 3208, 3209, 3048, 3115, 2943, 2420, 2942, 2421, 
         2944, 2418, 2564, 2719, 2718, 2419, 3195, 3114, 3047}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->540095261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Calculate integrals over Fermi\[Dash]Dirac distributions:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Epsilon]", "^", "\[Alpha]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"E", "^", 
       RowBox[{"(", 
        RowBox[{"\[Epsilon]", "-", "\[Mu]"}], ")"}]}], "+", "1"}], ")"}]}], 
   ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Alpha]", "\[GreaterEqual]", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], " ", 
  RowBox[{"PolyLog", "[", 
   RowBox[{
    RowBox[{"1", "+", "\[Alpha]"}], ",", 
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", "\[Mu]"]}]}], "]"}]}]], "Output",
 ImageSize->{212, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->158201862]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Volume of a hyperbolic dodecahedron with vertices 0, 1, ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 " , ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " (subject to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Im",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Im"], 
    RowBox[{"(", 
     StyleBox["z", "TI"], ")"}]}], ">", "0"}]], "InlineFormula"],
 "):"
}], "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "z_", "]"}], " ", ":=", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", " ", "z"}], "]"}], "]"}], "+", " ", 
   RowBox[{
    RowBox[{"Arg", "[", 
     RowBox[{"1", " ", "-", " ", "z"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Abs", "[", "z", "]"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[TextData[{
 "Plot the volume as a function of the vertex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"x", " ", "+", " ", 
     RowBox[{"I", " ", "y"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->622994453]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Mahler measure of the trivariate polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "+", "x", "+", 
    RowBox[{"a", "\[InvisibleSpace]", "y"}], "+", 
    RowBox[{"a", "\[InvisibleSpace]", "z"}]}], TraditionalForm]], 
  "InlineMath"],
 " as a function of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", "a_", "]"}], "=", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"a", "\[LessEqual]", "1"}], ",", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"PolyLog", "[", 
         RowBox[{"3", ",", "a"}], "]"}]}], "-", 
       RowBox[{"2", 
        RowBox[{"PolyLog", "[", 
         RowBox[{"3", ",", 
          RowBox[{"-", "a"}]}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Pi", "^", "2"}], " ", 
        RowBox[{"Log", "[", "a", "]"}]}], "+", 
       RowBox[{"2", 
        RowBox[{"PolyLog", "[", 
         RowBox[{"3", ",", 
          RowBox[{"1", "/", "a"}]}], "]"}]}], "-", 
       RowBox[{"2", 
        RowBox[{"PolyLog", "[", 
         RowBox[{"3", ",", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "a"}]}], "]"}]}]}]}], "]"}], "/", 
    RowBox[{"Pi", "^", "2"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:="],

Cell["Plot the Mahler measure:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"m", "[", "a", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->848615247]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify polylogarithms:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", " ", 
     RowBox[{"1", " ", "-", " ", "z"}]}], "]"}], "+", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", " ", "z"}], "]"}], "  ", "+", " ", 
   RowBox[{
    RowBox[{"Log", "[", "z", "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", " ", "-", " ", "z"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "2"], "6"]], "Output",
 ImageSize->{22, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380528404]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand polylogarithms:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"2", ",", 
   RowBox[{"1", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88873018],

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"2", ",", 
   RowBox[{"1", "-", "\[ImaginaryI]"}]}], "]"}]], "Output",
 ImageSize->{113, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->487014506]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->137972258],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", "Catalan"}], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["\[Pi]", "2"]}], "16"], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "4"]}], "+", 
     FractionBox[
      RowBox[{"Log", "[", "2", "]"}], "2"]}], ")"}]}]}]], "Output",
 ImageSize->{265, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177683901]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"PolyLog", "[", 
   RowBox[{"2", ",", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"I", " ", 
      RowBox[{"Pi", "/", "3"}]}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["\[Pi]", "2"], "108"]}], "+", 
  RowBox[{
   FractionBox["1", "36"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"1", "/", "3"}]], " ", 
   RowBox[{"PolyGamma", "[", 
    RowBox[{"1", ",", 
     FractionBox["1", "6"]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "36"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"2", "/", "3"}]], " ", 
   RowBox[{"PolyGamma", "[", 
    RowBox[{"1", ",", 
     FractionBox["1", "3"]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "36"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"1", "/", "3"}]], " ", 
   RowBox[{"PolyGamma", "[", 
    RowBox[{"1", ",", 
     FractionBox["2", "3"]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "36"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"2", "/", "3"}]], " ", 
   RowBox[{"PolyGamma", "[", 
    RowBox[{"1", ",", 
     FractionBox["5", "6"]}], "]"}]}]}]], "Output",
 ImageSize->{422, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->364214326]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Numerically find a root of a transcendental equation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"PolyLog", "[", 
      RowBox[{"2", ",", "z"}], "]"}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"z", "+", "2"}]}], "]"}]}], "+", "z"}], "\[Equal]", "2"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"3", "+", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{"1.4015498638913408`", "\[InvisibleSpace]", "+", 
    RowBox[{"4.861577841405301`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->506777767]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Integration:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", "z"}], "]"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "z"}], "]"}], "2"]}], "+", 
  FractionBox[
   RowBox[{"z", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", "z"}], "]"}]}], 
   RowBox[{"1", "-", "z"}]]}]], "Output",
 ImageSize->{208, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->528246874]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "a"}], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", "t"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "a", "]"}], ">", 
    RowBox[{"-", "2"}]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "a"}], ")"}], " ", 
      SuperscriptBox["\[Pi]", "2"]}], "-", 
     RowBox[{"6", " ", 
      RowBox[{"HarmonicNumber", "[", 
       RowBox[{"1", "+", "a"}], "]"}]}]}], 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "a"}], ")"}], "2"]}]], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["t", "a"], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", "t"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "a", "]"}], "\[LessEqual]", 
       RowBox[{"-", "2"}]}]}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{436, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->253554760]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Generate from integrals, sums:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "k"}], "/", 
    RowBox[{"k", "^", "\[Nu]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"\[Nu]", ",", "z"}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->672115216]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"HarmonicNumber", "[", 
     RowBox[{"n", ",", " ", "r"}], "]"}], " ", 
    RowBox[{"z", "^", "n"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"r", ",", "z"}], "]"}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", "z"}]]}]], "Output",
 ImageSize->{104, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->651002033]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", 
     RowBox[{"(", 
      RowBox[{"\[Nu]", "-", "1"}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"E", "^", "t"}], "-", "z"}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "\[Nu]", "]"}], ">", "0"}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"Gamma", "[", "\[Nu]", "]"}], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"\[Nu]", ",", "z"}], "]"}]}], "z"], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     FractionBox[
      SuperscriptBox["t", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[Nu]"}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "t"], "-", "z"}]], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "\[Nu]", "]"}], "\[LessEqual]", "0"}]}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{361, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->28753313]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolyLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyLog"]], "InlineFormula"],
 " appears in special cases of various mathematical functions:  "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"PolyLog", "[", 
   RowBox[{"2", ",", "z"}], "]"}], "z"]], "Output",
 ImageSize->{97, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129472937]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{"z", ",", "n", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"PolyLog", "[", 
   RowBox[{"n", ",", "z"}], "]"}], "z"]], "Output",
 ImageSize->{97, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->695108393]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Generating function:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"PolyLog", "[", 
     RowBox[{"1", ",", "k"}], "]"}], " ", 
    SuperscriptBox["x", "k"]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Fibonacci",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Pi]", " ", "x"}], "+", 
    RowBox[{"x", " ", 
     RowBox[{
      SuperscriptBox["LerchPhi", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "0", ",", "0"}], "]"}]}], "-", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     RowBox[{
      SuperscriptBox["LerchPhi", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "0", ",", "0"}], "]"}]}]}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}]]}]], "Output",
 ImageSize->{401, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Fibonacci",
 CellLabel->"Out[1]=",
 CellID->657417878]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["\<\
Large orders can give results too large to be computed explicitly:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"10.", "^", "10"}], " ", "I"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"unfl\"\>"}], ":", 
  " ", "\<\"Underflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/unfl\\\", ButtonNote -> \
\\\"General::unfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->530705412],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->90074713],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->643440066]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17709],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Zeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Zeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolyGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyGamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LerchPhi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LerchPhi"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20895]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22332],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->23022]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->9145],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#10219"], None}]], "RelatedLinks",
 CellID->409337661],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Polylogarithm.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ZetaFunctionsandPolylogarithms/PolyLog/"]\
, None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
PolyLog"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->290364919],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->679569631],

Cell[TextData[ButtonBox["Recurrence and Sum Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], "MoreAbout",
 CellID->27672642],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->470507079],

Cell[TextData[ButtonBox["Zeta Functions & Polylogarithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ZetaFunctionsAndPolylogarithms"]], "MoreAbout",
 CellID->7986039]
}, Open  ]],

Cell["New in 1  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolyLog - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 11, 48.9658286}", "context" -> "System`", 
    "keywords" -> {
     "Clausen function", "dilog", "dilogarithm function", "hyperlogarithm", 
      "Jonquiere's function", "Nielsen functions", "polylogarithm", 
      "Spence's integral", "trilogarithm"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PolyLog[n, z] gives the polylogarithm function Li_n (z). PolyLog[n, p, \
z] gives the Nielsen generalized polylogarithm function S n, p (z). ", 
    "synonyms" -> {"poly log"}, "title" -> "PolyLog", "type" -> "Symbol", 
    "uri" -> "ref/PolyLog"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7801, 272, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->335997339]},
 "Fibonacci"->{
  Cell[159203, 3738, 304, 10, 70, "Input",
   CellTags->"Fibonacci"],
  Cell[159510, 3750, 928, 32, 54, "Output",
   CellTags->"Fibonacci",
   CellID->657417878]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 167205, 4014},
 {"Fibonacci", 167341, 4018}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2416, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3039, 83, 44, 1, 70, "ObjectName",
 CellID->7933],
Cell[3086, 86, 1257, 42, 70, "Usage",
 CellID->20444]
}, Open  ]],
Cell[CellGroupData[{
Cell[4380, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4858, 150, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4981, 156, 405, 15, 70, "Notes",
 CellID->14486],
Cell[5389, 173, 859, 30, 70, "Notes",
 CellID->18025],
Cell[6251, 205, 289, 12, 70, "Notes",
 CellID->32364],
Cell[6543, 219, 551, 20, 70, "Notes",
 CellID->4000],
Cell[7097, 241, 246, 8, 70, "Notes",
 CellID->328880693],
Cell[7346, 251, 216, 7, 70, "Notes",
 CellID->31226],
Cell[7565, 260, 199, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[7801, 272, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->335997339],
Cell[CellGroupData[{
Cell[8186, 286, 148, 5, 70, "ExampleSection",
 CellID->487760768],
Cell[CellGroupData[{
Cell[8359, 295, 130, 4, 28, "Input"],
Cell[8492, 301, 526, 18, 51, "Output",
 CellID->175855336]
}, Open  ]],
Cell[9033, 322, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[9163, 328, 243, 8, 28, "Input"],
Cell[9409, 338, 2802, 50, 162, "Output",
 Evaluatable->False,
 CellID->44961329]
}, Open  ]],
Cell[12226, 391, 125, 3, 70, "ExampleDelimiter",
 CellID->235490961],
Cell[CellGroupData[{
Cell[12376, 398, 245, 8, 70, "Input",
 CellID->307849572],
Cell[12624, 408, 1149, 41, 54, "Output",
 CellID->579354668]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13822, 455, 200, 6, 70, "ExampleSection"],
Cell[14025, 463, 71, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14121, 467, 126, 4, 70, "Input",
 CellID->180640071],
Cell[14250, 473, 204, 7, 54, "Output",
 CellID->4634522]
}, Open  ]],
Cell[CellGroupData[{
Cell[14491, 485, 126, 4, 70, "Input",
 CellID->831017084],
Cell[14620, 491, 272, 9, 54, "Output",
 CellID->218518673]
}, Open  ]],
Cell[CellGroupData[{
Cell[14929, 505, 125, 4, 70, "Input"],
Cell[15057, 511, 298, 11, 57, "Output",
 CellID->92081379]
}, Open  ]],
Cell[15370, 525, 105, 2, 70, "ExampleDelimiter"],
Cell[15478, 529, 63, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[15566, 533, 126, 4, 70, "Input"],
Cell[15695, 539, 362, 11, 54, "Output",
 CellID->653949760]
}, Open  ]],
Cell[CellGroupData[{
Cell[16094, 555, 135, 4, 70, "Input"],
Cell[16232, 561, 329, 10, 36, "Output",
 CellID->31155520]
}, Open  ]],
Cell[16576, 574, 105, 2, 70, "ExampleDelimiter"],
Cell[16684, 578, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16759, 582, 189, 6, 70, "Input"],
Cell[16951, 590, 360, 10, 36, "Output",
 CellID->371115682]
}, Open  ]],
Cell[17326, 603, 125, 3, 70, "ExampleDelimiter",
 CellID->284729499],
Cell[17454, 608, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[17572, 614, 130, 3, 70, "Input"],
Cell[17705, 619, 338, 9, 36, "Output",
 CellID->14026673]
}, Open  ]],
Cell[18058, 631, 105, 2, 70, "ExampleDelimiter"],
Cell[18166, 635, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[18255, 639, 132, 4, 70, "Input"],
Cell[18390, 645, 274, 7, 36, "Output",
 CellID->567397358]
}, Open  ]],
Cell[18679, 655, 105, 2, 70, "ExampleDelimiter"],
Cell[18787, 659, 188, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[19000, 669, 171, 5, 70, "Input"],
Cell[19174, 676, 275, 9, 36, "Output",
 CellID->269495924]
}, Open  ]],
Cell[19464, 688, 125, 3, 70, "ExampleDelimiter",
 CellID->178530565],
Cell[19592, 693, 203, 7, 70, "ExampleText",
 CellID->159939814],
Cell[CellGroupData[{
Cell[19820, 704, 164, 5, 70, "Input",
 CellID->52335610],
Cell[19987, 711, 339, 12, 50, "Output",
 CellID->464082242]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20375, 729, 223, 6, 70, "ExampleSection"],
Cell[CellGroupData[{
Cell[20623, 739, 252, 7, 70, "ExampleSubsection",
 CellID->109632089],
Cell[20878, 748, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[20967, 752, 113, 3, 70, "Input"],
Cell[21083, 757, 182, 6, 36, "Output",
 CellID->858164]
}, Open  ]],
Cell[21280, 766, 105, 2, 70, "ExampleDelimiter"],
Cell[21388, 770, 187, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[21600, 780, 268, 9, 70, "Input",
 CellID->331647718],
Cell[21871, 791, 1331, 44, 54, "Output",
 CellID->260502306]
}, Open  ]],
Cell[23217, 838, 105, 2, 70, "ExampleDelimiter"],
Cell[23325, 842, 53, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[23403, 846, 239, 8, 70, "Input"],
Cell[23645, 856, 454, 15, 54, "Output",
 CellID->307304880]
}, Open  ]],
Cell[24114, 874, 105, 2, 70, "ExampleDelimiter"],
Cell[24222, 878, 55, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[24302, 882, 252, 8, 70, "Input"],
Cell[24557, 892, 2183, 66, 82, "Output",
 CellID->212128097]
}, Open  ]],
Cell[26755, 961, 124, 3, 70, "ExampleDelimiter",
 CellID->22040815],
Cell[26882, 966, 52, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[26959, 970, 231, 7, 70, "Input"],
Cell[27193, 979, 1637, 56, 54, "Output",
 CellID->771205674]
}, Open  ]],
Cell[28845, 1038, 75, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[28945, 1042, 273, 9, 70, "Input"],
Cell[29221, 1053, 2026, 61, 86, "Output",
 CellID->155899377]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31296, 1120, 243, 6, 70, "ExampleSubsection"],
Cell[31542, 1128, 37, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[31604, 1132, 116, 3, 70, "Input"],
Cell[31723, 1137, 362, 13, 54, "Output",
 CellID->431120683]
}, Open  ]],
Cell[CellGroupData[{
Cell[32122, 1155, 116, 3, 70, "Input"],
Cell[32241, 1160, 903, 31, 71, "Output",
 CellID->151878957]
}, Open  ]],
Cell[33159, 1194, 105, 2, 70, "ExampleDelimiter"],
Cell[33267, 1198, 40, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[33332, 1202, 235, 7, 70, "Input"],
Cell[33570, 1211, 1320, 46, 54, "Output",
 CellID->688826329]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[34951, 1264, 207, 6, 70, "ExampleSection"],
Cell[35161, 1272, 110, 3, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[35296, 1279, 428, 14, 70, "Input"],
Cell[35727, 1295, 80974, 1363, 70, "Output",
 CellID->540095261]
}, Open  ]],
Cell[116716, 2661, 105, 2, 70, "ExampleDelimiter"],
Cell[116824, 2665, 88, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[116937, 2671, 549, 17, 70, "Input"],
Cell[117489, 2690, 419, 14, 39, "Output",
 CellID->158201862]
}, Open  ]],
Cell[117923, 2707, 105, 2, 70, "ExampleDelimiter"],
Cell[118031, 2711, 467, 17, 70, "ExampleText"],
Cell[118501, 2730, 389, 12, 70, "Input"],
Cell[118893, 2744, 152, 5, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[119070, 2753, 344, 11, 70, "Input"],
Cell[119417, 2766, 24381, 404, 70, "Output",
 Evaluatable->False,
 CellID->622994453]
}, Open  ]],
Cell[143813, 3173, 105, 2, 70, "ExampleDelimiter"],
Cell[143921, 3177, 368, 12, 70, "ExampleText"],
Cell[144292, 3191, 943, 30, 70, "Input"],
Cell[145238, 3223, 47, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[145310, 3227, 193, 6, 70, "Input"],
Cell[145506, 3235, 2270, 41, 70, "Output",
 Evaluatable->False,
 CellID->848615247]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[147825, 3282, 217, 6, 70, "ExampleSection"],
Cell[148045, 3290, 202, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[148272, 3301, 422, 12, 70, "Input"],
Cell[148697, 3315, 206, 7, 54, "Output",
 CellID->380528404]
}, Open  ]],
Cell[148918, 3325, 105, 2, 70, "ExampleDelimiter"],
Cell[149026, 3329, 204, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[149255, 3340, 149, 5, 70, "Input",
 CellID->88873018],
Cell[149407, 3347, 251, 8, 36, "Output",
 CellID->487014506]
}, Open  ]],
Cell[CellGroupData[{
Cell[149695, 3360, 110, 3, 70, "Input",
 CellID->137972258],
Cell[149808, 3365, 605, 20, 54, "Output",
 CellID->177683901]
}, Open  ]],
Cell[CellGroupData[{
Cell[150450, 3390, 239, 7, 70, "Input"],
Cell[150692, 3399, 1235, 45, 84, "Output",
 CellID->364214326]
}, Open  ]],
Cell[151942, 3447, 105, 2, 70, "ExampleDelimiter"],
Cell[152050, 3451, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[152151, 3455, 437, 15, 70, "Input"],
Cell[152591, 3472, 329, 10, 36, "Output",
 CellID->506777767]
}, Open  ]],
Cell[152935, 3485, 105, 2, 70, "ExampleDelimiter"],
Cell[153043, 3489, 35, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[153103, 3493, 275, 10, 70, "Input"],
Cell[153381, 3505, 460, 17, 51, "Output",
 CellID->528246874]
}, Open  ]],
Cell[CellGroupData[{
Cell[153878, 3527, 278, 9, 70, "Input"],
Cell[154159, 3538, 1053, 35, 79, "Output",
 CellID->253554760]
}, Open  ]],
Cell[155227, 3576, 105, 2, 70, "ExampleDelimiter"],
Cell[155335, 3580, 53, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[155413, 3584, 246, 8, 70, "Input"],
Cell[155662, 3594, 218, 7, 36, "Output",
 CellID->672115216]
}, Open  ]],
Cell[CellGroupData[{
Cell[155917, 3606, 281, 9, 70, "Input"],
Cell[156201, 3617, 301, 11, 51, "Output",
 CellID->651002033]
}, Open  ]],
Cell[CellGroupData[{
Cell[156539, 3633, 363, 12, 70, "Input"],
Cell[156905, 3647, 876, 28, 84, "Output",
 CellID->28753313]
}, Open  ]],
Cell[157796, 3678, 105, 2, 70, "ExampleDelimiter"],
Cell[157904, 3682, 217, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[158146, 3692, 234, 7, 70, "Input"],
Cell[158383, 3701, 236, 8, 51, "Output",
 CellID->129472937]
}, Open  ]],
Cell[CellGroupData[{
Cell[158656, 3714, 117, 3, 70, "Input"],
Cell[158776, 3719, 236, 8, 51, "Output",
 CellID->695108393]
}, Open  ]],
Cell[159027, 3730, 105, 2, 70, "ExampleDelimiter"],
Cell[159135, 3734, 43, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[159203, 3738, 304, 10, 70, "Input",
 CellTags->"Fibonacci"],
Cell[159510, 3750, 928, 32, 54, "Output",
 CellTags->"Fibonacci",
 CellID->657417878]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[160487, 3788, 210, 6, 70, "ExampleSection"],
Cell[160700, 3796, 97, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[160822, 3802, 159, 5, 70, "Input"],
Cell[160984, 3809, 358, 7, 70, "Message",
 CellID->530705412],
Cell[161345, 3818, 356, 7, 70, "Message",
 CellID->90074713],
Cell[161704, 3827, 187, 6, 36, "Output",
 CellID->643440066]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[161952, 3840, 311, 9, 70, "SeeAlsoSection",
 CellID->17709],
Cell[162266, 3851, 690, 26, 70, "SeeAlso",
 CellID->20895]
}, Open  ]],
Cell[CellGroupData[{
Cell[162993, 3882, 314, 9, 70, "TutorialsSection",
 CellID->22332],
Cell[163310, 3893, 144, 3, 70, "Tutorials",
 CellID->23022]
}, Open  ]],
Cell[CellGroupData[{
Cell[163491, 3901, 320, 9, 70, "RelatedLinksSection",
 CellID->9145],
Cell[163814, 3912, 271, 6, 70, "RelatedLinks",
 CellID->409337661],
Cell[164088, 3920, 184, 4, 70, "RelatedLinks"],
Cell[164275, 3926, 208, 4, 70, "RelatedLinks"],
Cell[164486, 3932, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[164908, 3950, 319, 9, 70, "MoreAboutSection",
 CellID->290364919],
Cell[165230, 3961, 155, 3, 70, "MoreAbout",
 CellID->679569631],
Cell[165388, 3966, 164, 3, 70, "MoreAbout",
 CellID->27672642],
Cell[165555, 3971, 145, 3, 70, "MoreAbout",
 CellID->470507079],
Cell[165703, 3976, 171, 3, 70, "MoreAbout",
 CellID->7986039]
}, Open  ]],
Cell[165889, 3982, 50, 0, 70, "History"],
Cell[165942, 3984, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

