(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   5046843,      96177]
NotebookOptionsPosition[   4991465,      94361]
NotebookOutlinePosition[   4997965,      94479]
CellTagsIndexPosition[   4997876,      94474]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics3D" :> 
          Documentation`HelpLookup["paclet:ref/Graphics3D"], "RegionPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot3D"], "Polygon" :> 
          Documentation`HelpLookup["paclet:ref/Polygon"], "GraphData" :> 
          Documentation`HelpLookup["paclet:ref/GraphData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics3D\"\>", 
       2->"\<\"RegionPlot3D\"\>", 3->"\<\"Polygon\"\>", 
       4->"\<\"GraphData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Integrated Data Sources" :> 
          Documentation`HelpLookup["paclet:guide/DataCollections"], 
          "Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"], 
          "Mathematical Data" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalData"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Computational Geometry\"\>", 
       2->"\<\"Integrated Data Sources\"\>", 3->"\<\"Inequalities\"\>", 
       4->"\<\"Mathematical Data\"\>", 
       5->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       6->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PolyhedronData", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolyhedronData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolyhedronData"], "[", 
       RowBox[{
        StyleBox["poly", "TI"], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the value of the specified property for the \
polyhedron named ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolyhedronData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolyhedronData"], "[", 
       StyleBox["poly", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an image of the polyhedron named ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolyhedronData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolyhedronData"], "[", "\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the polyhedra in the specified class."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Polyhedra can be specified by standard names such as ",
 Cell[BoxData["\"\<Dodecahedron\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<TruncatedCube\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->292801888],

Cell[TextData[{
 "Classes of polyhedra supported include ",
 Cell[BoxData["\"\<Platonic\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Archimedean\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<ArchimedeanDual\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<KeplerPoinsot\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Johnson\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Uniform\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->477183112],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyhedronData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyhedronData"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyhedronData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyhedronData"], "[", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives a list all available polyhedra."
}], "Notes",
 CellID->28919592],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyhedronData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyhedronData"], "[", 
   StyleBox["patt", "TI"], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives a list of all polyhedron names that match the string pattern ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->628766205],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyhedronData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyhedronData"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " gives a list of polyhedra with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " faces, with faces not necessarily being convex."
}], "Notes",
 CellID->75298684],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyhedronData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyhedronData"], "[", "\"\<Classes\>\"", "]"}]], 
  "InlineFormula"],
 " gives a list of all supported classes."
}], "Notes",
 CellID->136604891],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyhedronData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyhedronData"], "[", "\"\<Properties\>\"", 
   "]"}]], "InlineFormula"],
 " gives a list of properties available for polyhedra."
}], "Notes",
 CellID->761833040],

Cell["\<\
For coordinate purposes, all polyhedra are taken to have smallest edges of \
unit length.\
\>", "Notes",
 CellID->684616674],

Cell["Basic graphics-related properties include:", "Notes",
 CellID->270166015],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Edges\>\"", Cell[
    "graphics primitives for edges in the polyhedron", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Faces\>\"", Cell[
    "graphics primitives for faces of the polyhedron", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Image\>\"", Cell[
    "complete image of the polyhedron", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->25428423],

Cell["Combinatorial properties include:", "Notes",
 CellID->112965608],

Cell[BoxData[GridBox[{
   {Cell[" ", "TableRowIcon"], "\"\<AdjacentFaceIndices\>\"", Cell[
    "lists of indices for adjacent pairs of faces", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EdgeCount\>\"", Cell[
    "total number of edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EdgeIndices\>\"", Cell[
    "indices specifying the vertices on each edge ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FaceCount\>\"", Cell[
    "total number of faces", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FaceCountRules\>\"", Cell[TextData[{
     "rules for the numbers of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "-sided faces"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FaceIndices\>\"", Cell[
    "lists of indices for the vertices of each face", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexCount\>\"", Cell[
    "total number of vertices", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->383955074],

Cell["Coordinate-related properties include:", "Notes",
 CellID->485086907],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Centroid\>\"", Cell[
    "coordinates of the centroid in the standard embedding", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InertiaTensor\>\"", Cell[
    "inertia tensor of the solid polyhedron", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RegionFunction\>\"", Cell[TextData[{
     "pure function giving ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " in the interior of the polyhedron"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexCoordinates\>\"", Cell[
    "coordinates of vertices assuming unit smallest edge length", 
     "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->798493051],

Cell["Geometrical properties include:", "Notes",
 CellID->115436353],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Circumradius\>\"", Cell[
    "circumradius assuming unit smallest edge length", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DihedralAngleRules\>\"", Cell[
    "rules for dihedral angles", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EdgeLengths\>\"", Cell[
    "relative lengths of edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GeneralizedDiameter\>\"", Cell[
    "maximum distance between a pair of vertices", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Inradius\>\"", Cell[
    "inradius assuming unit smallest edge length", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Midradius\>\"", Cell[
    "midradius assuming unit smallest edge length", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SurfaceArea\>\"", Cell[
    "total surface area assuming unit smallest edge length", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Volume\>\"", Cell[
    "enclosed volume assuming unit smallest edge length", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->416448982],

Cell["Properties of polyhedron nets include:", "Notes",
 CellID->66655508],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<NetCoordinates\>\"", Cell[
    "coordinates of vertices in the net", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NetCount\>\"", Cell[
    "number of topologically distinct nets that can be drawn", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NetEdgeIndices\>\"", Cell[
    "indices specifying the vertices on each edge in the net", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NetEdges\>\"", Cell[
    "graphics primitives for edges in the net", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NetFaceIndices\>\"", Cell[
    "indices specifying the incidence of faces in the net", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NetFaces\>\"", Cell[
    "graphics primitives for faces in the net", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NetImage\>\"", Cell[
    "image of the polyhedron net", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->865729],

Cell["Properties of polyhedron skeleton graphs include:", "Notes",
 CellID->141029063],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<SkeletonCoordinates\>\"", Cell[
    "vertex positions in an embedding of the skeleton graph ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SkeletonImage\>\"", Cell[
    "image of the skeleton graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SkeletonRules\>\"", Cell[
    "rules specifying the connectivity of the skeleton graph", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->234091111],

Cell["Overall properties include:", "Notes",
 CellID->22458508],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Dual\>\"", Cell[
    "dual of the polyhedron", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<Classes\>\"", Cell[
    "classes of which the polyhedron is a member", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NotationRules\>\"", Cell[
    "formal notations for the polyhedron", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SymmetryGroupString\>\"", Cell[
    "name of the symmetry group for the polyhedron", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->118619863],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyhedronData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyhedronData"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", "\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if the polyhedron is in the specified class."
}], "Notes",
 CellID->482514198],

Cell["Classes of polyhedra include:", "Notes",
 CellID->178890765],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Chiral\>\"", Cell[
    "chiral solid", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Convex\>\"", Cell[
    "convex solid", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Deltahedron\>\"", Cell[
    "solid consisting of equilateral triangles", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Equilateral\>\"", Cell[
    "all sides have unit length", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Zonohedron\>\"", Cell[
    "zonohedron", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->139981555],

Cell["Classes of polyhedra indexed by an integer include:", "Notes",
 CellID->1175401420],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Antiprism\>\"", Cell[
    "antiprism", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Dipyramid\>\"", Cell[
    "dipyramid", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Prism\>\"", Cell[
    "prism", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Pyramid\>\"", Cell[
    "pyramid", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->269597187],

Cell["Naming-related properties include:", "Notes",
 CellID->699856716],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AlternateNames\>\"", Cell[
    "alternate English names, as strings", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AlternateStandardNames\>\"", Cell[
    TextData[{
     "alternate standard ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " names"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Name\>\"", Cell[
    "English name as a string ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StandardName\>\"", Cell[TextData[{
     "standard ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " name"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->38918036],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyhedronData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyhedronData"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"ann\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyhedronData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyhedronData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"ann\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives various annotations associated with a property. Typical annotations \
include:"
}], "Notes",
 CellID->276644756],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Description\>\"", Cell[
    "short textual description of the property", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LongDescription\>\"", Cell[
    "longer textual description of the property ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Note\>\"", Cell[
    "additional information about the property", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->524183967],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["PolyhedronData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyhedronData"]], "InlineFormula"],
 " may require internet connectivity. "
}], "Notes",
 CellID->94188222]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->119692175],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(6)", "ExampleCount"]
}], "ExampleSection",
 CellID->294287130],

Cell["Show an image of a dodecahedron:", "ExampleText",
 CellID->355356762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<Dodecahedron\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->205409853],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlnFlzG8cRgFdY3ARvEuAFEoogU6JEW6Qoiock2rQtOZblo1ROKZdtWoZL
dsoVl6If4/yOpCpvfsgvyLPf8yeSQiU7Pb2LxbcD7pIG6YtFAhhMb3/dPbPT
s7szfHT04lnnq6MXXzw9aj14fvT1sy+e/qV1/8/Pg6/8C57n/T34+9ecF3z+
X/BJ/l50u91cp9O5F7x73nMteX7wIXg3X96Vmq+1xtd3++1XwasflAqm5NsD
zOF3pPZPKlt21j7TY6umlLe1VmBf6j/Xo0dNqRDVq449kflMZcaPkTlSzmTM
CvMxh/Jtkf5YNc5kkv6D6q6j1kd5W6R/p7rnUZtH+ZZIP1HpxUzSH6olTdQW
UN4S6cequ4XaIso3Rfp91f2rTNLvqu6XUqQ3Rfodlb6C2hLKGyL9a7VkLZP0
A9W9jtoyyjdE+g3V/Uom6UPVvYnaCsqizXtVpbdQW0X5ZZG+q5ZsZ5LeV927
qB1BWaLg7ajufdTWUL4u0tvd2OiQKr2l0q+idhTlayK9oZYconYMZWlriaPR
/WYm6euq+wFqx1G+KtJrqvvtTNJXVPod1E6gLD3au6yWvItajkarIn1JdX+Q
Sbqluh+jdgplORO9ZdX9G9ROo3xZpJdU+kkm6Xm15Pcp0m2Rbqjuj1DLMfeS
SM+o7k8ySU+p7qeonUVZxjJpMyPdySQ9rtKfo5aj/8VIOp71yGig3Ood1ZcN
Hxr/g1RNyjHHJzLhW8byQIf/t/XPzDtjN4fySsID85E58FAtK6lW9jvmuWWn
VubKA7W1Fmg12inv1spxgHlvX22dVFs5Ji2g3HRqZQ7bUVvrqpVjLnP3klMr
s9eW2rqgWplTsmll3tpQW1c0rvRlyUVJaKUt62prW23l7OR0Wq+prVdVK3te
09V6Ca3Ml6tq67pqTfQi9rJEL2Hea6udm4FG+d6zP9m0sdxS+7ZCbcG7+WgI
9HjOqZERaKp9t6lRI8DWaTi1us5AY+cutOa1Z/EMdWtlvqyrrXehtai2coyq
O7UyU06r1gNoLatWjqKzTq0c2aYGaK2qVuYPq5W9h6OwRCQfHP5o/a/Bb/Dh
HvSPDNA/49RPKekdhUi/RTgZnmnG7rffeI5c4WYxO9n6ni8582LKSrnjiJz4
HlAtmNZPO7lsvyq4eXD3XdxCxFWfyZ5ystkjK6dh+z2fc+ZFyoN7XdIKnm0l
WFGEFXuwogIr8ilWTDqtYP4swIrS97SCM0k5VxL5luOZDysqsIIjWBlWFFNi
4baiKQGIz8FMn6qdkF1KYY872ZJ5evNHM9MBdwfcErjllMiPObkrYdkG+8TU
Soq3x1F77XtSajWFOjo4xjHqOKjMtkVQR05FbYI6cUJqLYUqZ3RizkTqFKjb
oBZAHQPV9FojPnYutJrSeI0x4qQvgT4D+i3HfCdOnwC9rHTOtN30RdBnT0if
BD2vdM6t3fQF0Bugc05K+hToRpQ5wk2eB3kuheyDPB2SO/KTmK2ejspo50Cd
gb+ceVsqY0/qgsvXQkQ1JZn59rM4O3Wz5sBaPENWA6wmWDely/SiGVzbpnCq
Tk4dnOVUzqJjRDg5ZwWczfPkaC/05Cqwn8IccZ4U3l9gH2gFL9WguBZq10uK
4WmX8nf/7Aa/Xil4WTPGnzlpw7wMnbICymYKhf2r8v0o5t3R8qejLINy80dM
4b03jppOSt5SLGhpKJwmOFs/GCetP/+4OEvg3DIvhYijfSEtduWfNYvzT85C
FsG67WSlZTg3K82vnwuLMdw5b5bfO7dyUu7NVTmn+2GonOGVMlEXQN0dCrWQ
ckakUX1QGz9h6jyoe79gah7U+lCoc452lfsC50LbVpqfEmHSnc8+E8/3eN+A
dDPDNGm/lEKfHQq9AfoN9b2WMmqcDX1d6RPOXMAePRzmmjJnnMzhtHEdzFVt
48Y5Mtvq59J3nFeeDe+i8lqxnpTdO95/HHivT2nLGtE2aNn6KWlpvi2qb1dD
mj0xEve4eGetkIlG3+aVth7SeB9vqLS60jZA4/3K4dCmtN22zoQ2A9qE+rYT
jmYWeEqa6ZOyNgiUUaXsx8ZM00dORzH32M3j1glQqko5AIV3td0Urg+xT8FM
5L78r/01KmpglrS1DmUMibJBxzyd+PYbI8jVBG5a7ymUoDxfeRXw8urjfRkn
I556WlWm5//j3/+xDiee0eSd/Bb4BeXLk998xFf62wlvS0rOGXAs1nzy56ab
tXEVJUZP+Tvy45nVco+c3vrKzIPJ1QZu5iV4XDb8oPoD5HX7RL0Trcspgsbn
/G5aG7S80nxp7F77vmf6U9iCQb2B0T+uV3ATL7NHmVYCzcTVnK8FQyhYnP01
JvB5vOXE1/WbVaGm948Eeo2eh6qvLBar+Z6XWG2W1GRaQ+IBq0dg8YOwddTM
chgb1ZNOCle8mivWUbX7TbW7Gou0afEmtPkJbU3VVkux+zXYXZGIR22qPOfa
gz7evEZ8wsGT1UQOT6I4JGb8x5Hq6tksSDV4tu/yLEZ2X50fR55W8nwKeUd9
HQHRfdc3Sex9M65RbTqIsvYNPpro8srKuX+jjxI+SebIQ782B/iVtl4qSawo
cXWAXzeUVAOJc0KOcUlSUUnXQBqFb9cRSeMjcwRpuQQtp+31ioNm/Fkb4BdJ
zh06ESnMPlugjMGnlxw+HZchaIWl9vZfJP1px/wx7zx7meNDP7rRObWX0i6t
FB+YC5w7oRI5yPhj7GXEmgPah+OfmxLuH9sf0KuXHGdrnLICrVxFaim8R8II
8qxtxM5a834JxztXwidGR/oUjut1xyhrvucOKVIuCKWkEbuj7cHWnxww4qxC
G8cFq53Pigf5MD6Awp1YHFktpdqN7Ro8JtOOpOQj7uTiqGpp/HZfI8dWL8fy
rYyombTTw2gnlXUrilgpxZcN6OHzL0sb68bOl751ffQmN2D2kLbnzHJ4Ht1G
mXO7inppb+SJkwkPqYN9zZI5TnDXW15bL+orGs8SaHsO2oWgaCiWFO4NIqEI
38ogFbR/cBdcOUFgTrrpOIJXaiTFfUonzqpPJFU0aiT4ILyG40oJAmdgPEtG
4FNOHIuIehVx3xHzfg7nltyHKeddscexfc7uCeU1er/meY0RNcpaxEDDQ0eP
69fAK5PrKHMnm5/QEO6n45Efo5xLHMm9JFdTNMTZXiJfcp8td9Xl+o5udd27
c48k0FG5a+db9hjuEr6M8qfdLna42eOYc9sox3f09WhttZDS4c5wK8VMe/FY
6VUtUarTFxu2A9vJRNaEyM4VmCebKJud5PKcRKSvqQWUeqJSdhUesyHneY/V
ArtS/GXVSan3VKfd18Gzm2f/Q5W2+4+Yw3hVc18tsDvUNtUCSh2qTrtvkvmK
M+57Ki39yu5+P2Y2vasW2L274X5mSt1SnXZH9Q5qOS/bUGm7g323G/sfBBgj
CmG28dL2W19RnfZ/H9xBLecGbZU+EOm7aoFrdbyx4HWROkAtr7QXVedbIh3u
WHetUzFSsvvZ495t3qmYVgveF+nXUct7w+GV/Ici/Ua39x8nGAsj9VuRkrzS
N5qUlflHqY/vADejRl6PllFI9sUWO7qj1/Mu/B9h3cSp\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 208},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68198844]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1468749044],

Cell["Show the net of a dodecahedron:", "ExampleText",
 CellID->2088143890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<NetImage\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->447323701],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32061201]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266638758],

Cell["\<\
Show the snub cube with colored faces and transparency with no external \
lighting:\
\>", "ExampleText",
 CellID->989047158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", ".5", "]"}], ",", 
     RowBox[{"Glow", "[", "Yellow", "]"}], ",", 
     RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"\"\<SnubCube\>\"", ",", "\"\<Faces\>\""}], "]"}]}], "}"}], ",",
    
   RowBox[{"Lighting", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->957589357],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28723776]
}, Open  ]],

Cell["\<\
Show the snub cube with colored faces and transparency in the presence of \
external lighting:\
\>", "ExampleText",
 CellID->955972162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", ".5", "]"}], ",", 
     RowBox[{"FaceForm", "[", "Yellow", "]"}], ",", 
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"\"\<SnubCube\>\"", ",", "\"\<Faces\>\""}], "]"}]}], "}"}], ",",
    
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1252875866],

Cell[BoxData[
 Graphics3DBox[
  {Opacity[0.5], FaceForm[RGBColor[1, 1, 0]], 
   GraphicsComplex3DBox[
    NCache[{{Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0]}, {
      Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0]}, {
      Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0]}, {
      Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
      Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0]}, {
      Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0]}, {
      Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
      Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0]}, {
      Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0]}, {
      Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0]}, {
      Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
      Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0]}, {
      Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0]}, {
      Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0]}, {
      Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0]}, {
      Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
      Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
      Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0]}, {
      Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0]}, {
      Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
      Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0]}, {
      Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
      Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
      Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
       Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
       Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 
        0]}}, {{-1.1426135089259621`, -0.3377539738137522, \
-0.6212264105565853}, {-1.1426135089259621`, 0.33775397381375233`, 
     0.6212264105565852}, {-1.1426135089259621`, -0.6212264105565853, 
     0.33775397381375233`}, {-1.1426135089259621`, 
     0.6212264105565852, -0.3377539738137522}, {
     1.1426135089259621`, -0.3377539738137522, 0.6212264105565852}, {
     1.1426135089259621`, 0.33775397381375233`, -0.6212264105565853}, {
     1.1426135089259621`, -0.6212264105565853, -0.3377539738137522}, {
     1.1426135089259621`, 0.6212264105565852, 
     0.33775397381375233`}, {-0.3377539738137522, -1.1426135089259621`, 
     0.6212264105565852}, {-0.3377539738137522, 
     1.1426135089259621`, -0.6212264105565853}, {-0.3377539738137522, \
-0.6212264105565853, -1.1426135089259621`}, {-0.3377539738137522, 
     0.6212264105565852, 1.1426135089259621`}, {
     0.33775397381375233`, -1.1426135089259621`, -0.6212264105565853}, {
     0.33775397381375233`, 1.1426135089259621`, 0.6212264105565852}, {
     0.33775397381375233`, -0.6212264105565853, 1.1426135089259621`}, {
     0.33775397381375233`, 
     0.6212264105565852, -1.1426135089259621`}, {-0.6212264105565853, \
-1.1426135089259621`, -0.3377539738137522}, {-0.6212264105565853, 
     1.1426135089259621`, 
     0.33775397381375233`}, {-0.6212264105565853, -0.3377539738137522, 
     1.1426135089259621`}, {-0.6212264105565853, 
     0.33775397381375233`, -1.1426135089259621`}, {
     0.6212264105565852, -1.1426135089259621`, 0.33775397381375233`}, {
     0.6212264105565852, 1.1426135089259621`, -0.3377539738137522}, {
     0.6212264105565852, -0.3377539738137522, -1.1426135089259621`}, {
     0.6212264105565852, 0.33775397381375233`, 1.1426135089259621`}}], 
    Polygon3DBox[{{3, 1, 17}, {3, 17, 9}, {3, 19, 2}, {3, 9, 19}, {1, 4, 
      20}, {1, 20, 11}, {1, 11, 17}, {2, 19, 12}, {2, 18, 4}, {2, 12, 18}, {4,
       18, 10}, {4, 10, 20}, {17, 11, 13}, {19, 9, 15}, {18, 12, 14}, {20, 10,
       16}, {9, 21, 15}, {11, 23, 13}, {12, 24, 14}, {10, 22, 16}, {13, 23, 
      7}, {13, 7, 21}, {15, 21, 5}, {15, 5, 24}, {16, 22, 6}, {16, 6, 23}, {
      14, 24, 8}, {14, 8, 22}, {21, 7, 5}, {23, 6, 7}, {24, 5, 8}, {22, 8, 
      6}, {1, 3, 2, 4}, {21, 9, 17, 13}, {24, 12, 19, 15}, {10, 18, 14, 22}, {
      11, 20, 16, 23}, {8, 5, 7, 6}}]]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->558475541,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNXc2vJUd1b3dX9/1+977PeXfejGc8zPgDY4OxsbGZ+MVxjD8IIQGESJAF
DhnFlpJMYhwRFv4jgAVi4SULEGgkazCCBQtHeIWEBAJkEAJWgAQSQrJYoKfk
fFV13V9Xv+47Hka56qnXdbu6zu9X59SpU9V9a97/zAvPXvq3Z1547pPPnH38
+Wf+49nnPvmps++9/Dx9VdyUZdlV+vc/+xmd/y+dyb//Pjo6yopLly4dySd7
kJPsvyh19OV7JPcpSnPKFfb3Ifn2Py1XRjVQajX8O6X85SB59V/t3jHnXJBO
J++W68/Z3dOW6/9i9885V4brJuMBKXPJymwCwxzy90npfzKJ271Kf8Lq3oOr
BeTvldJPW93Ljrq19Mes7lMddb9TSv+Dlb4ZrjrI3yOlP2JIzvYq/WGr+y1w
tYT8O6T0B630BbhaQf7tUvoDhuS2XqXfb3W/Fa4OIH+3lH7K6n5br9JPWN1v
h6tDyN8lpd9rpe+BqyPIi+zsUUNyb6/Sj1jd98PVMeTvlNKHVvrdvUpfNCQP
wdUJ5KWFs4es7r+Aq1PI3yGlH7C6D3uVfpfV/VdwdQb526X0vVb6sY7SYkdi
ifzl471K3211PwVXNyB/q5S+0+r+m16l77C6PwBX55CX3iJ4uPTfw9UF5M9L
6fOG5EO9Sp+zuj8CV9EvSi/Pzlrpj/YqfdqQ/CNc3YL8OSl9YHU/DVfR594i
pfetbraXCQ1VZ3rdtXdU96Gc7sqKK1cO6c+3v32YOfrrXn75cCDfX7yY2aei
f6iXHciLx5Rv49ql8kKrZwkFJSxlYVLQh+xCXjhJ2/KXD1itDmqtrNYh10qw
3be+dbiCv5cUtA7PYQDSRibNkYCJl/SVrxyyPEEH9eAYKCORtGfcUiOQ4igZ
PPFElr/2mkgTSZVK0kP54ajXLi2OMu4zqWOR+uCDXBMJyxwlM5LIQEYssUSJ
fBeOyyjzdC1zJTa5x6RWJHXAQlkMSaMj2zaeZdSidGQ5J4zipZcOVZuMHyOF
U7XERrTDXqyQprp8OSOpLNhRMvjGNw5jBCcMQVYQBAWQOUko8/TTDCARo0SS
j4lc3mrMc5I7B7knPXMvi0HLZx9qORBZ6E/R3m4zvlsg5xQnBSn4lVekJaV/
iky6l8hpA5/oJRMjnAtH3psQQZLLbYzyDyL5DCGnRPTC8lXBdHAtaE8nkxiw
V5/zGEoFQGlPJCUnRWj2TJkEg2v4i2USD0ZPZ0ObBDxy6tuIT9EWksjYojVP
h/TSLGv43zQm9K+nDRPiyCG/6MDlfItFupTrX/7yIR1yK44/+0mEGOkdtCDE
/LoIC/mSW08+P/mJWBqOw4oRoyGMAfcNowNMZQfGkz0wqgV/5jOMkM5+8AMx
QsR5IokT48k9w4m4rgmni61QNPSrXx0KUoXZgnQviRTz24a0AmSDNftLESG1
sT+JEqO1NEq0Vb2Lbm9px+Ga7VpEfodhDgVrANqCdTeJFUegDWtRxNQLowsY
vUVyzYQuoOQ7nn+ejyxnnJxvQbKTxIvR1sTwjgDfuMMCYrzmvQUf4GWX+Ytf
HNJBkBEx6lkRY29Cyx61IJ50tPCSEvEeKZxlwKlQO7FuJ7Gi760MK2Lrwrov
Fkv5P/7xkPtQeU2YU729iRlHNNeCedaBedfaNyfMWUGoDWuRwl4E7FnOiSP8
n/+8uV205K0kbumPdZxrqKeAcqMD9ba3ijVRO04KQm3eAjFvJjHHERbfhejm
Hb1u09AOAG2y70VoS0Cb9LCt41i6DdvbdMNQjtZEWXWgXBxjB2F0+Oxnl2gD
mx14p4Z30oF31IaXLJc/SV/biGLEBsqAVyE3ettWB+aRYZ6tiXnoMaubaLTm
vB1zNAJr3Eq4W+KF7Q70w8i/MYENTsrAgg4enSeAfdSBfSOJfddjv/9+0ZID
7BhN7HRgr6zlN3thHgNmRNeBWReJDGONGaPyvQ7MhWHe7oV5KpjrcQRXbme9
MFeAGec6ScwuYDbEu4TY8RDIkugvn44kX0dCU04ivIhs2guv2LALeAnYyZQ3
NoQa8ywIHaPJf/Yz7XX0l0/HkqcCP/rRIR3ZhJNjrEARYjtLr3NktoRQjXfg
29TmtSmEsr5EuIaEi8eJ/BrwcYzFQ+ssiWvXezDCFaA1ItxlciSmgm+8EdZB
skIDHIlxKBE/UNHJr399SAedEFASPO3Ay3EWA8RVucka+GMfxh75IBGzSXzz
6U+rtb34Ih/CY2cVt0Lvgbsw3Limsg5u6WdlwGno0TLY63EhnecSBdKCHuIT
//SnFX+88KOKkslyTgrlxJQmwGvMCcdw3/3uoVJj2LjGcAyrKrAKxMpWXryG
6SJrYhKOE84TEyFDSW49NGZSSFL3BGQy8ky+9KUlHVkz3liPBa5VFOAVeaSs
bFVUIjvgUYJmZm18XnopS/EZUJJfubL02lEFpTmhvvZaOCkHsqGVEbTmxD3d
BR3VK5Ml6Ay5VqazKXAsQWfovRwlBXHMIytch2c8EvBgkMvqvHJNjVw4sg2t
b4kHdPESaO79MTAdGtNxG1P1fE2mxLK8nixLYnn16qESZR2NE5EGU8KY2jOb
ArMx2GsFDKs2hsSMzXToPaSxyzk5JhYZ9+fqAlfjwzqTqGMQexm1T3byyG1i
WmvlpH4/GxCn4pVXllnB5ER5N4zX0PQlilM16lzC7FLjllyYhVGgYZ8zY+pS
TJ0yVbKFcXUJv/Nn4lsEvuZhiIc9X+LnPNg7w5zaPiVwHwH3OScuWDBxHDVZ
E+PBn4XxDjB2wLgIfXHV38Z+tQKGQ2C4MO3Gmh2I+yEcr7661EMi7evCMf20
eZVjzu42mmFuAEcffcW8BsATx5NN8UUco+mHrTcnZsIzjtQaPCvg6YAnaq0f
z8L31jCSbiZGEmWpLqjumzXLKsXSEcvf/vaQDu7dxKognnnkl1aiOBtH0YLL
G8R6C1hrBBvsd8X71rzL43m/9tpSnrkA5wI4V2tyRose9eIsfqpSznHkhMwL
07dL+uN27gvPnVjrUbDq2dZXdH2j2wG9V+G914r/rns52n+e8M9oBxjpb7A3
++EPl8Le+kBJSW49IW4FB61Q/r9ohWAV2gUa/nsG+SIRlxTSAnSijZCNrAVi
9to3dKLAxHHMdsC+6uj/yh6fv7eO2SutodGKtwFF+r3vLVfsvWa8Afk8EU9z
Czjv8c0OxtIrsAXa9V/ckBZw0ALzhv+jlmi0wUIaBmfuA2M+aGMejX0xc9T9
dWRer1CY3xsA35lpXBnWWseodFO6e53XdQpmOwK2E8/W8uJTbwhj7Ouo69Jz
f/llmV/5OEZisjJwtzFve1XHauAZM552MZY83dAy1hdrskdPN7x29k7ZawOM
IFYdRTbALbDrdc5dIMuI+QYwnyWYy3sRwDgHxjkwHnbo+xjGKxZ++bK9RbjC
szI9zzw/i+a2KOGs2Lnpt4uhC748rImqNZeBHR28qjjuxSn5Xmaj1zY5OeM0
9/3061/PvHd2xAlH5lkHryqyWY7Crzsnl0VrpfLOZRn4WH/MwR7nkQ9iNU1M
X2EORXSYFvbHDeA28Dorg0XqYkCj5/Wzw578isAvyymRd61WvShxGRinSaQv
niV1cRpJaEXlj+UzAj4YHaX5NPsV22CDE8wAF6m4wMVelXluAM8J8JwDz3Ho
b/X6DXqPN8FyRWtTnvuyqN//foXJHJgVxkXHxNDHiMS4Bxu5/stfRs9dtHMx
icl1YjKhP1yNAyYYuxUw6gujMjAyHeEIz7bI722LD6lqNqIdYjLt6EWDdhY2
frG9TbyPePVVrv13v9NVJmCUnpEAo8gP5p7Lypp+zW1KCYPKE5orRFtKVp51
9uKJ7wnvAs+x9+3EU6nmxFVmTG+SawFcNSL/6lc91yElvJRWAdehDHRUD/3V
FZucSMsKc4d9phk37XNoPc0xYafa1UN7BBG3MXpdzg4456DfyvQ7Bs6Vj1wk
QyfEmA668cc/Zp109cxjmEe6HnofaroW/kXgnxWSUF4bIJsAe4zS12VfGHsc
TQpjX/oowJ6nFkye8y3j47W1wgBaoYRWcGYH67KXvlwG9ua9cuO8JSNm4KzL
cxIbxIwdMZY5wTUz5dXTyux7CMwqr9834tXg/gyrSL88n2TRezC7lPUWoRJY
0VGBJss3p0mdVtSzZ9Mk8h2YJnF1uOqhSaEEtrsjRpnJD2D4lJWdv/663kt/
5ZS+K9dkK2NR41ckaLfIdpzSrnvhhewPf7DxENcNunjnxntEHLaIjHpDOqHv
mNuAExe4Mvvvf1+07e32TTI1veZmv7OEPj1DJYmrpccxZIVy3MB4C76dVWVa
2zG2TlSodPm0jLQrGie+fBt6Jnz6sQbvMvC+om8fzYH1UHptzRqfCgyBc4iy
LslHOA+B7zZYbQm8HfAemp5z5l0G3vrQubFCcAzbehymkwUwHa3qlw55dxT4
cZ7p1XESFbK2GQDPTdPrCPjlDUseG0PtvPJZmx0D2UxxirUnCCmvbth8U82O
Lbo0diWwq4DdwthNRYWBHec4avLuiJjRIQwL78GMG8aMaW7+tyHbwG28qi86
yU1ncT/kSIInnX4kHHawmoNtCrsBsDO7XDCx6Llemg++CxZiYPOkWylepjPW
lDNWvtfJa1+UOGM06WA0Mz2xvrKqtkJPY0tYtHuP8rqwYN2wsiS+DFHId76z
tDh8A1iUwGLq7Ulxywjhra7WyCZwQY2kuewBF+xFE0oYe/mb32ic7COqY/BO
wI52pM+H1qeCC8CKPT2N9QRgRS/GWHPCWhFWjSLomjZz1oV5ZJZywvsnhUsF
5uyfsuYbPmmM+4ARx5SJt42f/1xtw7A6a98unENo2xNRniljy+Jbru2o81Yf
+rWvMVofdw4IKU9glvxXPgvA7ADzwNr2JGCdA9Z+LbzsaGEetbl4QZilpQkn
Qy0lUdz2FY/5HdhLw34qGrfoKq+CAHr85YGix19DHwD6DUBfGnqZEqqZZA6Y
sK1kRWAiNiRRWwcXB7ZzIF4xHouJEntVYJb8BXSD2SlghjFk7vUS9QAmVgK7
Atj5noG+HtnlpqmbIYIqhA0JttF4COzwV0Muye40sJt6dlGsVwGzSugFZnTw
iy8j4RdGggxHZYmQXeBlrM4CKwesKmCFvzHsx4pnNsFzxrF/xGogJhlYEaWx
aaiDCV0418GiBBb4+880i5uBRWUsitQsJmIyjCyPNTM1HlWKRxTrvCUxN4lZ
FMACfz2ZZnEGWOTGokquJdQsxp6FueQZ2FcBbHykeL4RiVfAI+/FQxy0fin7
EPBAP+rAPIE+P/PRhV+FC/OQTNYyLiRmRRJRGNLmPgVNbNy+wbaPm8k3cH7z
m0uFms1lDKnbVoDavJDO1NS1ZSO0I9+u2pQ9sJ4yrC7RP3HFLMY79XgtulgQ
XmfgYl+JFhwQGqLk3mUrCJeGcAgIUfNJhE4RKkjGyDfkgBFbcWhxWDMSPw7n
rlnkFHDiilUSZxlwWnsGOw3zko42daH3XGrZEW4F7Za1KntvmT0n14lrlLNI
33yaQ78aGt5B3OexH0U9HH0S/pbaI66/mRvisJJk7TtYE3kqWpMxBUf5xCgy
ABY4i0a/1WQxNRYYvSOLvIMFRmo+MhsnYpU4EjsDjHA0x/XYbkYjY4RRGY4m
XYzKaLTX0W8KXAqLULo44HM/HNubHErru2esN4g2yix6aiQ+LoFYfjHdEsmf
9jg13m3EHLgGkNwjMsNvOHse2rrshbcwvPq2EIGygQ9tZpiYRdXRR9Y6l8ZI
cBW/j11vB+yuF3b1N1m2+kuomsMIOIyNw34yDsxaZ4LJPaYE99tSuM2+GfEm
ImY7ApToY6aGci8xk5B3bwANzo98Cx8Fv44oizaUFmGOASGurm4Ywh2wZYw8
EVkaaduOXdiWC7PUGaDDNQq/9rsF6DCeRMvEGbSi8zvL3gltmHt0NkveMHRi
hBQLM0hEinNGXI3fAI13RcBop4oYvbXsbVkF5Pqwn1DPDLH2GoWcQt32zETQ
2vxKmzhPRMK4AqQYq6No19QSsEncW7/JXyPbkBd4AzINebPl6/FqeGg9Dcwb
u6ohnpsED3rd28wGg5aj2Wfdh2tkc3m1PCCjkwNDNfbznAAJ95ZLIxpZC4ln
tPc0nnySGXkMI8CwiPTG7XLaEAyjfsCfkyAPPbbKR1S3evtXELq6EPleRMPj
yRlxW1/8IvqN+Oka14X7CePasSJCa7/V+wl+/kB/N3ll96c/1TawTZymlGzz
8ysLluN2OA31oQ2o1Jnp4TbPn6SJN+EeINKuXl3SXz7dAum3UBLidPvgXqH4
dqlKRR8v+6r6mkzarId0scnPfc5k497KadkLY+zbNyu+8IVMxWbTDplnZP8h
lelb6VxC6k2UZWkqEf3ahYTkEUjeBsmnI8kv2m/yL0C9VUPydqRdlDjokHjA
2uVnwnTb7SCpbEhCv5hq3bJD4tIk8n24g7RrSMT5nt+dMrahvEPiiUji3Z0S
TxzVXl24uSCJROxC3btR3bhnddGoG3f/vCO0H1WhBLIdkLDte0D43Ae15A05
J4/q8V5GALodW2XT25p9cJ/ruNamd7vD5+1ulrAJEuYgQXa7L0MdRxo5a/2n
oX60xbTfqGXNQNbDotxwf+Bx81E0IuHMyfwq14L1T6D+v2ypH70T9t4y1rhx
GYGsESUM5dHo3rqlbjlK7wM/SNQ8gJoH5ssftzq0Rtx/Hn3dKFFzCTWXVvNT
K1Zz3uRgjZNEjQXUmEOLv28F861QI45IPOJxG0qtLtRqPZX3pGdD1Pky7pGP
e/0vAlqqzABxnveqd379Tiw29T8FbNndf20ydY8c3Gn/APIftrp1R7M7rW4s
9XdWSvd0vAuuYoz2PkOge7363dmx1ONWp+78/A64iiPAo1ZadyBHD4h78j1s
CHQP93caAiz1kNWpO+ujt8O1hHdZnfo/Gfjd77HUPVan/v8SD8BVnNPdZaX1
f8NAz5jaSZ8RXJTSDxoCLHXe6nxESr0HrmK0eIuVfkxKX7Q6sdQpk/yklHoY
ruJq0b7V+bdS2v//Bql3ybnUB6XUI3AVnyTPDYHsfp/h/zmAs+KJ1f0xKf2o
IcBSldX5cSn1WHSVvaCzOv5ZrnIf5JdSnpVcdtP/AfrU7jg=\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->465218570],

Cell["Count the number of edges of an icosahedron:", "ExampleText",
 CellID->1051858867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<EdgeCount\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75111809],

Cell[BoxData["30"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1794880197]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266364444],

Cell["Vertex coordinates for a unit tetrahedron:", "ExampleText",
 CellID->578958897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Tetrahedron\>\"", ",", "\"\<VertexCoordinates\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234149351],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{
      SqrtBox[
       FractionBox["2", "3"]], "-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["3"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["3"]}]]}], ",", 
     FractionBox["1", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["3"]], ",", "0", ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{308, 76},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->848681570]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25388447],

Cell["A list of Archimedean polyhedra:", "ExampleText",
 CellID->621248852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<Archimedean\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->530875421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Cuboctahedron\"\>", ",", "\<\"GreatRhombicosidodecahedron\"\>",
    ",", "\<\"GreatRhombicuboctahedron\"\>", ",", "\<\"Icosidodecahedron\"\>",
    ",", "\<\"SmallRhombicosidodecahedron\"\>", 
   ",", "\<\"SmallRhombicuboctahedron\"\>", ",", "\<\"SnubCube\"\>", 
   ",", "\<\"SnubDodecahedron\"\>", ",", "\<\"TruncatedCube\"\>", 
   ",", "\<\"TruncatedDodecahedron\"\>", ",", "\<\"TruncatedIcosahedron\"\>", 
   ",", "\<\"TruncatedOctahedron\"\>", ",", "\<\"TruncatedTetrahedron\"\>"}], 
  "}"}]], "Output",
 ImageSize->{517, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->204763616]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(51)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Names and Classes",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1533190506],

Cell["Obtain a list of all implemented polyhedra:", "ExampleText",
 CellID->676553989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", "All", "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1459672817],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "9"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "136", "\[RightSkeleton]"}], 
    ",", "\<\"TruncatedCube\"\>", ",", "\<\"TruncatedDodecahedron\"\>", 
    ",", "\<\"TruncatedIcosahedron\"\>", ",", "\<\"TruncatedOctahedron\"\>", 
    ",", "\<\"TruncatedTetrahedron\"\>"}], "}"}],
  Short[#, 4]& ]], "Output",
 ImageSize->{541, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->1193291618]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->961719889],

Cell[BoxData["147"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->302444393]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->92157315],

Cell["Find the English name of a polyhedron:", "ExampleText",
 CellID->738578064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<Name\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221172202],

Cell[BoxData["\<\"cube\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89120702]
}, Open  ]],

Cell["A list of alternate names can also be found:", "ExampleText",
 CellID->629456667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<AlternateNames\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33052035],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"hexahedron\"\>", ",", "\<\"regular cuboid\"\>", 
   ",", "\<\"unit cube\"\>", ",", "\<\"square prism\"\>"}], "}"}]], "Output",
 ImageSize->{367, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1055536555]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->612011445],

Cell["Additional names acceptable as input can be found:", "ExampleText",
 CellID->129146030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<AlternateStandardNames\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->952696506],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Hexahedron\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Hypercube\"\>", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Prism\"\>", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40472018]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Hypercube\>\"", ",", "3"}], "}"}], ",", 
   "\"\<StandardName\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149645494],

Cell[BoxData["\<\"Cube\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1608374074]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->593810369],

Cell["Find the list of polyhedron classes:", "ExampleText",
 CellID->268927234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<Classes\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28830905],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Antiprism\"\>", ",", "\<\"Archimedean\"\>", 
   ",", "\<\"ArchimedeanDual\"\>", ",", "\<\"Chiral\"\>", 
   ",", "\<\"Concave\"\>", ",", "\<\"Convex\"\>", ",", "\<\"Cuboid\"\>", 
   ",", "\<\"Deltahedron\"\>", ",", "\<\"Dipyramid\"\>", 
   ",", "\<\"Equilateral\"\>", ",", "\<\"Hypercube\"\>", 
   ",", "\<\"Johnson\"\>", ",", "\<\"KeplerPoinsot\"\>", 
   ",", "\<\"Orthotope\"\>", ",", "\<\"Platonic\"\>", ",", "\<\"Prism\"\>", 
   ",", "\<\"Pyramid\"\>", ",", "\<\"Quasiregular\"\>", 
   ",", "\<\"RectangularParallelepiped\"\>", ",", "\<\"Rhombohedron\"\>", 
   ",", "\<\"Rigid\"\>", ",", "\<\"SelfDual\"\>", ",", "\<\"Shaky\"\>", 
   ",", "\<\"Simplex\"\>", ",", "\<\"SpaceFilling\"\>", 
   ",", "\<\"Uniform\"\>", ",", "\<\"Zonohedron\"\>"}], "}"}]], "Output",
 ImageSize->{559, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1566396929]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16764254],

Cell["Find the list of polyhedra belonging to a class:", "ExampleText",
 CellID->53277388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<Platonic\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->795584317],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Cube\"\>", ",", "\<\"Dodecahedron\"\>", 
   ",", "\<\"Icosahedron\"\>", ",", "\<\"Octahedron\"\>", 
   ",", "\<\"Tetrahedron\"\>"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->431157130]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<Archimedean\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23186614],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Cuboctahedron\"\>", ",", "\<\"GreatRhombicosidodecahedron\"\>",
    ",", "\<\"GreatRhombicuboctahedron\"\>", ",", "\<\"Icosidodecahedron\"\>",
    ",", "\<\"SmallRhombicosidodecahedron\"\>", 
   ",", "\<\"SmallRhombicuboctahedron\"\>", ",", "\<\"SnubCube\"\>", 
   ",", "\<\"SnubDodecahedron\"\>", ",", "\<\"TruncatedCube\"\>", 
   ",", "\<\"TruncatedDodecahedron\"\>", ",", "\<\"TruncatedIcosahedron\"\>", 
   ",", "\<\"TruncatedOctahedron\"\>", ",", "\<\"TruncatedTetrahedron\"\>"}], 
  "}"}]], "Output",
 ImageSize->{517, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->848058932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->427853053],

Cell["Test whether a polyhedron belongs to a class:", "ExampleText",
 CellID->226300656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<Archimedean\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16562659],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->477504985]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<Platonic\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->101592490],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->279894056]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties and Annotations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1961895733],

Cell["Get a list of properties for a particular polyhedron:", "ExampleText",
 CellID->218429381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<EschersSolid\>\"", ",", "\"\<Properties\>\""}], "]"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", "4"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180587304],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"AdjacentFaceIndices\"\>", ",", "\<\"AlternateNames\"\>", 
    ",", "\<\"AlternateStandardNames\"\>", ",", "\<\"Centroid\"\>", 
    ",", "\<\"Circumcenter\"\>", ",", "\<\"Circumradius\"\>", 
    ",", "\<\"Circumsphere\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "45", "\[RightSkeleton]"}], 
    ",", "\<\"SymmetryGroupString\"\>", ",", "\<\"VertexCoordinates\"\>", 
    ",", "\<\"VertexCount\"\>", ",", "\<\"VertexIndices\"\>", 
    ",", "\<\"Volume\"\>", ",", "\<\"WythoffSymbol\"\>"}], "}"}],
  Short[#, 4]& ]], "Output",
 ImageSize->{493, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->1190212262]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228229632],

Cell["Get a short textual description of a property:", "ExampleText",
 CellID->1347723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Circumradius\>\"", ",", "\"\<Description\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1850805952],

Cell[BoxData["\<\"circumradius\"\>"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87315629]
}, Open  ]],

Cell["Get a longer textual description:", "ExampleText",
 CellID->1113244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Circumradius\>\"", ",", "\"\<LongDescription\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4392297],

Cell[BoxData["\<\"circumradius assuming unit smallest edge length\"\>"], \
"Output",
 ImageSize->{333, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->782445702]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Property Values",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29302194],

Cell[TextData[{
 "A property value can be any valid ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression:"
}], "ExampleText",
 CellID->553589695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<TruncatedDodecahedron\>\"", ",", "\"\<Volume\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->529027222],

Cell[BoxData[
 RowBox[{
  FractionBox["5", "12"], " ", 
  RowBox[{"(", 
   RowBox[{"99", "+", 
    RowBox[{"47", " ", 
     SqrtBox["5"]}]}], ")"}]}]], "Output",
 ImageSize->{107, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1522542933]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Octahedron\>\"", ",", "\"\<NetCount\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1648676993],

Cell[BoxData["11"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2111420926]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Octahedron\>\"", ",", "\"\<Centroid\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->609521478],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1631720254]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Octahedron\>\"", ",", "\"\<SkeletonRules\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->417806960],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"1", "\[Rule]", "3"}], ",", 
   RowBox[{"1", "\[Rule]", "4"}], ",", 
   RowBox[{"1", "\[Rule]", "5"}], ",", 
   RowBox[{"2", "\[Rule]", "3"}], ",", 
   RowBox[{"2", "\[Rule]", "4"}], ",", 
   RowBox[{"2", "\[Rule]", "6"}], ",", 
   RowBox[{"3", "\[Rule]", "5"}], ",", 
   RowBox[{"3", "\[Rule]", "6"}], ",", 
   RowBox[{"4", "\[Rule]", "5"}], ",", 
   RowBox[{"4", "\[Rule]", "6"}], ",", 
   RowBox[{"5", "\[Rule]", "6"}]}], "}"}]], "Output",
 ImageSize->{502, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->956136788]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<DuerersSolid\>\"", ",", "\"\<EdgeLengths\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1391922218],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", 
      SqrtBox["5"]}], ")"}]}], ",", 
   SqrtBox[
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       SqrtBox["5"]}], ")"}]}]]}], "}"}]], "Output",
 ImageSize->{211, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->170865415]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->490922267],

Cell[TextData[{
 "A property that is not available for a ",
 "polyhedron",
 " has the value ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<NotAvailable\>\"", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->187464565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<DuerersSolid\>\"", ",", "\"\<Centroid\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178393597],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549393866]
}, Open  ]],

Cell[TextData[{
 "A property that is not applicable for a polyhedron has the value ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<NotApplicable\>\"", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1537427777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<SnubDisphenoid\>\"", ",", "\"\<Circumradius\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1025407335],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"NotApplicable\"\>", "]"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1630507409]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Detailed Properties",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(44)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2131646900],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "Graphics-Related Properties", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->384419450],

Cell[TextData[{
 "Give the edges of the cube as a ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1306885974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<Edges\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1495055007],

Cell[BoxData[
 RowBox[{"GraphicsComplex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "8"}], "}"}]}], "}"}], "]"}]}], "]"}]], "Output",
 ImageSize->{464, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2046687343]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", "%", "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->854483156],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
     Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
     Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
     Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
     Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
     Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
     Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
     Rational[1, 2], Rational[1, 2], Rational[
      1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
    0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {0.5, 
    0.5, -0.5}, {0.5, 0.5, 0.5}}], 
   Line3DBox[{{1, 2}, {1, 3}, {1, 5}, {2, 4}, {2, 6}, {3, 4}, {3, 7}, {4, 
    8}, {5, 6}, {5, 7}, {6, 8}, {7, 8}}]],
  Boxed->False]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->281116155,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1822048435],

Cell[TextData[{
 "Give the faces of the cube as a ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->565932071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<Faces\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->415244734],

Cell[BoxData[
 RowBox[{"GraphicsComplex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"8", ",", "4", ",", "2", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "6", ",", "5", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "7", ",", "3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "3", ",", "1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "7", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "5", ",", "6"}], "}"}]}], "}"}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{556, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->255193685]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->939205470],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
     Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
     Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
     Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
     Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
     Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
     Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
     Rational[1, 2], Rational[1, 2], Rational[
      1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
    0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {0.5, 
    0.5, -0.5}, {0.5, 0.5, 0.5}}], 
   Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 2}, {1, 
    3, 7, 5}, {2, 1, 5, 6}}]]]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->515420736,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1681761137],

Cell["Give an image of the cube:", "ExampleText",
 CellID->179667745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<Image\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->313782533],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
     Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
     Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
     Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
     Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
     Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
     Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
     Rational[1, 2], Rational[1, 2], Rational[
      1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
    0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {0.5, 
    0.5, -0.5}, {0.5, 0.5, 0.5}}], 
   Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 2}, {1, 
    3, 7, 5}, {2, 1, 5, 6}}]]]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1874761601,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Cube\>\"", ",", "\"\<Faces\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->748999497],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
     Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
     Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
     Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
     Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
     Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
     Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
     Rational[1, 2], Rational[1, 2], Rational[
      1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
    0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {0.5, 
    0.5, -0.5}, {0.5, 0.5, 0.5}}], 
   Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 2}, {1, 
    3, 7, 5}, {2, 1, 5, 6}}]]]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1238159223,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzdmvtSFEcUxoe9sctykzsIuMAqIoGgSBQloYiRYIxammhpLDWoG8ELKmoq
5R+xKn8YY6IxmhdIniFvkDfI+1BJd5+Zpec7p2cYQywrW+XIDv37vu+c6Vl2
ZvrY4v2lyq3F+8tXFksfry7eWVq+cq80f3tV7UrXeJ73h/r3Z5enfv5b/WT+
fbO2tualK5XKmnl503rjPVDbjNp50Ly7p7Yp9S7t/3/A7L3rv8taCmrrK6yo
rd5ZK/72ps/q36ZVDC9TTaB+2G/GLFsKKTUkdXvskZdVP9hDPRp7zdfL+2Mz
emy6OtZLQZVThqpAipxF6VBpoPYa6jLkKthev606qC/Bq6ipzDrF3SYNdwHc
GoMuKKiKsvqIPQ+ezSKLvnsMew7YlqBKYpWjoo1W8NJ7yfcMZG4HNq3ZTJVV
u4j7HDw7JY55Ut5TFqs9e4DNiOxuw57w8+Z8315gs+p/7NK7hjwGrtsEkrtO
GPYT6NIgzKMs6xJxC9ClssQxT8o7D3mHgc2J7LhhD0GXRoCtZXmJmwPPdySO
eY4ZdhbYcWDzzJO4Gcg6AVxBOKK7DHkAHCcFkqcdNew+cJ0Cto6lJW4KPPdL
HPOkvJPAHoAZWBTZEcNOQN4ZYOtZXuLGwXNW4pjnTsOOguccsA3Mk7gR8PwI
uEbhiG435DCQ8wLJ0+4wbBnSLgDbxNISNwieRyWOeVLeks8GnsdhNnBP4vqs
rNrzJHDNjCsbbitk/UziWNYhw3ZBf04Du4V5EtcBnmcljnkOGrYN+vMFsC0i
O2DYLdCjC8C2srzENcPMyvr8JYln3iWj0eTnzvi5F4FtY97rXPD9iLba+SrM
qHZh/vcx3uzwvhJYnrp/g3QHy52IZL6UutG0uUqTAFPoZN5J6C5G9yalWfqt
6wqh2q8B3c28N0r2CEe6y8EuwRzjrj1mYINYMdI9jO5OSrN+dSVQ2Mr8LTpU
9zKQvYzsTEKy1B0bpPuYL5H1Yr1I9wtHunUjvD9T+pl7ewJ6G6PbktKsb1b6
UN+uA11i3hslBxjZ8i/Jolgv0oOM3pKUZt1qTqAwxPwtOlT3DSDLjGxKQrLU
jQ76Jsxu7ktknVgv0tsDuhK8Gl6Hrnq/JXSoY7c2jdyhNniPwBwhdT0jZb4F
R1rz9J6OccObZEMV178ddKjbK/85mRcTIz0MnX6jbCh1cbPoULfuCLN6c8la
MfHm0sPCuVhIyNtHKql3OHndRmjnkbLoUL/vbpDMib7/H3onHKtNYlmvzf3x
ir5XgmkLDmrFp/QkjK6XFLJi5hvW/NK0ub79/a+16M+0KMVrVq5CoOT8+xel
dNVSagAl/t0jSmnRUmqG6rYLZ3NthNZFoWNtoFmGI29lCx3D81aubtDg3wfN
p6KXEVOdtZT6oFf8m22U0mlLaQCU+DfsKKVTQqfKUGUyxRPWMxd6jYAev+6I
0jtq1ToGSvzqKUppwVLaDV3bJswwcz7TkxumNW9pTYEWvyKsjVA6JByBaVDk
V7hRirNWtvehY8mUZiylOVDiV/tRStOW0mFQ4nccopTeE/p1BPrF76FYiqGz
e9LKdVxQwTlhPh/oSSBLNmFpnYQae+DTpjZCZ8zSOQ06/N5SLkJpl9Crc6DI
789FKQ6zs/sidI3fLYzSG7JqvQxK/J5nlFLJUqpAjS4lMyFIyH+6q/YpHV1k
r9C7ZdBtfw3dbtbBFUEV510mVrfdqn8VOsnvemdj9Vosva9Bj9/Bj9drEvr5
EHRbXkO3nvXzW+inU5XNoaJV83egwp+yuFTylspjqJA/H3KpZC2Vp4IKzpC0
Qycl9P056PGnXRmHmjZ8CZ1x0taKFO1qGMVq/BVoNDo0gmc5USx/msnPFr1H
d/NXqJw/ffV9pfPPyvASdIoOnWA1T/As6xVw/Gk1cdkY/xfQg6IwI8x78y1m
fQWRW4EnoRmVF+aZruQXqKTg4AsO/5+B56sMiC86/F8Az1dGEF8f08ln0AeX
ToOjDuRzDr7JUQeeiznhSNYYhWZHgp9AIVhJU6Pea5LoFof/M6AzLD/No1aH
+1Oo38W3C/5ROnz9Eul0OOr4EepIOfhORx0/6E22ymvao8+BcB+7Hf4mf2it
GWd7HN5PILt99DyvN6Zz3wfOfufCzrRmQUr8BDoepvodWR/bfQpa68/QksNJ
M6ngz0eIGHC4PFKbjLf++Umjh2I68dCn8qFKymvrawJ0igdqlC6gGNLeEaO9
4mtrKls9q4cdFV+3RusLDrou3emo9rKfqM7XpvvCu2ISXQAPehY2CtWeg1H0
dHIsRvskJKJn0OOWtj36U/CgtQkT4JHyEy3AaFpxsjsm0ZxPBYloDdAeqHbG
yq21ae3X3hjtKdCmdXxTjmonrNHag9ae7nNUOwqJaC3t/phEZUg0Y6hpqLYE
SebMqIMx2l2Q6LChZhzVtkKSI2b0B45qmyDRcTN61qGdh9GnzOg5h3baz13w
k5wxoz8URptrfC94BernzfhDfhbpbo9WvWRGHbZ+S3/VSOOq+a1e4ZlT75bM
O6/mH6o2pWk=\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["Combinatorial Properties", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->334414914],

Cell["Give the number of edges in an icosahedron:", "ExampleText",
 CellID->546755399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<EdgeCount\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1803444586],

Cell[BoxData["30"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->625521531]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235465480],

Cell["Give the indices of edges in an icosahedron:", "ExampleText",
 CellID->613171829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<EdgeIndices\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1952391697],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12"}], "}"}]}], "}"}]], "Output",
 ImageSize->{445, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1207919452]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1625960700],

Cell[BoxData["30"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1339314673]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->885757158],

Cell["Give the number of faces in a cuboctahedron:", "ExampleText",
 CellID->600773270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cuboctahedron\>\"", ",", "\"\<FaceCount\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1875724343],

Cell[BoxData["14"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2085604904]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->525089150],

Cell["\<\
Give a list of rules summarizing the number and types of faces in the \
cuboctahedron:\
\>", "ExampleText",
 CellID->1163038527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cuboctahedron\>\"", ",", "\"\<FaceCountRules\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->792368295],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", "\[Rule]", "8"}], ",", 
   RowBox[{"4", "\[Rule]", "6"}]}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1533535194]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"Last", "/@", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1805183635],

Cell[BoxData["14"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27274264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1159943401],

Cell["Give the indices faces in a cuboctahedron:", "ExampleText",
 CellID->312193141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cuboctahedron\>\"", ",", "\"\<FaceIndices\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->727571166],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "8", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9", ",", "11", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "6", ",", "8", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "12", ",", "10", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "11", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "9", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "11", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "10", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "8", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "10", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{421, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->984538237]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->655510803],

Cell[BoxData["14"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->772649124]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->280398620],

Cell["Give the indices faces in a cuboctahedron:", "ExampleText",
 CellID->1080484822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cuboctahedron\>\"", ",", "\"\<VertexCount\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->586684322],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80213659]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Cuboctahedron\>\"", ",", "\"\<VertexCoordinates\>\""}], "]"}],
   "//", "Length"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->116292952],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1678720144]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "Coordinate-Related Properties", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->1667665697],

Cell["\<\
Give the centroid of D\[UDoubleDot]rer's solid:\
\>", "ExampleText",
 CellID->2075193695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<DuerersSolid\>\"", ",", "\"\<Centroid\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1307698019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->609305922]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->498520938],

Cell[TextData[{
 "Give the normalized moment of inertia tensor of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " polyhedron:"
}], "ExampleText",
 CellID->2101227243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<MathematicaPolyhedron\>\"", ",", "\"\<InertiaTensor\>\""}], 
   "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2105181833],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox["1", "180"], " ", 
       RowBox[{"(", 
        RowBox[{"35", "+", 
         RowBox[{"9", " ", 
          SqrtBox["5"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            SqrtBox["5"]}], ")"}]}]}], ")"}]}], "0", "0"},
     {"0", 
      RowBox[{
       FractionBox["1", "180"], " ", 
       RowBox[{"(", 
        RowBox[{"35", "+", 
         RowBox[{"9", " ", 
          SqrtBox["5"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            SqrtBox["5"]}], ")"}]}]}], ")"}]}], "0"},
     {"0", "0", 
      RowBox[{
       FractionBox["1", "180"], " ", 
       RowBox[{"(", 
        RowBox[{"35", "+", 
         RowBox[{"9", " ", 
          SqrtBox["5"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            SqrtBox["5"]}], ")"}]}]}], ")"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{591, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->1402602158]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2044396650],

Cell["\<\
Give the region function of the cuboctahedron as a pure function:\
\>", "ExampleText",
 CellID->1648292482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cuboctahedron\>\"", ",", "\"\<RegionFunction\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312698674],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], "+", "#3"}], "\[GreaterEqual]", "0"}], "&&", 
   RowBox[{"#3", "\[LessEqual]", 
    FractionBox["1", 
     SqrtBox["2"]]}], "&&", 
   RowBox[{"#1", "\[LessEqual]", 
    RowBox[{"1", "+", "#2"}]}], "&&", 
   RowBox[{
    RowBox[{"1", "+", "#1", "+", "#2"}], "\[GreaterEqual]", "0"}], "&&", 
   RowBox[{"#2", "\[LessEqual]", 
    RowBox[{"1", "+", "#1"}]}], "&&", 
   RowBox[{
    RowBox[{"#1", "+", "#2"}], "\[LessEqual]", "1"}], "&&", 
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox["2"], " ", "#1"}], "+", "#3"}], "\[LessEqual]", 
    SqrtBox["2"]}], "&&", 
   RowBox[{"#3", "\[LessEqual]", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "#1"}], ")"}]}]}], "&&", 
   RowBox[{"#3", "\[LessEqual]", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "#2"}], ")"}]}]}], "&&", 
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox["2"], " ", "#2"}], "+", "#3"}], "\[LessEqual]", 
    SqrtBox["2"]}], "&&", 
   RowBox[{
    RowBox[{
     SqrtBox["2"], " ", "#1"}], "\[LessEqual]", 
    RowBox[{
     SqrtBox["2"], "+", "#3"}]}], "&&", 
   RowBox[{
    RowBox[{
     SqrtBox["2"], "+", 
     RowBox[{
      SqrtBox["2"], " ", "#1"}], "+", "#3"}], "\[GreaterEqual]", "0"}], "&&", 
   
   RowBox[{
    RowBox[{
     SqrtBox["2"], "+", 
     RowBox[{
      SqrtBox["2"], " ", "#2"}], "+", "#3"}], "\[GreaterEqual]", "0"}], "&&", 
   
   RowBox[{
    RowBox[{
     SqrtBox["2"], " ", "#2"}], "\[LessEqual]", 
    RowBox[{
     SqrtBox["2"], "+", "#3"}]}]}], "&"}]], "Output",
 ImageSize->{549, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->606476387]
}, Open  ]],

Cell[TextData[{
 "Give the region function of the cuboctahedron as a function of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 "-, ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]]],
 "-, and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]]],
 "-coordinates:"
}], "ExampleText",
 CellID->176926156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Cuboctahedron\>\"", ",", "\"\<RegionFunction\>\""}], "]"}], 
   "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1480536444],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"z", "+", 
     FractionBox["1", 
      SqrtBox["2"]]}], "\[GreaterEqual]", "0"}], "\[And]", 
   RowBox[{"z", "\[LessEqual]", 
    FractionBox["1", 
     SqrtBox["2"]]}], "\[And]", 
   RowBox[{"x", "\[LessEqual]", 
    RowBox[{"y", "+", "1"}]}], "\[And]", 
   RowBox[{
    RowBox[{"x", "+", "y", "+", "1"}], "\[GreaterEqual]", "0"}], "\[And]", 
   RowBox[{"y", "\[LessEqual]", 
    RowBox[{"x", "+", "1"}]}], "\[And]", 
   RowBox[{
    RowBox[{"x", "+", "y"}], "\[LessEqual]", "1"}], "\[And]", 
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox["2"], " ", "x"}], "+", "z"}], "\[LessEqual]", 
    SqrtBox["2"]}], "\[And]", 
   RowBox[{"z", "\[LessEqual]", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}]}]}], "\[And]", 
   RowBox[{"z", "\[LessEqual]", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"(", 
      RowBox[{"y", "+", "1"}], ")"}]}]}], "\[And]", 
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox["2"], " ", "y"}], "+", "z"}], "\[LessEqual]", 
    SqrtBox["2"]}], "\[And]", 
   RowBox[{
    RowBox[{
     SqrtBox["2"], " ", "x"}], "\[LessEqual]", 
    RowBox[{"z", "+", 
     SqrtBox["2"]}]}], "\[And]", 
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox["2"], " ", "x"}], "+", "z", "+", 
     SqrtBox["2"]}], "\[GreaterEqual]", "0"}], "\[And]", 
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox["2"], " ", "y"}], "+", "z", "+", 
     SqrtBox["2"]}], "\[GreaterEqual]", "0"}], "\[And]", 
   RowBox[{
    RowBox[{
     SqrtBox["2"], " ", "y"}], "\[LessEqual]", 
    RowBox[{"z", "+", 
     SqrtBox["2"]}]}]}], TraditionalForm]], "Output",
 ImageSize->{464, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->1091247647]
}, Open  ]],

Cell["\<\
Plot the region corresponding to the interior of the cuboctahedron:\
\>", "ExampleText",
 CellID->234309173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"r", "=", "1"}], "}"}], ",", 
   RowBox[{"RegionPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"PolyhedronData", "[", 
       RowBox[{"\"\<Cuboctahedron\>\"", ",", "\"\<RegionFunction\>\""}], 
       "]"}], "[", 
      RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "r"}], ",", "r"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "r"}], ",", "r"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "r"}], ",", "r"}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "20"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1696745660],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->96101635]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93708132],

Cell["Give the indices faces in a vertex coordinates:", "ExampleText",
 CellID->847061273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cuboctahedron\>\"", ",", "\"\<VertexCoordinates\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->889719348],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["1", 
      SqrtBox["2"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["1", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", 
      SqrtBox["2"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["1", 
      SqrtBox["2"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", 
      SqrtBox["2"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{484, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1724031356]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["Geometrical Properties", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->227883247],

Cell["Show the circumradius of the unit cube:", "ExampleText",
 CellID->1070389728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<Circumradius\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->569647577],

Cell[BoxData[
 FractionBox[
  SqrtBox["3"], "2"]], "Output",
 ImageSize->{32, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1945634968]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->643587919],

Cell["Show the dihedral angle rules of the unit cube:", "ExampleText",
 CellID->2054508341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<DihedralAngleRules\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->732127074],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWcmO00AQ7cROQiaZMAEJuADhABeWM2JfZxgSPiIaIc0cEGiY/8tXwAE+
xrja7sR5Kbu6vcUBIsV29VJ7t9v1Ps0vTj9/mV+cncwnR+fzb6dnJ98nh1/P
wyavpVTrl1Lq8Q0VPgfhk/7T73f4jx6jp9fhtRN2fozvxwI9WM5SHcMz0G3R
mM3W44rGRpq8oau37FMzoKcF+4daytuKpfjhpR2SHS3tXcXSOkC3tdT3Ndi4
KbUJmdRlNaPMosZZfJ8KdI/lMoDWPtCXgZ4AvVdw/r8m/w4bBeRCNK23MbTf
jttdx6OVu8Ifvc17ywuiDMd9o5fSjvOvAn2JkUqLEneINP7ojStAY4648t8V
/bsp7dvWn88i3bqx95o3Xy+1V5JMs9FjOM9NyhDoccCvqjotKkOWrV3FvLdN
izATW3oeSsY3Nb5DPIbuK3NOWCwWKvqReppO0QbXDe6+KMeP5XQEOftCvEas
71CbvFahNPR5WVahviOg8dTWNHtoXPghpnMwykNcZ2gB5mEbaFxZNwVLMN+Q
H3pC4qcj5Lz+69YSvVi3fvwexO2xtM+RtjZnkFsWVrcZPmgt8sHxZI2fQx8c
v59il6QP2nUANK5GV71Gln6yO9PgCpbeAPcFa6VceyDIRyuwH+W76o/yXfWX
5Es74MQqKvzJAt8frrGx2/3QQ+Xoko+LFC07i+x0sePFxw+zllq9eG+kvQjX
/ENmPK3pg3geSn2Uwt+Mt+GfpQ/HP0ufLP7ceL6mQY8/2Z5X0Ir6YqUP+w+3
PN+lUlhVTZAfy9f4dA3aX7XGPNdapiWN4TVI1qeV4ZSgZwX7aWdZ1aerljZc
xrsXUkfx/YNA67eAdgtiHKun/2hHdn/keXM2fV6xtMgmXP0vKpa6x0p9WbHU
Piv1adCUzELNngVu6MeQ5YInkr8dfWiafI+NClcv3gW0oi7+vpXXKLe502NZ
qIIrf1dUYVuoTj/FrqahOmn+yat/dFLDL1rkzmHR5dfei0lpIj6Shllw35Z5
bGkCJpLXlugtYG4BE3/q6qr4LV4ZcmCkSDW9vIgBfhsNKrWGq3h2mdiXhX/w
FZayrOF8V8QazU/c7YrUkqQ6Ps+7KNrAVlxLx0TsPLAd/CafB1DXa3qcdMbS
/Wv1D7IhDz6xyYmqpzbnKI6TF8/PowmL1q5pJkVE4pjXR0lMyk2j64FNNJP0
cp1nZFZWRV4p9/o36ichyhIikPz64nLeqv7uIB/7k/M5+XdzRaUITlJGVPCb
1hWnKRqVcrAZSQs+NigLUWIJqTDjzd5kg1T4DvzNd4I5v9oiIWMH/l48nuN/
j/UaXX6wPU+A3jUkxKVqWC8Swtf7qGpYFxKSXqtWqipMYjeQD9X6A2yLqUI=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{474, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88137222]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"Last", "/@", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->160693879],

Cell[BoxData[
 RowBox[{"{", 
  FractionBox["\[Pi]", "2"], "}"}]], "Output",
 ImageSize->{31, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->482582592]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->884345772],

Cell["Give edge lengths of the unit cube:", "ExampleText",
 CellID->465069117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<EdgeLengths\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1723657986],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1867372672]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"Normal", "[", 
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"\"\<Cube\>\"", ",", "\"\<Edges\>\""}], "]"}], "]"}], "]"}], "/.",
    
   RowBox[{
    RowBox[{"Line", "[", "x_", "]"}], "\[RuleDelayed]", 
    RowBox[{"Norm", "[", 
     RowBox[{"Subtract", "@@", "x"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->634907099],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1606481046]
}, Open  ]],

Cell["Give edge lengths of the deltoidal hexecontahedron:", "ExampleText",
 CellID->2134050288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<DeltoidalHexecontahedron\>\"", ",", "\"\<EdgeLengths\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1438399374],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{"7", "+", 
      SqrtBox["5"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{108, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1962530038]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"Normal", "[", 
      RowBox[{"PolyhedronData", "[", 
       RowBox[{"\"\<DeltoidalHexecontahedron\>\"", ",", "\"\<Edges\>\""}], 
       "]"}], "]"}], "]"}], "/.", 
    RowBox[{
     RowBox[{"Line", "[", "x_", "]"}], "\[RuleDelayed]", 
     RowBox[{"Norm", "[", 
      RowBox[{"Subtract", "@@", "x"}], "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1536491214],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{"7", "+", 
      SqrtBox["5"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{108, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1041014393]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1172256596],

Cell["Give the generalized diameter of the unit cube:", "ExampleText",
 CellID->1101631394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<GeneralizedDiameter\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1662318171],

Cell[BoxData[
 SqrtBox["3"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->779631042]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "/@", 
  RowBox[{"Subtract", "@@@", 
   RowBox[{"Subsets", "[", 
    RowBox[{
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"\"\<Cube\>\"", ",", "\"\<VertexCoordinates\>\""}], "]"}], ",", 
     
     RowBox[{"{", "2", "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->301848914],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", 
   SqrtBox["2"], ",", "1", ",", 
   SqrtBox["2"], ",", 
   SqrtBox["2"], ",", 
   SqrtBox["3"], ",", 
   SqrtBox["2"], ",", "1", ",", 
   SqrtBox["2"], ",", "1", ",", 
   SqrtBox["3"], ",", 
   SqrtBox["2"], ",", "1", ",", 
   SqrtBox["2"], ",", 
   SqrtBox["3"], ",", "1", ",", 
   SqrtBox["2"], ",", 
   SqrtBox["3"], ",", 
   SqrtBox["2"], ",", 
   SqrtBox["2"], ",", "1", ",", "1", ",", "1", ",", 
   SqrtBox["2"], ",", 
   SqrtBox["2"], ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{415, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1461192547]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1303646965],

Cell[BoxData[
 SqrtBox["3"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1787633984]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->592401792],

Cell["Give the inradius of the unit cube:", "ExampleText",
 CellID->762730652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<Inradius\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->884179221],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1468147558]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->347588458],

Cell["Give the midradius of the unit cube:", "ExampleText",
 CellID->763693766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<Midradius\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2038850690],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["2"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->568903276]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1127462866],

Cell["Give the surface area of the unit cube:", "ExampleText",
 CellID->2020171381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<SurfaceArea\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1303941397],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->960163288]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->866781808],

Cell["Give the volume of the unit cube:", "ExampleText",
 CellID->1620269455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<Volume\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1776086225],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1272257858]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "Properties of Polyhedron Nets", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->1167962657],

Cell["Give the coordinates the vertices of an icosahedron net:", "ExampleText",
 CellID->1947842619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<NetCoordinates\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1150182665],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox[
      SqrtBox["3"], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["3", "2"], ",", 
     FractionBox[
      SqrtBox["3"], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["5", "2"], ",", 
     FractionBox[
      SqrtBox["3"], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["7", "2"], ",", 
     FractionBox[
      SqrtBox["3"], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["9", "2"], ",", 
     FractionBox[
      SqrtBox["3"], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["11", "2"], ",", 
     FractionBox[
      SqrtBox["3"], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     SqrtBox["3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     SqrtBox["3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     SqrtBox["3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     SqrtBox["3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     SqrtBox["3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     SqrtBox["3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       SqrtBox["3"]}], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["3", "2"], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       SqrtBox["3"]}], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["5", "2"], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       SqrtBox["3"]}], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["7", "2"], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       SqrtBox["3"]}], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["9", "2"], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       SqrtBox["3"]}], "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{561, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->343146227]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1534833084],

Cell["Give the number of distinct nets of an icosahedron:", "ExampleText",
 CellID->981560060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<NetCount\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->366075024],

Cell[BoxData["43380"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1265044994]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110552166],

Cell["Give the indices of the edges of an icosahedron net:", "ExampleText",
 CellID->476899307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<NetEdgeIndices\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->837682145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "22"}], "}"}]}], "}"}]], "Output",
 ImageSize->{522, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1523108858]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->901426429],

Cell[TextData[{
 "Give the edges of an icosahedron net as a ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1924346265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<NetEdges\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1383952035],

Cell[BoxData[
 RowBox[{"GraphicsComplex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox[
        SqrtBox["3"], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "2"], ",", 
       FractionBox[
        SqrtBox["3"], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["5", "2"], ",", 
       FractionBox[
        SqrtBox["3"], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["7", "2"], ",", 
       FractionBox[
        SqrtBox["3"], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["9", "2"], ",", 
       FractionBox[
        SqrtBox["3"], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["11", "2"], ",", 
       FractionBox[
        SqrtBox["3"], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       SqrtBox["3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       SqrtBox["3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       SqrtBox["3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       SqrtBox["3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       SqrtBox["3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       SqrtBox["3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox[
        RowBox[{"3", " ", 
         SqrtBox["3"]}], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "2"], ",", 
       FractionBox[
        RowBox[{"3", " ", 
         SqrtBox["3"]}], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["5", "2"], ",", 
       FractionBox[
        RowBox[{"3", " ", 
         SqrtBox["3"]}], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["7", "2"], ",", 
       FractionBox[
        RowBox[{"3", " ", 
         SqrtBox["3"]}], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["9", "2"], ",", 
       FractionBox[
        RowBox[{"3", " ", 
         SqrtBox["3"]}], "2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "11"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "12"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "13"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "13"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "14"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "14"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", "15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", "16"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "11"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "16"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "17"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", "17"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "13"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "18"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "14"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "18"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "19"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"14", ",", "15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"14", ",", "19"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"14", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", "16"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", "21"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"16", ",", "17"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"16", ",", "21"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"16", ",", "22"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"17", ",", "22"}], "}"}]}], "}"}], "]"}]}], "]"}]], "Output",
 ImageSize->{568, 217},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->885504166]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"Graphics", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1245827832],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[
   NCache[{{1, 0}, {2, 0}, {3, 0}, {4, 0}, {5, 0}, {
     Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
     Rational[3, 2], Rational[1, 2] 3^Rational[1, 2]}, {
     Rational[5, 2], Rational[1, 2] 3^Rational[1, 2]}, {
     Rational[7, 2], Rational[1, 2] 3^Rational[1, 2]}, {
     Rational[9, 2], Rational[1, 2] 3^Rational[1, 2]}, {
     Rational[11, 2], Rational[1, 2] 3^Rational[1, 2]}, {
     0, 3^Rational[1, 2]}, {1, 3^Rational[1, 2]}, {2, 3^Rational[1, 2]}, {
     3, 3^Rational[1, 2]}, {4, 3^Rational[1, 2]}, {5, 3^Rational[1, 2]}, {
     Rational[1, 2], Rational[3, 2] 3^Rational[1, 2]}, {
     Rational[3, 2], Rational[3, 2] 3^Rational[1, 2]}, {
     Rational[5, 2], Rational[3, 2] 3^Rational[1, 2]}, {
     Rational[7, 2], Rational[3, 2] 3^Rational[1, 2]}, {
     Rational[9, 2], Rational[3, 2] 3^Rational[1, 2]}}, {{1, 0}, {2, 0}, {3, 
     0}, {4, 0}, {5, 0}, {0.5, 0.8660254037844386}, {1.5, 
     0.8660254037844386}, {2.5, 0.8660254037844386}, {3.5, 
     0.8660254037844386}, {4.5, 0.8660254037844386}, {5.5, 
     0.8660254037844386}, {0, 1.7320508075688772`}, {
     1, 1.7320508075688772`}, {2, 1.7320508075688772`}, {
     3, 1.7320508075688772`}, {4, 1.7320508075688772`}, {
     5, 1.7320508075688772`}, {0.5, 2.598076211353316}, {1.5, 
     2.598076211353316}, {2.5, 2.598076211353316}, {3.5, 2.598076211353316}, {
     4.5, 2.598076211353316}}], 
   LineBox[{{1, 6}, {1, 7}, {2, 7}, {2, 8}, {3, 8}, {3, 9}, {4, 9}, {4, 10}, {
    5, 10}, {5, 11}, {6, 7}, {6, 12}, {6, 13}, {7, 8}, {7, 13}, {7, 14}, {8, 
    9}, {8, 14}, {8, 15}, {9, 10}, {9, 15}, {9, 16}, {10, 11}, {10, 16}, {10, 
    17}, {11, 17}, {12, 13}, {12, 18}, {13, 14}, {13, 18}, {13, 19}, {14, 
    15}, {14, 19}, {14, 20}, {15, 16}, {15, 20}, {15, 21}, {16, 17}, {16, 
    21}, {16, 22}, {17, 22}}]]]], "Output",
 ImageSize->{184, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->606844252]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<NetImage\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1895575360],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 1, 0.85], EdgeForm[GrayLevel[0]], 
   GraphicsComplexBox[
    NCache[{{1, 0}, {2, 0}, {3, 0}, {4, 0}, {5, 0}, {
      Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      Rational[3, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      Rational[5, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      Rational[7, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      Rational[9, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      Rational[11, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      0, 3^Rational[1, 2]}, {1, 3^Rational[1, 2]}, {2, 3^Rational[1, 2]}, {
      3, 3^Rational[1, 2]}, {4, 3^Rational[1, 2]}, {5, 3^Rational[1, 2]}, {
      Rational[1, 2], Rational[3, 2] 3^Rational[1, 2]}, {
      Rational[3, 2], Rational[3, 2] 3^Rational[1, 2]}, {
      Rational[5, 2], Rational[3, 2] 3^Rational[1, 2]}, {
      Rational[7, 2], Rational[3, 2] 3^Rational[1, 2]}, {
      Rational[9, 2], Rational[3, 2] 3^Rational[1, 2]}}, {{1, 0}, {2, 0}, {3, 
      0}, {4, 0}, {5, 0}, {0.5, 0.8660254037844386}, {1.5, 
      0.8660254037844386}, {2.5, 0.8660254037844386}, {3.5, 
      0.8660254037844386}, {4.5, 0.8660254037844386}, {5.5, 
      0.8660254037844386}, {0, 1.7320508075688772`}, {
      1, 1.7320508075688772`}, {2, 1.7320508075688772`}, {
      3, 1.7320508075688772`}, {4, 1.7320508075688772`}, {
      5, 1.7320508075688772`}, {0.5, 2.598076211353316}, {1.5, 
      2.598076211353316}, {2.5, 2.598076211353316}, {3.5, 
      2.598076211353316}, {4.5, 2.598076211353316}}], 
    PolygonBox[{{7, 6, 1}, {13, 12, 6}, {8, 7, 2}, {14, 13, 7}, {9, 8, 3}, {
     15, 14, 8}, {10, 9, 4}, {16, 15, 9}, {11, 10, 5}, {17, 16, 10}, {6, 7, 
     13}, {12, 13, 18}, {7, 8, 14}, {13, 14, 19}, {8, 9, 15}, {14, 15, 20}, {
     9, 10, 16}, {15, 16, 21}, {10, 11, 17}, {16, 17, 22}}]]}]], "Output",
 ImageSize->{184, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->831503761]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1543450596],

Cell["Give the indices of the faces of a net of the icosahedron:", \
"ExampleText",
 CellID->1319194859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<NetFaceIndices\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1086823585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", "6", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "12", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "7", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "13", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "14", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "9", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "15", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "10", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "16", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "13", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "14", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "9", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "15", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "16", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "17", ",", "22"}], "}"}]}], "}"}]], "Output",
 ImageSize->{448, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1407620098]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1369592270],

Cell[TextData[{
 "Give the faces in a net of the octahedron as a ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2007553344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Octahedron\>\"", ",", "\"\<NetFaces\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1833474591],

Cell[BoxData[
 RowBox[{"GraphicsComplex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox[
        SqrtBox["3"], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "2"], ",", 
       FractionBox[
        SqrtBox["3"], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["5", "2"], ",", 
       FractionBox[
        SqrtBox["3"], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["7", "2"], ",", 
       FractionBox[
        SqrtBox["3"], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       SqrtBox["3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       SqrtBox["3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       SqrtBox["3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       SqrtBox["3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "2"], ",", 
       FractionBox[
        RowBox[{"3", " ", 
         SqrtBox["3"]}], "2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"7", ",", "6", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "7", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "7", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "10", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "3", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "8", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", "8", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "9", ",", "4"}], "}"}]}], "}"}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{451, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1191131734]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "LightYellow", ",", "%"}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->148094270],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 1, 0.85], EdgeForm[GrayLevel[0]], 
   GraphicsComplexBox[
    NCache[{{2, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      Rational[3, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      Rational[5, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      Rational[7, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      0, 3^Rational[1, 2]}, {1, 3^Rational[1, 2]}, {2, 3^Rational[1, 2]}, {
      3, 3^Rational[1, 2]}, {
      Rational[3, 2], Rational[3, 2] 3^Rational[1, 2]}}, {{2, 0}, {0.5, 
      0.8660254037844386}, {1.5, 0.8660254037844386}, {2.5, 
      0.8660254037844386}, {3.5, 0.8660254037844386}, {
      0, 1.7320508075688772`}, {1, 1.7320508075688772`}, {
      2, 1.7320508075688772`}, {3, 1.7320508075688772`}, {1.5, 
      2.598076211353316}}], 
    PolygonBox[{{7, 6, 2}, {3, 7, 2}, {8, 7, 3}, {8, 10, 7}, {4, 3, 1}, {4, 8,
      3}, {9, 8, 4}, {5, 9, 4}}]]}]], "Output",
 ImageSize->{184, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->508496004]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->721547675],

Cell["Show an image of the net of the dodecahedron:", "ExampleText",
 CellID->211619116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<NetImage\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->205545294],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->715331477]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["Skeleton Properties", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->960896114],

Cell["Give the vertices of a skeleton of the dodecahedron:", "ExampleText",
 CellID->703962558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<SkeletonCoordinates\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1058596989],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.548`"}], ",", "0.503`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.134`", ",", 
     RowBox[{"-", "0.368`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.957`"}], ",", 
     RowBox[{"-", "1.317`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.628`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.957`", ",", 
     RowBox[{"-", "1.317`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.548`", ",", "0.503`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.449`"}], ",", 
     RowBox[{"-", "1.995`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "2.466`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.489`"}], ",", 
     RowBox[{"-", "0.159`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.302`"}], ",", "0.416`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.449`", ",", 
     RowBox[{"-", "1.995`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.345`", ",", "0.761`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.489`", ",", 
     RowBox[{"-", "0.159`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.133`"}], ",", 
     RowBox[{"-", "0.369`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7`"}], ",", "0.965`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.345`"}], ",", "0.762`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "0.514`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.302`", ",", "0.416`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.001`"}], ",", 
     RowBox[{"-", "1.192`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7`", ",", "0.965`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{564, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1386841963]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1414367506],

Cell["Give an image of the dodecahedron skeleton graph:", "ExampleText",
 CellID->778184699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<SkeletonImage\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->774825863],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{-1.548, 0.503}, {-1.133, -0.369}, {-0.7, 
    0.965}, {-2.345, 0.762}, {1.134, -0.368}, {0.957, -1.317}, {1.548, 
    0.503}, {0.489, -0.159}, {-0.957, -1.317}, {-1.449, -1.995}, {-0.001, \
-1.192}, {0., 1.628}, {0., 2.466}, {0.7, 0.965}, {1.449, -1.995}, {2.345, 
    0.761}, {-0.489, -0.159}, {-0.302, 0.416}, {0., -0.514}, {0.302, 
    0.416}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {5, 6}, {5, 7}, {5, 8}, {6, 15}, {6, 
       11}, {7, 16}, {7, 14}, {8, 19}, {8, 20}, {9, 10}, {9, 2}, {9, 11}, {10,
        15}, {10, 4}, {12, 13}, {12, 3}, {12, 14}, {13, 16}, {13, 4}, {15, 
       16}, {17, 18}, {17, 2}, {17, 19}, {18, 3}, {18, 20}, {19, 11}, {20, 
       14}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "18"],
       Annotation[#, 18, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{-1.548, 0.503}, {-1.133, -0.369}, {-0.7, 
     0.965}, {-2.345, 0.762}, {1.134, -0.368}, {0.957, -1.317}, {1.548, 
     0.503}, {0.489, -0.159}, {-0.957, -1.317}, {-1.449, -1.995}, {-0.001, \
-1.192}, {0., 1.628}, {0., 2.466}, {0.7, 0.965}, {1.449, -1.995}, {2.345, 
     0.761}, {-0.489, -0.159}, {-0.302, 0.416}, {0., -0.514}, {0.302, 
     0.416}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2012851250]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->606987206],

Cell["Show an image of the dodecahedron skeleton graph:", "ExampleText",
 CellID->1086647992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<SkeletonRules\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1091867456],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "14"}], ",", 
   RowBox[{"1", "\[Rule]", "15"}], ",", 
   RowBox[{"1", "\[Rule]", "16"}], ",", 
   RowBox[{"2", "\[Rule]", "5"}], ",", 
   RowBox[{"2", "\[Rule]", "6"}], ",", 
   RowBox[{"2", "\[Rule]", "13"}], ",", 
   RowBox[{"3", "\[Rule]", "7"}], ",", 
   RowBox[{"3", "\[Rule]", "14"}], ",", 
   RowBox[{"3", "\[Rule]", "19"}], ",", 
   RowBox[{"4", "\[Rule]", "8"}], ",", 
   RowBox[{"4", "\[Rule]", "15"}], ",", 
   RowBox[{"4", "\[Rule]", "20"}], ",", 
   RowBox[{"5", "\[Rule]", "11"}], ",", 
   RowBox[{"5", "\[Rule]", "19"}], ",", 
   RowBox[{"6", "\[Rule]", "12"}], ",", 
   RowBox[{"6", "\[Rule]", "20"}], ",", 
   RowBox[{"7", "\[Rule]", "11"}], ",", 
   RowBox[{"7", "\[Rule]", "16"}], ",", 
   RowBox[{"8", "\[Rule]", "12"}], ",", 
   RowBox[{"8", "\[Rule]", "16"}], ",", 
   RowBox[{"9", "\[Rule]", "10"}], ",", 
   RowBox[{"9", "\[Rule]", "14"}], ",", 
   RowBox[{"9", "\[Rule]", "17"}], ",", 
   RowBox[{"10", "\[Rule]", "15"}], ",", 
   RowBox[{"10", "\[Rule]", "18"}], ",", 
   RowBox[{"11", "\[Rule]", "12"}], ",", 
   RowBox[{"13", "\[Rule]", "17"}], ",", 
   RowBox[{"13", "\[Rule]", "18"}], ",", 
   RowBox[{"17", "\[Rule]", "19"}], ",", 
   RowBox[{"18", "\[Rule]", "20"}]}], "}"}]], "Output",
 ImageSize->{509, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->681067559]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1900847868],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 1.0342527348870791`}, {0.5370050632835828, 
    0.08677977011618676}, {4.6213805515726847`*^-7, 1.9185691306886627`}, {
    0.7231612211338838, 1.7050449048778278`}, {3.249406778921892, 
    1.9213185583561643`}, {3.2497818915851875`, 1.036078334980985}, {
    2.711672209151447, 2.8683835168645415`}, {2.5255485430846036`, 
    1.2507325817355228`}, {1.625534308198128, 0.}, {1.6251586275473553`, 
    1.056099781461929}, {2.714348529155186, 0.0884146488869253}, {
    0.5352560643416142, 2.8667581732897958`}, {1.0906088294579104`, 
    2.658946307536393}, {1.6229453390361037`, 2.9565332054477778`}, {
    2.526221359742679, 1.7062675631483637`}, {2.1564305390408887`, 
    2.659594794458452}, {1.0924056373600841`, 0.29551318270093696`}, {
    0.7238166154680834, 1.248510670815506}, {2.158552346362523, 
    0.2968814541885918}, {1.624229514264738, 1.8999517756534923`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {5, 6}, {5, 7}, {5, 8}, {6, 15}, {6, 
       11}, {7, 16}, {7, 14}, {8, 19}, {8, 20}, {9, 10}, {9, 2}, {9, 11}, {10,
        15}, {10, 4}, {12, 13}, {12, 3}, {12, 14}, {13, 16}, {13, 4}, {15, 
       16}, {17, 18}, {17, 2}, {17, 19}, {18, 3}, {18, 20}, {19, 11}, {20, 
       14}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "18"],
       Annotation[#, 18, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.0342527348870791`}, {0.5370050632835828, 
     0.08677977011618676}, {4.6213805515726847`*^-7, 1.9185691306886627`}, {
     0.7231612211338838, 1.7050449048778278`}, {3.249406778921892, 
     1.9213185583561643`}, {3.2497818915851875`, 1.036078334980985}, {
     2.711672209151447, 2.8683835168645415`}, {2.5255485430846036`, 
     1.2507325817355228`}, {1.625534308198128, 0.}, {1.6251586275473553`, 
     1.056099781461929}, {2.714348529155186, 0.0884146488869253}, {
     0.5352560643416142, 2.8667581732897958`}, {1.0906088294579104`, 
     2.658946307536393}, {1.6229453390361037`, 2.9565332054477778`}, {
     2.526221359742679, 1.7062675631483637`}, {2.1564305390408887`, 
     2.659594794458452}, {1.0924056373600841`, 0.29551318270093696`}, {
     0.7238166154680834, 1.248510670815506}, {2.158552346362523, 
     0.2968814541885918}, {1.624229514264738, 1.8999517756534923`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->614625603]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", "%%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->329366504],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{1.9463013404285556`, 1.2122526693498756`, 
    2.4675433658702417`}, {2.580056864488837, 1.0543291290448331`, 
    1.710679041590274}, {1.192772445306157, 0.5605803710261589, 
    2.380099140682016}, {1.5710444949652203`, 2.134401549171035, 
    2.3684672710734906`}, {0.6511016464507654, 1.5055743806364512`, 0.}, {
    1.4045376443771662`, 2.1569701340568894`, 0.0869338480144779}, {
    0.016355555165383118`, 1.663851568019109, 0.7560148023770739}, {
    1.0263311314261494`, 0.5839181848868036, 0.09850305989219299}, {
    2.5971294021119276`, 1.8777498155175438`, 1.1438604586960284`}, {
    1.9735918265436188`, 2.545210318803979, 1.5507773173855197`}, {
    2.2458468503741456`, 1.6383964647065485`, 0.23906945276600833`}, {
    0.35178764449741706`, 1.0796516013317627`, 2.2277863588174975`}, {
    0.5852092614804696, 2.052156056696556, 2.2204764540618824`}, {0., 
    0.839795558725008, 1.3230475206263028`}, {1.236326843409997, 
    2.7178027107540665`, 0.8974203686429826}, {0.378459724025206, 
    2.4132011905759585`, 1.3108073862991496`}, {2.219320290726343, 
    0.3052439574536143, 1.1555315013514076`}, {1.3610525976449674`, 0., 
    1.5690361453767037`}, {2.0120510416808672`, 0.6664142874502431, 
    0.24632435188764212`}, {0.624042840618236, 0.17213070858999902`, 
    0.9159776847755893}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {5, 6}, {5, 7}, {5, 8}, {6, 15}, {6, 
       11}, {7, 16}, {7, 14}, {8, 19}, {8, 20}, {9, 10}, {9, 2}, {9, 11}, {10,
        15}, {10, 4}, {12, 13}, {12, 3}, {12, 14}, {13, 16}, {13, 4}, {15, 
       16}, {17, 18}, {17, 2}, {17, 19}, {18, 3}, {18, 20}, {19, 11}, {20, 
       14}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[5],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[8],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[9],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[10],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[11],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[12],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[14],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[15],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[16],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[17],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[18],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[19],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[20],
        "18"],
       Annotation[#, 18, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.9463013404285556`, 1.2122526693498756`, 
     2.4675433658702417`}, {2.580056864488837, 1.0543291290448331`, 
     1.710679041590274}, {1.192772445306157, 0.5605803710261589, 
     2.380099140682016}, {1.5710444949652203`, 2.134401549171035, 
     2.3684672710734906`}, {0.6511016464507654, 1.5055743806364512`, 0.}, {
     1.4045376443771662`, 2.1569701340568894`, 0.0869338480144779}, {
     0.016355555165383118`, 1.663851568019109, 0.7560148023770739}, {
     1.0263311314261494`, 0.5839181848868036, 0.09850305989219299}, {
     2.5971294021119276`, 1.8777498155175438`, 1.1438604586960284`}, {
     1.9735918265436188`, 2.545210318803979, 1.5507773173855197`}, {
     2.2458468503741456`, 1.6383964647065485`, 0.23906945276600833`}, {
     0.35178764449741706`, 1.0796516013317627`, 2.2277863588174975`}, {
     0.5852092614804696, 2.052156056696556, 2.2204764540618824`}, {0., 
     0.839795558725008, 1.3230475206263028`}, {1.236326843409997, 
     2.7178027107540665`, 0.8974203686429826}, {0.378459724025206, 
     2.4132011905759585`, 1.3108073862991496`}, {2.219320290726343, 
     0.3052439574536143, 1.1555315013514076`}, {1.3610525976449674`, 0., 
     1.5690361453767037`}, {2.0120510416808672`, 0.6664142874502431, 
     0.24632435188764212`}, {0.624042840618236, 0.17213070858999902`, 
     0.9159776847755893}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->616167551]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["Overall Properties", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->1011300983],

Cell["Duals of the Platonic solids:", "ExampleText",
 CellID->1750038923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rule", "@@@", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Platonic\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<StandardName\>\"", ",", "\"\<Dual\>\""}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1039098706],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"Cube\"\>", "\[Rule]", "\<\"Octahedron\"\>"}], ",", 
   RowBox[{"\<\"Dodecahedron\"\>", "\[Rule]", "\<\"Icosahedron\"\>"}], ",", 
   RowBox[{"\<\"Icosahedron\"\>", "\[Rule]", "\<\"Dodecahedron\"\>"}], ",", 
   RowBox[{"\<\"Octahedron\"\>", "\[Rule]", "\<\"Cube\"\>"}], ",", 
   RowBox[{"\<\"Tetrahedron\"\>", "\[Rule]", "\<\"Tetrahedron\"\>"}]}], 
  "}"}]], "Output",
 ImageSize->{502, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->761883823]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1788293711],

Cell["Classes of which the cube is a member:", "ExampleText",
 CellID->1818761012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<Classes\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->634097286],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Convex\"\>", ",", "\<\"Cuboid\"\>", ",", "\<\"Equilateral\"\>",
    ",", "\<\"Hypercube\"\>", ",", "\<\"Orthotope\"\>", 
   ",", "\<\"Platonic\"\>", ",", "\<\"Prism\"\>", 
   ",", "\<\"RectangularParallelepiped\"\>", ",", "\<\"Rhombohedron\"\>", 
   ",", "\<\"Rigid\"\>", ",", "\<\"SpaceFilling\"\>", ",", "\<\"Uniform\"\>", 
   ",", "\<\"Zonohedron\"\>"}], "}"}]], "Output",
 ImageSize->{571, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1683909747]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1881627647],

Cell["Notations describing the cube:", "ExampleText",
 CellID->671677407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<NotationRules\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1708130817],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"Uniform\"\>", "\[Rule]", "6"}], ",", 
   RowBox[{"\<\"WenningerModel\"\>", "\[Rule]", "3"}], ",", 
   RowBox[{"\<\"SchlaefliSymbol\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], ",", 
   RowBox[{"\<\"WythoffSymbol\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "3", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}]}], "}"}]], "Output",
 ImageSize->{382, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1931617663]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->709851449],

Cell["Show the symmetry group of the cube, encoded as a string:", \
"ExampleText",
 CellID->1201644258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Cube\>\"", ",", "\"\<SymmetryGroupString\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1098827818],

Cell[BoxData["\<\"Oh\"\>"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1187770342]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["Polyhedron Classes", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->968149549],

Cell["Chiral polyhedra:", "ExampleText",
 CellID->1475011863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<Chiral\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2120644120],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"GyroelongatedPentagonalBicupola\"\>", 
   ",", "\<\"GyroelongatedPentagonalBirotunda\"\>", 
   ",", "\<\"GyroelongatedPentagonalCupolarotunda\"\>", 
   ",", "\<\"GyroelongatedSquareBicupola\"\>", 
   ",", "\<\"GyroelongatedTriangularBicupola\"\>", 
   ",", "\<\"PentagonalHexecontahedron\"\>", 
   ",", "\<\"PentagonalIcositetrahedron\"\>", ",", "\<\"SnubCube\"\>", 
   ",", "\<\"SnubDodecahedron\"\>"}], "}"}]], "Output",
 ImageSize->{471, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1995639129]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"PolyhedronData", "[", 
     RowBox[{"#", ",", "\"\<Chiral\>\""}], "]"}], "&"}], "/@", "%"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->860468825],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1307242257]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->980874605],

Cell["Convex polyhedra:", "ExampleText",
 CellID->5923446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PolyhedronData", "[", "\"\<Convex\>\"", "]"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", "5"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->771109160],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "10"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "125", "\[RightSkeleton]"}], 
    ",", "\<\"TrigyrateRhombicosidodecahedron\"\>", 
    ",", "\<\"TruncatedCube\"\>", ",", "\<\"TruncatedDodecahedron\"\>", 
    ",", "\<\"TruncatedIcosahedron\"\>", ",", "\<\"TruncatedOctahedron\"\>", 
    ",", "\<\"TruncatedTetrahedron\"\>"}], "}"}],
  Short[#, 5]& ]], "Output",
 ImageSize->{496, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->2062904589]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->523421722],

Cell["Deltahedra:", "ExampleText",
 CellID->1055863542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<Deltahedron\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1241175233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Dipyramid\"\>", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dipyramid\"\>", ",", "5"}], "}"}], 
   ",", "\<\"GyroelongatedSquareDipyramid\"\>", ",", "\<\"Icosahedron\"\>", 
   ",", "\<\"MathematicaPolyhedron\"\>", ",", "\<\"Octahedron\"\>", 
   ",", "\<\"SnubDisphenoid\"\>", ",", "\<\"Tetrahedron\"\>", 
   ",", "\<\"TriaugmentedTriangularPrism\"\>"}], "}"}]], "Output",
 ImageSize->{427, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113946508]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1785547692],

Cell["Equilateral polyhedra:", "ExampleText",
 CellID->763576266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PolyhedronData", "[", "\"\<Equilateral\>\"", "]"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", "5"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64028190],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "10"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "118", "\[RightSkeleton]"}], 
    ",", "\<\"TrigyrateRhombicosidodecahedron\"\>", 
    ",", "\<\"TruncatedCube\"\>", ",", "\<\"TruncatedDodecahedron\"\>", 
    ",", "\<\"TruncatedIcosahedron\"\>", ",", "\<\"TruncatedOctahedron\"\>", 
    ",", "\<\"TruncatedTetrahedron\"\>"}], "}"}],
  Short[#, 5]& ]], "Output",
 ImageSize->{496, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->1691030479]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->288868343],

Cell["Zonohedra:", "ExampleText",
 CellID->1697198581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<Zonohedron\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1938751413],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Cube\"\>", ",", "\<\"GreatRhombicosidodecahedron\"\>", 
   ",", "\<\"GreatRhombicuboctahedron\"\>", 
   ",", "\<\"RhombicDodecahedron\"\>", ",", "\<\"RhombicTriacontahedron\"\>", 
   ",", "\<\"TruncatedOctahedron\"\>"}], "}"}]], "Output",
 ImageSize->{461, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1350676155]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["Polyhedron Classes", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->1269298691],

Cell["Archimedean duals:", "ExampleText",
 CellID->185407710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<ArchimedeanDual\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148610173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DeltoidalHexecontahedron\"\>", 
   ",", "\<\"DeltoidalIcositetrahedron\"\>", 
   ",", "\<\"DisdyakisDodecahedron\"\>", 
   ",", "\<\"DisdyakisTriacontahedron\"\>", 
   ",", "\<\"PentagonalHexecontahedron\"\>", 
   ",", "\<\"PentagonalIcositetrahedron\"\>", 
   ",", "\<\"PentakisDodecahedron\"\>", ",", "\<\"RhombicDodecahedron\"\>", 
   ",", "\<\"RhombicTriacontahedron\"\>", 
   ",", "\<\"SmallTriakisOctahedron\"\>", ",", "\<\"TetrakisHexahedron\"\>", 
   ",", "\<\"TriakisIcosahedron\"\>", ",", "\<\"TriakisTetrahedron\"\>"}], 
  "}"}]], "Output",
 ImageSize->{531, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1911988295]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Tooltip", "@@@", 
     RowBox[{"Rest", "/@", 
      RowBox[{"Sort", "[", 
       RowBox[{"PolyhedronData", "[", 
        RowBox[{"\"\<ArchimedeanDual\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<FaceCount\>\"", ",", "\"\<Image\>\"", ",", "\"\<Name\>\""}], 
          "}"}]}], "]"}], "]"}]}]}], ",", "5", ",", "5", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->970648186],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, 0, Rational[-5, 2] 6^Rational[-1, 2]}, {
             0, 0, Rational[1, 2] Rational[3, 2]^Rational[1, 2]}, {
             Rational[-5, 3] 3^Rational[-1, 2], 0, Rational[5, 6] 
              6^Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 2] 6^Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 2] 6^Rational[-1, 2]}, {
             Rational[5, 6] 3^Rational[-1, 2], Rational[-5, 6], 
              Rational[5, 6] 6^Rational[-1, 2]}, {
             Rational[5, 6] 3^Rational[-1, 2], Rational[5, 6], Rational[5, 6] 
              6^Rational[-1, 2]}, {
             3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}}, {{
             0, 0, -1.0206207261596576`}, {
             0, 0, 0.6123724356957945}, {-0.9622504486493765, 0, 
              0.3402069087198859}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
             0.48112522432468824`, -0.8333333333333334, 0.3402069087198859}, {
             0.48112522432468824`, 0.8333333333333334, 0.3402069087198859}, {
             0.5773502691896258, 0, -0.20412414523193154`}}], 
           Polygon3DBox[{{6, 4, 1}, {1, 5, 7}, {6, 3, 4}, {7, 5, 3}, {6, 2, 
            3}, {7, 3, 2}, {7, 2, 6}, {7, 6, 8}, {4, 3, 1}, {3, 5, 1}, {6, 1, 
            8}, {1, 7, 8}}]]],
         "\"triakis tetrahedron\""],
        Annotation[#, "triakis tetrahedron", "Tooltip"]& ],
       TraditionalForm], {195., -193.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{-Rational[2, 3]^Rational[1, 2], -
              Rational[2, 3]^Rational[1, 2], 0}, {-
              Rational[2, 3]^Rational[1, 2], 0, -3^Rational[-1, 2]}, {-
              Rational[2, 3]^Rational[1, 2], 0, 3^Rational[-1, 2]}, {-
              Rational[2, 3]^Rational[1, 2], Rational[2, 3]^Rational[1, 2], 
              0}, {0, -Rational[2, 3]^Rational[1, 2], -3^Rational[-1, 2]}, {
             0, -Rational[2, 3]^Rational[1, 2], 3^Rational[-1, 2]}, {
             0, 0, (-2) 3^Rational[-1, 2]}, {0, 0, 2 3^Rational[-1, 2]}, {
             0, Rational[2, 3]^Rational[1, 2], -3^Rational[-1, 2]}, {
             0, Rational[2, 3]^Rational[1, 2], 3^Rational[-1, 2]}, {
             Rational[2, 3]^Rational[1, 2], -Rational[2, 3]^Rational[1, 2], 
              0}, {Rational[2, 3]^Rational[1, 2], 0, -3^Rational[-1, 2]}, {
             Rational[2, 3]^Rational[1, 2], 0, 3^Rational[-1, 2]}, {
             Rational[2, 3]^Rational[1, 2], Rational[2, 3]^Rational[1, 2], 
              0}}, {{-0.816496580927726, -0.816496580927726, 
              0}, {-0.816496580927726, 
              0, -0.5773502691896258}, {-0.816496580927726, 0, 
              0.5773502691896258}, {-0.816496580927726, 0.816496580927726, 
              0}, {0, -0.816496580927726, -0.5773502691896258}, {
             0, -0.816496580927726, 0.5773502691896258}, {
             0, 0, -1.1547005383792517`}, {0, 0, 1.1547005383792517`}, {
             0, 0.816496580927726, -0.5773502691896258}, {
             0, 0.816496580927726, 0.5773502691896258}, {
             0.816496580927726, -0.816496580927726, 0}, {
             0.816496580927726, 0, -0.5773502691896258}, {
             0.816496580927726, 0, 0.5773502691896258}, {
             0.816496580927726, 0.816496580927726, 0}}], 
           Polygon3DBox[{{2, 1, 3, 4}, {1, 2, 7, 5}, {6, 8, 3, 1}, {2, 4, 9, 
            7}, {8, 10, 4, 3}, {11, 6, 1, 5}, {9, 4, 10, 14}, {5, 7, 12, 
            11}, {11, 13, 8, 6}, {7, 9, 14, 12}, {13, 14, 10, 8}, {14, 13, 11,
             12}}]]],
         "\"rhombic dodecahedron\""],
        Annotation[#, "rhombic dodecahedron", "Tooltip"]& ],
       TraditionalForm], {585., -193.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
             Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
             0, 0, Rational[-1, 2] - 2^Rational[-1, 2]}, {
             0, 0, Rational[1, 2] + 2^Rational[-1, 2]}, {
             0, Rational[-1, 2] - 2^Rational[-1, 2], 0}, {
             0, Rational[1, 2] + 2^Rational[-1, 2], 0}, {
             Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
             Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {
             Rational[-1, 2] - 2^Rational[-1, 2], 0, 0}, {
             Rational[1, 2] + 2^Rational[-1, 2], 0, 
              0}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
             0.5, -0.5}, {-0.5, 0.5, 0.5}, {0, 0, -1.2071067811865475`}, {
             0, 0, 1.2071067811865475`}, {0, -1.2071067811865475`, 0}, {
             0, 1.2071067811865475`, 0}, {0.5, -0.5, -0.5}, {0.5, -0.5, 
             0.5}, {0.5, 0.5, -0.5}, {0.5, 0.5, 
             0.5}, {-1.2071067811865475`, 0, 0}, {
             1.2071067811865475`, 0, 0}}], 
           Polygon3DBox[{{6, 8, 4}, {3, 8, 5}, {7, 6, 2}, {1, 5, 7}, {12, 8, 
            6}, {5, 8, 11}, {10, 6, 7}, {7, 5, 9}, {14, 6, 10}, {9, 5, 14}, {
            14, 12, 6}, {5, 11, 14}, {11, 8, 14}, {14, 8, 12}, {7, 9, 14}, {
            14, 10, 7}, {6, 13, 2}, {1, 13, 5}, {6, 4, 13}, {13, 3, 5}, {3, 
            13, 8}, {8, 13, 4}, {13, 1, 7}, {7, 2, 13}}]]],
         "\"small triakis octahedron\""],
        Annotation[#, "small triakis octahedron", "Tooltip"]& ],
       TraditionalForm], {975., -193.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{Rational[-2, 3] 2^Rational[1, 2], 0, Rational[-2, 3]}, {
             Rational[-2, 3] 2^Rational[1, 2], 0, Rational[
              2, 3]}, {-2^Rational[-1, 2], -2^Rational[-1, 2], 
              0}, {-2^Rational[-1, 2], 2^Rational[-1, 2], 0}, {
             0, Rational[-2, 3] 2^Rational[1, 2], Rational[-2, 3]}, {
             0, Rational[-2, 3] 2^Rational[1, 2], Rational[2, 3]}, {0, 
             0, -1}, {0, 0, 1}, {
             0, Rational[2, 3] 2^Rational[1, 2], Rational[-2, 3]}, {
             0, Rational[2, 3] 2^Rational[1, 2], Rational[2, 3]}, {
             2^Rational[-1, 2], -2^Rational[-1, 2], 0}, {
             2^Rational[-1, 2], 2^Rational[-1, 2], 0}, {
             Rational[2, 3] 2^Rational[1, 2], 0, Rational[-2, 3]}, {
             Rational[2, 3] 2^Rational[1, 2], 0, Rational[
              2, 3]}}, {{-0.9428090415820634, 
              0, -0.6666666666666666}, {-0.9428090415820634, 0, 
              0.6666666666666666}, {-0.7071067811865475, -0.7071067811865475, 
              0}, {-0.7071067811865475, 0.7071067811865475, 0}, {
             0, -0.9428090415820634, -0.6666666666666666}, {
             0, -0.9428090415820634, 0.6666666666666666}, {0, 0, -1}, {0, 0, 
             1}, {0, 0.9428090415820634, -0.6666666666666666}, {
             0, 0.9428090415820634, 0.6666666666666666}, {
             0.7071067811865475, -0.7071067811865475, 0}, {
             0.7071067811865475, 0.7071067811865475, 0}, {
             0.9428090415820634, 0, -0.6666666666666666}, {
             0.9428090415820634, 0, 0.6666666666666666}}], 
           Polygon3DBox[{{3, 2, 1}, {1, 2, 4}, {3, 1, 5}, {6, 2, 3}, {1, 4, 
            9}, {10, 4, 2}, {5, 6, 3}, {1, 7, 5}, {6, 8, 2}, {1, 9, 7}, {8, 
            10, 2}, {4, 10, 9}, {11, 6, 5}, {5, 7, 13}, {14, 8, 6}, {7, 9, 
            13}, {14, 10, 8}, {9, 10, 12}, {11, 5, 13}, {14, 6, 11}, {9, 12, 
            13}, {14, 12, 10}, {13, 14, 11}, {12, 14, 13}}]]],
         "\"tetrakis hexahedron\""],
        Annotation[#, "tetrakis hexahedron", "Tooltip"]& ],
       TraditionalForm], {1365., -193.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 0}, {
             Rational[-1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[-1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 0}, {
             0, Rational[-1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2]}, {
             0, Rational[-1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2]}, {
             0, 0, Rational[-1, 2] (10 + 2^Rational[1, 2])^Rational[1, 2]}, {
             0, 0, Rational[1, 2] (10 + 2^Rational[1, 2])^Rational[1, 2]}, {
             0, Rational[1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2]}, {
             0, Rational[1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2]}, {
             0, Rational[-1, 2] (10 + 2^Rational[1, 2])^Rational[1, 2], 0}, {
             0, Rational[1, 2] (10 + 2^Rational[1, 2])^Rational[1, 2], 0}, {
             Rational[1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 0}, {
             Rational[1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[-1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (5 + 2^Rational[-1, 2])^Rational[1, 2], 0}, {
             Rational[-1, 2] (10 + 2^Rational[1, 2])^Rational[1, 2], 0, 0}, {
             Rational[1, 2] (10 + 2^Rational[1, 2])^Rational[1, 2], 0, 0}, {
             Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2] (2 + 2^Rational[1, 2])^
               Rational[1, 2]}}, {{-1.1944775825843852`, -1.1944775825843852`,
               0}, {-1.1944775825843852`, 
              0, -1.1944775825843852`}, {-1.1944775825843852`, 0, 
              1.1944775825843852`}, {-1.1944775825843852`, 
              1.1944775825843852`, 0}, {
             0, -1.1944775825843852`, -1.1944775825843852`}, {
             0, -1.1944775825843852`, 1.1944775825843852`}, {
             0, 0, -1.6892463972414664`}, {0, 0, 1.6892463972414664`}, {
             0, 1.1944775825843852`, -1.1944775825843852`}, {
             0, 1.1944775825843852`, 1.1944775825843852`}, {
             0, -1.6892463972414664`, 0}, {0, 1.6892463972414664`, 0}, {
             1.1944775825843852`, -1.1944775825843852`, 0}, {
             1.1944775825843852`, 0, -1.1944775825843852`}, {
             1.1944775825843852`, 0, 1.1944775825843852`}, {
             1.1944775825843852`, 1.1944775825843852`, 
              0}, {-1.6892463972414664`, 0, 0}, {1.6892463972414664`, 0, 0}, {
             0.9238795325112867, 0.9238795325112867, 0.9238795325112867}, {
             0.9238795325112867, 0.9238795325112867, -0.9238795325112867}, {
             0.9238795325112867, -0.9238795325112867, 0.9238795325112867}, {
             0.9238795325112867, -0.9238795325112867, -0.9238795325112867}, \
{-0.9238795325112867, 0.9238795325112867, 
             0.9238795325112867}, {-0.9238795325112867, 
             0.9238795325112867, -0.9238795325112867}, {-0.9238795325112867, \
-0.9238795325112867, 
             0.9238795325112867}, {-0.9238795325112867, -0.9238795325112867, \
-0.9238795325112867}}], 
           Polygon3DBox[{{26, 2, 7, 5}, {6, 8, 3, 25}, {2, 24, 9, 7}, {8, 10, 
            23, 3}, {1, 26, 5, 11}, {11, 6, 25, 1}, {24, 4, 12, 9}, {10, 12, 
            4, 23}, {22, 5, 7, 14}, {15, 8, 6, 21}, {7, 9, 20, 14}, {15, 19, 
            10, 8}, {11, 5, 22, 13}, {13, 21, 6, 11}, {20, 9, 12, 16}, {16, 
            12, 10, 19}, {1, 17, 2, 26}, {25, 3, 17, 1}, {2, 17, 4, 24}, {23, 
            4, 17, 3}, {13, 22, 14, 18}, {18, 15, 21, 13}, {14, 20, 16, 18}, {
            18, 16, 19, 15}}]]],
         "\"deltoidal icositetrahedron\""],
        Annotation[#, "deltoidal icositetrahedron", "Tooltip"]& ],
       TraditionalForm], {1755., -193.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, 0, Root[-1 - 4 #^2 - 336 #^4 + 64 #^6& , 1, 0]}, {
             0, 0, Root[-1 - 4 #^2 - 336 #^4 + 64 #^6& , 2, 0]}, {
             0, Root[-1 - 4 #^2 - 336 #^4 + 64 #^6& , 1, 0], 0}, {
             0, Root[-1 - 4 #^2 - 336 #^4 + 64 #^6& , 2, 0], 0}, {
             Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 1, 0]}, {
             Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 2, 0]}, {
             Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0]}, {
             Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0]}, {
             Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 2, 0]}, {
             Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 1, 0]}, {
             Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0]}, {
             Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0]}, {
             Root[-1 - 4 #^2 - 336 #^4 + 64 #^6& , 1, 0], 0, 0}, {
             Root[-1 - 4 #^2 - 336 #^4 + 64 #^6& , 2, 0], 0, 0}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 2, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 1, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 1, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 1, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 2, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 2, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 1, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 2, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 1, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 2, 0]}, {
             Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 2, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 1, 0]}, {
             Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 1, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0]}, {
             Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 1, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0]}, {
             Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 2, 0]}, {
             Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 1, 0]}, {
             Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 2, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 1, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0]}, {
             Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 2, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0]}, {
             Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 1, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 1, 0]}, {
             Root[-1 + 4 #^2 + 16 #^4 + 64 #^6& , 2, 0], 
              Root[-1 + 20 #^2 - 112 #^4 + 64 #^6& , 2, 0], 
              Root[-49 + 164 #^2 - 240 #^4 + 64 #^6& , 2, 0]}}, {{
             0, 0, -2.294001053686955}, {0, 0, 2.294001053686955}, {
             0, -2.294001053686955, 0}, {
             0, 2.294001053686955, 
              0}, {-1.724879418506459, -1.2472231679936434`, \
-0.36867635288016376`}, {-1.724879418506459, 1.2472231679936434`, 
             0.3686763528801638}, {-1.724879418506459, -0.36867635288016376`, 
             1.2472231679936434`}, {-1.724879418506459, 
             0.3686763528801638, -1.2472231679936434`}, {
             1.724879418506459, -1.2472231679936434`, 0.3686763528801638}, {
             1.724879418506459, 1.2472231679936434`, -0.36867635288016376`}, {
             1.724879418506459, -0.36867635288016376`, -1.2472231679936434`}, \
{1.724879418506459, 0.3686763528801638, 
             1.2472231679936434`}, {-2.294001053686955, 0, 0}, {
             2.294001053686955, 0, 
              0}, {-1.2472231679936434`, -1.724879418506459, 
             0.3686763528801638}, {-1.2472231679936434`, 
             1.724879418506459, -0.36867635288016376`}, \
{-1.2472231679936434`, -1.2472231679936434`, -1.2472231679936434`}, \
{-1.2472231679936434`, -1.2472231679936434`, 
             1.2472231679936434`}, {-1.2472231679936434`, 
             1.2472231679936434`, -1.2472231679936434`}, \
{-1.2472231679936434`, 1.2472231679936434`, 
             1.2472231679936434`}, {-1.2472231679936434`, \
-0.36867635288016376`, -1.724879418506459}, {-1.2472231679936434`, 
             0.3686763528801638, 1.724879418506459}, {
             1.2472231679936434`, -1.724879418506459, -0.36867635288016376`}, \
{1.2472231679936434`, 1.724879418506459, 0.3686763528801638}, {
             1.2472231679936434`, -1.2472231679936434`, \
-1.2472231679936434`}, {1.2472231679936434`, -1.2472231679936434`, 
             1.2472231679936434`}, {1.2472231679936434`, 
             1.2472231679936434`, -1.2472231679936434`}, {1.2472231679936434`,
              1.2472231679936434`, 1.2472231679936434`}, {
             1.2472231679936434`, -0.36867635288016376`, 1.724879418506459}, {
             1.2472231679936434`, 
             0.3686763528801638, -1.724879418506459}, {-0.36867635288016376`, \
-1.724879418506459, -1.2472231679936434`}, {-0.36867635288016376`, 
             1.724879418506459, 
             1.2472231679936434`}, {-0.36867635288016376`, \
-1.2472231679936434`, 1.724879418506459}, {-0.36867635288016376`, 
             1.2472231679936434`, -1.724879418506459}, {
             0.3686763528801638, -1.724879418506459, 1.2472231679936434`}, {
             0.3686763528801638, 1.724879418506459, -1.2472231679936434`}, {
             0.3686763528801638, -1.2472231679936434`, -1.724879418506459}, {
             0.3686763528801638, 1.2472231679936434`, 1.724879418506459}}], 
           Polygon3DBox[{{5, 13, 8, 21, 17}, {22, 20, 6, 13, 7}, {15, 18, 7, 
            13, 5}, {8, 13, 6, 16, 19}, {14, 12, 29, 26, 9}, {11, 30, 27, 10, 
            14}, {9, 23, 25, 11, 14}, {14, 10, 24, 28, 12}, {35, 33, 18, 15, 
            3}, {34, 19, 16, 4, 36}, {31, 17, 21, 1, 37}, {38, 32, 20, 22, 
            2}, {3, 31, 37, 25, 23}, {28, 24, 4, 32, 38}, {26, 29, 2, 33, 
            35}, {1, 34, 36, 27, 30}, {15, 5, 17, 31, 3}, {4, 16, 6, 20, 
            32}, {2, 22, 7, 18, 33}, {21, 8, 19, 34, 1}, {9, 26, 35, 3, 23}, {
            27, 36, 4, 24, 10}, {25, 37, 1, 30, 11}, {12, 28, 38, 2, 29}}]]],
         "\"pentagonal icositetrahedron\""],
        Annotation[#, "pentagonal icositetrahedron", "Tooltip"]& ],
       TraditionalForm], {195., -580.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, 0, Rational[1, 2] (-1 - 5^Rational[1, 2])}, {
             0, 0, Rational[1, 2] (1 + 5^Rational[1, 2])}, {
             Rational[1, 10] (5 - 5^Rational[1, 2]), Root[
              1 - 5 #^2 + 5 #^4& , 1, 0], 
              Rational[1, 10] (5 + 3 5^Rational[1, 2])}, {
             Rational[1, 10] (5 - 5^Rational[1, 2]), (
               Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
              Rational[1, 10] (5 + 3 5^Rational[1, 2])}, {
             2 5^Rational[-1, 2], 0, 
              Rational[1, 10] (5 + 3 5^Rational[1, 2])}, {
             Rational[1, 10] (5 + 3 5^Rational[1, 2]), Root[
              1 - 5 #^2 + 5 #^4& , 1, 0], 
              Rational[1, 10] (5 + 5^Rational[1, 2])}, {
             Rational[1, 10] (5 + 3 5^Rational[1, 2]), Root[
              1 - 5 #^2 + 5 #^4& , 1, 0], 
              Rational[1, 10] (-5 + 5^Rational[1, 2])}, {
             Rational[1, 10] (5 + 3 5^Rational[1, 2]), (
               Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
              Rational[1, 10] (5 + 5^Rational[1, 2])}, {
             Rational[1, 10] (5 + 3 5^Rational[1, 2]), (
               Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
              Rational[1, 10] (-5 + 5^Rational[1, 2])}, {(-2) 
              5^Rational[-1, 2], 0, 
              Rational[1, 10] (-5 - 3 5^Rational[1, 2])}, {-5^
               Rational[-1, 2], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 10] (5 + 5^Rational[1, 2])}, {-5^
               Rational[-1, 2], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 10] (-5 + 5^Rational[1, 2])}, {-5^Rational[-1, 2], (
               1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 10] (5 + 5^Rational[1, 2])}, {-5^Rational[-1, 2], (
               1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 10] (-5 + 5^Rational[1, 2])}, {
             5^Rational[-1, 2], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 10] (5 - 5^Rational[1, 2])}, {
             5^Rational[-1, 2], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 10] (-5 - 5^Rational[1, 2])}, {
             5^Rational[-1, 2], (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 10] (5 - 5^Rational[1, 2])}, {
             5^Rational[-1, 2], (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 10] (-5 - 5^Rational[1, 2])}, {-1 - 5^
              Rational[-1, 2], 0, 
              Rational[1, 10] (5 + 5^Rational[1, 2])}, {-1 - 5^
              Rational[-1, 2], 0, Rational[1, 10] (-5 + 5^Rational[1, 2])}, {
             Rational[1, 10] (-5 - 5^Rational[1, 2]), Root[
              1 - 5 #^2 + 5 #^4& , 2, 0], 
              Rational[1, 10] (5 + 3 5^Rational[1, 2])}, {
             Rational[1, 10] (-5 - 5^Rational[1, 2]), (2/(5 + 
               5^Rational[1, 2]))^Rational[1, 2], 
              Rational[1, 10] (5 + 3 5^Rational[1, 2])}, {
             Rational[1, 10] (5 + 5^Rational[1, 2]), Root[
              1 - 5 #^2 + 5 #^4& , 2, 0], 
              Rational[1, 10] (-5 - 3 5^Rational[1, 2])}, {
             Rational[1, 10] (5 + 5^Rational[1, 2]), (2/(5 + 
               5^Rational[1, 2]))^Rational[1, 2], 
              Rational[1, 10] (-5 - 3 5^Rational[1, 2])}, {
             1 + 5^Rational[-1, 2], 0, 
              Rational[1, 10] (5 - 5^Rational[1, 2])}, {
             1 + 5^Rational[-1, 2], 0, 
              Rational[1, 10] (-5 - 5^Rational[1, 2])}, {
             Rational[1, 10] (-5 - 3 5^Rational[1, 2]), Root[
              1 - 5 #^2 + 5 #^4& , 1, 0], 
              Rational[1, 10] (5 - 5^Rational[1, 2])}, {
             Rational[1, 10] (-5 - 3 5^Rational[1, 2]), Root[
              1 - 5 #^2 + 5 #^4& , 1, 0], 
              Rational[1, 10] (-5 - 5^Rational[1, 2])}, {
             Rational[1, 10] (-5 - 3 5^Rational[1, 2]), (
               Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
              Rational[1, 10] (5 - 5^Rational[1, 2])}, {
             Rational[1, 10] (-5 - 3 5^Rational[1, 2]), (
               Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
              Rational[1, 10] (-5 - 5^Rational[1, 2])}, {
             Rational[1, 10] (-5 + 5^Rational[1, 2]), Root[
              1 - 5 #^2 + 5 #^4& , 1, 0], 
              Rational[1, 10] (-5 - 3 5^Rational[1, 2])}, {
             Rational[1, 10] (-5 + 5^Rational[1, 2]), (
               Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
              Rational[1, 10] (-5 - 3 5^Rational[1, 2])}}, {{
             0, 0, -1.618033988749895}, {0, 0, 1.618033988749895}, {
             0.276393202250021, -0.8506508083520394, 1.170820393249937}, {
             0.276393202250021, 0.85065080835204, 1.170820393249937}, {
             0.8944271909999159, 0, 1.170820393249937}, {
             1.170820393249937, -0.8506508083520394, 0.723606797749979}, {
             1.170820393249937, -0.8506508083520394, -0.276393202250021}, {
             1.170820393249937, 0.85065080835204, 0.723606797749979}, {
             1.170820393249937, 
             0.85065080835204, -0.276393202250021}, {-0.8944271909999159, 
              0, -1.170820393249937}, {-0.4472135954999579, \
-1.3763819204711736`, 
             0.723606797749979}, {-0.4472135954999579, -1.3763819204711736`, \
-0.276393202250021}, {-0.4472135954999579, 1.3763819204711736`, 
             0.723606797749979}, {-0.4472135954999579, 
             1.3763819204711736`, -0.276393202250021}, {
             0.4472135954999579, -1.3763819204711736`, 0.276393202250021}, {
             0.4472135954999579, -1.3763819204711736`, -0.723606797749979}, {
             0.4472135954999579, 1.3763819204711736`, 0.276393202250021}, {
             0.4472135954999579, 
             1.3763819204711736`, -0.723606797749979}, {-1.4472135954999579`, 
              0, 0.723606797749979}, {-1.4472135954999579`, 
              0, -0.276393202250021}, {-0.723606797749979, \
-0.5257311121191341, 1.170820393249937}, {-0.723606797749979, 
             0.5257311121191336, 1.170820393249937}, {
             0.723606797749979, -0.5257311121191341, -1.170820393249937}, {
             0.723606797749979, 0.5257311121191336, -1.170820393249937}, {
             1.4472135954999579`, 0, 0.276393202250021}, {
             1.4472135954999579`, 
              0, -0.723606797749979}, {-1.170820393249937, \
-0.8506508083520394, 
             0.276393202250021}, {-1.170820393249937, -0.8506508083520394, \
-0.723606797749979}, {-1.170820393249937, 0.85065080835204, 
             0.276393202250021}, {-1.170820393249937, 
             0.85065080835204, -0.723606797749979}, {-0.276393202250021, \
-0.8506508083520394, -1.170820393249937}, {-0.276393202250021, 
             0.85065080835204, -1.170820393249937}}], 
           Polygon3DBox[{{16, 15, 11, 12}, {14, 13, 17, 18}, {10, 28, 20, 
            30}, {8, 5, 6, 25}, {12, 28, 31, 16}, {32, 30, 14, 18}, {6, 3, 11,
             15}, {8, 17, 13, 4}, {11, 21, 19, 27}, {13, 29, 19, 22}, {7, 16, 
            23, 26}, {24, 18, 9, 26}, {12, 11, 27, 28}, {30, 29, 13, 14}, {7, 
            6, 15, 16}, {18, 17, 8, 9}, {2, 22, 19, 21}, {23, 1, 24, 26}, {3, 
            2, 21, 11}, {4, 13, 22, 2}, {16, 31, 1, 23}, {1, 32, 18, 24}, {31,
             28, 10, 1}, {10, 30, 32, 1}, {6, 5, 2, 3}, {8, 4, 2, 5}, {28, 27,
             19, 20}, {20, 19, 29, 30}, {26, 25, 6, 7}, {9, 8, 25, 26}}]]],
         "\"rhombic triacontahedron\""],
        Annotation[#, "rhombic triacontahedron", "Tooltip"]& ],
       TraditionalForm], {585., -580.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2]}, {
             0, Rational[-1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2]}, {
             0, Rational[1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2]}, {
             0, Rational[-1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 0}, {
             7 (60 - 6 2^Rational[1, 2])^Rational[-1, 2], 
              7 (60 - 6 2^Rational[1, 2])^Rational[-1, 2], 
              7 (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2]}, {(-7) (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2], (-7) (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2], (-7) (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2]}, {
             Rational[-1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[-1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 0}, {
             7 (60 - 6 2^Rational[1, 2])^Rational[-1, 2], 
              7 (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2], (-7) (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2]}, {
             7 (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2], (-7) (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2], 
              7 (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2]}, {(-7) (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2], 7 (60 - 6 2^Rational[1, 2])^Rational[-1, 2], 
              7 (60 - 6 2^Rational[1, 2])^Rational[-1, 2]}, {
             7 (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2], (-7) (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2], (-7) (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2]}, {(-7) (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2], 
              7 (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2], (-7) (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2]}, {(-7) (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2], (-7) (60 - 6 2^Rational[1, 2])^
               Rational[-1, 2], 
              7 (60 - 6 2^Rational[1, 2])^Rational[-1, 2]}, {
             Rational[1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[-1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 0}, {
             Rational[-1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (3 + 3 2^Rational[-1, 2])^Rational[1, 2], 0}, {
             Rational[-1, 14] (366 + 213 2^Rational[1, 2])^Rational[1, 2], 0, 
              0}, {0, Rational[-1, 14] (366 + 213 2^Rational[1, 2])^
               Rational[1, 2], 0}, {
             0, 0, Rational[-1, 14] (366 + 213 2^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[1, 14] (366 + 213 2^Rational[1, 2])^Rational[1, 2], 0, 
              0}, {0, Rational[1, 14] (366 + 213 2^Rational[1, 2])^
               Rational[1, 2], 0}, {
             0, 0, Rational[1, 14] (366 + 213 2^Rational[1, 2])^
               Rational[1, 2]}}, {{
             0, 1.1315167192268571`, 1.1315167192268571`}, {
             0, -1.1315167192268571`, -1.1315167192268571`}, {
             0, 1.1315167192268571`, -1.1315167192268571`}, {
             0, -1.1315167192268571`, 1.1315167192268571`}, {
             1.1315167192268571`, 0, 1.1315167192268571`}, {
             1.1315167192268571`, 1.1315167192268571`, 0}, {0.975286862174966,
              0.975286862174966, 
             0.975286862174966}, {-0.975286862174966, -0.975286862174966, \
-0.975286862174966}, {-1.1315167192268571`, 
              0, -1.1315167192268571`}, {-1.1315167192268571`, \
-1.1315167192268571`, 0}, {0.975286862174966, 
             0.975286862174966, -0.975286862174966}, {
             0.975286862174966, -0.975286862174966, 
             0.975286862174966}, {-0.975286862174966, 0.975286862174966, 
             0.975286862174966}, {
             0.975286862174966, -0.975286862174966, -0.975286862174966}, \
{-0.975286862174966, 
             0.975286862174966, -0.975286862174966}, {-0.975286862174966, \
-0.975286862174966, 0.975286862174966}, {
             1.1315167192268571`, 0, -1.1315167192268571`}, {
             1.1315167192268571`, -1.1315167192268571`, 
              0}, {-1.1315167192268571`, 0, 
              1.1315167192268571`}, {-1.1315167192268571`, 
              1.1315167192268571`, 0}, {-1.8450533546644432`, 0, 0}, {
             0, -1.8450533546644432`, 0}, {0, 0, -1.8450533546644432`}, {
             1.8450533546644432`, 0, 0}, {0, 1.8450533546644432`, 0}, {
             0, 0, 1.8450533546644432`}}], 
           Polygon3DBox[{{15, 3, 23}, {26, 1, 13}, {2, 8, 23}, {26, 16, 4}, {
            22, 4, 16}, {8, 2, 22}, {25, 13, 1}, {3, 15, 25}, {23, 3, 11}, {7,
             1, 26}, {2, 23, 14}, {12, 26, 4}, {12, 4, 22}, {22, 2, 14}, {7, 
            25, 1}, {3, 25, 11}, {14, 23, 17}, {5, 26, 12}, {23, 11, 17}, {5, 
            7, 26}, {22, 14, 18}, {18, 12, 22}, {11, 25, 6}, {6, 25, 7}, {8, 
            9, 23}, {26, 19, 16}, {9, 15, 23}, {26, 13, 19}, {10, 8, 22}, {22,
             16, 10}, {15, 20, 25}, {25, 20, 13}, {16, 19, 21}, {21, 9, 8}, {
            13, 21, 19}, {9, 21, 15}, {21, 20, 15}, {13, 20, 21}, {10, 21, 
            8}, {16, 21, 10}, {24, 5, 12}, {14, 17, 24}, {24, 7, 5}, {17, 11, 
            24}, {11, 6, 24}, {24, 6, 7}, {18, 14, 24}, {24, 12, 18}}]]],
         "\"disdyakis dodecahedron\""],
        Annotation[#, "disdyakis dodecahedron", "Tooltip"]& ],
       TraditionalForm], {975., -580.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, 0, (Rational[13, 8] + Rational[19, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {
             Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
               Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
               Rational[11, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
              Rational[1, 2], 
              0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {
             0, 0, -(Rational[13, 8] + Rational[19, 8] 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
              1 - 100 #^2 + 80 #^4& , 1, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
              1 - 100 #^2 + 80 #^4& , 1, 0]}, {
             Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
             Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
             Root[1 - 5 #^2 + 5 #^4& , 1, 0], 0, Root[
              1 - 100 #^2 + 80 #^4& , 1, 0]}, {
             Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], (Rational[5, 8] + 
               Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[
              1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[5, 8] + 
               Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[5, 8] + 
               Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 2, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 2, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 2, 0]}, {(1 + 2 5^Rational[-1, 2])^
              Rational[1, 2], 0, Root[
              1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 3, 0]}, {
             Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 3, 0]}, {
             Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[29, 40] + 
               Rational[61, 40] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-3, 4] + 
              Rational[-1, 4] 5^Rational[-1, 2], (Rational[13, 40] + 
               Rational[19, 40] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[29, 40] + 
               Rational[61, 40] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 20] (15 + 5^Rational[1, 2]), (Rational[13, 40] + 
               Rational[19, 40] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 5] (Rational[1, 2] (65 + 19 5^Rational[1, 2]))^
               Rational[1, 2], 
              0, (Rational[13, 40] + Rational[19, 40] 5^Rational[-1, 2])^
              Rational[1, 2]}, {
             Rational[-1, 10] (25 - 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2] - 2 
              5^Rational[-1, 2], (Rational[13, 40] + 
               Rational[19, 40] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 10] (25 - 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2] + 
              2 5^Rational[-1, 2], (Rational[13, 40] + 
               Rational[19, 40] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[13, 10] + 
               Rational[19, 10] 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[-1, 10] (Rational[1, 2] (65 + 19 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[29, 40] + 
                Rational[61, 40] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-3, 4] + Rational[-1, 4] 5^Rational[-1, 2], 
              Rational[-1, 10] (Rational[1, 2] (65 + 19 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[29, 40] + 
                Rational[61, 40] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 20] (15 + 5^Rational[1, 2]), 
              Rational[-1, 10] (Rational[1, 2] (65 + 19 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[1, 10] (25 - 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2] - 2 5^Rational[-1, 2], 
              Rational[-1, 10] (Rational[1, 2] (65 + 19 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[1, 10] (25 - 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2] + 2 5^Rational[-1, 2], 
              Rational[-1, 10] (Rational[1, 2] (65 + 19 5^Rational[1, 2]))^
               Rational[1, 2]}}, {{0, 0, 1.6392474765307403`}, {
             0.2628655560595668, -0.8090169943749475, 1.1135163644116066`}, {
             0.2628655560595668, 0.8090169943749475, 1.1135163644116066`}, {
             0.85065080835204, 0, 1.1135163644116066`}, {
             0, 0, -1.6392474765307403`}, {-0.2628655560595671, \
-0.8090169943749475, -1.1135163644116068`}, {-0.2628655560595671, 
             0.8090169943749475, -1.1135163644116068`}, {
             0.6881909602355868, -0.5, -1.1135163644116068`}, {
             0.6881909602355868, 
             0.5, -1.1135163644116068`}, {-0.8506508083520394, 
              0, -1.1135163644116068`}, {-0.6881909602355868, -0.5, 
             1.1135163644116066`}, {-0.6881909602355868, 0.5, 
             1.1135163644116066`}, {-1.3763819204711736`, 
              0, -0.2628655560595671}, {
             1.1135163644116066`, -0.8090169943749475, -0.2628655560595671}, {
             1.1135163644116066`, 
             0.8090169943749475, -0.2628655560595671}, {-0.4253254041760197, \
-1.3090169943749475`, -0.2628655560595671}, {-0.4253254041760197, 
             1.3090169943749475`, -0.2628655560595671}, {
             1.3763819204711736`, 0, 0.2628655560595668}, {
             0.42532540417601994`, -1.3090169943749475`, 
             0.2628655560595668}, {0.42532540417601994`, 1.3090169943749475`, 
             0.2628655560595668}, {-1.1135163644116068`, -0.8090169943749475, 
             0.2628655560595668}, {-1.1135163644116068`, 0.8090169943749475, 
             0.2628655560595668}, {1.1861706172121427`, -0.8618033988749895, 
             0.7330937578935453}, {1.1861706172121427`, 0.8618033988749896, 
             0.7330937578935453}, {-1.4661875157870907`, 0, 
              0.7330937578935453}, {-0.45307685931859754`, \
-1.3944271909999157`, 0.7330937578935453}, {-0.45307685931859754`, 
             1.3944271909999157`, 0.7330937578935453}, {
             1.4661875157870905`, 
              0, -0.7330937578935454}, {-1.1861706172121427`, \
-0.8618033988749895, -0.7330937578935454}, {-1.1861706172121427`, 
             0.8618033988749896, -0.7330937578935454}, {
             0.45307685931859754`, -1.3944271909999157`, \
-0.7330937578935454}, {0.45307685931859754`, 
             1.3944271909999157`, -0.7330937578935454}}], 
           Polygon3DBox[{{1, 26, 2}, {5, 31, 6}, {3, 27, 1}, {7, 32, 5}, {19, 
            26, 31}, {32, 27, 20}, {26, 23, 2}, {3, 24, 27}, {30, 29, 13}, {
            29, 26, 21}, {22, 27, 30}, {16, 26, 29}, {30, 27, 17}, {31, 29, 
            6}, {7, 30, 32}, {31, 23, 19}, {20, 24, 32}, {18, 24, 23}, {8, 28,
             31}, {9, 32, 28}, {14, 23, 31}, {32, 24, 15}, {23, 24, 4}, {31, 
            28, 14}, {28, 32, 15}, {21, 25, 29}, {30, 25, 22}, {28, 23, 14}, {
            15, 24, 28}, {18, 23, 28}, {28, 24, 18}, {29, 25, 13}, {13, 25, 
            30}, {2, 23, 1}, {8, 31, 5}, {1, 24, 3}, {5, 32, 9}, {19, 23, 
            26}, {27, 24, 20}, {11, 26, 1}, {6, 29, 5}, {1, 27, 12}, {5, 30, 
            7}, {1, 25, 11}, {5, 29, 10}, {12, 25, 1}, {10, 30, 5}, {1, 23, 
            4}, {5, 28, 8}, {4, 24, 1}, {9, 28, 5}, {10, 29, 30}, {21, 26, 
            25}, {22, 25, 27}, {16, 29, 31}, {32, 30, 17}, {25, 26, 11}, {27, 
            25, 12}, {31, 26, 16}, {17, 27, 32}}]]],
         "\"triakis icosahedron\""],
        Annotation[#, "triakis icosahedron", "Tooltip"]& ],
       TraditionalForm], {1365., -580.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Root[361 - 765 #^2 + 405 #^4& , 2, 0], 0, 
              Rational[1, 6] (29 + 62 5^Rational[-1, 2])^Rational[1, 2]}, {(1 + 
               2 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, 0, Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]}, {
             Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
             Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, 0, Rational[-1, 2] (5 + 2 5^Rational[1, 2])^
               Rational[1, 2]}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 6] (13 - 22 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 6] (-1 - 2 5^Rational[1, 2]), 
              Rational[1, 6] (29 + 62 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 6] (13 - 22 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 6] (1 + 2 5^Rational[1, 2]), 
              Rational[1, 6] (29 + 62 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[25, 72] + Rational[41, 72] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 12] (9 - 5^Rational[1, 2]), 
              Rational[1, 6] (29 + 62 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[25, 72] + Rational[41, 72] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 12] (-9 + 5^Rational[1, 2]), 
              Rational[1, 6] (29 + 62 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 3] (Rational[1, 10] (85 - 5^Rational[1, 2]))^
               Rational[1, 2], 0, 
              Rational[-1, 6] (29 + 62 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 6] (13 - 22 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 6] (-1 - 2 5^Rational[1, 2]), 
              Rational[-1, 6] (29 + 62 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 6] (13 - 22 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 6] (1 + 2 5^Rational[1, 2]), 
              Rational[-1, 6] (29 + 62 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 6] (Rational[25, 2] + 
                Rational[41, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 12] (9 - 5^Rational[1, 2]), 
              Rational[-1, 6] (29 + 62 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 6] (Rational[25, 2] + 
                Rational[41, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 12] (-9 + 5^Rational[1, 2]), 
              Rational[-1, 6] (29 + 62 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 6] (29 + 62 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 6] (-1 - 2 5^Rational[1, 2]), 
              Rational[1, 6] (13 - 22 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 6] (Rational[1, 10] (85 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 12] (-11 - 3 5^Rational[1, 2]), 
              Rational[1, 6] (13 - 22 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 6] (29 + 62 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 6] (1 + 2 5^Rational[1, 2]), 
              Rational[1, 6] (13 - 22 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 6] (Rational[1, 10] (85 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 12] (11 + 3 5^Rational[1, 2]), 
              Rational[1, 6] (13 - 22 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 3] (Rational[25, 2] + 
                Rational[41, 2] 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[1, 6] (13 - 22 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[25, 18] + Rational[41, 18] 5^Rational[-1, 2])^
              Rational[1, 2], 0, 
              Rational[-1, 6] (13 - 22 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 6] (Rational[1, 10] (85 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 12] (-11 - 3 5^Rational[1, 2]), 
              Rational[-1, 6] (13 - 22 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 6] (Rational[1, 10] (85 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 12] (11 + 3 5^Rational[1, 2]), 
              Rational[-1, 6] (13 - 22 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 6] (29 + 62 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 6] (-1 - 2 5^Rational[1, 2]), 
              Rational[-1, 6] (13 - 22 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 6] (29 + 62 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 6] (1 + 2 5^Rational[1, 2]), 
              Rational[-1, 6] (13 - 22 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0,
               Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
             Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
             Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^
               Rational[1, 2]}}, {{-0.9589573737630132, 0, 
              1.2552914991369466`}, {
             1.3763819204711736`, 0, 0.6881909602355868}, {
             0, 0, 1.5388417685876268`}, {-1.1135163644116068`, \
-0.8090169943749475, 0.6881909602355868}, {-1.1135163644116068`, 
             0.8090169943749475, 0.6881909602355868}, {
             0, 0, -1.5388417685876268`}, {
             0.42532540417601994`, -1.3090169943749475`, 
             0.6881909602355868}, {0.42532540417601994`, 1.3090169943749475`, 
             0.6881909602355868}, {-0.296334125373938, -0.9120226591665965, 
             1.2552914991369466`}, {-0.296334125373938, 0.9120226591665965, 
             1.2552914991369466`}, {0.7758128122554423, 0.5636610018750174, 
             1.2552914991369466`}, {0.7758128122554423, -0.5636610018750174, 
             1.2552914991369466`}, {
             0.9589573737630086, 0, -1.2552914991369466`}, {
             0.296334125373938, -0.9120226591665965, -1.2552914991369466`}, {
             0.296334125373938, 
             0.9120226591665965, -1.2552914991369466`}, {-0.7758128122554423, 
             0.5636610018750174, -1.2552914991369466`}, {-0.7758128122554423, \
-0.5636610018750174, -1.2552914991369466`}, {
             1.2552914991369466`, -0.9120226591665965, 
             0.296334125373938}, {-0.4794786868815043, -1.475683661041614, 
             0.296334125373938}, {1.2552914991369466`, 0.9120226591665965, 
             0.296334125373938}, {-0.4794786868815043, 1.475683661041614, 
             0.296334125373938}, {-1.5516256245108846`, 0, 
              0.296334125373938}, {
             1.5516256245108846`, 0, -0.296334125373938}, {
             0.4794786868815043, -1.475683661041614, -0.296334125373938}, {
             0.4794786868815043, 
             1.475683661041614, -0.296334125373938}, {-1.2552914991369466`, \
-0.9120226591665965, -0.296334125373938}, {-1.2552914991369466`, 
             0.9120226591665965, -0.296334125373938}, {
             1.1135163644116066`, -0.8090169943749475, -0.6881909602355868}, \
{-1.3763819204711736`, 0, -0.6881909602355868}, {1.1135163644116066`, 
             0.8090169943749475, -0.6881909602355868}, {-0.4253254041760197, \
-1.3090169943749475`, -0.6881909602355868}, {-0.4253254041760197, 
             1.3090169943749475`, -0.6881909602355868}}], 
           Polygon3DBox[{{7, 9, 19}, {21, 10, 8}, {31, 14, 24}, {25, 15, 
            32}, {6, 14, 17}, {24, 19, 31}, {6, 16, 15}, {21, 25, 32}, {9, 12,
             3}, {7, 19, 24}, {3, 11, 10}, {8, 25, 21}, {13, 14, 6}, {6, 15, 
            13}, {7, 24, 18}, {8, 20, 25}, {4, 1, 22}, {22, 1, 5}, {9, 1, 
            4}, {1, 10, 5}, {26, 17, 31}, {32, 16, 27}, {3, 1, 9}, {3, 10, 
            1}, {28, 14, 13}, {13, 15, 30}, {18, 12, 7}, {8, 11, 20}, {16, 17,
             29}, {11, 12, 2}, {19, 26, 31}, {27, 21, 32}, {29, 17, 26}, {27, 
            16, 29}, {28, 13, 23}, {23, 13, 30}, {23, 18, 28}, {30, 20, 23}, {
            2, 18, 23}, {23, 20, 2}, {19, 9, 4}, {5, 10, 21}, {24, 14, 28}, {
            30, 15, 25}, {26, 22, 29}, {22, 27, 29}, {4, 26, 19}, {5, 21, 
            27}, {18, 24, 28}, {25, 20, 30}, {2, 12, 18}, {20, 11, 2}, {3, 12,
             11}, {4, 22, 26}, {5, 27, 22}, {6, 17, 16}, {17, 14, 31}, {15, 
            16, 32}, {7, 12, 9}, {10, 11, 8}}]]],
         "\"pentakis dodecahedron\""],
        Annotation[#, "pentakis dodecahedron", "Tooltip"]& ],
       TraditionalForm], {1755., -580.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, 0, (-11) (85 - 31 5^Rational[1, 2])^Rational[-1, 2]}, {
             0, 0, 11 (85 - 31 5^Rational[1, 2])^Rational[-1, 2]}, {
             0, (-11) (85 - 31 5^Rational[1, 2])^Rational[-1, 2], 0}, {
             0, 11 (85 - 31 5^Rational[1, 2])^Rational[-1, 2], 0}, {
             0, Rational[-1, 3] (Rational[53, 2] + 59 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 6] (41 + 89 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, 
              Rational[-1, 3] (Rational[53, 2] + 59 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 6] (41 + 89 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, -(Rational[1, 2] + 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (13 + 29 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, -(Rational[1, 2] + 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (13 + 29 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, (Rational[1, 2] + 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (13 + 29 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, (Rational[1, 2] + 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (13 + 29 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, (Rational[53, 18] + Rational[59, 9] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[-1, 6] (41 + 89 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, (Rational[53, 18] + Rational[59, 9] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[1, 6] (41 + 89 5^Rational[-1, 2])^
               Rational[1, 2]}, {(-11) (85 - 31 5^Rational[1, 2])^
               Rational[-1, 2], 0, 0}, {
             Rational[-1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             11 (85 - 31 5^Rational[1, 2])^Rational[-1, 2], 0, 0}, {
             Rational[-1, 2] (13 + 29 5^Rational[-1, 2])^Rational[1, 2], 
              0, -(Rational[1, 2] + 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (13 + 29 5^Rational[-1, 2])^Rational[1, 2], 
              0, (Rational[1, 2] + 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 3] (Rational[53, 2] + 59 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 6] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              0}, {Rational[-1, 3] (Rational[53, 2] + 59 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 6] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              0}, {-(Rational[1, 2] + 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (13 + 29 5^Rational[-1, 2])^Rational[1, 2], 
              0}, {-(Rational[1, 2] + 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (13 + 29 5^Rational[-1, 2])^Rational[1, 2], 0}, {
             Rational[-1, 6] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[-1, 3] (Rational[53, 2] + 59 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 6] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              0, (Rational[53, 18] + Rational[59, 9] 5^Rational[-1, 2])^
              Rational[1, 2]}, {
             Rational[-1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 6] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[-1, 3] (Rational[53, 2] + 59 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[1, 6] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              0, (Rational[53, 18] + Rational[59, 9] 5^Rational[-1, 2])^
              Rational[1, 2]}, {
             Rational[1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[5, 2] + 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (17 + 31 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[1, 2] + 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (13 + 29 5^Rational[-1, 2])^Rational[1, 2], 
              0}, {(Rational[1, 2] + 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (13 + 29 5^Rational[-1, 2])^Rational[1, 2], 
              0}, {(Rational[53, 18] + Rational[59, 9] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[-1, 6] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 
              0}, {(Rational[53, 18] + Rational[59, 9] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[1, 6] (41 + 89 5^Rational[-1, 2])^Rational[1, 2], 0}, {
             Rational[1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (5 + 11 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (13 + 29 5^Rational[-1, 2])^Rational[1, 2], 
              0, -(Rational[1, 2] + 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (13 + 29 5^Rational[-1, 2])^Rational[1, 2], 
              0, (Rational[1, 2] + 5^Rational[-1, 2])^Rational[1, 2]}}, {{
             0, 0, -2.777751854490368}, {0, 0, 2.777751854490368}, {
             0, -2.777751854490368, 0}, {0, 2.777751854490368, 0}, {
             0, -2.424082922456278, -1.4981656376261552`}, {
             0, -2.424082922456278, 1.4981656376261552`}, {
             0, -0.9732489894677301, -2.547998933943006}, {
             0, -0.9732489894677301, 2.547998933943006}, {
             0, 0.9732489894677301, -2.547998933943006}, {
             0, 0.9732489894677301, 2.547998933943006}, {
             0, 2.424082922456278, -1.4981656376261552`}, {
             0, 2.424082922456278, 1.4981656376261552`}, {-2.777751854490368, 
              0, 0}, {-1.3888759272451836`, -2.247248456439233, 
             0.8583725291940496}, {-1.3888759272451836`, -2.247248456439233, \
-0.8583725291940496}, {-1.3888759272451836`, 2.247248456439233, 
             0.8583725291940496}, {-1.3888759272451836`, 
             2.247248456439233, -0.8583725291940496}, {
             1.3888759272451836`, -2.247248456439233, 0.8583725291940496}, {
             1.3888759272451836`, -2.247248456439233, -0.8583725291940496}, {
             1.3888759272451836`, 2.247248456439233, 0.8583725291940496}, {
             1.3888759272451836`, 2.247248456439233, -0.8583725291940496}, {
             2.777751854490368, 0, 0}, {-2.547998933943006, 
              0, -0.9732489894677301}, {-2.547998933943006, 0, 
              0.9732489894677301}, {-1.5747499444752757`, \
-1.5747499444752757`, -1.5747499444752757`}, {-1.5747499444752757`, \
-1.5747499444752757`, 1.5747499444752757`}, {-1.5747499444752757`, 
             1.5747499444752757`, -1.5747499444752757`}, \
{-1.5747499444752757`, 1.5747499444752757`, 
             1.5747499444752757`}, {-2.424082922456278, -1.4981656376261552`, 
              0}, {-2.424082922456278, 1.4981656376261552`, 
              0}, {-0.9732489894677301, -2.547998933943006, 
              0}, {-0.9732489894677301, 2.547998933943006, 
              0}, {-1.4981656376261552`, 
              0, -2.424082922456278}, {-1.4981656376261552`, 0, 
              2.424082922456278}, {-2.247248456439233, 
             0.8583725291940496, -1.3888759272451836`}, {-2.247248456439233, 
             0.8583725291940496, 
             1.3888759272451836`}, {-2.247248456439233, -0.8583725291940496, \
-1.3888759272451836`}, {-2.247248456439233, -0.8583725291940496, 
             1.3888759272451836`}, {
             0.8583725291940496, -1.3888759272451836`, -2.247248456439233}, {
             0.8583725291940496, -1.3888759272451836`, 2.247248456439233}, {
             0.8583725291940496, 1.3888759272451836`, -2.247248456439233}, {
             0.8583725291940496, 1.3888759272451836`, 
             2.247248456439233}, {-0.8583725291940496, -1.3888759272451836`, \
-2.247248456439233}, {-0.8583725291940496, -1.3888759272451836`, 
             2.247248456439233}, {-0.8583725291940496, 
             1.3888759272451836`, -2.247248456439233}, {-0.8583725291940496, 
             1.3888759272451836`, 2.247248456439233}, {
             1.4981656376261552`, 0, -2.424082922456278}, {
             1.4981656376261552`, 0, 2.424082922456278}, {2.247248456439233, 
             0.8583725291940496, -1.3888759272451836`}, {2.247248456439233, 
             0.8583725291940496, 1.3888759272451836`}, {
             2.247248456439233, -0.8583725291940496, -1.3888759272451836`}, {
             2.247248456439233, -0.8583725291940496, 1.3888759272451836`}, {
             0.9732489894677301, -2.547998933943006, 0}, {
             0.9732489894677301, 2.547998933943006, 0}, {
             2.424082922456278, -1.4981656376261552`, 0}, {
             2.424082922456278, 1.4981656376261552`, 0}, {
             1.5747499444752757`, -1.5747499444752757`, \
-1.5747499444752757`}, {1.5747499444752757`, -1.5747499444752757`, 
             1.5747499444752757`}, {1.5747499444752757`, 
             1.5747499444752757`, -1.5747499444752757`}, {1.5747499444752757`,
              1.5747499444752757`, 1.5747499444752757`}, {
             2.547998933943006, 0, -0.9732489894677301}, {
             2.547998933943006, 0, 0.9732489894677301}}], 
           Polygon3DBox[{{43, 33, 1, 7}, {8, 2, 34, 44}, {33, 45, 9, 1}, {2, 
            10, 46, 34}, {31, 15, 5, 3}, {3, 6, 14, 31}, {17, 32, 4, 11}, {12,
             4, 32, 16}, {39, 5, 43, 7}, {40, 8, 44, 6}, {9, 45, 11, 41}, {12,
             46, 10, 42}, {39, 7, 1, 47}, {48, 2, 8, 40}, {1, 9, 41, 47}, {48,
             42, 10, 2}, {53, 3, 5, 19}, {18, 6, 3, 53}, {11, 4, 54, 21}, {20,
             54, 4, 12}, {33, 37, 23, 35}, {24, 38, 34, 36}, {15, 25, 43, 
            5}, {6, 44, 26, 14}, {45, 27, 17, 11}, {12, 16, 28, 46}, {29, 37, 
            25, 15}, {14, 26, 38, 29}, {27, 35, 30, 17}, {16, 30, 36, 28}, {
            29, 13, 23, 37}, {38, 24, 13, 29}, {23, 13, 30, 35}, {36, 30, 13, 
            24}, {15, 31, 14, 29}, {25, 37, 33, 43}, {44, 34, 38, 26}, {33, 
            35, 27, 45}, {46, 28, 36, 34}, {17, 30, 16, 32}, {19, 5, 39, 
            57}, {58, 40, 6, 18}, {41, 11, 21, 59}, {60, 20, 12, 42}, {19, 57,
             51, 55}, {55, 52, 58, 18}, {49, 59, 21, 56}, {56, 20, 60, 50}, {
            55, 51, 61, 22}, {22, 62, 52, 55}, {61, 49, 56, 22}, {22, 56, 50, 
            62}, {55, 18, 53, 19}, {57, 39, 47, 51}, {52, 48, 40, 58}, {47, 
            41, 59, 49}, {50, 60, 42, 48}, {54, 20, 56, 21}, {49, 61, 51, 
            47}, {50, 48, 52, 62}}]]],
         "\"deltoidal hexecontahedron\""],
        Annotation[#, "deltoidal hexecontahedron", "Tooltip"]& ],
       TraditionalForm], {195., -967.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, 0, Root[
              729 - 9720 #^2 + 50544 #^4 - 126144 #^6 + 147456 #^8 - 
               64512 #^10 + 4096 #^12& , 1, 0]}, {
             0, 0, Root[
              729 - 9720 #^2 + 50544 #^4 - 126144 #^6 + 147456 #^8 - 
               64512 #^10 + 4096 #^12& , 8, 0]}, {
             Root[1 - 30 #^2 + 351 #^4 - 1971 #^6 + 5184 #^8 - 5103 #^10 + 
               729 #^12& , 1, 0], 0, Root[
              15625 - 375000 #^2 + 3510000 #^4 - 15768000 #^6 + 33177600 #^8 - 
               26127360 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 30 #^2 + 351 #^4 - 1971 #^6 + 5184 #^8 - 5103 #^10 + 
               729 #^12& , 8, 0], 0, Root[
              15625 - 375000 #^2 + 3510000 #^4 - 15768000 #^6 + 33177600 #^8 - 
               26127360 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 225 #^2 + 6318 #^4 - 468396 #^6 + 5037876 #^8 - 
               10161774 #^10 + 700569 #^12& , 1, 0], 0, Root[
              1 - 360 #^2 + 1567728 #^4 - 197429184 #^6 + 1651746816 #^8 - 
               3954686976 #^10 + 2869530624 #^12& , 2, 0]}, {
             Root[1 - 225 #^2 + 6318 #^4 - 468396 #^6 + 5037876 #^8 - 
               10161774 #^10 + 700569 #^12& , 8, 0], 0, Root[
              1 - 360 #^2 + 1567728 #^4 - 197429184 #^6 + 1651746816 #^8 - 
               3954686976 #^10 + 2869530624 #^12& , 7, 0]}, {
             Root[1 - 105 #^2 + 16218 #^4 - 1169964 #^6 + 5188131 #^8 - 
               4674591 #^10 + 700569 #^12& , 1, 0], 0, Root[
              1 - 2280 #^2 + 300528 #^4 - 19797696 #^6 + 1344024576 #^8 - 
               26430188544 #^10 + 2869530624 #^12& , 8, 0]}, {
             Root[1 - 105 #^2 + 16218 #^4 - 1169964 #^6 + 5188131 #^8 - 
               4674591 #^10 + 700569 #^12& , 8, 0], 0, Root[
              1 - 2280 #^2 + 300528 #^4 - 19797696 #^6 + 1344024576 #^8 - 
               26430188544 #^10 + 2869530624 #^12& , 1, 0]}, {
             Root[116281 - 3604284 #^2 + 25701408 #^4 - 68097024 #^6 + 
               73115136 #^8 - 33841152 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 132 #^2 + 4256 #^4 - 3072 #^6 - 9728 #^8 + 4096 #^12& , 8, 
               0], Root[
              14641 - 1169208 #^2 + 7126704 #^4 - 16168896 #^6 + 18496512 #^8 - 
               13188096 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[116281 - 3604284 #^2 + 25701408 #^4 - 68097024 #^6 + 
               73115136 #^8 - 33841152 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 132 #^2 + 4256 #^4 - 3072 #^6 - 9728 #^8 + 4096 #^12& , 8, 
               0], Root[
              14641 - 1169208 #^2 + 7126704 #^4 - 16168896 #^6 + 18496512 #^8 - 
               13188096 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[434281 - 6964092 #^2 + 32133456 #^4 - 48121344 #^6 + 
               60217344 #^8 - 36080640 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 100 #^2 + 1872 #^4 - 9472 #^6 + 9216 #^8 - 13312 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 18792 #^2 + 524016 #^4 - 3443904 #^6 + 6718464 #^8 - 
               1244160 #^10 + 2985984 #^12& , 2, 0]}, {
             Root[434281 - 6964092 #^2 + 32133456 #^4 - 48121344 #^6 + 
               60217344 #^8 - 36080640 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 100 #^2 + 1872 #^4 - 9472 #^6 + 9216 #^8 - 13312 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 18792 #^2 + 524016 #^4 - 3443904 #^6 + 6718464 #^8 - 
               1244160 #^10 + 2985984 #^12& , 7, 0]}, {
             Root[3721 - 487788 #^2 + 9747648 #^4 - 39785472 #^6 + 
               39336192 #^8 - 29113344 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 68 #^2 + 1216 #^4 - 5888 #^6 + 9472 #^8 - 5120 #^10 + 
               4096 #^12& , 1, 0], Root[
              212521 - 2031960 #^2 + 3632688 #^4 + 6053184 #^6 + 2820096 #^8 - 
               14183424 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[3721 - 487788 #^2 + 9747648 #^4 - 39785472 #^6 + 
               39336192 #^8 - 29113344 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 68 #^2 + 1216 #^4 - 5888 #^6 + 9472 #^8 - 5120 #^10 + 
               4096 #^12& , 1, 0], Root[
              212521 - 2031960 #^2 + 3632688 #^4 + 6053184 #^6 + 2820096 #^8 - 
               14183424 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[44521 - 4301016 #^2 + 28874016 #^4 - 73500480 #^6 + 
               84976128 #^8 - 40310784 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 488 #^2 + 5728 #^4 - 20160 #^6 + 29184 #^8 - 18432 #^10 + 
               4096 #^12& , 8, 0], Root[
              961 - 36984 #^2 + 466992 #^4 - 2185920 #^6 + 1741824 #^8 + 
               6718464 #^10 + 2985984 #^12& , 5, 0]}, {
             Root[44521 - 4301016 #^2 + 28874016 #^4 - 73500480 #^6 + 
               84976128 #^8 - 40310784 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 488 #^2 + 5728 #^4 - 20160 #^6 + 29184 #^8 - 18432 #^10 + 
               4096 #^12& , 8, 0], Root[
              961 - 36984 #^2 + 466992 #^4 - 2185920 #^6 + 1741824 #^8 + 
               6718464 #^10 + 2985984 #^12& , 4, 0]}, {
             Root[1 - 10416 #^2 + 835488 #^4 - 11995776 #^6 + 27392256 #^8 - 
               38320128 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 48 #^2 + 672 #^4 - 3456 #^6 + 4352 #^8 + 6144 #^10 + 
               4096 #^12& , 2, 0], Root[
              39601 - 1972104 #^2 + 10693296 #^4 - 22783680 #^6 + 
               24219648 #^8 - 13188096 #^10 + 2985984 #^12& , 7, 0]}, {
             Root[1 - 10416 #^2 + 835488 #^4 - 11995776 #^6 + 27392256 #^8 - 
               38320128 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 48 #^2 + 672 #^4 - 3456 #^6 + 4352 #^8 + 6144 #^10 + 
               4096 #^12& , 2, 0], Root[
              39601 - 1972104 #^2 + 10693296 #^4 - 22783680 #^6 + 
               24219648 #^8 - 13188096 #^10 + 2985984 #^12& , 2, 0]}, {
             Root[1 - 10584 #^2 + 441072 #^4 - 3430080 #^6 + 7962624 #^8 - 
               3234816 #^10 + 2985984 #^12& , 3, 0], Root[
              1 - 120 #^2 + 1392 #^4 - 17728 #^6 + 70656 #^8 - 58368 #^10 + 
               4096 #^12& , 8, 0], Root[
              1 - 18792 #^2 + 524016 #^4 - 3443904 #^6 + 6718464 #^8 - 
               1244160 #^10 + 2985984 #^12& , 7, 0]}, {
             Root[1 - 10584 #^2 + 441072 #^4 - 3430080 #^6 + 7962624 #^8 - 
               3234816 #^10 + 2985984 #^12& , 6, 0], Root[
              1 - 120 #^2 + 1392 #^4 - 17728 #^6 + 70656 #^8 - 58368 #^10 + 
               4096 #^12& , 8, 0], Root[
              1 - 18792 #^2 + 524016 #^4 - 3443904 #^6 + 6718464 #^8 - 
               1244160 #^10 + 2985984 #^12& , 2, 0]}, {
             Root[15625 - 375000 #^2 + 3510000 #^4 - 15768000 #^6 + 
               33177600 #^8 - 26127360 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 40 #^2 + 624 #^4 - 4672 #^6 + 16384 #^8 - 21504 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[15625 - 375000 #^2 + 3510000 #^4 - 15768000 #^6 + 
               33177600 #^8 - 26127360 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 40 #^2 + 624 #^4 - 4672 #^6 + 16384 #^8 - 21504 #^10 + 
               4096 #^12& , 8, 0], Root[
              1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[15625 - 375000 #^2 + 3510000 #^4 - 15768000 #^6 + 
               33177600 #^8 - 26127360 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 40 #^2 + 624 #^4 - 4672 #^6 + 16384 #^8 - 21504 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[15625 - 375000 #^2 + 3510000 #^4 - 15768000 #^6 + 
               33177600 #^8 - 26127360 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 40 #^2 + 624 #^4 - 4672 #^6 + 16384 #^8 - 21504 #^10 + 
               4096 #^12& , 8, 0], Root[
              1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[961 - 107388 #^2 + 1622448 #^4 - 9268992 #^6 + 22851072 #^8 - 
               21648384 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 2996 #^2 + 9520 #^4 - 3840 #^6 - 7680 #^8 + 1024 #^10 + 
               4096 #^12& , 8, 0], Root[
              3721 - 567432 #^2 + 11871216 #^4 - 47127744 #^6 + 54825984 #^8 - 
               26127360 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[961 - 107388 #^2 + 1622448 #^4 - 9268992 #^6 + 22851072 #^8 - 
               21648384 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 2996 #^2 + 9520 #^4 - 3840 #^6 - 7680 #^8 + 1024 #^10 + 
               4096 #^12& , 8, 0], Root[
              3721 - 567432 #^2 + 11871216 #^4 - 47127744 #^6 + 54825984 #^8 - 
               26127360 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[361 - 28704 #^2 + 811296 #^4 - 9210240 #^6 + 31788288 #^8 - 
               34338816 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 48 #^2 + 672 #^4 - 3456 #^6 + 4352 #^8 + 6144 #^10 + 
               4096 #^12& , 7, 0], Root[
              961 - 1204296 #^2 + 16679088 #^4 - 41224896 #^6 + 38071296 #^8 - 
               17169408 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[361 - 28704 #^2 + 811296 #^4 - 9210240 #^6 + 31788288 #^8 - 
               34338816 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 48 #^2 + 672 #^4 - 3456 #^6 + 4352 #^8 + 6144 #^10 + 
               4096 #^12& , 7, 0], Root[
              961 - 1204296 #^2 + 16679088 #^4 - 41224896 #^6 + 38071296 #^8 - 
               17169408 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[961 - 44028 #^2 + 430704 #^4 - 3684096 #^6 + 18600192 #^8 - 
               29362176 #^10 + 2985984 #^12& , 1, 0], Root[
              361 - 8452 #^2 + 41584 #^4 - 58880 #^6 + 39168 #^8 - 22528 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 18792 #^2 + 524016 #^4 - 3443904 #^6 + 6718464 #^8 - 
               1244160 #^10 + 2985984 #^12& , 7, 0]}, {
             Root[961 - 44028 #^2 + 430704 #^4 - 3684096 #^6 + 18600192 #^8 - 
               29362176 #^10 + 2985984 #^12& , 8, 0], Root[
              361 - 8452 #^2 + 41584 #^4 - 58880 #^6 + 39168 #^8 - 22528 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 18792 #^2 + 524016 #^4 - 3443904 #^6 + 6718464 #^8 - 
               1244160 #^10 + 2985984 #^12& , 2, 0]}, {
             Root[5041 - 184920 #^2 + 2366928 #^4 - 13153536 #^6 + 
               35894016 #^8 - 29113344 #^10 + 2985984 #^12& , 1, 0], Root[
              121 - 3176 #^2 + 26576 #^4 - 80128 #^6 + 83712 #^8 - 33792 #^10 + 
               4096 #^12& , 8, 0], Root[
              961 - 36984 #^2 + 466992 #^4 - 2185920 #^6 + 1741824 #^8 + 
               6718464 #^10 + 2985984 #^12& , 4, 0]}, {
             Root[5041 - 184920 #^2 + 2366928 #^4 - 13153536 #^6 + 
               35894016 #^8 - 29113344 #^10 + 2985984 #^12& , 8, 0], Root[
              121 - 3176 #^2 + 26576 #^4 - 80128 #^6 + 83712 #^8 - 33792 #^10 + 
               4096 #^12& , 8, 0], Root[
              961 - 36984 #^2 + 466992 #^4 - 2185920 #^6 + 1741824 #^8 + 
               6718464 #^10 + 2985984 #^12& , 5, 0]}, {
             Root[1 - 420 #^2 + 50976 #^4 - 1880064 #^6 + 13768704 #^8 - 
               31352832 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 60 #^2 + 1184 #^4 - 7168 #^6 + 16384 #^8 - 14336 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 420 #^2 + 50976 #^4 - 1880064 #^6 + 13768704 #^8 - 
               31352832 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 60 #^2 + 1184 #^4 - 7168 #^6 + 16384 #^8 - 14336 #^10 + 
               4096 #^12& , 8, 0], Root[
              1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 420 #^2 + 50976 #^4 - 1880064 #^6 + 13768704 #^8 - 
               31352832 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 60 #^2 + 1184 #^4 - 7168 #^6 + 16384 #^8 - 14336 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 420 #^2 + 50976 #^4 - 1880064 #^6 + 13768704 #^8 - 
               31352832 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 60 #^2 + 1184 #^4 - 7168 #^6 + 16384 #^8 - 14336 #^10 + 
               4096 #^12& , 8, 0], Root[
              1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[361 - 32844 #^2 + 678528 #^4 - 4791744 #^6 + 13913856 #^8 - 
               21399552 #^10 + 2985984 #^12& , 1, 0], Root[
              841 - 12932 #^2 + 49088 #^4 - 68160 #^6 + 50944 #^8 - 
               22528 #^10 + 4096 #^12& , 1, 0], Root[
              961 - 101256 #^2 + 2920176 #^4 - 19085760 #^6 - 9787392 #^8 - 
               9206784 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[361 - 32844 #^2 + 678528 #^4 - 4791744 #^6 + 13913856 #^8 - 
               21399552 #^10 + 2985984 #^12& , 8, 0], Root[
              841 - 12932 #^2 + 49088 #^4 - 68160 #^6 + 50944 #^8 - 
               22528 #^10 + 4096 #^12& , 1, 0], Root[
              961 - 101256 #^2 + 2920176 #^4 - 19085760 #^6 - 9787392 #^8 - 
               9206784 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[11881 - 1058220 #^2 + 5908608 #^4 - 11563776 #^6 + 
               9144576 #^8 - 4230144 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 68 #^2 + 1216 #^4 - 5888 #^6 + 9472 #^8 - 5120 #^10 + 
               4096 #^12& , 8, 0], Root[
              1 - 146088 #^2 + 1720368 #^4 - 10141632 #^6 + 32596992 #^8 - 
               39066624 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[11881 - 1058220 #^2 + 5908608 #^4 - 11563776 #^6 + 
               9144576 #^8 - 4230144 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 68 #^2 + 1216 #^4 - 5888 #^6 + 9472 #^8 - 5120 #^10 + 
               4096 #^12& , 8, 0], Root[
              1 - 146088 #^2 + 1720368 #^4 - 10141632 #^6 + 32596992 #^8 - 
               39066624 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[841 - 44232 #^2 + 705456 #^4 - 4688064 #^6 + 12939264 #^8 - 
               11197440 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 120 #^2 + 1392 #^4 - 17728 #^6 + 70656 #^8 - 58368 #^10 + 
               4096 #^12& , 1, 0], Root[
              961 - 36984 #^2 + 466992 #^4 - 2185920 #^6 + 1741824 #^8 + 
               6718464 #^10 + 2985984 #^12& , 4, 0]}, {
             Root[841 - 44232 #^2 + 705456 #^4 - 4688064 #^6 + 12939264 #^8 - 
               11197440 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 120 #^2 + 1392 #^4 - 17728 #^6 + 70656 #^8 - 58368 #^10 + 
               4096 #^12& , 1, 0], Root[
              961 - 36984 #^2 + 466992 #^4 - 2185920 #^6 + 1741824 #^8 + 
               6718464 #^10 + 2985984 #^12& , 5, 0]}, {
             Root[5041 - 193824 #^2 + 2029536 #^4 - 6791040 #^6 + 2757888 #^8 + 
               497664 #^10 + 2985984 #^12& , 2, 0], Root[
              1 - 112 #^2 + 3552 #^4 - 28544 #^6 + 55552 #^8 - 47104 #^10 + 
               4096 #^12& , 1, 0], Root[
              14641 - 1169208 #^2 + 7126704 #^4 - 16168896 #^6 + 18496512 #^8 - 
               13188096 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[5041 - 193824 #^2 + 2029536 #^4 - 6791040 #^6 + 2757888 #^8 + 
               497664 #^10 + 2985984 #^12& , 7, 0], Root[
              1 - 112 #^2 + 3552 #^4 - 28544 #^6 + 55552 #^8 - 47104 #^10 + 
               4096 #^12& , 1, 0], Root[
              14641 - 1169208 #^2 + 7126704 #^4 - 16168896 #^6 + 18496512 #^8 - 
               13188096 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[203401 - 3899628 #^2 + 19040544 #^4 - 38416896 #^6 + 
               36951552 #^8 - 16920576 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 132 #^2 + 4256 #^4 - 3072 #^6 - 9728 #^8 + 4096 #^12& , 1, 
               0], Root[
              121 - 65304 #^2 + 519408 #^4 + 1740096 #^6 - 10450944 #^8 - 
               30108672 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[203401 - 3899628 #^2 + 19040544 #^4 - 38416896 #^6 + 
               36951552 #^8 - 16920576 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 132 #^2 + 4256 #^4 - 3072 #^6 - 9728 #^8 + 4096 #^12& , 1, 
               0], Root[
              121 - 65304 #^2 + 519408 #^4 + 1740096 #^6 - 10450944 #^8 - 
               30108672 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 420 #^2 + 50976 #^4 - 635904 #^6 + 2882304 #^8 - 
               5225472 #^10 + 2985984 #^12& , 3, 0], Root[
              1 - 60 #^2 + 1184 #^4 - 9728 #^6 + 35584 #^8 - 50176 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 420 #^2 + 50976 #^4 - 635904 #^6 + 2882304 #^8 - 
               5225472 #^10 + 2985984 #^12& , 3, 0], Root[
              1 - 60 #^2 + 1184 #^4 - 9728 #^6 + 35584 #^8 - 50176 #^10 + 
               4096 #^12& , 8, 0], Root[
              1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 420 #^2 + 50976 #^4 - 635904 #^6 + 2882304 #^8 - 
               5225472 #^10 + 2985984 #^12& , 6, 0], Root[
              1 - 60 #^2 + 1184 #^4 - 9728 #^6 + 35584 #^8 - 50176 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 420 #^2 + 50976 #^4 - 635904 #^6 + 2882304 #^8 - 
               5225472 #^10 + 2985984 #^12& , 6, 0], Root[
              1 - 60 #^2 + 1184 #^4 - 9728 #^6 + 35584 #^8 - 50176 #^10 + 
               4096 #^12& , 8, 0], Root[
              1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 2556 #^2 + 130176 #^4 - 1874880 #^6 + 5038848 #^8 - 
               497664 #^10 + 2985984 #^12& , 1, 0], Root[
              841 - 12932 #^2 + 49088 #^4 - 68160 #^6 + 50944 #^8 - 
               22528 #^10 + 4096 #^12& , 8, 0], Root[
              121 - 65304 #^2 + 519408 #^4 + 1740096 #^6 - 10450944 #^8 - 
               30108672 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 2556 #^2 + 130176 #^4 - 1874880 #^6 + 5038848 #^8 - 
               497664 #^10 + 2985984 #^12& , 8, 0], Root[
              841 - 12932 #^2 + 49088 #^4 - 68160 #^6 + 50944 #^8 - 
               22528 #^10 + 4096 #^12& , 8, 0], Root[
              121 - 65304 #^2 + 519408 #^4 + 1740096 #^6 - 10450944 #^8 - 
               30108672 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[3721 - 128376 #^2 + 1171008 #^4 - 3675456 #^6 + 2820096 #^8 + 
               1492992 #^10 + 2985984 #^12& , 3, 0], Root[
              121 - 1432 #^2 + 4736 #^4 - 5312 #^6 + 18432 #^8 - 30720 #^10 + 
               4096 #^12& , 1, 0], Root[
              3721 - 567432 #^2 + 11871216 #^4 - 47127744 #^6 + 54825984 #^8 - 
               26127360 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[3721 - 128376 #^2 + 1171008 #^4 - 3675456 #^6 + 2820096 #^8 + 
               1492992 #^10 + 2985984 #^12& , 6, 0], Root[
              121 - 1432 #^2 + 4736 #^4 - 5312 #^6 + 18432 #^8 - 30720 #^10 + 
               4096 #^12& , 1, 0], Root[
              3721 - 567432 #^2 + 11871216 #^4 - 47127744 #^6 + 54825984 #^8 - 
               26127360 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[109561 - 5971944 #^2 + 19229472 #^4 - 23112000 #^6 + 
               27661824 #^8 - 24385536 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 488 #^2 + 5728 #^4 - 20160 #^6 + 29184 #^8 - 18432 #^10 + 
               4096 #^12& , 1, 0], Root[
              961 - 101256 #^2 + 2920176 #^4 - 19085760 #^6 - 9787392 #^8 - 
               9206784 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[109561 - 5971944 #^2 + 19229472 #^4 - 23112000 #^6 + 
               27661824 #^8 - 24385536 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 488 #^2 + 5728 #^4 - 20160 #^6 + 29184 #^8 - 18432 #^10 + 
               4096 #^12& , 1, 0], Root[
              961 - 101256 #^2 + 2920176 #^4 - 19085760 #^6 - 9787392 #^8 - 
               9206784 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[961 - 123996 #^2 + 2112768 #^4 - 11105856 #^6 + 
               17024256 #^8 - 10948608 #^10 + 2985984 #^12& , 4, 0], Root[
              1 - 228 #^2 + 192 #^4 + 6208 #^6 + 256 #^8 - 36864 #^10 + 
               4096 #^12& , 8, 0], Root[
              961 - 101256 #^2 + 2920176 #^4 - 19085760 #^6 - 9787392 #^8 - 
               9206784 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[961 - 123996 #^2 + 2112768 #^4 - 11105856 #^6 + 
               17024256 #^8 - 10948608 #^10 + 2985984 #^12& , 5, 0], Root[
              1 - 228 #^2 + 192 #^4 + 6208 #^6 + 256 #^8 - 36864 #^10 + 
               4096 #^12& , 8, 0], Root[
              961 - 101256 #^2 + 2920176 #^4 - 19085760 #^6 - 9787392 #^8 - 
               9206784 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[361 - 305400 #^2 + 5071248 #^4 - 17179776 #^6 + 4686336 #^8 - 
               12939264 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 104 #^2 + 2832 #^4 - 15744 #^6 - 30208 #^8 - 28672 #^10 + 
               4096 #^12& , 1, 0], Root[
              39601 - 1972104 #^2 + 10693296 #^4 - 22783680 #^6 + 
               24219648 #^8 - 13188096 #^10 + 2985984 #^12& , 2, 0]}, {
             Root[361 - 305400 #^2 + 5071248 #^4 - 17179776 #^6 + 4686336 #^8 - 
               12939264 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 104 #^2 + 2832 #^4 - 15744 #^6 - 30208 #^8 - 28672 #^10 + 
               4096 #^12& , 1, 0], Root[
              39601 - 1972104 #^2 + 10693296 #^4 - 22783680 #^6 + 
               24219648 #^8 - 13188096 #^10 + 2985984 #^12& , 7, 0]}, {
             Root[292681 - 5426892 #^2 + 7322256 #^4 + 15572736 #^6 - 
               11114496 #^8 - 11197440 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 100 #^2 + 1872 #^4 - 9472 #^6 + 9216 #^8 - 13312 #^10 + 
               4096 #^12& , 8, 0], Root[
              3721 - 567432 #^2 + 11871216 #^4 - 47127744 #^6 + 54825984 #^8 - 
               26127360 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[292681 - 5426892 #^2 + 7322256 #^4 + 15572736 #^6 - 
               11114496 #^8 - 11197440 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 100 #^2 + 1872 #^4 - 9472 #^6 + 9216 #^8 - 13312 #^10 + 
               4096 #^12& , 8, 0], Root[
              3721 - 567432 #^2 + 11871216 #^4 - 47127744 #^6 + 54825984 #^8 - 
               26127360 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 252 #^2 + 20016 #^4 - 635904 #^6 + 7340544 #^8 - 
               8709120 #^10 + 2985984 #^12& , 2, 0], Root[
              1 - 2996 #^2 + 9520 #^4 - 3840 #^6 - 7680 #^8 + 1024 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 146088 #^2 + 1720368 #^4 - 10141632 #^6 + 32596992 #^8 - 
               39066624 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 252 #^2 + 20016 #^4 - 635904 #^6 + 7340544 #^8 - 
               8709120 #^10 + 2985984 #^12& , 7, 0], Root[
              1 - 2996 #^2 + 9520 #^4 - 3840 #^6 - 7680 #^8 + 1024 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 146088 #^2 + 1720368 #^4 - 10141632 #^6 + 32596992 #^8 - 
               39066624 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[19321 - 529224 #^2 + 4338576 #^4 - 14394240 #^6 + 
               19865088 #^8 - 11943936 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 104 #^2 + 2832 #^4 - 15744 #^6 - 30208 #^8 - 28672 #^10 + 
               4096 #^12& , 8, 0], Root[
              212521 - 2031960 #^2 + 3632688 #^4 + 6053184 #^6 + 2820096 #^8 - 
               14183424 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[19321 - 529224 #^2 + 4338576 #^4 - 14394240 #^6 + 
               19865088 #^8 - 11943936 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 104 #^2 + 2832 #^4 - 15744 #^6 - 30208 #^8 - 28672 #^10 + 
               4096 #^12& , 8, 0], Root[
              212521 - 2031960 #^2 + 3632688 #^4 + 6053184 #^6 + 2820096 #^8 - 
               14183424 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 15372 #^2 + 1189296 #^4 - 8066304 #^6 - 13913856 #^8 - 
               17418240 #^10 + 2985984 #^12& , 1, 0], Root[
              361 - 8452 #^2 + 41584 #^4 - 58880 #^6 + 39168 #^8 - 22528 #^10 + 
               4096 #^12& , 8, 0], Root[
              14641 - 1169208 #^2 + 7126704 #^4 - 16168896 #^6 + 18496512 #^8 - 
               13188096 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 15372 #^2 + 1189296 #^4 - 8066304 #^6 - 13913856 #^8 - 
               17418240 #^10 + 2985984 #^12& , 8, 0], Root[
              361 - 8452 #^2 + 41584 #^4 - 58880 #^6 + 39168 #^8 - 22528 #^10 + 
               4096 #^12& , 8, 0], Root[
              14641 - 1169208 #^2 + 7126704 #^4 - 16168896 #^6 + 18496512 #^8 - 
               13188096 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 40 #^2 + 624 #^4 - 4672 #^6 + 16384 #^8 - 21504 #^10 + 
               4096 #^12& , 1, 0], Root[
              15625 - 375000 #^2 + 3510000 #^4 - 15768000 #^6 + 33177600 #^8 - 
               26127360 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 40 #^2 + 624 #^4 - 4672 #^6 + 16384 #^8 - 21504 #^10 + 
               4096 #^12& , 8, 0], Root[
              15625 - 375000 #^2 + 3510000 #^4 - 15768000 #^6 + 33177600 #^8 - 
               26127360 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 40 #^2 + 624 #^4 - 4672 #^6 + 16384 #^8 - 21504 #^10 + 
               4096 #^12& , 1, 0], Root[
              15625 - 375000 #^2 + 3510000 #^4 - 15768000 #^6 + 33177600 #^8 - 
               26127360 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 120 #^2 + 5616 #^4 - 126144 #^6 + 1327104 #^8 - 
               5225472 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 40 #^2 + 624 #^4 - 4672 #^6 + 16384 #^8 - 21504 #^10 + 
               4096 #^12& , 8, 0], Root[
              15625 - 375000 #^2 + 3510000 #^4 - 15768000 #^6 + 33177600 #^8 - 
               26127360 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[14641 - 802956 #^2 + 4366656 #^4 - 5037120 #^6 - 
               1804032 #^8 - 2985984 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 228 #^2 + 192 #^4 + 6208 #^6 + 256 #^8 - 36864 #^10 + 
               4096 #^12& , 1, 0], Root[
              961 - 1204296 #^2 + 16679088 #^4 - 41224896 #^6 + 38071296 #^8 - 
               17169408 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[14641 - 802956 #^2 + 4366656 #^4 - 5037120 #^6 - 
               1804032 #^8 - 2985984 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 228 #^2 + 192 #^4 + 6208 #^6 + 256 #^8 - 36864 #^10 + 
               4096 #^12& , 1, 0], Root[
              961 - 1204296 #^2 + 16679088 #^4 - 41224896 #^6 + 38071296 #^8 - 
               17169408 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[841 - 235272 #^2 + 3062016 #^4 - 5949504 #^6 - 13188096 #^8 - 
               7464960 #^10 + 2985984 #^12& , 1, 0], Root[
              121 - 1432 #^2 + 4736 #^4 - 5312 #^6 + 18432 #^8 - 30720 #^10 + 
               4096 #^12& , 8, 0], Root[
              961 - 1204296 #^2 + 16679088 #^4 - 41224896 #^6 + 38071296 #^8 - 
               17169408 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[841 - 235272 #^2 + 3062016 #^4 - 5949504 #^6 - 13188096 #^8 - 
               7464960 #^10 + 2985984 #^12& , 8, 0], Root[
              121 - 1432 #^2 + 4736 #^4 - 5312 #^6 + 18432 #^8 - 30720 #^10 + 
               4096 #^12& , 8, 0], Root[
              961 - 1204296 #^2 + 16679088 #^4 - 41224896 #^6 + 38071296 #^8 - 
               17169408 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[7921 - 243408 #^2 + 2368224 #^4 - 6189696 #^6 - 
               10430208 #^8 + 497664 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 112 #^2 + 3552 #^4 - 28544 #^6 + 55552 #^8 - 47104 #^10 + 
               4096 #^12& , 8, 0], Root[
              39601 - 1972104 #^2 + 10693296 #^4 - 22783680 #^6 + 
               24219648 #^8 - 13188096 #^10 + 2985984 #^12& , 2, 0]}, {
             Root[
              7921 - 243408 #^2 + 2368224 #^4 - 6189696 #^6 - 10430208 #^8 + 
               497664 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 112 #^2 + 3552 #^4 - 28544 #^6 + 55552 #^8 - 47104 #^10 + 
               4096 #^12& , 8, 0], Root[
              39601 - 1972104 #^2 + 10693296 #^4 - 22783680 #^6 + 
               24219648 #^8 - 13188096 #^10 + 2985984 #^12& , 7, 0]}, {
             Root[130321 - 2833128 #^2 + 13293648 #^4 - 3652992 #^6 - 
               373248 #^8 - 7962624 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 56 #^2 + 912 #^4 - 6016 #^6 + 15872 #^8 - 12288 #^10 + 
               4096 #^12& , 3, 0], Root[
              121 - 65304 #^2 + 519408 #^4 + 1740096 #^6 - 10450944 #^8 - 
               30108672 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[130321 - 2833128 #^2 + 13293648 #^4 - 3652992 #^6 - 
               373248 #^8 - 7962624 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 56 #^2 + 912 #^4 - 6016 #^6 + 15872 #^8 - 12288 #^10 + 
               4096 #^12& , 3, 0], Root[
              121 - 65304 #^2 + 519408 #^4 + 1740096 #^6 - 10450944 #^8 - 
               30108672 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 4344 #^2 + 1629072 #^4 - 7603200 #^6 - 13291776 #^8 - 
               8211456 #^10 + 2985984 #^12& , 1, 0], Root[
              121 - 3176 #^2 + 26576 #^4 - 80128 #^6 + 83712 #^8 - 33792 #^10 + 
               4096 #^12& , 1, 0], Root[
              212521 - 2031960 #^2 + 3632688 #^4 + 6053184 #^6 + 2820096 #^8 - 
               14183424 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 4344 #^2 + 1629072 #^4 - 7603200 #^6 - 13291776 #^8 - 
               8211456 #^10 + 2985984 #^12& , 8, 0], Root[
              121 - 3176 #^2 + 26576 #^4 - 80128 #^6 + 83712 #^8 - 33792 #^10 + 
               4096 #^12& , 1, 0], Root[
              212521 - 2031960 #^2 + 3632688 #^4 + 6053184 #^6 + 2820096 #^8 - 
               14183424 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[5041 - 854424 #^2 + 4100688 #^4 - 3176064 #^6 - 3608064 #^8 + 
               995328 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 56 #^2 + 912 #^4 - 6016 #^6 + 15872 #^8 - 12288 #^10 + 
               4096 #^12& , 6, 0], Root[
              1 - 146088 #^2 + 1720368 #^4 - 10141632 #^6 + 32596992 #^8 - 
               39066624 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[5041 - 854424 #^2 + 4100688 #^4 - 3176064 #^6 - 3608064 #^8 + 
               995328 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 56 #^2 + 912 #^4 - 6016 #^6 + 15872 #^8 - 12288 #^10 + 
               4096 #^12& , 6, 0], Root[
              1 - 146088 #^2 + 1720368 #^4 - 10141632 #^6 + 32596992 #^8 - 
               39066624 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 900 #^2 + 101088 #^4 - 29977344 #^6 + 1289696256 #^8 - 
               10405656576 #^10 + 2869530624 #^12& , 1, 0], Root[
              1 - 300 #^2 + 11232 #^4 - 1110272 #^6 + 15922176 #^8 - 
               42821632 #^10 + 3936256 #^12& , 1, 0], Root[
              1 - 360 #^2 + 1567728 #^4 - 197429184 #^6 + 1651746816 #^8 - 
               3954686976 #^10 + 2869530624 #^12& , 7, 0]}, {
             Root[1 - 900 #^2 + 101088 #^4 - 29977344 #^6 + 1289696256 #^8 - 
               10405656576 #^10 + 2869530624 #^12& , 1, 0], Root[
              1 - 300 #^2 + 11232 #^4 - 1110272 #^6 + 15922176 #^8 - 
               42821632 #^10 + 3936256 #^12& , 8, 0], Root[
              1 - 360 #^2 + 1567728 #^4 - 197429184 #^6 + 1651746816 #^8 - 
               3954686976 #^10 + 2869530624 #^12& , 7, 0]}, {
             Root[1 - 900 #^2 + 101088 #^4 - 29977344 #^6 + 1289696256 #^8 - 
               10405656576 #^10 + 2869530624 #^12& , 8, 0], Root[
              1 - 300 #^2 + 11232 #^4 - 1110272 #^6 + 15922176 #^8 - 
               42821632 #^10 + 3936256 #^12& , 1, 0], Root[
              1 - 360 #^2 + 1567728 #^4 - 197429184 #^6 + 1651746816 #^8 - 
               3954686976 #^10 + 2869530624 #^12& , 2, 0]}, {
             Root[1 - 900 #^2 + 101088 #^4 - 29977344 #^6 + 1289696256 #^8 - 
               10405656576 #^10 + 2869530624 #^12& , 8, 0], Root[
              1 - 300 #^2 + 11232 #^4 - 1110272 #^6 + 15922176 #^8 - 
               42821632 #^10 + 3936256 #^12& , 8, 0], Root[
              1 - 360 #^2 + 1567728 #^4 - 197429184 #^6 + 1651746816 #^8 - 
               3954686976 #^10 + 2869530624 #^12& , 2, 0]}, {
             Root[1 - 420 #^2 + 259488 #^4 - 74877696 #^6 + 1328161536 #^8 - 
               4786781184 #^10 + 2869530624 #^12& , 1, 0], Root[
              1 - 140 #^2 + 28832 #^4 - 2773248 #^6 + 16397056 #^8 - 
               19698688 #^10 + 3936256 #^12& , 1, 0], Root[
              1 - 2280 #^2 + 300528 #^4 - 19797696 #^6 + 1344024576 #^8 - 
               26430188544 #^10 + 2869530624 #^12& , 1, 0]}, {
             Root[1 - 420 #^2 + 259488 #^4 - 74877696 #^6 + 1328161536 #^8 - 
               4786781184 #^10 + 2869530624 #^12& , 1, 0], Root[
              1 - 140 #^2 + 28832 #^4 - 2773248 #^6 + 16397056 #^8 - 
               19698688 #^10 + 3936256 #^12& , 8, 0], Root[
              1 - 2280 #^2 + 300528 #^4 - 19797696 #^6 + 1344024576 #^8 - 
               26430188544 #^10 + 2869530624 #^12& , 1, 0]}, {
             Root[1 - 420 #^2 + 259488 #^4 - 74877696 #^6 + 1328161536 #^8 - 
               4786781184 #^10 + 2869530624 #^12& , 8, 0], Root[
              1 - 140 #^2 + 28832 #^4 - 2773248 #^6 + 16397056 #^8 - 
               19698688 #^10 + 3936256 #^12& , 1, 0], Root[
              1 - 2280 #^2 + 300528 #^4 - 19797696 #^6 + 1344024576 #^8 - 
               26430188544 #^10 + 2869530624 #^12& , 8, 0]}, {
             Root[1 - 420 #^2 + 259488 #^4 - 74877696 #^6 + 1328161536 #^8 - 
               4786781184 #^10 + 2869530624 #^12& , 8, 0], Root[
              1 - 140 #^2 + 28832 #^4 - 2773248 #^6 + 16397056 #^8 - 
               19698688 #^10 + 3936256 #^12& , 8, 0], Root[
              1 - 2280 #^2 + 300528 #^4 - 19797696 #^6 + 1344024576 #^8 - 
               26430188544 #^10 + 2869530624 #^12& , 8, 0]}}, {{
             0, 0, -3.6322037888637904`}, {
             0, 0, 3.6322037888637904`}, {-2.4214691925758602`, 
              0, -2.707284860010576}, {
             2.4214691925758602`, 0, 2.707284860010576}, {-3.740934376726981, 
              0, -0.7144548911134015}, {
             3.740934376726981, 0, 0.7144548911134015}, {-2.312024594500178, 
              0, 3.0264794856135793`}, {
             2.312024594500178, 
              0, -3.0264794856135793`}, {-2.9738836353273794`, 
             1.2495037884630271`, -1.6696289318243818`}, {2.9738836353273794`,
              1.2495037884630271`, 
             1.6696289318243818`}, {-3.2033308030956054`, \
-1.6469179406903744`, -0.46822796414515255`}, {
             3.2033308030956054`, -1.6469179406903744`, 
             0.46822796414515255`}, {-2.891224897457488, -0.6430296059140725, \
-2.1024357022454705`}, {2.891224897457488, -0.6430296059140725, 
             2.1024357022454705`}, {-3.337075450436258, 1.4152654162559821`, 
             0.23206810095724179`}, {3.337075450436258, 
             1.4152654162559821`, -0.23206810095724179`}, \
{-3.478881598739421, -0.3748216581145623, 0.9745747331000193}, {
             3.478881598739421, -0.3748216581145623, -0.9745747331000193}, \
{-0.175392626961585, 3.597624822551189, 0.46822796414515255`}, {
             0.175392626961585, 
             3.597624822551189, -0.46822796414515255`}, {-2.707284860010576, \
-2.0970538352520878`, -1.2107345962879301`}, {-2.707284860010576, 
             2.0970538352520878`, -1.2107345962879301`}, {
             2.707284860010576, -2.0970538352520878`, 1.2107345962879301`}, {
             2.707284860010576, 2.0970538352520878`, 
             1.2107345962879301`}, {-2.464007691561295, 
             0.9739506306439168, -2.4845503876620354`}, {2.464007691561295, 
             0.9739506306439168, 2.4845503876620354`}, {-3.2427217355515103`, 
             0.3748216581145623, 1.5928492817044948`}, {3.2427217355515103`, 
             0.3748216581145623, -1.5928492817044948`}, \
{-3.0279381761340205`, -1.9507068818608146`, 0.46822796414515255`}, {
             3.0279381761340205`, -1.9507068818608146`, \
-0.46822796414515255`}, {-2.8941935287933678`, 
             2.1823594062952067`, -0.23206810095724179`}, {
             2.8941935287933678`, 2.1823594062952067`, 
             0.23206810095724179`}, {-3.1697443244371835`, \
-1.2960505464241128`, 1.2107345962879301`}, {-3.1697443244371835`, 
             1.2960505464241128`, 1.2107345962879301`}, {
             3.1697443244371835`, -1.2960505464241128`, \
-1.2107345962879301`}, {3.1697443244371835`, 
             1.2960505464241128`, -1.2107345962879301`}, \
{-2.5466664294311863`, -1.5804248131928715`, -2.0517436172409464`}, {
             2.5466664294311863`, -1.5804248131928715`, 
             2.0517436172409464`}, {-0.7533680014879535, 0.6430296059140725, 
             3.4945463144861186`}, {0.7533680014879535, 
             0.6430296059140725, -3.4945463144861186`}, \
{-0.44288192164289053`, -3.597624822551189, -0.23206810095724179`}, {
             0.44288192164289053`, -3.597624822551189, 
             0.23206810095724179`}, {-0.40483979472981085`, \
-3.2002106703238415`, 1.6696289318243818`}, {
             0.40483979472981085`, -3.2002106703238415`, \
-1.6696289318243818`}, {-1.1035160340391508`, -1.2495037884630271`, 
             3.2270570198048127`}, {
             1.1035160340391508`, -1.2495037884630271`, \
-3.2270570198048127`}, {-0.462459464426607, -3.393104381676201, \
-1.2107345962879301`}, {-0.462459464426607, 
             3.393104381676201, -1.2107345962879301`}, {
             0.462459464426607, -3.393104381676201, 1.2107345962879301`}, {
             0.462459464426607, 3.393104381676201, 
             1.2107345962879301`}, {-0.5303440059143036, 1.5804248131928715`, 
             3.2270570198048127`}, {0.5303440059143036, 
             1.5804248131928715`, -3.2270570198048127`}, \
{-0.3885378576111407, -2.620868571334291, 2.4845503876620354`}, {
             0.3885378576111407, -2.620868571334291, -2.4845503876620354`}, \
{-2.6420212517118955`, -1.4152654162559821`, 2.0517436172409464`}, {
             2.6420212517118955`, -1.4152654162559821`, \
-2.0517436172409464`}, {-0.0953548222807093, 
             2.9956902294488534`, -2.0517436172409464`}, {0.0953548222807093, 
             2.9956902294488534`, 
             2.0517436172409464`}, {-2.064045877185527, -2.8253890122092793`, \
-0.9745747331000193}, {2.064045877185527, -2.8253890122092793`, 
             0.9745747331000193}, {-2.0754698339501543`, 1.6469179406903744`, 
             2.4845503876620354`}, {2.0754698339501543`, 
             1.6469179406903744`, -2.4845503876620354`}, \
{-0.1801959733631064, -0.9739506306439168, 3.4945463144861186`}, {
             0.1801959733631064, -0.9739506306439168, -3.4945463144861186`}, \
{-0.8887324746216608, 2.8253890122092793`, 2.1024357022454705`}, {
             0.8887324746216608, 
             2.8253890122092793`, -2.1024357022454705`}, \
{-2.5690438405975686`, 1.9507068818608146`, 1.6696289318243818`}, {
             2.5690438405975686`, 
             1.9507068818608146`, -1.6696289318243818`}, \
{-1.2107345962879301`, -2.0970538352520878`, 
             2.707284860010576}, {-1.2107345962879301`, 2.0970538352520878`, 
             2.707284860010576}, {
             1.2107345962879301`, -2.0970538352520878`, -2.707284860010576}, {
             1.2107345962879301`, 
             2.0970538352520878`, -2.707284860010576}, {-1.2967557899599385`, \
-2.9956902294488534`, -1.5928492817044948`}, {
             1.2967557899599385`, -2.9956902294488534`, 
             1.5928492817044948`}, {-1.9459659455915719`, 
             2.620868571334291, -1.5928492817044948`}, {1.9459659455915719`, 
             2.620868571334291, 1.5928492817044948`}, {-1.4148357215538938`, 
             3.2002106703238415`, -0.9745747331000193}, {1.4148357215538938`, 
             3.2002106703238415`, 
             0.9745747331000193}, {-1.6338600399534542`, \
-0.33092102472984425`, -3.2270570198048127`}, {
             1.6338600399534542`, -0.33092102472984425`, 
             3.2270570198048127`}, {-2.002492422835827, -2.1823594062952067`, 
             2.1024357022454705`}, {
             2.002492422835827, -2.1823594062952067`, -2.1024357022454705`}, \
{-0.9335639748510599, 0.33092102472984425`, -3.4945463144861186`}, {
             0.9335639748510599, 0.33092102472984425`, 
             3.4945463144861186`}, {-1.8704671883634905`, -3.239744204136071, 
             0.7144548911134015}, {-1.8704671883634905`, 3.239744204136071, 
             0.7144548911134015}, {
             1.8704671883634905`, -3.239744204136071, -0.7144548911134015}, {
             1.8704671883634905`, 
             3.239744204136071, -0.7144548911134015}, {-1.156012297250089, \
-2.0022720330115695`, -3.0264794856135793`}, {-1.156012297250089, 
             2.0022720330115695`, -3.0264794856135793`}, {
             1.156012297250089, -2.0022720330115695`, 3.0264794856135793`}, {
             1.156012297250089, 2.0022720330115695`, 3.0264794856135793`}}], 
           Polygon3DBox[{{29, 33, 17, 5, 11}, {12, 30, 35, 18, 6}, {61, 67, 
            34, 27, 7}, {8, 62, 68, 36, 28}, {34, 15, 5, 17, 27}, {18, 28, 36,
             16, 6}, {75, 22, 31, 86, 77}, {32, 88, 78, 76, 24}, {7, 27, 17, 
            33, 55}, {35, 56, 8, 28, 18}, {90, 75, 77, 48, 57}, {76, 78, 50, 
            58, 92}, {65, 86, 67, 61, 70}, {62, 72, 66, 88, 68}, {9, 5, 15, 
            31, 22}, {6, 16, 32, 24, 10}, {45, 7, 55, 81, 69}, {82, 71, 46, 8,
             56}, {29, 11, 21, 59, 85}, {12, 23, 60, 87, 30}, {79, 3, 25, 90, 
            83}, {26, 92, 84, 80, 4}, {89, 79, 83, 1, 64}, {80, 84, 2, 63, 
            91}, {85, 81, 55, 33, 29}, {30, 87, 82, 56, 35}, {21, 11, 5, 13, 
            37}, {6, 14, 38, 23, 12}, {86, 31, 15, 34, 67}, {36, 68, 88, 32, 
            16}, {53, 69, 81, 85, 43}, {87, 44, 54, 71, 82}, {47, 73, 89, 54, 
            44}, {74, 91, 53, 43, 49}, {85, 59, 73, 47, 41}, {60, 74, 49, 42, 
            87}, {73, 59, 21, 37, 89}, {23, 38, 91, 74, 60}, {13, 5, 9, 25, 
            3}, {6, 10, 26, 4, 14}, {37, 13, 3, 79, 89}, {14, 4, 80, 91, 
            38}, {51, 70, 61, 7, 39}, {40, 52, 72, 62, 8}, {25, 9, 22, 75, 
            90}, {10, 24, 76, 92, 26}, {1, 83, 90, 52, 40}, {92, 51, 39, 2, 
            84}, {48, 77, 86, 19, 20}, {88, 20, 19, 50, 78}, {50, 19, 86, 65, 
            58}, {66, 57, 48, 20, 88}, {92, 58, 65, 70, 51}, {52, 90, 57, 66, 
            72}, {2, 39, 7, 45, 63}, {46, 64, 1, 40, 8}, {49, 43, 85, 41, 
            42}, {42, 41, 47, 44, 87}, {91, 63, 45, 69, 53}, {54, 89, 64, 46, 
            71}}]]],
         "\"pentagonal hexecontahedron\""],
        Annotation[#, "pentagonal hexecontahedron", "Tooltip"]& ],
       TraditionalForm], {585., -967.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, 0, Rational[-1, 2] (15 + 33 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             0, 0, Rational[1, 2] (15 + 33 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             0, Rational[-1, 2] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              0}, {0, Rational[1, 2] (15 + 33 5^Rational[-1, 2])^
               Rational[1, 2], 0}, {
             0, -(Rational[5, 6] + Rational[1, 3] 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 2] (Rational[41, 3] + 
                Rational[89, 3] 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, (Rational[5, 6] + Rational[1, 3] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[-1, 2] (Rational[41, 3] + 
                Rational[89, 3] 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, -(Rational[5, 6] + Rational[1, 3] 5^Rational[-1, 2])^
               Rational[1, 2], (Rational[41, 12] + 
               Rational[89, 12] 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, (Rational[5, 6] + Rational[1, 3] 5^Rational[-1, 2])^
              Rational[1, 2], (Rational[41, 12] + 
               Rational[89, 12] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 0, 
              0}, {Rational[1, 2] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              0, 
              0}, {(-11) (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2], (-11) (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2], (-11) (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2]}, {
             11 (255 - 93 5^Rational[1, 2])^Rational[-1, 2], 
              11 (255 - 93 5^Rational[1, 2])^Rational[-1, 2], 
              11 (255 - 93 5^Rational[1, 2])^Rational[-1, 2]}, {
             Rational[-1, 2] (Rational[41, 3] + 
                Rational[89, 3] 5^Rational[-1, 2])^Rational[1, 2], 
              0, -(Rational[5, 6] + Rational[1, 3] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 6] + 
                Rational[1, 3] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[41, 3] + 
                Rational[89, 3] 5^Rational[-1, 2])^Rational[1, 2], 0}, {
             Rational[-1, 2] (Rational[3, 2] + 3 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[3, 2] + 3 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[3, 2] + 3 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 2] (Rational[3, 2] + 3 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[3, 2] + 3 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[3, 2] + 3 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 2] (Rational[41, 3] + 
                Rational[89, 3] 5^Rational[-1, 2])^Rational[1, 2], 
              0, (Rational[5, 6] + Rational[1, 3] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[5, 6] + 
               Rational[1, 3] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[41, 3] + 
                Rational[89, 3] 5^Rational[-1, 2])^Rational[1, 2], 0}, {
             Rational[-1, 10] (123 + 267 5^Rational[-1, 2])^Rational[1, 2], 0,
               Rational[-1, 5] (Rational[159, 2] + 177 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 5] (Rational[159, 2] + 177 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 10] (123 + 267 5^Rational[-1, 2])^Rational[1, 2], 
              0}, {0, Rational[-1, 5] (Rational[159, 2] + 
                177 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 10] (123 + 267 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], (
               Rational[3, 8] + Rational[3, 4] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[-1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], (
               Rational[3, 8] + Rational[3, 4] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[3, 8] + 
               Rational[3, 4] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], (
               Rational[3, 8] + Rational[3, 4] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], (
               Rational[3, 8] + Rational[3, 4] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[3, 8] + 
               Rational[3, 4] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 5] (Rational[159, 2] + 177 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 10] (123 + 267 5^Rational[-1, 2])^Rational[1, 2], 
              0}, {0, Rational[-1, 5] (Rational[159, 2] + 
                177 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 10] (123 + 267 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 10] (123 + 267 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[-1, 5] (Rational[159, 2] + 177 5^Rational[-1, 2])^
               Rational[1, 2]}, {(-11) (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2], (-11) (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2], 
              11 (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2]}, {(-11) (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2], 
              11 (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2], (-11) (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2]}, {
             11 (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2], (-11) (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2], (-11) (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2]}, {(-11) (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2], 
              11 (255 - 93 5^Rational[1, 2])^Rational[-1, 2], 
              11 (255 - 93 5^Rational[1, 2])^Rational[-1, 2]}, {
             11 (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2], (-11) (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2], 
              11 (255 - 93 5^Rational[1, 2])^Rational[-1, 2]}, {
             11 (255 - 93 5^Rational[1, 2])^Rational[-1, 2], 
              11 (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2], (-11) (255 - 93 5^Rational[1, 2])^
               Rational[-1, 2]}, {
             Rational[-1, 2] (Rational[3, 2] + 3 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[3, 2] + 3 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[3, 2] + 3 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[3, 2] + 3 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[3, 2] + 3 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (Rational[3, 2] + 3 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], (
               Rational[3, 8] + Rational[3, 4] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[3, 8] + 
               Rational[3, 4] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], (
               Rational[3, 8] + Rational[3, 4] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[-1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], (
               Rational[3, 8] + Rational[3, 4] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[3, 8] + 
               Rational[3, 4] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (15 + 33 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (39 + 87 5^Rational[-1, 2])^Rational[1, 2], (
               Rational[3, 8] + Rational[3, 4] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[1, 4] (15 + 33 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 6] + 
                Rational[1, 3] 5^Rational[-1, 2])^Rational[1, 2], (
               Rational[41, 12] + Rational[89, 12] 5^Rational[-1, 2])^
              Rational[1, 2], 
              0}, {(Rational[41, 12] + Rational[89, 12] 5^Rational[-1, 2])^
              Rational[1, 2], 
              0, -(Rational[5, 6] + Rational[1, 3] 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[5, 6] + 
               Rational[1, 3] 5^Rational[-1, 2])^
              Rational[1, 2], (Rational[41, 12] + 
               Rational[89, 12] 5^Rational[-1, 2])^Rational[1, 2], 
              0}, {(Rational[41, 12] + Rational[89, 12] 5^Rational[-1, 2])^
              Rational[1, 2], 
              0, (Rational[5, 6] + Rational[1, 3] 5^Rational[-1, 2])^
              Rational[1, 2]}, {
             Rational[-1, 10] (123 + 267 5^Rational[-1, 2])^Rational[1, 2], 0,
               Rational[1, 5] (Rational[159, 2] + 177 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             0, Rational[1, 5] (Rational[159, 2] + 177 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 10] (123 + 267 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[1, 5] (Rational[159, 2] + 177 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 10] (123 + 267 5^Rational[-1, 2])^Rational[1, 2], 
              0}, {0, Rational[
               1, 5] (Rational[159, 2] + 177 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 10] (123 + 267 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 10] (123 + 267 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[1, 5] (Rational[159, 2] + 177 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[1, 5] (Rational[159, 2] + 177 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 10] (123 + 267 5^Rational[-1, 2])^Rational[1, 2], 
              0}}, {{0, 0, -2.7275469130474463`}, {
             0, 0, 2.7275469130474463`}, {0, -2.7275469130474463`, 0}, {
             0, 2.7275469130474463`, 0}, {
             0, -0.9911632215903289, -2.5948990025223244`}, {
             0, 0.9911632215903289, -2.5948990025223244`}, {
             0, -0.9911632215903289, 2.5948990025223244`}, {
             0, 0.9911632215903289, 
              2.5948990025223244`}, {-2.7275469130474463`, 0, 0}, {
             2.7275469130474463`, 0, 
              0}, {-1.6037357809319959`, -1.6037357809319959`, \
-1.6037357809319959`}, {1.6037357809319959`, 1.6037357809319959`, 
             1.6037357809319959`}, {-2.5948990025223244`, 
              0, -0.9911632215903289}, {-0.9911632215903289, \
-2.5948990025223244`, 
              0}, {-0.842858349086588, -1.3637734565237232`, \
-2.2066318056103107`}, {-2.2066318056103107`, -0.842858349086588, \
-1.3637734565237232`}, {-1.3637734565237232`, -2.2066318056103107`, \
-0.842858349086588}, {-0.842858349086588, 
             1.3637734565237232`, -2.2066318056103107`}, \
{-2.2066318056103107`, -0.842858349086588, 1.3637734565237232`}, {
             1.3637734565237232`, -2.2066318056103107`, -0.842858349086588}, \
{-2.5948990025223244`, 0, 0.9911632215903289}, {
             0.9911632215903289, -2.5948990025223244`, 
              0}, {-1.5569394015133948`, 
              0, -2.519180870072592}, {-2.519180870072592, \
-1.5569394015133948`, 0}, {
             0, -2.519180870072592, -1.5569394015133948`}, \
{-2.2066318056103107`, 
             0.842858349086588, -1.3637734565237232`}, {-1.3637734565237232`, \
-2.2066318056103107`, 0.842858349086588}, {
             0.842858349086588, -1.3637734565237232`, -2.2066318056103107`}, \
{-2.2066318056103107`, 0.842858349086588, 1.3637734565237232`}, {
             1.3637734565237232`, -2.2066318056103107`, 0.842858349086588}, {
             0.842858349086588, 
             1.3637734565237232`, -2.2066318056103107`}, {-2.519180870072592, 
              1.5569394015133948`, 0}, {
             0, -2.519180870072592, 1.5569394015133948`}, {
             1.5569394015133948`, 
              0, -2.519180870072592}, {-1.6037357809319959`, \
-1.6037357809319959`, 1.6037357809319959`}, {-1.6037357809319959`, 
             1.6037357809319959`, -1.6037357809319959`}, {
             1.6037357809319959`, -1.6037357809319959`, \
-1.6037357809319959`}, {-1.6037357809319959`, 1.6037357809319959`, 
             1.6037357809319959`}, {1.6037357809319959`, -1.6037357809319959`,
              1.6037357809319959`}, {1.6037357809319959`, 
             1.6037357809319959`, -1.6037357809319959`}, {-0.842858349086588, \
-1.3637734565237232`, 2.2066318056103107`}, {-1.3637734565237232`, 
             2.2066318056103107`, -0.842858349086588}, {
             2.2066318056103107`, -0.842858349086588, -1.3637734565237232`}, \
{-0.842858349086588, 1.3637734565237232`, 2.2066318056103107`}, {
             1.3637734565237232`, 2.2066318056103107`, -0.842858349086588}, {
             2.2066318056103107`, -0.842858349086588, 
             1.3637734565237232`}, {-1.3637734565237232`, 2.2066318056103107`,
              0.842858349086588}, {0.842858349086588, -1.3637734565237232`, 
             2.2066318056103107`}, {2.2066318056103107`, 
             0.842858349086588, -1.3637734565237232`}, {1.3637734565237232`, 
             2.2066318056103107`, 0.842858349086588}, {0.842858349086588, 
             1.3637734565237232`, 2.2066318056103107`}, {2.2066318056103107`, 
             0.842858349086588, 
             1.3637734565237232`}, {-0.9911632215903289, 2.5948990025223244`, 
              0}, {2.5948990025223244`, 0, -0.9911632215903289}, {
             0.9911632215903289, 2.5948990025223244`, 0}, {
             2.5948990025223244`, 0, 
              0.9911632215903289}, {-1.5569394015133948`, 0, 
              2.519180870072592}, {
             0, 2.519180870072592, -1.5569394015133948`}, {
             2.519180870072592, -1.5569394015133948`, 0}, {
             0, 2.519180870072592, 1.5569394015133948`}, {
             1.5569394015133948`, 0, 2.519180870072592}, {
             2.519180870072592, 1.5569394015133948`, 0}}], 
           Polygon3DBox[{{15, 23, 5}, {41, 7, 57}, {6, 23, 18}, {57, 8, 44}, {
            5, 23, 1}, {57, 7, 2}, {1, 23, 6}, {2, 8, 57}, {14, 25, 3}, {3, 
            33, 14}, {25, 15, 5}, {7, 41, 33}, {58, 53, 4}, {4, 53, 60}, {6, 
            18, 58}, {60, 44, 8}, {34, 5, 1}, {7, 61, 2}, {1, 6, 34}, {2, 61, 
            8}, {25, 22, 3}, {3, 22, 33}, {5, 28, 25}, {33, 48, 7}, {55, 58, 
            4}, {4, 60, 55}, {58, 31, 6}, {8, 51, 60}, {28, 5, 34}, {48, 61, 
            7}, {34, 6, 31}, {8, 61, 51}, {13, 16, 24}, {24, 19, 21}, {32, 26,
             13}, {21, 29, 32}, {16, 11, 24}, {24, 35, 19}, {32, 36, 26}, {29,
             38, 32}, {15, 11, 23}, {57, 35, 41}, {36, 18, 23}, {57, 44, 
            38}, {17, 25, 14}, {14, 33, 27}, {11, 15, 25}, {33, 41, 35}, {18, 
            36, 58}, {44, 60, 38}, {42, 53, 58}, {60, 53, 47}, {23, 11, 16}, {
            19, 35, 57}, {26, 36, 23}, {57, 38, 29}, {9, 13, 24}, {24, 21, 
            9}, {32, 13, 9}, {9, 21, 32}, {11, 25, 17}, {27, 33, 35}, {42, 58,
             36}, {47, 38, 60}, {23, 16, 13}, {21, 19, 57}, {13, 26, 23}, {57,
             29, 21}, {17, 14, 24}, {24, 14, 27}, {32, 53, 42}, {47, 53, 
            32}, {24, 11, 17}, {27, 35, 24}, {42, 36, 32}, {32, 38, 47}, {25, 
            37, 20}, {39, 33, 30}, {40, 58, 45}, {50, 60, 12}, {20, 37, 59}, {
            59, 39, 30}, {62, 40, 45}, {50, 12, 62}, {59, 54, 10}, {10, 56, 
            59}, {10, 54, 62}, {62, 56, 10}, {59, 22, 20}, {30, 22, 59}, {45, 
            55, 62}, {62, 55, 50}, {20, 22, 25}, {33, 22, 30}, {37, 25, 28}, {
            33, 39, 48}, {40, 31, 58}, {60, 51, 12}, {45, 58, 55}, {55, 60, 
            50}, {43, 37, 34}, {61, 39, 46}, {34, 40, 49}, {52, 12, 61}, {54, 
            43, 34}, {61, 46, 56}, {34, 49, 54}, {56, 52, 61}, {37, 28, 34}, {
            61, 48, 39}, {31, 40, 34}, {61, 12, 51}, {59, 37, 43}, {46, 39, 
            59}, {49, 40, 62}, {62, 12, 52}, {59, 43, 54}, {56, 46, 59}, {54, 
            49, 62}, {62, 52, 56}}]]],
         "\"disdyakis triacontahedron\""],
        Annotation[#, "disdyakis triacontahedron", "Tooltip"]& ],
       TraditionalForm], {975., -967.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], 
     TagBox[InsetBox["", {1365., -967.5}, {Center, Center}, {360., 360.}],
      "InsetString"], 
     TagBox[InsetBox["", {1755., -967.5}, {Center, Center}, {360., 360.}],
      "InsetString"]}}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 ImageSize->{364, 213},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->Automatic},
 Graphics3DBoxOptions->{ImageSize->Automatic},
 CellLabel->"Out[4]=",
 CellID->1989464004]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->969839309],

Cell["Archimedean solids:", "ExampleText",
 CellID->233499154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<Archimedean\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->967658209],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Cuboctahedron\"\>", ",", "\<\"GreatRhombicosidodecahedron\"\>",
    ",", "\<\"GreatRhombicuboctahedron\"\>", ",", "\<\"Icosidodecahedron\"\>",
    ",", "\<\"SmallRhombicosidodecahedron\"\>", 
   ",", "\<\"SmallRhombicuboctahedron\"\>", ",", "\<\"SnubCube\"\>", 
   ",", "\<\"SnubDodecahedron\"\>", ",", "\<\"TruncatedCube\"\>", 
   ",", "\<\"TruncatedDodecahedron\"\>", ",", "\<\"TruncatedIcosahedron\"\>", 
   ",", "\<\"TruncatedOctahedron\"\>", ",", "\<\"TruncatedTetrahedron\"\>"}], 
  "}"}]], "Output",
 ImageSize->{517, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->601131438]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Tooltip", "@@@", 
     RowBox[{"Rest", "/@", 
      RowBox[{"Sort", "[", 
       RowBox[{"PolyhedronData", "[", 
        RowBox[{"\"\<Archimedean\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<FaceCount\>\"", ",", "\"\<Image\>\"", ",", "\"\<Name\>\""}], 
          "}"}]}], "]"}], "]"}]}]}], ",", "5", ",", "5", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1053206901],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, -1, Rational[-1, 2] Rational[3, 2]^Rational[1, 2]}, {
             0, 1, Rational[-1, 2] 
              Rational[3, 2]^Rational[1, 2]}, {-3^Rational[-1, 2], -1, 
              Rational[1, 2] 6^Rational[-1, 2]}, {-3^Rational[-1, 2], 1, 
              Rational[1, 2] 6^Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[5, 2] 6^Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[5, 2] 6^Rational[-1, 2]}, {
             3^Rational[-1, 2], 0, Rational[5, 2] 6^Rational[-1, 2]}, {
             2 3^Rational[-1, 2], 0, Rational[1, 2] 6^Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2] Rational[3, 2]^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2] Rational[3, 2]^Rational[1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2] Rational[3, 2]^Rational[1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[1, 2], Rational[-1, 2] 
              Rational[3, 2]^Rational[1, 2]}}, {{
             0, -1, -0.6123724356957945}, {
             0, 1, -0.6123724356957945}, {-0.5773502691896258, -1, 
              0.20412414523193154`}, {-0.5773502691896258, 1, 
              0.20412414523193154`}, {-0.2886751345948129, -0.5, 
             1.0206207261596576`}, {-0.2886751345948129, 0.5, 
             1.0206207261596576`}, {
             0.5773502691896258, 0, 1.0206207261596576`}, {
             1.1547005383792517`, 0, 
              0.20412414523193154`}, {-0.8660254037844386, -0.5, \
-0.6123724356957945}, {-0.8660254037844386, 0.5, -0.6123724356957945}, {
             0.8660254037844386, -0.5, -0.6123724356957945}, {
             0.8660254037844386, 0.5, -0.6123724356957945}}], 
           Polygon3DBox[{{11, 12, 8}, {3, 9, 1}, {2, 10, 4}, {6, 5, 7}, {11, 
             8, 7, 5, 3, 1}, {2, 4, 6, 7, 8, 12}, {9, 3, 5, 6, 4, 10}, {2, 12,
              11, 1, 9, 10}}]]],
         "\"truncated tetrahedron\""],
        Annotation[#, "truncated tetrahedron", "Tooltip"]& ],
       TraditionalForm], {195., -193.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{-1, 0, 0}, {
             Rational[-1, 2], Rational[-1, 2], -2^Rational[-1, 2]}, {
             Rational[-1, 2], Rational[-1, 2], 2^Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2], -2^Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2], 2^Rational[-1, 2]}, {0, -1, 
             0}, {0, 1, 0}, {
             Rational[1, 2], Rational[-1, 2], -2^Rational[-1, 2]}, {
             Rational[1, 2], Rational[-1, 2], 2^Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2], -2^Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2], 2^Rational[-1, 2]}, {1, 0, 
             0}}, {{-1, 0, 0}, {-0.5, -0.5, -0.7071067811865475}, {-0.5, -0.5,
              0.7071067811865475}, {-0.5, 0.5, -0.7071067811865475}, {-0.5, 
             0.5, 0.7071067811865475}, {0, -1, 0}, {0, 1, 0}, {
             0.5, -0.5, -0.7071067811865475}, {0.5, -0.5, 
             0.7071067811865475}, {0.5, 0.5, -0.7071067811865475}, {0.5, 0.5, 
             0.7071067811865475}, {1, 0, 0}}], 
           Polygon3DBox[{{4, 10, 8, 2}, {3, 9, 11, 5}, {9, 6, 8, 12}, {3, 1, 
             2, 6}, {5, 7, 4, 1}, {11, 12, 10, 7}, {12, 11, 9}, {3, 5, 1}, {6,
              9, 3}, {5, 11, 7}, {8, 10, 12}, {1, 4, 2}, {2, 8, 6}, {7, 10, 
             4}}]]],
         "\"cuboctahedron\""],
        Annotation[#, "cuboctahedron", "Tooltip"]& ],
       TraditionalForm], {585., -193.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{Rational[-3, 2], Rational[-1, 2], 0}, {
             Rational[-3, 2], Rational[1, 2], 
              0}, {-1, -1, -2^Rational[-1, 2]}, {-1, -1, 2^
              Rational[-1, 2]}, {-1, 1, -2^Rational[-1, 2]}, {-1, 1, 2^
              Rational[-1, 2]}, {Rational[-1, 2], Rational[-3, 2], 0}, {
             Rational[-1, 2], Rational[-1, 2], -2^Rational[1, 2]}, {
             Rational[-1, 2], Rational[-1, 2], 2^Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2], -2^Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2], 2^Rational[1, 2]}, {
             Rational[-1, 2], Rational[3, 2], 0}, {
             Rational[1, 2], Rational[-3, 2], 0}, {
             Rational[1, 2], Rational[-1, 2], -2^Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2], 2^Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2], -2^Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2], 2^Rational[1, 2]}, {
             Rational[1, 2], Rational[3, 2], 0}, {
             1, -1, -2^Rational[-1, 2]}, {1, -1, 2^Rational[-1, 2]}, {
             1, 1, -2^Rational[-1, 2]}, {1, 1, 2^Rational[-1, 2]}, {
             Rational[3, 2], Rational[-1, 2], 0}, {
             Rational[3, 2], Rational[1, 2], 0}}, {{-1.5, -0.5, 0}, {-1.5, 
              0.5, 0}, {-1, -1, -0.7071067811865475}, {-1, -1, 
              0.7071067811865475}, {-1, 1, -0.7071067811865475}, {-1, 1, 
              0.7071067811865475}, {-0.5, -1.5, 
              0}, {-0.5, -0.5, -1.4142135623730951`}, {-0.5, -0.5, 
             1.4142135623730951`}, {-0.5, 0.5, -1.4142135623730951`}, {-0.5, 
             0.5, 1.4142135623730951`}, {-0.5, 1.5, 0}, {0.5, -1.5, 0}, {
             0.5, -0.5, -1.4142135623730951`}, {0.5, -0.5, 
             1.4142135623730951`}, {0.5, 0.5, -1.4142135623730951`}, {0.5, 
             0.5, 1.4142135623730951`}, {0.5, 1.5, 0}, {
             1, -1, -0.7071067811865475}, {1, -1, 0.7071067811865475}, {
             1, 1, -0.7071067811865475}, {1, 1, 0.7071067811865475}, {
             1.5, -0.5, 0}, {1.5, 0.5, 0}}], 
           Polygon3DBox[{{17, 11, 9, 15}, {14, 8, 10, 16}, {22, 24, 21, 18}, {
             12, 5, 2, 6}, {13, 19, 23, 20}, {4, 1, 3, 7}, {19, 13, 7, 3, 8, 
             14}, {15, 9, 4, 7, 13, 20}, {16, 10, 5, 12, 18, 21}, {22, 18, 12,
              6, 11, 17}, {20, 23, 24, 22, 17, 15}, {14, 16, 21, 24, 23, 
             19}, {9, 11, 6, 2, 1, 4}, {3, 1, 2, 5, 10, 8}}]]],
         "\"truncated octahedron\""],
        Annotation[#, "truncated octahedron", "Tooltip"]& ],
       TraditionalForm], {975., -193.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2], Rational[1, 2] + 2^Rational[-1, 2], 
              Rational[1, 2] + 2^Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2] + 
              2^Rational[-1, 2], (2 - 2 2^Rational[1, 2])^(-1)}, {
             Rational[-1, 2], (2 - 2 2^Rational[1, 2])^(-1), Rational[1, 2] + 
              2^Rational[-1, 2]}, {
             Rational[-1, 2], (2 - 2 2^Rational[1, 2])^(-1), (2 - 2 
               2^Rational[1, 2])^(-1)}, {
             Rational[1, 2], Rational[1, 2] + 2^Rational[-1, 2], 
              Rational[1, 2] + 2^Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2] + 
              2^Rational[-1, 2], (2 - 2 2^Rational[1, 2])^(-1)}, {
             Rational[1, 2], (2 - 2 2^Rational[1, 2])^(-1), Rational[1, 2] + 
              2^Rational[-1, 2]}, {
             Rational[
              1, 2], (2 - 2 2^Rational[1, 2])^(-1), (2 - 2 
               2^Rational[1, 2])^(-1)}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[-1, 2], 
              Rational[1, 2] + 2^Rational[-1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], 
              Rational[-1, 2], (2 - 2 2^Rational[1, 2])^(-1)}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[1, 2], 
              Rational[1, 2] + 2^Rational[-1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[
              1, 2], (2 - 2 2^Rational[1, 2])^(-1)}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[1, 2] + 
              2^Rational[-1, 2], Rational[-1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[1, 2] + 
              2^Rational[-1, 2], Rational[1, 2]}, {
             Rational[1, 2] + 
              2^Rational[-1, 2], (2 - 2 2^Rational[1, 2])^(-1), 
              Rational[-1, 2]}, {
             Rational[1, 2] + 
              2^Rational[-1, 2], (2 - 2 2^Rational[1, 2])^(-1), Rational[
              1, 2]}, {(2 - 2 2^Rational[1, 2])^(-1), Rational[-1, 2], 
              Rational[1, 2] + 
              2^Rational[-1, 2]}, {(2 - 2 2^Rational[1, 2])^(-1), 
              Rational[-1, 2], (2 - 2 2^Rational[1, 2])^(-1)}, {(2 - 2 
               2^Rational[1, 2])^(-1), Rational[1, 2], Rational[1, 2] + 
              2^Rational[-1, 2]}, {(2 - 2 2^Rational[1, 2])^(-1), Rational[
              1, 2], (2 - 2 2^Rational[1, 2])^(-1)}, {(2 - 2 
               2^Rational[1, 2])^(-1), Rational[1, 2] + 2^Rational[-1, 2], 
              Rational[-1, 2]}, {(2 - 2 2^Rational[1, 2])^(-1), 
              Rational[1, 2] + 2^Rational[-1, 2], Rational[
              1, 2]}, {(2 - 2 2^Rational[1, 2])^(-1), (2 - 2 
               2^Rational[1, 2])^(-1), 
              Rational[-1, 2]}, {(2 - 2 2^Rational[1, 2])^(-1), (2 - 2 
               2^Rational[1, 2])^(-1), Rational[1, 2]}}, {{-0.5, 
            1.2071067811865475`, 1.2071067811865475`}, {-0.5, 
            1.2071067811865475`, -1.2071067811865472`}, {-0.5, \
-1.2071067811865472`, 
            1.2071067811865475`}, {-0.5, -1.2071067811865472`, \
-1.2071067811865472`}, {0.5, 1.2071067811865475`, 1.2071067811865475`}, {0.5, 
            1.2071067811865475`, -1.2071067811865472`}, {
            0.5, -1.2071067811865472`, 1.2071067811865475`}, {
            0.5, -1.2071067811865472`, -1.2071067811865472`}, {
            1.2071067811865475`, -0.5, 1.2071067811865475`}, {
            1.2071067811865475`, -0.5, -1.2071067811865472`}, {
            1.2071067811865475`, 0.5, 1.2071067811865475`}, {
            1.2071067811865475`, 0.5, -1.2071067811865472`}, {
            1.2071067811865475`, 1.2071067811865475`, -0.5}, {
            1.2071067811865475`, 1.2071067811865475`, 0.5}, {
            1.2071067811865475`, -1.2071067811865472`, -0.5}, {
            1.2071067811865475`, -1.2071067811865472`, 
            0.5}, {-1.2071067811865472`, -0.5, 
            1.2071067811865475`}, {-1.2071067811865472`, -0.5, \
-1.2071067811865472`}, {-1.2071067811865472`, 0.5, 
            1.2071067811865475`}, {-1.2071067811865472`, 
            0.5, -1.2071067811865472`}, {-1.2071067811865472`, 
            1.2071067811865475`, -0.5}, {-1.2071067811865472`, 
            1.2071067811865475`, 
            0.5}, {-1.2071067811865472`, -1.2071067811865472`, -0.5}, \
{-1.2071067811865472`, -1.2071067811865472`, 0.5}}], 
           Polygon3DBox[{{6, 12, 10, 8, 4, 18, 20, 2}, {1, 19, 17, 3, 7, 9, 
             11, 5}, {3, 24, 23, 4, 8, 15, 16, 7}, {5, 14, 13, 6, 2, 21, 22, 
             1}, {9, 16, 15, 10, 12, 13, 14, 11}, {19, 22, 21, 20, 18, 23, 24,
              17}, {16, 9, 7}, {5, 11, 14}, {3, 17, 24}, {22, 19, 1}, {8, 10, 
             15}, {13, 12, 6}, {23, 18, 4}, {2, 20, 21}}]]],
         "\"truncated cube\""],
        Annotation[#, "truncated cube", "Tooltip"]& ],
       TraditionalForm], {1365., -193.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2], Rational[-1, 2], Rational[-1, 2] - 2^
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[-1, 2], Rational[1, 2] + 
              2^Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2], Rational[-1, 2] - 2^
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2], Rational[1, 2] + 
              2^Rational[-1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] - 2^Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] - 2^Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[-1, 2], Rational[1, 2] + 2^Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2] + 2^Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[1, 2], Rational[-1, 2], Rational[-1, 2] - 2^
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[-1, 2], Rational[1, 2] + 
              2^Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2], Rational[-1, 2] - 2^
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2], Rational[1, 2] + 
              2^Rational[-1, 2]}, {
             Rational[1, 2], Rational[-1, 2] - 2^Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[-1, 2] - 2^Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[1, 2], Rational[1, 2] + 2^Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2] + 2^Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[-1, 2] - 2^Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2] - 2^Rational[-1, 2], Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[-1, 2] - 2^Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2] - 2^Rational[-1, 2], Rational[1, 2], Rational[
              1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[1, 2], Rational[
              1, 2]}}, {{-0.5, -0.5, -1.2071067811865475`}, {-0.5, -0.5, 
            1.2071067811865475`}, {-0.5, 0.5, -1.2071067811865475`}, {-0.5, 
            0.5, 1.2071067811865475`}, {-0.5, -1.2071067811865475`, -0.5}, \
{-0.5, -1.2071067811865475`, 0.5}, {-0.5, 1.2071067811865475`, -0.5}, {-0.5, 
            1.2071067811865475`, 0.5}, {0.5, -0.5, -1.2071067811865475`}, {
            0.5, -0.5, 1.2071067811865475`}, {0.5, 
            0.5, -1.2071067811865475`}, {0.5, 0.5, 1.2071067811865475`}, {
            0.5, -1.2071067811865475`, -0.5}, {0.5, -1.2071067811865475`, 
            0.5}, {0.5, 1.2071067811865475`, -0.5}, {0.5, 1.2071067811865475`,
             0.5}, {-1.2071067811865475`, -0.5, -0.5}, {-1.2071067811865475`, \
-0.5, 0.5}, {-1.2071067811865475`, 0.5, -0.5}, {-1.2071067811865475`, 0.5, 
            0.5}, {1.2071067811865475`, -0.5, -0.5}, {
            1.2071067811865475`, -0.5, 0.5}, {1.2071067811865475`, 
            0.5, -0.5}, {1.2071067811865475`, 0.5, 0.5}}], 
           Polygon3DBox[{{3, 11, 9, 1}, {2, 10, 12, 4}, {24, 22, 21, 23}, {19,
              17, 18, 20}, {5, 13, 14, 6}, {8, 16, 15, 7}, {13, 21, 22, 14}, {
             16, 24, 23, 15}, {6, 18, 17, 5}, {7, 19, 20, 8}, {6, 14, 10, 
             2}, {4, 12, 16, 8}, {22, 24, 12, 10}, {2, 4, 20, 18}, {1, 9, 13, 
             5}, {7, 15, 11, 3}, {9, 11, 23, 21}, {17, 19, 3, 1}, {22, 10, 
             14}, {16, 12, 24}, {6, 2, 18}, {20, 4, 8}, {13, 9, 21}, {23, 11, 
             15}, {17, 1, 5}, {7, 3, 19}}]]],
         "\"small rhombicuboctahedron\""],
        Annotation[#, "small rhombicuboctahedron", "Tooltip"]& ],
       TraditionalForm], {1755., -193.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2], Rational[1, 2] + 2^Rational[-1, 2], 
              Rational[-1, 2] - 2^Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2] + 2^Rational[-1, 2], 
              Rational[1, 2] + 2^Rational[1, 2]}, {
             Rational[-1, 2], (2 - 2 2^Rational[1, 2])^(-1), Rational[-1, 2] - 
              2^Rational[1, 2]}, {
             Rational[-1, 2], (2 - 2 2^Rational[1, 2])^(-1), Rational[1, 2] + 
              2^Rational[1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] - 2^Rational[1, 2], 
              Rational[1, 2] + 2^Rational[-1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] - 2^
              Rational[1, 2], (2 - 2 2^Rational[1, 2])^(-1)}, {
             Rational[-1, 2], Rational[1, 2] + 2^Rational[1, 2], 
              Rational[1, 2] + 2^Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2] + 
              2^Rational[1, 2], (2 - 2 2^Rational[1, 2])^(-1)}, {
             Rational[1, 2], Rational[1, 2] + 2^Rational[-1, 2], 
              Rational[-1, 2] - 2^Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2] + 2^Rational[-1, 2], 
              Rational[1, 2] + 2^Rational[1, 2]}, {
             Rational[1, 2], (2 - 2 2^Rational[1, 2])^(-1), Rational[-1, 2] - 
              2^Rational[1, 2]}, {
             Rational[1, 2], (2 - 2 2^Rational[1, 2])^(-1), Rational[1, 2] + 
              2^Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2] - 2^Rational[1, 2], 
              Rational[1, 2] + 2^Rational[-1, 2]}, {
             Rational[1, 2], Rational[-1, 2] - 2^
              Rational[1, 2], (2 - 2 2^Rational[1, 2])^(-1)}, {
             Rational[1, 2], Rational[1, 2] + 2^Rational[1, 2], 
              Rational[1, 2] + 2^Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2] + 
              2^Rational[1, 2], (2 - 2 2^Rational[1, 2])^(-1)}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 2] - 2^Rational[1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[-1, 2], 
              Rational[1, 2] + 2^Rational[1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 2] - 2^Rational[1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[1, 2], 
              Rational[1, 2] + 2^Rational[1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[-1, 2] - 2^
              Rational[1, 2], Rational[-1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[-1, 2] - 2^
              Rational[1, 2], Rational[1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[1, 2] + 
              2^Rational[1, 2], Rational[-1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[1, 2] + 
              2^Rational[1, 2], Rational[
              1, 2]}, {(2 - 2 2^Rational[1, 2])^(-1), Rational[-1, 2], 
              Rational[-1, 2] - 2^
              Rational[1, 2]}, {(2 - 2 2^Rational[1, 2])^(-1), 
              Rational[-1, 2], Rational[1, 2] + 
              2^Rational[1, 2]}, {(2 - 2 2^Rational[1, 2])^(-1), Rational[
              1, 2], Rational[-1, 2] - 2^
              Rational[1, 2]}, {(2 - 2 2^Rational[1, 2])^(-1), Rational[1, 2],
               Rational[1, 2] + 
              2^Rational[1, 2]}, {(2 - 2 2^Rational[1, 2])^(-1), 
              Rational[-1, 2] - 2^Rational[1, 2], 
              Rational[-1, 2]}, {(2 - 2 2^Rational[1, 2])^(-1), 
              Rational[-1, 2] - 2^Rational[1, 2], Rational[
              1, 2]}, {(2 - 2 2^Rational[1, 2])^(-1), Rational[1, 2] + 
              2^Rational[1, 2], 
              Rational[-1, 2]}, {(2 - 2 2^Rational[1, 2])^(-1), 
              Rational[1, 2] + 2^Rational[1, 2], Rational[1, 2]}, {
             Rational[-1, 2] - 2^Rational[1, 2], Rational[-1, 2], 
              Rational[1, 2] + 2^Rational[-1, 2]}, {
             Rational[-1, 2] - 2^Rational[1, 2], 
              Rational[-1, 2], (2 - 2 2^Rational[1, 2])^(-1)}, {
             Rational[-1, 2] - 2^Rational[1, 2], Rational[1, 2], 
              Rational[1, 2] + 2^Rational[-1, 2]}, {
             Rational[-1, 2] - 2^Rational[1, 2], Rational[
              1, 2], (2 - 2 2^Rational[1, 2])^(-1)}, {
             Rational[-1, 2] - 2^Rational[1, 2], Rational[1, 2] + 
              2^Rational[-1, 2], Rational[-1, 2]}, {
             Rational[-1, 2] - 2^Rational[1, 2], Rational[1, 2] + 
              2^Rational[-1, 2], Rational[1, 2]}, {
             Rational[-1, 2] - 2^
              Rational[1, 2], (2 - 2 2^Rational[1, 2])^(-1), 
              Rational[-1, 2]}, {
             Rational[-1, 2] - 2^
              Rational[1, 2], (2 - 2 2^Rational[1, 2])^(-1), Rational[
              1, 2]}, {
             Rational[1, 2] + 2^Rational[1, 2], Rational[-1, 2], 
              Rational[1, 2] + 2^Rational[-1, 2]}, {
             Rational[1, 2] + 2^Rational[1, 2], 
              Rational[-1, 2], (2 - 2 2^Rational[1, 2])^(-1)}, {
             Rational[1, 2] + 2^Rational[1, 2], Rational[1, 2], 
              Rational[1, 2] + 2^Rational[-1, 2]}, {
             Rational[1, 2] + 2^Rational[1, 2], Rational[
              1, 2], (2 - 2 2^Rational[1, 2])^(-1)}, {
             Rational[1, 2] + 2^Rational[1, 2], Rational[1, 2] + 
              2^Rational[-1, 2], Rational[-1, 2]}, {
             Rational[1, 2] + 2^Rational[1, 2], Rational[1, 2] + 
              2^Rational[-1, 2], Rational[1, 2]}, {
             Rational[1, 2] + 2^Rational[1, 2], (2 - 2 2^Rational[1, 2])^(-1),
               Rational[-1, 2]}, {
             Rational[1, 2] + 2^Rational[1, 2], (2 - 2 2^Rational[1, 2])^(-1),
               Rational[1, 2]}}, CompressedData["
1:eJxTTMoPSmViYGAwAGJmBhh4sP/ZXHtj/4DP9met69PmLfi3H4e4PUz8KUR8
P7p6NHG4epg6mHno4jB9aOL2ONTbo6m3x+F+dHGYOfY43I8uDlePw/32ONxv
j8P99ujuxxUeuPyNy35c9hAZr4TCC1c6QI8HgvGJI5xwhh+R6YxQ/OFKl8SG
C077cIUjunoi4xlXeOAKV2LjCaf/icwfOPMhofRNKP4BMZzkRg==
            "]], 
           Polygon3DBox[{{44, 42, 17, 19}, {14, 6, 3, 11}, {34, 36, 27, 25}, {
             8, 16, 9, 1}, {20, 18, 41, 43}, {12, 4, 5, 13}, {26, 28, 35, 
             33}, {2, 10, 15, 7}, {45, 23, 24, 46}, {39, 29, 30, 40}, {48, 22,
              21, 47}, {38, 32, 31, 37}, {9, 19, 17, 11, 3, 25, 27, 1}, {2, 
             28, 26, 4, 12, 18, 20, 10}, {41, 48, 47, 42, 44, 45, 46, 43}, {
             35, 38, 37, 36, 34, 39, 40, 33}, {15, 24, 23, 16, 8, 31, 32, 
             7}, {5, 30, 29, 6, 14, 21, 22, 13}, {46, 24, 15, 10, 20, 43}, {
             35, 28, 2, 7, 32, 38}, {41, 18, 12, 13, 22, 48}, {40, 30, 5, 4, 
             26, 33}, {44, 19, 9, 16, 23, 45}, {37, 31, 8, 1, 27, 36}, {47, 
             21, 14, 11, 17, 42}, {34, 25, 3, 6, 29, 39}}]]],
         "\"great rhombicuboctahedron\""],
        Annotation[#, "great rhombicuboctahedron", "Tooltip"]& ],
       TraditionalForm], {195., -580.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, Rational[1, 2] (-1 - 5^Rational[1, 2]), 0}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), 
              0}, {(Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[1, 4] (-1 - 5^
               Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[1, 4] (1 + 
               5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), (
               Rational[1, 10] (5 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), (
               Rational[1, 10] (5 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], (1 + 2 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], (1 + 2 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[5, 8] + 
               Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
              1 - 5 #^2 + 5 #^4& , 1, 0]}, {(Rational[5, 8] + 
               Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
              1 - 5 #^2 + 5 #^4& , 1, 0]}, {-(1 + 2 5^Rational[-1, 2])^
               Rational[1, 2], 0, Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
             Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[
              1, 2], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {(1 + 
               2 5^Rational[-1, 2])^Rational[1, 2], 
              0, (Rational[1, 10] (5 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 8] (1 + 5^Rational[1, 2])^2, 
              0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              0}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
              0, -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
               Rational[1, 2], Rational[-1, 8] (1 + 5^Rational[1, 2])^2, 0}, {
             Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 0}, {
             Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], 0}, {
             Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2], 0}, {
             Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], 0}, {
             Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], 0}, {
             Root[1 - 5 #^2 + 5 #^4& , 1, 0], 0, (1 + 2 5^Rational[-1, 2])^
              Rational[1, 2]}, {
             Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), (
               Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2]}, {
             Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), (
               Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2]}, {
             Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
              1 - 5 #^2 + 5 #^4& , 1, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
              1 - 5 #^2 + 5 #^4& , 1, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), (1 + 
               2 5^Rational[-1, 2])^Rational[1, 2]}, {
             Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), (1 + 
               2 5^Rational[-1, 2])^Rational[1, 2]}}, {{
             0, -1.618033988749895, 0}, {0, 1.618033988749895, 0}, {
             0.2628655560595668, -0.8090169943749475, -1.3763819204711736`}, {
             0.2628655560595668, 0.8090169943749475, -1.3763819204711736`}, {
             0.42532540417601994`, -1.3090169943749475`, 0.85065080835204}, {
             0.42532540417601994`, 1.3090169943749475`, 0.85065080835204}, {
             0.6881909602355868, -0.5, 1.3763819204711736`}, {
             0.6881909602355868, 0.5, 1.3763819204711736`}, {
             1.1135163644116066`, -0.8090169943749475, -0.8506508083520394}, {
             1.1135163644116066`, 
             0.8090169943749475, -0.8506508083520394}, {-1.3763819204711736`, 
              0, -0.8506508083520394}, {-0.6881909602355868, -0.5, \
-1.3763819204711736`}, {-0.6881909602355868, 0.5, -1.3763819204711736`}, {
             1.3763819204711736`, 0, 0.85065080835204}, {
             0.9510565162951535, -1.3090169943749475`, 0}, {
             0.9510565162951535, 1.3090169943749475`, 0}, {
             0.85065080835204, 
              0, -1.3763819204711736`}, {-0.9510565162951535, \
-1.3090169943749475`, 0}, {-0.9510565162951535, 1.3090169943749475`, 
              0}, {-1.5388417685876268`, -0.5, 0}, {-1.5388417685876268`, 0.5,
               0}, {1.5388417685876268`, -0.5, 0}, {
             1.5388417685876268`, 0.5, 0}, {-0.8506508083520394, 0, 
              1.3763819204711736`}, {-1.1135163644116068`, \
-0.8090169943749475, 0.85065080835204}, {-1.1135163644116068`, 
             0.8090169943749475, 
             0.85065080835204}, {-0.4253254041760197, -1.3090169943749475`, \
-0.8506508083520394}, {-0.4253254041760197, 
             1.3090169943749475`, -0.8506508083520394}, {-0.2628655560595671, \
-0.8090169943749475, 1.3763819204711736`}, {-0.2628655560595671, 
             0.8090169943749475, 1.3763819204711736`}}], 
           Polygon3DBox[{{30, 24, 29, 7, 8}, {26, 24, 30}, {25, 29, 24}, {5, 
             7, 29}, {14, 8, 7}, {6, 30, 8}, {16, 2, 6}, {19, 21, 26}, {20, 
             18, 25}, {1, 15, 5}, {22, 23, 14}, {2, 19, 26, 30, 6}, {21, 20, 
             25, 24, 26}, {18, 1, 5, 29, 25}, {15, 22, 14, 7, 5}, {23, 16, 6, 
             8, 14}, {12, 13, 4, 17, 3}, {3, 17, 9}, {17, 4, 10}, {4, 13, 
             28}, {13, 12, 11}, {12, 3, 27}, {27, 1, 18}, {9, 22, 15}, {10, 
             16, 23}, {28, 19, 2}, {11, 20, 21}, {27, 3, 9, 15, 1}, {9, 17, 
             10, 23, 22}, {10, 4, 28, 2, 16}, {28, 13, 11, 21, 19}, {11, 12, 
             27, 18, 20}}]]],
         "\"icosidodecahedron\""],
        Annotation[#, "icosidodecahedron", "Tooltip"]& ],
       TraditionalForm], {585., -580.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), (Rational[25, 8] + 
               Rational[11, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), Root[
              5 - 100 #^2 + 16 #^4& , 1, 0]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), (Rational[25, 8] + 
               Rational[11, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), Root[
              5 - 100 #^2 + 16 #^4& , 1, 0]}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-5 - 3 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (5 + 3 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], -1 + 
              Rational[-1, 2] 5^Rational[1, 2], (Rational[17, 8] + 
               Rational[31, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2]), (Rational[17, 8] + 
               Rational[31, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(-2) (1 + 2 5^Rational[-1, 2])^Rational[1, 2],
               0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
             Rational[-3, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], -1 + 
              Rational[-1, 2] 5^Rational[1, 2], Root[
              1 - 20 #^2 + 80 #^4& , 3, 0]}, {
             Rational[-3, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 3, 0]}, {-(1 + 2 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 2] (-3 - 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 2, 0]}, {-(1 + 2 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 2] (3 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 2, 0]}, {
             Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], -1 + 
              Rational[-1, 2] 
               5^Rational[1, 2], -(Rational[17, 8] + 
                Rational[31, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 
               5^Rational[1, 2]), -(Rational[17, 8] + 
                Rational[31, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {(1 + 
               2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (-3 - 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 2] (3 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 3, 0]}, {
             2 (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[13, 8] + 
               Rational[29, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^
               Rational[1, 2]), -(Rational[17, 8] + 
                Rational[31, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[13, 8] + Rational[29, 8] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[1, 4] (3 + 
               5^Rational[1, 2]), -(Rational[17, 8] + 
                Rational[31, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[9, 4] + Rational[9, 2] 5^Rational[-1, 2])^
              Rational[1, 2], -1 + Rational[-1, 2] 5^Rational[1, 2], Root[
              1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[9, 4] + 
               Rational[9, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[5, 2] + 
               Rational[11, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              0, (Rational[17, 8] + Rational[31, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[5, 2] + 
               Rational[11, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (-1 - 5^Rational[1, 2]), Root[
              1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[5, 2] + 
               Rational[11, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (1 + 5^Rational[1, 2]), Root[
              1 - 100 #^2 + 80 #^4& , 1, 
               0]}, {-(Rational[29, 8] + Rational[61, 8] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 3, 
               0]}, {-(Rational[29, 8] + Rational[61, 8] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[29, 8] + 
               Rational[61, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[29, 8] + 
               Rational[61, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[17, 4] + 
               Rational[19, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], Root[
              1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[17, 4] + 
               Rational[19, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
             Rational[-1, 2] (17 + 38 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
             Rational[-1, 2] (17 + 38 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2], Root[
              1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[25, 8] + 
               Rational[11, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
              5 - 100 #^2 + 16 #^4& , 1, 0]}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[25, 8] + 
               Rational[11, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
              5 - 100 #^2 + 16 #^4& , 1, 0]}, {(
               Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
              Rational[1, 2] (-3 - 5^Rational[1, 2]), (Rational[5, 8] + 
               Rational[11, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
              Rational[1, 2], 
              Rational[1, 2] (3 + 5^Rational[1, 2]), (Rational[5, 8] + 
               Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[25, 8] + 
               Rational[11, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
              5 - 100 #^2 + 16 #^4& , 1, 0]}, {
             Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[25, 8] + 
               Rational[11, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
              5 - 100 #^2 + 16 #^4& , 1, 0]}, {
             Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], (Rational[25, 8] + 
               Rational[11, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], Root[5 - 100 #^2 + 16 #^4& , 1, 0]}, {
             Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[
              1, 2], (Rational[25, 8] + Rational[11, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
             Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2], Root[5 - 100 #^2 + 16 #^4& , 1, 0]}, {
             Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], (Rational[25, 8] + 
               Rational[11, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], Root[5 - 100 #^2 + 16 #^4& , 1, 0]}, {
             Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], (Rational[25, 8] + Rational[11, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
             Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], Root[5 - 100 #^2 + 16 #^4& , 1, 0]}, {
             Root[1 - 25 #^2 + 5 #^4& , 1, 0], 
              0, -(Rational[17, 8] + Rational[31, 8] 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Root[1 - 25 #^2 + 5 #^4& , 1, 0], 
              Rational[1, 2] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
               Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Root[1 - 25 #^2 + 5 #^4& , 1, 0], 
              Rational[1, 2] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
               Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
              Rational[1, 2] (-3 - 5^Rational[1, 2]), Root[
              1 - 100 #^2 + 80 #^4& , 1, 0]}, {
             Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
              Rational[1, 2] (3 + 5^Rational[1, 2]), Root[
              1 - 100 #^2 + 80 #^4& , 1, 0]}, {
             Root[1 - 260 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[17, 8] + 
               Rational[31, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Root[1 - 260 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[17, 8] + 
               Rational[31, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (-5 - 3 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 2, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (5 + 3 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{
             0, -1.618033988749895, 2.48989828488278}, {
             0, -1.618033988749895, -2.48989828488278}, {
             0, 1.618033988749895, 2.48989828488278}, {
             0, 1.618033988749895, -2.48989828488278}, {
             0.42532540417601994`, -2.9270509831248424`, 
             0.2628655560595668}, {0.42532540417601994`, 2.9270509831248424`, 
             0.2628655560595668}, {0.6881909602355868, -2.118033988749895, 
             1.9641671727636467`}, {0.6881909602355868, 2.118033988749895, 
             1.9641671727636467`}, {-2.752763840942347, 
              0, -1.1135163644116068`}, {-2.0645728807067605`, \
-2.118033988749895, 0.2628655560595668}, {-2.0645728807067605`, 
             2.118033988749895, 
             0.2628655560595668}, {-1.3763819204711736`, -2.618033988749895, \
-0.2628655560595671}, {-1.3763819204711736`, 
             2.618033988749895, -0.2628655560595671}, {-0.6881909602355868, \
-2.118033988749895, -1.9641671727636467`}, {-0.6881909602355868, 
             2.118033988749895, -1.9641671727636467`}, {
             1.3763819204711736`, -2.618033988749895, 0.2628655560595668}, {
             1.3763819204711736`, 2.618033988749895, 0.2628655560595668}, {
             2.752763840942347, 0, 1.1135163644116066`}, {
             1.8017073246471935`, -1.3090169943749475`, \
-1.9641671727636467`}, {1.8017073246471935`, 
             1.3090169943749475`, -1.9641671727636467`}, {
             2.0645728807067605`, -2.118033988749895, -0.2628655560595671}, {
             2.0645728807067605`, 2.118033988749895, -0.2628655560595671}, {
             2.2270327288232132`, 0, 1.9641671727636467`}, {
             2.2270327288232132`, -1.618033988749895, -1.1135163644116068`}, {
             2.2270327288232132`, 
             1.618033988749895, -1.1135163644116068`}, {-2.6523581329992334`, \
-1.3090169943749475`, 0.2628655560595668}, {-2.6523581329992334`, 
             1.3090169943749475`, 0.2628655560595668}, {
             2.6523581329992334`, -1.3090169943749475`, -0.2628655560595671}, \
{2.6523581329992334`, 1.3090169943749475`, -0.2628655560595671}, {
             2.9152236890588, -0.5, 0.2628655560595668}, {2.9152236890588, 
             0.5, 0.2628655560595668}, {-2.9152236890588, -0.5, \
-0.2628655560595671}, {-2.9152236890588, 0.5, -0.2628655560595671}, {
             0.9510565162951535, -1.3090169943749475`, 2.48989828488278}, {
             0.9510565162951535, -1.3090169943749475`, -2.48989828488278}, {
             0.9510565162951535, 1.3090169943749475`, 2.48989828488278}, {
             0.9510565162951535, 1.3090169943749475`, -2.48989828488278}, {
             0.85065080835204, -2.618033988749895, 1.1135163644116066`}, {
             0.85065080835204, 2.618033988749895, 
             1.1135163644116066`}, {-0.9510565162951535, -1.3090169943749475`,
              2.48989828488278}, {-0.9510565162951535, -1.3090169943749475`, \
-2.48989828488278}, {-0.9510565162951535, 1.3090169943749475`, 
             2.48989828488278}, {-0.9510565162951535, 
             1.3090169943749475`, -2.48989828488278}, {-1.5388417685876268`, \
-0.5, 2.48989828488278}, {-1.5388417685876268`, -0.5, -2.48989828488278}, \
{-1.5388417685876268`, 0.5, 2.48989828488278}, {-1.5388417685876268`, 
             0.5, -2.48989828488278}, {1.5388417685876268`, -0.5, 
             2.48989828488278}, {
             1.5388417685876268`, -0.5, -2.48989828488278}, {
             1.5388417685876268`, 0.5, 2.48989828488278}, {
             1.5388417685876268`, 
             0.5, -2.48989828488278}, {-2.2270327288232137`, 
              0, -1.9641671727636467`}, {-2.2270327288232137`, \
-1.618033988749895, 1.1135163644116066`}, {-2.2270327288232137`, 
             1.618033988749895, 
             1.1135163644116066`}, {-0.8506508083520394, -2.618033988749895, \
-1.1135163644116068`}, {-0.8506508083520394, 
             2.618033988749895, -1.1135163644116068`}, {-1.8017073246471933`, \
-1.3090169943749475`, 1.9641671727636467`}, {-1.8017073246471933`, 
             1.3090169943749475`, 
             1.9641671727636467`}, {-0.4253254041760197, \
-2.9270509831248424`, -0.2628655560595671}, {-0.4253254041760197, 
             2.9270509831248424`, -0.2628655560595671}}], 
           Polygon3DBox[{{3, 42, 46, 44, 40, 1, 34, 48, 50, 36}, {47, 43, 4, 
             37, 51, 49, 35, 2, 41, 45}, {2, 35, 19, 24, 21, 16, 5, 59, 55, 
             14}, {49, 51, 20, 25, 29, 31, 30, 28, 24, 19}, {37, 4, 15, 56, 
             60, 6, 17, 22, 25, 20}, {43, 47, 52, 9, 33, 27, 11, 13, 56, 
             15}, {45, 41, 14, 55, 12, 10, 26, 32, 9, 52}, {6, 60, 13, 11, 54,
              58, 42, 3, 8, 39}, {27, 33, 32, 26, 53, 57, 44, 46, 58, 54}, {
             10, 12, 59, 5, 38, 7, 1, 40, 57, 53}, {16, 21, 28, 30, 18, 23, 
             48, 34, 7, 38}, {31, 29, 22, 17, 39, 8, 36, 50, 23, 18}, {9, 32, 
             33}, {18, 30, 31}, {47, 45, 52}, {50, 48, 23}, {10, 53, 26}, {27,
              54, 11}, {21, 24, 28}, {29, 25, 22}, {40, 44, 57}, {58, 46, 
             42}, {35, 49, 19}, {20, 51, 37}, {12, 55, 59}, {60, 56, 13}, {41,
              2, 14}, {15, 4, 43}, {34, 1, 7}, {8, 3, 36}, {38, 5, 16}, {17, 
             6, 39}}]]],
         "\"truncated dodecahedron\""],
        Annotation[#, "truncated dodecahedron", "Tooltip"]& ],
       TraditionalForm], {975., -580.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2] (1 - 2 5^Rational[-1, 2])^Rational[1, 2], -1 + 
              Rational[-1, 2] 5^Rational[1, 2], (Rational[9, 8] + 
               Rational[9, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (1 - 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2]), (Rational[9, 8] + 
               Rational[9, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 2] (1 - 2 5^Rational[-1, 2])^Rational[1, 2], -1 + 
              Rational[-1, 2] 5^Rational[1, 2], 
              Rational[-3, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[1, 2] (1 - 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2]), 
              Rational[-3, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[-1, 4] (2 - 2 5^Rational[-1, 2])^Rational[1, 2], (1 - 5^
               Rational[1, 2])^(-1), -(Rational[25, 8] + 
                Rational[41, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 4] (2 - 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-3, 4] (1 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 1, 0]}, {
             Rational[-1, 4] (2 - 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (1 + 
               5^Rational[1, 2]), -(Rational[25, 8] + 
                Rational[41, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 4] (2 - 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[3, 4] (1 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 1, 0]}, {
             Rational[1, 4] (2 - 2 5^Rational[-1, 2])^Rational[1, 2], (1 - 5^
               Rational[1, 2])^(-1), (Rational[25, 8] + 
               Rational[41, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (2 - 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-3, 4] (1 + 5^Rational[1, 2]), (Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (2 - 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[25, 8] + 
               Rational[41, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (2 - 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[3, 4] (1 + 5^Rational[1, 2]), (Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 
               2], -(Rational[25, 8] + Rational[41, 8] 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], -(Rational[25, 8] + Rational[41, 8] 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], -1 + 
              Rational[-1, 2] 5^Rational[1, 2], (Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2]), (Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-3, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], (Rational[9, 8] + 
               Rational[9, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-3, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[
              1, 2], (Rational[9, 8] + Rational[9, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], -1,
               Rational[1, 4] (26 + 58 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 1,
               Rational[1, 4] (26 + 58 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(1 + 2 5^Rational[-1, 2])^
               Rational[1, 2], (-2)/(-1 + 5^Rational[1, 2]), 
              Rational[-3, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[-3, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], (Rational[25, 8] + 
               Rational[41, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[
              1, 2], (Rational[25, 8] + Rational[41, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(1 + 2 5^Rational[-1, 2])^Rational[1, 2], -1, 
              Root[1 - 260 #^2 + 80 #^4& , 1, 0]}, {(1 + 2 5^Rational[-1, 2])^
              Rational[1, 2], 1, Root[
              1 - 260 #^2 + 80 #^4& , 1, 0]}, {(1 + 2 5^Rational[-1, 2])^
              Rational[1, 2], (-2)/(-1 + 
              5^Rational[1, 2]), (Rational[9, 8] + 
               Rational[9, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (1 + 5^Rational[1, 2]), (Rational[9, 8] + 
               Rational[9, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {-(2 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Root[1 - 260 #^2 + 80 #^4& , 1, 0]}, {(2 + 2 5^Rational[-1, 2])^
              Rational[1, 2], 0, 
              Rational[1, 4] (26 + 58 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] (5 + 2 5^Rational[-1, 2])^Rational[1, 2], -1 + 
              Rational[-1, 2] 5^Rational[1, 2], Root[
              1 - 20 #^2 + 80 #^4& , 1, 0]}, {
             Rational[-1, 2] (5 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 1, 
               0]}, {-(Rational[17, 8] + Rational[31, 8] 5^Rational[-1, 2])^
               Rational[1, 2], (1 - 5^Rational[1, 2])^(-1), 
              Rational[-3, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[17, 8] + 
                Rational[31, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-3, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
               Rational[1, 2]}, {(Rational[9, 4] + 
               Rational[9, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Rational[-3, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
               Rational[1, 2]}, {(Rational[9, 4] + 
               Rational[9, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[-3, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
               Rational[1, 2]}, {(Rational[5, 2] + 
               Rational[11, 2] 5^Rational[-1, 2])^Rational[1, 2], -1, Root[
              1 - 20 #^2 + 80 #^4& , 1, 0]}, {(Rational[5, 2] + 
               Rational[11, 2] 5^Rational[-1, 2])^Rational[1, 2], 1, Root[
              1 - 20 #^2 + 80 #^4& , 1, 0]}, {(Rational[13, 4] + 
               Rational[11, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], (Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[13, 4] + 
               Rational[11, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {
             Rational[-1, 4] (10 + 22 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-5 - 5^Rational[1, 2]), (Rational[9, 8] + 
               Rational[9, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 4] (10 + 22 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (5 + 5^Rational[1, 2]), (Rational[9, 8] + 
               Rational[9, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (10 + 22 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-5 - 5^Rational[1, 2]), 
              Rational[-3, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[1, 4] (10 + 22 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (5 + 5^Rational[1, 2]), 
              Rational[-3, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[-1, 2] (13 + 22 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], Root[1 - 20 #^2 + 80 #^4& , 1, 0]}, {
             Rational[-1, 2] (13 + 22 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2], Root[1 - 20 #^2 + 80 #^4& , 1, 0]}, {
             Rational[-1, 4] (26 + 38 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-5 - 5^Rational[1, 2]), (Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[-1, 4] (26 + 38 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (5 + 5^Rational[1, 2]), (Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (26 + 38 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-5 - 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 1, 0]}, {
             Rational[1, 4] (26 + 38 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (5 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 1, 0]}, {
             Rational[1, 4] (34 + 62 5^Rational[-1, 2])^Rational[1, 2], (1 - 
               5^Rational[1, 2])^(-1), (Rational[9, 8] + 
               Rational[9, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Rational[1, 4] (34 + 62 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[9, 8] + 
               Rational[9, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
              Rational[1, 2], 
              0, (Rational[25, 8] + Rational[41, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {
             Root[1 - 25 #^2 + 5 #^4& , 1, 0], -1, (Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
             Root[1 - 25 #^2 + 5 #^4& , 1, 0], 
              1, (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2]}, {
             Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
              0, -(Rational[25, 8] + Rational[41, 8] 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Root[1 - 5 #^2 + 5 #^4& , 2, 0], (-2)/(-1 + 5^Rational[1, 2]), 
              Root[1 - 260 #^2 + 80 #^4& , 1, 0]}, {
             Root[1 - 5 #^2 + 5 #^4& , 2, 0], 
              Rational[1, 2] (1 + 5^Rational[1, 2]), Root[
              1 - 260 #^2 + 80 #^4& , 1, 0]}, {
             Root[1 - 5 #^2 + 5 #^4& , 3, 0], (-2)/(-1 + 5^Rational[1, 2]), 
              Rational[1, 4] (26 + 58 5^Rational[-1, 2])^Rational[1, 2]}, {
             Root[1 - 5 #^2 + 5 #^4& , 3, 0], 
              Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[1, 4] (26 + 58 5^Rational[-1, 2])^
               Rational[1, 2]}}, {{-0.16245984811645317`, -2.118033988749895, 
             1.2759762125280598`}, {-0.16245984811645317`, 2.118033988749895, 
             1.2759762125280598`}, {
             0.16245984811645317`, -2.118033988749895, -1.27597621252806}, {
             0.16245984811645317`, 
             2.118033988749895, -1.27597621252806}, {-0.2628655560595668, \
-0.8090169943749473, -2.327438436766327}, {-0.2628655560595668, \
-2.4270509831248424`, -0.4253254041760197}, {-0.2628655560595668, 
             0.8090169943749475, -2.327438436766327}, {-0.2628655560595668, 
             2.4270509831248424`, -0.4253254041760197}, {
             0.2628655560595668, -0.8090169943749473, 2.327438436766327}, {
             0.2628655560595668, -2.4270509831248424`, 
             0.42532540417601994`}, {0.2628655560595668, 0.8090169943749475, 
             2.327438436766327}, {0.2628655560595668, 2.4270509831248424`, 
             0.42532540417601994`}, {
             0.6881909602355868, -0.5, -2.327438436766327}, {
             0.6881909602355868, 0.5, -2.327438436766327}, {
             1.2139220723547204`, -2.118033988749895, 0.42532540417601994`}, {
             1.2139220723547204`, 2.118033988749895, 
             0.42532540417601994`}, {-2.0645728807067605`, -0.5, 
             1.2759762125280598`}, {-2.0645728807067605`, 0.5, 
             1.2759762125280598`}, {-1.3763819204711736`, -1, 
              1.8017073246471935`}, {-1.3763819204711736`, 1, 
              1.8017073246471935`}, {-1.3763819204711736`, \
-1.6180339887498947`, -1.27597621252806}, {-1.3763819204711736`, 
             1.618033988749895, -1.27597621252806}, {-0.6881909602355868, \
-0.5, 2.327438436766327}, {-0.6881909602355868, 0.5, 2.327438436766327}, {
             1.3763819204711736`, -1, -1.8017073246471933`}, {
             1.3763819204711736`, 1, -1.8017073246471933`}, {
             1.3763819204711736`, -1.6180339887498947`, 
             1.2759762125280598`}, {1.3763819204711736`, 1.618033988749895, 
             1.2759762125280598`}, {-1.7013016167040798`, 
              0, -1.8017073246471933`}, {
             1.7013016167040798`, 0, 
              1.8017073246471935`}, {-1.2139220723547204`, \
-2.118033988749895, -0.4253254041760197}, {-1.2139220723547204`, 
             2.118033988749895, -0.4253254041760197}, {-1.9641671727636467`, \
-0.8090169943749473, -1.27597621252806}, {-1.9641671727636467`, 
             0.8090169943749475, -1.27597621252806}, {
             2.0645728807067605`, -0.5, -1.27597621252806}, {
             2.0645728807067605`, 0.5, -1.27597621252806}, {
             2.2270327288232132`, -1, -0.4253254041760197}, {
             2.2270327288232132`, 1, -0.4253254041760197}, {
             2.3894925769396664`, -0.5, 0.42532540417601994`}, {
             2.3894925769396664`, 0.5, 
             0.42532540417601994`}, {-1.1135163644116066`, \
-1.8090169943749475`, 1.2759762125280598`}, {-1.1135163644116066`, 
             1.8090169943749475`, 1.2759762125280598`}, {
             1.1135163644116066`, -1.8090169943749475`, -1.27597621252806}, {
             1.1135163644116066`, 
             1.8090169943749475`, -1.27597621252806}, {-2.3894925769396664`, \
-0.5, -0.4253254041760197}, {-2.3894925769396664`, 
             0.5, -0.4253254041760197}, {-1.6392474765307403`, \
-1.8090169943749475`, 0.42532540417601994`}, {-1.6392474765307403`, 
             1.8090169943749475`, 0.42532540417601994`}, {
             1.6392474765307403`, -1.8090169943749475`, -0.4253254041760197}, \
{1.6392474765307403`, 1.8090169943749475`, -0.4253254041760197}, {
             1.9641671727636467`, -0.8090169943749473, 1.2759762125280598`}, {
             1.9641671727636467`, 0.8090169943749475, 1.2759762125280598`}, {
             0.85065080835204, 0, 
              2.327438436766327}, {-2.2270327288232137`, -1, 
              0.42532540417601994`}, {-2.2270327288232137`, 1, 
              0.42532540417601994`}, {-0.8506508083520394, 
              0, -2.327438436766327}, {-0.5257311121191341, \
-1.6180339887498947`, -1.8017073246471933`}, {-0.5257311121191341, 
             1.618033988749895, -1.8017073246471933`}, {
             0.5257311121191336, -1.6180339887498947`, 1.8017073246471935`}, {
             0.5257311121191336, 1.618033988749895, 1.8017073246471935`}}], 
           Polygon3DBox[{{53, 11, 24, 23, 9}, {51, 39, 40, 52, 30}, {60, 28, 
             16, 12, 2}, {20, 42, 48, 55, 18}, {19, 17, 54, 47, 41}, {1, 10, 
             15, 27, 59}, {36, 26, 44, 50, 38}, {4, 58, 22, 32, 8}, {34, 29, 
             33, 45, 46}, {21, 57, 3, 6, 31}, {37, 49, 43, 25, 35}, {13, 5, 
             56, 7, 14}, {9, 59, 27, 51, 30, 53}, {53, 30, 52, 28, 60, 11}, {
             11, 60, 2, 42, 20, 24}, {24, 20, 18, 17, 19, 23}, {23, 19, 41, 1,
              59, 9}, {13, 25, 43, 3, 57, 5}, {5, 57, 21, 33, 29, 56}, {56, 
             29, 34, 22, 58, 7}, {7, 58, 4, 44, 26, 14}, {14, 26, 36, 35, 25, 
             13}, {40, 38, 50, 16, 28, 52}, {16, 50, 44, 4, 8, 12}, {12, 8, 
             32, 48, 42, 2}, {48, 32, 22, 34, 46, 55}, {55, 46, 45, 54, 17, 
             18}, {54, 45, 33, 21, 31, 47}, {47, 31, 6, 10, 1, 41}, {10, 6, 3,
              43, 49, 15}, {15, 49, 37, 39, 51, 27}, {39, 37, 35, 36, 38, 
             40}}]]],
         "\"truncated icosahedron\""],
        Annotation[#, "truncated icosahedron", "Tooltip"]& ],
       TraditionalForm], {1365., -580.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0]}, {
             Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0]}, {
             Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0]}, {
             Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
             Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0]}, {
             Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0]}, {
             Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
             Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0]}, {
             Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0]}, {
             Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0]}, {
             Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
             Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0]}, {
             Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0]}, {
             Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0]}, {
             Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0]}, {
             Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
             Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
             Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0]}, {
             Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0]}, {
             Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
             Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0]}, {
             Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
             Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 1, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 1, 0]}, {
             Root[-1 + 4 #^2 - 16 #^4 + 32 #^6& , 2, 0], 
              Root[-1 + 12 #^2 - 32 #^4 + 32 #^6& , 2, 0], 
              Root[-1 - 12 #^2 - 32 #^4 + 32 #^6& , 2, 
               0]}}, {{-1.1426135089259621`, -0.3377539738137522, \
-0.6212264105565853}, {-1.1426135089259621`, 0.33775397381375233`, 
            0.6212264105565852}, {-1.1426135089259621`, -0.6212264105565853, 
            0.33775397381375233`}, {-1.1426135089259621`, 
            0.6212264105565852, -0.3377539738137522}, {
            1.1426135089259621`, -0.3377539738137522, 0.6212264105565852}, {
            1.1426135089259621`, 0.33775397381375233`, -0.6212264105565853}, {
            1.1426135089259621`, -0.6212264105565853, -0.3377539738137522}, {
            1.1426135089259621`, 0.6212264105565852, 
            0.33775397381375233`}, {-0.3377539738137522, -1.1426135089259621`,
             0.6212264105565852}, {-0.3377539738137522, 
            1.1426135089259621`, -0.6212264105565853}, {-0.3377539738137522, \
-0.6212264105565853, -1.1426135089259621`}, {-0.3377539738137522, 
            0.6212264105565852, 1.1426135089259621`}, {
            0.33775397381375233`, -1.1426135089259621`, -0.6212264105565853}, \
{0.33775397381375233`, 1.1426135089259621`, 0.6212264105565852}, {
            0.33775397381375233`, -0.6212264105565853, 1.1426135089259621`}, {
            0.33775397381375233`, 
            0.6212264105565852, -1.1426135089259621`}, {-0.6212264105565853, \
-1.1426135089259621`, -0.3377539738137522}, {-0.6212264105565853, 
            1.1426135089259621`, 
            0.33775397381375233`}, {-0.6212264105565853, -0.3377539738137522, 
            1.1426135089259621`}, {-0.6212264105565853, 
            0.33775397381375233`, -1.1426135089259621`}, {
            0.6212264105565852, -1.1426135089259621`, 0.33775397381375233`}, {
            0.6212264105565852, 1.1426135089259621`, -0.3377539738137522}, {
            0.6212264105565852, -0.3377539738137522, -1.1426135089259621`}, {
            0.6212264105565852, 0.33775397381375233`, 1.1426135089259621`}}], 
           Polygon3DBox[{{3, 1, 17}, {3, 17, 9}, {3, 19, 2}, {3, 9, 19}, {1, 
             4, 20}, {1, 20, 11}, {1, 11, 17}, {2, 19, 12}, {2, 18, 4}, {2, 
             12, 18}, {4, 18, 10}, {4, 10, 20}, {17, 11, 13}, {19, 9, 15}, {
             18, 12, 14}, {20, 10, 16}, {9, 21, 15}, {11, 23, 13}, {12, 24, 
             14}, {10, 22, 16}, {13, 23, 7}, {13, 7, 21}, {15, 21, 5}, {15, 5,
              24}, {16, 22, 6}, {16, 6, 23}, {14, 24, 8}, {14, 8, 22}, {21, 7,
              5}, {23, 6, 7}, {24, 5, 8}, {22, 8, 6}, {1, 3, 2, 4}, {21, 9, 
             17, 13}, {24, 12, 19, 15}, {10, 18, 14, 22}, {11, 20, 16, 23}, {
             8, 5, 7, 6}}]]],
         "\"snub cube\""],
        Annotation[#, "snub cube", "Tooltip"]& ],
       TraditionalForm], {1755., -580.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2], Rational[-1, 2], -1 + 
              Rational[-1, 2] 5^Rational[1, 2]}, {
             Rational[-1, 2], Rational[-1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2])}, {
             Rational[-1, 2], Rational[1, 2], -1 + 
              Rational[-1, 2] 5^Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2])}, {
             Rational[-1, 2], -1 + Rational[-1, 2] 5^Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2], -1 + Rational[-1, 2] 5^Rational[1, 2], Rational[
              1, 2]}, {
             Rational[-1, 2], Rational[1, 2] (2 + 5^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2] (2 + 5^Rational[1, 2]), Rational[
              1, 2]}, {
             0, (-3 + 5^Rational[1, 2])^(-1), 
              Rational[1, 4] (-5 - 5^Rational[1, 2])}, {
             0, (-3 + 5^Rational[1, 2])^(-1), 
              Rational[1, 4] (5 + 5^Rational[1, 2])}, {
             0, Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 5^Rational[1, 2])}, {
             0, Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 5^Rational[1, 2])}, {
             Rational[1, 2], Rational[-1, 2], -1 + 
              Rational[-1, 2] 5^Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2], -1 + 
              Rational[-1, 2] 5^Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2])}, {
             Rational[1, 2], -1 + Rational[-1, 2] 5^Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2], -1 + Rational[-1, 2] 5^Rational[1, 2], Rational[
              1, 2]}, {
             Rational[1, 2], Rational[1, 2] (2 + 5^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2] (2 + 5^Rational[1, 2]), Rational[
              1, 2]}, {
             Rational[1, 4] (-5 - 5^Rational[1, 2]), 
              0, (-3 + 5^Rational[1, 2])^(-1)}, {
             Rational[1, 4] (-5 - 5^Rational[1, 2]), 0, 
              Rational[1, 4] (3 + 5^Rational[1, 2])}, {
             Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2]), (-3 + 
               5^Rational[1, 2])^(-1)}, {
             Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2])}, {
             Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2]), (-3 + 
               5^Rational[1, 2])^(-1)}, {
             Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 5^Rational[1, 2]), (-3 + 
               5^Rational[1, 2])^(-1), 
              Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 5^Rational[1, 2]), (-3 + 
               5^Rational[1, 2])^(-1), 
              Rational[1, 4] (1 + 5^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (1 + 5^Rational[1, 2])}, {-1 + 
              Rational[-1, 2] 5^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {-1 + Rational[-1, 2] 5^Rational[1, 2], 
              Rational[-1, 2], Rational[1, 2]}, {-1 + 
              Rational[-1, 2] 5^Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {-1 + Rational[-1, 2] 5^Rational[1, 2], 
              Rational[1, 2], Rational[1, 2]}, {(-3 + 5^Rational[1, 2])^(-1), 
              Rational[1, 4] (-5 - 5^Rational[1, 2]), 
              0}, {(-3 + 5^Rational[1, 2])^(-1), 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2])}, {(-3 + 
               5^Rational[1, 2])^(-1), Rational[1, 4] (-1 - 5^Rational[1, 2]),
               Rational[1, 2] (1 + 5^Rational[1, 2])}, {(-3 + 
               5^Rational[1, 2])^(-1), Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2])}, {(-3 + 
               5^Rational[1, 2])^(-1), Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2])}, {(-3 + 
               5^Rational[1, 2])^(-1), Rational[1, 4] (5 + 5^Rational[1, 2]), 
              0}, {Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2]), (-3 + 
               5^Rational[1, 2])^(-1)}, {
             Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2])}, {
             Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2]), (-3 + 
               5^Rational[1, 2])^(-1)}, {
             Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2])}, {
             Rational[1, 2] (1 + 5^Rational[1, 2]), (-3 + 
               5^Rational[1, 2])^(-1), 
              Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
             Rational[1, 2] (1 + 5^Rational[1, 2]), (-3 + 
               5^Rational[1, 2])^(-1), 
              Rational[1, 4] (1 + 5^Rational[1, 2])}, {
             Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
             Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (1 + 5^Rational[1, 2])}, {
             Rational[1, 2] (2 + 5^Rational[1, 2]), Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2] (2 + 5^Rational[1, 2]), Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[1, 2] (2 + 5^Rational[1, 2]), Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2] (2 + 5^Rational[1, 2]), Rational[1, 2], Rational[
              1, 2]}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 5^Rational[1, 2]), 0}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2])}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2])}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2])}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2])}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 5^Rational[1, 2]), 0}, {
             Rational[1, 4] (5 + 5^Rational[1, 2]), 
              0, (-3 + 5^Rational[1, 2])^(-1)}, {
             Rational[1, 4] (5 + 5^Rational[1, 2]), 0, 
              Rational[1, 4] (3 + 
               5^Rational[
                 1, 2])}}, {{-0.5, -0.5, -2.118033988749895}, {-0.5, -0.5, 
             2.118033988749895}, {-0.5, 0.5, -2.118033988749895}, {-0.5, 0.5, 
             2.118033988749895}, {-0.5, -2.118033988749895, -0.5}, {-0.5, \
-2.118033988749895, 0.5}, {-0.5, 2.118033988749895, -0.5}, {-0.5, 
             2.118033988749895, 0.5}, {
             0, -1.3090169943749477`, -1.8090169943749475`}, {
             0, -1.3090169943749477`, 1.8090169943749475`}, {
             0, 1.3090169943749475`, -1.8090169943749475`}, {
             0, 1.3090169943749475`, 1.8090169943749475`}, {
             0.5, -0.5, -2.118033988749895}, {0.5, -0.5, 2.118033988749895}, {
             0.5, 0.5, -2.118033988749895}, {0.5, 0.5, 2.118033988749895}, {
             0.5, -2.118033988749895, -0.5}, {0.5, -2.118033988749895, 0.5}, {
             0.5, 2.118033988749895, -0.5}, {0.5, 2.118033988749895, 
             0.5}, {-1.8090169943749475`, 
              0, -1.3090169943749477`}, {-1.8090169943749475`, 0, 
              1.3090169943749475`}, {-0.8090169943749475, -1.618033988749895, \
-1.3090169943749477`}, {-0.8090169943749475, -1.618033988749895, 
             1.3090169943749475`}, {-0.8090169943749475, 
             1.618033988749895, -1.3090169943749477`}, {-0.8090169943749475, 
             1.618033988749895, 
             1.3090169943749475`}, {-1.618033988749895, -1.3090169943749477`, \
-0.8090169943749475}, {-1.618033988749895, -1.3090169943749477`, 
             0.8090169943749475}, {-1.618033988749895, 
             1.3090169943749475`, -0.8090169943749475}, {-1.618033988749895, 
             1.3090169943749475`, 
             0.8090169943749475}, {-2.118033988749895, -0.5, -0.5}, \
{-2.118033988749895, -0.5, 0.5}, {-2.118033988749895, 
             0.5, -0.5}, {-2.118033988749895, 0.5, 
             0.5}, {-1.3090169943749477`, -1.8090169943749475`, 
              0}, {-1.3090169943749477`, -0.8090169943749475, \
-1.618033988749895}, {-1.3090169943749477`, -0.8090169943749475, 
             1.618033988749895}, {-1.3090169943749477`, 
             0.8090169943749475, -1.618033988749895}, {-1.3090169943749477`, 
             0.8090169943749475, 
             1.618033988749895}, {-1.3090169943749477`, 1.8090169943749475`, 
              0}, {0.8090169943749475, -1.618033988749895, \
-1.3090169943749477`}, {0.8090169943749475, -1.618033988749895, 
             1.3090169943749475`}, {0.8090169943749475, 
             1.618033988749895, -1.3090169943749477`}, {0.8090169943749475, 
             1.618033988749895, 1.3090169943749475`}, {
             1.618033988749895, -1.3090169943749477`, -0.8090169943749475}, {
             1.618033988749895, -1.3090169943749477`, 0.8090169943749475}, {
             1.618033988749895, 1.3090169943749475`, -0.8090169943749475}, {
             1.618033988749895, 1.3090169943749475`, 0.8090169943749475}, {
             2.118033988749895, -0.5, -0.5}, {2.118033988749895, -0.5, 0.5}, {
             2.118033988749895, 0.5, -0.5}, {2.118033988749895, 0.5, 0.5}, {
             1.3090169943749475`, -1.8090169943749475`, 0}, {
             1.3090169943749475`, -0.8090169943749475, -1.618033988749895}, {
             1.3090169943749475`, -0.8090169943749475, 1.618033988749895}, {
             1.3090169943749475`, 0.8090169943749475, -1.618033988749895}, {
             1.3090169943749475`, 0.8090169943749475, 1.618033988749895}, {
             1.3090169943749475`, 1.8090169943749475`, 0}, {
             1.8090169943749475`, 0, -1.3090169943749477`}, {
             1.8090169943749475`, 0, 1.3090169943749475`}}], 
           Polygon3DBox[{{36, 23, 27}, {37, 28, 24}, {40, 8, 7}, {35, 5, 6}, {
             38, 29, 25}, {39, 26, 30}, {10, 14, 2}, {9, 1, 13}, {12, 4, 
             16}, {11, 15, 3}, {54, 45, 41}, {55, 42, 46}, {58, 19, 20}, {53, 
             18, 17}, {56, 43, 47}, {57, 48, 44}, {34, 32, 22}, {33, 21, 
             31}, {59, 51, 49}, {60, 50, 52}, {27, 31, 21, 36}, {23, 36, 1, 
             9}, {10, 2, 37, 24}, {37, 22, 32, 28}, {8, 40, 30, 26}, {25, 29, 
             40, 7}, {35, 27, 23, 5}, {6, 24, 28, 35}, {3, 38, 25, 11}, {21, 
             33, 29, 38}, {39, 30, 34, 22}, {12, 26, 39, 4}, {55, 14, 10, 
             42}, {41, 9, 13, 54}, {57, 44, 12, 16}, {15, 11, 43, 56}, {45, 
             54, 59, 49}, {50, 60, 55, 46}, {48, 58, 20, 44}, {43, 19, 58, 
             47}, {53, 17, 41, 45}, {46, 42, 18, 53}, {59, 56, 47, 51}, {52, 
             48, 57, 60}, {31, 32, 34, 33}, {17, 18, 6, 5}, {1, 3, 15, 13}, {
             14, 16, 4, 2}, {7, 8, 20, 19}, {51, 52, 50, 49}, {3, 1, 36, 21, 
             38}, {22, 37, 2, 4, 39}, {29, 33, 34, 30, 40}, {27, 35, 28, 32, 
             31}, {42, 10, 24, 6, 18}, {41, 17, 5, 23, 9}, {20, 8, 26, 12, 
             44}, {11, 25, 7, 19, 43}, {56, 59, 54, 13, 15}, {57, 16, 14, 55, 
             60}, {58, 48, 52, 51, 47}, {49, 50, 46, 53, 45}}]]],
         "\"small rhombicosidodecahedron\""],
        Annotation[#, "small rhombicosidodecahedron", "Tooltip"]& ],
       TraditionalForm], {195., -967.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{-1, Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (-7 - 3 5^Rational[1, 2])}, {-1, 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (7 + 3 5^Rational[1, 2])}, {-1, 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (-7 - 3 5^Rational[1, 2])}, {-1, 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (7 + 3 5^Rational[1, 2])}, {
             Rational[-1, 2], Rational[-1, 2], Rational[-3, 2] - 5^
              Rational[1, 2]}, {
             Rational[-1, 2], Rational[-1, 2], Rational[3, 2] + 
              5^Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2], Rational[-3, 2] - 5^
              Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2], Rational[3, 2] + 
              5^Rational[1, 2]}, {
             Rational[-1, 2], Rational[-3, 2] - 5^Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[-3, 2] - 5^Rational[1, 2], Rational[
              1, 2]}, {
             Rational[-1, 2], -1 + Rational[-1, 2] 5^Rational[1, 2], -2 + 
              Rational[-1, 2] 5^Rational[1, 2]}, {
             Rational[-1, 2], -1 + Rational[-1, 2] 5^Rational[1, 2], 
              Rational[1, 2] (4 + 5^Rational[1, 2])}, {
             Rational[-1, 2], Rational[3, 2] + 5^Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[3, 2] + 5^Rational[1, 2], Rational[
              1, 2]}, {
             Rational[-1, 2], Rational[1, 2] (2 + 5^Rational[1, 2]), -2 + 
              Rational[-1, 2] 5^Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2] (2 + 5^Rational[1, 2]), 
              Rational[1, 2] (4 + 5^Rational[1, 2])}, {
             Rational[1, 2], Rational[-1, 2], Rational[-3, 2] - 5^
              Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2], Rational[3, 2] + 
              5^Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2], Rational[-3, 2] - 5^
              Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2], Rational[3, 2] + 
              5^Rational[1, 2]}, {
             Rational[1, 2], Rational[-3, 2] - 5^Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[-3, 2] - 5^Rational[1, 2], Rational[
              1, 2]}, {
             Rational[1, 2], -1 + Rational[-1, 2] 5^Rational[1, 2], -2 + 
              Rational[-1, 2] 5^Rational[1, 2]}, {
             Rational[1, 2], -1 + Rational[-1, 2] 5^Rational[1, 2], 
              Rational[1, 2] (4 + 5^Rational[1, 2])}, {
             Rational[1, 2], Rational[3, 2] + 5^Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[3, 2] + 5^Rational[1, 2], Rational[
              1, 2]}, {
             Rational[1, 2], Rational[1, 2] (2 + 5^Rational[1, 2]), -2 + 
              Rational[-1, 2] 5^Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2] (2 + 5^Rational[1, 2]), 
              Rational[1, 2] (4 + 5^Rational[1, 2])}, {
             1, Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (-7 - 3 5^Rational[1, 2])}, {
             1, Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (7 + 3 5^Rational[1, 2])}, {
             1, Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (-7 - 3 5^Rational[1, 2])}, {
             1, Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (7 + 3 5^Rational[1, 2])}, {
             Rational[1, 4] (-7 - 3 5^Rational[1, 2]), -1, 
              Rational[1, 4] (-3 - 5^Rational[1, 2])}, {
             Rational[1, 4] (-7 - 3 5^Rational[1, 2]), -1, 
              Rational[1, 4] (3 + 5^Rational[1, 2])}, {
             Rational[1, 4] (-7 - 3 5^Rational[1, 2]), 1, 
              Rational[1, 4] (-3 - 5^Rational[1, 2])}, {
             Rational[1, 4] (-7 - 3 5^Rational[1, 2]), 1, 
              Rational[1, 4] (3 + 5^Rational[1, 2])}, {
             Rational[1, 4] (-5 - 3 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2])}, {
             Rational[1, 4] (-5 - 3 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2])}, {
             Rational[1, 4] (-5 - 3 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2])}, {
             Rational[1, 4] (-5 - 3 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2])}, {
             Rational[1, 4] (-5 - 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 3 5^Rational[1, 2])}, {
             Rational[1, 4] (-5 - 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 3 5^Rational[1, 2])}, {
             Rational[1, 4] (-5 - 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 3 5^Rational[1, 2])}, {
             Rational[1, 4] (-5 - 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 3 5^Rational[1, 2])}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (-7 - 3 5^Rational[1, 2]), -1}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (-7 - 3 5^Rational[1, 2]), 1}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (-3 - 5^Rational[1, 2])}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (3 + 5^Rational[1, 2])}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (-3 - 5^Rational[1, 2])}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (3 + 5^Rational[1, 2])}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (7 + 3 5^Rational[1, 2]), -1}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (7 + 3 5^Rational[1, 2]), 1}, {
             Rational[1, 2] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-3, 4] (1 + 5^Rational[1, 2])}, {
             Rational[1, 2] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[3, 4] (1 + 5^Rational[1, 2])}, {
             Rational[1, 2] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-3, 4] (1 + 5^Rational[1, 2])}, {
             Rational[1, 2] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[3, 4] (1 + 5^Rational[1, 2])}, {
             Rational[-3, 2] - 5^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[-3, 2] - 5^Rational[1, 2], Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[-3, 2] - 5^Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[-3, 2] - 5^Rational[1, 2], Rational[1, 2], Rational[
              1, 2]}, {
             Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 3 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 5^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 3 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 5^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 3 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 5^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 3 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 5^Rational[1, 2])}, {-2 + 
              Rational[-1, 2] 5^Rational[1, 2], Rational[-1, 2], -1 + 
              Rational[-1, 2] 5^Rational[1, 2]}, {-2 + 
              Rational[-1, 2] 5^Rational[1, 2], Rational[-1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2])}, {-2 + 
              Rational[-1, 2] 5^Rational[1, 2], Rational[1, 2], -1 + 
              Rational[-1, 2] 5^Rational[1, 2]}, {-2 + 
              Rational[-1, 2] 5^Rational[1, 2], Rational[1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2])}, {-1 + 
              Rational[-1, 2] 5^Rational[1, 2], -2 + 
              Rational[-1, 2] 5^Rational[1, 2], Rational[-1, 2]}, {-1 + 
              Rational[-1, 2] 5^Rational[1, 2], -2 + 
              Rational[-1, 2] 5^Rational[1, 2], Rational[1, 2]}, {-1 + 
              Rational[-1, 2] 5^Rational[1, 2], 
              Rational[1, 2] (4 + 5^Rational[1, 2]), Rational[-1, 2]}, {-1 + 
              Rational[-1, 2] 5^Rational[1, 2], 
              Rational[1, 2] (4 + 5^Rational[1, 2]), Rational[1, 2]}, {
             Rational[-3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (-3 - 5^Rational[1, 2])}, {
             Rational[-3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2])}, {
             Rational[-3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (-3 - 5^Rational[1, 2])}, {
             Rational[-3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2])}, {
             Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 3 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 5^Rational[1, 2])}, {
             Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 3 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 5^Rational[1, 2])}, {
             Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 3 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 5^Rational[1, 2])}, {
             Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 3 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 5^Rational[1, 2])}, {
             Rational[3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (-3 - 5^Rational[1, 2])}, {
             Rational[3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (-3 - 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2])}, {
             Rational[3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (-3 - 5^Rational[1, 2])}, {
             Rational[3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2])}, {
             Rational[3, 2] + 5^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[3, 2] + 5^Rational[1, 2], Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[3, 2] + 5^Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[3, 2] + 5^Rational[1, 2], Rational[1, 2], Rational[
              1, 2]}, {
             Rational[1, 2] (2 + 5^Rational[1, 2]), -2 + 
              Rational[-1, 2] 5^Rational[1, 2], Rational[-1, 2]}, {
             Rational[1, 2] (2 + 5^Rational[1, 2]), -2 + 
              Rational[-1, 2] 5^Rational[1, 2], Rational[1, 2]}, {
             Rational[1, 2] (2 + 5^Rational[1, 2]), 
              Rational[1, 2] (4 + 5^Rational[1, 2]), Rational[-1, 2]}, {
             Rational[1, 2] (2 + 5^Rational[1, 2]), 
              Rational[1, 2] (4 + 5^Rational[1, 2]), Rational[1, 2]}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (-7 - 3 5^Rational[1, 2]), -1}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (-7 - 3 5^Rational[1, 2]), 1}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (-3 - 5^Rational[1, 2])}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (3 + 5^Rational[1, 2])}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (-3 - 5^Rational[1, 2])}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[3, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2] (3 + 5^Rational[1, 2])}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (7 + 3 5^Rational[1, 2]), -1}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (7 + 3 5^Rational[1, 2]), 1}, {
             Rational[1, 2] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-3, 4] (1 + 5^Rational[1, 2])}, {
             Rational[1, 2] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[3, 4] (1 + 5^Rational[1, 2])}, {
             Rational[1, 2] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-3, 4] (1 + 5^Rational[1, 2])}, {
             Rational[1, 2] (3 + 5^Rational[1, 2]), 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[3, 4] (1 + 5^Rational[1, 2])}, {
             Rational[1, 2] (4 + 5^Rational[1, 2]), Rational[-1, 2], -1 + 
              Rational[-1, 2] 5^Rational[1, 2]}, {
             Rational[1, 2] (4 + 5^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2])}, {
             Rational[1, 2] (4 + 5^Rational[1, 2]), Rational[1, 2], -1 + 
              Rational[-1, 2] 5^Rational[1, 2]}, {
             Rational[1, 2] (4 + 5^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 2] (2 + 5^Rational[1, 2])}, {
             Rational[1, 4] (5 + 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 3 5^Rational[1, 2])}, {
             Rational[1, 4] (5 + 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 3 5^Rational[1, 2])}, {
             Rational[1, 4] (5 + 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 3 5^Rational[1, 2])}, {
             Rational[1, 4] (5 + 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 3 5^Rational[1, 2])}, {
             Rational[1, 4] (5 + 3 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2])}, {
             Rational[1, 4] (5 + 3 5^Rational[1, 2]), 
              Rational[1, 4] (-5 - 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2])}, {
             Rational[1, 4] (5 + 3 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 5^Rational[1, 2]), 
              Rational[1, 2] (-1 - 5^Rational[1, 2])}, {
             Rational[1, 4] (5 + 3 5^Rational[1, 2]), 
              Rational[1, 4] (5 + 5^Rational[1, 2]), 
              Rational[1, 2] (1 + 5^Rational[1, 2])}, {
             Rational[1, 4] (7 + 3 5^Rational[1, 2]), -1, 
              Rational[1, 4] (-3 - 5^Rational[1, 2])}, {
             Rational[1, 4] (7 + 3 5^Rational[1, 2]), -1, 
              Rational[1, 4] (3 + 5^Rational[1, 2])}, {
             Rational[1, 4] (7 + 3 5^Rational[1, 2]), 1, 
              Rational[1, 4] (-3 - 5^Rational[1, 2])}, {
             Rational[1, 4] (7 + 3 5^Rational[1, 2]), 1, 
              Rational[1, 4] (3 + 
               5^Rational[
                 1, 2])}}, {{-1, -1.3090169943749475`, -3.4270509831248424`}, \
{-1, -1.3090169943749475`, 3.4270509831248424`}, {-1, 
              1.3090169943749475`, -3.4270509831248424`}, {-1, 
              1.3090169943749475`, 
              3.4270509831248424`}, {-0.5, -0.5, -3.73606797749979}, {-0.5, \
-0.5, 3.73606797749979}, {-0.5, 0.5, -3.73606797749979}, {-0.5, 0.5, 
             3.73606797749979}, {-0.5, -3.73606797749979, -0.5}, {-0.5, \
-3.73606797749979, 
             0.5}, {-0.5, -2.118033988749895, -3.118033988749895}, {-0.5, \
-2.118033988749895, 3.118033988749895}, {-0.5, 3.73606797749979, -0.5}, {-0.5,
              3.73606797749979, 0.5}, {-0.5, 
             2.118033988749895, -3.118033988749895}, {-0.5, 2.118033988749895,
              3.118033988749895}, {0.5, -0.5, -3.73606797749979}, {0.5, -0.5, 
             3.73606797749979}, {0.5, 0.5, -3.73606797749979}, {0.5, 0.5, 
             3.73606797749979}, {0.5, -3.73606797749979, -0.5}, {
             0.5, -3.73606797749979, 0.5}, {
             0.5, -2.118033988749895, -3.118033988749895}, {
             0.5, -2.118033988749895, 3.118033988749895}, {0.5, 
             3.73606797749979, -0.5}, {0.5, 3.73606797749979, 0.5}, {0.5, 
             2.118033988749895, -3.118033988749895}, {0.5, 2.118033988749895, 
             3.118033988749895}, {
             1, -1.3090169943749475`, -3.4270509831248424`}, {
             1, -1.3090169943749475`, 3.4270509831248424`}, {
             1, 1.3090169943749475`, -3.4270509831248424`}, {
             1, 1.3090169943749475`, 
              3.4270509831248424`}, {-3.4270509831248424`, -1, \
-1.3090169943749475`}, {-3.4270509831248424`, -1, 
              1.3090169943749475`}, {-3.4270509831248424`, 
              1, -1.3090169943749475`}, {-3.4270509831248424`, 1, 
              1.3090169943749475`}, {-2.9270509831248424`, \
-1.8090169943749475`, -1.618033988749895}, {-2.9270509831248424`, \
-1.8090169943749475`, 1.618033988749895}, {-2.9270509831248424`, 
             1.8090169943749475`, -1.618033988749895}, {-2.9270509831248424`, 
             1.8090169943749475`, 
             1.618033988749895}, {-1.8090169943749475`, -1.618033988749895, \
-2.9270509831248424`}, {-1.8090169943749475`, -1.618033988749895, 
             2.9270509831248424`}, {-1.8090169943749475`, 
             1.618033988749895, -2.9270509831248424`}, {-1.8090169943749475`, 
             1.618033988749895, 
             2.9270509831248424`}, {-1.3090169943749475`, \
-3.4270509831248424`, -1}, {-1.3090169943749475`, -3.4270509831248424`, 
              1}, {-1.3090169943749475`, -2.4270509831248424`, \
-2.618033988749895}, {-1.3090169943749475`, -2.4270509831248424`, 
             2.618033988749895}, {-1.3090169943749475`, 
             2.4270509831248424`, -2.618033988749895}, {-1.3090169943749475`, 
             2.4270509831248424`, 
             2.618033988749895}, {-1.3090169943749475`, 
              3.4270509831248424`, -1}, {-1.3090169943749475`, 
              3.4270509831248424`, 
              1}, {-2.618033988749895, -1.3090169943749475`, \
-2.4270509831248424`}, {-2.618033988749895, -1.3090169943749475`, 
             2.4270509831248424`}, {-2.618033988749895, 
             1.3090169943749475`, -2.4270509831248424`}, {-2.618033988749895, 
             1.3090169943749475`, 
             2.4270509831248424`}, {-3.73606797749979, -0.5, -0.5}, \
{-3.73606797749979, -0.5, 0.5}, {-3.73606797749979, 
             0.5, -0.5}, {-3.73606797749979, 0.5, 
             0.5}, {-1.618033988749895, -2.9270509831248424`, \
-1.8090169943749475`}, {-1.618033988749895, -2.9270509831248424`, 
             1.8090169943749475`}, {-1.618033988749895, 
             2.9270509831248424`, -1.8090169943749475`}, {-1.618033988749895, 
             2.9270509831248424`, 
             1.8090169943749475`}, {-3.118033988749895, -0.5, \
-2.118033988749895}, {-3.118033988749895, -0.5, 
             2.118033988749895}, {-3.118033988749895, 
             0.5, -2.118033988749895}, {-3.118033988749895, 0.5, 
             2.118033988749895}, {-2.118033988749895, -3.118033988749895, \
-0.5}, {-2.118033988749895, -3.118033988749895, 0.5}, {-2.118033988749895, 
             3.118033988749895, -0.5}, {-2.118033988749895, 3.118033988749895,
              0.5}, {-2.4270509831248424`, -2.618033988749895, \
-1.3090169943749475`}, {-2.4270509831248424`, -2.618033988749895, 
             1.3090169943749475`}, {-2.4270509831248424`, 
             2.618033988749895, -1.3090169943749475`}, {-2.4270509831248424`, 
             2.618033988749895, 1.3090169943749475`}, {
             1.618033988749895, -2.9270509831248424`, -1.8090169943749475`}, {
             1.618033988749895, -2.9270509831248424`, 1.8090169943749475`}, {
             1.618033988749895, 2.9270509831248424`, -1.8090169943749475`}, {
             1.618033988749895, 2.9270509831248424`, 1.8090169943749475`}, {
             2.4270509831248424`, -2.618033988749895, -1.3090169943749475`}, {
             2.4270509831248424`, -2.618033988749895, 1.3090169943749475`}, {
             2.4270509831248424`, 2.618033988749895, -1.3090169943749475`}, {
             2.4270509831248424`, 2.618033988749895, 1.3090169943749475`}, {
             3.73606797749979, -0.5, -0.5}, {3.73606797749979, -0.5, 0.5}, {
             3.73606797749979, 0.5, -0.5}, {3.73606797749979, 0.5, 0.5}, {
             2.118033988749895, -3.118033988749895, -0.5}, {
             2.118033988749895, -3.118033988749895, 0.5}, {2.118033988749895, 
             3.118033988749895, -0.5}, {2.118033988749895, 3.118033988749895, 
             0.5}, {1.3090169943749475`, -3.4270509831248424`, -1}, {
             1.3090169943749475`, -3.4270509831248424`, 1}, {
             1.3090169943749475`, -2.4270509831248424`, -2.618033988749895}, {
             1.3090169943749475`, -2.4270509831248424`, 2.618033988749895}, {
             1.3090169943749475`, 2.4270509831248424`, -2.618033988749895}, {
             1.3090169943749475`, 2.4270509831248424`, 2.618033988749895}, {
             1.3090169943749475`, 3.4270509831248424`, -1}, {
             1.3090169943749475`, 3.4270509831248424`, 1}, {
             2.618033988749895, -1.3090169943749475`, -2.4270509831248424`}, {
             2.618033988749895, -1.3090169943749475`, 2.4270509831248424`}, {
             2.618033988749895, 1.3090169943749475`, -2.4270509831248424`}, {
             2.618033988749895, 1.3090169943749475`, 2.4270509831248424`}, {
             3.118033988749895, -0.5, -2.118033988749895}, {
             3.118033988749895, -0.5, 2.118033988749895}, {3.118033988749895, 
             0.5, -2.118033988749895}, {3.118033988749895, 0.5, 
             2.118033988749895}, {
             1.8090169943749475`, -1.618033988749895, -2.9270509831248424`}, {
             1.8090169943749475`, -1.618033988749895, 2.9270509831248424`}, {
             1.8090169943749475`, 1.618033988749895, -2.9270509831248424`}, {
             1.8090169943749475`, 1.618033988749895, 2.9270509831248424`}, {
             2.9270509831248424`, -1.8090169943749475`, -1.618033988749895}, {
             2.9270509831248424`, -1.8090169943749475`, 1.618033988749895}, {
             2.9270509831248424`, 1.8090169943749475`, -1.618033988749895}, {
             2.9270509831248424`, 1.8090169943749475`, 1.618033988749895}, {
             3.4270509831248424`, -1, -1.3090169943749475`}, {
             3.4270509831248424`, -1, 1.3090169943749475`}, {
             3.4270509831248424`, 1, -1.3090169943749475`}, {
             3.4270509831248424`, 1, 1.3090169943749475`}}], 
           Polygon3DBox[{{2, 6, 8, 4, 44, 56, 68, 66, 54, 42}, {109, 29, 17, 
             19, 31, 111, 103, 107, 105, 101}, {24, 30, 18, 6, 2, 12}, {7, 3, 
             15, 27, 31, 19}, {58, 57, 33, 37, 73, 69, 70, 74, 38, 34}, {84, 
             116, 120, 88, 87, 119, 115, 83, 91, 92}, {90, 89, 81, 113, 117, 
             85, 86, 118, 114, 82}, {36, 40, 76, 72, 71, 75, 39, 35, 59, 
             60}, {5, 17, 29, 23, 11, 1}, {4, 8, 20, 32, 28, 16}, {67, 55, 43,
              3, 7, 5, 1, 41, 53, 65}, {18, 30, 110, 102, 106, 108, 104, 112, 
             32, 20}, {79, 83, 115, 103, 111, 97}, {38, 74, 62, 48, 42, 54}, {
             4, 16, 50, 44}, {23, 29, 109, 95}, {96, 110, 30, 24}, {43, 49, 
             15, 3}, {53, 41, 47, 61, 73, 37}, {98, 112, 104, 116, 84, 80}, {
             69, 45, 9, 10, 46, 70}, {26, 100, 92, 91, 99, 25}, {82, 114, 102,
              110, 96, 78}, {55, 39, 75, 63, 49, 43}, {1, 11, 47, 41}, {28, 
             32, 112, 98}, {61, 47, 11, 23, 95, 77, 93, 21, 9, 45}, {50, 16, 
             28, 98, 80, 100, 26, 14, 52, 64}, {97, 111, 31, 27}, {42, 48, 12,
              2}, {44, 50, 64, 76, 40, 56}, {77, 95, 109, 101, 113, 81}, {63, 
             51, 13, 25, 99, 79, 97, 27, 15, 49}, {46, 10, 22, 94, 78, 96, 24,
              12, 48, 62}, {52, 14, 13, 51, 71, 72}, {22, 21, 93, 89, 90, 
             94}, {115, 119, 107, 103}, {34, 38, 54, 66}, {71, 51, 63, 75}, {
             94, 90, 82, 78}, {114, 118, 106, 102}, {35, 39, 55, 67}, {70, 46,
              62, 74}, {99, 91, 83, 79}, {65, 53, 37, 33}, {104, 108, 120, 
             116}, {77, 81, 89, 93}, {76, 64, 52, 72}, {59, 35, 67, 65, 33, 
             57}, {106, 118, 86, 88, 120, 108}, {68, 56, 40, 36}, {101, 105, 
             117, 113}, {80, 84, 92, 100}, {73, 61, 45, 69}, {34, 66, 68, 36, 
             60, 58}, {105, 107, 119, 87, 85, 117}, {7, 19, 17, 5}, {6, 18, 
             20, 8}, {14, 26, 25, 13}, {9, 21, 22, 10}, {58, 60, 59, 57}, {85,
              87, 88, 86}}]]],
         "\"great rhombicosidodecahedron\""],
        Annotation[#, "great rhombicosidodecahedron", "Tooltip"]& ],
       TraditionalForm], {585., -967.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Root[3721 - 65628 #^2 + 31104 #^4 + 1050624 #^6 + 2426112 #^8 - 
               13188096 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 68 #^2 + 1216 #^4 - 5888 #^6 + 9472 #^8 - 5120 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 10584 #^2 + 441072 #^4 - 3430080 #^6 + 7962624 #^8 - 
               3234816 #^10 + 2985984 #^12& , 6, 0]}, {
             Root[3721 - 65628 #^2 + 31104 #^4 + 1050624 #^6 + 2426112 #^8 - 
               13188096 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 68 #^2 + 1216 #^4 - 5888 #^6 + 9472 #^8 - 5120 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 10584 #^2 + 441072 #^4 - 3430080 #^6 + 7962624 #^8 - 
               3234816 #^10 + 2985984 #^12& , 3, 0]}, {
             Root[5041 - 289884 #^2 + 2745792 #^4 - 10091520 #^6 + 
               17190144 #^8 - 13188096 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 68 #^2 + 1216 #^4 - 5888 #^6 + 9472 #^8 - 5120 #^10 + 
               4096 #^12& , 8, 0], Root[
              361 - 292488 #^2 + 2858544 #^4 - 6492096 #^6 + 1078272 #^8 - 
               3234816 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[5041 - 289884 #^2 + 2745792 #^4 - 10091520 #^6 + 
               17190144 #^8 - 13188096 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 68 #^2 + 1216 #^4 - 5888 #^6 + 9472 #^8 - 5120 #^10 + 
               4096 #^12& , 8, 0], Root[
              361 - 292488 #^2 + 2858544 #^4 - 6492096 #^6 + 1078272 #^8 - 
               3234816 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 1272 #^2 + 158544 #^4 + 763776 #^6 - 787968 #^8 - 
               12939264 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 56 #^2 + 912 #^4 - 6016 #^6 + 15872 #^8 - 12288 #^10 + 
               4096 #^12& , 6, 0], Root[
              961 - 95784 #^2 + 1076976 #^4 - 3568320 #^6 + 1824768 #^8 + 
               1741824 #^10 + 2985984 #^12& , 6, 0]}, {
             Root[1 - 1272 #^2 + 158544 #^4 + 763776 #^6 - 787968 #^8 - 
               12939264 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 56 #^2 + 912 #^4 - 6016 #^6 + 15872 #^8 - 12288 #^10 + 
               4096 #^12& , 6, 0], Root[
              961 - 95784 #^2 + 1076976 #^4 - 3568320 #^6 + 1824768 #^8 + 
               1741824 #^10 + 2985984 #^12& , 3, 0]}, {
             Root[17161 - 386076 #^2 + 3170448 #^4 - 11460096 #^6 + 
               17750016 #^8 - 12192768 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 100 #^2 + 1872 #^4 - 9472 #^6 + 9216 #^8 - 13312 #^10 + 
               4096 #^12& , 8, 0], Root[
              961 - 95784 #^2 + 1076976 #^4 - 3568320 #^6 + 1824768 #^8 + 
               1741824 #^10 + 2985984 #^12& , 3, 0]}, {
             Root[17161 - 386076 #^2 + 3170448 #^4 - 11460096 #^6 + 
               17750016 #^8 - 12192768 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 100 #^2 + 1872 #^4 - 9472 #^6 + 9216 #^8 - 13312 #^10 + 
               4096 #^12& , 8, 0], Root[
              961 - 95784 #^2 + 1076976 #^4 - 3568320 #^6 + 1824768 #^8 + 
               1741824 #^10 + 2985984 #^12& , 6, 0]}, {
             Root[3481 - 83304 #^2 + 701136 #^4 - 2782080 #^6 + 7423488 #^8 - 
               11943936 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 56 #^2 + 912 #^4 - 6016 #^6 + 15872 #^8 - 12288 #^10 + 
               4096 #^12& , 3, 0], Root[
              22801 - 432792 #^2 + 2409264 #^4 - 3340224 #^6 - 3898368 #^8 + 
               746496 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[3481 - 83304 #^2 + 701136 #^4 - 2782080 #^6 + 7423488 #^8 - 
               11943936 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 56 #^2 + 912 #^4 - 6016 #^6 + 15872 #^8 - 12288 #^10 + 
               4096 #^12& , 3, 0], Root[
              22801 - 432792 #^2 + 2409264 #^4 - 3340224 #^6 - 3898368 #^8 + 
               746496 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[6241 - 211068 #^2 + 2283984 #^4 - 9542016 #^6 + 
               16941312 #^8 - 11943936 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 36 #^2 + 272 #^4 + 384 #^6 - 768 #^8 - 12288 #^10 + 
               4096 #^12& , 8, 0], Root[
              22801 - 432792 #^2 + 2409264 #^4 - 3340224 #^6 - 3898368 #^8 + 
               746496 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[6241 - 211068 #^2 + 2283984 #^4 - 9542016 #^6 + 
               16941312 #^8 - 11943936 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 36 #^2 + 272 #^4 + 384 #^6 - 768 #^8 - 12288 #^10 + 
               4096 #^12& , 8, 0], Root[
              22801 - 432792 #^2 + 2409264 #^4 - 3340224 #^6 - 3898368 #^8 + 
               746496 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[361 - 83964 #^2 + 2241792 #^4 - 11102400 #^6 + 17812224 #^8 - 
               11943936 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 116 #^2 + 3456 #^4 - 7488 #^6 + 1792 #^8 - 8192 #^10 + 
               4096 #^12& , 8, 0], Root[
              361 - 71736 #^2 + 1573488 #^4 - 167616 #^6 - 3400704 #^8 - 
               2239488 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[361 - 83964 #^2 + 2241792 #^4 - 11102400 #^6 + 17812224 #^8 - 
               11943936 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 116 #^2 + 3456 #^4 - 7488 #^6 + 1792 #^8 - 8192 #^10 + 
               4096 #^12& , 8, 0], Root[
              361 - 71736 #^2 + 1573488 #^4 - 167616 #^6 - 3400704 #^8 - 
               2239488 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[361 - 56064 #^2 + 1461024 #^4 + 1707264 #^6 - 373248 #^8 - 
               11197440 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 160 #^2 + 1312 #^4 - 2048 #^6 - 3584 #^8 + 3072 #^10 + 
               4096 #^12& , 8, 0], Root[
              841 - 44232 #^2 + 705456 #^4 - 4688064 #^6 + 12939264 #^8 - 
               11197440 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[361 - 56064 #^2 + 1461024 #^4 + 1707264 #^6 - 373248 #^8 - 
               11197440 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 160 #^2 + 1312 #^4 - 2048 #^6 - 3584 #^8 + 3072 #^10 + 
               4096 #^12& , 8, 0], Root[
              841 - 44232 #^2 + 705456 #^4 - 4688064 #^6 + 12939264 #^8 - 
               11197440 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[14641 - 604032 #^2 + 5589216 #^4 - 15704064 #^6 + 
               18537984 #^8 - 11197440 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 160 #^2 + 1312 #^4 - 2048 #^6 - 3584 #^8 + 3072 #^10 + 
               4096 #^12& , 1, 0], Root[
              1681 - 113304 #^2 + 1571184 #^4 - 7390656 #^6 + 11446272 #^8 - 
               11197440 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[14641 - 604032 #^2 + 5589216 #^4 - 15704064 #^6 + 
               18537984 #^8 - 11197440 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 160 #^2 + 1312 #^4 - 2048 #^6 - 3584 #^8 + 3072 #^10 + 
               4096 #^12& , 1, 0], Root[
              1681 - 113304 #^2 + 1571184 #^4 - 7390656 #^6 + 11446272 #^8 - 
               11197440 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[961 - 109116 #^2 + 1807488 #^4 - 6492096 #^6 + 11010816 #^8 - 
               10948608 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 116 #^2 + 3456 #^4 - 7488 #^6 + 1792 #^8 - 8192 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 10584 #^2 + 441072 #^4 - 3430080 #^6 + 7962624 #^8 - 
               3234816 #^10 + 2985984 #^12& , 3, 0]}, {
             Root[961 - 109116 #^2 + 1807488 #^4 - 6492096 #^6 + 11010816 #^8 - 
               10948608 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 116 #^2 + 3456 #^4 - 7488 #^6 + 1792 #^8 - 8192 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 10584 #^2 + 441072 #^4 - 3430080 #^6 + 7962624 #^8 - 
               3234816 #^10 + 2985984 #^12& , 6, 0]}, {
             Root[5041 - 240000 #^2 + 3312288 #^4 - 11062656 #^6 + 
               15365376 #^8 - 10450944 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 48 #^2 + 672 #^4 - 3456 #^6 + 4352 #^8 + 6144 #^10 + 
               4096 #^12& , 7, 0], Root[
              961 - 90696 #^2 + 1566576 #^4 - 7750080 #^6 + 15925248 #^8 - 
               14183424 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[5041 - 240000 #^2 + 3312288 #^4 - 11062656 #^6 + 
               15365376 #^8 - 10450944 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 48 #^2 + 672 #^4 - 3456 #^6 + 4352 #^8 + 6144 #^10 + 
               4096 #^12& , 7, 0], Root[
              961 - 90696 #^2 + 1566576 #^4 - 7750080 #^6 + 15925248 #^8 - 
               14183424 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[11881 - 272016 #^2 + 2297376 #^4 - 8899200 #^6 + 
               15614208 #^8 - 10450944 #^10 + 2985984 #^12& , 3, 0], Root[
              1 - 48 #^2 + 672 #^4 - 3456 #^6 + 4352 #^8 + 6144 #^10 + 
               4096 #^12& , 2, 0], Root[
              1 - 360 #^2 + 12528 #^4 - 478656 #^6 + 5723136 #^8 - 
               14183424 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[11881 - 272016 #^2 + 2297376 #^4 - 8899200 #^6 + 
               15614208 #^8 - 10450944 #^10 + 2985984 #^12& , 6, 0], Root[
              1 - 48 #^2 + 672 #^4 - 3456 #^6 + 4352 #^8 + 6144 #^10 + 
               4096 #^12& , 2, 0], Root[
              1 - 360 #^2 + 12528 #^4 - 478656 #^6 + 5723136 #^8 - 
               14183424 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[361 - 38172 #^2 + 1001376 #^4 - 4472064 #^6 + 8169984 #^8 - 
               9953280 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 132 #^2 + 4256 #^4 - 3072 #^6 - 9728 #^8 + 4096 #^12& , 1, 
               0], Root[
              1 - 176136 #^2 + 2371248 #^4 - 9332928 #^6 + 14764032 #^8 - 
               10202112 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[361 - 38172 #^2 + 1001376 #^4 - 4472064 #^6 + 8169984 #^8 - 
               9953280 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 132 #^2 + 4256 #^4 - 3072 #^6 - 9728 #^8 + 4096 #^12& , 1, 
               0], Root[
              1 - 176136 #^2 + 2371248 #^4 - 9332928 #^6 + 14764032 #^8 - 
               10202112 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[5041 - 180336 #^2 + 912816 #^4 + 1028160 #^6 - 4396032 #^8 - 
               9206784 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 128 #^2 + 1392 #^4 - 4672 #^6 + 4096 #^8 - 1024 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 176136 #^2 + 2371248 #^4 - 9332928 #^6 + 14764032 #^8 - 
               10202112 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[5041 - 180336 #^2 + 912816 #^4 + 1028160 #^6 - 4396032 #^8 - 
               9206784 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 128 #^2 + 1392 #^4 - 4672 #^6 + 4096 #^8 - 1024 #^10 + 
               4096 #^12& , 1, 0], Root[
              1 - 176136 #^2 + 2371248 #^4 - 9332928 #^6 + 14764032 #^8 - 
               10202112 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[
              6241 - 97356 #^2 + 351648 #^4 + 110592 #^6 + 870912 #^8 - 
               8957952 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 132 #^2 + 4256 #^4 - 3072 #^6 - 9728 #^8 + 4096 #^12& , 8, 
               0], Root[
              841 - 44232 #^2 + 705456 #^4 - 4688064 #^6 + 12939264 #^8 - 
               11197440 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[6241 - 97356 #^2 + 351648 #^4 + 110592 #^6 + 870912 #^8 - 
               8957952 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 132 #^2 + 4256 #^4 - 3072 #^6 - 9728 #^8 + 4096 #^12& , 8, 
               0], Root[
              841 - 44232 #^2 + 705456 #^4 - 4688064 #^6 + 12939264 #^8 - 
               11197440 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[7921 - 275484 #^2 + 2564496 #^4 - 8951040 #^6 + 
               13022208 #^8 - 8211456 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 100 #^2 + 1872 #^4 - 9472 #^6 + 9216 #^8 - 13312 #^10 + 
               4096 #^12& , 1, 0], Root[
              361 - 71736 #^2 + 1573488 #^4 - 167616 #^6 - 3400704 #^8 - 
               2239488 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[7921 - 275484 #^2 + 2564496 #^4 - 8951040 #^6 + 
               13022208 #^8 - 8211456 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 100 #^2 + 1872 #^4 - 9472 #^6 + 9216 #^8 - 13312 #^10 + 
               4096 #^12& , 1, 0], Root[
              361 - 71736 #^2 + 1573488 #^4 - 167616 #^6 - 3400704 #^8 - 
               2239488 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 1452 #^2 + 348624 #^4 - 5457024 #^6 + 11964672 #^8 - 
               7962624 #^10 + 2985984 #^12& , 2, 0], Root[
              1 - 36 #^2 + 272 #^4 + 384 #^6 - 768 #^8 - 12288 #^10 + 
               4096 #^12& , 1, 0], Root[
              361 - 292488 #^2 + 2858544 #^4 - 6492096 #^6 + 1078272 #^8 - 
               3234816 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 1452 #^2 + 348624 #^4 - 5457024 #^6 + 11964672 #^8 - 
               7962624 #^10 + 2985984 #^12& , 7, 0], Root[
              1 - 36 #^2 + 272 #^4 + 384 #^6 - 768 #^8 - 12288 #^10 + 
               4096 #^12& , 1, 0], Root[
              361 - 292488 #^2 + 2858544 #^4 - 6492096 #^6 + 1078272 #^8 - 
               3234816 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[841 - 73056 #^2 + 1265328 #^4 - 6887808 #^6 + 11964672 #^8 - 
               7713792 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 48 #^2 + 752 #^4 - 4736 #^6 + 14592 #^8 - 19456 #^10 + 
               4096 #^12& , 1, 0], Root[
              961 - 95784 #^2 + 1076976 #^4 - 3568320 #^6 + 1824768 #^8 + 
               1741824 #^10 + 2985984 #^12& , 3, 0]}, {
             Root[841 - 73056 #^2 + 1265328 #^4 - 6887808 #^6 + 11964672 #^8 - 
               7713792 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 48 #^2 + 752 #^4 - 4736 #^6 + 14592 #^8 - 19456 #^10 + 
               4096 #^12& , 1, 0], Root[
              961 - 95784 #^2 + 1076976 #^4 - 3568320 #^6 + 1824768 #^8 + 
               1741824 #^10 + 2985984 #^12& , 6, 0]}, {
             Root[1 - 3384 #^2 + 1219104 #^4 - 5679936 #^6 + 7921152 #^8 - 
               7464960 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 488 #^2 + 5728 #^4 - 20160 #^6 + 29184 #^8 - 18432 #^10 + 
               4096 #^12& , 1, 0], Root[
              22801 - 432792 #^2 + 2409264 #^4 - 3340224 #^6 - 3898368 #^8 + 
               746496 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 3384 #^2 + 1219104 #^4 - 5679936 #^6 + 7921152 #^8 - 
               7464960 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 488 #^2 + 5728 #^4 - 20160 #^6 + 29184 #^8 - 18432 #^10 + 
               4096 #^12& , 1, 0], Root[
              22801 - 432792 #^2 + 2409264 #^4 - 3340224 #^6 - 3898368 #^8 + 
               746496 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 20280 #^2 + 1035648 #^4 - 781056 #^6 - 8999424 #^8 - 
               6718464 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 56 #^2 + 1024 #^4 - 7168 #^6 + 18944 #^8 - 15360 #^10 + 
               4096 #^12& , 5, 0], Root[
              361 - 71736 #^2 + 1573488 #^4 - 167616 #^6 - 3400704 #^8 - 
               2239488 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 20280 #^2 + 1035648 #^4 - 781056 #^6 - 8999424 #^8 - 
               6718464 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 56 #^2 + 1024 #^4 - 7168 #^6 + 18944 #^8 - 15360 #^10 + 
               4096 #^12& , 5, 0], Root[
              361 - 71736 #^2 + 1573488 #^4 - 167616 #^6 - 3400704 #^8 - 
               2239488 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[10201 - 246120 #^2 + 1816128 #^4 - 4962816 #^6 + 
               5101056 #^8 - 6718464 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 328 #^2 + 2944 #^4 - 8960 #^6 + 9728 #^8 - 3072 #^10 + 
               4096 #^12& , 2, 0], Root[
              1681 - 113304 #^2 + 1571184 #^4 - 7390656 #^6 + 11446272 #^8 - 
               11197440 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[
              10201 - 246120 #^2 + 1816128 #^4 - 4962816 #^6 + 5101056 #^8 - 
               6718464 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 328 #^2 + 2944 #^4 - 8960 #^6 + 9728 #^8 - 3072 #^10 + 
               4096 #^12& , 2, 0], Root[
              1681 - 113304 #^2 + 1571184 #^4 - 7390656 #^6 + 11446272 #^8 - 
               11197440 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[11881 - 341376 #^2 + 3016368 #^4 - 8434368 #^6 + 
               8957952 #^8 - 5225472 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 128 #^2 + 1392 #^4 - 4672 #^6 + 4096 #^8 - 1024 #^10 + 
               4096 #^12& , 8, 0], Root[
              961 - 90696 #^2 + 1566576 #^4 - 7750080 #^6 + 15925248 #^8 - 
               14183424 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[11881 - 341376 #^2 + 3016368 #^4 - 8434368 #^6 + 
               8957952 #^8 - 5225472 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 128 #^2 + 1392 #^4 - 4672 #^6 + 4096 #^8 - 1024 #^10 + 
               4096 #^12& , 8, 0], Root[
              961 - 90696 #^2 + 1566576 #^4 - 7750080 #^6 + 15925248 #^8 - 
               14183424 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[361 - 29856 #^2 + 588816 #^4 - 1926720 #^6 - 1907712 #^8 - 
               4230144 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 416 #^2 + 6672 #^4 - 21696 #^6 + 28672 #^8 - 17408 #^10 + 
               4096 #^12& , 8, 0], Root[
              361 - 292488 #^2 + 2858544 #^4 - 6492096 #^6 + 1078272 #^8 - 
               3234816 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[361 - 29856 #^2 + 588816 #^4 - 1926720 #^6 - 1907712 #^8 - 
               4230144 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 416 #^2 + 6672 #^4 - 21696 #^6 + 28672 #^8 - 17408 #^10 + 
               4096 #^12& , 8, 0], Root[
              361 - 292488 #^2 + 2858544 #^4 - 6492096 #^6 + 1078272 #^8 - 
               3234816 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 504 #^2 + 65664 #^4 - 2647296 #^6 + 8335872 #^8 - 
               3732480 #^10 + 2985984 #^12& , 3, 0], Root[
              1 - 328 #^2 + 2944 #^4 - 8960 #^6 + 9728 #^8 - 3072 #^10 + 
               4096 #^12& , 7, 0], Root[
              1 - 360 #^2 + 12528 #^4 - 478656 #^6 + 5723136 #^8 - 
               14183424 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 504 #^2 + 65664 #^4 - 2647296 #^6 + 8335872 #^8 - 
               3732480 #^10 + 2985984 #^12& , 6, 0], Root[
              1 - 328 #^2 + 2944 #^4 - 8960 #^6 + 9728 #^8 - 3072 #^10 + 
               4096 #^12& , 7, 0], Root[
              1 - 360 #^2 + 12528 #^4 - 478656 #^6 + 5723136 #^8 - 
               14183424 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 18792 #^2 + 524016 #^4 - 3443904 #^6 + 6718464 #^8 - 
               1244160 #^10 + 2985984 #^12& , 2, 0], Root[
              1 - 40 #^2 + 624 #^4 - 4672 #^6 + 16384 #^8 - 21504 #^10 + 
               4096 #^12& , 8, 0], Root[
              1 - 10584 #^2 + 441072 #^4 - 3430080 #^6 + 7962624 #^8 - 
               3234816 #^10 + 2985984 #^12& , 3, 0]}, {
             Root[1 - 18792 #^2 + 524016 #^4 - 3443904 #^6 + 6718464 #^8 - 
               1244160 #^10 + 2985984 #^12& , 7, 0], Root[
              1 - 40 #^2 + 624 #^4 - 4672 #^6 + 16384 #^8 - 21504 #^10 + 
               4096 #^12& , 8, 0], Root[
              1 - 10584 #^2 + 441072 #^4 - 3430080 #^6 + 7962624 #^8 - 
               3234816 #^10 + 2985984 #^12& , 6, 0]}, {
             Root[1 - 7104 #^2 + 351216 #^4 - 3300480 #^6 + 2757888 #^8 + 
               4230144 #^10 + 2985984 #^12& , 2, 0], Root[
              1 - 48 #^2 + 752 #^4 - 4736 #^6 + 14592 #^8 - 19456 #^10 + 
               4096 #^12& , 8, 0], Root[
              1 - 176136 #^2 + 2371248 #^4 - 9332928 #^6 + 14764032 #^8 - 
               10202112 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 7104 #^2 + 351216 #^4 - 3300480 #^6 + 2757888 #^8 + 
               4230144 #^10 + 2985984 #^12& , 7, 0], Root[
              1 - 48 #^2 + 752 #^4 - 4736 #^6 + 14592 #^8 - 19456 #^10 + 
               4096 #^12& , 8, 0], Root[
              1 - 176136 #^2 + 2371248 #^4 - 9332928 #^6 + 14764032 #^8 - 
               10202112 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[361 - 23352 #^2 + 432864 #^4 - 2666304 #^6 + 2115072 #^8 + 
               4478976 #^10 + 2985984 #^12& , 4, 0], Root[
              1 - 488 #^2 + 5728 #^4 - 20160 #^6 + 29184 #^8 - 18432 #^10 + 
               4096 #^12& , 8, 0], Root[
              1681 - 113304 #^2 + 1571184 #^4 - 7390656 #^6 + 11446272 #^8 - 
               11197440 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[361 - 23352 #^2 + 432864 #^4 - 2666304 #^6 + 2115072 #^8 + 
               4478976 #^10 + 2985984 #^12& , 5, 0], Root[
              1 - 488 #^2 + 5728 #^4 - 20160 #^6 + 29184 #^8 - 18432 #^10 + 
               4096 #^12& , 8, 0], Root[
              1681 - 113304 #^2 + 1571184 #^4 - 7390656 #^6 + 11446272 #^8 - 
               11197440 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[5041 - 143496 #^2 + 1133568 #^4 - 2958336 #^6 + 124416 #^8 + 
               5225472 #^10 + 2985984 #^12& , 1, 0], Root[
              1 - 56 #^2 + 1024 #^4 - 7168 #^6 + 18944 #^8 - 15360 #^10 + 
               4096 #^12& , 4, 0], Root[
              1 - 360 #^2 + 12528 #^4 - 478656 #^6 + 5723136 #^8 - 
               14183424 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[5041 - 143496 #^2 + 1133568 #^4 - 2958336 #^6 + 124416 #^8 + 
               5225472 #^10 + 2985984 #^12& , 8, 0], Root[
              1 - 56 #^2 + 1024 #^4 - 7168 #^6 + 18944 #^8 - 15360 #^10 + 
               4096 #^12& , 4, 0], Root[
              1 - 360 #^2 + 12528 #^4 - 478656 #^6 + 5723136 #^8 - 
               14183424 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[961 - 36984 #^2 + 466992 #^4 - 2185920 #^6 + 1741824 #^8 + 
               6718464 #^10 + 2985984 #^12& , 4, 0], Root[
              1 - 40 #^2 + 624 #^4 - 4672 #^6 + 16384 #^8 - 21504 #^10 + 
               4096 #^12& , 1, 0], Root[
              841 - 44232 #^2 + 705456 #^4 - 4688064 #^6 + 12939264 #^8 - 
               11197440 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[961 - 36984 #^2 + 466992 #^4 - 2185920 #^6 + 1741824 #^8 + 
               6718464 #^10 + 2985984 #^12& , 5, 0], Root[
              1 - 40 #^2 + 624 #^4 - 4672 #^6 + 16384 #^8 - 21504 #^10 + 
               4096 #^12& , 1, 0], Root[
              841 - 44232 #^2 + 705456 #^4 - 4688064 #^6 + 12939264 #^8 - 
               11197440 #^10 + 2985984 #^12& , 1, 0]}, {
             Root[1 - 528 #^2 + 69264 #^4 - 1498176 #^6 + 2737152 #^8 + 
               6718464 #^10 + 2985984 #^12& , 2, 0], Root[
              1 - 416 #^2 + 6672 #^4 - 21696 #^6 + 28672 #^8 - 17408 #^10 + 
               4096 #^12& , 1, 0], Root[
              961 - 90696 #^2 + 1566576 #^4 - 7750080 #^6 + 15925248 #^8 - 
               14183424 #^10 + 2985984 #^12& , 8, 0]}, {
             Root[1 - 528 #^2 + 69264 #^4 - 1498176 #^6 + 2737152 #^8 + 
               6718464 #^10 + 2985984 #^12& , 7, 0], Root[
              1 - 416 #^2 + 6672 #^4 - 21696 #^6 + 28672 #^8 - 17408 #^10 + 
               4096 #^12& , 1, 0], Root[
              961 - 90696 #^2 + 1566576 #^4 - 7750080 #^6 + 15925248 #^8 - 
               14183424 #^10 + 2985984 #^12& , 1, 0]}}, CompressedData["
1:eJxd01tIVFEUBuDTZFmZZRcN6kEneugoU2PTlEiwpuyCYJaaqRGYUZqmCZZg
UmREFzR7UINABBM1I7EUExyUdQiZxBRTG4byMlhj43iJUcvxMmfMh73Pw3rY
Lx+bzeJf/1ZfzY69rhIE4djqWbt6NlX8KLOkClJbwkJ/U6kNc8NSPBG3TcDc
QBwfHlG5dbFLyByqxOn7btMcMAfiuD62cM18uyCZCxqv9GrM0ODb7T+R/x2Y
G4hjd9F4WF/cPyxKTqs0JS1RB+Jgr4vcH3lYRvYO6tTrQvaVznAH4nhJX9xa
ssGGUT7PQ1Ocy0AciMMZlWPG7HGiq2SjoyHCBU2eBXeSa5Y7EMez27JSvCc8
GGl+eVodOAndzy5naBKHuANx8A6wO9JiZvl9jFdLn4Nsi9yBOKarql/0n1vk
8yh7YQ7EwdmSdUqcdOLd3sGlHbIFmuTUnpw7MjIH4mBsEevNu4f4fax8s3xg
tEKQmANxw6e9Xl5VKwuo/Rb+3iXPoewblXqz2QHMgTgG+C4e3fNVxiBLY8nj
aDt1IA6hIVMX83XL/H0lN+ZAHPOyh/s/Rtl5f5DvizkQxyeWEb97Qh/vA/Le
Mgfi8ECbWKY/P44SluaF16wg7ydzIA7hWx59WTk4h7veJSdNV88rPWQOxMHL
mDCorXHj62t/jO0fOpVeMQfiUKwRy4Ptf3GsQMxsDf6p9IQ5EIexjFe5cdGT
PH9l78yBOFYWdLl2bp/HW9atnU9rZ5R/zRyIg/6QSqz9ZeTzAO8PcyBuqB85
mZnjGsYM6wmxwyQYeJ+ZA3GIeTvQazs+wPMH3hPmQBx1bX6F/g0dPH/gOTAH
4lit1pdb00d5/krPmQNx6bfW+8KN5h4+v8T7yRyI45TP5nh3YBfPE3n+zIE4
/gcnACJE
            "]], 
           Polygon3DBox[{{5, 1, 9}, {5, 9, 3}, {5, 29, 15}, {5, 3, 29}, {1, 
             27, 19}, {1, 19, 25}, {1, 25, 9}, {15, 29, 7}, {15, 45, 39}, {15,
              7, 45}, {27, 39, 41}, {27, 41, 37}, {27, 37, 19}, {9, 25, 17}, {
             39, 45, 21}, {39, 21, 41}, {29, 3, 13}, {3, 43, 13}, {19, 37, 
             35}, {25, 31, 17}, {45, 7, 11}, {7, 49, 11}, {41, 21, 23}, {37, 
             33, 35}, {17, 31, 59}, {17, 59, 55}, {13, 43, 53}, {13, 53, 
             51}, {21, 47, 23}, {43, 55, 48}, {43, 48, 53}, {35, 33, 58}, {35,
              58, 57}, {31, 57, 34}, {31, 34, 59}, {11, 49, 52}, {11, 52, 
             54}, {55, 59, 24}, {55, 24, 48}, {49, 51, 50}, {49, 50, 52}, {23,
              47, 56}, {23, 56, 60}, {51, 53, 12}, {51, 12, 50}, {33, 60, 
             32}, {33, 32, 58}, {57, 58, 36}, {57, 36, 34}, {47, 54, 44}, {47,
              44, 56}, {48, 24, 22}, {54, 52, 14}, {54, 14, 44}, {60, 56, 
             18}, {60, 18, 32}, {34, 36, 38}, {24, 42, 22}, {50, 12, 8}, {12, 
             46, 8}, {32, 18, 26}, {36, 20, 38}, {44, 14, 4}, {22, 42, 40}, {
             22, 40, 46}, {14, 30, 4}, {18, 10, 26}, {38, 20, 28}, {38, 28, 
             42}, {42, 28, 40}, {8, 46, 16}, {8, 16, 30}, {46, 40, 16}, {26, 
             10, 2}, {26, 2, 20}, {20, 2, 28}, {4, 30, 6}, {4, 6, 10}, {30, 
             16, 6}, {10, 6, 2}, {39, 27, 1, 5, 15}, {3, 9, 17, 55, 43}, {51, 
             49, 7, 29, 13}, {57, 31, 25, 19, 35}, {47, 21, 45, 11, 54}, {33, 
             37, 41, 23, 60}, {42, 24, 59, 34, 38}, {46, 12, 53, 48, 22}, {36,
              58, 32, 26, 20}, {14, 52, 50, 8, 30}, {44, 4, 10, 18, 56}, {16, 
             40, 28, 2, 6}}]]],
         "\"snub dodecahedron\""],
        Annotation[#, "snub dodecahedron", "Tooltip"]& ],
       TraditionalForm], {975., -967.5}, {Center, Center}, {360., 360.},
      ContentSelectable->True], 
     TagBox[InsetBox["", {1365., -967.5}, {Center, Center}, {360., 360.}],
      "InsetString"], 
     TagBox[InsetBox["", {1755., -967.5}, {Center, Center}, {360., 360.}],
      "InsetString"]}}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 ImageSize->{364, 213},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->Automatic},
 Graphics3DBoxOptions->{ImageSize->Automatic},
 CellLabel->"Out[2]=",
 CellID->1453002978]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134757383],

Cell["Deltahedra:", "ExampleText",
 CellID->1717717394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<Deltahedron\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1040029290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Dipyramid\"\>", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dipyramid\"\>", ",", "5"}], "}"}], 
   ",", "\<\"GyroelongatedSquareDipyramid\"\>", ",", "\<\"Icosahedron\"\>", 
   ",", "\<\"MathematicaPolyhedron\"\>", ",", "\<\"Octahedron\"\>", 
   ",", "\<\"SnubDisphenoid\"\>", ",", "\<\"Tetrahedron\"\>", 
   ",", "\<\"TriaugmentedTriangularPrism\"\>"}], "}"}]], "Output",
 ImageSize->{427, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1584501209]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Tooltip", "@@@", 
     RowBox[{"Rest", "/@", 
      RowBox[{"Sort", "[", 
       RowBox[{"PolyhedronData", "[", 
        RowBox[{"\"\<Deltahedron\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<FaceCount\>\"", ",", "\"\<Image\>\"", ",", "\"\<Name\>\""}], 
          "}"}]}], "]"}], "]"}]}]}], ",", "5", ",", "5", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->881987866],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, 0, Rational[2, 3]^Rational[1, 2] + 
              Rational[-1, 2] 6^Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 2] 6^Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 2] 6^Rational[-1, 2]}, {
             3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}}, {{
             0, 0, 0.6123724356957945}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
             0.5773502691896258, 0, -0.20412414523193154`}}], 
           Polygon3DBox[{{2, 3, 4}, {3, 2, 1}, {4, 1, 2}, {1, 4, 3}}]]],
         "\"tetrahedron\""],
        Annotation[#, "tetrahedron", "Tooltip"]& ],
       TraditionalForm], {195., -192.}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, 0, -Rational[2, 3]^Rational[1, 2]}, {
             0, 0, Rational[2, 3]^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 0}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 0}, {
             3^Rational[-1, 2], 0, 0}}, {{0, 0, -0.816496580927726}, {
             0, 0, 0.816496580927726}, {-0.2886751345948129, -0.5, 
              0}, {-0.2886751345948129, 0.5, 0}, {0.5773502691896258, 0, 0}}],
            Polygon3DBox[{{4, 3, 2}, {3, 5, 2}, {5, 4, 2}, {1, 3, 4}, {1, 5, 
            3}, {1, 4, 5}}]]],
         "\"triangular dipyramid\""],
        Annotation[#, "triangular dipyramid", "Tooltip"]& ],
       TraditionalForm], {585., -192.}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{Rational[-1, 2], Rational[-1, 2], 0}, {
             Rational[-1, 2], Rational[1, 2], 0}, {
             0, 0, -2^Rational[-1, 2]}, {0, 0, 2^Rational[-1, 2]}, {
             Rational[1, 2], Rational[-1, 2], 0}, {
             Rational[1, 2], Rational[1, 2], 0}}, {{-0.5, -0.5, 0}, {-0.5, 
              0.5, 0}, {0, 0, -0.7071067811865475}, {
             0, 0, 0.7071067811865475}, {0.5, -0.5, 0}, {0.5, 0.5, 0}}], 
           Polygon3DBox[{{4, 5, 6}, {4, 6, 2}, {4, 2, 1}, {4, 1, 5}, {5, 1, 
            3}, {5, 3, 6}, {3, 1, 2}, {6, 3, 2}}]]],
         "\"octahedron\""],
        Annotation[#, "octahedron", "Tooltip"]& ],
       TraditionalForm], {975., -192.}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, 0, -(Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             0, 0, (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[1, 2] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 0, 0}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              0}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              0}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 2], 0}}, {{
             0, 0, -0.5257311121191336}, {0, 0, 0.5257311121191336}, {
             0.8506508083520399, 0, 0}, {
             0.2628655560595668, -0.8090169943749475, 0}, {
             0.2628655560595668, 0.8090169943749475, 
              0}, {-0.6881909602355868, -0.5, 0}, {-0.6881909602355868, 0.5, 
              0}}], Polygon3DBox[{{5, 7, 2}, {7, 6, 2}, {6, 4, 2}, {4, 3, 
            2}, {3, 5, 2}, {1, 7, 5}, {1, 6, 7}, {1, 4, 6}, {1, 3, 4}, {1, 5, 
            3}}]]],
         "\"pentagonal dipyramid\""],
        Annotation[#, "pentagonal dipyramid", "Tooltip"]& ],
       TraditionalForm], {1365., -192.}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2], 0, -
              Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0]}, {
             0, Rational[-1, 2], Root[-4 - 8 #^2 - #^4 + 2 #^6& , 2, 0] - 
              Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0]}, {
             0, Rational[1, 2], Root[-4 - 8 #^2 - #^4 + 2 #^6& , 2, 0] - 
              Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0]}, {
             0, Root[-2 - 2 # + 3 #^2 + 2 #^3& , 2, 0], -
               Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0] + 
              Root[-1 - 22 #^2 + 64 #^4 + 32 #^6& , 2, 0]}, {
             0, Root[2 - 2 # - 3 #^2 + 2 #^3& , 2, 0], -
               Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0] + 
              Root[-1 - 22 #^2 + 64 #^4 + 32 #^6& , 2, 0]}, {
             Rational[1, 2], 0, -Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0]}, {
             Root[-2 - 2 # + 3 #^2 + 2 #^3& , 2, 0], 0, 
              Root[-8 - 15 #^2 + 8 #^4 + 16 #^6& , 2, 0] - 
              Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0]}, {
             Root[2 - 2 # - 3 #^2 + 2 #^3& , 2, 0], 0, 
              Root[-8 - 15 #^2 + 8 #^4 + 16 #^6& , 2, 0] - 
              Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0]}}, {{-0.5, 
              0, -0.7839309242325636}, {0, -0.5, 0.7839309242325636}, {
             0, 0.5, 0.7839309242325636}, {
             0, -0.6445842732241552, -0.20556156585325946`}, {
             0, 0.644584273224155, -0.20556156585325946`}, {
             0.5, 0, -0.7839309242325636}, {-0.6445842732241552, 0, 
              0.20556156585325958`}, {
             0.644584273224155, 0, 0.20556156585325958`}}], 
           Polygon3DBox[{{2, 3, 7}, {3, 2, 8}, {4, 2, 7}, {2, 4, 8}, {6, 8, 
            4}, {4, 1, 6}, {7, 1, 4}, {3, 5, 7}, {8, 5, 3}, {5, 8, 6}, {5, 6, 
            1}, {5, 1, 7}}]]],
         "\"snub disphenoid\""],
        Annotation[#, "snub disphenoid", "Tooltip"]& ],
       TraditionalForm], {1755., -192.}, {Center, Center}, {360., 360.},
      ContentSelectable->True]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], Rational[
              1, 2]}, {3^Rational[-1, 2], 0, Rational[-1, 2]}, {
             3^Rational[-1, 2], 0, Rational[1, 2]}, {
             Root[25 - 168 #^2 + 144 #^4& , 1, 0], 0, 0}, {
             Root[25 - 672 #^2 + 2304 #^4& , 4, 0], 
              Rational[1, 4] (-1 - 6^Rational[1, 2]), 0}, {
             Root[25 - 672 #^2 + 2304 #^4& , 4, 0], 
              Rational[1, 4] (1 + 6^Rational[1, 2]), 
              0}}, {{-0.2886751345948129, -0.5, -0.5}, {-0.2886751345948129, \
-0.5, 0.5}, {-0.2886751345948129, 0.5, -0.5}, {-0.2886751345948129, 0.5, 
             0.5}, {0.5773502691896258, 0, -0.5}, {
             0.5773502691896258, 0, 0.5}, {-0.9957819157813603, 0, 0}, {
             0.49789095789068016`, -0.8623724356957945, 0}, {
             0.49789095789068016`, 0.8623724356957945, 0}}], 
           Polygon3DBox[{{1, 3, 5}, {6, 4, 2}, {9, 5, 3}, {9, 3, 4}, {9, 4, 
            6}, {9, 6, 5}, {7, 3, 1}, {7, 1, 2}, {7, 2, 4}, {7, 4, 3}, {8, 1, 
            5}, {8, 5, 6}, {8, 6, 2}, {8, 2, 1}}]]],
         "\"triaugmented triangular prism\""],
        Annotation[#, "triaugmented triangular prism", "Tooltip"]& ],
       TraditionalForm], {195., -576.}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {
             0, 0, -2^Rational[-1, 2] + 
              Rational[-1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
                Rational[1, 2]}, {
             0, 0, 2^Rational[-1, 2] + 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^Rational[1, 2]}, {
             0, -2^Rational[-1, 2], 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^Rational[1, 2]}, {
             0, 2^Rational[-1, 2], 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2], 
              Rational[-1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {-2^Rational[-1, 2], 0, 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^Rational[1, 2]}, {
             2^Rational[-1, 2], 0, 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}}, {{-0.5, -0.5, -0.42044820762685725`}, {-0.5, 
             0.5, -0.42044820762685725`}, {0, 0, -1.1275549888134047`}, {
             0, 0, 1.1275549888134047`}, {
             0, -0.7071067811865475, 0.42044820762685725`}, {
             0, 0.7071067811865475, 0.42044820762685725`}, {
             0.5, -0.5, -0.42044820762685725`}, {0.5, 
             0.5, -0.42044820762685725`}, {-0.7071067811865475, 0, 
              0.42044820762685725`}, {
             0.7071067811865475, 0, 0.42044820762685725`}}], 
           Polygon3DBox[{{8, 6, 10}, {2, 9, 6}, {1, 5, 9}, {7, 10, 5}, {8, 2, 
            6}, {2, 1, 9}, {1, 7, 5}, {7, 8, 10}, {6, 9, 4}, {9, 5, 4}, {5, 
            10, 4}, {10, 6, 4}, {3, 2, 8}, {3, 1, 2}, {3, 7, 1}, {3, 8, 
            7}}]]],
         "\"gyroelongated square dipyramid\""],
        Annotation[#, "gyroelongated square dipyramid", "Tooltip"]& ],
       TraditionalForm], {585., -576.}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
             0, 0, 5 (50 - 10 5^Rational[1, 2])^
               Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
              0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
               Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
              Rational[-1, 2]}, {
             Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
               5^Rational[1, 2]), 
              Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
             Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
               5^Rational[1, 2]), Rational[
              1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
             Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
               5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
              Rational[-1, 2]}, {
             Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
               5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
              Rational[-1, 2]}, {
             Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
               5^Rational[1, 2]), 
              Rational[-1, 
                2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
               Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
             Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
               5^Rational[1, 2]), 
              Rational[
               1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
               Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
             Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
               5^Rational[1, 2]), 
              Rational[-1, 
                2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
               Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
             Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
               5^Rational[1, 2]), 
              Rational[
               1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
               Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
             0, 0, -0.9510565162951536}, {
             0, 0, 0.9510565162951536}, {-0.85065080835204, 
              0, -0.42532540417601994`}, {
             0.85065080835204, 0, 0.42532540417601994`}, {
             0.6881909602355868, -0.5, -0.42532540417601994`}, {
             0.6881909602355868, 
             0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
             0.42532540417601994`}, {-0.6881909602355868, 0.5, 
             0.42532540417601994`}, {-0.2628655560595668, \
-0.8090169943749475, -0.42532540417601994`}, {-0.2628655560595668, 
             0.8090169943749475, -0.42532540417601994`}, {
             0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
             0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
           Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4,
             12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {
            12, 10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11,
             9}, {6, 4, 5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 3}}]]],
         "\"icosahedron\""],
        Annotation[#, "icosahedron", "Tooltip"]& ],
       TraditionalForm], {975., -576.}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, 0, Root[5 - 20 #^2 + 16 #^4& , 1, 0]}, {
             0, 0, Root[5 - 20 #^2 + 16 #^4& , 4, 0]}, {
             Root[1 - 5 #^2 + 5 #^4& , 1, 0], 0, Root[
              1 - 20 #^2 + 80 #^4& , 1, 0]}, {
             Root[1 - 5 #^2 + 5 #^4& , 4, 0], 0, Root[
              1 - 20 #^2 + 80 #^4& , 4, 0]}, {
             Root[1 - 40 #^2 + 80 #^4& , 1, 0], Rational[-1, 2], Root[
              1 - 20 #^2 + 80 #^4& , 4, 0]}, {
             Root[1 - 40 #^2 + 80 #^4& , 1, 0], Rational[1, 2], Root[
              1 - 20 #^2 + 80 #^4& , 4, 0]}, {
             Root[1 - 40 #^2 + 80 #^4& , 4, 0], Rational[-1, 2], Root[
              1 - 20 #^2 + 80 #^4& , 1, 0]}, {
             Root[1 - 40 #^2 + 80 #^4& , 4, 0], Rational[1, 2], Root[
              1 - 20 #^2 + 80 #^4& , 1, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 1, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 1, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 4, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 4, 0]}, {
             Root[1 - 290 #^2 + 2555 #^4 - 5850 #^6 + 2025 #^8& , 1, 0], 0, 
              Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 
               0]}, {Root[
              1 - 290 #^2 + 2555 #^4 - 5850 #^6 + 2025 #^8& , 8, 0], 0, Root[
              1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
             Root[1 - 740 #^2 + 3230 #^4 - 4500 #^6 + 2025 #^8& , 1, 0], 0, 
              Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 
               0]}, {Root[
              1 - 740 #^2 + 3230 #^4 - 4500 #^6 + 2025 #^8& , 8, 0], 0, Root[
              1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
             Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0], 
              Root[1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
              1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
             Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0], 
              Root[1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
              1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
             Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0], 
              Root[1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
              1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
             Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0], 
              Root[1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
              1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
             Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 
               0], Root[1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
              1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
             Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 
               0], Root[1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
              1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
             Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 
               0], Root[1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
              1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
             Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 
               0], Root[1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
              1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
             Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 1, 0],
               Root[1 + 44 # - 100 #^2 - 48 #^3 + 144 #^4& , 3, 0], Root[
              1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
             Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 1, 0],
               Root[1 - 44 # - 100 #^2 + 48 #^3 + 144 #^4& , 2, 0], Root[
              1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
             Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 8, 0],
               Root[1 + 44 # - 100 #^2 - 48 #^3 + 144 #^4& , 3, 0], Root[
              1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
             Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 8, 0],
               Root[1 - 44 # - 100 #^2 + 48 #^3 + 144 #^4& , 2, 0], Root[
              1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
             Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 1, 0],
               Root[1 + 16 # - 40 #^2 - 192 #^3 + 144 #^4& , 4, 0], Root[
              1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
             Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 1, 0],
               Root[1 - 16 # - 40 #^2 + 192 #^3 + 144 #^4& , 1, 0], Root[
              1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
             Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 8, 0],
               Root[1 + 16 # - 40 #^2 - 192 #^3 + 144 #^4& , 4, 0], Root[
              1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
             Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 8, 0],
               Root[1 - 16 # - 40 #^2 + 192 #^3 + 144 #^4& , 1, 0], Root[
              1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 
               0]}}, {{0, 0, -0.9510565162951532}, {
             0, 0, 0.9510565162951536}, {-0.8506508083520394, 
              0, -0.4253254041760197}, {
             0.85065080835204, 0, 
              0.42532540417602}, {-0.6881909602355868, -0.5, 
             0.42532540417602}, {-0.6881909602355868, 0.5, 
             0.42532540417602}, {
             0.6881909602355868, -0.5, -0.4253254041760197}, {
             0.6881909602355868, 
             0.5, -0.4253254041760197}, {-0.2628655560595671, \
-0.8090169943749475, -0.4253254041760197}, {-0.2628655560595671, 
             0.8090169943749475, -0.4253254041760197}, {
             0.2628655560595668, -0.8090169943749475, 0.42532540417602}, {
             0.2628655560595668, 0.8090169943749475, 
             0.42532540417602}, {-1.5443455162844653`, 0, 
              0.29494374842358073`}, {
             1.5443455162844653`, 
              0, -0.29494374842358073`}, {-0.9544580194373125, 0, 
              1.2494017678608846`}, {
             0.954458019437308, 
              0, -1.2494017678608846`}, {-1.2494017678608846`, 
             0.9077435189160142, -0.29494374842358073`}, \
{-1.2494017678608846`, -0.9077435189160141, -0.29494374842358073`}, {
             1.2494017678608846`, 0.9077435189160142, 0.29494374842358073`}, {
             1.2494017678608846`, -0.9077435189160141, 
             0.29494374842358073`}, {-0.29494374842358073`, 
             0.9077435189160142, 
             1.2494017678608846`}, {-0.29494374842358073`, \
-0.9077435189160141, 1.2494017678608846`}, {0.29494374842358073`, 
             0.9077435189160142, -1.2494017678608846`}, {
             0.29494374842358073`, -0.9077435189160141, \
-1.2494017678608846`}, {-0.7721727581422326, 
             0.5610163477575297, -1.2494017678608846`}, {-0.7721727581422326, \
-0.5610163477575298, -1.2494017678608846`}, {0.7721727581422326, 
             0.5610163477575297, 1.2494017678608846`}, {
             0.7721727581422326, -0.5610163477575298, 
             1.2494017678608846`}, {-0.4772290097186562, 1.468759866673544, 
             0.29494374842358073`}, {-0.4772290097186562, -1.468759866673544, 
             0.29494374842358073`}, {0.477229009718654, 
             1.468759866673544, -0.29494374842358073`}, {
             0.477229009718654, -1.468759866673544, -0.29494374842358073`}}], 
           Polygon3DBox[{{21, 2, 12}, {21, 12, 6}, {21, 6, 2}, {15, 2, 6}, {
            15, 6, 5}, {15, 5, 2}, {22, 2, 5}, {22, 5, 11}, {22, 11, 2}, {28, 
            2, 11}, {28, 11, 4}, {28, 4, 2}, {27, 2, 4}, {27, 4, 12}, {27, 12,
             2}, {24, 7, 9}, {24, 9, 1}, {24, 1, 7}, {16, 8, 7}, {16, 7, 1}, {
            16, 1, 8}, {23, 10, 8}, {23, 8, 1}, {23, 1, 10}, {25, 3, 10}, {25,
             10, 1}, {25, 1, 3}, {26, 9, 3}, {26, 3, 1}, {26, 1, 9}, {29, 12, 
            10}, {29, 10, 6}, {29, 6, 12}, {13, 6, 3}, {13, 3, 5}, {13, 5, 
            6}, {30, 5, 9}, {30, 9, 11}, {30, 11, 5}, {20, 11, 7}, {20, 7, 
            4}, {20, 4, 11}, {19, 4, 8}, {19, 8, 12}, {19, 12, 4}, {32, 7, 
            11}, {32, 11, 9}, {32, 9, 7}, {14, 8, 4}, {14, 4, 7}, {14, 7, 
            8}, {31, 10, 12}, {31, 12, 8}, {31, 8, 10}, {17, 3, 6}, {17, 6, 
            10}, {17, 10, 3}, {18, 9, 5}, {18, 5, 3}, {18, 3, 9}}]]],
         "\"Mathematica polyhedron\""],
        Annotation[#, "Mathematica polyhedron", "Tooltip"]& ],
       TraditionalForm], {1365., -576.}, {Center, Center}, {360., 360.},
      ContentSelectable->True], 
     TagBox[InsetBox["", {1755., -576.}, {Center, Center}, {360., 360.}],
      "InsetString"]}}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 ImageSize->{364, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->Automatic},
 Graphics3DBoxOptions->{ImageSize->Automatic},
 CellLabel->"Out[2]=",
 CellID->1914596863]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1463794321],

Cell["Johnson solids:", "ExampleText",
 CellID->418493015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PolyhedronData", "[", "\"\<Johnson\>\"", "]"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", "5"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->603159180],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"AugmentedDodecahedron\"\>", 
    ",", "\<\"AugmentedHexagonalPrism\"\>", 
    ",", "\<\"AugmentedPentagonalPrism\"\>", 
    ",", "\<\"AugmentedSphenocorona\"\>", 
    ",", "\<\"AugmentedTriangularPrism\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "83", "\[RightSkeleton]"}], 
    ",", "\<\"TriaugmentedTruncatedDodecahedron\"\>", 
    ",", "\<\"TridiminishedIcosahedron\"\>", 
    ",", "\<\"TridiminishedRhombicosidodecahedron\"\>", 
    ",", "\<\"TrigyrateRhombicosidodecahedron\"\>"}], "}"}],
  Short[#, 5]& ]], "Output",
 ImageSize->{517, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->734509793]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Tooltip", "@@@", 
     RowBox[{"Rest", "/@", 
      RowBox[{"Sort", "[", 
       RowBox[{"PolyhedronData", "[", 
        RowBox[{"\"\<Johnson\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<FaceCount\>\"", ",", "\"\<Image\>\"", ",", "\"\<Name\>\""}], 
          "}"}]}], "]"}], "]"}]}]}], ",", "12", ",", "12", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->935112892],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, 0, Rational[3, 4] 2^Rational[-1, 2]}, {
             0, -2^Rational[-1, 2], Rational[-1, 4] 2^Rational[-1, 2]}, {
             0, 2^Rational[-1, 2], Rational[-1, 4] 
              2^Rational[-1, 2]}, {-2^Rational[-1, 2], 0, Rational[-1, 4] 
              2^Rational[-1, 2]}, {
             2^Rational[-1, 2], 0, Rational[-1, 4] 2^Rational[-1, 2]}}, {{
             0, 0, 0.5303300858899106}, {
             0, -0.7071067811865475, -0.17677669529663687`}, {
             0, 0.7071067811865475, -0.17677669529663687`}, \
{-0.7071067811865475, 0, -0.17677669529663687`}, {
             0.7071067811865475, 0, -0.17677669529663687`}}], 
           Polygon3DBox[{{3, 4, 1}, {4, 2, 1}, {2, 5, 1}, {5, 3, 1}, {5, 2, 4,
              3}}]]],
         "\"square pyramid\""],
        Annotation[#, "square pyramid", "Tooltip"]& ],
       TraditionalForm], {196.6153846153846, -196.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, 0, -Rational[2, 3]^Rational[1, 2]}, {
             0, 0, Rational[2, 3]^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 0}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 0}, {
             3^Rational[-1, 2], 0, 0}}, {{0, 0, -0.816496580927726}, {
             0, 0, 0.816496580927726}, {-0.2886751345948129, -0.5, 
              0}, {-0.2886751345948129, 0.5, 0}, {0.5773502691896258, 0, 0}}],
            Polygon3DBox[{{4, 3, 2}, {3, 5, 2}, {5, 4, 2}, {1, 3, 4}, {1, 5, 
            3}, {1, 4, 5}}]]],
         "\"triangular dipyramid\""],
        Annotation[#, "triangular dipyramid", "Tooltip"]& ],
       TraditionalForm], {589.8461538461538, -196.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, 0, Rational[3, 4] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {(Rational[1, 2] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[-1, 4] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-1, 4] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 4] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Rational[-1, 4] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[-1, 4] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}}, {{0, 0, 0.3942983340893502}, {
             0.8506508083520399, 0, -0.1314327780297834}, {
             0.2628655560595668, -0.8090169943749475, -0.1314327780297834}, {
             0.2628655560595668, 
             0.8090169943749475, -0.1314327780297834}, {-0.6881909602355868, \
-0.5, -0.1314327780297834}, {-0.6881909602355868, 0.5, -0.1314327780297834}}],
            Polygon3DBox[{{4, 6, 1}, {6, 5, 1}, {5, 3, 1}, {3, 2, 1}, {2, 4, 
             1}, {2, 3, 5, 6, 4}}]]],
         "\"pentagonal pyramid\""],
        Annotation[#, "pentagonal pyramid", "Tooltip"]& ],
       TraditionalForm], {983.0769230769231, -196.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, 0, Rational[1, 75] (-39 - 4 6^Rational[1, 2]) + 
              Rational[1, 3] (3 + 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[1, 75] (-39 - 4 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 1 + 
              Rational[1, 75] (-39 - 4 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[1, 75] (-39 - 4 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 1 + 
              Rational[1, 75] (-39 - 4 6^Rational[1, 2])}, {
             3^Rational[-1, 2], 0, 
              Rational[1, 75] (-39 - 4 6^Rational[1, 2])}, {
             3^Rational[-1, 2], 0, 1 + 
              Rational[1, 75] (-39 - 4 6^Rational[1, 2])}}, {{
             0, 0, 1.1658571279792895`}, {-0.2886751345948129, -0.5, \
-0.6506394529484363}, {-0.2886751345948129, -0.5, 
             0.3493605470515637}, {-0.2886751345948129, 
             0.5, -0.6506394529484363}, {-0.2886751345948129, 0.5, 
             0.3493605470515637}, {
             0.5773502691896258, 0, -0.6506394529484363}, {
             0.5773502691896258, 0, 0.3493605470515637}}], 
           Polygon3DBox[{{5, 3, 1}, {3, 7, 1}, {7, 5, 1}, {4, 2, 3, 5}, {2, 6,
              7, 3}, {6, 4, 5, 7}, {6, 2, 4}}]]],
         "\"elongated triangular pyramid\""],
        Annotation[#, "elongated triangular pyramid", "Tooltip"]& ],
       TraditionalForm], {1376.3076923076924`, -196.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2] 3^Rational[-1, 2] + 
              Rational[-1, 76] (Rational[1, 3] (97 + 8 6^Rational[1, 2]))^
                Rational[1, 2], Rational[-1, 2] + 
              Rational[1, 76] (-1 - 4 6^Rational[1, 2]), Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2] + 
              Rational[-1, 76] (Rational[1, 3] (97 + 8 6^Rational[1, 2]))^
                Rational[1, 2], Rational[-1, 2] + 
              Rational[1, 76] (-1 - 4 6^Rational[1, 2]), Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2] + 
              Rational[-1, 76] (Rational[1, 3] (97 + 8 6^Rational[1, 2]))^
                Rational[1, 2], Rational[1, 2] + 
              Rational[1, 76] (-1 - 4 6^Rational[1, 2]), Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2] + 
              Rational[-1, 76] (Rational[1, 3] (97 + 8 6^Rational[1, 2]))^
                Rational[1, 2], Rational[1, 2] + 
              Rational[1, 76] (-1 - 4 6^Rational[1, 2]), Rational[1, 2]}, {
             3^Rational[-1, 2] + 
              Rational[-1, 76] (Rational[1, 3] (97 + 8 6^Rational[1, 2]))^
                Rational[1, 2], Rational[1, 76] (-1 - 4 6^Rational[1, 2]), 
              Rational[-1, 2]}, {
             3^Rational[-1, 2] + 
              Rational[-1, 76] (Rational[1, 3] (97 + 8 6^Rational[1, 2]))^
                Rational[1, 2], Rational[1, 76] (-1 - 4 6^Rational[1, 2]), 
              Rational[1, 2]}, {
             Rational[-1, 76] (Rational[1, 3] (97 + 8 6^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 672 #^2 + 2304 #^4& , 4, 0], 
              Rational[1, 76] (-1 - 4 6^Rational[1, 2]) + 
              Rational[1, 4] (1 + 6^Rational[1, 2]), 
              0}}, {{-0.37070414141957614`, -0.6420784075149041, -0.5}, \
{-0.37070414141957614`, -0.6420784075149041, 0.5}, {-0.37070414141957614`, 
             0.3579215924850959, -0.5}, {-0.37070414141957614`, 
             0.3579215924850959, 0.5}, {
             0.4953212623648626, -0.14207840751490408`, -0.5}, {
             0.4953212623648626, -0.14207840751490408`, 0.5}, {
             0.41586195106591695`, 0.7202940281808904, 0}}], 
           Polygon3DBox[{{1, 3, 5}, {6, 4, 2}, {3, 1, 2, 4}, {1, 5, 6, 2}, {7,
              5, 3}, {7, 3, 4}, {7, 4, 6}, {7, 6, 5}}]]],
         "\"augmented triangular prism\""],
        Annotation[#, "augmented triangular prism", "Tooltip"]& ],
       TraditionalForm], {1769.5384615384614`, -196.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{Rational[-1, 2], Rational[-1, 2], 0}, {
             Rational[-1, 2], 0, Rational[1, 2] 3^Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2], 0}, {
             0, Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
             0, Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2], 0}, {
             Rational[1, 2], 0, Rational[1, 2] 3^Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2], 0}}, {{-0.5, -0.5, 0}, {-0.5, 0, 
              0.8660254037844386}, {-0.5, 0.5, 0}, {
             0, -0.5, -0.8660254037844386}, {0, 0.5, -0.8660254037844386}, {
             0.5, -0.5, 0}, {0.5, 0, 0.8660254037844386}, {0.5, 0.5, 0}}], 
           Polygon3DBox[{{6, 8, 7}, {2, 3, 1}, {7, 2, 1, 6}, {2, 7, 8, 3}, {4,
              6, 1}, {3, 8, 5}, {1, 3, 5, 4}, {8, 6, 4, 5}}]]],
         "\"gyrobifastigium\""],
        Annotation[#, "gyrobifastigium", "Tooltip"]& ],
       TraditionalForm], {2162.7692307692305`, -196.}, {Center, Center}, {359.9999999999998, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, -1, Rational[-1, 4] Rational[3, 2]^Rational[1, 2]}, {
             0, 1, Rational[-1, 4] Rational[3, 2]^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[2, 3]^Rational[1, 2] + 
              Rational[-1, 4] Rational[3, 2]^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[2, 3]^Rational[1, 2] + 
              Rational[-1, 4] Rational[3, 2]^Rational[1, 2]}, {
             3^Rational[-1, 2], 0, Rational[2, 3]^Rational[1, 2] + 
              Rational[-1, 4] Rational[3, 2]^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 4] Rational[3, 2]^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[-1, 4] Rational[3, 2]^Rational[1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 4] Rational[3, 2]^Rational[1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[1, 2], Rational[-1, 4] 
              Rational[3, 2]^Rational[1, 2]}}, {{
             0, -1, -0.30618621784789724`}, {
             0, 1, -0.30618621784789724`}, {-0.2886751345948129, -0.5, 
             0.5103103630798288}, {-0.2886751345948129, 0.5, 
             0.5103103630798288}, {
             0.5773502691896258, 0, 
              0.5103103630798288}, {-0.8660254037844386, -0.5, \
-0.30618621784789724`}, {-0.8660254037844386, 0.5, -0.30618621784789724`}, {
             0.8660254037844386, -0.5, -0.30618621784789724`}, {
             0.8660254037844386, 0.5, -0.30618621784789724`}}], 
           Polygon3DBox[{{4, 3, 5}, {9, 8, 1, 6, 7, 2}, {3, 4, 7, 6}, {5, 3, 
             1, 8}, {4, 5, 9, 2}, {2, 7, 4}, {6, 1, 3}, {8, 9, 5}}]]],
         "\"triangular cupola\""],
        Annotation[#, "triangular cupola", "Tooltip"]& ],
       TraditionalForm], {2556., -196.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{-3^Rational[-1, 2], 0, 
              Rational[-1, 4] (Rational[3, 10] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 84 #^2 + 144 #^4& , 1, 0]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 4] (Rational[3, 10] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 84 #^2 + 144 #^4& , 4, 0]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 4] (Rational[3, 10] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 84 #^2 + 144 #^4& , 4, 0]}, {
             Rational[1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 4] (Rational[3, 10] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 84 #^2 + 144 #^4& , 1, 0]}, {
             Rational[1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 4] (Rational[3, 10] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 84 #^2 + 144 #^4& , 1, 0]}, {
             3^Rational[-1, 2], 0, 
              Rational[-1, 4] (Rational[3, 10] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 84 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-1, 4] (Rational[3, 10] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 3, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 4] (Rational[3, 10] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 3, 0]}, {
             Root[1 - 9 #^2 + 9 #^4& , 1, 0], 0, 
              Rational[-1, 4] (Rational[3, 10] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + 
              Root[1 - 36 #^2 + 144 #^4& , 3, 0]}}, {{-0.5773502691896258, 
              0, -0.8297287140956173}, {-0.2886751345948129, -0.5, 
             0.6817939140567242}, {-0.2886751345948129, 0.5, 
             0.6817939140567242}, {
             0.2886751345948129, -0.5, -0.8297287140956173}, {
             0.2886751345948129, 0.5, -0.8297287140956173}, {
             0.5773502691896258, 0, 0.6817939140567242}, {
             0.46708617948135783`, -0.8090169943749475, 
             0.10444364486709838`}, {0.46708617948135783`, 0.8090169943749475,
              0.10444364486709838`}, {-0.9341723589627158, 0, 
              0.10444364486709838`}}], 
           Polygon3DBox[{{9, 2, 3}, {1, 5, 4}, {3, 2, 6}, {3, 6, 8}, {2, 7, 
             6}, {2, 9, 1, 4, 7}, {5, 1, 9, 3, 8}, {8, 6, 7, 4, 5}}]]],
         "\"tridiminished icosahedron\""],
        Annotation[#, "tridiminished icosahedron", "Tooltip"]& ],
       TraditionalForm], {2949.2307692307686`, -196.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, 0, Rational[1, 6] (-3 - 2 6^Rational[1, 2])}, {
             0, 0, Rational[1, 6] (3 + 2 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], Rational[
              1, 2]}, {3^Rational[-1, 2], 0, Rational[-1, 2]}, {
             3^Rational[-1, 2], 0, Rational[1, 2]}}, {{
             0, 0, -1.3164965809277258`}, {
             0, 0, 1.3164965809277258`}, {-0.2886751345948129, -0.5, -0.5}, \
{-0.2886751345948129, -0.5, 0.5}, {-0.2886751345948129, 
             0.5, -0.5}, {-0.2886751345948129, 0.5, 0.5}, {
             0.5773502691896258, 0, -0.5}, {0.5773502691896258, 0, 0.5}}], 
           Polygon3DBox[{{6, 4, 2}, {4, 8, 2}, {8, 6, 2}, {1, 3, 5}, {1, 7, 
             3}, {1, 5, 7}, {5, 3, 4, 6}, {3, 7, 8, 4}, {7, 5, 6, 8}}]]],
         "\"elongated triangular dipyramid\""],
        Annotation[#, "elongated triangular dipyramid", "Tooltip"]& ],
       TraditionalForm], {3342.461538461538, -196.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, 0, Rational[1, 136] (-70 - 11 2^Rational[1, 2]) + 
              Rational[1, 2] (2 + 2^Rational[1, 2])}, {
             0, -2^Rational[-1, 2], 
              Rational[1, 136] (-70 - 11 2^Rational[1, 2])}, {
             0, -2^Rational[-1, 2], 1 + 
              Rational[1, 136] (-70 - 11 2^Rational[1, 2])}, {
             0, 2^Rational[-1, 2], 
              Rational[1, 136] (-70 - 11 2^Rational[1, 2])}, {
             0, 2^Rational[-1, 2], 1 + 
              Rational[1, 136] (-70 - 11 2^Rational[1, 2])}, {-2^
               Rational[-1, 2], 0, 
              Rational[1, 136] (-70 - 11 2^Rational[1, 2])}, {-2^
               Rational[-1, 2], 0, 1 + 
              Rational[1, 136] (-70 - 11 2^Rational[1, 2])}, {
             2^Rational[-1, 2], 0, 
              Rational[1, 136] (-70 - 11 2^Rational[1, 2])}, {
             2^Rational[-1, 2], 0, 1 + 
              Rational[1, 136] (-70 - 11 2^Rational[1, 2])}}, {{
             0, 0, 1.0780159783475471`}, {
             0, -0.7071067811865475, -0.6290908028390003}, {
             0, -0.7071067811865475, 0.3709091971609997}, {
             0, 0.7071067811865475, -0.6290908028390003}, {
             0, 0.7071067811865475, 0.3709091971609997}, {-0.7071067811865475,
               0, -0.6290908028390003}, {-0.7071067811865475, 0, 
              0.3709091971609997}, {
             0.7071067811865475, 0, -0.6290908028390003}, {
             0.7071067811865475, 0, 0.3709091971609997}}], 
           Polygon3DBox[{{5, 7, 1}, {7, 3, 1}, {3, 9, 1}, {9, 5, 1}, {4, 6, 7,
              5}, {6, 2, 3, 7}, {2, 8, 9, 3}, {8, 4, 5, 9}, {8, 2, 6, 4}}]]],
         "\"elongated square pyramid\""],
        Annotation[#, "elongated square pyramid", "Tooltip"]& ],
       TraditionalForm], {3735.6923076923067`, -196.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, 0, -(Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             0, 0, (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[1, 2] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 0, 0}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              0}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              0}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 2], 0}}, {{
             0, 0, -0.5257311121191336}, {0, 0, 0.5257311121191336}, {
             0.8506508083520399, 0, 0}, {
             0.2628655560595668, -0.8090169943749475, 0}, {
             0.2628655560595668, 0.8090169943749475, 
              0}, {-0.6881909602355868, -0.5, 0}, {-0.6881909602355868, 0.5, 
              0}}], Polygon3DBox[{{5, 7, 2}, {7, 6, 2}, {6, 4, 2}, {4, 3, 
            2}, {3, 5, 2}, {1, 7, 5}, {1, 6, 7}, {1, 4, 6}, {1, 3, 4}, {1, 5, 
            3}}]]],
         "\"pentagonal dipyramid\""],
        Annotation[#, "pentagonal dipyramid", "Tooltip"]& ],
       TraditionalForm], {4128.923076923076, -196.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, 0, Rational[
                1, 84] (
                 Rational[1, 6] (903 + 350 2^Rational[1, 2] - 223 
                  5^Rational[1, 2] - 282 10^Rational[1, 2]))^Rational[1, 2] + 
              Root[9 - 2472 #^2 + 8752 #^4 - 8832 #^6 + 2304 #^8& , 1, 
                0]}, {-3^Rational[-1, 2], 0, 
              Rational[
                1, 84] (
                 Rational[1, 6] (903 + 350 2^Rational[1, 2] - 223 
                  5^Rational[1, 2] - 282 10^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 84 #^2 + 144 #^4& , 1, 0]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[
                1, 84] (
                 Rational[1, 6] (903 + 350 2^Rational[1, 2] - 223 
                  5^Rational[1, 2] - 282 10^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 84 #^2 + 144 #^4& , 4, 0]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[
                1, 84] (
                 Rational[1, 6] (903 + 350 2^Rational[1, 2] - 223 
                  5^Rational[1, 2] - 282 10^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 84 #^2 + 144 #^4& , 4, 0]}, {
             Rational[1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[
                1, 84] (
                 Rational[1, 6] (903 + 350 2^Rational[1, 2] - 223 
                  5^Rational[1, 2] - 282 10^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 84 #^2 + 144 #^4& , 1, 0]}, {
             Rational[1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[
                1, 84] (
                 Rational[1, 6] (903 + 350 2^Rational[1, 2] - 223 
                  5^Rational[1, 2] - 282 10^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 84 #^2 + 144 #^4& , 1, 0]}, {
             3^Rational[-1, 2], 0, 
              Rational[
                1, 84] (
                 Rational[1, 6] (903 + 350 2^Rational[1, 2] - 223 
                  5^Rational[1, 2] - 282 10^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 84 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 9 #^2 + 9 #^4& , 1, 0], 0, 
              Rational[
                1, 84] (
                 Rational[1, 6] (903 + 350 2^Rational[1, 2] - 223 
                  5^Rational[1, 2] - 282 10^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 36 #^2 + 144 #^4& , 3, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[
                1, 84] (
                 Rational[1, 6] (903 + 350 2^Rational[1, 2] - 223 
                  5^Rational[1, 2] - 282 10^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 36 #^2 + 144 #^4& , 3, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[
                1, 84] (
                 Rational[1, 6] (903 + 350 2^Rational[1, 2] - 223 
                  5^Rational[1, 2] - 282 10^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 36 #^2 + 144 #^4& , 3, 0]}}, {{
             0, 0, -1.55888662697191}, {-0.5773502691896258, 
              0, -0.7423900460441839}, {-0.2886751345948129, -0.5, 
             0.7691325821081576}, {-0.2886751345948129, 0.5, 
             0.7691325821081576}, {
             0.2886751345948129, -0.5, -0.7423900460441839}, {
             0.2886751345948129, 0.5, -0.7423900460441839}, {
             0.5773502691896258, 0, 0.7691325821081576}, {-0.9341723589627158,
               0, 0.19178231291853182`}, {
             0.46708617948135783`, -0.8090169943749475, 
             0.19178231291853182`}, {0.46708617948135783`, 0.8090169943749475,
              0.19178231291853182`}}], 
           Polygon3DBox[{{8, 3, 4}, {4, 3, 7}, {4, 7, 10}, {3, 9, 7}, {3, 8, 
             2, 5, 9}, {6, 2, 8, 4, 10}, {10, 7, 9, 5, 6}, {1, 2, 6}, {1, 6, 
             5}, {1, 5, 2}}]]],
         "\"augmented tridiminished icosahedron\""],
        Annotation[#, "augmented tridiminished icosahedron", "Tooltip"]& ],
       TraditionalForm], {4522.153846153846, -196.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-11, 2] (209970 - 91382 5^Rational[1, 2] - 
                 448 (386525 - 172855 5^Rational[1, 2])^Rational[1, 2])^
                Rational[-1, 2] + Root[1 - 5 #^2 + 5 #^4& , 4, 0], 
              Rational[1, 52712] (1631 - 889 5^Rational[1, 2] - 
               16 (29585 + 1181 5^Rational[1, 2])^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[-11, 2] (209970 - 91382 5^Rational[1, 2] - 
                 448 (386525 - 172855 5^Rational[1, 2])^Rational[1, 2])^
                Rational[-1, 2] + Root[1 - 5 #^2 + 5 #^4& , 4, 0], 
              Rational[1, 52712] (1631 - 889 5^Rational[1, 2] - 
               16 (29585 + 1181 5^Rational[1, 2])^Rational[1, 2]), Rational[
              1, 2]}, {
             Rational[-11, 2] (209970 - 91382 5^Rational[1, 2] - 
                 448 (386525 - 172855 5^Rational[1, 2])^Rational[1, 2])^
                Rational[-1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 52712] (1631 - 889 5^Rational[1, 2] - 
                16 (29585 + 1181 5^Rational[1, 2])^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[-11, 2] (209970 - 91382 5^Rational[1, 2] - 
                 448 (386525 - 172855 5^Rational[1, 2])^Rational[1, 2])^
                Rational[-1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 52712] (1631 - 889 5^Rational[1, 2] - 
                16 (29585 + 1181 5^Rational[1, 2])^Rational[1, 2]), Rational[
              1, 2]}, {
             Rational[-11, 2] (209970 - 91382 5^Rational[1, 2] - 
                 448 (386525 - 172855 5^Rational[1, 2])^Rational[1, 2])^
                Rational[-1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Rational[1, 52712] (1631 - 889 5^Rational[1, 2] - 
                16 (29585 + 1181 5^Rational[1, 2])^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[-11, 2] (209970 - 91382 5^Rational[1, 2] - 
                 448 (386525 - 172855 5^Rational[1, 2])^Rational[1, 2])^
                Rational[-1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Rational[1, 52712] (1631 - 889 5^Rational[1, 2] - 
                16 (29585 + 1181 5^Rational[1, 2])^Rational[1, 2]), Rational[
              1, 2]}, {
             Rational[-11, 2] (209970 - 91382 5^Rational[1, 2] - 
                 448 (386525 - 172855 5^Rational[1, 2])^Rational[1, 2])^
                Rational[-1, 2] + Root[1 - 40 #^2 + 80 #^4& , 1, 0], 
              Rational[-1, 2] + 
              Rational[1, 52712] (1631 - 889 5^Rational[1, 2] - 
                16 (29585 + 1181 5^Rational[1, 2])^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[-11, 2] (209970 - 91382 5^Rational[1, 2] - 
                 448 (386525 - 172855 5^Rational[1, 2])^Rational[1, 2])^
                Rational[-1, 2] + Root[1 - 40 #^2 + 80 #^4& , 1, 0], 
              Rational[-1, 2] + 
              Rational[1, 52712] (1631 - 889 5^Rational[1, 2] - 
                16 (29585 + 1181 5^Rational[1, 2])^Rational[1, 2]), Rational[
              1, 2]}, {
             Rational[-11, 2] (209970 - 91382 5^Rational[1, 2] - 
                 448 (386525 - 172855 5^Rational[1, 2])^Rational[1, 2])^
                Rational[-1, 2] + Root[1 - 40 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 2] + 
              Rational[1, 52712] (1631 - 889 5^Rational[1, 2] - 
                16 (29585 + 1181 5^Rational[1, 2])^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[-11, 2] (209970 - 91382 5^Rational[1, 2] - 
                 448 (386525 - 172855 5^Rational[1, 2])^Rational[1, 2])^
                Rational[-1, 2] + Root[1 - 40 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 2] + 
              Rational[1, 52712] (1631 - 889 5^Rational[1, 2] - 
                16 (29585 + 1181 5^Rational[1, 2])^Rational[1, 2]), Rational[
              1, 2]}, {
             Rational[-11, 2] (209970 - 91382 5^Rational[1, 2] - 
                 448 (386525 - 172855 5^Rational[1, 2])^Rational[1, 2])^
                Rational[-1, 2] + 
              Root[1 - 4320 #^2 + 213760 #^4 - 2252800 #^6 + 1638400 #^8& , 8,
                 0], Rational[1, 52712] (1631 - 889 5^Rational[1, 2] - 
                16 (29585 + 1181 5^Rational[1, 2])^Rational[1, 2]) + 
              Root[1 + 88 # - 176 #^2 - 128 #^3 + 256 #^4& , 4, 0], 0}}, {{
             0.7663343180206339, -0.06125951603792099, -0.5}, {
             0.7663343180206339, -0.06125951603792099, 0.5}, {
             0.17854906572816065`, -0.8702765104128685, -0.5}, {
             0.17854906572816065`, -0.8702765104128685, 0.5}, {
             0.17854906572816065`, 0.7477574783370264, -0.5}, {
             0.17854906572816065`, 0.7477574783370264, 
             0.5}, {-0.7725074505669929, -0.561259516037921, -0.5}, \
{-0.7725074505669929, -0.561259516037921, 0.5}, {-0.7725074505669929, 
             0.438740483962079, -0.5}, {-0.7725074505669929, 
             0.438740483962079, 0.5}, {
             1.0445030946920815`, 0.7588759189270062, 0}}], 
           Polygon3DBox[{{3, 7, 9, 5, 1}, {2, 6, 10, 8, 4}, {5, 9, 10, 6}, {9,
              7, 8, 10}, {7, 3, 4, 8}, {3, 1, 2, 4}, {11, 1, 5}, {11, 5, 6}, {
             11, 6, 2}, {11, 2, 1}}]]],
         "\"augmented pentagonal prism\""],
        Annotation[#, "augmented pentagonal prism", "Tooltip"]& ],
       TraditionalForm], {196.6153846153846, -588.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, -2^Rational[-1, 2], 2^Rational[-1, 2] + 
              Rational[1, 8] (-5 + 2 2^Rational[1, 2])}, {
             0, 2^Rational[-1, 2], 2^Rational[-1, 2] + 
              Rational[1, 8] (-5 + 2 2^Rational[1, 2])}, {-2^Rational[-1, 2], 
              0, 2^Rational[-1, 2] + 
              Rational[1, 8] (-5 + 2 2^Rational[1, 2])}, {
             2^Rational[-1, 2], 0, 2^Rational[-1, 2] + 
              Rational[1, 8] (-5 + 2 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 8] (-5 + 2 2^Rational[1, 2])}, {
             Rational[-1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 8] (-5 + 2 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 8] (-5 + 2 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 8] (-5 + 2 2^Rational[1, 2])}, {
             Rational[-1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 8] (-5 + 2 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 8] (-5 + 2 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 8] (-5 + 2 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 8] (-5 + 2 2^Rational[1, 2])}}, {{
             0, -0.7071067811865475, 0.43566017177982125`}, {
             0, 0.7071067811865475, 
              0.43566017177982125`}, {-0.7071067811865475, 0, 
              0.43566017177982125`}, {
             0.7071067811865475, 0, 0.43566017177982125`}, {0.5, 
             1.2071067811865475`, -0.2714466094067262}, {-0.5, 
             1.2071067811865475`, -0.2714466094067262}, {-1.2071067811865475`,
              0.5, -0.2714466094067262}, {-1.2071067811865475`, -0.5, \
-0.2714466094067262}, {-0.5, -1.2071067811865475`, -0.2714466094067262}, {
             0.5, -1.2071067811865475`, -0.2714466094067262}, {
             1.2071067811865475`, -0.5, -0.2714466094067262}, {
             1.2071067811865475`, 0.5, -0.2714466094067262}}], 
           Polygon3DBox[{{2, 3, 1, 4}, {12, 11, 10, 9, 8, 7, 6, 5}, {3, 2, 6, 
             7}, {1, 3, 8, 9}, {4, 1, 10, 11}, {2, 4, 12, 5}, {5, 6, 2}, {7, 
             8, 3}, {9, 10, 1}, {11, 12, 4}}]]],
         "\"square cupola\""],
        Annotation[#, "square cupola", "Tooltip"]& ],
       TraditionalForm], {589.8461538461538, -588.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2] 3^Rational[-1, 2] + 
              Rational[1, 20] (Rational[1, 3] (73 - 28 6^Rational[1, 2]))^
                Rational[1, 2], Rational[-1, 2] + 
              Rational[1, 20] (-7 + 2 6^Rational[1, 2]), Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2] + 
              Rational[1, 20] (Rational[1, 3] (73 - 28 6^Rational[1, 2]))^
                Rational[1, 2], Rational[-1, 2] + 
              Rational[1, 20] (-7 + 2 6^Rational[1, 2]), Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2] + 
              Rational[1, 20] (Rational[1, 3] (73 - 28 6^Rational[1, 2]))^
                Rational[1, 2], Rational[1, 2] + 
              Rational[1, 20] (-7 + 2 6^Rational[1, 2]), Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2] + 
              Rational[1, 20] (Rational[1, 3] (73 - 28 6^Rational[1, 2]))^
                Rational[1, 2], Rational[1, 2] + 
              Rational[1, 20] (-7 + 2 6^Rational[1, 2]), Rational[1, 2]}, {
             3^Rational[-1, 2] + 
              Rational[1, 20] (Rational[1, 3] (73 - 28 6^Rational[1, 2]))^
                Rational[1, 2], Rational[1, 20] (-7 + 2 6^Rational[1, 2]), 
              Rational[-1, 2]}, {
             3^Rational[-1, 2] + 
              Rational[1, 20] (Rational[1, 3] (73 - 28 6^Rational[1, 2]))^
                Rational[1, 2], Rational[1, 20] (-7 + 2 6^Rational[1, 2]), 
              Rational[1, 2]}, {
             Rational[1, 20] (Rational[1, 3] (73 - 28 6^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 168 #^2 + 144 #^4& , 1, 0], 
              Rational[1, 20] (-7 + 2 6^Rational[1, 2]), 0}, {
             Rational[1, 20] (Rational[1, 3] (73 - 28 6^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 672 #^2 + 2304 #^4& , 4, 0], 
              Rational[1, 4] (1 + 6^Rational[1, 2]) + 
              Rational[1, 20] (-7 + 2 6^Rational[1, 2]), 
              0}}, {{-0.22802389661575334`, -0.6050510257216822, -0.5}, \
{-0.22802389661575334`, -0.6050510257216822, 0.5}, {-0.22802389661575334`, 
             0.39494897427831777`, -0.5}, {-0.22802389661575334`, 
             0.39494897427831777`, 0.5}, {
             0.6380015071686854, -0.10505102572168222`, -0.5}, {
             0.6380015071686854, -0.10505102572168222`, 
             0.5}, {-0.9351306778023007, -0.10505102572168222`, 0}, {
             0.5585421958697397, 0.7573214099741122, 0}}], 
           Polygon3DBox[{{1, 3, 5}, {6, 4, 2}, {1, 5, 6, 2}, {8, 5, 3}, {8, 3,
              4}, {8, 4, 6}, {8, 6, 5}, {7, 3, 1}, {7, 1, 2}, {7, 2, 4}, {7, 
             4, 3}}]]],
         "\"biaugmented triangular prism\""],
        Annotation[#, "biaugmented triangular prism", "Tooltip"]& ],
       TraditionalForm], {983.0769230769231, -588.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, 0, Rational[1, 2888] (-1487 + 
                9 5^Rational[1, 2] - (107666 - 102062 5^Rational[-1, 2])^
                Rational[1, 2]) + 
              Rational[1, 10] (
                10 + (10 (5 - 5^Rational[1, 2]))^Rational[1, 2])}, {(
               Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], 0, 
              Rational[1, 2888] (-1487 + 
               9 5^Rational[1, 2] - (107666 - 102062 5^Rational[-1, 2])^
               Rational[1, 2])}, {(Rational[1, 2] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 0, 1 + 
              Rational[1, 2888] (-1487 + 
                9 5^Rational[1, 2] - (107666 - 102062 5^Rational[-1, 2])^
                Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 2888] (-1487 + 
               9 5^Rational[1, 2] - (107666 - 102062 5^Rational[-1, 2])^
               Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 1 + 
              Rational[1, 2888] (-1487 + 
                9 5^Rational[1, 2] - (107666 - 102062 5^Rational[-1, 2])^
                Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 2888] (-1487 + 
               9 5^Rational[1, 2] - (107666 - 102062 5^Rational[-1, 2])^
               Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 1 + 
              Rational[1, 2888] (-1487 + 
                9 5^Rational[1, 2] - (107666 - 102062 5^Rational[-1, 2])^
                Rational[1, 2])}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Rational[1, 2888] (-1487 + 
               9 5^Rational[1, 2] - (107666 - 102062 5^Rational[-1, 2])^
               Rational[1, 2])}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], 1 + 
              Rational[1, 2888] (-1487 + 
                9 5^Rational[1, 2] - (107666 - 102062 5^Rational[-1, 2])^
                Rational[1, 2])}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[1, 2888] (-1487 + 
               9 5^Rational[1, 2] - (107666 - 102062 5^Rational[-1, 2])^
               Rational[1, 2])}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], 1 + 
              Rational[1, 2888] (-1487 + 
                9 5^Rational[1, 2] - (107666 - 102062 5^Rational[-1, 2])^
                Rational[1, 2])}}, {{0, 0, 0.9315764967881461}, {
             0.8506508083520399, 0, -0.5941546153309876}, {
             0.8506508083520399, 0, 0.40584538466901243`}, {
             0.2628655560595668, -0.8090169943749475, -0.5941546153309876}, {
             0.2628655560595668, -0.8090169943749475, 0.40584538466901243`}, {
             0.2628655560595668, 0.8090169943749475, -0.5941546153309876}, {
             0.2628655560595668, 0.8090169943749475, 
             0.40584538466901243`}, {-0.6881909602355868, -0.5, \
-0.5941546153309876}, {-0.6881909602355868, -0.5, 
             0.40584538466901243`}, {-0.6881909602355868, 
             0.5, -0.5941546153309876}, {-0.6881909602355868, 0.5, 
             0.40584538466901243`}}], 
           Polygon3DBox[{{7, 11, 1}, {11, 9, 1}, {9, 5, 1}, {5, 3, 1}, {3, 7, 
             1}, {6, 10, 11, 7}, {10, 8, 9, 11}, {8, 4, 5, 9}, {4, 2, 3, 5}, {
             2, 6, 7, 3}, {2, 4, 8, 10, 6}}]]],
         "\"elongated pentagonal pyramid\""],
        Annotation[#, "elongated pentagonal pyramid", "Tooltip"]& ],
       TraditionalForm], {1376.3076923076924`, -588.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{-1 + Rational[1, 1928] (-15 - 53 6^Rational[1, 2]), 
              Rational[1, 1928] ((-53) 2^Rational[1, 2] - 5 3^Rational[1, 2]),
               Rational[-1, 2]}, {-1 + 
              Rational[1, 1928] (-15 - 53 6^Rational[1, 2]), 
              Rational[1, 1928] ((-53) 2^Rational[1, 2] - 5 3^Rational[1, 2]),
               Rational[1, 2]}, {
             Rational[-1, 2] + Rational[1, 1928] (-15 - 53 6^Rational[1, 2]), 
              Rational[-1, 2] 3^Rational[1, 2] + 
              Rational[1, 1928] ((-53) 2^Rational[1, 2] - 5 3^Rational[1, 2]),
               Rational[-1, 2]}, {
             Rational[-1, 2] + Rational[1, 1928] (-15 - 53 6^Rational[1, 2]), 
              Rational[-1, 2] 3^Rational[1, 2] + 
              Rational[1, 1928] ((-53) 2^Rational[1, 2] - 5 3^Rational[1, 2]),
               Rational[1, 2]}, {
             Rational[-1, 2] + Rational[1, 1928] (-15 - 53 6^Rational[1, 2]), 
              Rational[1, 2] 3^Rational[1, 2] + 
              Rational[1, 1928] ((-53) 2^Rational[1, 2] - 5 3^Rational[1, 2]),
               Rational[-1, 2]}, {
             Rational[-1, 2] + Rational[1, 1928] (-15 - 53 6^Rational[1, 2]), 
              Rational[1, 2] 3^Rational[1, 2] + 
              Rational[1, 1928] ((-53) 2^Rational[1, 2] - 5 3^Rational[1, 2]),
               Rational[1, 2]}, {
             Rational[1, 2] + Rational[1, 1928] (-15 - 53 6^Rational[1, 2]), 
              Rational[-1, 2] 3^Rational[1, 2] + 
              Rational[1, 1928] ((-53) 2^Rational[1, 2] - 5 3^Rational[1, 2]),
               Rational[-1, 2]}, {
             Rational[1, 2] + Rational[1, 1928] (-15 - 53 6^Rational[1, 2]), 
              Rational[-1, 2] 3^Rational[1, 2] + 
              Rational[1, 1928] ((-53) 2^Rational[1, 2] - 5 3^Rational[1, 2]),
               Rational[1, 2]}, {
             Rational[1, 2] + Rational[1, 1928] (-15 - 53 6^Rational[1, 2]), 
              Rational[1, 2] 3^Rational[1, 2] + 
              Rational[1, 1928] ((-53) 2^Rational[1, 2] - 5 3^Rational[1, 2]),
               Rational[-1, 2]}, {
             Rational[1, 2] + Rational[1, 1928] (-15 - 53 6^Rational[1, 2]), 
              Rational[1, 2] 3^Rational[1, 2] + 
              Rational[1, 1928] ((-53) 2^Rational[1, 2] - 5 3^Rational[1, 2]),
               Rational[1, 2]}, {
             1 + Rational[1, 1928] (-15 - 53 6^Rational[1, 2]), 
              Rational[1, 1928] ((-53) 2^Rational[1, 2] - 5 3^Rational[1, 2]),
               Rational[-1, 2]}, {
             1 + Rational[1, 1928] (-15 - 53 6^Rational[1, 2]), 
              Rational[1, 1928] ((-53) 2^Rational[1, 2] - 5 3^Rational[1, 2]),
               Rational[1, 2]}, {
             Rational[1, 1928] (-15 - 53 6^Rational[1, 2]) + 
              Rational[1, 4] (3 + 6^Rational[1, 2]), 
              Rational[1, 1928] ((-53) 2^Rational[1, 2] - 5 3^Rational[1, 2]) + 
              Root[1 - 160 #^2 + 256 #^4& , 4, 0], 
              0}}, {{-1.0751156412694547`, -0.04336803570727097, -0.5}, \
{-1.0751156412694547`, -0.04336803570727097, 
             0.5}, {-0.5751156412694546, -0.9093934394917096, -0.5}, \
{-0.5751156412694546, -0.9093934394917096, 0.5}, {-0.5751156412694546, 
             0.8226573680771676, -0.5}, {-0.5751156412694546, 
             0.8226573680771676, 0.5}, {
             0.4248843587305454, -0.9093934394917096, -0.5}, {
             0.4248843587305454, -0.9093934394917096, 0.5}, {
             0.4248843587305454, 0.8226573680771676, -0.5}, {
             0.4248843587305454, 0.8226573680771676, 0.5}, {
             0.9248843587305454, -0.04336803570727097, -0.5}, {
             0.9248843587305454, -0.04336803570727097, 0.5}, {
             1.28725679442634, 0.743198056778222, 0}}], 
           Polygon3DBox[{{7, 3, 1, 5, 9, 11}, {12, 10, 6, 2, 4, 8}, {9, 5, 6, 
             10}, {5, 1, 2, 6}, {1, 3, 4, 2}, {3, 7, 8, 4}, {7, 11, 12, 8}, {
             13, 11, 9}, {13, 9, 10}, {13, 10, 12}, {13, 12, 11}}]]],
         "\"augmented hexagonal prism\""],
        Annotation[#, "augmented hexagonal prism", "Tooltip"]& ],
       TraditionalForm], {1769.5384615384614`, -588.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2], 0, -
              Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0]}, {
             0, Rational[-1, 2], Root[-4 - 8 #^2 - #^4 + 2 #^6& , 2, 0] - 
              Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0]}, {
             0, Rational[1, 2], Root[-4 - 8 #^2 - #^4 + 2 #^6& , 2, 0] - 
              Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0]}, {
             0, Root[-2 - 2 # + 3 #^2 + 2 #^3& , 2, 0], -
               Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0] + 
              Root[-1 - 22 #^2 + 64 #^4 + 32 #^6& , 2, 0]}, {
             0, Root[
              2 - 2 # - 3 #^2 + 2 #^3& , 2, 0], -
               Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0] + 
              Root[-1 - 22 #^2 + 64 #^4 + 32 #^6& , 2, 0]}, {
             Rational[1, 2], 0, -Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0]}, {
             Root[-2 - 2 # + 3 #^2 + 2 #^3& , 2, 0], 0, 
              Root[-8 - 15 #^2 + 8 #^4 + 16 #^6& , 2, 0] - 
              Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0]}, {
             Root[2 - 2 # - 3 #^2 + 2 #^3& , 2, 0], 0, 
              Root[-8 - 15 #^2 + 8 #^4 + 16 #^6& , 2, 0] - 
              Root[-1 - 8 #^2 - 4 #^4 + 32 #^6& , 2, 0]}}, {{-0.5, 
              0, -0.7839309242325636}, {0, -0.5, 0.7839309242325636}, {
             0, 0.5, 0.7839309242325636}, {
             0, -0.6445842732241552, -0.20556156585325946`}, {
             0, 0.644584273224155, -0.20556156585325946`}, {
             0.5, 0, -0.7839309242325636}, {-0.6445842732241552, 0, 
              0.20556156585325958`}, {
             0.644584273224155, 0, 0.20556156585325958`}}], 
           Polygon3DBox[{{2, 3, 7}, {3, 2, 8}, {4, 2, 7}, {2, 4, 8}, {6, 8, 
            4}, {4, 1, 6}, {7, 1, 4}, {3, 5, 7}, {8, 5, 3}, {5, 8, 6}, {5, 6, 
            1}, {5, 1, 7}}]]],
         "\"snub disphenoid\""],
        Annotation[#, "snub disphenoid", "Tooltip"]& ],
       TraditionalForm], {2162.7692307692305`, -588.}, {Center, Center}, {359.9999999999998, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2], 0, Rational[1, 4] 5^Rational[-1, 2] + 
              Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
             Rational[-1, 2], 0, Rational[1, 4] 5^Rational[-1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2])}, {
             0, Rational[1, 4] (-1 - 5^Rational[1, 2]), Rational[-1, 2] + 
              Rational[1, 4] 5^Rational[-1, 2]}, {
             0, Rational[1, 4] (1 + 5^Rational[1, 2]), Rational[-1, 2] + 
              Rational[1, 4] 5^Rational[-1, 2]}, {
             Rational[1, 2], 0, Rational[1, 4] 5^Rational[-1, 2] + 
              Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
             Rational[1, 2], 0, Rational[1, 4] 5^Rational[-1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2])}, {
             Rational[1, 4] (-1 - 5^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 4] 5^Rational[-1, 2]}, {
             Rational[1, 4] (-1 - 5^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 4] 5^Rational[-1, 2]}, {
             Rational[1, 4] (1 + 5^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 4] 5^Rational[-1, 2]}, {
             Rational[1, 4] (1 + 5^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 4] 5^Rational[-1, 2]}}, {{-0.5, 
              0, -0.697213595499958}, {-0.5, 0, 0.9208203932499369}, {
             0, -0.8090169943749475, -0.38819660112501053`}, {
             0, 0.8090169943749475, -0.38819660112501053`}, {
             0.5, 0, -0.697213595499958}, {
             0.5, 0, 0.9208203932499369}, {-0.8090169943749475, -0.5, 
             0.11180339887498948`}, {-0.8090169943749475, 0.5, 
             0.11180339887498948`}, {0.8090169943749475, -0.5, 
             0.11180339887498948`}, {0.8090169943749475, 0.5, 
             0.11180339887498948`}}], 
           Polygon3DBox[{{7, 8, 1}, {7, 1, 3}, {7, 2, 8}, {8, 4, 1}, {1, 4, 
             5}, {1, 5, 3}, {3, 5, 9}, {4, 10, 5}, {5, 10, 9}, {6, 9, 10}, {9,
              6, 2, 7, 3}, {4, 8, 2, 6, 10}}]]],
         "\"metabidiminished icosahedron\""],
        Annotation[#, "metabidiminished icosahedron", "Tooltip"]& ],
       TraditionalForm], {2556., -588.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, 0, Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             0, 0, Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             0, -2^Rational[-1, 2], Rational[-1, 2]}, {
             0, -2^Rational[-1, 2], Rational[1, 2]}, {
             0, 2^Rational[-1, 2], Rational[-1, 2]}, {
             0, 2^Rational[-1, 2], Rational[1, 2]}, {-2^Rational[-1, 2], 0, 
              Rational[-1, 2]}, {-2^Rational[-1, 2], 0, Rational[1, 2]}, {
             2^Rational[-1, 2], 0, Rational[-1, 2]}, {
             2^Rational[-1, 2], 0, Rational[1, 2]}}, {{
             0, 0, -1.2071067811865475`}, {0, 0, 1.2071067811865475`}, {
             0, -0.7071067811865475, -0.5}, {0, -0.7071067811865475, 0.5}, {
             0, 0.7071067811865475, -0.5}, {
             0, 0.7071067811865475, 0.5}, {-0.7071067811865475, 
              0, -0.5}, {-0.7071067811865475, 0, 0.5}, {
             0.7071067811865475, 0, -0.5}, {0.7071067811865475, 0, 0.5}}], 
           Polygon3DBox[{{6, 8, 2}, {8, 4, 2}, {4, 10, 2}, {10, 6, 2}, {1, 7, 
             5}, {1, 3, 7}, {1, 9, 3}, {1, 5, 9}, {5, 7, 8, 6}, {7, 3, 4, 
             8}, {3, 9, 10, 4}, {9, 5, 6, 10}}]]],
         "\"elongated square dipyramid\""],
        Annotation[#, "elongated square dipyramid", "Tooltip"]& ],
       TraditionalForm], {2949.2307692307686`, -588.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[-1, 88] (Rational[701, 2] + 
                Rational[-131, 2] 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[-1, 88] (Rational[701, 2] + 
                Rational[-131, 2] 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], 0, 
              Rational[-1, 88] (Rational[701, 2] + 
                 Rational[-131, 2] 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 10] (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-1, 88] (Rational[701, 2] + 
                 Rational[-131, 2] 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 10] (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 88] (Rational[701, 2] + 
                 Rational[-131, 2] 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 88] (Rational[701, 2] + 
                Rational[-131, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 88] (Rational[701, 2] + 
                Rational[-131, 2] 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 88] (Rational[701, 2] + 
                Rational[-131, 2] 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 88] (Rational[701, 2] + 
                Rational[-131, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Rational[-1, 88] (Rational[701, 2] + 
                 Rational[-131, 2] 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[-1, 88] (Rational[701, 2] + 
                 Rational[-131, 2] 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[5, 4] + 
                Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Rational[-1, 88] (Rational[701, 2] + 
                Rational[-131, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 4] + 
                Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[-1, 88] (Rational[701, 2] + 
                Rational[-131, 2] 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 88] (Rational[701, 2] + 
                Rational[-131, 2] 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[-1, 88] (Rational[701, 2] + 
                Rational[-131, 2] 5^Rational[-1, 2])^Rational[1, 2]}}, {{
             0, -1.618033988749895, -0.2036620790552008}, {
             0, 1.618033988749895, -0.2036620790552008}, {
             0.8506508083520399, 0, 0.32206903306393275`}, {
             0.2628655560595668, -0.8090169943749475, 0.32206903306393275`}, {
             0.2628655560595668, 0.8090169943749475, 
             0.32206903306393275`}, {-0.9510565162951535, \
-1.3090169943749475`, -0.2036620790552008}, {-0.9510565162951535, 
             1.3090169943749475`, -0.2036620790552008}, {
             0.9510565162951535, -1.3090169943749475`, -0.2036620790552008}, {
             0.9510565162951535, 
             1.3090169943749475`, -0.2036620790552008}, {-0.6881909602355868, \
-0.5, 0.32206903306393275`}, {-0.6881909602355868, 0.5, 
             0.32206903306393275`}, {-1.5388417685876268`, -0.5, \
-0.2036620790552008}, {-1.5388417685876268`, 0.5, -0.2036620790552008}, {
             1.5388417685876268`, -0.5, -0.2036620790552008}, {
             1.5388417685876268`, 0.5, -0.2036620790552008}}], 
           Polygon3DBox[{{5, 11, 10, 4, 3}, {15, 14, 8, 1, 6, 12, 13, 7, 2, 
             9}, {11, 5, 2, 7}, {10, 11, 13, 12}, {4, 10, 6, 1}, {3, 4, 8, 
             14}, {5, 3, 15, 9}, {9, 2, 5}, {7, 13, 11}, {12, 6, 10}, {1, 8, 
             4}, {14, 15, 3}}]]],
         "\"pentagonal cupola\""],
        Annotation[#, "pentagonal cupola", "Tooltip"]& ],
       TraditionalForm], {3342.461538461538, -588.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2], Rational[-1, 2], 
              Rational[1, 184] (20 - 27 2^Rational[1, 2] - 
                2 (-168 + 121 2^Rational[1, 2])^Rational[1, 2]) + 
              Rational[-1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
                Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2], 
              Rational[1, 184] (20 - 27 2^Rational[1, 2] - 
                2 (-168 + 121 2^Rational[1, 2])^Rational[1, 2]) + 
              Rational[-1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
                Rational[1, 2]}, {
             0, 0, 2^Rational[-1, 2] + 
              Rational[1, 184] (20 - 27 2^Rational[1, 2] - 
                2 (-168 + 121 2^Rational[1, 2])^Rational[1, 2]) + 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^Rational[1, 2]}, {
             0, -2^Rational[-1, 2], 
              Rational[1, 184] (20 - 27 2^Rational[1, 2] - 
                2 (-168 + 121 2^Rational[1, 2])^Rational[1, 2]) + 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^Rational[1, 2]}, {
             0, 2^Rational[-1, 2], 
              Rational[1, 184] (20 - 27 2^Rational[1, 2] - 
                2 (-168 + 121 2^Rational[1, 2])^Rational[1, 2]) + 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2], 
              Rational[1, 184] (20 - 27 2^Rational[1, 2] - 
                2 (-168 + 121 2^Rational[1, 2])^Rational[1, 2]) + 
              Rational[-1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
                Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2], 
              Rational[1, 184] (20 - 27 2^Rational[1, 2] - 
                2 (-168 + 121 2^Rational[1, 2])^Rational[1, 2]) + 
              Rational[-1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
                Rational[1, 2]}, {-2^Rational[-1, 2], 0, 
              Rational[1, 184] (20 - 27 2^Rational[1, 2] - 
                2 (-168 + 121 2^Rational[1, 2])^Rational[1, 2]) + 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^Rational[1, 2]}, {
             2^Rational[-1, 2], 0, 
              Rational[1, 184] (20 - 27 2^Rational[1, 2] - 
                2 (-168 + 121 2^Rational[1, 2])^Rational[1, 2]) + 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
                Rational[1, 2]}}, {{-0.5, -0.5, -0.5384720149101433}, {-0.5, 
             0.5, -0.5384720149101433}, {0, 0, 1.0095311815301187`}, {
             0, -0.7071067811865475, 0.3024244003435712}, {
             0, 0.7071067811865475, 0.3024244003435712}, {
             0.5, -0.5, -0.5384720149101433}, {0.5, 
             0.5, -0.5384720149101433}, {-0.7071067811865475, 0, 
              0.3024244003435712}, {
             0.7071067811865475, 0, 0.3024244003435712}}], 
           Polygon3DBox[{{6, 1, 2, 7}, {7, 5, 9}, {2, 8, 5}, {1, 4, 8}, {6, 9,
              4}, {7, 2, 5}, {2, 1, 8}, {1, 6, 4}, {6, 7, 9}, {5, 8, 3}, {8, 
             4, 3}, {4, 9, 3}, {9, 5, 3}}]]],
         "\"gyroelongated square pyramid\""],
        Annotation[#, "gyroelongated square pyramid", "Tooltip"]& ],
       TraditionalForm], {3735.6923076923067`, -588.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[
                11, 2] (
                 2 (24205 + 9849 5^Rational[1, 2] + 
                  8 (32425 + 5755 5^Rational[1, 2])^Rational[1, 2]))^
                Rational[-1, 2] + Root[1 - 5 #^2 + 5 #^4& , 4, 0], -
              Root[11 - 104 # - 6064 #^2 + 32896 #^3 + 832256 #^4& , 4, 0], 
              Rational[-1, 2]}, {
             Rational[
                11, 2] (
                 2 (24205 + 9849 5^Rational[1, 2] + 
                  8 (32425 + 5755 5^Rational[1, 2])^Rational[1, 2]))^
                Rational[-1, 2] + Root[1 - 5 #^2 + 5 #^4& , 4, 0], -
              Root[11 - 104 # - 6064 #^2 + 32896 #^3 + 832256 #^4& , 4, 0], 
              Rational[1, 2]}, {
             Rational[
                11, 2] (
                 2 (24205 + 9849 5^Rational[1, 2] + 
                  8 (32425 + 5755 5^Rational[1, 2])^Rational[1, 2]))^
                Rational[-1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) - Root[
              11 - 104 # - 6064 #^2 + 32896 #^3 + 832256 #^4& , 4, 0], 
              Rational[-1, 2]}, {
             Rational[
                11, 2] (
                 2 (24205 + 9849 5^Rational[1, 2] + 
                  8 (32425 + 5755 5^Rational[1, 2])^Rational[1, 2]))^
                Rational[-1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) - Root[
              11 - 104 # - 6064 #^2 + 32896 #^3 + 832256 #^4& , 4, 0], 
              Rational[1, 2]}, {
             Rational[
                11, 2] (
                 2 (24205 + 9849 5^Rational[1, 2] + 
                  8 (32425 + 5755 5^Rational[1, 2])^Rational[1, 2]))^
                Rational[-1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Root[
              11 - 104 # - 6064 #^2 + 32896 #^3 + 832256 #^4& , 4, 0], 
              Rational[-1, 2]}, {
             Rational[
                11, 2] (
                 2 (24205 + 9849 5^Rational[1, 2] + 
                  8 (32425 + 5755 5^Rational[1, 2])^Rational[1, 2]))^
                Rational[-1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Root[
              11 - 104 # - 6064 #^2 + 32896 #^3 + 832256 #^4& , 4, 0], 
              Rational[1, 2]}, {
             Rational[
                11, 2] (
                 2 (24205 + 9849 5^Rational[1, 2] + 
                  8 (32425 + 5755 5^Rational[1, 2])^Rational[1, 2]))^
                Rational[-1, 2] + Root[1 - 40 #^2 + 80 #^4& , 1, 0], 
              Rational[-1, 2] - Root[
              11 - 104 # - 6064 #^2 + 32896 #^3 + 832256 #^4& , 4, 0], 
              Rational[-1, 2]}, {
             Rational[
                11, 2] (
                 2 (24205 + 9849 5^Rational[1, 2] + 
                  8 (32425 + 5755 5^Rational[1, 2])^Rational[1, 2]))^
                Rational[-1, 2] + Root[1 - 40 #^2 + 80 #^4& , 1, 0], 
              Rational[-1, 2] - Root[
              11 - 104 # - 6064 #^2 + 32896 #^3 + 832256 #^4& , 4, 0], 
              Rational[1, 2]}, {
             Rational[
                11, 2] (
                 2 (24205 + 9849 5^Rational[1, 2] + 
                  8 (32425 + 5755 5^Rational[1, 2])^Rational[1, 2]))^
                Rational[-1, 2] + Root[1 - 40 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 2] - Root[
              11 - 104 # - 6064 #^2 + 32896 #^3 + 832256 #^4& , 4, 0], 
              Rational[-1, 2]}, {
             Rational[
                11, 2] (
                 2 (24205 + 9849 5^Rational[1, 2] + 
                  8 (32425 + 5755 5^Rational[1, 2])^Rational[1, 2]))^
                Rational[-1, 2] + Root[1 - 40 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 2] - Root[
              11 - 104 # - 6064 #^2 + 32896 #^3 + 832256 #^4& , 4, 0], 
              Rational[1, 2]}, {
             Rational[
                11, 2] (
                 2 (24205 + 9849 5^Rational[1, 2] + 
                  8 (32425 + 5755 5^Rational[1, 2])^Rational[1, 2]))^
                Rational[-1, 2] + 
              Root[1 - 2800 #^2 + 14560 #^4 - 19200 #^6 + 6400 #^8& , 1, 0], -
              Root[11 - 104 # - 6064 #^2 + 32896 #^3 + 832256 #^4& , 4, 0], 
              0}, {Rational[
                11, 2] (
                 2 (24205 + 9849 5^Rational[1, 2] + 
                  8 (32425 + 5755 5^Rational[1, 2])^Rational[1, 2]))^
                Rational[-1, 2] + 
              Root[1 - 4320 #^2 + 213760 #^4 - 2252800 #^6 + 1638400 #^8& , 8,
                 0], Root[1 + 88 # - 176 #^2 - 128 #^3 + 256 #^4& , 4, 0] - 
              Root[11 - 104 # - 6064 #^2 + 32896 #^3 + 832256 #^4& , 4, 0], 
              0}}, {{0.8684148255311884, -0.054672023226363595`, -0.5}, {
             0.8684148255311884, -0.054672023226363595`, 0.5}, {
             0.28062957323871524`, -0.863689017601311, -0.5}, {
             0.28062957323871524`, -0.863689017601311, 0.5}, {
             0.28062957323871524`, 0.7543449711485839, -0.5}, {
             0.28062957323871524`, 0.7543449711485839, 
             0.5}, {-0.6704269430564384, -0.5546720232263636, -0.5}, \
{-0.6704269430564384, -0.5546720232263636, 0.5}, {-0.6704269430564384, 
             0.4453279767736364, -0.5}, {-0.6704269430564384, 
             0.4453279767736364, 
             0.5}, {-1.3775337242429866`, -0.054672023226363595`, 0}, {
             1.146583602202636, 0.7654634117385637, 0}}], 
           Polygon3DBox[{{3, 7, 9, 5, 1}, {2, 6, 10, 8, 4}, {5, 9, 10, 6}, {7,
              3, 4, 8}, {3, 1, 2, 4}, {12, 1, 5}, {12, 5, 6}, {12, 6, 2}, {12,
              2, 1}, {11, 9, 7}, {11, 7, 8}, {11, 8, 10}, {11, 10, 9}}]]],
         "\"biaugmented pentagonal prism\""],
        Annotation[#, "biaugmented pentagonal prism", "Tooltip"]& ],
       TraditionalForm], {4128.923076923076, -588.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], Rational[
              1, 2]}, {3^Rational[-1, 2], 0, Rational[-1, 2]}, {
             3^Rational[-1, 2], 0, Rational[1, 2]}, {
             Root[25 - 168 #^2 + 144 #^4& , 1, 0], 0, 0}, {
             Root[25 - 672 #^2 + 2304 #^4& , 4, 0], 
              Rational[1, 4] (-1 - 6^Rational[1, 2]), 0}, {
             Root[25 - 672 #^2 + 2304 #^4& , 4, 0], 
              Rational[1, 4] (1 + 6^Rational[1, 2]), 
              0}}, {{-0.2886751345948129, -0.5, -0.5}, {-0.2886751345948129, \
-0.5, 0.5}, {-0.2886751345948129, 0.5, -0.5}, {-0.2886751345948129, 0.5, 
             0.5}, {0.5773502691896258, 0, -0.5}, {
             0.5773502691896258, 0, 0.5}, {-0.9957819157813603, 0, 0}, {
             0.49789095789068016`, -0.8623724356957945, 0}, {
             0.49789095789068016`, 0.8623724356957945, 0}}], 
           Polygon3DBox[{{1, 3, 5}, {6, 4, 2}, {9, 5, 3}, {9, 3, 4}, {9, 4, 
            6}, {9, 6, 5}, {7, 3, 1}, {7, 1, 2}, {7, 2, 4}, {7, 4, 3}, {8, 1, 
            5}, {8, 5, 6}, {8, 6, 2}, {8, 2, 1}}]]],
         "\"triaugmented triangular prism\""],
        Annotation[#, "triaugmented triangular prism", "Tooltip"]& ],
       TraditionalForm], {4522.153846153846, -588.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[-1, 2], 
              Rational[-1, 180] (7774 + 4389 6^Rational[1, 2] - 
                2 (3330013 + 481743 6^Rational[1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             0, Rational[1, 2], 
              Rational[-1, 180] (7774 + 4389 6^Rational[1, 2] - 
                2 (3330013 + 481743 6^Rational[1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[1, 30] (-6 - 6^Rational[1, 2] - 
               2 (213 - 57 6^Rational[1, 2])^Rational[1, 2]), Rational[1, 2], 
              Rational[
                1, 5] (Rational[1, 6] + 6 6^Rational[1, 2] + 
                 Rational[-1, 3] (538 + 18 6^Rational[1, 2])^Rational[1, 2])^
                Rational[1, 2] + 
              Rational[-1, 180] (7774 + 4389 6^Rational[1, 2] - 
                 2 (3330013 + 481743 6^Rational[1, 2])^Rational[1, 2])^
                Rational[1, 2]}, {
             Rational[-1, 2], 
              0, (Rational[1, 2] (1 + 6^Rational[1, 2]))^Rational[1, 2] + 
              Rational[-1, 180] (7774 + 4389 6^Rational[1, 2] - 
                 2 (3330013 + 481743 6^Rational[1, 2])^Rational[1, 2])^
                Rational[1, 2]}, {
             Rational[1, 30] (-6 - 6^Rational[1, 2] - 
               2 (213 - 57 6^Rational[1, 2])^Rational[1, 2]), Rational[-1, 2],
               Rational[
                1, 5] (Rational[1, 6] + 6 6^Rational[1, 2] + 
                 Rational[-1, 3] (538 + 18 6^Rational[1, 2])^Rational[1, 2])^
                Rational[1, 2] + 
              Rational[-1, 180] (7774 + 4389 6^Rational[1, 2] - 
                 2 (3330013 + 481743 6^Rational[1, 2])^Rational[1, 2])^
                Rational[1, 2]}, {
             Rational[1, 30] (6 + 6^Rational[1, 2] + 
               2 (213 - 57 6^Rational[1, 2])^Rational[1, 2]), Rational[1, 2], 
              Rational[
                1, 5] (Rational[1, 6] + 6 6^Rational[1, 2] + 
                 Rational[-1, 3] (538 + 18 6^Rational[1, 2])^Rational[1, 2])^
                Rational[1, 2] + 
              Rational[-1, 180] (7774 + 4389 6^Rational[1, 2] - 
                 2 (3330013 + 481743 6^Rational[1, 2])^Rational[1, 2])^
                Rational[1, 2]}, {
             Rational[1, 2], 
              0, (Rational[1, 2] (1 + 6^Rational[1, 2]))^Rational[1, 2] + 
              Rational[-1, 180] (7774 + 4389 6^Rational[1, 2] - 
                 2 (3330013 + 481743 6^Rational[1, 2])^Rational[1, 2])^
                Rational[1, 2]}, {
             Rational[1, 30] (6 + 6^Rational[1, 2] + 
               2 (213 - 57 6^Rational[1, 2])^Rational[1, 2]), Rational[-1, 2],
               Rational[
                1, 5] (Rational[1, 6] + 6 6^Rational[1, 2] + 
                 Rational[-1, 3] (538 + 18 6^Rational[1, 2])^Rational[1, 2])^
                Rational[1, 2] + 
              Rational[-1, 180] (7774 + 4389 6^Rational[1, 2] - 
                 2 (3330013 + 481743 6^Rational[1, 2])^Rational[1, 2])^
                Rational[1, 2]}, {
             0, Rational[1, 30] (9 - 6^Rational[1, 2] + 
               2 (213 - 57 6^Rational[1, 2])^Rational[1, 2]), 
              Rational[
                1, 5] (Rational[1, 6] + 6 6^Rational[1, 2] + 
                 Rational[1, 3] (538 + 18 6^Rational[1, 2])^Rational[1, 2])^
                Rational[1, 2] + 
              Rational[-1, 180] (7774 + 4389 6^Rational[1, 2] - 
                 2 (3330013 + 481743 6^Rational[1, 2])^Rational[1, 2])^
                Rational[1, 2]}, {
             0, Rational[1, 30] (-9 + 6^Rational[1, 2] - 
               2 (213 - 57 6^Rational[1, 2])^Rational[1, 2]), 
              Rational[
                1, 5] (Rational[1, 6] + 6 6^Rational[1, 2] + 
                 Rational[1, 3] (538 + 18 6^Rational[1, 2])^Rational[1, 2])^
                Rational[1, 2] + 
              Rational[-1, 180] (7774 + 4389 6^Rational[1, 2] - 
                 2 (3330013 + 481743 6^Rational[1, 2])^Rational[1, 2])^
                Rational[1, 2]}}, {{0, -0.5, -0.6638235832416433}, {
             0, 0.5, -0.6638235832416433}, {-0.8527269428464169, 
             0.5, -0.1414666545580049}, {-0.5, 0, 
              0.6494718410219109}, {-0.8527269428464169, -0.5, \
-0.1414666545580049}, {0.8527269428464169, 0.5, -0.1414666545580049}, {
             0.5, 0, 0.6494718410219109}, {
             0.8527269428464169, -0.5, -0.1414666545580049}, {
             0, 0.7894276266608717, 0.2933763169492496}, {
             0, -0.7894276266608717, 0.2933763169492496}}], 
           Polygon3DBox[{{3, 2, 1, 5}, {2, 6, 8, 1}, {3, 9, 2}, {9, 6, 2}, {9,
              3, 4}, {6, 9, 7}, {3, 5, 4}, {6, 7, 8}, {4, 7, 9}, {10, 7, 4}, {
             10, 8, 7}, {5, 10, 4}, {1, 8, 10}, {5, 1, 10}}]]],
         "\"sphenocorona\""],
        Annotation[#, "sphenocorona", "Tooltip"]& ],
       TraditionalForm], {196.6153846153846, -980.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, -1, 0}, {0, 1, 0}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], -
              Rational[2, 3]^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[2, 3]^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], -
              Rational[2, 3]^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[2, 3]^Rational[1, 2]}, {
             3^Rational[-1, 2], 0, -Rational[2, 3]^Rational[1, 2]}, {
             3^Rational[-1, 2], 0, Rational[2, 3]^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2], 0}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2], 0}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2], 0}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[1, 2], 0}}, {{0, -1, 
             0}, {0, 1, 
             0}, {-0.2886751345948129, -0.5, -0.816496580927726}, \
{-0.2886751345948129, -0.5, 0.816496580927726}, {-0.2886751345948129, 
             0.5, -0.816496580927726}, {-0.2886751345948129, 0.5, 
             0.816496580927726}, {
             0.5773502691896258, 0, -0.816496580927726}, {
             0.5773502691896258, 0, 
              0.816496580927726}, {-0.8660254037844386, -0.5, 
              0}, {-0.8660254037844386, 0.5, 0}, {
             0.8660254037844386, -0.5, 0}, {0.8660254037844386, 0.5, 0}}], 
           Polygon3DBox[{{6, 4, 8}, {4, 6, 10, 9}, {8, 4, 1, 11}, {6, 8, 12, 
             2}, {2, 10, 6}, {9, 1, 4}, {11, 12, 8}, {7, 3, 5}, {9, 10, 5, 
             3}, {11, 1, 3, 7}, {2, 12, 7, 5}, {5, 10, 2}, {3, 1, 9}, {7, 12, 
             11}}]]],
         "\"triangular orthobicupola\""],
        Annotation[#, "triangular orthobicupola", "Tooltip"]& ],
       TraditionalForm], {589.8461538461538, -980.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[{{-1.068953283714483, -0.0819798983889878, 
           0.0715677667265998}, {-1.0203761486475376`, 0.8213872489392514, 
           0.4976687172240609}, {-0.554083485896695, 0.04383572283921688, 
           0.9195500809909495}, {-0.5501267843310638, -0.9151532281000329, \
-0.11982657613531757`}, {-0.4165387774027467, -0.10178877491180195`, \
-0.6860332820384937}, {-0.3379376832256302, 1.3598929877565609`, 
           0.0034123969085569747`}, {-0.035254832189355975`, \
-0.7893359069262839, 0.7281541778590922}, {0.03525506458007556, 
           0.7893371553386951, -0.7281566121939212}, {
           0.3379337778369398, -1.3598921288037638`, \
-0.0034090598913773143`}, {0.4165397763793586, 0.10178999195466241`, 
           0.6860330622854794}, {0.5501258893529102, 0.9151564929417643, 
           0.11982777922072284`}, {
           0.5540845311641801, -0.04383974689388304, -0.9195521037557072}, {
           1.0203748212317918`, -0.8213913794916007, -0.4976672568682107}, {
           1.0689553559370146`, 0.08197959070918635, -0.0715677123410622}}, 
           Polygon3DBox[{{14, 12, 8, 11}, {12, 14, 13}, {8, 12, 5}, {11, 8, 
             6}, {14, 11, 10}, {13, 14, 10, 7, 9}, {12, 13, 9, 4, 5}, {6, 8, 
             5, 1, 2}, {11, 6, 2, 3, 10}, {4, 9, 7}, {5, 4, 1}, {3, 2, 1}, {
             10, 3, 7}, {7, 3, 1, 4}}]]],
         "\"bilunabirotunda\""],
        Annotation[#, "bilunabirotunda", "Tooltip"]& ],
       TraditionalForm], {983.0769230769231, -980.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{-1, 0, Rational[-1, 2]}, {-1, 0, Rational[1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2], Rational[
              1, 2]}, {
             Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2], Rational[
              1, 2]}, {
             Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2], Rational[
              1, 2]}, {
             Rational[1, 2], Rational[1, 2] 3^Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2] 3^Rational[1, 2], Rational[
              1, 2]}, {1, 0, Rational[-1, 2]}, {1, 0, Rational[1, 2]}, {
             Rational[1, 4] (-3 - 6^Rational[1, 2]), Root[
              1 - 160 #^2 + 256 #^4& , 1, 0], 0}, {
             Rational[1, 4] (3 + 6^Rational[1, 2]), Root[
              1 - 160 #^2 + 256 #^4& , 4, 0], 0}}, {{-1, 0, -0.5}, {-1, 0, 
              0.5}, {-0.5, -0.8660254037844386, -0.5}, {-0.5, \
-0.8660254037844386, 0.5}, {-0.5, 0.8660254037844386, -0.5}, {-0.5, 
             0.8660254037844386, 0.5}, {0.5, -0.8660254037844386, -0.5}, {
             0.5, -0.8660254037844386, 0.5}, {0.5, 
             0.8660254037844386, -0.5}, {0.5, 0.8660254037844386, 0.5}, {
             1, 0, -0.5}, {
             1, 0, 0.5}, {-1.3623724356957945`, -0.786566092485493, 0}, {
             1.3623724356957945`, 0.786566092485493, 0}}], 
           Polygon3DBox[{{7, 3, 1, 5, 9, 11}, {12, 10, 6, 2, 4, 8}, {9, 5, 6, 
             10}, {5, 1, 2, 6}, {3, 7, 8, 4}, {7, 11, 12, 8}, {14, 11, 9}, {
             14, 9, 10}, {14, 10, 12}, {14, 12, 11}, {13, 1, 3}, {13, 3, 4}, {
             13, 4, 2}, {13, 2, 1}}]]],
         "\"parabiaugmented hexagonal prism\""],
        Annotation[#, "parabiaugmented hexagonal prism", "Tooltip"]& ],
       TraditionalForm], {1376.3076923076924`, -980.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{-1, 
              Rational[1, 940] ((-52) 2^Rational[1, 2] - 3^Rational[1, 2]), 
              Rational[-1, 2]}, {-1, 
              Rational[1, 940] ((-52) 2^Rational[1, 2] - 3^Rational[1, 2]), 
              Rational[1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2] + 
              Rational[1, 940] ((-52) 2^Rational[1, 2] - 3^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2] + 
              Rational[1, 940] ((-52) 2^Rational[1, 2] - 3^Rational[1, 2]), 
              Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2] + 
              Rational[1, 940] ((-52) 2^Rational[1, 2] - 3^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2] + 
              Rational[1, 940] ((-52) 2^Rational[1, 2] - 3^Rational[1, 2]), 
              Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] + 
              Rational[1, 940] ((-52) 2^Rational[1, 2] - 3^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] + 
              Rational[1, 940] ((-52) 2^Rational[1, 2] - 3^Rational[1, 2]), 
              Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
              Rational[1, 940] ((-52) 2^Rational[1, 2] - 3^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
              Rational[1, 940] ((-52) 2^Rational[1, 2] - 3^Rational[1, 2]), 
              Rational[1, 2]}, {
             1, Rational[1, 940] ((-52) 2^Rational[1, 2] - 3^Rational[1, 2]), 
              Rational[-1, 2]}, {
             1, Rational[1, 940] ((-52) 2^Rational[1, 2] - 3^Rational[1, 2]), 
              Rational[1, 2]}, {
             Rational[1, 4] (-3 - 6^Rational[1, 2]), 
              Rational[1, 940] ((-52) 2^Rational[1, 2] - 3^Rational[1, 2]) + 
              Root[1 - 160 #^2 + 256 #^4& , 4, 0], 0}, {
             Rational[1, 4] (3 + 6^Rational[1, 2]), 
              Rational[1, 940] ((-52) 2^Rational[1, 2] - 3^Rational[1, 2]) + 
              Root[1 - 160 #^2 + 256 #^4& , 4, 0], 
              0}}, {{-1, -0.08007569792656366, -0.5}, {-1, \
-0.08007569792656366, 
              0.5}, {-0.5, -0.9461011017110023, -0.5}, {-0.5, \
-0.9461011017110023, 0.5}, {-0.5, 0.7859497058578749, -0.5}, {-0.5, 
             0.7859497058578749, 0.5}, {0.5, -0.9461011017110023, -0.5}, {
             0.5, -0.9461011017110023, 0.5}, {0.5, 
             0.7859497058578749, -0.5}, {0.5, 0.7859497058578749, 0.5}, {
             1, -0.08007569792656366, -0.5}, {
             1, -0.08007569792656366, 0.5}, {-1.3623724356957945`, 
              0.7064903945589294, 0}, {
             1.3623724356957945`, 0.7064903945589294, 0}}], 
           Polygon3DBox[{{7, 3, 1, 5, 9, 11}, {12, 10, 6, 2, 4, 8}, {9, 5, 6, 
             10}, {1, 3, 4, 2}, {3, 7, 8, 4}, {7, 11, 12, 8}, {14, 11, 9}, {
             14, 9, 10}, {14, 10, 12}, {14, 12, 11}, {13, 5, 1}, {13, 1, 2}, {
             13, 2, 6}, {13, 6, 5}}]]],
         "\"metabiaugmented hexagonal prism\""],
        Annotation[#, "metabiaugmented hexagonal prism", "Tooltip"]& ],
       TraditionalForm], {1769.5384615384614`, -980.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, -1, Rational[-3, 11] Rational[3, 2]^Rational[1, 2]}, {
             0, 1, Rational[-3, 11] 
              Rational[3, 2]^Rational[1, 2]}, {-3^Rational[-1, 2], -1, 
              Rational[5, 22] Rational[3, 2]^Rational[1, 2] + 
              Rational[1, 2] 6^Rational[-1, 2]}, {-3^Rational[-1, 2], 1, 
              Rational[5, 22] Rational[3, 2]^Rational[1, 2] + 
              Rational[1, 2] 6^Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[5, 22] Rational[3, 2]^Rational[1, 2] + 
              Rational[5, 2] 6^Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[5, 22] Rational[3, 2]^Rational[1, 2] + 
              Rational[5, 2] 6^Rational[-1, 2]}, {
             Rational[1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[5, 22] Rational[3, 2]^Rational[1, 2] + 
              Rational[-7, 2] 6^Rational[-1, 2]}, {
             3^Rational[-1, 2], 0, 
              Rational[5, 22] Rational[3, 2]^Rational[1, 2] + 
              Rational[5, 2] 6^Rational[-1, 2]}, {
             2 3^Rational[-1, 2], 0, 
              Rational[5, 22] Rational[3, 2]^Rational[1, 2] + 
              Rational[1, 2] 6^Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-3, 11] Rational[3, 2]^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[-3, 11] Rational[3, 2]^Rational[1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-3, 11] Rational[3, 2]^Rational[1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[-3, 11] 
              Rational[3, 2]^Rational[1, 2]}, {-3^Rational[-1, 2], 0, 
              Rational[5, 22] Rational[3, 2]^Rational[1, 2] + 
              Rational[-7, 2] 6^Rational[-1, 2]}, {
             Rational[1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[5, 22] Rational[3, 2]^Rational[1, 2] + 
              Rational[-7, 2] 6^Rational[-1, 2]}}, {{
             0, -1, -0.3340213285613424}, {
             0, 1, -0.3340213285613424}, {-0.5773502691896258, -1, 
              0.48247525236638356`}, {-0.5773502691896258, 1, 
              0.48247525236638356`}, {-0.2886751345948129, -0.5, 
             1.2989718332941096`}, {-0.2886751345948129, 0.5, 
             1.2989718332941096`}, {
             0.2886751345948129, -0.5, -1.1505179094890687`}, {
             0.5773502691896258, 0, 1.2989718332941096`}, {
             1.1547005383792517`, 0, 
              0.48247525236638356`}, {-0.8660254037844386, -0.5, \
-0.3340213285613424}, {-0.8660254037844386, 0.5, -0.3340213285613424}, {
             0.8660254037844386, -0.5, -0.3340213285613424}, {
             0.8660254037844386, 
             0.5, -0.3340213285613424}, {-0.5773502691896258, 
              0, -1.1505179094890687`}, {0.2886751345948129, 
             0.5, -1.1505179094890687`}}], 
           Polygon3DBox[{{12, 13, 9}, {3, 10, 1}, {2, 11, 4}, {6, 5, 8}, {12, 
             9, 8, 5, 3, 1}, {2, 4, 6, 8, 9, 13}, {10, 3, 5, 6, 4, 11}, {7, 
             14, 15}, {11, 2, 15, 14}, {1, 10, 14, 7}, {13, 12, 7, 15}, {15, 
             2, 13}, {14, 10, 11}, {7, 12, 1}}]]],
         "\"augmented truncated tetrahedron\""],
        Annotation[#, "augmented truncated tetrahedron", "Tooltip"]& ],
       TraditionalForm], {2162.7692307692305`, -980.}, {Center, Center}, {359.9999999999998, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, -1, -1 + Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}, {
             0, -1, Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}, {
             0, 1, -1 + Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}, {
             0, 1, Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[2, 3]^Rational[1, 2] + 
              Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[2, 3]^Rational[1, 2] + 
              Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}, {
             3^Rational[-1, 2], 0, Rational[2, 3]^Rational[1, 2] + 
              Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2], -1 + 
              Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2], -1 + 
              Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2], -1 + 
              Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[1, 2], -1 + 
              Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[-13, 772] (-27 + 5 6^Rational[1, 2])}}, {{
             0, -1, -0.7515762089130914}, {0, -1, 0.2484237910869086}, {
             0, 1, -0.7515762089130914}, {
             0, 1, 0.2484237910869086}, {-0.2886751345948129, -0.5, 
             1.0649203720146345`}, {-0.2886751345948129, 0.5, 
             1.0649203720146345`}, {
             0.5773502691896258, 0, 
              1.0649203720146345`}, {-0.8660254037844386, -0.5, \
-0.7515762089130914}, {-0.8660254037844386, -0.5, 
             0.2484237910869086}, {-0.8660254037844386, 
             0.5, -0.7515762089130914}, {-0.8660254037844386, 0.5, 
             0.2484237910869086}, {
             0.8660254037844386, -0.5, -0.7515762089130914}, {
             0.8660254037844386, -0.5, 0.2484237910869086}, {
             0.8660254037844386, 0.5, -0.7515762089130914}, {
             0.8660254037844386, 0.5, 0.2484237910869086}}], 
           Polygon3DBox[{{5, 6, 11, 9}, {7, 5, 2, 13}, {6, 7, 15, 4}, {4, 11, 
             6}, {9, 2, 5}, {13, 15, 7}, {6, 5, 7}, {14, 12, 1, 8, 10, 3}, {3,
              10, 11, 4}, {10, 8, 9, 11}, {8, 1, 2, 9}, {1, 12, 13, 2}, {12, 
             14, 15, 13}, {14, 3, 4, 15}}]]],
         "\"elongated triangular cupola\""],
        Annotation[#, "elongated triangular cupola", "Tooltip"]& ],
       TraditionalForm], {2556., -980.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, 0, Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
               Rational[1, 2])}, {
             0, 0, Rational[1, 10] (
               5 + (10 (5 - 5^Rational[1, 2]))^Rational[1, 2])}, {(
               Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], 0, 
              Rational[-1, 2]}, {(Rational[1, 2] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 0, Rational[
              1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[
              1, 2]}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 
               2]}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[-1, 2], Rational[
              1, 2]}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 2], 
              Rational[-1, 
               2]}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 2], Rational[1, 2]}}, {{
             0, 0, -1.0257311121191337`}, {0, 0, 1.0257311121191337`}, {
             0.8506508083520399, 0, -0.5}, {0.8506508083520399, 0, 0.5}, {
             0.2628655560595668, -0.8090169943749475, -0.5}, {
             0.2628655560595668, -0.8090169943749475, 0.5}, {
             0.2628655560595668, 0.8090169943749475, -0.5}, {
             0.2628655560595668, 0.8090169943749475, 
             0.5}, {-0.6881909602355868, -0.5, -0.5}, {-0.6881909602355868, \
-0.5, 0.5}, {-0.6881909602355868, 0.5, -0.5}, {-0.6881909602355868, 0.5, 
             0.5}}], Polygon3DBox[{{8, 12, 2}, {12, 10, 2}, {10, 6, 2}, {6, 4,
              2}, {4, 8, 2}, {1, 11, 7}, {1, 9, 11}, {1, 5, 9}, {1, 3, 5}, {1,
              7, 3}, {7, 11, 12, 8}, {11, 9, 10, 12}, {9, 5, 6, 10}, {5, 3, 4,
              6}, {3, 7, 8, 4}}]]],
         "\"elongated pentagonal dipyramid\""],
        Annotation[#, "elongated pentagonal dipyramid", "Tooltip"]& ],
       TraditionalForm], {2949.2307692307686`, -980.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {
             0, 0, -2^Rational[-1, 2] + 
              Rational[-1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
                Rational[1, 2]}, {
             0, 0, 2^Rational[-1, 2] + 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^Rational[1, 2]}, {
             0, -2^Rational[-1, 2], 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^Rational[1, 2]}, {
             0, 2^Rational[-1, 2], 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2], 
              Rational[-1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {-2^Rational[-1, 2], 0, 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^Rational[1, 2]}, {
             2^Rational[-1, 2], 0, 
              Rational[1, 4] (4 - Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}}, {{-0.5, -0.5, -0.42044820762685725`}, {-0.5, 
             0.5, -0.42044820762685725`}, {0, 0, -1.1275549888134047`}, {
             0, 0, 1.1275549888134047`}, {
             0, -0.7071067811865475, 0.42044820762685725`}, {
             0, 0.7071067811865475, 0.42044820762685725`}, {
             0.5, -0.5, -0.42044820762685725`}, {0.5, 
             0.5, -0.42044820762685725`}, {-0.7071067811865475, 0, 
              0.42044820762685725`}, {
             0.7071067811865475, 0, 0.42044820762685725`}}], 
           Polygon3DBox[{{8, 6, 10}, {2, 9, 6}, {1, 5, 9}, {7, 10, 5}, {8, 2, 
            6}, {2, 1, 9}, {1, 7, 5}, {7, 8, 10}, {6, 9, 4}, {9, 5, 4}, {5, 
            10, 4}, {10, 6, 4}, {3, 2, 8}, {3, 1, 2}, {3, 7, 1}, {3, 8, 
            7}}]]],
         "\"gyroelongated square dipyramid\""],
        Annotation[#, "gyroelongated square dipyramid", "Tooltip"]& ],
       TraditionalForm], {3342.461538461538, -980.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, 0, (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + 
              Rational[-1, 44] (Rational[1, 10] (85 + 31 5^Rational[1, 2]))^
                Rational[1, 2]}, {-(Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              0, -(Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
                Rational[1, 2] + 
              Rational[-1, 44] (Rational[1, 10] (85 + 31 5^Rational[1, 2]))^
                Rational[1, 2]}, {(Rational[1, 2] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              0, (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
               Rational[1, 2] + 
              Rational[-1, 44] (Rational[1, 10] (85 + 31 5^Rational[1, 2]))^
                Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (-1 - 5^
               Rational[
                1, 2]), -(Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
                Rational[1, 2] + 
              Rational[-1, 44] (Rational[1, 10] (85 + 31 5^Rational[1, 2]))^
                Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (1 + 
               5^Rational[1, 2]), -(Rational[1, 8] + 
                 Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2] + 
              Rational[-1, 44] (Rational[1, 10] (85 + 31 5^Rational[1, 2]))^
                Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (-1 - 5^
               Rational[1, 2]), (Rational[1, 8] + 
                Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2] + 
              Rational[-1, 44] (Rational[1, 10] (85 + 31 5^Rational[1, 2]))^
                Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (1 + 
               5^Rational[1, 2]), (Rational[1, 8] + 
                Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2] + 
              Rational[-1, 44] (Rational[1, 10] (85 + 31 5^Rational[1, 2]))^
                Rational[1, 2]}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 
               2], (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
               Rational[1, 2] + 
              Rational[-1, 44] (Rational[1, 10] (85 + 31 5^Rational[1, 2]))^
                Rational[1, 2]}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
               Rational[1, 2] + 
              Rational[-1, 44] (Rational[1, 10] (85 + 31 5^Rational[1, 2]))^
                Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 
               2], -(Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
                Rational[1, 2] + 
              Rational[-1, 44] (Rational[1, 10] (85 + 31 5^Rational[1, 2]))^
                Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], -(Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
                Rational[1, 2] + 
              Rational[-1, 44] (Rational[1, 10] (85 + 31 5^Rational[1, 2]))^
                Rational[1, 2]}}, {{
             0, 0, 0.8617761902604423}, {-0.8506508083520399, 
              0, -0.5146057302107312}, {
             0.8506508083520399, 0, 
              0.3360450781413087}, {-0.2628655560595668, -0.8090169943749475, \
-0.5146057302107312}, {-0.2628655560595668, 
             0.8090169943749475, -0.5146057302107312}, {
             0.2628655560595668, -0.8090169943749475, 0.3360450781413087}, {
             0.2628655560595668, 0.8090169943749475, 
             0.3360450781413087}, {-0.6881909602355868, -0.5, 
             0.3360450781413087}, {-0.6881909602355868, 0.5, 
             0.3360450781413087}, {
             0.6881909602355868, -0.5, -0.5146057302107312}, {
             0.6881909602355868, 0.5, -0.5146057302107312}}], 
           Polygon3DBox[{{10, 4, 2, 5, 11}, {11, 7, 3}, {5, 9, 7}, {2, 8, 
             9}, {4, 6, 8}, {10, 3, 6}, {11, 5, 7}, {5, 2, 9}, {2, 4, 8}, {4, 
             10, 6}, {10, 11, 3}, {7, 9, 1}, {9, 8, 1}, {8, 6, 1}, {6, 3, 
             1}, {3, 7, 1}}]]],
         "\"gyroelongated pentagonal pyramid\""],
        Annotation[#, "gyroelongated pentagonal pyramid", "Tooltip"]& ],
       TraditionalForm], {3735.6923076923067`, -980.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{-Root[1 - 1236 #^2 + 17424 #^4& , 2, 0], 0, 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[9 - 36 #^2 + 16 #^4& , 4, 0]}, {-
              Root[1 - 1236 #^2 + 17424 #^4& , 2, 0], 0, 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[9 - 36 #^2 + 16 #^4& , 1, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 3, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 3, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 4, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 1, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 4, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 1, 0]}, {
             Root[25 - 180 #^2 + 144 #^4& , 4, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Root[25 - 180 #^2 + 144 #^4& , 4, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 216 #^2 + 144 #^4& , 1, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], Rational[-1, 2], 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 216 #^2 + 144 #^4& , 1, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], Rational[1, 2], 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 216 #^2 + 144 #^4& , 4, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], Rational[-1, 2], 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Root[1 - 216 #^2 + 144 #^4& , 4, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], Rational[1, 2], 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Root[1 - 9 #^2 + 9 #^4& , 1, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 0, 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 1, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 1, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 1, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 9 #^2 + 9 #^4& , 4, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 0, 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 4, 0]}, {
             Root[25 - 180 #^2 + 144 #^4& , 1, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Root[25 - 180 #^2 + 144 #^4& , 1, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Root[121 - 345 #^2 + 225 #^4& , 1, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 0, 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[121 - 6180 #^2 + 3600 #^4& , 4, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 2, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 2, 0] - Root[
              1 - 1236 #^2 + 17424 #^4& , 2, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 44] (Rational[1, 6] (23 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}}, {{
             0.028609541385736282`, 0, 1.3638081625688714`}, {
             0.028609541385736282`, 0, -1.438708914319276}, {
             0.20702058627228123`, -1.3090169943749475`, 
             0.42963580360615566`}, {0.20702058627228123`, 
             1.3090169943749475`, 0.42963580360615566`}, {
             0.4956957208670941, -0.8090169943749475, -1.081886824546186}, {
             0.4956957208670941, 0.8090169943749475, -1.081886824546186}, {
             1.07304599005672, -0.8090169943749475, 0.42963580360615566`}, {
             1.07304599005672, 0.8090169943749475, 
             0.42963580360615566`}, {-1.1942379521717923`, -0.5, 
             0.42963580360615566`}, {-1.1942379521717923`, 0.5, 
             0.42963580360615566`}, {
             1.251457034943265, -0.5, -0.50453655535656}, {1.251457034943265, 
             0.5, -0.50453655535656}, {-0.9055628175769795, 
              0, -1.081886824546186}, {-0.43847663809562154`, \
-0.8090169943749475, 1.0069860727957813`}, {-0.43847663809562154`, 
             0.8090169943749475, 1.0069860727957813`}, {
             0.962781900348452, 0, 
              1.0069860727957813`}, {-1.0158269072852473`, \
-0.8090169943749475, -0.50453655535656}, {-1.0158269072852473`, 
             0.8090169943749475, -0.50453655535656}, {-0.9665153072722827, 0, 
              1.2651849625429423`}, {-0.14980150350080865`, \
-1.3090169943749475`, -0.50453655535656}, {-0.14980150350080865`, 
             1.3090169943749475`, -0.50453655535656}}], 
           Polygon3DBox[{{2, 6, 12, 11, 5}, {5, 11, 7, 3, 20}, {11, 12, 8, 16,
              7}, {12, 6, 21, 4, 8}, {6, 2, 13, 18, 21}, {2, 5, 20, 17, 13}, {
             4, 21, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 20, 3, 14, 9}, {3, 
             7, 16, 1, 14}, {16, 8, 4, 15, 1}, {19, 15, 10}, {19, 10, 9}, {19,
              9, 14}, {19, 14, 1}, {19, 1, 15}}]]],
         "\"augmented dodecahedron\""],
        Annotation[#, "augmented dodecahedron", "Tooltip"]& ],
       TraditionalForm], {4128.923076923076, -980.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[{{-0.8097582135547496, -0.7471091304426166, 
           0.4030724692749733}, {-0.7418882135547495, 
           0.04837086955738355, -0.19908753072502666`}, {-0.5055982135547497, 
           0.13245086955738328`, 0.7689524692749736}, {-0.22206821355474957`, 
           0.8401008695573836, 0.12177246927497347`}, {-0.20559821355474958`, 
           0.5901008695573832, -0.8463275307250266}, {-0.09214821355474942, \
-0.7060591304426166, -0.29216753072502677`}, {
           0.14414178644525047`, -0.6219891304426165, 0.6758724692749736}, {
           0.44414178644525054`, -0.1643391304426164, -0.9394075307250263}, {
           0.46624178644525055`, 0.3236608695573836, 0.6312024692749736}, {
           0.6421457864452503, 0.5920108695573832, -0.31592753072502655`}, {
           0.8037757864452504, -0.35104913044261654`, -0.02517753072502644}}, 
           Polygon3DBox[{{6, 1, 2}, {6, 2, 5, 8}, {10, 4, 9}, {9, 7, 11}, {9, 
             4, 3}, {9, 3, 7}, {7, 6, 11}, {11, 6, 8}, {4, 2, 3}, {2, 4, 5}, {
             8, 10, 11}, {8, 5, 10}, {10, 5, 4}, {11, 10, 9}, {7, 1, 6}, {7, 
             3, 1}, {1, 3, 2}}]]],
         "\"augmented sphenocorona\""],
        Annotation[#, "augmented sphenocorona", "Tooltip"]& ],
       TraditionalForm], {4522.153846153846, -980.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{-1, 0, Rational[-1, 2]}, {-1, 0, Rational[1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2], Rational[
              1, 2]}, {
             Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2], Rational[
              1, 2]}, {0, Root[1 - 40 #^2 + 16 #^4& , 1, 0], 0}, {
             Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2], Rational[
              1, 2]}, {
             Rational[1, 2], Rational[1, 2] 3^Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2] 3^Rational[1, 2], Rational[
              1, 2]}, {1, 0, Rational[-1, 2]}, {1, 0, Rational[1, 2]}, {
             Rational[1, 4] (-3 - 6^Rational[1, 2]), Root[
              1 - 160 #^2 + 256 #^4& , 4, 0], 0}, {
             Rational[1, 4] (3 + 6^Rational[1, 2]), Root[
              1 - 160 #^2 + 256 #^4& , 4, 0], 0}}, {{-1, 0, -0.5}, {-1, 0, 
              0.5}, {-0.5, -0.8660254037844386, -0.5}, {-0.5, \
-0.8660254037844386, 0.5}, {-0.5, 0.8660254037844386, -0.5}, {-0.5, 
             0.8660254037844386, 0.5}, {0, -1.573132184970986, 0}, {
             0.5, -0.8660254037844386, -0.5}, {0.5, -0.8660254037844386, 
             0.5}, {0.5, 0.8660254037844386, -0.5}, {0.5, 0.8660254037844386, 
             0.5}, {1, 0, -0.5}, {
             1, 0, 0.5}, {-1.3623724356957945`, 0.786566092485493, 0}, {
             1.3623724356957945`, 0.786566092485493, 0}}], 
           Polygon3DBox[{{8, 3, 1, 5, 10, 12}, {13, 11, 6, 2, 4, 9}, {10, 5, 
             6, 11}, {1, 3, 4, 2}, {8, 12, 13, 9}, {15, 12, 10}, {15, 10, 
             11}, {15, 11, 13}, {15, 13, 12}, {14, 5, 1}, {14, 1, 2}, {14, 2, 
             6}, {14, 6, 5}, {7, 3, 8}, {7, 8, 9}, {7, 9, 4}, {7, 4, 3}}]]],
         "\"triaugmented hexagonal prism\""],
        Annotation[#, "triaugmented hexagonal prism", "Tooltip"]& ],
       TraditionalForm], {196.6153846153846, -1372.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^
               Rational[1, 2]), -(Rational[5, 32] + 
                Rational[11, 32] 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, Rational[1, 2] (1 + 
               5^Rational[1, 2]), -(Rational[5, 32] + 
                Rational[11, 32] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^
               Rational[1, 2]), -(Rational[5, 32] + 
                Rational[11, 32] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 
               5^Rational[1, 2]), -(Rational[5, 32] + 
                Rational[11, 32] 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], 
              Rational[1, 4] (-3 - 5^
               Rational[1, 2]), -(Rational[5, 32] + 
                Rational[11, 32] 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], 
              Rational[1, 4] (3 + 
               5^Rational[1, 2]), -(Rational[5, 32] + 
                Rational[11, 32] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 4] + 
                Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 
               2], -(Rational[5, 32] + Rational[11, 32] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 4] + 
                Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], -(Rational[5, 32] + Rational[11, 32] 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 
               2], -(Rational[5, 32] + Rational[11, 32] 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], -(Rational[5, 32] + Rational[11, 32] 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
              Rational[1, 2], 
              0, -(Rational[5, 32] + Rational[11, 32] 5^Rational[-1, 2])^
                Rational[1, 2] + (Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[1, 4] (-3 - 5^
               Rational[
                1, 2]), -(Rational[5, 32] + 
                 Rational[11, 32] 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 
               5^Rational[1, 2]), -(Rational[5, 32] + 
                 Rational[11, 32] 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-1 - 5^
               Rational[
                1, 2]), -(Rational[5, 32] + 
                 Rational[11, 32] 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (1 + 
               5^Rational[1, 2]), -(Rational[5, 32] + 
                 Rational[11, 32] 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              0, -(Rational[5, 32] + Rational[11, 32] 5^Rational[-1, 2])^
                Rational[1, 2] + (Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (-1 - 5^
               Rational[
                1, 2]), -(Rational[5, 32] + 
                 Rational[11, 32] 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (1 + 
               5^Rational[1, 2]), -(Rational[5, 32] + 
                 Rational[11, 32] 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2]}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[-1, 
               2], -(Rational[5, 32] + Rational[11, 32] 5^Rational[-1, 2])^
                Rational[1, 2] + (Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], -(Rational[5, 32] + Rational[11, 32] 5^Rational[-1, 2])^
                Rational[1, 2] + (Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2]}}, {{
             0, -1.618033988749895, -0.5567581822058033}, {
             0, 1.618033988749895, -0.5567581822058033}, \
{-0.9510565162951535, -1.3090169943749475`, -0.5567581822058033}, \
{-0.9510565162951535, 1.3090169943749475`, -0.5567581822058033}, {
             0.9510565162951535, -1.3090169943749475`, -0.5567581822058033}, {
             0.9510565162951535, 
             1.3090169943749475`, -0.5567581822058033}, \
{-1.5388417685876268`, -0.5, -0.5567581822058033}, {-1.5388417685876268`, 
             0.5, -0.5567581822058033}, {
             1.5388417685876268`, -0.5, -0.5567581822058033}, {
             1.5388417685876268`, 0.5, -0.5567581822058033}, {
             1.3763819204711736`, 0, 0.29389262614623657`}, {
             0.42532540417601994`, -1.3090169943749475`, 
             0.29389262614623657`}, {0.42532540417601994`, 
             1.3090169943749475`, 
             0.29389262614623657`}, {-1.1135163644116066`, \
-0.8090169943749475, 0.29389262614623657`}, {-1.1135163644116066`, 
             0.8090169943749475, 
             0.29389262614623657`}, {-0.8506508083520399, 0, 
              0.8196237382653703}, {-0.2628655560595668, -0.8090169943749475, 
             0.8196237382653703}, {-0.2628655560595668, 0.8090169943749475, 
             0.8196237382653703}, {0.6881909602355868, -0.5, 
             0.8196237382653703}, {0.6881909602355868, 0.5, 
             0.8196237382653703}}], 
           Polygon3DBox[{{18, 16, 17, 19, 20}, {15, 16, 18}, {14, 17, 16}, {
             12, 19, 17}, {11, 20, 19}, {13, 18, 20}, {6, 2, 13}, {4, 8, 
             15}, {7, 3, 14}, {1, 5, 12}, {9, 10, 11}, {2, 4, 15, 18, 13}, {8,
              7, 14, 16, 15}, {3, 1, 12, 17, 14}, {5, 9, 11, 19, 12}, {10, 6, 
             13, 20, 11}, {10, 9, 5, 1, 3, 7, 8, 4, 2, 6}}]]],
         "\"pentagonal rotunda\""],
        Annotation[#, "pentagonal rotunda", "Tooltip"]& ],
       TraditionalForm], {589.8461538461538, -1372.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[{{-0.7074138486784932, -0.2998872468011181, \
-0.15479434163251038`}, {-0.6480925041002644, -0.10870506385028235`, 
           0.8249657598295737}, {-0.6183599657301097, 0.6430135066064443, 
           0.1661535905235797}, {-0.6112067488573701, -1.0525251057014975`, 
           0.4965734715657737}, {-0.16469460666749797`, 
           0.35720483837581274`, -0.6779442397963589}, \
{-0.0008162182475573551, -0.9938056576704114, -0.29334768055301486`}, {
           0.16671548432489697`, 0.46752042304967356`, 0.7601715537451216}, {
           0.22643953922699017`, -0.5090576456960382, 0.5512671343665216}, {
           0.2796776419676163, 1.0145836877807088`, -0.06935089575168729}, {
           0.5419030237634378, -0.33671357249348055`, -0.8164975787168633}, {
           0.7691587812379855, 0.14803443948089132`, 0.028117236202673368`}, {
           0.781521476760963, 0.6337071540306473, -0.8459358279062124}}, 
           Polygon3DBox[{{8, 6, 10, 11}, {7, 8, 11}, {4, 8, 2}, {4, 6, 8}, {
             11, 12, 9}, {11, 10, 12}, {2, 8, 7}, {7, 11, 9}, {5, 10, 6, 1}, {
             3, 5, 1}, {12, 5, 9}, {12, 10, 5}, {1, 4, 2}, {1, 6, 4}, {9, 3, 
             7}, {9, 5, 3}, {3, 2, 7}, {3, 1, 2}}]]],
         "\"sphenomegacorona\""],
        Annotation[#, "sphenomegacorona", "Tooltip"]& ],
       TraditionalForm], {983.0769230769231, -1372.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{Rational[-1, 2], Rational[-1, 2], -2^Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2], -2^Rational[-1, 2]}, {
             0, -2^Rational[-1, 2], 2^Rational[-1, 2]}, {
             0, 2^Rational[-1, 2], 2^Rational[-1, 2]}, {
             Rational[1, 2], Rational[-1, 2], -2^Rational[-1, 2]}, {
             Rational[1, 2], Rational[
              1, 2], -2^Rational[-1, 2]}, {-2^Rational[-1, 2], 0, 2^
              Rational[-1, 2]}, {2^Rational[-1, 2], 0, 2^Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 0}, {
             Rational[-1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 0}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[1, 2], 0}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2], 0}, {
             Rational[-1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 0}, {
             Rational[1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 0}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2], 0}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2], 
              0}}, {{-0.5, -0.5, -0.7071067811865475}, {-0.5, 
             0.5, -0.7071067811865475}, {
             0, -0.7071067811865475, 0.7071067811865475}, {
             0, 0.7071067811865475, 0.7071067811865475}, {
             0.5, -0.5, -0.7071067811865475}, {0.5, 
             0.5, -0.7071067811865475}, {-0.7071067811865475, 0, 
              0.7071067811865475}, {
             0.7071067811865475, 0, 0.7071067811865475}, {
             0.5, 1.2071067811865475`, 0}, {-0.5, 1.2071067811865475`, 
              0}, {-1.2071067811865475`, 0.5, 0}, {-1.2071067811865475`, -0.5,
               0}, {-0.5, -1.2071067811865475`, 0}, {
             0.5, -1.2071067811865475`, 0}, {1.2071067811865475`, -0.5, 0}, {
             1.2071067811865475`, 0.5, 0}}], 
           Polygon3DBox[{{4, 7, 3, 8}, {7, 4, 10, 11}, {3, 7, 12, 13}, {8, 3, 
             14, 15}, {4, 8, 16, 9}, {9, 10, 4}, {11, 12, 7}, {13, 14, 3}, {
             15, 16, 8}, {5, 1, 2, 6}, {10, 9, 6, 2}, {12, 11, 2, 1}, {14, 13,
              1, 5}, {16, 15, 5, 6}, {6, 9, 16}, {2, 11, 10}, {1, 13, 12}, {5,
              15, 14}}]]],
         "\"square gyrobicupola\""],
        Annotation[#, "square gyrobicupola", "Tooltip"]& ],
       TraditionalForm], {1376.3076923076924`, -1372.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, -2^Rational[-1, 2], -2^Rational[-1, 2]}, {
             0, -2^Rational[-1, 2], 2^Rational[-1, 2]}, {
             0, 2^Rational[-1, 2], -2^Rational[-1, 2]}, {
             0, 2^Rational[-1, 2], 2^Rational[-1, 2]}, {-2^Rational[-1, 2], 
              0, -2^Rational[-1, 2]}, {-2^Rational[-1, 2], 0, 2^
              Rational[-1, 2]}, {2^Rational[-1, 2], 0, -2^Rational[-1, 2]}, {
             2^Rational[-1, 2], 0, 2^Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 0}, {
             Rational[-1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 0}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[1, 2], 0}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2], 0}, {
             Rational[-1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 0}, {
             Rational[1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 0}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2], 0}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2], 0}}, {{
             0, -0.7071067811865475, -0.7071067811865475}, {
             0, -0.7071067811865475, 0.7071067811865475}, {
             0, 0.7071067811865475, -0.7071067811865475}, {
             0, 0.7071067811865475, 0.7071067811865475}, {-0.7071067811865475,
               0, -0.7071067811865475}, {-0.7071067811865475, 0, 
              0.7071067811865475}, {
             0.7071067811865475, 0, -0.7071067811865475}, {
             0.7071067811865475, 0, 0.7071067811865475}, {
             0.5, 1.2071067811865475`, 0}, {-0.5, 1.2071067811865475`, 
              0}, {-1.2071067811865475`, 0.5, 0}, {-1.2071067811865475`, -0.5,
               0}, {-0.5, -1.2071067811865475`, 0}, {
             0.5, -1.2071067811865475`, 0}, {1.2071067811865475`, -0.5, 0}, {
             1.2071067811865475`, 0.5, 0}}], 
           Polygon3DBox[{{4, 6, 2, 8}, {6, 4, 10, 11}, {2, 6, 12, 13}, {8, 2, 
             14, 15}, {4, 8, 16, 9}, {9, 10, 4}, {11, 12, 6}, {13, 14, 2}, {
             15, 16, 8}, {7, 1, 5, 3}, {11, 10, 3, 5}, {13, 12, 5, 1}, {15, 
             14, 1, 7}, {9, 16, 7, 3}, {3, 10, 9}, {5, 12, 11}, {1, 14, 13}, {
             7, 16, 15}}]]],
         "\"square orthobicupola\""],
        Annotation[#, "square orthobicupola", "Tooltip"]& ],
       TraditionalForm], {1769.5384615384614`, -1372.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, -2^Rational[-1, 2], 2^Rational[-1, 2] + 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             0, 2^Rational[-1, 2], 2^Rational[-1, 2] + 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {-2^
               Rational[-1, 2], 0, 2^Rational[-1, 2] + 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             2^Rational[-1, 2], 0, 2^Rational[-1, 2] + 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), -1 + 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[-1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), -1 + 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[-1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[1, 2], -1 + 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2], -1 + 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[-1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), -1 + 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[-1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), -1 + 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2], -1 + 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2], -1 + 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 376] (167 - 44 2^Rational[1, 2])}}, {{
             0, -0.7071067811865475, 0.9857626409088449}, {
             0, 0.7071067811865475, 0.9857626409088449}, {-0.7071067811865475,
               0, 0.9857626409088449}, {
             0.7071067811865475, 0, 0.9857626409088449}, {0.5, 
             1.2071067811865475`, -0.7213441402777026}, {0.5, 
             1.2071067811865475`, 0.2786558597222974}, {-0.5, 
             1.2071067811865475`, -0.7213441402777026}, {-0.5, 
             1.2071067811865475`, 0.2786558597222974}, {-1.2071067811865475`, 
             0.5, -0.7213441402777026}, {-1.2071067811865475`, 0.5, 
             
             0.2786558597222974}, {-1.2071067811865475`, -0.5, \
-0.7213441402777026}, {-1.2071067811865475`, -0.5, 
             0.2786558597222974}, {-0.5, -1.2071067811865475`, \
-0.7213441402777026}, {-0.5, -1.2071067811865475`, 0.2786558597222974}, {
             0.5, -1.2071067811865475`, -0.7213441402777026}, {
             0.5, -1.2071067811865475`, 0.2786558597222974}, {
             1.2071067811865475`, -0.5, -0.7213441402777026}, {
             1.2071067811865475`, -0.5, 0.2786558597222974}, {
             1.2071067811865475`, 0.5, -0.7213441402777026}, {
             1.2071067811865475`, 0.5, 0.2786558597222974}}], 
           Polygon3DBox[{{3, 2, 8, 10}, {1, 3, 12, 14}, {4, 1, 16, 18}, {2, 4,
              20, 6}, {6, 8, 2}, {10, 12, 3}, {14, 16, 1}, {18, 20, 4}, {2, 3,
              1, 4}, {19, 17, 15, 13, 11, 9, 7, 5}, {5, 7, 8, 6}, {7, 9, 10, 
             8}, {9, 11, 12, 10}, {11, 13, 14, 12}, {13, 15, 16, 14}, {15, 17,
              18, 16}, {17, 19, 20, 18}, {19, 5, 6, 20}}]]],
         "\"elongated square cupola\""],
        Annotation[#, "elongated square cupola", "Tooltip"]& ],
       TraditionalForm], {2162.7692307692305`, -1372.}, {Center, Center}, {359.9999999999998, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{-1, 0, -(-1 + 3^Rational[1, 2])^Rational[1, 2] + 
              Rational[
                1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                 90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                  Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] 
              3^Rational[1, 2], -(-1 + 3^Rational[1, 2])^Rational[1, 2] + 
              Rational[
                1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                 90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                  Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2] 
              3^Rational[1, 2], -(-1 + 3^Rational[1, 2])^Rational[1, 2] + 
              Rational[
                1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                 90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                  Rational[1, 2])^Rational[1, 2]}, {
             0, -1, Rational[
               1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                 Rational[1, 2])^Rational[1, 2]}, {
             0, 1, Rational[
               1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                 Rational[1, 2])^Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2] 
              3^Rational[1, 2], -(-1 + 3^Rational[1, 2])^Rational[1, 2] + 
              Rational[
                1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                 90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                  Rational[1, 2])^Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2] 
              3^Rational[1, 2], -(-1 + 3^Rational[1, 2])^Rational[1, 2] + 
              Rational[
                1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                 90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                  Rational[1, 2])^Rational[1, 2]}, {
             1, 0, -(-1 + 3^Rational[1, 2])^Rational[1, 2] + 
              Rational[
                1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                 90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                  Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[2, 3]^Rational[1, 2] + 
              Rational[
                1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                 90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                  Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[2, 3]^Rational[1, 2] + 
              Rational[
                1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                 90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                  Rational[1, 2])^Rational[1, 2]}, {
             3^Rational[-1, 2], 0, Rational[2, 3]^Rational[1, 2] + 
              Rational[
                1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                 90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                  Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[
               1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                 Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[
               1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                 Rational[1, 2])^Rational[1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[
               1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                 Rational[1, 2])^Rational[1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[
               1, 15068] (Rational[34388823, 2] + 12170346 3^Rational[1, 2] - 
                90 (-1281344819375 + 807276361713 3^Rational[1, 2])^
                 Rational[1, 2])^Rational[1, 2]}}, {{-1, 
              0, -0.6738174158574366}, {-0.5, -0.8660254037844386, \
-0.6738174158574366}, {-0.5, 0.8660254037844386, -0.6738174158574366}, {
             0, -1, 0.18178226130991548`}, {0, 1, 0.18178226130991548`}, {
             0.5, -0.8660254037844386, -0.6738174158574366}, {0.5, 
             0.8660254037844386, -0.6738174158574366}, {
             1, 0, -0.6738174158574366}, {-0.2886751345948129, -0.5, 
             0.9982788422376415}, {-0.2886751345948129, 0.5, 
             0.9982788422376415}, {
             0.5773502691896258, 0, 
              0.9982788422376415}, {-0.8660254037844386, -0.5, 
             0.18178226130991548`}, {-0.8660254037844386, 0.5, 
             0.18178226130991548`}, {0.8660254037844386, -0.5, 
             0.18178226130991548`}, {0.8660254037844386, 0.5, 
             0.18178226130991548`}}], 
           Polygon3DBox[{{3, 7, 8, 6, 2, 1}, {1, 2, 12}, {2, 6, 4}, {6, 8, 
             14}, {8, 7, 15}, {7, 3, 5}, {3, 1, 13}, {2, 4, 12}, {6, 14, 4}, {
             8, 15, 14}, {7, 5, 15}, {3, 13, 5}, {1, 12, 13}, {10, 9, 11}, {9,
              10, 13, 12}, {11, 9, 4, 14}, {10, 11, 15, 5}, {5, 13, 10}, {12, 
             4, 9}, {14, 15, 11}}]]],
         "\"gyroelongated triangular cupola\""],
        Annotation[#, "gyroelongated triangular cupola", "Tooltip"]& ],
       TraditionalForm], {2556., -1372.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[{{-0.9601329154398749, 
           0.715228827607169, -0.038940340478218406`}, {-0.8187282992850485, 
           0.16130517672676778`, -0.8594117437126204}, {-0.7611144360244372, 
           0.3324336895940013, 0.8632012931717644}, {-0.5479424211554954, 
           1.1239249279664272`, -0.8532292904049141}, {-0.47830520371478974`, \
-0.7754136121667969, -0.7777415132970539}, {-0.4206913404541757, \
-0.604285099299567, 
           0.9448715235873327}, {-0.27928672429935203`, -1.158208750179968, 
           0.12440012035291889`}, {-0.18156919050129358`, 1.336062427757598, 
           0.05273390417913578}, {-0.026905148726201384`, 
           0.12175399793315325`, 1.508608753592473}, {0.01744934059955831, 
           0.9532667741322984, 0.9548758259169691}, {0.04722853458733749, 
           0.43979375739903803`, -1.2748180091772525`}, {
           0.34329703413956375`, -1.3284373060931192`, -0.6394137983994109}, {
           0.3876519127990416, -0.4969254544690647, -1.1931480832747694`}, {
           0.568266260917956, -0.5623777208013869, 1.087021565146125}, {
           0.6400338013331498, 0.7830391754875077, 0.19106203932993235`}, {
           0.7096707041513745, -1.116301423393658, 0.2665495971587358}, {
           0.7814386781557835, 0.22911425565242435`, -0.6294107944859267}, {
           0.9804569718616517, -0.15368159140503465`, 0.27273270035205593`}}, 
           Polygon3DBox[{{12, 13, 17, 18, 16}, {13, 12, 5}, {12, 7, 5}, {7, 
             12, 16}, {7, 16, 14, 6}, {14, 16, 18}, {9, 14, 18, 15, 10}, {6, 
             14, 9}, {3, 6, 9}, {3, 9, 10}, {8, 10, 15}, {3, 10, 8, 1}, {17, 
             15, 18}, {17, 11, 4, 8, 15}, {4, 1, 8}, {4, 2, 1}, {2, 4, 11}, {
             13, 5, 2, 11}, {13, 11, 17}, {2, 5, 7, 6, 3, 1}}]]],
         "\"triangular hebesphenorotunda\""],
        Annotation[#, "triangular hebesphenorotunda", "Tooltip"]& ],
       TraditionalForm], {2949.2307692307686`, -1372.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, -1, Rational[-1, 2]}, {0, -1, Rational[1, 2]}, {
             0, 1, Rational[-1, 2]}, {0, 1, Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[1, 6] (-3 - 2 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[1, 6] (3 + 2 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[1, 6] (-3 - 2 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[1, 6] (3 + 2 6^Rational[1, 2])}, {
             3^Rational[-1, 2], 0, 
              Rational[1, 6] (-3 - 2 6^Rational[1, 2])}, {
             3^Rational[-1, 2], 0, Rational[1, 6] (3 + 2 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2], Rational[
              1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[1, 2], Rational[
              1, 2]}}, {{0, -1, -0.5}, {0, -1, 0.5}, {0, 1, -0.5}, {
             0, 1, 0.5}, {-0.2886751345948129, -0.5, -1.3164965809277258`}, \
{-0.2886751345948129, -0.5, 1.3164965809277258`}, {-0.2886751345948129, 
             0.5, -1.3164965809277258`}, {-0.2886751345948129, 0.5, 
             1.3164965809277258`}, {
             0.5773502691896258, 0, -1.3164965809277258`}, {
             0.5773502691896258, 0, 
              1.3164965809277258`}, {-0.8660254037844386, -0.5, -0.5}, \
{-0.8660254037844386, -0.5, 0.5}, {-0.8660254037844386, 
             0.5, -0.5}, {-0.8660254037844386, 0.5, 0.5}, {
             0.8660254037844386, -0.5, -0.5}, {0.8660254037844386, -0.5, 
             0.5}, {0.8660254037844386, 0.5, -0.5}, {0.8660254037844386, 0.5, 
             0.5}}], 
           Polygon3DBox[{{6, 8, 14, 12}, {10, 6, 2, 16}, {8, 10, 18, 4}, {4, 
             14, 8}, {12, 2, 6}, {16, 18, 10}, {8, 6, 10}, {11, 13, 7, 5}, {
             15, 1, 5, 9}, {3, 17, 9, 7}, {7, 13, 3}, {5, 1, 11}, {9, 17, 
             15}, {9, 5, 7}, {3, 13, 14, 4}, {13, 11, 12, 14}, {11, 1, 2, 
             12}, {1, 15, 16, 2}, {15, 17, 18, 16}, {17, 3, 4, 18}}]]],
         "\"elongated triangular orthobicupola\""],
        Annotation[#, "elongated triangular orthobicupola", "Tooltip"]& ],
       TraditionalForm], {3342.461538461538, -1372.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, -1, Rational[-1, 2]}, {0, -1, Rational[1, 2]}, {
             0, 1, Rational[-1, 2]}, {0, 1, Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[1, 6] (3 + 2 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[1, 6] (3 + 2 6^Rational[1, 2])}, {
             Rational[1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[1, 6] (-3 - 2 6^Rational[1, 2])}, {
             3^Rational[-1, 2], 0, Rational[1, 6] (3 + 2 6^Rational[1, 2])}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2], Rational[
              1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[1, 2], Rational[
              1, 2]}, {-3^Rational[-1, 2], 0, 
              Rational[1, 6] (-3 - 2 6^Rational[1, 2])}, {
             Rational[1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[1, 6] (-3 - 2 6^Rational[1, 2])}}, {{0, -1, -0.5}, {
             0, -1, 0.5}, {0, 1, -0.5}, {
             0, 1, 0.5}, {-0.2886751345948129, -0.5, 
             1.3164965809277258`}, {-0.2886751345948129, 0.5, 
             1.3164965809277258`}, {
             0.2886751345948129, -0.5, -1.3164965809277258`}, {
             0.5773502691896258, 0, 
              1.3164965809277258`}, {-0.8660254037844386, -0.5, -0.5}, \
{-0.8660254037844386, -0.5, 0.5}, {-0.8660254037844386, 
             0.5, -0.5}, {-0.8660254037844386, 0.5, 0.5}, {
             0.8660254037844386, -0.5, -0.5}, {0.8660254037844386, -0.5, 
             0.5}, {0.8660254037844386, 0.5, -0.5}, {0.8660254037844386, 0.5, 
             0.5}, {-0.5773502691896258, 0, -1.3164965809277258`}, {
             0.2886751345948129, 0.5, -1.3164965809277258`}}], 
           Polygon3DBox[{{6, 5, 8}, {5, 6, 12, 10}, {8, 5, 2, 14}, {6, 8, 16, 
             4}, {4, 12, 6}, {10, 2, 5}, {14, 16, 8}, {7, 17, 18}, {11, 3, 18,
              17}, {1, 9, 17, 7}, {15, 13, 7, 18}, {18, 3, 15}, {17, 9, 11}, {
             7, 13, 1}, {3, 11, 12, 4}, {11, 9, 10, 12}, {9, 1, 2, 10}, {1, 
             13, 14, 2}, {13, 15, 16, 14}, {15, 3, 4, 16}}]]],
         "\"elongated triangular gyrobicupola\""],
        Annotation[#, "elongated triangular gyrobicupola", "Tooltip"]& ],
       TraditionalForm], {3735.6923076923067`, -1372.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, 0, Root[9 - 36 #^2 + 16 #^4& , 4, 0]}, {
             0, 0, Root[9 - 36 #^2 + 16 #^4& , 1, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 3, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
              1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 3, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
              1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
              25 - 180 #^2 + 144 #^4& , 1, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
              25 - 180 #^2 + 144 #^4& , 1, 0]}, {
             Root[25 - 180 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
              1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Root[25 - 180 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
              1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 216 #^2 + 144 #^4& , 1, 0], Rational[-1, 2], Root[
              1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 216 #^2 + 144 #^4& , 1, 0], Rational[1, 2], Root[
              1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 216 #^2 + 144 #^4& , 4, 0], Rational[-1, 2], Root[
              1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Root[1 - 216 #^2 + 144 #^4& , 4, 0], Rational[1, 2], Root[
              1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Root[1 - 9 #^2 + 9 #^4& , 1, 0], 0, Root[
              25 - 180 #^2 + 144 #^4& , 1, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 1, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
              25 - 180 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 1, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
              25 - 180 #^2 + 144 #^4& , 4, 0]}, {
             Root[1 - 9 #^2 + 9 #^4& , 4, 0], 0, Root[
              25 - 180 #^2 + 144 #^4& , 4, 0]}, {
             Root[25 - 180 #^2 + 144 #^4& , 1, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
              1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Root[25 - 180 #^2 + 144 #^4& , 1, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
              1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Root[121 - 345 #^2 + 225 #^4& , 4, 0], 0, Root[
              121 - 6180 #^2 + 3600 #^4& , 1, 0]}, {
             Root[121 - 345 #^2 + 225 #^4& , 1, 0], 0, Root[
              121 - 6180 #^2 + 3600 #^4& , 4, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
              1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
              1 - 36 #^2 + 144 #^4& , 1, 0]}}, {{0, 0, 1.4012585384440737`}, {
             0, 0, -1.4012585384440737`}, {
             0.17841104488654494`, -1.3090169943749475`, 
             0.46708617948135783`}, {0.17841104488654494`, 
             1.3090169943749475`, 0.46708617948135783`}, {
             0.46708617948135783`, -0.8090169943749475, \
-1.0444364486709836`}, {0.46708617948135783`, 
             0.8090169943749475, -1.0444364486709836`}, {
             1.0444364486709836`, -0.8090169943749475, 
             0.46708617948135783`}, {1.0444364486709836`, 0.8090169943749475, 
             0.46708617948135783`}, {-1.2228474935575286`, -0.5, 
             0.46708617948135783`}, {-1.2228474935575286`, 0.5, 
             0.46708617948135783`}, {
             1.2228474935575286`, -0.5, -0.46708617948135783`}, {
             1.2228474935575286`, 
             0.5, -0.46708617948135783`}, {-0.9341723589627158, 
              0, -1.0444364486709836`}, {-0.46708617948135783`, \
-0.8090169943749475, 1.0444364486709836`}, {-0.46708617948135783`, 
             0.8090169943749475, 1.0444364486709836`}, {
             0.9341723589627158, 0, 
              1.0444364486709836`}, {-1.0444364486709836`, \
-0.8090169943749475, -0.46708617948135783`}, {-1.0444364486709836`, 
             0.8090169943749475, -0.46708617948135783`}, {
             0.9951248486580193, 
              0, -1.3026353384181446`}, {-0.995124848658019, 0, 
              1.3026353384181446`}, {-0.17841104488654494`, \
-1.3090169943749475`, -0.46708617948135783`}, {-0.17841104488654494`, 
             1.3090169943749475`, -0.46708617948135783`}}], 
           Polygon3DBox[{{5, 11, 7, 3, 21}, {11, 12, 8, 16, 7}, {12, 6, 22, 4,
              8}, {6, 2, 13, 18, 22}, {2, 5, 21, 17, 13}, {4, 22, 18, 10, 
             15}, {18, 13, 17, 9, 10}, {17, 21, 3, 14, 9}, {3, 7, 16, 1, 
             14}, {16, 8, 4, 15, 1}, {20, 15, 10}, {20, 10, 9}, {20, 9, 14}, {
             20, 14, 1}, {20, 1, 15}, {19, 2, 6}, {19, 6, 12}, {19, 12, 11}, {
             19, 11, 5}, {19, 5, 2}}]]],
         "\"parabiaugmented dodecahedron\""],
        Annotation[#, "parabiaugmented dodecahedron", "Tooltip"]& ],
       TraditionalForm], {4128.923076923076, -1372.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2], 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[9 - 36 #^2 + 16 #^4& , 4, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2], 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[9 - 36 #^2 + 16 #^4& , 1, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[1 - 36 #^2 + 144 #^4& , 3, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[1 - 36 #^2 + 144 #^4& , 3, 0], 
              Rational[1, 32] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[1 - 36 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 1, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[1 - 36 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 32] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 1, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[25 - 180 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[25 - 180 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 32] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[1 - 216 #^2 + 144 #^4& , 1, 0], Rational[-1, 2] + 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[1 - 216 #^2 + 144 #^4& , 1, 0], Rational[1, 2] + 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[1 - 216 #^2 + 144 #^4& , 4, 0], Rational[-1, 2] + 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[1 - 216 #^2 + 144 #^4& , 4, 0], Rational[1, 2] + 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[1 - 9 #^2 + 9 #^4& , 1, 0], 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 1, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[1 - 36 #^2 + 144 #^4& , 1, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 4, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[1 - 36 #^2 + 144 #^4& , 1, 0], 
              Rational[1, 32] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 4, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[1 - 9 #^2 + 9 #^4& , 4, 0], 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 4, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[25 - 180 #^2 + 144 #^4& , 1, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[25 - 180 #^2 + 144 #^4& , 1, 0], 
              Rational[1, 32] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[121 - 345 #^2 + 225 #^4& , 1, 0], 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[121 - 6180 #^2 + 3600 #^4& , 4, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
              Rational[1, 32] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Rational[1, 8] (6 (47 + 21 5^Rational[1, 2]))^Rational[-1, 2] + 
              Root[121 - 2520 #^2 + 3600 #^4& , 4, 0], 
              Rational[1, 10] (-5 - 4 5^Rational[1, 2]) + 
              Rational[1, 32] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 8] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[121 - 1620 #^2 + 3600 #^4& , 2, 0]}}, {{
            0.005264641816248859, 0.03862712429686843, 1.3736925160170066`}, {
            0.005264641816248859, 
            0.03862712429686843, -1.4288245608711407`}, {
            0.1836756867027938, -1.2703898700780791`, 0.43952015705429087`}, {
            0.1836756867027938, 1.3476441186718158`, 0.43952015705429087`}, {
            0.4723508212976067, -0.770389870078079, -1.0720024710980507`}, {
            0.4723508212976067, 0.8476441186718159, -1.0720024710980507`}, {
            1.0497010904872324`, -0.770389870078079, 0.43952015705429087`}, {
            1.0497010904872324`, 0.8476441186718159, 
            0.43952015705429087`}, {-1.21758285174128, -0.46137287570313157`, 
            0.43952015705429087`}, {-1.21758285174128, 0.5386271242968684, 
            0.43952015705429087`}, {
            1.2281121353737774`, -0.46137287570313157`, -0.4946522019084248}, \
{1.2281121353737774`, 
            0.5386271242968684, -0.4946522019084248}, {-0.9289077171464669, 
            0.03862712429686843, -1.0720024710980507`}, \
{-0.46182153766510897`, -0.770389870078079, 
            1.0168704262439165`}, {-0.46182153766510897`, 0.8476441186718159, 
            1.0168704262439165`}, {0.9394370007789646, 0.03862712429686843, 
            1.0168704262439165`}, {-1.0391718068547349`, -0.770389870078079, \
-0.4946522019084248}, {-1.0391718068547349`, 
            0.8476441186718159, -0.4946522019084248}, {-0.9898602068417701, 
            0.03862712429686843, 
            1.2750693159910775`}, {-0.17314640307029608`, \
-1.2703898700780791`, -0.4946522019084248}, {-0.17314640307029608`, 
            1.3476441186718158`, -0.4946522019084248}, {
            0.8103375559053839, -1.3558000667030474`, -0.3350765121871925}}], 
           Polygon3DBox[{{2, 6, 12, 11, 5}, {11, 12, 8, 16, 7}, {12, 6, 21, 4,
              8}, {6, 2, 13, 18, 21}, {2, 5, 20, 17, 13}, {4, 21, 18, 10, 
             15}, {18, 13, 17, 9, 10}, {17, 20, 3, 14, 9}, {3, 7, 16, 1, 
             14}, {16, 8, 4, 15, 1}, {19, 15, 10}, {19, 10, 9}, {19, 9, 14}, {
             19, 14, 1}, {19, 1, 15}, {22, 5, 11}, {22, 11, 7}, {22, 7, 3}, {
             22, 3, 20}, {22, 20, 5}}]]],
         "\"metabiaugmented dodecahedron\""],
        Annotation[#, "metabiaugmented dodecahedron", "Tooltip"]& ],
       TraditionalForm], {4522.153846153846, -1372.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[{{-0.8715058121691427, 
           0.1405344982638719, -0.010013501014237834`}, {-0.7340524446984583, \
-0.8444552990728706, -0.1144087983788448}, {-0.661762502745297, \
-0.4225314526555028, 
           0.7893352558818149}, {-0.6041325343394331, -0.23575409584233784`, \
-0.8970977271439614}, {-0.4680612025830643, 0.5584170709505638, 
           0.8039930115154174}, {-0.18106525424646336`, 
           0.8575210290255579, -0.10604553047181745`}, {0.08630802358324619, 
           0.4812324349193487, -0.9931297566015392}, {
           0.11001543981793194`, -0.8901898159171224, -0.6486896771594076}, {
           0.15235659626470388`, -0.797719416565912, 0.3461251054582305}, {
           0.2460819357429923, -0.0960142944774633, 1.0523988056797258`}, {
           0.49218253717003047`, 0.7757803228691322, 0.6288352927872572}, {
           0.7867060534050055, 0.7347731329330915, -0.3259281293508386}, {
           0.8004559977406117, -0.1732032851554368, -0.7447217066169863}, {
           0.8427971541873832, -0.0807328858042264, 0.2500930760006509}}, 
           Polygon3DBox[{{9, 8, 13, 14}, {10, 9, 14}, {2, 9, 3}, {2, 8, 9}, {
             14, 12, 11}, {14, 13, 12}, {3, 9, 10}, {10, 14, 11}, {4, 7, 13, 
             8}, {13, 7, 12}, {4, 8, 2}, {6, 7, 4, 1}, {5, 6, 1}, {12, 6, 
             11}, {12, 7, 6}, {1, 2, 3}, {1, 4, 2}, {11, 5, 10}, {11, 6, 5}, {
             5, 3, 10}, {5, 1, 3}}]]],
         "\"hebesphenomegacorona\""],
        Annotation[#, "hebesphenomegacorona", "Tooltip"]& ],
       TraditionalForm], {196.6153846153846, -1764.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, Rational[1, 2] (-1 - 5^Rational[1, 2]), 0}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), 
              0}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 2], (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[
               1, 2]}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[
              1, 2], (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], -(Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], -(Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              0, -(Rational[1, 10] (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {(
               Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], 0, (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (-1 - 5^
               Rational[1, 2]), -(Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (1 + 
               5^Rational[1, 2]), -(Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), (
               Rational[1, 10] (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), (
               Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[
               1, 2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              0}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              0}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], 
              0}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              0}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], 0}}, {{
             0, -1.618033988749895, 0}, {
             0, 1.618033988749895, 0}, {-0.6881909602355868, -0.5, 
             0.5257311121191336}, {-0.6881909602355868, 0.5, 
             0.5257311121191336}, {
             0.6881909602355868, -0.5, -0.5257311121191336}, {
             0.6881909602355868, 
             0.5, -0.5257311121191336}, {-0.8506508083520399, 
              0, -0.5257311121191336}, {
             0.8506508083520399, 0, 
              0.5257311121191336}, {-0.2628655560595668, -0.8090169943749475, \
-0.5257311121191336}, {-0.2628655560595668, 
             0.8090169943749475, -0.5257311121191336}, {
             0.2628655560595668, -0.8090169943749475, 0.5257311121191336}, {
             0.2628655560595668, 0.8090169943749475, 
             0.5257311121191336}, {-0.9510565162951535, -1.3090169943749475`, 
              0}, {-0.9510565162951535, 1.3090169943749475`, 0}, {
             0.9510565162951535, -1.3090169943749475`, 0}, {
             0.9510565162951535, 1.3090169943749475`, 
              0}, {-1.5388417685876268`, -0.5, 0}, {-1.5388417685876268`, 0.5,
               0}, {1.5388417685876268`, -0.5, 0}, {
             1.5388417685876268`, 0.5, 0}}], 
           Polygon3DBox[{{12, 4, 3, 11, 8}, {4, 12, 2, 14}, {3, 4, 18, 17}, {
             11, 3, 13, 1}, {8, 11, 15, 19}, {12, 8, 20, 16}, {16, 2, 12}, {
             14, 18, 4}, {17, 13, 3}, {1, 15, 11}, {19, 20, 8}, {5, 9, 7, 10, 
             6}, {2, 16, 6, 10}, {18, 14, 10, 7}, {13, 17, 7, 9}, {15, 1, 9, 
             5}, {20, 19, 5, 6}, {6, 16, 20}, {10, 14, 2}, {7, 17, 18}, {9, 1,
              13}, {5, 19, 15}}]]],
         "\"pentagonal gyrobicupola\""],
        Annotation[#, "pentagonal gyrobicupola", "Tooltip"]& ],
       TraditionalForm], {589.8461538461538, -1764.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, Rational[1, 2] (-1 - 5^Rational[1, 2]), 0}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), 
              0}, {(Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], 
              0, -(Rational[1, 10] (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {(
               Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], 0, (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (-1 - 5^
               Rational[1, 2]), -(Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), (
               Rational[1, 10] (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (1 + 
               5^Rational[1, 2]), -(Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), (
               Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[
               1, 2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              0}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[-1, 2], -(Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[
               1, 2]}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[
              1, 2], -(Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[
               1, 2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              0}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], 
              0}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              0}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], 0}}, {{
             0, -1.618033988749895, 0}, {0, 1.618033988749895, 0}, {
             0.8506508083520399, 0, -0.5257311121191336}, {
             0.8506508083520399, 0, 0.5257311121191336}, {
             0.2628655560595668, -0.8090169943749475, -0.5257311121191336}, {
             0.2628655560595668, -0.8090169943749475, 0.5257311121191336}, {
             0.2628655560595668, 0.8090169943749475, -0.5257311121191336}, {
             0.2628655560595668, 0.8090169943749475, 
             0.5257311121191336}, {-0.9510565162951535, -1.3090169943749475`, 
              0}, {-0.9510565162951535, 1.3090169943749475`, 0}, {
             0.9510565162951535, -1.3090169943749475`, 0}, {
             0.9510565162951535, 1.3090169943749475`, 
              0}, {-0.6881909602355868, -0.5, -0.5257311121191336}, \
{-0.6881909602355868, -0.5, 0.5257311121191336}, {-0.6881909602355868, 
             0.5, -0.5257311121191336}, {-0.6881909602355868, 0.5, 
             0.5257311121191336}, {-1.5388417685876268`, -0.5, 
              0}, {-1.5388417685876268`, 0.5, 0}, {
             1.5388417685876268`, -0.5, 0}, {1.5388417685876268`, 0.5, 0}}], 
           Polygon3DBox[{{8, 16, 14, 6, 4}, {16, 8, 2, 10}, {14, 16, 18, 
             17}, {6, 14, 9, 1}, {4, 6, 11, 19}, {8, 4, 20, 12}, {12, 2, 8}, {
             10, 18, 16}, {17, 9, 14}, {1, 11, 6}, {19, 20, 4}, {3, 5, 13, 15,
              7}, {10, 2, 7, 15}, {17, 18, 15, 13}, {1, 9, 13, 5}, {19, 11, 5,
              3}, {12, 20, 3, 7}, {7, 2, 12}, {15, 18, 10}, {13, 9, 17}, {5, 
             11, 1}, {3, 20, 19}}]]],
         "\"pentagonal orthobicupola\""],
        Annotation[#, "pentagonal orthobicupola", "Tooltip"]& ],
       TraditionalForm], {983.0769230769231, -1764.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), -1 + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[1, 319840] (154425 - 45 
               5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
               Rational[1, 2])}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), -1 + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[1, 319840] (154425 - 45 
               5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
               Rational[1, 2])}, {(Rational[1, 2] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              0, (Rational[1, 10] (5 - 5^Rational[1, 2]))^Rational[1, 2] + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (-1 - 5^
               Rational[1, 2]), (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2] + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (1 + 
               5^Rational[1, 2]), (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2] + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {-(Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), -1 + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {-(Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 319840] (154425 - 45 
               5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
               Rational[1, 2])}, {-(Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), -1 + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {-(Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 319840] (154425 - 45 
               5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
               Rational[1, 2])}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), -1 + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 319840] (154425 - 45 
               5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
               Rational[1, 2])}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), -1 + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 319840] (154425 - 45 
               5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
               Rational[1, 2])}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2] + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], (Rational[1, 10] (5 - 5^Rational[1, 2]))^Rational[1, 2] + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {-(Rational[5, 4] + 
                Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], -1 + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {-(Rational[5, 4] + 
                Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Rational[1, 319840] (154425 - 45 
               5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
               Rational[1, 2])}, {-(Rational[5, 4] + 
                Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], -1 + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {-(Rational[5, 4] + 
                Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[1, 319840] (154425 - 45 
               5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
               Rational[1, 2])}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], -1 + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Rational[1, 319840] (154425 - 45 
               5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
               Rational[1, 2])}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], -1 + 
              Rational[1, 319840] (154425 - 45 
                5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
                Rational[1, 2])}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[1, 319840] (154425 - 45 
               5^Rational[1, 2] - (2650294450 - 213518390 5^Rational[1, 2])^
               Rational[1, 2])}}, {{
             0, -1.618033988749895, -0.663236281910152}, {
             0, -1.618033988749895, 0.3367637180898479}, {
             0, 1.618033988749895, -0.663236281910152}, {
             0, 1.618033988749895, 0.3367637180898479}, {
             0.8506508083520399, 0, 0.8624948302089814}, {
             0.2628655560595668, -0.8090169943749475, 0.8624948302089814}, {
             0.2628655560595668, 0.8090169943749475, 
             0.8624948302089814}, {-0.9510565162951535, -1.3090169943749475`, \
-0.663236281910152}, {-0.9510565162951535, -1.3090169943749475`, 
             0.3367637180898479}, {-0.9510565162951535, 
             1.3090169943749475`, -0.663236281910152}, {-0.9510565162951535, 
             1.3090169943749475`, 0.3367637180898479}, {
             0.9510565162951535, -1.3090169943749475`, -0.663236281910152}, {
             0.9510565162951535, -1.3090169943749475`, 0.3367637180898479}, {
             0.9510565162951535, 1.3090169943749475`, -0.663236281910152}, {
             0.9510565162951535, 1.3090169943749475`, 
             0.3367637180898479}, {-0.6881909602355868, -0.5, 
             0.8624948302089814}, {-0.6881909602355868, 0.5, 
             0.8624948302089814}, {-1.5388417685876268`, -0.5, \
-0.663236281910152}, {-1.5388417685876268`, -0.5, 
             0.3367637180898479}, {-1.5388417685876268`, 
             0.5, -0.663236281910152}, {-1.5388417685876268`, 0.5, 
             0.3367637180898479}, {
             1.5388417685876268`, -0.5, -0.663236281910152}, {
             1.5388417685876268`, -0.5, 0.3367637180898479}, {
             1.5388417685876268`, 0.5, -0.663236281910152}, {
             1.5388417685876268`, 0.5, 0.3367637180898479}}], 
           Polygon3DBox[{{17, 7, 4, 11}, {16, 17, 21, 19}, {6, 16, 9, 2}, {5, 
             6, 13, 23}, {7, 5, 25, 15}, {15, 4, 7}, {11, 21, 17}, {19, 9, 
             16}, {2, 13, 6}, {23, 25, 5}, {7, 17, 16, 6, 5}, {24, 22, 12, 1, 
             8, 18, 20, 10, 3, 14}, {14, 3, 4, 15}, {3, 10, 11, 4}, {10, 20, 
             21, 11}, {20, 18, 19, 21}, {18, 8, 9, 19}, {8, 1, 2, 9}, {1, 12, 
             13, 2}, {12, 22, 23, 13}, {22, 24, 25, 23}, {24, 14, 15, 25}}]]],
         
         "\"elongated pentagonal cupola\""],
        Annotation[#, "elongated pentagonal cupola", "Tooltip"]& ],
       TraditionalForm], {1376.3076923076924`, -1764.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[-1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[-1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[-1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             0, -2^Rational[-1, 2], Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (1 + 2 2^Rational[1, 2])}, {
             0, 2^Rational[-1, 2], Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (1 + 2 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {-2^Rational[-1, 2], 0, 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (1 + 2 2^Rational[1, 2])}, {
             2^Rational[-1, 2], 0, Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (1 + 2 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2] + 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2] + 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2] + 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[1, 2] + 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2]) + 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2] + 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2] + 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2] + 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[1, 2] + 
              Rational[1, 64] (-9 - 2 2^Rational[1, 2])}}, {{-0.5, 
             1.2071067811865475`, -1.3919259550107066`}, {-0.5, 
             1.2071067811865475`, 
             1.0222876073623883`}, {-0.5, -1.2071067811865475`, \
-1.3919259550107066`}, {-0.5, -1.2071067811865475`, 1.0222876073623883`}, {
             0, -0.7071067811865475, 1.729394388548936}, {
             0, 0.7071067811865475, 1.729394388548936}, {0.5, 
             1.2071067811865475`, -1.3919259550107066`}, {0.5, 
             1.2071067811865475`, 1.0222876073623883`}, {
             0.5, -1.2071067811865475`, -1.3919259550107066`}, {
             0.5, -1.2071067811865475`, 
             1.0222876073623883`}, {-0.7071067811865475, 0, 
              1.729394388548936}, {
             0.7071067811865475, 0, 1.729394388548936}, {
             1.2071067811865475`, -0.5, -1.3919259550107066`}, {
             1.2071067811865475`, -0.5, 1.0222876073623883`}, {
             1.2071067811865475`, 0.5, -1.3919259550107066`}, {
             1.2071067811865475`, 0.5, 1.0222876073623883`}, {
             1.2071067811865475`, 1.2071067811865475`, -0.6848191738241592}, {
             1.2071067811865475`, 1.2071067811865475`, 
             0.31518082617584076`}, {
             1.2071067811865475`, -1.2071067811865475`, -0.6848191738241592}, \
{1.2071067811865475`, -1.2071067811865475`, 
             0.31518082617584076`}, {-1.2071067811865475`, -0.5, \
-1.3919259550107066`}, {-1.2071067811865475`, -0.5, 
             1.0222876073623883`}, {-1.2071067811865475`, 
             0.5, -1.3919259550107066`}, {-1.2071067811865475`, 0.5, 
             1.0222876073623883`}, {-1.2071067811865475`, 
             1.2071067811865475`, -0.6848191738241592}, {-1.2071067811865475`,
              1.2071067811865475`, 
             0.31518082617584076`}, {-1.2071067811865475`, \
-1.2071067811865475`, -0.6848191738241592}, {-1.2071067811865475`, \
-1.2071067811865475`, 0.31518082617584076`}}], 
           Polygon3DBox[{{7, 15, 13, 9, 3, 21, 23, 1}, {9, 19, 20, 10, 4, 28, 
             27, 3}, {1, 25, 26, 2, 8, 18, 17, 7}, {15, 17, 18, 16, 14, 20, 
             19, 13}, {21, 27, 28, 22, 24, 26, 25, 23}, {9, 13, 19}, {17, 15, 
             7}, {27, 21, 3}, {1, 23, 25}, {20, 14, 10}, {8, 16, 18}, {4, 22, 
             28}, {26, 24, 2}, {6, 11, 5, 12}, {11, 6, 2, 24}, {5, 11, 22, 
             4}, {12, 5, 10, 14}, {6, 12, 16, 8}, {8, 2, 6}, {24, 22, 11}, {4,
              10, 5}, {14, 16, 12}}]]],
         "\"augmented truncated cube\""],
        Annotation[#, "augmented truncated cube", "Tooltip"]& ],
       TraditionalForm], {1769.5384615384614`, -1764.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[{{-1.17114430798631, 0.29368801011732865`, 
           0.10931162094238263`}, {-0.8387701090062462, -0.4576492789900169, 
           0.6794165848290808}, {-0.8144392952376528, -0.5375424573160974, \
-0.31708894647092317`}, {-0.6665847017420747, 
           0.8492341214602188, -0.5515878584933748}, {-0.4604401949899723, 
           0.46107543093596254`, 0.7925986141756621}, {-0.30987968899341745`, 
           0.018003654026792444`, -0.9779884259066806}, \
{-0.11726680239547817`, -0.9911542397772739, 0.2380533277147617}, {
           0.010482453735345468`, -0.901366982255388, -0.7496791952436982}, {
           0.04411941125426262, 1.0166215422788532`, 0.13169913473990377`}, {
           0.11346132789881679`, -0.34027689103815867`, 0.9613247414690286}, {
           0.29798459888735945`, 0.7939763540871261, -0.8095658486926417}, {
           0.5303052558386957, 0.5650396572477727, 0.8798272120504372}, {
           0.6568605152355149, -0.13880239517520027`, -0.7759358573509268}, {
           0.8034989275767017, -0.8969007441994632, -0.14049521817657964`}, {
           0.8875880204815091, 0.5120753422939326, -0.05266459402297767}, {
           1.0342255878319375`, -0.24602252904443161`, 0.5827770385041723}}, 
           Polygon3DBox[{{14, 7, 8}, {10, 7, 14, 16}, {10, 16, 12}, {13, 14, 
             8}, {16, 14, 13, 15}, {16, 15, 12}, {13, 11, 15}, {13, 8, 6}, {
             13, 6, 11}, {11, 6, 4}, {6, 3, 1, 4}, {8, 7, 3}, {6, 8, 3}, {3, 
             7, 2}, {3, 2, 1}, {4, 1, 5, 9}, {11, 4, 9}, {11, 9, 15}, {9, 12, 
             15}, {9, 5, 12}, {12, 5, 10}, {10, 2, 7}, {5, 2, 10}, {1, 2, 
             5}}]]],
         "\"disphenocingulum\""],
        Annotation[#, "disphenocingulum", "Tooltip"]& ],
       TraditionalForm], {2162.7692307692305`, -1764.}, {Center, Center}, {359.9999999999998, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
               Rational[1, 2], 0, 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[9 - 36 #^2 + 16 #^4& , 4, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
               Rational[1, 2], 0, 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[9 - 36 #^2 + 16 #^4& , 1, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 3, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 3, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 1, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 1, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 216 #^2 + 144 #^4& , 1, 0], 
              Rational[-1, 2], 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 216 #^2 + 144 #^4& , 1, 0], 
              Rational[1, 2], 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 4, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 216 #^2 + 144 #^4& , 4, 0], 
              Rational[-1, 2], 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 216 #^2 + 144 #^4& , 4, 0], 
              Rational[1, 2], 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 9 #^2 + 9 #^4& , 1, 0], 0, 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 1, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 4, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 4, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 9 #^2 + 9 #^4& , 4, 0], 0, 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 4, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 1, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[25 - 180 #^2 + 144 #^4& , 1, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[121 - 345 #^2 + 225 #^4& , 1, 0], 0, 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[121 - 6180 #^2 + 3600 #^4& , 4, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[1 - 36 #^2 + 144 #^4& , 1, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[121 - 2520 #^2 + 3600 #^4& , 4, 0], 
              Rational[1, 10] (5 + 4 5^Rational[1, 2]), 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[121 - 1620 #^2 + 3600 #^4& , 2, 0]}, {
             Rational[-1, 6] (Rational[1, 30] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + Root[121 - 2520 #^2 + 3600 #^4& , 4, 0], 
              Rational[1, 10] (-5 - 4 5^Rational[1, 2]), 
              Rational[-1, 12] (Rational[1, 6] (7 - 3 5^Rational[1, 2]))^
                Rational[1, 2] + 
              Root[121 - 1620 #^2 + 3600 #^4& , 2, 
                0]}}, {{-0.01643720000432146, 0, 
              1.3828811901593623`}, {-0.01643720000432146, 
              0, -1.419635886728785}, {
             0.1619738448822235, -1.3090169943749475`, 0.4487088311966465}, {
             0.1619738448822235, 1.3090169943749475`, 0.4487088311966465}, {
             0.45064897947703636`, -0.8090169943749475, -1.062813796955695}, {
             0.45064897947703636`, 0.8090169943749475, -1.062813796955695}, {
             1.0279992486666623`, -0.8090169943749475, 0.4487088311966465}, {
             1.0279992486666623`, 0.8090169943749475, 
             0.4487088311966465}, {-1.23928469356185, -0.5, 
             0.4487088311966465}, {-1.23928469356185, 0.5, 
             0.4487088311966465}, {
             1.2064102935532073`, -0.5, -0.48546352776606916`}, {
             1.2064102935532073`, 
             0.5, -0.48546352776606916`}, {-0.9506095589670372, 
              0, -1.062813796955695}, {-0.4835233794856793, \
-0.8090169943749475, 1.0260591003862722`}, {-0.4835233794856793, 
             0.8090169943749475, 1.0260591003862722`}, {
             0.9177351589583943, 0, 
              1.0260591003862722`}, {-1.060873648675305, -0.8090169943749475, \
-0.48546352776606916`}, {-1.060873648675305, 
             0.8090169943749475, -0.48546352776606916`}, \
{-1.0115620486623405`, 0, 
              1.2842579901334332`}, {-0.19484824489086638`, \
-1.3090169943749475`, -0.48546352776606916`}, {-0.19484824489086638`, 
             1.3090169943749475`, -0.48546352776606916`}, {0.7886357140848136,
              1.394427190999916, -0.32588783804483684`}, {
             0.7886357140848136, -1.394427190999916, -0.32588783804483684`}}],
            Polygon3DBox[{{2, 6, 12, 11, 5}, {11, 12, 8, 16, 7}, {6, 2, 13, 
             18, 21}, {2, 5, 20, 17, 13}, {4, 21, 18, 10, 15}, {18, 13, 17, 9,
              10}, {17, 20, 3, 14, 9}, {3, 7, 16, 1, 14}, {16, 8, 4, 15, 1}, {
             19, 15, 10}, {19, 10, 9}, {19, 9, 14}, {19, 14, 1}, {19, 1, 
             15}, {23, 5, 11}, {23, 11, 7}, {23, 7, 3}, {23, 3, 20}, {23, 20, 
             5}, {22, 12, 6}, {22, 6, 21}, {22, 21, 4}, {22, 4, 8}, {22, 8, 
             12}}]]],
         "\"triaugmented dodecahedron\""],
        Annotation[#, "triaugmented dodecahedron", "Tooltip"]& ],
       TraditionalForm], {2556., -1764.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[{{-1.0931747372693175`, 
           0.4315649798710932, -0.3536055354670887}, {-1.0056985183106426`, \
-0.5621892411484819, -0.4228829154418715}, {-0.8596327851101334, \
-0.10743660193928338`, 0.4556752880961398}, {-0.7198768747830485, 
           0.882748335041893, 0.456999565652224}, {-0.3636782503436039, 
           0.03130332428957307, -0.90824520310839}, {-0.30962213760626256`, \
-0.9050088375692658, 0.2079520219611931}, {-0.19708912848065338`, 
           
           0.8734734484562894, -0.3954123390698724}, {-0.14950525197374728`, \
-0.9368546979551662, -0.7786317457081781}, {-0.07403012602113966, 
           0.28600019230247553`, 0.9332063875745616}, {0.2547077930849525, 
           1.1065954068570159`, 0.4657102757680406}, {
           0.47598052148273096`, -0.5115720433275064, 0.685483121439615}, {
           0.5807424806072231, -0.2544647354462948, -0.7457456677702762}, {
           0.6146736213176217, -1.0524890882774083`, -0.14407835925102164`}, {
           0.7473316024701738, 0.5877053887204216, -0.2329128037317586}, {
           0.9004952648452159, 0.3924484879129675, 0.7358041218430739}, {
           1.1983772783805229`, -0.26182427096924354`, 0.04068406552695126}}, 
           Polygon3DBox[{{14, 12, 5, 7}, {14, 10, 15}, {10, 14, 7}, {10, 7, 
             4}, {12, 16, 13}, {16, 12, 14}, {16, 14, 15}, {5, 8, 2}, {8, 5, 
             12}, {8, 12, 13}, {7, 1, 4}, {1, 7, 5}, {1, 5, 2}, {3, 6, 11, 
             9}, {3, 4, 1}, {4, 3, 9}, {4, 9, 10}, {6, 2, 8}, {2, 6, 3}, {2, 
             3, 1}, {11, 13, 16}, {13, 11, 6}, {13, 6, 8}, {9, 15, 10}, {15, 
             9, 11}, {15, 11, 16}}]]],
         "\"snub square antiprism\""],
        Annotation[#, "snub square antiprism", "Tooltip"]& ],
       TraditionalForm], {2949.2307692307686`, -1764.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{-1, 0, 
              Rational[1, 2] (-1 + 3^Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2], 
              Rational[1, 2] (-1 + 3^Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2], 
              Rational[1, 2] (-1 + 3^Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] 3^Rational[-1, 2], 
              Rational[
               1, 2] (Rational[5, 3] + 3^Rational[1, 2] + 
                4 (Rational[2, 3] (-1 + 3^Rational[1, 2]))^Rational[1, 2])^
               Rational[1, 2]}, {
             0, -1, Rational[-1, 2] (-1 + 3^Rational[1, 2])^Rational[1, 2]}, {
             0, 1, Rational[-1, 2] (-1 + 3^Rational[1, 2])^Rational[1, 2]}, {
             0, 3^Rational[-1, 2], 
              Rational[
               1, 2] (Rational[5, 3] + 3^Rational[1, 2] + 
                4 (Rational[2, 3] (-1 + 3^Rational[1, 2]))^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2] 3^Rational[-1, 2], 
              Rational[
               1, 2] (Rational[5, 3] + 3^Rational[1, 2] + 
                4 (Rational[2, 3] (-1 + 3^Rational[1, 2]))^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2], 
              Rational[1, 2] (-1 + 3^Rational[1, 2])^Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2] 3^Rational[1, 2], 
              Rational[1, 2] (-1 + 3^Rational[1, 2])^Rational[1, 2]}, {
             1, 0, Rational[1, 2] (-1 + 3^Rational[1, 2])^
               Rational[1, 2]}, {-3^Rational[-1, 2], 0, 
              Rational[-1, 2] (Rational[5, 3] + 3^Rational[1, 2] + 
                4 (Rational[2, 3] (-1 + 3^Rational[1, 2]))^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 2] (Rational[5, 3] + 3^Rational[1, 2] + 
                4 (Rational[2, 3] (-1 + 3^Rational[1, 2]))^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[1, 2] 3^Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 2] (Rational[5, 3] + 3^Rational[1, 2] + 
                4 (Rational[2, 3] (-1 + 3^Rational[1, 2]))^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2] (-1 + 3^Rational[1, 2])^Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2] (-1 + 3^Rational[1, 2])^Rational[1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2] (-1 + 3^Rational[1, 2])^Rational[1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2] (-1 + 3^Rational[1, 2])^Rational[1, 2]}}, {{-1, 
              0, 0.42779983858367604`}, {-0.5, -0.8660254037844386, 
             0.42779983858367604`}, {-0.5, 0.8660254037844386, 
             0.42779983858367604`}, {-0.5, -0.2886751345948129, 
             1.2442964195114021`}, {0, -1, -0.42779983858367604`}, {
             0, 1, -0.42779983858367604`}, {
             0, 0.5773502691896258, 1.2442964195114021`}, {
             0.5, -0.2886751345948129, 1.2442964195114021`}, {
             0.5, -0.8660254037844386, 0.42779983858367604`}, {0.5, 
             0.8660254037844386, 0.42779983858367604`}, {
             1, 0, 0.42779983858367604`}, {-0.5773502691896258, 
              0, -1.2442964195114021`}, {
             0.2886751345948129, -0.5, -1.2442964195114021`}, {
             0.2886751345948129, 
             0.5, -1.2442964195114021`}, {-0.8660254037844386, -0.5, \
-0.42779983858367604`}, {-0.8660254037844386, 0.5, -0.42779983858367604`}, {
             0.8660254037844386, -0.5, -0.42779983858367604`}, {
             0.8660254037844386, 0.5, -0.42779983858367604`}}], 
           Polygon3DBox[{{18, 10, 11}, {6, 3, 10}, {16, 1, 3}, {15, 2, 1}, {5,
              9, 2}, {17, 11, 9}, {18, 6, 10}, {6, 16, 3}, {16, 15, 1}, {15, 
             5, 2}, {5, 17, 9}, {17, 18, 11}, {7, 4, 8}, {4, 7, 3, 1}, {8, 4, 
             2, 9}, {7, 8, 11, 10}, {10, 3, 7}, {1, 2, 4}, {9, 11, 8}, {12, 
             14, 13}, {18, 17, 13, 14}, {16, 6, 14, 12}, {5, 15, 12, 13}, {13,
              17, 5}, {14, 6, 18}, {12, 15, 16}}]]],
         "\"gyroelongated triangular bicupola\""],
        Annotation[#, "gyroelongated triangular bicupola", "Tooltip"]& ],
       TraditionalForm], {3342.461538461538, -1764.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, -2^Rational[-1, 2], 2^Rational[-1, 2] - 
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
               59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
               135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
               0]}, {0, 2^Rational[-1, 2], 2^Rational[-1, 2] - 
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
               59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
               135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
               0]}, {0, Root[1 - 4 #^2 + 2 #^4& , 1, 0], 
              Root[-1 + 8 #^2 - 16 #^4 + 8 #^6 + 2 #^8& , 1, 0] - 
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
               59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
               135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
               0]}, {0, Root[1 - 4 #^2 + 2 #^4& , 4, 0], 
              Root[-1 + 8 #^2 - 16 #^4 + 8 #^6 + 2 #^8& , 1, 0] - 
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
               59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
               135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
               0]}, {-2^Rational[-1, 2], 0, 2^Rational[-1, 2] - 
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
               59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
               135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
               0]}, {2^Rational[-1, 2], 0, 2^Rational[-1, 2] - 
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
               59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
               135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
               0]}, {Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[-1, 2], -
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
                59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
                135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
                0]}, {Root[1 - 4 #^2 + 2 #^4& , 1, 0], 0, 
              Root[-1 + 8 #^2 - 16 #^4 + 8 #^6 + 2 #^8& , 1, 0] - 
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
               59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
               135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
               0]}, {Root[1 - 4 #^2 + 2 #^4& , 4, 0], 0, 
              Root[-1 + 8 #^2 - 16 #^4 + 8 #^6 + 2 #^8& , 1, 0] - 
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
               59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
               135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
               0]}, {Root[1 - 8 #^2 + 8 #^4& , 1, 0], Root[
              1 - 8 #^2 + 8 #^4& , 1, 0], 
              Root[-1 + 8 #^2 - 16 #^4 + 8 #^6 + 2 #^8& , 1, 0] - 
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
               59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
               135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
               0]}, {Root[1 - 8 #^2 + 8 #^4& , 1, 0], Root[
              1 - 8 #^2 + 8 #^4& , 4, 0], 
              Root[-1 + 8 #^2 - 16 #^4 + 8 #^6 + 2 #^8& , 1, 0] - 
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
               59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
               135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
               0]}, {Root[1 - 8 #^2 + 8 #^4& , 4, 0], Root[
              1 - 8 #^2 + 8 #^4& , 1, 0], 
              Root[-1 + 8 #^2 - 16 #^4 + 8 #^6 + 2 #^8& , 1, 0] - 
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
               59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
               135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
               0]}, {Root[1 - 8 #^2 + 8 #^4& , 4, 0], Root[
              1 - 8 #^2 + 8 #^4& , 4, 0], 
              Root[-1 + 8 #^2 - 16 #^4 + 8 #^6 + 2 #^8& , 1, 0] - 
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
               59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
               135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
               0]}, {Rational[-1, 2], 
              Rational[1, 2] (-1 - 2^Rational[1, 2]), -
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
                59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
                135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
                0]}, {Rational[1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), -
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
                59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
                135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
                0]}, {Rational[1, 2], 
              Rational[1, 2] (-1 - 2^Rational[1, 2]), -
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
                59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
                135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
                0]}, {Rational[-1, 2], 
              Rational[1, 2] (1 + 2^Rational[1, 2]), -
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
                59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
                135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
                0]}, {Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[-1, 2], -
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
                59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
                135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
                0]}, {Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[
              1, 2], -Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
                59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
                135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
                0]}, {Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2], -
              Root[-1380196801 + 1357646144 # + 30792952064 #^2 - 
                59997409280 #^3 - 79510659072 #^4 + 223146147840 #^5 - 
                135651131392 #^6 + 37664849920 #^7 + 56891539456 #^8& , 3, 
                0]}}, {{0, -0.7071067811865475, 0.9177866327770738}, {
             0, 0.7071067811865475, 0.9177866327770738}, {
             0, -1.3065629648763766`, -0.6496157182724434}, {
             0, 1.3065629648763766`, -0.6496157182724434}, \
{-0.7071067811865475, 0, 0.9177866327770738}, {
             0.7071067811865475, 0, 
              0.9177866327770738}, {-1.2071067811865475`, -0.5, 
             0.2106798515905264}, {-1.3065629648763766`, 
              0, -0.6496157182724434}, {
             1.3065629648763766`, 
              0, -0.6496157182724434}, {-0.9238795325112867, \
-0.9238795325112867, -0.6496157182724434}, {-0.9238795325112867, 
             0.9238795325112867, -0.6496157182724434}, {
             0.9238795325112867, -0.9238795325112867, -0.6496157182724434}, {
             0.9238795325112867, 
             0.9238795325112867, -0.6496157182724434}, {-0.5, \
-1.2071067811865475`, 0.2106798515905264}, {0.5, 1.2071067811865475`, 
             0.2106798515905264}, {0.5, -1.2071067811865475`, 
             0.2106798515905264}, {-0.5, 1.2071067811865475`, 
             0.2106798515905264}, {1.2071067811865475`, -0.5, 
             0.2106798515905264}, {-1.2071067811865475`, 0.5, 
             0.2106798515905264}, {1.2071067811865475`, 0.5, 
             0.2106798515905264}}], 
           Polygon3DBox[{{11, 4, 13, 9, 12, 3, 10, 8}, {8, 10, 7}, {10, 3, 
             14}, {3, 12, 16}, {12, 9, 18}, {9, 13, 20}, {13, 4, 15}, {4, 11, 
             17}, {11, 8, 19}, {10, 14, 7}, {3, 16, 14}, {12, 18, 16}, {9, 20,
              18}, {13, 15, 20}, {4, 17, 15}, {11, 19, 17}, {8, 7, 19}, {2, 5,
              1, 6}, {5, 2, 17, 19}, {1, 5, 7, 14}, {6, 1, 16, 18}, {2, 6, 20,
              15}, {15, 17, 2}, {19, 7, 5}, {14, 16, 1}, {18, 20, 6}}]]],
         "\"gyroelongated square cupola\""],
        Annotation[#, "gyroelongated square cupola", "Tooltip"]& ],
       TraditionalForm], {3735.6923076923067`, -1764.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2], Rational[-1, 2], 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[-1, 2], Rational[1, 2], 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             0, -2^Rational[-1, 2], Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             0, 2^Rational[-1, 2], Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[-1, 2], 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2], 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {-2^Rational[-1, 2], 0,
               Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             2^Rational[-1, 2], 0, Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[
              1, 2]}, {
             Rational[-1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[
              1, 2]}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[1, 2], Rational[
              1, 2]}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[-1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[-1, 2]}, {
             Rational[1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[
              1, 2]}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2], Rational[
              1, 2]}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2], 
              Rational[-1, 2]}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2], Rational[
              1, 2]}}, {{-0.5, -0.5, -1.2071067811865475`}, {-0.5, 
             0.5, -1.2071067811865475`}, {
             0, -0.7071067811865475, 1.2071067811865475`}, {
             0, 0.7071067811865475, 1.2071067811865475`}, {
             0.5, -0.5, -1.2071067811865475`}, {0.5, 
             0.5, -1.2071067811865475`}, {-0.7071067811865475, 0, 
              1.2071067811865475`}, {
             0.7071067811865475, 0, 1.2071067811865475`}, {0.5, 
             1.2071067811865475`, -0.5}, {0.5, 1.2071067811865475`, 
             0.5}, {-0.5, 1.2071067811865475`, -0.5}, {-0.5, 
             1.2071067811865475`, 0.5}, {-1.2071067811865475`, 
             0.5, -0.5}, {-1.2071067811865475`, 0.5, 
             0.5}, {-1.2071067811865475`, -0.5, -0.5}, {-1.2071067811865475`, \
-0.5, 0.5}, {-0.5, -1.2071067811865475`, -0.5}, {-0.5, -1.2071067811865475`, 
             0.5}, {0.5, -1.2071067811865475`, -0.5}, {
             0.5, -1.2071067811865475`, 0.5}, {
             1.2071067811865475`, -0.5, -0.5}, {1.2071067811865475`, -0.5, 
             0.5}, {1.2071067811865475`, 0.5, -0.5}, {1.2071067811865475`, 
             0.5, 0.5}}], 
           Polygon3DBox[{{4, 7, 3, 8}, {7, 4, 12, 14}, {3, 7, 16, 18}, {8, 3, 
             20, 22}, {4, 8, 24, 10}, {10, 12, 4}, {14, 16, 7}, {18, 20, 3}, {
             22, 24, 8}, {5, 1, 2, 6}, {11, 9, 6, 2}, {15, 13, 2, 1}, {19, 17,
              1, 5}, {23, 21, 5, 6}, {6, 9, 23}, {2, 13, 11}, {1, 17, 15}, {5,
              21, 19}, {9, 11, 12, 10}, {11, 13, 14, 12}, {13, 15, 16, 14}, {
             15, 17, 18, 16}, {17, 19, 20, 18}, {19, 21, 22, 20}, {21, 23, 24,
              22}, {23, 9, 10, 24}}]]],
         "\"elongated square gyrobicupola\""],
        Annotation[#, "elongated square gyrobicupola", "Tooltip"]& ],
       TraditionalForm], {4128.923076923076, -1764.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] - (
               Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2]}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] - (
               Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^
                Rational[1, 2] + (Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] - (
               Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[
               1, 2]}, {-(Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], 0, 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] - (
               Rational[1, 10] (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] - (
               Rational[1, 10] (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 4] + 
                Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 4] + 
                Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2], 0, 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}}, {{
             0, -1.618033988749895, -0.36553465826201964`}, {
             0, 1.618033988749895, -0.36553465826201964`}, {
             0.42532540417601994`, -1.3090169943749475`, 
             0.48511615009002024`}, {0.42532540417601994`, 
             1.3090169943749475`, 0.48511615009002024`}, {
             0.6881909602355868, -0.5, -0.8912657703811533}, {
             0.6881909602355868, -0.5, 1.010847262209154}, {
             0.6881909602355868, 0.5, -0.8912657703811533}, {
             0.6881909602355868, 0.5, 
             1.010847262209154}, {-0.8506508083520399, 
              0, -0.8912657703811533}, {-0.8506508083520399, 0, 
              1.010847262209154}, {-1.1135163644116066`, -0.8090169943749475, 
             0.48511615009002024`}, {-1.1135163644116066`, 0.8090169943749475,
              0.48511615009002024`}, {-0.2628655560595668, \
-0.8090169943749475, -0.8912657703811533}, {-0.2628655560595668, \
-0.8090169943749475, 1.010847262209154}, {-0.2628655560595668, 
             0.8090169943749475, -0.8912657703811533}, {-0.2628655560595668, 
             0.8090169943749475, 
             1.010847262209154}, {-0.9510565162951535, -1.3090169943749475`, \
-0.36553465826201964`}, {-0.9510565162951535, 
             1.3090169943749475`, -0.36553465826201964`}, {
             0.9510565162951535, -1.3090169943749475`, \
-0.36553465826201964`}, {0.9510565162951535, 
             1.3090169943749475`, -0.36553465826201964`}, \
{-1.5388417685876268`, -0.5, -0.36553465826201964`}, {-1.5388417685876268`, 
             0.5, -0.36553465826201964`}, {
             1.5388417685876268`, -0.5, -0.36553465826201964`}, {
             1.5388417685876268`, 0.5, -0.36553465826201964`}, {
             1.3763819204711736`, 0, 0.48511615009002024`}}], 
           Polygon3DBox[{{16, 10, 14, 6, 8}, {12, 10, 16}, {11, 14, 10}, {3, 
             6, 14}, {25, 8, 6}, {4, 16, 8}, {20, 2, 4}, {18, 22, 12}, {21, 
             17, 11}, {1, 19, 3}, {23, 24, 25}, {2, 18, 12, 16, 4}, {22, 21, 
             11, 10, 12}, {17, 1, 3, 14, 11}, {19, 23, 25, 6, 3}, {24, 20, 4, 
             8, 25}, {5, 13, 9, 15, 7}, {2, 20, 7, 15}, {22, 18, 15, 9}, {17, 
             21, 9, 13}, {19, 1, 13, 5}, {24, 23, 5, 7}, {7, 20, 24}, {15, 18,
              2}, {9, 21, 22}, {13, 1, 17}, {5, 23, 19}}]]],
         "\"pentagonal orthocupolarotunda\""],
        Annotation[#, "pentagonal orthocupolarotunda", "Tooltip"]& ],
       TraditionalForm], {4522.153846153846, -1764.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], 0, 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] - (
               Rational[1, 10] (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] - (
               Rational[1, 10] (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] - (
               Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[
               1, 2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] - (
               Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[
               1, 2]}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 2], 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] - (
               Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[
               1, 2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 4] + 
                Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2], 0, 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2]}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2]}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[-9, 8] (1 - 2 5^Rational[-1, 2])^Rational[1, 2] + (
                Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2]}}, {{
             0, -1.618033988749895, -0.36553465826201964`}, {
             0, 1.618033988749895, -0.36553465826201964`}, {
             0.8506508083520399, 0, -0.8912657703811533}, {
             0.2628655560595668, -0.8090169943749475, -0.8912657703811533}, {
             0.2628655560595668, 
             0.8090169943749475, -0.8912657703811533}, {-0.9510565162951535, \
-1.3090169943749475`, -0.36553465826201964`}, {-0.9510565162951535, 
             1.3090169943749475`, -0.36553465826201964`}, {
             0.9510565162951535, -1.3090169943749475`, \
-0.36553465826201964`}, {0.9510565162951535, 
             1.3090169943749475`, -0.36553465826201964`}, \
{-0.6881909602355868, -0.5, -0.8912657703811533}, {-0.6881909602355868, 
             0.5, -0.8912657703811533}, {-1.5388417685876268`, -0.5, \
-0.36553465826201964`}, {-1.5388417685876268`, 0.5, -0.36553465826201964`}, {
             1.5388417685876268`, -0.5, -0.36553465826201964`}, {
             1.5388417685876268`, 0.5, -0.36553465826201964`}, {
             1.3763819204711736`, 0, 0.48511615009002024`}, {
             0.42532540417601994`, -1.3090169943749475`, 
             0.48511615009002024`}, {0.42532540417601994`, 
             1.3090169943749475`, 
             0.48511615009002024`}, {-1.1135163644116066`, \
-0.8090169943749475, 0.48511615009002024`}, {-1.1135163644116066`, 
             0.8090169943749475, 
             0.48511615009002024`}, {-0.8506508083520399, 0, 
              1.010847262209154}, {-0.2628655560595668, -0.8090169943749475, 
             1.010847262209154}, {-0.2628655560595668, 0.8090169943749475, 
             1.010847262209154}, {0.6881909602355868, -0.5, 
             1.010847262209154}, {0.6881909602355868, 0.5, 
             1.010847262209154}}], 
           Polygon3DBox[{{23, 21, 22, 24, 25}, {20, 21, 23}, {19, 22, 21}, {
             17, 24, 22}, {16, 25, 24}, {18, 23, 25}, {9, 2, 18}, {7, 13, 
             20}, {12, 6, 19}, {1, 8, 17}, {14, 15, 16}, {2, 7, 20, 23, 18}, {
             13, 12, 19, 21, 20}, {6, 1, 17, 22, 19}, {8, 14, 16, 24, 17}, {
             15, 9, 18, 25, 16}, {3, 4, 10, 11, 5}, {7, 2, 5, 11}, {12, 13, 
             11, 10}, {1, 6, 10, 4}, {14, 8, 4, 3}, {9, 15, 3, 5}, {5, 2, 
             9}, {11, 13, 7}, {10, 6, 12}, {4, 8, 1}, {3, 15, 14}}]]],
         "\"pentagonal gyrocupolarotunda\""],
        Annotation[#, "pentagonal gyrocupolarotunda", "Tooltip"]& ],
       TraditionalForm], {196.6153846153846, -2156.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), -1 - Root[
              1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 0]}, {
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), -
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
                0]}, {0, Rational[1, 2] (1 + 5^Rational[1, 2]), -1 - Root[
              1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 0]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), -
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
                0]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), -1 - 
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), -
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
                0]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), -1 - 
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), -
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
                0]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), -1 - 
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), -
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
                0]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), -1 - 
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), -
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
                0]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], -1 - Root[
              1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], -
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
                0]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], -1 - Root[
              1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], -
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
                0]}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[-1, 2], -1 - Root[
              1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[-1, 2], -
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
                0]}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], -1 - Root[
              1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], -
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
                0]}, {(Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
              Rational[1, 2], 
              0, (Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2] - Root[
              1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {(Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[1, 4] (-3 - 5^
               Rational[1, 2]), (Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2] - Root[
              1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {(Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[1, 4] (3 + 
               5^Rational[1, 2]), (Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2] - Root[
              1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {-(Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (-1 - 5^
               Rational[1, 2]), (Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2] - Root[
              1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {-(Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (1 + 
               5^Rational[1, 2]), (Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2] - Root[
              1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {-(Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], 
              0, (Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2] - 
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (-1 - 5^
               Rational[1, 2]), (Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2] - Root[
              1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 0]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (1 + 
               5^Rational[1, 2]), (Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2] - Root[
              1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[-1, 2], (Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2] - Root[
              1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[
              1, 2], (Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2] - 
              Root[1 - 3480 # + 567200 #^2 + 2390400 #^3 + 2228480 #^4& , 3, 
               0]}}, {{0, -1.618033988749895, -1.0003022667749277`}, {
             0, -1.618033988749895, -0.0003022667749277553}, {
             0, 1.618033988749895, -1.0003022667749277`}, {
             0, 1.618033988749895, -0.0003022667749277553}, \
{-0.9510565162951535, -1.3090169943749475`, -1.0003022667749277`}, \
{-0.9510565162951535, -1.3090169943749475`, -0.0003022667749277553}, \
{-0.9510565162951535, 
             1.3090169943749475`, -1.0003022667749277`}, {-0.9510565162951535,
              1.3090169943749475`, -0.0003022667749277553}, {
             0.9510565162951535, -1.3090169943749475`, -1.0003022667749277`}, \
{0.9510565162951535, -1.3090169943749475`, -0.0003022667749277553}, {
             0.9510565162951535, 1.3090169943749475`, -1.0003022667749277`}, {
             0.9510565162951535, 
             1.3090169943749475`, -0.0003022667749277553}, \
{-1.5388417685876268`, -0.5, -1.0003022667749277`}, {-1.5388417685876268`, \
-0.5, -0.0003022667749277553}, {-1.5388417685876268`, 
             0.5, -1.0003022667749277`}, {-1.5388417685876268`, 
             0.5, -0.0003022667749277553}, {
             1.5388417685876268`, -0.5, -1.0003022667749277`}, {
             1.5388417685876268`, -0.5, -0.0003022667749277553}, {
             1.5388417685876268`, 0.5, -1.0003022667749277`}, {
             1.5388417685876268`, 0.5, -0.0003022667749277553}, {
             1.3763819204711736`, 0, 0.8503485415771121}, {
             0.42532540417601994`, -1.3090169943749475`, 
             0.8503485415771121}, {0.42532540417601994`, 1.3090169943749475`, 
             0.8503485415771121}, {-1.1135163644116066`, -0.8090169943749475, 
             0.8503485415771121}, {-1.1135163644116066`, 0.8090169943749475, 
             0.8503485415771121}, {-0.8506508083520399, 0, 
              1.3760796536962459`}, {-0.2628655560595668, -0.8090169943749475,
              1.3760796536962459`}, {-0.2628655560595668, 0.8090169943749475, 
             1.3760796536962459`}, {0.6881909602355868, -0.5, 
             1.3760796536962459`}, {0.6881909602355868, 0.5, 
             1.3760796536962459`}}], 
           Polygon3DBox[{{28, 26, 27, 29, 30}, {25, 26, 28}, {24, 27, 26}, {
             22, 29, 27}, {21, 30, 29}, {23, 28, 30}, {12, 4, 23}, {8, 16, 
             25}, {14, 6, 24}, {2, 10, 22}, {18, 20, 21}, {4, 8, 25, 28, 
             23}, {16, 14, 24, 26, 25}, {6, 2, 22, 27, 24}, {10, 18, 21, 29, 
             22}, {20, 12, 23, 30, 21}, {19, 17, 9, 1, 5, 13, 15, 7, 3, 11}, {
             11, 3, 4, 12}, {3, 7, 8, 4}, {7, 15, 16, 8}, {15, 13, 14, 16}, {
             13, 5, 6, 14}, {5, 1, 2, 6}, {1, 9, 10, 2}, {9, 17, 18, 10}, {17,
              19, 20, 18}, {19, 11, 12, 20}}]]],
         "\"elongated pentagonal rotunda\""],
        Annotation[#, "elongated pentagonal rotunda", "Tooltip"]& ],
       TraditionalForm], {589.8461538461538, -2156.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[-1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[-1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[-1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             0, -2^Rational[-1, 2], 
              Rational[1, 2] (1 + 2 2^Rational[1, 2])}, {
             0, -2^Rational[-1, 2], 
              Rational[1, 2] (-1 - 2 2^Rational[1, 2])}, {
             0, 2^Rational[-1, 2], Rational[1, 2] (1 + 2 2^Rational[1, 2])}, {
             0, 2^Rational[-1, 2], 
              Rational[1, 2] (-1 - 2 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[1, 2], Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {-2^Rational[-1, 2], 0,
               Rational[1, 2] (1 + 2 2^Rational[1, 2])}, {-2^Rational[-1, 2], 
              0, Rational[1, 2] (-1 - 2 2^Rational[1, 2])}, {
             2^Rational[-1, 2], 0, Rational[1, 2] (1 + 2 2^Rational[1, 2])}, {
             2^Rational[-1, 2], 0, 
              Rational[1, 2] (-1 - 2 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2]}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2]}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2]}, {
             Rational[1, 2] (1 + 2^Rational[1, 2]), 
              Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[1, 2]}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2], 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 2] (1 + 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[1, 2], 
              Rational[1, 2] (-1 - 2^Rational[1, 2])}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[-1, 2]}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 2] (1 + 2^Rational[1, 2]), Rational[1, 2]}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[-1, 2]}, {
             Rational[1, 2] (-1 - 2^Rational[1, 2]), 
              Rational[1, 2] (-1 - 2^Rational[1, 2]), Rational[
              1, 2]}}, {{-0.5, 1.2071067811865475`, 
             1.2071067811865475`}, {-0.5, 
             1.2071067811865475`, -1.2071067811865475`}, {-0.5, \
-1.2071067811865475`, 
             1.2071067811865475`}, {-0.5, -1.2071067811865475`, \
-1.2071067811865475`}, {0, -0.7071067811865475, 1.9142135623730951`}, {
             0, -0.7071067811865475, -1.9142135623730951`}, {
             0, 0.7071067811865475, 1.9142135623730951`}, {
             0, 0.7071067811865475, -1.9142135623730951`}, {0.5, 
             1.2071067811865475`, 1.2071067811865475`}, {0.5, 
             1.2071067811865475`, -1.2071067811865475`}, {
             0.5, -1.2071067811865475`, 1.2071067811865475`}, {
             0.5, -1.2071067811865475`, -1.2071067811865475`}, \
{-0.7071067811865475, 0, 1.9142135623730951`}, {-0.7071067811865475, 
              0, -1.9142135623730951`}, {
             0.7071067811865475, 0, 1.9142135623730951`}, {
             0.7071067811865475, 0, -1.9142135623730951`}, {
             1.2071067811865475`, -0.5, 1.2071067811865475`}, {
             1.2071067811865475`, -0.5, -1.2071067811865475`}, {
             1.2071067811865475`, 0.5, 1.2071067811865475`}, {
             1.2071067811865475`, 0.5, -1.2071067811865475`}, {
             1.2071067811865475`, 1.2071067811865475`, -0.5}, {
             1.2071067811865475`, 1.2071067811865475`, 0.5}, {
             1.2071067811865475`, -1.2071067811865475`, -0.5}, {
             1.2071067811865475`, -1.2071067811865475`, 
             0.5}, {-1.2071067811865475`, -0.5, 
             1.2071067811865475`}, {-1.2071067811865475`, -0.5, \
-1.2071067811865475`}, {-1.2071067811865475`, 0.5, 
             1.2071067811865475`}, {-1.2071067811865475`, 
             0.5, -1.2071067811865475`}, {-1.2071067811865475`, 
             1.2071067811865475`, -0.5}, {-1.2071067811865475`, 
             1.2071067811865475`, 
             0.5}, {-1.2071067811865475`, -1.2071067811865475`, -0.5}, \
{-1.2071067811865475`, -1.2071067811865475`, 0.5}}], 
           Polygon3DBox[{{3, 32, 31, 4, 12, 23, 24, 11}, {9, 22, 21, 10, 2, 
             29, 30, 1}, {17, 24, 23, 18, 20, 21, 22, 19}, {27, 30, 29, 28, 
             26, 31, 32, 25}, {24, 17, 11}, {9, 19, 22}, {3, 25, 32}, {30, 27,
              1}, {12, 18, 23}, {21, 20, 10}, {31, 26, 4}, {2, 28, 29}, {16, 
             6, 14, 8}, {28, 2, 8, 14}, {4, 26, 14, 6}, {18, 12, 6, 16}, {10, 
             20, 16, 8}, {8, 2, 10}, {14, 26, 28}, {6, 12, 4}, {16, 20, 18}, {
             7, 13, 5, 15}, {13, 7, 1, 27}, {5, 13, 25, 3}, {15, 5, 11, 17}, {
             7, 15, 19, 9}, {9, 1, 7}, {27, 25, 13}, {3, 11, 5}, {17, 19, 
             15}}]]],
         "\"biaugmented truncated cube\""],
        Annotation[#, "biaugmented truncated cube", "Tooltip"]& ],
       TraditionalForm], {983.0769230769231, -2156.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), -
              Root[9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
                265545895321600 #^3 - 3381046121123840 #^4 - 
                2030856201830400 #^5 + 6490210421964800 #^6 + 
                3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), -
              Root[9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
                265545895321600 #^3 - 3381046121123840 #^4 - 
                2030856201830400 #^5 + 6490210421964800 #^6 + 
                3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Rational[1, 2] (-1 - 5^Rational[1, 2]), 0, 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Root[1 - 5 #^2 + 5 #^4& , 4, 0], 0, 
              Root[1 - 5 #^2 + 5 #^4& , 3, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Root[1 - 5 #^2 + 5 #^4& , 3, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Root[1 - 5 #^2 + 5 #^4& , 3, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Rational[1, 2] (1 + 5^Rational[1, 2]), 0, 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Root[5 - 20 #^2 + 16 #^4& , 1, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), -
              Root[9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
                265545895321600 #^3 - 3381046121123840 #^4 - 
                2030856201830400 #^5 + 6490210421964800 #^6 + 
                3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Root[5 - 20 #^2 + 16 #^4& , 1, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), -
              Root[9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
                265545895321600 #^3 - 3381046121123840 #^4 - 
                2030856201830400 #^5 + 6490210421964800 #^6 + 
                3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Root[5 - 20 #^2 + 16 #^4& , 4, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), -
              Root[9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
                265545895321600 #^3 - 3381046121123840 #^4 - 
                2030856201830400 #^5 + 6490210421964800 #^6 + 
                3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Root[5 - 20 #^2 + 16 #^4& , 4, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), -
              Root[9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
                265545895321600 #^3 - 3381046121123840 #^4 - 
                2030856201830400 #^5 + 6490210421964800 #^6 + 
                3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Root[1 - 40 #^2 + 80 #^4& , 1, 0], Rational[-1, 2], 
              Root[1 - 5 #^2 + 5 #^4& , 3, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Root[1 - 40 #^2 + 80 #^4& , 1, 0], Rational[1, 2], 
              Root[1 - 5 #^2 + 5 #^4& , 3, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Rational[-1, 2], Root[5 - 40 #^2 + 16 #^4& , 1, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Rational[-1, 2], Root[5 - 40 #^2 + 16 #^4& , 4, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Rational[1, 2], Root[5 - 40 #^2 + 16 #^4& , 1, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Rational[1, 2], Root[5 - 40 #^2 + 16 #^4& , 4, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
              5 - 20 #^2 + 16 #^4& , 1, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
              5 - 20 #^2 + 16 #^4& , 4, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
              5 - 20 #^2 + 16 #^4& , 1, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
              5 - 20 #^2 + 16 #^4& , 4, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - Root[
              9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
               265545895321600 #^3 - 3381046121123840 #^4 - 
               2030856201830400 #^5 + 6490210421964800 #^6 + 
               3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Root[5 - 40 #^2 + 16 #^4& , 1, 0], Rational[-1, 2], -
              Root[9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
                265545895321600 #^3 - 3381046121123840 #^4 - 
                2030856201830400 #^5 + 6490210421964800 #^6 + 
                3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Root[5 - 40 #^2 + 16 #^4& , 1, 0], Rational[1, 2], -
              Root[9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
                265545895321600 #^3 - 3381046121123840 #^4 - 
                2030856201830400 #^5 + 6490210421964800 #^6 + 
                3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Root[5 - 40 #^2 + 16 #^4& , 4, 0], Rational[-1, 2], -
              Root[9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
                265545895321600 #^3 - 3381046121123840 #^4 - 
                2030856201830400 #^5 + 6490210421964800 #^6 + 
                3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}, {
             Root[5 - 40 #^2 + 16 #^4& , 4, 0], Rational[1, 2], -
              Root[9607030429441 + 119077149816320 # + 412521362904960 #^2 - 
                265545895321600 #^3 - 3381046121123840 #^4 - 
                2030856201830400 #^5 + 6490210421964800 #^6 + 
                3030095233024000 #^7 + 3583731197542400 #^8& , 1, 0]}}, {{
             0, -1.618033988749895, 0.26858518998529496`}, {
             0, 1.618033988749895, 0.26858518998529496`}, {-1.618033988749895,
               0, -0.5938118138741659}, {
             0.85065080835204, 0, 0.7943163021044286}, {
             0.2628655560595668, -0.8090169943749475, 0.7943163021044286}, {
             0.2628655560595668, 0.8090169943749475, 0.7943163021044286}, {
             1.618033988749895, 
              0, -0.5938118138741659}, {-0.9510565162951532, \
-1.3090169943749475`, 0.26858518998529496`}, {-0.9510565162951532, 
             1.3090169943749475`, 0.26858518998529496`}, {
             0.9510565162951536, -1.3090169943749475`, 
             0.26858518998529496`}, {0.9510565162951536, 1.3090169943749475`, 
             0.26858518998529496`}, {-0.6881909602355868, -0.5, 
             0.7943163021044286}, {-0.6881909602355868, 0.5, 
             0.7943163021044286}, {-0.5, -1.5388417685876268`, \
-0.5938118138741659}, {-0.5, 1.5388417685876268`, -0.5938118138741659}, {
             0.5, -1.5388417685876268`, -0.5938118138741659}, {0.5, 
             1.5388417685876268`, -0.5938118138741659}, \
{-1.3090169943749475`, -0.9510565162951532, -0.5938118138741659}, \
{-1.3090169943749475`, 0.9510565162951536, -0.5938118138741659}, {
             1.3090169943749475`, -0.9510565162951532, -0.5938118138741659}, {
             1.3090169943749475`, 
             0.9510565162951536, -0.5938118138741659}, {-1.5388417685876268`, \
-0.5, 0.26858518998529496`}, {-1.5388417685876268`, 0.5, 
             0.26858518998529496`}, {1.5388417685876268`, -0.5, 
             0.26858518998529496`}, {1.5388417685876268`, 0.5, 
             0.26858518998529496`}}], 
           Polygon3DBox[{{19, 15, 17, 21, 7, 20, 16, 14, 18, 3}, {3, 18, 
             22}, {18, 14, 8}, {14, 16, 1}, {16, 20, 10}, {20, 7, 24}, {7, 21,
              25}, {21, 17, 11}, {17, 15, 2}, {15, 19, 9}, {19, 3, 23}, {18, 
             8, 22}, {14, 1, 8}, {16, 10, 1}, {20, 24, 10}, {7, 25, 24}, {21, 
             11, 25}, {17, 2, 11}, {15, 9, 2}, {19, 23, 9}, {3, 22, 23}, {6, 
             13, 12, 5, 4}, {13, 6, 2, 9}, {12, 13, 23, 22}, {5, 12, 8, 1}, {
             4, 5, 10, 24}, {6, 4, 25, 11}, {11, 2, 6}, {9, 23, 13}, {22, 8, 
             12}, {1, 10, 5}, {24, 25, 4}}]]],
         "\"gyroelongated pentagonal cupola\""],
        Annotation[#, "gyroelongated pentagonal cupola", "Tooltip"]& ],
       TraditionalForm], {1376.3076923076924`, -2156.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), Rational[-1, 2]}, {
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), Rational[1, 2]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), Rational[-1, 2]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), Rational[
              1, 2]}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              Rational[1, 10] (
               5 + (10 (5 - 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 2], 
              Rational[1, 10] (
               5 + (10 (5 - 5^Rational[1, 2]))^Rational[1, 2])}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
               Rational[1, 2])}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
               Rational[1, 2])}, {-(Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
               Rational[1, 2])}, {(Rational[1, 2] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[1, 10] (
               5 + (10 (5 - 5^Rational[1, 2]))^Rational[1, 2])}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
               Rational[1, 2])}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
               Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (
               5 + (10 (5 - 5^Rational[1, 2]))^Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (
               5 + (10 (5 - 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 
               2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[
              1, 2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 
               2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[
              1, 2]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 2]}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), Rational[
              1, 2]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 2]}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), Rational[
              1, 2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 
               2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], Rational[
              1, 2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], 
              Rational[-1, 
               2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], Rational[
              1, 2]}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], Rational[
              1, 2]}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[1, 2]}}, {{0, -1.618033988749895, -0.5}, {
             0, -1.618033988749895, 0.5}, {0, 1.618033988749895, -0.5}, {
             0, 1.618033988749895, 0.5}, {-0.6881909602355868, -0.5, 
             1.0257311121191337`}, {-0.6881909602355868, 0.5, 
             1.0257311121191337`}, {
             0.6881909602355868, -0.5, -1.0257311121191337`}, {
             0.6881909602355868, 
             0.5, -1.0257311121191337`}, {-0.8506508083520399, 
              0, -1.0257311121191337`}, {
             0.8506508083520399, 0, 
              1.0257311121191337`}, {-0.2628655560595668, \
-0.8090169943749475, -1.0257311121191337`}, {-0.2628655560595668, 
             0.8090169943749475, -1.0257311121191337`}, {
             0.2628655560595668, -0.8090169943749475, 1.0257311121191337`}, {
             0.2628655560595668, 0.8090169943749475, 
             1.0257311121191337`}, {-0.9510565162951535, \
-1.3090169943749475`, -0.5}, {-0.9510565162951535, -1.3090169943749475`, 
             0.5}, {-0.9510565162951535, 
             1.3090169943749475`, -0.5}, {-0.9510565162951535, 
             1.3090169943749475`, 0.5}, {
             0.9510565162951535, -1.3090169943749475`, -0.5}, {
             0.9510565162951535, -1.3090169943749475`, 0.5}, {
             0.9510565162951535, 1.3090169943749475`, -0.5}, {
             0.9510565162951535, 1.3090169943749475`, 
             0.5}, {-1.5388417685876268`, -0.5, -0.5}, {-1.5388417685876268`, \
-0.5, 0.5}, {-1.5388417685876268`, 0.5, -0.5}, {-1.5388417685876268`, 0.5, 
             0.5}, {1.5388417685876268`, -0.5, -0.5}, {
             1.5388417685876268`, -0.5, 0.5}, {1.5388417685876268`, 
             0.5, -0.5}, {1.5388417685876268`, 0.5, 0.5}}], 
           Polygon3DBox[{{14, 6, 5, 13, 10}, {6, 14, 4, 18}, {5, 6, 26, 24}, {
             13, 5, 16, 2}, {10, 13, 20, 28}, {14, 10, 30, 22}, {22, 4, 14}, {
             18, 26, 6}, {24, 16, 5}, {2, 20, 13}, {28, 30, 10}, {7, 11, 9, 
             12, 8}, {3, 21, 8, 12}, {25, 17, 12, 9}, {15, 23, 9, 11}, {19, 1,
              11, 7}, {29, 27, 7, 8}, {8, 21, 29}, {12, 17, 3}, {9, 23, 25}, {
             11, 1, 15}, {7, 27, 19}, {21, 3, 4, 22}, {3, 17, 18, 4}, {17, 25,
              26, 18}, {25, 23, 24, 26}, {23, 15, 16, 24}, {15, 1, 2, 16}, {1,
              19, 20, 2}, {19, 27, 28, 20}, {27, 29, 30, 28}, {29, 21, 22, 
             30}}]]],
         "\"elongated pentagonal gyrobicupola\""],
        Annotation[#, "elongated pentagonal gyrobicupola", "Tooltip"]& ],
       TraditionalForm], {1769.5384615384614`, -2156.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), Rational[-1, 2]}, {
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), Rational[1, 2]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), Rational[-1, 2]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), Rational[
              1, 2]}, {(Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], 0, 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
               Rational[1, 2])}, {(Rational[1, 2] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[1, 10] (
               5 + (10 (5 - 5^Rational[1, 2]))^Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
               Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (
               5 + (10 (5 - 5^Rational[1, 2]))^Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
               Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (
               5 + (10 (5 - 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 
               2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[
              1, 2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 
               2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[
              1, 2]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 2]}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), Rational[
              1, 2]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 2]}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), Rational[
              1, 2]}, {-(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
               Rational[1, 2])}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Rational[1, 10] (
               5 + (10 (5 - 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 2], 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
               Rational[1, 2])}, {-(Rational[1, 4] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[1, 10] (
               5 + (10 (5 - 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 
               2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], Rational[
              1, 2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], 
              Rational[-1, 
               2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], Rational[
              1, 2]}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], Rational[
              1, 2]}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[1, 2]}}, {{0, -1.618033988749895, -0.5}, {
             0, -1.618033988749895, 0.5}, {0, 1.618033988749895, -0.5}, {
             0, 1.618033988749895, 0.5}, {
             0.8506508083520399, 0, -1.0257311121191337`}, {
             0.8506508083520399, 0, 1.0257311121191337`}, {
             0.2628655560595668, -0.8090169943749475, -1.0257311121191337`}, {
             0.2628655560595668, -0.8090169943749475, 1.0257311121191337`}, {
             0.2628655560595668, 0.8090169943749475, -1.0257311121191337`}, {
             0.2628655560595668, 0.8090169943749475, 
             1.0257311121191337`}, {-0.9510565162951535, \
-1.3090169943749475`, -0.5}, {-0.9510565162951535, -1.3090169943749475`, 
             0.5}, {-0.9510565162951535, 
             1.3090169943749475`, -0.5}, {-0.9510565162951535, 
             1.3090169943749475`, 0.5}, {
             0.9510565162951535, -1.3090169943749475`, -0.5}, {
             0.9510565162951535, -1.3090169943749475`, 0.5}, {
             0.9510565162951535, 1.3090169943749475`, -0.5}, {
             0.9510565162951535, 1.3090169943749475`, 
             0.5}, {-0.6881909602355868, -0.5, -1.0257311121191337`}, \
{-0.6881909602355868, -0.5, 1.0257311121191337`}, {-0.6881909602355868, 
             0.5, -1.0257311121191337`}, {-0.6881909602355868, 0.5, 
             1.0257311121191337`}, {-1.5388417685876268`, -0.5, -0.5}, \
{-1.5388417685876268`, -0.5, 0.5}, {-1.5388417685876268`, 
             0.5, -0.5}, {-1.5388417685876268`, 0.5, 0.5}, {
             1.5388417685876268`, -0.5, -0.5}, {1.5388417685876268`, -0.5, 
             0.5}, {1.5388417685876268`, 0.5, -0.5}, {1.5388417685876268`, 
             0.5, 0.5}}], 
           Polygon3DBox[{{22, 10, 4, 14}, {20, 22, 26, 24}, {8, 20, 12, 2}, {
             6, 8, 16, 28}, {10, 6, 30, 18}, {18, 4, 10}, {14, 26, 22}, {24, 
             12, 20}, {2, 16, 8}, {28, 30, 6}, {10, 22, 20, 8, 6}, {13, 3, 9, 
             21}, {23, 25, 21, 19}, {1, 11, 19, 7}, {27, 15, 7, 5}, {17, 29, 
             5, 9}, {9, 3, 17}, {21, 25, 13}, {19, 11, 23}, {7, 15, 1}, {5, 
             29, 27}, {5, 7, 19, 21, 9}, {17, 3, 4, 18}, {3, 13, 14, 4}, {13, 
             25, 26, 14}, {25, 23, 24, 26}, {23, 11, 12, 24}, {11, 1, 2, 
             12}, {1, 15, 16, 2}, {15, 27, 28, 16}, {27, 29, 30, 28}, {29, 17,
              18, 30}}]]],
         "\"elongated pentagonal orthobicupola\""],
        Annotation[#, "elongated pentagonal orthobicupola", "Tooltip"]& ],
       TraditionalForm], {2162.7692307692305`, -2156.}, {Center, Center}, {359.9999999999998, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{0, Rational[1, 2] (-1 - 5^Rational[1, 2]), 0}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), 
              0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              0}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              0}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], 
              0}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              0}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], 
              0}, {(Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2], 
              0, -(Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {(Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
              Rational[1, 2], 
              0, (Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^
               Rational[1, 2]), -(Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[1, 2] + 
               Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2]}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 
               5^Rational[1, 2]), -(Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2]}, {(
               Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[1, 2] + 
               Rational[1, 2] 5^Rational[-1, 2])^
              Rational[
               1, 2]}, {-(Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (-1 - 5^
               Rational[1, 2]), -(Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[1, 2] + 
               Rational[1, 2] 5^Rational[-1, 2])^
              Rational[
               1, 2]}, {-(Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
               Rational[1, 2], 
              Rational[1, 4] (1 + 
               5^Rational[1, 2]), -(Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2]}, {-(Rational[5, 8] + 
                Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[1, 2] + 
               Rational[1, 2] 5^Rational[-1, 2])^
              Rational[
               1, 2]}, {-(Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], 
              0, -(Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2]}, {-(Rational[1, 2] + 
                Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              0, (Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (-1 - 5^
               Rational[1, 2]), -(Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), (
               Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (1 + 
               5^Rational[1, 2]), -(Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2]}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), (
               Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], -(Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], (Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], -(Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2]}, {(Rational[1, 4] + 
               Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
              1, 2], (Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
              Rational[1, 2]}}, {{0, -1.618033988749895, 0}, {
             0, 1.618033988749895, 
              0}, {-0.9510565162951535, -1.3090169943749475`, 
              0}, {-0.9510565162951535, 1.3090169943749475`, 0}, {
             0.9510565162951535, -1.3090169943749475`, 0}, {
             0.9510565162951535, 1.3090169943749475`, 
              0}, {-1.5388417685876268`, -0.5, 0}, {-1.5388417685876268`, 0.5,
               0}, {1.5388417685876268`, -0.5, 0}, {
             1.5388417685876268`, 0.5, 0}, {
             1.3763819204711736`, 0, -0.8506508083520399}, {
             1.3763819204711736`, 0, 0.8506508083520399}, {
             0.42532540417601994`, -1.3090169943749475`, \
-0.8506508083520399}, {0.42532540417601994`, -1.3090169943749475`, 
             0.8506508083520399}, {0.42532540417601994`, 
             1.3090169943749475`, -0.8506508083520399}, {0.42532540417601994`,
              1.3090169943749475`, 
             0.8506508083520399}, {-1.1135163644116066`, -0.8090169943749475, \
-0.8506508083520399}, {-1.1135163644116066`, -0.8090169943749475, 
             0.8506508083520399}, {-1.1135163644116066`, 
             0.8090169943749475, -0.8506508083520399}, {-1.1135163644116066`, 
             0.8090169943749475, 
             0.8506508083520399}, {-0.8506508083520399, 
              0, -1.3763819204711736`}, {-0.8506508083520399, 0, 
              1.3763819204711736`}, {-0.2628655560595668, \
-0.8090169943749475, -1.3763819204711736`}, {-0.2628655560595668, \
-0.8090169943749475, 1.3763819204711736`}, {-0.2628655560595668, 
             0.8090169943749475, -1.3763819204711736`}, {-0.2628655560595668, 
             0.8090169943749475, 1.3763819204711736`}, {
             0.6881909602355868, -0.5, -1.3763819204711736`}, {
             0.6881909602355868, -0.5, 1.3763819204711736`}, {
             0.6881909602355868, 0.5, -1.3763819204711736`}, {
             0.6881909602355868, 0.5, 1.3763819204711736`}}], 
           Polygon3DBox[{{26, 22, 24, 28, 30}, {20, 22, 26}, {18, 24, 22}, {
             14, 28, 24}, {12, 30, 28}, {16, 26, 30}, {6, 2, 16}, {4, 8, 
             20}, {7, 3, 18}, {1, 5, 14}, {9, 10, 12}, {2, 4, 20, 26, 16}, {8,
              7, 18, 22, 20}, {3, 1, 14, 24, 18}, {5, 9, 12, 28, 14}, {10, 6, 
             16, 30, 12}, {29, 27, 23, 21, 25}, {25, 21, 19}, {21, 23, 17}, {
             23, 27, 13}, {27, 29, 11}, {29, 25, 15}, {15, 2, 6}, {19, 8, 
             4}, {17, 3, 7}, {13, 5, 1}, {11, 10, 9}, {15, 25, 19, 4, 2}, {19,
              21, 17, 7, 8}, {17, 23, 13, 1, 3}, {13, 27, 11, 9, 5}, {11, 29, 
             15, 6, 10}}]]],
         "\"pentagonal orthobirotunda\""],
        Annotation[#, "pentagonal orthobirotunda", "Tooltip"]& ],
       TraditionalForm], {2556., -2156.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwBSQS2+yFib1JlAgAAAC0AAAADAAAAKM2zVC+8AMBvYtYRikHdP7NX/u6n
hd0/5x6NixKMAMDPasgR1ljiP9xR/CtiA+G/TKLlbZRcAMBdk4LDaLTgv7Cw
r6d9FuU/YGWJc7sOAMDJ+qPN3V/Vv7xECZfwUu6/hEMdpcLi/786Zs8Y2izw
v4jF4BXbGsu/nFy3AqjY+b9Ym9hRdkP1P3w/ZsMhY+I/VNXBwPOd+b+bZ+RY
J93kP1ype8qt9/Q/HABqcG54+b8uOEfWfh/3P2R8KsAoxtq/kH8l873e+L9p
uRLnDPDUv8vrk6KCIfg/WDYYPCTo9r+V9ZWGQMTtvzjHDMQWHvi/DK8i+m+t
9r9aYrHoArf5vxZ7iLbzr+i/HVKRxgOH6b/K7AhN/yr8P9avcm3SlO4/d0Om
QpsR6b9GhaKnHFbxP3nhgR+GEPs/VV4g3Z9P6L+qN2E7PC3/P15FRtGb1OS/
oU6sXtam5r+tLCL0UAbgv9P4YeltFwBAdwP3yy/54b/ti1H+eZrvvxKAmqXY
8/+//xBZVTc74b+PIuc07qkAwJr9iHfRzem/16ipF5Q10b9s6a6xtiUBQM6F
xzCvX8k/Fk0vRaSdzb9/sUdNrb/XP669W1yB/wBAWOEkp2a/g7/eXnlTbjP7
vy/mZAxcBfm/yuPVEBz6qD/ChLwM2mP5P9ld6WbCV/c/1VjIeMY7vD98bIN/
H0L+P4jbMMoPQPK/Lvr/AEnjxT9F8lv2A0Dvv12wQ/Lsn/8/aTx5bxpQ0T/Z
GTto/v3ev96BGS9O1gHAJT+LZNy20z+ZVg3VgA0CwLHjUS4+ZtO/x9vJe9t7
4j/OahEjSIT/P3rtkSyecuY/Uc5n8tM54z+X19dwUfvrP8H3HgA/Rv4/EJVk
oE484z/TA8BTKLAAQJsg0+0vp9K/3HmgjT+45D/kZq/c4s66vxKdG+wJuABA
4zMOJR7y5T9qcKGv9rf0P2gAuUKuNPu/myc1lnfj5z9G9Q/LKir5v4SLu3lO
q/Y/iBkdhXrn5z/f8FDNUM7YP/a8H7w67gDAfCmRA0SQ6T/vCA9BaH4AwMg0
T4ZoeeE/NQ4XaT9S6j9GX1/usCXzv+Fp/cQfvvy/7xwC7afH6j/+xsWTk/r9
v0XgNNwC+PC/fBRbDcJN9z8QiPShbuf3P9xqkWvAVOU/0ptQT3aI9z9DQRz5
FyXqP/U+kR59cPY/+XCon/ut9z/sJGMmd8P5P7El1G/r4tS/kPHsHKxH+D/S
DEZNV8DEv0SBqfZRmvk/AHJW1mGE+D9sCFVv0fDxP4X6iBJVJ/O/l2T0TFpC
+T/O9fVlbRzxv9IHI8GK8vI/4+RdBhB/+T8uoj6Yd2PLPwx0D0gcz/m/oWWi
g8AY+j9aEgQdE+/4v5taPCrCD9Q/rDr600U++j+lG17mT3zov8Ax929Hpfa/
DcLvFfp4+j9ydZWYChP3v2ZQXQ5VvuW/YrNGqg==
           "], 
           Polygon3DBox[{{36, 38, 28, 26}, {26, 28, 18}, {28, 22, 14, 18}, {
             38, 40, 30, 22, 28}, {2, 8, 14, 22, 30, 32, 24, 16, 10, 4}, {26, 
             18, 12, 21}, {21, 12, 13}, {12, 6, 7, 13}, {18, 14, 8, 6, 12}, {
             6, 1, 7}, {7, 1, 3, 9}, {8, 2, 1, 6}, {2, 4, 5, 3, 1}, {4, 10, 
             11, 5}, {21, 13, 19, 27}, {27, 19, 29}, {19, 15, 23, 29}, {13, 7,
              9, 15, 19}, {33, 31, 23, 15, 9, 3, 5, 11, 17, 25}, {27, 29, 39, 
             37}, {37, 39, 41, 43, 45, 44, 42, 40, 38, 36}, {29, 23, 31, 41, 
             39}, {31, 33, 43, 41}, {33, 25, 35, 45, 43}, {25, 17, 20, 35}, {
             40, 42, 32, 30}, {45, 35, 34, 44}, {44, 34, 24, 32, 42}, {35, 20,
              34}, {34, 20, 16, 24}, {36, 26, 21, 27, 37}, {20, 17, 11, 10, 
             16}}]]],
         "\"tridiminished rhombicosidodecahedron\""],
        Annotation[#, "tridiminished rhombicosidodecahedron", "Tooltip"]& ],
       TraditionalForm], {2949.2307692307686`, -2156.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, -2^Rational[-1, 2], Root[
              47 - 96 # - 608 #^2 + 1408 #^3 + 256 #^4 - 1024 #^5 - 512 #^6 + 
               512 #^8& , 1, 0]}, {
             0, 2^Rational[-1, 2], Root[
              47 - 96 # - 608 #^2 + 1408 #^3 + 256 #^4 - 1024 #^5 - 512 #^6 + 
               512 #^8& , 1, 0]}, {
             0, -(1 + 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[
               1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             0, (1 + 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[
               1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {-2^Rational[-1, 2], 0, Root[
              47 - 96 # - 608 #^2 + 1408 #^3 + 256 #^4 - 1024 #^5 - 512 #^6 + 
               512 #^8& , 1, 0]}, {
             2^Rational[-1, 2], 0, Root[
              47 - 96 # - 608 #^2 + 1408 #^3 + 256 #^4 - 1024 #^5 - 512 #^6 + 
               512 #^8& , 1, 0]}, {
             Rational[-1, 2] (1 + 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (1 - 2^Rational[-1, 2])^Rational[1, 2], Root[
              47 + 96 # - 608 #^2 - 1408 #^3 + 256 #^4 + 1024 #^5 - 512 #^6 + 
               512 #^8& , 6, 0]}, {
             Rational[1, 2] (1 + 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (1 - 2^Rational[-1, 2])^Rational[1, 2], Root[
              47 + 96 # - 608 #^2 - 1408 #^3 + 256 #^4 + 1024 #^5 - 512 #^6 + 
               512 #^8& , 6, 0]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {-(1 + 2^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[
               1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {(1 + 2^Rational[-1, 2])^Rational[1, 2], 0, 
              Rational[
               1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[
               1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[
               1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[
               1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2] (2 + 2^Rational[1, 2])^Rational[1, 2], 
              Rational[
               1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] - 2^Rational[-1, 2], 
              Rational[-1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2] + 2^Rational[-1, 2], 
              Rational[-1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2] - 2^Rational[-1, 2], 
              Rational[-1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2] + 2^Rational[-1, 2], 
              Rational[-1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[1, 2] + 2^Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 2] - 2^Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 2] - 2^Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 2] (-1 - 2^
                Rational[1, 2] + (5 + 7 2^Rational[-1, 2])^Rational[1, 2])^
               Rational[1, 2]}, {
             Rational[-1, 2] (1 - 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2] (1 + 2^Rational[-1, 2])^Rational[1, 2], Root[
              47 + 96 # - 608 #^2 - 1408 #^3 + 256 #^4 + 1024 #^5 - 512 #^6 + 
               512 #^8& , 6, 0]}, {
             Rational[1, 2] (1 - 2^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2] (1 + 2^Rational[-1, 2])^Rational[1, 2], Root[
              47 + 96 # - 608 #^2 - 1408 #^3 + 256 #^4 + 1024 #^5 - 512 #^6 + 
               512 #^8& , 6, 0]}}, {{
             0, -0.7071067811865475, -1.1372545661180333`}, {
             0, 0.7071067811865475, -1.1372545661180333`}, {
             0, -1.3065629648763766`, 0.43014778493148575`}, {
             0, 1.3065629648763766`, 
              0.43014778493148575`}, {-0.7071067811865475, 
              0, -1.1372545661180333`}, {
             0.7071067811865475, 
              0, -1.1372545661180333`}, {-0.6532814824381883, 
             0.2705980500730985, 1.1372545661180333`}, {
             0.6532814824381883, -0.2705980500730985, 1.1372545661180333`}, {
             1.2071067811865475`, 
             0.5, -0.43014778493148575`}, {-1.3065629648763766`, 0, 
              0.43014778493148575`}, {
             1.3065629648763766`, 0, 
              0.43014778493148575`}, {-0.9238795325112867, \
-0.9238795325112867, 0.43014778493148575`}, {-0.9238795325112867, 
             0.9238795325112867, 0.43014778493148575`}, {
             0.9238795325112867, -0.9238795325112867, 0.43014778493148575`}, {
             0.9238795325112867, 0.9238795325112867, 
             0.43014778493148575`}, {-0.5, -1.2071067811865475`, \
-0.43014778493148575`}, {0.5, 1.2071067811865475`, -0.43014778493148575`}, {
             0.5, -1.2071067811865475`, -0.43014778493148575`}, {-0.5, 
             1.2071067811865475`, -0.43014778493148575`}, {
             1.2071067811865475`, -0.5, -0.43014778493148575`}, \
{-1.2071067811865475`, 
             0.5, -0.43014778493148575`}, {-1.2071067811865475`, -0.5, \
-0.43014778493148575`}, {-0.2705980500730985, -0.6532814824381883, 
             1.1372545661180333`}, {0.2705980500730985, 0.6532814824381883, 
             1.1372545661180333`}}], 
           Polygon3DBox[{{9, 15, 11}, {17, 4, 15}, {19, 13, 4}, {21, 10, 
             13}, {22, 12, 10}, {16, 3, 12}, {18, 14, 3}, {20, 11, 14}, {9, 
             17, 15}, {17, 19, 4}, {19, 21, 13}, {21, 22, 10}, {22, 16, 12}, {
             16, 18, 3}, {18, 20, 14}, {20, 9, 11}, {24, 7, 23, 8}, {7, 24, 4,
              13}, {23, 7, 10, 12}, {8, 23, 3, 14}, {24, 8, 11, 15}, {15, 4, 
             24}, {13, 10, 7}, {12, 3, 23}, {14, 11, 8}, {5, 2, 6, 1}, {20, 
             18, 1, 6}, {17, 9, 6, 2}, {21, 19, 2, 5}, {16, 22, 5, 1}, {1, 18,
              16}, {6, 9, 20}, {2, 19, 17}, {5, 22, 21}}]]],
         "\"gyroelongated square bicupola\""],
        Annotation[#, "gyroelongated square bicupola", "Tooltip"]& ],
       TraditionalForm], {3342.461538461538, -2156.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), -
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
                2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
                10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
                2, 0]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), -
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
                2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
                10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
                2, 0]}, {
             Rational[1, 2] (-1 - 5^Rational[1, 2]), 0, 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Rational[1, 2] (1 + 5^Rational[1, 2]), 0, 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Root[5 - 20 #^2 + 16 #^4& , 1, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), -
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
                2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
                10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
                2, 0]}, {
             Root[5 - 20 #^2 + 16 #^4& , 1, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), -
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
                2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
                10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
                2, 0]}, {
             Root[5 - 20 #^2 + 16 #^4& , 4, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), -
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
                2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
                10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
                2, 0]}, {
             Root[5 - 20 #^2 + 16 #^4& , 4, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), -
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
                2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
                10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
                2, 0]}, {
             Rational[-1, 2], Root[5 - 40 #^2 + 16 #^4& , 1, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Rational[-1, 2], Root[5 - 40 #^2 + 16 #^4& , 4, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Rational[1, 2], Root[5 - 40 #^2 + 16 #^4& , 1, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Rational[1, 2], Root[5 - 40 #^2 + 16 #^4& , 4, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
              5 - 20 #^2 + 16 #^4& , 1, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
              5 - 20 #^2 + 16 #^4& , 4, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
              5 - 20 #^2 + 16 #^4& , 1, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
              5 - 20 #^2 + 16 #^4& , 4, 0], 
              Root[1 + 2 #^2 - 11 #^4 + 8 #^6 + #^8& , 1, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Root[5 - 40 #^2 + 16 #^4& , 1, 0], Rational[-1, 2], -
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
                2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
                10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
                2, 0]}, {
             Root[5 - 40 #^2 + 16 #^4& , 1, 0], Rational[1, 2], -
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
                2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
                10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
                2, 0]}, {
             Root[5 - 40 #^2 + 16 #^4& , 4, 0], Rational[-1, 2], -
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
                2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
                10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
                2, 0]}, {
             Root[5 - 40 #^2 + 16 #^4& , 4, 0], Rational[1, 2], -
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
                2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
                10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
                2, 0]}, {
             Root[1 - 10 #^2 + 5 #^4& , 4, 0], 0, 
              Root[1 - 5 #^2 + 5 #^4& , 4, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 4, 0], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Root[1 - 5 #^2 + 5 #^4& , 4, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 4, 0], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Root[1 - 5 #^2 + 5 #^4& , 4, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Root[1 - 5 #^2 + 5 #^4& , 4, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Root[1 - 5 #^2 + 5 #^4& , 4, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Root[1 - 5 #^2 + 5 #^4& , 1, 0], 0, 
              Root[1 - 10 #^2 + 5 #^4& , 4, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Root[1 - 10 #^2 + 5 #^4& , 4, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Root[1 - 10 #^2 + 5 #^4& , 4, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Root[1 - 40 #^2 + 80 #^4& , 4, 0], Rational[-1, 2], 
              Root[1 - 10 #^2 + 5 #^4& , 4, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}, {
             Root[1 - 40 #^2 + 80 #^4& , 4, 0], Rational[1, 2], 
              Root[1 - 10 #^2 + 5 #^4& , 4, 0] - 
              Root[-1134275041 + 44661048320 # - 591623768800 #^2 + 
               2613025843200 #^3 + 1458987101440 #^4 - 13318096486400 #^5 - 
               10622929920000 #^6 - 3906043904000 #^7 + 1113913753600 #^8& , 
               2, 0]}}, {{0, -1.618033988749895, -0.06886916020153731}, {
             0, 1.618033988749895, -0.06886916020153731}, {-1.618033988749895,
               0, -0.9312661640609983}, {
             1.618033988749895, 
              0, -0.9312661640609983}, {-0.9510565162951532, \
-1.3090169943749475`, -0.06886916020153731}, {-0.9510565162951532, 
             1.3090169943749475`, -0.06886916020153731}, {
             0.9510565162951536, -1.3090169943749475`, -0.06886916020153731}, \
{0.9510565162951536, 
             1.3090169943749475`, -0.06886916020153731}, {-0.5, \
-1.5388417685876268`, -0.9312661640609983}, {-0.5, 
             1.5388417685876268`, -0.9312661640609983}, {
             0.5, -1.5388417685876268`, -0.9312661640609983}, {0.5, 
             1.5388417685876268`, -0.9312661640609983}, \
{-1.3090169943749475`, -0.9510565162951532, -0.9312661640609983}, \
{-1.3090169943749475`, 0.9510565162951536, -0.9312661640609983}, {
             1.3090169943749475`, -0.9510565162951532, -0.9312661640609983}, {
             1.3090169943749475`, 
             0.9510565162951536, -0.9312661640609983}, {-1.5388417685876268`, \
-0.5, -0.06886916020153731}, {-1.5388417685876268`, 
             0.5, -0.06886916020153731}, {
             1.5388417685876268`, -0.5, -0.06886916020153731}, {
             1.5388417685876268`, 0.5, -0.06886916020153731}, {
             1.3763819204711736`, 0, 0.7817816481505027}, {
             0.42532540417602, -1.3090169943749475`, 0.7817816481505027}, {
             0.42532540417602, 1.3090169943749475`, 
             0.7817816481505027}, {-1.1135163644116068`, -0.8090169943749475, 
             0.7817816481505027}, {-1.1135163644116068`, 0.8090169943749475, 
             0.7817816481505027}, {-0.8506508083520394, 0, 
              1.3075127602696364`}, {-0.2628655560595671, -0.8090169943749475,
              1.3075127602696364`}, {-0.2628655560595671, 0.8090169943749475, 
             1.3075127602696364`}, {0.6881909602355868, -0.5, 
             1.3075127602696364`}, {0.6881909602355868, 0.5, 
             1.3075127602696364`}}], 
           Polygon3DBox[{{14, 10, 12, 16, 4, 15, 11, 9, 13, 3}, {3, 13, 17}, {
             13, 9, 5}, {9, 11, 1}, {11, 15, 7}, {15, 4, 19}, {4, 16, 20}, {
             16, 12, 8}, {12, 10, 2}, {10, 14, 6}, {14, 3, 18}, {13, 5, 17}, {
             9, 1, 5}, {11, 7, 1}, {15, 19, 7}, {4, 20, 19}, {16, 8, 20}, {12,
              2, 8}, {10, 6, 2}, {14, 18, 6}, {3, 17, 18}, {28, 26, 27, 29, 
             30}, {25, 26, 28}, {24, 27, 26}, {22, 29, 27}, {21, 30, 29}, {23,
              28, 30}, {8, 2, 23}, {6, 18, 25}, {17, 5, 24}, {1, 7, 22}, {19, 
             20, 21}, {2, 6, 25, 28, 23}, {18, 17, 24, 26, 25}, {5, 1, 22, 27,
              24}, {7, 19, 21, 29, 22}, {20, 8, 23, 30, 21}}]]],
         "\"gyroelongated pentagonal rotunda\""],
        Annotation[#, "gyroelongated pentagonal rotunda", "Tooltip"]& ],
       TraditionalForm], {3735.6923076923067`, -2156.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 10] (
                5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 10] (
                5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
                Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              Rational[1, 10] (5 + 
                2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
                Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[1, 10] (5 + 
                2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], 0, 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
                Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], 0, 
              Rational[1, 10] (5 + 
                2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (
                5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (
                5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
                Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (5 + 
                2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
                Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (5 + 
                2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[-1, 2], Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[-1, 2], Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2], 0, 
              Rational[1, 10] (
                5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}}, {{
             0, -1.618033988749895, -0.8350882332752827}, {
             0, -1.618033988749895, 0.16491176672471725`}, {
             0, 1.618033988749895, -0.8350882332752827}, {
             0, 1.618033988749895, 0.16491176672471725`}, {
             0.42532540417601994`, -1.3090169943749475`, 
             1.0155625750767574`}, {0.42532540417601994`, 1.3090169943749475`,
              1.0155625750767574`}, {
             0.6881909602355868, -0.5, -1.3608193453944164`}, {
             0.6881909602355868, -0.5, 1.541293687195891}, {
             0.6881909602355868, 0.5, -1.3608193453944164`}, {
             0.6881909602355868, 0.5, 
             1.541293687195891}, {-0.8506508083520399, 
              0, -1.3608193453944164`}, {-0.8506508083520399, 0, 
              1.541293687195891}, {-1.1135163644116066`, -0.8090169943749475, 
             1.0155625750767574`}, {-1.1135163644116066`, 0.8090169943749475, 
             1.0155625750767574`}, {-0.2628655560595668, -0.8090169943749475, \
-1.3608193453944164`}, {-0.2628655560595668, -0.8090169943749475, 
             1.541293687195891}, {-0.2628655560595668, 
             0.8090169943749475, -1.3608193453944164`}, {-0.2628655560595668, 
             0.8090169943749475, 
             1.541293687195891}, {-0.9510565162951535, -1.3090169943749475`, \
-0.8350882332752827}, {-0.9510565162951535, -1.3090169943749475`, 
             0.16491176672471725`}, {-0.9510565162951535, 
             1.3090169943749475`, -0.8350882332752827}, {-0.9510565162951535, 
             1.3090169943749475`, 0.16491176672471725`}, {
             0.9510565162951535, -1.3090169943749475`, -0.8350882332752827}, {
             0.9510565162951535, -1.3090169943749475`, 
             0.16491176672471725`}, {0.9510565162951535, 
             1.3090169943749475`, -0.8350882332752827}, {0.9510565162951535, 
             1.3090169943749475`, 
             0.16491176672471725`}, {-1.5388417685876268`, -0.5, \
-0.8350882332752827}, {-1.5388417685876268`, -0.5, 
             0.16491176672471725`}, {-1.5388417685876268`, 
             0.5, -0.8350882332752827}, {-1.5388417685876268`, 0.5, 
             0.16491176672471725`}, {
             1.5388417685876268`, -0.5, -0.8350882332752827}, {
             1.5388417685876268`, -0.5, 0.16491176672471725`}, {
             1.5388417685876268`, 0.5, -0.8350882332752827}, {
             1.5388417685876268`, 0.5, 0.16491176672471725`}, {
             1.3763819204711736`, 0, 1.0155625750767574`}}], 
           Polygon3DBox[{{18, 12, 16, 8, 10}, {14, 12, 18}, {13, 16, 12}, {5, 
             8, 16}, {35, 10, 8}, {6, 18, 10}, {26, 4, 6}, {22, 30, 14}, {28, 
             20, 13}, {2, 24, 5}, {32, 34, 35}, {4, 22, 14, 18, 6}, {30, 28, 
             13, 12, 14}, {20, 2, 5, 16, 13}, {24, 32, 35, 8, 5}, {34, 26, 6, 
             10, 35}, {7, 15, 11, 17, 9}, {3, 25, 9, 17}, {29, 21, 17, 11}, {
             19, 27, 11, 15}, {23, 1, 15, 7}, {33, 31, 7, 9}, {9, 25, 33}, {
             17, 21, 3}, {11, 27, 29}, {15, 1, 19}, {7, 31, 23}, {25, 3, 4, 
             26}, {3, 21, 22, 4}, {21, 29, 30, 22}, {29, 27, 28, 30}, {27, 19,
              20, 28}, {19, 1, 2, 20}, {1, 23, 24, 2}, {23, 31, 32, 24}, {31, 
             33, 34, 32}, {33, 25, 26, 34}}]]],
         "\"elongated pentagonal orthocupolarotunda\""],
        Annotation[#, "elongated pentagonal orthocupolarotunda", 
         "Tooltip"]& ],
       TraditionalForm], {4128.923076923076, -2156.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], 0, 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
                Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
                Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
                Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
                Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 2], 
              Rational[1, 10] (-5 - (10 (5 - 5^Rational[1, 2]))^
                Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[-1, 2], Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[-1, 2], Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], Rational[-1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], Rational[1, 2] + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[1, 5] (5 + 2 5^Rational[1, 2]))^Rational[1, 2], 0, 
              Rational[1, 10] (
                5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 10] (
                5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 10] (
                5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (
                5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (
                5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {-(
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], 0, 
              Rational[1, 10] (5 + 
                2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (5 + 
                2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (5 + 
                2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              Rational[1, 10] (5 + 
                2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[1, 10] (5 + 
                2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2]) + 
              Rational[1, 14320] (1660 + 422 5^Rational[1, 2] - 
                3 (4354450 + 775210 5^Rational[1, 2])^Rational[1, 2])}}, {{
             0, -1.618033988749895, -0.8350882332752827}, {
             0, -1.618033988749895, 0.16491176672471725`}, {
             0, 1.618033988749895, -0.8350882332752827}, {
             0, 1.618033988749895, 0.16491176672471725`}, {
             0.8506508083520399, 0, -1.3608193453944164`}, {
             0.2628655560595668, -0.8090169943749475, -1.3608193453944164`}, {
             0.2628655560595668, 
             0.8090169943749475, -1.3608193453944164`}, {-0.9510565162951535, \
-1.3090169943749475`, -0.8350882332752827}, {-0.9510565162951535, \
-1.3090169943749475`, 0.16491176672471725`}, {-0.9510565162951535, 
             1.3090169943749475`, -0.8350882332752827}, {-0.9510565162951535, 
             1.3090169943749475`, 0.16491176672471725`}, {
             0.9510565162951535, -1.3090169943749475`, -0.8350882332752827}, {
             0.9510565162951535, -1.3090169943749475`, 
             0.16491176672471725`}, {0.9510565162951535, 
             1.3090169943749475`, -0.8350882332752827}, {0.9510565162951535, 
             1.3090169943749475`, 
             0.16491176672471725`}, {-0.6881909602355868, -0.5, \
-1.3608193453944164`}, {-0.6881909602355868, 
             0.5, -1.3608193453944164`}, {-1.5388417685876268`, -0.5, \
-0.8350882332752827}, {-1.5388417685876268`, -0.5, 
             0.16491176672471725`}, {-1.5388417685876268`, 
             0.5, -0.8350882332752827}, {-1.5388417685876268`, 0.5, 
             0.16491176672471725`}, {
             1.5388417685876268`, -0.5, -0.8350882332752827}, {
             1.5388417685876268`, -0.5, 0.16491176672471725`}, {
             1.5388417685876268`, 0.5, -0.8350882332752827}, {
             1.5388417685876268`, 0.5, 0.16491176672471725`}, {
             1.3763819204711736`, 0, 1.0155625750767574`}, {
             0.42532540417601994`, -1.3090169943749475`, 
             1.0155625750767574`}, {0.42532540417601994`, 1.3090169943749475`,
              1.0155625750767574`}, {-1.1135163644116066`, \
-0.8090169943749475, 1.0155625750767574`}, {-1.1135163644116066`, 
             0.8090169943749475, 
             1.0155625750767574`}, {-0.8506508083520399, 0, 
              1.541293687195891}, {-0.2628655560595668, -0.8090169943749475, 
             1.541293687195891}, {-0.2628655560595668, 0.8090169943749475, 
             1.541293687195891}, {0.6881909602355868, -0.5, 
             1.541293687195891}, {0.6881909602355868, 0.5, 
             1.541293687195891}}], 
           Polygon3DBox[{{33, 31, 32, 34, 35}, {30, 31, 33}, {29, 32, 31}, {
             27, 34, 32}, {26, 35, 34}, {28, 33, 35}, {15, 4, 28}, {11, 21, 
             30}, {19, 9, 29}, {2, 13, 27}, {23, 25, 26}, {4, 11, 30, 33, 
             28}, {21, 19, 29, 31, 30}, {9, 2, 27, 32, 29}, {13, 23, 26, 34, 
             27}, {25, 15, 28, 35, 26}, {5, 6, 16, 17, 7}, {10, 3, 7, 17}, {
             18, 20, 17, 16}, {1, 8, 16, 6}, {22, 12, 6, 5}, {14, 24, 5, 7}, {
             7, 3, 14}, {17, 20, 10}, {16, 8, 18}, {6, 12, 1}, {5, 24, 22}, {
             14, 3, 4, 15}, {3, 10, 11, 4}, {10, 20, 21, 11}, {20, 18, 19, 
             21}, {18, 8, 9, 19}, {8, 1, 2, 9}, {1, 12, 13, 2}, {12, 22, 23, 
             13}, {22, 24, 25, 23}, {24, 14, 15, 25}}]]],
         "\"elongated pentagonal gyrocupolarotunda\""],
        Annotation[#, "elongated pentagonal gyrocupolarotunda", "Tooltip"]& ],
       
       TraditionalForm], {4522.153846153846, -2156.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[{{-1.1689224117344201`*^-17, \
-1.618033988749895, -0.4311985019297303}, {-1.1689224117344201`*^-17, 
           1.618033988749895, -0.4311985019297303}, \
{-1.1689224117344201`*^-17, -0.8506508083520394, 
           0.956929614048863}, {-1.618033988749895, -1.039042143763929*^-17, 
           0.4311985019297293}, {-0.8506508083520394, \
-1.039042143763929*^-17, -0.9569296140488626}, {-0.5, -1.5388417685876268`, 
           0.4311985019297293}, {-0.2628655560595671, -0.8090169943749475, \
-0.9569296140488626}, {-0.2628655560595671, 
           0.8090169943749475, -0.9569296140488626}, {
           1.618033988749895, -1.039042143763929*^-17, 
           0.4311985019297293}, {-0.9510565162951535, -1.3090169943749475`, \
-0.4311985019297303}, {-0.9510565162951535, 
           1.3090169943749475`, -0.4311985019297303}, {
           0.9510565162951535, -1.3090169943749475`, -0.4311985019297303}, {
           0.9510565162951535, 1.3090169943749475`, -0.4311985019297303}, {
           0.6881909602355868, -0.5, -0.9569296140488626}, {
           0.6881909602355868, 0.5, -0.9569296140488626}, {-0.5, 
           1.5388417685876268`, 0.4311985019297293}, {
           0.5, -1.5388417685876268`, 0.4311985019297293}, {0.5, 
           1.5388417685876268`, 
           0.4311985019297293}, {-1.3090169943749475`, -0.9510565162951535, 
           0.4311985019297293}, {-1.3090169943749475`, 0.9510565162951535, 
           0.4311985019297293}, {1.3090169943749475`, -0.9510565162951535, 
           0.4311985019297293}, {1.3090169943749475`, 0.9510565162951535, 
           0.4311985019297293}, {-1.5388417685876268`, -0.5, \
-0.4311985019297303}, {-1.5388417685876268`, 0.5, -0.4311985019297303}, {
           1.5388417685876268`, -0.5, -0.4311985019297303}, {
           1.5388417685876268`, 0.5, -0.4311985019297303}, {
           0.8090169943749475, -0.2628655560595671, 0.956929614048863}, {0.5, 
           0.6881909602355868, 
           0.956929614048863}, {-0.8090169943749475, -0.2628655560595671, 
           0.956929614048863}, {-0.5, 0.6881909602355868, 0.956929614048863}},
            Polygon3DBox[{{26, 22, 9}, {13, 18, 22}, {2, 16, 18}, {11, 20, 
             16}, {24, 4, 20}, {23, 19, 4}, {10, 6, 19}, {1, 17, 6}, {12, 21, 
             17}, {25, 9, 21}, {26, 13, 22}, {13, 2, 18}, {2, 11, 16}, {11, 
             24, 20}, {24, 23, 4}, {23, 10, 19}, {10, 1, 6}, {1, 12, 17}, {12,
              25, 21}, {25, 26, 9}, {28, 30, 29, 3, 27}, {30, 28, 18, 16}, {
             29, 30, 20, 4}, {3, 29, 19, 6}, {27, 3, 17, 21}, {28, 27, 9, 
             22}, {22, 18, 28}, {16, 20, 30}, {4, 19, 29}, {6, 17, 3}, {21, 9,
              27}, {5, 8, 15, 14, 7}, {12, 1, 7, 14}, {26, 25, 14, 15}, {2, 
             13, 15, 8}, {24, 11, 8, 5}, {10, 23, 5, 7}, {7, 1, 10}, {14, 25, 
             12}, {15, 13, 26}, {8, 11, 2}, {5, 23, 24}}]]],
         "\"gyroelongated pentagonal bicupola\""],
        Annotation[#, "gyroelongated pentagonal bicupola", "Tooltip"]& ],
       TraditionalForm], {196.6153846153846, -2548.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), Rational[-1, 2]}, {
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), Rational[1, 2]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), Rational[-1, 2]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), Rational[
              1, 2]}, {-(Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 + 5^Rational[1, 2]))^
               Rational[1, 2])}, {-(Rational[1, 8] + 
                Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 + 5^Rational[1, 2]))^
               Rational[1, 2])}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 10] (
               5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2])}, {(
               Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 10] (
               5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              Rational[1, 10] (-5 - 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 2], 
              Rational[1, 10] (-5 - 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              Rational[1, 10] (5 + 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[1, 10] (5 + 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], 0, 
              Rational[1, 10] (5 + 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {(
               Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], 0, 
              Rational[1, 10] (-5 - 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (
               5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (
               5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2])}, {(
               Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 + 5^Rational[1, 2]))^
               Rational[1, 2])}, {(Rational[5, 8] + 
               Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 + 5^Rational[1, 2]))^
               Rational[1, 2])}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (5 + 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (5 + 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 
               2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[
              1, 2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 
               2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[
              1, 2]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 2]}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), Rational[
              1, 2]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 2]}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), Rational[
              1, 2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 
               2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], Rational[
              1, 2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], 
              Rational[-1, 
               2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], Rational[
              1, 2]}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], Rational[
              1, 2]}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[
              1, 2]}, {-(Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
               Rational[1, 2], 0, 
              Rational[1, 10] (-5 - (10 (5 + 5^Rational[1, 2]))^
               Rational[1, 2])}, {(Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
              Rational[1, 2], 0, 
              Rational[1, 10] (
               5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2])}}, {{
             0, -1.618033988749895, -0.5}, {0, -1.618033988749895, 0.5}, {
             0, 1.618033988749895, -0.5}, {
             0, 1.618033988749895, 
              0.5}, {-0.42532540417601994`, -1.3090169943749475`, \
-1.35065080835204}, {-0.42532540417601994`, 
             1.3090169943749475`, -1.35065080835204}, {
             0.42532540417601994`, -1.3090169943749475`, 1.35065080835204}, {
             0.42532540417601994`, 1.3090169943749475`, 
             1.35065080835204}, {-0.6881909602355868, -0.5, \
-1.8763819204711738`}, {-0.6881909602355868, 0.5, -1.8763819204711738`}, {
             0.6881909602355868, -0.5, 1.8763819204711738`}, {
             0.6881909602355868, 0.5, 
             1.8763819204711738`}, {-0.8506508083520399, 0, 
              1.8763819204711738`}, {
             0.8506508083520399, 
              0, -1.8763819204711738`}, {-1.1135163644116066`, \
-0.8090169943749475, 1.35065080835204}, {-1.1135163644116066`, 
             0.8090169943749475, 1.35065080835204}, {
             1.1135163644116066`, -0.8090169943749475, -1.35065080835204}, {
             1.1135163644116066`, 
             0.8090169943749475, -1.35065080835204}, {-0.2628655560595668, \
-0.8090169943749475, 1.8763819204711738`}, {-0.2628655560595668, 
             0.8090169943749475, 1.8763819204711738`}, {
             0.2628655560595668, -0.8090169943749475, -1.8763819204711738`}, {
             0.2628655560595668, 
             0.8090169943749475, -1.8763819204711738`}, {-0.9510565162951535, \
-1.3090169943749475`, -0.5}, {-0.9510565162951535, -1.3090169943749475`, 
             0.5}, {-0.9510565162951535, 
             1.3090169943749475`, -0.5}, {-0.9510565162951535, 
             1.3090169943749475`, 0.5}, {
             0.9510565162951535, -1.3090169943749475`, -0.5}, {
             0.9510565162951535, -1.3090169943749475`, 0.5}, {
             0.9510565162951535, 1.3090169943749475`, -0.5}, {
             0.9510565162951535, 1.3090169943749475`, 
             0.5}, {-1.5388417685876268`, -0.5, -0.5}, {-1.5388417685876268`, \
-0.5, 0.5}, {-1.5388417685876268`, 0.5, -0.5}, {-1.5388417685876268`, 0.5, 
             0.5}, {1.5388417685876268`, -0.5, -0.5}, {
             1.5388417685876268`, -0.5, 0.5}, {1.5388417685876268`, 
             0.5, -0.5}, {1.5388417685876268`, 0.5, 
             0.5}, {-1.3763819204711736`, 0, -1.35065080835204}, {
             1.3763819204711736`, 0, 1.35065080835204}}], 
           Polygon3DBox[{{20, 13, 19, 11, 12}, {16, 13, 20}, {15, 19, 13}, {7,
              11, 19}, {40, 12, 11}, {8, 20, 12}, {30, 4, 8}, {26, 34, 16}, {
             32, 24, 15}, {2, 28, 7}, {36, 38, 40}, {4, 26, 16, 20, 8}, {34, 
             32, 15, 13, 16}, {24, 2, 7, 19, 15}, {28, 36, 40, 11, 7}, {38, 
             30, 8, 12, 40}, {14, 21, 9, 10, 22}, {22, 10, 6}, {10, 9, 39}, {
             9, 21, 5}, {21, 14, 17}, {14, 22, 18}, {18, 29, 37}, {6, 25, 
             3}, {39, 31, 33}, {5, 1, 23}, {17, 35, 27}, {18, 22, 6, 3, 29}, {
             6, 10, 39, 33, 25}, {39, 9, 5, 23, 31}, {5, 21, 17, 27, 1}, {17, 
             14, 18, 37, 35}, {29, 3, 4, 30}, {3, 25, 26, 4}, {25, 33, 34, 
             26}, {33, 31, 32, 34}, {31, 23, 24, 32}, {23, 1, 2, 24}, {1, 27, 
             28, 2}, {27, 35, 36, 28}, {35, 37, 38, 36}, {37, 29, 30, 38}}]]],
         
         "\"elongated pentagonal gyrobirotunda\""],
        Annotation[#, "elongated pentagonal gyrobirotunda", "Tooltip"]& ],
       TraditionalForm], {589.8461538461538, -2548.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), Rational[-1, 2]}, {
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), Rational[1, 2]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), Rational[-1, 2]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), Rational[
              1, 2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 
               2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[
              1, 2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 
               2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[
              1, 2]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 2]}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), Rational[
              1, 2]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 2]}, {(Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), Rational[
              1, 2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 
               2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[-1, 2], Rational[
              1, 2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], 
              Rational[-1, 
               2]}, {-(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
               Rational[1, 2], Rational[1, 2], Rational[
              1, 2]}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2]}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], Rational[
              1, 2]}, {(Rational[5, 4] + Rational[1, 2] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2]}, {(Rational[5, 4] + 
               Rational[1, 2] 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], Rational[
              1, 2]}, {(Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
              Rational[1, 2], 0, 
              Rational[1, 10] (-5 - (10 (5 + 5^Rational[1, 2]))^
               Rational[1, 2])}, {(Rational[1, 5] (5 + 2 5^Rational[1, 2]))^
              Rational[1, 2], 0, 
              Rational[1, 10] (
               5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2])}, {(
               Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 + 5^Rational[1, 2]))^
               Rational[1, 2])}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[1, 10] (
               5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2])}, {(
               Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 + 5^Rational[1, 2]))^
               Rational[1, 2])}, {(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[1, 10] (
               5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 + 5^Rational[1, 2]))^
               Rational[1, 2])}, {-(Rational[5, 8] + 
                Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (
               5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - (10 (5 + 5^Rational[1, 2]))^
               Rational[1, 2])}, {-(Rational[5, 8] + 
                Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (
               5 + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], 0, 
              Rational[1, 10] (-5 - 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {-(
                Rational[1, 2] + Rational[1, 2] 5^Rational[-1, 2])^
               Rational[1, 2], 0, 
              Rational[1, 10] (5 + 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Rational[1, 10] (5 + 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (-5 - 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Rational[1, 10] (5 + 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              Rational[1, 10] (-5 - 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[-1, 2], 
              Rational[1, 10] (5 + 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[1, 10] (-5 - 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}, {(
               Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
              Rational[1, 2], Rational[1, 2], 
              Rational[1, 10] (5 + 
               2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])}}, {{
             0, -1.618033988749895, -0.5}, {0, -1.618033988749895, 0.5}, {
             0, 1.618033988749895, -0.5}, {
             0, 1.618033988749895, 
              0.5}, {-0.9510565162951535, -1.3090169943749475`, -0.5}, \
{-0.9510565162951535, -1.3090169943749475`, 0.5}, {-0.9510565162951535, 
             1.3090169943749475`, -0.5}, {-0.9510565162951535, 
             1.3090169943749475`, 0.5}, {
             0.9510565162951535, -1.3090169943749475`, -0.5}, {
             0.9510565162951535, -1.3090169943749475`, 0.5}, {
             0.9510565162951535, 1.3090169943749475`, -0.5}, {
             0.9510565162951535, 1.3090169943749475`, 
             0.5}, {-1.5388417685876268`, -0.5, -0.5}, {-1.5388417685876268`, \
-0.5, 0.5}, {-1.5388417685876268`, 0.5, -0.5}, {-1.5388417685876268`, 0.5, 
             0.5}, {1.5388417685876268`, -0.5, -0.5}, {
             1.5388417685876268`, -0.5, 0.5}, {1.5388417685876268`, 
             0.5, -0.5}, {1.5388417685876268`, 0.5, 0.5}, {
             1.3763819204711736`, 0, -1.35065080835204}, {
             1.3763819204711736`, 0, 1.35065080835204}, {
             0.42532540417601994`, -1.3090169943749475`, -1.35065080835204}, {
             0.42532540417601994`, -1.3090169943749475`, 1.35065080835204}, {
             0.42532540417601994`, 1.3090169943749475`, -1.35065080835204}, {
             0.42532540417601994`, 1.3090169943749475`, 
             1.35065080835204}, {-1.1135163644116066`, -0.8090169943749475, \
-1.35065080835204}, {-1.1135163644116066`, -0.8090169943749475, 
             1.35065080835204}, {-1.1135163644116066`, 
             0.8090169943749475, -1.35065080835204}, {-1.1135163644116066`, 
             0.8090169943749475, 
             1.35065080835204}, {-0.8506508083520399, 
              0, -1.8763819204711738`}, {-0.8506508083520399, 0, 
              1.8763819204711738`}, {-0.2628655560595668, \
-0.8090169943749475, -1.8763819204711738`}, {-0.2628655560595668, \
-0.8090169943749475, 1.8763819204711738`}, {-0.2628655560595668, 
             0.8090169943749475, -1.8763819204711738`}, {-0.2628655560595668, 
             0.8090169943749475, 1.8763819204711738`}, {
             0.6881909602355868, -0.5, -1.8763819204711738`}, {
             0.6881909602355868, -0.5, 1.8763819204711738`}, {
             0.6881909602355868, 0.5, -1.8763819204711738`}, {
             0.6881909602355868, 0.5, 1.8763819204711738`}}], 
           Polygon3DBox[{{36, 32, 34, 38, 40}, {30, 32, 36}, {28, 34, 32}, {
             24, 38, 34}, {22, 40, 38}, {26, 36, 40}, {12, 4, 26}, {8, 16, 
             30}, {14, 6, 28}, {2, 10, 24}, {18, 20, 22}, {4, 8, 30, 36, 
             26}, {16, 14, 28, 32, 30}, {6, 2, 24, 34, 28}, {10, 18, 22, 38, 
             24}, {20, 12, 26, 40, 22}, {39, 37, 33, 31, 35}, {35, 31, 29}, {
             31, 33, 27}, {33, 37, 23}, {37, 39, 21}, {39, 35, 25}, {25, 3, 
             11}, {29, 15, 7}, {27, 5, 13}, {23, 9, 1}, {21, 19, 17}, {25, 35,
              29, 7, 3}, {29, 31, 27, 13, 15}, {27, 33, 23, 1, 5}, {23, 37, 
             21, 17, 9}, {21, 39, 25, 11, 19}, {11, 3, 4, 12}, {3, 7, 8, 4}, {
             7, 15, 16, 8}, {15, 13, 14, 16}, {13, 5, 6, 14}, {5, 1, 2, 6}, {
             1, 9, 10, 2}, {9, 17, 18, 10}, {17, 19, 20, 18}, {19, 11, 12, 
             20}}]]],
         "\"elongated pentagonal orthobirotunda\""],
        Annotation[#, "elongated pentagonal orthobirotunda", "Tooltip"]& ],
       TraditionalForm], {983.0769230769231, -2548.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwtlGtQ1GUYxf8rkVPoZtZuEpiCxDpQjDmNDZY+/2BlnLgsKKZQmMIASyAJ
zaprjHYjFJNxNAQCli7LLB/M0SUugnbWdposE7nuiqWQkIusOMRuurvpkvN/
+vB+eT687/uc8zsnLPu9DblzBEFY+fAEPDzCa/XlMQdkFrm+8ULbPhvGAuIP
0obLqH02aaJyULAkmUMevDNjhamnc7WzyEFVfWUdrZmCJffJs78enj9Kw0sC
xg5ccWB1SFDO0zv90GUrEkdjJsn7lX9ZeNcknVq3y60ffgB7xK684RoXrWta
mHPZ0YrISmfJePd9aK6kKz9qd6L3sT0FCcppqNtODt3Z5gNMH/cH51Xihdi+
W3GLPCjC1ug3nvDieLFju91og9pwuOW3AQ/F1Ydpp1T3kKxeODZy/g4pU2N0
ppK7KGvuO7fe9g/Ka7R184bHKK9ixWLtXh/9uMYwNZvohmbt16VzZny0abDb
hQoHGnq/CNv4gQsd5lij7+g9km+xNxTumSG/b9bcOT4DTeTzf+U85afvplY1
377ZQ3Kf99FvlX9j94cDp2eDPLg//5IhTeVGquLUJnnVJDybDd3GLKBW82Jw
eJVgKR6Mve595hZat7qzM4ecOGJ+WZtR6Cfxz+q9QaHjCPx0wmwlJy1q7zjX
optFxC8VgjHiOmT5Lc2209NY2qP/5vsTfvwxUro9P/0ack0JKa11N6nOXf3S
0UOCmK7Zl+5uHwKWH+vcHy2IOx5fqmt6+za0n++fPjIxgKauFn+yy0MjZ/pv
qBReSj02GrU5uR/KyYLy7kjBkuZK/OHgkimMxge+aw/uxc+hQyUrzsrE36OS
6FpkB631FFztev8MGoozjiv0F7E46zNvhlUmrlEXlu+0n0Bd/LItRSEeZJ0c
WZmS6aP4OGlO9TwnLc9ReVe6h9R8Dz3H91hWqaV36Ty/a/kpWnoXC/ifpOB/
inr+J6l5LzLxXhjkvVDKOpCVdbAksg6UwrrRbtYNtaybZdsFSWdy5Ek6Uzjr
TK+yL6RiXzCXfaEG9pEusY9Uxj5iHvtOy9+UfKca9l0MZE6okDkhmVzihEL/
lbii9cwVrMwVqplDamQOsYA5xA3mljYyt1Axt/QJc075zDmSmHOkcS5Iw7lA
IOeC3uIc0VXOESVwjhDLuaPXOXf0f+5IwTmlHZxTsnFO6SLnmsC5RgjnmjTc
A0TcA2jjHsCX3BviK9wb6OPeIAP3jGjkniEd9wzmci+JUdxL1PiI1Ev0HxNj
hFg=
           "], 
           Polygon3DBox[{{23, 20, 11, 13}, {13, 11, 5}, {11, 9, 3, 5}, {20, 
             26, 17, 9, 11}, {9, 7, 3}, {3, 7, 6, 1}, {17, 15, 7, 9}, {17, 27,
              15}, {27, 32, 18, 15}, {15, 18, 14, 6, 7}, {32, 30, 18}, {18, 
             30, 22, 14}, {13, 5, 4, 12}, {12, 4, 10}, {4, 2, 8, 10}, {5, 3, 
             1, 2, 4}, {25, 16, 8, 2, 1, 6, 14, 22, 28, 31}, {12, 10, 19, 
             21}, {21, 19, 33}, {19, 24, 36, 33}, {10, 8, 16, 24, 19}, {24, 
             34, 36}, {36, 34, 42, 44}, {16, 25, 34, 24}, {25, 31, 40, 42, 
             34}, {31, 28, 38, 40}, {21, 33, 37, 29}, {29, 37, 45, 50, 49, 43,
              35, 26, 20, 23}, {33, 36, 44, 45, 37}, {44, 48, 50, 45}, {44, 
             42, 48}, {42, 40, 46, 48}, {48, 46, 47, 49, 50}, {40, 38, 46}, {
             46, 38, 39, 47}, {26, 35, 27, 17}, {49, 47, 41, 43}, {43, 41, 32,
              27, 35}, {47, 39, 41}, {41, 39, 30, 32}, {23, 13, 12, 21, 29}, {
             39, 38, 28, 22, 30}}]]],
         "\"parabidiminished rhombicosidodecahedron\""],
        Annotation[#, "parabidiminished rhombicosidodecahedron", 
         "Tooltip"]& ],
       TraditionalForm], {1376.3076923076924`, -2548.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwBwQQ++yFib1JlAgAAADIAAAADAAAAVcktQ7vZAMBNtv49FfXTv9+WHNac
raG/rFgLLquo/7/iWDJOWjjjPyzCc77dFtu/QRu4mx6E/78ZEM7GeNSuP2zz
BwBVRuw/Q+FnQ1N5/b/2lJ55LCDvP4G3X9x/q98/E7VpwkCg/L9SyoM2ZBDn
v7aM4U+HfOy/SmFhzlor/L/lknxIjgD0v+v1UAhKqKW/InsZanWV+r8mprfa
AorIPxfS3DCOdvS/jcITa1Gi+L+i/2U3or3kv7ODeXSBF/c/jELsXcfe979a
AHvhbnnoP4JLqMDKh/Y/t4L6UqnS9r9rMpoyNTjyP6u5vG/u9fC/q8Ll6M6Q
9r81XY4U7VP3v8Srm/JQ3+s/7eOs759J87+mxWNf8tn7P9NG/VNVO9s/cCJH
tyWi8b/h2G1/UDn1v/j1kjcQqvS/0c4+wz8t8b+NhqisrLH9v8vdkn87ZNy/
0ulHLfr88L8ZAILaUeisP3fVHbUhfP8/+lNdKqRa7r8mQiHdSH79P7bPMF6c
IuG/jPtgKH+o7L8mlIAoBDDDPyccIc5xuv6/VopiFChe679X+1GTk4b4P0Wv
jx7Aa/U/QGCGu2cl579xKF28hYIAwO+YrqZvD94/qgoj+uYi5b9PUFNc9Yzx
P6UDAQ3SOfu/3JhsuEeY4b96pdnnkDrpvzO/sjdH2v6/hUZXtSew07/ZaO+C
7Fz+v2cBKX3yXPG/57yBvEhk07+zgGnPTZEAQDfM3zwSd+Y/KmUt+uFgx7/v
X9oGCdP8P+exXMwx1fK/tqjbZWNjxL8bLw05r7/YP+E0R79q9AFAKKlGlIqY
p7/5PkgOeWMBQK5Nn5ZpktC/iGNnjSI0oL+pJdxEXsn0P91dovWKsP0/sEhD
hOMpmz8rcp3gW2/fP7OZUU7P0gDAliLYbb9Pzz/BYm535MD1v6XKSH0pjfu/
4fnHt2yU0D+PXZEnPN8BwOSbBXjvH9k/SfksGA3T1z+NI1YDyJ3cvzlrGgO6
4gDAcnDgENKC4D9Jn7LoEA0BwL6lLExPMOK/njVLjcGo4D+vK11QZmX9P8KU
gvVTgPM/ygPfmGWX6T/F9XEwnBn6PyTxBtgREfS/KnPzPcVW6j9GDNe+97PL
P0UVcrl6VgFAUAM7nWq67T+eMC1vAEnqPxSfMtPqOP2/uvIlbhX27T/iCRSj
wgYAQNZKSMXpgdW/HOeT7lts7j9vu3Nu8Q/yP7Ie+OmqdPw/IA6B42oX8T9t
OOTFGX75vyMcNqZeSPO/RXN+7qiV8j9pf7MPz3X+v6L2405faeU/zrKXBlFl
9D/00WQWjOy9vyhCxDzAWP2/D5iOnJaV9D94SRZ6Jrr8P5yVfLDgeOI/A638
yPax9j/hAvaReNH8v9f5lnLPrdK/L0wcqn0p+D/dSESxferYv9X6QeMoQfw/
6UtKLAA7+j+5byxluy/zv/tMFuhPGfM/gws8Nx5H+z+aep9Ge2jqv1m4Tkhp
ZPS/yfAyzWN3+z8p2SyYsWTxP7LUs0zHMPI/K9VbDtVwAECxh2FvnIfwvw5r
+fr5Hde/CpGWwr9/AEBWnn/5RAvDP6AxIuPxEPI/75CtA4GIAUBS01azZifl
v14H7c8x0uE/sBCHvA==
           "], 
           Polygon3DBox[{{37, 34, 24, 26}, {26, 24, 16}, {24, 20, 10, 16}, {
             34, 36, 28, 20, 24}, {28, 17, 20}, {20, 17, 7, 10}, {31, 21, 17, 
             28}, {31, 29, 21}, {29, 22, 13, 21}, {21, 13, 5, 7, 17}, {22, 14,
              13}, {13, 14, 6, 5}, {26, 16, 12, 23}, {23, 12, 18}, {12, 4, 9, 
             18}, {16, 10, 2, 4, 12}, {4, 3, 9}, {9, 3, 8, 15}, {2, 1, 3, 
             4}, {10, 7, 2}, {7, 5, 1, 2}, {1, 6, 11, 8, 3}, {5, 6, 1}, {6, 
             14, 19, 11}, {23, 18, 27, 33}, {33, 27, 38}, {27, 25, 35, 38}, {
             18, 9, 15, 25, 27}, {45, 44, 35, 25, 15, 8, 11, 19, 30, 40}, {33,
              38, 47, 42}, {42, 47, 49, 50, 48, 46, 41, 36, 34, 37}, {38, 35, 
             44, 49, 47}, {44, 45, 50, 49}, {45, 40, 43, 48, 50}, {40, 30, 32,
              43}, {36, 41, 31, 28}, {48, 43, 39, 46}, {46, 39, 29, 31, 41}, {
             43, 32, 39}, {39, 32, 22, 29}, {37, 26, 23, 33, 42}, {32, 30, 19,
              14, 22}}]]],
         "\"gyrate bidiminished rhombicosidodecahedron\""],
        Annotation[#, "gyrate bidiminished rhombicosidodecahedron", 
         "Tooltip"]& ],
       TraditionalForm], {1769.5384615384614`, -2548.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwBwQQ++yFib1JlAgAAADIAAAADAAAAbkpj6EmwAMDhdtk3nv/VvzR5eoDH
Jtk/xOSu9JHn/7+Bb9SkxbDcv2a8lbi8HOO/2PpK6APi/7+bzPAiabbkP5FC
i+CSAtM/vkozDAJp/r9DUHNs1V3hP7pXjQjXLua/GAUI2MTy/L9UI9Xd0pPz
v6Txb5lDdns/KqIKNHwZ+7+hpZVlJW7jv1BpqqdiY/Q/TlzCTjUJ+b8QB4dZ
EO/1P1eKGb56TM+/bJNAk3yu+L/tJkXKaOHvP8SVSTRq5/E/UEtbo3c+97/9
wzicsTDsv1RWicqGF/W/YhJMO62r9r90mKkC/sr3v+J1ShZOauw/sLOZdq+5
9b+uYBSEl0jMP+vjLdQ+kfs/mjyRAnjT9L+lCKKT3B7nP9Yp6j1/k/e/tGu0
hqpJ9L90abxC+n/6vzoQSlVk2+a/3vS3+a3V8b89NDEtkIT7P60nx0hseuI/
yKzSCall8L8CCm4w6CPEv0BYb9q6wf2/UJxAilbn7r9BYx7tk8/4P0OvZhGj
ZfC/XAT4uSwd578kv1wIZU33P9pe7+vmVvc/ALsk+kBo5b9IDSWvdp/3vx2G
SOTF6fe/SEkGKqxC5L/KIdnxDakAwDwWzOLPxeY/DOnWcahQ4b/ogHjfMn8B
wIHFDSyh1NG/8ESqgJIz4b+Lb3knh8vlP33W6cVdgABA4NIyz0Mq278pHTeI
bOPxP2AnpX/L7vu/IPhNHI/azr892SzONRfovwVEF/r8SQDAIGibVzdmzr+J
pss1R+wAQEhZooqnh9M/oChx2A/mwr/evMLCCXzOP+MqFY6DDgHAQOfddiie
wr90RyxIIhYAQGbMgbNM7OW/QTfTFrqmrT/i0qwV8Q4AwDrvpgQ88fC/UC1E
joXSwz/u18JGY6H9P1thNKqa+/I/aHFrRS7t1j9Grne6YVQBwDCwnP4JAeo/
GHLfCVVV2T/OSHErHUD5P01e/8dOf/a/aDHKtTXR3D9iDReohioCwGsi2ehZ
vMa/mHkjmGEL3T+rPf8EOB7jPwD93UwsTwFAlIOohZ8C6D9JC6fwhMTqv/46
RuZc9v6/rCfVdrUf6D8UGi1t80AAQGCNQ8Ib/tk/tLefVr//6j+e89k4zcbD
P10EIQe1PwDA7IcEL7kR6z/8dRv/nNX+P1QysZcSseK/1Pki/0037D9/P47K
9yL1Pxz41Ykk9Pk//EL2vjns7T8EjfPs48n5v8/sYUaITPW/om2fxzHb8j/c
MLXREkz7vy0h9LYBcPI/UsrAaKzf8j8NO9GU/nHvPzSOvuGNUfm/LsxRjC/N
8z/Axs7bhfhfPxjK/H8ZzP8/PhQ3fDQ99T/sAcgRDwH+v42HWPtdy9y/Eosz
CTGx9z/DmyVeewP4P/jzZKAh8Oo/+lsQhf46+D/Bo89c2hfsv8Cbd+Pdnfk/
wjHLvTMT+j++yhIef071PyKSL8uQVei/vmraJf6l+j/pKAvTszfnPxPIFnDl
Ifc/sntB0btw/D+41B0+j2v4v+2MQvW3z9c/O5JDrSUtAECmVT75UxfxP/oc
QB+G7r4/ETVZR0ToAEB566A101bmv1A7qFOUQ+o/FQKXO4ynAUA3OXkSyr7S
P9OfsAN6Mec/w7B/Dw==
           "], 
           Polygon3DBox[{{45, 40, 30, 36}, {36, 30, 26}, {30, 22, 16, 26}, {
             40, 35, 25, 22, 30}, {22, 12, 16}, {16, 12, 4, 7}, {25, 15, 12, 
             22}, {25, 23, 15}, {23, 18, 9, 15}, {15, 9, 2, 4, 12}, {18, 13, 
             9}, {9, 13, 5, 2}, {36, 26, 24, 34}, {34, 24, 28}, {24, 14, 17, 
             28}, {26, 16, 7, 14, 24}, {14, 8, 17}, {17, 8, 11, 21}, {7, 3, 8,
              14}, {7, 4, 3}, {4, 2, 1, 3}, {3, 1, 6, 11, 8}, {2, 5, 1}, {1, 
             5, 10, 6}, {34, 28, 37, 43}, {43, 37, 46}, {37, 32, 41, 46}, {28,
              17, 21, 32, 37}, {39, 44, 41, 32, 21, 11, 6, 10, 19, 29}, {43, 
             46, 50, 48}, {48, 50, 49, 47, 42, 38, 33, 35, 40, 45}, {46, 41, 
             44, 49, 50}, {44, 39, 47, 49}, {39, 29, 31, 42, 47}, {29, 19, 20,
              31}, {35, 33, 23, 25}, {42, 31, 27, 38}, {38, 27, 18, 23, 33}, {
             31, 20, 27}, {27, 20, 13, 18}, {45, 36, 34, 43, 48}, {20, 19, 10,
              5, 13}}]]],
         "\"metabidiminished rhombicosidodecahedron\""],
        Annotation[#, "metabidiminished rhombicosidodecahedron", 
         "Tooltip"]& ],
       TraditionalForm], {2162.7692307692305`, -2548.}, {Center, Center}, {359.9999999999998, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwBKQbW+SFib1JlAgAAAEEAAAADAAAAGWGVDWLPCMCoNbDY0/7Jv2Y914Wc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           "], 
           Polygon3DBox[{{32, 27, 20, 10, 6, 4, 8, 18, 25, 31}, {35, 31, 
             25}, {60, 54, 45, 37, 32, 31, 35, 42, 52, 58}, {46, 52, 42}, {37,
              27, 32}, {38, 28, 22, 17, 20, 27, 37, 45, 50, 48}, {54, 50, 
             45}, {17, 10, 20}, {9, 5, 1, 2, 6, 10, 17, 22, 21, 15}, {28, 21, 
             22}, {2, 4, 6}, {11, 13, 14, 12, 8, 4, 2, 1, 3, 7}, {5, 3, 1}, {
             12, 18, 8}, {40, 46, 42, 35, 25, 18, 12, 14, 23, 33}, {13, 23, 
             14}, {51, 41, 34, 29, 30, 36, 43, 53, 59, 57}, {63, 57, 59}, {46,
              40, 39, 44, 51, 57, 63, 64, 58, 52}, {60, 58, 64}, {44, 41, 
             51}, {13, 11, 16, 24, 34, 41, 44, 39, 33, 23}, {40, 33, 39}, {24,
              29, 34}, {5, 9, 19, 26, 30, 29, 24, 16, 7, 3}, {11, 7, 16}, {26,
              36, 30}, {28, 38, 47, 49, 43, 36, 26, 19, 15, 21}, {9, 15, 
             19}, {49, 53, 43}, {48, 47, 38}, {61, 55, 56, 62, 65}, {55, 61, 
             53, 49}, {55, 49, 47}, {56, 55, 47, 48}, {56, 48, 50}, {62, 56, 
             50, 54}, {62, 54, 60}, {65, 62, 60, 64}, {63, 65, 64}, {61, 65, 
             63, 59}, {61, 59, 53}}]]],
         "\"augmented truncated dodecahedron\""],
        Annotation[#, "augmented truncated dodecahedron", "Tooltip"]& ],
       TraditionalForm], {2556., -2548.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             0, Rational[1, 2] (-1 - 5^Rational[1, 2]), 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 1, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             0, Rational[1, 2] (1 + 5^Rational[1, 2]), 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 1, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             0, -(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Root[361 + 1520 # - 13240 #^2 + 19200 #^3 + 7760 #^4 - 
                25600 #^5 + 6400 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             0, (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
              Root[-479 - 6240 # - 8600 #^2 + 16000 #^3 + 49360 #^4 - 
                44800 #^5 - 12800 #^6 + 6400 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 2] (-1 - 5^Rational[1, 2]), 0, 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
              Rational[1, 2], 0, 
              Root[641 + 7760 # + 8360 #^2 - 22400 #^3 - 11440 #^4 + 
                19200 #^5 + 6400 #^8& , 2, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[-1, 2], 
              Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (-1 - 5^Rational[1, 2]), 
              Root[641 + 7760 # + 8360 #^2 - 22400 #^3 - 11440 #^4 + 
                19200 #^5 + 6400 #^8& , 2, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
              Rational[1, 4] (1 + 5^Rational[1, 2]), 
              Root[641 + 7760 # + 8360 #^2 - 22400 #^3 - 11440 #^4 + 
                19200 #^5 + 6400 #^8& , 2, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 2] (1 + 5^Rational[1, 2]), 0, 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 1, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
               Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 1, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 1, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 1, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Root[641 + 7760 # + 8360 #^2 - 22400 #^3 - 11440 #^4 + 
                19200 #^5 + 6400 #^8& , 2, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Rational[1, 2], 
              Root[641 + 7760 # + 8360 #^2 - 22400 #^3 - 11440 #^4 + 
                19200 #^5 + 6400 #^8& , 2, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[-1, 2], 
              Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 2], 
              Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 2], 
              Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), 
              Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
               Rational[1, 2], 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
              Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
               Rational[1, 2], 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 1, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[1, 2], 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 1, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
              Rational[-1, 2], 
              Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 1, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
              1, 2], Root[1 + 8 #^2 - 176 #^4 + 512 #^6 + 256 #^8& , 1, 0] - 
              Root[482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 1, 0], 
              Root[361 + 1520 # - 13240 #^2 + 19200 #^3 + 7760 #^4 - 
                25600 #^5 + 6400 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
               Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Root[361 + 1520 # - 13240 #^2 + 19200 #^3 + 7760 #^4 - 
                25600 #^5 + 6400 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 3, 0], 
              Root[-479 - 6240 # - 8600 #^2 + 16000 #^3 + 49360 #^4 - 
                44800 #^5 - 12800 #^6 + 6400 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[-1, 2], 
              Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Root[-479 - 6240 # - 8600 #^2 + 16000 #^3 + 49360 #^4 - 
                44800 #^5 - 12800 #^6 + 6400 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 1, 0], 
              Root[361 + 1520 # - 13240 #^2 + 19200 #^3 + 7760 #^4 - 
                25600 #^5 + 6400 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
               Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
              Root[361 + 1520 # - 13240 #^2 + 19200 #^3 + 7760 #^4 - 
                25600 #^5 + 6400 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 2], 
              Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
              Root[-479 - 6240 # - 8600 #^2 + 16000 #^3 + 49360 #^4 - 
                44800 #^5 - 12800 #^6 + 6400 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}, {
             Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
              1 - 20 #^2 + 80 #^4& , 3, 0], 
              Root[-479 - 6240 # - 8600 #^2 + 16000 #^3 + 49360 #^4 - 
                44800 #^5 - 12800 #^6 + 6400 #^8& , 4, 0] - Root[
              482477187239 + 2343512990720 # - 5105030091520 #^2 - 
               28990840217600 #^3 + 3719440179200 #^4 + 76573704192000 #^5 + 
               32992002048000 #^6 - 47248834560000 #^7 + 10894704640000 #^8& ,
                3, 0]}}, {{0, -1.618033988749895, -0.7663228328886568}, {
             0, 1.618033988749895, -0.7663228328886568}, {
             0, -1.3763819204711736`, 0.9467249793228429}, {
             0, 0.85065080835204, 1.4724560914419766`}, {-1.618033988749895, 
              0, 0.09607417097080284}, {
             0.85065080835204, 
              0, -1.292053945007789}, {-0.5, -1.5388417685876268`, 
             0.09607417097080284}, {
             0.2628655560595668, -0.8090169943749475, -1.292053945007789}, {
             0.2628655560595668, 0.8090169943749475, -1.292053945007789}, {
             1.618033988749895, 0, 
              0.09607417097080284}, {-0.9510565162951535, \
-1.3090169943749475`, -0.7663228328886568}, {-0.9510565162951535, 
             1.3090169943749475`, -0.7663228328886568}, {
             0.9510565162951535, -1.3090169943749475`, -0.7663228328886568}, {
             0.9510565162951535, 
             1.3090169943749475`, -0.7663228328886568}, {-0.6881909602355868, \
-0.5, -1.292053945007789}, {-0.6881909602355868, 
             0.5, -1.292053945007789}, {-0.5, 1.5388417685876268`, 
             0.09607417097080284}, {0.5, -1.5388417685876268`, 
             0.09607417097080284}, {0.5, 1.5388417685876268`, 
             0.09607417097080284}, {-1.3090169943749475`, -0.9510565162951535,
              0.09607417097080284}, {-1.3090169943749475`, 0.9510565162951535,
              0.09607417097080284}, {1.3090169943749475`, -0.9510565162951535,
              0.09607417097080284}, {1.3090169943749475`, 0.9510565162951535, 
             0.09607417097080284}, {-1.5388417685876268`, -0.5, \
-0.7663228328886568}, {-1.5388417685876268`, 0.5, -0.7663228328886568}, {
             1.5388417685876268`, -0.5, -0.7663228328886568}, {
             1.5388417685876268`, 0.5, -0.7663228328886568}, {
             1.3090169943749475`, -0.4253254041760197, 0.9467249793228429}, {
             0.8090169943749475, 1.1135163644116066`, 
             0.9467249793228429}, {-0.8090169943749475, 0.2628655560595668, 
             1.4724560914419766`}, {-0.5, -0.6881909602355868, 
             1.4724560914419766`}, {-1.3090169943749475`, -0.4253254041760197,
              0.9467249793228429}, {-0.8090169943749475, 1.1135163644116066`, 
             0.9467249793228429}, {0.5, -0.6881909602355868, 
             1.4724560914419766`}, {0.8090169943749475, 0.2628655560595668, 
             1.4724560914419766`}}], 
           Polygon3DBox[{{27, 23, 10}, {14, 19, 23}, {2, 17, 19}, {12, 21, 
             17}, {25, 5, 21}, {24, 20, 5}, {11, 7, 20}, {1, 18, 7}, {13, 22, 
             18}, {26, 10, 22}, {27, 14, 23}, {14, 2, 19}, {2, 12, 17}, {12, 
             25, 21}, {25, 24, 5}, {24, 11, 20}, {11, 1, 7}, {1, 13, 18}, {13,
              26, 22}, {26, 27, 10}, {6, 8, 15, 16, 9}, {12, 2, 9, 16}, {24, 
             25, 16, 15}, {1, 11, 15, 8}, {26, 13, 8, 6}, {14, 27, 6, 9}, {9, 
             2, 14}, {16, 25, 12}, {15, 11, 24}, {8, 13, 1}, {6, 27, 26}, {4, 
             30, 31, 34, 35}, {33, 30, 4}, {32, 31, 30}, {3, 34, 31}, {28, 35,
              34}, {29, 4, 35}, {23, 19, 29}, {17, 21, 33}, {5, 20, 32}, {7, 
             18, 3}, {22, 10, 28}, {19, 17, 33, 4, 29}, {21, 5, 32, 30, 33}, {
             20, 7, 3, 31, 32}, {18, 22, 28, 34, 3}, {10, 23, 29, 35, 28}}]]],
         
         "\"gyroelongated pentagonal cupolarotunda\""],
        Annotation[#, "gyroelongated pentagonal cupolarotunda", "Tooltip"]& ],
       
       TraditionalForm], {2949.2307692307686`, -2548.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[{{
           1.0786823526341342`*^-18, -1.618033988749895, \
-0.4311985019297304}, {1.0786823526341342`*^-18, 
           1.618033988749895, -0.4311985019297304}, {
           1.0786823526341342`*^-18, -1.3763819204711736`, 
           1.2818493102817692`}, {1.0786823526341342`*^-18, 0.85065080835204, 
           1.8075804224009029`}, {-1.618033988749895, \
-1.4382431368455124`*^-18, 0.4311985019297292}, {-0.5, -1.5388417685876268`, 
           0.4311985019297292}, {1.618033988749895, -1.4382431368455124`*^-18,
            0.4311985019297292}, {-0.9510565162951535, -1.3090169943749475`, \
-0.4311985019297304}, {-0.9510565162951535, 
           1.3090169943749475`, -0.4311985019297304}, {
           0.9510565162951535, -1.3090169943749475`, -0.4311985019297304}, {
           0.9510565162951535, 
           1.3090169943749475`, -0.4311985019297304}, {-0.5, 
           1.5388417685876268`, 0.4311985019297292}, {
           0.5, -1.5388417685876268`, 0.4311985019297292}, {0.5, 
           1.5388417685876268`, 
           0.4311985019297292}, {-1.3090169943749475`, -0.9510565162951535, 
           0.4311985019297292}, {-1.3090169943749475`, 0.9510565162951535, 
           0.4311985019297292}, {1.3090169943749475`, -0.9510565162951535, 
           0.4311985019297292}, {1.3090169943749475`, 0.9510565162951535, 
           0.4311985019297292}, {-1.5388417685876268`, -0.5, \
-0.4311985019297304}, {-1.5388417685876268`, 0.5, -0.4311985019297304}, {
           1.5388417685876268`, -0.5, -0.4311985019297304}, {
           1.5388417685876268`, 0.5, -0.4311985019297304}, {
           1.3763819204711736`, -1.4382431368455124`*^-18, \
-1.2818493102817692`}, {
           0.42532540417601994`, -1.3090169943749475`, -1.2818493102817692`}, \
{0.42532540417601994`, 
           1.3090169943749475`, -1.2818493102817692`}, {-1.1135163644116068`, \
-0.8090169943749475, -1.2818493102817692`}, {-1.1135163644116068`, 
           0.8090169943749475, -1.2818493102817692`}, {
           1.3090169943749475`, -0.4253254041760197, 1.2818493102817692`}, {
           0.8090169943749475, 1.1135163644116066`, 
           1.2818493102817692`}, {-0.8506508083520394, \
-1.4382431368455124`*^-18, -1.8075804224009029`}, {-0.2628655560595671, \
-0.8090169943749475, -1.8075804224009029`}, {-0.2628655560595671, 
           0.8090169943749475, -1.8075804224009029`}, {
           0.6881909602355868, -0.5, -1.8075804224009029`}, {
           0.6881909602355868, 
           0.5, -1.8075804224009029`}, {-0.8090169943749475, 
           0.2628655560595668, 
           1.8075804224009029`}, {-0.5, -0.6881909602355868, 
           1.8075804224009029`}, {-1.3090169943749475`, -0.4253254041760197, 
           1.2818493102817692`}, {-0.8090169943749475, 1.1135163644116066`, 
           1.2818493102817692`}, {0.5, -0.6881909602355868, 
           1.8075804224009029`}, {0.8090169943749475, 0.2628655560595668, 
           1.8075804224009029`}}, 
           Polygon3DBox[{{22, 18, 7}, {11, 14, 18}, {2, 12, 14}, {9, 16, 
             12}, {20, 5, 16}, {19, 15, 5}, {8, 6, 15}, {1, 13, 6}, {10, 17, 
             13}, {21, 7, 17}, {22, 11, 18}, {11, 2, 14}, {2, 9, 12}, {9, 20, 
             16}, {20, 19, 5}, {19, 8, 15}, {8, 1, 6}, {1, 10, 13}, {10, 21, 
             17}, {21, 22, 7}, {4, 35, 36, 39, 40}, {38, 35, 4}, {37, 36, 
             35}, {3, 39, 36}, {28, 40, 39}, {29, 4, 40}, {18, 14, 29}, {12, 
             16, 38}, {5, 15, 37}, {6, 13, 3}, {17, 7, 28}, {14, 12, 38, 4, 
             29}, {16, 5, 37, 35, 38}, {15, 6, 3, 36, 37}, {13, 17, 28, 39, 
             3}, {7, 18, 29, 40, 28}, {34, 33, 31, 30, 32}, {32, 30, 27}, {30,
              31, 26}, {31, 33, 24}, {33, 34, 23}, {34, 32, 25}, {25, 2, 
             11}, {27, 20, 9}, {26, 8, 19}, {24, 10, 1}, {23, 22, 21}, {25, 
             32, 27, 9, 2}, {27, 30, 26, 19, 20}, {26, 31, 24, 1, 8}, {24, 33,
              23, 21, 10}, {23, 34, 25, 11, 22}}]]],
         "\"gyroelongated pentagonal birotunda\""],
        Annotation[#, "gyroelongated pentagonal birotunda", "Tooltip"]& ],
       TraditionalForm], {3342.461538461538, -2548.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwNyHk01AkcAPAfoZ5q2kIloanEkpZY2hzf8dZzJEYT636RUpJXqJ6ewkj1
KqxzEbuUfeVqlSMl+Y4uSpgjhFFuM9iYGczMzrX98fnnQz5+jnZSnSAI++9W
fUeqEXOLQJ1Rp7+vOTN7CAJw6kb/s35YIW1nW21XZ8g1+vXKyhCu6Hk2xzhP
YM3B96u6g1TobE2vj7zYCbNlY6yrUUuQEJG3KbpcifTr5M4w6jh+uUdEx1eJ
sMSYvkXppcC9ct2j7Kkl6DV5nld5awiuJas7nhmUY2+86yylYRaYioKibTuE
mKTSatbIleCOSsNaz7VScDxotMbMbBR3aYREFO+RIFFaHBLiK4D4y5v964OX
QedVWHWcixjb6ssVrdgOPF2hSYC5HHU2XsqPwhUc4+bO88pG0Leopsp9Vg6i
nsQR56Fl/OioLQ5LXUHlciir/e4SdoXa3aVNLeIPp9TOSNhKMC78GCnhsuHa
nYXVzqRFNMtQpD+4vAihDi/v77STobviaVuicA59rY18qhhLqOdKdZFIZFB4
yIv7OGUWdTPBLy2JYJjJTEQLljxcrc/TfJI5g9z/JC+oFnJoCbYjbTcXYEfa
js7hlBlkat2IpzvJgOVv4HnjnAjsp2756OyfRirZXlVNWwC2pgs9+qISbtba
zutemsSFU1aefplFUGYel9WXrUZpXtzRtGtoAslnR8e/nGBiWnvui+v71Bji
5i6aidE4yvn7ZgLCRZhvkz78/rEC3dNjS26+GsVQv4xdtHEVLu0VNbz4JoAB
HdW5GdtRtHVS9Dq5qTM25Fc10rXfgvfDzKLi00ycC/3mmCIlKNbHmG9Mk1hY
QtrULuh5iylNO4O++U5Cq5/kckwjwbBzlG/Q8GlG1vmqa6J5Pt4kfh2y3KpG
GcivTSdZ/ImhHRVFyn4F7nFoWUVYLqNIQKPpfWBC+YpHFlVXAcF9YSI7UwEm
GI134xQT0tX7Xel75GA9LIqMiRdB3p66DxwrFjyZNxQLG6ZRvYVmQ68iGA1B
G9p96RwIzJg74p+7CPvv6Jf6JCrBpuv5dW9pP8j7vOxpDY1wKHbEwCNXjdJg
4GF6OvwLlAY6HqFJlehV39VTLhCAjXx3cmXSVwiEvumXLDVGb1vsnWryW4im
Tj1kT4+BY8CCj9yEoJxiD841LrCBL4j/KMufgHzO0LMHQgGkzz9PTbCWoSdh
a85STkOyjONd49QBzt7PBFE/EYzBtSWGqrYZ+MynbKtyF+FKLi3yoUIGQW1a
RIc1H1rZ9y5oJKvwbJhxXc5uHt6aVry26/7+nFWW5cxlzE4azjrQK0HNnmqS
HkUAlLlD9Z6xMuDmRGWpto5i2PvfTqTWCGDN13cRIfUiaPIW5rgdX4aLrQ7W
DZtEQGaOcHhbPmHi2ZvTwwI5jEgnndwil+CTZoTL4UEZPuV73LJuHoNYPvPN
5ZMrILnd28IeEENdKaeCXDcEV29Ty9d/XgHbTi633GsRSOG/+7VuFuKjjVZU
SYYErlA6hiXajbCG5Na82VWM/yaOvqqplsDWwpPaFaaLGO5vEVQ2I4Rl/WN/
gaEUeEGBvE8NYpS+i8wpiBnA9f8Ep4rPSGGs6YLL2Lp5/KPtb4O+QiGOhMQV
V8f9B6q8nx2eRA1CorTgR/H5JeAnzUkrLFTQS66luisn4avXcfVJfj/oN97f
cCFeBcdqyh7xjg6AR+9t6aTJBJqvu1PA0iAoZEnaNqExBxvfJBy42D0JjpVR
5b+YERSXTkOtw5PjeC88O/31XQ7+D8xa1YE=
           "], 
           Polygon3DBox[{{1, 3, 8, 5}, {8, 18, 17}, {18, 31, 29, 17}, {3, 10, 
             19, 18, 8}, {31, 42, 29}, {29, 42, 45, 35}, {19, 32, 31, 18}, {
             19, 26, 32}, {26, 38, 43, 32}, {32, 43, 51, 42, 31}, {38, 48, 
             43}, {43, 48, 54, 51}, {8, 17, 12, 5}, {5, 12, 7}, {12, 24, 16, 
             7}, {17, 29, 35, 24, 12}, {24, 28, 16}, {28, 41, 46, 36}, {35, 
             41, 28, 24}, {35, 45, 41}, {42, 51, 52, 45}, {45, 52, 53, 46, 
             41}, {51, 54, 52}, {52, 54, 55, 53}, {7, 16, 13, 6}, {6, 13, 
             9}, {13, 25, 20, 9}, {16, 28, 36, 25, 13}, {36, 37, 25}, {25, 37,
              30, 20}, {46, 47, 37, 36}, {46, 53, 47}, {53, 55, 50, 47}, {47, 
             50, 40, 30, 37}, {55, 49, 50}, {50, 49, 39, 40}, {6, 9, 4, 2}, {
             2, 4, 11, 15, 23, 22, 14, 10, 3, 1}, {9, 20, 21, 11, 4}, {21, 27,
              15, 11}, {20, 30, 21}, {30, 40, 27, 21}, {27, 39, 34, 23, 15}, {
             40, 39, 27}, {39, 49, 44, 34}, {10, 14, 26, 19}, {23, 34, 33, 
             22}, {22, 33, 38, 26, 14}, {34, 44, 33}, {33, 44, 48, 38}, {1, 5,
              7, 6, 2}, {44, 49, 55, 54, 48}}]]],
         "\"bigyrate diminished rhombicosidodecahedron\""],
        Annotation[#, "bigyrate diminished rhombicosidodecahedron", 
         "Tooltip"]& ],
       TraditionalForm], {3735.6923076923067`, -2548.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwN0Pk7FAgYAOAZkp6kESJHYh1LKqlQOb4hmsrzVOQ+IhLSOiIi0Vo85SpH
EmJds2FRUputfLOJWeXIMW3lyM0MMeYwxjG2H95/4NXwCbH3EyMQCCY/iP+g
0DfqXBlMpCWdOOPjUdSHztH/vK3eyMBykxO9faUEWu7D/KpKqwn4Tt2YZXCt
DVvaPTuVqtfRmHNez798GjvyetQZXiNwIfHRjhopEV6+uHbZa3cHXs6UczwX
ykONKHvlOMU15CQcsrYNZcFe7vgVUJiGBUeS67z0Gmo4Mtyy+xbwt8k9nvRD
LLxmG0DaELGKPeNiRDJlGliS5U6nPTlYeeKdG01pFR+PXwk6Ml6LTQ/mPUgX
uHAn5o+oF/1CVFllfzJYX8IPc5fOHp2sAk96Z0HV6BL6JjLansYJwJ8TqUt9
MoQXEgJnUmr4GCWptdkrYBEXk4xvCGTYYNR1jxTfwMOt0aW5CduX4SHFKSbU
eAj4yvmKXtJctE/PojS9GUYrWvrFWNI6mou6ogxVOShiFf+arzyJbt2vKapv
lyFsVsqlhMRB33mLTJ2MRVQulWlKaxRgC1d33/GEBZTtSVaeZHGAalZXbBjP
B7uW/ODbiWzsrbBuiJnrgU63Pcc1GKtwpCXDtzmajcxwglyM/gKIZSdaUBpW
0DKB9a33IxMHkxwGUpNXoZ4iCvtJfAErU+N3hNKZSO3m5p2WI9KUXcTnIh/V
I3PiiRLNYQLDm1esBMJuEJ4zEsW3EmkPC8QJSkEjWFCr7Nd+dx2/G1LDB3bN
gqW1AUtLaxg/NbmK69kTaCkBx3rjXdg4ltwVdD77MwZcb8255U4guzYmB3vF
DYHfAe92fg4dGSfDai6mCUHN9ZXH3kw+VExEOOBNOioYf3HY5c3COTZ/+KXH
OnyI3jnfVNKEL2dYFUvtAkiIvP6rbekK2prlbp+79Rwjd5WrjLa+A+M39fND
fxHIqUOvzNQPPkeTVO/dVFUimS67UdPKbAhXBrds2nL8Lfhove2o0xKjhdvR
7fWSP0D/n+YX3NdaQUqtdlZqUIibB0iahEQB3OjTtDDd3QVXu+3pSzAJjTZ1
uxLeEGkVMiUVNP0BYEcKQ67OzkF91m3KUc4qmIuo3oWBA5C7Tfdwii+R1pwp
H9F6Ywr71/PHj5FGwcmWjRY5IpAofM4MiJgGfeeQZROnMbCJdVZrjF+DhGem
eUf2cbC/RFX+G0xBS9qm89ZHv2KEtFhRQ/A6pFJmZO/Wz0Dk4Sy+tRSB/Ivu
sdjiMjqaWDh95byagYMvFTWLc0Xo56b/c20bE0zL3g3bhywAUJtd0025mLKk
MrxyXwCB7y0Z+yW4wH9945RcHA+yJB97WRZwwXRAgk/bxgWfZCVe+PIIdAZp
U/2HRdi/1JUzJ8YDd7sdEQamX6BJW3uj4cIy7K1pTdtaxQevar/B+9qrWO2y
Kux0nkI77+IA5bJF0GB4N9u68CBSvfiLlQEPHSs2KB39LIRnL/JkWjKEyJWp
9FwIbodol0GeTfcyvG/be091fhEElLpmHqMXK3WW/ztDWgP5htgXinef4r4D
Lq/c4gV4Ta8oLTvwx9fJOxmX/Gdx4mskWyJuFsYO2nyKExdBvo2WLuHOPCQ9
df99/9IIqDjefiAtLYKiqb+7w+7Noax8v3yQHhs9fXrvmxHXIa2UHphyrhFY
i1WLkvZs8GG0VTicJZBj0j8XkBPHobmjbDCokInlOmOZhTuJ5FMi9cMffZho
9GwpsYZXg4rNNxXCmESyjigxQ+31v0A1j9USGtXD/9HrwwU=
           "], 
           Polygon3DBox[{{32, 21, 18, 27}, {27, 18, 19}, {18, 7, 10, 19}, {21,
              13, 4, 7, 18}, {7, 2, 10}, {10, 2, 5, 12}, {4, 1, 2, 7}, {4, 6, 
             1}, {6, 9, 3, 1}, {1, 3, 8, 5, 2}, {9, 11, 3}, {3, 11, 14, 8}, {
             27, 19, 29, 36}, {36, 29, 38}, {29, 24, 35, 38}, {19, 10, 12, 24,
              29}, {24, 25, 35}, {35, 25, 33, 41}, {12, 16, 25, 24}, {12, 5, 
             16}, {5, 8, 17, 16}, {16, 17, 28, 33, 25}, {8, 14, 17}, {17, 14, 
             26, 28}, {36, 38, 47, 45}, {45, 47, 53}, {47, 50, 55, 53}, {38, 
             35, 41, 50, 47}, {50, 52, 55}, {55, 52, 49, 54}, {41, 43, 52, 
             50}, {41, 33, 43}, {33, 28, 37, 43}, {43, 37, 40, 49, 52}, {28, 
             26, 37}, {37, 26, 31, 40}, {45, 53, 48, 42}, {42, 48, 51, 44, 34,
              23, 15, 13, 21, 32}, {53, 55, 54, 51, 48}, {54, 46, 44, 51}, {
             54, 49, 46}, {49, 40, 39, 46}, {46, 39, 30, 34, 44}, {40, 31, 
             39}, {39, 31, 22, 30}, {13, 15, 6, 4}, {34, 30, 20, 23}, {23, 20,
              9, 6, 15}, {30, 22, 20}, {20, 22, 11, 9}, {32, 27, 36, 45, 
             42}, {22, 31, 26, 14, 11}}]]],
         "\"diminished rhombicosidodecahedron\""],
        Annotation[#, "diminished rhombicosidodecahedron", "Tooltip"]& ],
       TraditionalForm], {4128.923076923076, -2548.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwN0fk7lAkcAPB3zGY3NluSsNRDyLG5jUi+4yEVj7SO0LFC5CjkWlJCiaxQ
yvLUttTmVlGR0HcURoMnSTmGXDFGOcZ4MWaM7YfPX/BR9Ql19pMgCMLsO+p3
hyYHnH+2oTDeyUOd/XIP3v66Muo70YePaDbhu84TjA2fBznO7DFIfljEaeb2
428nxlvoigRjjbFgspMzjoVufD2mygjkumTmxxavop/3rpfG96bhUEps14zD
MLgWa8eVGaziulNvmasxr0D6jXD2Wi4PAqhH3LZ2ivD0gfC2YV02NnJVpRz9
STTwmNM/6CHCK+XRxklVfHzd3SwZxeGgcr7aLU8rIfrtaxpKsR4FQwXHvzSK
SPxiTVGo+mEFXferbqcWL2N1f5n/xsJWUM5ITLxsuYwRin3+HCEJEkSOn9iC
i8paUt2dLxbxSbLg+c0WPgZriWZ1SB64RqbtvT+3gDvYRKf74ArQAgaTHLe+
BgXCpKntywKScqVF8dQZwMXlkKBUEuTkAxtXqvn49x4pUX0FGx/T4w+8F6/A
si3fYdqKh5d88r0pClNoaBlY0HNZjOV51zW3M+ew3SGoMo0vwA7LUqV9m0hU
rQ9tYAVOowATr3ue5YL1jsJ3b76J0bDE+/yQ5BTaO4eod4kIRvQFdmzVBhaU
WP/xetJzEvtM0G71FyHYMfTP1NrPgnburtxt/hx8+almb+cNAahIq/+pMkZi
CXtCjvZpAj1vu48Qdb3gGxnHrJwRw0hUxLxy6BhOjj4bMlZYxWxlH6PtavNg
3jbwXldmBKvZjHr3F4/RW1ujItxYgrFpm8nTWtNBjHwROWHrS2EkxTtdEbpx
MDFT6WpqdB86Kyadqq0j6LScp+m6MY1wY8mys+H0B1zqvVskkzOMBR16rJ6T
BF3q41F1pYX/UP1p3H07N4IuG5MHJ+K4uLNJ8mjBfAKmmzUh8zAfEk8EyxQT
a3is9MGvhNVzOOwS1Ru9RmJbcO36jP1CEJpnSdTmNcBP1t1698opDP9bpjTt
9aPwuc7NuyahGZzd+YZ+TwTQZrFE2RNAgnjL5XQteAuNsVU+1Te4oGtRndrR
LwavMrf2Yv1eoNhEfTt57hNcbElpP7VXguFlY5wUYfUZaEX9cxs3SzCSb6r2
XczvQXZAoXuXeBgydJSPTksT9DLTHjKDOQTBGlwn1fAxuHOosrxZpg6TDdpL
x48Q9Lp3l8JkP4yDIpPKvBK4Amdl5MzM2SQemzeXl2NxIWE+4MglughdFMPD
qTrz4EsNWe4O+gaYqmtA2q/Bw+TnTtZf2Rghf2EPo2MWMpfGXtWwZjDbcIFV
YiyElpbscUUBD6b1a3PZtktAdVjeouvBA/E5gdRk2DzwdKwMHrz8Aqfta+42
sFZAzyY0gZxcgMb2fXkEvxO8jQwcv9aI8UxBluiu2iIMLFZOSqavokYcrVtm
rgeN3DZmt00twVTggX/GtvJAW+nRgu0jEml1KfT4EAGYmKZdyildxmhlo+Os
1hEQhfzYU04TQpZumKSrgISoZyp2YWZstO3QcnENE8HsBc1NE/c4GKp556r0
DA/skhdnbNJWgZHVrPSBygMaz3uVHjUMaQbH5WQlxEDpqwhQP9cJwqXQdcYV
PAj5qG9R6COGna3V3UKPLmx4VrHw4HcSqxJue0V+/4xpZ5KtF3nYFTTIVnvF
wfqIAE2rKoJ+9tpN6ttrwyBr7r5bmDmJVo4t73U2U+j/bqErVu7m4mI9ltRJ
tcKo2Ktq/QCF7uxEPlGOYwHtoH/+ErUF/gf5tsLu
           "], 
           Polygon3DBox[{{33, 23, 17, 28}, {28, 17, 20}, {17, 8, 10, 20}, {23,
              15, 6, 8, 17}, {8, 2, 10}, {10, 2, 4, 12}, {6, 1, 2, 8}, {6, 7, 
             1}, {7, 9, 3, 1}, {1, 3, 5, 4, 2}, {9, 11, 3}, {3, 11, 14, 5}, {
             28, 20, 27, 37}, {37, 27, 39}, {27, 25, 35, 39}, {20, 10, 12, 25,
              27}, {12, 19, 25}, {25, 19, 31, 35}, {4, 13, 19, 12}, {4, 5, 
             13}, {5, 14, 21, 13}, {13, 21, 32, 31, 19}, {14, 26, 21}, {21, 
             26, 36, 32}, {37, 39, 47, 45}, {45, 47, 53}, {47, 49, 55, 53}, {
             39, 35, 41, 49, 47}, {49, 50, 55}, {55, 50, 48, 54}, {41, 42, 50,
              49}, {35, 31, 41}, {31, 32, 42, 41}, {42, 36, 40, 48, 50}, {32, 
             36, 42}, {36, 26, 29, 40}, {45, 53, 51, 43}, {43, 51, 52, 44, 34,
              24, 16, 15, 23, 33}, {53, 55, 54, 52, 51}, {54, 46, 44, 52}, {
             54, 48, 46}, {48, 40, 38, 46}, {46, 38, 30, 34, 44}, {40, 29, 
             38}, {38, 29, 22, 30}, {15, 16, 7, 6}, {34, 30, 18, 24}, {24, 18,
              9, 7, 16}, {30, 22, 18}, {18, 22, 11, 9}, {33, 28, 37, 45, 
             43}, {22, 29, 26, 14, 11}}]]],
         "\"paragyrate diminished rhombicosidodecahedron\""],
        Annotation[#, "paragyrate diminished rhombicosidodecahedron", 
         "Tooltip"]& ],
       TraditionalForm], {4522.153846153846, -2548.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwN0/k71AkcwPHv5Eh2W1RKki1dUqJEzj7TUINqK0kYoclaJaTaipC2FNVu
eCweOhyhRYejIuUzrnlqWc8Y9yRqHGMY54wxJ+uH13/wfq+nh7n9uoggiD0L
VBYc3+rX2kcmMcyWXBlb8aoPuvwPKB8asrBqy66QQCHB2FmXza782IErlpvt
onGGUSsijXfqC8HQOrBhJvPuI9y99fzLjG39EHH13M2BPwnGNeINPNMXYLbF
ok471TIwqjNSA74Ss2pZ+W5e30CTOFEa6y1EfZcnkup2OcYum/Oq+X0UKY11
tjddJ4Hbu1qndZ8cD7UMDLJkM9AXGmY7M1uJ5xs29nhIpegs8F1/gvsNIreM
UHSCRKDpHaZpUizFxG4ber7zKC7Lq6ZoZc7ibXJk+4szEhRQ3e5ITeXoF9RV
O7KnEj2OxIS5/SPGgNcTynI7Mbz1LVT3mZ7EdTb96p/lM+jszPCkHBaD4rTX
8aiZEWD9Z2r56OUMcsumIw5y70PMGgWNHj+HAQYpat56IqxZJSjx9W3FHb1X
NzcYyEHxutfCtFGIbUHUUN0xGQaOm/vRhiaxPsOxMXetEHtYV5bHf5FhPeVQ
TvTSUVizf1jC6RzD4rJLc0rDeTA26w72j+1C6rG+Ps5rPpon6yl4oVyg3zBi
828rAV0fi0nMQfTOn/nNKojEMDeT2PGZteC4tb7bjdePovfxfptmxSCOiUsI
z5XhU2nkAPNgPz43ORIeFj4P9hXv611F30FupL0vpISLzx+q+fW/48K2iryk
6NskRoG1jyW++Y7Wa9Yy7y+fhRGNwYrUNDE0q+a8KPflYLqusUBXNIyF5zbK
1i2Zh9CTTYEkk25kW03S6qkkxoc6jVXzQj4yZ22i+NOd2KNcnb9XV4YeEb7+
abli2A7YvKG0Bq2rf/QP5cyDQVeOHS1nAn9yj6GOLc6DD467qT8crQRpHI+d
U0GQA6os7jpO1ECvPbVER43EqK8KDQkeHYJxy8ueETpd4E9Jz00YnIU7d69R
teZl6Pu3umOSczdoeL3i8M0Isn1Bm7OWw3dgU3oSnKI5kPhkI68oZQCC7Z9e
OFRKYtxb5ZSddbkHnuds15wkSSCUmJZJFrootesU9Bj3gudUe6/RTiGqG7jw
9ErkkKeXzv6J1g/6l4ZtklkEo7xtPNm2aASrzr4fcGkfhJRP5UO0owQ5/WiA
rXsLB1tP1SldFHwwP6yaQbs4CPrvbvQWTyogIq48m5oyBqcTbFt84tvwl4/C
ZIfVc+AYoMYz4o1B6rvIWK8CgnGaU+eg4voBCuJPrCxPmIDdIa6ZizfLMYPI
cdhzaxIoJm611E1CcNKd0W4tksATM3KFFXcK/yKPmbSwhWD9oiHY/6MEfBim
k0xdPgwV5SiUP4vA8Pi/R3ShATwESUsdrs1j6qcp5XkVMbSpUGizURLchUxt
q44p1GfFNx0LloDTA9YtpzkJsOwDOj8DE7P40aTmMik4061O2fOHoCP1GS0N
hDDubtEqI2QQdIa+GfcNYr6lqklCnQQvhBprXHWRw6cHgcNxJhJMrEzPrO9r
wIvRV1qbbshBx6/DNTOjBZc91tM2Xvi6sKt4gv5VDp6ZMveTK3lA7/66Xpon
woJY1lPUVwDrXtUfHNI0Rp3ME9irDcNenIp6m0SQ/RNKbG2reBDfYJw8vqMD
OxiG/WZ9BNlpiG1ytrsKL+/PirrHHcWbYZVB1rMEeW+hZVKjshGaxLIzwRu+
gX74UHOJE4mceL36ushqAKMi105LRSn4P+iAzEA=
           "], 
           Polygon3DBox[{{32, 22, 20, 30}, {30, 20, 27}, {20, 11, 17, 27}, {
             22, 13, 5, 11, 20}, {11, 7, 17}, {17, 7, 12, 21}, {5, 1, 7, 
             11}, {5, 2, 1}, {2, 4, 3, 1}, {1, 3, 8, 12, 7}, {4, 6, 3}, {3, 6,
              14, 8}, {30, 27, 36, 41}, {41, 36, 45}, {36, 31, 42, 45}, {27, 
             17, 21, 31, 36}, {31, 33, 42}, {42, 33, 37, 46}, {21, 23, 33, 
             31}, {21, 12, 23}, {12, 8, 18, 23}, {23, 18, 28, 37, 33}, {8, 14,
              18}, {18, 14, 24, 28}, {41, 45, 52, 50}, {50, 52, 53}, {52, 54, 
             55, 53}, {45, 42, 46, 54, 52}, {46, 49, 54}, {54, 49, 51, 55}, {
             37, 38, 49, 46}, {37, 28, 38}, {28, 24, 34, 38}, {38, 34, 40, 51,
              49}, {24, 26, 34}, {34, 26, 29, 40}, {50, 53, 47, 43}, {43, 47, 
             44, 35, 25, 15, 9, 13, 22, 32}, {53, 55, 48, 44, 47}, {48, 39, 
             35, 44}, {55, 51, 48}, {51, 40, 39, 48}, {39, 29, 19, 25, 35}, {
             40, 29, 39}, {29, 26, 16, 19}, {13, 9, 2, 5}, {25, 19, 10, 15}, {
             15, 10, 4, 2, 9}, {19, 16, 10}, {10, 16, 6, 4}, {32, 30, 41, 50, 
             43}, {16, 26, 24, 14, 6}}]]],
         "\"metagyrate diminished rhombicosidodecahedron\""],
        Annotation[#, "metagyrate diminished rhombicosidodecahedron", 
         "Tooltip"]& ],
       TraditionalForm], {196.6153846153846, -2940.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwNwwk81HkfAOC5aVZLCDESUerFOoZWtL+/dw05Iiq7ohyR3FqiaCLE24XY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           "], 
           Polygon3DBox[{{41, 45, 50, 59, 66, 70, 68, 63, 54, 47}, {42, 47, 
             54}, {12, 15, 22, 34, 41, 47, 42, 35, 23, 16}, {27, 23, 35}, {34,
              45, 41}, {21, 32, 44, 49, 50, 45, 34, 22, 19, 18}, {15, 19, 
             22}, {49, 59, 50}, {51, 60, 67, 69, 66, 59, 49, 44, 39, 46}, {32,
              39, 44}, {69, 70, 66}, {57, 58, 62, 65, 68, 70, 69, 67, 64, 
             61}, {60, 64, 67}, {65, 63, 68}, {33, 27, 35, 42, 54, 63, 65, 62,
              53, 40}, {58, 53, 62}, {17, 24, 28, 31, 26, 20, 13, 7, 3, 10}, {
             4, 10, 3}, {27, 33, 29, 25, 17, 10, 4, 8, 16, 23}, {12, 16, 8}, {
             25, 24, 17}, {58, 57, 52, 38, 28, 24, 25, 29, 40, 53}, {33, 40, 
             29}, {38, 31, 28}, {61, 52, 57}, {30, 20, 26}, {32, 21, 14, 11, 
             13, 20, 30, 37, 46, 39}, {51, 46, 37}, {11, 7, 13}, {18, 14, 
             21}, {1, 5, 9, 6, 2}, {5, 1, 7, 11}, {5, 11, 14}, {9, 5, 14, 
             18}, {9, 18, 19}, {6, 9, 19, 15}, {6, 15, 12}, {2, 6, 12, 8}, {4,
              2, 8}, {1, 2, 4, 3}, {1, 3, 7}, {36, 48, 56, 55, 43}, {48, 36, 
             31, 38}, {48, 38, 52}, {56, 48, 52, 61}, {56, 61, 64}, {55, 56, 
             64, 60}, {55, 60, 51}, {43, 55, 51, 37}, {30, 43, 37}, {36, 43, 
             30, 26}, {36, 26, 31}}]]],
         "\"metabiaugmented truncated dodecahedron\""],
        Annotation[#, "metabiaugmented truncated dodecahedron", "Tooltip"]& ],
       
       TraditionalForm], {589.8461538461538, -2940.}, {Center, Center}, {359.99999999999994`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwtlWlM1FcUxf/DDKPiBrKJS8MSS8WWUrcIEe4TIxbUQkzRkWKlCEFoVCzi
QolFpRURFDFYpdUOKhoZCyiIQJX7LOggIBpZ6lABSUkdBGQXRsCpfdcP78v7
8JZ7zvkdh9Cd68NNJEnyebfk71a5WY6H69UJXHNN1nDp+COQ+fUtOPmkGK86
JscF/6jkG/riU8yW1wNbsthfdqALQjriqm/FK3lcmSX3S2hA/kXV7ut5XWhX
YnH5VZ0pn5v7T9+D6f0gFU556T67HjKONpwtSZDzIYsgvwJNOYZEuv+tl4/C
lcWeEXe+k3On+eElmzcOoPSt4fpyrwG0q65I979rwl1aDuVsCtJhtMq8dcee
MQxZVVO4JF/G7SbsTQvLMEJCzPGsfKUWgpLDJj5INOLU4tb9Jvt7MEB1UjHw
3AiHni+6+HibEWPaEn0W+0ucjXhbhP/ZhUlHap3elo2j5bQ1GREnR1E9yTUi
eN84OhY2xzkGj+E896mpzKEbk7539FutkvPBfxe1+jaN4ssl94PK9CUoPez4
PNZDzmxUDrpK7Sg2hiVVf6gtguhj9VccveW8eK3b3IxsA0Y66guWXpMzjr/s
khU+wyL7DqiPNmCEdYBPTcE4Prcan3LizRswy61qS95iwGL70ppoCwWX1TkG
ZFeU4Jb43l/7Ng+jLtu5+KGHgoUcaP9jvVcb6JqTv3lhO4yrz8VV6g7JuaTI
rSrb0gVno0+/3pAwgIfLfraZ1d4NlR7jTR8EKrhxeoWmwrUfU70yGwfd5Mzc
YcbB02uGcOuur6NL9X2oVUzMuZGi4NKdoAEe24MttobeF169mJ7zketCpQnn
ne4qsydvccV123nqvB4sSszTa5TNsM+0qvu8nZJtz6zOzNP0oG7jiVAT83GQ
ZgVbOU2W8R/u5/62V9aFpobLoVmKV3hmrfX+2BYlt5y2NLji6Uv8uHS3J1Pl
QVKwtjGgUsl91f1padv16Gk9bPC+rGCPd6ZYLTAfBNjqPCu+7QU++0TzU5it
nKct7JvdpjZAaIWc71vRgvM98Mwq7SAs25BVekFpyqK2rUz3MW/CPJuRxK98
x3BmYGRY704FL9rL5pgVPcXuhrsxynaJqVqtLx2Nklj2627T3sxa9K1dlDVn
xIS5lQ+39G8cw+2yuy7no2pQv3tHa/I9BefG9L+Wa19jxqZtpYrCGLx/MMqq
U2qB4nXrHjnHTmCdDmIfXA6LfXy/zwPpHHhI57AA6dT/58DKIXEveNK93J7u
hZA94p0wRO/kEr2T10WIf0E2/Qvc6F9MWy7mABdpDjgSKObAp9PcQEdzY49p
bphKc4YOKzFnzmjOeGSq0AW+vC10wTOkC7twT+gInaQjqElHNpl0h07SHSeS
7mx1vvAJVB0WPsEE8gmfNFP4CtzJV0zqEr6CzeRDSCUfMvVt4UNoIt/CHvIt
f+9bCCefQyr5HJ+Sz1kt5QLcKRdMTbnAAsoR3KAccYlyhJaUO7hJuWPGRyJ3
kEI5hU2UU2DWIqd4g3IN3pRrzrjI9bv/Cw6AS7jgAKqJA6yOuAGnPxXcgGXE
Dd5eIDgDo8sEZyCfOMNsiEvwGXEJOHEJwohjEEkcYxJxDJyIe1B3S3APOHEP
zxIn2Sml4CRKxElUEFdZUbPgKvQSV+EccZjNJQ6DPXEYzhG3mWaG4Da4RQlu
Ywpxng3/LjiP0k3BeYyhXmCN1AvA/EUvwDj1CEumHkG+VPQIOk8WvcOGNKJ3
0Ogtegf+A4ToVa8=
           "], 
           Polygon3DBox[{{16, 29, 38, 46, 51, 44, 35, 24, 13, 9}, {5, 9, 
             13}, {6, 10, 17, 19, 16, 9, 5, 2, 1, 3}, {4, 1, 2}, {19, 29, 
             16}, {43, 53, 56, 50, 38, 29, 19, 17, 22, 34}, {10, 22, 17}, {50,
              46, 38}, {70, 68, 64, 57, 51, 46, 50, 56, 63, 67}, {53, 63, 
             56}, {57, 44, 51}, {68, 70, 69, 66, 62, 55, 52, 54, 61, 65}, {65,
              64, 68}, {30, 24, 35}, {8, 4, 2, 5, 13, 24, 30, 32, 28, 18}, {
             37, 28, 32}, {25, 33, 42, 55, 62, 58, 47, 36, 27, 20}, {14, 20, 
             27}, {4, 8, 15, 21, 25, 20, 14, 7, 3, 1}, {6, 3, 7}, {21, 33, 
             25}, {37, 49, 54, 52, 42, 33, 21, 15, 18, 28}, {8, 18, 15}, {52, 
             55, 42}, {61, 54, 49}, {66, 58, 62}, {53, 43, 39, 41, 47, 58, 66,
              69, 67, 63}, {70, 67, 69}, {41, 36, 47}, {34, 39, 43}, {26, 31, 
             23, 11, 12}, {31, 26, 36, 41}, {31, 41, 39}, {23, 31, 39, 34}, {
             23, 34, 22}, {11, 23, 22, 10}, {11, 10, 6}, {12, 11, 6, 7}, {14, 
             12, 7}, {26, 12, 14, 27}, {26, 27, 36}, {45, 59, 60, 48, 40}, {
             59, 45, 44, 57}, {59, 57, 64}, {60, 59, 64, 65}, {60, 65, 61}, {
             48, 60, 61, 49}, {48, 49, 37}, {40, 48, 37, 32}, {30, 40, 32}, {
             45, 40, 30, 35}, {45, 35, 44}}]]],
         "\"parabiaugmented truncated dodecahedron\""],
        Annotation[#, "parabiaugmented truncated dodecahedron", "Tooltip"]& ],
       
       TraditionalForm], {983.0769230769231, -2940.}, {Center, Center}, {360., 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwNlGs0FGgYx4c6HMlSHdt2pt1tt7QSSevSSp6JpZLrLEltnK1D5Rpy3Vhp
3SuX0shlcolMq+xqp4PwzLbKxGpyia7INabcBoOZYZ8P75f3w3t5/r//75sT
QWxvZQaDYUFrBa3JC6KKdRwlgd0WvZPMwTYY9TuZqOLWBrfshamaTCWBfz3f
NTX/Me7JfG6w3DOAkYNvVMdfMARpQvOk3e+GkT1jfzrgrxaY+k050Sx3CTsS
B7m9dtMwHjDP7wt6hCmCM/oXahVop8PWXeI9hztNX7t6eEnAQ3tmn2GxArUv
qUivWAyDoxHLqT5rEosS4vtNdstRXVi2ZX/0CO5Ky/CyiZuGhcbsZh0jGb7h
zLBS9nzCJyHMj5WyKeTN1DX2ly1izHzcDdERKXbvKCtcdaQdfygO9LRhz2Ee
c/ej14mLwN+cfrXL+j28b8s+oiycRWaQ0VNRyxQsRdZczlGdg9GtmwL/rJzF
lu2FtRycBybDYbu8U4zbysdrrSclqB+1FGGt9h826K0X6J9VwFRZrnxUKMHm
DaWeRxd7oKw8dO7LGjmq+d+v4tpO40OHGLUN7D78fEhZbJSjwFFbZ87dzim0
0TIO6u2W4vSiozwTJXDw7b6fSt9OosI5Oyti5TKmHDfTtBa/gOKD+0UfFj6i
w5ONQZKEOfS5tjP+Q6kUv+Vl/3tiSIzvQjafXmItY97RmPPhcYOofPWLy+dF
Y2jTtxD4NIbBGl+xXM7vbMK1oSbPUmQjGGZgXujEGgTNwJdyk9UMFjv4sktX
xQiu03/SNew1Cz7SV3U9WosYIjI4EZ8yiOIry3Gx0XKILTDfqbIwDcodkb3h
Gwbw4ZyAIzSbwOjcFz9HVS7B7xmGEU02HThk+FjplLgfRBkqKUmfKQkOHNK5
aRzVjIfdtAMbml6hqqHjxTWxSgIhb/XWNZaNWKrZWLQ+UYZ2Z4tVD5bMgSZv
lzpXVo2G5Vn97h5KgrAbVlzN+j7QnDpwtaiEj4obxx3zIpRYTyvsH2uFvAOL
LsnwRCEXS0zFSV3PZuABY1f+KzUFNIY2NX8q5EL9uYEE2sfDGs0FtI9T7XtX
0zmwucbDgc4RdPdWtNA5GJz+3e8FsmrQSLk+QPeyZFUhRXQvVm9M6teybIRj
bS0l9E5QiTFXo3fifMPNY/Qv8D1uHE7/glbd+Hj6F+tts78bzQGYFXyFj7gf
L6SaJ9McWA1BnGc0N/COfp5HcwPL2wGeNDe09Ld3oTmDSas0luaMtnfajWjO
2KNRwaJcwM23oZNyQe7YvoeUC9zTcq2nHMGPp5dPOaL7uVsKylHQY2h2nnIH
v+XZAMpdwOZa5lPuYGn7dxVxAveNt/sSJ6BgOUQRJ+A57N1AXMH3yVuCiSuo
SsqJI64gXa/NjjgEydqCa8QhuGdwtIlDhOzeK8QtMNv3BBO3cE91REHcYlCt
1R3iHPhtlzSIc0h86TtKnAM4MtTHhBIwret2oV6gcqS66lc1cuDMxVRRj8A1
2SKZegSxZpX/UI/QPazSm3oHs2dyqql3WDC8UZd6B7c36ThTT8Hk7rYm6imW
JbikU0+xd1LhRr2GVo+dAuo1Mvfideo1TljZ15EHILQ2OY88ADyZTS55APav
03lE3gA+c6UNeQNW+VwcI2+AtGPNa/IMDB16oEuegXGO7i/kGTy1GO5JXgL1
dIMJ8hLu+FXbj7wE0tI/LMhjYBrGZZPHcCnzkyd5DJ28f7xO3oPW3AgeeQ/X
MlO9yHtwK61kBXmSFWZvl0aehHEPjTDyJFptkmWSV1mdkc6B5FUoNWQ4kVfh
gGVWHXmYZVp0s4I8jGZ7vYTkYfwf+b4U6A==
           "], 
           Polygon3DBox[{{25, 22, 34, 37}, {37, 34, 45}, {34, 33, 44, 45}, {
             22, 12, 20, 33, 34}, {20, 29, 33}, {33, 29, 42, 44}, {10, 23, 29,
              20}, {10, 11, 23}, {11, 21, 30, 23}, {23, 30, 43, 42, 29}, {21, 
             35, 30}, {30, 35, 46, 43}, {37, 45, 54, 48}, {48, 54, 56}, {54, 
             58, 60, 56}, {45, 44, 52, 58, 54}, {58, 59, 60}, {60, 59, 55, 
             57}, {52, 53, 59, 58}, {44, 42, 52}, {42, 43, 53, 52}, {53, 46, 
             47, 55, 59}, {43, 46, 53}, {46, 35, 36, 47}, {48, 56, 50, 40}, {
             50, 51, 38}, {51, 41, 32, 38}, {56, 60, 57, 51, 50}, {41, 28, 
             32}, {32, 28, 17, 19}, {57, 49, 41, 51}, {57, 55, 49}, {55, 47, 
             39, 49}, {49, 39, 27, 28, 41}, {47, 36, 39}, {39, 36, 24, 27}, {
             50, 38, 31, 40}, {40, 31, 26}, {31, 18, 15, 26}, {38, 32, 19, 18,
              31}, {18, 8, 15}, {8, 9, 3, 2}, {19, 9, 8, 18}, {19, 17, 9}, {
             28, 27, 16, 17}, {17, 16, 7, 3, 9}, {27, 24, 16}, {16, 24, 13, 
             7}, {26, 15, 14, 25}, {25, 14, 22}, {14, 6, 12, 22}, {15, 8, 2, 
             6, 14}, {6, 4, 12}, {12, 4, 10, 20}, {2, 1, 4, 6}, {2, 3, 1}, {3,
              7, 5, 1}, {1, 5, 11, 10, 4}, {7, 13, 5}, {5, 13, 21, 11}, {25, 
             37, 48, 40, 26}, {13, 24, 36, 35, 21}}]]],
         "\"parabigyrate rhombicosidodecahedron\""],
        Annotation[#, "parabigyrate rhombicosidodecahedron", "Tooltip"]& ],
       TraditionalForm], {1376.3076923076924`, -2940.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwNlHk8FHgYxmeSQlEqu6EVSo5oKmHleIePoxpUVtS2KdaRI1PakFXrWHSJ
MCpR7JK7IlE53okU5YgkK9eQXBlmnDMY+/vj/ef9633e53m+Kq5Me/dlFArF
mIwYmULfjcFOEVS21tmGl3yNTjwtd4t1r+4afhQdYmQNUtgBG/NZ1JhPIFqZ
c178zFeUNaxWDi+lsL+PSe+sqH0D5h/iYz2uDkGTy43FZkUKW7HfKkYzhgsj
M503lZSqoDJMcKNFbBHjA3dY+q2YRL4j/Vi/FAdyLxvfbGMvYJHN/eyfOiZx
/psVS7WlC4MVDnao+84jq4zfq2vVh3XPErc/X5oCqy1M4fvN82jF2awrqp0E
068Rp3Yzh5C7S8dEvE6ILnIDqmJecZCQUDOunzGLB2Q2B8aw5nDmudHJmS3t
wDs3JrNTXwCuq4ozRNmz6P6DycnTj7m4vehp8sD4NMr4hjDKU2fQsd/ABbcK
wTtAvUhMug88nIRp4fJTONodWlxtNwbVVF0P20wB7nWR5kt94yFXYaV/md8U
nEgxypTXmwV7u2jjr5E8TIqbq9HIEsGfYenVvh8/ob6Gy9BnSx4qjIdHynQv
osIaH1bujT7YppYx/GUZD81f84cqCkWYF8DblNjYgTqmnSvPu41hzT2Wbmz5
KFI1KaFvAxbBUrAqwCFrFI+OOYnLBFVAQb22t4o/hV3wuwFFom0QXy6bZDrQ
hKjoeH+BSpvGBrUQM9PSQWznfB4UdRYDyz+/8EEbha6WL29p7TmAemY5pY8i
RnGy1PovHm0JU7Oz/qbe5GBARMraAbEl2L36fQmrmQs1VyaNqtp7MbnyWYLG
IyG63/pPtsVgBoYpWsVNae3o7CJtWXhsBnwmzibq0ObxKkd7nf+TVvQpcgtS
9BwHXsDod438JZB0Cx3eat6CsSac+nAlCt20fk6r0WsMBQ9X25ZsaUYdBdW6
CyVU9sejvJYM/XJYJ3H8jdXFBoxQbbRQr6bStxWfY5cXFMB+5xdqIRmXcIBf
8G/a+n5MVy4NlTWg0ktvdQwHZVyC6xyLJLKHxWpGGNmzG3/2SvO93QRW6xme
pfuEYCv4QOvomYUdXDElTmYTSFmIf5ZSWcAvx318DPOmMXoorpPcCbwwow/k
TvY704ca5E5Q9zARJ7pgoLohkujCpxUbuEQXBkbuzSJ/AK2RVwzyB8zJsU4g
fwDaj7VdHUc5MLDV5GT0KIX9np1wIorfhcxLA7Ebmf2gdMJnXOg5BZP2sN49
bx6duOmmxBfIo9FziS+gdk7pMvEFGNEeUn73v0FjxKDdQYYI3tCcjU1cuQin
lxsRf0HDW/mXpc5i5MmZFRF/2bRUlaQdLkPQQ7WUtXlHodvMpTek2qZAglEi
k+QHsgPTzpL84H7NO14kP/RTv+1J2jc0ATOLG4wSu+dBa/BiUgqMgR+TYUjy
DPbyBfUkzxjpsVBJ8gybBoN13nbxYe+2IFMtfwFarw0taYicwO4qyevqclOg
d+Wpw6+SI6jor2lYESXEuKDKVNIj0JsYfkV6hNJlku6kRzAn4f0l6sI0HD9s
a/RMuR9WJWu4h40IMUQ7KJ30FEaXtx4mPYUzPtfukp6Co4rokJrkHJSsaEpW
iRNA2ZFLS8ZDHUg3U3EgHIAH2q93EQ6g+MInAeEA2FjozhJuQJ9XqyHhBgod
dzkTbsDEgb5Zk9J5qJrOtbEwn8ES3d7g6H/qsfEB5TrhEqx4PZxOuAR69elx
hEvw5DZv35rHi9CaKVG+Yc8rZPQ2GS5VT2Ktb3Pmop0IthcNKoWFDoOzsqSx
JH8U3bL6nAk/6SNJd6MIP/HlSA6L8BOq4qUOnNKl0t95tc/L+/fgny1qt1OP
tKHrH/GRhMN0x8s9LwiH4Y5jTWpa3TX4HyWv/s4=
           "], 
           Polygon3DBox[{{19, 13, 25, 31}, {31, 25, 38}, {25, 27, 40, 38}, {
             13, 8, 15, 27, 25}, {15, 29, 27}, {27, 29, 42, 40}, {12, 23, 29, 
             15}, {12, 14, 23}, {14, 26, 32, 23}, {23, 32, 44, 42, 29}, {26, 
             39, 32}, {32, 39, 50, 44}, {31, 38, 49, 41}, {49, 57, 56}, {57, 
             60, 59, 56}, {38, 40, 51, 57, 49}, {60, 58, 59}, {59, 58, 53, 
             54}, {51, 55, 60, 57}, {40, 42, 51}, {42, 44, 55, 51}, {55, 50, 
             52, 58, 60}, {44, 50, 55}, {50, 39, 43, 52}, {49, 56, 47, 41}, {
             41, 47, 35}, {47, 46, 33, 35}, {56, 59, 54, 46, 47}, {46, 37, 
             33}, {37, 45, 34, 28}, {54, 45, 37, 46}, {54, 53, 45}, {58, 52, 
             48, 53}, {53, 48, 36, 34, 45}, {52, 43, 48}, {48, 43, 30, 36}, {
             35, 33, 20, 22}, {22, 20, 11}, {20, 17, 6, 11}, {33, 37, 28, 17, 
             20}, {28, 16, 17}, {17, 16, 5, 6}, {34, 24, 16, 28}, {34, 36, 
             24}, {36, 30, 18, 24}, {24, 18, 7, 5, 16}, {30, 21, 18}, {18, 21,
              10, 7}, {22, 11, 9, 19}, {19, 9, 13}, {9, 2, 8, 13}, {11, 6, 1, 
             2, 9}, {2, 4, 8}, {8, 4, 12, 15}, {1, 3, 4, 2}, {6, 5, 1}, {5, 7,
              3, 1}, {3, 10, 14, 12, 4}, {7, 10, 3}, {10, 21, 26, 14}, {19, 
             31, 41, 35, 22}, {21, 30, 43, 39, 26}}]]],
         "\"trigyrate rhombicosidodecahedron\""],
        Annotation[#, "trigyrate rhombicosidodecahedron", "Tooltip"]& ],
       TraditionalForm], {1769.5384615384614`, -2940.}, {Center, Center}, {360.0000000000002, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwNlGs4FGgUxwdrrUYRTaViaUIS0fZE2M64VFaKpK1WurqsjEvZFdqVR6Os
TdKDLZdcChWyVEjljFvppg2RSyRk3GeYMOO258P75f3ynvf8f/+f9nF/Zw9Z
BoNhSUeOTsWNPXNap2X4xj0pLhd4HeDoGbDZNyUP8zUeC7qaGfwrgTo1hhYN
mCB8M2r3rBffFARIGB4MfoYf8+KG0grwKZ5SdVMYgtA1tsptTXPooHVkX75A
hPGj0sN2P1ag87651Da7OSwdGlTQZg9isuOQuUfwAHzO8xFwG2dQxdYyLNtK
BO/lY0RMewFWftQ547t9BpX8shyrrn2F9cuCefkTL6Ds7tanI2nTeKXUqLN3
ewNIJyXf7mBPYOv8CV/D9VL8kHkkN8dICLu7ym966Y1BaLrrr7WaElzOXSZ9
NNyLvxgwxisHJlAqMMm13TuJx6Z3mxtl10L22WfK3Z+lkPSXfnbntgn8LUS7
q1xlClmrRQtjDw9hUcfunzXrxXhNcaVrhlc/Wtvx2V4rpVCU65WSZiDGB7Ze
ka2hs1iY139hl34ORLdrG6SnjmP1irn7T9kS1G24xNLVEIJsgNO81aAQezbs
ajP1mYbIqmI1s64R/Jy+4LK1mxAbDxbnuVTOw6i4hFkR7o3d3p6mm4XDKLyw
0UXV6CMMrDBNG0+exxNBOg8fDPXjUb5iUuz8BMjaNj9IVJ0Cm33pMf3DAhTw
EpAt/YT6OTdqSkwYfLZdhXG3eQ/WSvp8XF91g4m/v4qiF4Njc9dnfcyDT1jd
FO2oa/MV6uPFPPPgacxRzE/f4teJQ6K+qaqCWTS/qcY7aD2Gene56qykNiz1
iLVa4MTg5EZF7RTc6oc+g2/z1nE+oKB0jbe13Sjek7sf5vD3PJhezQrZIt+M
lzsS60YvyfDjdTUvWta9xGVs53kTvwY8NCZrsWjJDN67fC6AGfMVRg5KTpzJ
fYNl2dM9ypoynN7ZSFHLgm5cpWEBCY+fYPuXemVQFuNYpq7aHxGzaPootdji
UQZWxB9vnHxeBglL9esimmX4LxJCHekeINg6g+6xoTr0Nd1z6os3tbmH1MBt
b4Un3vsp7z1yrCszk6AaZ2xP70Jl1vFuepdvUPJ6gN4FdfQdoznBTLxpK80J
shvbA2lOfFF8PGifVhMccOguUD47AKLfI/nyhxgciWEFl/4LwZ0b/qP/crjM
LVz6L0iea6fRfiD8SZQ/7QdUc5QjaD+ovy1KifYJle4TQPvkJ7y1cqZ9YsKf
Zg6UC7wOrHWlXPDZwVX/UC6wcKnjOsoR1k6c96AcsZ+voUo58t/b3L9HPACv
vDmReMDTfT+UEg+Ybyo2Jn7g33MndxA/GHSmNZn4AV/1nhDGvRGwc7Nr2fRu
Bna6XZI8UxiGsYvvoolDEO/n3SEOcfHOU85l4d5gfuq7ldaDQnBXZImIW3y8
OM2ZuIWwKoEecQ5Rq4xLiHO4GtS/nDjHJnFisufYODiV5DGYoR1Q1DJ6XnJr
BjKvGl2nvkD49utR1BdwVA8bo75gdg1rL/UL1i48d4z6BZmDq/SoXyh9O5VD
PYXOoXIt6inKfs9Wo55iRGRdgYWsFHrMOHcUQARzLe3iJncRtH5Zd5I8AN9k
GN4mD2Amb2UOeQCL4uTLyBvgVOhZT97AGy6pcuQNKKoeCiTPgCU30IE8g0s2
uqWRZzBiqfMUeQksu0KiyUv4KradpWQvAHvLmiTyGBwQOi4ij4FHYpYVeQz9
mEwl8h6sWR13gLwH3EaWLXkPfmI3TpInOWlHz/qSJ1FntlCdPIl6cZp95FWO
MHT4HXkVXt1Z0k9eBQvVhzPkYY7Kx8Yd5GEslLa95Kbkwf+Scv/B
           "], 
           Polygon3DBox[{{37, 34, 46, 49}, {49, 46, 56}, {46, 48, 57, 56}, {
             34, 28, 36, 48, 46}, {36, 43, 48}, {48, 43, 51, 57}, {24, 32, 43,
              36}, {24, 19, 32}, {19, 21, 35, 32}, {32, 35, 47, 51, 43}, {21, 
             31, 35}, {35, 31, 42, 47}, {49, 56, 58, 50}, {50, 58, 52}, {58, 
             60, 54, 52}, {56, 57, 59, 60, 58}, {60, 55, 54}, {54, 55, 45, 
             44}, {59, 53, 55, 60}, {57, 51, 59}, {51, 47, 53, 59}, {53, 42, 
             39, 45, 55}, {47, 42, 53}, {42, 31, 25, 39}, {50, 52, 41, 40}, {
             40, 41, 29}, {41, 38, 23, 29}, {52, 54, 44, 38, 41}, {38, 26, 
             23}, {23, 26, 14, 12}, {44, 33, 26, 38}, {44, 45, 33}, {45, 39, 
             27, 33}, {33, 27, 15, 14, 26}, {39, 25, 27}, {27, 25, 13, 15}, {
             40, 29, 20, 30}, {30, 20, 18}, {20, 10, 8, 18}, {29, 23, 12, 10, 
             20}, {10, 2, 8}, {8, 2, 1, 6}, {12, 4, 2, 10}, {12, 14, 4}, {14, 
             15, 5, 4}, {4, 5, 3, 1, 2}, {15, 13, 5}, {5, 13, 11, 3}, {30, 18,
              22, 37}, {37, 22, 34}, {22, 16, 28, 34}, {18, 8, 6, 16, 22}, {
             16, 17, 28}, {28, 17, 24, 36}, {6, 7, 17, 16}, {6, 1, 7}, {1, 3, 
             9, 7}, {7, 9, 19, 24, 17}, {3, 11, 9}, {9, 11, 21, 19}, {37, 49, 
             50, 40, 30}, {11, 13, 25, 31, 21}}]]],
         "\"gyrate rhombicosidodecahedron\""],
        Annotation[#, "gyrate rhombicosidodecahedron", "Tooltip"]& ],
       TraditionalForm], {2162.7692307692305`, -2940.}, {Center, Center}, {359.9999999999998, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwVlHk4FGgcx2fYVCqqJ0eHbQvpoUNYHeQ3qPSQxINy32JJjiKqdeRYRrXZ
orRYZ47SQ9Yks/Mb99GO5Cr3fR/PuMa41r7zx/vv+3vf7+/7+RxyvG3iIkSh
UDTJESbnbL1MVoM2le06EexuYPMPVvda/dohNQBR3KKmYSEq+4+JjrTpymGQ
M2ycGS7MwM9WYT1VDRT2jvD6Mu89o1hncPh5tSwH94ft3db9lMJO/FHYV6W/
EIICjMNW8iYw6vuBOI2odbS103p9coaL5m5JXW3Fw6Axmfm69fwaCpkaMkZt
uaByVb/1seg0bk4z0G12W0WOtn2xuGEZXJe3uWbfyANVt6x5raQVTNQzKbvF
4oHmrPrLuvAu8Lto5BcstoyR4inwQmsJE3VGQiQah9BuW67spA4fVYOrsw2u
VqFFTHnuGakVVIhm1c5E8lBRcTnS33IW5kv6siRTF+HgyLFoH08e7igo6vTp
Hse88YfBPSl8sHO9efkkfwFHjvEDY9PW8IpPMNXVrhE2fAbGL7cuYNgRlTc9
59agMvWR6eJyB8LcgRwRh3l0yjiqLik2DmWLWqZhl1YxwIjuHn1pHvOV0UKu
fBap1an3P+nxcVNHU37d5hl0tbvRe/BYAf68J1TUVJVCu2umwShynsKmxWgh
1pl18H+l/+in0mmQ6WTmsdXH0CpBmq52nsKOGfJrqjDpR3nKF9ZC+jCqvbxG
rzHLBc6I5CHRTVR21ZuPJZQLQ6h75racvOYULDEjPGxPb8DDA/e+ZcwNICvA
szJWkYcMaYZ5lO0KVDmKloQe6UfJ0hIvbs8GslhbY3SsJ+Gu+4f02pY+tJlQ
u5NgSaV1bbQ07GS+h9LE4Hj7Z92ocj/zhjljA0yuS7cXOE6jkkKGxb7lduw4
fSN/TogHy85a/7EcVlGjx105x7Ade4yMlfnrK7gc75axK5qHr3fKvnA0/4bT
jIRrFvQpzAyP3GogQ2G3ZVd+OR7JRht98RylpCEszZPxz95NpU1ZMlZZbUyM
u1m7w3JtGWqM9EW++/HBuHs2JMIpDvxsAyNcO6lsa2nHW6V/vgNFXadEcg80
t2imkHvAPVlScA/bxcY3iMwFWZ2qS2QujD57LJhLk7gzr0XeD8W+2h/I+zEl
+Irg/fBitOE++S+IFT+xIf/F+Fg1wX9BpuNBVpNaD/R71j9w9qLSTgfYe5dt
IfOKqnpJnjDhLxJD8gQdjzAGyRN7TxpNkPxhd6RHM8kfdvWxnEn+6DHKtLW5
PAht+kcO2rat4F7l5rX2iEXUvWr/luwRut9pnyB7RIe0AMEeMSXLv4DsHf7l
BhytNctFiQUZwd5pCkpiOVv1RsGRqYFf761DwvZer7UQLiRkxhat35kEqSJ8
q0jyrayjcNukuvBpSFAq6SHsK678nfQQ+kWCBD1kpx/udSS9habFVlPSW0jp
ey/oLQRWeaeRnsP03lUgPUennYaCnsOpi+qDhAswd9j/lnCBmtuZAi5AnNtk
TDgCHY2l3whHUPQk+SzhCF1KQsIId/BBY+Ar4Q6oX24LuMOKzlsdFhFLkP8q
sHfIioe/yF/3pQ9M4/GnEKokzIckg7F8Fb1BpG5qVKhP46NUwowa4R0el89y
CO9AH3v2kfAOqdLpnsQP8Knl73PED8ALEAolfgBD1vJz4h9gPVFnEv9g8iNX
gX+gJs+bTnwFiXJm8cRXsKISKvAVKjTYDMr+9R/0xEmoeFnPYVxzVbAipxBh
i7DqR48N4LhEVEyVl4F2tUEcpYuLvOxD+4kPaa5jinWn+gsxuYSbT3wI71Ll
Rok/aRWmEp+JP2HpfJJQjSwHcvwWT/xQRqXNh+uKc6zrsO5CNX2grxz/B5zM
Ba0=
           "], 
           Polygon3DBox[{{20, 15, 26, 32}, {32, 26, 38}, {26, 25, 37, 38}, {
             15, 6, 14, 25, 26}, {14, 24, 25}, {25, 24, 36, 37}, {8, 18, 24, 
             14}, {8, 11, 18}, {11, 21, 30, 18}, {18, 30, 42, 36, 24}, {21, 
             33, 30}, {30, 33, 45, 42}, {32, 38, 49, 44}, {49, 55, 57}, {55, 
             59, 60, 57}, {38, 37, 48, 55, 49}, {59, 58, 60}, {60, 58, 54, 
             56}, {48, 53, 59, 55}, {37, 36, 48}, {36, 42, 53, 48}, {53, 45, 
             52, 58, 59}, {42, 45, 53}, {45, 33, 41, 52}, {49, 57, 51, 44}, {
             44, 51, 40}, {51, 50, 39, 40}, {57, 60, 56, 50, 51}, {50, 43, 
             39}, {43, 47, 35, 31}, {56, 47, 43, 50}, {56, 54, 47}, {58, 52, 
             46, 54}, {54, 46, 34, 35, 47}, {52, 41, 46}, {46, 41, 29, 34}, {
             40, 39, 27, 28}, {28, 27, 16}, {27, 19, 9, 16}, {39, 43, 31, 19, 
             27}, {19, 13, 9}, {9, 13, 5, 3}, {31, 23, 13, 19}, {31, 35, 
             23}, {35, 34, 22, 23}, {23, 22, 12, 5, 13}, {34, 29, 22}, {22, 
             29, 17, 12}, {28, 16, 10, 20}, {20, 10, 15}, {10, 4, 6, 15}, {16,
              9, 3, 4, 10}, {4, 2, 6}, {6, 2, 8, 14}, {3, 1, 2, 4}, {3, 5, 
             1}, {5, 12, 7, 1}, {1, 7, 11, 8, 2}, {12, 17, 7}, {7, 17, 21, 
             11}, {20, 32, 44, 40, 28}, {17, 29, 41, 33, 21}}]]],
         "\"metabigyrate rhombicosidodecahedron\""],
        Annotation[#, "metabigyrate rhombicosidodecahedron", "Tooltip"]& ],
       TraditionalForm], {2556., -2940.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwN0fk/1PkfAPA5zFGxjyySUo7a2r6EbJQc7w9KbouobGoRtpDKLRQdm6+j
ktqkwy1slCv3602b6yubYwrJlWvGMTPEGGP49sPzL3iquPs7eFJIJJLVd9Tv
OPOknVtq6DhFyVVh4+5WJHmKzfbn90Oxg3dAxyAN72LopKXXzqKJ6Ues3rJm
FLVvaMw6g4aNYmhU34lJuOXb9m9v6Ai4d74Nco6XwIOBTD2ZKj7KibjX/5jO
hkpth6mHblRcIKtm23xoHvk5STwy+x8fGW+3P3HFlYo/K19OdzZaRYEPaH5d
uAfFMt/oSa1SsJToskZZixBShCdtSZr1oPbspQtpPQVvXKd1s82aRJjNBKbm
do1A+W0Zg6R8Mh5ed/Pd5QsCMN3aVDwJfOiwac/W1iHh4mG5wq46Dno/XRh3
wnQNCU/Yz2R0rEHZ4NhHVS8hmrc68MBQSgA+R70m7TPXYHH7/WyZ7DVwKarr
8sgaR+wTqtwv61fga/2EZGq3CM3cHJL3XhEirqZySw5lBeje8q9kfanEYzX9
8vyGaSRjaTk/piKCn6/56RxjuaNg/mjpnDqVuMIw6OnPWYaBhJjdii0iSLij
dbSWvoy6/mGGWM0uwflTu8tcTnPBmaJpxFGnENX6MmuNr5eg17FHsTJMCB6W
p0wdbolh707Zz9IVAljtEoPyMRqx6/fDDtZVY3DpumHgEY0FKHmQdLXfRYAc
DMeTus6RsbzxepnSoHmoqSJyPKvIxDztOe/OtSWwH2W3PqmegxhF+lVFEwYx
YRiavqe6HZWUZdzwfjMHzj4NQdPf32rz7CKMr/NRU3T5ngFXLvQVGNen8ylE
ZFtojWzsEvpUK7nZfmwW3KMv5r29tQKLs982uJZTCM2hSnI4axYqJpej8t7z
4ZDvTzoqTAlcdFFKSeAzDc3UU/7nnfohccu2qPAjdOLMWXPjtEgOzD1WDkF4
El1+5Rx6r4CGD/z2ztxn0zgcr+aZN7xthaTnktyUAjr2NpCzv3J4FAJVpwpe
7FiDPp58Y18ECTPObzzeHD4M+dLPaXYMOvELq+Givx0PCveXDrdJDgDNs1IX
Yyreu8S0MWKvoO2s+y7Jz3vhgpvW3bwmOrEcIatmsTqFoiykk9zZnWDSXcLh
Tc+DBuOr1Uw7nVh1+6Mi9PkHGO20MhzVpeMtO5e8apSmUXUuty+U0Q7qLrn/
WC4wCO2PCgeMCyuhe8D5kLzeBUi0Szu23EslvrD2x+qGiJDFC7PT9zeUIQPx
wmvc04dMIrCiqScDW3QEpfo/LUfqE17d2T+yQEPpytm4GgbhmdrU62nTiJZ8
Z5d0VajY8S4Is5uXwX1+XE0804s+hCz88acBA3tvOyCfbdWAOqM/BVfGfkYX
y8SPcrl0IucvKfPUBg5Eb8xIN9IbQv71LpnePRScQH6n8PunNbQnPDqec3gE
LUdF7R//gY5v8fdI/pzOgdcPmGfd8r8iy8zGsKGHQjDTD8vVl6MR9cKj5ZPc
cWSgOZMXZ0vDe7ceJJFWeai+zfpVaiUb1QTkvv7LkkTM3u+U2tFNIi5xVnLj
4qZQ1kUGZWV3F3I2adIdoTCIvG9X0/AcF92WPsnU/jIGGo7SuJdCJ2auqkIc
j4cK44NyGqSGUX6Iu672LA2L34Rq2fw0h0xfntbVQvNo8YehiHNnJIgUZsjh
q+fmkHHLHc+BgxRs+id1740+AdyLNCoVXFpAHJvAjqItEkSXR9/0q24ehK3L
MTmstYj+25NomUEm40gr2WvKmkIkZ92byZoUoOAOjWYn9gIYDaX1ba0nE7HU
Io3jviLkt9mgG00to5k7HZ0j+1fR0/isnM8vRMg/QCBdqsxH4WcCF9NZZHzA
h0OLqHwNN3/dtFkiiQsmRYkV5iEMfOTfTww/NzFScRwfyDgkRiUW1W/UTwih
VnpcNbhfjC6x73bj6HKUb/sfv3wWBaco122/8G4V1a1cd5L1WIYSwuf2Rxsh
pI98+KXw2jh6YlZ30ov9EYrjTcb5WkycxSBL8jXIxPrLVzRs4khEzo7uUpOj
Y9B6NzhRwYxM7Noao/TkmwCe3vt7Z3u1AGXte1IbnkQmiOO2qPHzBATk6q00
Ja9ClO+wYx+DSiS0T0YIB5eQq5uBSdiFOTSS137mWckHRPMQHSQriSFmf7QF
ZZqK707fsHf6TYKg4Y9j+voiNKEm0XojsxElb1KmDtZJEJl2TQ+NW/iwY+Md
ZrkiH15S/o40Vl9CzOSGCsNiNmR4rN92fjMNx5ffS3jGphEKr7Ki48154MKI
EFV7cNBpuUJx8hqdKNzw/lJY6xSqWiyfXWZ9RWWwT6WqbR7pbDX68VdbEVhq
7fDgB1LwI12dOAVDBuEV6bcvuW8KFBpmTzoZvwXep3Z9dwUmMciNrCnVqYVv
AXW7iwsG0f8BsTKi5Q==
           "], 
           Polygon3DBox[{{69, 65, 60, 57, 59, 63, 68, 72, 75, 74}, {71, 74, 
             75}, {41, 44, 52, 61, 69, 74, 71, 64, 54, 46}, {55, 54, 64}, {61,
              65, 69}, {55, 64, 71, 75, 72, 66, 56, 51, 48, 49}, {44, 40, 
             52}, {50, 57, 60}, {21, 31, 42, 53, 59, 57, 50, 38, 28, 20}, {29,
              28, 38}, {53, 63, 59}, {37, 47, 56, 66, 68, 63, 53, 42, 36, 
             33}, {31, 36, 42}, {66, 72, 68}, {51, 56, 47}, {3, 7, 12, 16, 17,
              15, 10, 5, 2, 1}, {4, 1, 2}, {29, 26, 18, 9, 3, 1, 4, 11, 20, 
             28}, {21, 20, 11}, {9, 7, 3}, {44, 41, 35, 23, 12, 7, 9, 18, 30, 
             40}, {26, 30, 18}, {23, 16, 12}, {46, 35, 41}, {27, 15, 17}, {47,
              37, 24, 13, 10, 15, 27, 39, 48, 51}, {49, 48, 39}, {13, 5, 
             10}, {33, 24, 37}, {6, 14, 22, 19, 8}, {14, 6, 5, 13}, {14, 13, 
             24}, {22, 14, 24, 33}, {22, 33, 36}, {19, 22, 36, 31}, {19, 31, 
             21}, {8, 19, 21, 11}, {4, 8, 11}, {6, 8, 4, 2}, {6, 2, 5}, {25, 
             32, 43, 45, 34}, {32, 25, 16, 23}, {32, 23, 35}, {43, 32, 35, 
             46}, {43, 46, 54}, {45, 43, 54, 55}, {45, 55, 49}, {34, 45, 49, 
             39}, {27, 34, 39}, {25, 34, 27, 17}, {25, 17, 16}, {73, 67, 58, 
             62, 70}, {67, 73, 52, 40}, {67, 40, 30}, {67, 30, 26, 58}, {58, 
             26, 29}, {58, 29, 38, 62}, {62, 38, 50}, {62, 50, 60, 70}, {70, 
             60, 65}, {70, 65, 61, 73}, {73, 61, 52}}]]],
         "\"triaugmented truncated dodecahedron\""],
        Annotation[#, "triaugmented truncated dodecahedron", "Tooltip"]& ],
       TraditionalForm], {2949.2307692307686`, -2940.}, {Center, Center}, {359.99999999999955`, 360.},
      
      ContentSelectable->True], 
     TagBox[
      InsetBox["", {3342.461538461538, -2940.}, {
       Center, Center}, {359.99999999999955`, 360.}],
      "InsetString"], 
     TagBox[
      InsetBox["", {3735.6923076923067`, -2940.}, {
       Center, Center}, {359.99999999999955`, 360.}],
      "InsetString"], 
     TagBox[
      InsetBox["", {4128.923076923076, -2940.}, {
       Center, Center}, {360., 360.}],
      "InsetString"], 
     TagBox[
      InsetBox["", {4522.153846153846, -2940.}, {
       Center, Center}, {360., 360.}],
      "InsetString"]}}, {}},
  ContentSelectable->True,
  ImageSize->{512., Automatic},
  PlotRangePadding->{6, 5}]], "Output",
 ImageSize->{516, 340},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->Automatic},
 Graphics3DBoxOptions->{ImageSize->Automatic},
 CellLabel->"Out[2]=",
 CellID->1170087995]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1824769395],

Cell["Kepler-Poinsot solids:", "ExampleText",
 CellID->685258958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<KeplerPoinsot\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->192508245],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"GreatDodecahedron\"\>", ",", "\<\"GreatIcosahedron\"\>", 
   ",", "\<\"GreatStellatedDodecahedron\"\>", 
   ",", "\<\"SmallStellatedDodecahedron\"\>"}], "}"}]], "Output",
 ImageSize->{394, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1161176386]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsArray", "[", 
  RowBox[{"Tooltip", "@@@", 
   RowBox[{"Rest", "/@", 
    RowBox[{"PolyhedronData", "[", 
     RowBox[{"\"\<KeplerPoinsot\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<FaceCount\>\"", ",", "\"\<Image\>\"", ",", "\"\<Name\>\""}], 
       "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1914324583],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     FormBox[
      TagBox[
       TooltipBox[
        Graphics3DBox[
         GraphicsComplex3DBox[
          NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
            0, 0, 5 (50 - 10 5^Rational[1, 2])^
              Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
             0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
              Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
             Rational[-1, 2]}, {
            Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
              5^Rational[1, 2]), 
             Rational[-1, 
               2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
            Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
              5^Rational[1, 2]), 
             Rational[
              1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
            Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
              5^Rational[1, 2]), 
             Rational[-1, 
               2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
            Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
              5^Rational[1, 2]), 
             Rational[
              1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
            Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
              5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
             Rational[-1, 2]}, {
            Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
              5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
             Rational[-1, 2]}, {
            Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
              5^Rational[1, 2]), 
             Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
            Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
              5^Rational[1, 2]), Rational[
             1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
            0, 0, -0.9510565162951536}, {
            0, 0, 0.9510565162951536}, {-0.85065080835204, 
             0, -0.42532540417601994`}, {
            0.85065080835204, 0, 
             0.42532540417601994`}, {-0.2628655560595668, \
-0.8090169943749475, -0.42532540417601994`}, {-0.2628655560595668, 
            0.8090169943749475, -0.42532540417601994`}, {
            0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
            0.2628655560595668, 0.8090169943749475, 
            0.42532540417601994`}, {-0.6881909602355868, -0.5, 
            0.42532540417601994`}, {-0.6881909602355868, 0.5, 
            0.42532540417601994`}, {
            0.6881909602355868, -0.5, -0.42532540417601994`}, {
            0.6881909602355868, 0.5, -0.42532540417601994`}}], 
          Polygon3DBox[{{7, 9, 3, 1, 11}, {1, 3, 10, 8, 12}, {11, 1, 6, 8, 
           4}, {7, 5, 1, 12, 4}, {1, 5, 9, 10, 6}, {8, 6, 3, 9, 2}, {7, 2, 10,
            3, 5}, {4, 2, 9, 5, 11}, {4, 12, 6, 10, 2}, {8, 2, 7, 11, 12}, {5,
            3, 6, 12, 11}, {4, 8, 10, 9, 7}}]]],
        "\"great dodecahedron\""],
       Annotation[#, "great dodecahedron", "Tooltip"]& ],
      TraditionalForm], {194.4, -189.}, {Center, Center}, {360.00000000000006`, 360.},
     
     ContentSelectable->True], InsetBox[
     FormBox[
      TagBox[
       TooltipBox[
        Graphics3DBox[
         GraphicsComplex3DBox[
          NCache[{{
            0, 0, Rational[-1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {
            0, 0, Rational[1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[1, 8] + 
              Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], (-1)/(1 + 
             5^Rational[1, 2]), 
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[1, 8] + 
              Rational[1, 8] 5^Rational[-1, 2])^
             Rational[1, 2], (1 + 5^Rational[1, 2])^(-1), 
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {-(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], (-1)/(1 + 
             5^Rational[1, 2]), 
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {-(Rational[1, 8] + 
               Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], (1 + 
              5^Rational[1, 2])^(-1), 
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[1, 10] (5 - 5^Rational[1, 2]))^
             Rational[1, 2], 0, 
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {-(Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2], 0, 
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {
            Rational[-1, 2] (1 - 2 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[-1, 2], 
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {
            Rational[-1, 2] (1 - 2 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[1, 2], 
             Rational[-1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {
            Rational[1, 2] (1 - 2 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[-1, 2], 
             Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {
            Rational[1, 2] (1 - 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
             1, 2], Rational[1, 2] (Rational[1, 10] (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}}, {{0, 0, -0.5877852522924731}, {
            0, 0, 0.5877852522924731}, {
            0.42532540417601994`, -0.3090169943749474, -0.2628655560595668}, {
            0.42532540417601994`, 
            0.3090169943749474, -0.2628655560595668}, {-0.42532540417601994`, \
-0.3090169943749474, 0.2628655560595668}, {-0.42532540417601994`, 
            0.3090169943749474, 0.2628655560595668}, {
            0.5257311121191336, 0, 0.2628655560595668}, {-0.5257311121191336, 
             0, -0.2628655560595668}, {-0.16245984811645317`, -0.5, \
-0.2628655560595668}, {-0.16245984811645317`, 0.5, -0.2628655560595668}, {
            0.16245984811645317`, -0.5, 0.2628655560595668}, {
            0.16245984811645317`, 0.5, 0.2628655560595668}}], 
          Polygon3DBox[{{1, 7, 5}, {6, 7, 1}, {1, 5, 12}, {11, 6, 1}, {12, 11,
            1}, {2, 8, 3}, {4, 8, 2}, {2, 3, 10}, {9, 4, 2}, {10, 9, 2}, {12, 
           3, 8}, {8, 4, 11}, {8, 11, 12}, {10, 5, 7}, {7, 6, 9}, {7, 9, 
           10}, {3, 5, 10}, {12, 5, 3}, {9, 6, 4}, {4, 6, 11}}]]],
        "\"great icosahedron\""],
       Annotation[#, "great icosahedron", "Tooltip"]& ],
      TraditionalForm], {583.2, -189.}, {Center, Center}, {360.00000000000006`, 360.},
     
     ContentSelectable->True], InsetBox[
     FormBox[
      TagBox[
       TooltipBox[
        Graphics3DBox[
         GraphicsComplex3DBox[
          NCache[{{
            Root[1 - 10 #^2 + 5 #^4& , 2, 0], 0, Root[
             1 - 20 #^2 + 80 #^4& , 4, 0]}, {
            Root[1 - 10 #^2 + 5 #^4& , 3, 0], 0, Root[
             1 - 20 #^2 + 80 #^4& , 1, 0]}, {
            Root[1 - 5 #^2 + 5 #^4& , 2, 0], 0, Root[
             1 - 100 #^2 + 80 #^4& , 3, 0]}, {
            Root[1 - 5 #^2 + 5 #^4& , 3, 0], 0, Root[
             1 - 100 #^2 + 80 #^4& , 2, 0]}, {
            Root[1 - 100 #^2 + 80 #^4& , 2, 0], 
             Rational[1, 4] (1 - 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 4, 0]}, {
            Root[1 - 100 #^2 + 80 #^4& , 2, 0], 
             Rational[1, 4] (-1 + 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 4, 0]}, {
            Root[1 - 100 #^2 + 80 #^4& , 3, 0], 
             Rational[1, 4] (1 - 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 1, 0]}, {
            Root[1 - 100 #^2 + 80 #^4& , 3, 0], 
             Rational[1, 4] (-1 + 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 1, 0]}, {
            Root[1 - 40 #^2 + 80 #^4& , 2, 0], Rational[-1, 2], Root[
             1 - 100 #^2 + 80 #^4& , 3, 0]}, {
            Root[1 - 40 #^2 + 80 #^4& , 2, 0], Rational[1, 2], Root[
             1 - 100 #^2 + 80 #^4& , 3, 0]}, {
            Root[1 - 40 #^2 + 80 #^4& , 3, 0], Rational[-1, 2], Root[
             1 - 100 #^2 + 80 #^4& , 2, 0]}, {
            Root[1 - 40 #^2 + 80 #^4& , 3, 0], Rational[1, 2], Root[
             1 - 100 #^2 + 80 #^4& , 2, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
             Rational[1, 4] (1 - 5^Rational[1, 2]), Root[
             1 - 100 #^2 + 80 #^4& , 2, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
             Rational[1, 4] (-1 + 5^Rational[1, 2]), Root[
             1 - 100 #^2 + 80 #^4& , 2, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
             Rational[1, 4] (3 - 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 1, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
             Rational[1, 4] (-3 + 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 1, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
             Rational[1, 4] (3 - 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 4, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
             Rational[1, 4] (-3 + 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 4, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 4, 0], 
             Rational[1, 4] (1 - 5^Rational[1, 2]), Root[
             1 - 100 #^2 + 80 #^4& , 3, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 4, 0], 
             Rational[1, 4] (-1 + 5^Rational[1, 2]), Root[
             1 - 100 #^2 + 80 #^4& , 3, 0]}}, {{-0.32491969623290634`, 0, 
             0.42532540417602}, {
            0.32491969623290634`, 
             0, -0.4253254041760197}, {-0.5257311121191341, 0, 
             0.10040570794311364`}, {
            0.5257311121191336, 
             0, -0.10040570794311364`}, {-0.10040570794311364`, \
-0.30901699437494745`, 0.42532540417602}, {-0.10040570794311364`, 
            0.30901699437494745`, 0.42532540417602}, {
            0.10040570794311364`, -0.30901699437494745`, \
-0.4253254041760197}, {0.10040570794311364`, 
            0.30901699437494745`, -0.4253254041760197}, \
{-0.16245984811645317`, -0.5, 0.10040570794311364`}, {-0.16245984811645317`, 
            0.5, 0.10040570794311364`}, {
            0.16245984811645317`, -0.5, -0.10040570794311364`}, {
            0.16245984811645317`, 
            0.5, -0.10040570794311364`}, {-0.4253254041760197, \
-0.30901699437494745`, -0.10040570794311364`}, {-0.4253254041760197, 
            0.30901699437494745`, -0.10040570794311364`}, \
{-0.2628655560595671, 
            0.19098300562505255`, -0.4253254041760197}, {-0.2628655560595671, \
-0.19098300562505255`, -0.4253254041760197}, {0.2628655560595668, 
            0.19098300562505255`, 0.42532540417602}, {
            0.2628655560595668, -0.19098300562505255`, 0.42532540417602}, {
            0.42532540417602, -0.30901699437494745`, 0.10040570794311364`}, {
            0.42532540417602, 0.30901699437494745`, 0.10040570794311364`}}], 
          Polygon3DBox[{{13, 4, 1, 7, 17}, {18, 8, 1, 4, 14}, {10, 7, 1, 8, 
           9}, {19, 3, 2, 5, 15}, {16, 6, 2, 3, 20}, {12, 5, 2, 6, 11}, {9, 
           20, 3, 19, 10}, {11, 14, 4, 13, 12}, {17, 15, 5, 12, 13}, {14, 11, 
           6, 16, 18}, {15, 17, 7, 10, 19}, {20, 9, 8, 18, 16}}]]],
        "\"great stellated dodecahedron\""],
       Annotation[#, "great stellated dodecahedron", "Tooltip"]& ],
      TraditionalForm], {972., -189.}, {Center, Center}, {360., 360.},
     ContentSelectable->True], InsetBox[
     FormBox[
      TagBox[
       TooltipBox[
        Graphics3DBox[
         GraphicsComplex3DBox[
          NCache[{{-3^Rational[-1, 2], 0, Root[
             1 - 84 #^2 + 144 #^4& , 2, 0]}, {
            Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Root[
             1 - 84 #^2 + 144 #^4& , 3, 0]}, {
            Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], Root[
             1 - 84 #^2 + 144 #^4& , 3, 0]}, {
            Rational[1, 2] 3^Rational[-1, 2], Rational[-1, 2], Root[
             1 - 84 #^2 + 144 #^4& , 2, 0]}, {
            Rational[1, 2] 3^Rational[-1, 2], Rational[1, 2], Root[
             1 - 84 #^2 + 144 #^4& , 2, 0]}, {
            3^Rational[-1, 2], 0, Root[1 - 84 #^2 + 144 #^4& , 3, 0]}, {
            Root[1 - 9 #^2 + 9 #^4& , 2, 0], 
             0, (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
             Rational[1, 2]}, {(Rational[1, 6] (3 - 5^Rational[1, 2]))^
             Rational[1, 2], 0, 
             Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {
            Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
             Rational[1, 4] (1 - 5^Rational[1, 2]), 
             Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {
            Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
             Rational[1, 4] (-1 + 5^Rational[1, 2]), 
             Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {
            Root[1 - 36 #^2 + 144 #^4& , 3, 0], 
             Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[1, 8] + 
              Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2]}, {
            Root[1 - 36 #^2 + 144 #^4& , 3, 0], 
             Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[1, 8] + 
              Rational[1, 24] 5^Rational[1, 2])^
             Rational[1, 2]}}, {{-0.5773502691896258, 
             0, -0.11026408970826791`}, {-0.2886751345948129, -0.5, 
            0.11026408970826791`}, {-0.2886751345948129, 0.5, 
            0.11026408970826791`}, {
            0.2886751345948129, -0.5, -0.11026408970826791`}, {
            0.2886751345948129, 0.5, -0.11026408970826791`}, {
            0.5773502691896258, 0, 
             0.11026408970826791`}, {-0.3568220897730899, 0, 
             0.46708617948135783`}, {
            0.3568220897730899, 
             0, -0.46708617948135783`}, {-0.17841104488654494`, \
-0.30901699437494745`, -0.46708617948135783`}, {-0.17841104488654494`, 
            0.30901699437494745`, -0.46708617948135783`}, {
            0.17841104488654494`, -0.30901699437494745`, 
            0.46708617948135783`}, {0.17841104488654494`, 
            0.30901699437494745`, 0.46708617948135783`}}], 
          Polygon3DBox[{{2, 12, 1, 11, 3}, {10, 4, 1, 8, 2}, {3, 8, 1, 5, 
           9}, {9, 11, 1, 4, 7}, {7, 5, 1, 12, 10}, {7, 10, 2, 3, 9}, {4, 12, 
           2, 6, 7}, {9, 6, 2, 8, 11}, {7, 6, 3, 11, 5}, {12, 8, 3, 6, 10}, {
           9, 5, 4, 10, 6}, {8, 12, 4, 5, 11}}]]],
        "\"small stellated dodecahedron\""],
       Annotation[#, "small stellated dodecahedron", "Tooltip"]& ],
      TraditionalForm], {1360.8000000000002`, -189.}, {Center, Center}, {359.9999999999998, 360.},
     
     ContentSelectable->True]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 ImageSize->{364, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->Automatic},
 Graphics3DBoxOptions->{ImageSize->Automatic},
 CellLabel->"Out[2]=",
 CellID->1707619213]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->464213815],

Cell["Platonic solids:", "ExampleText",
 CellID->1425332559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<Platonic\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->384236828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Cube\"\>", ",", "\<\"Dodecahedron\"\>", 
   ",", "\<\"Icosahedron\"\>", ",", "\<\"Octahedron\"\>", 
   ",", "\<\"Tetrahedron\"\>"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->984654383]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"Tooltip", "@@@", 
   RowBox[{"Rest", "/@", 
    RowBox[{"Sort", "[", 
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"\"\<Platonic\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<FaceCount\>\"", ",", "\"\<Image\>\"", ",", "\"\<Name\>\""}], 
        "}"}]}], "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1027068858],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     FormBox[
      TagBox[
       TooltipBox[
        Graphics3DBox[
         GraphicsComplex3DBox[
          NCache[{{
            0, 0, Rational[2, 3]^Rational[1, 2] + 
             Rational[-1, 2] 6^Rational[-1, 2]}, {
            Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
             Rational[-1, 2] 6^Rational[-1, 2]}, {
            Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
             Rational[-1, 2] 6^Rational[-1, 2]}, {
            3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}}, {{
            0, 0, 0.6123724356957945}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
            0.5773502691896258, 0, -0.20412414523193154`}}], 
          Polygon3DBox[{{2, 3, 4}, {3, 2, 1}, {4, 1, 2}, {1, 4, 3}}]]],
        "\"tetrahedron\""],
       Annotation[#, "tetrahedron", "Tooltip"]& ],
      TraditionalForm], {195., -189.}, {Center, Center}, {360., 360.},
     ContentSelectable->True], InsetBox[
     FormBox[
      TagBox[
       TooltipBox[
        Graphics3DBox[
         GraphicsComplex3DBox[
          NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
            Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
            Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
            Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
            Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
            Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
            Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2], Rational[1, 2], Rational[
             1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
           0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 
           0.5}, {0.5, 0.5, -0.5}, {0.5, 0.5, 0.5}}], 
          Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 
           2}, {1, 3, 7, 5}, {2, 1, 5, 6}}]]],
        "\"cube\""],
       Annotation[#, "cube", "Tooltip"]& ],
      TraditionalForm], {585., -189.}, {Center, Center}, {360., 360.},
     ContentSelectable->True], InsetBox[
     FormBox[
      TagBox[
       TooltipBox[
        Graphics3DBox[
         GraphicsComplex3DBox[
          NCache[{{Rational[-1, 2], Rational[-1, 2], 0}, {
            Rational[-1, 2], Rational[1, 2], 0}, {0, 0, -2^Rational[-1, 2]}, {
            0, 0, 2^Rational[-1, 2]}, {Rational[1, 2], Rational[-1, 2], 0}, {
            Rational[1, 2], Rational[1, 2], 0}}, {{-0.5, -0.5, 0}, {-0.5, 0.5,
              0}, {0, 0, -0.7071067811865475}, {0, 0, 0.7071067811865475}, {
            0.5, -0.5, 0}, {0.5, 0.5, 0}}], 
          Polygon3DBox[{{4, 5, 6}, {4, 6, 2}, {4, 2, 1}, {4, 1, 5}, {5, 1, 
           3}, {5, 3, 6}, {3, 1, 2}, {6, 3, 2}}]]],
        "\"octahedron\""],
       Annotation[#, "octahedron", "Tooltip"]& ],
      TraditionalForm], {975., -189.}, {Center, Center}, {360., 360.},
     ContentSelectable->True], InsetBox[
     FormBox[
      TagBox[
       TooltipBox[
        Graphics3DBox[
         GraphicsComplex3DBox[
          NCache[{{
            0, 0, (Rational[9, 8] + Rational[3, 8] 5^Rational[1, 2])^
             Rational[1, 2]}, {
            0, 0, Rational[-1, 2] (Rational[3, 2] (3 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[1, 8] + 
              Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[1, 8] + 
              Rational[1, 24] 5^Rational[1, 2])^
             Rational[1, 2]}, {(Rational[1, 8] + 
              Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[1, 8] + 
              Rational[1, 24] 5^Rational[1, 2])^
             Rational[1, 2]}, {(Rational[1, 8] + 
              Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[1, 4] (-1 - 5^Rational[1, 2]), 
             Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[1, 8] + 
              Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[1, 4] (1 + 5^Rational[1, 2]), 
             Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[5, 8] + 
              Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[1, 8] + 
              Rational[1, 24] 5^Rational[1, 2])^
             Rational[1, 2]}, {(Rational[5, 8] + 
              Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[1, 8] + 
              Rational[1, 24] 5^Rational[1, 2])^
             Rational[
              1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
              Rational[1, 2], 
             Rational[-1, 2], (Rational[1, 8] + 
              Rational[1, 24] 5^Rational[1, 2])^
             Rational[
              1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
              Rational[1, 2], Rational[
             1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
             Rational[1, 2]}, {(Rational[3, 4] + 
              Rational[1, 3] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[-1, 2], 
             Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {(Rational[3, 4] + 
              Rational[1, 3] 5^Rational[1, 2])^Rational[1, 2], Rational[1, 2],
              Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {-(Rational[1, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2], 0, 
             Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {
            Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2], 
             Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
              Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2], 
             Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
              Rational[5, 24] 5^Rational[1, 2])^
             Rational[1, 2]}, {(Rational[1, 6] (3 + 5^Rational[1, 2]))^
             Rational[1, 2], 
             0, (Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
             Rational[1, 2]}, {
            Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
             Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {
            Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
             Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {
            Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
             Rational[1, 4] (-3 - 5^Rational[1, 2]), 
             Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2]}, {
            Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
             Rational[1, 4] (3 + 5^Rational[1, 2]), 
             Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
              Rational[1, 2]}}, {{0, 0, 1.4012585384440737`}, {
            0, 0, -1.4012585384440737`}, {
            0.17841104488654497`, -1.3090169943749475`, 
            0.46708617948135783`}, {0.17841104488654497`, 1.3090169943749475`,
             0.46708617948135783`}, {
            0.46708617948135783`, -0.8090169943749475, -1.0444364486709836`}, \
{0.46708617948135783`, 0.8090169943749475, -1.0444364486709836`}, {
            1.0444364486709836`, -0.8090169943749475, 0.46708617948135783`}, {
            1.0444364486709836`, 0.8090169943749475, 
            0.46708617948135783`}, {-1.2228474935575286`, -0.5, 
            0.46708617948135783`}, {-1.2228474935575286`, 0.5, 
            0.46708617948135783`}, {
            1.2228474935575286`, -0.5, -0.46708617948135783`}, {
            1.2228474935575286`, 
            0.5, -0.46708617948135783`}, {-0.9341723589627157, 
             0, -1.0444364486709836`}, {-0.46708617948135783`, \
-0.8090169943749475, 1.0444364486709836`}, {-0.46708617948135783`, 
            0.8090169943749475, 1.0444364486709836`}, {
            0.9341723589627157, 0, 
             1.0444364486709836`}, {-1.0444364486709836`, \
-0.8090169943749475, -0.46708617948135783`}, {-1.0444364486709836`, 
            0.8090169943749475, -0.46708617948135783`}, \
{-0.17841104488654494`, -1.3090169943749475`, -0.46708617948135783`}, \
{-0.17841104488654494`, 1.3090169943749475`, -0.46708617948135783`}}], 
          Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 
           19}, {11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2,
            5, 19, 17, 13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19,
            3, 14, 9}, {3, 7, 16, 1, 14}, {16, 8, 4, 15, 1}}]]],
        "\"dodecahedron\""],
       Annotation[#, "dodecahedron", "Tooltip"]& ],
      TraditionalForm], {1365., -189.}, {Center, Center}, {360., 360.},
     ContentSelectable->True], InsetBox[
     FormBox[
      TagBox[
       TooltipBox[
        Graphics3DBox[
         GraphicsComplex3DBox[
          NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
            0, 0, 5 (50 - 10 5^Rational[1, 2])^
              Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
             0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
              Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
             Rational[-1, 2]}, {
            Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
              5^Rational[1, 2]), 
             Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
            Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
              5^Rational[1, 2]), Rational[
             1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
            Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
              5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
             Rational[-1, 2]}, {
            Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
              5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
             Rational[-1, 2]}, {
            Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
              5^Rational[1, 2]), 
             Rational[-1, 
               2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
            Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
              5^Rational[1, 2]), 
             Rational[
              1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
            Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
              5^Rational[1, 2]), 
             Rational[-1, 
               2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
            Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
              5^Rational[1, 2]), 
             Rational[
              1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
            0, 0, -0.9510565162951536}, {
            0, 0, 0.9510565162951536}, {-0.85065080835204, 
             0, -0.42532540417601994`}, {
            0.85065080835204, 0, 0.42532540417601994`}, {
            0.6881909602355868, -0.5, -0.42532540417601994`}, {
            0.6881909602355868, 
            0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
            0.42532540417601994`}, {-0.6881909602355868, 0.5, 
            0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
            0.8090169943749475, -0.42532540417601994`}, {
            0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
            0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
          Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 
           12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 
           10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 
           9}, {6, 4, 5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 3}}]]],
        "\"icosahedron\""],
       Annotation[#, "icosahedron", "Tooltip"]& ],
      TraditionalForm], {1755., -189.}, {Center, Center}, {360., 360.},
     ContentSelectable->True]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 ImageSize->{364, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->Automatic},
 Graphics3DBoxOptions->{ImageSize->Automatic},
 CellLabel->"Out[2]=",
 CellID->577231299]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "Polyhedron Classes Indexed by an Integer", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->573944951],

Cell["Antiprisms:", "ExampleText",
 CellID->343334720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<Antiprism\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163081907],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Antiprism\"\>", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Antiprism\"\>", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Antiprism\"\>", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Antiprism\"\>", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Antiprism\"\>", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Antiprism\"\>", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Antiprism\"\>", ",", "10"}], "}"}], 
   ",", "\<\"Octahedron\"\>"}], "}"}]], "Output",
 ImageSize->{433, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1342808794]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Tooltip", "@@@", 
     RowBox[{"Rest", "/@", 
      RowBox[{"Sort", "[", 
       RowBox[{"PolyhedronData", "[", 
        RowBox[{"\"\<Antiprism\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<FaceCount\>\"", ",", "\"\<Image\>\"", ",", "\"\<Name\>\""}], 
          "}"}]}], "]"}], "]"}]}]}], ",", "4"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1995834210],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{Rational[-1, 2], Rational[-1, 2], 0}, {
             Rational[-1, 2], Rational[1, 2], 0}, {
             0, 0, -2^Rational[-1, 2]}, {0, 0, 2^Rational[-1, 2]}, {
             Rational[1, 2], Rational[-1, 2], 0}, {
             Rational[1, 2], Rational[1, 2], 0}}, {{-0.5, -0.5, 0}, {-0.5, 
              0.5, 0}, {0, 0, -0.7071067811865475}, {
             0, 0, 0.7071067811865475}, {0.5, -0.5, 0}, {0.5, 0.5, 0}}], 
           Polygon3DBox[{{4, 5, 6}, {4, 6, 2}, {4, 2, 1}, {4, 1, 5}, {5, 1, 
            3}, {5, 3, 6}, {3, 1, 2}, {6, 3, 2}}]]],
         "\"octahedron\""],
        Annotation[#, "octahedron", "Tooltip"]& ],
       TraditionalForm], {194.4, -192.}, {Center, Center}, {360.00000000000006`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2], Rational[-1, 2], 
              Rational[-1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2], 
              Rational[-1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {
             0, -2^Rational[-1, 2], 
              Rational[1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {
             0, 2^Rational[-1, 2], 
              Rational[1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {-2^Rational[-1, 2], 0, 
              Rational[1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}, {
             2^Rational[-1, 2], 0, 
              Rational[1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 8] Pi]^2)^
               Rational[1, 2]}}, {{-0.5, -0.5, -0.42044820762685725`}, {-0.5, 
             0.5, -0.42044820762685725`}, {
             0, -0.7071067811865475, 0.42044820762685725`}, {
             0, 0.7071067811865475, 0.42044820762685725`}, {
             0.5, -0.5, -0.42044820762685725`}, {0.5, 
             0.5, -0.42044820762685725`}, {-0.7071067811865475, 0, 
              0.42044820762685725`}, {
             0.7071067811865475, 0, 0.42044820762685725`}}], 
           Polygon3DBox[{{5, 1, 2, 6}, {8, 4, 7, 3}, {6, 4, 8}, {2, 7, 4}, {1,
              3, 7}, {5, 8, 3}, {6, 2, 4}, {2, 1, 7}, {1, 5, 3}, {5, 6, 
             8}}]]],
         "\"square antiprism\""],
        Annotation[#, "square antiprism", "Tooltip"]& ],
       TraditionalForm], {583.2, -192.}, {Center, Center}, {360.00000000000006`, 360.},
      
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2] (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[-1, 2], 0, 
              Rational[-1, 2] (1 + 
                Rational[-1, 4]/(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[
               1, 2] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
               Rational[-1, 2], 0, 
              Rational[
               1, 2] (1 + 
                Rational[-1, 4]/(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[1, 8] (-1 - 5^
               Rational[1, 2]) (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[-1, 2], 
              Rational[-1, 2], 
              Rational[
               1, 2] (1 + 
                Rational[-1, 4]/(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[1, 8] (-1 - 5^
               Rational[1, 2]) (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[-1, 2], Rational[
              1, 2], Rational[
               1, 2] (1 + 
                Rational[-1, 4]/(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[1, 8] (1 - 5^
               Rational[1, 2]) (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[-1, 2], 
              Rational[-1, 
                2] ((Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^(-1) (
                 Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[-1, 2] (1 + 
                Rational[-1, 4]/(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[1, 8] (1 - 5^
               Rational[1, 2]) (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[-1, 2], 
              Rational[
               1, 2] ((Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^(-1) (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2]))^Rational[1, 2], 
              Rational[-1, 2] (1 + 
                Rational[-1, 4]/(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[
               1, 8] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
               Rational[-1, 2] (-1 + 5^Rational[1, 2]), 
              Rational[-1, 
                2] ((Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^(-1) (
                 Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]))^
               Rational[1, 2], 
              Rational[
               1, 2] (1 + 
                Rational[-1, 4]/(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[
               1, 8] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
               Rational[-1, 2] (-1 + 5^Rational[1, 2]), 
              Rational[
               1, 2] ((Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^(-1) (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2]))^Rational[1, 2], 
              Rational[
               1, 2] (1 + 
                Rational[-1, 4]/(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[
               1, 8] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
               Rational[-1, 2] (1 + 5^Rational[1, 2]), Rational[-1, 2], 
              Rational[-1, 2] (1 + 
                Rational[-1, 4]/(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2]))^Rational[1, 2]}, {
             Rational[
               1, 8] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
               Rational[-1, 2] (1 + 5^Rational[1, 2]), Rational[1, 2], 
              Rational[-1, 2] (1 + 
                Rational[-1, 4]/(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2]))^
               Rational[1, 2]}}, {{-0.8506508083520399, 
              0, -0.42532540417601994`}, {
             0.8506508083520399, 0, 
              0.42532540417601994`}, {-0.6881909602355868, -0.5, 
             0.42532540417601994`}, {-0.6881909602355868, 0.5, 
             0.42532540417601994`}, {-0.2628655560595668, \
-0.8090169943749475, -0.42532540417601994`}, {-0.2628655560595668, 
             0.8090169943749475, -0.42532540417601994`}, {
             0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
             0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}, {
             0.6881909602355868, -0.5, -0.42532540417601994`}, {
             0.6881909602355868, 0.5, -0.42532540417601994`}}], 
           Polygon3DBox[{{9, 5, 1, 6, 10}, {2, 8, 4, 3, 7}, {10, 8, 2}, {6, 4,
              8}, {1, 3, 4}, {5, 7, 3}, {9, 2, 7}, {10, 6, 8}, {6, 1, 4}, {1, 
             5, 3}, {5, 9, 7}, {9, 10, 2}}]]],
         "\"pentagonal antiprism\""],
        Annotation[#, "pentagonal antiprism", "Tooltip"]& ],
       TraditionalForm], {972., -192.}, {Center, Center}, {360., 360.},
      ContentSelectable->True], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{-1, 0, 
              Rational[1, 2] (1 + Rational[-1, 2] (-1 + 3^Rational[1, 2])^2)^
               Rational[1, 2]}, {
             Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2], 
              Rational[1, 2] (1 + Rational[-1, 2] (-1 + 3^Rational[1, 2])^2)^
               Rational[1, 2]}, {
             Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2], 
              Rational[1, 2] (1 + Rational[-1, 2] (-1 + 3^Rational[1, 2])^2)^
               Rational[1, 2]}, {
             0, -1, Rational[-1, 2] (1 + 
                Rational[-1, 2] (-1 + 3^Rational[1, 2])^2)^Rational[1, 2]}, {
             0, 1, Rational[-1, 2] (1 + 
                Rational[-1, 2] (-1 + 3^Rational[1, 2])^2)^Rational[1, 2]}, {
             Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2], 
              Rational[1, 2] (1 + Rational[-1, 2] (-1 + 3^Rational[1, 2])^2)^
               Rational[1, 2]}, {
             Rational[1, 2], Rational[1, 2] 3^Rational[1, 2], 
              Rational[1, 2] (1 + Rational[-1, 2] (-1 + 3^Rational[1, 2])^2)^
               Rational[1, 2]}, {
             1, 0, Rational[
               1, 2] (1 + Rational[-1, 2] (-1 + 3^Rational[1, 2])^2)^
               Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2] (1 + Rational[-1, 2] (-1 + 3^Rational[1, 2])^2)^
               Rational[1, 2]}, {
             Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2] (1 + Rational[-1, 2] (-1 + 3^Rational[1, 2])^2)^
               Rational[1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2], 
              Rational[-1, 2] (1 + Rational[-1, 2] (-1 + 3^Rational[1, 2])^2)^
               Rational[1, 2]}, {
             Rational[1, 2] 3^Rational[1, 2], Rational[1, 2], 
              Rational[-1, 2] (1 + Rational[-1, 2] (-1 + 3^Rational[1, 2])^2)^
               Rational[1, 2]}}, {{-1, 0, 
              0.42779983858367615`}, {-0.5, -0.8660254037844386, 
             0.42779983858367615`}, {-0.5, 0.8660254037844386, 
             0.42779983858367615`}, {0, -1, -0.42779983858367615`}, {
             0, 1, -0.42779983858367615`}, {0.5, -0.8660254037844386, 
             0.42779983858367615`}, {0.5, 0.8660254037844386, 
             0.42779983858367615`}, {
             1, 0, 0.42779983858367615`}, {-0.8660254037844386, -0.5, \
-0.42779983858367615`}, {-0.8660254037844386, 0.5, -0.42779983858367615`}, {
             0.8660254037844386, -0.5, -0.42779983858367615`}, {
             0.8660254037844386, 0.5, -0.42779983858367615`}}], 
           Polygon3DBox[{{11, 4, 9, 10, 5, 12}, {8, 7, 3, 1, 2, 6}, {12, 7, 
             8}, {5, 3, 7}, {10, 1, 3}, {9, 2, 1}, {4, 6, 2}, {11, 8, 6}, {12,
              5, 7}, {5, 10, 3}, {10, 9, 1}, {9, 4, 2}, {4, 11, 6}, {11, 12, 
             8}}]]],
         "\"hexagonal antiprism\""],
        Annotation[#, "hexagonal antiprism", "Tooltip"]& ],
       TraditionalForm], {1360.8000000000002`, -192.}, {Center, Center}, {359.9999999999998, 360.},
      
      ContentSelectable->True]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         Graphics3DBox[
          GraphicsComplex3DBox[
           NCache[{{
             Rational[-1, 2] Cot[Rational[1, 7] Pi], Rational[-1, 2], 
              Rational[1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 14] Pi]^2)^
               Rational[1, 2]}, {
             Rational[-1, 2] Cot[Rational[1, 7] Pi], Rational[1, 2], 
              Rational[1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 14] Pi]^2)^
               Rational[1, 2]}, {
             Rational[1, 2] Cot[Rational[1, 7] Pi], Rational[-1, 2], 
              Rational[-1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 14] Pi]^2)^
               Rational[1, 2]}, {
             Rational[1, 2] Cot[Rational[1, 7] Pi], Rational[1, 2], 
              Rational[-1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 14] Pi]^2)^
               Rational[1, 2]}, {
             Rational[-1, 2] Csc[Rational[1, 7] Pi], 0, 
              Rational[-1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 14] Pi]^2)^
               Rational[1, 2]}, {
             Rational[1, 2] Csc[Rational[1, 7] Pi], 0, 
              Rational[1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 14] Pi]^2)^
               Rational[1, 2]}, {
             Rational[-1, 2] Csc[Rational[1, 7] Pi] Sin[Rational[1, 14] Pi], 
              Rational[-1, 2] Cos[Rational[1, 14] Pi] Csc[Rational[1, 7] Pi], 
              Rational[1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 14] Pi]^2)^
               Rational[1, 2]}, {
             Rational[-1, 2] Csc[Rational[1, 7] Pi] Sin[Rational[1, 14] Pi], 
              Rational[1, 2] Cos[Rational[1, 14] Pi] Csc[Rational[1, 7] Pi], 
              Rational[1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 14] Pi]^2)^
               Rational[1, 2]}, {
             Rational[1, 2] Csc[Rational[1, 7] Pi] Sin[Rational[1, 14] Pi], 
              Rational[-1, 2] Cos[Rational[1, 14] Pi] Csc[Rational[1, 7] Pi], 
              Rational[-1, 2] (1 + Rational[-1, 4] Sec[Rational[1, 14] Pi]^2)^
               Rational[1, 2]}, {
             Rational[1, 2] Csc[Rational[1, 7] Pi] Sin[Rational[1, 14] Pi], 
              Rational[1, 2] Cos[Rational[1, 14] Pi] Csc[Rational[1, 7] Pi], 
              Rational[-1, 2] (1 + Rational[