(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15100,        540]
NotebookOptionsPosition[     11695,        428]
NotebookOutlinePosition[     13166,        468]
CellTagsIndexPosition[     13081,        463]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"], 
          "Finding the Structure of a Polynomial" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingTheStructureOfAPolynomial"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Putting Constraints on Patterns\"\>", 
       2->"\<\"Finding the Structure of a Polynomial\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Collect" :> Documentation`HelpLookup["paclet:ref/Collect"], 
          "Series" :> Documentation`HelpLookup["paclet:ref/Series"], 
          "Variables" :> Documentation`HelpLookup["paclet:ref/Variables"], 
          "Exponent" :> Documentation`HelpLookup["paclet:ref/Exponent"], 
          "CoefficientList" :> 
          Documentation`HelpLookup["paclet:ref/CoefficientList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Collect\"\>", 2->"\<\"Series\"\>", 
       3->"\<\"Variables\"\>", 4->"\<\"Exponent\"\>", 
       5->"\<\"CoefficientList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PolynomialQ", "ObjectName",
 CellID->3435],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolynomialQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolynomialQ"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["var", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a polynomial in ",
     Cell[BoxData[
      StyleBox["var", "TI"]], "InlineFormula"],
     ", and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolynomialQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolynomialQ"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["var", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]tests whether ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a polynomial in the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["var", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25976]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["var", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " need not be symbols; ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"PolynomialQ", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "a", "]"}], "+", 
      RowBox[{
       RowBox[{"f", "[", "a", "]"}], "^", "2"}]}], ",", 
     RowBox[{"f", "[", "a", "]"}]}], "]"}], "\[LongRightArrow]", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14840]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->273271281],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->150108242],

Cell["\<\
Test whether an expression is a polynomial in the specified variable:\
\>", "ExampleText",
 CellID->878363215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"2", 
     RowBox[{"x", "/", "y"}]}], "+", 
    RowBox[{"3", "x", " ", "z"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417454432],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->729442795]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"2", 
     RowBox[{"x", "/", "y"}]}], "+", 
    RowBox[{"3", "x", " ", "z"}]}], ",", "y"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->626569129],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->79991427]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89042200],

Cell["\<\
Test whether an expression is a polynomial in the specified set of variables:\
\
\>", "ExampleText",
 CellID->172040131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"a", " ", "x", " ", 
     RowBox[{"y", "^", "2"}]}], "-", 
    RowBox[{"b", " ", 
     RowBox[{"Sin", "[", "c", "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->606574659],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->897944837]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"a", " ", "x", " ", 
     RowBox[{"y", "^", "2"}]}], "-", 
    RowBox[{"b", " ", 
     RowBox[{"Sin", "[", "c", "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38738510],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->161825572]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12637],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Collect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Collect"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Series",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Series"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Variables",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variables"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoefficientList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27323]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16048],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->8529],

Cell[TextData[ButtonBox["Finding the Structure of a Polynomial",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingTheStructureOfAPolynomial"]], "Tutorials",\

 CellID->190]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->45888001]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolynomialQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 11, 54.0753344}", "context" -> "System`", 
    "keywords" -> {
     "testing for polynomials", "polynomial functions", 
      "polynomial structure", "polynomial structure test", 
      "function class test"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PolynomialQ[expr, var] yields True if expr is a polynomial in var, and \
yields False otherwise. PolynomialQ[expr, {var_1, ...}] tests whether expr is \
a polynomial in the var_i. ", "synonyms" -> {"polynomial q"}, "title" -> 
    "PolynomialQ", "type" -> "Symbol", "uri" -> "ref/PolynomialQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5897, 192, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->273271281]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12938, 456}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2403, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3026, 84, 48, 1, 70, "ObjectName",
 CellID->3435],
Cell[3077, 87, 1714, 57, 70, "Usage",
 CellID->25976]
}, Open  ]],
Cell[CellGroupData[{
Cell[4828, 149, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5306, 166, 554, 21, 70, "Notes",
 CellID->14840]
}, Closed]],
Cell[CellGroupData[{
Cell[5897, 192, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->273271281],
Cell[CellGroupData[{
Cell[6282, 206, 148, 5, 70, "ExampleSection",
 CellID->150108242],
Cell[6433, 213, 120, 3, 70, "ExampleText",
 CellID->878363215],
Cell[CellGroupData[{
Cell[6578, 220, 265, 9, 28, "Input",
 CellID->417454432],
Cell[6846, 231, 161, 5, 36, "Output",
 CellID->729442795]
}, Open  ]],
Cell[CellGroupData[{
Cell[7044, 241, 265, 9, 28, "Input",
 CellID->626569129],
Cell[7312, 252, 161, 5, 36, "Output",
 CellID->79991427]
}, Open  ]],
Cell[7488, 260, 124, 3, 70, "ExampleDelimiter",
 CellID->89042200],
Cell[7615, 265, 130, 4, 70, "ExampleText",
 CellID->172040131],
Cell[CellGroupData[{
Cell[7770, 273, 357, 12, 70, "Input",
 CellID->606574659],
Cell[8130, 287, 161, 5, 36, "Output",
 CellID->897944837]
}, Open  ]],
Cell[CellGroupData[{
Cell[8328, 297, 366, 12, 70, "Input",
 CellID->38738510],
Cell[8697, 311, 162, 5, 36, "Output",
 CellID->161825572]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8920, 323, 311, 9, 70, "SeeAlsoSection",
 CellID->12637],
Cell[9234, 334, 1196, 44, 70, "SeeAlso",
 CellID->27323]
}, Open  ]],
Cell[CellGroupData[{
Cell[10467, 383, 314, 9, 70, "TutorialsSection",
 CellID->16048],
Cell[10784, 394, 169, 3, 70, "Tutorials",
 CellID->8529],
Cell[10956, 399, 180, 4, 70, "Tutorials",
 CellID->190]
}, Open  ]],
Cell[CellGroupData[{
Cell[11173, 408, 299, 8, 70, "MoreAboutSection"],
Cell[11475, 418, 148, 3, 70, "MoreAbout",
 CellID->45888001]
}, Open  ]],
Cell[11638, 424, 27, 0, 70, "History"],
Cell[11668, 426, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

