(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31568,       1229]
NotebookOptionsPosition[     24304,        971]
NotebookOutlinePosition[     25690,       1010]
CellTagsIndexPosition[     25605,       1005]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Operations on Polynomials\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolynomialQuotient" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialQuotient"], "Apart" :> 
          Documentation`HelpLookup["paclet:ref/Apart"], "Cancel" :> 
          Documentation`HelpLookup["paclet:ref/Cancel"], "PolynomialMod" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialMod"], "Mod" :> 
          Documentation`HelpLookup["paclet:ref/Mod"], "PolynomialReduce" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialReduce"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PolynomialQuotient\"\>", 
       2->"\<\"Apart\"\>", 3->"\<\"Cancel\"\>", 4->"\<\"PolynomialMod\"\>", 
       5->"\<\"Mod\"\>", 6->"\<\"PolynomialReduce\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Division" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialDivision"], 
          "Rational Functions" :> 
          Documentation`HelpLookup["paclet:guide/RationalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Polynomial Division\"\>", 
       2->"\<\"Rational Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PolynomialRemainder", "ObjectName",
 CellID->12975],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolynomialRemainder",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolynomialRemainder"], "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["q", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the remainder from dividing ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     ", treated as polynomials in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4813]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The degree of the result in ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is guaranteed to be smaller than the degree of ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1183],

Cell[TextData[{
 "Unlike ",
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PolynomialRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFormula"],
 " performs divisions in generating its results. "
}], "Notes",
 CellID->10391],

Cell[TextData[{
 "With the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Modulus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Modulus"], "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ", the remainder is computed modulo ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->393141159]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->234352041],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->116413505],

Cell["Find the remainder after dividing one polynomial by another:", \
"ExampleText",
 CellID->106487567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialRemainder", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"x", "+", "a"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234400331],

Cell[BoxData[
 SuperscriptBox["a", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->470637227]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18835],

Cell["\<\
The resulting polynomial will have coefficients that are rational expressions \
of input coefficients:\
\>", "ExampleText",
 CellID->539034256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialRemainder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "x"}], "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->437091989],

Cell[BoxData[
 FractionBox["3", "4"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->377037174]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialRemainder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", " ", 
    RowBox[{"b", " ", "x"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->132983447],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox["1", 
   SuperscriptBox["a", "2"]], "-", 
  FractionBox["b", "a"]}]], "Output",
 ImageSize->{64, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->150191796]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialRemainder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], ",", 
   RowBox[{
    RowBox[{"Pi", " ", "x"}], "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->730441424],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox["1", 
   SuperscriptBox["\[Pi]", "2"]], "-", 
  FractionBox["1", "\[Pi]"]}]], "Output",
 ImageSize->{66, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->309373501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->606569546],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFormula"],
 " also works for rational functions:"
}], "ExampleText",
 CellID->645246260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialRemainder", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"x", "+", "1"}], 
    RowBox[{"x", "+", "2"}]], ",", 
   FractionBox[
    RowBox[{"x", "+", "1"}], 
    RowBox[{"x", "+", "3"}]], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198260822],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297241299]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->82121532],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->6522235],

Cell["Use a prime modulus:", "ExampleText",
 CellID->463780863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialRemainder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"4", " ", "x"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "x"}], "+", "1"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3407125],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->301954559]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialRemainder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"4", " ", "x"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "x"}], "+", "1"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154342918],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->108763068]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23171],

Cell["Euclid's algorithm for the greatest common divisor:", "ExampleText",
 CellID->680418097],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Euclid", "[", 
    RowBox[{"f_", ",", "g_", ",", "x_"}], "]"}], "/;", 
   RowBox[{
    RowBox[{"Exponent", "[", 
     RowBox[{"f", ",", "x"}], "]"}], "<", 
    RowBox[{"Exponent", "[", 
     RowBox[{"g", ",", "x"}], "]"}]}]}], " ", ":=", 
  RowBox[{"Euclid", "[", 
   RowBox[{"g", ",", "f", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227864394],

Cell[BoxData[
 RowBox[{
  RowBox[{"Euclid", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"g_", "?", "NumericQ"}], ",", "x_"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"PossibleZeroQ", "[", "g", "]"}], ",", "f", ",", "1"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->435190692],

Cell[BoxData[
 RowBox[{
  RowBox[{"Euclid", "[", 
   RowBox[{"f_", ",", "g_", ",", "x_"}], "]"}], ":=", 
  RowBox[{"Euclid", "[", 
   RowBox[{"g", ",", 
    RowBox[{"PolynomialRemainder", "[", 
     RowBox[{"f", ",", "g", ",", "x"}], "]"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->237386279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Euclid", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "2"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "2"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "3"}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->61287089],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], "-", 
  RowBox[{"2", " ", "x"}]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->123196858]
}, Open  ]],

Cell["Divide by the leading coefficient:", "ExampleText",
 CellID->87652818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"%", "/", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"%", ",", "x", ",", "1"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->129850966],

Cell[BoxData[
 RowBox[{"2", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->483245389]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "2"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "2"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "3"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->178150785],

Cell[BoxData[
 RowBox[{"2", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->111039393]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18595],

Cell[TextData[{
 "For a polynomial ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "=", 
   RowBox[{
    StyleBox["qg", "TI"], "+", 
    StyleBox["r", "TI"]}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  ButtonBox["PolynomialQuotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQuotient"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->554893848],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"4", "x"}], "+", "1"}], ",", 
     RowBox[{"x", "+", "2"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183574653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q", "=", 
  RowBox[{"PolynomialQuotient", "[", 
   RowBox[{"f", ",", "g", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19683135],

Cell[BoxData[
 RowBox[{"2", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37850387]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"PolynomialRemainder", "[", 
   RowBox[{"f", ",", "g", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->468974377],

Cell[BoxData[
 RowBox[{"-", "3"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->159020982]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " to verify identity:"
}], "ExampleText",
 CellID->229890328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"q", " ", "g"}], "+", "r"}], "]"}], "\[Equal]", "f"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->425153559],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->392771417]
}, Open  ]],

Cell[TextData[{
 "To get both quotient and remainder use ",
 Cell[BoxData[
  ButtonBox["PolynomialQuotientRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQuotientRemainder"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->657075916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotientRemainder", "[", 
  RowBox[{"f", ",", "g", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->607439311],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", "x"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->398093896]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->457672655],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialReduce"]], "InlineFormula"],
 " generalizes ",
 Cell[BoxData[
  ButtonBox["PolynomialRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFormula"],
 " for multivariate polynomials:"
}], "ExampleText",
 CellID->460214986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"4", "x"}], "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "+", "2"}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200852104],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", "+", "x"}], "}"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95474204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41177677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialRemainder", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"x", "+", "a"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234466976],

Cell[BoxData[
 SuperscriptBox["a", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314456473]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"x", "+", "a"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->966788908],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99433900]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29720],

Cell["The variable assumed for the polynomials matters:", "ExampleText",
 CellID->52975764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PolynomialRemainder", "[", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{"x", "-", "y"}], ",", "x"}], "]"}], ",", 
   RowBox[{"PolynomialRemainder", "[", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{"x", "-", "y"}], ",", "y"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191902805],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "y"}], ",", 
   RowBox[{"2", " ", "x"}]}], "}"}]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->359281851]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19127],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialQuotient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialQuotient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cancel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cancel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialMod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialReduce"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11773]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->148],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->23646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->304095836],

Cell[TextData[ButtonBox["Polynomial Division",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialDivision"]], "MoreAbout",
 CellID->466781873],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "MoreAbout",
 CellID->534925245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
PolynomialRemainder"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolynomialRemainder - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 4.0599650}", "context" -> "System`", 
    "keywords" -> {
     "division", "polynomial division", "rem", "remainder", 
      "remainder in polynomial division"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PolynomialRemainder[p, q, x] gives the remainder from dividing p by q, \
treated as polynomials in x. ", "synonyms" -> {"polynomial remainder"}, 
    "title" -> "PolynomialRemainder", "type" -> "Symbol", "uri" -> 
    "ref/PolynomialRemainder"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5517, 179, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->234352041]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25462, 998}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2466, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3089, 83, 57, 1, 70, "ObjectName",
 CellID->12975],
Cell[3149, 86, 842, 27, 70, "Usage",
 CellID->4813]
}, Open  ]],
Cell[CellGroupData[{
Cell[4028, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4506, 135, 249, 9, 70, "Notes",
 CellID->1183],
Cell[4758, 146, 384, 13, 70, "Notes",
 CellID->10391],
Cell[5145, 161, 335, 13, 70, "Notes",
 CellID->393141159]
}, Closed]],
Cell[CellGroupData[{
Cell[5517, 179, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->234352041],
Cell[CellGroupData[{
Cell[5902, 193, 148, 5, 70, "ExampleSection",
 CellID->116413505],
Cell[6053, 200, 105, 2, 70, "ExampleText",
 CellID->106487567],
Cell[CellGroupData[{
Cell[6183, 206, 196, 6, 28, "Input",
 CellID->234400331],
Cell[6382, 214, 181, 6, 36, "Output",
 CellID->470637227]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6612, 226, 216, 7, 70, "ExampleSection",
 CellID->18835],
Cell[6831, 235, 153, 4, 70, "ExampleText",
 CellID->539034256],
Cell[CellGroupData[{
Cell[7009, 243, 251, 8, 70, "Input",
 CellID->437091989],
Cell[7263, 253, 178, 6, 51, "Output",
 CellID->377037174]
}, Open  ]],
Cell[CellGroupData[{
Cell[7478, 264, 286, 9, 70, "Input",
 CellID->132983447],
Cell[7767, 275, 257, 9, 52, "Output",
 CellID->150191796]
}, Open  ]],
Cell[CellGroupData[{
Cell[8061, 289, 257, 8, 70, "Input",
 CellID->730441424],
Cell[8321, 299, 265, 9, 52, "Output",
 CellID->309373501]
}, Open  ]],
Cell[8601, 311, 125, 3, 70, "ExampleDelimiter",
 CellID->606569546],
Cell[8729, 316, 234, 7, 70, "ExampleText",
 CellID->645246260],
Cell[CellGroupData[{
Cell[8988, 327, 292, 10, 70, "Input",
 CellID->198260822],
Cell[9283, 339, 158, 5, 36, "Output",
 CellID->297241299]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9490, 350, 221, 7, 70, "ExampleSection",
 CellID->82121532],
Cell[CellGroupData[{
Cell[9736, 361, 226, 7, 70, "ExampleSubsection",
 CellID->6522235],
Cell[9965, 370, 63, 1, 70, "ExampleText",
 CellID->463780863],
Cell[CellGroupData[{
Cell[10053, 375, 320, 10, 70, "Input",
 CellID->3407125],
Cell[10376, 387, 158, 5, 36, "Output",
 CellID->301954559]
}, Open  ]],
Cell[CellGroupData[{
Cell[10571, 397, 322, 10, 70, "Input",
 CellID->154342918],
Cell[10896, 409, 158, 5, 36, "Output",
 CellID->108763068]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[11115, 421, 223, 7, 70, "ExampleSection",
 CellID->23171],
Cell[11341, 430, 94, 1, 70, "ExampleText",
 CellID->680418097],
Cell[11438, 433, 411, 13, 70, "Input",
 CellID->227864394],
Cell[11852, 448, 304, 10, 70, "Input",
 CellID->435190692],
Cell[12159, 460, 314, 9, 70, "Input",
 CellID->237386279],
Cell[CellGroupData[{
Cell[12498, 473, 376, 14, 70, "Input",
 CellID->61287089],
Cell[12877, 489, 221, 8, 36, "Output",
 CellID->123196858]
}, Open  ]],
Cell[13113, 500, 76, 1, 70, "ExampleText",
 CellID->87652818],
Cell[CellGroupData[{
Cell[13214, 505, 199, 6, 70, "Input",
 CellID->129850966],
Cell[13416, 513, 180, 6, 36, "Output",
 CellID->483245389]
}, Open  ]],
Cell[CellGroupData[{
Cell[13633, 524, 374, 14, 70, "Input",
 CellID->178150785],
Cell[14010, 540, 180, 6, 36, "Output",
 CellID->111039393]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14239, 552, 233, 7, 70, "ExampleSection",
 CellID->18595],
Cell[14475, 561, 520, 21, 70, "ExampleText",
 CellID->554893848],
Cell[14998, 584, 319, 12, 70, "Input",
 CellID->183574653],
Cell[CellGroupData[{
Cell[15342, 600, 170, 5, 70, "Input",
 CellID->19683135],
Cell[15515, 607, 179, 6, 36, "Output",
 CellID->37850387]
}, Open  ]],
Cell[CellGroupData[{
Cell[15731, 618, 172, 5, 70, "Input",
 CellID->468974377],
Cell[15906, 625, 175, 6, 36, "Output",
 CellID->159020982]
}, Open  ]],
Cell[16096, 634, 202, 8, 70, "ExampleText",
 CellID->229890328],
Cell[CellGroupData[{
Cell[16323, 646, 181, 6, 70, "Input",
 CellID->425153559],
Cell[16507, 654, 161, 5, 36, "Output",
 CellID->392771417]
}, Open  ]],
Cell[16683, 662, 260, 8, 70, "ExampleText",
 CellID->657075916],
Cell[CellGroupData[{
Cell[16968, 674, 156, 4, 70, "Input",
 CellID->607439311],
Cell[17127, 680, 246, 9, 36, "Output",
 CellID->398093896]
}, Open  ]],
Cell[17388, 692, 125, 3, 70, "ExampleDelimiter",
 CellID->457672655],
Cell[17516, 697, 382, 12, 70, "ExampleText",
 CellID->460214986],
Cell[CellGroupData[{
Cell[17923, 713, 297, 10, 70, "Input",
 CellID->200852104],
Cell[18223, 725, 270, 10, 36, "Output",
 CellID->95474204]
}, Open  ]],
Cell[18508, 738, 124, 3, 70, "ExampleDelimiter",
 CellID->41177677],
Cell[CellGroupData[{
Cell[18657, 745, 196, 6, 70, "Input",
 CellID->234466976],
Cell[18856, 753, 181, 6, 36, "Output",
 CellID->314456473]
}, Open  ]],
Cell[CellGroupData[{
Cell[19074, 764, 180, 6, 70, "Input",
 CellID->966788908],
Cell[19257, 772, 180, 6, 36, "Output",
 CellID->99433900]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19486, 784, 226, 7, 70, "ExampleSection",
 CellID->29720],
Cell[19715, 793, 91, 1, 70, "ExampleText",
 CellID->52975764],
Cell[CellGroupData[{
Cell[19831, 798, 383, 12, 70, "Input",
 CellID->191902805],
Cell[20217, 812, 251, 9, 36, "Output",
 CellID->359281851]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20529, 828, 311, 9, 70, "SeeAlsoSection",
 CellID->19127],
Cell[20843, 839, 1457, 53, 70, "SeeAlso",
 CellID->11773]
}, Open  ]],
Cell[CellGroupData[{
Cell[22337, 897, 312, 9, 70, "TutorialsSection",
 CellID->148],
Cell[22652, 908, 180, 4, 70, "Tutorials",
 CellID->23646]
}, Open  ]],
Cell[CellGroupData[{
Cell[22869, 917, 319, 9, 70, "MoreAboutSection",
 CellID->304095836],
Cell[23191, 928, 149, 3, 70, "MoreAbout",
 CellID->466781873],
Cell[23343, 933, 147, 3, 70, "MoreAbout",
 CellID->534925245]
}, Open  ]],
Cell[CellGroupData[{
Cell[23527, 941, 305, 8, 70, "RelatedLinksSection"],
Cell[23835, 951, 397, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[24247, 967, 27, 0, 70, "History"],
Cell[24277, 969, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

