(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    166622,       4006]
NotebookOptionsPosition[    159184,       3748]
NotebookOutlinePosition[    160532,       3786]
CellTagsIndexPosition[    160445,       3781]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tooltip" :> Documentation`HelpLookup["paclet:ref/Tooltip"], 
          "Hyperlink" :> Documentation`HelpLookup["paclet:ref/Hyperlink"], 
          "CreateDocument" :> 
          Documentation`HelpLookup["paclet:ref/CreateDocument"], 
          "MouseAnnotation" :> 
          Documentation`HelpLookup["paclet:ref/MouseAnnotation"], "Button" :> 
          Documentation`HelpLookup["paclet:ref/Button"], "PopupMenu" :> 
          Documentation`HelpLookup["paclet:ref/PopupMenu"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Tooltip\"\>", 
       2->"\<\"Hyperlink\"\>", 3->"\<\"CreateDocument\"\>", 
       4->"\<\"MouseAnnotation\"\>", 5->"\<\"Button\"\>", 
       6->"\<\"PopupMenu\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Dynamic Graphics Elements" :> 
          Documentation`HelpLookup["paclet:guide/DynamicGraphicsElements"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Dynamic Graphics Elements\"\>", 
       3->"\<\"Dynamic Visualization\"\>", 
       4->"\<\"Graphics Annotation & Appearance\"\>", 
       5->"\<\"Viewers and Annotation\"\>", 
       6->"\<\"New in 6.0: Dynamic Interactivity\"\>", 
       7->"\<\"New in 6.0: Graphics & Visualization Options\"\>", 
       8->"\<\"New in 6.0: Notebooks & Documents\"\>", 
       9->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PopupWindow", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PopupWindow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PopupWindow"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["contents", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", but pops up a window containing ",
     Cell[BoxData[
      StyleBox["contents", "TI"]], "InlineFormula"],
     " when clicked."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 " can take any notebook option."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "The default option settings for ",
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 " include ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowTitle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowTitle"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowFloating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowFloating"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->163383501],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 " by default pops up a window near the current location of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". Other locations can be specified using the ",
 Cell[BoxData[
  ButtonBox["WindowMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
 " option."
}], "Notes",
 CellID->596524930],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 " objects can appear within graphics."
}], "Notes",
 CellID->412560981]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->45208305],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->337159498],

Cell["When the expression is clicked, show a label:", "ExampleText",
 CellID->125941982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupWindow", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}], ",", "\"\<Label\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69134423],

Cell[BoxData[
 ButtonBox[
  GraphicsBox[DiskBox[{0, 0}],
   ImageSize->50],
  Appearance->None,
  BaseStyle->{},
  ButtonFrame->None,
  ButtonFunction:>CreateDocument[
    Internal`PopupWindowNotebook["Label"]],
  DefaultBaseStyle->{},
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{54, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217215272]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->889586732],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 " within graphics:"
}], "ExampleText",
 CellID->372249084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PopupWindow", "[", 
     RowBox[{
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", "0.2"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Sin", "[", "x", "]"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "6", ",", "0.5"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124735531],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyNmD1TGlEUhq/AQlIJ0YJChViJ5oMKyQyFhWJSZMbJh2n50BksiIRY0CTk
H9iFn2BJ4wwlP4GfQGlJSbm5e8+6Oa733Ned4cq49zzn431XuXxsXnXOu82r
i3azeNxv9joX7Z/F+mVf/yq5opS61a/3eaXf+/qded36vv75eB0Ga2a5XA6H
w4ODA721Wq12Op27uzv1xuz4HazJ2WyWz+f1bZUKlmQ2m51MJsGtlIPw0hB+
GYLesbOzEwSnDUHj9JbgVgJkKDDKaDRSdGWCxRsMBr65Qnwmxt5isY1Gg8em
dLUUq6HPTVxEU5ssTvfzIK5YLNIuDaS4iBTG/XDMxDPMXq/3gHlyckIEvZGY
UZaQ2QNTSpplPB4/4F5fXxNFJyRulIkihCrXTM5LoBzl1MQwp2eWcrns319B
PZQ3qgTqnWO5Y3ozhYiyWCzC9ETRHcznc7G2ZFRbGC/3lmVVxJzD9Dbu96bT
Kc1Ql3dzc6PST6pN7m2V5Y65j/ki58gtV8zZMRcyb2yA3JwS8xxTegNkWWXO
lpXaBFk4RZ55AWQhvfvWmW4DNjn2zPE8la3cdRPXBs/DsdnVAn5958ieZgTZ
dfugjhSjyP6qgDqTjCL7q/KUpz+kyP6qgFo5RfZXBdSaYCrK/toHtRIl7VDx
FLiwCvqgDB5Q+dTq1BrojlRNAe3/gg5SjCJrP7JWmGGxsuJ1NN+QIKt9BOb3
hVFktQ/BpD4ziqzoIZjUJ6a4rN0RmBmnyNrVwdyIkrFq9wFMi2K/gmnQrlPQ
LU12zeGDGuiUFH4BfFCzdvrNxOaA+iO2S1Z3z9HDGSPIyu6CHlqMIitbAt00
GUXWuAS6bTCK7IES6LjBtJM9sgs65hTZJ3ugY6KsW33yzKFtAcyAuEWg7RaY
AalWANrmHHWivxgtlgF8Fnb04Vnnd87Y4P+/s3q58+8sQ8wp6cgp+qLKvVjV
6ATQZfSYg7zIQcKZNwG65mzxvHh/Jv5/wvbN4VTFT6dd5jbXSTCoh4hRJb45
lqr4uZQTZfckbJP3+ORtZ09ib1s9Yz2Zxz+hOZ4YcsQr21wfnX7lvsyZSr0G
ueyu77NYOYP5VkO9tRL+mHvSt0Vq5R85CHlK\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98268494]
}, Open  ]],

Cell["Include a window title:", "ExampleText",
 CellID->295257080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupWindow", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}], ",", "\"\<Label\>\"", 
   ",", 
   RowBox[{"WindowTitle", "\[Rule]", "\"\<Disk\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16899101],

Cell[BoxData[
 ButtonBox[
  GraphicsBox[DiskBox[{0, 0}],
   ImageSize->50],
  Appearance->None,
  BaseStyle->{},
  ButtonFrame->None,
  ButtonFunction:>CreateDocument[
    Internal`PopupWindowNotebook["Label", WindowTitle -> "Disk"]],
  DefaultBaseStyle->{},
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{54, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106679119]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["WindowFloating",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowFloating"]], "InlineFormula"],
 " \[Rule] ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", the popup window will not remain on top of all other windows:"
}], "ExampleText",
 CellID->31592091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupWindow", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}], ",", "\"\<Label\>\"", 
   ",", 
   RowBox[{"WindowFloating", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->328411194],

Cell[BoxData[
 ButtonBox[
  GraphicsBox[DiskBox[{0, 0}],
   ImageSize->50],
  Appearance->None,
  BaseStyle->{},
  ButtonFrame->None,
  ButtonFunction:>CreateDocument[
    Internal`PopupWindowNotebook["Label", WindowFloating -> False]],
  DefaultBaseStyle->{},
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{54, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->386955454]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->218040998],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->138825359],

Cell[TextData[{
 "Change the background of the ",
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->643405886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupWindow", "[", 
  RowBox[{"\"\<xxx\>\"", ",", "\"\<Label\>\"", ",", 
   RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132541782],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  Appearance->None,
  BaseStyle->{},
  ButtonFrame->None,
  ButtonFunction:>CreateDocument[
    Internal`PopupWindowNotebook[
    "Label", Background -> RGBColor[1, 0.5, 0.5]]],
  DefaultBaseStyle->{},
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->760639781]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Editable",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->155543905],

Cell[TextData[{
 "Disable editing in the ",
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->415203308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupWindow", "[", 
  RowBox[{"\"\<xxx\>\"", ",", "\"\<Label\>\"", ",", 
   RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->703394645],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  Appearance->None,
  BaseStyle->{},
  ButtonFrame->None,
  ButtonFunction:>CreateDocument[
    Internal`PopupWindowNotebook["Label", Editable -> False]],
  DefaultBaseStyle->{},
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->514181452]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowFloating",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->265875914],

Cell[TextData[{
 "Keep the ",
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 " on top of other windows:"
}], "ExampleText",
 CellID->36867834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupWindow", "[", 
  RowBox[{"\"\<xxx\>\"", ",", "\"\<Label\>\"", ",", 
   RowBox[{"WindowFloating", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12988127],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  Appearance->None,
  BaseStyle->{},
  ButtonFrame->None,
  ButtonFunction:>CreateDocument[
    Internal`PopupWindowNotebook["Label", WindowFloating -> True]],
  DefaultBaseStyle->{},
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132151644]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowMovable",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->77465025],

Cell[TextData[{
 "Create a static ",
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->50659202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupWindow", "[", 
  RowBox[{"\"\<xxx\>\"", ",", "\"\<Label\>\"", ",", 
   RowBox[{"WindowMovable", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149804008],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  Appearance->None,
  BaseStyle->{},
  ButtonFrame->None,
  ButtonFunction:>CreateDocument[
    Internal`PopupWindowNotebook["Label", WindowMovable -> False]],
  DefaultBaseStyle->{},
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129381977]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowOpacity",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->223392316],

Cell[TextData[{
 "Create a transparent ",
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->615134415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupWindow", "[", 
  RowBox[{"\"\<xxx\>\"", ",", "\"\<Label\>\"", ",", 
   RowBox[{"WindowOpacity", "\[Rule]", ".7"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->633449304],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  Appearance->None,
  BaseStyle->{},
  ButtonFrame->None,
  ButtonFunction:>CreateDocument[
    Internal`PopupWindowNotebook["Label", WindowOpacity -> 0.7]],
  DefaultBaseStyle->{},
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105692328]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->302249855],

Cell[TextData[{
 "Change the overall ",
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 " size:"
}], "ExampleText",
 CellID->136982735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupWindow", "[", 
  RowBox[{"\"\<xxx\>\"", ",", "\"\<LABEL\>\"", ",", 
   RowBox[{"WindowSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"50", ",", "150"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->429725255],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  Appearance->None,
  BaseStyle->{},
  ButtonFrame->None,
  ButtonFunction:>CreateDocument[
    Internal`PopupWindowNotebook["LABEL", WindowSize -> {50, 150}]],
  DefaultBaseStyle->{},
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12343986]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowTitle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->338291436],

Cell[TextData[{
 "Add a title to the ",
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->453937264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupWindow", "[", 
  RowBox[{"\"\<xxx\>\"", ",", "\"\<Label\>\"", ",", 
   RowBox[{"WindowTitle", "\[Rule]", "\"\<My Title\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->517551301],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  Appearance->None,
  BaseStyle->{},
  ButtonFrame->None,
  ButtonFunction:>CreateDocument[
    Internal`PopupWindowNotebook["Label", WindowTitle -> "My Title"]],
  DefaultBaseStyle->{},
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107985195]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->129419],

Cell["Generate higher-resolution simulations as a popup:", "ExampleText",
 CellID->350030151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PopupWindow", "[", 
    RowBox[{
     RowBox[{"ArrayPlot", "[", 
      RowBox[{
       RowBox[{"CellularAutomaton", "[", 
        RowBox[{"n", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10", ",", "All"}], "}"}]}], "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}], ",", 
     RowBox[{"ArrayPlot", "[", 
      RowBox[{"CellularAutomaton", "[", 
       RowBox[{"n", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"100", ",", "All"}], "}"}]}], "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "64"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60735240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJy90MEJgEAQBMHVTEzJEA58G6dZeUl0Dcy7oK/13uucmWf/2z/ADNKPKX0s
gpBWRuljEYS0MkofiyCklVH6WAQhrYzSxyIIaWWUPhZBSCuj9LEIQloZpY9F
ENLKKH0sgpBWRuljEYS0MkofiyCklVH6WAQhrYzSxyIIaWWUPhZBSCuj9LEI
QloZpY9FENLKKH0sgpBWRuljEYS0MkofiyCklVH6WAQhrYzSxyIIaWWUPhZB
SCuj9LEIQloZpY9FENLKKH0sgpBWRuljEYS0MkofiyCklVH6WAQhrYzSxyII
aWWUPhZBSCuj9LEIQloZpY9FENLKKH0sgpBWRuljEYS0MkofiyCklVH6WAQh
rYzSxyIIaWWUPhZBSCuj9LEIQloZpY9FENLKKH0sgpBWRuljEYS0MkofiyCk
lVH6WAQhrYzSxyIIaWWUPhZBSCuj9LEIQloZpY9FENLKKH0sgpBWRuljCeQH
30YrRQ==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztz0ENgDAAwMCBEywhYQlvdOKKWeDXkLukAnrM+5z7GONaPaux/YWTHic9
Tnqc9DjpcdLjpMdJj5MeJz1Oepz0OOlx0uOkx0mPkx4nPU56nPQ46XHS46TH
SY+THic9Tnqc9DjpcdLjpMdJj5MeJz1Oepz0OOlx0uOkx0mPkx4nPU56nPQ4
6XHS46THSY+THiefvNSMUb8=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzNkdttAlEQxTbphJZSAlK+qTNdgYRQAuGxO8eewdL9nWP57vaHr/3nsizf
p/dzeh9vSUFreUcqWnxNgIoVnzOnZIXXBChJ4TlzalJ0TYCaE50zp+gE1wQo
KsE5c6pKbE2AqhGbM6dshNYEKAuhOXPqQmRNgLoPmTMn8AFrAgQ6YM6cRIer
CZDYcDlzIhusJkAkg+XMyWSomgCZC5UzJ3SBagKEKlDOnFSFqQmQmjA5c2IT
pCZALILkzMlFiJoAuQeRMwfwAGoCABpAzhxCI08BQFjkKXIQC6BFDCIBtEhh
JIgYIYwDESNNCZ2ZBlJAamQlqTvDUAZMjiQkdmgWTADqUe/IXRqF26eCVDOC
pyYB57EitYrkrUHIdS5JJSJ6bA50HGyyvSF7bQx2m4yyNSF8bgp4Gq2yrSB9
bwh6mc2yJSB+cAZ8GO6yvh9/cQR+lw6zNp9wcgJhFi+zrp5xcwBjlU+zJp5y
tB9lVGjzup1ztR1n04jzKp10thtpUqnzvJx1txlr0cnzLJx2uBdtUOrzuJt3
uRVvzwr0KJt4uhNxTit0v5p5uxFzzUt0L5p6vA91TGz0v5l7vQ13y4x0m0w+
34U8pVa6Lmbfb8JecjP9DaYP9KAPyZ1+e/kLLfg7dqhLroaJDhpm9FLnWh0b
DXSs+Kl6PqTlR1pGjht2KxM=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztzzENgEAABMEHJ1hCAgk1OnHFW6D5bDGTXH3Z43rOax9j3HPv3LbAkpMV
hNQIqRFSI6RGSI2QGiE1QmqE1AipEVIjpEZIjZAaITVCaoTUCKkRUiOkRkiN
kBohNUJqhNQIqRFSI6RGSI2QGiE1QmqE1AipEVIjpEZIjZAaITVCaoTUCKkR
UiOkRkiNkBohNUJqhNQI+eMD6EZRvw==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztkbENgDAQxAKbsBIjRKLOnGxFVnCBK5/0tfX2Ndc9zzHGs+/ddwhzIP9v
P2JQDFkKRHBVEQQRXFUEQQRXFUEQwVVFEERwVREEEVxVBEEEVxVBEMFVRRBE
cFURBBFcVQRBBFcVQRDBVUUQRHBVEQQRXFUEQQRXFUEQwVVFEERwVREEEVxV
BEEEVxVBEMFVRRBEcFURBBFcVQRBBFcVQRDBVUUQRHBVEQQRXFUEQQRXFUEQ
wVVFEERwVREEEVxVBEEEVxVBEMFVRRBEcFURBBFcVQRBBFcVQRDBVUUQRHBV
EQQRXFUEQQRXFUEQwVVFEERwVREEEVxVBEEEVxVBEMFVRRBEcFURBBFcVQRB
BFcVQRDBVUUQRHBVEbIPID8rEw==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzt0cEJgDAABMFoJ7ZkCYJv67Qr04K/JczAFXDscT3ntY8x7rl3bmyrWOfK
Mkc0CdKkR5MeTXo06dGkR5MeTXo06dGkR5MeTXo06dGkR5MeTXo06dGkR5Me
TXo06dGkR5MeTXo06dGkR5MeTXo06dGkR5MeTXo06dGkR5MeTXo06dGkR5Me
TXo06dGkR5MeTXo06dGkR5MeTXo0+eUDC/NRjQ==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzd0MEJgDAABMFoJ7ZkCYJv67QrU8SQBRfufTDH9ZzXPsa459657S+Nv1RD
smpIVg3JqiFZNSSrhmTVkKwaklVDsmpIVg3JqiFZNSSrhmTVkKwaklVDsmpI
Vg3JqiFZNSSrhmTVkKwaklVDsmpIVg3JqiFZNSSrhmTVkKwaklVDsmpIVg3J
qiFZNSSrhmTVkKwaklVDsmpIVg3JqiFZNSSrhmTVkKwaklVDsmpIVg3JqiFZ
NSSrhmTVkKwaklVDsmpIVg3JqiFZNSSrhmTVkKwaklVDsmpIVg3JqiFZNSSr
hmTVkKwaklVDsmpIVg3JqiFZNSSrhmTVkKwaklVDsmpIVg3JqiFZNSSrhmTV
kKwaklVDsmpIVg3JqiFZNSSrhmTVkKwaklVDstZorfhYgbXi5AOJmCri
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzt3EENACAMALGBEywhYQlvdOKKiSC82uRs3Mg9s0fEqk7VAAAAAAAAAAAA
AAAAAAAAAAAAAOChL6O7C420UiM=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 
      0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzd3MltQzEQA1D+dJKWXIKBnFNnuoq35Hv5i6TZSA8w5wH5oKs+j9+H4weA
r9P+nHZ6gznHgPxMV4s3ELmFqS7UOH8e+m/kP0x1paaZPdRF5jDKIvce2iJz
mElY5NFDWQT3HrIizx66Inj0EBV59VAVwbOHpMiSh6YIXj0ERZY9FEWw5CEn
suahJ4JlDzGRdQ81Eax5SIlseWiJYN1DSGTbQ0kEWx4yInseOiLY9hAR2fdQ
EcGeh4RIi4eGCPY9BETaPBRE0OJBL9LqwS+CNg9ykXYPdhG0elCL9Hhwi6Dd
g1ikz4NZBD0etCK9Hrwi6PMgFen3YBVBrwelyIgHpwj6PQhFxjwYRTDiQScy
6sEngjEPMpFxDzYRjHpQiVg8uEQw7kEkYvNgEoHFg0bE6sEjApsHiYjdg0UE
Vg8KEQ8PDhHYPQhEfDwYRODhUS7i5VEvAh+PYhE/j2oReHmUinh61IrAz6NQ
xNejUgSeHmUi3h51IvD1KBLx96gSgbdHiUiER40I/D0KRGI8KkQQ4ZEuEuWR
L4IYj2SROI9sEUR5pIpEeuSKIM4jUSTWI1MEkR5pItEeeSKI9UgSiffIEkG0
R4pIhkeOCOI9ckRS7kQXdQmR8Y1XeFOXrnKuxJeVceQXVbgrQw==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztz0ENgDAAwMCBEywhYQlvdOKKWeDXkLukAnrM+5z7GONaPaux/YWTHic9
Tnqc9DjpcdLjpMdJj5MeJz1Oepz0OOlx0uOkx0mPkx4nPU56nPQ46XHS46TH
SY+THic9Tnqc9DjpcdLjpMdJj5MeJz1Oepz0OOlx0uOkx0mPkx4nPU56nPQ4
6XHS46THSY+THiefvNSMUb8=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzdkVtOw0AQBA034UocIRLfnJNbYQUIcfza3erukVKSf6dry2+Xz/fL6zRN
H/P3NX8vz8H0JMwvqU4p4fqSJ+D6iuqYAn4eUV2T8/uG6pyYvycU58TcXlCb
E/P/gNKcmDv/ypyYe/3CnJiFfV1OzFK+LCfmwb0qJ+ZRvSgnZmVekxOzFi/J
idnwrsiJ2dIuyInZtM7nxGxLx3NidpzTOTF7yuGcmF3jbE7MvnA0J+bAN5kT
c6QbzIk5tM3lxBzLxnJiTlxTOTFnqqGcmFPTTE7MuWgkJ6bBM5ET06IZyIlp
svTnxLRJ2nNiGh3dOTGtiuacmGZDb05Mu6A1J6bDz5kT06NnzInpsvPlxPTJ
2XJiOt1cOTG9aqacmG4zT05Mv5glJ2bAy5ETM6JlyIkZstLnxIxJyXNiBp3U
OTGjSuKcmGEjbU7MuJA0Jwb4KHNiiI4wJwbZ6HJimIwsJwa6qHJiqIooJwab
aHJiuIgkJ0bgociJUWgIcmIkFjwFRiMhaIFTis4Uo1KQ1EAhZYdK0QmIegxn
FJ4qRDkvKzIUUXqsDO24sEl3QvG5ItTT0ipdAeUHS9APi7s05zOcLMAxKy/T
FM9yNI5n1NDmNJ3pbBjXpKXOYTjb4Si+QVOf3WzG00Gcc7ZCm9Gsx2N4x4yN
VsnM50O4p6yVFsHsAxH8Q+ZOt1yBiQCJGXupKfI/Mn8kMvINOksq4Q==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztzzENgEAABMEHJ1hCAgk1OnHFW6D5bDGTXH3Z43rOax9j3HPv3LbAkpMV
hNQIqRFSI6RGSI2QGiE1QmqE1AipEVIjpEZIjZAaITVCaoTUCKkRUiOkRkiN
kBohNUJqhNQIqRFSI6RGSI2QGiE1QmqE1AipEVIjpEZIjZAaITVCaoTUCKkR
UiOkRkiNkBohNUJqhNQI+eMD6EZRvw==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
      1, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzd08lNBDEARNEeMiElQhiJM3GSFXMBZum97WdXl+Xzl/Xk9+vXx/VtGIbP
2/2+3QvYIA6YechZRASJeMhZ/sjlJCLDSUQuJxEZTiLyG0kX+auEi/xHskXu
KtEi95FkkYdKsMhjJFfkqRIr8hxJFXmphIq8RjJFRiqRImORRJHRSqDIeCRP
ZKISJzIVSROZrISJTEeyRGYqUSJzkSSR2UqQyHwkR2ShEiOyFEkRWayEiCxH
MkRWVMCAR4jIqgoY8IgQWVkBAx4BIqsrYMCje5ENFTDg0bnIpgoY8OhaZGMF
DHh0LLK5AgY8uhXZUQEDHp2K7KqAAY8uRXZWwIBHhyK7K2DAozuRAxUw4NGZ
yKEKGPDoSuRgBQx4dCRyuAIGPLoRKVABAx6diBSpgAGPLkQKVcCARwcixSpg
wKO5SMEKGPBoLFK0AgY8mooUroABj4YixStgwKOZSIUKGPBoJFKlAgY8mohU
qoABjwYi1SpgwIOLVKyAAQ8sUrUCBjyoSOUKGPCAItUrYMCDiYAKGIn8AH0H
KuE=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztz8EJgEAAA8HTTmzJEg58W6ddqU3IIDuQd9htnvtcxxjHs2u8lp+oxFOJ
pxJPJZ5KPJV4KvFU4qnEU4mnEk8lnko8lXgq8VTiqcRTiacSTyWeSjyVeCrx
VOKpxFOJpxJPJZ5KPJV4KvFU4qnEU4mnEk8lnko8lXgq8VTiqcRTiacSTyWe
SjyVeCrxVOKpxPOjki9ObhvXUVs=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzdkdlNxEAUBG0yISVCWIlv4iQrFtiFPXzMTHX3k1ySf1/XlF9PH2+nl2ma
3s/f5/mbD8J0EOaD/JHpIL/k+xXVLRX8PKI6poDfN1TX5FyeUFyTc31BbU3O
3wNKa3L+/Strcm70C2tybu3ranLu5Mtqcu7dq2pyHtSLanIezWtqcp7ES2py
nr0ranIWtAtqcpas8zU5i9Lxmpxl53RNzopyuCZnzThbk7MqHK3JWfdN1uRs
6AZrcrZsczU5m7Kxmpxt11RNzo5qqCZnzzRTk7MrGqnJ2fdM1OQ0aAZqclos
/TU5TZL2mpw2R3dNTqOiuSan1dBbk9MsaK3Jafdz1uR06BlrcnrsfDU5XXK2
mpw+N1dNTqeaqSan18xTk9MtZqnJ6fdy1OQMaBlqckas9DU5Q1LympwxJ3VN
zqCSuCZn1EhbkzMsJK3JGfdR1uQAHWFNDrHR1eQgGVlNDnNR1eRAFVFNDjXR
1ORgEUlNDvdQ1OQINAQ1OQoLnoIjkRC0oGgcFDFgStGZalQGmhwgpOxQLbp9
VZDBjMJTlSjXdUkGIkqP1aHdVkbpTCg+V4V6WZulI6D8YA36XXWYxnyGkxU4
VvVpGuJZjubxbDri7KQznU3jWvTk2QhnO5zFt+cKtJLNeDqJc82XaCGa9XgO
75Yz0kMy8/kU7iVvpptg9oEM/h13qEuuwESCxIo/VeR/zPMXYVsq4Q==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztz0ENgDAAwMCBEywhYQlvdOKKWeDXkLukAnrM+5z7GONaPavtJ/4y4qPF
R4uPFh8tPlp8tPho8dHio8VHi48WHy0+Wny0+Gjx0eKjxUeLjxYfLT5afLT4
aPHR4qPFR4uPFh8tPlp8tPho8dHio8VHi48WHy0+Wny0+Gjx0eKjxUeLjxYf
LT5afLT4aPHR4qPFxwcv/ABRvw==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJy90dtNA0EQBdGFTEiJECzxTZxkhYUsC9v7mu5z50r+dNV07cfl+/PyvizL
1/X3c/29Da/wlxlbhlf5z4RVbuc1xUq385xgpeN1TbHa8TonWO16XFOseD3O
CVY839YUq55vc4JV76c1xcr305xg5QCyplg9gMwJVi8Aa4o1CsCcYI0ErqZY
J4HLCdZpwGqKtRqwnGCtCKqmWC+CygnWq4BqijUroJxgzQymplg3g8kJ1u1A
aoq1O5CcYO0QoqZYP4TICdYvAWqKgRIgJxhI0UeIiRR9BphoARj9kRYA0h6J
ISDdmRiC0pypQSi9oRoE03wDyWEwrSegHIbTeoLpgTiNF6geCNR4AQqiQOUH
sCCKVH6AKsJIRb8rwlBFP0viUCU9TOJYJb1rAlkFu2wCYQU7jCJhw3IaRdKG
5bIKpQ26bRWKG3TTLBY3pMZZLG9Ibbtg3oBZd8HAATMOo4GnxTyMJp4W6zKc
eNLry3DkSS9P45GntIE0nnlK69sEmCesiTYB6AlrIE4CeiiNxElQD6WJOhHq
gTNTJ4I9cEbyZLC7ylCeDHdXmekT4u4YU31C4B1jKFAKvCmMBUqRN4WpQjHy
hi9XKIbe8MUS5dCrumCiHHtVl2sUZK/Yko2C8BVbMFIS/iKLRkrSX2TJSlH6
kytbKYp/ckUzZfEPqnCmLP9Ble0U5v8zpTuFBf9M4VBpwV0UD5U23EXpUnHD
zZMvFVfcPPFUecWfZkKqvGOZ8UUmfZIprSZIptSaIvkFJQgrEw==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      0}, {1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzdl1FOwzAQRAM34UocAYlvzsmtoEL+YCv6mu7MepcXRZFluWMnXk/n5e3j
9e35OI737/vz+z6efljPs/QZv65H6TN+3Y//UpfxmffRa3zudzqNP5JXFp3+
kbzzK1Hpr3U9+syvRKUf6+XsM4tOP+63s+0sOv243862s+j04/rOtrPo9P+q
m3vbWXT65A9q//Dpkz+o/cOnT/6g9g+fPvmD2j98+rT/XPWh16f956oPvT6t
1/k9tPr31pELnf79//896PTjee32D5++O3/U6d///9+DTt+dP+r03fmjTt+d
P+r03fmjTr/aP3z61f7h06/2D59+tX/49HfVh15/V33o9Xd+D63+3nUo9Skf
uC8dlA/ct3Ilt/OB+6lcyd6nDsoH7rYOygfuto74fqrbOigfuNs66Hx39+ug
893dr4POd3e/Djrf3f06aP+6+3XQ/nX366D35e7XQTrufh3Z/JAdryOe92fP
/+x4Hdn8UJc/eCa3n+7xOrL5oS5/8Exy+aEuf/BMcvmhLn/wTG633eN1ZM//
ff5xPZPc+b/PP65nkjv/9/nH9Ux+P6vH68ju7/31scju7/31sci+zx7f40J2
Hl3WwfmiT/4gKF/0yR8E5Ys++YOgfNEnfxCUL/rkD4LyRZ/8QVC+6JM/CMoX
ffIHQf7Q1z8i5A99/SNC/tDXPyLkD339I0L7v399LGj/96+PBb3vGd/jAs1z
yjo4n8xhTv4g5uQPYk7+IObkD2JO/iDm5A9iTv4g5vpHZK5/ROb6R2Suf0Tm
18difn0s/sf3uFCyji8t7005
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzd0MEJgDAABMFoJ7ZkCYJv67QrU8SQBRfufTDH9ZzXPsa459657S+Nv1RD
smpIVg3JqiFZNSSrhmTVkKwaklVDsmpIVg3JqiFZNSSrhmTVkKwaklVDsmpI
Vg3JqiFZNSSrhmTVkKwaklVDsmpIVg3JqiFZNSSrhmTVkKwaklVDsmpIVg3J
qiFZNSSrhmTVkKwaklVDsmpIVg3JqiFZNSSrhmTVkKwaklVDsmpIVg3JqiFZ
NSSrhmTVkKwaklVDsmpIVg3JqiFZNSSrhmTVkKwaklVDsmpIVg3JqiFZNSSr
hmTVkKwaklVDsmpIVg3JqiFZNSSrhmTVkKwaklVDsmpIVg3JqiFZNSSrhmTV
kKwaklVDsmpIVg3JqiFZNSSrhmTVkKwaklVDspZgLTlZgbXi5AOJmSri
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzt0cEJgDAABMFoJ7ZkCYJv67Qr04K/JczCFXDMcT3ntY8x7rl3blukRY4s
A7LIDx6teLTi0YpHKx6teLTi0YpHKx6teLTi0YpHKx6teLTi0YpHKx6teLTi
0YpHKx6teLTi0YpHKx6teLTi0YpHKx6teLTi0YpHKx6teLTi0YpHKx6teLTi
0YpHKx6teLTi0YpHKx6teLTi0YpHKx5/+gBGi1GN
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzd0cEJgEAQBMHTTEzJEATfxmlWXhDFNVgw74Xe43rOax9j3HPv3PYX4y/q
kEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwd
kqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlD
MnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVI
pg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J
1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZ
OiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkMyKVgturPnIkiMfiZoq4g==

         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      0}, {1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzdmVFqxDAMRLO9Sa/UIyz0e8/ZW3VDMQUv5SXRjCz1gTHGeMdKLGuHvN8f
H/e3bds+n+3r2bbbD6M/S531eyy/8Vz4pTLrR7v8S2XWR55HrfWx36m0fpyz
qy2KTn8LtnAkMv0R19U+HIlMf86Xs30Unf583s6Oo+j05/N2dhxFpz/Hd3Yc
Raf/V94cHUfR6VN9UNcPnz7VB3X98OlTfVDXD58+1Qd1/fDp0/lz5Yden86f
Kz/0+hSv831o9Y/mkQudvtt/5OnP97W7fvj03f4jT//4/38POn23/8jTd/uP
PH23/8jTd/uPPP3s+uHTz64fPv3s+uHTz64fPv1V+aHXX5Ufev2V70OrvzYO
pT75A3fTQf7A3YSRgD9w98JIFvc6yB+4xzrIH7jHOsgfuMc6yB+4xzrofnfP
66D73T2vg+5397wOut/d8zro/LrnddD5dc/roOflntdBOu55HVH/kOc/cCfQ
3Ot1RP1Dnv/AnUDvXq8j6h/y/Afu5BbzD3n+A3cS9A95/gN3AmP3eh3R+39d
/XjZydSy1+uI3v/r6sfLTqY+e72O6Plenx+D6Plenx+D6POs8T52ovuoEgf7
izr+gyB/Ucd/EOQv6vgPgvxFHf9BnP3eUS8/BuQv6vgPos73jyjkL+r4D6LO
948oVB/q1o+ZOt8/olB9qFs/Zup8/4hC579+fgzqfP+IQvvsEgf7kz708R9E
H/9B9PEfRB//QfTxH0Qf/0H08R9E3/ox07d+zPStHzN968dM//wY9M+Pwf94
HzspcXwDHdtLmA==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzd0MEJgDAABMFoJ7ZkCQHf1mlXWsTgQgbufbDHvM+5jzGub8+3bRVjFXVI
pg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J
1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZ
OiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRT
h2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2Tq
kEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwd
kqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J/BLrj5MXiGsq4Q==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztz0ENgDAAwMCBEywhYQlvdOKKWeDXkLukAnrM+5z7GONaPavtJ/4y4qPF
R4uPFh8tPlp8tPho8dHio8VHi48WHy0+Wny0+Gjx0eKjxUeLjxYfLT5afLT4
aPHR4qPFR4uPFh8tPlp8tPho8dHio8VHi48WHy0+Wny0+Gjx0eKjxUeLjxYf
LT5afLT4aPHR4qPFxwcv/ABRvw==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 
      0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzN1duNEDAMRNG7dEJLW8JKfFMnXbGIDuJ5WfJnNI6Povz8+v359QP49d1/
vvtjrv4N9TAWY/X/Di8H14o3kDWRZ5A5ER5BxkTeQdZEeAXZEjmAjInwDDIl
cgHZEuEdZEnkBDIlwgFkSOQGsiTCBWRH5AgyJMIJZEbkCrIjwg1kReQMMiPC
EWRE5A6yIsIVZENEADIiwhlkQkQBsiHCHWRBRAIyIYIAZEBEA7IgggKkLyIC
GRBBAlIXUYH0RdCAtEVkIHURRCBlER1IWwQVSFdECFIWQQZSFVGCdEXQgTRF
pCBVEYQgRREtSFMEJUhPRAxSFEEKUhNRg/RE0IK0ROQgNRHEICURPUhLBDVI
R8QAUhJBDlIRcYB0RNCDNEQsIBURDCAFEQ9IQwQHSF7EBFIQwQISF3GB5EXw
gKRFbCBxEUwgYREfSFoEF0hWxAgSFsEGEhVxgmRF8IEkRawgURGMIEERL0hS
BCdITsQMEhTBChITcYPkRPCCpETsIDERzCAhET9ISgQ3SEYkABISwQ4SEUmA
ZETwgyREIiAREQIgAZEMSEKEBEhgUxmQgAgRkNCq/CmRN5IAyewqEJL5RxIh
fwGkaCsR
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      0}, {1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzdl1FOwzAQRAM34UocAYlvzsmtoEL+YCv6mu7MepcXRZFluWMnXk/n5e3j
9e35OI737/vz+z6efljPs/QZv65H6TN+3Y//UpfxmffRa3zudzqNP5JXFp3+
kbzzK1Hpr3U9+syvRKUf6+XsM4tOP+63s+0sOv243862s+j04/rOtrPo9P+q
m3vbWXT65A9q//Dpkz+o/cOnT/6g9g+fPvmD2j98+rT/XPWh16f956oPvT6t
1/k9tPr31pELnf79//896PTjee32D5++O3/U6d///9+DTt+dP+r03fmjTt+d
P+r03fmjTr/aP3z61f7h06/2D59+tX/49HfVh15/V33o9Xd+D63+3nUo9Skf
uC8dlA/ct3Ilt/OB+6lcyd6nDsoH7rYOygfuto74fqrbOigfuNs66Hx39+ug
893dr4POd3e/Djrf3f06aP+6+3XQ/nX366D35e7XQTrufh3Z/JAdryOe92fP
/+x4Hdn8UJc/eCa3n+7xOrL5oS5/8Exy+aEuf/BMcvmhLn/wTG633eN1ZM//
ff5xPZPc+b/PP65nkjv/9/nH9Ux+P6vH68ju7/31scju7/31sci+zx7f40J2
Hl3WwfmiT/4gKF/0yR8E5Ys++YOgfNEnfxCUL/rkD4LyRZ/8QVC+6JM/CMoX
ffIHQf7Q1z8i5A99/SNC/tDXPyLkD339I0L7v399LGj/96+PBb3vGd/jAs1z
yjo4n8xhTv4g5uQPYk7+IObkD2JO/iDm5A9iTv4g5vpHZK5/ROb6R2Suf0Tm
18difn0s/sf3uFCyji8t7005
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzN0dlNBEEQBNEBT3AJE1biGzvxipUQ4tpjpuplNSH1b2Uo+un0+nx63Lbt
5fzezu/hX1LQ2v4jFStfE1Cx4jUBJSleE1CS0jUBNSddE1BzwjUBRSVcE1BU
sjUBVSNbE1A1ojUBZSFaE1AWkjUBdR9ZE1D3gTUBDR1YE9DQcTUBHRtXE9Cx
YTUBLRlWE9CSUTUBPRdVE9BzQTUBTRVUE9BUMTUBXRNTE9A1ITUBbRFSE9AW
ETUBfQ9RE9D3ADUBQAPUBACNfgqAsOinAAgL0KINkQAt2hAJEaOJcRAxmhgH
UqOXEp1ZDlIwOTol1Z3VKAPUox6SHVoME1BBqh3dpbW4fVaklhGeWgqcd0kq
FeWtlch12OR4RHpsIXRcRjna0F5bh92mVY4lxOeWgadtliMF9b1V6GXcZX9A
fnARfFiH2dvPX1yD3+Vl9uULnFxCYNan2VMvcXMFidVAm/vxIkcXEBlNxLnX
LnN1nsxmpM7tdKGz44QmM3lulUvdnSa1GOpzPVzs8DCxwVSga91yl2fJ7cUK
Xc4WPD1KcC6X6FK15O1JkmvBRn+jRY8PEh1LRvrdLHt9juxWtNLPZOHzY4Sn
spm+F0vfnyK9FO70FSw+MER8KB3qs1d+YYb8TrzUR66BiREGZvKptpEPmfmR
iZWBViMfMvIjIyPvYVsq4Q==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzd0ckNwkAQBdFpMiElQrDEmTjJCp/B2LP0Wr/VATzVfXs9tltr7bn/e39x
WHM5BsTFQenhAHFyUHqYQ9wclB7GEEcHpYcpxNVB6WEIcXZQephB3B2UHkaQ
AAelhwkkxEHpYQAJclB6qEPCHJQeypBAB6WHKiTUQemhCAl2UHqoQcIdlB5K
kAQOSg8VSAoHpYcCJImD0mMZksZB6bEISeSg9FiCpHJQeixAkjkoPaYh6RyU
HpOQhA5KjylISgelxwQkqYPSYxiS1kHpMQhJ7KD0GIKkdlB6DECSOyg9uiHp
HZQenZACDkqPLkgJB6VHB6SIg9LjElLGQelxASnkoPQ4hZRyUHqcQIo5KD3+
Qso5KD3+QAo6KD0OISUdlB4HkKIOSo8fSFkHpYdQenwXKTxID6H0EEoPofQQ
Sg+h9BBKD6H0EEoPofQQSg/x6fEBglJHyQ==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztkbEJgEAAxF43cSVHeLB2TrfyV0hhCsnB1YHkmPc59zHGtf6sb8IcyPcz
GBVBrgRGRZArgVER5EpgVAS5EhgVQa4ERkWQK4FREeRKYFQEuRIYFUGuBEZF
kCuBURHkSmBUBLkSGBVBrgRGRZArgVER5EpgVAS5EhgVQa4ERkWQK4FREeRK
YFQEuRIYFUGuBEZFkCuBURHkSmBUBLkSGBVBrgRGRZArgVER5EpgVAS5EhgV
Qa4ERkWQK4FREeRKYFQEuRIYFUGuBEZFkCuBURHkSmBUBLkSGBVBrgRGRZAr
gVER5EpgVAS5EhgVQa4ERkWQK4FREeRKYFQEuRIYFUGuBEZFkCuBURHkSmBU
BLkSGBVBrgTGj4q8YVsq4Q==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 
      0}, {1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1}, {1,
       1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 
      1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzdl2uWrDYMhK3sJFvKEu45+Z11Zle5DKjqkxswM/0A4tMzzcPYqiqVRP/5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         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzd0MEJgDAABMFoJ7ZkCQHf1mlXWsTgQgbufbDHvM+5jzGub8+3bRVjFXVI
pg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J
1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZ
OiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRT
h2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2Tq
kEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwd
kqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J/BLrj5MXiGsq4Q==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzt3EENACAMALGBEywhYQlvdOKKiSC82uRs3Mg9s0fEqk7VAAAAAAAAAAAA
AAAAAAAAAAAAAOChL6O7C420UiM=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJy90MEJgEAQBMHVTEzJEA58G6dZeUl0Dcy7oK/13uucmWf/2z/ADNKPKX0s
gpBWRuljEYS0MkofiyCklVH6WAQhrYzSxyIIaWWUPhZBSCuj9LEIQloZpY9F
ENLKKH0sgpBWRuljEYS0MkofiyCklVH6WAQhrYzSxyIIaWWUPhZBSCuj9LEI
QloZpY9FENLKKH0sgpBWRuljEYS0MkofiyCklVH6WAQhrYzSxyIIaWWUPhZB
SCuj9LEIQloZpY9FENLKKH0sgpBWRuljEYS0MkofiyCklVH6WAQhrYzSxyII
aWWUPhZBSCuj9LEIQloZpY9FENLKKH0sgpBWRuljEYS0MkofiyCklVH6WAQh
rYzSxyIIaWWUPhZBSCuj9LEIQloZpY9FENLKKH0sgpBWRuljEYS0MkofiyCk
lVH6WAQhrYzSxyIIaWWUPhZBSCuj9LEIQloZpY9FENLKKH0sgpBWRuljCeQH
30YrRQ==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztz0ENgDAAwMCBEywhYQlvdOKKWeDXkLukAnrM+5z7GONaPaux/YWTHic9
Tnqc9DjpcdLjpMdJj5MeJz1Oepz0OOlx0uOkx0mPkx4nPU56nPQ46XHS46TH
SY+THic9Tnqc9DjpcdLjpMdJj5MeJz1Oepz0OOlx0uOkx0mPkx4nPU56nPQ4
6XHS46THSY+THiefvNSMUb8=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzNkdttAlEQxTbphJZSAlK+qTNdgYRQAuGxO8eewdL9nWP57vaHr/3nsizf
p/dzeh9vSUFreUcqWnxNgIoVnzOnZIXXBChJ4TlzalJ0TYCaE50zp+gE1wQo
KsE5c6pKbE2AqhGbM6dshNYEKAuhOXPqQmRNgLoPmTMn8AFrAgQ6YM6cRIer
CZDYcDlzIhusJkAkg+XMyWSomgCZC5UzJ3SBagKEKlDOnFSFqQmQmjA5c2IT
pCZALILkzMlFiJoAuQeRMwfwAGoCABpAzhxCI08BQFjkKXIQC6BFDCIBtEhh
JIgYIYwDESNNCZ2ZBlJAamQlqTvDUAZMjiQkdmgWTADqUe/IXRqF26eCVDOC
pyYB57EitYrkrUHIdS5JJSJ6bA50HGyyvSF7bQx2m4yyNSF8bgp4Gq2yrSB9
bwh6mc2yJSB+cAZ8GO6yvh9/cQR+lw6zNp9wcgJhFi+zrp5xcwBjlU+zJp5y
tB9lVGjzup1ztR1n04jzKp10thtpUqnzvJx1txlr0cnzLJx2uBdtUOrzuJt3
uRVvzwr0KJt4uhNxTit0v5p5uxFzzUt0L5p6vA91TGz0v5l7vQ13y4x0m0w+
34U8pVa6Lmbfb8JecjP9DaYP9KAPyZ1+e/kLLfg7dqhLroaJDhpm9FLnWh0b
DXSs+Kl6PqTlR1pGjht2KxM=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztzzENgEAABMEHJ1hCAgk1OnHFW6D5bDGTXH3Z43rOax9j3HPv3LbAkpMV
hNQIqRFSI6RGSI2QGiE1QmqE1AipEVIjpEZIjZAaITVCaoTUCKkRUiOkRkiN
kBohNUJqhNQIqRFSI6RGSI2QGiE1QmqE1AipEVIjpEZIjZAaITVCaoTUCKkR
UiOkRkiNkBohNUJqhNQI+eMD6EZRvw==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJy90MEJgEAQBMHVTEzJEA58G6dZeUl0Dcy7oK/13uucmWf/2z/6MSWeZPJW
RhGpEJO3MopIhZi8lVFEKsTkrYwiUiEmb2UUkQoxeSujiFSIyVsZRaRCTN7K
KCIVYvJWRhGpEJO3MopIhZi8lVFEKsTkrYwiUiEmb2UUkQoxeSujiFSIyVsZ
RaRCTN7KKCIVYvJWRhGpEJO3MopIhZi8lVFEKsTkrYwiUiEmb2UUkQoxeSuj
iFSIyVsZRaRCTN7KKCIVYvJWRhGpEJO3MopIhZi8lVFEKsTkrYwiUiEmb2UU
kQoxeSujiFSIyVsZRaRCTN7KKCIVYvJWRhGpEJO3MopIhZi8lVFEKsTkrYwi
UiEmb2UUkQoxeSujiFSIyVsZRaRCTN7KKCIVYvJWRhGpEJO3MopIhZi8lVFE
KsTkrYwiUiEmb2UUkQoxeSujiFSIyVsZRaRCTN7KKCIVYvJWRslbDVFELIH8
jTgrQg==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzt0cEJgDAABMFoJ7ZkCYJv67Qr04K/JczAFXDscT3ntY8x7rl3bmyrWOfK
Mkc0CdKkR5MeTXo06dGkR5MeTXo06dGkR5MeTXo06dGkR5MeTXo06dGkR5Me
TXo06dGkR5MeTXo06dGkR5MeTXo06dGkR5MeTXo06dGkR5MeTXo06dGkR5Me
TXo06dGkR5MeTXo06dGkR5MeTXo0+eUDC/NRjQ==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzN0dtNQ0EQBFGbTEiJECzxTZxkhSWEePlx78zpWZe0v9Ol2ufT28vp6XA4
vJ7f+/kdH5KC1uEhKWj5moCKla8JqFjxmoCSFK8JKEnpmoCak64JqDnhmoCi
Eq4JKCrZmoCqka0JqBrRmoCyEK0JKAvJmoC6j6wJqPvAmoCGDqwJaOi4moCO
jasJ6NiwmoCWDKsJaMmomoCei6oJ6LmgmoCmCqoJaKqYmoCuiakJ6JqQmoC2
CKkJaIuImoC+h6gJ6HuAmgCgAWoCgEY/BUBY9FMAhAVo0YZIgBZtiISI0cQ4
iBhNjAOp0UuJziwHKZgcnZLqzmqUAepRD8kOLYYJqCDVju7SWtw+K1LLCE8t
Bc67JJWK8tZK5Dpssj8iPbYQOi6j7G1or63DbtMq+xLic8vA0zbLnoL63ir0
Mu6yPSA/uAg+rMNs7ecvrsHv8jLb8gVOLiEw69NsqZe4uYLEaqDN/XiRowuI
jCbi3GuXuTpPZjNS53a60NlxQpOZPLfKpe5Ok1oM9bkeLnZ4mNhgKtC1brnL
s+T2YoUuZwueHiU4l0t0qVry9iTJtWCj/9GixweJjiUj/W2WvT5Hdita6Xey
8PkxwlPZTD+Lpe9PkV4Kd/oOFh8YIj6UDvXVK78wQ34nXuoz18DECAMz+VTH
kQ+Z+ZGJlYFWIx9y/ABhKSrh
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzt3EENACAMALGBEywhYQlvdOKKiSC82uRs3Mg9s0fEqk7VAAAAAAAAAAAA
AAAAAAAAAAAAAOChL6O7C420UiM=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
      0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
      0, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzdm0tuwzAMRO3epFfqEQJ03XP2Vg1INE3qTyTNDEnlodnEEjV+yKTZ+P3y
9XF5W5bl8/r6vr7WF2F5Aa53YX/zs9idzM9qd5Ftk4HdRLZOkPX2qcq2ibL8
1jzZKMrfHaTqJHC7gVSfGOvDt26mTZTl/t9golGUx/RpOgk8hE/zibFufpVk
2URZ/v9MTDKKsk2eopPAJniKT4xtP/zd+dj0w96cj/3U4ToJ7IYO94mx3w+/
Mhe7/bALc3GcOFQngcPAoT4xjvvhV+fhsB92cR7O04bpJHAaNswnxnk/fMUc
nPbDFszB86QhOgk8DRriE+N5P3xVfZ72wxbVpy2lXCeBppBynxht/fCVtWnq
hy2sTXtCqU4CzQGlPjHa++Gr69LcD1tcl750Mp0EusLJfGL09cN31KSrH7ah
Jv3JJDoJdAeT+MTo74fvqkd3P2xTPcZS0XUSGApF94kx1g/fWYuhftjGWown
ouokMByI6hNjvB++uw7D/bDNdcDS0HQSgMLQfGJg/fAJNYD6YQNqgCeh6CQA
B6H4xMD74VPygfthQ/LhpMBV4FBCEFxgHllPFTFkQCJZj3lRbEAeeZNSoQUg
+RhzyHzqjiVkSCLzMUiakSGH3GlpUA8nOunzx+yHT8yB2g8bmAP/ZK6WDoH0
gfHw++FT46H3w4bGozmVr6ZBnmRoLJp++ORYJP2wwbHoTtToOREnGxyHrh8+
PQ5ZP2x4HNrTdIp2pEmHx6Dth58Qg7QfdkAM+pO0mu6EyQ/Qo++Hn6JH3g87
RE/YKXpZEYf8AOBZK0U=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztz0ENgDAAwMCBEywhYQlvdOKKWeDXkLukAnrM+5z7GONaPaux/YWTHic9
Tnqc9DjpcdLjpMdJj5MeJz1Oepz0OOlx0uOkx0mPkx4nPU56nPQ46XHS46TH
SY+THic9Tnqc9DjpcdLjpMdJj5MeJz1Oepz0OOlx0uOkx0mPkx4nPU56nPQ4
6XHS46THSY+THiefvNSMUb8=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzdkVtOw0AQBA034UocIRLfnJNbYQUIcfza3erukVKSf6dry2+Xz/fL6zRN
H/P3NX8vz8H0JMwvqU4p4fqSJ+D6iuqYAn4eUV2T8/uG6pyYvycU58TcXlCb
E/P/gNKcmDv/ypyYe/3CnJiFfV1OzFK+LCfmwb0qJ+ZRvSgnZmVekxOzFi/J
idnwrsiJ2dIuyInZtM7nxGxLx3NidpzTOTF7yuGcmF3jbE7MvnA0J+bAN5kT
c6QbzIk5tM3lxBzLxnJiTlxTOTFnqqGcmFPTTE7MuWgkJ6bBM5ET06IZyIlp
svTnxLRJ2nNiGh3dOTGtiuacmGZDb05Mu6A1J6bDz5kT06NnzInpsvPlxPTJ
2XJiOt1cOTG9aqacmG4zT05Mv5glJ2bAy5ETM6JlyIkZstLnxIxJyXNiBp3U
OTGjSuKcmGEjbU7MuJA0Jwb4KHNiiI4wJwbZ6HJimIwsJwa6qHJiqIooJwab
aHJiuIgkJ0bgociJUWgIcmIkFjwFRiMhaIFTis4Uo1KQ1EAhZYdK0QmIegxn
FJ4qRDkvKzIUUXqsDO24sEl3QvG5ItTT0ipdAeUHS9APi7s05zOcLMAxKy/T
FM9yNI5n1NDmNJ3pbBjXpKXOYTjb4Si+QVOf3WzG00Gcc7ZCm9Gsx2N4x4yN
VsnM50O4p6yVFsHsAxH8Q+ZOt1yBiQCJGXupKfI/Mn8kMvINOksq4Q==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztzzENgEAABMEHJ1hCAgk1OnHFW6D5bDGTXH3Z43rOax9j3HPv3LbAkpMV
hNQIqRFSI6RGSI2QGiE1QmqE1AipEVIjpEZIjZAaITVCaoTUCKkRUiOkRkiN
kBohNUJqhNQIqRFSI6RGSI2QGiE1QmqE1AipEVIjpEZIjZAaITVCaoTUCKkR
UiOkRkiNkBohNUJqhNQI+eMD6EZRvw==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 
      0}, {0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 0}, {1,
       1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 
      0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJy9WVF220gMI/cme6Ueoe/td8+5t2peJALgSLZnNGTYJk5sSSQBEpDaf3//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         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztz8EJgEAAA8HTTmzJEg58W6ddqU3IIDuQd9htnvtcxxjHs2u8lp+oxFOJ
pxJPJZ5KPJV4KvFU4qnEU4mnEk8lnko8lXgq8VTiqcRTiacSTyWeSjyVeCrx
VOKpxFOJpxJPJZ5KPJV4KvFU4qnEU4mnEk8lnko8lXgq8VTiqcRTiacSTyWe
SjyVeCrxVOKpxPOjki9ObhvXUVs=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzdkFtOAzEQBBduwpU4QiS+OSe3IlogZJN92K7uHmlL8u90ud4un++X12ma
Pq7v6/pezsF0Eq4/qU4pYf7JCZh/UR1TwM8nqmtyfv9QnRPz94XinJjbD2pz
Yv4/UJoTc+dfmRNzr1+YE7Owr8uJWcqX5cQ8uFflxDyqF+XEPJnX5MQ8i5fk
xKx4V+TErGkX5MSsWudzYtal4zkxG87pnJgt5XBOzKZxNidmWziaE7Pjm8yJ
2dMN5sTs2uZyYvZlYzkxB66pnJgj1VBOzKFpJifmWDSSE9PgmciJadEM5MQ0
WfpzYtok7TkxjY7unJhWRXNOTLOhNyemXdCaE9Ph58yJ6dEz5sR02flyYvrk
bDkxnW6unJheNVNOTLeZJyemX8ySEzPg5ciJGdEy5MQMWelzYsak5Dkxg07q
nJhRJXFOzLCRNidmXEiaEwN8lDkxREeYE4NsdDkxTEaWEwNdVDkxVEWUE4NN
NDkxXESSEyPwUOTEKDQEOTESC54Co5EQtMApRWeKUSlIaqCQskOl6AREPYYz
Ck8VopyXFRmKKD1WhnZc2KQ7ofhcEeppaZWugPKDJeiHxV2a8xlOFuCYlZdp
imc5GsczamhzmM50Noxr0lJnN5ztcBTfoKnPZjbj6SDOOVuh1WjW4zG8Y8ZG
T8nM50O4p6yVFsHsAxH8Q+ZOt1yBiQCJGXupuVZiI0Bk5Bs5HSrg
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztz0ENgDAAwMCBEywhYQlvdOKKWeDXkLukAnrM+5z7GONaPavtJ/4y4qPF
R4uPFh8tPlp8tPho8dHio8VHi48WHy0+Wny0+Gjx0eKjxUeLjxYfLT5afLT4
aPHR4qPFR4uPFh8tPlp8tPho8dHio8VHi48WHy0+Wny0+Gjx0eKjxUeLjxYf
LT5afLT4aPHR4qPFxwcv/ABRvw==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJy90dtNA0EQBdGFTEiJECzxTZxkhYUsC9v7mu5z50r+dNV07cfl+/PyvizL
1/X3c/29Da/wlxlbhlf5z4RVbuc1xUq385xgpeN1TbHa8TonWO16XFOseD3O
CVY839YUq55vc4JV76c1xcr305xg5QCyplg9gMwJVi8Aa4o1CsCcYI0ErqZY
J4HLCdZpwGqKtRqwnGCtCKqmWC+CygnWq4BqijUroJxgzQymplg3g8kJ1u1A
aoq1O5CcYO0QoqZYP4TICdYvAWqKgRIgJxhI0UeIiRR9BphoARj9kRYA0h6J
ISDdmRiC0pypQSi9oRoE03wDyWEwrSegHIbTeoLpgTiNF6geCNR4AQqiQOUH
sCCKVH6AKsJIRb8rwlBFP0viUCU9TOJYJb1rAlkFu2wCYQU7jCJhw3IaRdKG
5bIKpQ26bRWKG3TTLBY3pMZZLG9Ibbtg3oBZd8HAATMOo4GnxTyMJp4W6zKc
eNLry3DkSS9P45GntIE0nnlK69sEmCesiTYB6AlrIE4CeiiNxElQD6WJOhHq
gTNTJ4I9cEbyZLC7ylCeDHdXmekT4u4YU31C4B1jKFAKvCmMBUqRN4WpQjHy
hi9XKIbe8MUS5dCrumCiHHtVl2sUZK/Yko2C8BVbMFIS/iKLRkrSX2TJSlH6
kytbKYp/ckUzZfEPqnCmLP9Ble0U5v8zpTuFBf9M4VBpwV0UD5U23EXpUnHD
zZMvFVfcPPFUecWfZkKqvGOZ8UUmfZIprSZIptSaIvkFJQgrEw==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0}, {1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1}, {1,
       1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1}, {1, 1, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztz8sNwlAMRNGYTmiJEpBYUyddkXUE5DfPY19xLe/nXO/P2/0yTdNj/tf8
U/yv1oV9gcrBkAREEhBJQCQBkQREssy9R+XoKvmUe5PK0VHyLfculaOb5Ffu
bSpHJ8la7n0qRxfJltwbVY4Okq25d6oc1SV7cm9VOSpL9ubeq3JUlRzJvVnl
qCg5mnu3ylFNcib3dpWjkuRs7v0qRxWJIrdB5aggUUVxuCXKKA6nRB3F4ZKM
iOJwSEZFcWRLRkZxZEpGR3FkSTKiODIkWVEcoyWZURwjJdlRHKMkjiiOERJX
FIda4oziUErcURwqSYUoDoWkShTHWUmlKI4zkmpRHEclFaM4jkiqRnHslVSO
4tgjqR7FsVXSIYpji6RLFMeapFMUxy9JtyiOb5KOURyfJF2jOJaSzlEcgXEE
xhEYR2AckeN4AykLPgU=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJy90MEJACAQA8FoJ7ZkCQe+rdOuvComkPfArrq7ZpLTf/0BZhAwg4hYBBGx
CCJiEUTEIoiIRRARiyAiFkFELIKIWAQRsQgiYhFExCKIiEUQEYsgIhZBRCyC
iFgEEbEIImIRRMQiiIhFEBGLICIWQUQsgohYBBGxCCJiEUTEIoiIRRARiyAi
FkFELIKIWAQRsQgiYhFExCKIiEUQEYsgIhZBRCyCiFgEEbEIImIRRMQiiIhF
EBGLICIWQUQsgohYBBGxCCJiEUTEIoiIRRARiyAiFkFELIKIWAQRsQgiYhFE
xCKIiEUQEYsgIhZBRCyCiFgEEbEIImIRRMQiiIhFEBGLICIWQUQsgohYBBGx
CCJiEUTEIoiIRRARiyAiFkFELIKIWAQRsQgiYhFExCKIiEUQEYsgIhZBRCyC
iFgEEbEIImIRRMQiiIhFEBGLICIWQUQsgohYBBGxCCJiCeQDYSkq4Q==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzt0cEJgDAABMFoJ7ZkCYJv67Qr04K/JczCFXDMcT3ntY8x7rl3blukRY4s
A7LIDx6teLTi0YpHKx6teLTi0YpHKx6teLTi0YpHKx6teLTi0YpHKx6teLTi
0YpHKx6teLTi0YpHKx6teLTi0YpHKx6teLTi0YpHKx6teLTi0YpHKx6teLTi
0YpHKx6teLTi0YpHKx6teLTi0YpHKx5/+gBGi1GN
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJy90dttAkEQBVHsTJySQ0Dyt+N0VkYIIR77mOk+d6/EJ1XTtV/n3+/z5+l0
+rn8/i6/j+kV/nLETtMr/OWIVW7nNcUqt/OaYqXjdU2x0vG6pljtelxTrHY9
rilWPN/WFCueb2uKVe+nNcWq99OaYuUAsqZYOYCsKVYvAGuK1QvAmmKNBK6m
WCOBqynWacBqinUasJpirQiqplgrgqop1quAaor1KqCaYs0MpqZYM4OpKdbt
QGqKdTuQmmLtEKKmWDuEqCnWLwFqivVLgJpiIEUfIQZS9BFiogVg9CdaAEZ/
JIaAdEdiCEh3pgah9GZqEEpvKIfBtJ5gchhM6wmoB+I0XoB6IE7jBSqIApUf
oIIoUPkBrAgjFf2sCCMV/S6JQ5X0LolDlfSwCWQV7LAJZBXsMoqETctlFAmb
ltMqlDbpplUobdJts1jclNpmsbgpNe6CeRNm3AXzJsw6jAYOi3UYDRwW8zKc
OOjlZThx0OvTeOSQ1qfxyCFtoE2AOWANtAkwB6yJOAnorjQRJwHdlUbqRKg7
zkidCHXHmcmTwW4qM3ky2E1lqE+Iu2EM9QlxN4ypQCnwqjAVKAVeFcYKxcgr
vlihGHnFl0uUQy/qcoly6EVdsFGQvWALNgqyF2zJSEn4mywZKQl/k0UrRekv
rmilKP3Flc2UxT+pspmy+CdVuFOY/2AKdwrzH0zpUGnBXZQOlRbcRfFSccPN
Ey8VN9w8+VR5xVWTT5VXXDUHtDrAccQXOeiTHBLrCMk/YSkq4Q==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 
      0}, {1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1}, {1,
       1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzd0ctNBFEMRNE2mZASIYzEmjjJiilvEBo+jdrP5Xev5ADK5/n29nJ7Oo7j
9X7v9zsignHaQjj3H+su7L+s8YgBv6zxIJh85v5njcfuJl9z/7TGY2eTx9x/
rfHY1eT73L+t8djR5Ofc/63x2M3k99w/rvHYyeTv3H+u8djF5FzuX9d47GBy
Pve/azymm/wv989rPHLJgN9f94gBf6/xyCUD/n/dI5r+u94jlwwwuO4RRT/0
e+SSAQ7XPeLkn+Z75JIBFtc9IvwONR65BOGRSwZc0RKERy4xX+EShEcuMV7x
EoRHLjHdgiUIj1xiuEVLEB65pPkWLkF45JLGW7wE4ZFLmq5hCcIjlzRc0xKE
Ry5ZfH0xPHLJwuuN4ZFLFl1/DI9csuA8MTxySfH5YnjkksLzxvBQDA/F8FAM
D8XwUAwPxfBQDA/F8FAMD8XwUAwPxfBQDA/F8FAMD8XwUAwPxfBQDA/F8FAM
D8XwUAwPxfBQDA/F8FAMD8XwUAwPxfBQDA/F8FAMD8XwUC07PgASWj4F
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzd0MEJgDAABMFoJ7ZkCQHf1mlXWsTgQgbufbDHvM+5jzGub8+3bRVjFXVI
pg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J
1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZ
OiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRT
h2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2Tq
kEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwd
kqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J/BLrj5MXiGsq4Q==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztz0ENgDAAwMCBEywhYQlvdOKKWeDXkLukAnrM+5z7GONaPavtJ/4y4qPF
R4uPFh8tPlp8tPho8dHio8VHi48WHy0+Wny0+Gjx0eKjxUeLjxYfLT5afLT4
aPHR4qPFR4uPFh8tPlp8tPho8dHio8VHi48WHy0+Wny0+Gjx0eKjxUeLjxYf
LT5afLT4aPHR4qPFxwcv/ABRvw==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzFktlNxFAUxRI6oSVKGIlv6qQrRiBglixvsc+Nkm/f+Pj18vF2eVmW5f36
fV6/tftZBt6l++0/q/sZ+ZX+Pxk4KzBJYJCxf/fTiiwSSCuzSCCt0CJ6WqlF
9LRii8hp5RaR0wouoqaVXERNK7qImFZ2ETGt8CJaWulFtLTii0hp5ReR0ipY
REmrYhElrZJFhLRqFhHSKloET6tqETytskXgtOoWgdMqXARNq3IRNK3SRcC0
ahcB0ypeBEurehEsrfJFoLTqF4HSAs6YdwGkBVxBuJhPi7gCkDGdFnEEImM2
LeQIwsZkWsgNjI25tJgbEB1TaTEnQDpm0oJOYHxMpAVdQPkYT4u6ABIynBZ1
ACZkNC3sAMrIYFoYnzMylhbHx5QMpcXhQSUjaYF4zslAWiCddNKfFkkHpXSn
RcJRKb1poXDSSmdaKJu10pcWy0a1dKXFomEtPWnBaNZLR1owmfbSnhZNhsU0
p0WDcTGtaeFg2kxjWjiXN9OWFs/F1TSlxWMFNS1pCVjeTUNaAtVwc56WQRXk
nKZlQBU5Z2kpUMPOSVoK07FznJbDVPQcpuUgJT1HaUlIx89BWhLR8rOflkWU
BO2mZQE1QXtpaUDL0E5aGs8ztJ2Wx9MUbabl4URFW2mJOM/RRloizXT0nJZJ
EyU9pWXCVEmPaakw09JDWirLtXSflstSNd2l5aJkTbdpySjX001aMsn29J+W
TZJF/aVlg3RRv2npINvUGhkkYeonLZ+jq1oTg0RUJQYJqPpOK0BJuApAEq4i
g6xfsxYq4Q==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0}, {1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1}, {1,
       1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1}, {1, 1, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJztz8sNwlAMRNGYTmiJEpBYUyddkXUE5DfPY19xLe/nXO/P2/0yTdNj/tf8
U/yv1oV9gcrBkAREEhBJQCQBkQREssy9R+XoKvmUe5PK0VHyLfculaOb5Ffu
bSpHJ8la7n0qRxfJltwbVY4Okq25d6oc1SV7cm9VOSpL9ubeq3JUlRzJvVnl
qCg5mnu3ylFNcib3dpWjkuRs7v0qRxWJIrdB5aggUUVxuCXKKA6nRB3F4ZKM
iOJwSEZFcWRLRkZxZEpGR3FkSTKiODIkWVEcoyWZURwjJdlRHKMkjiiOERJX
FIda4oziUErcURwqSYUoDoWkShTHWUmlKI4zkmpRHEclFaM4jkiqRnHslVSO
4tgjqR7FsVXSIYpji6RLFMeapFMUxy9JtyiOb5KOURyfJF2jOJaSzlEcgXEE
xhEYR2AckeN4AykLPgU=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzNkdlNBEEUxAYyISVCWIlv4iQrVkKIa4+ZV3Y1lvr3leV+Or0+nx63bXs5
v7fze/iPTLS2/8jEis+ZM7LCawKMpPCcOTMpuibAzInOmTN0gmsCDJXgnDlT
JbYmwNSIzZkzNkJrAoyF0Jw5cyGyJsDch8yZE/iANQECHTBnTqLD1QRIbLic
OZENVhMgksFy5mQyVE2AzIXKmRO6QDUBQhUoZ06qwtQESE2YnDmxCVITIBZB
cubkIkRNgNyDyJkDeAA1AQANIGcOoZGnACAs8hQ5iAXQIgaRAFqkMBJEjBDG
gYiRpoTOrAZSQGpkJak7i6EMmBxJSOzQWjABqMe8I3dpKdw+FWSaETy1EnAe
KzKrSN5aCLnOJZlERI+tAx0HmxxvyF5bBrtNRjmaED63CngarXKsIH1vEfQy
m+VIQPzgGvBhuMv+fvzFJfC7dJi9+YSTKxBm8TL76hk3F2Cs8mn2xFOO9lFG
hTb32zlX6zibRpx76aSzbaRJpc7tctbdMtaik+dWOO1wF21Q6nO9m3e5irdn
BbqWTTzdRJzTCl2uZt4uYq55iS5FU4/3UMfERn+buddruFtmpN/J5PMt5Cm1
0s9i9v0S9pKb6XswfaCDPiR3+urlL1Twd+xQn7kKEw0KM3qpj1qNjQKNFT9V
50MqP9IZacRqjLwDf8wqrw==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzdmVFqAzEMRN3epFfqEQL9zjl7q8ZQ52OW7VRIXs3kBWOWRURxZIlhPm73
z9v7GOPrsb4f6+0Cxu/qel/GIAe2+30Zg5zX7vdlsPPa/b4M9j2735cxCLvj
yxjkszu+jHlmf63d8WUMsnbHl7Hq+GzfHV/GquOzfXd8Gevczvbd8WUMsu+O
LwP7fbT/Z+PLwH4f7f/Z+DKw30f7fza+DOz30f6fjS8D6zla39n4MrCeo/Wd
jS8Dzy96ntn4MvB7o3lk48vI6oc2/XFIJKkf2vTHIZGkfmjTH4dEYF0dX0ZW
P7Tpj0MiSf3Qpj8OiST1Q5v+QLL6oU1/INn+3z4/nokk+3/7/Hgmkuz/7fNj
ke3/7fNjka1vifsxyda3xP2YZM9T5P/I17fK76D+BqM7/yfM35DxPxjM35Dx
PxioJ6JLBtQT0V0G5m/I+B8M5m/I+B8M1BPRXQacB9FnGZi/IeN/MJi/IeN/
MHAeRJ9lwHqPPsvA/A0Z/4PB/A0Z/4OBeUWfZWD6QlZ/IExfyOoPhOkLWf2B
MH0hqz8Qpi9k9QfC9IWs/kCYvpDVHwjTF7L6A2HzQX5+LNh8kJ8fCzYf5OfH
gs0H+fmxYPVvcT8mrP4t7seEnbfJ/8Hr3+V3UH+kO79/Y+N/MGz8DwbqDRv9
gdj4Hwwb/4Nh438wUG/Y6A/Exv9g2PgfDBv/g2HjfzBs/A+Gjf/BsPE/GDb+
B8NWfyC2+gOx1R+Irf5AbPUHYqs/EFv9gdjqD8R+fizs58fCfn4s7OfH4iXu
x+Ql7sfkRf6Pi+7HD8KOTTk=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzN0sFtAzEQQ1HFnaSllGDA59SZrrJ2BztDflLAHgWB/+338/fn+TjnvK7v
7/q+bp/zvjW4Zz7n9vmMuH/NfYbb+0gm2ytJpuPrSEbjG0nG69tIZusLSebz
y0iG8/tIFvu7SKb760g2AapIxgHaSFYFmkjmBcpIdgmKSBYJukiWDXpINg2q
SLYRakhWEZpI1hVaSHYVikj2GUpIlhl6SAQdOki2HWpIFCEqSNYhWkgkJRpI
9iVKSDQpCkgEKTpIRC3yJIoWFSSqGHESSYwGElmNNImmRgGJLkeYRJQjTyLs
kSVR9YiTKINESWRB0iTSIkkSXZEwiTZJkESYJEsibpIjUTaJkqijxEikUZIk
8iopEm2VIIk+S4hEnCVHYuiSIVF3iZE4wkRI5GFSJJYyCRJ9mRCJJ02AxJAm
Q2Jqw5M42kRIXHFwEkucBImtDk3iqRMg8eWBSUx5eBJjH5bE1QcncQZCSWyB
aBJrIZLEVwgm8SYCSYyJWBJzI47E2QglcUfCSKyRSBJ7JYrEWwkk8WeCSMyZ
OBKgE0Pi7oSREKEQEnsoigQpRZD4S0EkTCr/K0Cri8T/CNQKeAT5e4E3oFjE
I/8A1yqu
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 
      0}, {1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1}, {1,
       1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 
      0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzd01FOw0AMBNAsN+FKHKES35yTW8GqbAtN0mTtGXvMKFXz1z555vXy8XZ5
WZbl/fvzufS0gKe16y8R3yMYdMTy88V/2Ij+FiIhV+vqiJCQr9JalIR8lRYm
4e8jSEK8yl8HW0K8SnsMVRKyjwgJC7HloEpIV9l2MCVR+6BLSFfZD0vCQDxz
0CSB++BKCFc5cJAkjGqlSGL3QZSAr3LOwZCAr3LSQZCE74MlQSJmHHAJ8Cpz
DrQkYx8UCbJaqRIUwuKASpL2gZeArmJ0ACWoaqVL8vYBlgCu4nOgJICrOB0g
Seo+kBIvAuGASJxXwTgQkux9wCTeaslI8vcBkgjsAyNR2AdEIrEPhERjHwCJ
yD78EpV9uCUy+/BKdPbhlAjtwydR2odLIrUPj0RrHw6J2D7sErV9mCVy+7BK
9PZhlAjuwyZR3IdJIrkPi0RzHwaJ6D7mJar7mJbI7mNWoruPSYnwPuYkyvsY
gVUrPYBqCdyjx18tDccZifo+RtzVkomjWkL36LFXS8txJKmwjxFzteRiqJbg
PXrmq6XpeCapso+R6WrJZqJawvfoOV8tbceepNI+Rk5XSz4nqlXgHj3H1arh
2JJU28fIYbXK5Em1Ct2jZ79atRyPkor7GNmtVrlsVKvgPXrW1arpaOtqZf8h
c1bVKptf1Sp8j557tWo72r1a2X/EnVu1yqf+Pkb+xz16QhxfaZI5Ag==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzd0MEJgDAABMFoJ7ZkCQHf1mlXWsTgQgbufbDHvM+5jzGub8+3bRVjFXVI
pg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J
1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZ
OiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRT
h2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2Tq
kEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J1CGZOiRTh2TqkEwd
kqlDMnVIpg7J1CGZOiRTh2TqkEwdkqlDMnVIpg7J/BLrj5MXiGsq4Q==
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True],
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[
       Graphics[
        Raster[CompressedData["
1:eJzt3EENACAMALGBEywhYQlvdOKKiSC82uRs3Mg9s0fEqk7VAAAAAAAAAAAA
AAAAAAAAAAAAAOChL6O7C420UiM=
         "], {{0, 0}, {201, 101}}, {0, 1}], Frame -> Automatic, 
        FrameLabel -> {None, None}, 
        FrameTicks -> {{None, None}, {None, None}}, PlotRangeClipping -> 
        True]]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"]}], "}"}]], "Output",
 ImageSize->{497, 247},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12659831]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 " must be clicked to be activated:"
}], "ExampleText",
 CellID->188323707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupWindow", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "\"\<Label\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418309732],

Cell[BoxData[
 ButtonBox[
  RowBox[{"x", "+", "y"}],
  Appearance->None,
  BaseStyle->{},
  ButtonFrame->None,
  ButtonFunction:>CreateDocument[
    Internal`PopupWindowNotebook["Label"]],
  DefaultBaseStyle->{},
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92134282]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->131238384],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " presents the label in a popup box:"
}], "ExampleText",
 CellID->96543143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tooltip", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "\"\<Label\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->477464077],

Cell[BoxData[
 TagBox[
  TooltipBox[
   RowBox[{"x", "+", "y"}],
   "\"Label\""],
  Annotation[#, "Label", "Tooltip"]& ]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165571090]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hyperlink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hyperlink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDocument",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDocument"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MouseAnnotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MouseAnnotation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupMenu"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->320813193],

Cell[TextData[ButtonBox["Dynamic Graphics Elements",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicGraphicsElements"]], "MoreAbout",
 CellID->89514147],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->15983872],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->52661055],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->75742166],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->259797875],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->717877090],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->34665837],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->274362167]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PopupWindow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 15.4508816}", "context" -> "System`", 
    "keywords" -> {
     "information drilldown", "popup dialog", "popup input", "popup display", 
      "popup label"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PopupWindow[expr, contents] displays as expr, but pops up a window \
containing contents when clicked.", "synonyms" -> {"popup window"}, "title" -> 
    "PopupWindow", "type" -> "Symbol", "uri" -> "ref/PopupWindow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8947, 262, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->45208305]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 160303, 3774}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3840, 85, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4463, 112, 1576, 37, 70, "ObjectNameGrid"],
Cell[6042, 151, 735, 23, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6814, 179, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7292, 196, 208, 7, 70, "Notes",
 CellID->1067943069],
Cell[7503, 205, 701, 26, 70, "Notes",
 CellID->163383501],
Cell[8207, 233, 487, 15, 70, "Notes",
 CellID->596524930],
Cell[8697, 250, 213, 7, 70, "Notes",
 CellID->412560981]
}, Closed]],
Cell[CellGroupData[{
Cell[8947, 262, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->45208305],
Cell[CellGroupData[{
Cell[9331, 276, 148, 5, 70, "ExampleSection",
 CellID->337159498],
Cell[9482, 283, 88, 1, 70, "ExampleText",
 CellID->125941982],
Cell[CellGroupData[{
Cell[9595, 288, 275, 9, 28, "Input",
 CellID->69134423],
Cell[9873, 299, 425, 16, 71, "Output",
 CellID->217215272]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10347, 321, 220, 7, 70, "ExampleSection",
 CellID->889586732],
Cell[10570, 330, 209, 8, 70, "ExampleText",
 CellID->372249084],
Cell[CellGroupData[{
Cell[10804, 342, 555, 18, 70, "Input",
 CellID->124735531],
Cell[11362, 362, 1345, 26, 70, "Output",
 Evaluatable->False,
 CellID->98268494]
}, Open  ]],
Cell[12722, 391, 66, 1, 70, "ExampleText",
 CellID->295257080],
Cell[CellGroupData[{
Cell[12813, 396, 337, 10, 70, "Input",
 CellID->16899101],
Cell[13153, 408, 448, 16, 70, "Output",
 CellID->106679119]
}, Open  ]],
Cell[13616, 427, 388, 13, 70, "ExampleText",
 CellID->31592091],
Cell[CellGroupData[{
Cell[14029, 444, 334, 10, 70, "Input",
 CellID->328411194],
Cell[14366, 456, 450, 16, 70, "Output",
 CellID->386955454]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14865, 478, 222, 7, 70, "ExampleSection",
 CellID->218040998],
Cell[CellGroupData[{
Cell[15112, 489, 231, 7, 70, "ExampleSubsection",
 CellID->138825359],
Cell[15346, 498, 218, 8, 70, "ExampleText",
 CellID->643405886],
Cell[CellGroupData[{
Cell[15589, 510, 204, 5, 70, "Input",
 CellID->132541782],
Cell[15796, 517, 431, 15, 70, "Output",
 CellID->760639781]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16276, 538, 229, 7, 70, "ExampleSubsection",
 CellID->155543905],
Cell[16508, 547, 212, 8, 70, "ExampleText",
 CellID->415203308],
Cell[CellGroupData[{
Cell[16745, 559, 203, 5, 70, "Input",
 CellID->703394645],
Cell[16951, 566, 408, 14, 70, "Output",
 CellID->514181452]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17408, 586, 235, 7, 70, "ExampleSubsection",
 CellID->265875914],
Cell[17646, 595, 221, 8, 70, "ExampleText",
 CellID->36867834],
Cell[CellGroupData[{
Cell[17892, 607, 207, 5, 70, "Input",
 CellID->12988127],
Cell[18102, 614, 413, 14, 70, "Output",
 CellID->132151644]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18564, 634, 233, 7, 70, "ExampleSubsection",
 CellID->77465025],
Cell[18800, 643, 204, 8, 70, "ExampleText",
 CellID->50659202],
Cell[CellGroupData[{
Cell[19029, 655, 208, 5, 70, "Input",
 CellID->149804008],
Cell[19240, 662, 413, 14, 70, "Output",
 CellID->129381977]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19702, 682, 234, 7, 70, "ExampleSubsection",
 CellID->223392316],
Cell[19939, 691, 210, 8, 70, "ExampleText",
 CellID->615134415],
Cell[CellGroupData[{
Cell[20174, 703, 205, 5, 70, "Input",
 CellID->633449304],
Cell[20382, 710, 411, 14, 70, "Output",
 CellID->105692328]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20842, 730, 231, 7, 70, "ExampleSubsection",
 CellID->302249855],
Cell[21076, 739, 213, 8, 70, "ExampleText",
 CellID->136982735],
Cell[CellGroupData[{
Cell[21314, 751, 255, 7, 70, "Input",
 CellID->429725255],
Cell[21572, 760, 413, 14, 70, "Output",
 CellID->12343986]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22034, 780, 232, 7, 70, "ExampleSubsection",
 CellID->338291436],
Cell[22269, 789, 208, 8, 70, "ExampleText",
 CellID->453937264],
Cell[CellGroupData[{
Cell[22502, 801, 217, 5, 70, "Input",
 CellID->517551301],
Cell[22722, 808, 416, 14, 70, "Output",
 CellID->107985195]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[23199, 829, 224, 7, 70, "ExampleSection",
 CellID->129419],
Cell[23426, 838, 93, 1, 70, "ExampleText",
 CellID->350030151],
Cell[CellGroupData[{
Cell[23544, 843, 869, 26, 70, "Input",
 CellID->60735240],
Cell[24416, 871, 128554, 2637, 70, "Output",
 CellID->12659831]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[153019, 3514, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[153260, 3523, 216, 7, 70, "ExampleText",
 CellID->188323707],
Cell[CellGroupData[{
Cell[153501, 3534, 166, 5, 70, "Input",
 CellID->418309732],
Cell[153670, 3541, 401, 15, 70, "Output",
 CellID->92134282]
}, Open  ]],
Cell[154086, 3559, 125, 3, 70, "ExampleDelimiter",
 CellID->131238384],
Cell[154214, 3564, 209, 7, 70, "ExampleText",
 CellID->96543143],
Cell[CellGroupData[{
Cell[154448, 3575, 162, 5, 70, "Input",
 CellID->477464077],
Cell[154613, 3582, 262, 10, 70, "Output",
 CellID->165571090]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[154936, 3599, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[155255, 3610, 1459, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[156751, 3668, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[157072, 3679, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[157255, 3687, 299, 8, 70, "MoreAboutSection"],
Cell[157557, 3697, 173, 3, 70, "MoreAbout",
 CellID->320813193],
Cell[157733, 3702, 159, 3, 70, "MoreAbout",
 CellID->89514147],
Cell[157895, 3707, 152, 3, 70, "MoreAbout",
 CellID->15983872],
Cell[158050, 3712, 174, 3, 70, "MoreAbout",
 CellID->52661055],
Cell[158227, 3717, 153, 3, 70, "MoreAbout",
 CellID->75742166],
Cell[158383, 3722, 172, 3, 70, "MoreAbout",
 CellID->259797875],
Cell[158558, 3727, 197, 4, 70, "MoreAbout",
 CellID->717877090],
Cell[158758, 3733, 172, 3, 70, "MoreAbout",
 CellID->34665837],
Cell[158933, 3738, 179, 3, 70, "MoreAbout",
 CellID->274362167]
}, Open  ]],
Cell[159127, 3744, 27, 0, 70, "History"],
Cell[159157, 3746, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

