(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26421,        936]
NotebookOptionsPosition[     20927,        747]
NotebookOutlinePosition[     22328,        786]
CellTagsIndexPosition[     22243,        781]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SquaresR" :> Documentation`HelpLookup["paclet:ref/SquaresR"], 
          "IntegerPartitions" :> 
          Documentation`HelpLookup["paclet:ref/IntegerPartitions"], 
          "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "Divisors" :> 
          Documentation`HelpLookup["paclet:ref/Divisors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SquaresR\"\>", 
       2->"\<\"IntegerPartitions\"\>", 3->"\<\"FindInstance\"\>", 
       4->"\<\"Divisors\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Diophantine Equations" :> 
          Documentation`HelpLookup["paclet:guide/DiophantineEquations"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Diophantine Equations\"\>", 
       2->"\<\"Number Theoretic Functions\"\>", 3->"\<\"Number Theory\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       5->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PowersRepresentations", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PowersRepresentations",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PowersRepresentations"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the distinct representations of the integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " as a sum of ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " non-negative ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " integer powers."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PowersRepresentations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowersRepresentations"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["k", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " returns lists of integers ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", 
    SubscriptBox["n", "1"], "\[LessEqual]", " ", 
    SubscriptBox["n", "2"], "\[LessEqual]", " ", "\[Ellipsis]", 
    "\[LessEqual]", " ", 
    SubscriptBox["n", "k"]}], TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["n", "1", "p"], "+", 
     SubsuperscriptBox["n", "2", "p"], "+", "\[Ellipsis]", "+", 
     SubsuperscriptBox["n", "k", "p"]}], "=", " ", "n"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->299898270],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->664594745],

Cell["Find representations of 1729 as a sum of two cubes:", "ExampleText",
 CellID->99381371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowersRepresentations", "[", 
  RowBox[{"1729", ",", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361771951],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103994639]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"9", "^", "3"}], "+", 
  RowBox[{"10", "^", "3"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45568046],

Cell[BoxData["1729"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->128851040]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["\<\
Representation of relatively large numbers as the sum of two squares:\
\>", "ExampleText",
 CellID->1767251691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowersRepresentations", "[", 
  RowBox[{"489886592769624989886788", ",", "2", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->352848980],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"179075995118", ",", "676622775808"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"180837148448", ",", "676154212078"}], "}"}]}], "}"}]], "Output",
 ImageSize->{442, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102024984]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->722610919],

Cell["Known taxicab numbers:", "ExampleText",
 CellID->901691848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowersRepresentations", "[", 
  RowBox[{"1729", ",", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->583452843],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264032848]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowersRepresentations", "[", 
  RowBox[{"87539319", ",", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1910190432],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"167", ",", "436"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"228", ",", "423"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"255", ",", "414"}], "}"}]}], "}"}]], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->298110899]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowersRepresentations", "[", 
  RowBox[{"6963472309248", ",", " ", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->767766640],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2421", ",", "19083"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5436", ",", "18948"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10200", ",", "18072"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13322", ",", "16630"}], "}"}]}], "}"}]], "Output",
 ImageSize->{432, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->401782744]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowersRepresentations", "[", 
  RowBox[{"48988659276962496", ",", " ", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1365178085],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"38787", ",", "365757"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"107839", ",", "362753"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"205292", ",", "342952"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"221424", ",", "336588"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"231518", ",", "331954"}], "}"}]}], "}"}]], "Output",
 ImageSize->{381, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->256371672]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find a solution instance: "
}], "ExampleText",
 CellID->1994743784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sort", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], " ", "/.", " ", "#"}], "]"}], 
   " ", "&"}], "/@", " ", 
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "\[Equal]", "102"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "Integers"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1551392430],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"2", ",", "7", ",", "7"}], "}"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->402611114]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowersRepresentations", "[", 
  RowBox[{"102", ",", " ", "3", ",", " ", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1978016118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "7", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->126544003]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1109128812],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowersRepresentations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowersRepresentations"]], "InlineFormula"],
 " gives ordered partitions of fixed length: "
}], "ExampleText",
 CellID->629145995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"PowersRepresentations", "[", 
    RowBox[{"7", ",", "3", ",", "1"}], "]"}], ",", " ", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"#", ",", "0"}], "]"}], " ", "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->745293725],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48620248]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", " ", "/@", " ", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"IntegerPartitions", "[", "7", "]"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "#", "]"}], " ", "\[Equal]", " ", "3"}], " ", 
     "&"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->969887324],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "3"}], "}"}]}], "}"}]], "Output",
 GeneratedCell->False,
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->534785372]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
The scale of the computation increases rapidly with the size of the number:\
\>", "ExampleText",
 CellID->2069466808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowersRepresentations", "[", 
  RowBox[{"4898865927696249222222555", ",", " ", "2", ",", " ", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->883495244],

Cell[BoxData[
 RowBox[{
  RowBox[{"PowersRepresentations", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"PowersRepresentations::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->352769374],

Cell[BoxData[
 RowBox[{"PowersRepresentations", "[", 
  RowBox[{"4898865927696249222222555", ",", "2", ",", "3"}], "]"}]], "Output",\

 ImageSize->{394, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180788585]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SquaresR",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SquaresR"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPartitions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisors"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->28609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->448861558],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "MoreAbout",
 CellID->926180955],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->41600948],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->180400358],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->47605976],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->349050911]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PowersRepresentations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 36.2639144}", "context" -> "System`", 
    "keywords" -> {
     "integer representation", "sum of powers", "sum of squares"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "PowersRepresentations[n, k, p] gives the distinct representations of the \
integer n as a sum of k non-negative p\\[Null]^th integer powers.", 
    "synonyms" -> {"powers representations"}, "title" -> 
    "PowersRepresentations", "type" -> "Symbol", "uri" -> 
    "ref/PowersRepresentations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7535, 218, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->299898270]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22100, 774}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2904, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3527, 93, 1586, 37, 70, "ObjectNameGrid"],
Cell[5116, 132, 971, 30, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6124, 167, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6602, 184, 896, 29, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[7535, 218, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->299898270],
Cell[CellGroupData[{
Cell[7920, 232, 148, 5, 70, "ExampleSection",
 CellID->664594745],
Cell[8071, 239, 93, 1, 70, "ExampleText",
 CellID->99381371],
Cell[CellGroupData[{
Cell[8189, 244, 153, 4, 28, "Input",
 CellID->361771951],
Cell[8345, 250, 304, 11, 36, "Output",
 CellID->103994639]
}, Open  ]],
Cell[CellGroupData[{
Cell[8686, 266, 138, 5, 28, "Input",
 CellID->45568046],
Cell[8827, 273, 161, 5, 36, "Output",
 CellID->128851040]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9037, 284, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[9261, 293, 121, 3, 70, "ExampleText",
 CellID->1767251691],
Cell[CellGroupData[{
Cell[9407, 300, 173, 4, 70, "Input",
 CellID->352848980],
Cell[9583, 306, 346, 11, 36, "Output",
 CellID->102024984]
}, Open  ]],
Cell[9944, 320, 125, 3, 70, "ExampleDelimiter",
 CellID->722610919],
Cell[10072, 325, 65, 1, 70, "ExampleText",
 CellID->901691848],
Cell[CellGroupData[{
Cell[10162, 330, 153, 4, 70, "Input",
 CellID->583452843],
Cell[10318, 336, 304, 11, 36, "Output",
 CellID->264032848]
}, Open  ]],
Cell[CellGroupData[{
Cell[10659, 352, 158, 4, 70, "Input",
 CellID->1910190432],
Cell[10820, 358, 373, 13, 36, "Output",
 CellID->298110899]
}, Open  ]],
Cell[CellGroupData[{
Cell[11230, 376, 167, 4, 70, "Input",
 CellID->767766640],
Cell[11400, 382, 450, 15, 36, "Output",
 CellID->401782744]
}, Open  ]],
Cell[CellGroupData[{
Cell[11887, 402, 172, 4, 70, "Input",
 CellID->1365178085],
Cell[12062, 408, 528, 17, 54, "Output",
 CellID->256371672]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12639, 431, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[12880, 440, 225, 8, 70, "ExampleText",
 CellID->1994743784],
Cell[CellGroupData[{
Cell[13130, 452, 553, 19, 70, "Input",
 CellID->1551392430],
Cell[13686, 473, 237, 8, 36, "Output",
 CellID->402611114]
}, Open  ]],
Cell[CellGroupData[{
Cell[13960, 486, 163, 4, 70, "Input",
 CellID->1978016118],
Cell[14126, 492, 323, 11, 36, "Output",
 CellID->126544003]
}, Open  ]],
Cell[14464, 506, 126, 3, 70, "ExampleDelimiter",
 CellID->1109128812],
Cell[14593, 511, 246, 7, 70, "ExampleText",
 CellID->629145995],
Cell[CellGroupData[{
Cell[14864, 522, 298, 9, 70, "Input",
 CellID->745293725],
Cell[15165, 533, 459, 15, 36, "Output",
 CellID->48620248]
}, Open  ]],
Cell[CellGroupData[{
Cell[15661, 553, 325, 10, 70, "Input",
 CellID->969887324],
Cell[15989, 565, 483, 16, 36, "Output",
 CellID->534785372]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16521, 587, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[16755, 596, 127, 3, 70, "ExampleText",
 CellID->2069466808],
Cell[CellGroupData[{
Cell[16907, 603, 187, 5, 70, "Input",
 CellID->883495244],
Cell[17097, 610, 385, 7, 70, "Message",
 CellID->352769374],
Cell[17485, 619, 265, 8, 36, "Output",
 CellID->180788585]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17811, 634, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[18130, 645, 971, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[19138, 685, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[19459, 696, 198, 4, 70, "Tutorials",
 CellID->28609]
}, Open  ]],
Cell[CellGroupData[{
Cell[19694, 705, 319, 9, 70, "MoreAboutSection",
 CellID->448861558],
Cell[20016, 716, 153, 3, 70, "MoreAbout",
 CellID->926180955],
Cell[20172, 721, 161, 3, 70, "MoreAbout",
 CellID->41600948],
Cell[20336, 726, 137, 3, 70, "MoreAbout",
 CellID->180400358],
Cell[20476, 731, 178, 3, 70, "MoreAbout",
 CellID->47605976],
Cell[20657, 736, 198, 4, 70, "MoreAbout",
 CellID->349050911]
}, Open  ]],
Cell[20870, 743, 27, 0, 70, "History"],
Cell[20900, 745, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

