(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16305,        631]
NotebookOptionsPosition[     12241,        490]
NotebookOutlinePosition[     13550,        527]
CellTagsIndexPosition[     13465,        522]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Defining Output Formats" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DefiningOutputFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Defining Output Formats\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Infix" :> Documentation`HelpLookup["paclet:ref/Infix"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Infix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Notational Forms" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicNotationalForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Symbolic Notational Forms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PrecedenceForm", "ObjectName",
 CellID->30580],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PrecedenceForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PrecedenceForm"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["prec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " parenthesized as it would be if it contained an operator with \
precedence ",
     Cell[BoxData[
      StyleBox["prec", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14127]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["prec", "TI"]], "InlineFormula"],
 " must be an integer. See notes for ",
 Cell[BoxData[
  ButtonBox["Infix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infix"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4550],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrecedenceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecedenceForm"]], "InlineFormula"],
 " acts as a \"wrapper\", which affects printing, but not evaluation. "
}], "Notes",
 CellID->16502]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->224106964],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->14361523],

Cell["\<\
Force parenthesization by lowering the effective precedence of \
multiplication:\
\>", "ExampleText",
 CellID->145055474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"PrecedenceForm", "[", 
   RowBox[{
    RowBox[{"b", " ", "c"}], ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127226402],

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"(", 
   TagBox[
    RowBox[{"b", " ", "c"}],
    PrecedenceForm[#, 10]& ], ")"}]}]], "Output",
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->230644028]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8012],

Cell[TextData[{
 "Define an operator ",
 Cell[BoxData[
  RowBox[{"|", ">"}]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["Infix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infix"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->106819490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Infix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", "\"\<|>\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->339313892],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"a", "\<\"|>\"\>", "b"}],
  Infix[{$CellContext`a, $CellContext`b}, "|>"],
  Editable->False]], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252538789]
}, Open  ]],

Cell[TextData[{
 "Give the operator precedence higher than ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " but lower than ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->411093667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PrecedenceForm", "[", 
   RowBox[{"s", ",", "350"}], "]"}], "+", "y"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->541852984],

Cell[BoxData[
 RowBox[{"y", "+", 
  TagBox[
   InterpretationBox[
    RowBox[{"a", "\<\"|>\"\>", "b"}],
    Infix[{$CellContext`a, $CellContext`b}, "|>"],
    Editable->False],
   PrecedenceForm[#, 350]& ]}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->254106353]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PrecedenceForm", "[", 
   RowBox[{"s", ",", "350"}], "]"}], " ", "y"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->345233769],

Cell[BoxData[
 RowBox[{"y", " ", 
  RowBox[{"(", 
   TagBox[
    InterpretationBox[
     RowBox[{"a", "\<\"|>\"\>", "b"}],
     Infix[{$CellContext`a, $CellContext`b}, "|>"],
     Editable->False],
    PrecedenceForm[#, 350]& ], ")"}]}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->210802764]
}, Open  ]],

Cell[TextData[{
 "Give the operator precedence higher than both ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->643753633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PrecedenceForm", "[", 
   RowBox[{"s", ",", "500"}], "]"}], "+", "y"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->772035886],

Cell[BoxData[
 RowBox[{"y", "+", 
  TagBox[
   InterpretationBox[
    RowBox[{"a", "\<\"|>\"\>", "b"}],
    Infix[{$CellContext`a, $CellContext`b}, "|>"],
    Editable->False],
   PrecedenceForm[#, 500]& ]}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->3017976]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PrecedenceForm", "[", 
   RowBox[{"s", ",", "500"}], "]"}], " ", "y"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->777529622],

Cell[BoxData[
 RowBox[{"y", " ", 
  TagBox[
   InterpretationBox[
    RowBox[{"a", "\<\"|>\"\>", "b"}],
    Infix[{$CellContext`a, $CellContext`b}, "|>"],
    Editable->False],
   PrecedenceForm[#, 500]& ]}]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->399603714]
}, Open  ]],

Cell["Give the operator lowest precedence:", "ExampleText",
 CellID->490210780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PrecedenceForm", "[", 
   RowBox[{"s", ",", "0"}], "]"}], "+", "y"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->10310918],

Cell[BoxData[
 RowBox[{"y", "+", 
  RowBox[{"(", 
   TagBox[
    InterpretationBox[
     RowBox[{"a", "\<\"|>\"\>", "b"}],
     Infix[{$CellContext`a, $CellContext`b}, "|>"],
     Editable->False],
    PrecedenceForm[#, 0]& ], ")"}]}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->74332311]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PrecedenceForm", "[", 
   RowBox[{"s", ",", "0"}], "]"}], " ", "y"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->356461161],

Cell[BoxData[
 RowBox[{"y", " ", 
  RowBox[{"(", 
   TagBox[
    InterpretationBox[
     RowBox[{"a", "\<\"|>\"\>", "b"}],
     Infix[{$CellContext`a, $CellContext`b}, "|>"],
     Editable->False],
    PrecedenceForm[#, 0]& ], ")"}]}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->520095237]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23156],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Infix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infix"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->20580]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9793],

Cell[TextData[ButtonBox["Defining Output Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiningOutputFormats"]], "Tutorials",
 CellID->25994]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbolic Notational Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicNotationalForms"]], "MoreAbout",
 CellID->74318851]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PrecedenceForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 37.0139336}", "context" -> "System`", 
    "keywords" -> {"operator precedence"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PrecedenceForm[expr, prec] prints with expr parenthesized as it would be \
if it contained an operator with precedence prec. ", 
    "synonyms" -> {"precedence form"}, "title" -> "PrecedenceForm", "type" -> 
    "Symbol", "uri" -> "ref/PrecedenceForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4261, 147, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->224106964]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13322, 515}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1761, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2384, 74, 52, 1, 70, "ObjectName",
 CellID->30580],
Cell[2439, 77, 758, 24, 70, "Usage",
 CellID->14127]
}, Open  ]],
Cell[CellGroupData[{
Cell[3234, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3712, 123, 262, 10, 70, "Notes",
 CellID->4550],
Cell[3977, 135, 247, 7, 70, "Notes",
 CellID->16502]
}, Closed]],
Cell[CellGroupData[{
Cell[4261, 147, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->224106964],
Cell[CellGroupData[{
Cell[4646, 161, 147, 5, 70, "ExampleSection",
 CellID->14361523],
Cell[4796, 168, 131, 4, 70, "ExampleText",
 CellID->145055474],
Cell[CellGroupData[{
Cell[4952, 176, 183, 6, 28, "Input",
 CellID->127226402],
Cell[5138, 184, 269, 10, 36, "Output",
 CellID->230644028]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5456, 200, 215, 7, 70, "ExampleSection",
 CellID->8012],
Cell[5674, 209, 264, 11, 70, "ExampleText",
 CellID->106819490],
Cell[CellGroupData[{
Cell[5963, 224, 208, 7, 70, "Input",
 CellID->339313892],
Cell[6174, 233, 279, 9, 36, "Output",
 CellID->252538789]
}, Open  ]],
Cell[6468, 245, 350, 13, 70, "ExampleText",
 CellID->411093667],
Cell[CellGroupData[{
Cell[6843, 262, 159, 5, 70, "Input",
 CellID->541852984],
Cell[7005, 269, 349, 12, 36, "Output",
 CellID->254106353]
}, Open  ]],
Cell[CellGroupData[{
Cell[7391, 286, 159, 5, 70, "Input",
 CellID->345233769],
Cell[7553, 293, 378, 13, 36, "Output",
 CellID->210802764]
}, Open  ]],
Cell[7946, 309, 344, 13, 70, "ExampleText",
 CellID->643753633],
Cell[CellGroupData[{
Cell[8315, 326, 159, 5, 70, "Input",
 CellID->772035886],
Cell[8477, 333, 347, 12, 36, "Output",
 CellID->3017976]
}, Open  ]],
Cell[CellGroupData[{
Cell[8861, 350, 159, 5, 70, "Input",
 CellID->777529622],
Cell[9023, 357, 349, 12, 36, "Output",
 CellID->399603714]
}, Open  ]],
Cell[9387, 372, 79, 1, 70, "ExampleText",
 CellID->490210780],
Cell[CellGroupData[{
Cell[9491, 377, 156, 5, 70, "Input",
 CellID->10310918],
Cell[9650, 384, 375, 13, 36, "Output",
 CellID->74332311]
}, Open  ]],
Cell[CellGroupData[{
Cell[10062, 402, 157, 5, 70, "Input",
 CellID->356461161],
Cell[10222, 409, 376, 13, 36, "Output",
 CellID->520095237]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10659, 429, 311, 9, 70, "SeeAlsoSection",
 CellID->23156],
Cell[10973, 440, 190, 6, 70, "SeeAlso",
 CellID->20580]
}, Open  ]],
Cell[CellGroupData[{
Cell[11200, 451, 313, 9, 70, "TutorialsSection",
 CellID->9793],
Cell[11516, 462, 155, 3, 70, "Tutorials",
 CellID->25994]
}, Open  ]],
Cell[CellGroupData[{
Cell[11708, 470, 299, 8, 70, "MoreAboutSection"],
Cell[12010, 480, 159, 3, 70, "MoreAbout",
 CellID->74318851]
}, Open  ]],
Cell[12184, 486, 27, 0, 70, "History"],
Cell[12214, 488, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

