(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11683,        421]
NotebookOptionsPosition[      8766,        325]
NotebookOutlinePosition[     10054,        361]
CellTagsIndexPosition[      9970,        356]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Defining Output Formats" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DefiningOutputFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Defining Output Formats\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Infix" :> Documentation`HelpLookup["paclet:ref/Infix"], 
          "Postfix" :> Documentation`HelpLookup["paclet:ref/Postfix"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Infix\"\>", 
       2->"\<\"Postfix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Notational Forms" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicNotationalForms"], 
          "Mathematica Syntax" :> 
          Documentation`HelpLookup["paclet:guide/Syntax"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Symbolic Notational Forms\"\>", 
       2->"\<\"Mathematica Syntax\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Prefix", "ObjectName",
 CellID->7026],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Prefix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Prefix"], "[", 
       RowBox[{
        StyleBox["f", "TI"], "[", 
        StyleBox["expr", "TI"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " given in default prefix form: ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "@", 
       StyleBox["expr", "TI"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Prefix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Prefix"], "[", 
       RowBox[{
        RowBox[{
         StyleBox["f", "TI"], "[", 
         StyleBox["expr", "TI"], "]"}], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as ",
     Cell[BoxData[
      StyleBox["hexpr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->9452]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Prefix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prefix"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["h", "TI"], ",", 
    StyleBox["precedence", "TI"], ",", 
    StyleBox["grouping", "TI"]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " can be used to specify how the output form should be parenthesized. "
}], "Notes",
 CellID->4946]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->640904840],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->93905957],

Cell[TextData[{
 "Display ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineFormula"],
 " in pretfix form:"
}], "ExampleText",
 CellID->64949714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prefix", "[", 
  RowBox[{"f", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->377999034],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"f", "@", "x"}],
  Prefix[
   $CellContext`f[$CellContext`x]],
  Editable->False]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153055310]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->160844154],

Cell["Use a special character as a prefix operator:", "ExampleText",
 CellID->350845310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prefix", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", "\"\<\[Section]\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->68367406],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Section]\"\>", "x"}],
  Prefix[
   $CellContext`f[$CellContext`x], "\[Section]"],
  Editable->False]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->844269634]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17745],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Infix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Postfix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Postfix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11925]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11921],

Cell[TextData[ButtonBox["Defining Output Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiningOutputFormats"]], "Tutorials",
 CellID->21680]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbolic Notational Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicNotationalForms"]], "MoreAbout",
 CellID->11407262],

Cell[TextData[ButtonBox["Mathematica Syntax",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Syntax"]], "MoreAbout",
 CellID->65570927]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Prefix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 44.3266208}", "context" -> "System`", 
    "keywords" -> {"prefix notation", "functional notation", "lisp notation"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Prefix[f[expr]] prints with f[expr] given in default prefix form: \
f@expr. Prefix[f[expr], h] prints as hexpr. ", "synonyms" -> {"@"}, "title" -> 
    "Prefix", "type" -> "Symbol", "uri" -> "ref/Prefix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4894, 163, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->640904840]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9827, 349}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1971, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2594, 76, 43, 1, 70, "ObjectName",
 CellID->7026],
Cell[2640, 79, 1269, 43, 70, "Usage",
 CellID->9452]
}, Open  ]],
Cell[CellGroupData[{
Cell[3946, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4424, 144, 433, 14, 70, "Notes",
 CellID->4946]
}, Closed]],
Cell[CellGroupData[{
Cell[4894, 163, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->640904840],
Cell[CellGroupData[{
Cell[5279, 177, 147, 5, 70, "ExampleSection",
 CellID->93905957],
Cell[5429, 184, 153, 6, 70, "ExampleText",
 CellID->64949714],
Cell[CellGroupData[{
Cell[5607, 194, 130, 4, 28, "Input",
 CellID->377999034],
Cell[5740, 200, 267, 10, 36, "Output",
 CellID->153055310]
}, Open  ]],
Cell[6022, 213, 125, 3, 70, "ExampleDelimiter",
 CellID->160844154],
Cell[6150, 218, 88, 1, 70, "ExampleText",
 CellID->350845310],
Cell[CellGroupData[{
Cell[6263, 223, 172, 6, 70, "Input",
 CellID->68367406],
Cell[6438, 231, 293, 10, 36, "Output",
 CellID->844269634]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6792, 248, 311, 9, 70, "SeeAlsoSection",
 CellID->17745],
Cell[7106, 259, 443, 17, 70, "SeeAlso",
 CellID->11925]
}, Open  ]],
Cell[CellGroupData[{
Cell[7586, 281, 314, 9, 70, "TutorialsSection",
 CellID->11921],
Cell[7903, 292, 155, 3, 70, "Tutorials",
 CellID->21680]
}, Open  ]],
Cell[CellGroupData[{
Cell[8095, 300, 299, 8, 70, "MoreAboutSection"],
Cell[8397, 310, 159, 3, 70, "MoreAbout",
 CellID->11407262],
Cell[8559, 315, 135, 3, 70, "MoreAbout",
 CellID->65570927]
}, Open  ]],
Cell[8709, 321, 27, 0, 70, "History"],
Cell[8739, 323, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

