(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31486,       1207]
NotebookOptionsPosition[     24547,        963]
NotebookOutlinePosition[     25871,       1001]
CellTagsIndexPosition[     25786,        996]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Forms of Assignment" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialFormsOfAssignment"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Special Forms of Assignment\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AppendTo" :> Documentation`HelpLookup["paclet:ref/AppendTo"], 
          "Sow" :> Documentation`HelpLookup["paclet:ref/Sow"], "AddTo" :> 
          Documentation`HelpLookup["paclet:ref/AddTo"], "Prepend" :> 
          Documentation`HelpLookup["paclet:ref/Prepend"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AppendTo\"\>", 2->"\<\"Sow\"\>", 
       3->"\<\"AddTo\"\>", 4->"\<\"Prepend\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assignments" :> 
          Documentation`HelpLookup["paclet:guide/Assignments"], 
          "Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Assignments\"\>", 
       2->"\<\"Elements of Lists\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PrependTo", "ObjectName",
 CellID->28899],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PrependTo",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PrependTo"], "[", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prepends ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " to the value of ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ", and resets ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " to the result. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16834]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrependTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrependTo"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "=", 
   RowBox[{
    ButtonBox["Prepend",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Prepend"], "[", 
    RowBox[{
     StyleBox["s", "TI"], ",", 
     StyleBox["elem", "TI"]}], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24804],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrependTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrependTo"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " does not evaluate ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9969],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["PrependTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrependTo"]], "InlineFormula"],
 " repeatedly to build up a list, though ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " will usually be more efficient. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->32289171,
  ButtonNote->"32289171"]
}], "Notes",
 CellID->8283],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrependTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrependTo"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects, returning ordinary lists if necessary. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->433833737,
  ButtonNote->"433833737"]
}], "Notes",
 CellID->28568]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->79890194],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->3944915],

Cell[TextData[{
 "Assign ",
 Cell[BoxData[
  StyleBox["l", "TI"]], "InlineFormula"],
 " to a list:"
}], "ExampleText",
 CellID->11494944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", " ", "=", " ", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "4", ",", "9"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127216836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4", ",", "9"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->184678740]
}, Open  ]],

Cell["Include a new value at the end of the list:", "ExampleText",
 CellID->145088879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrependTo", "[", 
  RowBox[{"l", ",", " ", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6478896],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2", ",", "4", ",", "9"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->658342155]
}, Open  ]],

Cell[TextData[{
 "The value assigned to ",
 Cell[BoxData[
  StyleBox["l", "TI"]], "InlineFormula"],
 " has changed:"
}], "ExampleText",
 CellID->79900755],

Cell[CellGroupData[{

Cell[BoxData["l"], "Input",
 CellLabel->"In[3]:=",
 CellID->360550079],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2", ",", "4", ",", "9"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->253960947]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24546],

Cell[TextData[{
 "Use a head other than ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3967],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"e", " ", "=", " ", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", " ", "c"}], "]"}]}], ";"}], "\n", 
 RowBox[{"PrependTo", "[", 
  RowBox[{"e", ",", 
   RowBox[{"x", "+", "y"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1707],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177073541]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->554012073],

Cell[TextData[{
 "This assigns ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " to a sparse matrix:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->433833737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", " ", "i_"}], "}"}], "\[Rule]", "i"}], "}"}], ",", 
    "3"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135393557],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170089269]
}, Open  ]],

Cell["Add a row to the top of the matrix:", "ExampleText",
 CellID->132199243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrependTo", "[", 
  RowBox[{"s", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54625957],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "6", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 6, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->803667580]
}, Open  ]],

Cell["\<\
Prepending an element with inconsistent dimensions requires converting to \
ordinary lists:\
\>", "ExampleText",
 CellID->91811606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrependTo", "[", 
  RowBox[{"s", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->233977205],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->604659279]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25270],

Cell[TextData[{
 "Assign ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " to be a 2\[Times]2 matrix:"
}], "ExampleText",
 CellID->94389399],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->405629810],

Cell[TextData[{
 "Prepend a row to ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->48465141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrependTo", "[", 
  RowBox[{"m", ",", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18615598],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->224852385]
}, Open  ]],

Cell[TextData[{
 "Prepend a column to ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->65755977],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"col", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], ";"}], "\n", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PrependTo", "[", 
    RowBox[{
     RowBox[{"m", "[", 
      RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
     RowBox[{"col", "[", 
      RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->345528288],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5387152]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is now a 3\[Times]3 matrix:"
}], "ExampleText",
 CellID->322977225],

Cell[CellGroupData[{

Cell[BoxData["m"], "Input",
 CellLabel->"In[4]:=",
 CellID->190164334],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->24661348]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12039],

Cell["The first argument must be a variable:", "ExampleText",
 CellID->79233537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrependTo", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", " ", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->650378038],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrependTo", "::", "\<\"rvalue\"\>"}], ":", 
  " ", "\<\"\\!\\({1, 2}\\) is not a variable with a value, so its value \
cannot be changed. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\
\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/rvalue\\\", ButtonNote -> \
\\\"PrependTo::rvalue\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->153785397],

Cell[BoxData[
 RowBox[{"PrependTo", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "3"}], "]"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59032576]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23707779],

Cell["The first argument must be a variable with a value:", "ExampleText",
 CellID->167906277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrependTo", "[", 
  RowBox[{"k", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219291365],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrependTo", "::", "\<\"rvalue\"\>"}], ":", 
  " ", "\<\"\\!\\(k\\) is not a variable with a value, so its value cannot be \
changed. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\
\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/rvalue\\\", \
ButtonNote -> \\\"PrependTo::rvalue\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->930571783],

Cell[BoxData[
 RowBox[{"PrependTo", "[", 
  RowBox[{"k", ",", "2"}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->185684618]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->185065819],

Cell["\<\
The first argument must be assigned to something which can be prepended to:\
\>", "ExampleText",
 CellID->170551083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"k", " ", "=", " ", "1"}], ";", 
  RowBox[{"PrependTo", "[", 
   RowBox[{"k", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340162720],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrependTo", "::", "\<\"normal\"\>"}], ":", 
  " ", "\<\"Nonatomic expression expected at position \\!\\(1\\) in \
\\!\\(PrependTo[\\(\\(k, 2\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/normal\\\", ButtonNote -> \
\\\"PrependTo::normal\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->803871991],

Cell[BoxData[
 RowBox[{"PrependTo", "[", 
  RowBox[{"k", ",", "2"}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4721803]
}, Open  ]],

Cell[TextData[{
 "Something for which",
 Cell[BoxData[
  RowBox[{" ", 
   ButtonBox["AtomQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AtomQ"]}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " cannot be prepended to:"
}], "ExampleText",
 CellID->73529949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtomQ", "[", "k", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->175591933],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->383570538]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->427776523],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["PrependTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrependTo"]], "InlineFormula"],
 " to accumulate values in large loops can be slow:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->32289171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", 
  RowBox[{"Timing", "[", 
   RowBox[{
    RowBox[{"a", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"sum", " ", "=", " ", "0"}], ";", 
    RowBox[{"While", "[", 
     RowBox[{
      RowBox[{"sum", " ", "<", " ", 
       RowBox[{"10", "^", "4"}]}], ",", 
      RowBox[{
       RowBox[{"r", " ", "=", " ", 
        RowBox[{"RandomReal", "[", "]"}]}], ";", 
       RowBox[{"sum", " ", "+=", " ", "r"}], ";", 
       RowBox[{"PrependTo", "[", 
        RowBox[{"a", ",", " ", "r"}], "]"}]}]}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Length", "[", "a", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->462277309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"18.227`", ",", "20069"}], "}"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->512549985]
}, Open  ]],

Cell[TextData[{
 "There are many alternatives, such as using ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->107902303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", 
  RowBox[{"Timing", "[", 
   RowBox[{
    RowBox[{"sum", " ", "=", " ", "0"}], ";", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", ",", 
       RowBox[{"{", "a", "}"}]}], "}"}], " ", "=", " ", 
     RowBox[{"Reap", "[", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{"sum", " ", "<", " ", 
         RowBox[{"10", "^", "4"}]}], ",", " ", 
        RowBox[{
         RowBox[{"r", " ", "=", " ", 
          RowBox[{"RandomReal", "[", "]"}]}], ";", " ", 
         RowBox[{"sum", " ", "+=", " ", "r"}], ";", " ", 
         RowBox[{"Sow", "[", "r", "]"}]}]}], "]"}], "]"}]}], ";", 
    RowBox[{"a", " ", "=", " ", 
     RowBox[{"Reverse", "[", "a", "]"}]}], ";", 
    RowBox[{"Length", "[", "a", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->125230519],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.27000000000000146`", ",", "20069"}], "}"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141226838]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24200],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AppendTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AppendTo"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AddTo"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prepend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prepend"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32579]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13538],

Cell[TextData[ButtonBox["Special Forms of Assignment",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFormsOfAssignment"]], "Tutorials",
 CellID->23474]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Assignments",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Assignments"]], "MoreAbout",
 CellID->34386802],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->12322501]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PrependTo - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 49.5455044}", "context" -> "System`", 
    "keywords" -> {
     "concatenation of lists", "prepend elements to lists", 
      "prepending to list", "push", "stack"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PrependTo[s, elem] prepends elem to the value of s, and resets s to the \
result. ", "synonyms" -> {"prepend to"}, "title" -> "PrependTo", "type" -> 
    "Symbol", "uri" -> "ref/PrependTo"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6130, 214, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->79890194]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25644, 989}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2127, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2750, 78, 47, 1, 70, "ObjectName",
 CellID->28899],
Cell[2800, 81, 781, 26, 70, "Usage",
 CellID->16834]
}, Open  ]],
Cell[CellGroupData[{
Cell[3618, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4096, 129, 561, 22, 70, "Notes",
 CellID->24804],
Cell[4660, 153, 351, 14, 70, "Notes",
 CellID->9969],
Cell[5014, 169, 604, 22, 70, "Notes",
 CellID->8283],
Cell[5621, 193, 472, 16, 70, "Notes",
 CellID->28568]
}, Closed]],
Cell[CellGroupData[{
Cell[6130, 214, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->79890194],
Cell[CellGroupData[{
Cell[6514, 228, 146, 5, 70, "ExampleSection",
 CellID->3944915],
Cell[6663, 235, 137, 6, 70, "ExampleText",
 CellID->11494944],
Cell[CellGroupData[{
Cell[6825, 245, 169, 5, 28, "Input",
 CellID->127216836],
Cell[6997, 252, 223, 7, 36, "Output",
 CellID->184678740]
}, Open  ]],
Cell[7235, 262, 86, 1, 70, "ExampleText",
 CellID->145088879],
Cell[CellGroupData[{
Cell[7346, 267, 131, 4, 28, "Input",
 CellID->6478896],
Cell[7480, 273, 233, 7, 36, "Output",
 CellID->658342155]
}, Open  ]],
Cell[7728, 283, 154, 6, 70, "ExampleText",
 CellID->79900755],
Cell[CellGroupData[{
Cell[7907, 293, 70, 2, 70, "Input",
 CellID->360550079],
Cell[7980, 297, 233, 7, 36, "Output",
 CellID->253960947]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8262, 310, 239, 7, 70, "ExampleSection",
 CellID->24546],
Cell[8504, 319, 192, 8, 70, "ExampleText",
 CellID->3967],
Cell[CellGroupData[{
Cell[8721, 331, 279, 9, 70, "Input",
 CellID->1707],
Cell[9003, 342, 253, 8, 36, "Output",
 CellID->177073541]
}, Open  ]],
Cell[9271, 353, 125, 3, 70, "ExampleDelimiter",
 CellID->554012073],
Cell[9399, 358, 201, 7, 70, "ExampleText",
 CellID->433833737],
Cell[CellGroupData[{
Cell[9625, 369, 288, 10, 70, "Input",
 CellID->135393557],
Cell[9916, 381, 479, 17, 36, "Output",
 CellID->170089269]
}, Open  ]],
Cell[10410, 401, 78, 1, 70, "ExampleText",
 CellID->132199243],
Cell[CellGroupData[{
Cell[10513, 406, 186, 6, 70, "Input",
 CellID->54625957],
Cell[10702, 414, 479, 17, 36, "Output",
 CellID->803667580]
}, Open  ]],
Cell[11196, 434, 141, 4, 70, "ExampleText",
 CellID->91811606],
Cell[CellGroupData[{
Cell[11362, 442, 177, 6, 70, "Input",
 CellID->233977205],
Cell[11542, 450, 519, 17, 36, "Output",
 CellID->604659279]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12110, 473, 223, 7, 70, "ExampleSection",
 CellID->25270],
Cell[12336, 482, 153, 6, 70, "ExampleText",
 CellID->94389399],
Cell[12492, 490, 275, 10, 70, "Input",
 CellID->405629810],
Cell[12770, 502, 137, 6, 70, "ExampleText",
 CellID->48465141],
Cell[CellGroupData[{
Cell[12932, 512, 181, 6, 70, "Input",
 CellID->18615598],
Cell[13116, 520, 361, 13, 36, "Output",
 CellID->224852385]
}, Open  ]],
Cell[13492, 536, 140, 6, 70, "ExampleText",
 CellID->65755977],
Cell[CellGroupData[{
Cell[13657, 546, 482, 16, 70, "Input",
 CellID->345528288],
Cell[14142, 564, 389, 13, 36, "Output",
 CellID->5387152]
}, Open  ]],
Cell[14546, 580, 143, 5, 70, "ExampleText",
 CellID->322977225],
Cell[CellGroupData[{
Cell[14714, 589, 70, 2, 70, "Input",
 CellID->190164334],
Cell[14787, 593, 390, 13, 36, "Output",
 CellID->24661348]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15226, 612, 226, 7, 70, "ExampleSection",
 CellID->12039],
Cell[15455, 621, 80, 1, 70, "ExampleText",
 CellID->79233537],
Cell[CellGroupData[{
Cell[15560, 626, 182, 6, 70, "Input",
 CellID->650378038],
Cell[15745, 634, 415, 8, 70, "Message",
 CellID->153785397],
Cell[16163, 644, 265, 9, 36, "Output",
 CellID->59032576]
}, Open  ]],
Cell[16443, 656, 124, 3, 70, "ExampleDelimiter",
 CellID->23707779],
Cell[16570, 661, 94, 1, 70, "ExampleText",
 CellID->167906277],
Cell[CellGroupData[{
Cell[16689, 666, 128, 4, 70, "Input",
 CellID->219291365],
Cell[16820, 672, 408, 7, 70, "Message",
 CellID->930571783],
Cell[17231, 681, 217, 7, 36, "Output",
 CellID->185684618]
}, Open  ]],
Cell[17463, 691, 125, 3, 70, "ExampleDelimiter",
 CellID->185065819],
Cell[17591, 696, 126, 3, 70, "ExampleText",
 CellID->170551083],
Cell[CellGroupData[{
Cell[17742, 703, 185, 6, 70, "Input",
 CellID->340162720],
Cell[17930, 711, 429, 8, 70, "Message",
 CellID->803871991],
Cell[18362, 721, 215, 7, 36, "Output",
 CellID->4721803]
}, Open  ]],
Cell[18592, 731, 359, 14, 70, "ExampleText",
 CellID->73529949],
Cell[CellGroupData[{
Cell[18976, 749, 101, 3, 70, "Input",
 CellID->175591933],
Cell[19080, 754, 161, 5, 36, "Output",
 CellID->383570538]
}, Open  ]],
Cell[19256, 762, 125, 3, 70, "ExampleDelimiter",
 CellID->427776523],
Cell[19384, 767, 286, 9, 70, "ExampleText",
 CellID->32289171],
Cell[CellGroupData[{
Cell[19695, 780, 697, 20, 70, "Input",
 CellID->462277309],
Cell[20395, 802, 214, 7, 36, "Output",
 CellID->512549985]
}, Open  ]],
Cell[20624, 812, 337, 13, 70, "ExampleText",
 CellID->107902303],
Cell[CellGroupData[{
Cell[20986, 829, 828, 23, 70, "Input",
 CellID->125230519],
Cell[21817, 854, 226, 7, 36, "Output",
 CellID->141226838]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22104, 868, 311, 9, 70, "SeeAlsoSection",
 CellID->24200],
Cell[22418, 879, 923, 35, 70, "SeeAlso",
 CellID->32579]
}, Open  ]],
Cell[CellGroupData[{
Cell[23378, 919, 314, 9, 70, "TutorialsSection",
 CellID->13538],
Cell[23695, 930, 162, 3, 70, "Tutorials",
 CellID->23474]
}, Open  ]],
Cell[CellGroupData[{
Cell[23894, 938, 299, 8, 70, "MoreAboutSection"],
Cell[24196, 948, 133, 3, 70, "MoreAbout",
 CellID->34386802],
Cell[24332, 953, 143, 3, 70, "MoreAbout",
 CellID->12322501]
}, Open  ]],
Cell[24490, 959, 27, 0, 70, "History"],
Cell[24520, 961, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

