(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23416,        733]
NotebookOptionsPosition[     19669,        611]
NotebookOutlinePosition[     21045,        648]
CellTagsIndexPosition[     20960,        643]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ImageSize" :> Documentation`HelpLookup["paclet:ref/ImageSize"],
           "ImageSize" :> Documentation`HelpLookup["paclet:ref/ImageSize"], 
          "ViewPoint" :> Documentation`HelpLookup["paclet:ref/ViewPoint"], 
          "RotationAction" :> 
          Documentation`HelpLookup["paclet:ref/RotationAction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ImageSize\"\>", 
       2->"\<\"ImageSize\"\>", 3->"\<\"ViewPoint\"\>", 
       4->"\<\"RotationAction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Graphics Options & Styling\"\>", 
       2->"\<\"Options & Styling for Interactive Manipulation\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PreserveImageOptions", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PreserveImageOptions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PreserveImageOptions"]], "InlineFormula"],
     " \[LineSeparator]is an option to graphics and related functions that \
specifies whether image size and certain other  options should be preserved \
from the previous version of a graphic if the graphic is replaced by a new \
one in output."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"PreserveImageOptions", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", settings for image options from the previous version of a graphic are \
always ignored."
}], "Notes",
 CellID->24487658],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PreserveImageOptions", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " specifies that image options from the previous version of a graphic should \
be used if there are no explicit settings for the options in a new graphic."
}], "Notes",
 CellID->44630670],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PreserveImageOptions", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " specifies that any image option setting manually changed by interactive \
manipulation in the previous version of a graphic will overwrite the setting \
for that option in a new graphic. If no manual change was made in the \
previous version, then any explicit setting in the new version will be used, \
but if there is no such explicit setting, then any setting from the old \
version will be used."
}], "Notes",
 CellID->36215859],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PreserveImageOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreserveImageOptions"]], "InlineFormula"],
 " affects ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ImageMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->237081894],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ", it also affects ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->70383279],

Cell[TextData[{
 "Settings given for ",
 Cell[BoxData[
  ButtonBox["PreserveImageOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreserveImageOptions"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 " and related functions affect the default value of ",
 Cell[BoxData[
  ButtonBox["PreserveImageOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreserveImageOptions"]], "InlineFormula"],
 " assumed for all graphics that appear anywhere in their contents."
}], "Notes",
 CellID->131651877]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->85617070],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->58752205],

Cell["\<\
Explicitly dragging the image size in the graphic \"disconnects it\" from the \
control:\
\>", "ExampleText",
 CellID->605415344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "100", ",", "200"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->282422646],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`s$$ = 142.6, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`s$$], 100, 200}}, Typeset`size$$ = {143., {69., 73.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`s$93049$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`s$$ = 100}, 
      "ControllerVariables" :> {
        Hold[$CellContext`s$$, $CellContext`s$93049$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Circle[], ImageSize -> $CellContext`s$$], 
      "Specifications" :> {{$CellContext`s$$, 100, 200}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{248., {113., 118.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->25784334]
}, Open  ]],

Cell["\<\
Do not preserve explicit settings for the image size, leaving it connected to \
the control:\
\>", "ExampleText",
 CellID->19324045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "100", ",", "200"}], "}"}], ",", 
   RowBox[{"PreserveImageOptions", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150300476],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`s$$ = 141.4, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`s$$], 100, 200}}, Typeset`size$$ = {141., {68., 73.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`s$93089$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`s$$ = 100}, 
      "ControllerVariables" :> {
        Hold[$CellContext`s$$, $CellContext`s$93089$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Circle[], ImageSize -> $CellContext`s$$], 
      "Specifications" :> {{$CellContext`s$$, 100, 200}}, 
      "Options" :> {PreserveImageOptions -> False}, "DefaultOptions" :> {}],
     ImageSizeCache->{248., {112., 117.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[2]=",
 CellID->358290569]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->367082783],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " preserves manual resizing of the graphic:"
}], "ExampleText",
 CellID->106854295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"Circle", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "x"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406024907],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 1.6520000000000001`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 1, 2}}, Typeset`size$$ = {100., {47., 53.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$93154$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$93154$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Circle[], 
         Circle[{$CellContext`x$$, $CellContext`x$$}]}, ImageSize -> 100], 
      "Specifications" :> {{$CellContext`x$$, 1, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {92., 97.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->204148485]
}, Open  ]],

Cell["\<\
Change the graphic back to its original specified size every time the control \
is moved:\
\>", "ExampleText",
 CellID->429216305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"Circle", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "x"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"PreserveImageOptions", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->187843701],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 1.6099999999999999`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 1, 2}}, Typeset`size$$ = {100., {47., 53.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$93210$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$93210$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Circle[], 
         Circle[{$CellContext`x$$, $CellContext`x$$}]}, ImageSize -> 100], 
      "Specifications" :> {{$CellContext`x$$, 1, 2}}, 
      "Options" :> {PreserveImageOptions -> False}, "DefaultOptions" :> {}],
     ImageSizeCache->{249., {92., 97.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[2]=",
 CellID->207880435]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotationAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotationAction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->566696045],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->120210624]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PreserveImageOptions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 50.1705204}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Symbol", 
    "language" -> "en", "paclet" -> "", "status" -> "None", "summary" -> 
    "PreserveImageOptions is an option to graphics and related functions that \
specifies whether image size and certain other options should be preserved \
from the previous version of a graphic if the graphic is replaced by a new \
one in output.", "synonyms" -> {}, "title" -> "PreserveImageOptions", "type" -> 
    "Symbol", "uri" -> "ref/PreserveImageOptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7580, 245, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->85617070]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20818, 636}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2338, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2961, 83, 63, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3027, 86, 635, 16, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3699, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4177, 124, 309, 10, 70, "Notes",
 CellID->24487658],
Cell[4489, 136, 371, 9, 70, "Notes",
 CellID->44630670],
Cell[4863, 147, 608, 13, 70, "Notes",
 CellID->36215859],
Cell[5474, 162, 602, 23, 70, "Notes",
 CellID->237081894],
Cell[6079, 187, 722, 28, 70, "Notes",
 CellID->70383279],
Cell[6804, 217, 739, 23, 70, "Notes",
 CellID->131651877]
}, Closed]],
Cell[CellGroupData[{
Cell[7580, 245, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->85617070],
Cell[CellGroupData[{
Cell[7964, 259, 147, 5, 70, "ExampleSection",
 CellID->58752205],
Cell[8114, 266, 139, 4, 70, "ExampleText",
 CellID->605415344],
Cell[CellGroupData[{
Cell[8278, 274, 324, 10, 28, "Input",
 CellID->282422646],
Cell[8605, 286, 1529, 33, 254, "Output",
 CellID->25784334]
}, Open  ]],
Cell[10149, 322, 142, 4, 70, "ExampleText",
 CellID->19324045],
Cell[CellGroupData[{
Cell[10316, 330, 387, 11, 70, "Input",
 CellID->150300476],
Cell[10706, 343, 1559, 33, 70, "Output",
 CellID->358290569]
}, Open  ]],
Cell[12280, 379, 125, 3, 70, "ExampleDelimiter",
 CellID->367082783],
Cell[12408, 384, 240, 8, 70, "ExampleText",
 CellID->106854295],
Cell[CellGroupData[{
Cell[12673, 396, 474, 15, 70, "Input",
 CellID->406024907],
Cell[13150, 413, 1578, 34, 70, "Output",
 CellID->204148485]
}, Open  ]],
Cell[14743, 450, 140, 4, 70, "ExampleText",
 CellID->429216305],
Cell[CellGroupData[{
Cell[14908, 458, 537, 16, 70, "Input",
 CellID->187843701],
Cell[15448, 476, 1607, 34, 70, "Output",
 CellID->207880435]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17116, 517, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[17435, 528, 963, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[18435, 568, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[18756, 579, 162, 3, 70, "Tutorials",
 CellID->659944600]
}, Open  ]],
Cell[CellGroupData[{
Cell[18955, 587, 299, 8, 70, "MoreAboutSection"],
Cell[19257, 597, 163, 3, 70, "MoreAbout",
 CellID->566696045],
Cell[19423, 602, 204, 4, 70, "MoreAbout",
 CellID->120210624]
}, Open  ]],
Cell[19642, 609, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

