(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39463,       1241]
NotebookOptionsPosition[     33095,       1013]
NotebookOutlinePosition[     34301,       1048]
CellTagsIndexPosition[     34215,       1043]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NextPrime" :> Documentation`HelpLookup["paclet:ref/NextPrime"],
           "RandomPrime" :> 
          Documentation`HelpLookup["paclet:ref/RandomPrime"], "FactorInteger" :> 
          Documentation`HelpLookup["paclet:ref/FactorInteger"], "PrimeQ" :> 
          Documentation`HelpLookup["paclet:ref/PrimeQ"], "PrimePi" :> 
          Documentation`HelpLookup["paclet:ref/PrimePi"], "Primes" :> 
          Documentation`HelpLookup["paclet:ref/Primes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NextPrime\"\>", 2->"\<\"RandomPrime\"\>", 
       3->"\<\"FactorInteger\"\>", 4->"\<\"PrimeQ\"\>", 5->"\<\"PrimePi\"\>", 
       6->"\<\"Primes\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Prime Numbers" :> 
          Documentation`HelpLookup["paclet:guide/PrimeNumbers"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cryptographic Number Theory\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Number Theoretic Functions\"\>", 4->"\<\"Number Theory\"\>", 
       5->"\<\"Prime Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Prime", "ObjectName",
 CellID->8785],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Prime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Prime"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox[
        StyleBox["n", "TI"], "th"], TraditionalForm]]],
     " prime number. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25932]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Prime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prime"], "[", "1", "]"}]], "InlineFormula"],
 " is 2."
}], "Notes",
 CellID->21270],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Prime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prime"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67838993],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->90098087],

Cell["The first 20 primes:", "ExampleText",
 CellID->16109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Prime", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26752],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "5", ",", "7", ",", "11", ",", "13", ",", "17", ",", 
   "19", ",", "23", ",", "29", ",", "31", ",", "37", ",", "41", ",", "43", 
   ",", "47", ",", "53", ",", "59", ",", "61", ",", "67", ",", "71"}], 
  "}"}]], "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225719298]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20638],

Cell["The billionth prime:", "ExampleText",
 CellID->944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prime", "[", 
  RowBox[{"10", "^", "9"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31966],

Cell[BoxData["22801763489"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180914038]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20255],

Cell[TextData[{
 "Some symbolic operations can be done with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Prime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prime"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula",
  ShowStringCharacters->False],
 ":"
}], "ExampleText",
 CellID->437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"Prime", "[", "n", "]"}], "^", "s"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21922],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"Zeta", "[", "s", "]"}]]], "Output",
 ImageSize->{58, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->964209192]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Prime", "[", "n", "]"}], ">", 
    RowBox[{"n", " ", 
     RowBox[{"Log", "[", "n", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "Integers"}], "&&", 
    RowBox[{"n", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10477],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->324136980]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->231155382],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting: "
}], "ExampleText",
 CellID->506483315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Prime", "[", "n", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10004381],

Cell[BoxData[
 FormBox[
  SubscriptBox[
   TagBox["p",
    Prime], "n"], TraditionalForm]], "Output",
 ImageSize->{17, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->98566473]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16031],

Cell["Plot of the first 100 primes:", "ExampleText",
 CellID->2372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Prime", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32586],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd1Elu1EAYBlCLFUsvWLBg0SCEEEKomWdiAoEwmzCFQaIJCSCGxMwz1BH6
CD6Cj+Aj+AhesvQRAPnVwh0p+vLy+XecripvX9lYWtuUJMnqv+//2X91c37I
hrl5JrfIVG6b+f0uuVXumbluvxzJg3KHPCp3ytMz952Tu/sM88O/E87zXl7g
fXyRx3x5+FzhGh/g68PnrHM+xDf5cJ/ZEh/R3xr+X/VtPub6u3ycl/kE3+eT
5qNP8QP2OWUP+Qw/Yp9b/ZizPieTPgOPnujP6jlwuaKf77PluA7lU/0586t6
bjmxTuWanifP9Nat5LiO7XP9Bc/7Qs8lJ9a5jT1PXuoX9a/0PHmtv+R+HHj0
Rm/ftBz30Whdf8X9NvScFvqrfRYcuIm9fdjFnvO3evtyynGfVrG/4fp3eh6/
19vHBWc85cANx31ffTBv36cfzXPFgRuO5yT9ZN45KTiem44D55/Nc8WJc9Vx
xvkX89xwPIfpV/PO4ZQzHn8zzznHc9txcsf9vpvnggNXXMfrf5h37qcc3wMN
B+645vFP8/f0nHHxyzxXXPP4t3nvmYLje6fhwIvBPC9z4j30J2R/AZmOuZY=

     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 100.}, {0., 541.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->292019498]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10558],

Cell["Differences between the first 100 primes:", "ExampleText",
 CellID->17392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Prime", "[", 
      RowBox[{"n", "+", "1"}], "]"}], "-", 
     RowBox[{"Prime", "[", "n", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9963],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdlElKg0EQRgtXLl24cOEiioiISJxn0zEmzhr/qNGt6Nor1NH6SDmCivUJ
9QKheLya6O5k4f2r+Zwys4+f72/8+0w6OVrJcRo8gzgLPwc/D9+CX0TdEvKX
4VdQv4r8Nfh11LfBG6jfhN9Cv23k7yB/F/l78PsRdQ4HyD9E/yP4Y/gT+NOI
OocOfMn7uFj9uhHjHrwLf4Z6sPXyPO/Bn6NerP59zO/DD9B/AH8RMd6Jg+0S
9WLVX8GLtf91znex3u1Nznew3cKLNf8OXqz7u8d8seY/RIz7d7Hqh7m+DLN3
cdRXsfZ/zPOKWPuIo18Vq76JGO+/NNk7uIq1/yj7Io5+Psr5Fd6esL9Y+8NX
eHvGfLHOD76KNf8l5xex5sNXsd7vOPcr45zv8BXeXrG/WL8XcexTxfpffPuv
/wae/mzb
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  PlotRange->{{0., 100.}, {0., 18.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->71720841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15183],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["n", "th"], TraditionalForm]]],
 " prime compared with an estimate:"
}], "ExampleText",
 CellID->17415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"n", " ", 
       RowBox[{"Log", "[", "n", "]"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "2", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3848],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->557582320]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], "-", 
     RowBox[{"n", " ", 
      RowBox[{"Log", "[", "n", "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "2", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27397],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->79990541]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13707],

Cell["An approximation to the zeta function:", "ExampleText",
 CellID->17184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Expand", "[", 
   RowBox[{"Product", "[", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"1", "/", 
       RowBox[{
        RowBox[{"Prime", "[", "n", "]"}], "^", "s"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11444],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWs1uEzEQdvPbIrVJqUTbpKEV5QDlwu8rwIlXQIoqoD0gUOnzwY0LXOAC
b7PE7k7qfDvjGe8mbaVm1/Z4PB6Px/ON9+308uz9p+nl+en06M3F9MvZ+enX
o9efL2ZV7TXn1v46517sudl7MXsL//7v3+z/6vX67bd/axNF4Trzlj/Q0g4t
92a/3VmlL/nGXvncg/pO+bwLXLolXQvoR1Bul+Vt6N8D/vQcC/U4/npZ34Jx
kK7H6QW04Ys7xvmRPNI8qTwAfq2g9T2utjsvBxpXkXnf1IuvRb13WSrUCs9r
P2Nc5GiTI2dmOdLYdLPhfzrX5avVZGqiPkMoa/bGS4JW26/FZfmrxlNtcVQV
20ZN9Mqenh3Oz7YPNsveWN81cRsIvVlZojL12+DWJGkbm3HPJCXqnXr6mXm9
lU7bybPbETTbYalxfGldUC7NuqUV0nTc2M6S2rX5T5QZPXi9PTlWNIiaYH1S
ltWNVQqUHGea45uRl8mTqfaIXrWpXaIFaKvQxB7jSGFxHdAWfP+OS8c4lchN
lfKA6dUqfUnK0voRXYvWhLXnltPjs+qupNmi7jk5Vm8xGM9NjFprahnSucX5
CrRKlOW+Qs/LijNl/VhUZunreKCKJLH8cw+TsH/Ujy7JSJmr5hlRw5quVmkd
tD9xp2lzWC/7DVnZbKdYP8nDdjLU4bE8aVBLpJVYmxwdb7nLnwviz1xLTa9y
k2ifJGQlcrvFtZ/suOvTg7w9F2n6dsL/7ZIuRU9+msaJ+6Xo436dDPpc/in5
h8XiedlW+FMEjXkHiX5QLJ7a3YjOqldVvws+Npzf7hnwe3zDZRz/KZTX51L6
WZ3UfD4vn8QnRONhCC4Hl/dGGTha6VGhR1Q57ZPySdgxvDo9E4cZOC6ebDMe
S4u49ot0Jg0t/tVcS6vIdDTJRzXpG6KpZMzSBI3laICNNhtnpmxcbRLZzqeX
BZ1Dqb7eD9tyMQtZmwTHXDrK5WDMOKzBx6pR4t1nW6UsEMbdKMlysnj18imU
jTsKZYyhkUf+btNWIZd+l52Flh2vxzWRD8jGz5oNILKqd5ORs8O1vl4iOW+h
ZTs4PxfHbVVMi2icuwnAcy6OzCa3uC50xuLZnrMeGrbW85Cavx+zo2PWAG1M
8wma3Ieq3JrWbPnmXK6ptciJkupg1+X3seLxNG/c1RIqttLVmd92jT7obern
LLjZpMd+Esr+BIm9kxXvLpPOgps1/LtV2PDuAOST6Cg6sYwboxYt39EtbPOO
6S35jkdhNU+g9sENl4+hbELzc5R9XPP5sJDR+9VQFhyOsZb/+RVa7jAtP9kW
jvIbS8mN9j1QIk7H+IKLtr3lkSUSbqenlB/Ac4ZDs/EOQHwu0ZOlcr425qd9
aYP93wW1pLLjnHY4zFL1iSO2lkfRNtSPMY12u1UPCWtcMSbSvlKxYX/bt0O2
9at8HaLMOLYyHI1DzxI6T6NoQpcYZech3oFAzWFJiWvPyV+sYHlLoENdEb/l
rAjaFN6VoQ3b8lronbR73dXsH9t+0DSWeye9mp2DXOkGXzon6AYB731vZyWq
9w/aKkjnjPY1hU37KB/uMe17GLRvRKuITg+hbMOWJmQttHP9UQsoFeY0L0y6
41ZOP7PTuEtChhISTCO/PLwmUUs34Sm6FD8JF/IakUY/D+2tsoRxKny/E43g
iVK3kal2QmsaStPQmRVtpeSIUVbqdrgVrYRlXCsKTY37IawNfjeCKAp9Ce5a
rbxs1PdRlNrPdVI+D4SnFe2dhVEwmvA/P0KLf7tCdm7tPybf2ig=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{471, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->514390033]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"s", "->", "2"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29073],

Cell[BoxData[
 FractionBox["29645", "18432"]], "Output",
 ImageSize->{46, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->299234016]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20873],

Cell[BoxData["1.6083441840277777`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->381529330]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Zeta", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26559],

Cell[BoxData["1.6449340668482262`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->400151167]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15993],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrimePi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimePi"]], "InlineFormula"],
 " is effectively the inverse of ",
 Cell[BoxData[
  ButtonBox["Prime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prime"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->13947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prime", "[", "100", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6361],

Cell[BoxData["541"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344843071]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimePi", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3959],

Cell[BoxData["100"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->108117169]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18536],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NextPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NextPrime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomPrime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimePi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimePi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Primes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Primes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3461]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27894],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->8012]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->19292],

Cell[TextData[{
 ButtonBox["Demonstrations with Prime",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Prime"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#12788"], None}]], "RelatedLinks",
 CellID->150271336],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/PrimeNumber.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/NumberTheoryFunctions/Prime/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->163398392],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->328647219],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->995253737],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->586284330],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->227636493],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "MoreAbout",
 CellID->21180311]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Prime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 51.8893144}", "context" -> "System`", 
    "keywords" -> {"Lagarias-Miller-Odlyzko algorithm", "prime", "primes"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Prime[n] gives the n^th prime number. ", "synonyms" -> {}, "title" -> 
    "Prime", "type" -> "Symbol", "uri" -> "ref/Prime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5126, 158, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->67838993]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34073, 1036}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2923, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3546, 91, 42, 1, 70, "ObjectName",
 CellID->8785],
Cell[3591, 94, 583, 20, 70, "Usage",
 CellID->25932]
}, Open  ]],
Cell[CellGroupData[{
Cell[4211, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4689, 136, 198, 8, 70, "Notes",
 CellID->21270],
Cell[4890, 146, 199, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[5126, 158, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67838993],
Cell[CellGroupData[{
Cell[5510, 172, 147, 5, 70, "ExampleSection",
 CellID->90098087],
Cell[5660, 179, 59, 1, 70, "ExampleText",
 CellID->16109],
Cell[CellGroupData[{
Cell[5744, 184, 203, 7, 28, "Input",
 CellID->26752],
Cell[5950, 193, 414, 11, 36, "Output",
 CellID->225719298]
}, Open  ]],
Cell[6379, 207, 121, 3, 70, "ExampleDelimiter",
 CellID->20638],
Cell[6503, 212, 57, 1, 70, "ExampleText",
 CellID->944],
Cell[CellGroupData[{
Cell[6585, 217, 121, 4, 70, "Input",
 CellID->31966],
Cell[6709, 223, 168, 5, 36, "Output",
 CellID->180914038]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6926, 234, 216, 7, 70, "ExampleSection",
 CellID->20255],
Cell[7145, 243, 295, 11, 70, "ExampleText",
 CellID->437],
Cell[CellGroupData[{
Cell[7465, 258, 289, 10, 70, "Input",
 CellID->21922],
Cell[7757, 270, 209, 7, 53, "Output",
 CellID->964209192]
}, Open  ]],
Cell[CellGroupData[{
Cell[8003, 282, 334, 11, 70, "Input",
 CellID->10477],
Cell[8340, 295, 161, 5, 36, "Output",
 CellID->324136980]
}, Open  ]],
Cell[8516, 303, 125, 3, 70, "ExampleDelimiter",
 CellID->231155382],
Cell[8644, 308, 204, 7, 70, "ExampleText",
 CellID->506483315],
Cell[CellGroupData[{
Cell[8873, 319, 138, 4, 70, "Input",
 CellID->10004381],
Cell[9014, 325, 247, 9, 52, "Output",
 CellID->98566473]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9310, 340, 223, 7, 70, "ExampleSection",
 CellID->16031],
Cell[9536, 349, 67, 1, 70, "ExampleText",
 CellID->2372],
Cell[CellGroupData[{
Cell[9628, 354, 243, 8, 70, "Input",
 CellID->32586],
Cell[9874, 364, 1057, 26, 134, "Output",
 CellID->292019498]
}, Open  ]],
Cell[10946, 393, 121, 3, 70, "ExampleDelimiter",
 CellID->10558],
Cell[11070, 398, 80, 1, 70, "ExampleText",
 CellID->17392],
Cell[CellGroupData[{
Cell[11175, 403, 334, 11, 70, "Input",
 CellID->9963],
Cell[11512, 416, 951, 25, 166, "Output",
 CellID->71720841]
}, Open  ]],
Cell[12478, 444, 121, 3, 70, "ExampleDelimiter",
 CellID->15183],
Cell[12602, 449, 172, 7, 70, "ExampleText",
 CellID->17415],
Cell[CellGroupData[{
Cell[12799, 460, 367, 12, 70, "Input",
 CellID->3848],
Cell[13169, 474, 7336, 124, 70, "Output",
 Evaluatable->False,
 CellID->557582320]
}, Open  ]],
Cell[CellGroupData[{
Cell[20542, 603, 340, 11, 70, "Input",
 CellID->27397],
Cell[20885, 616, 2464, 44, 70, "Output",
 Evaluatable->False,
 CellID->79990541]
}, Open  ]],
Cell[23364, 663, 121, 3, 70, "ExampleDelimiter",
 CellID->13707],
Cell[23488, 668, 77, 1, 70, "ExampleText",
 CellID->17184],
Cell[CellGroupData[{
Cell[23590, 673, 353, 12, 70, "Input",
 CellID->11444],
Cell[23946, 687, 2033, 37, 70, "Output",
 Evaluatable->False,
 CellID->514390033]
}, Open  ]],
Cell[CellGroupData[{
Cell[26016, 729, 113, 4, 70, "Input",
 CellID->29073],
Cell[26132, 735, 186, 6, 51, "Output",
 CellID->299234016]
}, Open  ]],
Cell[CellGroupData[{
Cell[26355, 746, 93, 3, 70, "Input",
 CellID->20873],
Cell[26451, 751, 176, 5, 36, "Output",
 CellID->381529330]
}, Open  ]],
Cell[CellGroupData[{
Cell[26664, 761, 124, 4, 70, "Input",
 CellID->26559],
Cell[26791, 767, 176, 5, 36, "Output",
 CellID->400151167]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27016, 778, 233, 7, 70, "ExampleSection",
 CellID->15993],
Cell[27252, 787, 321, 12, 70, "ExampleText",
 CellID->13947],
Cell[CellGroupData[{
Cell[27598, 803, 98, 3, 70, "Input",
 CellID->6361],
Cell[27699, 808, 160, 5, 36, "Output",
 CellID->344843071]
}, Open  ]],
Cell[CellGroupData[{
Cell[27896, 818, 98, 3, 70, "Input",
 CellID->3959],
Cell[27997, 823, 160, 5, 36, "Output",
 CellID->108117169]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28218, 835, 311, 9, 70, "SeeAlsoSection",
 CellID->18536],
Cell[28532, 846, 1438, 53, 70, "SeeAlso",
 CellID->3461]
}, Open  ]],
Cell[CellGroupData[{
Cell[30007, 904, 314, 9, 70, "TutorialsSection",
 CellID->27894],
Cell[30324, 915, 197, 4, 70, "Tutorials",
 CellID->8012]
}, Open  ]],
Cell[CellGroupData[{
Cell[30558, 924, 321, 9, 70, "RelatedLinksSection",
 CellID->19292],
Cell[30882, 935, 355, 12, 70, "RelatedLinks"],
Cell[31240, 949, 271, 6, 70, "RelatedLinks",
 CellID->150271336],
Cell[31514, 957, 182, 4, 70, "RelatedLinks"],
Cell[31699, 963, 199, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31935, 972, 319, 9, 70, "MoreAboutSection",
 CellID->163398392],
Cell[32257, 983, 164, 3, 70, "MoreAbout",
 CellID->328647219],
Cell[32424, 988, 155, 3, 70, "MoreAbout",
 CellID->995253737],
Cell[32582, 993, 162, 3, 70, "MoreAbout",
 CellID->586284330],
Cell[32747, 998, 137, 3, 70, "MoreAbout",
 CellID->227636493],
Cell[32887, 1003, 136, 3, 70, "MoreAbout",
 CellID->21180311]
}, Open  ]],
Cell[33038, 1009, 27, 0, 70, "History"],
Cell[33068, 1011, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

