(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44685,       1346]
NotebookOptionsPosition[     38533,       1129]
NotebookOutlinePosition[     39905,       1168]
CellTagsIndexPosition[     39819,       1163]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"], 
          "Types of Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/TypesOfNumbers"], 
          "Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Putting Constraints on Patterns\"\>", 
       2->"\<\"Types of Numbers\"\>", 
       3->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FactorInteger" :> 
          Documentation`HelpLookup["paclet:ref/FactorInteger"], "Prime" :> 
          Documentation`HelpLookup["paclet:ref/Prime"], "NextPrime" :> 
          Documentation`HelpLookup["paclet:ref/NextPrime"], "Primes" :> 
          Documentation`HelpLookup["paclet:ref/Primes"], "PrimePowerQ" :> 
          Documentation`HelpLookup["paclet:ref/PrimePowerQ"], "CoprimeQ" :> 
          Documentation`HelpLookup["paclet:ref/CoprimeQ"], "GCD" :> 
          Documentation`HelpLookup["paclet:ref/GCD"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FactorInteger\"\>", 2->"\<\"Prime\"\>", 
       3->"\<\"NextPrime\"\>", 4->"\<\"Primes\"\>", 5->"\<\"PrimePowerQ\"\>", 
       6->"\<\"CoprimeQ\"\>", 7->"\<\"GCD\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Recognition" :> 
          Documentation`HelpLookup["paclet:guide/NumberRecognition"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Prime Numbers" :> 
          Documentation`HelpLookup["paclet:guide/PrimeNumbers"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Cryptographic Number Theory\"\>", 
       2->"\<\"Integer Functions\"\>", 3->"\<\"Number Recognition\"\>", 
       4->"\<\"Number Theoretic Functions\"\>", 5->"\<\"Number Theory\"\>", 
       6->"\<\"Prime Numbers\"\>", 
       7->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PrimeQ", "ObjectName",
 CellID->30516],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PrimeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PrimeQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a prime number, and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21618]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"], "[", "1", "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7718],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"], "[", 
   RowBox[{"-", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is prime, gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23668],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    RowBox[{
     ButtonBox["GaussianIntegers",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GaussianIntegers"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " determines whether ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is a Gaussian prime. "
}], "Notes",
 CellID->20536],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"], "[", 
   RowBox[{
    StyleBox["m", "TI"], "+", 
    RowBox[{
     ButtonBox["I",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/I"], 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " automatically works over the Gaussian integers. "
}], "Notes",
 CellID->9747],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], "\[Element]", 
    ButtonBox["Primes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Primes"]}], "]"}]], "InlineFormula"],
 " can be used to try to determine whether a symbolic expression is \
mathematically a prime. "
}], "Notes",
 CellID->6523]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->323970060],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->160393497],

Cell["Test whether a number is prime:", "ExampleText",
 CellID->15544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", "13", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6210],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12104]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", 
  RowBox[{
   RowBox[{"10", "^", "100"}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18040],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8337]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17034],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 " threads itself element-wise over lists:"
}], "ExampleText",
 CellID->3744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3217],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "False", ",", "True", ",", "True", ",", "False", ",", "True", ",", 
   "False"}], "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26068]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13235],

Cell["Test for primality over the Gaussian integers:", "ExampleText",
 CellID->1104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", 
  RowBox[{"13", ",", 
   RowBox[{"GaussianIntegers", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20032],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15816]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{"13", ",", 
   RowBox[{"GaussianIntegers", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17691],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"3", " ", "\[ImaginaryI]"}]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", 
      RowBox[{"2", " ", "\[ImaginaryI]"}]}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13197]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27223],

Cell[TextData[{
 "Only some numbers of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["2", 
     SuperscriptBox["2", "n"]], "+", "1"}], TraditionalForm]], "InlineMath"],
 " are prime:"
}], "ExampleText",
 CellID->2478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PrimeQ", "[", 
    RowBox[{
     RowBox[{"2", "^", 
      RowBox[{"2", "^", "n"}]}], "+", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "False", ",", "False", 
   ",", "False", ",", "False", ",", "False", ",", "False"}], "}"}]], "Output",\

 ImageSize->{441, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19990],

Cell["Highlight numbers that are prime:", "ExampleText",
 CellID->21428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"PrimeQ", "[", "#", "]"}], ",", 
     RowBox[{"Framed", "[", "#", "]"}], ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"Range", "[", "20", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14124],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FrameBox["2",
    StripOnInput->False], ",", 
   FrameBox["3",
    StripOnInput->False], ",", "4", ",", 
   FrameBox["5",
    StripOnInput->False], ",", "6", ",", 
   FrameBox["7",
    StripOnInput->False], ",", "8", ",", "9", ",", "10", ",", 
   FrameBox["11",
    StripOnInput->False], ",", "12", ",", 
   FrameBox["13",
    StripOnInput->False], ",", "14", ",", "15", ",", "16", ",", 
   FrameBox["17",
    StripOnInput->False], ",", "18", ",", 
   FrameBox["19",
    StripOnInput->False], ",", "20"}], "}"}]], "Output",
 ImageSize->{528, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25981]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28489],

Cell["The distribution of Gaussian primes:", "ExampleText",
 CellID->30425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Boole", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PrimeQ", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "I"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "100"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "100"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1984],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyll11y3DAMg6nepFfKETJ97/3f2tnZtUXgA7U7cdtUEin+ArTz+/vv1/ev
qvrz/LfW/7/Pp9Zrd690V48/qtvlr5/3bVFqouFcHzq/LJtPzEMuxRB2e5ee
ZnEqXZn5XY/DBTfLFPVEu0E3izd17crk/adCoAchNnrl+xnHnDqQkaYLizxJ
0xNx6A2dXeZSqT0wnMmXNFJ4GxVVvTYjqYA9SnJo0lR3z4hiriYNWbMos7yv
uX+lR8nAT3CF40YxTjFmHnm72+pc87vd+/+q3eUtG4+aOf0e8dIkCOqnyveK
89i5ZMwCd7UbyDBWPRPRfi7dO8W8Gn+/p2mY9xgL9pxTcxC9rz35ySx1pNl9
pwhYZwyO5gFGlBzxEDnJJX0qE1c6ZQPc5yLkEuEsis5apJwBtTybDmCYjPOr
d4H0NBEOOKEs2DVJSxf0oiUG7GaNB4QtNVGmTJ92bJRCEVEkz8fFtFunjzYN
os/d2XmREhfm3YGC4D2C7sgIDWF3UfcmvolXL8xpzKx2ZtI8pDXmbogcZgv4
TIDO+rZOM8ql/LYnvSFiahlhn6QcrOTjeZSZ9bCyVBz0qPolx9mJrOAikS4B
VolGYEdPaTpRgTKkeSxVNWEyfv59JJf4MuCNyyBWkwlp126K6tOiMbzxCjW0
UIvarZrP73aOiK5xxCqFjyRit7t046QzFJzQrTEqAr0wenc7oyHtqtPAoMxo
Kkg2+ymNE5WSG+kGvSGGS+KSABLcTHTKbrsxv7t6+hRFQgvr93Oj4B0FES6z
YI+edu2Cc4BoxVRz4/BLTleZfinQ9fRcdpjDU3H4E6ds99TmiZ+Q1oFK/Rvx
l+aQgoH00hSorqAxUhxnbPXTyzJh41ZVswyLwwfGTLE1SEknBKxKr9oyzimk
XmgicztIUeUZRgDu4RQVxGufCDgTtR17WSjCXtAMFXQ6s1bVU1lOOUsWCk+m
oRsruNuMz/wlJicwLDojmHJnKH6XBp7TKPC82GiXgj4VYsb9shvnT+ulTH2t
kE4iJR0LbIJoSl+jz0/pRrPhDNVJClFsEH+nsb5gNdci4GTGGz2p7IaJ3mB/
23vZCIUQ0gQ9pegZIAgGmlQs9Yd5LmtCjvdm+k4k0DRp4CWWTueBasezNAiJ
tRMxGQKPn97QDGXFHY0Pz6XFOLObWksAiSs3lYuRkea0hStSR6qtND5LN0nJ
cZ5Z7tChy/ySKBLG8KJIM2A+aG36EusnPZDA86ndazmaCCoNzB575rRK1+K7
tu7v7hsC+2oyq1DpAT1OE+AyBDqn3ZXqFZHOEy48m0rUQNPfbPQmITQ5nggW
VzZ35ZWKvQgLjWQebbf+ASPaI44=
   "], {{0, 0}, {100, 100}}],
  AspectRatio->Automatic,
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->23286]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Boole", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PrimeQ", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "+", 
       RowBox[{"b", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "100"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "100"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15535],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyll11y3DAMg6nepFfKETJ97/3f2tnZtUXgA7U7cdtUEin+ArTz+/vv1/ev
qvrz/LfW/7/Pp9Zrd690V48/qtvlr5/3bVFqouFcHzq/LJtPzEMuxRB2e5ee
ZnEqXZn5XY/DBTfLFPVEu0E3izd17crk/adCoAchNnrl+xnHnDqQkaYLizxJ
0xNx6A2dXeZSqT0wnMmXNFJ4GxVVvTYjqYA9SnJo0lR3z4hiriYNWbMos7yv
uX+lR8nAT3CF40YxTjFmHnm72+pc87vd+/+q3eUtG4+aOf0e8dIkCOqnyveK
89i5ZMwCd7UbyDBWPRPRfi7dO8W8Gn+/p2mY9xgL9pxTcxC9rz35ySx1pNl9
pwhYZwyO5gFGlBzxEDnJJX0qE1c6ZQPc5yLkEuEsis5apJwBtTybDmCYjPOr
d4H0NBEOOKEs2DVJSxf0oiUG7GaNB4QtNVGmTJ92bJRCEVEkz8fFtFunjzYN
os/d2XmREhfm3YGC4D2C7sgIDWF3UfcmvolXL8xpzKx2ZtI8pDXmbogcZgv4
TIDO+rZOM8ql/LYnvSFiahlhn6QcrOTjeZSZ9bCyVBz0qPolx9mJrOAikS4B
VolGYEdPaTpRgTKkeSxVNWEyfv59JJf4MuCNyyBWkwlp126K6tOiMbzxCjW0
UIvarZrP73aOiK5xxCqFjyRit7t046QzFJzQrTEqAr0wenc7oyHtqtPAoMxo
Kkg2+ymNE5WSG+kGvSGGS+KSABLcTHTKbrsxv7t6+hRFQgvr93Oj4B0FES6z
YI+edu2Cc4BoxVRz4/BLTleZfinQ9fRcdpjDU3H4E6ds99TmiZ+Q1oFK/Rvx
l+aQgoH00hSorqAxUhxnbPXTyzJh41ZVswyLwwfGTLE1SEknBKxKr9oyzimk
XmgicztIUeUZRgDu4RQVxGufCDgTtR17WSjCXtAMFXQ6s1bVU1lOOUsWCk+m
oRsruNuMz/wlJicwLDojmHJnKH6XBp7TKPC82GiXgj4VYsb9shvnT+ulTH2t
kE4iJR0LbIJoSl+jz0/pRrPhDNVJClFsEH+nsb5gNdci4GTGGz2p7IaJ3mB/
23vZCIUQ0gQ9pegZIAgGmlQs9Yd5LmtCjvdm+k4k0DRp4CWWTueBasezNAiJ
tRMxGQKPn97QDGXFHY0Pz6XFOLObWksAiSs3lYuRkea0hStSR6qtND5LN0nJ
cZ5Z7tChy/ySKBLG8KJIM2A+aG36EusnPZDA86ndazmaCCoNzB575rRK1+K7
tu7v7hsC+2oyq1DpAT1OE+AyBDqn3ZXqFZHOEy48m0rUQNPfbPQmITQ5nggW
VzZ35ZWKvQgLjWQebbf+ASPaI44=
   "], {{0, 0}, {100, 100}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8667]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Boole", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PrimeQ", "[", 
      RowBox[{
       RowBox[{"a", "^", "b"}], "+", "3"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "100"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "100"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15155],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmlsSgyAMRS/dSbfUJTj97/7/OgqiIgQR1ERzZrRKgeYB4dV39/t0LwBf
d8HA9Nj7gkgSXzBd8EllGojSlzt9yxo+TMSwkiyNeZM6pH6lkGSs2mhLDiYv
DU5TuVaZlAAQb2JYdoRaJVrV81zgBkL7YmKPdPm24uxnNp6vv0uVoWusE+jZ
OHfEB0NBlkVCXCSelWOZVoRmV79m4ytI6gX3Z7Mz9nvtFH/D39r8oDbSSoq6
OV9rz8IVgsGvUmi+OgsjNKQIwyY2r7Kyi1BOIHexa3xjN1foCEmUnmkdtXZM
OKNfxAR2PsFyklVZlVLHsBzM25FcKXJwA/yJlHtvtTWaTlAoEvui0rDRdoy8
iIVfsmxJupIHQ88uP8rhZvOxdwRyrcXMCc5NMaHAT7Dg3yO5sglXg3EgLG9J
tfmVCLDhijpdcxnPkmgf9q9kfnkxnzMS80fylOcSjf9G/ii7
   "], {{0, 0}, {100, 100}}],
  AspectRatio->Automatic,
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->26575]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Cuboid", "/@", 
   RowBox[{"Position", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"PrimeQ", "[", 
         RowBox[{"#1", "+", 
          RowBox[{"#2", "^", "#3"}]}], "]"}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"30", ",", "30", ",", "30"}], "}"}]}], "]"}], ",", "True"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14970],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160494638]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27460]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14115],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NextPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NextPrime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Primes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Primes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimePowerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimePowerQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoprimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoprimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GCD"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2619]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1797],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->13073],

Cell[TextData[ButtonBox["Types of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TypesOfNumbers"]], "Tutorials",
 CellID->11552],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->28615]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->21256],

Cell[TextData[{
 ButtonBox["Demonstrations with PrimeQ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=PrimeQ"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#6849"], None}]], "RelatedLinks",
 CellID->11928],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
PrimeQ"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->660913247],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->573381204],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->86140465],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "MoreAbout",
 CellID->114424537],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->638932839],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->2783713],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "MoreAbout",
 CellID->914324101],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->654667105]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PrimeQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 54.1081212}", "context" -> "System`", 
    "keywords" -> {
     "isprime", "Lucas test", "Miller-Rabin test", "primality testing", 
      "pseudoprime test", "testing for primality of integers", 
      "testing for prime"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PrimeQ[expr] yields True if expr is a prime number, and yields False \
otherwise. ", "synonyms" -> {"prime q"}, "title" -> "PrimeQ", "type" -> 
    "Symbol", "uri" -> "ref/PrimeQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7860, 251, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->323970060]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39676, 1156}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3630, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4253, 105, 44, 1, 70, "ObjectName",
 CellID->30516],
Cell[4300, 108, 846, 28, 70, "Usage",
 CellID->21618]
}, Open  ]],
Cell[CellGroupData[{
Cell[5183, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5661, 158, 320, 13, 70, "Notes",
 CellID->7718],
Cell[5984, 173, 439, 18, 70, "Notes",
 CellID->23668],
Cell[6426, 193, 557, 20, 70, "Notes",
 CellID->20536],
Cell[6986, 215, 405, 15, 70, "Notes",
 CellID->9747],
Cell[7394, 232, 429, 14, 70, "Notes",
 CellID->6523]
}, Closed]],
Cell[CellGroupData[{
Cell[7860, 251, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->323970060],
Cell[CellGroupData[{
Cell[8245, 265, 148, 5, 70, "ExampleSection",
 CellID->160393497],
Cell[8396, 272, 70, 1, 70, "ExampleText",
 CellID->15544],
Cell[CellGroupData[{
Cell[8491, 277, 98, 3, 28, "Input",
 CellID->6210],
Cell[8592, 282, 157, 5, 36, "Output",
 CellID->12104]
}, Open  ]],
Cell[CellGroupData[{
Cell[8786, 292, 148, 5, 28, "Input",
 CellID->18040],
Cell[8937, 299, 157, 5, 36, "Output",
 CellID->8337]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9143, 310, 216, 7, 70, "ExampleSection",
 CellID->17034],
Cell[9362, 319, 208, 7, 70, "ExampleText",
 CellID->3744],
Cell[CellGroupData[{
Cell[9595, 330, 187, 6, 70, "Input",
 CellID->3217],
Cell[9785, 338, 268, 9, 36, "Output",
 CellID->26068]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10102, 353, 239, 7, 70, "ExampleSection",
 CellID->13235],
Cell[10344, 362, 84, 1, 70, "ExampleText",
 CellID->1104],
Cell[CellGroupData[{
Cell[10453, 367, 165, 5, 70, "Input",
 CellID->20032],
Cell[10621, 374, 158, 5, 36, "Output",
 CellID->15816]
}, Open  ]],
Cell[CellGroupData[{
Cell[10816, 384, 172, 5, 70, "Input",
 CellID->17691],
Cell[10991, 391, 523, 19, 36, "Output",
 CellID->13197]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11563, 416, 223, 7, 70, "ExampleSection",
 CellID->27223],
Cell[11789, 425, 240, 9, 70, "ExampleText",
 CellID->2478],
Cell[CellGroupData[{
Cell[12054, 438, 282, 10, 70, "Input",
 CellID->23233],
Cell[12339, 450, 325, 10, 36, "Output",
 CellID->30962]
}, Open  ]],
Cell[12679, 463, 121, 3, 70, "ExampleDelimiter",
 CellID->19990],
Cell[12803, 468, 72, 1, 70, "ExampleText",
 CellID->21428],
Cell[CellGroupData[{
Cell[12900, 473, 277, 9, 70, "Input",
 CellID->14124],
Cell[13180, 484, 703, 23, 43, "Output",
 CellID->25981]
}, Open  ]],
Cell[13898, 510, 121, 3, 70, "ExampleDelimiter",
 CellID->28489],
Cell[14022, 515, 75, 1, 70, "ExampleText",
 CellID->30425],
Cell[CellGroupData[{
Cell[14122, 520, 401, 13, 70, "Input",
 CellID->1984],
Cell[14526, 535, 1742, 35, 246, "Output",
 CellID->23286]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16317, 576, 224, 7, 70, "ExampleSection",
 CellID->24363],
Cell[CellGroupData[{
Cell[16566, 587, 430, 14, 70, "Input",
 CellID->15535],
Cell[16999, 603, 1651, 32, 201, "Output",
 CellID->8667]
}, Open  ]],
Cell[18665, 638, 120, 3, 70, "ExampleDelimiter",
 CellID->1437],
Cell[CellGroupData[{
Cell[18810, 645, 402, 13, 70, "Input",
 CellID->15155],
Cell[19215, 660, 847, 20, 246, "Output",
 CellID->26575]
}, Open  ]],
Cell[20077, 683, 121, 3, 70, "ExampleDelimiter",
 CellID->27154],
Cell[CellGroupData[{
Cell[20223, 690, 458, 15, 70, "Input",
 CellID->14970],
Cell[20684, 707, 11925, 200, 70, "Output",
 Evaluatable->False,
 CellID->160494638]
}, Open  ]],
Cell[32624, 910, 121, 3, 70, "ExampleDelimiter",
 CellID->27460]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32794, 919, 311, 9, 70, "SeeAlsoSection",
 CellID->14115],
Cell[33108, 930, 1673, 62, 70, "SeeAlso",
 CellID->2619]
}, Open  ]],
Cell[CellGroupData[{
Cell[34818, 997, 313, 9, 70, "TutorialsSection",
 CellID->1797],
Cell[35134, 1008, 170, 3, 70, "Tutorials",
 CellID->13073],
Cell[35307, 1013, 141, 3, 70, "Tutorials",
 CellID->11552],
Cell[35451, 1018, 198, 4, 70, "Tutorials",
 CellID->28615]
}, Open  ]],
Cell[CellGroupData[{
Cell[35686, 1027, 321, 9, 70, "RelatedLinksSection",
 CellID->21256],
Cell[36010, 1038, 357, 12, 70, "RelatedLinks"],
Cell[36370, 1052, 266, 6, 70, "RelatedLinks",
 CellID->11928],
Cell[36639, 1060, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37060, 1078, 319, 9, 70, "MoreAboutSection",
 CellID->660913247],
Cell[37382, 1089, 164, 3, 70, "MoreAbout",
 CellID->573381204],
Cell[37549, 1094, 144, 3, 70, "MoreAbout",
 CellID->86140465],
Cell[37696, 1099, 147, 3, 70, "MoreAbout",
 CellID->114424537],
Cell[37846, 1104, 162, 3, 70, "MoreAbout",
 CellID->638932839],
Cell[38011, 1109, 135, 3, 70, "MoreAbout",
 CellID->2783713],
Cell[38149, 1114, 137, 3, 70, "MoreAbout",
 CellID->914324101],
Cell[38289, 1119, 149, 3, 70, "MoreAbout",
 CellID->654667105]
}, Open  ]],
Cell[38453, 1125, 50, 0, 70, "History"],
Cell[38506, 1127, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

