(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33520,       1016]
NotebookOptionsPosition[     28342,        835]
NotebookOutlinePosition[     29563,        871]
CellTagsIndexPosition[     29478,        866]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MultiplicativeOrder" :> 
          Documentation`HelpLookup["paclet:ref/MultiplicativeOrder"], 
          "EulerPhi" :> Documentation`HelpLookup["paclet:ref/EulerPhi"], 
          "CarmichaelLambda" :> 
          Documentation`HelpLookup["paclet:ref/CarmichaelLambda"], "PowerMod" :> 
          Documentation`HelpLookup["paclet:ref/PowerMod"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MultiplicativeOrder\"\>", 
       2->"\<\"EulerPhi\"\>", 3->"\<\"CarmichaelLambda\"\>", 
       4->"\<\"PowerMod\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cryptographic Number Theory\"\>", 
       2->"\<\"Number Theoretic Functions\"\>", 3->"\<\"Number Theory\"\>", 
       4->"\<\"New in 6.0: Mathematical Functions\"\>", 
       5->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       6->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PrimitiveRoot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PrimitiveRoot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PrimitiveRoot"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a primitive root of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrimitiveRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimitiveRoot"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " gives a generator for the multiplicative group of integers modulo ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " relatively prime to ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrimitiveRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimitiveRoot"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " returns unevaluated if ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is not 2, 4, an odd prime power or twice an odd prime power."
}], "Notes",
 CellID->427741771]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->359556818],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->12040802],

Cell["A primitive root of the prime number 9 is 2:", "ExampleText",
 CellID->4912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimitiveRoot", "[", "9", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11150],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1856760735]
}, Open  ]],

Cell["\<\
The primitive root generates all integers modulo 9 that are relatively prime \
to 9:\
\>", "ExampleText",
 CellID->139144910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PowerMod", "[", 
     RowBox[{"2", ",", "i", ",", "9"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->499328195],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "7", ",", "8"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1492798588]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrimitiveRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimitiveRoot"]], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->740068502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimitiveRoot", "[", 
  RowBox[{"{", 
   RowBox[{"9", ",", "7", ",", "19"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106029690],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->877809084]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "The multiplicative order of a primitive root modulo ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EulerPhi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerPhi"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->597438711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimitiveRoot", "[", "43", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1279995437],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124619898]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MultiplicativeOrder", "[", 
   RowBox[{"3", ",", " ", "43"}], "]"}], "\[Equal]", 
  RowBox[{"EulerPhi", "[", "43", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1666366052],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->690069861]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157605838],

Cell[TextData[{
 "For a prime ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 ", there exist ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EulerPhi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerPhi"], "[", 
   RowBox[{
    StyleBox["p", "TI"], "-", "1"}], "]"}]], "InlineFormula"],
 " primitive roots modulo ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->1033982515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Range", "[", "13", "]"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"MultiplicativeOrder", "[", 
      RowBox[{"#", ",", "13"}], "]"}], "\[Equal]", " ", 
     RowBox[{"EulerPhi", "[", "13", "]"}]}], " ", "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1869754506],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "6", ",", "7", ",", "11"}], "}"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1592460027]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "%", "]"}], "==", 
  RowBox[{"EulerPhi", "[", 
   RowBox[{"13", "-", "1"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->479844552],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->386981228]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrimitiveRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimitiveRoot"]], "InlineFormula"],
 " is not defined for all integers:"
}], "ExampleText",
 CellID->1393759102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimitiveRoot", "[", "12", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1932962040],

Cell[BoxData[
 RowBox[{"PrimitiveRoot", "[", "12", "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1413015880]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell[TextData[{
 "Elements relatively prime to ",
 Cell[BoxData["22"], "InlineFormula"],
 " are enumerated by the primitive root:"
}], "ExampleText",
 CellID->693216771],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"2", " ", 
    RowBox[{"Prime", "[", "5", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"PrimitiveRoot", "[", "n", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"n", ",", "p"}], "}"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->643584473],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"22", ",", "13"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1683726634]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"PowerMod", "[", 
       RowBox[{"p", ",", "k", ",", "n"}], "]"}], "\[Rule]", 
      RowBox[{"PowerMod", "[", 
       RowBox[{"p", ",", 
        RowBox[{"k", "+", "1"}], ",", "n"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "n"}], "}"}]}], "]"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->539994482],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{340, 335},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->239425820]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultiplicativeOrder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiplicativeOrder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerPhi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerPhi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CarmichaelLambda",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CarmichaelLambda"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerMod"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->28609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->76733955],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->30408918],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->191189347],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->44451233],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->466357456],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->5076868],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->872398374]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PrimitiveRoot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 55.9362930}", "context" -> "System`", 
    "keywords" -> {"group generator"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PrimitiveRoot[n] gives a primitive root of n.", 
    "synonyms" -> {"primitive root"}, "title" -> "PrimitiveRoot", "type" -> 
    "Symbol", "uri" -> "ref/PrimitiveRoot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7283, 210, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->359556818]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29335, 859}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3141, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3764, 97, 1578, 37, 70, "ObjectNameGrid"],
Cell[5345, 136, 558, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5940, 159, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6418, 176, 446, 15, 70, "Notes",
 CellID->1067943069],
Cell[6867, 193, 379, 12, 70, "Notes",
 CellID->427741771]
}, Closed]],
Cell[CellGroupData[{
Cell[7283, 210, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->359556818],
Cell[CellGroupData[{
Cell[7668, 224, 147, 5, 70, "ExampleSection",
 CellID->12040802],
Cell[7818, 231, 82, 1, 70, "ExampleText",
 CellID->4912],
Cell[CellGroupData[{
Cell[7925, 236, 105, 3, 28, "Input",
 CellID->11150],
Cell[8033, 241, 159, 5, 36, "Output",
 CellID->1856760735]
}, Open  ]],
Cell[8207, 249, 135, 4, 70, "ExampleText",
 CellID->139144910],
Cell[CellGroupData[{
Cell[8367, 257, 282, 9, 28, "Input",
 CellID->499328195],
Cell[8652, 268, 248, 8, 36, "Output",
 CellID->1492798588]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8949, 282, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[9173, 291, 221, 7, 70, "ExampleText",
 CellID->740068502],
Cell[CellGroupData[{
Cell[9419, 302, 167, 5, 70, "Input",
 CellID->106029690],
Cell[9589, 309, 213, 7, 36, "Output",
 CellID->877809084]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9851, 322, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[10092, 331, 352, 13, 70, "ExampleText",
 CellID->597438711],
Cell[CellGroupData[{
Cell[10469, 348, 111, 3, 70, "Input",
 CellID->1279995437],
Cell[10583, 353, 158, 5, 36, "Output",
 CellID->124619898]
}, Open  ]],
Cell[CellGroupData[{
Cell[10778, 363, 212, 6, 70, "Input",
 CellID->1666366052],
Cell[10993, 371, 161, 5, 36, "Output",
 CellID->690069861]
}, Open  ]],
Cell[11169, 379, 125, 3, 70, "ExampleDelimiter",
 CellID->157605838],
Cell[11297, 384, 435, 17, 70, "ExampleText",
 CellID->1033982515],
Cell[CellGroupData[{
Cell[11757, 405, 342, 10, 70, "Input",
 CellID->1869754506],
Cell[12102, 417, 225, 7, 36, "Output",
 CellID->1592460027]
}, Open  ]],
Cell[CellGroupData[{
Cell[12364, 429, 186, 6, 70, "Input",
 CellID->479844552],
Cell[12553, 437, 161, 5, 36, "Output",
 CellID->386981228]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12763, 448, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[12997, 457, 221, 7, 70, "ExampleText",
 CellID->1393759102],
Cell[CellGroupData[{
Cell[13243, 468, 111, 3, 70, "Input",
 CellID->1932962040],
Cell[13357, 473, 200, 6, 36, "Output",
 CellID->1413015880]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13606, 485, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[13837, 494, 169, 5, 70, "ExampleText",
 CellID->693216771],
Cell[CellGroupData[{
Cell[14031, 503, 352, 11, 70, "Input",
 CellID->643584473],
Cell[14386, 516, 206, 7, 36, "Output",
 CellID->1683726634]
}, Open  ]],
Cell[CellGroupData[{
Cell[14629, 528, 555, 16, 70, "Input",
 CellID->539994482],
Cell[15187, 546, 9781, 164, 70, "Output",
 Evaluatable->False,
 CellID->239425820]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25029, 717, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[25348, 728, 983, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[26368, 768, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[26689, 779, 198, 4, 70, "Tutorials",
 CellID->28609]
}, Open  ]],
Cell[CellGroupData[{
Cell[26924, 788, 318, 9, 70, "MoreAboutSection",
 CellID->76733955],
Cell[27245, 799, 163, 3, 70, "MoreAbout",
 CellID->30408918],
Cell[27411, 804, 162, 3, 70, "MoreAbout",
 CellID->191189347],
Cell[27576, 809, 136, 3, 70, "MoreAbout",
 CellID->44451233],
Cell[27715, 814, 174, 3, 70, "MoreAbout",
 CellID->466357456],
Cell[27892, 819, 177, 3, 70, "MoreAbout",
 CellID->5076868],
Cell[28072, 824, 198, 4, 70, "MoreAbout",
 CellID->872398374]
}, Open  ]],
Cell[28285, 831, 27, 0, 70, "History"],
Cell[28315, 833, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

