(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14384,        514]
NotebookOptionsPosition[     11016,        399]
NotebookOutlinePosition[     12337,        436]
CellTagsIndexPosition[     12252,        431]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Definite Integrals" :> 
          Documentation`HelpLookup["paclet:tutorial/DefiniteIntegrals"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Definite Integrals\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Residue" :> Documentation`HelpLookup["paclet:ref/Residue"], 
          "Limit" :> Documentation`HelpLookup["paclet:ref/Limit"], 
          "GenerateConditions" :> 
          Documentation`HelpLookup["paclet:ref/GenerateConditions"], 
          "DiracDelta" :> 
          Documentation`HelpLookup["paclet:ref/DiracDelta"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Residue\"\>", 2->"\<\"Limit\"\>", 
       3->"\<\"GenerateConditions\"\>", 
       4->"\<\"DiracDelta\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions of Complex Variables" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsOfComplexVariables"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Functions of Complex Variables\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PrincipalValue", "ObjectName",
 CellID->7221],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PrincipalValue",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PrincipalValue"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Integrate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
     " that specifies whether the Cauchy principal value should be found for \
a definite integral. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17301]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"PrincipalValue", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " computes ordinary Riemann integrals. "
}], "Notes",
 CellID->27387],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  RowBox[{"PrincipalValue", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " gives finite answers for integrals that had simple pole divergences with \
",
 Cell[BoxData[
  RowBox[{"PrincipalValue", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18727]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57092168],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->187410141],

Cell["Find the Cauchy principal value integral:", "ExampleText",
 CellID->29017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "1"}], ",", " ", "2"}], "}"}], ",", " ", 
   RowBox[{"PrincipalValue", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7855],

Cell[BoxData[
 RowBox[{"Log", "[", "2", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65498682]
}, Open  ]],

Cell["The ordinary Riemann definite integral is divergent:", "ExampleText",
 CellID->19251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "1"}], ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1578],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], ":", 
  " ", "\<\"Integral of \\!\\(1\\/x\\) does not converge on \
\\!\\({\\(\\(-1\\)\\), 2}\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Integrate/idiv\\\", ButtonNote -> \
\\\"Integrate::idiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->816405988],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"-", "1"}], "2"], 
  RowBox[{
   FractionBox["1", "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{52, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77280153]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"PrincipalValue", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32011],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29513876]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16028],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], ":", 
  " ", "\<\"Integral of \\!\\(Tan[x]\\) does not converge on \\!\\({0, \[Pi]}\
\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Integrate/idiv\\\", \
ButtonNote -> \\\"Integrate::idiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->205159684],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Pi]"], 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{83, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->376150113]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14957],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Residue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Residue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Limit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Limit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GenerateConditions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GenerateConditions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiracDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiracDelta"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6051]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27325],

Cell[TextData[ButtonBox["Definite Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiniteIntegrals"]], "Tutorials",
 CellID->26140]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Functions of Complex Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsOfComplexVariables"]], "MoreAbout",
 CellID->235594677]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PrincipalValue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 57.8113410}", "context" -> "System`", 
    "keywords" -> {"Cauchy principal value"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PrincipalValue is an option for Integrate that specifies whether the \
Cauchy principal value should be found for a definite integral. ", 
    "synonyms" -> {"principal value"}, "title" -> "PrincipalValue", "type" -> 
    "Symbol", "uri" -> "ref/PrincipalValue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4699, 155, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->57092168]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12110, 424}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2103, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2726, 79, 51, 1, 70, "ObjectName",
 CellID->7221],
Cell[2780, 82, 652, 19, 70, "Usage",
 CellID->17301]
}, Open  ]],
Cell[CellGroupData[{
Cell[3469, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3947, 123, 264, 9, 70, "Notes",
 CellID->27387],
Cell[4214, 134, 448, 16, 70, "Notes",
 CellID->18727]
}, Closed]],
Cell[CellGroupData[{
Cell[4699, 155, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57092168],
Cell[CellGroupData[{
Cell[5083, 169, 148, 5, 70, "ExampleSection",
 CellID->187410141],
Cell[5234, 176, 80, 1, 70, "ExampleText",
 CellID->29017],
Cell[CellGroupData[{
Cell[5339, 181, 298, 9, 28, "Input",
 CellID->7855],
Cell[5640, 192, 186, 6, 36, "Output",
 CellID->65498682]
}, Open  ]],
Cell[5841, 201, 91, 1, 70, "ExampleText",
 CellID->19251],
Cell[CellGroupData[{
Cell[5957, 206, 242, 8, 70, "Input",
 CellID->1578],
Cell[6202, 216, 409, 8, 70, "Message",
 CellID->816405988],
Cell[6614, 226, 309, 11, 51, "Output",
 CellID->77280153]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6972, 243, 216, 7, 70, "ExampleSection",
 CellID->29321],
Cell[CellGroupData[{
Cell[7213, 254, 271, 8, 70, "Input",
 CellID->32011],
Cell[7487, 264, 157, 5, 36, "Output",
 CellID->29513876]
}, Open  ]],
Cell[CellGroupData[{
Cell[7681, 274, 215, 7, 70, "Input",
 CellID->16028],
Cell[7899, 283, 399, 7, 70, "Message",
 CellID->205159684],
Cell[8301, 292, 304, 10, 50, "Output",
 CellID->376150113]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8666, 309, 311, 9, 70, "SeeAlsoSection",
 CellID->14957],
Cell[8980, 320, 956, 35, 70, "SeeAlso",
 CellID->6051]
}, Open  ]],
Cell[CellGroupData[{
Cell[9973, 360, 314, 9, 70, "TutorialsSection",
 CellID->27325],
Cell[10290, 371, 146, 3, 70, "Tutorials",
 CellID->26140]
}, Open  ]],
Cell[CellGroupData[{
Cell[10473, 379, 299, 8, 70, "MoreAboutSection"],
Cell[10775, 389, 169, 3, 70, "MoreAbout",
 CellID->235594677]
}, Open  ]],
Cell[10959, 395, 27, 0, 70, "History"],
Cell[10989, 397, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

