(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14425,        481]
NotebookOptionsPosition[     10997,        369]
NotebookOutlinePosition[     12453,        409]
CellTagsIndexPosition[     12368,        404]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Generating Unstructured Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GeneratingUnstructuredOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Generating Unstructured Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Monitor" :> Documentation`HelpLookup["paclet:ref/Monitor"], 
          "Print" :> Documentation`HelpLookup["paclet:ref/Print"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Monitor\"\>", 
       2->"\<\"Print\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Input & Output in Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/BasicInputAndOutputInPrograms"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Basic Input & Output in Programs\"\>", 
       2->"\<\"Tuning & Debugging\"\>", 
       3->"\<\"New in 6.0: Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PrintTemporary", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PrintTemporary",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PrintTemporary"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]prints ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as a temporary cell in a notebook, removing it when the evaluation of \
the current input line is complete."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11575]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrintTemporary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrintTemporary"]], "InlineFormula"],
 " returns an object that can be supplied to ",
 Cell[BoxData[
  ButtonBox["NotebookDelete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookDelete"]], "InlineFormula"],
 " to immediately delete the temporary cell."
}], "Notes",
 CellID->30678],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrintTemporary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrintTemporary"]], "InlineFormula"],
 " creates a cell with style ",
 Cell[BoxData["\"\<PrintTemporary\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->11719]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->397766555],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->538345129],

Cell["Print a temporary cell during an evaluation: ", "ExampleText",
 CellID->339177600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PrintTemporary", "[", "\"\<text\>\"", "]"}], ";", 
  RowBox[{"Pause", "[", "2", "]"}], ";", "17"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->628805930],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173138584]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->404589778],

Cell["\<\
Explicitly delete temporary cells during the course of evaluation: \
\>", "ExampleText",
 CellID->867054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"temp", "=", 
   RowBox[{"PrintTemporary", "[", "\"\<text1\>\"", "]"}]}], ";", 
  RowBox[{"Pause", "[", "1", "]"}], ";", 
  RowBox[{"NotebookDelete", "[", "temp", "]"}], ";", 
  RowBox[{"temp", "=", 
   RowBox[{"PrintTemporary", "[", "\"\<text2\>\"", "]"}]}], ";", 
  RowBox[{"Pause", "[", "1", "]"}], ";", 
  RowBox[{"Print", "[", "\"\<done\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31592092],

Cell[BoxData["\<\"done\"\>"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->457249777]
}, Open  ]],

Cell["If not deleted, multiple temporary cells are printed: ", "ExampleText",
 CellID->629027358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"temp", "=", 
   RowBox[{"PrintTemporary", "[", "\"\<text1\>\"", "]"}]}], ";", 
  RowBox[{"Pause", "[", "1", "]"}], ";", 
  RowBox[{"temp", "=", 
   RowBox[{"PrintTemporary", "[", "\"\<text2\>\"", "]"}]}], ";", 
  RowBox[{"Pause", "[", "1", "]"}], ";", 
  RowBox[{"Print", "[", "\"\<done\>\"", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10892500],

Cell[BoxData["\<\"done\"\>"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->199172160]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21056],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Monitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Monitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23283]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8696],

Cell[TextData[ButtonBox["Generating Unstructured Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneratingUnstructuredOutput"]], "Tutorials",
 CellID->19560]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->59393440],

Cell[TextData[ButtonBox["Basic Input & Output in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], "MoreAbout",
 CellID->2127213],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->140568284],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->146266063]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PrintTemporary - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 5.9990506}", "context" -> "System`", 
    "keywords" -> {
     "create temporary cells", "print intermediate result", 
      "trace intermediate results", "status messages", 
      "monitor intermediate results"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PrintTemporary[expr] prints expr as a temporary cell in a notebook, \
removing it when the evaluation of the current input line is complete.", 
    "synonyms" -> {"print temporary"}, "title" -> "PrintTemporary", "type" -> 
    "Symbol", "uri" -> "ref/PrintTemporary"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6288, 189, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->397766555]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12225, 397}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2207, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2830, 81, 1579, 37, 70, "ObjectNameGrid"],
Cell[4412, 120, 650, 19, 70, "Usage",
 CellID->11575]
}, Open  ]],
Cell[CellGroupData[{
Cell[5099, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5577, 161, 400, 12, 70, "Notes",
 CellID->30678],
Cell[5980, 175, 271, 9, 70, "Notes",
 CellID->11719]
}, Closed]],
Cell[CellGroupData[{
Cell[6288, 189, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->397766555],
Cell[CellGroupData[{
Cell[6673, 203, 148, 5, 70, "ExampleSection",
 CellID->538345129],
Cell[6824, 210, 88, 1, 70, "ExampleText",
 CellID->339177600],
Cell[CellGroupData[{
Cell[6937, 215, 187, 5, 28, "Input",
 CellID->628805930],
Cell[7127, 222, 159, 5, 36, "Output",
 CellID->173138584]
}, Open  ]],
Cell[7301, 230, 125, 3, 70, "ExampleDelimiter",
 CellID->404589778],
Cell[7429, 235, 115, 3, 70, "ExampleText",
 CellID->867054],
Cell[CellGroupData[{
Cell[7569, 242, 442, 11, 70, "Input",
 CellID->31592092],
Cell[8014, 255, 102, 2, 70, "Print",
 CellID->457249777]
}, Open  ]],
Cell[8131, 260, 97, 1, 70, "ExampleText",
 CellID->629027358],
Cell[CellGroupData[{
Cell[8253, 265, 388, 10, 70, "Input",
 CellID->10892500],
Cell[8644, 277, 102, 2, 70, "Print",
 CellID->199172160]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8807, 286, 311, 9, 70, "SeeAlsoSection",
 CellID->21056],
Cell[9121, 297, 443, 17, 70, "SeeAlso",
 CellID->23283]
}, Open  ]],
Cell[CellGroupData[{
Cell[9601, 319, 313, 9, 70, "TutorialsSection",
 CellID->8696],
Cell[9917, 330, 169, 3, 70, "Tutorials",
 CellID->19560]
}, Open  ]],
Cell[CellGroupData[{
Cell[10123, 338, 318, 9, 70, "MoreAboutSection",
 CellID->59393440],
Cell[10444, 349, 171, 3, 70, "MoreAbout",
 CellID->2127213],
Cell[10618, 354, 148, 3, 70, "MoreAbout",
 CellID->140568284],
Cell[10769, 359, 156, 3, 70, "MoreAbout",
 CellID->146266063]
}, Open  ]],
Cell[10940, 365, 27, 0, 70, "History"],
Cell[10970, 367, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

