(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35776,       1133]
NotebookOptionsPosition[     31521,        989]
NotebookOutlinePosition[     32605,       1019]
CellTagsIndexPosition[     32562,       1016]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"PageFooters" :> 
         Documentation`HelpLookup["paclet:ref/PageFooters"], "PageHeaders" :> 
         Documentation`HelpLookup["paclet:ref/PageHeaders"], 
         "ShowCellBracket" :> 
         Documentation`HelpLookup["paclet:ref/ShowCellBracket"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"PageFooters\"\>", 
      2->"\<\"PageHeaders\"\>", 
      3->"\<\"ShowCellBracket\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PrintingOptions", "ObjectName",
 CellID->29436],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->283734131],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PrintingOptions", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["opt", "TI"], 
           StyleBox["1", "TR"]], "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]]}], ",", 
         RowBox[{
          SubscriptBox[
           StyleBox["opt", "TI"], 
           StyleBox["2", "TR"]], "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
     " \[LineSeparator]is an option that specifies settings for printing."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30106]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options may be specified:", "Notes",
 CellID->8544],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CellBackgroundHalftoneAngle\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
specifies the angle of grid lines used by PostScript printers to represent \
graphics\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CellBackgroundHalftoneDensity\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
the spacing of grid lines used by PostScript printers to represent graphics\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FacingPages\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether headers and footers are to be specified separately for left- and \
right-facing pages\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FirstPageFace\>\"", 
    ButtonBox["Right",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Right"], Cell["\<\
whether the first page of a notebook should face left or right when printed\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FirstPageFooter\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether a footer is added to the first page of a notebook when footers are \
printed on all other pages\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FirstPageHeader\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether a header is added to the first page of a notebook when headers are \
printed on all other pages\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsPrintingFormat\>\"", 
    "\"\<Automatic\>\"", Cell[
    "the format in which PostScript graphics are to be printed", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    "\"\<IncludePostScriptResourceDirectives\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether PostScript resource directives are included when sending a file to be \
printed\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IncludeSpecialFonts\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " fonts should be included when a file is sent to be printed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Magnification\>\"", "1.", Cell["\<\
the scaling factor by which each page is magnified when a notebook is printed\
\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PageFooterMargins\>\"", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", " ", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell["\<\
the size of the margins for the footers on each page when the notebook is \
printed\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PageHeaderMargins\>\"", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", " ", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell["\<\
the size of the margins for the headers on each page when the notebook is \
printed\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PageSize\>\"", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", " ", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell[
    "the page size to use for printing a notebook", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PaperOrientation\>\"", 
    "\"\<Portrait\>\"", Cell["\<\
the orientation of the paper to use when preparing a notebook for printing\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PaperSize\>\"", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", " ", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell[
    "the paper size to use when preparing a notebook for printing", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PostScriptOutputFile\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "the file name under which to save the PostScript output that is \
generated when a ",
     Cell[BoxData[
      ButtonBox["Print",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Print"]], "InlineFormula"],
     " command is given"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PrintCellBrackets\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether cell brackets are included when a notebook is printed\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PrintMultipleHorizontalPages\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether the contents of a notebook that extend beyond the width of the page \
are to be printed\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PrintRegistrationMarks\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether trim marks indicating the corners of a page are added when a notebook \
is printed\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PrintSelectionHighlighting\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether elements of a notebook that are selected are highlighted when printed\
\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PrintingMargins\>\"", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"54", ",", " ", "54"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"72", ",", " ", "72"}], "}"}]}], "}"}], Cell[
    "the size of the margins when printing a notebook", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RestPagesFooter\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether a footer is added to all pages of a notebook after the first page\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RestPagesHeader\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether a header is added to all pages of a notebook after the first page\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnixShellPrintingCommand\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
the command to be executed on the system when sending the notebook to a \
printer\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UsePostScriptOutputFile\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether a notebook should be saved as a PostScript file, instead of being \
sent to a printer\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UseUnixShellPrintingCommand\>\"", 
    Cell[TextData[{
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " (",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " on Unix)"
    }], "TableText"], Cell["\<\
whether the system command for printing should be executed when a notebook is \
printed\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, None, None, None, 
     None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True}}}},
 CellID->13851],

Cell[TextData[{
 Cell[BoxData["\"\<CellBackgroundHalftoneAngle\>\""], "InlineFormula"],
 " is specified as ",
 Cell[BoxData[
  RowBox[{"\"\<CellBackgroundHalftoneAngle\>\"", " ", "->", " ", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is the magnitude of the grid angle",
 StyleBox[".", "MR"]
}], "Notes",
 CellID->22264],

Cell[TextData[{
 Cell[BoxData["\"\<CellBackgroundHalftoneDensity\>\""], "InlineFormula"],
 " is specified as ",
 Cell[BoxData[
  RowBox[{"\"\<CellBackgroundHalftoneDensity\>\"", " ", "->", " ", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is the number of grid lines per inch."
}], "Notes",
 CellID->23973],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<FacingPages\>\"", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", headers and footers for left pages can be different from those for right \
pages. Both kinds of headers and footers must be specified separately in the \
",
 StyleBox[ButtonBox["File",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FileMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Printing Settings",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/PrintingSettings"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Headers and Footers",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/HeadersAndFooters"], "MenuName"],
 " dialog box."
}], "Notes",
 CellID->14979],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<FacingPages\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the headers and footers for left pages are the same as for right pages."
}], "Notes",
 CellID->2855],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<FirstPageFooter\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the first page is printed without a footer even if footers are specified \
for all other pages of the notebook."
}], "Notes",
 CellID->30127],

Cell[TextData[{
 Cell[BoxData["\"\<FirstPageFooter\>\""], "InlineFormula"],
 " can also be specified using the dialog box accessed from the ",
 StyleBox[ButtonBox["File",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FileMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Printing Settings",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/PrintingSettings"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Headers and Footers",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/HeadersAndFooters"], "MenuName"],
 " menu item."
}], "Notes",
 CellID->10797],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<FirstPageHeader\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the first page is printed without a header even if headers have been \
specified for all other pages."
}], "Notes",
 CellID->21540],

Cell[TextData[{
 Cell[BoxData["\"\<FirstPageHeader\>\""], "InlineFormula"],
 " can also be specified using the dialog box accessed from the ",
 StyleBox[ButtonBox["File",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FileMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Printing Settings",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/PrintingSettings"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Headers and Footers",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/HeadersAndFooters"], "MenuName"],
 " menu item."
}], "Notes",
 CellID->21725],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData["\"\<GraphicsPrintingFormat\>\""], "InlineFormula"],
 " are as follows."
}], "Notes",
 CellID->6150],

Cell[TextData[Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DownloadPostScript\>\"", Cell[
    "download the underlying PostScript directly to the printer ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RenderInFrontEnd\>\"", Cell[
    "render the graphic to the printer", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Bitmap\>\"", Cell["\<\
render the graphic as a bitmap and send the resulting bitmap to the printer\
\>", "TableText"]}
  }]]]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->31486],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"\"\<GraphicsPrintingFormat\>\"", "->", "\"\<Automatic\>\""}]], 
  "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"\"\<GraphicsPrintingFormat\>\"", "->", "\"\<Automatic\>\""}]], 
  "InlineFormula"],
 " on Windows and Macintosh, and to ",
 Cell[BoxData[
  RowBox[{"\"\<GraphicsPrintingFormat\>\"", "->", "\"\<Automatic\>\""}]], 
  "InlineFormula"],
 " on Unix."
}], "Notes",
 CellID->5996],

Cell[TextData[{
 Cell[BoxData[
 "\"\<IncludePostScriptResourceDirectives\>\""], "InlineFormula"],
 " is typically set from the ",
 StyleBox["Print", "DialogElementName"],
 " dialog box."
}], "Notes",
 CellID->21006],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<IncludeSpecialFonts\>\"", "->", "\"\<True\>\""}]], 
  "InlineFormula"],
 ", the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " fonts are included with the print output."
}], "Notes",
 CellID->4761],

Cell[TextData[{
 "You can force the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " fonts to be excluded from the print output by setting ",
 Cell[BoxData[
  RowBox[{"\"\<IncludeSpecialFonts\>\"", "->", "\"\<False\>\""}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->24339],

Cell[TextData[{
 Cell[BoxData["\"\<IncludeSpecialFonts\>\""], "InlineFormula"],
 " is typically set from the ",
 StyleBox["Print", "DialogElementName"],
 " dialog box."
}], "Notes",
 CellID->28928],

Cell[TextData[{
 Cell[BoxData["\"\<Magnification\>\""], "InlineFormula"],
 " is specified as a number. The default setting ",
 Cell[BoxData[
  RowBox[{"\"\<Magnification\>\"", "->", "1"}]], "InlineFormula"],
 " corresponds to the page being printed at its original size."
}], "Notes",
 CellID->12315],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"\"\<PageFooterMargins\>\"", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " are given in printer\[CloseCurlyQuote]s points, specifies the vertical \
margin below the footer of the left- and right-facing pages, respectively. If \
the ",
 Cell[BoxData["\"\<FacingPages\>\""], "InlineFormula"],
 " option is set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", then the right header margin value is used for all pages."
}], "Notes",
 CellID->17235],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"\"\<PageHeaderMargins\>\"", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 StyleBox[", where ", "Text"],
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 StyleBox[" and ", "Text"],
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 StyleBox[" are given in ", "Text"],
 "printer\[CloseCurlyQuote]s",
 StyleBox[" points, ", "Text"],
 "specifies the vertical margin above the header of the left- and \
right-facing pages, respectively. If the ",
 Cell[BoxData["\"\<FacingPages\>\""], "InlineFormula"],
 " option is set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", then the right header margin value is used for all pages."
}], "Notes",
 CellID->19071],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<PageSize\>\"", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["w", "TI"], ",", 
     StyleBox["h", "TI"]}], "}"}]}]], "InlineFormula"],
 StyleBox[" ", "TR"],
 "specifies the width and height of the page in printer\[CloseCurlyQuote]s \
points, where 72 points equal one inch."
}], "Notes",
 CellID->6963],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData["\"\<PageSize\>\""], "InlineFormula"],
 " override those for the similar option ",
 Cell[BoxData["\"\<PaperSize\>\""], "InlineFormula"],
 ". By using a value of ",
 Cell[BoxData["\"\<PageSize\>\""], "InlineFormula"],
 " smaller than ",
 Cell[BoxData["\"\<PaperSize\>\""], "InlineFormula"],
 ", for example, you can simulate how a notebook would look when printed on \
smaller pages."
}], "Notes",
 CellID->15454],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<PaperOrientation\>\"", "->", "\"\<Portrait\>\""}]], 
  "InlineFormula"],
 ", the paper is assumed to be oriented vertically."
}], "Notes",
 CellID->3388],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<PaperOrientation\>\"", "->", "\"\<Landscape\>\""}]], 
  "InlineFormula"],
 ", the paper is assumed to be oriented horizontally."
}], "Notes",
 CellID->29430],

Cell[TextData[{
 Cell[BoxData["\"\<PaperOrientation\>\""], "InlineFormula"],
 " can also be set using the dialog box accessed from the ",
 StyleBox[ButtonBox["File",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FileMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Printing Settings",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/PrintingSettings"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Page Setup",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/PageSetup"], "MenuName"],
 " menu item."
}], "Notes",
 CellID->6266],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<PaperSize\>\"", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["w", "TI"], ",", 
     StyleBox["h", "TI"]}], "}"}]}]], "InlineFormula"],
 " specifies the width and height of the page in printer\[CloseCurlyQuote]s \
points, where 72 points equal one inch."
}], "Notes",
 CellID->17605],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<PostScriptOutputFile\>\"", "->", "\"\<Automatic\>\""}]], 
  "InlineFormula"],
 ", the file name is the same as that of the notebook being printed, with the \
extension .nb replaced by .ps."
}], "Notes",
 CellID->18065],

Cell[TextData[{
 Cell[BoxData["\"\<PostScriptOutputFile\>\""], "InlineFormula"],
 " is relevant only when the option ",
 Cell[BoxData["\"\<UsePostScriptOutputFile\>\""], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "; that is, when the PostScript output is saved as a file. Whether the \
output is sent to a printer or not depends on the setting of ",
 Cell[BoxData["\"\<UseUnixShellPrintingCommand\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->21903],

Cell[TextData[{
 Cell[BoxData["\"\<PostScriptOutputFile\>\""], "InlineFormula"],
 " is typically set from the ",
 StyleBox["Print", "DialogElementName"],
 " dialog box."
}], "Notes",
 CellID->12832],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<PrintCellBrackets\>\"", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", cell brackets in a notebook are not printed even if they are visible on \
screen."
}], "Notes",
 CellID->27584],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<PrintingMargins\>\"", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["l", "TI"], ",", 
       StyleBox["r", "TI"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["b", "TI"], ",", 
       StyleBox["t", "TI"]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies the margins at the left, right, bottom, and top of the page in \
printer\[CloseCurlyQuote]s points, where 72 points equal one inch."
}], "Notes",
 CellID->19738],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<PrintMultipleHorizontalPages\>\"", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", text that extends beyond the width of a page is not printed. The extra \
text is cut off when the paper width is reached."
}], "Notes",
 CellID->18888],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<PrintMultipleHorizontalPages\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", any text that extends beyond the width of a regular page is printed on a \
separate page. As many supplementary pages are printed as are necessary to \
contain the entire additional text. The extra pages have decimal page \
numbers, for example, 1.1, 1.2, 1.3, and so on."
}], "Notes",
 CellID->20282],

Cell[TextData[{
 "You can simulate how a notebook would look when printed on paper of a \
particular size by adjusting the option ",
 Cell[BoxData["\"\<PageSize\>\""], "InlineFormula"],
 ". With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<PrintRegistrationMarks\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", trim marks are printed at the corners of the simulated page, making the \
boundaries of the page easier to visualize."
}], "Notes",
 CellID->29534],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<PrintRegistrationMarks\>\"", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", no trim marks are printed."
}], "Notes",
 CellID->13496],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<PrintSelectionHighlighting\>\"", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", selected elements of a notebook do not appear highlighted in print."
}], "Notes",
 CellID->17867],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<RestPagesFooter\>\"", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", no footers are printed from the second page onward. This option \
complements the option ",
 Cell[BoxData["\"\<FirstPageFooter\>\""], "InlineFormula"],
 ", which specifies whether headers are printed on the first page."
}], "Notes",
 CellID->14302],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<RestPagesFooter\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", footers are printed from the second page onward. The content of the \
footers is determined by the setting for the option ",
 Cell[BoxData[
  ButtonBox["PageFooters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PageFooters"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17331],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<RestPagesHeader\>\"", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", no headers are printed from the second page onward. This option \
complements the option ",
 Cell[BoxData["\"\<FirstPageHeader\>\""], "InlineFormula"],
 ", which specifies whether headers are printed on the first page."
}], "Notes",
 CellID->17470],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<RestPagesHeader\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", headers are printed from the second page onward. The content of the \
headers is determined by the setting for the option ",
 Cell[BoxData[
  ButtonBox["PageHeaders",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PageHeaders"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14320],

Cell[TextData[{
 "Any Unix system command can be specified by typing a string into the text \
field next to ",
 Cell[BoxData["\"\<UnixShellPrintingCommand\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->6288],

Cell[TextData[{
 "This option is relevant only when the option ",
 Cell[BoxData["\"\<UseUnixShellPrintingCommand\>\""], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12412],

Cell[TextData[{
 Cell[BoxData["\"\<UnixShellPrintingCommand\>\""], "InlineFormula"],
 " is typically set from the ",
 StyleBox["Print", "DialogElementName"],
 " dialog box."
}], "Notes",
 CellID->13441],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<UsePostScriptOutputFile\>\"", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the output generated by a ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " command is not saved as a PostScript file. Whether the output is sent to a \
printer or not depends on the setting for ",
 Cell[BoxData["\"\<UseUnixShellPrintingCommand\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->6530],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<UsePostScriptOutputFile\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the output generated by a ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " command is saved as a PostScript file."
}], "Notes",
 CellID->23037],

Cell[TextData[{
 Cell[BoxData["\"\<UsePostScriptOutputFile\>\""], "InlineFormula"],
 " is typically set from the ",
 StyleBox["Print", "DialogElementName"],
 " dialog box."
}], "Notes",
 CellID->16902],

Cell[TextData[{
 Cell[BoxData["\"\<UseUnixShellPrintingCommand\>\""], "InlineFormula"],
 " is typically set from the ",
 StyleBox["Print", "DialogElementName"],
 " dialog box."
}], "Notes",
 CellID->26035]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10297],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageFooters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageFooters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageHeaders",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageHeaders"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowCellBracket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowCellBracket"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2673]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PrintingOptions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 58.8738682}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PrintingOptions -> {opt_1 -> val_1, opt_2 -> val_2, ...} is an option \
that specifies settings for printing.", "synonyms" -> {"printing options"}, 
    "title" -> "PrintingOptions", "type" -> "Symbol", "uri" -> 
    "ref/PrintingOptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 813, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1436, 46, 53, 1, 70, "ObjectName",
 CellID->29436],
Cell[1492, 49, 218, 6, 70, "AwaitingReviewNote",
 CellID->283734131],
Cell[1713, 57, 900, 28, 70, "Usage",
 CellID->30106]
}, Open  ]],
Cell[CellGroupData[{
Cell[2650, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3128, 107, 71, 1, 70, "Notes",
 CellID->8544],
Cell[3202, 110, 8504, 217, 70, "3ColumnTableMod",
 CellID->13851],
Cell[11709, 329, 395, 12, 70, "Notes",
 CellID->22264],
Cell[12107, 343, 380, 11, 70, "Notes",
 CellID->23973],
Cell[12490, 356, 894, 23, 70, "Notes",
 CellID->14979],
Cell[13387, 381, 318, 9, 70, "Notes",
 CellID->2855],
Cell[13708, 392, 355, 10, 70, "Notes",
 CellID->30127],
Cell[14066, 404, 671, 16, 70, "Notes",
 CellID->10797],
Cell[14740, 422, 345, 10, 70, "Notes",
 CellID->21540],
Cell[15088, 434, 671, 16, 70, "Notes",
 CellID->21725],
Cell[15762, 452, 157, 5, 70, "Notes",
 CellID->6150],
Cell[15922, 459, 733, 15, 70, "2ColumnTableMod",
 CellID->31486],
Cell[16658, 476, 473, 15, 70, "Notes",
 CellID->5996],
Cell[17134, 493, 215, 7, 70, "Notes",
 CellID->21006],
Cell[17352, 502, 281, 10, 70, "Notes",
 CellID->4761],
Cell[17636, 514, 284, 10, 70, "Notes",
 CellID->24339],
Cell[17923, 526, 197, 6, 70, "Notes",
 CellID->28928],
Cell[18123, 534, 300, 7, 70, "Notes",
 CellID->12315],
Cell[18426, 543, 795, 25, 70, "Notes",
 CellID->17235],
Cell[19224, 570, 880, 27, 70, "Notes",
 CellID->19071],
Cell[20107, 599, 353, 11, 70, "Notes",
 CellID->6963],
Cell[20463, 612, 464, 12, 70, "Notes",
 CellID->15454],
Cell[20930, 626, 229, 7, 70, "Notes",
 CellID->3388],
Cell[21162, 635, 225, 7, 70, "Notes",
 CellID->29430],
Cell[21390, 644, 648, 16, 70, "Notes",
 CellID->6266],
Cell[22041, 662, 334, 10, 70, "Notes",
 CellID->17605],
Cell[22378, 674, 294, 8, 70, "Notes",
 CellID->18065],
Cell[22675, 684, 558, 14, 70, "Notes",
 CellID->21903],
Cell[23236, 700, 198, 6, 70, "Notes",
 CellID->12832],
Cell[23437, 708, 325, 10, 70, "Notes",
 CellID->27584],
Cell[23765, 720, 525, 16, 70, "Notes",
 CellID->19738],
Cell[24293, 738, 376, 10, 70, "Notes",
 CellID->18888],
Cell[24672, 750, 516, 12, 70, "Notes",
 CellID->20282],
Cell[25191, 764, 536, 13, 70, "Notes",
 CellID->29534],
Cell[25730, 779, 267, 9, 70, "Notes",
 CellID->13496],
Cell[26000, 790, 320, 9, 70, "Notes",
 CellID->17867],
Cell[26323, 801, 452, 12, 70, "Notes",
 CellID->14302],
Cell[26778, 815, 493, 15, 70, "Notes",
 CellID->17331],
Cell[27274, 832, 452, 12, 70, "Notes",
 CellID->17470],
Cell[27729, 846, 493, 15, 70, "Notes",
 CellID->14320],
Cell[28225, 863, 212, 6, 70, "Notes",
 CellID->6288],
Cell[28440, 871, 298, 10, 70, "Notes",
 CellID->12412],
Cell[28741, 883, 202, 6, 70, "Notes",
 CellID->13441],
Cell[28946, 891, 591, 17, 70, "Notes",
 CellID->6530],
Cell[29540, 910, 423, 14, 70, "Notes",
 CellID->23037],
Cell[29966, 926, 201, 6, 70, "Notes",
 CellID->16902],
Cell[30170, 934, 205, 6, 70, "Notes",
 CellID->26035]
}, Closed]],
Cell[CellGroupData[{
Cell[30412, 945, 311, 9, 70, "SeeAlsoSection",
 CellID->10297],
Cell[30726, 956, 721, 26, 70, "SeeAlso",
 CellID->2673]
}, Open  ]],
Cell[31462, 985, 29, 0, 70, "History"],
Cell[31494, 987, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

