(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27877,        707]
NotebookOptionsPosition[     24178,        587]
NotebookOutlinePosition[     25862,        634]
CellTagsIndexPosition[     25744,        628]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Displaying and Printing Mathematica Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DisplayingAndPrintingMathematicaNotebooks"], 
          "Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"], 
          "Styles and the Inheritance of Option Settings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StylesAndTheInheritanceOfOptionSettings"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Displaying and Printing Mathematica Notebooks\"\>", 
       2->"\<\"Options for Notebooks\"\>", 
       3->"\<\"Styles and the Inheritance of Option Settings\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ScreenStyleEnvironment" :> 
          Documentation`HelpLookup["paclet:ref/ScreenStyleEnvironment"], 
          "StyleDefinitions" :> 
          Documentation`HelpLookup["paclet:ref/StyleDefinitions"], 
          "NotebookPrint" :> 
          Documentation`HelpLookup["paclet:ref/NotebookPrint"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ScreenStyleEnvironment\"\>", 
       2->"\<\"StyleDefinitions\"\>", 
       3->"\<\"NotebookPrint\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PrintingStyleEnvironment", "ObjectName",
 CellID->5462],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PrintingStyleEnvironment",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PrintingStyleEnvironment"]], "InlineFormula"],
     "\[LineSeparator]is an option for notebooks which specifies the style \
environment to be used in printing the notebook on paper. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3472]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Style environments appropriate for printed output are typically substantially \
denser than those appropriate for on\[Hyphen]screen display. \
\>", "Notes",
 CellID->32502]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->541775841],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->592774425],

Cell["Open a notebook file:", "ExampleText",
 CellID->974687872],

Cell[BoxData[
 RowBox[{
  RowBox[{"docpath", "=", 
   RowBox[{"{", 
    RowBox[{
    "$InstallationDirectory", ",", "\"\<Documentation\>\"", ",", 
     "\"\<English\>\"", ",", "\"\<System\>\"", ",", "\"\<ExampleData\>\""}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->499770701],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookOpen", "[", 
    RowBox[{"ToFileName", "[", 
     RowBox[{"docpath", ",", "\"\<document.nb\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->821303488],

Cell[TextData[{
 "Check the current setting of ",
 Cell[BoxData[
  ButtonBox["PrintingStyleEnvironment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrintingStyleEnvironment"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->867810384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"nb", ",", "PrintingStyleEnvironment"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->374171681],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PrintingStyleEnvironment", "\[Rule]", "\<\"Printout\"\>"}], 
  "}"}]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->110258230]
}, Open  ]],

Cell[TextData[{
 "This is how the printed page looks with the ",
 Cell[BoxData["\"\<Printout\>\""], "InlineFormula"],
 " style environment:"
}], "ExampleText",
 CellID->43887934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookPrint", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<printout-test.pdf\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->462562497],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
  CellFrame->True,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellFrameMargins->0,
  ImageSize->{245, 320},
  ImageMargins->0]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->360692176]
}, Open  ]],

Cell[TextData[{
 "Change ",
 Cell[BoxData[
  ButtonBox["PrintingStyleEnvironment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrintingStyleEnvironment"]], "InlineFormula"],
 " to change the appearance of the printout:"
}], "ExampleText",
 CellID->954439747],

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"PrintingStyleEnvironment", "\[Rule]", "\"\<Presentation\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->4312829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookPrint", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<present-test.pdf\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->40450146],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\
eJzlXF2oXUcV3t37/NzfkKRJ81AhaW1VtCj+0FIqihT1RelDRAs+SCxC+lCU
tPXhQrEUfKj3xZZYuCCGIjamamvbU/+S2gMNtMSQ+BC4gZqHEsWXazDYPsf9
zaxv9jezZ59zcpNrHzxw7j57Zs1aa9Zas9aaNXvfrx545OB3HjrwyIMPHNj3
5UMHvnfwwQce3vel7x6qm6obiqJ4tyhuuGdfgd9X6lv7825x5coVdP4fXj7i
Lv3ioYePuV/4vv23fxarP/5jMbS+9fWLoQ/f9QsXi4p9Fy/EfRfXra9XXKh/
s/3i+fVF96PCz+Llp1bdXSltBB1YG4YfeTmGU5SEO3ryaDE6PYrg1ltw/Rru
1RpuLKxeKObZ9+rJYjQ+HU1xjrjq6a+uvhzjF5F8zUtyHy5lceLP54rFYu2n
4+Jfl/5TPPbES060uIdYv3jfmvsN8WKUink0aujjC35Km8H43Kli4/Kl0Dc+
N67vN0obeqq+vXR5I3Sf/v0oiOfkr46GdmoN/UoK95VBvHqyDT8+HcPjnvAj
6SP8KIEfRfDjDHzThmliuhQ1VMO+HuFFVRuXLhfjU+ca+KMn2/hT0db3Xxe1
1YipEWjtpVfOVK5hEJSUXL2eKwdNpGUXsaDHeKKxYJZaQqaSLm9suPWCNXL8
Z2uu7dwb4763txqKyFOtwioMqsZNqJYuCVX/XTm20qk36CSV68qxpyN4LDHq
ATpJ9bby9LEYvtZtgB+fi/GXkCR7Vai64NqaK21RYenRk3EpUotefYNIfc6W
Ni6DD4qKpsXutePPh6mvHV+Lhj5f35NZaKzWkFhFFTTnR8dwUBzhcI92v+59
G5Y2lAnVEU6XPOGgrtorOJUGsXpPkcCN28usVh35C3C15baWlyxHzsPE5pSk
6kR7RmG/+OWbUBSdJEegGb/gL70Sq6DAhqvNrq+FqesLkq+d5cCIoQld7LYh
c9aNyAT548soVVPwznzoRL5qzbhSBWCogblU9x0xmCPBwWMSAaYW/+oRH3xw
xT0nPTRWEJwganwZqGohmYP7jIlG/WK89gYuFOr6RvisDYdSRdSFvbEbIWW7
aU3DCyO8hhC2HZW2BXEpTCAIB1tD9I3GCutmS5vNd+4xlAcPHmyZ+/r6euES
wvruNx78TlPDaDRyXSsrK8X+/ftdK65oD86t7gPao0f9THH/gkdzl1FYW1sL
FIYybKO2MVyTYXfagiF1UKwpcCRuOToZ+QV6qZogmoGB03thgng+l2H0ZuNi
5Ylzxf5vhbVXgu5X6CmMQ1zv9ag+b13gEqRxN2/yxodt+EJs9T39CSQITJ6u
zeRIk2hiKNCWGfiPBp/UpEO0VUgCM8PdnLQRbj4D1zcuKMkw+5qJpYwxDTNt
O9UKdgZDoqFQj7y/++67Ayk1POcDVldpaKXR0xnQDHA9cRZR4N4n76+5x29K
rv4w3hd3vFGsn/93NLRJcZvV4F3ocuCEuiM3uKoJcBxmVDqIfrBxmiPGlE5M
i3WwGHfOFFfygntdrRiNsZWpL8cDpct2z08VLdPSxusSB36Rtldh/fHjt4f5
6ZxS2pzL23+/4BTxoxcPu2utDvrWVHsg1TMvyVVIGFv/keHU5NQBkQN271LT
6wfB4xtPfhAEiq+4FNoDGYF15pgHU16nbnnUUw0bqNrC4DwOHvprsC5AchpO
o37V+cjAtadcJldyABBd6oEDWdrNJPtZ1D1bSBAAtYnfwEtPVYnnIoyw5EWx
I+JSf9P4VYjar+xUiXDb06icIeEXrmQt5wdq1nuZbok5OT+4W41mzhkEDEeD
CMHdgoBQq2hOqmaKa3Z/VQV/1XjggXNWiAK4jv7wD471E9gV0FCLOd/Ee65l
rluNorZEvGuqnHuJZzXMuibMHveMYRhHtD1zn6pJkuUV8KDIrCI13FR93tDx
a9fU6el9uqY6XVPboMxicgZFz1RbwjSDqsTI4yBbRb5zYMJOcwXNJ0qwyyhM
/+WH4W8vWq7BVhovQHvxyUSYW8zIsrWpm2GJK3H682LipEEWGKtyPNAIdCmz
n0shKKaKchEOUa9NlG5xNtpg6GCKglmTyk2e1/u8864R/dw3ZLPEDxlN7Myw
QyNN263tEZrEb0nnrfQLUlIprdSC0WltrG5jrkJRc8E1sXwxRJJpmRV+/3YK
J6WpNqn6+JJBLy0ZMJtQQyslT0lDdt1TiXiIKRLPYqCNrTDqFlri0DoGROYZ
W27VMuCQQLnLuQSbl1xPXXcne4PADr/GSm7TnmoPnFB73ErrSqCW6rYXJ1jg
Zi93eZ2B+rKbNfgBffLArI9Swj1+Q39YXs41aPKhrsn7ZLT0wiBznKW78TNO
adJN1+26oyHW0pN0SAA2yDIeaPSCr7aYrbG4cZzo3BHuhYVoytNE0uCqAi7g
8G3DFm72A983RCW2wWKGccU2WKWtB5JW5ybCDW2eHSDvRXsUF899GpfjPJb2
BLpgPaXX0EVPP0wT5GJxDwKhZGxpmQPBVRRNVbktfd+3LWIz1Q4NIUM6RU2y
UFiknCqiQAepbfVv7sFIkLLHb8oMsmkYH4Z7lW0jz5C89iNaAGo2fXMtRSjx
Gq5K2DW9MMlJRxlLZefE+4EB5TininRGnCmXbEYVRM0rQCJVzIdmgKTK5tIq
GzfXjxYC1yE3vF25eMvKPLI9WRNj+SU1X6aa6j9Tq+gg1DgxQ55jWCWhfPil
3u+WjHkH6feKXgzs8pubXqKXqz5W9VXu2c4LAf/Nbz/roJzokvHTD67efOvt
UFkPB1fDVrZAfTUupwr6g3x9bFmYKSC4OOZtT+UZO8OlsMVWWedij93TZ6Q+
uRXWqGLVG4NnOE81c8jSWIxwpurXcOYl4327+jhBrZJIUdHWE1LefhcjQWQw
dwbhxif5NlWCx72tS8id+rV7+illK3aBvVRAKp9McColFUwtRYxy90Sj7zrz
i5P7riPb2MuHs8eR2ZAsEdpgOg8NImqnnAhFxHtfHmjj0fsqiSgs2xEHYZlv
JMZV2WZTg3pG2WnqoVhS6TSzu9n9TlGrH54UF7pWFt29wjY7kt2RpFJcaVaW
689JOc2B1B+Gpx8k64v7crJZito6Mj5Ny3JGuCs292s6Mc2ady0DnotOSlla
KcqOkJqoNHSo2qWi0vs0J4uSrkEI6sqFcxWAW46oaKKUm0CccVbRGLYpDrWH
FDc3NWprKo3ULmI6ffV6Cb1eOl2aXppAN7lRg66dhubNuZcIPSKVk0JjyR0m
Ea32esVNsORPB686aPxrFfifmprloli8yQ6xdikbanKpssWXXMWDe+kktywb
MnNRxM8kMB7tztYhSZcLlGw3h5qT6/D3XdmwF9Uwm0zEhr2nE5XuHNL+WeTc
aPfGKIlRR8023GNsbpqphLQeok7e5pWzHKtzbrZ+NKXyyVK01qx5IK0HwnwA
Qs9Yf+ApTKqQIgTA1+tuIFRIm2K0YfUS/0Swv7EVAVmW5T0KgdRo7gCW5To9
DCVs7gp8PBhNjyNZjO2iRSuIn62Yz5VR+dBAuH98ugBxz1jKvitTarsLQUMk
lF6tHN997LjUGtZ1DmjX0gH0gkGbKLvOjLVsqwecQ5OeHPd1TiKSXr4CTfHk
K9DtPaVWoNPDP81kaYylU3PmyE2L7Bzs23ZGlqRnW5wvjwP51E56gGnj0wNL
FZ8cbs0mvn62Qs4NCMXWmORCmMVYyuO0E3q+mo3OM6rcQxs8AyOcrR9W5HNV
9yUxmNxyG1t5GJ/Hr82Tbl29RBa2PF8d179fE5ybfPg34y5AoamD43tiIp3c
thX1mva2tf2oqiW2r8cEshuFYbRRADo1QYpHncpr16bNKVHyrSmOOncCVw99
cxPDgsm0vROXRHPumn8Yx/ni0XTviPtUeZO8oy1pS2TiJd3wVIVwirtXlI2F
rnO4VMU8kQclusjOyodRZJt/mpTpu38kQtNIfWSPDw+NrotL+JRh1lzq9ald
zvT6rscXqzFhpl50Y++9956DQB+CFCb8zjvvBLMgTrQBHh997MBvKDFyT7TB
BwxaNRemNwYuZkSgm6OnvxsascAP6xKLReD1t9NNjzELHyWl9RNNRohDvL7P
rhfccHAMtPiNz9mzZx0KDLM2v9G4MUxYT/9x1QdT0gnnSKD9J92TZRTUiMny
rcKpDlLS3pzB6N4gc0icSxDsAD+ESb2hrQvnJFqq15SGTtM/s9ILykG/e9gT
gz7ubomS0mWGyHaIAnBaw2UCz2faGMk10cBvSF/3spwOxnZpk/Q4zQyNZ6ZZ
7R0OK+ZoE44osC9dqEyhz58/H6wdbYSBZPDRRQmuqICuhQraVLjSIx8h2++l
JCZMlIGLFoS751Kvtc+AlKPnJnjJ23E560D/5+8OflB4ZczYLTGEe+5bMnD+
vaHiNuvSwLvL2rTAdGsG7imPwi/dbeGJUlCgs2bs5G9eBZaBkI7PF759Msxa
Bc1HY4D6epss9y9KLdfmpbM9OuaAZXEjTg71KeQMC57LbWEIuef+nHt7kuZs
rJrio/lclK5yzcn1MZXyMFQC+awTPT2ufNKbbQrrxbwQjcGcWFZS+KCVfniq
jVtE7+Wb9CgmPYjaeA4V0PWiLreGIbNB1NxiYrHFp4JSsDEjGeZ+KHL0dOfD
ZpNa46Ih536fC9h+VDNjcLcjTV+pVBVLNYK7Hm+GAF0KdHil8aVtESp/YMtY
w9jBKZCtFgc7QzWQ6SEpjO0JJs6YIiNq/ra6kQkw5wlyBdx+pq0SmaRtWsi/
0Yy96+kIjN+ewf9kzKLm0epm2MYUhmscd3szbWUG3zZrYxLmTge3wMfvNU7V
u7pKv7dg+h7qMefGrISD214wdXNWfrn0oipNaB4Ehbwf1Js6lMSrvWZbOTdI
bPgt1bYyeBo+w8Jlljor2obfEaLF783V/7C/cYTNQ3bEpaW+a6HeS6kfbvmw
5eAAVPbqJHIOw7Oy3HIejFwYY09vBbUzUHq6zes3hL1KHq6ZhcPd7ijnegaZ
tt6McNeC75mYzWnuZ5Bp62fGDq4zvme2wHV9wLjiKZV9+7YOuBHTvQHrL0zq
/Z52e7TX0LRULQZt3FvQCK3Nb952hCYMQcuZM2dCkq9DT5/2b1nqJoC/n40n
R47twzfHuInGlb+5LQP2aM/ebJhJBFsUHrKRAnd4pRs819r1Aa3s2fi8bTzU
n0Xy1GPz8wNj3JiBMOeq+61EfzQ1gug+kAeM1DP3ktbGN15SMUUHbcNW9+zT
ok1iKiw26PsjWkjwc9qdpYYP7JIqpv/mrp4FB4qLzjHG3Ry0+Hf98krDeIo+
mV2y4nrSjI+lpEzKszpr3rRL1pzftizp8mqVBtJl6LJkr0iVVliZw4CN3Xzz
EoRtcreZ86KZQY6YPxDk3iDfaW06PXur/HabudYOag66sfQcVYq1/vx6C/zl
1SaF8avdZaZNJ8QAWmbaXo/RTkvtcycWk7YAWj79nZKaDzstZpDpntmjBtRy
8Nx8KiItLjDL4PgmW6nCOL9r88xxL046TV/zlkLYTGodASDNnrpB3qRW1w15
P0KOloZIU3LRF2UpGXVZPPG3PeUjqoP4rcjc0SquWnJU7nJjtQyRbtG9K1ps
7TeZ6rFNd+HRETTdi2fCe0tWBXEtt5qAGjXln3uzltZMKTyqQp8L2yaqSmtL
rtyMzrloD073I3t4LWSwZsuMmdYXW+YnAxVdKhxHHBivb2QRljGJOxyeSaNN
q9lbTUNTXXpqPryouZ/w8n0v/49lfNJipk3fvaaTsQgYnNUVe1WzaN69xteW
1yFbXqxlq1y4WNWI9NGdR3Ne/2DG8igI1uhUOFoC7slYCr3K4OvPCJej+1lR
gBY1zX736Cx6Ib21FDe3x0rPSJXBNtxVoJwJlO/FqVWsNE9/KOjueG2zWErH
qQ9PJVUPqfqxOam5lL6vXXChJ8sWXEwNtKkO6lKzmU59cSbqcYgaRsagp+u+
Nu//2YYG+1C3XIzygLT8rtfGbw9b7brofJRdCM4msc+UPc/dICInBchSHDm9
MrczMsRjGbaY1sMAlRXtJUFjspoPpPjwnRwohMn4ifaD9tt45ibiCf/bJs7P
NMdSmdkTxv7k7KbIl6nM0hqXtndV2ESNGp+ZAVZJcW13OKNIc5lrIFxMpsx/
XkJoTJkOgAtFy3lCPX2nTg9b0gTMoagSWrhqVpZy27Thbz/U6GbgrWfmjSZG
7QQk1UrMQYwxgPZzWDorqXrVXT4jwmbwVDKzCXDRC0/N+1oM9JNqlZJbinFu
C7VOqiEtlTLG6QaGnsaH34VOulpmvU509b+m6A5CH5ziOuFCpytRH05Xp36Z
lWiO80+CtMdwSeiY9pZqKcKd40/jQJjaDteFD5e1gjKBT9vIdnyyuj2slLSi
rXjS0MQ0a2z/eYBHyipOut0ZcOgDZFQ0jyfJtj1IGzntfthBamjPbfNzidKs
5fFZx3a3NYuW4W4sr4bVffyPjATTQ8UV/vuZuFtGp90Jcv6vYipad+v+OLAX
8Vz/7mi+wwv/Funl5q5WU65mn6v35+r4/czYXNvV4mOc9HUK74gVH776eJJW
mbg/YO6t+J3N1wBVJ/wgghca/Mc7enxN05CXipQrvrmlqQlntS3DXd2+bEPS
yWKIqXErKnwfFnnEG9xlV4rUnFgf2OKjh3zUjFXY49PQLoWownce9FlAZvry
8N2J6RjxodfCN30qLDlmmYpxELJUrQG7FxMxz17kHWZBGMtSy0N8SpV2z0CB
6wRZLmXaDPz2pAsfV5zmGOY0+P5pgmm8n0+czX5x6dNfwOOuzm57tVdTp/F4
zKdqfLaoHcx5SivEMQozD8LvU4p/KRS/OFzRMZ1jwHZU/XsnWu7kb6Y/RoH/
ZEtf49AXWhkd+N/ztCJCG625OLXlmihu+C+jRqHT\
\>"], "Graphics",
  CellFrame->True,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellFrameMargins->0,
  ImageSize->{244, 315},
  ImageMargins->0]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->285611710]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11643],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScreenStyleEnvironment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScreenStyleEnvironment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StyleDefinitions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StyleDefinitions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookPrint"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26390]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->374],

Cell[TextData[{
 ButtonBox["Displaying and Printing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DisplayingAndPrintingMathematicaNotebooks"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DisplayingAndPrintingMathematicaNotebooks"],
  FontSlant->"Italic"],
 ButtonBox[" Notebooks",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DisplayingAndPrintingMathematicaNotebooks"]
}], "Tutorials",
 CellID->1806],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->232099468],

Cell[TextData[ButtonBox["Styles and the Inheritance of Option Settings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StylesAndTheInheritanceOfOptionSettings"]], "Tutorials",
 CellID->138461839]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PrintingStyleEnvironment - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 0.1239002}", "context" -> "System`", 
    "keywords" -> {
     "style for printing", "printing style environment", "printout style"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "PrintingStyleEnvironment is an option for notebooks which specifies the \
style environment to be used in printing the notebook on paper. ", 
    "synonyms" -> {"printing style environment"}, "title" -> 
    "PrintingStyleEnvironment", "type" -> "Symbol", "uri" -> 
    "ref/PrintingStyleEnvironment"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3896, 120, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->541775841]},
 "Notebook Image"->{
  Cell[6139, 211, 7682, 131, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->360692176],
  Cell[14531, 373, 7275, 124, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->285611710]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25370, 614},
 {"Notebook Image", 25511, 618}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1948, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2571, 72, 61, 1, 70, "ObjectName",
 CellID->5462],
Cell[2635, 75, 527, 14, 70, "Usage",
 CellID->3472]
}, Open  ]],
Cell[CellGroupData[{
Cell[3199, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3677, 111, 182, 4, 70, "Notes",
 CellID->32502]
}, Closed]],
Cell[CellGroupData[{
Cell[3896, 120, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->541775841],
Cell[CellGroupData[{
Cell[4281, 134, 148, 5, 70, "ExampleSection",
 CellID->592774425],
Cell[4432, 141, 64, 1, 70, "ExampleText",
 CellID->974687872],
Cell[4499, 144, 297, 9, 70, "Input",
 CellID->499770701],
Cell[4799, 155, 243, 8, 70, "Input",
 CellID->821303488],
Cell[5045, 165, 244, 8, 70, "ExampleText",
 CellID->867810384],
Cell[CellGroupData[{
Cell[5314, 177, 150, 4, 70, "Input",
 CellID->374171681],
Cell[5467, 183, 251, 8, 36, "Output",
 CellID->110258230]
}, Open  ]],
Cell[5733, 194, 178, 5, 70, "ExampleText",
 CellID->43887934],
Cell[CellGroupData[{
Cell[5936, 203, 200, 6, 70, "Input",
 CellID->462562497],
Cell[6139, 211, 7682, 131, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->360692176]
}, Open  ]],
Cell[13836, 345, 263, 8, 70, "ExampleText",
 CellID->954439747],
Cell[14102, 355, 203, 6, 70, "Input",
 CellID->4312829],
Cell[CellGroupData[{
Cell[14330, 365, 198, 6, 70, "Input",
 CellID->40450146],
Cell[14531, 373, 7275, 124, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->285611710]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21867, 504, 311, 9, 70, "SeeAlsoSection",
 CellID->11643],
Cell[22181, 515, 750, 26, 70, "SeeAlso",
 CellID->26390]
}, Open  ]],
Cell[CellGroupData[{
Cell[22968, 546, 312, 9, 70, "TutorialsSection",
 CellID->374],
Cell[23283, 557, 460, 12, 70, "Tutorials",
 CellID->1806],
Cell[23746, 571, 155, 3, 70, "Tutorials",
 CellID->232099468],
Cell[23904, 576, 202, 4, 70, "Tutorials",
 CellID->138461839]
}, Open  ]],
Cell[24121, 583, 27, 0, 70, "History"],
Cell[24151, 585, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

