(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39270,       1403]
NotebookOptionsPosition[     31875,       1150]
NotebookOutlinePosition[     33542,       1193]
CellTagsIndexPosition[     33456,       1188]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntroductionToDynamic"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Introduction to Dynamic\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Slider" :> Documentation`HelpLookup["paclet:ref/Slider"], 
          "Animator" :> Documentation`HelpLookup["paclet:ref/Animator"], 
          "StatusArea" :> Documentation`HelpLookup["paclet:ref/StatusArea"], 
          "Monitor" :> Documentation`HelpLookup["paclet:ref/Monitor"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Slider\"\>", 
       2->"\<\"Animator\"\>", 3->"\<\"StatusArea\"\>", 
       4->"\<\"Monitor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"User Interface Structuring & Layout\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ProgressIndicator", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ProgressIndicator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ProgressIndicator"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a progress indicator with setting ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " in the range 0 to 1. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ProgressIndicator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ProgressIndicator"], "[", 
       RowBox[{
        ButtonBox["Dynamic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Dynamic"], "[", 
        StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the setting to be the dynamically updated current \
value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ProgressIndicator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ProgressIndicator"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a progress indicator with range ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ProgressIndicator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ProgressIndicator"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        ButtonBox["Indeterminate",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Indeterminate"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a progress indicator with indeterminate \
range. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->115]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ProgressIndicator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProgressIndicator"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " displays in a notebook as a progress indicator going from left to right; \
it does not allow interactive modification. "
}], "Notes",
 CellID->7660],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ProgressIndicator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProgressIndicator"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    ButtonBox["Indeterminate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Indeterminate"]}], "]"}]], "InlineFormula"],
 " displays as an object which changes whenever ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " changes. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->39125269]
}], "Notes",
 CellID->13095],

Cell["The following options can be given: ", "Notes",
 CellID->9710],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the progress indicator ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style for the progress indicator ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the progress indicator ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size of the progress indicator ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->995],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ProgressIndicator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProgressIndicator"], "[", "]"}]], 
  "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ProgressIndicator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProgressIndicator"], "[", "0", "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->7705],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<ProgressIndicator\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->814130481],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->389320063],

Cell[TextData[{
 "Create a progress indicator set at ",
 Cell[BoxData[
  FormBox["0.8`", TraditionalForm]], "InlineMath"],
 " in the default range ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->258827707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProgressIndicator", "[", "0.8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150901624],

Cell[BoxData[
 ProgressIndicatorBox[0.8]], "Output",
 ImageSize->{204, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159148024]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17162],

Cell["Use the default range 0 to 1:", "ExampleText",
 CellID->56854779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ProgressIndicator", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119237216],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ProgressIndicatorBox[Dynamic[$CellContext`x]], ",", 
   SliderBox[Dynamic[$CellContext`x]]}], "}"}]], "Output",
 ImageSize->{430, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164381134]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182366407],

Cell["Use the fixed range 0 to 10:", "ExampleText",
 CellID->542856803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ProgressIndicator", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->284420359],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ProgressIndicatorBox[Dynamic[$CellContext`x], {0, 10}], ",", 
   SliderBox[Dynamic[$CellContext`x], {0, 10}]}], "}"}]], "Output",
 ImageSize->{430, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155458629]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->94653007],

Cell["\<\
Use an unknown range, and indicate change in the progress variable:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->39125269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ProgressIndicator", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "Indeterminate"}], "]"}], ",", 
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->794488],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ProgressIndicatorBox[Dynamic[$CellContext`x], Indeterminate], ",", 
   SliderBox[Dynamic[$CellContext`x], {0, 10}]}], "}"}]], "Output",
 ImageSize->{430, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->568951842]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProgressIndicator", "[", 
  RowBox[{"0.5", ",", "Indeterminate"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24533167],

Cell[BoxData[
 ProgressIndicatorBox[0.5, Indeterminate]], "Output",
 ImageSize->{204, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->340679058]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->84503160],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->407299554],

Cell["Specify a background color:", "ExampleText",
 CellID->509934955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProgressIndicator", "[", 
  RowBox[{"0.5", ",", 
   RowBox[{"ImageMargins", "\[Rule]", "10"}], ",", 
   RowBox[{"Background", "\[Rule]", "Gray"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220082059],

Cell[BoxData[
 ProgressIndicatorBox[0.5,
  Background->GrayLevel[0.5],
  ImageMargins->10]], "Output",
 ImageSize->{224, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->366501210]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->283732985],

Cell["Align with surrounding text:", "ExampleText",
 CellID->5796157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ProgressIndicator", "[", 
      RowBox[{"0.5", ",", 
       RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270175938],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   ProgressIndicatorBox[0.5,
    BaselinePosition->Top,
    ImageSize->100], "xxx", 
   ProgressIndicatorBox[0.5,
    BaselinePosition->Center,
    ImageSize->100], "xxx", 
   ProgressIndicatorBox[0.5,
    BaselinePosition->Bottom,
    ImageSize->100]}],
  Row[{
    ProgressIndicator[0.5, ImageSize -> 100, BaselinePosition -> Top], 
    ProgressIndicator[0.5, ImageSize -> 100, BaselinePosition -> Center], 
    ProgressIndicator[0.5, ImageSize -> 100, BaselinePosition -> Bottom]}, 
   "xxx"]]], "Output",
 ImageSize->{358, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64764907]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->63776260],

Cell["Add margins to the indicator:", "ExampleText",
 CellID->63449945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"ProgressIndicator", "[", 
     RowBox[{"0.5", ",", 
      RowBox[{"ImageMargins", "\[Rule]", "m"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10", ",", "15"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184867429],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    ProgressIndicatorBox[0.5,
     ImageMargins->0],
    StripOnInput->False], ",", 
   FrameBox[
    ProgressIndicatorBox[0.5,
     ImageMargins->5],
    StripOnInput->False], ",", 
   FrameBox[
    ProgressIndicatorBox[0.5,
     ImageMargins->10],
    StripOnInput->False], ",", 
   FrameBox[
    ProgressIndicatorBox[0.5,
     ImageMargins->15],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{500, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->543125306]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->203476154],

Cell["Specify the overall image size:", "ExampleText",
 CellID->57404855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ProgressIndicator", "[", 
     RowBox[{"0.7", ",", 
      RowBox[{"Background", "\[Rule]", "Gray"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "30", ",", "50"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"30", ",", "50", ",", "80", ",", "220"}], "}"}]}], "}"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13512316],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ProgressIndicatorBox[0.7,
      Background->GrayLevel[0.5],
      ImageSize->{30, 10}], 
     ProgressIndicatorBox[0.7,
      Background->GrayLevel[0.5],
      ImageSize->{50, 10}], 
     ProgressIndicatorBox[0.7,
      Background->GrayLevel[0.5],
      ImageSize->{80, 10}], 
     ProgressIndicatorBox[0.7,
      Background->GrayLevel[0.5],
      ImageSize->{220, 10}]},
    {
     ProgressIndicatorBox[0.7,
      Background->GrayLevel[0.5],
      ImageSize->{30, 30}], 
     ProgressIndicatorBox[0.7,
      Background->GrayLevel[0.5],
      ImageSize->{50, 30}], 
     ProgressIndicatorBox[0.7,
      Background->GrayLevel[0.5],
      ImageSize->{80, 30}], 
     ProgressIndicatorBox[0.7,
      Background->GrayLevel[0.5],
      ImageSize->{220, 30}]},
    {
     ProgressIndicatorBox[0.7,
      Background->GrayLevel[0.5],
      ImageSize->{30, 50}], 
     ProgressIndicatorBox[0.7,
      Background->GrayLevel[0.5],
      ImageSize->{50, 50}], 
     ProgressIndicatorBox[0.7,
      Background->GrayLevel[0.5],
      ImageSize->{80, 50}], 
     ProgressIndicatorBox[0.7,
      Background->GrayLevel[0.5],
      ImageSize->{220, 50}]}
   }],
  "Grid"]], "Output",
 ImageSize->{408, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->198792806]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->499272266],

Cell["Display the progress of a computation:", "ExampleText",
 CellID->435566907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProgressIndicator", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"100", ",", "140"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->864420970],

Cell[BoxData[
 ProgressIndicatorBox[Dynamic[$CellContext`n], {100, 140}]], "Output",
 ImageSize->{204, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1178953815]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "=", "k"}], ";", 
      RowBox[{"FactorInteger", "[", 
       RowBox[{
        RowBox[{"2", "^", "k"}], "-", "1"}], "]"}]}], ")"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "100", ",", "140"}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->350464048],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->434418523],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " to indicate activity with unknown duration:"
}], "ExampleText",
 CellID->505621380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", "0"}], ";", 
  RowBox[{"ProgressIndicator", "[", 
   RowBox[{
    RowBox[{"Dynamic", "[", "k", "]"}], ",", "Indeterminate"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115420921],

Cell[BoxData[
 ProgressIndicatorBox[Dynamic[$CellContext`k], Indeterminate]], "Output",
 ImageSize->{204, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1917312220]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"L", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", " ", "t", ",", " ", 
        "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", " ", "x", ",", "x"}],
         "]"}], " ", "+", " ", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", " ", "x", ",", " ", "y"}], "]"}], ",", " ", "y", 
         ",", " ", "y"}], "]"}], " ", "+", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "]"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"t", ",", 
        RowBox[{"-", "L"}], ",", " ", "y"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"t", ",", " ", "L", ",", " ", "y"}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"t", ",", " ", "x", ",", " ", 
        RowBox[{"-", "L"}]}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"t", ",", " ", "x", ",", " ", "L"}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"0", ",", "x", ",", " ", "y"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "^", "2"}], " ", "+", " ", 
          RowBox[{"y", "^", "2"}]}], ")"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "u", "]"}], "[", 
       RowBox[{"0", ",", "x", ",", "y"}], "]"}], " ", "\[Equal]", " ", 
      "0"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->54182063],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["EvaluationMonitor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvaluationMonitor"]], "InlineFormula"],
 " to track solution activity in numerical functions:"
}], "ExampleText",
 CellID->182492124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{"eqs", ",", " ", "u", ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"L", "/", "2"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "L"}], ",", "L"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "L"}], ",", "L"}], "}"}], ",", 
   RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
    RowBox[{"k", "++"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->211175700],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "2.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4.`"}], ",", "4.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4.`"}], ",", "4.`"}], "}"}]}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{453, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1274358305]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4634430],

Cell["Display activity indefinitely:", "ExampleText",
 CellID->887594308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProgressIndicator", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", 
    RowBox[{"Clock", "[", "Infinity", "]"}], "]"}], ",", "Indeterminate"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1382924222],

Cell[BoxData[
 ProgressIndicatorBox[Dynamic[
   Clock[Infinity]], Indeterminate]], "Output",
 ImageSize->{204, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84073978]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17742],

Cell["The zero argument case is equivalent to zero progress:", "ExampleText",
 CellID->69876031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ProgressIndicator", "[", "]"}], ",", 
   RowBox[{"ProgressIndicator", "[", "0", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179707054],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ProgressIndicatorBox[0], ",", 
   ProgressIndicatorBox[0]}], "}"}]], "Output",
 ImageSize->{430, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139403851]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3501],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Animator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StatusArea",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StatusArea"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Monitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Monitor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32525]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28264],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->183310],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->535715864],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->13271167]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ProgressIndicator - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 13.6867474}", "context" -> "System`", 
    "keywords" -> {
     "calculation delay", "delay feedback", "guesstimate", "progress display",
       "progress meter"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ProgressIndicator[x] represents a progress indicator with setting x in \
the range 0 to 1. ProgressIndicator[Dynamic[x]] takes the setting to be the \
dynamically updated current value of x. ProgressIndicator[x, {x_min, x_max}] \
represents a progress indicator with range x_min to x_max. \
ProgressIndicator[x, Indeterminate] represents a progress indicator with \
indeterminate range. ", "synonyms" -> {"progress indicator"}, "title" -> 
    "ProgressIndicator", "type" -> "Symbol", "uri" -> 
    "ref/ProgressIndicator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11007, 335, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->814130481]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33312, 1181}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2228, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2851, 81, 1582, 37, 70, "ObjectNameGrid"],
Cell[4436, 120, 2466, 77, 70, "Usage",
 CellID->115]
}, Open  ]],
Cell[CellGroupData[{
Cell[6939, 202, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7417, 219, 365, 10, 70, "Notes",
 CellID->7660],
Cell[7785, 231, 562, 19, 70, "Notes",
 CellID->13095],
Cell[8350, 252, 68, 1, 70, "Notes",
 CellID->9710],
Cell[8421, 255, 1781, 45, 70, "3ColumnTableMod",
 CellID->995],
Cell[10205, 302, 408, 16, 70, "Notes",
 CellID->7705],
Cell[10616, 320, 354, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[11007, 335, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->814130481],
Cell[CellGroupData[{
Cell[11392, 349, 148, 5, 70, "ExampleSection",
 CellID->389320063],
Cell[11543, 356, 330, 12, 70, "ExampleText",
 CellID->258827707],
Cell[CellGroupData[{
Cell[11898, 372, 115, 3, 28, "Input",
 CellID->150901624],
Cell[12016, 377, 183, 6, 40, "Output",
 CellID->159148024]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12248, 389, 216, 7, 70, "ExampleSection",
 CellID->17162],
Cell[12467, 398, 71, 1, 70, "ExampleText",
 CellID->56854779],
Cell[CellGroupData[{
Cell[12563, 403, 266, 8, 70, "Input",
 CellID->119237216],
Cell[12832, 413, 285, 9, 70, "Output",
 CellID->164381134]
}, Open  ]],
Cell[13132, 425, 125, 3, 70, "ExampleDelimiter",
 CellID->182366407],
Cell[13260, 430, 71, 1, 70, "ExampleText",
 CellID->542856803],
Cell[CellGroupData[{
Cell[13356, 435, 426, 14, 70, "Input",
 CellID->284420359],
Cell[13785, 451, 303, 9, 70, "Output",
 CellID->155458629]
}, Open  ]],
Cell[14103, 463, 124, 3, 70, "ExampleDelimiter",
 CellID->94653007],
Cell[14230, 468, 165, 4, 70, "ExampleText",
 CellID->39125269],
Cell[CellGroupData[{
Cell[14420, 476, 381, 12, 70, "Input",
 CellID->794488],
Cell[14804, 490, 309, 9, 70, "Output",
 CellID->568951842]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15162, 505, 239, 7, 70, "ExampleSection",
 CellID->16451],
Cell[CellGroupData[{
Cell[15426, 516, 149, 4, 70, "Input",
 CellID->24533167],
Cell[15578, 522, 198, 6, 70, "Output",
 CellID->340679058]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15825, 534, 221, 7, 70, "ExampleSection",
 CellID->84503160],
Cell[CellGroupData[{
Cell[16071, 545, 231, 7, 70, "ExampleSubsection",
 CellID->407299554],
Cell[16305, 554, 70, 1, 70, "ExampleText",
 CellID->509934955],
Cell[CellGroupData[{
Cell[16400, 559, 232, 6, 70, "Input",
 CellID->220082059],
Cell[16635, 567, 233, 8, 70, "Output",
 CellID->366501210]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16917, 581, 237, 7, 70, "ExampleSubsection",
 CellID->283732985],
Cell[17157, 590, 69, 1, 70, "ExampleText",
 CellID->5796157],
Cell[CellGroupData[{
Cell[17251, 595, 506, 15, 70, "Input",
 CellID->270175938],
Cell[17760, 612, 683, 21, 70, "Output",
 CellID->64764907]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18492, 639, 232, 7, 70, "ExampleSubsection",
 CellID->63776260],
Cell[18727, 648, 71, 1, 70, "ExampleText",
 CellID->63449945],
Cell[CellGroupData[{
Cell[18823, 653, 398, 13, 70, "Input",
 CellID->184867429],
Cell[19224, 668, 578, 23, 70, "Output",
 CellID->543125306]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19851, 697, 230, 7, 70, "ExampleSubsection",
 CellID->203476154],
Cell[20084, 706, 73, 1, 70, "ExampleText",
 CellID->57404855],
Cell[CellGroupData[{
Cell[20182, 711, 646, 20, 70, "Input",
 CellID->13512316],
Cell[20831, 733, 1340, 47, 70, "Output",
 CellID->198792806]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[22232, 787, 227, 7, 70, "ExampleSection",
 CellID->499272266],
Cell[22462, 796, 81, 1, 70, "ExampleText",
 CellID->435566907],
Cell[CellGroupData[{
Cell[22568, 801, 224, 7, 70, "Input",
 CellID->864420970],
Cell[22795, 810, 216, 6, 70, "Output",
 CellID->1178953815]
}, Open  ]],
Cell[23026, 819, 387, 13, 70, "Input",
 CellID->350464048],
Cell[23416, 834, 125, 3, 70, "ExampleDelimiter",
 CellID->434418523],
Cell[23544, 839, 240, 8, 70, "ExampleText",
 CellID->505621380],
Cell[CellGroupData[{
Cell[23809, 851, 235, 8, 70, "Input",
 CellID->115420921],
Cell[24047, 861, 219, 6, 70, "Output",
 CellID->1917312220]
}, Open  ]],
Cell[24281, 870, 1983, 56, 70, "Input",
 CellID->54182063],
Cell[26267, 928, 255, 8, 70, "ExampleText",
 CellID->182492124],
Cell[CellGroupData[{
Cell[26547, 940, 502, 15, 70, "Input",
 CellID->211175700],
Cell[27052, 957, 693, 24, 36, "Output",
 CellID->1274358305]
}, Open  ]],
Cell[27760, 984, 123, 3, 70, "ExampleDelimiter",
 CellID->4634430],
Cell[27886, 989, 73, 1, 70, "ExampleText",
 CellID->887594308],
Cell[CellGroupData[{
Cell[27984, 994, 228, 7, 70, "Input",
 CellID->1382924222],
Cell[28215, 1003, 222, 7, 70, "Output",
 CellID->84073978]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28486, 1016, 233, 7, 70, "ExampleSection",
 CellID->17742],
Cell[28722, 1025, 96, 1, 70, "ExampleText",
 CellID->69876031],
Cell[CellGroupData[{
Cell[28843, 1030, 200, 6, 70, "Input",
 CellID->179707054],
Cell[29046, 1038, 252, 9, 70, "Output",
 CellID->139403851]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29359, 1054, 310, 9, 70, "SeeAlsoSection",
 CellID->3501],
Cell[29672, 1065, 939, 35, 70, "SeeAlso",
 CellID->32525]
}, Open  ]],
Cell[CellGroupData[{
Cell[30648, 1105, 314, 9, 70, "TutorialsSection",
 CellID->28264],
Cell[30965, 1116, 159, 3, 70, "Tutorials",
 CellID->445434225]
}, Open  ]],
Cell[CellGroupData[{
Cell[31161, 1124, 316, 9, 70, "MoreAboutSection",
 CellID->183310],
Cell[31480, 1135, 141, 3, 70, "MoreAbout",
 CellID->535715864],
Cell[31624, 1140, 179, 3, 70, "MoreAbout",
 CellID->13271167]
}, Open  ]],
Cell[31818, 1146, 27, 0, 70, "History"],
Cell[31848, 1148, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

