(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24569,        924]
NotebookOptionsPosition[     18220,        708]
NotebookOutlinePosition[     19719,        748]
CellTagsIndexPosition[     19634,        743]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modifying Built\[Hyphen]in Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModifyingBuiltInFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Modifying Built\[Hyphen]in Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Unprotect" :> Documentation`HelpLookup["paclet:ref/Unprotect"],
           "Protected" :> 
          Documentation`HelpLookup["paclet:ref/Protected"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Unprotect\"\>", 
       2->"\<\"Protected\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Package Bulletproofing" :> 
          Documentation`HelpLookup["paclet:guide/PackageBulletproofing"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Package Bulletproofing\"\>", 
       3->"\<\"Package Development\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Protect", "ObjectName",
 CellID->20399],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Protect",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Protect"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets the attribute ",
     Cell[BoxData[
      ButtonBox["Protected",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
     " for the symbols ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Protect",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Protect"], "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"form\", \"TI\"], \"1\"]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"form\", \"TI\"], \"2\"]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]protects all symbols whose names match any of the \
string patterns ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["form", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->17162]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Protect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protect"]], "InlineFormula"],
 " allows abbreviated string patterns containing the following \
metacharacters:"
}], "Notes",
 CellID->23859],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "*", Cell[
    "zero or more characters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "@", Cell[
    "one or more characters, excluding upper-case letters", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["\\\\*, etc.", "TableText"], Cell[
    "literal *, etc.", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->439942953],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Protect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Protect"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)*\>\"", "]"}]], "InlineFormula"],
 " protects all symbols in a particular context. "
}], "Notes",
 CellID->2088]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->270990873],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->168872899],

Cell["Define and protect a function: ", "ExampleText",
 CellID->58479224],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "f", "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->458281062],

Cell["The function definition can no longer be changed: ", "ExampleText",
 CellID->115835733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"x", "+", "y"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72282556],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDelayed", "::", "\<\"write\"\>"}], ":", 
  " ", "\<\"Tag \\!\\(f\\) in \\!\\(f[\\(\\(x_, y_\\)\\)]\\) is Protected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/write\\\", \
ButtonNote -> \\\"SetDelayed::write\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->541048130],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->159752086]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->799520895],

Cell["Protect several symbols", "ExampleText",
 CellID->24259263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Protect", "[", 
  RowBox[{"f", ",", "g", ",", "h"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23952930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"f\"\>", ",", "\<\"g\"\>", ",", "\<\"h\"\>"}], "}"}]], "Output",\

 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20572319]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->496871568],

Cell["Protect all symbols matching a string pattern:", "ExampleText",
 CellID->117005208],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f1", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f2", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "3"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->163840732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Protect", "[", "\"\<f*\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->598269100],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"f1\"\>", ",", "\<\"f2\"\>"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->126283100]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->193965480],

Cell["Protect all symbols in the current context:", "ExampleText",
 CellID->94617937],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "3"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->195537977],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "\"\<`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->112854032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", 
  RowBox[{"{", 
   RowBox[{"f", ",", "g"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26976993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "Protected", "}"}], ",", 
   RowBox[{"{", "Protected", "}"}]}], "}"}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->290236593]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->275459409],

Cell[TextData[{
 "Protecting a symbol is equivalent to setting the ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->52594906],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Protect", "[", "f", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"g", ",", "Protected"}], "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->634542146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", 
  RowBox[{"{", 
   RowBox[{"f", ",", "g"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->491598477],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "Protected", "}"}], ",", 
   RowBox[{"{", "Protected", "}"}]}], "}"}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72258698]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "f", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ClearAttributes", "[", 
   RowBox[{"g", ",", "Protected"}], "]"}], ";"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->105125778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", 
  RowBox[{"{", 
   RowBox[{"f", ",", "g"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->78016570],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->819929432]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->552686897],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Protect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protect"]], "InlineFormula"],
 " returns the list of symbols actually protected:"
}], "ExampleText",
 CellID->571371264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Protect", "[", 
  RowBox[{"f", ",", "g"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29120263],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"f\"\>", ",", "\<\"g\"\>"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13074990]
}, Open  ]],

Cell["If a symbol is already protected, it is not protected again:", \
"ExampleText",
 CellID->538643784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Protect", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->761928964],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45552738]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204894777],

Cell["No more definitions can be made for a protected symbol:", "ExampleText",
 CellID->339100066],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->230977323],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "f", "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90568818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->265663274],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDelayed", "::", "\<\"write\"\>"}], ":", 
  " ", "\<\"Tag \\!\\(f\\) in \\!\\(f[x_]\\) is Protected.\"\>"}]], "Message",\
 "MSG",
 CellID->93335215],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->58518755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->387880631],

Cell[TextData[{
 "To protect all symbols given in a variable, use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->29372840],

Cell[BoxData[
 RowBox[{
  RowBox[{"syms", "=", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g", ",", "h"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->520700977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Protect", "[", 
  RowBox[{"Evaluate", "[", "syms", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->601487310],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"f\"\>", ",", "\<\"g\"\>", ",", "\<\"h\"\>"}], "}"}]], "Output",\

 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->421219522]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->261815148],

Cell[BoxData[
 RowBox[{"{", "Protected", "}"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->461489203]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18596],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unprotect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unprotect"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Protected",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Protected"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13094]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7413],

Cell[TextData[ButtonBox["Modifying Built\[Hyphen]in Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ModifyingBuiltInFunctions"]], "Tutorials",
 CellID->22418]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->33829236],

Cell[TextData[ButtonBox["Package Bulletproofing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageBulletproofing"]], "MoreAbout",
 CellID->201019738],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->684903873]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Protect - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 17.7493514}", "context" -> "System`", 
    "keywords" -> {
     "security", "unwritable", "write protection", "overwrite protection", 
      "write-protect", "lock definition", "prevent redefinition"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Protect[s_1, s_2, ...] sets the attribute Protected for the symbols s_i. \
Protect[\"SubscriptBox[ form, \\\"1\\\"]\", \"SubscriptBox[ form, \
\\\"2\\\"]\", ...] protects all symbols whose names match any of the string \
patterns form_i. ", "synonyms" -> {}, "title" -> "Protect", "type" -> 
    "Symbol", "uri" -> "ref/Protect"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6130, 196, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->270990873]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19491, 736}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2162, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2785, 81, 45, 1, 70, "ObjectName",
 CellID->20399],
Cell[2833, 84, 1587, 50, 70, "Usage",
 CellID->17162]
}, Open  ]],
Cell[CellGroupData[{
Cell[4457, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4935, 156, 243, 8, 70, "Notes",
 CellID->23859],
Cell[5181, 166, 603, 13, 70, "2ColumnTableMod",
 CellID->439942953],
Cell[5787, 181, 306, 10, 70, "Notes",
 CellID->2088]
}, Closed]],
Cell[CellGroupData[{
Cell[6130, 196, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->270990873],
Cell[CellGroupData[{
Cell[6515, 210, 148, 5, 70, "ExampleSection",
 CellID->168872899],
Cell[6666, 217, 73, 1, 70, "ExampleText",
 CellID->58479224],
Cell[6742, 220, 229, 8, 70, "Input",
 CellID->458281062],
Cell[6974, 230, 93, 1, 70, "ExampleText",
 CellID->115835733],
Cell[CellGroupData[{
Cell[7092, 235, 169, 6, 70, "Input",
 CellID->72282556],
Cell[7264, 243, 395, 7, 70, "Message",
 CellID->541048130],
Cell[7662, 252, 164, 5, 36, "Output",
 CellID->159752086]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7875, 263, 220, 7, 70, "ExampleSection",
 CellID->799520895],
Cell[8098, 272, 65, 1, 70, "ExampleText",
 CellID->24259263],
Cell[CellGroupData[{
Cell[8188, 277, 135, 4, 70, "Input",
 CellID->23952930],
Cell[8326, 283, 238, 8, 36, "Output",
 CellID->20572319]
}, Open  ]],
Cell[8579, 294, 125, 3, 70, "ExampleDelimiter",
 CellID->496871568],
Cell[8707, 299, 89, 1, 70, "ExampleText",
 CellID->117005208],
Cell[8799, 302, 275, 10, 70, "Input",
 CellID->163840732],
Cell[CellGroupData[{
Cell[9099, 316, 112, 3, 70, "Input",
 CellID->598269100],
Cell[9214, 321, 221, 7, 36, "Output",
 CellID->126283100]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9484, 334, 227, 7, 70, "ExampleSection",
 CellID->193965480],
Cell[9714, 343, 85, 1, 70, "ExampleText",
 CellID->94617937],
Cell[9802, 346, 273, 10, 70, "Input",
 CellID->195537977],
Cell[10078, 358, 130, 4, 70, "Input",
 CellID->112854032],
Cell[CellGroupData[{
Cell[10233, 366, 152, 5, 70, "Input",
 CellID->26976993],
Cell[10388, 373, 268, 9, 36, "Output",
 CellID->290236593]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10705, 388, 237, 7, 70, "ExampleSection",
 CellID->275459409],
Cell[10945, 397, 243, 8, 70, "ExampleText",
 CellID->52594906],
Cell[11191, 407, 223, 7, 70, "Input",
 CellID->634542146],
Cell[CellGroupData[{
Cell[11439, 418, 153, 5, 70, "Input",
 CellID->491598477],
Cell[11595, 425, 267, 9, 36, "Output",
 CellID->72258698]
}, Open  ]],
Cell[11877, 437, 227, 7, 70, "Input",
 CellID->105125778],
Cell[CellGroupData[{
Cell[12129, 448, 152, 5, 70, "Input",
 CellID->78016570],
Cell[12284, 455, 241, 9, 36, "Output",
 CellID->819929432]
}, Open  ]],
Cell[12540, 467, 125, 3, 70, "ExampleDelimiter",
 CellID->552686897],
Cell[12668, 472, 223, 7, 70, "ExampleText",
 CellID->571371264],
Cell[CellGroupData[{
Cell[12916, 483, 125, 4, 70, "Input",
 CellID->29120263],
Cell[13044, 489, 218, 7, 36, "Output",
 CellID->13074990]
}, Open  ]],
Cell[13277, 499, 105, 2, 70, "ExampleText",
 CellID->538643784],
Cell[CellGroupData[{
Cell[13407, 505, 103, 3, 70, "Input",
 CellID->761928964],
Cell[13513, 510, 174, 6, 36, "Output",
 CellID->45552738]
}, Open  ]],
Cell[13702, 519, 125, 3, 70, "ExampleDelimiter",
 CellID->204894777],
Cell[13830, 524, 98, 1, 70, "ExampleText",
 CellID->339100066],
Cell[13931, 527, 145, 5, 70, "Input",
 CellID->230977323],
Cell[14079, 534, 120, 4, 70, "Input",
 CellID->90568818],
Cell[CellGroupData[{
Cell[14224, 542, 145, 5, 70, "Input",
 CellID->265663274],
Cell[14372, 549, 185, 5, 70, "Message",
 CellID->93335215],
Cell[14560, 556, 163, 5, 36, "Output",
 CellID->58518755]
}, Open  ]],
Cell[14738, 564, 125, 3, 70, "ExampleDelimiter",
 CellID->387880631],
Cell[14866, 569, 230, 8, 70, "ExampleText",
 CellID->29372840],
Cell[15099, 579, 172, 6, 70, "Input",
 CellID->520700977],
Cell[CellGroupData[{
Cell[15296, 589, 141, 4, 70, "Input",
 CellID->601487310],
Cell[15440, 595, 239, 8, 36, "Output",
 CellID->421219522]
}, Open  ]],
Cell[CellGroupData[{
Cell[15716, 608, 106, 3, 70, "Input",
 CellID->261815148],
Cell[15825, 613, 188, 6, 36, "Output",
 CellID->461489203]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16074, 626, 311, 9, 70, "SeeAlsoSection",
 CellID->18596],
Cell[16388, 637, 455, 17, 70, "SeeAlso",
 CellID->13094]
}, Open  ]],
Cell[CellGroupData[{
Cell[16880, 659, 313, 9, 70, "TutorialsSection",
 CellID->7413],
Cell[17196, 670, 172, 3, 70, "Tutorials",
 CellID->22418]
}, Open  ]],
Cell[CellGroupData[{
Cell[17405, 678, 299, 8, 70, "MoreAboutSection"],
Cell[17707, 688, 131, 3, 70, "MoreAbout",
 CellID->33829236],
Cell[17841, 693, 155, 3, 70, "MoreAbout",
 CellID->201019738],
Cell[17999, 698, 149, 3, 70, "MoreAbout",
 CellID->684903873]
}, Open  ]],
Cell[18163, 704, 27, 0, 70, "History"],
Cell[18193, 706, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

