(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24468,        779]
NotebookOptionsPosition[     20378,        646]
NotebookOutlinePosition[     21807,        685]
CellTagsIndexPosition[     21722,        680]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading and Writing Mathematica Files: Basics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"], 
          "Running External Programs" :> 
          Documentation`HelpLookup["paclet:tutorial/RunningExternalPrograms"],
           "Reading and Writing Mathematica Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ReadingAndWritingMathematicaFiles"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Reading and Writing Mathematica Files: Basics\"\>", 
       2->"\<\"Running External Programs\"\>", 
       3->"\<\"Reading and Writing Mathematica Files\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PutAppend" :> Documentation`HelpLookup["paclet:ref/PutAppend"],
           "OpenAppend" :> Documentation`HelpLookup["paclet:ref/OpenAppend"], 
          "Export" :> Documentation`HelpLookup["paclet:ref/Export"], "Save" :> 
          Documentation`HelpLookup["paclet:ref/Save"], "Definition" :> 
          Documentation`HelpLookup["paclet:ref/Definition"], "DumpSave" :> 
          Documentation`HelpLookup["paclet:ref/DumpSave"], "Get" :> 
          Documentation`HelpLookup["paclet:ref/Get"], "NotebookPut" :> 
          Documentation`HelpLookup["paclet:ref/NotebookPut"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PutAppend\"\>", 
       2->"\<\"OpenAppend\"\>", 3->"\<\"Export\"\>", 4->"\<\"Save\"\>", 
       5->"\<\"Definition\"\>", 6->"\<\"DumpSave\"\>", 7->"\<\"Get\"\>", 
       8->"\<\"NotebookPut\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"], 
          "Mathematica Expressions in Files" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaExpressionsInFiles"], 
          "Mathematica Session History" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessionHistory"], 
          "MathLink API" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkAPI"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"External Operations\"\>", 
       2->"\<\"File Operations\"\>", 3->"\<\"Files\"\>", 
       4->"\<\"Mathematica Expressions in Files\"\>", 
       5->"\<\"Mathematica Session History\"\>", 
       6->"\<\"MathLink API\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "Put ",
     StyleBox["(>>)", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["expr", "TI"], ">>", 
       StyleBox["filename", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]writes ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to a file. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Put",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Put"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", "\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes a sequence of expressions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to a file. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Put",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Put"], "[", "\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]creates an empty file with the specified name."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->24216]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
On systems with advanced graphical interfaces, there will usually be \
graphical tools for saving expressions in files. \
\>", "Notes",
 CellID->12823],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Put",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Put"]], "InlineFormula"],
 " starts writing output at the beginning of the file. It deletes whatever \
was previously in the file. "
}], "Notes",
 CellID->9188],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Put",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Put"]], "InlineFormula"],
 " inserts a newline (line feed) at the end of its output. "
}], "Notes",
 CellID->24777],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], ">>", 
   StyleBox["filename", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], ">>", "\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\""}]], "InlineFormula"],
 ". The double quotes can be omitted if the file name is of the form \
specified in ",
 ButtonBox["Operator Input Forms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InputSyntax#23301"],
 ". "
}], "Notes",
 CellID->11687],

Cell[TextData[{
 "It is conventional to use names that end with ",
 Cell[BoxData[
  RowBox[{".", "m"}]], "InlineFormula"],
 " for files containing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. "
}], "Notes",
 CellID->19736],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Put",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Put"]], "InlineFormula"],
 " by default writes expressions in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27287],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Put",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Put"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["OutputForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OutputForm"], "[", 
     StyleBox["expr", "TI"], "]"}], ",", "\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " generates ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13530]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->495205980],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->423396694],

Cell["Save a computed value in a temporary file:", "ExampleText",
 CellID->108668988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"47", "!"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96690981],

Cell[BoxData["258623241511168180642964355153611979969197632389120000000000"], \
"Output",
 ImageSize->{465, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->294807615]
}, Open  ]],

Cell["Set the current directory to one for temporary files:", "ExampleText",
 CellID->67667722],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "$TemporaryPrefix", "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->87637484],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Put",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Put"]], "InlineFormula"],
 " the value of ",
 Cell[BoxData["a"], "InlineFormula"],
 " into a file:"
}], "ExampleText",
 CellID->779040954],

Cell[BoxData[
 RowBox[{"a", ">>", "\"\<fortysevenfactorial\>\""}]], "Input",
 CellLabel->"In[3]:=",
 CellID->163369602],

Cell["The file now contains the value:", "ExampleText",
 CellID->356982034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<fortysevenfactorial\>\"", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->389730913],

Cell["258623241511168180642964355153611979969197632389120000000000", "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->117840644]
}, Open  ]],

Cell["Reset the directory: ", "ExampleText",
 CellID->454605972],

Cell[BoxData[
 RowBox[{
  RowBox[{"ResetDirectory", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->119717613]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10181],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PutAppend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PutAppend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenAppend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenAppend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Save",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Save"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Definition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Definition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DumpSave",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DumpSave"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookPut",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookPut"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22212]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27454],

Cell[TextData[{
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"],
  FontSlant->"Italic"],
 ButtonBox[" Files: Basics",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"]
}], "Tutorials",
 CellID->20535],

Cell[TextData[ButtonBox["Running External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RunningExternalPrograms"]], "Tutorials",
 CellID->29134],

Cell[TextData[{
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Files",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"]
}], "Tutorials",
 CellID->8378]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->69904727],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->589625089],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->323049957],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->54253720],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaExpressionsInFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions in Files",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaExpressionsInFiles"]
}], "MoreAbout",
 CellID->54483672],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessionHistory"],
  FontSlant->"Italic"],
 ButtonBox[" Session History",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessionHistory"]
}], "MoreAbout",
 CellID->60562921],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
  FontSlant->"Italic"],
 ButtonBox[" API",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]
}], "MoreAbout",
 CellID->753781111]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Put (>>) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 23.5463748}", "context" -> "System`", 
    "keywords" -> {
     "files", "output", "overwriting files", "pipes", "printing expressions", 
      "put", "saving", "writing"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "expr >> filename writes expr to a file. Put[expr_1, expr_2, ..., \" \
filename\"] writes a sequence of expressions expr_i to a file. Put[\"filename\
\"] creates an empty file with the specified name.", "synonyms" -> {">>"}, 
    "title" -> "Put", "type" -> "Symbol", "uri" -> "ref/Put"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12780, 354, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->495205980]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21578, 673}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3598, 76, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4221, 103, 4255, 86, 70, "ObjectNameGrid"],
Cell[8479, 191, 1480, 47, 70, "Usage",
 CellID->24216]
}, Open  ]],
Cell[CellGroupData[{
Cell[9996, 243, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10474, 260, 161, 4, 70, "Notes",
 CellID->12823],
Cell[10638, 266, 259, 8, 70, "Notes",
 CellID->9188],
Cell[10900, 276, 214, 7, 70, "Notes",
 CellID->24777],
Cell[11117, 285, 511, 17, 70, "Notes",
 CellID->11687],
Cell[11631, 304, 239, 9, 70, "Notes",
 CellID->19736],
Cell[11873, 315, 319, 12, 70, "Notes",
 CellID->27287],
Cell[12195, 329, 548, 20, 70, "Notes",
 CellID->13530]
}, Closed]],
Cell[CellGroupData[{
Cell[12780, 354, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->495205980],
Cell[CellGroupData[{
Cell[13165, 368, 148, 5, 70, "ExampleSection",
 CellID->423396694],
Cell[13316, 375, 85, 1, 70, "ExampleText",
 CellID->108668988],
Cell[CellGroupData[{
Cell[13426, 380, 110, 4, 28, "Input",
 CellID->96690981],
Cell[13539, 386, 220, 6, 36, "Output",
 CellID->294807615]
}, Open  ]],
Cell[13774, 395, 95, 1, 70, "ExampleText",
 CellID->67667722],
Cell[13872, 398, 140, 4, 70, "Input",
 CellID->87637484],
Cell[14015, 404, 237, 9, 70, "ExampleText",
 CellID->779040954],
Cell[14255, 415, 119, 3, 70, "Input",
 CellID->163369602],
Cell[14377, 420, 75, 1, 70, "ExampleText",
 CellID->356982034],
Cell[CellGroupData[{
Cell[14477, 425, 131, 3, 70, "Input",
 CellID->389730913],
Cell[14611, 430, 141, 2, 70, "Print",
 CellID->117840644]
}, Open  ]],
Cell[14767, 435, 64, 1, 70, "ExampleText",
 CellID->454605972],
Cell[14834, 438, 123, 4, 70, "Input",
 CellID->119717613]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15006, 448, 311, 9, 70, "SeeAlsoSection",
 CellID->10181],
Cell[15320, 459, 1915, 71, 70, "SeeAlso",
 CellID->22212]
}, Open  ]],
Cell[CellGroupData[{
Cell[17272, 535, 314, 9, 70, "TutorialsSection",
 CellID->27454],
Cell[17589, 546, 458, 12, 70, "Tutorials",
 CellID->20535],
Cell[18050, 560, 159, 3, 70, "Tutorials",
 CellID->29134],
Cell[18212, 565, 428, 12, 70, "Tutorials",
 CellID->8378]
}, Open  ]],
Cell[CellGroupData[{
Cell[18677, 582, 318, 9, 70, "MoreAboutSection",
 CellID->69904727],
Cell[18998, 593, 149, 3, 70, "MoreAbout",
 CellID->589625089],
Cell[19150, 598, 141, 3, 70, "MoreAbout",
 CellID->323049957],
Cell[19294, 603, 121, 3, 70, "MoreAbout",
 CellID->54253720],
Cell[19418, 608, 309, 9, 70, "MoreAbout",
 CellID->54483672],
Cell[19730, 619, 296, 9, 70, "MoreAbout",
 CellID->60562921],
Cell[20029, 630, 254, 9, 70, "MoreAbout",
 CellID->753781111]
}, Open  ]],
Cell[20298, 642, 50, 0, 70, "History"],
Cell[20351, 644, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

