(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    148191,       3803]
NotebookOptionsPosition[    136209,       3385]
NotebookOutlinePosition[    137855,       3427]
CellTagsIndexPosition[    137768,       3422]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Statistics" :> 
          Documentation`HelpLookup["paclet:tutorial/BasicStatistics"], 
          "Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:tutorial/DescriptiveStatistics"], 
          "Discrete Distributions" :> 
          Documentation`HelpLookup["paclet:tutorial/DiscreteDistributions"], 
          "Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Basic Statistics\"\>", 
       2->"\<\"Descriptive Statistics\"\>", 
       3->"\<\"Discrete Distributions\"\>", 
       4->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Median" :> Documentation`HelpLookup["paclet:ref/Median"], 
          "Quartiles" :> Documentation`HelpLookup["paclet:ref/Quartiles"], 
          "Ordering" :> Documentation`HelpLookup["paclet:ref/Ordering"], 
          "Variance" :> Documentation`HelpLookup["paclet:ref/Variance"], 
          "MedianDeviation" :> 
          Documentation`HelpLookup["paclet:ref/MedianDeviation"], 
          "InterquartileRange" :> 
          Documentation`HelpLookup["paclet:ref/InterquartileRange"], "Sort" :> 
          Documentation`HelpLookup["paclet:ref/Sort"], "ListInterpolation" :> 
          Documentation`HelpLookup["paclet:ref/ListInterpolation"], "Nearest" :> 
          Documentation`HelpLookup["paclet:ref/Nearest"], "InverseCDF" :> 
          Documentation`HelpLookup["paclet:ref/InverseCDF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Median\"\>", 2->"\<\"Quartiles\"\>",
        3->"\<\"Ordering\"\>", 4->"\<\"Variance\"\>", 
       5->"\<\"MedianDeviation\"\>", 6->"\<\"InterquartileRange\"\>", 
       7->"\<\"Sort\"\>", 8->"\<\"ListInterpolation\"\>", 
       9->"\<\"Nearest\"\>", 10->"\<\"InverseCDF\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exploratory Data Analysis" :> 
          Documentation`HelpLookup["paclet:guide/DataClassification"], 
          "Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Statistical Distributions" :> 
          Documentation`HelpLookup["paclet:guide/StatisticalDistributions"], 
          "Statistics" :> Documentation`HelpLookup["paclet:guide/Statistics"],
           "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Exploratory Data Analysis\"\>", 
       2->"\<\"Descriptive Statistics\"\>", 3->"\<\"Numerical Data\"\>", 
       4->"\<\"Statistical Distributions\"\>", 5->"\<\"Statistics\"\>", 
       6->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Quantile", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Quantile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Quantile"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox[
        RowBox[{
         StyleBox["q", "TI"], "\[Null]"}]], "th"]], "InlineFormula"],
     " quantile of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Quantile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Quantile"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["q", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["q", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of quantiles ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["q", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["q", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " . "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Quantile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Quantile"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["q", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            StyleBox["a", "TI"], ",", 
            StyleBox["b", "TI"]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            StyleBox["c", "TI"], ",", 
            StyleBox["d", "TI"]}], "}"}]}], "}"}]}], "]"}]], "InlineFormula"],
     
     "\[LineSeparator]uses the quantile definition specified by parameters ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Quantile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Quantile"], "[", 
       RowBox[{
        StyleBox["dist", "TI"], ",", 
        StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a quantile of the symbolic distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->31474]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Sort",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sort"], "[", 
    RowBox[{
     StyleBox["list", "TI"], ",", 
     ButtonBox["Less",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Less"]}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{
     ButtonBox["Ceiling",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ceiling"], "[", 
     RowBox[{
      StyleBox["q", "TI"], 
      RowBox[{
       ButtonBox["Length",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Length"], "[", 
       StyleBox["list", "TI"], "]"}]}], "]"}], "]"}], "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->13064],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Quantile", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["q", "TI"]}], "]"}], ",", 
    RowBox[{"Quantile", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["q", "TI"]}], "]"}]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30651],

Cell[TextData[{
 "For a list of length ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["q", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["d", "TI"]}], "}"}]}], "}"}]}], "]"}]], "InlineFormula"],
 " depends on ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   RowBox[{
    StyleBox["a", "TI"], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["n", "TI"], "+", 
       StyleBox["b", "TI"]}], ")"}], 
     StyleBox["q", "TI"]}]}]}]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is an integer, the result is ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "[", 
   RowBox[{"[", 
    StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "=", 
   RowBox[{
    ButtonBox["Sort",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sort"], "[", 
    RowBox[{
     StyleBox["list", "TI"], ",", 
     ButtonBox["Less",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Less"]}], "]"}]}]], "InlineFormula"],
 ". Otherwise the result is ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["s", "TI"], "[", 
    RowBox[{"[", 
     RowBox[{
      ButtonBox["Floor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Floor"], "[", 
      StyleBox["x", "TI"], "]"}], "]"}], "]"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       StyleBox["s", "TI"], "[", 
       RowBox[{"[", 
        RowBox[{
         ButtonBox["Ceiling",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Ceiling"], "[", 
         StyleBox["x", "TI"], "]"}], "]"}], "]"}], "-", 
      RowBox[{
       StyleBox["s", "TI"], "[", 
       RowBox[{"[", 
        RowBox[{
         ButtonBox["Floor",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Floor"], "[", 
         StyleBox["x", "TI"], "]"}], "]"}], "]"}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["c", "TI"], "+", 
      RowBox[{
       StyleBox["d", "TI"], 
       RowBox[{
        ButtonBox["FractionalPart",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/FractionalPart"], "[", 
        StyleBox["x", "TI"], "]"}]}]}], ")"}]}]}]], "InlineFormula"],
 ", with the indices taken to be 1 or ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " if they are out of range. "
}], "Notes",
 CellID->22385],

Cell[TextData[{
 "The default choice of parameters is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4304],

Cell["Common choices of parameters include:", "Notes",
 CellID->30047],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["{{0, 0}, {1, 0}}", "MR"],
      " "
     }]], Cell["inverse empirical CDF (default) "]},
    {Cell[TextData[{
      StyleBox["{{0, 0}, {0, 1}}", "MR"],
      " "
     }]], Cell["linear interpolation (California method) "]},
    {Cell[TextData[{
      StyleBox["{{1/2, 0}, {0, 0}}", "MR"],
      " "
     }]], Cell[TextData[{
      "element numbered closest to ",
      Cell[BoxData[
       FormBox[
        StyleBox[
         RowBox[{"q", "n"}], "TI"], TraditionalForm]], "InlineFormula"],
      " "
     }]]},
    {Cell[TextData[{
      StyleBox["{{1/2, 0}, {0, 1}}", "MR"],
      " "
     }]], Cell["linear interpolation (hydrologist method) "]},
    {Cell[TextData[{
      StyleBox["{{0, 1}, {0, 1}}", "MR"],
      " "
     }]], Cell["\<\
mean\[Hyphen]based estimate (Weibull method) \
\>"]},
    {Cell[TextData[{
      StyleBox["{{1, -1}, {0, 1}}", "MR"],
      " "
     }]], Cell["mode\[Hyphen]based estimate "]},
    {Cell[TextData[{
      StyleBox["{{1/3, 1/3}, {0, 1}}", "MR"],
      " "
     }]], Cell["median\[Hyphen]based estimate "]},
    {Cell[TextData[{
      StyleBox["{{3/8, 1/4}, {0, 1}}", "MR"],
      " "
     }]], Cell["normal distribution estimate "]}
   },
   GridBoxAlignment->{
    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
     "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], TraditionalForm]], "Notes",\

 CellID->1819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " always gives a result equal to an element of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32610],

Cell[TextData[{
 "The same is true whenever ",
 Cell[BoxData[
  RowBox[{
   StyleBox["d", "TI"], "=", "0"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2829],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  RowBox[{
   StyleBox["d", "TI"], "=", "1"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " is piecewise linear as a function of ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21434],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"1", "/", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6935],

Cell["\<\
About ten different choices of parameters are in use in statistical work. \
\>", "Notes",
 CellID->29570],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->26286]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8710012],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->92663316],

Cell["Find the half-way value (median) of a list:", "ExampleText",
 CellID->14190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}],
     "}"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28219],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306873090]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12951],

Cell["Find the quarter-way value (lower quartile) of a list:", "ExampleText",
 CellID->3613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}],
     "}"}], ",", 
   RowBox[{"1", "/", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24768],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59972703]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25408],

Cell["Lower and upper quartiles:", "ExampleText",
 CellID->32646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "4"}], ",", 
     RowBox[{"3", "/", "4"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32147],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "6"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->497475858]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->136480203],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["q", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " quantile for a normal distribution:"
}], "ExampleText",
 CellID->235162839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->856663451],

Cell[BoxData[
 RowBox[{"\[Mu]", "+", 
  RowBox[{
   SqrtBox["2"], " ", "\[Sigma]", " ", 
   RowBox[{"InverseErf", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "q"}]}], "]"}]}]}]], "Output",
 ImageSize->{189, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6441995]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12596],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " works with any real numeric quantities:"
}], "ExampleText",
 CellID->13924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"E", ",", "Pi", ",", 
     RowBox[{"Sqrt", "[", "2", "]"}], ",", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "}"}], ",", 
   RowBox[{"1", "/", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->839],

Cell[BoxData[
 SqrtBox["2"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->387645858]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24209],

Cell["Find quantiles of elements in each column:", "ExampleText",
 CellID->15492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "Pi"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"3", "Pi"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16499],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "\[Pi]"}], "}"}]], "Output",
 ImageSize->{45, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106845677]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->166755903],

Cell["Find multiple quantiles of elements in each column:", "ExampleText",
 CellID->40597666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "Pi"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"3", "Pi"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"4", "/", "5"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->386975047],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Pi]", ",", 
     RowBox[{"3", " ", "\[Pi]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{120, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259718442]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->158391064],

Cell["Obtain results at any precision: ", "ExampleText",
 CellID->160553898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10", ",", "4", ",", "25", ",", "2", ",", "1"}], 
      "}"}], ",", "30"}], "]"}], ",", 
   RowBox[{"2", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190699768],

Cell[BoxData["5.`29.522878745280337"], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147795851]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650909219],

Cell["Compute results for a large vector or matrix:", "ExampleText",
 CellID->285474028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"10", "^", "6"}]}], "]"}], ",", 
   RowBox[{"1", "/", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315224713],

Cell[BoxData["0.100187154736054`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290907418]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"1", "/", "10"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594479966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.10098064004117613`", ",", "0.09994207641056074`", ",", 
   "0.09858758507315857`", ",", "0.09973781726763087`", ",", 
   "0.10069157011686625`"}], "}"}]], "Output",
 ImageSize->{364, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->68659755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5859166],

Cell["Compute results using other parametrizations:", "ExampleText",
 CellID->103907181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "10", ",", "4", ",", "25", ",", "2", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"1", "/", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->201367446],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->315338516]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "10", ",", "4", ",", "25", ",", "2", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"1", "/", "5"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->118044929],

Cell[BoxData[
 FractionBox["17", "10"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->444631779]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->811],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], ":>", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[Equal]", 
         RowBox[{"i", "+", "1"}]}]}], "\[RuleDelayed]", 
       RowBox[{"i", "-", "1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "18", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 18, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->327723661]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{"sp", ",", 
   RowBox[{"99", "/", "100"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", 
   ",", "7", ",", "8"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->161827535]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13294],

Cell[TextData[{
 "Plot the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["q", "th"], TraditionalForm]]],
 " quantile for a list:"
}], "ExampleText",
 CellID->11043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Quantile", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], 
      "}"}], ",", "q"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->764],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc9rE0EUnu5sav0PpNm2UcEe9A+wh6JSVEQ8am9KDIX2oJU2vai96r29
tCr25kEFFaHWmyexIAqiRbxFkHopgsWDp+28+bHZzLzZTHY3moaGZDJv3vfe
fDPz3sxkc6FcnZy4Vq5OVcqlszPlG5NTldnSmekZ1kR7CCE19lk6QFg9ZDX+
qYUh+zbLY6z0GICCRAEJrYRXh+K6gtCJFyBKiCVUPQcdNHmIjuPJUSj9uoaQ
gsZu0ED0at4GDIRvtJheTExJ80sNhGfh7MbId+TRXq77NMsA7y22AkOpOMM6
wjofbCNT1QfOkDpyTz+XrcyDySQe6VDNc91VrvfKb5Wl+pwOxtoVS8xOySJr
47tKn+Zxw6V15eF79iZFKOiTx58kao2jYNTfor50T/oIdL3IxROjyzKA97do
3216XS6gs1pUsyZlfdaGW5SPpOp1LUJBrAVWrZuPPFGdxmd3ss7Kx9dOJztS
wNQR5maj31Jg/wFRoMcvPmIGsK8UoaDT119K3D1ubdx/NPk4lzc3fzNHUL2f
wcp+XifYiO2Uv9SZNIIi9bXA/f0fVKex7jY+FLmX5Bm5zlbnz63A5SDgN4SP
H35I/e0Qi2UajZrdJeTdop9bLi68lf3Ph7Ycj8uXNNbzTqwtVshc4sg+OQa7
1s1HniiIpPEO4rM7WWflky5e01mp07UeiVtbf1gespOOBFBQllLSw+VQ5GF0
xBqRLkZdq/1iycvepB8KyE9xcJIrIZbJcQ9VLjOzjBbNZgO3Uqs3Z9W6+cgT
tcenvayxHRv30+xEyGhVufoU0iXgOcOyUOpPWr2AKKy3t//euvka0rXIc5a5
mquugupU2Cx/FjTWjRZQull4cpb1mymOVmuyaNW6+fj3qE5j3W18UsRq4i8j
VxswibANJ+D6u+8SecihPxj7AM/h5aX1u3feQNthDsV2mudcfrX6tQGZlH24
hS37cLRapxdWrZuPPFF7fNrLuvWYSheFSbcudytIsWdc+PL55+mxB/D4JeDP
YOq/C32nPsVT6OSc3Yg1qxeOMf9hIz07FBSB8w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->326265843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->503240723],

Cell["Plot a linearly interpolated quantile:", "ExampleText",
 CellID->82963523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Quantile", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10", ",", "4", ",", "25", ",", "2", ",", "1"}], 
      "}"}], ",", "q", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178941197],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325005407]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->223703586],

Cell["Generate a random number from a distribution:", "ExampleText",
 CellID->178539715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"ExtremeValueDistribution", "[", 
    RowBox[{"1", ",", "2"}], "]"}], ",", 
   RowBox[{"RandomReal", "[", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49740330],

Cell[BoxData["0.016877378800480014`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115310687]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8298],

Cell[TextData[{
 "With default parameters ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " always returns an element of the list:"
}], "ExampleText",
 CellID->2025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14789],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42537082]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->651399430],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Quartiles",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quartiles"]], "InlineFormula"],
 " gives linearly interpolated ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " values for a list:"
}], "ExampleText",
 CellID->38722882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->133352675],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "8.720484306483007`", ",", "7.960898357146336`", ",", "0.5355082272499323`",
    ",", "7.56985908430911`", ",", "4.389169221019815`", ",", 
   "1.3635358087154348`", ",", "4.1799062205213255`", ",", 
   "8.518375170537912`", ",", "0.8080560452847596`", ",", "4.22638983619154`",
    ",", "4.318448499048779`", ",", "2.3908899258804506`", ",", 
   "2.345682416327628`", ",", "3.5443738407546377`", ",", 
   "5.0745156807735885`", ",", "4.373744713127115`", ",", 
   "5.044308642638455`", ",", "0.628950566090658`", ",", "8.372758221594124`",
    ",", "6.806278119891747`"}], "}"}]], "Output",
 ImageSize->{436, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->501141084]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "4"}], ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"3", "/", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->155558425],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.3682861711040393`", ",", "4.346096606087947`", ",", 
   "7.1880686021004285`"}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141553801]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quartiles", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->632052870],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.3682861711040393`", ",", "4.346096606087947`", ",", 
   "7.1880686021004285`"}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->105177708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103804862],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterquartileRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterquartileRange"]], "InlineFormula"],
 " is the difference of linearly interpolated ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " values for a list:"
}], "ExampleText",
 CellID->15299726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118537781],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7.901595723056198`", ",", "3.431718825498753`", ",", "9.494557320869175`", 
   ",", "1.598316929302226`", ",", "0.2146022935606795`", ",", 
   "9.862992754615219`", ",", "7.645062380591517`", ",", "4.53809364915974`", 
   ",", "3.343069282000324`", ",", "5.784920596609837`", ",", 
   "4.12514924101953`", ",", "8.861835681819594`", ",", "9.293329343980943`", 
   ",", "0.570578536499573`", ",", "5.5455808984259285`", ",", 
   "7.43039602151462`", ",", "0.6911088610006`", ",", "6.206879202687327`", 
   ",", "1.3983745667538128`", ",", "1.2211727627660696`"}], "}"}]], "Output",\

 ImageSize->{436, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67937882]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Subtract", ",", 
   RowBox[{"Quantile", "[", 
    RowBox[{"data", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "/", "4"}], ",", 
       RowBox[{"1", "/", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23051440],

Cell[BoxData["6.274983303795838`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->604861829]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterquartileRange", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->481300380],

Cell[BoxData["6.274983303795838`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->40392708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->631682428],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["QuartileDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QuartileDeviation"]], "InlineFormula"],
 " is half the difference of linearly interpolated ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " values for a list:"
}], "ExampleText",
 CellID->533304287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->239649738],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "8.022253340400427`", ",", "5.336774748618717`", ",", "1.2518172860716303`",
    ",", "1.4649189625505987`", ",", "7.017650584235584`", ",", 
   "6.623583632119415`", ",", "7.803420864849759`", ",", "6.000034432713111`",
    ",", "5.700648094457302`", ",", "7.928638768425465`", ",", 
   "7.4297229288705635`", ",", "2.808846522247408`", ",", 
   "5.912160103508368`", ",", "2.9698222918485717`", ",", 
   "3.2053225082673653`", ",", "0.24754276792721575`", ",", 
   "3.9138966478547332`", ",", "1.3639273106697503`", ",", 
   "1.6994548918500674`", ",", "6.984273120085458`"}], "}"}]], "Output",
 ImageSize->{429, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328885261]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Apply", "[", 
   RowBox[{"Subtract", ",", 
    RowBox[{"Quantile", "[", 
     RowBox[{"data", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", "/", "4"}], ",", 
        RowBox[{"1", "/", "4"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]}], "]"}], "/", 
  "2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->501255430],

Cell[BoxData["2.3734055725558916`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->63950425]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuartileDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->333901997],

Cell[BoxData["2.3734055725558916`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->130664747]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174408474],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["QuartileSkewness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QuartileSkewness"]], "InlineFormula"],
 " uses linearly interpolated ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " values as a skewness measure:"
}], "ExampleText",
 CellID->75587225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->371742929],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7.758481032104214`", ",", "1.9355492236714689`", ",", "9.428432535797423`",
    ",", "8.45698153843951`", ",", "9.408667417054588`", ",", 
   "0.2281666312405739`", ",", "0.13976385378512868`", ",", 
   "4.964718677114195`", ",", "3.0066422457854003`", ",", 
   "4.972622635028394`", ",", "6.434157843091546`", ",", 
   "2.5549394423274197`", ",", "3.2073316057399315`", ",", 
   "5.9761014460762985`", ",", "6.297830356509461`", ",", 
   "0.5142168121007762`", ",", "3.457040756158818`", ",", 
   "2.9874209787456985`", ",", "5.334235310170827`", ",", 
   "0.35212595350881726`"}], "}"}]], "Output",
 ImageSize->{436, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164641296]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"q1", ",", "q2", ",", "q3"}], "}"}], "=", 
  RowBox[{"Quantile", "[", 
   RowBox[{"data", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "4"}], ",", 
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"3", "/", "4"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->250626437],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.2452443329994445`", ",", "4.210879716636507`", ",", 
   "6.365994099800504`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->373841244]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"q1", "-", 
    RowBox[{"2", "q2"}], "+", "q3"}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"q3", "-", "q1"}], ")"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->156230570],

Cell[BoxData["0.04598168057994627`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->629093449]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuartileSkewness", "[", "data", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->46759148],

Cell[BoxData["0.04598168057994627`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->57755007]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->683712],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["InverseCDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseCDF"]], "InlineFormula"],
 " for distributions:"
}], "ExampleText",
 CellID->958682470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"ParetoDistribution", "[", 
    RowBox[{"k", ",", "\[Alpha]"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54070942],

Cell[BoxData[
 RowBox[{"k", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "q"}], ")"}], 
   RowBox[{
    RowBox[{"-", "1"}], "/", "\[Alpha]"}]]}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102541279]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseCDF", "[", 
  RowBox[{
   RowBox[{"ParetoDistribution", "[", 
    RowBox[{"k", ",", "\[Alpha]"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26145892],

Cell[BoxData[
 RowBox[{"k", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "q"}], ")"}], 
   RowBox[{
    RowBox[{"-", "1"}], "/", "\[Alpha]"}]]}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->710722294]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12788],

Cell["1/2 quantile with two varying parameters:", "ExampleText",
 CellID->15610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Quantile", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], 
      "}"}], ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "0"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16874],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1nQmcTtX7wI0lispWlkhk7Akpst0slX2vCFmKsm+R3ViSsrYgS8gW2caa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   "], {{{}, 
     {RGBColor[0.34411691107805, 0.14555959182307163`, 0.6006782639620051], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl12IlVUUhvc5Z845M+fDyDEmkmqOElGMaDoQapQ/jKOOgTMH+wMzGA0a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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlF9ojmEYxp/Z++7zPi/KaMvyZyJZvpKtnCgtYeJAfcUopb4slCgpJc5E
42BZ7cSJlDVL/qSoKRpfDEfzJbUyYwey8idzoFjN7+pycPXd1/vc9/3c93Xf
z7eyfKJ0fE4IoQMkYDAL4Ta4lIbwCFQLIZyHF7FvgPcxhNJc/LG/gyQ6Rr4D
YDIP4RN4WBvCfBKOY38ApboQ9tWEsIPY4rwQKvDt+PRydphvJWIb+PaZfAvh
NfCfqgGew2fJ9QX+gHpOcd9q7F5wgfhOzndiLya+XvHgKLmv8+009uPo2Ivk
OID/Sfw74RH/zdgt1DOEfYSYdvgwPgsS99CqWqJ724jPK85eg3bsUc5fYo/k
7k3fzmDvImYr/vXwj/CJ3L1KgzZqP8R9xYJrXEXuRnAH/3vSELsF/1nsK4m1
6iDfTLBm6vUrPtOpe35KvueZtViH/xj2OLgKb0us1RB3La+zZsfgg/AmeDN8
EbmawV3sP9TzhrPpzNrpzl/YvzPPfhP5ypoV/s/gu1PPrki9oc4zlLZlzl+k
1lizewf/lnqG6r01s9bS4Cz2CL/NxK9Nrd0w/lOpNWyE7yV/xnkt/Bb2JDFv
E8doVxr49jf1zlzDvs/5aOIe+zUveDWxBtrdLeR/knqHddade3fks1+7CvoS
37kmdw26WzPZE62xtJUGP+A94HLimSyL3hntijRdn3ummqU06orWVFpKo6W5
NZWWM6ASvbPaVWlQ+a+RtNFMm6JnpllpZ7ZF74Bmr56WkK8e9CTWRFqcy72L
0kTa9eV+a9JwjPgq6E48o/6Cd0S7of8AnU1Ev3X5SJuDud+ONFLvU9FvVRro
7hW5e1ENelsbMv8X6I3dxB7I/Hb0n/IPh0iU2A==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4455187332341498, 0.32186997546921486`, 0.7432107918860154], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl0tsVVUUhk/v69zTe1ODIxwyMZRYKyLy6FMegWCF4AMF7q1I0JSHQEzb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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVVUUhrf1DufswwvFWKhU26gYiE2BRk2QwRZxiL7Y2kqrRW1TNAya
4EQcGmIUYmOQYKxGiSBDmX1AMQGjoZZSwBlMlZsWrlVvQUUrNkp88vuz9sOf
s/ZZe6+z9hr+dSpaH697rMg5twGkwBXeucvABFAKiiPnShLnLgfjkceB73k/
ABLkOeAMunsz6DCwlnUBbEJuTTv3fuxcd9a5bWAv8lF0ZSCN7k323Iadz3jf
AxYgD2PrTvSN2GsAy8Y5twjdf+ydi4096H9iPQx2I7ejvwF5Kb5XoZ/I2ft4
3whKkJt51oM60AS6wefsPw62Ib8gnzjXD55HLsaHv3juwb/dYCvyFjB6Kfdl
3YHNVWAB/rSw/pZzNZw5gLwZzGPv2+gXIw+y5w/063lXzfoe1p3oXgV3IT/M
u0348AH6fWBjYrE4AvpCTJZyv/t5jrF/NrY+Ak+xfhLsRx7jeRH8C/4G32G7
AmSxvYEzF5C7QDvrLaxz+HoSnACnwM/orgVx2nKm3FeA8lADsn2S75zI2jfG
2Ds1slhsZX8HPj8HnlUsE7M1Gtm3ZFO5X865ZbHVwM2x1YhqI8ee4chiolhs
ZH0T+hdZL2L9Q8pieztrn7IYl/KNCaAYTAKn2X8Yu71gKLa75yOzpRgoVgfR
HchazNLY28VzJ0gpDpHlVLl8hzNLiPdC+Us9zeLMPHTjvdXCMfTduofqJ2U1
uR8f9oEB5CkZi9XL6F+KLWZXcrYaGzNV995isYv3O7MWkza+V8VzFU04LWu9
8U1kvqhHPHI/9muwvSJlvqun9oY7zEW/mWcte/vRF3m7o+52ibda7+T8K4nV
vHIrn8pCjptDjam25ENTbDHQ3VVzN8bWY+ot3Xm+t55Vr9aCNrAYtINWUA8a
QQOoA9PDHXW3vpT1ZnPoRfWofFsDVgcfy0Cb6gNMRn6Pc4d4zuL+c8jJoHKu
nmadYO8X5IJssl7uLBe/gZaM5eQs8khi39aer5C/BrdmrKc/xcePwUHwCTis
vWB2xjjlV96NgAI4B44ojqAW/UXOT0O+DkwBU8E58DS+N6XNB9kWZ4or9Q1x
aWmoXXHqGuLzYWK1I3+HFEP21oFB5B3eviHb2719SxwnbtM3e+Qz6AWHwEpv
d9JdngF5bzZl64y3WC8UR0YWc3F5LnCBOF29VQ6uCj1WCaaDKnB94NKHwIOB
U8VdHaH3xWHigrvFb5FxQnnI6eRgU2dbwAPBhuQn2LsisncjYeZo1hQCV+WD
7+Ks82AU/Al+B+u85Ui5eS3EYmW4u2KiWTIjtt7QTPmSb3yRWK2oBsTNo1nj
anF0F7rXwXrwRmKz4EJs3K6ZUIO97axXI1emrfdmaoakrAcL2FrLekbaOP40
607WVWmbGdKdzRr3aY90+axxnfaol8YCl6unVEvHI5uVqqkdsdWMakU+VMfG
UeIm+XBHmMmaxeLMfGI9o17RjBa3DkQ2G8SxE73NfM36Em+z4q3IZpVmxruc
/TGxWTwJHE2sB1T74iTNun8imwWaeUOJcZa4Sj2qWugJtamaUK7bAlco5+JC
zUDNPnFiS2wzX7NeHNyrmQiWOOvJY4nlQLFXD+pfoCvkajjMcv0j6N9AM13c
r5mvWa8ZcI23O+uuV3vL9aPYeySynKvW1XPqNdW8uLsocKk4XHsrQy/oTC62
GaTZcyo27ssFuSHU6rpQm6rZWyKLqWIpTtOs10zXLO8Ls0z/JPoX0UwTF8wP
XCtOEDfWB24VR6qXz4deUE//D3s1TNk=
         "],
         VertexColors->None], PolygonBox[{{2437, 2006, 1574, 2996, 2436}},
         VertexColors->None]}]}, 
     {RGBColor[0.5469205553902496, 0.49818035911535813`, 0.8857433198100256], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXmMldUZxr+53/3u5d47rco6gE1lGRDTqFU2I4iGsDlIYYZNLHWhLmzW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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHm0VlUZxg+X73zfPedcRQQFZbBLgEKGQCJYIBRyEdOsIC+DqAGasBZg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         "],
         VertexColors->None], PolygonBox[{{2090, 2304, 1191, 2399, 2089}},
         VertexColors->None]}]}, 
     {RGBColor[0.6259490281195165, 0.6273881033512626, 0.9109150720273521], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmQVcUVhu9bZu5794GCxpSCSUoEJYBGEasETCoqMKLBMjgSNxSGQVRg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mwl1MYx997+/1+71aKsUSRVEIjhDZFxpJSSWNJl0pF0ZSQETJqNCYq
roRSWcpOJWso2wxpESJlF22Smlvq1k3l8/U9f3znfc55nuec55zzbG/jATf1
Gl4eRdFaUAA7kyi6qHYUbS1F0eSyKHovjaK5cRTNAe9C/wY+g65GdloxioZn
UbSXuRowDHowGATas9hs+H3zKLoWJCXP/cH6Z7P+WsZdGU9B7x/W+xn6DOTH
wb9PNjDux3gEdHf0u4GboPcj2wj9meg3xr4lzLVivJLxRMad2ft8cBL6D6N/
B/yhjG8Eo6DH8V0KloB7wTLWG4sNY8BS6H3MVSDXB/wLvYB9t4G+rL9a9jK/
FcyCHsT6G9DbDP4E68EOdCLkD/DdnpmnPbS2ZG5jbiRoiv5E9CtZazLowXgg
4yp4W8HJjL9jPBReBeM+OgP0aLACPAH/6qJ5fcE1QeYC9mjIfTyKvX0Lvptl
uvOC7+irzHegs38JxsP7BTwJvz/rXcncZaBVwe+ru9MbDwt3WMnZJoGJ4CEw
Q7rgMuQHI9+D/WphQ2/Gu0v2nZsZj0jtQ0fAn438FfDvL/muL2bdrpnv/He+
f4AtrHUf73kMezQGNUXb9EXmM8j25bITtNB7g9PAL2Bt0JcP9GfNOujXBv2g
a7ChATY8wt4NWL8fdDNsG4RsY3g/orsm895aYz06nZBZh3wlcwNYZ2Dw5wcY
t4c+HbQC7cD22D4tX9ad7ED/QvT/Qr4n4+OQaRLOMx79lcguQmch+Br6c7AA
uiqy/65Cvy36P6D/IPLfMG7NeDXj81lvV7hT3eVh8Mex9lgwBtwLypFfxPcU
+M3hnwDdAvxWtP3rOeu6EC8672Z4W0Czkn3mFXgvZ5aVzqvQczLTZxZ8ly+x
x9UF32lXdDuDC0EX8LRiFjwPfwg6m9D9K7Nv6/yvcd4XOcN6zns/c9XwasAe
sAtMAY8GecWEYn8e6w0oOAdIdkeItT0h9hTDil3FYMz4MOQPBSXonol9SL5z
CfRivnX5HgQ+g16R+k30Fl+A0czdLfmiY/Y85upjw4SSffxTeJ+EeJbMQugP
g7x8qBeyeepYLI/91ncwHpX6zZ9D9tnMdzkDnQj5sYnfdih7vJ06Byv3viU6
d05SLmoB/5QQA/L9lqATvI6gAzgHnMjcCaA+SX4O63dmjWPZ46mSfb4ZMk1z
x5Z8Umerju1LOqNkD8TOtdKZwVoZ8imYnjm2X4c/P3aMHwwuRyeN/UbKRXtj
x5py0mnotcx9XvlQuWoB/Frwh8Fvq7sAZ4A24KzMZ9TZ2oPjQfPMZ9nAdTWC
Pi6MdcbrWHtQ7lqjGJ2Wu4aodkyFbsM3Qz4FraHHY+9Pse+yZdFv8zHjj2K/
UQN06uf2Vd2Pck3bYJtyzjvILU4dq4rZi5jrknmsmJqN7ofwPwCzoB+AN0F+
HeR1VtkkW3TmFLlLdeclx9QtzN2auVYoRrLUPiVfeqzMuaUqcW5SjtnGfD3m
7oGuW+ba2RNcEmpoBbyGrDEV3uHItsmdw5S7Wodc1in4jnLaFtZurjsruubJ
t1STVIvkY51Y6xD5LPv1Kjg3fZ24FitHDUdmMLgeDAPL4TVSLBZdw36N7fPy
dfmAfKde6rPJhyrQ6Z07/+g9f0K3CUiKrlkbkUnQuQ1eWmZbqmKfXTYdnfrM
OusQ5GPuMsmca+QvDaGPzOxL8qHR7HVP7vtWTGfo/hl77dvl/7l9Sr40PXdt
qQfqhhrzArLzUq+v9+qQeg3pdiv4bRPmppT5jbszjlL3WjtLoTdKnOvVI72Z
Oacql76RObc2gH9U4hyr2rBadME1YltqG2XbVuiJYB02fQ//VGz6O3cPod5B
PU156pqtWi2bylLbJFtUo5Ubq0MuVo6sSVzzVeufK7hXrE789uoZ62TOWcpV
taF/SNzTqZebWbDtQ7HhxtxnaJe6B1HvIRvlu9MS10r58ObEPZJ6o2cKzuVt
gq8qp9+cu8dTbzcity9MStxbyie01/Dge9pTuUs1oRRymHqPHqB76EHUS20I
vZx6KvnqmsS2y2fHhhqi2jEmxPa4UGsV4/LNTYltlY8q9vSGejvF4HZQldsX
/6/JyO5OfJeKsd9jv5neSj3wyNxn1NluzW3rilCbZLN8TzlZubhuiLWRQVYx
9wJ4P/QTyjnqfVXzVOvUAz8CJmfOb6qxvaGvytz7qSasTt3zqdf7Drpp6p5J
vZJyyPexc6hy5xrob8Ge1L3/PvYcj96E3Hurfiv3ykdqhxz8Uu49tPaL0M+A
V0I/oBgcgswNmddTTv8U3q+p7dM/yLzcPi9fn5u7N1XPp15PPeqB1DbKtv2p
/1U0tz/8s5RYu1aoj4rZ+eisim279lRtUw5X7laN2wwq0WtVdM+u3nBj4thW
j6jaoTPpLKohk5S7M59dd3Bu6p5IvZD+ebTWFvWdBa95F7J3hv5TPcTbup9g
j3qyKYwfz90rqIbO0t1kHus+9C/zJfIrYv/TiNYd6W40N4fvkvD/Jp2Oqf9p
9C8jG9qmrsmqxcop/wEnpNp8
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7005028309634165, 0.7471753197051194, 0.9126146691033419], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXtwlsUVxt/3uyVfEtAiSWoh0aglIDp1xtEKWFtAHTsVIgWUi9NBLY5F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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQl1UZx9+V329/7/v+dldQsBwtdcg2RQZtRRcQkoulriCUTVMmgU1m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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7737900624999999, 0.85071925, 0.90903175], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnuUltV1xt/vm2++66goSVdqAZPVCGgFEgWMjUC81IDEoE2zxEq8Vpk0
BgJGuVhQR0cz6bKtKwtNIMSoTUFFxDAMKspgdK1gwzWSVgVJVlrExKhQtAWN
bZ+fz8Mif5w5+z3vfs/Z55y9n3355hNXzfzLGeWiKP5Tf9rU390oijdqRdFR
KoprNHZQrSR6daUohrQXRa+YFuj9IY1PFP8A9as09rDo4/X+2YqfD+VbeDaL
/zbN+57obaK7QveLvkn0O6J/Inp+6N9pjs9qrt2aZ5XGr9f4bzXe15RMov9e
8tzUbpneFX2i1ukXfUPJayMDY4PUXlL7d307R/xrK5b30/WiGKp5vlfyfm7X
eJ/oX4v+beZ8N+826tvVkmF2ZFiusYfUPqf3H2j8exofIrqkOZeI/qTom7XW
W5lzQbv30yu6S/S+yHZ1tSiurPq5lrOeVPjMrsm5DWlYVuQ8TvQo0feKPqhz
GCD6TtFvq/1Y8jwp/kGa/5aKn5nj2sxzeck06+yRzHdprqroV0X3iC5EHxJ9
r+iPiX6zZj1AB05Sf2WHz/RdjS/S83Ea/4FkuFp0j+htatPLXucOjV/ZsGx1
yTisw2fK2aMf3M9C8d6MfFp6mOYcqvZc7vy1iu/9an0/WzxHqX9J8z3cKorv
6v2/6fn68pH30Bdrng3i+Wfx/JN46uho5n9Ebb2eVxRu/aIfVT+wZJ7phfuF
4f8m+qY2THczT+2Citfcrvfb1LaIp1vv71B7pOT3e6rmoX9N7R9Lfv961Tyz
ypYVORn7jdoUfXdA/X+pfUc8X9Lz26J3id5bNX13yf2+0PDuD39F+/2zuul9
oldp7z/U3n+l/b1esV58XO83q90l+pPqX61bNvTo6IZ1qVPfzVQ7qmod5ezn
qX9H9/i+2gHNOU/t8cw5QO97tJcbtJfR+u6zaiV9O0JzVjXnIvEMF/1m3TKz
H+56esn4ga1hV+j6U+rPL9zWiZ6svqrvTuzwHiqi/7TDOnFUznGqeJ7UmuvU
Tq5ar6dHz1mDe+RuueMNmnNl4T29FtsH5GblLjoalhuZD9UtNzJ/RnP/Ud26
Pa7dsnCu2DP9AvV9WnuN2qzY2y2x8Rc0tlHtVj0/ozlGdMQmdZZr1fZovsXq
71PbKbpL/Z1q20X/seS5pMO4NqHddgMmrZc876iNrhpjirpx5g49d6t9WXx/
pfHODuPOSPC6bN0fWPYcXRq7UDzXdhiPPir64g7f68Oa4yG1r1eMZ7+vGdNO
09ipal/T+Cc0/pUO2/EqjT2mNrNiXekte03w42DNGLJV9BTta1G7bWJPbGk2
Z6Y2SfTfqb8ptgAm/UfNuLQYXAVz1T7Q+Frt/UfB1HHR8V36bqfa5yvWA+z1
HPYuWc4uGZ+/qu/mRbd/r3lmNj3PGvUXtXwXr2v8d2pLRY/R2F9En/fFBrHL
N/X+8abtC/w7UDMG7hV9edPf/gJ/0jRGbRO9o+G9n9Lmu8A/vqv37S3b1FLR
x7asA2DC3tj4Vvxtxff2nNrzYFPJujy4Yn0eLbq/bMwfXTL9lOhFkusJ/LHo
tWXT8/X+Gclya9PY+ITop9Xuarc9rCn7DrvRwegh823I/Pj+gZUj9vqRyhF7
/WjFNvubuvEFbHm5btwBc67T/gbV7a+3an9b0NeK9WVNzuQ5vR/VYVwAX54t
277A6UEV2zH4/ScV4/dwvTu+Yt1eWHMs8qLmrWisyLn1lb3/USX3fTmTU7S/
09RWa48H9e7nwXOwHfq2ks/8J8QThb+HXl+4590Yje0v+V7g4a4qWff58DBO
/LClbLvbXDZNLFGv+Jutf/BuXMnn/WzOfEGeuduTSpb/scJ61JtzeyJ7ZF9T
sKeq52Yf27OvTWXPz7qswfMLhf0YPNjImW0e35hxYpvNxRE/hE/8ds2+51GN
zVT/jdjdxeId2+Zzwu4ubfMZop9j4kdKxEslxwbw8s386Cx8IyMXcrBf5mYN
cABsACOIQ+bGH+Nnr6j5Hb6VsfnBli71t8WHXlYzzrA2GAlWYrPsAT58xUla
9/TIM1lj76t/r+T55mVd5uvKt8gPP/c7N9gFD2vMqHqP0xN3XR7duzjns0B6
/lbLGHWaZDtV7VMl9zzjL5ZX/YxcYBt6TWy1Uv1YjR8QPRS91pw3JjbYm/3y
/vSa7Yue57GJGbi//ZGXswNv0SWwaXiwEszcVfjsZ+T8G20+Y2ItfNuYxJkz
guHwjNfYJW3GqBm5O2SenRxhGT60zfeLjmEf8I9JTHVpYumrar6nw/fTnTPn
/G8PDv93yzEzsfNxNfte7BhbAPveFH1+zX75rJLfQ8ND661aP8GhzVWfJ+/7
ws+3/VXzDa55TuzrpeQSE0r2h9dWHa/io/BVZ1W8X54vzTmNzllhT9tiazcn
zkT3VicOAieObfO+GWfNe7KXIaEHJyZdHJ+ITW8Kbpwf7ANTtsTewZUH24xZ
nPPjiVHA1+sTi3Kn5CN/kxwE/08cgE4+EnuDZ6S++3L0jTufnXu/PbZ2XDBy
bOwCu5kbu5gYPVyZWIGYYX/wk7GF4WEcXT2o+z3UskzEUD+t2hZGtFlXwT14
V4UfudEHcr/xOWf221nzfjjD80KzL56xMez96Jpl2h8e7I531+eM0dtRZePa
bfEV6BA0uof+3FeyjWKr+DswcWf0H/mJBZeKPqbm9aBPzH7YCzbZU3Msjc6h
e+DPhtDoJPPtyvy71b9atZ8FB6GJY7Fx7Acd2haZJsY/7qh6L0OjR+DHjmAL
c7L+t/MtdrE1+9ocfw194PBz4W9/kViLfkfmAXe2xKa4N/bL2a5NPYBYgz2x
t8Fly74ne4G+tea9oG/gG3aH72D8oewJX8++6Bfmjtg7eRQxMFhIbnZt5FyY
2AAc606+xhl21bwmfnVk1mKdrqwFFm+M7qF33Be1BeI08rq90c2NuV/stydn
yL5/mnHshvlPyrq/rDruZZ3d8U2M7c45sB7fYkfkiKxHTDiwZp27Lzg/Mdg+
vOp8dVj09pvBosHJqZeIZ0TZsQmYAB7PDkZxTxOC22sSV8wLdoH10KMiP7YP
3g2N/oBLJ9ScLywONrEuWDUk2AXvsMiwJ3qLzh6WdVnO6pjY4emJJbDNEzLP
ksi8IPxDosNLoo+cycHY48D4A+QbHNwGKyYGf/ARyMX8ffFJh2MesAPdJn5D
ZxfmbMbnfFi3M/sCJ86L7wZXzgtuoNv4j7My94e1n/gXxrHvZxNXL8i3nTnD
S7IW2EUcMqXmWAQdnpa9835C5EQfwZHDOnlFdBsfOy75aXcwAbtAvy6LbjP3
hWrniv5C1TRrDsta2PWs8E9KTE0uSg6J/8PnvEQsqnhmovKI6Xp/b9P5D7kP
/nx7MPPJpvNe8iziDWIN4nZqgSubrgESH61NnvKzZvIQ8X9f40vaHPf+Kr6L
fVGroRYwvbAfm5XnK5vO5cjFOA/OhTiHekFnYX7iS/IkYuCe1AluLOyTF+T5
Ej1/Nd/Majr/JGfcpOen1Z5RO1n5yjl1n02r5VyOPO7mpnMt8qy2lvM9cj3y
p6dS8+hProwc1AbW110foK6C/0eGxzU2UPNco/Ezms5byFnYw5zCMiPf3Dz3
NF1H4Nzu1rdv1B0PY9Orsx7nRP1vamqYyxLnUwP4SMMxwlWJ89GZNxrObznP
pW2+D+5iSWhyop1qPyt8NmDp0vBQKyS2QEefyTfwk89tSP2N5/vb/J667/qa
a79g0YDkOJ/RPsZqX8fr+VPqz1R7A7tuOicnH6de8rGG46n7m66tcBfUUcEO
sO4MzXNM5pnccv6/J7UoarV9sYXJ8U2bknuhJ5wLdVXip3Prvnvu/fuJ69nH
Uo2/X3eMelbLdTFqCOe0XFOAhn9pvnmgzXvn2xGJLalRY1+DEtftjs8Eh8EH
4mawaIRk/1z04aKmaw3UGahPP1ZzjXqt6KObzvGL1JDwAaWW63roJDn383Wf
AXWeNvYWvfzX2Ah2gD38de55XWzggWDV5uhgZ3jPDPZwdl8LFuM7mO8VtZcz
z848D4pfYr9PR494T/xPToM9cE6bYncjgx+HbZj5wKL+lmtk1MfWZQ7WvCx+
Fhyb03I9iFoQ9QNqCsx1Snw72IR9YKNTs2fqHNQ3qD30p4bMeUzKu7tbrk2D
eze0XEtl/nvi87GFaYnBwNXuluvU4MO+luuY1K7+p+Xchrxmh/oXW47ru3Un
O+uOK6nnlyLfjMSY5Jjjm9YJ9GFl4i/0BPvemTN9RHMcRa2q4trq5IZrmpOy
H/ZLnf6ChmuORdP1MnCP3wdeqRUf/kZALXZSw7XUFxuu8aF73A02TW2K+url
OUv0vS91mIOxRfbwI8nTTq2z4nrSutSBqWd/kJr2+bkD5KOeTy4Czi9tud6N
7ZNnXxNcW554DT8yOrUH9GVFdBa9WKO5T9C3f5t68tT4hUejX08n/kRm7m9u
YhbW5nv0ZUX6ddHDOZmjM21qZF4SbFsZXXwq3/Qmxsc/Lk/uuytrryiO/DYx
PTi/NfEb+ED9b1Fq2j3ay583rNv3iz67YdwmziXeJQamr4fmd7MbW67FcUel
3BNxAvZG7Eoe0FM7kpcQ15Kb4CvxT8hFzgfOYZ+MHRu/Rd6PnqKXxA8zEt8S
696aeJvYuTvxM7UIzpe4hRgE/CUmoX7CHMT5xEr9weIJTeM4GM7vUSc37Gda
TfsJxsnNwTJwjFwbGdk767Nf8gtiZOJm4tWdodHtaYmjibVmab7FOqszyC9F
/4PoT1fMOyz84B+xIxh4kXi6xDO84vwanWGtzsSxxHj4lcm5e/Y7JXEX99OI
fvM758KmMfzXqQ0cxscXgnWXaa0fNi0Pv7+d3fLvFP3xXcz/dfFcIZ6xFT8T
S75aOJ99LzR5BrEuucZN4v+G+CeI/zrR41v+lhib+JqYkzi2N8+cZZHzpOaA
nMTSxNsrMy+/RXyp4Zo9v/He07R/px48MXrI7xC7k29Qu6SGWUqtgjHqJ72J
pZn/rT/4HQa9GxD9XITMDcd7Y1P3GJVYkfPF1r8onm81fUfkUOSrYOV2yfLz
ltcmvj6Q/c4X/+yWz4QazvLES8RR7B3MWSaec7XupRXrxcnRjTvrxm7s4Qta
c5rokbmLUYmNtzStN8PzmwXj3Mt1Ta/NunNbvhto6nMjw8Nvvxub/o31lqb3
xjwV8X8la/Vqj+MSL22tu/6IDzq6ZZ1Gf/AP+AnwZ3PoTfHLI+Kbv9u0zsG/
LOcAP/4dexsafBoRjJrWtA6hP/zOv6nmOB/cuifx4co8f+gfxfu/Tcv8cvw6
eHk41oSX350+3nAt4VHxn8dv0sk3FyUn5HetKQ3r1Lkt2wAyrNLcM+q2ZXKT
kanFEVc8kDvF5/H/BOjxF1u2f/iJy/n9Hl3kXO4PPzkgNQL8DTnd29HVYQ3n
ReREzP1g4qT/qxujwef76o4XwdDv1B2vX5D8l/mwR/T3wcSHtYb1DB37l7p9
J37zl3X7APCfeuSpwT1+t6wHE8gx8YvkrejFhTlnfp8vt6w/6xqOFz/8Pajp
34egme+5xHBv121j2Be+f077kf/7ODGx+oGW/Su+dUXdMQfxxiu5T2Iy7uGJ
ps+W2h11O77/cd05D/kOcQm/N3OmxzR839w1tQhkIa9/MHfH+fw/+omTFg==

         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlWto12UUx5+//vb/3eYss3BSKzPK9iKKRGrmrG2V89JmsyAS1O6INBPK
7pqYK8IbYl5IXWG+iMjZwFmakvUiKCvTXqSJL0JJpyaotGlWny/f34sD53vO
ec5znvOcy4gn2h9+fkAIYTkUQbVpCKOgRRUhfI3gUhZCH9RRCuEcst1JCLug
N+AXoj+Uh7Afai6H0AJVV4awBf1j6JaBZ+PrG/BicA1nmsDDsVmB7nFkBzhb
hz6Cn4jsFPp9cQgXiWUD9s+Bv0p817XgHfBXI9sGfgW8HTwC3AOeD27Fd5za
92X8NaLvBI+v8AMnwN+IzWZ0z4Ij+A5sHoSfi+wS/ERkZ+Hb5AM8GXwOvIoc
tJOLOdB4dB/jcx38WugO8FrwBd7zN/Qk9meRDeXspsS+FiN7C9uF0CjwCuy3
wXdBd4M7wR3wS4p87wcf5mwdPn4vO8Z74I8ia4Y/imwTthuhd7E/rDcqH9h8
hO6mknPblPjtynFz6pwpV8fBTdj+BW6BP8GZB9DXIFsPPwtZL7oG8HHwFPAv
vO1nqBT5z69D9yk2M/R+8AximQ6Nifx/yt1/6B+JnMPR4J/AjeBfwacTx6C7
V+rNnP2xyI/e3wO/HXoP3THwkaTIAfbLkf0TOwbdXQOuhF+VONZXkf3L2VLu
2r0NWQvv+wAaCz4F7otds6rVYZwfjP0V0FL0w2mMBmyvQb+k7Dfcj6+m3O8r
IevP/ef666fAW/G3M/X5k6T9TXwtyPzXwouwfTs31htb0U2FVhfx7eb8gdT4
PPbvo1uTubaEpxNLDfp1xFqN7Vh83ZX7/xWPeqs/9lvUY1dh+yiyHNnTkWu/
lLg21AM3oH9GPVnhHjoIvyf2XYqhAtzCmYtl93QVeJp6DJs1+BiaukfVm+pJ
1c7l2H+hGuqN/Sf6i0pkc3nLC5l7Rz00Dr4e6gb3cucO+C8y/7V64h3VduZa
UL6+g/++wOqRTvgPM9e+erCBXDTmzoVyMg/+RWhQ2ffVw99X6PWHA+AHFvUh
fxPgJ+W+XzV3iPhDEW8AJ+jy3PfJv3rhYO7ZpZ5YBr8y938pnh8435u6FzTT
xqjXi/eqvl7Cdn4Rn+6biW5WZnvF9xn81syzQefXY7shN1Z+BvKXe8CjOV/L
+TOqRai27B5r4+6N0Djsz0Su5QvENKTkmq4Cn479N6+Du9TfxfzVHdenrjnV
2mzNXPQv586lYtau6Mtd+9oZN4NnYj8ydo32KFexc6cc7gQfKbBi3Azujt0b
6gnFWuZNf0aOWbM7AZ+MPMP3wk9L/ZYF4F3wXcV59Zxq+dbUu0s1PSn1ztCu
kM9vE/vQWe2kdu6fkzv3eo92W2vq2aAdV6d4eM+8smfuedVK7lwo519iX41N
N/g17P+IvVO0S8r4/ATbvUU/qSY0e6LEs1czSL00OPWsVU/prmOxz+rOYal3
qHan7lAvD0nde+rpCvxHuWeHangq/EO5a0M1PAjbNs5EsWd0feo/119r5pdT
70ztytXa8bF3lnaVauROau/2zL2pmr0S31W5a1s9sC/xTNcsX1ryrjiReDZr
Z1RxNs9c6/of7bLfEttqpym2ytR3K0bNmij1rtXM0S7uT7wbtJO12z5PPMu0
41Rrt6Te5aq5e7Wbi/sU75TUf6S/UQ21oJucOV+ab/8DIeUdSQ==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8407444374999999, 0.87304675, 0.87903625], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFls1rVGcUxu+duc7NZBbZ6USpiYkBbSpUEDeuxLSLIoUKCqULqZiRGuwg
wehWMIoxH5pkMtUiZiZmGSW4KKULq6L9A0q/6M5Vtl0mxtLnx3mGLg733HPP
ez6fc96771z91LeFJEl+FRVFv1WS5A/RyVKSzIpmRNU0SSb07aZoUlSV4phk
vaJp67wV/9TvfBvJk+SI+ItZkhyQ/rhkQ6JFnX8sWhE1RKt+vyq6ZR/f6VxT
tDcN219mYR8Z385m4WfOsZ3Pg8c/z7uWr4uWxNf1vF8Kft02Z223aTm+7hTC
zxXFUMvjTMcGehviZyWfEb3Te7/y2lcM+/fy4Bd0dpf4Z5K1xXeL3yGqyHZL
Z0az4J+Kegqh03ROG67bCdFhycpdOlNOkuOStwrhr0/8Gcle69ukzhQdC2dP
Sf5c8uuSD4r/QfylLOLqd2zVPOLD96bO/ePevczCJ/IVPZdLkQM9RP6h6zbt
2mL7s3LY73cNiG0+j1qQc7MQcd1Ioob3XWd6vOT+T/oJLoiDeKj/Ltn+UT7q
WfRp03FS/233+n0p+EYadcjy4M+6LviGqA8xlDpxpYHhXuOYfiCnPnkeek3n
Ar9uG0Xbp4a94CONc93Wp7fd7jVxEd9XWeAFXzeMh4r1yWlLtJCGH3x/Lf0B
9wj7YKHqfkHIwUyu2jxSjY6mIat24pH8oeQfUx/N8bD4V7L5s+TfiH/oedl2
bG8kH5P8URr2TtsmNr6wHeIZFF0wRk44nkbBdXTfNp3LMdn8U74/0Pff9fxb
NCL5R7J3QfS9Yx7wnAyaJ37m4onoahq+Ro29queCfcJzxDz4HMn/131XCX12
yoti7JltybZENX2fku3bhYiZ3fOyGLp8/9c6DX8Hm3PGPHhbKURvwcke5fGT
8rysGNYcM32pGA9godd9ueiZ5/y48T/hndfjXUC+j0sxe9T5ieXYBDv4B6t3
vffoHXgHk+D9lu1dE7Xta8FzdtO7dcs9Yp5GPdfMfWcO0RtOIx/qxhzPG//E
R0zD3ofMFTMPtplJ4mPP3LM++Jr1boLQA/87vB+I7YF3Aphnd1B34mD3VFyr
JeOM72+9o6nDp12BMzDWl0Wv6SP774V3IDGcd2zk2eM6780iD3IE+7uNf2aw
5vjZu590xe6llm3HM2eb1B8sEQ/7CkxNmWfOdnrWat4h5Aim0KP3zMGAZ4Ea
1KzTcq7sQ3b8L97z3KFrxsPBYszNuDExZbz2Z4HnVe+6ee+7bfeg4b1HPelF
nzG+aIxVvaOWjcP97vma+w4uV3wv4Ie6U/MB74Znxs6Qa0vNWn7njmgZk+yk
Q95L5NDunCnFDOCXu7Lt+xK7xIQuPPlTh5bvqf32S42ww71xshx3BzP6eTnm
lDo/8B2E7ZbPLpuv2MZB/6/wPGBfQ76DqdUd93rMsrbzAoNgi9zBbdN1pt5L
5ld93zGXf1Xif4t/LWZn3TNVN+7pT9Nn6/7fmvCs0q8ZY7vzX4Xfad+TY96B
i/a3YVvY+Q9U1DAy
         "],
         VertexColors->None], 
        PolygonBox[{{3120, 2246, 415, 1743}, {2378, 3108, 1706, 1133}, {3170, 
         2348, 411, 1831}, {3067, 3068, 1638, 298}, {2389, 3177, 1847, 310}, {
         2385, 3175, 1843, 304}, {2247, 3120, 1743, 1157}, {2241, 3118, 1737, 
         1153}, {2326, 3160, 1807, 413}, {2330, 3162, 1811, 415}, {2117, 3115,
          1728, 321}, {3032, 3033, 1612, 541}, {3118, 2240, 413, 1737}, {3160,
          2327, 1135, 1807}, {3031, 3030, 324, 1612}, {3166, 2339, 1133, 
         1823}, {3177, 2390, 1157, 1847}, {3175, 2386, 1153, 1843}, {3112, 
         2057, 321, 1718}, {2338, 3166, 1823, 411}, {3070, 3069, 1219, 
         1638}, {3115, 2118, 541, 1728}, {3110, 2055, 310, 1712}, {2349, 3170,
          1831, 1219}, {2380, 3110, 1712, 1135}, {3162, 2331, 1137, 1811}, {
         3108, 2053, 304, 1706}, {2382, 3112, 1718, 1137}},
         VertexColors->None]}]}, 
     {RGBColor[0.9076988125000001, 0.8953742499999999, 0.84904075], EdgeForm[
      None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFls1LlFEUxu/MO6/5MrMJsiBJ+6KCqZhZqRChhBNESQlFtGghhLWpZZGR
Ueb/46j4tdGpyaX5nZtUWoRIiLOLPuj8PM/Q4jLn3nvu+XjOc847p/qe9T5N
hxBGbEW2VmyzamvB5BdxCJOZEA7bvpgKoWxnc+ia4kc7P2/nF5MQ+nK+rwTX
GQ1+V7Gz5/bug87GbDWb/gPTH7O7V7H//jSdUbP51uRxkzcj9zlg8jHTv2/6
Zbur2tknW7NmZzDlclvKF3fExtvvirk98nP0YztL2zpi+yjje+SK6ZzMeGxr
uuP8jPl9mPP8e03uN/mHyfdMfmLynsnzpldLuX0wA7sh2xfSbgO5aL9Ntt6b
PG2/U8Kyp8FjwB/vlm1dS/kv+XwOvud309ZsYwiXc45RMXJ8wbYjcszAatzk
YbufABvTL+R8/zJ2/Ih1XhiC35ri/Kr4qQN1n0k7fnCiK3J76HM+rbrctvhv
2UqE9YzO50y/NeP1/mbyrur7Onb8iHUpOFfgBblSN/JMLOYLOX8DvlftzXbk
HGmNPT+wbVHM3O0oL/j3LnZcOK8pZnxeiZ0XW/KzqNiIixpR4+bYeb0ojhNf
v+X3yNZ+xvE7ETtPqWVJebyJPVYwwv+++qI75XFSw5Lllc85/6gfWIADPIAP
9Aw1ma9z1fTP5pzHh0w+l/M8B8Qh3hUif0uNplQX5Dx+M25zWnXhHFv0M7Ui
xori3BE/wAuukA+5kCO8Jc91cXg7eG3oW7Ajn87YsYRHBdVlRPzEb4vOh2Sv
KDvkWxXXwQqc4HlV+VED+ndAOG1kQ/iS9b7BDjFdT3mPnk68hsRALPgiB3gA
B+ozBVs1zRpwhhfgwh1430h8T0+1S6eqOVKUnQ6dM5OOJs4L+DkuPo2K1/VZ
WBGf6r1HPHB5WG/AsI4ffKce2/LfoZiZl8cT9wPeu3oDZ+H9iHxjb0GYb6gW
BzM78rjgYHej+2Se3Um8P5hndxPncWfkMwg7zI/5Ro+1Ppvon2XNOnTo157E
Y2I+zTU6x+HszcTzIbZVcQA+UTd6EQ4zy5hjfEMuJZ4PM6dTudBz2KNmv63+
v7Lel7zjPRzD7op67WBu6Zw4sdOmujDrmfOJ5i7zD550yRe6XeIMvfy44X8/
F2VzTvMDHMqKqybsJzQ/1yzG9azPxx/iF9xhLlZUC3qUupTld1DfsUnVkzz2
xAXsEjP2Ivkc13enIPzymkfgS3wbmpP0Fjkwx+j5PxbX36zn1qKa1L8zW/rW
wNkl5VlSrZCb1HMlza28/hMgEwd76oMvavQPH6cpXQ==
         "],
         VertexColors->None], 
        PolygonBox[{{3070, 3066, 1265, 1640}, {3029, 3033, 1614, 1027}, {3031,
          3029, 1027, 1613}, {2241, 2239, 1406, 1154}, {2107, 2118, 1026, 
         1029}, {2411, 2246, 1158, 1311}, {2378, 2231, 1400, 1255}, {2117, 
         2465, 1344, 1026}, {2380, 2233, 1402, 1257}, {2409, 2240, 1154, 
         1309}, {2389, 2463, 1342, 1263}, {2326, 2409, 1309, 1202}, {2385, 
         2461, 1340, 1261}, {2235, 2331, 1204, 1404}, {3066, 3068, 1639, 
         1265}, {3032, 2107, 1029, 1614}, {3035, 3030, 1613, 1616}, {2461, 
         2053, 1255, 1340}, {2465, 2057, 1259, 1344}, {2463, 2055, 1257, 
         1342}, {2407, 2348, 1220, 1307}, {2233, 2327, 1202, 1402}, {2245, 
         2390, 1263, 1408}, {2247, 2245, 1408, 1158}, {2338, 2407, 1307, 
         1208}, {2239, 2386, 1261, 1406}, {2330, 2411, 1311, 1204}, {2231, 
         2339, 1208, 1400}, {2347, 3069, 1640, 1411}, {2349, 2347, 1411, 
         1220}, {2382, 2235, 1404, 1259}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1056, 962, 1055, 961, 1054, 299, 375, 1218, 1637, 3067, 3068,
          3066, 3070, 3069, 2347, 2349, 3170, 2348, 2407, 2338, 3166, 2339, 
         2231, 2378, 3108, 2053, 2461, 2385, 3175, 2386, 2239, 2241, 3118, 
         2240, 2409, 2326, 3160, 2327, 2233, 2380, 3110, 2055, 2463, 2389, 
         3177, 2390, 2245, 2247, 3120, 2246, 2411, 2330, 3162, 2331, 2235, 
         2382, 3112, 2057, 2465, 2117, 3115, 2118, 2107, 3032, 3033, 3029, 
         3031, 3030, 3035}],
        "4.5`"],
       Annotation[#, 4.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{120, 119, 118, 649, 117, 1777, 403, 1786, 403, 1779, 1109, 
         1670, 1668, 1107, 1776, 401, 1769, 1103, 1660, 268, 1658, 1101, 1766,
          399, 1759, 1097, 1650, 262, 1648, 1095, 1756, 397, 1749, 1091, 1578,
          256, 1445, 1087, 1549, 395, 1509, 1081, 1440, 250, 1437, 1078, 1537,
          393, 1499, 1073, 1432, 244, 1429, 1070, 1523, 391, 1489, 1064, 1424,
          234, 1421, 538, 1459, 235}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{324, 1612, 541, 1728, 321, 1718, 1137, 1811, 415, 1743, 1157,
          1847, 310, 1712, 1135, 1807, 413, 1737, 1153, 1843, 304, 1706, 1133,
          1823, 411, 1831, 1219, 1638, 298, 1588, 1130, 1817, 409, 1827, 1127,
          1700, 292, 1698, 1125, 1803, 407, 1799, 1121, 1690, 286, 1688, 1119,
          1796, 405, 1789, 1115, 1680, 280, 1678, 1113, 1786}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1045, 955, 1044, 954, 1043, 257, 347, 1945, 1089, 1576, 2011,
          2999, 2557, 2673, 2672, 2171, 2936, 2937, 2921, 2935, 2934, 2405, 
         2742, 2743, 2738, 2745, 2744, 2158, 2736, 2737, 2541, 2735, 2734, 
         2435, 1997, 2540, 2536, 2657, 2656, 2157, 2884, 2885, 2869, 2883, 
         2882, 2403, 2718, 2719, 2714, 2721, 2720, 2142, 2712, 2713, 2517, 
         2711, 2710, 2427, 1983, 2516, 2512, 2641, 2640, 2141, 2820, 2821, 
         2805, 2819, 2818, 2401, 2694, 2695, 2690, 2697, 2696, 2126, 2688, 
         2689, 2493, 2687, 2686, 2419, 1968, 2492, 2488, 2576, 2575, 2105, 
         2623, 2624, 2605, 2622, 2621, 1972}],
        "3.5`"],
       Annotation[#, 3.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV03loz3Ecx/HPMjM2cy9mxlybsRDJsZQjYcPcqcnxh8SyqPlD+Uct7Q9q
aeSYoxzlyJWbTeMP5ZiZPxzJH5K0HDVji+Hx+eO55/v1/r4/n8++xy97fdmS
LQkhhHR/3qSE0IgXeI6XaMLU5BBmIy81hFl8vGsIyZwjL1DfVg/gVXJ/3oQH
emPlh1yPZXob5aV8FEl6I+RC9U11P14p941zuKeXL9fyXRTrbZAX8REk6g2T
56mvq7N5tTwkzmEU1sl5nIs299GOVvzCT6xLCqEuMYRy956LDHVtpxAGch1n
8n0exNW8H6PMLeftvFl/gj06Ob/OfrX4gRZc0xvs3BL/QxaPl0fyWjmHr8pz
eaicoD6sDvE+5Ct8GX30Vsi9eaycxsvkHnxBnsNZckeXEA6q//Ag+bxr59Bd
b6mcyvlyEhfLXfhMfKecIbdbdyA+Ix4gn3btFDrrLZITebTcgSL5H5/ATP10
udW6anUL95WPuVaD35gf9+dcfIlnyt+4GtOtSZO/WFelbuZUeZ9rVWiOZ8if
eTjeoUB+z5WYGr8j+aN1e9QfOFHe7VoF3sYZ+TUPwVNMlBt4J756T99xC3fw
zvpK+7zh0M3zVJdxKXaY32amHBtRhlJkxvfIhfGdm1vMC7FV/xDXxDPscyn+
puy7S/2Em/kT1lhTEs+Iz8PMDEzENExGun4yp8S9zPXitPjt6u/lKryyz1mu
t+8OdS03cUN8f9YUxTPM/+WE+I3yb7Shp/4jfowKNOJZvA/9XWYrcN8+J/mq
fbepL/IdvhHfn9kUTDY/iadgDCZgHArwH4JhjQ8=
         "]],
        "3.5`"],
       Annotation[#, 3.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{230, 1453, 536, 1417, 229, 1420, 1060, 1484, 390, 1516, 1066,
          1425, 241, 1428, 1069, 1494, 392, 1530, 1074, 1433, 247, 1436, 1077,
          1504, 394, 1544, 1082, 1443, 253, 1573, 1086, 1746, 396, 1751, 1092,
          1643, 259, 1645, 1094, 1754, 398, 1761, 1098, 1653, 265, 1655, 1100,
          1764, 400, 1771, 1104, 1663, 271, 1665, 1106, 1774, 402, 1772, 110, 
         643, 111, 112, 113, 114, 115, 646, 116, 1009, 1292, 2300, 3147, 2302,
          2208, 2369, 3093, 2036, 2452, 2034, 3091, 2206, 2204, 2298, 3145, 
         2296, 2087, 2284, 3139, 2286, 2196, 2365, 3085, 2028, 2448, 2026, 
         3083, 2194, 2192, 2282, 3137, 2280, 2083, 2268, 3131, 2270, 2184, 
         2361, 3077, 2020, 2444, 2018, 3075, 2182, 2180, 2266, 3129, 2264, 
         2079, 2252, 3123, 2254, 2172, 3053, 3055, 3000, 3002, 2012, 2440, 
         2009, 2559, 2555, 2670, 2667, 2169, 2929, 2932, 2919, 2926, 2923, 
         2075, 2887, 2890, 2740, 2896, 2893, 2160, 2969, 2972, 2543, 2991, 
         1999, 2433, 1995, 2538, 2534, 2654, 2651, 2155, 2877, 2880, 2867, 
         2874, 2871, 2069, 2823, 2826, 2716, 2832, 2829, 2144, 2957, 2960, 
         2519, 2985, 1985, 2425, 1981, 2514, 2510, 2638, 2635, 2139, 2813, 
         2816, 2803, 2810, 2807, 2063, 2759, 2762, 2692, 2768, 2765, 2128, 
         2945, 2948, 2495, 2979, 1970, 2417, 1966, 2490, 2486, 2573, 2570, 
         2103, 2613, 2616, 2603, 2610, 2607, 2619}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{318, 1608, 539, 1726, 315, 1715, 1136, 1809, 414, 1740, 1155,
          1845, 307, 1709, 1134, 1805, 412, 1734, 1151, 1841, 301, 1703, 1132,
          1820, 410, 1829, 1216, 1634, 295, 1583, 1128, 1814, 408, 1825, 1124,
          1695, 289, 1693, 1122, 1801, 406, 1794, 1118, 1685, 283, 1683, 1116,
          1791, 404, 1784, 1112, 1675, 277, 1673, 1110, 1781, 402}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1049, 957, 1048, 914, 915, 294, 852, 372, 1129, 1582, 2050, 
         3005, 3004, 3058, 3057, 2228, 2333, 3163, 2332, 2096, 2340, 3167, 
         2341, 2224, 2375, 3104, 2047, 2458, 2046, 3103, 2223, 2222, 2321, 
         3157, 2320, 2094, 2314, 3154, 2315, 2218, 2373, 3100, 2043, 2456, 
         2042, 3099, 2217, 2216, 2313, 3153, 2312, 2092, 2306, 3150, 2307, 
         2212, 2371, 3096, 2039, 2454, 2038, 3095, 2211, 2210, 2305, 3149, 
         2304, 2090, 2293, 3144, 2295, 2203, 2368, 3090, 2033, 2451, 2031, 
         3088, 2201, 2199, 2291, 3142, 2289, 2086, 2277, 3136, 2279, 2191, 
         2364, 3082, 2025, 2447, 2023, 3080, 2189, 2187, 2275, 3134, 2273, 
         2082, 2261, 3128, 2263, 2179, 2360, 3074, 2017, 2443, 2015, 3072, 
         2177, 2175, 2259, 3126, 2257, 2078, 2249, 3122, 2251, 2167, 3050, 
         3052, 2995, 2998, 2007, 2438, 2004, 2553, 2549, 2663, 2660, 2164, 
         2910, 2913, 2900, 2907, 2904, 2073, 2856, 2859, 2729, 2865, 2862, 
         2153, 2964, 2967, 2532, 2989, 1993, 2430, 1989, 2527, 2523, 2647, 
         2644, 2148, 2846, 2849, 2836, 2843, 2840, 2067, 2792, 2795, 2705, 
         2801, 2798, 2137, 2952, 2955, 2508, 2983, 1979, 2422, 1975, 2503, 
         2499, 2631, 2628, 2132, 2782, 2785, 2772, 2779, 2776, 2061, 2748, 
         2751, 2681, 2757, 2754, 2125, 2940, 2943, 2484, 2977, 1963, 2414, 
         1959, 2479, 2475, 2566, 2563, 2100, 2591, 2594, 2581, 2588, 2585, 
         2597}],
        "2.5`"],
       Annotation[#, 2.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1964, 2598, 2599, 2582, 2601, 2600, 2101, 2567, 2568, 2476, 
         2480, 1960, 2415, 2674, 2675, 2481, 2677, 2676, 2122, 2684, 2685, 
         2678, 2683, 2682, 2400, 2786, 2787, 2773, 2789, 2788, 2133, 2632, 
         2633, 2500, 2504, 1976, 2423, 2698, 2699, 2505, 2701, 2700, 2134, 
         2708, 2709, 2702, 2707, 2706, 2402, 2850, 2851, 2837, 2853, 2852, 
         2149, 2648, 2649, 2524, 2528, 1990, 2431, 2722, 2723, 2529, 2725, 
         2724, 2150, 2732, 2733, 2726, 2731, 2730, 2404, 2914, 2915, 2901, 
         2917, 2916, 2165, 2664, 2665, 2550, 2993, 2005, 1571, 1084, 1943, 
         345, 254, 1039, 951, 1040, 952, 1041, 953, 1042, 875, 876, 255, 839, 
         346, 977, 1326, 2008, 2558, 2554, 2669, 2666, 2168, 2928, 2931, 2918,
          2925, 2922, 2074, 2886, 2889, 2739, 2895, 2892, 2159, 2968, 2971, 
         2542, 2990, 1998, 2432, 1994, 2537, 2533, 2653, 2650, 2154, 2876, 
         2879, 2866, 2873, 2870, 2068, 2822, 2825, 2715, 2831, 2828, 2143, 
         2956, 2959, 2518, 2984, 1984, 2424, 1980, 2513, 2509, 2637, 2634, 
         2138, 2812, 2815, 2802, 2809, 2806, 2062, 2758, 2761, 2691, 2767, 
         2764, 2127, 2944, 2947, 2494, 2978, 1969, 2416, 1965, 2489, 2485, 
         2572, 2569, 2102, 2612, 2615, 2602, 2609, 2606, 2618}],
        "2.5`"],
       Annotation[#, 2.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3043, 3010, 3011, 3009, 3013, 3012, 1954, 2357, 3173, 2358, 
         2356, 2469, 2470, 2396, 2398, 3180, 2397, 1955, 2392, 3178, 2393, 
         2391, 2395, 3179, 2394, 2108, 2351, 3171, 2352, 2350, 3047, 3048, 
         3044, 3046, 3045, 1956, 3020, 3021, 3019, 3023, 3022, 2114, 2467, 
         2468, 2399, 2089, 2292, 3143, 2294, 2202, 2367, 3089, 2032, 2450, 
         2030, 3087, 2200, 2198, 2290, 3141, 2288, 2085, 2276, 3135, 2278, 
         2190, 2363, 3081, 2024, 2446, 2022, 3079, 2188, 2186, 2274, 3133, 
         2272, 2081, 2260, 3127, 2262, 2178, 2359, 3073, 2016, 2442, 2014, 
         3071, 2176, 2174, 2258, 3125, 2256, 2077, 2248, 3121, 2250, 2166, 
         3049, 3051, 2994, 2997, 2006, 2437, 2003, 2552, 2548, 2662, 2659, 
         2163, 2909, 2912, 2899, 2906, 2903, 2072, 2855, 2858, 2728, 2864, 
         2861, 2152, 2963, 2966, 2531, 2988, 1992, 2429, 1988, 2526, 2522, 
         2646, 2643, 2147, 2845, 2848, 2835, 2842, 2839, 2066, 2791, 2794, 
         2704, 2800, 2797, 2136, 2951, 2954, 2507, 2982, 1978, 2421, 1974, 
         2502, 2498, 2630, 2627, 2131, 2781, 2784, 2771, 2778, 2775, 2060, 
         2747, 2750, 2680, 2756, 2753, 2124, 2939, 2942, 2483, 2976, 1962, 
         2413, 1958, 2478, 2474, 2565, 2562, 2099, 2590, 2593, 2580, 2587, 
         2584, 2596}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1953, 3008, 2112, 2974, 3041, 3042, 2121, 2353, 3113, 2110, 
         2466, 2354, 3172, 2355, 2111, 2577, 2578, 2545, 2546, 2001, 2625, 
         2119, 3116, 2120, 2109, 3039, 3040, 3036, 3038, 3037, 2058, 3015, 
         3016, 3014, 3018, 3017, 2113, 2471, 2472, 2439, 2996, 2436, 2002, 
         2551, 2547, 2661, 2658, 2162, 2908, 2911, 2898, 2905, 2902, 2071, 
         2854, 2857, 2727, 2863, 2860, 2151, 2962, 2965, 2530, 2987, 1991, 
         2428, 1987, 2525, 2521, 2645, 2642, 2146, 2844, 2847, 2834, 2841, 
         2838, 2065, 2790, 2793, 2703, 2799, 2796, 2135, 2950, 2953, 2506, 
         2981, 1977, 2420, 1973, 2501, 2497, 2629, 2626, 2130, 2780, 2783, 
         2770, 2777, 2774, 2059, 2746, 2749, 2679, 2755, 2752, 2123, 2938, 
         2941, 2482, 2975, 1961, 2412, 1957, 2477, 2473, 2564, 2561, 2098, 
         2589, 2592, 2579, 2586, 2583, 2595}],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57596894]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6694],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quartiles",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quartiles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ordering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ordering"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MedianDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MedianDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterquartileRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterquartileRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nearest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nearest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseCDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseCDF"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27348]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16405],

Cell[TextData[ButtonBox["Basic Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicStatistics"]], "Tutorials",
 CellID->24620],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DescriptiveStatistics"]], "Tutorials",
 CellID->4063544],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "Tutorials",
 CellID->4738],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->167082332],

Cell[TextData[ButtonBox["Exploratory Data Analysis",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataClassification"]], "MoreAbout",
 CellID->451200180],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->240103007],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->64894172],

Cell[TextData[ButtonBox["Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StatisticalDistributions"]], "MoreAbout",
 CellID->135872905],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->100515636],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->290391201]
}, Open  ]],

Cell["New in 5  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Quantile - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 26.6714548}", "context" -> "System`", 
    "keywords" -> {
     "CDF", "confidence intervals", "deciles", "empirical distribution", 
      "interquartile range", "inverse CDF", "order statistics", "percentiles",
       "quantile", "quartiles", "Weibull quantile method"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Quantile[list, q] gives the q\\[Null] th quantile of list. \
Quantile[list, {q_1, q_2, ...}] gives a list of quantiles q_1, q_2, ... . \
Quantile[list, q, {{a, b}, {c, d}}] uses the quantile definition specified by \
parameters a, b, c, d. Quantile[dist, q] gives a quantile of the symbolic \
distribution dist.", "synonyms" -> {}, "title" -> "Quantile", "type" -> 
    "Symbol", "uri" -> "ref/Quantile"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[21550, 680, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->8710012]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 137626, 3415}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3917, 80, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4540, 107, 4192, 83, 70, "ObjectNameGrid"],
Cell[8735, 192, 3118, 106, 70, "Usage",
 CellID->31474]
}, Open  ]],
Cell[CellGroupData[{
Cell[11890, 303, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[12368, 320, 927, 36, 70, "Notes",
 CellID->13064],
Cell[13298, 358, 1648, 59, 70, "Notes",
 CellID->30651],
Cell[14949, 419, 2757, 102, 70, "Notes",
 CellID->22385],
Cell[17709, 523, 277, 11, 70, "Notes",
 CellID->4304],
Cell[17989, 536, 70, 1, 70, "Notes",
 CellID->30047],
Cell[18062, 539, 1427, 48, 70, "Notes",
 CellID->1819],
Cell[19492, 589, 380, 14, 70, "Notes",
 CellID->32610],
Cell[19875, 605, 161, 7, 70, "Notes",
 CellID->2829],
Cell[20039, 614, 367, 15, 70, "Notes",
 CellID->21434],
Cell[20409, 631, 664, 25, 70, "Notes",
 CellID->6935],
Cell[21076, 658, 115, 3, 70, "Notes",
 CellID->29570],
Cell[21194, 663, 319, 12, 70, "Notes",
 CellID->26286]
}, Closed]],
Cell[CellGroupData[{
Cell[21550, 680, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8710012],
Cell[CellGroupData[{
Cell[21933, 694, 147, 5, 70, "ExampleSection",
 CellID->92663316],
Cell[22083, 701, 82, 1, 70, "ExampleText",
 CellID->14190],
Cell[CellGroupData[{
Cell[22190, 706, 251, 8, 28, "Input",
 CellID->28219],
Cell[22444, 716, 158, 5, 36, "Output",
 CellID->306873090]
}, Open  ]],
Cell[22617, 724, 121, 3, 70, "ExampleDelimiter",
 CellID->12951],
Cell[22741, 729, 92, 1, 70, "ExampleText",
 CellID->3613],
Cell[CellGroupData[{
Cell[22858, 734, 251, 8, 70, "Input",
 CellID->24768],
Cell[23112, 744, 157, 5, 36, "Output",
 CellID->59972703]
}, Open  ]],
Cell[23284, 752, 121, 3, 70, "ExampleDelimiter",
 CellID->25408],
Cell[23408, 757, 65, 1, 70, "ExampleText",
 CellID->32646],
Cell[CellGroupData[{
Cell[23498, 762, 328, 11, 70, "Input",
 CellID->32147],
Cell[23829, 775, 203, 7, 36, "Output",
 CellID->497475858]
}, Open  ]],
Cell[24047, 785, 125, 3, 70, "ExampleDelimiter",
 CellID->136480203],
Cell[24175, 790, 206, 8, 70, "ExampleText",
 CellID->235162839],
Cell[CellGroupData[{
Cell[24406, 802, 209, 6, 70, "Input",
 CellID->856663451],
Cell[24618, 810, 346, 12, 38, "Output",
 CellID->6441995]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25013, 828, 216, 7, 70, "ExampleSection",
 CellID->12596],
Cell[25232, 837, 213, 7, 70, "ExampleText",
 CellID->13924],
Cell[CellGroupData[{
Cell[25470, 848, 283, 9, 70, "Input",
 CellID->839],
Cell[25756, 859, 169, 6, 38, "Output",
 CellID->387645858]
}, Open  ]],
Cell[25940, 868, 121, 3, 70, "ExampleDelimiter",
 CellID->24209],
Cell[26064, 873, 81, 1, 70, "ExampleText",
 CellID->15492],
Cell[CellGroupData[{
Cell[26170, 878, 414, 15, 70, "Input",
 CellID->16499],
Cell[26587, 895, 207, 7, 36, "Output",
 CellID->106845677]
}, Open  ]],
Cell[26809, 905, 125, 3, 70, "ExampleDelimiter",
 CellID->166755903],
Cell[26937, 910, 93, 1, 70, "ExampleText",
 CellID->40597666],
Cell[CellGroupData[{
Cell[27055, 915, 495, 18, 70, "Input",
 CellID->386975047],
Cell[27553, 935, 336, 12, 36, "Output",
 CellID->259718442]
}, Open  ]],
Cell[27904, 950, 125, 3, 70, "ExampleDelimiter",
 CellID->158391064],
Cell[28032, 955, 76, 1, 70, "ExampleText",
 CellID->160553898],
Cell[CellGroupData[{
Cell[28133, 960, 308, 10, 70, "Input",
 CellID->190699768],
Cell[28444, 972, 179, 5, 36, "Output",
 CellID->147795851]
}, Open  ]],
Cell[28638, 980, 125, 3, 70, "ExampleDelimiter",
 CellID->650909219],
Cell[28766, 985, 88, 1, 70, "ExampleText",
 CellID->285474028],
Cell[CellGroupData[{
Cell[28879, 990, 242, 8, 70, "Input",
 CellID->315224713],
Cell[29124, 1000, 175, 5, 36, "Output",
 CellID->290907418]
}, Open  ]],
Cell[CellGroupData[{
Cell[29336, 1010, 297, 10, 70, "Input",
 CellID->594479966],
Cell[29636, 1022, 339, 10, 36, "Output",
 CellID->68659755]
}, Open  ]],
Cell[29990, 1035, 123, 3, 70, "ExampleDelimiter",
 CellID->5859166],
Cell[30116, 1040, 88, 1, 70, "ExampleText",
 CellID->103907181],
Cell[CellGroupData[{
Cell[30229, 1045, 246, 8, 70, "Input",
 CellID->201367446],
Cell[30478, 1055, 158, 5, 36, "Output",
 CellID->315338516]
}, Open  ]],
Cell[CellGroupData[{
Cell[30673, 1065, 439, 15, 70, "Input",
 CellID->118044929],
Cell[31115, 1082, 180, 6, 51, "Output",
 CellID->444631779]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31344, 1094, 237, 7, 70, "ExampleSection",
 CellID->811],
Cell[31584, 1103, 211, 8, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[31820, 1115, 570, 19, 70, "Input",
 CellID->19878761],
Cell[32393, 1136, 484, 17, 36, "Output",
 CellID->327723661]
}, Open  ]],
Cell[CellGroupData[{
Cell[32914, 1158, 155, 5, 70, "Input",
 CellID->235263230],
Cell[33072, 1165, 291, 9, 36, "Output",
 CellID->161827535]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33412, 1180, 223, 7, 70, "ExampleSection",
 CellID->13294],
Cell[33638, 1189, 165, 7, 70, "ExampleText",
 CellID->11043],
Cell[CellGroupData[{
Cell[33828, 1200, 354, 12, 70, "Input",
 CellID->764],
Cell[34185, 1214, 1342, 26, 70, "Output",
 Evaluatable->False,
 CellID->326265843]
}, Open  ]],
Cell[35542, 1243, 125, 3, 70, "ExampleDelimiter",
 CellID->503240723],
Cell[35670, 1248, 80, 1, 70, "ExampleText",
 CellID->82963523],
Cell[CellGroupData[{
Cell[35775, 1253, 552, 18, 70, "Input",
 CellID->178941197],
Cell[36330, 1273, 2213, 40, 70, "Output",
 Evaluatable->False,
 CellID->325005407]
}, Open  ]],
Cell[38558, 1316, 125, 3, 70, "ExampleDelimiter",
 CellID->223703586],
Cell[38686, 1321, 88, 1, 70, "ExampleText",
 CellID->178539715],
Cell[CellGroupData[{
Cell[38799, 1326, 236, 7, 70, "Input",
 CellID->49740330],
Cell[39038, 1335, 178, 5, 36, "Output",
 CellID->115310687]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39265, 1346, 232, 7, 70, "ExampleSection",
 CellID->8298],
Cell[39500, 1355, 240, 8, 70, "ExampleText",
 CellID->2025],
Cell[CellGroupData[{
Cell[39765, 1367, 216, 7, 70, "Input",
 CellID->14789],
Cell[39984, 1376, 157, 5, 36, "Output",
 CellID->42537082]
}, Open  ]],
Cell[40156, 1384, 125, 3, 70, "ExampleDelimiter",
 CellID->651399430],
Cell[40284, 1389, 350, 12, 70, "ExampleText",
 CellID->38722882],
Cell[CellGroupData[{
Cell[40659, 1405, 158, 5, 70, "Input",
 CellID->133352675],
Cell[40820, 1412, 764, 16, 71, "Output",
 CellID->501141084]
}, Open  ]],
Cell[CellGroupData[{
Cell[41621, 1433, 460, 16, 70, "Input",
 CellID->155558425],
Cell[42084, 1451, 274, 9, 36, "Output",
 CellID->141553801]
}, Open  ]],
Cell[CellGroupData[{
Cell[42395, 1465, 108, 3, 70, "Input",
 CellID->632052870],
Cell[42506, 1470, 274, 9, 36, "Output",
 CellID->105177708]
}, Open  ]],
Cell[42795, 1482, 125, 3, 70, "ExampleDelimiter",
 CellID->103804862],
Cell[42923, 1487, 383, 12, 70, "ExampleText",
 CellID->15299726],
Cell[CellGroupData[{
Cell[43331, 1503, 158, 5, 70, "Input",
 CellID->118537781],
Cell[43492, 1510, 755, 16, 71, "Output",
 CellID->67937882]
}, Open  ]],
Cell[CellGroupData[{
Cell[44284, 1531, 510, 17, 70, "Input",
 CellID->23051440],
Cell[44797, 1550, 175, 5, 36, "Output",
 CellID->604861829]
}, Open  ]],
Cell[CellGroupData[{
Cell[45009, 1560, 117, 3, 70, "Input",
 CellID->481300380],
Cell[45129, 1565, 174, 5, 36, "Output",
 CellID->40392708]
}, Open  ]],
Cell[45318, 1573, 125, 3, 70, "ExampleDelimiter",
 CellID->631682428],
Cell[45446, 1578, 387, 12, 70, "ExampleText",
 CellID->533304287],
Cell[CellGroupData[{
Cell[45858, 1594, 158, 5, 70, "Input",
 CellID->239649738],
Cell[46019, 1601, 769, 16, 71, "Output",
 CellID->328885261]
}, Open  ]],
Cell[CellGroupData[{
Cell[46825, 1622, 551, 19, 70, "Input",
 CellID->501255430],
Cell[47379, 1643, 175, 5, 36, "Output",
 CellID->63950425]
}, Open  ]],
Cell[CellGroupData[{
Cell[47591, 1653, 116, 3, 70, "Input",
 CellID->333901997],
Cell[47710, 1658, 176, 5, 36, "Output",
 CellID->130664747]
}, Open  ]],
Cell[47901, 1666, 125, 3, 70, "ExampleDelimiter",
 CellID->174408474],
Cell[48029, 1671, 374, 12, 70, "ExampleText",
 CellID->75587225],
Cell[CellGroupData[{
Cell[48428, 1687, 158, 5, 70, "Input",
 CellID->371742929],
Cell[48589, 1694, 774, 17, 71, "Output",
 CellID->164641296]
}, Open  ]],
Cell[CellGroupData[{
Cell[49400, 1716, 556, 19, 70, "Input",
 CellID->250626437],
Cell[49959, 1737, 273, 9, 36, "Output",
 CellID->373841244]
}, Open  ]],
Cell[CellGroupData[{
Cell[50269, 1751, 221, 8, 70, "Input",
 CellID->156230570],
Cell[50493, 1761, 177, 5, 36, "Output",
 CellID->629093449]
}, Open  ]],
Cell[CellGroupData[{
Cell[50707, 1771, 114, 3, 70, "Input",
 CellID->46759148],
Cell[50824, 1776, 176, 5, 36, "Output",
 CellID->57755007]
}, Open  ]],
Cell[51015, 1784, 122, 3, 70, "ExampleDelimiter",
 CellID->683712],
Cell[51140, 1789, 342, 12, 70, "ExampleText",
 CellID->958682470],
Cell[CellGroupData[{
Cell[51507, 1805, 204, 6, 70, "Input",
 CellID->54070942],
Cell[51714, 1813, 304, 11, 36, "Output",
 CellID->102541279]
}, Open  ]],
Cell[CellGroupData[{
Cell[52055, 1829, 206, 6, 70, "Input",
 CellID->26145892],
Cell[52264, 1837, 304, 11, 36, "Output",
 CellID->710722294]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[52617, 1854, 224, 7, 70, "ExampleSection",
 CellID->12788],
Cell[52844, 1863, 80, 1, 70, "ExampleText",
 CellID->15610],
Cell[CellGroupData[{
Cell[52949, 1868, 677, 23, 70, "Input",
 CellID->16874],
Cell[53629, 1893, 77419, 1300, 70, "Output",
 CellID->57596894]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[131109, 3200, 310, 9, 70, "SeeAlsoSection",
 CellID->6694],
Cell[131422, 3211, 2455, 89, 70, "SeeAlso",
 CellID->27348]
}, Open  ]],
Cell[CellGroupData[{
Cell[133914, 3305, 314, 9, 70, "TutorialsSection",
 CellID->16405],
Cell[134231, 3316, 142, 3, 70, "Tutorials",
 CellID->24620],
Cell[134376, 3321, 156, 3, 70, "Tutorials",
 CellID->4063544],
Cell[134535, 3326, 153, 3, 70, "Tutorials",
 CellID->4738],
Cell[134691, 3331, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[134885, 3339, 319, 9, 70, "MoreAboutSection",
 CellID->167082332],
Cell[135207, 3350, 155, 3, 70, "MoreAbout",
 CellID->451200180],
Cell[135365, 3355, 155, 3, 70, "MoreAbout",
 CellID->240103007],
Cell[135523, 3360, 138, 3, 70, "MoreAbout",
 CellID->64894172],
Cell[135664, 3365, 161, 3, 70, "MoreAbout",
 CellID->135872905],
Cell[135828, 3370, 132, 3, 70, "MoreAbout",
 CellID->100515636],
Cell[135963, 3375, 151, 3, 70, "MoreAbout",
 CellID->290391201]
}, Open  ]],
Cell[136129, 3381, 50, 0, 70, "History"],
Cell[136182, 3383, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

