(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    236168,       8103]
NotebookOptionsPosition[    204093,       6993]
NotebookOutlinePosition[    207832,       7088]
CellTagsIndexPosition[    207463,       7077]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solving Recurrence Equations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SolvingRecurrenceEquations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Solving Recurrence Equations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], "Sum" :> 
          Documentation`HelpLookup["paclet:ref/Sum"], "ZTransform" :> 
          Documentation`HelpLookup["paclet:ref/ZTransform"], "DSolve" :> 
          Documentation`HelpLookup["paclet:ref/DSolve"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Solve\"\>", 2->"\<\"Sum\"\>", 
       3->"\<\"ZTransform\"\>", 4->"\<\"DSolve\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Equation Solving" :> 
          Documentation`HelpLookup["paclet:guide/EquationSolving"], 
          "Recurrence and Sum Functions" :> 
          Documentation`HelpLookup["paclet:guide/RecurrenceAndSumFunctions"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Discrete Mathematics\"\>", 
       2->"\<\"Equation Solving\"\>", 
       3->"\<\"Recurrence and Sum Functions\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RSolve", "ObjectName",
 CellID->17958],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RSolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RSolve"], "[", 
       RowBox[{
        StyleBox["eqn", "TI"], ",", 
        RowBox[{
         StyleBox["a", "TI"], "[", 
         StyleBox["n", "TI"], "]"}], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]solves a recurrence equation for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RSolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RSolve"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["eqn", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["eqn", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["a", "TI"], 
            StyleBox["1", "TR"]], "[", 
           StyleBox["n", "TI"], "]"}], ",", 
          RowBox[{
           SubscriptBox[
            StyleBox["a", "TI"], 
            StyleBox["2", "TR"]], "[", 
           StyleBox["n", "TI"], "]"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]solves a system of recurrence equations. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RSolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RSolve"], "[", 
       RowBox[{
        StyleBox["eqn", "TI"], ",", 
        RowBox[{
         StyleBox["a", "TI"], "[", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]solves a partial recurrence equation. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->8578]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RSolve"], "[", 
   RowBox[{
    StyleBox["eqn", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " gives solutions for ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " as pure functions. "
}], "Notes",
 CellID->25206],

Cell[TextData[{
 "The equations can involve objects of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "[", 
   RowBox[{
    StyleBox["n", "TI"], "+", 
    StyleBox["i", "TI"]}], "]"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " is any fixed integer, or objects of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["q", "TI"], "^", 
     StyleBox["i", "TI"]}], 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16750],

Cell[TextData[{
 "Equations such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["a", "TI"], "[", "0", "]"}], "==", 
   StyleBox["val", "TI"]}]], "InlineFormula"],
 " can be given to specify end conditions. "
}], "Notes",
 CellID->11840],

Cell[TextData[{
 "If not enough end conditions are specified, ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " will give general solutions in which undetermined constants are \
introduced. "
}], "Notes",
 CellID->15629],

Cell[TextData[{
 "The constants introduced by ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " are indexed by successive integers. The option ",
 Cell[BoxData[
  ButtonBox["GeneratedParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedParameters"]], "InlineFormula"],
 " specifies the function to apply to each index. The default is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeneratedParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeneratedParameters"], "->", 
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"]}]], "InlineFormula"],
 ", which yields constants ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 ", \[Ellipsis]",
 " ",
 ". "
}], "Notes",
 CellID->31118],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeneratedParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeneratedParameters"], "->", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      ButtonBox["Module",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Module"], "[", 
      RowBox[{
       RowBox[{"{", 
        ButtonBox["C",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/C"], "}"}], ",", 
       ButtonBox["C",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/C"]}], "]"}], "&"}], ")"}]}]], 
  "InlineFormula"],
 " guarantees that the constants of integration are unique, even across \
different invocations of ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3905],

Cell[TextData[{
 "For partial recurrence equations, ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " generates arbitrary functions ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["C",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/C"], "[", 
    StyleBox["n", "TI"], "]"}], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6838],

Cell[TextData[{
 "Solutions given by ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " sometimes include sums that cannot be carried out explicitly by ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 ". Dummy variables with local names are used in such sums. "
}], "Notes",
 CellID->18459],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " sometimes gives implicit solutions in terms of ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28751],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " handles both ordinary difference equations and ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 "\[Hyphen]difference equations. "
}], "Notes",
 CellID->18298],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " handles difference\[Hyphen]algebraic equations as well as ordinary \
difference equations. "
}], "Notes",
 CellID->28630],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " can solve linear recurrence equations of any order with constant \
coefficients. It can also solve many linear equations up to second order with \
non\[Hyphen]constant coefficients, as well as many nonlinear equations. "
}], "Notes",
 CellID->21909]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->417260006],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->304438872],

Cell["Solve a difference equation:", "ExampleText",
 CellID->186618846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"n", "+", "1"}], "]"}], "-", 
     RowBox[{"2", 
      RowBox[{"a", "[", "n", "]"}]}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", " ", "n"}], "]"}]], "Input",
 CellTags->"Ex--22029503983018204282,1",
 CellLabel->"In[1]:=",
 CellID->68317460],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["2", "n"], "+", 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{187, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22029503983018204282,1",
 CellLabel->"Out[1]=",
 CellID->533560623]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->281282100],

Cell["Include a boundary condition:", "ExampleText",
 CellID->98279580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"n", "+", "1"}], "]"}], "-", 
       RowBox[{"2", 
        RowBox[{"a", "[", "n", "]"}]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellTags->"Ex--22029503983018204282,2",
 CellLabel->"In[1]:=",
 CellID->306411985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["2", 
      RowBox[{"1", "+", "n"}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{126, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22029503983018204282,2",
 CellLabel->"Out[1]=",
 CellID->18443579]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->474279498],

Cell[TextData[{
 "Get a \"pure function\" solution for ",
 StyleBox["a", "TI"],
 ":"
}], "ExampleText",
 CellID->83962274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"n", "+", "1"}], "]"}], "-", 
       RowBox[{"2", 
        RowBox[{"a", "[", "n", "]"}]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "a", ",",
    "n"}], "]"}]], "Input",
 CellTags->"Ex--22029503983018204282,3",
 CellLabel->"In[1]:=",
 CellID->18971727],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["2", 
        RowBox[{"1", "+", "n"}]]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{207, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22029503983018204282,3",
 CellLabel->"Out[1]=",
 CellID->433575529]
}, Open  ]],

Cell["Substitute the solution into an expression:", "ExampleText",
 CellID->476784310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"n", "+", "1"}], "]"}], "-", 
       RowBox[{"2", 
        RowBox[{"a", "[", "n", "]"}]}]}], "\[Equal]", "1"}], ",", " ", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], "/.", "%"}], "//",
   "Simplify"}]], "Input",
 CellTags->"Ex--22029503983018204282,4",
 CellLabel->"In[2]:=",
 CellID->79016662],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"True", ",", "True"}], "}"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22029503983018204282,4",
 CellLabel->"Out[2]=",
 CellID->284398386]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(21)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25452],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Linear Difference Equations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->111409020],

Cell["Geometric equation: ", "ExampleText",
 CellID->84834757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      RowBox[{"c", " ", 
       RowBox[{"a", "[", "n", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "a", ",",
    "n"}], "]"}]], "Input",
 CellTags->"Ex--22029503983018204282,8",
 CellLabel->"In[1]:=",
 CellID->109983623],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      SuperscriptBox["c", "n"]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22029503983018204282,8",
 CellLabel->"Out[1]=",
 CellID->472553318]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->128545661],

Cell["First-order equation with variable coefficients: ", "ExampleText",
 CellID->571867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"n", "^", "2"}], "-", 
        RowBox[{"1", "/", "4"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], " ", 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellTags->"Ex--22029503983018204282,9",
 CellLabel->"In[1]:=",
 CellID->191201536],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "n"}], "]"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{
        FractionBox["1", "2"], "+", "n"}], "]"}]}], 
     RowBox[{"\[Pi]", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "n"}], "]"}]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{290, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22029503983018204282,9",
 CellLabel->"Out[1]=",
 CellID->306839004]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96936204],

Cell["A third-order constant coefficient equation: ", "ExampleText",
 CellID->35387769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "3"}], "]"}], "\[Equal]", 
    RowBox[{"2", 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", " ", "a", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229562079],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"n", "/", "3"}]], " ", 
        RowBox[{"C", "[", "3", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"n", "/", "3"}]], " ", 
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"Cos", "[", 
         FractionBox[
          RowBox[{"2", " ", "n", " ", "\[Pi]"}], "3"], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"n", "/", "3"}]], " ", 
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"Sin", "[", 
         FractionBox[
          RowBox[{"2", " ", "n", " ", "\[Pi]"}], "3"], "]"}]}]}]}], "]"}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{484, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->874896272]
}, Open  ]],

Cell["Initial value conditions: ", "ExampleText",
 CellID->285306073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "3"}], "]"}], "\[Equal]", 
      RowBox[{"2", 
       RowBox[{"a", "[", "n", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "\[Equal]", "2"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "2", "]"}], "\[Equal]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", " ", "a", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33773584],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "3"]}], " ", 
       SuperscriptBox["2", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         FractionBox["n", "3"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["2", 
          RowBox[{"1", "/", "3"}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["2", 
           RowBox[{"2", "/", "3"}]]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{"2", " ", "n", " ", "\[Pi]"}], "3"], "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["2", 
           RowBox[{"1", "/", "3"}]], " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{"2", " ", "n", " ", "\[Pi]"}], "3"], "]"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["2", 
           RowBox[{"2", "/", "3"}]], " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{"2", " ", "n", " ", "\[Pi]"}], "3"], "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["2", 
           RowBox[{"1", "/", "3"}]], " ", 
          SqrtBox["3"], " ", 
          RowBox[{"Sin", "[", 
           FractionBox[
            RowBox[{"2", " ", "n", " ", "\[Pi]"}], "3"], "]"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["2", 
           RowBox[{"2", "/", "3"}]], " ", 
          SqrtBox["3"], " ", 
          RowBox[{"Sin", "[", 
           FractionBox[
            RowBox[{"2", " ", "n", " ", "\[Pi]"}], "3"], "]"}]}]}], ")"}]}]}],
      "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{499, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->98805365]
}, Open  ]],

Cell["Plot the solution:", "ExampleText",
 CellID->299862468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "/.", 
      RowBox[{"First", "[", "%", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->74484381],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 2.}, {2., -1.}, {3., 2.}, {4., 4.}, {5., -2.}, {6.,
    4.}, {7., 8.}, {8., -4.}, {9., 8.}, {10., 16.}, {11., -8.}, {12., 16.}, {
   13., 32.}, {14., -16.}, {15., 32.}, {1., 0.}, {2., 0.}, {3., 0.}, {4., 
   0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}, {11., 
   0.}, {12., 0.}, {13., 0.}, {14., 0.}, {15., 0.}, {1., 2.}, {2., -1.}, {3., 
   2.}, {4., 4.}, {5., -2.}, {6., 4.}, {7., 8.}, {8., -4.}, {9., 8.}, {10., 
   16.}, {11., -8.}, {12., 16.}, {13., 32.}, {14., -16.}, {15., 
   32.}}, {{{}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{17, 2}], LineBox[{20, 5}], 
      LineBox[{23, 8}], LineBox[{26, 11}], LineBox[{29, 14}]}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{16, 1}], LineBox[{18, 3}], 
      LineBox[{19, 4}], LineBox[{21, 6}], LineBox[{22, 7}], LineBox[{24, 9}], 
      LineBox[{25, 10}], LineBox[{27, 12}], LineBox[{28, 13}], 
      LineBox[{30, 15}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 
       45}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 15.}, {-16., 32.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->95391271]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132668922],

Cell["Second-order inhomogeneous equation: ", "ExampleText",
 CellID->258898945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"n", "+", "2"}], "]"}], "-", 
     RowBox[{"4", 
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}]}], "+", 
     RowBox[{"3", 
      RowBox[{"a", "[", "n", "]"}]}]}], "\[Equal]", 
    RowBox[{"n", " ", 
     RowBox[{"4", "^", "n"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108563027],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      FractionBox["1", "9"], " ", 
      SuperscriptBox["2", 
       RowBox[{"2", " ", "n"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "16"}], "+", 
        RowBox[{"3", " ", "n"}]}], ")"}]}], "+", 
     RowBox[{"C", "[", "1", "]"}], "+", 
     RowBox[{
      SuperscriptBox["3", "n"], " ", 
      RowBox[{"C", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{275, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->401082780]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->234440931],

Cell["\<\
Second-order variable coefficient equation in terms of elementary functions:\
\>", "ExampleText",
 CellID->399558608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "+", "4"}], ")"}], " ", 
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "2"}], "]"}]}], "-", 
     RowBox[{"a", "[", 
      RowBox[{"n", "+", "1"}], "]"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}], 
      RowBox[{"a", "[", "n", "]"}]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53802919],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"2", " ", "n"}]}], ")"}], " ", 
       RowBox[{"C", "[", "1", "]"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"3", " ", "n"}], "+", 
         SuperscriptBox["n", "2"]}], ")"}]}]], "+", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "n"], "+", 
         RowBox[{"2", " ", "n"}]}], ")"}], " ", 
       RowBox[{"C", "[", "2", "]"}]}], 
      RowBox[{"8", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"3", " ", "n"}], "+", 
         SuperscriptBox["n", "2"]}], ")"}]}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{322, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->626955381]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"2", "^", "n"}], " ", 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->59156921],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["2", 
        FractionBox[
         SuperscriptBox["n", "2"], "4"]], " ", 
       RowBox[{"C", "[", "1", "]"}], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox[
         RowBox[{"1", "+", "n"}], "2"], "]"}]}], 
      SqrtBox["\[Pi]"]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"], " ", 
       SuperscriptBox["2", 
        FractionBox[
         SuperscriptBox["n", "2"], "4"]], " ", 
       RowBox[{"C", "[", "2", "]"}], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox[
         RowBox[{"1", "+", "n"}], "2"], "]"}]}], 
      SqrtBox["\[Pi]"]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{381, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->467953399]
}, Open  ]],

Cell["Euler\[Dash]Cauchy equation:", "ExampleText",
 CellID->131263866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"a", "[", "n", "]"}]}], "-", 
     RowBox[{"2", " ", "n", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"a", "[", "n", "]"}]}], "+", 
        RowBox[{"a", "[", 
         RowBox[{"n", "+", "1"}], "]"}]}], ")"}]}], "+", 
     RowBox[{"n", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "n"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "[", "n", "]"}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"a", "[", 
          RowBox[{"n", "+", "1"}], "]"}]}], "+", 
        RowBox[{"a", "[", 
         RowBox[{"n", "+", "2"}], "]"}]}], ")"}]}]}], "\[Equal]", "0"}], ",", 
   "a", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4460471],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       FractionBox[
        RowBox[{"n", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", 
           SuperscriptBox["n", "2"]}], ")"}], " ", 
         RowBox[{"C", "[", "1", "]"}]}], 
        RowBox[{"1", "+", "n"}]], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", 
          SuperscriptBox["n", "2"]}], ")"}], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{353, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->49098447]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4921868],

Cell["\<\
In general special functions are required to express solutions: \
\>", "ExampleText",
 CellID->673393368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}], 
     RowBox[{"a", "[", 
      RowBox[{"n", "+", "2"}], "]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "n"}], "+", "3"}], ")"}], " ", "x", " ", 
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}], " ", 
      RowBox[{"a", "[", "n", "]"}]}]}]}], ",", " ", "a", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365935554],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"LegendreP", "[", 
         RowBox[{"n", ",", "x"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"LegendreQ", "[", 
         RowBox[{"n", ",", "x"}], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{437, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26442513]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"2", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "n"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"c", " ", "z"}]}], ")"}]}], " ", 
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}]}], "-", 
     RowBox[{"a", "[", 
      RowBox[{"n", "+", "2"}], "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->305727159],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"n", ",", 
        RowBox[{"b", "+", 
         RowBox[{"c", " ", "z"}]}]}], "]"}], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      RowBox[{"BesselY", "[", 
       RowBox[{"n", ",", 
        RowBox[{"b", "+", 
         RowBox[{"c", " ", "z"}]}]}], "]"}], " ", 
      RowBox[{"C", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{387, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80657666]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"2", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", "n"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", "z"}], "+", "d"}], ")"}], " ", 
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}], "/", "n"}], " ", 
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "2"}], "]"}]}]}]}], ",", "a", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->63036633],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"ChebyshevT", "[", 
          RowBox[{"n", ",", 
           RowBox[{"d", "+", 
            RowBox[{"c", " ", "z"}]}]}], "]"}]}], "n"], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"C", "[", "2", "]"}], " ", 
         RowBox[{"ChebyshevU", "[", 
          RowBox[{"n", ",", 
           RowBox[{"d", "+", 
            RowBox[{"c", " ", "z"}]}]}], "]"}]}], "n"]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{518, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->453481659]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"n", "+", "2"}], "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "n"}], "+", "1"}], ")"}], " ", 
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"n", "^", "2"}], " ", 
      RowBox[{"a", "[", "n", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"a", "[", "n", "]"}], ",", " ", "n"}], " ", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->264247097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"]}], " ", 
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}], ")"}], "!"}]}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"], " ", 
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}], ")"}], "!"}], " ", 
      RowBox[{"(", 
       RowBox[{"EulerGamma", "+", 
        RowBox[{"PolyGamma", "[", 
         RowBox[{"0", ",", "n"}], "]"}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{548, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->366770820]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Nonlinear Difference Equations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->852448192],

Cell["Solvable logistic equations:", "ExampleText",
 CellID->661033615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"a", "[", "n", "]"}]}], ")"}], 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15985498],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SuperscriptBox["2", "n"], " ", 
        RowBox[{"C", "[", "1", "]"}]}]]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{154, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102628498]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"a", "[", "n", "]"}]}], ")"}], 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->322710185],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], "+", 
     RowBox[{"Cos", "[", 
      RowBox[{
       SuperscriptBox["2", "n"], " ", 
       RowBox[{"C", "[", "1", "]"}]}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{179, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221253227]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{"4", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"a", "[", "n", "]"}]}], ")"}], 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->223835609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        SuperscriptBox["2", "n"], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{193, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->230235801]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15645020],

Cell["Riccati equations: ", "ExampleText",
 CellID->284707688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "[", "n", "]"}], "+", "15"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "[", "n", "]"}], "+", "7"}], ")"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67729940],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", 
           FractionBox["1", "4"]}], ")"}], "n"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "n"], " ", 
        SuperscriptBox["2", 
         RowBox[{"1", "-", "n"}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox["1", "4"]}], ")"}], "n"], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "n"], " ", 
        SuperscriptBox["2", 
         RowBox[{"1", "-", "n"}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{249, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->691719003]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}], " ", 
      RowBox[{"a", "[", "n", "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"a", "[", "n", "]"}]}], "+", "2"}], "\[Equal]", "0"}], ",", "a",
    ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->113079553],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      FractionBox[
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", 
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"3", " ", "n", " ", "\[Pi]"}], "4"], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           FractionBox["3", "4"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "n"}], ")"}], " ", "\[Pi]"}], "]"}]}], "+", 
        RowBox[{
         SqrtBox["2"], " ", 
         RowBox[{"Sin", "[", 
          FractionBox[
           RowBox[{"3", " ", "n", " ", "\[Pi]"}], "4"], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{
           FractionBox["3", "4"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "n"}], ")"}], " ", "\[Pi]"}], "]"}]}]}], 
       RowBox[{
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           FractionBox["3", "4"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "n"}], ")"}], " ", "\[Pi]"}], "]"}]}], "+", 
        RowBox[{"Sin", "[", 
         RowBox[{
          FractionBox["3", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "n"}], ")"}], " ", "\[Pi]"}], "]"}]}]]}], 
     "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{549, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62867779]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56549341],

Cell["\<\
Solutions in terms of trigonometric and hyperbolic functions:\
\>", "ExampleText",
 CellID->8860629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"40", "+", 
       RowBox[{"21", " ", 
        RowBox[{"a", "[", "n", "]"}]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{
         RowBox[{"a", "[", "n", "]"}], "^", "2"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{
         RowBox[{"a", "[", "n", "]"}], "^", "3"}]}]}], ")"}], "/", "9"}]}], 
   ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->313847424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"2", "-", 
     RowBox[{"3", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        SuperscriptBox["3", "n"], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232795130]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "7300"}], "+", 
      RowBox[{"9600", " ", 
       RowBox[{"a", "[", "n", "]"}]}], "+", 
      RowBox[{"300", " ", 
       RowBox[{
        RowBox[{"a", "[", "n", "]"}], "^", "2"}]}], "-", 
      RowBox[{"200", " ", 
       RowBox[{
        RowBox[{"a", "[", "n", "]"}], "^", "3"}]}], "+", 
      RowBox[{
       RowBox[{"a", "[", "n", "]"}], "^", "4"}]}], 
     RowBox[{"2108", "+", 
      RowBox[{"584", " ", 
       RowBox[{"a", "[", "n", "]"}]}], "-", 
      RowBox[{"288", " ", 
       RowBox[{
        RowBox[{"a", "[", "n", "]"}], "^", "2"}]}], "-", 
      RowBox[{"4", " ", 
       RowBox[{
        RowBox[{"a", "[", "n", "]"}], "^", "3"}]}], "+", 
      RowBox[{
       RowBox[{"a", "[", "n", "]"}], "^", "4"}]}]]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->227334952],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"1", "-", 
     RowBox[{"7", " ", 
      RowBox[{"Tan", "[", 
       RowBox[{
        SuperscriptBox["4", "n"], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->176964998]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "168"}], "-", 
      RowBox[{"36", " ", 
       RowBox[{"a", "[", "n", "]"}]}], "+", 
      RowBox[{"12", " ", 
       RowBox[{
        RowBox[{"a", "[", "n", "]"}], "^", "2"}]}], "-", 
      RowBox[{
       RowBox[{"a", "[", "n", "]"}], "^", "3"}]}], 
     RowBox[{
      RowBox[{"-", "88"}], "-", 
      RowBox[{"12", " ", 
       RowBox[{"a", "[", "n", "]"}]}], "+", 
      RowBox[{"3", " ", 
       RowBox[{
        RowBox[{"a", "[", "n", "]"}], "^", "2"}]}]}]]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1748316],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"2", "-", 
     RowBox[{"5", " ", 
      RowBox[{"Sec", "[", 
       RowBox[{
        SuperscriptBox["3", "n"], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->36315714]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28017190],

Cell["Higher-order equations:", "ExampleText",
 CellID->15242058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", " ", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"n", "+", "1"}], "]"}], " ", 
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "^", "2"}]}]}], ",", " ", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103458102],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"], " ", 
       RowBox[{"C", "[", "1", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["2", "n"], " ", 
       RowBox[{"C", "[", "2", "]"}]}]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{169, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->369859954]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", " ", 
    RowBox[{
     RowBox[{"b", "^", "n"}], " ", 
     RowBox[{"a", "[", 
      RowBox[{"n", "+", "1"}], "]"}], " ", 
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "^", "2"}]}]}], ",", " ", 
   RowBox[{"a", "[", "n", "]"}], ",", " ", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2493408],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"], " ", 
       RowBox[{"C", "[", "1", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["2", "n"], " ", 
       RowBox[{"C", "[", "2", "]"}]}], "-", 
      RowBox[{
       FractionBox["1", "12"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"2", " ", "n"}]], "+", 
         RowBox[{"4", " ", "n"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], 
           RowBox[{"2", " ", "n"}]], " ", "n"}]}], ")"}], " ", 
       RowBox[{"Log", "[", "b", "]"}]}]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{342, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149078423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->491835137],

Cell["Nonlinear convolution equation:", "ExampleText",
 CellID->92646668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "==", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "[", "m", "]"}], " ", 
         RowBox[{"a", "[", 
          RowBox[{"n", "-", "m"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181061249],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{"Binomial", "[", 
      RowBox[{
       RowBox[{"2", " ", "n"}], ",", "n"}], "]"}], 
     RowBox[{"1", "+", "n"}]]}], "}"}], "}"}]], "Output",
 ImageSize->{186, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->552797202]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Systems of Difference Equations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->171831079],

Cell["Linear system with constant coefficients:", "ExampleText",
 CellID->732989362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"n", "+", "1"}], "]"}], "+", 
       RowBox[{"z", "[", "n", "]"}]}], "\[Equal]", "3"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "n", "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"z", "[", 
         RowBox[{"n", "+", "1"}], "]"}]}]}], "\[Equal]", "1"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "n", "]"}], ",", 
     RowBox[{"z", "[", "n", "]"}]}], "}"}], ",", " ", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18586062],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWk1v00AQdeI4TdJS+oUoCEjhggRHpCKqAioHQIhyQkJC4hBKoT0gUKlU
OMGh5eOM+rv6S6D/AONd7yab57FnHCdOa6m2Z3d2dmb2eT1+6Xpnd2vzfWd3
e6Oz9Gin83Fre+PT0sMPO1GTX/G8yr7necuLXnQfRnf6Tx0H0V98uxf9VaPm
wLnGPV/UnW9HhF4N5OoJ0Fw0Xk+a6wvQWgJ5GuQWyDNgbxn6Fwvaq4ujclsn
QX7ORDnDeHWWsX+LibqofYyazoKyEkSNurfW7Y0OpRo328NnPJoytiagPTDt
V4nxlD7KTdfHjPnrxuuAiJQaj/PUjF47Zfy4/JSvpBe4K+gRtqoiLcTSJDmK
WuekFq76FJNFlDlcY3ZpL/LmlMJG0mo7p5VyYpOtMaIP+yt6HO5CFGZl2W4a
xAfETlI37bhzqydKiS1zbRKzB8STZOfBfEufMDLv4G8eNFl/0M5CSlxp48uK
B9dHEn9UCGnMxLiZZTwabB86AzL3fDWYPGDeS9mbCuAI58fx80x8pexPBZ8T
fk/Sb7perUI8VwpdqhKsEu15air0H/HE4Qv7Txu+UEZ8YXzjxhf24z5WtCZW
mIqNxgfOdxlk3AUx/rx4QXtl42OOkTk8jNp/lPF5l60/92V4QbuC7y66/nYz
ouRWhkzNhRlGfUR4385He1O4Np4mrbh7AxUZejqOyOTVqgwlLutwKYxrudmw
V7NmxUfVIsrOOWhvmHbSq763IKJdjayZkVXnalko6ynO2Oq3XIpfviPL+JvX
uvXo6OirPryqOinZaAVM/4OEn/dDt8pOH7mSGHlD5PErE7eG9vHxsTarT5Fg
RzL9a8bGqrlWE2vVbfVjE70IelbuGL2bIr//QeveCEdtGAy0QrqC+wnyRIre
u5BiXDdBq5FYyV/O/P092n/vDVhoJvQOU0bi3BNmDQ7N9XM3fncXVaptcmZ1
uqJ71N0B3OGzrnriGbia6LRoVk3ebIR2H14HvfMgY42P30jIJq9Af7ugPaxh
5kTRcjLWDU+YLGAlhl5z7PJtJitF7fsmW/ODZ6cgm21Z2jQ2GyO2XAy+vaia
n+JsMENF2Wzr5zViHgmbPSo/yW8CtlLv28dzV3Tkd0ZiFPk1mZvz5dYfv+m4
/I6Gz6atIlYwbxxmRhObvGpXCIn3U/uV3p0FZ3XescU47TROGnEg5Xrtr1Bp
XC/HkZE5zsCnlLvGcZaT57j5vFz2sOPjuGz9tS9jCvqquuEw2nkZtLwM70h2
owJokvyGmvVWxv5SdqgC8cboktSysn1wEFY7rZJB7OVld086ttB/DluoP25s
cWx2BrYktW8uZhuxgXJeJhh/Vy4bKxzW82IDv3eGHQ/HbMv2GfL/OjKyQnPa
eZlejvXPZHr73rnD4a/pqNwVwaioKFHGJ2DUUcreGXJcuByF4nqVSypTvidl
iBdAyzLa5HrU3YjjcyvM5qvnjDeYWW5lLFONUQzDP9+RL4py/TQclGVeY0bk
Z7zvijx+HA6Da14V6CsE+wKblgW/J/L/GcjqdL3gSMQmaqbx0t/M6jdS+ve1
9ZdhGgu9D/pJ/vm7vrwdeOSmye0B6NtfbX5orb/Q+1u3/jF+aw5cd8VstFf5
D1NyfuA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{388, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->355257818]
}, Open  ]],

Cell["With boundary conditions:", "ExampleText",
 CellID->100028497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"n", "+", "1"}], "]"}], "+", 
       RowBox[{"z", "[", "n", "]"}]}], "\[Equal]", "3"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "n", "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"z", "[", 
         RowBox[{"n", "+", "1"}], "]"}]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "5"}], ",", 
     RowBox[{
      RowBox[{"z", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}], ",", " ", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->287853158],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "n", "}"}], ",", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox["n", "2"]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "n"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["2", 
            RowBox[{
             FractionBox["1", "2"], "+", 
             FractionBox["n", "2"]}]]}]}], ")"}]}]}], "]"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "n", "}"}], ",", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           FractionBox["n", "2"]}]]}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "n"]}], "+", 
          SuperscriptBox["2", 
           RowBox[{"2", "+", 
            FractionBox["n", "2"]}]]}], ")"}]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{324, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4176427]
}, Open  ]],

Cell["Plot their solution:", "ExampleText",
 CellID->7546931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", " ", "@", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y", "[", "n", "]"}], ",", 
         RowBox[{"z", "[", "n", "]"}]}], "}"}], "/.", 
       RowBox[{"First", "[", "%", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "15"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->62603598],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJztk70Jg1AURiWVRQqTWFhYGBEREXGDvBkyQQikzgqO4iZxhIyQMmWKVIH8
cu8VPCvEB3I474DwFW+9P24PM8/zdt/vRzm3jTB0egH6btwD5Rz3xki5UMbo
ibBdqqfomdCt1HP0QthZL9Er4dl6jd4Ir9Ztv3HY3wts/+UkDNDtv3ftEbrt
f2hP0FP1p/YMXfe3L+0Fuu53b+0Vuu7vrDfow247bqw+PICH8AgewxN4Cs/g
ObyAl/AKXsMb+LRfOL1/4f+8/w+pEGPc
   "], {{{}, {}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{49, 1}], LineBox[{50, 2}], 
      LineBox[{51, 3}], LineBox[{52, 4}], LineBox[{53, 5}], LineBox[{54, 6}], 
      LineBox[{55, 7}], LineBox[{56, 8}], LineBox[{57, 9}], LineBox[{58, 10}],
       LineBox[{59, 11}], LineBox[{60, 12}], LineBox[{61, 13}], 
      LineBox[{62, 14}], LineBox[{63, 15}], LineBox[{64, 16}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], Opacity[0.2], LineBox[{34, 18}], 
      LineBox[{35, 19}], LineBox[{36, 20}], LineBox[{37, 21}], 
      LineBox[{38, 22}], LineBox[{39, 23}], LineBox[{40, 24}], 
      LineBox[{41, 25}], LineBox[{42, 26}], LineBox[{43, 27}], 
      LineBox[{44, 28}], LineBox[{45, 29}], LineBox[{46, 30}], 
      LineBox[{47, 31}], LineBox[{48, 32}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], Opacity[0.2], 
      LineBox[{33, 17}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 
       80}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      PointBox[{81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
       96}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {-2., 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->327745457]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145073694],

Cell["Linear fractional systems: ", "ExampleText",
 CellID->157686389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{"3", 
        RowBox[{"y", "[", "n", "]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"y", "[", "n", "]"}], "+", 
        RowBox[{"z", "[", "n", "]"}]}]]}], ",", 
     RowBox[{
      RowBox[{"z", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{"z", "[", "n", "]"}], 
       RowBox[{"1", "+", 
        RowBox[{"y", "[", "n", "]"}], "+", 
        RowBox[{"z", "[", "n", "]"}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "n", "]"}], ",", " ", 
     RowBox[{"z", "[", "n", "]"}]}], "}"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->392299281],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "n", "]"}], "\[Rule]", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["3", "n"], " ", 
       RowBox[{"C", "[", "1", "]"}]}], 
      RowBox[{"2", "-", 
       RowBox[{"C", "[", "1", "]"}], "+", 
       RowBox[{
        SuperscriptBox["3", "n"], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{"2", " ", "n", " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]]}], ",", 
    RowBox[{
     RowBox[{"z", "[", "n", "]"}], "\[Rule]", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"C", "[", "2", "]"}]}], 
      RowBox[{"2", "-", 
       RowBox[{"C", "[", "1", "]"}], "+", 
       RowBox[{
        SuperscriptBox["3", "n"], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{"2", " ", "n", " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{469, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227533877]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{
        RowBox[{"x", "[", "n", "]"}], "+", 
        RowBox[{"3", " ", 
         RowBox[{"y", "[", "n", "]"}]}]}], 
       RowBox[{"4", "+", 
        RowBox[{"x", "[", "n", "]"}], "+", 
        RowBox[{"y", "[", "n", "]"}], "+", 
        RowBox[{"z", "[", "n", "]"}]}]]}], ",", 
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{
        RowBox[{"y", "[", "n", "]"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"z", "[", "n", "]"}]}]}], 
       RowBox[{"4", "+", 
        RowBox[{"x", "[", "n", "]"}], "+", 
        RowBox[{"y", "[", "n", "]"}], "+", 
        RowBox[{"z", "[", "n", "]"}]}]]}], ",", 
     RowBox[{
      RowBox[{"z", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{"z", "[", "n", "]"}], 
       RowBox[{"4", "+", 
        RowBox[{"x", "[", "n", "]"}], "+", 
        RowBox[{"y", "[", "n", "]"}], "+", 
        RowBox[{"z", "[", "n", "]"}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "n", "]"}], ",", 
     RowBox[{"y", "[", "n", "]"}], ",", 
     RowBox[{"z", "[", "n", "]"}]}], "}"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->300796514],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{542, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->771248691]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172707687],

Cell["Diagonal system: ", "ExampleText",
 CellID->10404424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "/", 
        RowBox[{"2", "^", "n"}]}], " ", 
       RowBox[{"y", "[", "n", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"z", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"n", "^", "2"}], " ", 
       RowBox[{"z", "[", "n", "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "n", "]"}], ",", 
     RowBox[{"z", "[", "n", "]"}]}], "}"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->239503210],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "n", "]"}], "\[Rule]", 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n"}]], " ", 
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "n"}], "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"z", "[", "n", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Pochhammer", "[", 
        RowBox[{"1", ",", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "n"}]}], "]"}], "2"]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{474, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83856992]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20002354],

Cell["\<\
Variable coefficient linear system with a polynomial solution:\
\>", "ExampleText",
 CellID->34367554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "n"}], "+", 
            RowBox[{"n", "^", "2"}]}], ")"}], " ", 
          RowBox[{"x", "[", "n", "]"}]}], 
         RowBox[{"n", "^", "2"}]]}], "+", 
       RowBox[{"x", "[", 
        RowBox[{"n", "+", "1"}], "]"}], "+", 
       FractionBox[
        RowBox[{"y", "[", "n", "]"}], "n"], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "n"}]}], ")"}], " ", 
         RowBox[{"z", "[", "n", "]"}]}], 
        RowBox[{"n", "^", "2"}]]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"y", "[", "n", "]"}]}], "+", 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"n", "^", "2"}], 
          RowBox[{"y", "[", 
           RowBox[{"n", "+", "1"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", "n"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"x", "[", "n", "]"}]}], "+", 
            RowBox[{"z", "[", "n", "]"}]}], ")"}]}]}], 
        RowBox[{"n", "^", "2"}]]}], "==", "0"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"-", 
         RowBox[{"x", "[", "n", "]"}]}], "+", 
        RowBox[{"y", "[", "n", "]"}], "-", 
        RowBox[{"n", " ", 
         RowBox[{"z", "[", "n", "]"}]}], "+", 
        RowBox[{"n", " ", 
         RowBox[{"z", "[", 
          RowBox[{"n", "+", "1"}], "]"}]}]}], "n"], "==", "0"}]}], "}"}], ",",
    " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "}"}], ",", " ", "n"}], " ", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25205159],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "n", "}"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["n", "2"], " ", 
         RowBox[{"C", "[", "1", "]"}]}], "+", 
        RowBox[{"C", "[", "2", "]"}], "+", 
        RowBox[{"n", " ", 
         RowBox[{"C", "[", "3", "]"}]}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "n", "}"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["n", "2"], " ", 
         RowBox[{"C", "[", "1", "]"}]}], "+", 
        RowBox[{"C", "[", "2", "]"}]}]}], "]"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "n", "}"}], ",", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], "+", 
        RowBox[{"n", " ", 
         RowBox[{"C", "[", "3", "]"}]}]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{457, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57524243]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->477117037],

Cell["Linear constant coefficient difference-algebraic system:", "ExampleText",
 CellID->193663299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"n", "+", "1"}], "]"}], "+", 
       RowBox[{"z", "[", 
        RowBox[{"n", "+", "1"}], "]"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"y", "[", "n", "]"}], "-", 
       RowBox[{"3", 
        RowBox[{"z", "[", "n", "]"}]}]}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "n", "]"}], "+", 
       RowBox[{"2", 
        RowBox[{"z", "[", "n", "]"}]}]}], "\[Equal]", "1"}]}], "}"}], ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "n", "]"}], ",", 
     RowBox[{"z", "[", "n", "]"}]}], "}"}], ",", " ", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118602188],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "n", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{
       FractionBox["1", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["5", "n"]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["5", "n"], " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}]}], ",", 
    RowBox[{
     RowBox[{"z", "[", "n", "]"}], "\[Rule]", 
     RowBox[{"1", "+", 
      RowBox[{
       FractionBox["1", "16"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["5", "n"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["5", "n"], " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{503, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250058074]
}, Open  ]],

Cell["An index-2 system:", "ExampleText",
 CellID->281573425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"x", "[", "n", "]"}], "+", 
       RowBox[{"2", 
        RowBox[{"y", "[", "n", "]"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "n", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"x", "[", "n", "]"}], "+", 
       RowBox[{"2", "^", "n"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "n", "]"}], "+", 
       RowBox[{"z", "[", "n", "]"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "n", "]"}], ",", 
     RowBox[{"y", "[", "n", "]"}], ",", 
     RowBox[{"z", "[", "n", "]"}]}], "}"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->356830790],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "n", "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", "8"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "16"}], " ", 
         SuperscriptBox["3", "n"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["2", "3"], ")"}], "n"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["3", "n"], " ", 
         RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}], ",", 
    RowBox[{
     RowBox[{"y", "[", "n", "]"}], "\[Rule]", 
     RowBox[{
      SuperscriptBox["2", "n"], "+", 
      RowBox[{
       FractionBox["1", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["3", "n"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              FractionBox["2", "3"], ")"}], "n"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["3", "n"], " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}]}], ",", 
    RowBox[{
     RowBox[{"z", "[", "n", "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", "8"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox["3", "n"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["2", "3"], ")"}], "n"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["3", "n"], " ", 
         RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{542, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118185362]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Partial Difference Equations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->414868684],

Cell["\<\
First-order linear partial difference equation with constant coefficients:\
\>", "ExampleText",
 CellID->5093003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{
       RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], "-", 
     RowBox[{
      RowBox[{"3", "/", "4"}], 
      RowBox[{"a", "[", 
       RowBox[{"m", ",", 
        RowBox[{"n", "+", "1"}]}], "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"m", ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", " ", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->391856253],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"m", ",", "n"}], "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["4", "3"], ")"}], 
      RowBox[{"1", "-", "m"}]], " ", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"m", "+", "n"}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{208, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50826275]
}, Open  ]],

Cell[TextData[{
 "Substitute the function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", 
   RowBox[{"2", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " for the free function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->277664129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"m", ",", "n"}], "]"}], "/.", "%"}], "/.", 
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Rule]", 
   RowBox[{"Function", "[", 
    RowBox[{"k", ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "k"}], "]"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->96371284],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["4", "3"], ")"}], 
    RowBox[{"1", "-", "m"}]], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n"}], ")"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{149, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->741271988]
}, Open  ]],

Cell["Plot the resulting solution:", "ExampleText",
 CellID->1003096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->219272216],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNfXdYVVm2531lrqqu2F1d9bpfv56X38xgqCrLyjl1dW2SIJgVFTGAASMq
5qwYQAVEkiKIKCgIknPOOeecoxLuXd/MXmvvc8Er1a/e980f41d1OWffE/ZZ
8bfCPpet3mG1znr1jg1rVv/5h+2rt1ptWGP75++3bOdDU/5OpVKF8P8d31bx
7f/Dt+j/EADgXzz3acM/p/ADXuB/X+B/v6DRLfg5le8C/ZPfq6aMj3z6//lx
0+TzzNc+Je5NkX9nPHf++/Rn//+j8T3yPi/8wvc7JdVpQuvWrVNN4ICYse2E
K+AFPqLRrfK86fS0/ERxUdWHzzzlLLqr+FYcsID+bJJnv/QL32+Q59OsxKTF
sdO0x8r7fUB/LeX1XpswG9zU5cV7dPRaefXfTnpF8dSr5RXf+i+u+C4dvULS
5u1nn0deQ9z1Y7n3j/Luf9S58hSdK8+jsz7TGX1HXuVPOmdP1Tlu7qRn/17e
+3/onD1N57g5k579W3nvf/5VZ38i7/U7mCCBE47SncN0ne9na68ycfR1OYf/
0Dl7hs5xenT2p/Ler8q//+tXnfWTvIfeJDPEcTGzH+TeXJ2jZulck+6p+k7O
4L1fdfTX8trzdY5+Uefo/0lHfymv/aHO0S/pHP2fWq5qNV7qFs5qKo39V2cr
XEXrMQ3PmHYmFC5Fw7Uk8MgiA/KKznnEKZobDs5TznvJzgfvfvgeHH8Ap0Lg
fAQ4xcP1NPDOxXG80svyXuIpP5B7c5W5vnYmAo4Fg30A7LkFu7xgvy+eyK/G
Z3Q+HC7SpNwzwacAAspxaroz+3e67nuT0ENP3kv1O/c8uJoGl5Pwm5OhcOg+
2N2GHR6wxxsO+MGR+zh+7jHe7EoCuKaCZzb4FsG9CsWW6t7z3+gmcydQg+7z
VkA13CwGl0y4EAenI+BEKF54/x18rh3usPcWHPSHY0Fw+hGOX46Vj3YrH/xL
Iaga74bX+c2kd5s9Ufbe4RsRbfCgHnzLwT0fnFLgTCQcCoL9d/HSOz1hmxvw
z3234VAAnHgIZ8NwnPPGNQV5w+/Hd0Pq6QFfiG5/5n66MvOvdP//BeN2kJ72
jag2vEhADdwswWe+GA8nw+DgfdhzG3Z64VfbrsNu4uiRe3AyGNl5OUZwaSan
bUgdPG7CCcR0AL9URCtM8uz/Qvd+Ccatrdanvc43knsgtgPCW+BhA57NKcH5
zCdyiiay+yZsv4Hjtjdgz02wv8OtHEmtVw74lUBgFTyqh4gWmkM7RLZBeCuE
NZP/eHnSeZDmPuN/356g40SVlzL6IKUH4rrwYoF1cIso7RAHpx6jnB+8J+fw
BheF40Eo5RejUOpupONxnC98VqENENWKs4qmWfHx0GYIbgTVOCX+9Rfm85b8
njzwTL6R3Q/8v/ReSOqB6A4IaQL/KqF5b+71RT5xJllfha2usMuTVDkATj6U
rHJOBk6pOyU4zikV2YLEJonB86eGtcCjJkl5Xb5NkXT54y/M8035/QKFbtNz
BiCnH7KIelwiOB9o/E8uWahNqEf+sMML5dr6Gmy+ArZuyFM+fiwQFepCJFyJ
B7d0NBT3K5Cx/CvOVWGFohTehjRCUB3cqYBJeKzru975hbm/LudMGOpPfCOl
C9J7ILMXv0zrgYROyTX/SnAvQN3kD3CcdH67O9g4w8bLYHMNdrrDPh/g9BbG
53I0OCeh5blTDA9qUDXo+V+M60SS8ws+5uQmMbhXA7dLwTN/smfQ9eK/9Ayv
wLgHnir5R/ebltAO/Hn4w+SS5Ahe/47fP6gWhdk5E85Fw/EQOBQI3LLx7zY5
woZLsNUFdnuiNT1K1tSBO4I4uJ4KN/Pgbpm8yiwuPvxPLD0R13cuQFweOT84
oWjSulKki4feecYavCyf4T+VuU/d6YfXX3pYY76P/NM0xSv8W3QLJHVAWjdk
90HuAD4bH03tRUnTMor7B26x7fxgpzdsdcNxqwvAn277ddjrjaabeyVhR68l
omLwDc6osEZU1oQu4IyKIfXgkhYqpXeaTyl45IFzOlyKn9SuKChd6ImC7CZ6
sX/XWha3AjgaBpuvw+KjYLpHY75XbboDjKyArQBmAWydtCzTr8TguWH1ENeG
T8wf94W8AVC9wQe5HYhrh1AuQ9V4DGemQywcDYY9vrDlOmy+ClYXiaWXUb3s
bqF0kq2YdbtQGqbIVojrgIRufFxunrTWYGZgLfiWgUc+uGTA5UQ4FwUnHmkl
dJr2icWDqf6B/ipYlPDSv/CNyJbhew3gmAJ7/WG1A5gdwIMXWo2ablUvtAH9
1cBW44ixDay0h03nYY8bnAqE64k4iCzuBG5+udTyZ+YjGd2Q2IFmK6QB7laB
RyFJZiwcC4FZOInfn3mE1vdqgjS9wbUQ0QzcaCR2I0O5nArrEdqCG/wK3Llf
zwanZHCIQRdzIoSe5SX5FEo0+Ad6tjfknhaFvB3WCl6lcDwSrN3B7DCY7AKj
jcBWjhquGjGyUhuuB7YKr7doO1gcgS2XYb8XXHgE3unwqAbHk7shjUzMC3lc
eqdmcktJ8stBAPH9t3t8YIsLrDsPa07D+vN45JarsMcTDvnD6RC0L9z338qT
jp9TJb4THzS+i66JjHzpETk/vwrwLECZ5Y70TDh6La7u8llnPWdJ/kx/XoUJ
qPpDvpHZ0RXdMvCgSXM1A/YHwOoLYGIHJns0RtZ4EjN5ysxG9FeqOUsNLXHE
8gTYXoMjfnAlCvzyIKpZMpN/lT8A+f2Q0wcZvZDYA+FkWzkzLyXCUZqVzXXY
6ASWDmBxCtaeASsHHNx6DXZ7wGF/OPsIPYNnljSsaIDa0RsqTz2TA6kwAgFo
hlQqt2y4kgzno4mquhZJyO0rikxPDHpV/xv//oFv5LbWpXcORbZpfKvgNPmu
RYfByBaM1o8Zb9Xg45uNsEUjbMkYW64x2YgHbDgDu6/DmUC4kQQPylFz04nX
BQMaoV/vZBO/+RZ3uD5l4JqNqnvkAezyJvJdAIvTsOo4Pr/NVdhB5mv/LTgR
CBciwDUZfPIhsBIeN6J4U4CgmsHlO6odhLW6X4MEuJErHlY1/ehDOPYQjgfD
iWDJel1K/HGcEnIUL/o7KQe/UyiU31yR3dYU29z1qFWjmoHXfsNwA9HAdJgt
HmXL1Qs3adYcxDsc8ILLEXA7B8IJUmT2cJ5rcvs0+X1q/klU+G1kO9yvQ02+
mICI6kiQfP41Z2DlMXr+07D5Muy6AQfJOZ0JAadY8MgA/2IQT83hBWc+l3qu
Ovxqj1sJwQiryw+4RMZA9QKnrGraRCqo/iYNtFZbJlHeUI48f697/dEndH3E
PKrf8I3CxsK8lurM9k6+zc2dQwJs9QazI3gLA6th/cWDTH9A8GEGMx81slCb
2mhW2VNc5A/Xk+Rs30nu1KR2ajK7NXm9moK+MTLvGqHOvhVwLRNOhcNeP4nx
uB/j48sOI43WnYENF8DWFQ5Q9HYxQkoE4sXoVkjqRknjpgF3O4CrB93vNz7F
cCMbH5Dbdr5/OAjJf/QBHHsAxx8iiU5OTqU/PKszWj+At0QsRWLhXdi5329o
mfUg+66NfVGJ16HvXuMbxU3FBa1VOc0VfPtx65hHMdiHwDpHYDtQkAysR/VX
PmGGfeznPmY4SDL2zs0sCK2FhHakUFaPpqBfU9iv5l9k9Y6m9mo49gggB3gx
CQ4/BFsvsHKEtedh1QlYdgjHLU6C5VnYeBG2O0vaoMNAA1KFOsR9KMcOPPjg
fhC9BNHnNS5HfuXgyd09j0Fi8fEOERZCKgURlR5gKMapdPax4hnHfb+CyESG
ZdywaJHZjGsFYzYuw8ZGPezzGlSgd9PotnjQP/ONopaKvMYivpHYOfagGa6k
wK5bsPgIMOsxtnoICWU5rG82yP7ai+KlUukvHlmyaXTt/rEt5zX23uAUSYi5
BVI6IacXigY0Rf1I3tze4YzeMe4OuRPlYqV6USoKbZwnOHS7AIIUunAvlUrB
hqBJBBlrjlgxLs5Ck83jfa5bIrA+EggTicMpM1n8+/dEnxmSPrqYcIoOvRR0
qJoVVFbH/6w/Osi+bmUflyHJ9OKZXhR+SdL4T3yjpAW/4P8y2tqi2kb4xrEo
sLwC+ts5ohpmS4hSpn36y58w/T7G+pkRknKJzdj6w+rtjpoTd8EtER6WS4NV
QLijoG+koPdJdu9IWq8mSmrPDB4CHnqA33KDZXUJlh0B8/1Stt7ZehX23YRD
fnAyCC5FgTvFgmENENMGiV2Qplh+NNgd6P9EzOVRAFdSEY1zPGMfoMjbdLJE
l2MxjzGZNgoMPXMSHPp8HDFJziq2PMs7v0VI/Az2WQP7sIDpJRBtI9nsRNUE
uVZNL6pN5X+yG0vjGlsfNY9eyRTjr7MNarZujC19wn7qQvoa9OqbDqD6Gg3y
XRNrjeVRzW4XcAhBbxDZiChWxpwF/aOFvU/yekeyetXiHn6VwCHGiTDYSdHg
+kvCzv9myX5YcRhHrC/DHg84GgBcWK8lwM0cuFeG4/EdGGpK9Kr1B9wXcmn1
oaidw1hCvy/JNJBKdTQQ8zc8QObxzVUK2nm4ORmV3xaYQOJ4/KfUCyZD/yjb
iEVmKR4iIS8U7x/Rsulsn+G3LUjeOWlsbjzROYLNjqFpKbazoqWkpC69sCY1
ty4ns7k2pqVPRm0bryp35+etGmNGKM3smw72l26k9sIho7XoNjaehoM34VoU
3C/iJhNjWT6I9pKefnp0G8IDjyLgInwgADY701xVryy2B9PdYLYXlh+C1dyr
nMbTOKmPBQB3KTfSwK8AHlZhdCQ4JewCp3Q0CXFQvaDuq9wc8Nj+wF0U4kMB
0jTwMJIH9jzcuhwDLinglQ1+RX+D0v+VPM/UkWeK9acTpR/dKyw/dL975bZu
tqBazJTTmCj9GIV6bqZK4t5X+EZVR1V5Y15RFYp8Tl1OUmM933DNgx3+sOI4
QdvFw8ygm7z379jX7ez7LvZTr6H5kP5a9D9bL8KpAPBKh7BaSCUPWzwAxf0j
RT0D+T0o/ClEfL8quJIurcNbK07AYgJIxrawaA+sOgqbLsIWJxyx94HTD+Fq
HNzKgQeVEEn4XUQJwoXHdaHJENjJk+zFeYoO993B6P2AP9jfhYMTyM7904VI
4PGtNuUaUj8Z+vv9L1Id7/WiDrW1Njsx/Y6iC6qpS36qZu8XC9NBtQUk+xQ2
J1VKLOX1MctX3dNW2VpaWpfOt/OqU7Pqi2IaW4OaNWdiYYczmG4DtnwYL/ND
N/u0if2lR2Cn17inM1g6vHwrGvU9rnDpEdyhoD29C/L7oLB3pKBnoKi7W4WW
W81NLVH7Vbs7YOUEK07CkkNguleS3WwPLD8IG87Dzutw4BYOXngMbikSLU9J
6YbMfkjvE6GR6s2gWuBg6XomXIzDlII95Xj2+SHJ7f3h4F04dFfS+0woCFPt
nUdJWYEjw5qU6F83F/vLdJ+4r0t/JTJVvRpZiqBh6ybyhvOy2bxEtCd6wUwv
REr8HDLm72fh4dMUC1PU0VndWVvRlMe3C6qTc6tTxZO/dPAerDzOA1cNW4TS
y5EF+6yZfVjPvkNwy77tEJh/enInZHVrsrqe5nUPFPf0FnR3E7Wn3C5XLNRM
evJlB8DyNGy/Jik5424RhFZDXCuGQ5zEwoQIKr0e0gR3ysEjB64kwdlwOByI
mWdJaD84QLTmhD6s0No5WfJrWmgjcBI/bsbMsWJJ8Zpva5EG7ukiDeLFdJ1K
Y3LCNeELT57PX7m0Gh96biqbG0vUDBIzncb0YtjsaDYvj83PZR+WijzNtKJe
dU1/X3VbWVlNUlF1kjj27fj6uuDm0XOU0jDnIGTxCDPoZd+1CHKyBXXsk0b2
VSvuGg0t3zC0fDdsuQBngwitN0Fq51hWF5fsJwKjZfaMxrZJEp+JxjwP31h6
FMz3gclOeMHARjzh8oOg1ctZh3zhPFUubudCUBlENgDnXvYAyTcd8ceYToig
1Kp3MVxLh/OxmCSw84M9PrCXWID098OE+0F/OBIg0yj88xaZlOC6cfJzKC6S
pbqZMYogn7M7L+tKNkmN+/20XfuLjb8pF/N7g80W0hzI9B7QRgrTCxeGnH1W
xb5pXbl+8LTLE7QF7VDU2V/Z2VjZlCuulVFXENnQTgaKNIb92MU+a8Qzf+ph
HzWwjxvY58gMfdMnpuvV6w+N7XUBpwgIpCy5sNhTSrq7CjvbcroHxXz+zKXc
KQ3LM5tdiK0HYNFOMLIBZgWGNrBoN+XcLsAWR9jrDifugWM08ACGD0Y2QXIX
ZPZBFiUsk6iwINL4dyhZwQH1yTBAKK56kQf6XMT5BPyKsZqkQ2Jtpf45GutS
nrDxVMGwlNjLcam3hVyssmtjerlML4nNjmNzQomw91HIVWS741UvsjkpROIa
gx871m17csJD/YCy1FV9QzUdVQKT5JdFZlfEpzViiOeSqrF1U5tvG8Wz/tqD
n5824efnzezLFqT2Z81812zFgLm1xuq45ugtwXzi1MvFnS35XYgfecAa3ATu
RXAmCnbegtXnYBFFy8ZbuIRbcaExtgHTHZQpugx2nsC95tkQcE0E/0KZa+DW
RXh+4TU50OYAJbAWcSDd641dNzHRsPsmFvFEzXO/L4o4Ny5nHoFjLFYeBMVC
G8bJLqw53wgmJ/ocpX87Kf2VXJpqmmdqrlBdkuAIIU2vMD1/pnePpPshfZfB
3k0luteZGnfZHR1wvKeOq4cS+UwvlzdmF5Q84luZlXjY3To4EKxZeWLMeJnw
mm3shw5xPzQt3HZ/3myo36OV5ll+uZDYhjEhHyns7S/pbi/qQIXI6B4TM/r7
y6lgfx842jQ7CCYkzfobgK0Bww2wkMv3DlhOidw9N1C4L0eAVwaiFYyiCe1k
92OmD217N3DTItCKWy6IXAy3Kzs8MYux2xsrPpwB+4gBB3zhRBBcCAfnRPDK
Av8SyQBOesHL6HZUldAmCKwBv7LJbMybWvpP7C9Q/TE+zpn/ueYeaWOdrv9e
BhE5ij455e8ogi9MSyabk85hDPukfumynl2nR72j1Wmt6pKuwbrupqrmvJKK
aHzC0kghsztujK3Y9pQZDCBM4ad/WMm+40a9Frffq2Yf1XPTTuj6ny32aexc
4epjCC6FdEKKRX2DZT1dxUT77M6+xI6RB3VjNwgVb/OC5adg4R4w2gb6lFDk
1DexgRX7MFG+iuKgfV5w+gGmj7hPjSCAkdFLiXJhowRqfNyKmXL3PLiUhIZF
lJNtPbCWvMsL6+V7b2JdgA9yyT8bisk1DvRvF1BysUlygMe8nPY8nhKSH1CJ
aOiFSezPm79of4T35xurTFLQtCClA+jztpjvP5AKBCnqkc0WlKIR3dx93Hnk
XgbkdWrqhkZr2srLa5OLSkJzi1H+E+sqHjRjTmONw6jRkkH2ly72fRuePq+E
LahknzWx2eVC5qcx46GlmykbcBu80ySNZhT3PSnv7SntRPuf196S2fU0plND
qSHVTE5wgw2wzA42nYPNFzGZzUcvhktN5lhflCVySNaln3pQj3kRjvTPRGK9
eoc3bLuBp+3wwGrsbi+sO9ndhH0CcUaCSzIW70WGVlQ1+RanczTVS4X/cskE
R2p0IBSo7ZDSSrk2Wzk9IfxMZNItUDrGuIuU3lPvNtO7pVA2gBsa3BDB5/vl
/JObdkffkehKJGVdX091U3ZZVaywdWnlyVENbbSJH1PZty3sS5Lu+RXCN+L2
R/VEFLpbWrcmt2e4pLe/vBu9bmFbbU5Hd3IXmia3QjgWBptc8WmMbNWGm9UG
69RshZot1xBafPtOAUgP2Qt5nLaUfeERVEIXZvT59vUccIinApcPFri2UVp8
hzvs9MBq5R4i8CF/IW3TH9Zg+SeyFbsRRFuCoHRAFdwqBrdsquTGTmZHKFOp
7RHUrcH+RsozofSZRNTHCnVvMb2bKNPkQe+rXsLBOYnsXQTaC417+acLVdGq
+keq22sq6yTunpZQmR/cNHIwFJYeG1lk3iOyC0jfd9nsPDa7kL2H/lX/s0b9
v3abrnq6cg/su076XQ1ZPWOFPUPlPeg5i1vK89rQ44Y3DPmUjV1Mgr2+YHEO
9MlbGqwb1V8xyswwBY0s2AQLt8Dqw7DVEQ76gANhxOBqSOzElAEX7DyiP0cr
yT1ox7n/9KKS28nH8BviNdbmK7FiKogsjIR0m1SDuF0C7rmyh+NsJJykZ9e1
GoLahM6fqURRduW5SqNSnVNNiY65KoeJE79RxNub6XnStg99hpJlCeOBEGcD
m18lJTmvU13a3lbbWlxeGSNQfVpRRGRNnVsBWLmpLbb0jiOT19i8YqZXyGaX
sHmYs15k1m1uOWx5GE74gE8Kzgolvqe3oru1pK26sKWSzvqDawEceADWzrBo
P+hvQoobrBzWNx/GatEKtRlVjrgjXX8SdrnA8btwNQYBDB8UxkXkHjkbuCVP
6MZElkCwb9h6Ys7GxgWbPLaRFOy4AbvcsTx26A6Wx64mYN8BHw+pG+eMqDmL
Wr3IN3oXgnMGOCYjc85FwanQSTHNa/9t7tDZaZFnVBN1h/OEc0ZGeqQnvioJ
6Sk3M6/A4ONa682dh5zxOqW9ow19ndUNmCEoKA7Jygsc14jXuWHHMz4uZZ9W
85iXzFgF0ytgs4vZ+1V819ikf8W2kW0O4BgKD0u4gqiFbXorq6MropErBuJT
W2+ua8BsNGzNGDMnxGo0xDh3VowZb0TWbDwP1hewaHsuGDxSMCec1CX7Egqo
4yB9PC/+jx4FcCEBDROeeBUr75zvW1xgmyu2G/DBnTfAzhuO34eLkdhGcZvS
jNw8ceaIrhYeCMR3Y8aSP+M9KmteJwuFoGnaJHx59W/wZbLOzpnSak3giAdO
XcgFceQ2jYZIbDS3wOS7xm27+m49HExrUSKz0kqMhKlLQHa3qd5hnzSxj6rZ
B5SD+KSSvV/AISxdKp/pFbEFWNwwWTa0cqf6wHW4EQ0xDcD1hQ9WdDWVtlYU
NhXntjYkNnffrxoSfHqVrRplizCcMzDhLHnKuNFaq1myh9CjBxz1w+KGbw5G
smk9cma/z6J6Mgp9I5p3Hp+dDId9/mBD7mbTFeyK2uKMfS3baWSnGxz0hTPB
cDUW4WZAGYQ1KNVSzosEgq7cC3Orx59UeBRuwriWHH8Ih+9jMmISW6Z0qCiZ
syl/S3vGR2BiZzbfyIg6q1Ip+iM9r94Noim6FxG/Mb0Y4lPRWtOGjXZjHo85
Shqr7x+obSkUmjI1pQh163z46NJDT2Qm9P0y9mEVqQyHWCVML13GIHNLjL6u
1/8RnYjlITjtD/45kElovqy7vby9pripML+pLLu9VdjKE1HAUSRex1LDVg4L
ur3IjJ+YrB1ZuGHMcKNm8U4KEdzgdBAVwctk9JTfD4UDmvw+jTjnzXu1cD0X
zsZgxLHNHdZfIhVywpYwm2uw1Rm2uWBpkw8eD4RLEeCWDL75mIcmQr3A+aR6
JUJJiQjZvEzJFmRW2DizDt+bzNNPe44zyDlcJPF3+Pe/xb2ZymhuwmUxl+kT
uOdG3OO+yUfJScdSsFG6YmmXo2tvUKbIV84sKQnWPotXMWxyGTVY28s+qJEo
+f1Clah7zc9ncygBoocxpf7njabmCC9sL8CVhxBGabji7p7KzoayFkTSuc2Y
y7pfNXg1B+zvwapTIDs3jIeYcT9HKz/3iV7jlQdg6yWR+8CPtzkUyO3D8mEB
lQ/JGWmCyYFcTEaLt9Mbq62WF7EKxgc3O4H1FdhyDbY5g60L6hgfvJYg6cBt
XWwH1gw432jklfu1cKsEXLOwXUtAh4lcs79DXVqPJ+Pd83x5nncKhpv6tzmW
E+ugw7EXFY55CezM9KLpE93N6rX9FNNNL+/u57uVVdFF+RjMpOQGiso62/vU
8OdGNpcs4rs5pG4iMZ6EGEQP+aa/oELU9n5X0DNU2tVa0Y4IL7+hgH/Gd6pv
VcDRcFjjiNkktlpNnBpgP/Zg/eHnPtw1HzW11qw9KvXoJbdEeFCKrX5ZvVDQ
D6LYm9GrTulR8wjat0yU3lXT7xTBo1r0OXEd2DGk8OFVjgl8y+FGLgKCC3HI
ilNUDBZ82HcbFehUCDhETooSfg0vdPvkJ1bL6NzCFOfMqDPKyDQi2BWVxA4e
iKhvqqZQzB6ONUoR2V27x80e0qe2Oa+8LFTQdBoPbNjsAiJ/AZsTr8UdiWx2
qvROC6oWGnaYrnyynjoEHhZzMVeX9PZVdmOKqrAW8+qpbd2yN8PGCzacAsN1
wMyeMhNKjX/bwb7rNFnUZ2SGFeSF6zVrDmi2X9Yc8IJLj2XyljukvD4oHpB1
9/Se0Xil8vkv56iRaOsNsDgLK0/A2nOw/gJsoHa9zY5g4wTbrqHynH8ErhT+
BVVCVMs401SUPYxqx9QhWooCQtkJWD4+9VgqEuebnQ9mtSbDD1N+JccUL/YM
p/ITnYS+kAZxW+ZEbHJXnNQt5A358ql1XU01tUl4ToHQjrf23x/de6xZnI+w
bU4a1xE2N0X6M84jvRQ2G3lk+F290c+dZlajtg7gSk0qxYPqqoEnAotkNVeF
1XTSTfDjt1is+AuWf9iXrez7TgODvqXrkTVmGzWWBzU7nTTH7miux0MQZXZz
kC+4UdD7NKt3VOQyfcrgUiocCcHGZL6/4gSW9ZcdxgY8qwvEmctg4wh73BHI
OUZjE9o9srSCLbI6kNyLzZSPW7EiertMVvBf1Nac+b9jQVQJjcVKqGfOZLbt
+ZVhv16ftH3PZVmeuXEXVVpLx3XHkSjsJjs+eGRE+ykG7xZar0WWRBRCRc9A
RWNRZYXIHrwVl/vYPWdw8YmxJRaN7D1SKb00ppeMG/MymF4kjSTwEc4z9h6a
OaOFfUu2wKHrcDsRsqR9mVVUnZRbn5fa2sF3LqVptnuQTVs+xhY+ERbsZfYF
so1bt0Wrhiz2YLJm80nNPjeNQwh2EHJ14hBPdEZyfMYhsksOHA+H7d6w3hGW
H1cS8XthqT1YnIANomvwKmaHzz0ClyS4nY8doSLe5rqTTKlhrkHYiU8S9MqR
h1i23n8H9vmiCu0mKThMCy7Oh1NXfwb4FCq4b6JmTPz7PGemSOq7iaFxa1mc
5iokApEf8eQVxe/4KgnJVOPPyleuGXD1e8p3Kzra6pvR4efn+AotsLWvY99X
oE9R8mhpxJpMrFBJjUpmc7L0P0P/snDZ0Hp7cLgPIcXcp+OTVLaVldajsmU1
lPBPj1LN7nuw+Khm8UbKJv/chx7ny1bZE4U12Z/7jBY/4QEW399+QXP4lsYl
DpUqlTrVigdGi/uG83vx5JQe0eX39vkEOHAfrF2xDCt6gE33wMId2Guw4hCs
PYkju2/A8XtwOQrBeGAF9rPyQdG0ltKLyeRYWfd+07MAnKhPRkWLCHZTKn+X
FyaBJIAIwX4OR6Vf3b9U9ok+0+26jv69/Iydm6rDJ22MW114tzD5akb4SZXU
L4GvibjOTM+FAzvR3c/0gmkwfdEPtYePdLoHQ3E3EqqmNqEk/66wiGxuFlc5
OkxkHqawOdHcSSHEoP3fcz3jIS2yy2JspwO4hUEirRYp72wQNdvc6vSEWoyr
TsXDxqvqFTuH9U0wXsJiLTd+HzewjxpkLMMWPV2yacTqCKrb2SBswBG5z4K+
0dK+J0U9iGAyekajO6gCJdbTmOwBw214Q2NbWGwHK49gEXcrdShwVXJV6q5T
ErswNZTWJ/cx/8mxnHMGVhCPP0Jd4qM7iTM73GGXB8IIwaLLMXJdll8xRaUz
FJpO6Ll86W/q0g1hvISlxGnnZSVU5HjzjbTQo8RJyt/gt68Rra/Spx8H4Ewv
SKmPZ5gbthw/1x+RM1rc3lvXioCtIFPw8pW917tt7UrZlxJxq8arBlQNRocl
dlOElBsaYAngiAfcpVpfaU9XRWtZaV1afjlCx0dVra7FCAQsDg8bLh9iP/Wy
L6gIPL+WKgUNuG0wsHTDMPFg5sMK1KiCAU3pwEhJL3Ipu7s/WWrUtBMReIu1
F8H8IJjaASUaVdMCyyG6BVv2RHVdop4Y6nv3K8de9wu0qIsHALuou8rWHWxv
wHY3rATY01oPTjOnOKWu/qgBl1NFtcnWebHaGKNheLZq++Lf5JS7UlMkmUnP
rGypiSvLuCG7RrSqyP+R53pVNY77blPEFKplgL1ttb0DJFdDbTc6/rKiQFnj
vpSK+4tNixDs4dFxBBLjtDX76Wx2uMKvNDa7UP+rFhHvlPQPl3c0VDblyPml
NGF2iTbxYwHqk0g4zatERnHd+hKr9YsthtbvH121n2M+OEmCHt2IWaHC/uEy
YldeV2dGN5rB2xVwPhF235HVYq5cZvuBG0Cj7Vgt5iPL7WHNcbC5DAduoqvi
I/5F8Lge802SkSpVeh+CitBGCKjCXR4snY6Aw0Fg5wuciaIrY5bQLbFEBxc/
CN510KoYbUe05M70SXmorPNS/hKnZ3H0zQ3bTiv0/onZw02NlY2VKNPZkadV
2j63iXzDNDhthIlmQhubrsDwvpJuwuk18cU5suoz9ZgrFiDYx+mcN6L2qGjm
QwVahJEjI5X7ulr/m1aD5eqd5NvTW6G0t6eyDQ1lfml4ZjWGVU65YH1Drb8F
jS77qo2u+R9sHt1lAvfMlvWv2/l0xwW13XVwCoeHtICsaBDK+tGMFlJFiDuf
wDq4lgWHQsDmBiw7IS2i8VZstzC3AxPKqq88BJanYNd1dF9OMXCTMq/xVAsV
z8gZmExQnYdYxKdXtlI+Y5srVizkao4YWevn40HVyOfIVq3HmxLWLFtEn+t7
E1zT7WzRzf1p8cZag6jNSwsdHEeVbKq251CB8N5KuPtYotmVG9S+FPO1dlVV
lobIeMj+ap3NrkIL03iVUv6gxOEjlcy4Byrcj5CW86NK9lP34k2aY24QSO2w
VT2IBIsrpM+beatiZG8gmOwfM1uNeQz2SQNbUM3mlMr8pMI79gOlqHY9sT0/
evQ2uMdDZC0VKghlv+ldAieiYKsXrDwDC/eCwXaqe2zEsvVijgwPwBI7HLG+
BPa3sCvmRioEFGNLKs3iBWzL+L1QNWEDXLPRl6moar3Hh7CGFyY3bKgTE1dU
iYaBGHBLg9uFlFyvxcqpSluz5tF3SCNKkh8JmS4HZ/16DuL+sq+jN5qVyL6U
ymyvvJjzRCDQ1qJkZMbjZPqM0J+bIvB1bXd3XWN2WcHd3HQPceUlxlnsPWET
ZYON6Coj2xmoKGAEm5NESlrDjAes9qsdH2hiqqByEPFoeW2ywM4zV5yFFVv6
2I8dnE949JwS9l4p0yuUuJEz76tWYwMMzzYdHN5zVX0pBAKLIZUIXd43WNqJ
Njars4+TXlnR+or+VolD9DeA/howsYYle2AF9TbtdIHjAZi79cmBR9Xi+D8J
U8n/BVRi3YmHwyfCsMUVLZAzrjO1vgKbneQCQD544gE4hOMyzZu5mAAOqZMa
GN8l+3LCW3E5Fp/PeAz1azinVA1FhuJuiLqioqEoM5Is5ikR64lqlYtSqgqi
zyiDBTnmi5BG+W1Q39lYX5/+jJcUhwr8pjSLCB6FUwfDQ3H0y2xeqkgLMvOR
3efVt6I0uQTOq1qKS8ojs4sexVSVi4o89uR8gIEBm1+K+frZhZi1klmsr1rN
zbrXbsUY2t4D3GJkWrF8UFPejTXhvI6WNG7SxQztH+J3Sw6D/hbBjZmGG8HY
Gsx3wgp7sKbEhkMoeKRLq4ierQ9r51znRJ2am7ibxVjyOBkOhx9gAR355gKb
nGDTZbB2wjWMByidKBYHe9ASMGGlBHFE0p4zTeJTtxxcNkEP+uu17pksoXYd
zaJPEk8daX4U+TQjraSpPLQ4GR0dcfJFYgCHo+60cZ8+o42+KD58oMnVX9ac
C9LdVROCeY5dJfLXuysUTxu9aXvcKN/4Febql20YPuGpDs6Dyifqyo7aCkqn
pJVjc/5RHgBfxHSU/hcCoxSz+SV0eg6bU8jmUQaSKyT5nVdLBjVlvSheha3V
mZ2YRfQuhhPRYOsNy0Sz8wYNW6dmq8cM1qpFH8RUjkPSejGTxaNvocsJXfCY
Eu4c6J+JwoXDHEzaesqCwIZLuBiJm8hd7mDvC6eChTRMfVgtV6spVdXp92sx
PeKZD64ZcJlag/6bXNLiximK9du9Ie/cyY7YhN7mOsQqhfEXFS5NVbjkxlVO
ycDHLDco37LjyaPk0dqe/uaW3ImRPNbE/Cd0pNxUlDRYYVCMRMkb9o1euzcm
jqttKxWj850KwP7mkNGawSX69YIzdFKWZM7cQvauKJg1LDLsWL2h3/rwUzsX
jA+4khVwDRsYLu9qKm6rymlrTu5SB1SqL6ZodvrB8tMYkeGJa8bYylG2bJSZ
j+qvQWBlthOW7sVVtAe84QLlbh9W4oJZrmZifXR2P6R0Y//4/RoB11Sve+di
ButRnVw/KpZRCmXiHotHhJw919JwtfPZSLkA+DnkOEuLHMdjaJ1ecRS/LSvy
r13tT0tHt1+V7UUmRuEs07vO9FxVSl3rkf67iZZLq09fGEwu0zR0IRgrzvRU
qSbIAlX6b2vPuKkE3g8km+YmsI8K2Be10hIU90FNT0uF4q2mr9j1ZNHCVlHO
Z/PyeSAobZ7Qm/fK2Hyslyxd3Gm5fXD7mdFTtPowtR1KB9XYakEx2tsHHoKl
I3AAaGClJOmXDLNFw5wlhrS7yBYsDsOOq3DiLlyLgwBKPWb0yfXMnCsZlCsU
eY1LSXCUKLzvDr7nYsNlsDwP687iyJarWD0+dh+r+xxreGTiIEf4HN5r846z
oki3HlBr4s0iKqkkYicSsg2poLsGSPBt0t5+BFM3fbEo3lEXX5bqrJrwRoEX
kVOSARiZmRh33fAZqOpD2a0oDtHKgECVAoSIHrvbaO2UawRJ2Ph+Hvu2eYXl
kIMvEqxq8GlVW7k4JqS8WqX8Y5/UYC15NlX756QrMfcsdFjvSmYtW923cd+T
XY4a50gILVN8QHEzlr/iO0aU2vIKNVtK5X7TIWb8RH/xiP4KjckmnL3VKdjn
ARdCQaw2TFU6098Sy5XFTHzL4EoanHiMtWUV+actzuii1pyGNadwiSEy8CYu
1L0UNd5LJyxekvJ6k+AGZNWtEpHPnHLoHi6aU/0ij17SGdXaqCktTQ3FGSH0
YONW7rpq3MNMdzpf7XlvrLYXnUR5nq/q2Zqy8D5+SlVyBvJlLiHCj0s5lrPZ
PXTtoawwTSssQFR/rWh0/60hg8VPVYoHy2Z62KeB9Zkk1VtiB9tl5paxj+r4
tvmG0Y1H1Ue8sFcmhRxHZU9naSuGZOmduILpUhrY+SMDjLdo2DINaehv9E2G
DJcPG61Vm1jjV9ud4OgdcImH+6W4mpqPFAxinUtWkbkv4c7+FL0zZ+dN2ETw
3OI0WJyE1Sdw7ac1Za/234JTD+FKHHjnoN0LVVYKT03txSazqHbtmx4wX++U
jOecDMOlCPZ3sSJ57IHsYdLlE2HD57rZtbmp0PDBjKS8hqIAHU6JVK9A3dOP
Hut4nIpK0FiXWJzhPpFT0xRO3aXYOkDGTBL9fVFtbNiz/+xwQOxo1RDUd9cL
THSvsn2Pr3rl9kELixqsP74gr0T5YVw5mYS8kiubvmpZtAQBwdZz4BgCj6i9
tnJgqKINwWF2a2NE45BL5qh9sGa1g2ahLZk6sxG28AnmsVi/lBBjK/Wi7WBJ
gTJXIzH6FjdzeQowj+/ShNCiJod4OBiEK1p3++ArVPjIquO45NviBOrQbndc
6Y+iEQXuGVJaE7vH100KnMv9k0c+XE2V2PgwvcLkYAAcCcQK8unQX+YUWTMF
OeDlmyoxBy66naYTgTzpM0j/vTg76yIh600dNTVlj4hZEzjjJTppiDN+Wo9E
CYsv6iwses66j0QUQd0QamBxYaCkFftLB/ukTOmUSVSyVNgVkKTVIf13y+no
GfuvSwKWDQ5XdWMGg0uTRPvHomDdVVh+YMxgDWU9TIepEtbDfqBimPmw/mqN
zClW4ltTcrg1k0uBx1K61BHt8DrNKKgSwuohplWu+RVXfzW4EQJqsPHPNRMc
E2hVaiDO5YA/CLN1Mpje7UUJyee8v6A2Sfw0nZU22rfG4VM/0P8w1XIlAqX6
/tH6xgJtHesNIsQ1lYyWvBVCi+4xyjfMz+efNrsG3e+P5DahZFZWxwn92Hjs
iak54g02Ox2NE8FqJes+QxCae3y0PJ9ULTNpWWctV1pODa3ANWWV/X0VrSUi
4/GoaUSl/DO0HEbRNxiU5P5rL/uxW6wk1l+jWWgDlsdhtyt6Ej4SUQ/ZA5p8
Wq6e3zuq7bL/LYfPxwimbffEtpdlR2DpYVhK0e2qo2B1DrZewZWuWGqkNX73
ucGqQ/6kyMzSi9xeiVd8qAiMO8Ri7fdwEDJpny/lmibnh+4bGd+Y4BEeLv0x
09i41ydoZKrCA+pilfkhFyU/dFPyYF4Um5ss31RT21ZWWoTwa4fLU6t9rYv0
K0Rkp9ShYihQFWsxx2lv+l3dyuUdVruGdl4Cb6p1lw+NVHU1ifzsburb0d80
Kqg2Wzbac/KbPEXjsxCpztZplu4GmwuIs9ySIITW0uQPIMnz+sdyehGd45KS
fDgVxX0NlqJU1GW04jgsPgCL92HRkI/YOsP+m3D0Ljg8xoSOfzHl8sTCYnpj
C49fwpqxsOtbDpRxkjlXrgcnguU77hxj8Y15NPlJqf+6zqjy/im05/4Gc0P0
vyy+7twYmznW3NlYXxGWn+g0oR9CdhZpse80yYY5ERj0f1wtvXJCBTQM9FbV
pQlrM8vg62q2gBpRhGGSTAjTrkKZqWXHYoPG1ZY9mw6OnPTBtQrE2RkBtXAw
HLa5jphQ3Q8bUb7tkJ0nCHg5O0yfcGjF99cfhz3X4WIo+BdAXAvl5kRn+K1i
OB8P++/D1huwht5ns/I4vuLFbC+Y7YaVhyUDDvvBhce4CMQnH3jQKFBcmvDP
bdKnvHaNcojHH8E+P6z+2d3GJhVt9Q/f/Rclu+v9yZXpvoVBcOIN6QW0HJgu
/KzpXytOnO6tbFc3txaP9wlNIP4Nxcr7IWCaHck+KGCf1u3ciramoBXqOuvl
CoONBzvkOXNiFaIHq5RM9yMxRKNIff0v6/j22i0DNic1zmEQVcEjfhTdkjr0
2UGlHeeTYbvnmPnuUcPlJPbfduAK2c+b+afk4uJRZjbMVlED6xk45ouvMwiW
vXfvFPdhdjureziuC1+7wrftH8COW8SQc2C2j8oTu3Al4ZL9YHEcNlKe/fAd
uBgOnpn4Hja+m9BJFT/Ri3yvFt8t5JiM7yY5Qq9D2OmJq3q4+Tk4YU0s14qr
ifTOnhJcyvaCohyy0idQ7m91eETr1kR25aag0gHbckeXoeZ+zDyWZtxQOPMm
54xSeXCjWoU3Dzlkgmx+vskPTQdODD6IozpsU35hNhowk+8q2fwcLYYVieuQ
8X3KXMfKvkbjH3GNzppdYwevg3865FAyraIJM2xxjaLG8KK5PZisGWJ/7WZf
0RoUzpcPatkCZCj7vkt4FWwSIvt+KUzmrQoG1YIped39SV3Doo43ZcUhadSF
5kzFl0b0YqIsXcnBcAvkU4Kv5nKIgaMPYd8dSfq9t2gVWwC+i1BQ3zEOuxa0
tRzd96yKNYM67yeh1I92zYjVmqbYFMTpTVUkrbPGrZGg+XXqziJ5Z3MoeJhf
vHZJy0XnwbhiaOzvElR81cIyRyykVWldN4brolSgEJxUYeEXJbJL3+mhpERl
R62wBHsewuqTaGcUpPWJ6AZvwBIBp7goqhoNsSVjQkb/+LgaIU/xAPK/oKs7
rQvdtlcJnIyEvVS4W34cDG1h4W7UACPKN5tTrzFW5Hzk2tlbedhzGtkIie0Y
tAtti+nEhYp8i5uji7HYG8zB5w5PUeWZMt7xo5vXEpTXfYvxy+OU9xE5Juut
A+mUMqgtuvdfUP4VNpusy/wKG5tuz4CnJW1oAkrz/Vdbli36nhpFZ4u01X0l
uxUgK+gix0+0N3g/a9GPFUuWtK+0GZG6kNkK1f29FQ1ZEqEeiwHLixpTKwqh
P2tiH4lo41/ZN+24mPnDermYeeGThWvGVu7V7HXRXCKUk9oJhYM4qaIutInx
3diUeD4O9tyBzddgk7M0PgY2oL8Z9Dfh7rID2BwiCqPnHynvUamD+DalnskV
Ir6L1kbM+CU6P0f33+uMvjQej93WfzeMfVQq0X5jbkWWp5burz9L9wnZXurD
PXWoPYDeCVhN7zXQp5X4YpZviuPoBBHGBSjJxAgB+FHkDGpWru1cu1t9llLc
FYNQ1VEj3xq16braZKN60dJubuqJyVXs/UolkyL6Pb7BxVb6pk/NN6t3OKiP
3QavVPS+hFHeuJoFdvcQ9Kw+hXVLvJsdrivUtwLDTWC2C0d2OMM+Tzh5H5wT
4E4hcCoLKuQMYJI+TlaQX9WhnW4uUFD4belXXxqPpnzZ+zHXzmIrRdeT0SkK
TXUqViKMus+DU2EvHa4MSe0vDRHSpz9PS0k/+vRXpPnuhFxtLMdCfGMRa1i9
qd/6GLgGywr5jGWWnUiweVTymFOEuaO5JUq9g/vR7zowmlWpLPaM7XSCy2Fw
Lx9SKd1Q3IdzyegaEFd6ma3HUaNNwNaCyRZYSmTd4w5nHoBjFL6VhgdbAsEm
UROTgvSef0e3LvX+XmeUKDUDscYHyUf3VgU/RvfXUPogJ/qMyN7NepaKnopk
JfMnlPFMaRs0tJaIaShI/7Zygo+sGj2T744VeNH4++bVW54euQ5hZVDWJ9GY
bRCsOEDhkERNcyiVPbeI6eWx2QVsbqkc/75Tn95RY3OKi6TmZprMrJf0IY1z
OtAO3CyFY+GwhV5Wu/IIrDmlWWSrkVlac1tYZQ/r6UU0nK5uKVImkztFECtk
Uhc3TO7n/jAZApzG5tzbuTpl6/rmrPzhtlYhCUTTlwVNldDzluKnUkw+qbCz
x+m3D4uuUWKi8g+dJo3+I0VIIlS6q1QMyEJ/UMR+Rgu5ZrfmahDEUUmtsh5t
hn3IgMXpYfO1PfrfkQnVw7d/SVnFvHS+LBlwF0d6/Xp2L5T2o1jmt2Iz2N1a
OBsPtjc166/gRQ2sYOEmzZIdagMLtYDmxpuV90k9rsP0pkJBXU80OQV1340/
Q9FuC4Pc61dbW3o1TXVoCbVrYiT9FGQtKmMZqw1qr1zqSq/SrlJSpM9jAhW9
lQaSAKqIIVjQfzdZxBu7HSS9azvr+OfZKOwIMFnaZ7KwiX1Ib5p7gcuh4hWz
2LwCNp/6P75s1f+5Z4nlk7WEwbyTIaYGyobIJbXKtxk4psN2H9h4Wb32pHr5
UaqzLBtjS8f0l48hoOA2ZSss2weWJ8HOfXzFJPdHovtRvI3rud8P0KXkP0j7
qKWgwael9/07u/pRV/Jjzv0SBcWK6ZzNa1s9fIbKWzQKBWWH23XFgt4QdoBE
UCyCvC9oaPRZpv67xSYGHSIeSKyHhifqqnqMLtZcHTW3os6L+RVsDhWP9TKZ
XpZYrYBFkXcL2YIK9jEmaYwW9a+2Hdl3ZcyRXHtenzBCqtfMtooqyKh4Jabh
irGFG3Bk9SHY5gjH/cE1Ae4RpBFvS9LVSl16kX+hX2eYtEbh6VT6KASJVlvg
rxrvykUEL/TWR9o/k4+KTto1+IdDp9Ba0f3O9FwUgRMR3esTSCbFzvibvEXG
9Wam3ZsJlOd3QF0XRgMWburl9r3GrFH46NeVnF0a00tlc6lPel4Rvg/gM2yH
WGk5sO6A+shN8ElXejk7GlRKlkuuOFn4RH/RU2OLUTNrJJnVKcA3aIaDbx48
rqXn+gcdOuhGtYJaf56MpogaHQ7X5BXQwjseO708gVbOQkaUjh9WeeZcf3IO
IrySrFuil5K+YXquSs6a0j9KHo3o9H2JmXnrktVPjrlCfK2MD180+rHB6Hvx
qj7R8SqSzwn01pF0ieAXVIk3sphaqXdfHnMMpeoNn2WvWH0xS7n/dFPL0cXb
NSsPoMqeCQQP4U90pWNyquj+ssV4DaWtBjuUQEHgAl+70CcuHBZPMqWhIVc1
oStYIBdBOBel5MKtlp+gif67EYafoeKYLeteYQNOvprEYtEpoa0JsHlZypv2
ErW5nDikzWySpPerZGbGaAkGiEe8wI/KfpWDI2VUPMFIDZXgn0A3u0pNC/TU
/wQ6ee6+/r7GkocTY2ttMS/S+AP0+A/joHt4rLokmBzbRNTrrDynl4K+0K0Z
fYPCbrakf/cZCC3UVPaOjr8bT3S5iKguFp9TZgGTZN6bw68FtQY/d0saF/dB
RRetDKH33Y//ZgvfEM/zL8+Og847EGbS3Lixi13+I6KdmHR1exfGh9PGOavF
SbLePFU+zJxgNlv2Y5tbjDp4o5CpxivadAq9a/IF/PuKUspPplV8SAL9zxsN
TAet7EYOUSNETg9UDSDnPvyFZ/lXHYl8TXmKaUrBNGH9klrX633j1VvxBI7K
E7hpPYOf4hzijX6qMV3cJ56jtHO4rjlPpRpfB8fnHo5oOUm5RBabTf3N33dY
WvfZnMTiT3yjeNyPJsxvXKL+TWfW2reszBBTMHwv9ahtuddddc+TYZrcuBRd
VpLIbkr45CtCUIOv8w2/rjRZhsA2Ime0eXCALgjj2CBU6d2lF+MQMLJY3rbE
RnPQTeMdCynCPn6iM2Phbf9d6gDFLgIre4nHX/Jt3tGDnYnJCOcKEp3G3yLI
9C5NSCjdUKiM4Njgq1LD7xvM1qgdXIenTJzli5TEiJRLYyiVyr5BHGd37unl
B9LWlLdWSLp9AhMwgPgdF91cgKige4q5bjIvOnPhaX7ZU63XGJ/pOFUVLcDS
uv6nVUYmPdsPjwWnj9VSn/+s8aviKm/F/ORiC5jQwIJedTV1CNEv0ozP73/q
zG9Cv6G3oMuG1c137yASq8wLmDmu+1pZxcdgs0U7QBzKyaKh45eeRqb06WLu
aMVO5Jl8W2tkOrD5EOKux4Vj5d1P5bymaOel+9tB2l9GINQdava56OuY0t2F
ABkUBDZzkrlxY/9JorAIqzY9vRuPPrimOmbCk0YJvTH6sJh912a9o3efkxol
AH9DCtVb9OL+b0m3F8c5hDNZpY9qVt00pM0nTxq1BbJP09h3FbJ3obWvTTXh
vYHCXidzTMs3Nm5o2bh32OEuhBeM1gxgEPCBnAfZdvHmdt14R8wnfP/6bGcK
uGryfbW/dcQFHt2eIkFkTj5MYT/U4vpgDpGbBxsa0l/RUoOWgi236LO7OOqX
DPkdqOzvyRnQ27LFL05NFi+YfJSwd0t9dFhTX09dXvTZZ2fgrNi0uRQvvJ/M
/tK0yXYwrkyj5B8Ej9bbPjlzWwYCc+V9KY557refpisyYfFTqt2ewfjEAQVV
KHp7TWECPfQneezH1uPnB3Lqh1vaS5Qq5Wx5D/H24nk699Ba57Umpbdca6oq
u2ry72rXFWkx1lx/xdN/XmVu1u11b6iilbTtCynV9Ati9PtlKEPadzVsXl3v
5Tmo1RSFR3TNeRSYfoj+1GZzu59vg2IJcbaEesSvyukgJCFhnY3pUsK09JCo
mM17wBYIfZji5Iby1cBx0ofyuuL3anR/CUvbtZyXResyX9beh80JZAtS2UcF
Mm9XUlqlmvArV/wS4pes6JfjZuhUijuaG5WrTfQ0bEEm+6zqoD0SsKOjiHiC
VxK/F7ZA0lC3k1obI0yTUfkH2eyzuovnm2lmsyUfxO+8faTzfBNy455SZObn
WC1vDk8abmzBByI7iXMQv+P3sc75L4/bEn95/gfFRw+0RUfhK5X+XZ4rfq3v
E51zX1IkDPHNbLS4hh9X0oP9szxP/PbhpzAh9yYs4QM2O5jNyxWUb2kukpT/
kzzvSzrv88nshdZXJLK5iCNK6ikh90d55rd05heT6fk05czUhQtKAx8I2X1H
UvdHOu/LXz4vY+uympScka72QspN4L3+Sud8BRO8kjg22+FIS0YKmneq5+Gx
BnTsNzrX166CWDg/765fj7QmePxCOv5bneO1K6S3LasIC6pTifgSjzej47/7
Ba2aKY9aSkd9/4wcPmsxcHclHfXjhG/XyWVweA0L+vYv/BMBvqXQh7/7vzyQ
ikU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->519562542]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->516873058],

Cell["Constant coefficient linear equation of orders 2, 3 and 4:", \
"ExampleText",
 CellID->177394188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"m", "+", "2"}], ",", "n"}], "]"}], "\[Equal]", 
    RowBox[{"4", 
     RowBox[{"a", "[", 
      RowBox[{"m", ",", 
       RowBox[{"n", "+", "1"}]}], "]"}]}]}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"m", ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56911405],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"m", ",", "n"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["2", "m"], " ", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "[", 
       RowBox[{"m", "+", 
        RowBox[{"2", " ", "n"}]}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "2"}], ")"}], "m"], " ", 
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], "[", 
       RowBox[{"m", "+", 
        RowBox[{"2", " ", "n"}]}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->600012371]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{
       RowBox[{"m", "+", "3"}], ",", "n"}], "]"}], "-", 
     RowBox[{"3", 
      RowBox[{"a", "[", 
       RowBox[{
        RowBox[{"m", "+", "2"}], ",", 
        RowBox[{"n", "+", "1"}]}], "]"}]}], "+", 
     RowBox[{"3", 
      RowBox[{"a", "[", 
       RowBox[{
        RowBox[{"m", "+", "1"}], ",", 
        RowBox[{"n", "+", "2"}]}], "]"}]}], "-", 
     RowBox[{"a", "[", 
      RowBox[{"m", ",", 
       RowBox[{"n", "+", "3"}]}], "]"}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"a", "[", 
    RowBox[{"m", ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375482845],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"m", ",", "n"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"m", "+", "n"}], "]"}], "+", 
     RowBox[{"m", " ", 
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], "[", 
       RowBox[{"m", "+", "n"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["m", "2"], " ", 
      RowBox[{
       RowBox[{"C", "[", "3", "]"}], "[", 
       RowBox[{"m", "+", "n"}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{351, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->115644198]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{
       RowBox[{"m", "+", "4"}], ",", "n"}], "]"}], "-", 
     RowBox[{"4", 
      RowBox[{"a", "[", 
       RowBox[{
        RowBox[{"m", "+", "3"}], ",", 
        RowBox[{"n", "+", "1"}]}], "]"}]}], "+", 
     RowBox[{"6", 
      RowBox[{"a", "[", 
       RowBox[{
        RowBox[{"m", "+", "2"}], ",", 
        RowBox[{"n", "+", "2"}]}], "]"}]}], "-", 
     RowBox[{"4", 
      RowBox[{"a", "[", 
       RowBox[{
        RowBox[{"m", "+", "1"}], ",", 
        RowBox[{"n", "+", "3"}]}], "]"}]}], "+", 
     RowBox[{"a", "[", 
      RowBox[{"m", ",", " ", 
       RowBox[{"n", "+", "4"}]}], "]"}]}], " ", "==", " ", "0"}], ",", "a", 
   ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->630893984],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"m", ",", "n"}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "[", 
        RowBox[{"m", "+", "n"}], "]"}], "+", 
       RowBox[{"m", " ", 
        RowBox[{
         RowBox[{"C", "[", "2", "]"}], "[", 
         RowBox[{"m", "+", "n"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["m", "2"], " ", 
        RowBox[{
         RowBox[{"C", "[", "3", "]"}], "[", 
         RowBox[{"m", "+", "n"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["m", "3"], " ", 
        RowBox[{
         RowBox[{"C", "[", "4", "]"}], "[", 
         RowBox[{"m", "+", "n"}], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{529, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->142832827]
}, Open  ]],

Cell["Inhomogeneous:", "ExampleText",
 CellID->608036519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{
       RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], "-", 
     RowBox[{"4", 
      RowBox[{"a", "[", 
       RowBox[{"m", ",", 
        RowBox[{"n", "+", "1"}]}], "]"}]}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"6", 
      RowBox[{"m", "^", "2"}], " ", "n"}], "+", "4"}]}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"m", ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->832122888],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"m", ",", "n"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["2", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "m"}]}]]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "3"]}], " ", 
         SuperscriptBox["2", 
          RowBox[{"3", "-", 
           RowBox[{"2", " ", "m"}]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["2", "m"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox["2", "m"]}], ")"}]}], "+", 
        RowBox[{
         FractionBox["1", "9"], " ", 
         SuperscriptBox["2", 
          RowBox[{"2", "-", 
           RowBox[{"2", " ", "m"}]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5"}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["4", "m"]}], "-", 
           RowBox[{"6", " ", "m"}], "-", 
           RowBox[{"9", " ", 
            SuperscriptBox["m", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         FractionBox["1", "9"], " ", 
         SuperscriptBox["2", 
          RowBox[{"2", "-", 
           RowBox[{"2", " ", "m"}]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "11"}], "+", 
           RowBox[{"11", " ", 
            SuperscriptBox["4", "m"]}], "-", 
           RowBox[{"15", " ", "m"}], "-", 
           RowBox[{"9", " ", 
            SuperscriptBox["m", "2"]}], "-", 
           RowBox[{"9", " ", 
            SuperscriptBox["m", "3"]}]}], ")"}]}], "-", 
        RowBox[{
         FractionBox["1", "9"], " ", 
         SuperscriptBox["2", 
          RowBox[{"2", "-", 
           RowBox[{"2", " ", "m"}]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5"}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["4", "m"]}], "-", 
           RowBox[{"6", " ", "m"}], "-", 
           RowBox[{"9", " ", 
            SuperscriptBox["m", "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n"}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["4", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}]], " ", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "[", 
       RowBox[{"m", "+", "n"}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{571, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->264051588]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141210847],

Cell["Variable coefficient linear equation:", "ExampleText",
 CellID->313651697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"m", ",", "n"}], "]"}], "-", 
     RowBox[{"m", " ", 
      RowBox[{"a", "[", 
       RowBox[{
        RowBox[{"m", "-", "1"}], ",", 
        RowBox[{"n", "-", "1"}]}], "]"}]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"m", ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20755232],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"m", ",", "n"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "m"}], "]"}], " ", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{
       RowBox[{"-", "m"}], "+", "n"}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52554747]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"m", ",", "n"}], "]"}], "==", 
    RowBox[{
     RowBox[{"m", "^", "3"}], 
     RowBox[{"a", "[", 
      RowBox[{
       RowBox[{"m", "+", "1"}], ",", 
       RowBox[{"n", "+", " ", "1"}]}], "]"}]}]}], " ", ",", "a", ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", " ", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50742991],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"m", ",", "n"}], "}"}], ",", 
      FractionBox[
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "[", 
        RowBox[{
         RowBox[{"-", "m"}], "+", "n"}], "]"}], 
       SuperscriptBox[
        RowBox[{"Pochhammer", "[", 
         RowBox[{"1", ",", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m"}]}], "]"}], "3"]]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{322, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->101146641]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Q\[Dash]Difference Equations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->101269338],

Cell[TextData[{
 "First-order constant coefficient ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 "-difference equation:"
}], "ExampleText",
 CellID->292776386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"q", " ", "n"}], "]"}], "\[Equal]", 
    RowBox[{"2", 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22368006],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       FractionBox[
        RowBox[{"Log", "[", "n", "]"}], 
        RowBox[{"Log", "[", "q", "]"}]]}]], " ", 
     RowBox[{"C", "[", "1", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{163, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78836773]
}, Open  ]],

Cell["Equivalent way of expressing the same equation:", "ExampleText",
 CellID->26985616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"2", 
     RowBox[{"a", "[", 
      RowBox[{"n", "/", "q"}], "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->156919886],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       FractionBox[
        RowBox[{"Log", "[", "n", "]"}], 
        RowBox[{"Log", "[", "q", "]"}]]}]], " ", 
     RowBox[{"C", "[", "1", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{163, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->147742234]
}, Open  ]],

Cell["Initial value:", "ExampleText",
 CellID->22466475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "\[Equal]", 
      RowBox[{"2", 
       RowBox[{"a", "[", 
        RowBox[{"n", "/", "q"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->81220557],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    SuperscriptBox["2", 
     FractionBox[
      RowBox[{"Log", "[", "n", "]"}], 
      RowBox[{"Log", "[", "q", "]"}]]]}], "}"}], "}"}]], "Output",
 ImageSize->{117, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->595013650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->482497475],

Cell["Second-order equation: ", "ExampleText",
 CellID->157557312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"q", " ", "n"}], "]"}], "+", 
     RowBox[{"a", "[", 
      RowBox[{"n", "/", "q"}], "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->223059353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", 
         RowBox[{"Log", "[", "n", "]"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"Log", "[", "q", "]"}]}]], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", 
         RowBox[{"Log", "[", "n", "]"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"Log", "[", "q", "]"}]}]], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{335, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->931807230]
}, Open  ]],

Cell["Third-order: ", "ExampleText",
 CellID->357341115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Equal]", " ", 
    RowBox[{"a", "[", 
     RowBox[{"n", "/", 
      RowBox[{"q", "^", "3"}]}], "]"}]}], ",", "a", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->299572584],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"Cos", "[", 
         FractionBox[
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"Log", "[", "n", "]"}]}], 
          RowBox[{"3", " ", 
           RowBox[{"Log", "[", "q", "]"}]}]], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "3", "]"}], " ", 
        RowBox[{"Sin", "[", 
         FractionBox[
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"Log", "[", "n", "]"}]}], 
          RowBox[{"3", " ", 
           RowBox[{"Log", "[", "q", "]"}]}]], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{477, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->512750763]
}, Open  ]],

Cell["Inhomogeneous:", "ExampleText",
 CellID->110720299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{
       RowBox[{"q", "^", "2"}], " ", "n"}], "]"}], "+", 
     RowBox[{"a", "[", "n", "]"}]}], "\[Equal]", "n"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->64859419],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["n", 
      RowBox[{"1", "+", 
       SuperscriptBox["q", "2"]}]], "+", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", 
         RowBox[{"Log", "[", "n", "]"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"Log", "[", "q", "]"}]}]], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", 
         RowBox[{"Log", "[", "n", "]"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"Log", "[", "q", "]"}]}]], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{384, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->693771009]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39776542],

Cell[TextData[{
 "Using a numeric value for ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->117826049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"3", " ", 
        RowBox[{"a", "[", 
         RowBox[{"n", "/", "2"}], "]"}]}], "+", "n"}]}], ",", " ", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "a", ",",
    "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11832526],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       SuperscriptBox["3", 
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"Log", "[", "n", "]"}], 
          RowBox[{"Log", "[", "2", "]"}]]}]], "-", 
       RowBox[{"2", " ", "n"}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{238, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->282934539]
}, Open  ]],

Cell["Plot solution:", "ExampleText",
 CellID->57554124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "/.", 
      RowBox[{"First", "[", "%", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->92424206],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWr9v1DAU9l1CB0RvRrSFzi39DygMCJjKAoUJpFOF1A53RaVig5EfEmWv
oC2CtmKnghXEwi/BWoYuZehQkCjSSYgKHX62c3ZenGDl7CTt3UmX5MX2931+
9nuxczdWnZ28VqvOTk1UB8/NVK9PTk3cGDw7PUNveSVCyBr93jxM6HWTXrHv
WrNJz9HjED36tMJRsDyoyT5kgB7K4j6c++kZisvC9ljrYaUV0aBAK+JLmxjd
AQ7oRgnO7NZxhNsnVA9Ywh9B+Ed0/QphBP6JKvg/ep/iW8+wF1HUoVhNx1KM
QhR/OAYtmBEBW78yI+TMUOdYL0JYTrh7kB6fCz3ROgeQ7TP78vgqvXXm9GPS
E1e/0fija9+yd3Z+t1X+fbsBl5if66ONxVTSl1NxieW7u39TlmO9ntarh5j9
/t1mvfbi1ct1UkFe4/W3tn4JL7TaK3aZeqCCetsb9O7b5k9pS7Ute2PjB1xW
jNSyaPEoZKK6sB1SR4sS1Qk1enVf17f3sDoW997K8pdTo/P3770RrfJU18qh
EMVUFURx/qqiPqPRMV1XoqMo6ka6agqsBmY3V8Fj7u6d19r5k51P+EoqOday
VpMcW9mpGe0wdpidJzusz/mx+8ruCa/LTjSjOcKdEr5MDDY3/FhGirDNFYbz
hjuFjD2yP8H6wOS6whnEnS5PUUEMvDbWQWpIjzpeZrPKsSJxIsruFEeeWwVB
lj3vnCXbPuXLRrxH8x9oHpp78FaUZ8M6fmFFZL8sWWVuc8cKc/RqJn260mUp
DEt31E1Y0FqkqX+OcO7FhY+hvJTNOiiqA2cqG2tX3mVFCnv7CNScU74/tPX0
RiubkB981O+aJU5BuM85zea0Ha4g09StobnR2EV1PfZPlj6FsqMdjZcuroZy
nR1UvOpqF/VWzigwCrdz1GCyF0uJnGLfuV+YwEzHEPyWn/y0aW+sW/5wwBG8
SYt7o2Yz3p49/RyTt0ziTb4za0dDfD4yQ5krZCvw0sNCKit+K9e+M8nYhkgp
8iZHlpFnG1muGtKuygGSY+F/TthQuegayWB09S3xbIqvBZhLbWJkX2vvqual
/FckiBlfi7HAbPlUSqolnzr6Wvw/W6T0D05y1Dk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->229604481]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50830592],

Cell["Linear varying coefficient equations:", "ExampleText",
 CellID->273583888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"q", " ", "n"}], "]"}], "\[Equal]", 
    RowBox[{"n", " ", 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", "a", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->259433476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       SuperscriptBox["n", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           FractionBox[
            RowBox[{"Log", "[", "n", "]"}], 
            RowBox[{"Log", "[", "q", "]"}]]}], ")"}]}]], " ", 
       RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{264, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169426]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"q", "^", "2"}], " ", "n"}], "]"}], "\[Equal]", 
    RowBox[{"n", " ", 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", "a", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3290360],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["n", 
         RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            FractionBox[
             RowBox[{"Log", "[", "n", "]"}], 
             RowBox[{"Log", "[", "q", "]"}]]}], ")"}]}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         FractionBox[
          RowBox[{"Log", "[", "n", "]"}], 
          RowBox[{"Log", "[", "q", "]"}]]], " ", 
        SuperscriptBox["n", 
         RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            FractionBox[
             RowBox[{"Log", "[", "n", "]"}], 
             RowBox[{"Log", "[", "q", "]"}]]}], ")"}]}]], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{448, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47893393]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63025014],

Cell["Nonlinear equations: ", "ExampleText",
 CellID->799482137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"q", " ", "n"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], "^", "2"}]}], ",", "a", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46239688],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SuperscriptBox["2", 
         FractionBox[
          RowBox[{"Log", "[", "n", "]"}], 
          RowBox[{"Log", "[", "q", "]"}]]], " ", 
        RowBox[{"C", "[", "1", "]"}]}]]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{226, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114239650]
}, Open  ]],

Cell["Riccati equation:", "ExampleText",
 CellID->524457134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"q", " ", "n"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "[", "n", "]"}], "+", "15"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "[", "n", "]"}], "+", "7"}], ")"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375927220],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", 
           FractionBox["1", "4"]}], ")"}], 
         FractionBox[
          RowBox[{"Log", "[", "n", "]"}], 
          RowBox[{"Log", "[", "q", "]"}]]]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         FractionBox[
          RowBox[{"Log", "[", "n", "]"}], 
          RowBox[{"Log", "[", "q", "]"}]]], " ", 
        SuperscriptBox["2", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"Log", "[", "n", "]"}], 
           RowBox[{"Log", "[", "q", "]"}]]}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox["1", "4"]}], ")"}], 
        FractionBox[
         RowBox[{"Log", "[", "n", "]"}], 
         RowBox[{"Log", "[", "q", "]"}]]], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         FractionBox[
          RowBox[{"Log", "[", "n", "]"}], 
          RowBox[{"Log", "[", "q", "]"}]]], " ", 
        SuperscriptBox["2", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"Log", "[", "n", "]"}], 
           RowBox[{"Log", "[", "q", "]"}]]}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{333, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->360759450]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->209712543],

Cell[TextData[{
 "A linear constant coefficient system of ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 "-difference equations:"
}], "ExampleText",
 CellID->139298089],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{
         RowBox[{"q", "^", "2"}], " ", "n"}], "]"}], "-", 
       RowBox[{"z", "[", 
        RowBox[{"q", " ", "n"}], "]"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "[", 
        RowBox[{"q", " ", "n"}], "]"}], "-", 
       RowBox[{"5", " ", 
        RowBox[{"y", "[", "n", "]"}]}]}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "n", "]"}], ",", 
     RowBox[{"z", "[", "n", "]"}]}], "}"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2103573],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "n", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["5", 
        FractionBox[
         RowBox[{"Log", "[", "n", "]"}], 
         RowBox[{"2", " ", 
          RowBox[{"Log", "[", "q", "]"}]}]]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          FractionBox[
           RowBox[{"Log", "[", "n", "]"}], 
           RowBox[{"Log", "[", "q", "]"}]]]}], ")"}], " ", 
       RowBox[{"C", "[", "1", "]"}]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["5", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "2"]}], "+", 
         FractionBox[
          RowBox[{"Log", "[", "n", "]"}], 
          RowBox[{"2", " ", 
           RowBox[{"Log", "[", "q", "]"}]}]]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          FractionBox[
           RowBox[{"Log", "[", "n", "]"}], 
           RowBox[{"Log", "[", "q", "]"}]]]}], ")"}], " ", 
       RowBox[{"C", "[", "2", "]"}]}]}]}], ",", 
    RowBox[{
     RowBox[{"z", "[", "n", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox["5", 
        RowBox[{
         FractionBox["1", "2"], "+", 
         FractionBox[
          RowBox[{"Log", "[", "n", "]"}], 
          RowBox[{"2", " ", 
           RowBox[{"Log", "[", "q", "]"}]}]]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          FractionBox[
           RowBox[{"Log", "[", "n", "]"}], 
           RowBox[{"Log", "[", "q", "]"}]]]}], ")"}], " ", 
       RowBox[{"C", "[", "1", "]"}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["5", 
        FractionBox[
         RowBox[{"Log", "[", "n", "]"}], 
         RowBox[{"2", " ", 
          RowBox[{"Log", "[", "q", "]"}]}]]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          FractionBox[
           RowBox[{"Log", "[", "n", "]"}], 
           RowBox[{"Log", "[", "q", "]"}]]]}], ")"}], " ", 
       RowBox[{"C", "[", "2", "]"}]}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{500, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->891983908]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23135],

Cell["No boundary condition, gives two generated parameters:", "ExampleText",
 CellID->4991966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", 
     RowBox[{"4", 
      RowBox[{"a", "[", "n", "]"}]}]}], "}"}], ",", " ", "a", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->721588173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["2", "n"], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}], "n"], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->492664246]
}, Open  ]],

Cell["One boundary condition:", "ExampleText",
 CellID->490851081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", 
      RowBox[{"4", 
       RowBox[{"a", "[", "n", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", " ", "a",
    ",", " ", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->531383639],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       SuperscriptBox["2", "n"], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}], "n"], " ", 
        RowBox[{"C", "[", "2", "]"}]}], "-", 
       RowBox[{
        SuperscriptBox["2", "n"], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->387502848]
}, Open  ]],

Cell["Two boundary conditions:", "ExampleText",
 CellID->17015412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", 
      RowBox[{"4", 
       RowBox[{"a", "[", "n", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "\[Equal]", "4"}]}], "}"}], ",", " ", "a",
    ",", " ", "n"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->223255139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "n"}]]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "n"]}], ")"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{271, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->364807344]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11842],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GeneratedParameters",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->16787],

Cell["Use differently named constants:", "ExampleText",
 CellID->518909729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", 
    RowBox[{"2", 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", " ", 
   RowBox[{"a", "[", "n", "]"}], ",", "n", ",", " ", 
   RowBox[{"GeneratedParameters", "\[Rule]", "d"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167693793],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"n", "/", "2"}]], " ", 
      RowBox[{"d", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"], " ", 
      SuperscriptBox["2", 
       RowBox[{"n", "/", "2"}]], " ", 
      RowBox[{"d", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{233, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28850127]
}, Open  ]],

Cell["Use subscripted constants:", "ExampleText",
 CellID->668299265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", 
    RowBox[{"2", 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", " ", 
   RowBox[{"a", "[", "n", "]"}], ",", "n", ",", " ", 
   RowBox[{"GeneratedParameters", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Subscript", "[", 
       RowBox[{"c", ",", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->355074764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"n", "/", "2"}]], " ", 
      SubscriptBox["c", "1"]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"], " ", 
      SuperscriptBox["2", 
       RowBox[{"n", "/", "2"}]], " ", 
      SubscriptBox["c", "2"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{202, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->91262983]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28451],

Cell[TextData[{
 "This models the amount ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " at year ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " when the interest ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " is paid on the principal ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " only:"
}], "ExampleText",
 CellID->51205494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"a", "[", "n", "]"}], "+", 
        RowBox[{"r", " ", "p"}]}]}], ",", 
      RowBox[{
       RowBox[{"a", "[", "0", "]"}], "\[Equal]", "p"}]}], "}"}], ",", 
    RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}], "//", 
  "Factor"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->519613323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"p", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"n", " ", "r"}]}], ")"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227904045]
}, Open  ]],

Cell[TextData[{
 "Here the interest is paid on the current amount ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ", i.e. compound interest:"
}], "ExampleText",
 CellID->203841013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "r"}], ")"}], 
       RowBox[{"a", "[", "n", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "p"}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->391484702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"p", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "r"}], ")"}], "n"]}]}], "}"}], "}"}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44526006]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->208352047],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"a", "[", "n", "]"}], "TI"]], "InlineFormula"],
 " denotes the number of moves required in the Tower of Hanoi problem with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " disks:"
}], "ExampleText",
 CellID->244787903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"a", "[", "n", "]"}]}], "+", "1"}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195640573],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["2", "n"]}]}], "}"}], "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->391382328]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->201197455],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"a", "[", "n", "]"}], "TI"]], "InlineFormula"],
 " is the number of ways to tile a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Times]", "3"}], TraditionalForm]], "InlineMath"],
 " space with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Times]", "1"}], TraditionalForm]], "InlineMath"],
 " tiles: "
}], "ExampleText",
 CellID->43284259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"n", "+", "4"}], "]"}], "-", 
       RowBox[{"4", 
        RowBox[{"a", "[", 
         RowBox[{"n", "+", "2"}], "]"}]}], "+", 
       RowBox[{"a", "[", "n", "]"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "2", "]"}], "\[Equal]", "3"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "3", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "4", "]"}], "\[Equal]", "11"}]}], "}"}], ",", "a", 
   ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132066701],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{"-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "n"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "123"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"2", "-", 
                SqrtBox["3"]}], ")"}], 
              RowBox[{"n", "/", "2"}]]}], "+", 
            RowBox[{"71", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"2", "-", 
                SqrtBox["3"]}], ")"}], 
              RowBox[{"n", "/", "2"}]]}], "-", 
            RowBox[{"33", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"2", "+", 
                SqrtBox["3"]}], ")"}], 
              RowBox[{"n", "/", "2"}]]}], "+", 
            RowBox[{"19", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"2", "+", 
                SqrtBox["3"]}], ")"}], 
              RowBox[{"n", "/", "2"}]]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            SqrtBox["3"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"4", " ", 
             SqrtBox["3"]}]}], ")"}]}], ")"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{580, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->288005792]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "/.", 
      RowBox[{"First", "[", "%", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "2", ",", "20", ",", "2"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->156773875],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "11", ",", "41", ",", "153", ",", "571", ",", "2131", ",", "7953",
    ",", "29681", ",", "110771", ",", "413403"}], "}"}]], "Output",
 ImageSize->{378, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->378944053]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167207028],

Cell["The number of comparisons for a binary search problem: ", "ExampleText",
 CellID->575766635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", "[", "n", "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{"b", "[", 
       RowBox[{"n", "/", "2"}], "]"}], "+", "1"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"b", "[", "1", "]"}], "\[Equal]", "1"}]}], ",", "b", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288554387],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"b", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      FractionBox[
       RowBox[{
        RowBox[{"Log", "[", "2", "]"}], "+", 
        RowBox[{"Log", "[", "n", "]"}]}], 
       RowBox[{"Log", "[", "2", "]"}]]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{258, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258378728]
}, Open  ]],

Cell["\<\
Number of arithmetic operations in the fast Fourier transform:\
\>", "ExampleText",
 CellID->25467917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "n", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"f", "[", 
       RowBox[{"n", "/", "2"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}], "n"}]}]}], ",", "f", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->122150084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       RowBox[{"2", " ", "n", " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       FractionBox[
        RowBox[{"3", " ", "n", " ", 
         RowBox[{"Log", "[", "n", "]"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"Log", "[", "2", "]"}]}]]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{284, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->76160678]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->416316283],

Cell[TextData[{
 "The integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"e", "[", "n", "]"}], "==", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "1", "\[Infinity]"], 
     RowBox[{
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "x"}], " ", "t"}]], 
       SuperscriptBox["t", "n"]], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 " satisfies the difference equation: "
}], "ExampleText",
 CellID->69335938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"e", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"1", "/", "n"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{"-", "x"}], "]"}], "-", 
         RowBox[{"x", " ", 
          RowBox[{"e", "[", "n", "]"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"e", "[", "1", "]"}], "\[Equal]", 
      RowBox[{"Gamma", "[", 
       RowBox[{"0", ",", "x"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"e", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107004108],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"e", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", 
        FractionBox["1", "x"]}], ")"}], "n"], " ", 
     SuperscriptBox["x", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"1", "-", "n"}], ",", "x"}], "]"}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{286, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17421266]
}, Open  ]],

Cell[TextData[{
 "The integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"i", "[", "n", "]"}], "==", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Pi]"], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         ButtonBox["Cos",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Cos"], "[", 
         RowBox[{"n", " ", "\[Theta]"}], "]"}], "-", 
        RowBox[{
         ButtonBox["Cos",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Cos"], "[", 
         RowBox[{"n", " ", "\[Phi]"}], "]"}]}], 
       RowBox[{
        RowBox[{
         ButtonBox["Cos",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Cos"], "[", "\[Theta]", "]"}], "-", 
        RowBox[{
         ButtonBox["Cos",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Cos"], "[", "\[Phi]", "]"}]}]], 
      RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 " satisfies the difference equation:"
}], "ExampleText",
 CellID->589668447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"i", "[", 
        RowBox[{"n", "+", "2"}], "]"}], "-", 
       RowBox[{"2", 
        RowBox[{"Cos", "[", "\[Phi]", "]"}], 
        RowBox[{"i", "[", 
         RowBox[{"n", "+", "1"}], "]"}]}], "+", 
       RowBox[{"i", "[", "n", "]"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"i", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"i", "[", "1", "]"}], "\[Equal]", "Pi"}]}], "}"}], ",", 
   RowBox[{"i", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->66857653],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"i", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[Pi]", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Cos", "[", "\[Phi]", "]"}], "-", 
            SqrtBox[
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox[
               RowBox[{"Cos", "[", "\[Phi]", "]"}], "2"]}]]}], ")"}], "n"], 
         "-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Cos", "[", "\[Phi]", "]"}], "+", 
            SqrtBox[
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox[
               RowBox[{"Cos", "[", "\[Phi]", "]"}], "2"]}]]}], ")"}], "n"]}], 
        ")"}]}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "\[Phi]", "]"}], "2"]}]]}]]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{462, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->314112637]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->766931940],

Cell[TextData[{
 "The difference equation for the series coefficients of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
     RowBox[{"2", "x", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], TraditionalForm]], 
  "InlineMath"],
 ": "
}], "ExampleText",
 CellID->167512801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"n", " ", 
       RowBox[{"a", "[", "n", "]"}]}], "\[Equal]", 
      RowBox[{"2", 
       RowBox[{"a", "[", 
        RowBox[{"n", "-", "2"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->626323128],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"]}], 
     RowBox[{"2", " ", 
      RowBox[{
       FractionBox["n", "2"], "!"}]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{134, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11925184]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], "/.", 
     RowBox[{"First", "[", "%", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->78641019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", 
   FractionBox["1", "2"], ",", "0", ",", 
   FractionBox["1", "6"], ",", "0", ",", 
   FractionBox["1", "24"], ",", "0", ",", 
   FractionBox["1", "120"]}], "}"}]], "Output",
 ImageSize->{245, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->309990843]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"2", "x", " ", 
       RowBox[{"y", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->87857765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox["x", "2"]]}], "}"}], "}"}]], "Output",
 ImageSize->{94, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->312313343]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", 
    RowBox[{"First", "[", "%", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7624890],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   SuperscriptBox["x", "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "6"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "8"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "10"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 1, 0, 
    Rational[1, 2], 0, 
    Rational[1, 6], 0, 
    Rational[1, 24], 0, 
    Rational[1, 120]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{215, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->99482009]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesCoefficient", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->536596124],

Cell[BoxData[
 FractionBox[
  RowBox[{"KroneckerDelta", "[", 
   RowBox[{"Mod", "[", 
    RowBox[{"n", ",", "2"}], "]"}], "]"}], 
  RowBox[{
   FractionBox["n", "2"], "!"}]]], "Output",
 ImageSize->{181, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->934005447]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->59294354],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", 
   FractionBox["1", "2"], ",", "0", ",", 
   FractionBox["1", "6"], ",", "0", ",", 
   FractionBox["1", "24"], ",", "0", ",", 
   FractionBox["1", "120"]}], "}"}]], "Output",
 ImageSize->{245, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->19945584]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->607440793],

Cell[TextData[{
 "The determinant of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "\[Times]", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " tridiagonal matrix with diagonals ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", ",", "a", ",", "b"}], TraditionalForm]], "InlineMath"],
 " satisfies:"
}], "ExampleText",
 CellID->69633857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"d", "[", 
       RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"d", "[", 
         RowBox[{"n", "+", "1"}], "]"}]}], "-", 
       RowBox[{"b", " ", "c", " ", 
        RowBox[{"d", "[", "n", "]"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"d", "[", "1", "]"}], "\[Equal]", "a"}], ",", 
     RowBox[{
      RowBox[{"d", "[", "2", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", 
       RowBox[{"b", " ", "c"}]}]}]}], "}"}], ",", 
   RowBox[{"d", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->441055550],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"d", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"4", " ", "b", " ", "c"}]}]]], 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{"-", "1"}], "-", "n"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "-", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["a", "2"], "-", 
              RowBox[{"4", " ", "b", " ", "c"}]}]]}], ")"}], "n"]}], "+", 
        RowBox[{
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"4", " ", "b", " ", "c"}]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "-", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["a", "2"], "-", 
              RowBox[{"4", " ", "b", " ", "c"}]}]]}], ")"}], "n"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["a", "2"], "-", 
              RowBox[{"4", " ", "b", " ", "c"}]}]]}], ")"}], "n"]}], "+", 
        RowBox[{
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"4", " ", "b", " ", "c"}]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["a", "2"], "-", 
              RowBox[{"4", " ", "b", " ", "c"}]}]]}], ")"}], "n"]}]}], 
       ")"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{512, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54837633]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"d", "[", "n", "]"}], "/.", 
      RowBox[{"First", "[", "%", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "2", ",", "5"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->308199093],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    RowBox[{"b", " ", "c"}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "3"], "-", 
    RowBox[{"2", " ", "a", " ", "b", " ", "c"}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "5"], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c"}], "+", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}]}]}], "}"}]], "Output",
 ImageSize->{393, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4338689]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Det", " ", "@", 
    RowBox[{"SparseArray", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Band", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "a"}], ",", 
        RowBox[{
         RowBox[{"Band", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", "b"}], ",", 
        RowBox[{
         RowBox[{"Band", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "c"}]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->127229090],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    RowBox[{"b", " ", "c"}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "3"], "-", 
    RowBox[{"2", " ", "a", " ", "b", " ", "c"}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "5"], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c"}], "+", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}]}]}], "}"}]], "Output",
 ImageSize->{393, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->171295901]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36099954],

Cell[TextData[{
 "This models the surface area ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " in dimension ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " of a unit sphere: "
}], "ExampleText",
 CellID->673968343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"s", "[", 
       RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", 
      RowBox[{"2", 
       RowBox[{"Pi", "/", "n"}], " ", 
       RowBox[{"s", "[", "n", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"s", "[", "2", "]"}], "\[Equal]", 
      RowBox[{"2", "Pi"}]}], ",", 
     RowBox[{
      RowBox[{"s", "[", "3", "]"}], "\[Equal]", 
      RowBox[{"4", "Pi"}]}]}], "}"}], ",", 
   RowBox[{"s", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->224029958],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"s", "[", "n", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["\[Pi]", 
       RowBox[{"n", "/", "2"}]]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        FractionBox["n", "2"]}], ")"}], "!"}]]}], "}"}], "}"}]], "Output",
 ImageSize->{140, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194858570]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"s", "[", "n", "]"}], "/.", 
    RowBox[{"First", "[", "%", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->529400338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "\[Pi]"}], ",", 
   RowBox[{"4", " ", "\[Pi]"}], ",", 
   RowBox[{"2", " ", 
    SuperscriptBox["\[Pi]", "2"]}], ",", 
   FractionBox[
    RowBox[{"8", " ", 
     SuperscriptBox["\[Pi]", "2"]}], "3"], ",", 
   SuperscriptBox["\[Pi]", "3"], ",", 
   FractionBox[
    RowBox[{"16", " ", 
     SuperscriptBox["\[Pi]", "3"]}], "15"], ",", 
   FractionBox[
    SuperscriptBox["\[Pi]", "4"], "3"], ",", 
   FractionBox[
    RowBox[{"32", " ", 
     SuperscriptBox["\[Pi]", "4"]}], "105"], ",", 
   FractionBox[
    SuperscriptBox["\[Pi]", "5"], "12"]}], "}"}]], "Output",
 ImageSize->{314, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->132849368]
}, Open  ]],

Cell[TextData[{
 "The volume of the unit ball in dimension ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25967949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"v", "[", "n", "]"}], "\[Equal]", 
      RowBox[{"2", "Pi", " ", 
       RowBox[{
        RowBox[{"v", "[", 
         RowBox[{"n", "-", "2"}], "]"}], "/", "n"}]}]}], ",", 
     RowBox[{
      RowBox[{"v", "[", "2", "]"}], "\[Equal]", "Pi"}], ",", 
     RowBox[{
      RowBox[{"v", "[", "3", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"4", "/", "3"}], "Pi"}]}]}], "}"}], ",", 
   RowBox[{"v", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->193076894],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"v", "[", "n", "]"}], "\[Rule]", 
    FractionBox[
     SuperscriptBox["\[Pi]", 
      RowBox[{"n", "/", "2"}]], 
     RowBox[{
      FractionBox["n", "2"], "!"}]]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->674968630]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"v", "[", "n", "]"}], "/.", 
    RowBox[{"First", "[", "%", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->120733083],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Pi]", ",", 
   FractionBox[
    RowBox[{"4", " ", "\[Pi]"}], "3"], ",", 
   FractionBox[
    SuperscriptBox["\[Pi]", "2"], "2"], ",", 
   FractionBox[
    RowBox[{"8", " ", 
     SuperscriptBox["\[Pi]", "2"]}], "15"], ",", 
   FractionBox[
    SuperscriptBox["\[Pi]", "3"], "6"], ",", 
   FractionBox[
    RowBox[{"16", " ", 
     SuperscriptBox["\[Pi]", "3"]}], "105"], ",", 
   FractionBox[
    SuperscriptBox["\[Pi]", "4"], "24"], ",", 
   FractionBox[
    RowBox[{"32", " ", 
     SuperscriptBox["\[Pi]", "4"]}], "945"], ",", 
   FractionBox[
    SuperscriptBox["\[Pi]", "5"], "120"]}], "}"}]], "Output",
 ImageSize->{313, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->326081229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->327667031],

Cell[TextData[{
 "Applying Newton's method to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "2"], "==", "3"}], TraditionalForm]], "InlineMath"],
 ", or computing ",
 Cell[BoxData[
  FormBox[
   SqrtBox["3"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->606545337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", 
      RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "[", "n", "]"}], "+", 
        RowBox[{"3", "/", 
         RowBox[{"y", "[", "n", "]"}]}]}], ")"}]}]}], "&&", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "\[Equal]", 
     RowBox[{"1", "/", "5"}]}]}], ",", "y", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180882920],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->771870093],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"Coth", "[", 
        RowBox[{
         SuperscriptBox["2", "n"], " ", 
         RowBox[{"ArcCoth", "[", 
          FractionBox["1", 
           RowBox[{"5", " ", 
            SqrtBox["3"]}]], "]"}]}], "]"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{343, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->369786933]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "k", "]"}], "/.", 
     RowBox[{"%", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1.", ",", "6"}], "}"}]}], "]"}], "//", 
  "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->267811800],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7.599999999999998`", ",", "3.997368421052631`", ",", "2.373931083469041`", 
   ",", "1.8188288719067005`", ",", "1.7341209397749724`", ",", 
   "1.732052043194159`"}], "}"}]], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->293953519]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74751799],

Cell[TextData[{
 "Applying the Euler forward method to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{"1", "/", "100"}], " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], TraditionalForm]], 
  "InlineMath"],
 " yields:"
}], "ExampleText",
 CellID->21485607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"101", " ", 
         RowBox[{"y", "[", "n", "]"}]}], "100"], "-", 
       RowBox[{"2", " ", 
        RowBox[{"y", "[", 
         RowBox[{"n", "+", "1"}], "]"}]}], "+", 
       RowBox[{"y", "[", 
        RowBox[{"n", "+", "2"}], "]"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "y", ",",
    "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22861247],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "n"}]], " ", 
       SuperscriptBox["101", 
        RowBox[{"n", "/", "2"}]], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"n", " ", 
         RowBox[{"ArcTan", "[", 
          FractionBox["1", "10"], "]"}]}], "]"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{344, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116987281]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"y", "[", "k", "]"}], "/.", 
     RowBox[{"First", "[", "%", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->41427780],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytmG1ollUYx8/2vMwibZWWbrPWq72pvZvVWm9qttQ0baRWzqVtps3pTJpU
WjGjloVBuS9JlIHVByMxAoNIiIRIiISoIAzCPiRB0odBcPe7rvs+e+6Xa5t7
2oO7n3Pd53/+13Wut3Me57V0ta1a19LV3tpSP2dDy/q29taN9bM7NvAqV+Gc
289f50THOGCkf/uDgO/scyrPPIDJIuUEqR9Xx6Myei/fIst0ZSTndPW02Cpn
sNTKI1+SnfGmLvNGdMg2KuRbX01P8dZEVmfXlsdfneJP72OStc+MlkpzZuTa
amJcOXMH5eypZlCbzx82anF9Xxz85ZT01Q7CHs+o+LfLHf3hj46nPu3v/9eV
Mqw6mu1TluPH/25v23fixD+uaOp8W2UYQP3805+uagjUlu7PD331qwxt1Fsq
9+06vOf9IzIco6ixPPdE+8+uKfxPOT/KfKMtj4p9kkcEhxARqDRjKepDVUjd
COcnBFH2kF88M3bZWneqfPJkP6skm84YArWp68Dhb36TYQkleRvOvtZ76JN9
R2U41uR4Q2USjXST4TgT9brKJC2pK8MzTdQOlUu1VJ2wZ4f3ROvKj9mZO8vk
6PU7ByX+OttEvRokq+0cE/WKR2E1LnLjh0Bt7/nyswM/ynB8wupwtlSLE0yO
l1X+6MPv39z5tQzPNVHbVaaLbdt6UIbnmagelbEXq8WLExP2hLPsGR+LFyeZ
HC95X0c9Szuwb2z60WGi0xZTHC96jihza0NYYs1wVfqCjyZ2HDv2V1gdbmi9
uZS8zXNEtTD5FDlE3OozgLXkZXgijFD/86ksusDgyGe8mfbEcymW+kxEipHN
9spSftabEX82hbowkTXp2YtMji0p1MUmqjuFusREPZNCXZqwJz17mcmxOYWa
YqKeTqEuN1GbUqgrTNRGHyWaKkB3VcLqgdkohlebHJ1BKecFNdVErVeZ2oyy
epqJ6ghKdSyo6Ql7wtnwQJMKvcbkWKdy2JWlF1ybybx0xlcalb1WZU6AqO9c
F5RTBU+qjGej3nZ9WSxrVKYnE04Z3mCwFCIfybcsbfOxo/fSyt1NZWl+wseW
/JDb6IyyWFbHonrku9/dzZmIFGPWx1eu8rHkdJR+OjORD+EsdkUxusXMh1aV
OajwhMTgVhPV4ndKpDjXXIOJWqEylrATcsPdbqIeU5laiE6BxoTV4Sw68KlY
fYfJsTxmD7a7u0zUsph/xJ67TdRSlbkWRSfbPQl7Htb4oQn/cHvCRbNMluag
VH2SC3NM1EMqk3HR3u81UYtVJ9WJD8hrdM41cQ96T7I/6S1NCcsXecupC4ig
u99kecCzPLJsr3S5+Zn8i98OShkZ55if0bUgyNbCcGfrvJQlCw0OX8H56LvJ
+4pMCDUvMlYNX4X3+SxAt+TK4rJYNJ55Mo74ki04ZElZPLO9PyGBCsLmTFQG
6wqz/E6al3zAM8zggazQ7M7TZ8iZ0MKlZlbcqbjwZhkeSstNXKPiqBv8DyXE
j5q4Bo8jQzAMF69I2HVbcp7wrzR5ZmZwj5u4GT4S2BXiVpu4GxWHObg5bFtt
Jk5PuALpRfHCB6vcINck9qBnaYH8pVcsXPAepSv9ZK3Jp/eAAvOg4ItOkA4T
e6U8iugmnNgIHCNY2mmip8TQRA5DiDPGdiVs1RtYkbDufudb4haiiN5mk1Nv
mVV0LDjDzbGGlXIL6Y6lsP9UptZbeaq/IE4jAXEYVHigae5uqg87cIXcTfSe
muHK/lZJV4/+3jqdLRNNmMMMgBwViKiTdl4mt/5uHgcBvuIfBxWUuARPo6Sx
oY8AoZCXKCdGPSPQk9NmCwf+hc8VeeQR3RiMD+uQww5q/INu2HtHsovCwBs+
4t8qSHaV6Yd3g8H60V59lf0fXlfxHyuNPM4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->306430798]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
      RowBox[{
       RowBox[{"1", "/", "100"}], 
       RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"y", "[", "1", "]"}], "\[Equal]", "1"}]}], ",", "y", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20821193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{"Cos", "[", 
        FractionBox["x", "10"], "]"}], "-", 
       RowBox[{
        RowBox[{"Cot", "[", 
         FractionBox["1", "10"], "]"}], " ", 
        RowBox[{"Sin", "[", 
         FractionBox["x", "10"], "]"}]}], "+", 
       RowBox[{
        RowBox[{"Csc", "[", 
         FractionBox["1", "10"], "]"}], " ", 
        RowBox[{"Sin", "[", 
         FractionBox["x", "10"], "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",\

 ImageSize->{455, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->147106491]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "/.", 
     RowBox[{"First", "[", "%", "]"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->450545160],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWH1olVUYP7v3fe+0D1tflnPq+v6cSh8mpX0oOsrUhl+lWd4tbbN0ts2M
GaVWs2hGWdAWUkQZWP1hJEZgEAmREAmREBWEQdgfSZD0xyB4+z3POWf3fDzX
XW9BF/be89zzO7/zfJ/zbn6xp331umJPR1uxsbmruKG9o627cW5nF37K1yil
9uGv+0KFcYYR/+3LMny7zyY8E0xNIClPGP6oBjxy5nf6Jpmmc0bO8+rJziol
sIynR1KSlfBLQ/QL7UEG1NA3/zQl4K03Wsdrq+OfGvCPk+yKWHPizMjs9c7a
vKhhJTo3ldVp4ohRqIS/TmCR2N0Mcb/zmZspdUbaxasPf/OrWZ0X93qD5U/2
f7+973NWVUQNWq6NPfuHhv5WqYgaYPnYsT/bWj88cWJIFUTU6yxjvqN979Gj
f6haRp2J527jnXhN+i/lM/5jvv9Fn3RYfnXnlx+8/62OqIOSIzwjkMPOMY3l
j/Ye2dF/cJhlRNbXMj8jThtGUe7p2R9/+L1z/ceUCaeLHDszky9A4am9EqFe
yUy+AAVGzpQY9TLL0GRz76eHvvpFjTkJauuWA58d+ImGYzyt9ezgwKHd7x6m
4Vkix0uBv+pE1A6WoQn8Q8OzRVS/9RNqgbx4joh60frJ1NW5ntZ69vjxv8BB
XjxP5Hgh8OL5Iur5wItjT4IC5OAXP9NwrKePnkU7QVOh4QUiRx+h33rz63Hi
7HOBjzXKpCJ/eOj11ULA8SzLCDTCTcN6DfPWhHWWBPIzNoowluIzXuAI9yXN
SNwWrG2ocK0rb7X5YepoQhUcWwKOiQJHEnkz9MTTAcukKCIFY3e48qnMr/JG
L1vC2YvEfHgyQF0sojYHqEtEVG+AutTTJ5y9TOR4IkBdLqI2OT4j1BUi6vEA
daWI2hj4/ypP63D2apGjm2X0bIO6RkR1ZaXORahrRdRjmakuk91NImoDy2gE
qEFCTfa01rNoAubuMUXkWM8yujKANJwaZV6Y8Tmhsh/NTGeDJmjv6rqsmip4
hGV4Bb6B7er6ilmIZK2TNYiCukFYnRrfhPp3OBGm/n1jVfq3OxlAuTatKpaH
bVRNhtwURaRQxoo1NpaIOOXDdC8fVgcxulnMhzaWcd7BBorBLSKq1foLp+KR
737Tt6AIVcxMFpuzc6aIWmW1Nll8q6f1gzYnUAmk9e0ix0qWcd/FTjg21R0i
6n7rWZz0dDeeJaKWc4SgCbyoHTnb02i5sxe41ByR5V7HdsqouSJqqbMXzIeZ
zSJuifU3NKc97xRRi1mGl8zd/y5P70W8FyKLvIK3sek8kaXFemnlij10S5kf
5Z97OyhlpMux0NkLpsGuBVlcCyOdrQsCTe4ROKgGpHPx7kiDFmF1+W4yL9h7
UcWrXS04TgligWrSWiyuiqfZ5gkChxRAi1kaRaVcV+DMS1AVsAS5AZJlXl5w
/ia696HIUKj3iXkxy3oUhmgdVog4rtAEpuJEWbbkPXKhiOM6T6EOXraAA5qq
/wERy50jARWAeD0D+SrPhhnOPNSDkq0iz3S75zCU+tJDIpa7d4qt4LQSdo2I
5bMmxTyUa1n4DqIEFfR5EGH5bEyRUyh48MJ6snutZw+fwik4MIuwmfNwncjH
d4NU3xWwNzSg2u8UsXxzSRFr3PyBhQbULbtELN+nCujuYISeCDneGKBSj6cp
3+9qYQEUgItAiuYDrclXm0TeSfQYhRVwARwF+JzZu6AJQgL2XqcA7CcXMEhZ
zu8Oo0AAg6CwZoXfEDyYwPfgiCd+ywnrjt+9RoMArNAVFQJPwEa4GjbSybet
SmZ+z6ZzFnVE/YXe1tRouEHvcdvMQZigzzwgyJt9p7BTnts0SEAFQlXAI4Go
8lAeYzhG70gnlOHvPxVLSv8twYdW14JloEpfvJ2V62V7+Kf4v72q5h/RuUYV
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->217698788]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12959],

Cell["Solutions satisfy their difference and boundary equations:", \
"ExampleText",
 CellID->588875236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", " ", 
      RowBox[{"a", "[", "n", "]"}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "\[Equal]", "2"}]}], "}"}], ",", "a", ",",
    "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->611802103],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"3", "-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "n"]}], ")"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{240, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93765999]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", " ", 
      RowBox[{"a", "[", "n", "]"}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "\[Equal]", "2"}]}], "}"}], "/.", "%"}], "//",
   "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->410541803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"True", ",", "True", ",", "True"}], "}"}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66069316]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->820648221],

Cell[TextData[{
 "Difference equation corresponding to ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->125761213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"n", "+", "1"}], "]"}], "-", 
       RowBox[{"a", "[", "n", "]"}]}], "\[Equal]", 
      RowBox[{"n", "^", "2"}]}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "0"}]}], ",", 
    RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}], "//", 
  "Expand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140992805],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["n", "6"], "-", 
     FractionBox[
      SuperscriptBox["n", "2"], "2"], "+", 
     FractionBox[
      SuperscriptBox["n", "3"], "3"]}]}], "}"}], "}"}]], "Output",
 ImageSize->{146, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35646086]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"i", "^", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", 
      RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "//", "Expand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->35317527],

Cell[BoxData[
 RowBox[{
  FractionBox["n", "6"], "-", 
  FractionBox[
   SuperscriptBox["n", "2"], "2"], "+", 
  FractionBox[
   SuperscriptBox["n", "3"], "3"]}]], "Output",
 ImageSize->{74, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->55217611]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->936148305],

Cell[TextData[{
 "Difference equation corresponding to ",
 Cell[BoxData[
  ButtonBox["Product",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Product"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->46519138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      RowBox[{"n", " ", 
       RowBox[{"a", "[", "n", "]"}]}]}], "&&", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "\[Equal]", "1"}]}], ",", 
    RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109666348],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"Gamma", "[", "n", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220828683]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Product", "[", 
   RowBox[{"i", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->248118811],

Cell[BoxData[
 RowBox[{"Gamma", "[", "n", "]"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->485923524]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15251],

Cell["Results may contain symbolic sums and products:", "ExampleText",
 CellID->437948186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], "+", 
     RowBox[{"f", "[", "n", "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30913648],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{
        RowBox[{"K", "[", "1", "]"}], "=", "0"}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}]], 
      RowBox[{"f", "[", 
       RowBox[{"K", "[", "1", "]"}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{198, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20595223]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"f", "[", "n", "]"}], 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->225082654],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], " ", 
     RowBox[{
      UnderoverscriptBox["\[Product]", 
       RowBox[{
        RowBox[{"K", "[", "1", "]"}], "=", "1"}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}]], 
      RowBox[{"f", "[", 
       RowBox[{"K", "[", "1", "]"}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{189, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->344456232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13089477],

Cell["\<\
The solution to this difference equation is unique as a sequence:\
\>", "ExampleText",
 CellID->74365102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
     RowBox[{"2", 
      RowBox[{"a", "[", "n", "]"}]}]}], "&&", 
    RowBox[{
     RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}]}], ",", "a", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->541418026],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      SuperscriptBox["2", "n"]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->429129033]
}, Open  ]],

Cell[TextData[{
 "As a function it is only unique up to a function of period ",
 Cell[BoxData["1"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->63164656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{"2", 
     RowBox[{"a", "[", "n", "]"}]}]}], "&&", 
   RowBox[{
    RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}]}], "/.", 
  RowBox[{"a", "\[Rule]", 
   RowBox[{"Function", "[", 
    RowBox[{"n", ",", 
     RowBox[{
      RowBox[{"2", "^", "n"}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"Pi", " ", "n"}], "]"}]}]}]}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30845830],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{"1", "+", "n"}]], "+", 
   RowBox[{"a", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "n"}], ")"}], " ", "\[Pi]"}], "]"}]}]}], "\[Equal]", 
  
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["2", "n"], "+", 
     RowBox[{"a", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"n", " ", "\[Pi]"}], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->508250526]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", " ", 
  RowBox[{"%", ",", " ", 
   RowBox[{"n", "\[Element]", "Integers"}]}], " ", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->161038863],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->140326492]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->116268602],

Cell["Boundary value problems may have multiple solutions: ", "ExampleText",
 CellID->929290479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], "^", "2"}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48233365],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      SuperscriptBox["2", "n"], " ", 
      RowBox[{"C", "[", "1", "]"}]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{116, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3161160]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "^", "2"}]}], "&&", 
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], "\[Equal]", "3"}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->329223782],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->139975873],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
     SuperscriptBox["3", 
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}]]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["2", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "\[Pi]"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"Log", "[", "3", "]"}]}]}], ")"}]}]]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{286, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40890397]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21220],

Cell[TextData[{
 "Compute the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " iterate or composition of a function:"
}], "ExampleText",
 CellID->56956424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{
        RowBox[{"2", 
         RowBox[{"a", "[", "n", "]"}]}], "+", "3"}], 
       RowBox[{
        RowBox[{"a", "[", "n", "]"}], "+", "4"}]]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118426736],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "n"], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", 
           FractionBox["1", "5"]}], ")"}], "n"]}], ")"}]}], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", 
         FractionBox["1", "5"]}], ")"}], "n"]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{189, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44000676]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], "/.", 
     RowBox[{"First", "[", "%", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->102066075],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["3", "4"], ",", 
   FractionBox["18", "19"], ",", 
   FractionBox["93", "94"], ",", 
   FractionBox["468", "469"], ",", 
   FractionBox["2343", "2344"], ",", 
   FractionBox["11718", "11719"], ",", 
   FractionBox["58593", "58594"], ",", 
   FractionBox["292968", "292969"], ",", 
   FractionBox["1464843", "1464844"], ",", 
   FractionBox["7324218", "7324219"]}], "}"}]], "Output",
 ImageSize->{487, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->331978340]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "#"}], "+", "3"}], 
     RowBox[{
      RowBox[{"1", " ", "#"}], "+", "4"}]], "&"}], ",", "0", ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->126769937],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["3", "4"], ",", 
   FractionBox["18", "19"], ",", 
   FractionBox["93", "94"], ",", 
   FractionBox["468", "469"], ",", 
   FractionBox["2343", "2344"], ",", 
   FractionBox["11718", "11719"], ",", 
   FractionBox["58593", "58594"], ",", 
   FractionBox["292968", "292969"], ",", 
   FractionBox["1464843", "1464844"], ",", 
   FractionBox["7324218", "7324219"]}], "}"}]], "Output",
 ImageSize->{487, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->215343127]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Apply", "[", 
   RowBox[{"Composition", ",", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", "#"}], "+", "3"}], 
        RowBox[{
         RowBox[{"1", " ", "#"}], "+", "4"}]], "&"}], ",", 
      RowBox[{"{", "10", "}"}]}], "]"}]}], "]"}], "[", "0", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->9329432],

Cell[BoxData[
 FractionBox["7324218", "7324219"]], "Output",
 ImageSize->{62, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->634886109]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2745],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ZTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DSolve"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17033]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3732],

Cell[TextData[ButtonBox["Solving Recurrence Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingRecurrenceEquations"]], "Tutorials",
 CellID->32375]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->9159],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#25824"], None}]], "RelatedLinks",
 CellID->18178]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->82878726],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->36566466],

Cell[TextData[ButtonBox["Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EquationSolving"]], "MoreAbout",
 CellID->338938296],

Cell[TextData[ButtonBox["Recurrence and Sum Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], "MoreAbout",
 CellID->80053660],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->555543843]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RSolve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 36.7731432}", "context" -> "System`", 
    "keywords" -> {
     "Abramov algorithm", "arithmetic difference equations", 
      "Bronstein algorithm", "difference-algebraic equations", 
      "difference equations", "discrete equations", 
      "divide-and-conquer equations", "equations", "Fibonacci equations", 
      "finite difference equations", "geometric difference equations", 
      "Germundsson methods", "Goktas methods", "integer sequence equations", 
      "partial difference equations", "partial recurrence equations", 
      "recurrence equations", "recursion equations", "sequence equations", 
      "symmetry reduction", "van Hoeij algorithms"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RSolve[eqn, a[n], n] solves a recurrence equation for a[n]. \
RSolve[{eqn_1, eqn_2, ...}, {a_1[n], a_2[n], ...}, n] solves a system of \
recurrence equations. RSolve[eqn, a[n_1, n_2, ...], {n_1, n_2, ...}] solves a \
partial recurrence equation. ", "synonyms" -> {}, "title" -> "RSolve", "type" -> 
    "Symbol", "uri" -> "ref/RSolve"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12012, 413, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->417260006]},
 "Ex--22029503983018204282,1"->{
  Cell[12644, 439, 376, 12, 28, "Input",
   CellTags->"Ex--22029503983018204282,1",
   CellID->68317460],
  Cell[13023, 453, 526, 18, 39, "Output",
   CellTags->"Ex--22029503983018204282,1",
   CellID->533560623]},
 "Ex--22029503983018204282,2"->{
  Cell[13788, 484, 498, 16, 70, "Input",
   CellTags->"Ex--22029503983018204282,2",
   CellID->306411985],
  Cell[14289, 502, 404, 14, 39, "Output",
   CellTags->"Ex--22029503983018204282,2",
   CellID->18443579]},
 "Ex--22029503983018204282,3"->{
  Cell[14983, 533, 472, 16, 70, "Input",
   CellTags->"Ex--22029503983018204282,3",
   CellID->18971727],
  Cell[15458, 551, 473, 16, 39, "Output",
   CellTags->"Ex--22029503983018204282,3",
   CellID->433575529]},
 "Ex--22029503983018204282,4"->{
  Cell[16057, 575, 465, 16, 70, "Input",
   CellTags->"Ex--22029503983018204282,4",
   CellID->79016662],
  Cell[16525, 593, 275, 9, 36, "Output",
   CellTags->"Ex--22029503983018204282,4",
   CellID->284398386]},
 "Ex--22029503983018204282,8"->{
  Cell[17429, 633, 447, 15, 70, "Input",
   CellTags->"Ex--22029503983018204282,8",
   CellID->109983623],
  Cell[17879, 650, 393, 13, 36, "Output",
   CellTags->"Ex--22029503983018204282,8",
   CellID->472553318]},
 "Ex--22029503983018204282,9"->{
  Cell[18529, 676, 542, 18, 70, "Input",
   CellTags->"Ex--22029503983018204282,9",
   CellID->191201536],
  Cell[19074, 696, 707, 23, 61, "Output",
   CellTags->"Ex--22029503983018204282,9",
   CellID->306839004]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 205830, 7028},
 {"Ex--22029503983018204282,1", 205984, 7032},
 {"Ex--22029503983018204282,2", 206232, 7039},
 {"Ex--22029503983018204282,3", 206480, 7046},
 {"Ex--22029503983018204282,4", 206728, 7053},
 {"Ex--22029503983018204282,8", 206975, 7060},
 {"Ex--22029503983018204282,9", 207224, 7067}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2544, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3167, 86, 44, 1, 70, "ObjectName",
 CellID->17958],
Cell[3214, 89, 2703, 86, 70, "Usage",
 CellID->8578]
}, Open  ]],
Cell[CellGroupData[{
Cell[5954, 180, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6432, 197, 396, 15, 70, "Notes",
 CellID->25206],
Cell[6831, 214, 568, 22, 70, "Notes",
 CellID->16750],
Cell[7402, 238, 246, 9, 70, "Notes",
 CellID->11840],
Cell[7651, 249, 291, 9, 70, "Notes",
 CellID->15629],
Cell[7945, 260, 1031, 36, 70, "Notes",
 CellID->31118],
Cell[8979, 298, 823, 29, 70, "Notes",
 CellID->3905],
Cell[9805, 329, 458, 17, 70, "Notes",
 CellID->6838],
Cell[10266, 348, 424, 13, 70, "Notes",
 CellID->18459],
Cell[10693, 363, 331, 12, 70, "Notes",
 CellID->28751],
Cell[11027, 377, 304, 10, 70, "Notes",
 CellID->18298],
Cell[11334, 389, 255, 8, 70, "Notes",
 CellID->28630],
Cell[11592, 399, 383, 9, 70, "Notes",
 CellID->21909]
}, Closed]],
Cell[CellGroupData[{
Cell[12012, 413, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->417260006],
Cell[CellGroupData[{
Cell[12397, 427, 148, 5, 70, "ExampleSection",
 CellID->304438872],
Cell[12548, 434, 71, 1, 70, "ExampleText",
 CellID->186618846],
Cell[CellGroupData[{
Cell[12644, 439, 376, 12, 28, "Input",
 CellTags->"Ex--22029503983018204282,1",
 CellID->68317460],
Cell[13023, 453, 526, 18, 39, "Output",
 CellTags->"Ex--22029503983018204282,1",
 CellID->533560623]
}, Open  ]],
Cell[13564, 474, 125, 3, 70, "ExampleDelimiter",
 CellID->281282100],
Cell[13692, 479, 71, 1, 70, "ExampleText",
 CellID->98279580],
Cell[CellGroupData[{
Cell[13788, 484, 498, 16, 70, "Input",
 CellTags->"Ex--22029503983018204282,2",
 CellID->306411985],
Cell[14289, 502, 404, 14, 39, "Output",
 CellTags->"Ex--22029503983018204282,2",
 CellID->18443579]
}, Open  ]],
Cell[14708, 519, 125, 3, 70, "ExampleDelimiter",
 CellID->474279498],
Cell[14836, 524, 122, 5, 70, "ExampleText",
 CellID->83962274],
Cell[CellGroupData[{
Cell[14983, 533, 472, 16, 70, "Input",
 CellTags->"Ex--22029503983018204282,3",
 CellID->18971727],
Cell[15458, 551, 473, 16, 39, "Output",
 CellTags->"Ex--22029503983018204282,3",
 CellID->433575529]
}, Open  ]],
Cell[15946, 570, 86, 1, 70, "ExampleText",
 CellID->476784310],
Cell[CellGroupData[{
Cell[16057, 575, 465, 16, 70, "Input",
 CellTags->"Ex--22029503983018204282,4",
 CellID->79016662],
Cell[16525, 593, 275, 9, 36, "Output",
 CellTags->"Ex--22029503983018204282,4",
 CellID->284398386]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16849, 608, 217, 7, 70, "ExampleSection",
 CellID->25452],
Cell[CellGroupData[{
Cell[17091, 619, 248, 7, 70, "ExampleSubsection",
 CellID->111409020],
Cell[17342, 628, 62, 1, 70, "ExampleText",
 CellID->84834757],
Cell[CellGroupData[{
Cell[17429, 633, 447, 15, 70, "Input",
 CellTags->"Ex--22029503983018204282,8",
 CellID->109983623],
Cell[17879, 650, 393, 13, 36, "Output",
 CellTags->"Ex--22029503983018204282,8",
 CellID->472553318]
}, Open  ]],
Cell[18287, 666, 125, 3, 70, "ExampleDelimiter",
 CellID->128545661],
Cell[18415, 671, 89, 1, 70, "ExampleText",
 CellID->571867],
Cell[CellGroupData[{
Cell[18529, 676, 542, 18, 70, "Input",
 CellTags->"Ex--22029503983018204282,9",
 CellID->191201536],
Cell[19074, 696, 707, 23, 61, "Output",
 CellTags->"Ex--22029503983018204282,9",
 CellID->306839004]
}, Open  ]],
Cell[19796, 722, 124, 3, 70, "ExampleDelimiter",
 CellID->96936204],
Cell[19923, 727, 87, 1, 70, "ExampleText",
 CellID->35387769],
Cell[CellGroupData[{
Cell[20035, 732, 281, 10, 70, "Input",
 CellID->229562079],
Cell[20319, 744, 969, 31, 51, "Output",
 CellID->874896272]
}, Open  ]],
Cell[21303, 778, 69, 1, 70, "ExampleText",
 CellID->285306073],
Cell[CellGroupData[{
Cell[21397, 783, 576, 19, 70, "Input",
 CellID->33773584],
Cell[21976, 804, 1886, 57, 81, "Output",
 CellID->98805365]
}, Open  ]],
Cell[23877, 864, 61, 1, 70, "ExampleText",
 CellID->299862468],
Cell[CellGroupData[{
Cell[23963, 869, 372, 12, 70, "Input",
 CellID->74484381],
Cell[24338, 883, 1465, 31, 122, "Output",
 CellID->95391271]
}, Open  ]],
Cell[25818, 917, 125, 3, 70, "ExampleDelimiter",
 CellID->132668922],
Cell[25946, 922, 80, 1, 70, "ExampleText",
 CellID->258898945],
Cell[CellGroupData[{
Cell[26051, 927, 473, 16, 70, "Input",
 CellID->108563027],
Cell[26527, 945, 642, 22, 51, "Output",
 CellID->401082780]
}, Open  ]],
Cell[27184, 970, 125, 3, 70, "ExampleDelimiter",
 CellID->234440931],
Cell[27312, 975, 127, 3, 70, "ExampleText",
 CellID->399558608],
Cell[CellGroupData[{
Cell[27464, 982, 546, 18, 70, "Input",
 CellID->53802919],
Cell[28013, 1002, 1050, 35, 58, "Output",
 CellID->626955381]
}, Open  ]],
Cell[CellGroupData[{
Cell[29100, 1042, 390, 13, 70, "Input",
 CellID->59156921],
Cell[29493, 1057, 972, 33, 73, "Output",
 CellID->467953399]
}, Open  ]],
Cell[30480, 1093, 71, 1, 70, "ExampleText",
 CellID->131263866],
Cell[CellGroupData[{
Cell[30576, 1098, 824, 27, 70, "Input",
 CellID->4460471],
Cell[31403, 1127, 763, 25, 56, "Output",
 CellID->49098447]
}, Open  ]],
Cell[32181, 1155, 123, 3, 70, "ExampleDelimiter",
 CellID->4921868],
Cell[32307, 1160, 115, 3, 70, "ExampleText",
 CellID->673393368],
Cell[CellGroupData[{
Cell[32447, 1167, 623, 22, 70, "Input",
 CellID->365935554],
Cell[33073, 1191, 621, 21, 36, "Output",
 CellID->26442513]
}, Open  ]],
Cell[CellGroupData[{
Cell[33731, 1217, 570, 19, 70, "Input",
 CellID->305727159],
Cell[34304, 1238, 654, 22, 36, "Output",
 CellID->80657666]
}, Open  ]],
Cell[CellGroupData[{
Cell[34995, 1265, 657, 23, 70, "Input",
 CellID->63036633],
Cell[35655, 1290, 814, 27, 51, "Output",
 CellID->453481659]
}, Open  ]],
Cell[CellGroupData[{
Cell[36506, 1322, 558, 18, 70, "Input",
 CellID->264247097],
Cell[37067, 1342, 967, 34, 36, "Output",
 CellID->366770820]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38083, 1382, 251, 7, 70, "ExampleSubsection",
 CellID->852448192],
Cell[38337, 1391, 71, 1, 70, "ExampleText",
 CellID->661033615],
Cell[CellGroupData[{
Cell[38433, 1396, 392, 13, 70, "Input",
 CellID->15985498],
Cell[38828, 1411, 498, 17, 51, "Output",
 CellID->102628498]
}, Open  ]],
Cell[CellGroupData[{
Cell[39363, 1433, 414, 14, 70, "Input",
 CellID->322710185],
Cell[39780, 1449, 435, 15, 51, "Output",
 CellID->221253227]
}, Open  ]],
Cell[CellGroupData[{
Cell[40252, 1469, 393, 13, 70, "Input",
 CellID->223835609],
Cell[40648, 1484, 490, 17, 51, "Output",
 CellID->230235801]
}, Open  ]],
Cell[41153, 1504, 124, 3, 70, "ExampleDelimiter",
 CellID->15645020],
Cell[41280, 1509, 62, 1, 70, "ExampleText",
 CellID->284707688],
Cell[CellGroupData[{
Cell[41367, 1514, 472, 16, 70, "Input",
 CellID->67729940],
Cell[41842, 1532, 1064, 36, 68, "Output",
 CellID->691719003]
}, Open  ]],
Cell[CellGroupData[{
Cell[42943, 1573, 386, 13, 70, "Input",
 CellID->113079553],
Cell[43332, 1588, 1665, 51, 92, "Output",
 CellID->62867779]
}, Open  ]],
Cell[45012, 1642, 124, 3, 70, "ExampleDelimiter",
 CellID->56549341],
Cell[45139, 1647, 110, 3, 70, "ExampleText",
 CellID->8860629],
Cell[CellGroupData[{
Cell[45274, 1654, 602, 20, 70, "Input",
 CellID->313847424],
Cell[45879, 1676, 441, 15, 36, "Output",
 CellID->232795130]
}, Open  ]],
Cell[CellGroupData[{
Cell[46357, 1696, 1021, 32, 70, "Input",
 CellID->227334952],
Cell[47381, 1730, 441, 15, 36, "Output",
 CellID->176964998]
}, Open  ]],
Cell[CellGroupData[{
Cell[47859, 1750, 762, 25, 70, "Input",
 CellID->1748316],
Cell[48624, 1777, 440, 15, 36, "Output",
 CellID->36315714]
}, Open  ]],
Cell[49079, 1795, 124, 3, 70, "ExampleDelimiter",
 CellID->28017190],
Cell[49206, 1800, 65, 1, 70, "ExampleText",
 CellID->15242058],
Cell[CellGroupData[{
Cell[49296, 1805, 407, 13, 70, "Input",
 CellID->103458102],
Cell[49706, 1820, 562, 19, 43, "Output",
 CellID->369859954]
}, Open  ]],
Cell[CellGroupData[{
Cell[50305, 1844, 446, 14, 70, "Input",
 CellID->2493408],
Cell[50754, 1860, 1062, 34, 48, "Output",
 CellID->149078423]
}, Open  ]],
Cell[51831, 1897, 125, 3, 70, "ExampleDelimiter",
 CellID->491835137],
Cell[51959, 1902, 73, 1, 70, "ExampleText",
 CellID->92646668],
Cell[CellGroupData[{
Cell[52057, 1907, 631, 20, 70, "Input",
 CellID->181061249],
Cell[52691, 1929, 406, 14, 51, "Output",
 CellID->552797202]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53146, 1949, 252, 7, 70, "ExampleSubsection",
 CellID->171831079],
Cell[53401, 1958, 84, 1, 70, "ExampleText",
 CellID->732989362],
Cell[CellGroupData[{
Cell[53510, 1963, 643, 22, 70, "Input",
 CellID->18586062],
Cell[54156, 1987, 1867, 35, 70, "Output",
 Evaluatable->False,
 CellID->355257818]
}, Open  ]],
Cell[56038, 2025, 68, 1, 70, "ExampleText",
 CellID->100028497],
Cell[CellGroupData[{
Cell[56131, 2030, 728, 23, 70, "Input",
 CellID->287853158],
Cell[56862, 2055, 1519, 51, 80, "Output",
 CellID->4176427]
}, Open  ]],
Cell[58396, 2109, 61, 1, 70, "ExampleText",
 CellID->7546931],
Cell[CellGroupData[{
Cell[58482, 2114, 525, 16, 70, "Input",
 CellID->62603598],
Cell[59010, 2132, 1828, 39, 133, "Output",
 CellID->327745457]
}, Open  ]],
Cell[60853, 2174, 125, 3, 70, "ExampleDelimiter",
 CellID->145073694],
Cell[60981, 2179, 70, 1, 70, "ExampleText",
 CellID->157686389],
Cell[CellGroupData[{
Cell[61076, 2184, 838, 27, 70, "Input",
 CellID->392299281],
Cell[61917, 2213, 1047, 33, 54, "Output",
 CellID->227533877]
}, Open  ]],
Cell[CellGroupData[{
Cell[63001, 2251, 1435, 44, 70, "Input",
 CellID->300796514],
Cell[64439, 2297, 2742, 49, 70, "Output",
 Evaluatable->False,
 CellID->771248691]
}, Open  ]],
Cell[67196, 2349, 125, 3, 70, "ExampleDelimiter",
 CellID->172707687],
Cell[67324, 2354, 59, 1, 70, "ExampleText",
 CellID->10404424],
Cell[CellGroupData[{
Cell[67408, 2359, 745, 25, 70, "Input",
 CellID->239503210],
Cell[68156, 2386, 902, 31, 48, "Output",
 CellID->83856992]
}, Open  ]],
Cell[69073, 2420, 124, 3, 70, "ExampleDelimiter",
 CellID->20002354],
Cell[69200, 2425, 112, 3, 70, "ExampleText",
 CellID->34367554],
Cell[CellGroupData[{
Cell[69337, 2432, 1947, 63, 70, "Input",
 CellID->25205159],
Cell[71287, 2497, 1126, 37, 58, "Output",
 CellID->57524243]
}, Open  ]],
Cell[72428, 2537, 125, 3, 70, "ExampleDelimiter",
 CellID->477117037],
Cell[72556, 2542, 99, 1, 70, "ExampleText",
 CellID->193663299],
Cell[CellGroupData[{
Cell[72680, 2547, 765, 26, 70, "Input",
 CellID->118602188],
Cell[73448, 2575, 1184, 41, 51, "Output",
 CellID->250058074]
}, Open  ]],
Cell[74647, 2619, 61, 1, 70, "ExampleText",
 CellID->281573425],
Cell[CellGroupData[{
Cell[74733, 2624, 835, 27, 70, "Input",
 CellID->356830790],
Cell[75571, 2653, 1921, 64, 81, "Output",
 CellID->118185362]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[77541, 2723, 249, 7, 70, "ExampleSubsection",
 CellID->414868684],
Cell[77793, 2732, 123, 3, 70, "ExampleText",
 CellID->5093003],
Cell[CellGroupData[{
Cell[77941, 2739, 516, 18, 70, "Input",
 CellID->391856253],
Cell[78460, 2759, 511, 18, 52, "Output",
 CellID->50826275]
}, Open  ]],
Cell[78986, 2780, 432, 17, 70, "ExampleText",
 CellID->277664129],
Cell[CellGroupData[{
Cell[79443, 2801, 344, 12, 70, "Input",
 CellID->96371284],
Cell[79790, 2815, 412, 15, 52, "Output",
 CellID->741271988]
}, Open  ]],
Cell[80217, 2833, 69, 1, 70, "ExampleText",
 CellID->1003096],
Cell[CellGroupData[{
Cell[80311, 2838, 305, 9, 70, "Input",
 CellID->219272216],
Cell[80619, 2849, 22543, 374, 70, "Output",
 Evaluatable->False,
 CellID->519562542]
}, Open  ]],
Cell[103177, 3226, 125, 3, 70, "ExampleDelimiter",
 CellID->516873058],
Cell[103305, 3231, 103, 2, 70, "ExampleText",
 CellID->177394188],
Cell[CellGroupData[{
Cell[103433, 3237, 462, 16, 70, "Input",
 CellID->56911405],
Cell[103898, 3255, 719, 25, 36, "Output",
 CellID->600012371]
}, Open  ]],
Cell[CellGroupData[{
Cell[104654, 3285, 774, 26, 70, "Input",
 CellID->375482845],
Cell[105431, 3313, 681, 23, 39, "Output",
 CellID->115644198]
}, Open  ]],
Cell[CellGroupData[{
Cell[106149, 3341, 872, 30, 70, "Input",
 CellID->630893984],
Cell[107024, 3373, 939, 31, 39, "Output",
 CellID->142832827]
}, Open  ]],
Cell[107978, 3407, 57, 1, 70, "ExampleText",
 CellID->608036519],
Cell[CellGroupData[{
Cell[108060, 3412, 573, 20, 70, "Input",
 CellID->832122888],
Cell[108636, 3434, 2611, 82, 103, "Output",
 CellID->264051588]
}, Open  ]],
Cell[111262, 3519, 125, 3, 70, "ExampleDelimiter",
 CellID->141210847],
Cell[111390, 3524, 80, 1, 70, "ExampleText",
 CellID->313651697],
Cell[CellGroupData[{
Cell[111495, 3529, 500, 17, 70, "Input",
 CellID->20755232],
Cell[111998, 3548, 489, 17, 36, "Output",
 CellID->52554747]
}, Open  ]],
Cell[CellGroupData[{
Cell[112524, 3570, 439, 15, 70, "Input",
 CellID->50742991],
Cell[112966, 3587, 661, 23, 54, "Output",
 CellID->101146641]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[113676, 3616, 249, 7, 70, "ExampleSubsection",
 CellID->101269338],
Cell[113928, 3625, 174, 6, 70, "ExampleText",
 CellID->292776386],
Cell[CellGroupData[{
Cell[114127, 3635, 301, 10, 70, "Input",
 CellID->22368006],
Cell[114431, 3647, 494, 17, 51, "Output",
 CellID->78836773]
}, Open  ]],
Cell[114940, 3667, 89, 1, 70, "ExampleText",
 CellID->26985616],
Cell[CellGroupData[{
Cell[115054, 3672, 303, 10, 70, "Input",
 CellID->156919886],
Cell[115360, 3684, 495, 17, 51, "Output",
 CellID->147742234]
}, Open  ]],
Cell[115870, 3704, 56, 1, 70, "ExampleText",
 CellID->22466475],
Cell[CellGroupData[{
Cell[115951, 3709, 426, 14, 70, "Input",
 CellID->81220557],
Cell[116380, 3725, 382, 13, 51, "Output",
 CellID->595013650]
}, Open  ]],
Cell[116777, 3741, 125, 3, 70, "ExampleDelimiter",
 CellID->482497475],
Cell[116905, 3746, 66, 1, 70, "ExampleText",
 CellID->157557312],
Cell[CellGroupData[{
Cell[116996, 3751, 336, 11, 70, "Input",
 CellID->223059353],
Cell[117335, 3764, 800, 27, 53, "Output",
 CellID->931807230]
}, Open  ]],
Cell[118150, 3794, 56, 1, 70, "ExampleText",
 CellID->357341115],
Cell[CellGroupData[{
Cell[118231, 3799, 287, 10, 70, "Input",
 CellID->299572584],
Cell[118521, 3811, 957, 30, 53, "Output",
 CellID->512750763]
}, Open  ]],
Cell[119493, 3844, 57, 1, 70, "ExampleText",
 CellID->110720299],
Cell[CellGroupData[{
Cell[119575, 3849, 336, 11, 70, "Input",
 CellID->64859419],
Cell[119914, 3862, 890, 30, 54, "Output",
 CellID->693771009]
}, Open  ]],
Cell[120819, 3895, 124, 3, 70, "ExampleDelimiter",
 CellID->39776542],
Cell[120946, 3900, 147, 6, 70, "ExampleText",
 CellID->117826049],
Cell[CellGroupData[{
Cell[121118, 3910, 441, 15, 70, "Input",
 CellID->11832526],
Cell[121562, 3927, 541, 18, 51, "Output",
 CellID->282934539]
}, Open  ]],
Cell[122118, 3948, 56, 1, 70, "ExampleText",
 CellID->57554124],
Cell[CellGroupData[{
Cell[122199, 3953, 382, 12, 70, "Input",
 CellID->92424206],
Cell[122584, 3967, 1351, 26, 70, "Output",
 Evaluatable->False,
 CellID->229604481]
}, Open  ]],
Cell[123950, 3996, 124, 3, 70, "ExampleDelimiter",
 CellID->50830592],
Cell[124077, 4001, 80, 1, 70, "ExampleText",
 CellID->273583888],
Cell[CellGroupData[{
Cell[124182, 4006, 278, 9, 70, "Input",
 CellID->259433476],
Cell[124463, 4017, 665, 22, 52, "Output",
 CellID->169426]
}, Open  ]],
Cell[CellGroupData[{
Cell[125165, 4044, 303, 10, 70, "Input",
 CellID->3290360],
Cell[125471, 4056, 1260, 40, 52, "Output",
 CellID->47893393]
}, Open  ]],
Cell[126746, 4099, 124, 3, 70, "ExampleDelimiter",
 CellID->63025014],
Cell[126873, 4104, 64, 1, 70, "ExampleText",
 CellID->799482137],
Cell[CellGroupData[{
Cell[126962, 4109, 285, 10, 70, "Input",
 CellID->46239688],
Cell[127250, 4121, 562, 18, 56, "Output",
 CellID->114239650]
}, Open  ]],
Cell[127827, 4142, 60, 1, 70, "ExampleText",
 CellID->524457134],
Cell[CellGroupData[{
Cell[127912, 4147, 473, 16, 70, "Input",
 CellID->375927220],
Cell[128388, 4165, 1691, 54, 86, "Output",
 CellID->360759450]
}, Open  ]],
Cell[130094, 4222, 125, 3, 70, "ExampleDelimiter",
 CellID->209712543],
Cell[130222, 4227, 182, 6, 70, "ExampleText",
 CellID->139298089],
Cell[CellGroupData[{
Cell[130429, 4237, 691, 23, 70, "Input",
 CellID->2103573],
Cell[131123, 4262, 2706, 86, 100, "Output",
 CellID->891983908]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[133890, 4355, 239, 7, 70, "ExampleSection",
 CellID->23135],
Cell[134132, 4364, 95, 1, 70, "ExampleText",
 CellID->4991966],
Cell[CellGroupData[{
Cell[134252, 4369, 310, 11, 70, "Input",
 CellID->721588173],
Cell[134565, 4382, 591, 20, 36, "Output",
 CellID->492664246]
}, Open  ]],
Cell[135171, 4405, 66, 1, 70, "ExampleText",
 CellID->490851081],
Cell[CellGroupData[{
Cell[135262, 4410, 411, 14, 70, "Input",
 CellID->531383639],
Cell[135676, 4426, 630, 21, 36, "Output",
 CellID->387502848]
}, Open  ]],
Cell[136321, 4450, 66, 1, 70, "ExampleText",
 CellID->17015412],
Cell[CellGroupData[{
Cell[136412, 4455, 486, 16, 70, "Input",
 CellID->223255139],
Cell[136901, 4473, 634, 23, 39, "Output",
 CellID->364807344]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[137584, 4502, 218, 7, 70, "ExampleSection",
 CellID->11842],
Cell[CellGroupData[{
Cell[137827, 4513, 236, 7, 70, "ExampleSubsection",
 CellID->16787],
Cell[138066, 4522, 75, 1, 70, "ExampleText",
 CellID->518909729],
Cell[CellGroupData[{
Cell[138166, 4527, 370, 11, 70, "Input",
 CellID->167693793],
Cell[138539, 4540, 606, 21, 39, "Output",
 CellID->28850127]
}, Open  ]],
Cell[139160, 4564, 69, 1, 70, "ExampleText",
 CellID->668299265],
Cell[CellGroupData[{
Cell[139254, 4569, 484, 15, 70, "Input",
 CellID->355074764],
Cell[139741, 4586, 594, 21, 39, "Output",
 CellID->91262983]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[140396, 4614, 224, 7, 70, "ExampleSection",
 CellID->28451],
Cell[140623, 4623, 437, 17, 70, "ExampleText",
 CellID->51205494],
Cell[CellGroupData[{
Cell[141085, 4644, 503, 17, 70, "Input",
 CellID->519613323],
Cell[141591, 4663, 370, 13, 36, "Output",
 CellID->227904045]
}, Open  ]],
Cell[141976, 4679, 242, 8, 70, "ExampleText",
 CellID->203841013],
Cell[CellGroupData[{
Cell[142243, 4691, 483, 16, 70, "Input",
 CellID->391484702],
Cell[142729, 4709, 370, 13, 36, "Output",
 CellID->44526006]
}, Open  ]],
Cell[143114, 4725, 125, 3, 70, "ExampleDelimiter",
 CellID->208352047],
Cell[143242, 4730, 296, 10, 70, "ExampleText",
 CellID->244787903],
Cell[CellGroupData[{
Cell[143563, 4744, 455, 15, 70, "Input",
 CellID->195640573],
Cell[144021, 4761, 337, 12, 36, "Output",
 CellID->391382328]
}, Open  ]],
Cell[144373, 4776, 125, 3, 70, "ExampleDelimiter",
 CellID->201197455],
Cell[144501, 4781, 406, 15, 70, "ExampleText",
 CellID->43284259],
Cell[CellGroupData[{
Cell[144932, 4800, 731, 23, 70, "Input",
 CellID->132066701],
Cell[145666, 4825, 1910, 61, 89, "Output",
 CellID->288005792]
}, Open  ]],
Cell[CellGroupData[{
Cell[147613, 4891, 363, 12, 70, "Input",
 CellID->156773875],
Cell[147979, 4905, 317, 9, 36, "Output",
 CellID->378944053]
}, Open  ]],
Cell[148311, 4917, 125, 3, 70, "ExampleDelimiter",
 CellID->167207028],
Cell[148439, 4922, 98, 1, 70, "ExampleText",
 CellID->575766635],
Cell[CellGroupData[{
Cell[148562, 4927, 385, 13, 70, "Input",
 CellID->288554387],
Cell[148950, 4942, 484, 16, 53, "Output",
 CellID->258378728]
}, Open  ]],
Cell[149449, 4961, 112, 3, 70, "ExampleText",
 CellID->25467917],
Cell[CellGroupData[{
Cell[149586, 4968, 386, 14, 70, "Input",
 CellID->122150084],
Cell[149975, 4984, 593, 20, 53, "Output",
 CellID->76160678]
}, Open  ]],
Cell[150583, 5007, 125, 3, 70, "ExampleDelimiter",
 CellID->416316283],
Cell[150711, 5012, 517, 18, 70, "ExampleText",
 CellID->69335938],
Cell[CellGroupData[{
Cell[151253, 5034, 671, 22, 70, "Input",
 CellID->107004108],
Cell[151927, 5058, 686, 25, 51, "Output",
 CellID->17421266]
}, Open  ]],
Cell[152628, 5086, 1036, 34, 70, "ExampleText",
 CellID->589668447],
Cell[CellGroupData[{
Cell[153689, 5124, 651, 20, 70, "Input",
 CellID->66857653],
Cell[154343, 5146, 1208, 41, 80, "Output",
 CellID->314112637]
}, Open  ]],
Cell[155566, 5190, 125, 3, 70, "ExampleDelimiter",
 CellID->766931940],
Cell[155694, 5195, 410, 15, 70, "ExampleText",
 CellID->167512801],
Cell[CellGroupData[{
Cell[156129, 5214, 530, 17, 70, "Input",
 CellID->626323128],
Cell[156662, 5233, 466, 17, 59, "Output",
 CellID->11925184]
}, Open  ]],
Cell[CellGroupData[{
Cell[157165, 5255, 311, 10, 70, "Input",
 CellID->78641019],
Cell[157479, 5267, 385, 11, 51, "Output",
 CellID->309990843]
}, Open  ]],
Cell[CellGroupData[{
Cell[157901, 5283, 430, 14, 70, "Input",
 CellID->87857765],
Cell[158334, 5299, 330, 11, 45, "Output",
 CellID->312313343]
}, Open  ]],
Cell[CellGroupData[{
Cell[158701, 5315, 272, 9, 70, "Input",
 CellID->7624890],
Cell[158976, 5326, 796, 27, 54, "Output",
 CellID->99482009]
}, Open  ]],
Cell[CellGroupData[{
Cell[159809, 5358, 251, 8, 70, "Input",
 CellID->536596124],
Cell[160063, 5368, 316, 11, 58, "Output",
 CellID->934005447]
}, Open  ]],
Cell[CellGroupData[{
Cell[160416, 5384, 183, 6, 70, "Input",
 CellID->59294354],
Cell[160602, 5392, 384, 11, 51, "Output",
 CellID->19945584]
}, Open  ]],
Cell[161001, 5406, 125, 3, 70, "ExampleDelimiter",
 CellID->607440793],
Cell[161129, 5411, 338, 12, 70, "ExampleText",
 CellID->69633857],
Cell[CellGroupData[{
Cell[161492, 5427, 720, 23, 70, "Input",
 CellID->441055550],
Cell[162215, 5452, 1924, 63, 95, "Output",
 CellID->54837633]
}, Open  ]],
Cell[CellGroupData[{
Cell[164176, 5520, 352, 12, 70, "Input",
 CellID->308199093],
Cell[164531, 5534, 834, 27, 39, "Output",
 CellID->4338689]
}, Open  ]],
Cell[CellGroupData[{
Cell[165402, 5566, 820, 26, 70, "Input",
 CellID->127229090],
Cell[166225, 5594, 836, 27, 39, "Output",
 CellID->171295901]
}, Open  ]],
Cell[167076, 5624, 124, 3, 70, "ExampleDelimiter",
 CellID->36099954],
Cell[167203, 5629, 293, 11, 70, "ExampleText",
 CellID->673968343],
Cell[CellGroupData[{
Cell[167521, 5644, 586, 19, 70, "Input",
 CellID->224029958],
Cell[168110, 5665, 500, 18, 63, "Output",
 CellID->194858570]
}, Open  ]],
Cell[CellGroupData[{
Cell[168647, 5688, 273, 9, 70, "Input",
 CellID->529400338],
Cell[168923, 5699, 757, 25, 54, "Output",
 CellID->132849368]
}, Open  ]],
Cell[169695, 5727, 161, 6, 70, "ExampleText",
 CellID->25967949],
Cell[CellGroupData[{
Cell[169881, 5737, 595, 19, 70, "Input",
 CellID->193076894],
Cell[170479, 5758, 391, 14, 61, "Output",
 CellID->674968630]
}, Open  ]],
Cell[CellGroupData[{
Cell[170907, 5777, 273, 9, 70, "Input",
 CellID->120733083],
Cell[171183, 5788, 781, 26, 54, "Output",
 CellID->326081229]
}, Open  ]],
Cell[171979, 5817, 125, 3, 70, "ExampleDelimiter",
 CellID->327667031],
Cell[172107, 5822, 304, 12, 70, "ExampleText",
 CellID->606545337],
Cell[CellGroupData[{
Cell[172436, 5838, 568, 19, 70, "Input",
 CellID->180882920],
Cell[173007, 5859, 453, 8, 70, "Message",
 CellID->771870093],
Cell[173463, 5869, 591, 21, 55, "Output",
 CellID->369786933]
}, Open  ]],
Cell[CellGroupData[{
Cell[174091, 5895, 332, 12, 70, "Input",
 CellID->267811800],
Cell[174426, 5909, 359, 10, 36, "Output",
 CellID->293953519]
}, Open  ]],
Cell[174800, 5922, 124, 3, 70, "ExampleDelimiter",
 CellID->74751799],
Cell[174927, 5927, 365, 14, 70, "ExampleText",
 CellID->21485607],
Cell[CellGroupData[{
Cell[175317, 5945, 650, 21, 70, "Input",
 CellID->22861247],
Cell[175970, 5968, 612, 21, 51, "Output",
 CellID->116987281]
}, Open  ]],
Cell[CellGroupData[{
Cell[176619, 5994, 310, 10, 70, "Input",
 CellID->41427780],
Cell[176932, 6006, 2140, 39, 70, "Output",
 Evaluatable->False,
 CellID->306430798]
}, Open  ]],
Cell[CellGroupData[{
Cell[179109, 6050, 503, 17, 70, "Input",
 CellID->20821193],
Cell[179615, 6069, 742, 25, 51, "Output",
 CellID->147106491]
}, Open  ]],
Cell[CellGroupData[{
Cell[180394, 6099, 321, 10, 70, "Input",
 CellID->450545160],
Cell[180718, 6111, 2165, 40, 70, "Output",
 Evaluatable->False,
 CellID->217698788]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[182932, 6157, 233, 7, 70, "ExampleSection",
 CellID->12959],
Cell[183168, 6166, 103, 2, 70, "ExampleText",
 CellID->588875236],
Cell[CellGroupData[{
Cell[183296, 6172, 458, 15, 70, "Input",
 CellID->611802103],
Cell[183757, 6189, 525, 19, 51, "Output",
 CellID->93765999]
}, Open  ]],
Cell[CellGroupData[{
Cell[184319, 6213, 446, 15, 70, "Input",
 CellID->410541803],
Cell[184768, 6230, 246, 8, 36, "Output",
 CellID->66069316]
}, Open  ]],
Cell[185029, 6241, 125, 3, 70, "ExampleDelimiter",
 CellID->820648221],
Cell[185157, 6246, 211, 8, 70, "ExampleText",
 CellID->125761213],
Cell[CellGroupData[{
Cell[185393, 6258, 481, 16, 70, "Input",
 CellID->140992805],
Cell[185877, 6276, 426, 15, 54, "Output",
 CellID->35646086]
}, Open  ]],
Cell[CellGroupData[{
Cell[186340, 6296, 264, 9, 70, "Input",
 CellID->35317527],
Cell[186607, 6307, 302, 11, 54, "Output",
 CellID->55217611]
}, Open  ]],
Cell[186924, 6321, 125, 3, 70, "ExampleDelimiter",
 CellID->936148305],
Cell[187052, 6326, 218, 8, 70, "ExampleText",
 CellID->46519138],
Cell[CellGroupData[{
Cell[187295, 6338, 450, 15, 70, "Input",
 CellID->109666348],
Cell[187748, 6355, 298, 10, 36, "Output",
 CellID->220828683]
}, Open  ]],
Cell[CellGroupData[{
Cell[188083, 6370, 255, 9, 70, "Input",
 CellID->248118811],
Cell[188341, 6381, 189, 6, 36, "Output",
 CellID->485923524]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[188579, 6393, 226, 7, 70, "ExampleSection",
 CellID->15251],
Cell[188808, 6402, 90, 1, 70, "ExampleText",
 CellID->437948186],
Cell[CellGroupData[{
Cell[188923, 6407, 337, 11, 70, "Input",
 CellID->30913648],
Cell[189263, 6420, 561, 19, 62, "Output",
 CellID->20595223]
}, Open  ]],
Cell[CellGroupData[{
Cell[189861, 6444, 333, 11, 70, "Input",
 CellID->225082654],
Cell[190197, 6457, 566, 19, 62, "Output",
 CellID->344456232]
}, Open  ]],
Cell[190778, 6479, 124, 3, 70, "ExampleDelimiter",
 CellID->13089477],
Cell[190905, 6484, 115, 3, 70, "ExampleText",
 CellID->74365102],
Cell[CellGroupData[{
Cell[191045, 6491, 369, 13, 70, "Input",
 CellID->541418026],
Cell[191417, 6506, 352, 12, 36, "Output",
 CellID->429129033]
}, Open  ]],
Cell[191784, 6521, 160, 5, 70, "ExampleText",
 CellID->63164656],
Cell[CellGroupData[{
Cell[191969, 6530, 550, 19, 70, "Input",
 CellID->30845830],
Cell[192522, 6551, 596, 22, 36, "Output",
 CellID->508250526]
}, Open  ]],
Cell[CellGroupData[{
Cell[193155, 6578, 182, 5, 70, "Input",
 CellID->161038863],
Cell[193340, 6585, 161, 5, 36, "Output",
 CellID->140326492]
}, Open  ]],
Cell[193516, 6593, 125, 3, 70, "ExampleDelimiter",
 CellID->116268602],
Cell[193644, 6598, 96, 1, 70, "ExampleText",
 CellID->929290479],
Cell[CellGroupData[{
Cell[193765, 6603, 306, 10, 70, "Input",
 CellID->48233365],
Cell[194074, 6615, 388, 13, 43, "Output",
 CellID->3161160]
}, Open  ]],
Cell[CellGroupData[{
Cell[194499, 6633, 400, 13, 70, "Input",
 CellID->329223782],
Cell[194902, 6648, 453, 8, 70, "Message",
 CellID->139975873],
Cell[195358, 6658, 829, 28, 45, "Output",
 CellID->40890397]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[196236, 6692, 224, 7, 70, "ExampleSection",
 CellID->21220],
Cell[196463, 6701, 251, 9, 70, "ExampleText",
 CellID->56956424],
Cell[CellGroupData[{
Cell[196739, 6714, 545, 18, 70, "Input",
 CellID->118426736],
Cell[197287, 6734, 813, 29, 68, "Output",
 CellID->44000676]
}, Open  ]],
Cell[CellGroupData[{
Cell[198137, 6768, 312, 10, 70, "Input",
 CellID->102066075],
Cell[198452, 6780, 578, 17, 51, "Output",
 CellID->331978340]
}, Open  ]],
Cell[CellGroupData[{
Cell[199067, 6802, 289, 11, 70, "Input",
 CellID->126769937],
Cell[199359, 6815, 578, 17, 51, "Output",
 CellID->215343127]
}, Open  ]],
Cell[CellGroupData[{
Cell[199974, 6837, 420, 14, 70, "Input",
 CellID->9329432],
Cell[200397, 6853, 190, 6, 51, "Output",
 CellID->634886109]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[200648, 6866, 310, 9, 70, "SeeAlsoSection",
 CellID->2745],
Cell[200961, 6877, 925, 35, 70, "SeeAlso",
 CellID->17033]
}, Open  ]],
Cell[CellGroupData[{
Cell[201923, 6917, 313, 9, 70, "TutorialsSection",
 CellID->3732],
Cell[202239, 6928, 165, 3, 70, "Tutorials",
 CellID->32375]
}, Open  ]],
Cell[CellGroupData[{
Cell[202441, 6936, 320, 9, 70, "RelatedLinksSection",
 CellID->9159],
Cell[202764, 6947, 254, 5, 70, "RelatedLinks",
 CellID->18178]
}, Open  ]],
Cell[CellGroupData[{
Cell[203055, 6957, 318, 9, 70, "MoreAboutSection",
 CellID->82878726],
Cell[203376, 6968, 150, 3, 70, "MoreAbout",
 CellID->36566466],
Cell[203529, 6973, 143, 3, 70, "MoreAbout",
 CellID->338938296],
Cell[203675, 6978, 164, 3, 70, "MoreAbout",
 CellID->80053660],
Cell[203842, 6983, 179, 3, 70, "MoreAbout",
 CellID->555543843]
}, Open  ]],
Cell[204036, 6989, 27, 0, 70, "History"],
Cell[204066, 6991, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

