(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     86831,       2588]
NotebookOptionsPosition[     76471,       2228]
NotebookOutlinePosition[     78198,       2271]
CellTagsIndexPosition[     78112,       2266]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pseudorandom Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/PseudorandomNumbers"], 
          "Random Number Generation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RandomNumberGeneration"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Pseudorandom Numbers\"\>", 
       2->"\<\"Random Number Generation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RandomInteger" :> 
          Documentation`HelpLookup["paclet:ref/RandomInteger"], 
          "RandomSample" :> 
          Documentation`HelpLookup["paclet:ref/RandomSample"], "RandomReal" :> 
          Documentation`HelpLookup["paclet:ref/RandomReal"], "SeedRandom" :> 
          Documentation`HelpLookup["paclet:ref/SeedRandom"], "BlockRandom" :> 
          Documentation`HelpLookup["paclet:ref/BlockRandom"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"RandomInteger\"\>", 2->"\<\"RandomSample\"\>", 
       3->"\<\"RandomReal\"\>", 4->"\<\"SeedRandom\"\>", 
       5->"\<\"BlockRandom\"\>", 6->"\<\"Part\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Random Number Generation" :> 
          Documentation`HelpLookup["paclet:guide/RandomNumberGeneration"], 
          "Statistics" :> Documentation`HelpLookup["paclet:guide/Statistics"],
           "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60ListManipulation"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Random Number Generation\"\>", 4->"\<\"Statistics\"\>", 
       5->"\<\"New in 6.0: Core Language\"\>", 
       6->"\<\"New in 6.0: List Manipulation\"\>", 
       7->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       8->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RandomChoice", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomChoice",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomChoice"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a pseudorandom choice of one of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomChoice",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomChoice"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " pseudorandom choices. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomChoice",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomChoice"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["1", "TR"]], "\[Cross]", 
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["2", "TR"]], "\[Cross]", "\[Ellipsis]", " "}]], 
      "InlineFormula"],
     " array of pseudorandom choices. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomChoice",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomChoice"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["w", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["w", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a pseudorandom choice weighted by the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["w", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomChoice",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomChoice"], "[", 
       RowBox[{
        RowBox[{
         StyleBox["wlist", "TI"], "->", 
         StyleBox["elist", "TI"]}], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " weighted choices."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomChoice",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomChoice"], "[", 
       RowBox[{
        RowBox[{
         StyleBox["wlist", "TI"], "->", 
         StyleBox["elist", "TI"]}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives an ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], "\[Cross]", 
        SubscriptBox["n", "2"], "\[Cross]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " array of weighted choices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->535]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomChoice",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomChoice"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " chooses with equal probability between all of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17689],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " gives a different sequence of pseudorandom choices whenever you run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can start with a particular seed using ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22564],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option to ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 " can be given to specify the pseudorandom generator used. "
}], "Notes",
 CellID->19196]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->204906064],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->233551970],

Cell[TextData[{
 "Choose among ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " at random:"
}], "ExampleText",
 CellID->13198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30919],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4819]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20471],

Cell["A list of 20 random choices:", "ExampleText",
 CellID->23901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29350],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "a", ",", "c", ",", "a", ",", "b", ",", "c", ",", "c", 
   ",", "b", ",", "b", ",", "b", ",", "b", ",", "b", ",", "c", ",", "c", ",", 
   "a", ",", "c", ",", "a", ",", "c", ",", "b"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5776]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27380],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", "\[Cross]", "3"}], TraditionalForm]], "InlineMath"],
 " array of random choices:"
}], "ExampleText",
 CellID->11021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31205],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", ",", "b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "c", ",", "b"}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19242]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7268],

Cell["Choices weighted with probabilities:", "ExampleText",
 CellID->7752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0.2", ",", "0.2", ",", "0.6"}], "}"}], "->", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ",", "20"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->10704],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "b", ",", "b", ",", "c", ",", "c", ",", "c", ",", "b", ",", "c", ",", "c", 
   ",", "c", ",", "c", ",", "a", ",", "a", ",", "c", ",", "c", ",", "a", ",", 
   "c", ",", "c", ",", "c", ",", "c", ",", "c"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15818]
}, Open  ]],

Cell["Weights are automatically normalized:", "ExampleText",
 CellID->24471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "6"}], "}"}], "->", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ",", "20"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->7342],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "c", ",", "b", ",", "a", ",", "c", ",", "a", ",", "b", ",", "a", ",", "c", 
   ",", "a", ",", "c", ",", "c", ",", "c", ",", "b", ",", "c", ",", "c", ",", 
   "b", ",", "c", ",", "b", ",", "c", ",", "c"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2782]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18514],

Cell["The choices can be any expressions:", "ExampleText",
 CellID->8067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], ",", 
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"1", "/", "x"}], ",", "2"}], "}"}], ",", "10"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->21394],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   FractionBox["1", "x"], ",", 
   SuperscriptBox["x", "2"], ",", 
   FractionBox["1", "x"], ",", 
   SuperscriptBox["x", "2"], ",", 
   SuperscriptBox["\[ExponentialE]", "x"], ",", 
   SuperscriptBox["\[ExponentialE]", "x"], ",", "2", ",", 
   SuperscriptBox["\[ExponentialE]", "x"], ",", "2"}], "}"}]], "Output",
 ImageSize->{230, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->692]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "->", "1"}], ",", 
     RowBox[{"a", "->", "4"}], ",", 
     RowBox[{"b", "->", "6"}]}], "}"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27344],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "1"}], ",", 
   RowBox[{"a", "\[Rule]", "4"}], ",", 
   RowBox[{"b", "\[Rule]", "6"}], ",", 
   RowBox[{"a", "\[Rule]", "4"}], ",", 
   RowBox[{"b", "\[Rule]", "6"}], ",", 
   RowBox[{"a", "\[Rule]", "1"}], ",", 
   RowBox[{"b", "\[Rule]", "6"}], ",", 
   RowBox[{"a", "\[Rule]", "4"}], ",", 
   RowBox[{"a", "\[Rule]", "1"}], ",", 
   RowBox[{"b", "\[Rule]", "6"}]}], "}"}]], "Output",
 ImageSize->{419, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2980]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1286],

Cell["Generate a random string:", "ExampleText",
 CellID->17856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<A\>\"", ",", "\"\<C\>\"", ",", "\"\<G\>\"", ",", "\"\<T\>\""}], 
    "}"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22607],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1OwzAMTttN+6Mbu3EcF+CCeAs48RAVQtoOCDT2uPAspU6aEXlOkyzJ
2sImbUldx7H9ZYnzPRe79etbsdu8FKunbfGx3rx8rh7ft5UoSxhLvhhj11es
6pdVj3/h8119RVf0LuE3k29Ltgj8HNp+1+2Ftp+VEqWU2bfLlvRM+ksUXcqj
G1W/IGQD/lh/MqQrtYYnlo818uFJvdZ58T+ij50Vu2jEah3zAXtpPQAGwgof
tfR2gnyV8qlG3pafbWVPlx8ff3Q2Q8nbyBW93kE1J8c4SxX7+DTAZ2UebOa5
lT+msxj7q7cKQt/KocFnq0hACe9zCddX19s+O2rNUXUvjpSZMJ0HnBtHTekd
hWnDPOCzb013bMzqvIxAN7VC19VbX0RjV8gmBHHWQqPnEt8Ztb+FGq6uAp2R
B1K+Ewx+52FifmXmqVED7yZRT9XI0c7IcRhDs53JSTRob10ygiOjKzXwRN62
BzU+VAt5GSltbhi3sLSnytO6BflM0+rsyfH4Pye4EOhiFsu9hzOIa/Cu8UB9
s+dq/5ajgm/csKv1mfe6I6OC54xY33YsREitfrJBXePCusZM6vRvSmo18rOj
N3xWN9m3eF65ckYx+D5XH+LlSpwSuL7KyDEqe4Rbc4XVzO0Eqp097kum89Wn
usTPPpzaQ6ndc1QE2SHLsjA8UywKltmwOSEZqCgoWvhhWk2UHRvbdujhu7Ir
cq5cQGyuwhclV3t4vMnfMyo9Q8V5x7XbgUPxJF1ggkJwNWYObNqGR17Zuuct
xfeoTAl1H21iZlyZHmlHMjcqc9Skl2vsiqggFBuuhiU/KQLfGg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{476, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74961021]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19756],

Cell[BoxData["\<\"GAAAGTGAGGGCCCTTTGGTTGGCAGGGCTTAGGGGCCCTGATTTTGGCA\"\>"], \
"Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22212]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27941],

Cell["Generate a weighted random string:", "ExampleText",
 CellID->17840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], "->", 
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}], ",", "80"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2424],

Cell[BoxData["\<\"\
AABBAAABAAAAAABBAAABBBAAAAAAAABAAABAABAABAAAAAAAAAAAAAAABAAAAAAAABAAAAAAAAAAAA\
AA\"\>"], "Output",
 ImageSize->{564, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13463]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29634],

Cell[TextData[{
 "Generate integers according to a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "n"}], TraditionalForm]], "InlineMath"],
 " distribution:"
}], "ExampleText",
 CellID->18653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"1", "/", "n"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "->", 
    RowBox[{"Range", "[", "10", "]"}]}], ",", "30"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21805],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10", ",", "10", ",", "2", ",", "2", ",", "1", ",", "2", ",", "3", ",", "7",
    ",", "2", ",", "4", ",", "1", ",", "5", ",", "2", ",", "1", ",", "1", ",",
    "2", ",", "1", ",", "6", ",", "4", ",", "2", ",", "6", ",", "8", ",", "2",
    ",", "4", ",", "6", ",", "1", ",", "3", ",", "1", ",", "1", ",", "4"}], 
  "}"}]], "Output",
 ImageSize->{567, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->776]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24581],

Cell["Random array of color choices:", "ExampleText",
 CellID->14481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14036],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyFk9ERgzAMQ+NrR+gCXakjsAD7/5WPhjrSE1zIBRJHlmXx3vbP9hhjvH7z
ecw6nppLG3Mvnc+zJV7uze/6pzln/yBsytH3zrs1FszIU1fFn5Dl2Av/Vmt6
17uEZ7HAodeiAlq9Eqs6E0fry00e8wT1KMSRhgmX+CtW8pvu3dWPPgQvmV5Q
k3qROKk/OnfTTX0d+JgfwOOkXeJCONE33XvQM9NTuNG54apWF9yQUwk21Gm5
gV/SIvWWfIo1JC2FN/qvLvKF/3nIUBzrk9baxhdflgT2
   "], {{0, 0}, {20, 20}}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->24837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32118],

Cell["A random walk with steps of unit length:", "ExampleText",
 CellID->31049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Accumulate", "[", 
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "50"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27593],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., -1.}, {2., 0.}, {3., 1.}, {4., 0.}, {5., -1.}, {6., -2.}, {
     7., -3.}, {8., -4.}, {9., -3.}, {10., -4.}, {11., -5.}, {12., -6.}, {
     13., -5.}, {14., -6.}, {15., -7.}, {16., -6.}, {17., -7.}, {18., -6.}, {
     19., -7.}, {20., -8.}, {21., -9.}, {22., -8.}, {23., -7.}, {24., -8.}, {
     25., -9.}, {26., -8.}, {27., -9.}, {28., -8.}, {29., -7.}, {30., -6.}, {
     31., -5.}, {32., -4.}, {33., -3.}, {34., -4.}, {35., -5.}, {36., -4.}, {
     37., -3.}, {38., -2.}, {39., -1.}, {40., 0.}, {41., 1.}, {42., 0.}, {43.,
      1.}, {44., 0.}, {45., 1.}, {46., 2.}, {47., 3.}, {48., 2.}, {49., 1.}, {
     50., 2.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 50.}, {-9., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88364806]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14053],

Cell["2D random walk:", "ExampleText",
 CellID->18086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"Accumulate", "[", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3322],

Cell[BoxData[
 GraphicsBox[LineBox[CompressedData["
1:eJydmItSG0cQRVer91s4tgHzdkg+KJ+QD0h+O/ETYiSBtEJhitPl66ZnpTJV
W+zh9vT09PT2THH1599//FUWRfFPsyjS7wZPWcTczOhFjX3T2Tcz9gXa9unH
OOfffrb8pPdH3jeO088jz4angtfoFWOUTTf7Khi/cfqaZ8XzEHB67gO+533J
+4L3ZaCv4LXwAn0u4739ww5/u+KJeC7zrx3vmn+5rV+v8cLpynPe7xwveJ+j
Kefs1f892gO8QtP9W7Jm0+dw8p3q4dv2uT7+2z7Xy61wJXzj9Bv0r/j7gv+v
zH9DDLfCK2ev43P+PjP+E/wR/QP2/xLPB+L7CH9C/5yZz8f7hXgjXsIL/M3h
O/Q58S9Y79Ktf0k+PS/If47vhe9q9nu9ffm92ve8DnhNLlSvAt36SWQffY9R
v/D1avWp9fjg1qfr/ZbRo+9Lue57jfK3Tz61n1UBL8hXTo944/If5dvvhz8f
fH/fMLbC94a5lFeMfwjs9TzQ+rB4l4xN690K3wunsypxOguNF45VLzOczts0
fwtuwx3hJbyA53Cqme7T71RDvaff6ZvqB3yb0e8C7or/BbyUeLouPuM0foW/
tbDXdbzxWrjtOKenfFXkb0M+Hx1X5NvuIxX7txZu4C/SV4G98eP2Zb0q+/tO
xOZP70u5eJNm8TzsqL85678jH8a+PpVz9fgz9VlXL9H4Ov9R/Vh9VfAG+2r7
Y71UQb20sY/qR+vF6qlR/HgftvtxC07+kk3i0rHZR+zv4yU2TXwYNxybnt47
cBfuoXVFb/N0+FuXMT189pljQHyeh6x3QD6MR+hj4aSPyd8EnqJPsJ/iP+IS
f03Hqk9Fb4n9yNkbDx17e9Oj9Ztu9n6+Fnob+xbjlU334y3+KfqMPZqyRxP2
aIzPCT6n+Jw5Nj1nr/pwh94n3l7AQ+IbEK/xCB6zHt2ftug6vofvvnBO7wl3
ee/U8OAn2MczIJ4h7yPhUU2+NB+6/x3RbX9tv2c7eBL4j/ZD6y+X78i+V3yv
X+0P1i98/zBu78FRvyph628FNlt68iM9dkvPVja9hPX/E8aPnHFe9//PUL0o
4v9vmD+zz81v46PzQlnPi4j9edDkXfPZKb73d+33mt/ejnx3iK0L99D78AAe
Ou7jb4D/PvMP8N3Ht/FQuJvhNPeIsWO0CdoUngmP4DE84ZnyzAKe8X7A+yv4
F2xf4e8g4JGw2b+G3zjO6W+FR8KH6EfEcyj20z30N6zntazH+EDYr3dX/K8y
/my+t/Ahtm+xfSNs+kziP5b1jOGUj3fCkz3tUz2cFM/1cQqfoZ9ib3wu+gDu
O1b9NLBPfIG/S/xfEN858eb4Er4iH5fk54p8vReeib360/XY+k6Eo/Wl8T38
Kas+EP0Kfg//iv01/Bv6746vA/uusPrz/v343PzmrwO3mb8FN9FbjG87brK+
FuvNcQk34ILxDfyVwqqnfpr0dD5cC3u9IN4G8ZfksymcW89Vhi3+C/gcPsPf
OfMpq70ffyn+O473zW/bxePZ4lOO4qnbD5//aD+8vfpT/1H+vL5v/fh8aL46
Ge5Kvuv0XmAf5Xvf/ffrL4uX+3OK/zPmO2d+41P4hPjewcfoR/ChcDvDLeHj
PfldwE24hBvEVxJvE24JnwVs9pa/Qvgk8O/1QnSNx8dnHMV/FOhtF7/tT1S/
tv9+f/33dUG8xtH35vufsu+P/vszXfubfi+qW38s4PQ9J079NfXLjbDXtf9G
/dj3X99v7XyJ+m/UD40vipffo3Hu+66bT8+7LvFG57E/PxMPix/P0yHz6/0l
8cSx1+vuO6ne0n0l1V+6v5wImx7dX+ruM5Mivt8o633R+H+ORghK
   "]],
  ImageMargins->0.]], "Output",
 ImageSize->{229, 281},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->13287]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->334],

Cell["Random walk on a hexagonal lattice:", "ExampleText",
 CellID->703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"Accumulate", "[", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"2", "Pi", " ", 
            RowBox[{"i", "/", "6"}]}], "]"}], ",", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", "Pi", " ", 
            RowBox[{"i", "/", "6"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "6"}], "}"}]}], "]"}], ",", "1000"}], "]"}], "]"}],
    "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28908],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66077080]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28160],

Cell["Randomly generate disks or circles:", "ExampleText",
 CellID->4028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"Disk", ",", "Circle"}], "}"}], "]"}], "[", 
     RowBox[{"2", 
      RowBox[{"{", 
       RowBox[{"i", ",", "j"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28415],

Cell[BoxData[
 GraphicsBox[{{CircleBox[{2, 2}], CircleBox[{2, 4}], CircleBox[{2, 6}], 
    DiskBox[{2, 8}], DiskBox[{2, 10}]}, {DiskBox[{4, 2}], CircleBox[{4, 4}], 
    CircleBox[{4, 6}], DiskBox[{4, 8}], CircleBox[{4, 10}]}, {
    CircleBox[{6, 2}], CircleBox[{6, 4}], CircleBox[{6, 6}], 
    CircleBox[{6, 8}], DiskBox[{6, 10}]}, {CircleBox[{8, 2}], DiskBox[{8, 4}],
     DiskBox[{8, 6}], DiskBox[{8, 8}], CircleBox[{8, 10}]}, {
    CircleBox[{10, 2}], CircleBox[{10, 4}], DiskBox[{10, 6}], 
    DiskBox[{10, 8}], CircleBox[{10, 10}]}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15492]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->499413102],

Cell["A random graph with 1% of possible edges filled in:", "ExampleText",
 CellID->11773221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.99"}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246836684],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxdVHs01AkUnsYQGTOMofEaZjRjZtQSRi/t7zsJFSLRZkkSmx5kGZsa0tlC
RS2lWsWopE5LarE9lkillNYjk17Sw7Mm7YRGTWjbP8aes/ece+4f95773Xu/
ey8nYnNAFJlEIkV+1X8tTbI0r1nfCpVW8ZYW/jRESJfPlFTzwQzWk2yU6MGT
JKsaS54GWrWsSdRtBXfHWw+J36dh4VgDnVGgheabQs9VGU5IaChsc9zIQ5jq
yoy8a0K8GGnLViS1E/lLPa4veMJHGePu8Tnfs6Ba8rakZIEN+l0ur+EUjxF7
ZKPnVZtmokfqcWatqy02i7NPRiXaomUw4bSFXi/h728dLO4wQujdyuGl4Xrg
jiaZ+npycDE04sF3zabYEKBv7baHC6VAqS90e01gvnv9Y4EIpSnlmaLlenh3
tn6K+U4RDO0jvYeClcR98pVaRaMArDDqulbzyViQ1GyWHeA4ge870zBURueA
Ul/SIlFS0BOn7zBqKwCJhqiDP1YRNaziK2Mfeejcq9rS5mCM+IjxCpmCC4nC
Y0NOERnN6rIIRZYlTm36lMKeSsaF0iLd92uF6JctYy8c0oIl3cWUajtCyHWd
gj6W0TCXNntNEMkG8uI8sZCqDydaUbrUW4TPWunzJ83iYufuU27v5onwdvqk
4/ZXDRDe+0R+YD4PG1g+JpF/mUDLOdqHv8sOEG2Zx67rJ7r9e7IlF8eJ4Sb3
EKvDBnhddH45t8sK+7NWaP+UaQiVn3dFzzodtL/K8qKRTaCZv4a/JzWF61LL
BWAkVpW5lDIh7+jYnWFGQ+RK1yWbZ9Em5qWJ/9LkSP5miAfS/+TeeWl1XDEd
jyY5FMU8F8CnNDfc9RwVLZf5mVX+HKzQSR9fqG0Eepqzr9dKIbTyO1PI3hyI
8xJzemzY6FTHfz4Wa4E1rK2ZH0S2SC+gsNY7MlEfcyz4bhcP3eU1B5l9NCSp
vRXbowSQGTkP5r4xg03/w6EDt5ggHX4VG3bhJGGqWNFx44QzvjDVX8YK7eBU
ZVCYvJ8P0navMv/3X/3jGxLC/hDioWdYbXYOF1J6NNtqvSE642R/xxszEHW9
myGosYFSPZ/ymKIkOpJq4g61CxG9uOLSOruPBPs1J8uzRQujteRmqZiGksZv
E4832CM85GbtIuNuoig10KVimS0c7xzY29/2gTDMOEJ9a8jHC4dVz4Zv9BKa
+9HUp6l335rA6Y1yId4dbVTP+iACy2ORR7iXFkrP3JqtLWJi2D1/kNU0BaSn
fens7C5Ckhs0/SmfjnujLinrBzg41W3wy7I0bQSsDijPZZhix7EuLrWiawJP
k1/Dvwaf3Ou6TSG2hI5usUfN26moHJxur1fMgaFJBjEWMkAsFvVxH9dz8Wr1
K/3IdnO4tY2er9tmDhFF7BbkZ4IAtkwrOV4E3ZGl7ZxENSGbq+MmqONjh6Ku
tstVTQTa30tJKxHg1+yQZJeWj4TtA4lJibktGBEFUuUWU2TSq7RpZuaoUS3I
57UZYR/ZPW38EwPlLlcr3tgzwTKSU419rUG9bS+vTDcAL7r1KGeOAJ3JWwvf
PWfDP60oRyxnImy/LjMimwGLuXvEy2KFYK36HBrxSE1o9lfTr+H4trxquhmS
+oZjDjqriJzAbY7nKvnYe2ZA7tDDxE1GbP0urjW2z1pufWqIhWsplalNDVPQ
eyF6p7TKGEczgvuM3Mzhc8kyd0a+LlY8il4iWMXHnx8Yfvnt1jB3DsphnrXC
ypupx39roUBamkXhpPKR4Be5kunKAa83pEB7vRA/qEvJhw5aTPCh4Se4LPBL
XRwHiz4ZGzXc+USkxXllnP5ZgFx/acYzOxoeqzyvedI4KC2Z6ptUQsa3cw51
BFJF2HT7c9jgGB2zueMX7QqsUV0zMNlX579/p8kPv7KE+y/tQFmoveiIiy52
Bzx7GTbEhc9epxGKuwEcx3nFW9oEUNLPbX6gGiCWnHjdGNNqDBulJPRlQivx
D54rrHE=
    "], {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 76}], LineBox[{4, 2}], 
      LineBox[{4, 21}], LineBox[{4, 62}], LineBox[{4, 71}], LineBox[{6, 99}], 
      LineBox[{7, 45}], LineBox[{12, 68}], LineBox[{12, 83}], 
      LineBox[{13, 55}], LineBox[{13, 67}], LineBox[{14, 59}], 
      LineBox[{15, 54}], LineBox[{15, 99}], LineBox[{18, 22}], 
      LineBox[{20, 28}], LineBox[{20, 44}], LineBox[{20, 82}], 
      LineBox[{21, 93}], LineBox[{22, 81}], LineBox[{23, 52}], 
      LineBox[{23, 92}], LineBox[{24, 53}], LineBox[{25, 98}], 
      LineBox[{28, 7}], LineBox[{28, 43}], LineBox[{29, 19}], 
      LineBox[{30, 53}], LineBox[{31, 76}], LineBox[{34, 92}], 
      LineBox[{35, 50}], LineBox[{35, 53}], LineBox[{35, 60}], 
      LineBox[{39, 2}], LineBox[{39, 27}], LineBox[{40, 12}], 
      LineBox[{40, 18}], LineBox[{40, 43}], LineBox[{40, 76}], 
      LineBox[{41, 26}], LineBox[{44, 2}], LineBox[{44, 92}], 
      LineBox[{44, 98}], LineBox[{45, 34}], LineBox[{45, 89}], 
      LineBox[{46, 63}], LineBox[{49, 41}], LineBox[{51, 91}], 
      LineBox[{52, 15}], LineBox[{52, 99}], LineBox[{55, 10}], 
      LineBox[{55, 18}], LineBox[{56, 37}], LineBox[{56, 48}], 
      LineBox[{56, 55}], LineBox[{60, 11}], LineBox[{61, 24}], 
      LineBox[{61, 38}], LineBox[{63, 100}], LineBox[{66, 69}], 
      LineBox[{66, 83}], LineBox[{67, 91}], LineBox[{68, 3}], 
      LineBox[{70, 15}], LineBox[{70, 59}], LineBox[{71, 29}], 
      LineBox[{72, 70}], LineBox[{72, 71}], LineBox[{73, 43}], 
      LineBox[{74, 69}], LineBox[{74, 78}], LineBox[{76, 62}], 
      LineBox[{76, 74}], LineBox[{76, 95}], LineBox[{77, 41}], 
      LineBox[{77, 45}], LineBox[{78, 50}], LineBox[{78, 75}], 
      LineBox[{79, 23}], LineBox[{79, 99}], LineBox[{81, 63}], 
      LineBox[{83, 42}], LineBox[{84, 32}], LineBox[{84, 50}], 
      LineBox[{85, 22}], LineBox[{85, 25}], LineBox[{85, 60}], 
      LineBox[{86, 3}], LineBox[{86, 77}], LineBox[{88, 86}], 
      LineBox[{91, 62}], LineBox[{92, 14}], LineBox[{93, 8}], 
      LineBox[{93, 18}], LineBox[{93, 95}], LineBox[{94, 39}], 
      LineBox[{95, 87}], LineBox[{97, 2}], LineBox[{97, 16}], 
      LineBox[{99, 56}]}, {
      TooltipBox[PointBox[1],
       "1"], 
      TooltipBox[PointBox[2],
       "2"], 
      TooltipBox[PointBox[3],
       "3"], 
      TooltipBox[PointBox[4],
       "4"], 
      TooltipBox[PointBox[5],
       "5"], 
      TooltipBox[PointBox[6],
       "6"], 
      TooltipBox[PointBox[7],
       "7"], 
      TooltipBox[PointBox[8],
       "8"], 
      TooltipBox[PointBox[9],
       "9"], 
      TooltipBox[PointBox[10],
       "10"], 
      TooltipBox[PointBox[11],
       "11"], 
      TooltipBox[PointBox[12],
       "12"], 
      TooltipBox[PointBox[13],
       "13"], 
      TooltipBox[PointBox[14],
       "14"], 
      TooltipBox[PointBox[15],
       "15"], 
      TooltipBox[PointBox[16],
       "16"], 
      TooltipBox[PointBox[17],
       "17"], 
      TooltipBox[PointBox[18],
       "18"], 
      TooltipBox[PointBox[19],
       "19"], 
      TooltipBox[PointBox[20],
       "20"], 
      TooltipBox[PointBox[21],
       "21"], 
      TooltipBox[PointBox[22],
       "22"], 
      TooltipBox[PointBox[23],
       "23"], 
      TooltipBox[PointBox[24],
       "24"], 
      TooltipBox[PointBox[25],
       "25"], 
      TooltipBox[PointBox[26],
       "26"], 
      TooltipBox[PointBox[27],
       "27"], 
      TooltipBox[PointBox[28],
       "28"], 
      TooltipBox[PointBox[29],
       "29"], 
      TooltipBox[PointBox[30],
       "30"], 
      TooltipBox[PointBox[31],
       "31"], 
      TooltipBox[PointBox[32],
       "32"], 
      TooltipBox[PointBox[33],
       "33"], 
      TooltipBox[PointBox[34],
       "34"], 
      TooltipBox[PointBox[35],
       "35"], 
      TooltipBox[PointBox[36],
       "36"], 
      TooltipBox[PointBox[37],
       "37"], 
      TooltipBox[PointBox[38],
       "38"], 
      TooltipBox[PointBox[39],
       "39"], 
      TooltipBox[PointBox[40],
       "40"], 
      TooltipBox[PointBox[41],
       "41"], 
      TooltipBox[PointBox[42],
       "42"], 
      TooltipBox[PointBox[43],
       "43"], 
      TooltipBox[PointBox[44],
       "44"], 
      TooltipBox[PointBox[45],
       "45"], 
      TooltipBox[PointBox[46],
       "46"], 
      TooltipBox[PointBox[47],
       "47"], 
      TooltipBox[PointBox[48],
       "48"], 
      TooltipBox[PointBox[49],
       "49"], 
      TooltipBox[PointBox[50],
       "50"], 
      TooltipBox[PointBox[51],
       "51"], 
      TooltipBox[PointBox[52],
       "52"], 
      TooltipBox[PointBox[53],
       "53"], 
      TooltipBox[PointBox[54],
       "54"], 
      TooltipBox[PointBox[55],
       "55"], 
      TooltipBox[PointBox[56],
       "56"], 
      TooltipBox[PointBox[57],
       "57"], 
      TooltipBox[PointBox[58],
       "58"], 
      TooltipBox[PointBox[59],
       "59"], 
      TooltipBox[PointBox[60],
       "60"], 
      TooltipBox[PointBox[61],
       "61"], 
      TooltipBox[PointBox[62],
       "62"], 
      TooltipBox[PointBox[63],
       "63"], 
      TooltipBox[PointBox[64],
       "64"], 
      TooltipBox[PointBox[65],
       "65"], 
      TooltipBox[PointBox[66],
       "66"], 
      TooltipBox[PointBox[67],
       "67"], 
      TooltipBox[PointBox[68],
       "68"], 
      TooltipBox[PointBox[69],
       "69"], 
      TooltipBox[PointBox[70],
       "70"], 
      TooltipBox[PointBox[71],
       "71"], 
      TooltipBox[PointBox[72],
       "72"], 
      TooltipBox[PointBox[73],
       "73"], 
      TooltipBox[PointBox[74],
       "74"], 
      TooltipBox[PointBox[75],
       "75"], 
      TooltipBox[PointBox[76],
       "76"], 
      TooltipBox[PointBox[77],
       "77"], 
      TooltipBox[PointBox[78],
       "78"], 
      TooltipBox[PointBox[79],
       "79"], 
      TooltipBox[PointBox[80],
       "80"], 
      TooltipBox[PointBox[81],
       "81"], 
      TooltipBox[PointBox[82],
       "82"], 
      TooltipBox[PointBox[83],
       "83"], 
      TooltipBox[PointBox[84],
       "84"], 
      TooltipBox[PointBox[85],
       "85"], 
      TooltipBox[PointBox[86],
       "86"], 
      TooltipBox[PointBox[87],
       "87"], 
      TooltipBox[PointBox[88],
       "88"], 
      TooltipBox[PointBox[89],
       "89"], 
      TooltipBox[PointBox[90],
       "90"], 
      TooltipBox[PointBox[91],
       "91"], 
      TooltipBox[PointBox[92],
       "92"], 
      TooltipBox[PointBox[93],
       "93"], 
      TooltipBox[PointBox[94],
       "94"], 
      TooltipBox[PointBox[95],
       "95"], 
      TooltipBox[PointBox[96],
       "96"], 
      TooltipBox[PointBox[97],
       "97"], 
      TooltipBox[PointBox[98],
       "98"], 
      TooltipBox[PointBox[99],
       "99"], 
      TooltipBox[PointBox[100],
       "100"]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxdVHs01AkUnsYQGTOMofEaZjRjZtQSRi/t7zsJFSLRZkkSmx5kGZsa0tlC
RS2lWsWopE5LarE9lkillNYjk17Sw7Mm7YRGTWjbP8aes/ece+4f95773Xu/
ey8nYnNAFJlEIkV+1X8tTbI0r1nfCpVW8ZYW/jRESJfPlFTzwQzWk2yU6MGT
JKsaS54GWrWsSdRtBXfHWw+J36dh4VgDnVGgheabQs9VGU5IaChsc9zIQ5jq
yoy8a0K8GGnLViS1E/lLPa4veMJHGePu8Tnfs6Ba8rakZIEN+l0ur+EUjxF7
ZKPnVZtmokfqcWatqy02i7NPRiXaomUw4bSFXi/h728dLO4wQujdyuGl4Xrg
jiaZ+npycDE04sF3zabYEKBv7baHC6VAqS90e01gvnv9Y4EIpSnlmaLlenh3
tn6K+U4RDO0jvYeClcR98pVaRaMArDDqulbzyViQ1GyWHeA4ge870zBURueA
Ul/SIlFS0BOn7zBqKwCJhqiDP1YRNaziK2Mfeejcq9rS5mCM+IjxCpmCC4nC
Y0NOERnN6rIIRZYlTm36lMKeSsaF0iLd92uF6JctYy8c0oIl3cWUajtCyHWd
gj6W0TCXNntNEMkG8uI8sZCqDydaUbrUW4TPWunzJ83iYufuU27v5onwdvqk
4/ZXDRDe+0R+YD4PG1g+JpF/mUDLOdqHv8sOEG2Zx67rJ7r9e7IlF8eJ4Sb3
EKvDBnhddH45t8sK+7NWaP+UaQiVn3dFzzodtL/K8qKRTaCZv4a/JzWF61LL
BWAkVpW5lDIh7+jYnWFGQ+RK1yWbZ9Em5qWJ/9LkSP5miAfS/+TeeWl1XDEd
jyY5FMU8F8CnNDfc9RwVLZf5mVX+HKzQSR9fqG0Eepqzr9dKIbTyO1PI3hyI
8xJzemzY6FTHfz4Wa4E1rK2ZH0S2SC+gsNY7MlEfcyz4bhcP3eU1B5l9NCSp
vRXbowSQGTkP5r4xg03/w6EDt5ggHX4VG3bhJGGqWNFx44QzvjDVX8YK7eBU
ZVCYvJ8P0navMv/3X/3jGxLC/hDioWdYbXYOF1J6NNtqvSE642R/xxszEHW9
myGosYFSPZ/ymKIkOpJq4g61CxG9uOLSOruPBPs1J8uzRQujteRmqZiGksZv
E4832CM85GbtIuNuoig10KVimS0c7xzY29/2gTDMOEJ9a8jHC4dVz4Zv9BKa
+9HUp6l335rA6Y1yId4dbVTP+iACy2ORR7iXFkrP3JqtLWJi2D1/kNU0BaSn
fens7C5Ckhs0/SmfjnujLinrBzg41W3wy7I0bQSsDijPZZhix7EuLrWiawJP
k1/Dvwaf3Ou6TSG2hI5usUfN26moHJxur1fMgaFJBjEWMkAsFvVxH9dz8Wr1
K/3IdnO4tY2er9tmDhFF7BbkZ4IAtkwrOV4E3ZGl7ZxENSGbq+MmqONjh6Ku
tstVTQTa30tJKxHg1+yQZJeWj4TtA4lJibktGBEFUuUWU2TSq7RpZuaoUS3I
57UZYR/ZPW38EwPlLlcr3tgzwTKSU419rUG9bS+vTDcAL7r1KGeOAJ3JWwvf
PWfDP60oRyxnImy/LjMimwGLuXvEy2KFYK36HBrxSE1o9lfTr+H4trxquhmS
+oZjDjqriJzAbY7nKvnYe2ZA7tDDxE1GbP0urjW2z1pufWqIhWsplalNDVPQ
eyF6p7TKGEczgvuM3Mzhc8kyd0a+LlY8il4iWMXHnx8Yfvnt1jB3DsphnrXC
ypupx39roUBamkXhpPKR4Be5kunKAa83pEB7vRA/qEvJhw5aTPCh4Se4LPBL
XRwHiz4ZGzXc+USkxXllnP5ZgFx/acYzOxoeqzyvedI4KC2Z6ptUQsa3cw51
BFJF2HT7c9jgGB2zueMX7QqsUV0zMNlX579/p8kPv7KE+y/tQFmoveiIiy52
Bzx7GTbEhc9epxGKuwEcx3nFW9oEUNLPbX6gGiCWnHjdGNNqDBulJPRlQivx
D54rrHE=
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{418., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{422, 275},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67637025]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10238],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 " to get repeatable random values:"
}], "ExampleText",
 CellID->26529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "5"}], "]"}], ",", 
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "5"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26610],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "a", ",", "c", ",", "a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "c", ",", "a", ",", "c"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6405]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"SeedRandom", "[", "1234", "]"}], ";", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "5"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"SeedRandom", "[", "1234", "]"}], ";", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "5"}], "]"}]}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24742],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "a", ",", "b", ",", "c"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->158144376]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14249],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 " to block one use of ",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " from affecting others:"
}], "ExampleText",
 CellID->29441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BlockRandom", "[", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"Range", "[", "100", "]"}], "]"}], "]"}], ",", 
   RowBox[{"RandomChoice", "[", 
    RowBox[{"Range", "[", "100", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"76", ",", "76"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41985644]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10681],

Cell["Pick 10 random words beginning with \"a\" from the dictionary:", \
"ExampleText",
 CellID->622971423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{"DictionaryLookup", "[", 
    RowBox[{"\"\<a\>\"", "~~", "___"}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20778882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"appliqued\"\>", ",", "\<\"alluviums\"\>", 
   ",", "\<\"appeasement\"\>", ",", "\<\"apiarists\"\>", 
   ",", "\<\"averse\"\>", ",", "\<\"ayes\"\>", ",", "\<\"ambergris\"\>", 
   ",", "\<\"aperitif\"\>", ",", "\<\"atilt\"\>", ",", "\<\"aspirates\"\>"}], 
  "}"}]], "Output",
 ImageSize->{361, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->375919537]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->566140721],

Cell[TextData[{
 "Pick 10 random ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions:"
}], "ExampleText",
 CellID->11901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{"Names", "[", "\"\<*\>\"", "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7671],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"GraphicsComplex3DBox\"\>", ",", "\<\"RegionFunction\"\>", 
   ",", "\<\"Precedence\"\>", ",", "\<\"ExportPacket\"\>", 
   ",", "\<\"$ImportFormats\"\>", ",", "\<\"OutputAutoOverwrite\"\>", 
   ",", "\<\"BesselI\"\>", ",", "\<\"NotGreaterFullEqual\"\>", 
   ",", "\<\"LicenseID\"\>", ",", "\<\"Delimiters\"\>"}], "}"}]], "Output",
 ImageSize->{553, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2794]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13281],

Cell["Make a continuous string of characters:", "ExampleText",
 CellID->17338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{
    RowBox[{"CharacterRange", "[", 
     RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}], ",", "80"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9575],

Cell[BoxData["\<\"\
idjinhsqqrvgldqqupasvsfvynwskkstvmxkbwthrqdtpajtwxlbwtzynjjuofgutrzokxtrifetdn\
ln\"\>"], "Output",
 ImageSize->{564, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30826]
}, Open  ]],

Cell["Break the characters into \"words\":", "ExampleText",
 CellID->21553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}], "->", 
      RowBox[{"{", 
       RowBox[{"\"\< \>\"", ",", "#"}], "}"}]}], "]"}], "&"}], "/@", 
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"CharacterRange", "[", 
      RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}], ",", "80"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19353],

Cell[BoxData["\<\"ov vyn nsp hweqorpa pwgkpksow  u bb aabizmrmrdleg tirzpg \
uzsl lo  ural vadbcwj i\"\>"], "Output",
 ImageSize->{564, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27030]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21935],

Cell["2D random walk with eight directions:", "ExampleText",
 CellID->1825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"Accumulate", "[", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31175],

Cell[BoxData[
 GraphicsBox[LineBox[CompressedData["
1:eJyFlYlS21YUhmXLxhDS7KRAVhYTSNM+TB+hD9C+dFi8SMY2GFuWrXKn3xn+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   "]]]], "Output",
 ImageSize->{161, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5205]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5853],

Cell["3D lattice random walk:", "ExampleText",
 CellID->23449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"Accumulate", "[", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "3"}], "}"}]}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8089],

Cell[BoxData[
 Graphics3DBox[Line3DBox[CompressedData["
1:eJyVmelWG9sVhCUhiYuFGTzem/zKK+UR8gA3D5nYeMLGFoMAgYQBgZFAQvNI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   "]],
  ImageMargins->0.,
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{304, 283},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->30573,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25340],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomSample",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomSample"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SeedRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeedRandom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlockRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlockRandom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13425]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28153],

Cell[TextData[ButtonBox["Pseudorandom Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PseudorandomNumbers"]], "Tutorials",
 CellID->32657],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RandomNumberGeneration"]], "Tutorials",
 CellID->86049371]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with RandomChoice",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=RandomChoice"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38330942],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->908152150],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->128630103],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RandomNumberGeneration"]], "MoreAbout",
 CellID->135341521],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->58707646],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->153331225],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->9199709],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->184949311],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->87951793]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RandomChoice - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 46.6563414}", "context" -> "System`", 
    "keywords" -> {
     "random selection", "sampling with replacement", "select randomly"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RandomChoice[{e_1, e_2, ...}] gives a pseudorandom choice of one of the \
e_i. RandomChoice[list, n] gives a list of n pseudorandom choices. \
RandomChoice[list, {n_1, n_2, ...}] gives an n_1*n_2*... array of \
pseudorandom choices. RandomChoice[{w_1, w_2, ...} -> {e_1, e_2, ...}] gives \
a pseudorandom choice weighted by the w_i. RandomChoice[wlist -> elist, n] \
gives a list of n weighted choices. RandomChoice[wlist -> elist, {n_1, n_2, \
...}] gives an n_1*n_2*... array of weighted choices.", 
    "synonyms" -> {"random choice"}, "title" -> "RandomChoice", "type" -> 
    "Symbol", "uri" -> "ref/RandomChoice"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12327, 369, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->204906064]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 77968, 2259}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3562, 75, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4185, 102, 1577, 37, 70, "ObjectNameGrid"],
Cell[5765, 141, 4567, 147, 70, "Usage",
 CellID->535]
}, Open  ]],
Cell[CellGroupData[{
Cell[10369, 293, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10847, 310, 597, 22, 70, "Notes",
 CellID->17689],
Cell[11447, 334, 473, 15, 70, "Notes",
 CellID->22564],
Cell[11923, 351, 367, 13, 70, "Notes",
 CellID->19196]
}, Closed]],
Cell[CellGroupData[{
Cell[12327, 369, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->204906064],
Cell[CellGroupData[{
Cell[12712, 383, 148, 5, 70, "ExampleSection",
 CellID->233551970],
Cell[12863, 390, 292, 12, 70, "ExampleText",
 CellID->13198],
Cell[CellGroupData[{
Cell[13180, 406, 161, 5, 28, "Input",
 CellID->30919],
Cell[13344, 413, 153, 5, 36, "Output",
 CellID->4819]
}, Open  ]],
Cell[13512, 421, 121, 3, 70, "ExampleDelimiter",
 CellID->20471],
Cell[13636, 426, 67, 1, 70, "ExampleText",
 CellID->23901],
Cell[CellGroupData[{
Cell[13728, 431, 187, 6, 70, "Input",
 CellID->29350],
Cell[13918, 439, 390, 10, 36, "Output",
 CellID->5776]
}, Open  ]],
Cell[14323, 452, 121, 3, 70, "ExampleDelimiter",
 CellID->27380],
Cell[14447, 457, 181, 7, 70, "ExampleText",
 CellID->11021],
Cell[CellGroupData[{
Cell[14653, 468, 235, 8, 70, "Input",
 CellID->31205],
Cell[14891, 478, 456, 15, 36, "Output",
 CellID->19242]
}, Open  ]],
Cell[15362, 496, 120, 3, 70, "ExampleDelimiter",
 CellID->7268],
Cell[15485, 501, 74, 1, 70, "ExampleText",
 CellID->7752],
Cell[CellGroupData[{
Cell[15584, 506, 283, 10, 70, "Input",
 CellID->10704],
Cell[15870, 518, 391, 10, 36, "Output",
 CellID->15818]
}, Open  ]],
Cell[16276, 531, 76, 1, 70, "ExampleText",
 CellID->24471],
Cell[CellGroupData[{
Cell[16377, 536, 276, 10, 70, "Input",
 CellID->7342],
Cell[16656, 548, 390, 10, 36, "Output",
 CellID->2782]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17095, 564, 216, 7, 70, "ExampleSection",
 CellID->18514],
Cell[17314, 573, 73, 1, 70, "ExampleText",
 CellID->8067],
Cell[CellGroupData[{
Cell[17412, 578, 284, 10, 70, "Input",
 CellID->21394],
Cell[17699, 590, 514, 15, 51, "Output",
 CellID->692]
}, Open  ]],
Cell[CellGroupData[{
Cell[18250, 610, 268, 9, 70, "Input",
 CellID->27344],
Cell[18521, 621, 579, 17, 36, "Output",
 CellID->2980]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19149, 644, 222, 7, 70, "ExampleSection",
 CellID->1286],
Cell[19374, 653, 64, 1, 70, "ExampleText",
 CellID->17856],
Cell[CellGroupData[{
Cell[19463, 658, 239, 8, 70, "Input",
 CellID->22607],
Cell[19705, 668, 1056, 21, 70, "Output",
 Evaluatable->False,
 CellID->74961021]
}, Open  ]],
Cell[CellGroupData[{
Cell[20798, 694, 102, 3, 70, "Input",
 CellID->19756],
Cell[20903, 699, 214, 6, 36, "Output",
 CellID->22212]
}, Open  ]],
Cell[21132, 708, 121, 3, 70, "ExampleDelimiter",
 CellID->27941],
Cell[21256, 713, 73, 1, 70, "ExampleText",
 CellID->17840],
Cell[CellGroupData[{
Cell[21354, 718, 316, 11, 70, "Input",
 CellID->2424],
Cell[21673, 731, 246, 7, 36, "Output",
 CellID->13463]
}, Open  ]],
Cell[21934, 741, 121, 3, 70, "ExampleDelimiter",
 CellID->29634],
Cell[22058, 746, 194, 7, 70, "ExampleText",
 CellID->18653],
Cell[CellGroupData[{
Cell[22277, 757, 331, 11, 70, "Input",
 CellID->21805],
Cell[22611, 770, 498, 12, 36, "Output",
 CellID->776]
}, Open  ]],
Cell[23124, 785, 121, 3, 70, "ExampleDelimiter",
 CellID->24581],
Cell[23248, 790, 69, 1, 70, "ExampleText",
 CellID->14481],
Cell[CellGroupData[{
Cell[23342, 795, 287, 9, 70, "Input",
 CellID->14036],
Cell[23632, 806, 632, 16, 246, "Output",
 CellID->24837]
}, Open  ]],
Cell[24279, 825, 121, 3, 70, "ExampleDelimiter",
 CellID->32118],
Cell[24403, 830, 79, 1, 70, "ExampleText",
 CellID->31049],
Cell[CellGroupData[{
Cell[24507, 835, 286, 10, 70, "Input",
 CellID->27593],
Cell[24796, 847, 1046, 23, 125, "Output",
 CellID->88364806]
}, Open  ]],
Cell[25857, 873, 121, 3, 70, "ExampleDelimiter",
 CellID->14053],
Cell[25981, 878, 54, 1, 70, "ExampleText",
 CellID->18086],
Cell[CellGroupData[{
Cell[26060, 883, 375, 13, 70, "Input",
 CellID->3322],
Cell[26438, 898, 2156, 40, 302, "Output",
 CellID->13287]
}, Open  ]],
Cell[28609, 941, 119, 3, 70, "ExampleDelimiter",
 CellID->334],
Cell[28731, 946, 72, 1, 70, "ExampleText",
 CellID->703],
Cell[CellGroupData[{
Cell[28828, 951, 643, 20, 70, "Input",
 CellID->28908],
Cell[29474, 973, 7458, 126, 70, "Output",
 Evaluatable->False,
 CellID->66077080]
}, Open  ]],
Cell[36947, 1102, 121, 3, 70, "ExampleDelimiter",
 CellID->28160],
Cell[37071, 1107, 73, 1, 70, "ExampleText",
 CellID->4028],
Cell[CellGroupData[{
Cell[37169, 1112, 479, 16, 70, "Input",
 CellID->28415],
Cell[37651, 1130, 678, 13, 201, "Output",
 CellID->15492]
}, Open  ]],
Cell[38344, 1146, 125, 3, 70, "ExampleDelimiter",
 CellID->499413102],
Cell[38472, 1151, 93, 1, 70, "ExampleText",
 CellID->11773221],
Cell[CellGroupData[{
Cell[38590, 1156, 366, 12, 70, "Input",
 CellID->246836684],
Cell[38959, 1170, 11209, 317, 70, "Output",
 CellID->67637025]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[50217, 1493, 233, 7, 70, "ExampleSection",
 CellID->10238],
Cell[50453, 1502, 219, 8, 70, "ExampleText",
 CellID->26529],
Cell[CellGroupData[{
Cell[50697, 1514, 370, 13, 70, "Input",
 CellID->26610],
Cell[51070, 1529, 360, 12, 36, "Output",
 CellID->6405]
}, Open  ]],
Cell[CellGroupData[{
Cell[51467, 1546, 510, 17, 70, "Input",
 CellID->24742],
Cell[51980, 1565, 365, 12, 36, "Output",
 CellID->158144376]
}, Open  ]],
Cell[52360, 1580, 121, 3, 70, "ExampleDelimiter",
 CellID->14249],
Cell[52484, 1585, 364, 13, 70, "ExampleText",
 CellID->29441],
Cell[CellGroupData[{
Cell[52873, 1602, 304, 9, 70, "Input",
 CellID->28560],
Cell[53180, 1613, 204, 7, 36, "Output",
 CellID->41985644]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53433, 1626, 224, 7, 70, "ExampleSection",
 CellID->10681],
Cell[53660, 1635, 107, 2, 70, "ExampleText",
 CellID->622971423],
Cell[CellGroupData[{
Cell[53792, 1641, 211, 6, 70, "Input",
 CellID->20778882],
Cell[54006, 1649, 448, 11, 54, "Output",
 CellID->375919537]
}, Open  ]],
Cell[54469, 1663, 125, 3, 70, "ExampleDelimiter",
 CellID->566140721],
Cell[54597, 1668, 134, 6, 70, "ExampleText",
 CellID->11901],
Cell[CellGroupData[{
Cell[54756, 1678, 168, 5, 70, "Input",
 CellID->7671],
Cell[54927, 1685, 499, 11, 54, "Output",
 CellID->2794]
}, Open  ]],
Cell[55441, 1699, 121, 3, 70, "ExampleDelimiter",
 CellID->13281],
Cell[55565, 1704, 78, 1, 70, "ExampleText",
 CellID->17338],
Cell[CellGroupData[{
Cell[55668, 1709, 253, 8, 70, "Input",
 CellID->9575],
Cell[55924, 1719, 246, 7, 36, "Output",
 CellID->30826]
}, Open  ]],
Cell[56185, 1729, 75, 1, 70, "ExampleText",
 CellID->21553],
Cell[CellGroupData[{
Cell[56285, 1734, 487, 16, 70, "Input",
 CellID->19353],
Cell[56775, 1752, 244, 6, 36, "Output",
 CellID->27030]
}, Open  ]],
Cell[57034, 1761, 121, 3, 70, "ExampleDelimiter",
 CellID->21935],
Cell[57158, 1766, 75, 1, 70, "ExampleText",
 CellID->1825],
Cell[CellGroupData[{
Cell[57258, 1771, 386, 13, 70, "Input",
 CellID->31175],
Cell[57647, 1786, 2266, 41, 237, "Output",
 CellID->5205]
}, Open  ]],
Cell[59928, 1830, 120, 3, 70, "ExampleDelimiter",
 CellID->5853],
Cell[60051, 1835, 62, 1, 70, "ExampleText",
 CellID->23449],
Cell[CellGroupData[{
Cell[60138, 1840, 377, 13, 70, "Input",
 CellID->8089],
Cell[60518, 1855, 11053, 190, 304, 3350, 59, "CachedBoxData", "BoxData", \
"Output",
 CellID->30573]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71632, 2052, 311, 9, 70, "SeeAlsoSection",
 CellID->25340],
Cell[71946, 2063, 1455, 53, 70, "SeeAlso",
 CellID->13425]
}, Open  ]],
Cell[CellGroupData[{
Cell[73438, 2121, 314, 9, 70, "TutorialsSection",
 CellID->28153],
Cell[73755, 2132, 150, 3, 70, "Tutorials",
 CellID->32657],
Cell[73908, 2137, 160, 3, 70, "Tutorials",
 CellID->86049371]
}, Open  ]],
Cell[CellGroupData[{
Cell[74105, 2145, 305, 8, 70, "RelatedLinksSection"],
Cell[74413, 2155, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74819, 2172, 318, 9, 70, "MoreAboutSection",
 CellID->38330942],
Cell[75140, 2183, 147, 3, 70, "MoreAbout",
 CellID->908152150],
Cell[75290, 2188, 155, 3, 70, "MoreAbout",
 CellID->128630103],
Cell[75448, 2193, 158, 3, 70, "MoreAbout",
 CellID->135341521],
Cell[75609, 2198, 131, 3, 70, "MoreAbout",
 CellID->58707646],
Cell[75743, 2203, 156, 3, 70, "MoreAbout",
 CellID->153331225],
Cell[75902, 2208, 162, 3, 70, "MoreAbout",
 CellID->9199709],
Cell[76067, 2213, 179, 3, 70, "MoreAbout",
 CellID->184949311],
Cell[76249, 2218, 150, 3, 70, "MoreAbout",
 CellID->87951793]
}, Open  ]],
Cell[76414, 2224, 27, 0, 70, "History"],
Cell[76444, 2226, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

