(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35902,       1406]
NotebookOptionsPosition[     27177,       1098]
NotebookOutlinePosition[     28442,       1135]
CellTagsIndexPosition[     28356,       1130]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Types of Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/TypesOfNumbers"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Types of Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rationals" :> Documentation`HelpLookup["paclet:ref/Rationals"],
           "Integer" :> Documentation`HelpLookup["paclet:ref/Integer"], 
          "Real" :> Documentation`HelpLookup["paclet:ref/Real"], "Numerator" :> 
          Documentation`HelpLookup["paclet:ref/Numerator"], "Denominator" :> 
          Documentation`HelpLookup["paclet:ref/Denominator"], "Rationalize" :> 
          Documentation`HelpLookup["paclet:ref/Rationalize"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rationals\"\>", 
       2->"\<\"Integer\"\>", 3->"\<\"Real\"\>", 4->"\<\"Numerator\"\>", 
       5->"\<\"Denominator\"\>", 
       6->"\<\"Rationalize\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Atomic Elements of Expressions\"\>", 
       2->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Rational", "ObjectName",
 CellID->22292],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Rational",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
     "\[LineSeparator]is the head used for rational numbers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21617]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can enter a rational number in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "/", 
   StyleBox["m", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4154],

Cell[TextData[{
 "The pattern object ",
 Cell[BoxData["_Rational"], "InlineFormula"],
 " can be used to stand for a rational number. It cannot stand for a single \
integer. "
}], "Notes",
 CellID->32053],

Cell[TextData[{
 "You have to use ",
 Cell[BoxData[
  ButtonBox["Numerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Numerator"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Denominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Denominator"]], "InlineFormula"],
 " to extract parts of ",
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 " numbers. "
}], "Notes",
 CellID->24947]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->69372361],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->720074097],

Cell["Enter a rational number:", "ExampleText",
 CellID->6104900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"22", "/", "7"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31730928],

Cell[BoxData[
 FractionBox["22", "7"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137488121]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 " for rational numbers:"
}], "ExampleText",
 CellID->558673377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11365339],

Cell[BoxData["Rational"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->647186184]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31245112],

Cell["\<\
Enter a rational number with very big integers in the numerator and \
denominator:\
\>", "ExampleText",
 CellID->661630778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1237918739182739817238917127398123", "/", 
  "12809812308120812038038101"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152495777],

Cell[BoxData[
 FractionBox["1237918739182739817238917127398123", 
  "12809812308120812038038101"]], "Output",
 ImageSize->{270, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->387203988]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34633563],

Cell["\<\
Rational numbers are represented with the smallest possible denominator:\
\>", "ExampleText",
 CellID->356607733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"7", "/", "49"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->441726642],

Cell[BoxData[
 FractionBox["1", "7"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->577479913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->49214099],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of a rational number is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rational",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rational"], "[", 
   RowBox[{
    StyleBox["numerator", "TI"], ",", 
    StyleBox["denominator", "TI"]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->605700804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"22", "/", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->748299800],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Rational", "[", 
    RowBox[{"22", ",", "7"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->781908028]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->767118822],

Cell[TextData[{
 "Enter a rational using the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->285365440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rational", "[", 
  RowBox[{"22", ",", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->450162588],

Cell[BoxData[
 FractionBox["22", "7"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->550070579]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->152575739],

Cell[TextData[{
 "You have to use ",
 Cell[BoxData[
  ButtonBox["Numerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Numerator"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Denominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Denominator"]], "InlineFormula"],
 " to extract parts of ",
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 " numbers: "
}], "ExampleText",
 CellID->207295393],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"22", "/", "7"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->328203102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Numerator", "[", "r", "]"}], ",", 
   RowBox[{"Denominator", "[", "r", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->490811815],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"22", ",", "7"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21027142]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " does not work:"
}], "ExampleText",
 CellID->133707150],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->789598527],

Cell[BoxData[
 RowBox[{
  RowBox[{"Part", "::", "\<\"partd\"\>"}], ":", 
  " ", "\<\"Part specification \\!\\(\\(\\(22\\/7\\)\\) \[LeftDoubleBracket] \
1 \[RightDoubleBracket]\\) is longer than depth of object. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/partd\\\", \
ButtonNote -> \\\"Part::partd\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->244007891],

Cell[BoxData[
 RowBox[{
  FractionBox["22", "7"], "\[LeftDoubleBracket]", "1", 
  "\[RightDoubleBracket]"}]], "Output",
 ImageSize->{44, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->302034026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17229281],

Cell[TextData[{
 "The pattern object ",
 Cell[BoxData["_Rational"], "InlineFormula"],
 " can be used to stand for a rational number:"
}], "ExampleText",
 CellID->26975409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"22", "/", "7"}], ",", "_Rational"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81089039],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39975761]
}, Open  ]],

Cell["It cannot stand for a single integer:", "ExampleText",
 CellID->286693746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"6", "/", "3"}], ",", "_Rational"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18578251],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->256856328]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8481454],

Cell["A rule that replaces all rationals with their reciprocals:", \
"ExampleText",
 CellID->252235255],

Cell[BoxData[
 RowBox[{
  RowBox[{"rule", "=", 
   RowBox[{"x_Rational", "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"Denominator", "[", "x", "]"}], "/", 
     RowBox[{"Numerator", "[", "x", "]"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27597116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"22", "/", "7"}], ",", 
    RowBox[{"201", "/", "64"}], ",", 
    RowBox[{"x", "/", "y"}]}], "]"}], "/.", "rule"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->109298255],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   FractionBox["7", "22"], ",", 
   FractionBox["64", "201"], ",", 
   FractionBox["x", "y"]}], "]"}]], "Output",
 ImageSize->{102, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7540845]
}, Open  ]],

Cell["An alternate way to write the rule:", "ExampleText",
 CellID->283555052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"22", "/", "7"}], ",", 
    RowBox[{"201", "/", "64"}], ",", 
    RowBox[{"x", "/", "y"}]}], "]"}], "/.", 
  RowBox[{
   RowBox[{"Rational", "[", 
    RowBox[{"n_", ",", "d_"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"d", "/", "n"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1452633],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   FractionBox["7", "22"], ",", 
   FractionBox["64", "201"], ",", 
   FractionBox["x", "y"]}], "]"}]], "Output",
 ImageSize->{102, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11876904]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21468161],

Cell["Define a function that only applies to rational numbers:", "ExampleText",
 CellID->134102227],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "r_Rational", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "=", 
       RowBox[{"Numerator", "[", "r", "]"}]}], ",", 
      RowBox[{"y", "=", 
       RowBox[{"Denominator", "[", "r", "]"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"2", 
        RowBox[{"y", "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "x", " ", "y"}], ")"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250191947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"f", ",", 
   RowBox[{"3", "/", "2"}], ",", "6"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->62958621],

Cell[BoxData[
 FractionBox["4946041176255201878775086487573351061418968498177", 
  "3497379255757941172020851852070562919437964212608"]], "Output",
 ImageSize->{386, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->460279312]
}, Open  ]],

Cell[TextData[{
 "This is a close approximation to ",
 Cell[BoxData[
  SqrtBox["2"]], "MSG"],
 ":"
}], "ExampleText",
 CellID->191194026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"%", "-", 
      RowBox[{"Sqrt", "[", "2", "]"}]}], ",", "20"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->120245496],

Cell[BoxData["2.8904771932153645532800066410314736941`20.*^-98"], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->147939023]
}, Open  ]],

Cell["An alternative definition of the function:", "ExampleText",
 CellID->222350975],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"Rational", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"2", 
      RowBox[{"y", "^", "2"}]}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"2", "x", " ", "y"}], ")"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->167544453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"g", ",", 
   RowBox[{"3", "/", "2"}], ",", "6"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->41912458],

Cell[BoxData[
 FractionBox["4946041176255201878775086487573351061418968498177", 
  "3497379255757941172020851852070562919437964212608"]], "Output",
 ImageSize->{386, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->9813637]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->102235690],

Cell["Rationals are numbers:", "ExampleText",
 CellID->280534777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", 
  RowBox[{"22", "/", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->248073754],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248655586]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->155610628],

Cell["Rationals are atomic objects with no subexpressions:", "ExampleText",
 CellID->55292171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtomQ", "[", 
  RowBox[{"22", "/", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->356562248],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239018999]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->509501055],

Cell["Rationals are exact numbers:", "ExampleText",
 CellID->391441838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExactNumberQ", "[", 
  RowBox[{"22", "/", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->345889971],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->308253502]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->299134612],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Rationals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationals"]], "InlineFormula"],
 " to indicate assumptions and domain conditions: "
}], "ExampleText",
 CellID->244023997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "2"}], "-", 
     RowBox[{"6", "x"}], "+", 
     RowBox[{"10", 
      RowBox[{"x", "^", "2"}]}], "-", 
     RowBox[{
      RowBox[{"x", "^", "99"}], "/", "2"}], "+", 
     RowBox[{"x", "^", "100"}]}], "\[Equal]", "0"}], ",", "x", ",", 
   "Rationals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->233070826],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", 
  FractionBox["1", "2"]}]], "Output",
 ImageSize->{40, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->476542339]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13555722],

Cell[TextData[{
 "Numbers entered in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "/", 
   StyleBox["m", "TI"]}]], "InlineFormula"],
 " only become ",
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 " numbers on evaluation:"
}], "ExampleText",
 CellID->219750768],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "HoldAll"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_Rational", "]"}], ":=", 
  RowBox[{
   RowBox[{"Numerator", "[", "x", "]"}], "-", 
   RowBox[{"Denominator", "[", "x", "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->296022512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"22", "/", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17833755],

Cell[BoxData[
 RowBox[{"f", "[", 
  FractionBox["22", "7"], "]"}]], "Output",
 ImageSize->{44, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->246915424]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"22", "/", "7"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37264585],

Cell[BoxData["15"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->358538111]
}, Open  ]],

Cell[TextData[{
 "The unevaluated form is expressed in terms of ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->379399591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"HoldForm", "[", 
   RowBox[{"22", "/", "7"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->140518944],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"HoldForm", "[", 
    RowBox[{"Times", "[", 
     RowBox[{"22", ",", 
      RowBox[{"Power", "[", 
       RowBox[{"7", ",", 
        RowBox[{"-", "1"}]}], "]"}]}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{231, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm=",
 CellID->79106920]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15625],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rationals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Real",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Real"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Numerator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Numerator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Denominator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Denominator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27459]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20121],

Cell[TextData[ButtonBox["Types of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TypesOfNumbers"]], "Tutorials",
 CellID->10039]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Rational",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Rational"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->396727222],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->567944],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->98848587]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rational - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 15.6727092}", "context" -> "System`", 
    "keywords" -> {
     "numbers", "fractions", "rationals", "commensurate numbers", 
      "exact real numbers"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Rational is the head used for rational numbers. ", "synonyms" -> {}, 
    "title" -> "Rational", "type" -> "Symbol", "uri" -> "ref/Rational"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4966, 162, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->69372361]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28214, 1123}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2432, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3055, 83, 46, 1, 70, "ObjectName",
 CellID->22292],
Cell[3104, 86, 422, 13, 70, "Usage",
 CellID->21617]
}, Open  ]],
Cell[CellGroupData[{
Cell[3563, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4041, 121, 199, 8, 70, "Notes",
 CellID->4154],
Cell[4243, 131, 203, 6, 70, "Notes",
 CellID->32053],
Cell[4449, 139, 480, 18, 70, "Notes",
 CellID->24947]
}, Closed]],
Cell[CellGroupData[{
Cell[4966, 162, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->69372361],
Cell[CellGroupData[{
Cell[5350, 176, 148, 5, 70, "ExampleSection",
 CellID->720074097],
Cell[5501, 183, 65, 1, 70, "ExampleText",
 CellID->6104900],
Cell[CellGroupData[{
Cell[5591, 188, 92, 3, 28, "Input",
 CellID->31730928],
Cell[5686, 193, 179, 6, 51, "Output",
 CellID->137488121]
}, Open  ]],
Cell[5880, 202, 323, 12, 70, "ExampleText",
 CellID->558673377],
Cell[CellGroupData[{
Cell[6228, 218, 99, 3, 28, "Input",
 CellID->11365339],
Cell[6330, 223, 165, 5, 36, "Output",
 CellID->647186184]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6544, 234, 219, 7, 70, "ExampleSection",
 CellID->31245112],
Cell[6766, 243, 133, 4, 70, "ExampleText",
 CellID->661630778],
Cell[CellGroupData[{
Cell[6924, 251, 153, 4, 70, "Input",
 CellID->152495777],
Cell[7080, 257, 240, 7, 51, "Output",
 CellID->387203988]
}, Open  ]],
Cell[7335, 267, 124, 3, 70, "ExampleDelimiter",
 CellID->34633563],
Cell[7462, 272, 123, 3, 70, "ExampleText",
 CellID->356607733],
Cell[CellGroupData[{
Cell[7610, 279, 93, 3, 70, "Input",
 CellID->441726642],
Cell[7706, 284, 178, 6, 51, "Output",
 CellID->577479913]
}, Open  ]],
Cell[7899, 293, 124, 3, 70, "ExampleDelimiter",
 CellID->49214099],
Cell[8026, 298, 451, 17, 70, "ExampleText",
 CellID->605700804],
Cell[CellGroupData[{
Cell[8502, 319, 128, 4, 70, "Input",
 CellID->748299800],
Cell[8633, 325, 352, 13, 50, "Output",
 CellID->781908028]
}, Open  ]],
Cell[9000, 341, 125, 3, 70, "ExampleDelimiter",
 CellID->767118822],
Cell[9128, 346, 210, 8, 70, "ExampleText",
 CellID->285365440],
Cell[CellGroupData[{
Cell[9363, 358, 128, 4, 70, "Input",
 CellID->450162588],
Cell[9494, 364, 179, 6, 51, "Output",
 CellID->550070579]
}, Open  ]],
Cell[9688, 373, 125, 3, 70, "ExampleDelimiter",
 CellID->152575739],
Cell[9816, 378, 490, 18, 70, "ExampleText",
 CellID->207295393],
Cell[10309, 398, 135, 5, 70, "Input",
 CellID->328203102],
Cell[CellGroupData[{
Cell[10469, 407, 191, 6, 70, "Input",
 CellID->490811815],
Cell[10663, 415, 203, 7, 36, "Output",
 CellID->21027142]
}, Open  ]],
Cell[10881, 425, 184, 7, 70, "ExampleText",
 CellID->133707150],
Cell[CellGroupData[{
Cell[11090, 436, 120, 4, 70, "Input",
 CellID->789598527],
Cell[11213, 442, 446, 8, 70, "Message",
 CellID->244007891],
Cell[11662, 452, 249, 8, 51, "Output",
 CellID->302034026]
}, Open  ]],
Cell[11926, 463, 124, 3, 70, "ExampleDelimiter",
 CellID->17229281],
Cell[12053, 468, 171, 5, 70, "ExampleText",
 CellID->26975409],
Cell[CellGroupData[{
Cell[12249, 477, 157, 5, 70, "Input",
 CellID->81089039],
Cell[12409, 484, 160, 5, 36, "Output",
 CellID->39975761]
}, Open  ]],
Cell[12584, 492, 80, 1, 70, "ExampleText",
 CellID->286693746],
Cell[CellGroupData[{
Cell[12689, 497, 156, 5, 70, "Input",
 CellID->18578251],
Cell[12848, 504, 162, 5, 36, "Output",
 CellID->256856328]
}, Open  ]],
Cell[13025, 512, 123, 3, 70, "ExampleDelimiter",
 CellID->8481454],
Cell[13151, 517, 103, 2, 70, "ExampleText",
 CellID->252235255],
Cell[13257, 521, 263, 8, 70, "Input",
 CellID->27597116],
Cell[CellGroupData[{
Cell[13545, 533, 237, 8, 70, "Input",
 CellID->109298255],
Cell[13785, 543, 287, 10, 53, "Output",
 CellID->7540845]
}, Open  ]],
Cell[14087, 556, 78, 1, 70, "ExampleText",
 CellID->283555052],
Cell[CellGroupData[{
Cell[14190, 561, 355, 12, 70, "Input",
 CellID->1452633],
Cell[14548, 575, 288, 10, 53, "Output",
 CellID->11876904]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14885, 591, 226, 7, 70, "ExampleSection",
 CellID->21468161],
Cell[15114, 600, 99, 1, 70, "ExampleText",
 CellID->134102227],
Cell[15216, 603, 592, 20, 70, "Input",
 CellID->250191947],
Cell[CellGroupData[{
Cell[15833, 627, 156, 5, 70, "Input",
 CellID->62958621],
Cell[15992, 634, 278, 7, 51, "Output",
 CellID->460279312]
}, Open  ]],
Cell[16285, 644, 137, 6, 70, "ExampleText",
 CellID->191194026],
Cell[CellGroupData[{
Cell[16447, 654, 318, 11, 70, "Input",
 CellID->120245496],
Cell[16768, 667, 206, 5, 36, "Output",
 CellID->147939023]
}, Open  ]],
Cell[16989, 675, 85, 1, 70, "ExampleText",
 CellID->222350975],
Cell[17077, 678, 384, 14, 70, "Input",
 CellID->167544453],
Cell[CellGroupData[{
Cell[17486, 696, 156, 5, 70, "Input",
 CellID->41912458],
Cell[17645, 703, 276, 7, 51, "Output",
 CellID->9813637]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17970, 716, 237, 7, 70, "ExampleSection",
 CellID->102235690],
Cell[18210, 725, 65, 1, 70, "ExampleText",
 CellID->280534777],
Cell[CellGroupData[{
Cell[18300, 730, 127, 4, 70, "Input",
 CellID->248073754],
Cell[18430, 736, 161, 5, 36, "Output",
 CellID->248655586]
}, Open  ]],
Cell[18606, 744, 125, 3, 70, "ExampleDelimiter",
 CellID->155610628],
Cell[18734, 749, 94, 1, 70, "ExampleText",
 CellID->55292171],
Cell[CellGroupData[{
Cell[18853, 754, 125, 4, 70, "Input",
 CellID->356562248],
Cell[18981, 760, 161, 5, 36, "Output",
 CellID->239018999]
}, Open  ]],
Cell[19157, 768, 125, 3, 70, "ExampleDelimiter",
 CellID->509501055],
Cell[19285, 773, 71, 1, 70, "ExampleText",
 CellID->391441838],
Cell[CellGroupData[{
Cell[19381, 778, 132, 4, 70, "Input",
 CellID->345889971],
Cell[19516, 784, 161, 5, 36, "Output",
 CellID->308253502]
}, Open  ]],
Cell[19692, 792, 125, 3, 70, "ExampleDelimiter",
 CellID->299134612],
Cell[19820, 797, 236, 8, 70, "ExampleText",
 CellID->244023997],
Cell[CellGroupData[{
Cell[20081, 809, 411, 14, 70, "Input",
 CellID->233070826],
Cell[20495, 825, 208, 7, 51, "Output",
 CellID->476542339]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20752, 838, 229, 7, 70, "ExampleSection",
 CellID->13555722],
Cell[20984, 847, 352, 13, 70, "ExampleText",
 CellID->219750768],
Cell[21339, 862, 329, 10, 70, "Input",
 CellID->296022512],
Cell[CellGroupData[{
Cell[21693, 876, 120, 4, 70, "Input",
 CellID->17833755],
Cell[21816, 882, 207, 7, 51, "Output",
 CellID->246915424]
}, Open  ]],
Cell[CellGroupData[{
Cell[22060, 894, 156, 5, 70, "Input",
 CellID->37264585],
Cell[22219, 901, 159, 5, 36, "Output",
 CellID->358538111]
}, Open  ]],
Cell[22393, 909, 346, 13, 70, "ExampleText",
 CellID->379399591],
Cell[CellGroupData[{
Cell[22764, 926, 164, 5, 70, "Input",
 CellID->140518944],
Cell[22931, 933, 474, 17, 50, "Output",
 CellID->79106920]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23466, 957, 311, 9, 70, "SeeAlsoSection",
 CellID->15625],
Cell[23780, 968, 1437, 53, 70, "SeeAlso",
 CellID->27459]
}, Open  ]],
Cell[CellGroupData[{
Cell[25254, 1026, 314, 9, 70, "TutorialsSection",
 CellID->20121],
Cell[25571, 1037, 141, 3, 70, "Tutorials",
 CellID->10039]
}, Open  ]],
Cell[CellGroupData[{
Cell[25749, 1045, 305, 8, 70, "RelatedLinksSection"],
Cell[26057, 1055, 361, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26455, 1072, 319, 9, 70, "MoreAboutSection",
 CellID->396727222],
Cell[26777, 1083, 166, 3, 70, "MoreAbout",
 CellID->567944],
Cell[26946, 1088, 159, 3, 70, "MoreAbout",
 CellID->98848587]
}, Open  ]],
Cell[27120, 1094, 27, 0, 70, "History"],
Cell[27150, 1096, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

