(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23669,        897]
NotebookOptionsPosition[     18113,        704]
NotebookOutlinePosition[     19431,        742]
CellTagsIndexPosition[     19346,        737]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using Assumptions" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingAssumptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Using Assumptions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Element" :> Documentation`HelpLookup["paclet:ref/Element"], 
          "Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "Algebraics" :> Documentation`HelpLookup["paclet:ref/Algebraics"], 
          "Integers" :> Documentation`HelpLookup["paclet:ref/Integers"], 
          "Rational" :> Documentation`HelpLookup["paclet:ref/Rational"], 
          "Denominator" :> 
          Documentation`HelpLookup["paclet:ref/Denominator"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Element\"\>", 2->"\<\"Simplify\"\>",
        3->"\<\"Algebraics\"\>", 4->"\<\"Integers\"\>", 5->"\<\"Rational\"\>",
        6->"\<\"Denominator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Number Recognition" :> 
          Documentation`HelpLookup["paclet:guide/NumberRecognition"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>", 
       2->"\<\"Number Recognition\"\>", 
       3->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Rationals", "ObjectName",
 CellID->18462],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Rationals",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Rationals"]], "InlineFormula"],
     "\[LineSeparator]represents the domain of rational numbers, as in ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], 
       StyleBox["\[Element]", "TR"], "Rationals"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20446]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   StyleBox["\[Element]", "TR"], "Rationals"}]], "InlineFormula"],
 " evaluates immediately only if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is a numeric quantity. "
}], "Notes",
 CellID->19096],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], 
    StyleBox["\[Element]", "TR"], "Rationals"}], "]"}]], "InlineFormula"],
 " can be used to try to determine whether an expression corresponds to a \
rational number. "
}], "Notes",
 CellID->32619],

Cell["\<\
The domain of integers is taken to be a subset of the domain of rationals. \
\>", "Notes",
 CellID->8476],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rationals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationals"]], "InlineFormula"],
 " is output in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData["\[DoubleStruckCapitalQ]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11771]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->104471023],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->47543470],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{"2", "/", "3"}], "TR"]], "InlineFormula"],
 " is a rational number:"
}], "ExampleText",
 CellID->861785557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{"2", "/", "3"}], ",", "Rationals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31527714],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->967673187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->812887046],

Cell["A sum of rational numbers is a rational number:", "ExampleText",
 CellID->484949674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", "Rationals"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"x", "|", "y"}], ",", "Rationals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20032742],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90939768]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->390842811],

Cell["Find rational solutions of an equation:", "ExampleText",
 CellID->595802410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"x", "^", "2"}]}], "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", 
        RowBox[{"x", "^", "2"}]}], "-", "1"}], ")"}]}], "\[Equal]", "0"}], 
   ",", "x", ",", "Rationals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67769349],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    FractionBox["1", "2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   FractionBox["1", "2"]}]}]], "Output",
 ImageSize->{102, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14033982]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->247594284],

Cell["Test domain membership of a numeric expression:  ", "ExampleText",
 CellID->186508013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{"21", "/", "32"}], ",", "Rationals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150279975],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115129745]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], ",", "Rationals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->359856375],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8757365]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"Pi", ",", "Rationals"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->538627246],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->26279449]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->337584712],

Cell["Make domain membership assumptions:", "ExampleText",
 CellID->24636061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"2", "x", " ", "y"}], "+", 
      RowBox[{
       RowBox[{"y", "^", "3"}], "/", "3"}]}], ",", "Rationals"}], "]"}], ",", 
   
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"x", "|", "y"}], ",", "Rationals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144317606],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77355349]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->118919199],

Cell[TextData[{
 "Specify the default domain over which ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " should work:"
}], "ExampleText",
 CellID->24255137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "3"}], "-", 
       RowBox[{"8", "/", "27"}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "3"}], "-", "2"}], ")"}]}], "\[Equal]", "0"}], ",", 
   "x", ",", "Rationals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->421960511],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", 
  FractionBox["2", "3"]}]], "Output",
 ImageSize->{40, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->607010286]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->218426802],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " of formatting:"
}], "ExampleText",
 CellID->2113989541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationals", "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1852759619],

Cell[BoxData[
 FormBox[
  TagBox["\[DoubleStruckCapitalQ]",
   Function[{}, Rationals]], TraditionalForm]], "Output",
 ImageSize->{13, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->617959617]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->62237656],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rationals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationals"]], "InlineFormula"],
 " contains ",
 Cell[BoxData[
  ButtonBox["Integers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Primes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Primes"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->112558139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Refine", "[", 
    RowBox[{
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "Rationals"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "#"}], "]"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"Integers", ",", "Primes"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155047900],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->200139919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->671879674],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rationals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationals"]], "InlineFormula"],
 " is contained in ",
 Cell[BoxData[
  ButtonBox["Complexes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Algebraics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Algebraics"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->356793860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Refine", "[", 
    RowBox[{
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "#"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "Rationals"}], "]"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"Complexes", ",", "Reals", ",", "Algebraics"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134385914],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8192642]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17567],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Algebraics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Algebraics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rational",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rational"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Denominator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Denominator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->876]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23095],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "Tutorials",
 CellID->8938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->277293444],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->7263580],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "MoreAbout",
 CellID->810334595],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->363026929]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rationals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 16.4696046}", "context" -> "System`", 
    "keywords" -> {
     "rational variables", "rational solutions", "rational numbers", 
      "rational space", "fractions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Rationals represents the domain of rational numbers, as in x \\[Element] \
Rationals. ", "synonyms" -> {}, "title" -> "Rationals", "type" -> "Symbol", 
    "uri" -> "ref/Rationals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5488, 177, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->104471023]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19203, 730}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2510, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3133, 84, 47, 1, 70, "ObjectName",
 CellID->18462],
Cell[3183, 87, 579, 18, 70, "Usage",
 CellID->20446]
}, Open  ]],
Cell[CellGroupData[{
Cell[3799, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4277, 127, 283, 10, 70, "Notes",
 CellID->19096],
Cell[4563, 139, 375, 12, 70, "Notes",
 CellID->32619],
Cell[4941, 153, 115, 3, 70, "Notes",
 CellID->8476],
Cell[5059, 158, 392, 14, 70, "Notes",
 CellID->11771]
}, Closed]],
Cell[CellGroupData[{
Cell[5488, 177, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->104471023],
Cell[CellGroupData[{
Cell[5873, 191, 147, 5, 70, "ExampleSection",
 CellID->47543470],
Cell[6023, 198, 161, 6, 70, "ExampleText",
 CellID->861785557],
Cell[CellGroupData[{
Cell[6209, 208, 157, 5, 28, "Input",
 CellID->31527714],
Cell[6369, 215, 161, 5, 36, "Output",
 CellID->967673187]
}, Open  ]],
Cell[6545, 223, 125, 3, 70, "ExampleDelimiter",
 CellID->812887046],
Cell[6673, 228, 90, 1, 70, "ExampleText",
 CellID->484949674],
Cell[CellGroupData[{
Cell[6788, 233, 314, 10, 70, "Input",
 CellID->20032742],
Cell[7105, 245, 160, 5, 36, "Output",
 CellID->90939768]
}, Open  ]],
Cell[7280, 253, 125, 3, 70, "ExampleDelimiter",
 CellID->390842811],
Cell[7408, 258, 82, 1, 70, "ExampleText",
 CellID->595802410],
Cell[CellGroupData[{
Cell[7515, 263, 407, 15, 70, "Input",
 CellID->67769349],
Cell[7925, 280, 305, 11, 51, "Output",
 CellID->14033982]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8279, 297, 220, 7, 70, "ExampleSection",
 CellID->247594284],
Cell[8502, 306, 92, 1, 70, "ExampleText",
 CellID->186508013],
Cell[CellGroupData[{
Cell[8619, 311, 160, 5, 70, "Input",
 CellID->150279975],
Cell[8782, 318, 161, 5, 36, "Output",
 CellID->115129745]
}, Open  ]],
Cell[CellGroupData[{
Cell[8980, 328, 166, 5, 70, "Input",
 CellID->359856375],
Cell[9149, 335, 160, 5, 36, "Output",
 CellID->8757365]
}, Open  ]],
Cell[CellGroupData[{
Cell[9346, 345, 135, 4, 70, "Input",
 CellID->538627246],
Cell[9484, 351, 161, 5, 36, "Output",
 CellID->26279449]
}, Open  ]],
Cell[9660, 359, 125, 3, 70, "ExampleDelimiter",
 CellID->337584712],
Cell[9788, 364, 77, 1, 70, "ExampleText",
 CellID->24636061],
Cell[CellGroupData[{
Cell[9890, 369, 441, 15, 70, "Input",
 CellID->144317606],
Cell[10334, 386, 160, 5, 36, "Output",
 CellID->77355349]
}, Open  ]],
Cell[10509, 394, 125, 3, 70, "ExampleDelimiter",
 CellID->118919199],
Cell[10637, 399, 228, 8, 70, "ExampleText",
 CellID->24255137],
Cell[CellGroupData[{
Cell[10890, 411, 389, 14, 70, "Input",
 CellID->421960511],
Cell[11282, 427, 208, 7, 51, "Output",
 CellID->607010286]
}, Open  ]],
Cell[11505, 437, 125, 3, 70, "ExampleDelimiter",
 CellID->218426802],
Cell[11633, 442, 207, 7, 70, "ExampleText",
 CellID->2113989541],
Cell[CellGroupData[{
Cell[11865, 453, 116, 3, 70, "Input",
 CellID->1852759619],
Cell[11984, 458, 264, 8, 50, "Output",
 CellID->617959617]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12297, 472, 236, 7, 70, "ExampleSection",
 CellID->62237656],
Cell[12536, 481, 439, 17, 70, "ExampleText",
 CellID->112558139],
Cell[CellGroupData[{
Cell[13000, 502, 365, 12, 70, "Input",
 CellID->155047900],
Cell[13368, 516, 209, 7, 36, "Output",
 CellID->200139919]
}, Open  ]],
Cell[13592, 526, 125, 3, 70, "ExampleDelimiter",
 CellID->671879674],
Cell[13720, 531, 576, 22, 70, "ExampleText",
 CellID->356793860],
Cell[CellGroupData[{
Cell[14321, 557, 384, 12, 70, "Input",
 CellID->134385914],
Cell[14708, 571, 221, 7, 36, "Output",
 CellID->8192642]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14990, 585, 311, 9, 70, "SeeAlsoSection",
 CellID->17567],
Cell[15304, 596, 1437, 53, 70, "SeeAlso",
 CellID->876]
}, Open  ]],
Cell[CellGroupData[{
Cell[16778, 654, 314, 9, 70, "TutorialsSection",
 CellID->23095],
Cell[17095, 665, 143, 3, 70, "Tutorials",
 CellID->8938]
}, Open  ]],
Cell[CellGroupData[{
Cell[17275, 673, 319, 9, 70, "MoreAboutSection",
 CellID->277293444],
Cell[17597, 684, 154, 3, 70, "MoreAbout",
 CellID->7263580],
Cell[17754, 689, 147, 3, 70, "MoreAbout",
 CellID->810334595],
Cell[17904, 694, 137, 3, 70, "MoreAbout",
 CellID->363026929]
}, Open  ]],
Cell[18056, 700, 27, 0, 70, "History"],
Cell[18086, 702, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

