(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51421,       1902]
NotebookOptionsPosition[     39016,       1459]
NotebookOutlinePosition[     40259,       1496]
CellTagsIndexPosition[     40173,       1491]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Types of Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/TypesOfNumbers"], 
          "Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Types of Numbers\"\>", 
       2->"\<\"Reading Textual Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RealDigits" :> 
          Documentation`HelpLookup["paclet:ref/RealDigits"], "BaseForm" :> 
          Documentation`HelpLookup["paclet:ref/BaseForm"], "Number" :> 
          Documentation`HelpLookup["paclet:ref/Number"], "Reals" :> 
          Documentation`HelpLookup["paclet:ref/Reals"], "Complex" :> 
          Documentation`HelpLookup["paclet:ref/Complex"], "Rational" :> 
          Documentation`HelpLookup["paclet:ref/Rational"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RealDigits\"\>", 
       2->"\<\"BaseForm\"\>", 3->"\<\"Number\"\>", 4->"\<\"Reals\"\>", 
       5->"\<\"Complex\"\>", 6->"\<\"Rational\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], 
          "Expression Structure" :> 
          Documentation`HelpLookup["paclet:guide/ExpressionStructure"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Atomic Elements of Expressions\"\>", 
       2->"\<\"Expression Structure\"\>", 
       3->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Real", "ObjectName",
 CellID->11368],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Real",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Real"]], "InlineFormula"],
     "\[LineSeparator]is the head used for real (floating\[Hyphen]point) \
numbers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8481]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["_Real"], "InlineFormula"],
 " can be used to stand for a real number in a pattern. "
}], "Notes",
 CellID->25048],

Cell["\<\
You can enter a floating\[Hyphen]point number of any length. \
\>", "Notes",
 CellID->18500],

Cell[TextData[{
 "You can enter a number in scientific notation by using the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["mantissa", "TI"], "*", 
   RowBox[{"^", 
    StyleBox["exponent", "TI"]}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19386],

Cell[TextData[{
 "You can enter a floating\[Hyphen]point number in base ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  RowBox[{
   StyleBox["b", "TI"], "^", 
   RowBox[{"^", 
    StyleBox["digits", "TI"]}]}]], "InlineFormula"],
 ". The base must be less than 36. The letters ",
 Cell[BoxData["a"], "InlineFormula"],
 "\[Dash]",
 Cell[BoxData["z"], "InlineFormula"],
 " or ",
 Cell[BoxData["A"], "InlineFormula"],
 "\[Dash]",
 Cell[BoxData["Z"], "InlineFormula"],
 " are used in sequence to stand for digits 10 through 35. "
}], "Notes",
 CellID->19413],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " is also used to indicate an approximate real number in ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24574]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->246139802],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->11841994],

Cell["Enter a real number:", "ExampleText",
 CellID->209018360],

Cell[CellGroupData[{

Cell[BoxData["1.23"], "Input",
 CellLabel->"In[1]:=",
 CellID->748377564],

Cell[BoxData["1.23`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10139581]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 " for real numbers:"
}], "ExampleText",
 CellID->305769920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->770672279],

Cell[BoxData["Real"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->130101650]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->183393434],

Cell["\<\
Real numbers entered with just a few digits are generally represented as \
machine reals:\
\>", "ExampleText",
 CellID->526221268],

Cell[CellGroupData[{

Cell[BoxData["1.23456789"], "Input",
 CellLabel->"In[1]:=",
 CellID->362866295],

Cell[BoxData["1.23456789`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->272378086]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->365474575],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1212178]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9811],

Cell["Enter a real number with many significant digits:", "ExampleText",
 CellID->5135380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", "987654321123456789.987654321123456789"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360474111],

Cell[BoxData["9.87654321123456789987654321123456789`35.994604968173014*^17"], \
"Output",
 ImageSize->{299, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->333726493]
}, Open  ]],

Cell["\<\
Arbitrary precision reals are used when too many digits are given for a \
machine number:\
\>", "ExampleText",
 CellID->236187934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->681074169],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->142837652]
}, Open  ]],

Cell[TextData[{
 "Its ",
 Cell[BoxData[
  ButtonBox["Accuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accuracy"]], "InlineFormula"],
 " is based on the number of digits to the right of the decimal point:"
}], "ExampleText",
 CellID->297964026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->307662885],

Cell[BoxData["18.000000000000004`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->105706925]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->509618741],

Cell[TextData[{
 "Enter a real number with a specified ",
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->11584218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", "1`23"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->482280941],

Cell[BoxData["1.`23."], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83668586]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21141247],

Cell[BoxData["23.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->124704882]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->481563841],

Cell[TextData[{
 "Enter a real number with a specified ",
 Cell[BoxData[
  ButtonBox["Accuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accuracy"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->622558193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", "0``12"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170756864],

Cell[BoxData["0``12."], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109420625]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28241490],

Cell[BoxData["12.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->966269881]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10558832],

Cell["Enter a real number with an exponent:", "ExampleText",
 CellID->571605199],

Cell[CellGroupData[{

Cell[BoxData["1.23*^45"], "Input",
 CellLabel->"In[1]:=",
 CellID->139232826],

Cell[BoxData["1.23`*^45"], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169401062]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->448093059],

Cell["\<\
Enter a real number with an exponent and specified precision:\
\>", "ExampleText",
 CellID->97779107],

Cell[CellGroupData[{

Cell[BoxData["1.23`45*^67"], "Input",
 CellLabel->"In[1]:=",
 CellID->40605970],

Cell[BoxData["1.23`44.99999999999999*^67"], "Output",
 ImageSize->{362, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->209809184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332175110],

Cell["Enter a real number in binary:", "ExampleText",
 CellID->663900166],

Cell[CellGroupData[{

Cell[BoxData["2^^101001000100001.0101101110111101111"], "Input",
 CellLabel->"In[1]:=",
 CellID->604478436],

Cell[BoxData["21025.358366012573`"], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142570476]
}, Open  ]],

Cell["\<\
Enter a real number in binary with precision specified in terms of bits:\
\>", "ExampleText",
 CellID->17474027],

Cell[CellGroupData[{

Cell[BoxData["2^^101001000100001.0101101110111101111`100"], "Input",
 CellLabel->"In[2]:=",
 CellID->499361359],

Cell[BoxData["21025.3583660125732421875`30.102999566398122"], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->414747226]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14577293],

Cell[BoxData["30.102999566398122`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->310502183]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "*", 
  RowBox[{"Log", "[", 
   RowBox[{"2", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->72245508],

Cell[BoxData["100.00000000000001`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->11406739]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->401688409],

Cell["Enter a real number in hexadecimal:", "ExampleText",
 CellID->520435997],

Cell[CellGroupData[{

Cell[BoxData["16^^fab.bead"], "Input",
 CellLabel->"In[1]:=",
 CellID->142012815],

Cell[BoxData["4011.744827270508`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->732319368]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174037236],

Cell["Enter a real number in base 35:", "ExampleText",
 CellID->318121702],

Cell[CellGroupData[{

Cell[BoxData["35^^thecowjumpedoverthemoon."], "Input",
 CellLabel->"In[1]:=",
 CellID->235285775],

Cell[BoxData["2.74967454112402596165414538191822888`35.43928129260896*^35"], \
"Output",
 ImageSize->{292, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79784319]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->155914803],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->276977651]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->118164365],

Cell["Format a real number using base 2:", "ExampleText",
 CellID->376679802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"1.2345", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140575763],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"1.001111000000100001\"\>", "2"],
   1.2345,
   AutoDelete->True],
  BaseForm[#, 2]& ]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//BaseForm=",
 CellID->158962757]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->635624897],

Cell[TextData[{
 "_",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " can be used to represent a real number in a pattern:"
}], "ExampleText",
 CellID->29363989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{"1.23", ",", "_Real"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->456705345],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3664893]
}, Open  ]],

Cell["A rule that replaces real numbers with nearby rationals:", "ExampleText",
 CellID->12493598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1.4142135623730951", "\[Times]", 
   SuperscriptBox["E", 
    RowBox[{"3.141592653589793", "  ", "t"}]]}], " ", "/.", " ", 
  RowBox[{"x_Real", "\[RuleDelayed]", 
   RowBox[{"Rationalize", "[", 
    RowBox[{"x", ",", "0"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->855040416],

Cell[BoxData[
 FractionBox[
  RowBox[{"77227930", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"245850922", " ", "t"}], "/", "78256779"}]]}], 
  "54608393"]], "Output",
 ImageSize->{182, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->181376730]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->88711246],

Cell["\<\
Determine if a matrix consists entirely of approximate reals:\
\>", "ExampleText",
 CellID->444628432],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1`20", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4.5"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103217058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"MatchQ", "[", 
     RowBox[{"#", ",", "_Real"}], "]"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79833454],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1003507338]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{
   RowBox[{"N", "[", "m", "]"}], ",", 
   RowBox[{
    RowBox[{"MatchQ", "[", 
     RowBox[{"#", ",", "_Real"}], "]"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->603772534],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->927015130]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->516123584],

Cell["\<\
A rule that rounds all reals to have two digits after the decimal point:\
\>", "ExampleText",
 CellID->277666339],

Cell[BoxData[
 RowBox[{
  RowBox[{"rule", "=", 
   RowBox[{"x_Real", "\[RuleDelayed]", 
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{"100", " ", "x"}], "]"}], "/", "100"}], "]"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29330501],

Cell["Divide a restaurant bill to the nearest penny:", "ExampleText",
 CellID->24405392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"123.50", "/", "7"}], " ", "/.", " ", "rule"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192035657],

Cell[BoxData["17.64`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149607787]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55314104],

Cell["Define a function that only works for reals:", "ExampleText",
 CellID->265147723],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_Real", "]"}], ":=", 
  RowBox[{"Total", "[", 
   RowBox[{"First", "[", 
    RowBox[{"RealDigits", "[", "x", "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26743356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1.2", "]"}], ",", 
   RowBox[{"f", "[", "4", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->241145684],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"f", "[", "4", "]"}]}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88815864]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->996656578],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->262708113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->357479606],

Cell["Define a function that has a special case for reals:", "ExampleText",
 CellID->18770103],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"sqrt", "[", "x_Real", "]"}], ":=", 
   RowBox[{"s", "/.", 
    RowBox[{"FindRoot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"s", "^", "2"}], "-", "x"}], ",", 
      RowBox[{"{", 
       RowBox[{"s", ",", "1."}], "}"}], ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", 
       RowBox[{"Precision", "[", "x", "]"}]}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270366039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sqrt", "[", "2`47", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->172766271],

Cell[BoxData["1.4142135623730950488016887242096980785696718753769480731767`47.\
"], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->719830943]
}, Open  ]],

Cell["\<\
For integers and rationals use the corresponding approximate real:\
\>", "ExampleText",
 CellID->2662555],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sqrt", "[", "x_Integer", "]"}], ":=", 
  RowBox[{"sqrt", "[", 
   RowBox[{"N", "[", "x", "]"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"sqrt", "[", "x_Rational", "]"}], ":=", 
  RowBox[{"sqrt", "[", 
   RowBox[{"N", "[", "x", "]"}], "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->138812556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sqrt", "[", "2", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->23199625],

Cell[BoxData["1.4142135623730951`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->7551077]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->241131515],

Cell["Reals are numbers:", "ExampleText",
 CellID->836499264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", "12.34", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399624644],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173467115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->254113784],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " is used for approximate reals:"
}], "ExampleText",
 CellID->185187222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExactNumberQ", "[", "12.34", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159211994],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210782962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86259080],

Cell["Reals are atomic objects with no subexpressions:", "ExampleText",
 CellID->174251264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtomQ", "[", "12.34", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->867844838],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197411842]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44735959],

Cell["Use different formats for displaying a real number: ", "ExampleText",
 CellID->25555655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"-", 
   RowBox[{"Pi", "^", "10."}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33260180],

Cell[BoxData[
 RowBox[{"-", "93648.04747608298`"}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3139911]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"f", "[", "r", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
      "ScientificForm", ",", "EngineeringForm", ",", "AccountingForm"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->621442609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    InterpretationBox[
     RowBox[{"\<\"-9.3648\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"4\"\>"]}],
     -93648.04747608298,
     AutoDelete->True],
    ScientificForm], ",", 
   TagBox[
    InterpretationBox[
     RowBox[{"\<\"-93.648\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"3\"\>"]}],
     -93648.04747608298,
     AutoDelete->True],
    EngineeringForm], ",", 
   TagBox[
    InterpretationBox["\<\"(93648.)\"\>",
     -93648.04747608298,
     AutoDelete->True],
    AccountingForm]}], "}"}]], "Output",
 ImageSize->{256, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28027860]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->234839004],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
 " in assumptions and to indicate domain conditions: "
}], "ExampleText",
 CellID->133064286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"Log", "[", "x", "]"}]}], "<", "1"}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64278095],

Cell[BoxData[
 RowBox[{"0", "<", "x", "<", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"ProductLog", "[", "1", "]"}]]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68214453]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->247082225],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " is only the head for approximate real numbers:"
}], "ExampleText",
 CellID->84609984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"3", "/", "4"}], ",", "Real"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->93968348],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->871786738]
}, Open  ]],

Cell["\<\
You can use the following function to test for numbers on the real axis:\
\>", "ExampleText",
 CellID->115771430],

Cell[BoxData[
 RowBox[{
  RowBox[{"realAxisQ", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"NumberQ", "[", "x", "]"}], "&&", 
   RowBox[{"!", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"x", ",", "_Complex"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->62791448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"realAxisQ", "[", 
  RowBox[{"3", "/", "4"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->180043250],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->550557046]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32300],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaseForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Number",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Number"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Complex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complex"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rational",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rational"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21986]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2625],

Cell[TextData[ButtonBox["Types of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TypesOfNumbers"]], "Tutorials",
 CellID->12664],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->10926]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->528901402],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->70779444],

Cell[TextData[ButtonBox["Expression Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExpressionStructure"]], "MoreAbout",
 CellID->722596507],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->42275757]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Real - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 24.1104252}", "context" -> "System`", 
    "keywords" -> {
     "approximate numbers", "floating-point numbers", "real numbers"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Real is the head used for real (floating-point) numbers. ", 
    "synonyms" -> {}, "title" -> "Real", "type" -> "Symbol", "uri" -> 
    "ref/Real"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5809, 188, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->246139802]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40030, 1484}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2714, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3337, 88, 42, 1, 70, "ObjectName",
 CellID->11368],
Cell[3382, 91, 436, 14, 70, "Usage",
 CellID->8481]
}, Open  ]],
Cell[CellGroupData[{
Cell[3855, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4333, 127, 144, 4, 70, "Notes",
 CellID->25048],
Cell[4480, 133, 102, 3, 70, "Notes",
 CellID->18500],
Cell[4585, 138, 254, 9, 70, "Notes",
 CellID->19386],
Cell[4842, 149, 594, 20, 70, "Notes",
 CellID->19413],
Cell[5439, 171, 333, 12, 70, "Notes",
 CellID->24574]
}, Closed]],
Cell[CellGroupData[{
Cell[5809, 188, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->246139802],
Cell[CellGroupData[{
Cell[6194, 202, 147, 5, 70, "ExampleSection",
 CellID->11841994],
Cell[6344, 209, 63, 1, 70, "ExampleText",
 CellID->209018360],
Cell[CellGroupData[{
Cell[6432, 214, 73, 2, 28, "Input",
 CellID->748377564],
Cell[6508, 218, 161, 5, 36, "Output",
 CellID->10139581]
}, Open  ]],
Cell[6684, 226, 311, 12, 70, "ExampleText",
 CellID->305769920],
Cell[CellGroupData[{
Cell[7020, 242, 100, 3, 28, "Input",
 CellID->770672279],
Cell[7123, 247, 161, 5, 36, "Output",
 CellID->130101650]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7333, 258, 221, 7, 70, "ExampleSection",
 CellID->183393434],
Cell[7557, 267, 140, 4, 70, "ExampleText",
 CellID->526221268],
Cell[CellGroupData[{
Cell[7722, 275, 79, 2, 70, "Input",
 CellID->362866295],
Cell[7804, 279, 168, 5, 36, "Output",
 CellID->272378086]
}, Open  ]],
Cell[CellGroupData[{
Cell[8009, 289, 110, 3, 70, "Input",
 CellID->365474575],
Cell[8122, 294, 159, 5, 36, "Output",
 CellID->1212178]
}, Open  ]],
Cell[8296, 302, 120, 3, 70, "ExampleDelimiter",
 CellID->9811],
Cell[8419, 307, 90, 1, 70, "ExampleText",
 CellID->5135380],
Cell[CellGroupData[{
Cell[8534, 312, 128, 3, 70, "Input",
 CellID->360474111],
Cell[8665, 317, 220, 6, 36, "Output",
 CellID->333726493]
}, Open  ]],
Cell[8900, 326, 140, 4, 70, "ExampleText",
 CellID->236187934],
Cell[CellGroupData[{
Cell[9065, 334, 110, 3, 70, "Input",
 CellID->681074169],
Cell[9178, 339, 162, 5, 36, "Output",
 CellID->142837652]
}, Open  ]],
Cell[9355, 347, 254, 8, 70, "ExampleText",
 CellID->297964026],
Cell[CellGroupData[{
Cell[9634, 359, 104, 3, 70, "Input",
 CellID->307662885],
Cell[9741, 364, 176, 5, 36, "Output",
 CellID->105706925]
}, Open  ]],
Cell[9932, 372, 125, 3, 70, "ExampleDelimiter",
 CellID->509618741],
Cell[10060, 377, 221, 8, 70, "ExampleText",
 CellID->11584218],
Cell[CellGroupData[{
Cell[10306, 389, 95, 3, 70, "Input",
 CellID->482280941],
Cell[10404, 394, 163, 5, 36, "Output",
 CellID->83668586]
}, Open  ]],
Cell[CellGroupData[{
Cell[10604, 404, 104, 3, 70, "Input",
 CellID->21141247],
Cell[10711, 409, 161, 5, 36, "Output",
 CellID->124704882]
}, Open  ]],
Cell[10887, 417, 125, 3, 70, "ExampleDelimiter",
 CellID->481563841],
Cell[11015, 422, 220, 8, 70, "ExampleText",
 CellID->622558193],
Cell[CellGroupData[{
Cell[11260, 434, 96, 3, 70, "Input",
 CellID->170756864],
Cell[11359, 439, 163, 5, 36, "Output",
 CellID->109420625]
}, Open  ]],
Cell[CellGroupData[{
Cell[11559, 449, 103, 3, 70, "Input",
 CellID->28241490],
Cell[11665, 454, 161, 5, 36, "Output",
 CellID->966269881]
}, Open  ]],
Cell[11841, 462, 124, 3, 70, "ExampleDelimiter",
 CellID->10558832],
Cell[11968, 467, 80, 1, 70, "ExampleText",
 CellID->571605199],
Cell[CellGroupData[{
Cell[12073, 472, 77, 2, 70, "Input",
 CellID->139232826],
Cell[12153, 476, 166, 5, 36, "Output",
 CellID->169401062]
}, Open  ]],
Cell[12334, 484, 125, 3, 70, "ExampleDelimiter",
 CellID->448093059],
Cell[12462, 489, 111, 3, 70, "ExampleText",
 CellID->97779107],
Cell[CellGroupData[{
Cell[12598, 496, 79, 2, 70, "Input",
 CellID->40605970],
Cell[12680, 500, 184, 5, 36, "Output",
 CellID->209809184]
}, Open  ]],
Cell[12879, 508, 125, 3, 70, "ExampleDelimiter",
 CellID->332175110],
Cell[13007, 513, 73, 1, 70, "ExampleText",
 CellID->663900166],
Cell[CellGroupData[{
Cell[13105, 518, 107, 2, 70, "Input",
 CellID->604478436],
Cell[13215, 522, 176, 5, 36, "Output",
 CellID->142570476]
}, Open  ]],
Cell[13406, 530, 122, 3, 70, "ExampleText",
 CellID->17474027],
Cell[CellGroupData[{
Cell[13553, 537, 111, 2, 70, "Input",
 CellID->499361359],
Cell[13667, 541, 202, 5, 36, "Output",
 CellID->414747226]
}, Open  ]],
Cell[CellGroupData[{
Cell[13906, 551, 104, 3, 70, "Input",
 CellID->14577293],
Cell[14013, 556, 176, 5, 36, "Output",
 CellID->310502183]
}, Open  ]],
Cell[CellGroupData[{
Cell[14226, 566, 146, 5, 70, "Input",
 CellID->72245508],
Cell[14375, 573, 175, 5, 36, "Output",
 CellID->11406739]
}, Open  ]],
Cell[14565, 581, 125, 3, 70, "ExampleDelimiter",
 CellID->401688409],
Cell[14693, 586, 78, 1, 70, "ExampleText",
 CellID->520435997],
Cell[CellGroupData[{
Cell[14796, 591, 81, 2, 70, "Input",
 CellID->142012815],
Cell[14880, 595, 175, 5, 36, "Output",
 CellID->732319368]
}, Open  ]],
Cell[15070, 603, 125, 3, 70, "ExampleDelimiter",
 CellID->174037236],
Cell[15198, 608, 74, 1, 70, "ExampleText",
 CellID->318121702],
Cell[CellGroupData[{
Cell[15297, 613, 97, 2, 70, "Input",
 CellID->235285775],
Cell[15397, 617, 218, 6, 36, "Output",
 CellID->79784319]
}, Open  ]],
Cell[CellGroupData[{
Cell[15652, 628, 110, 3, 70, "Input",
 CellID->155914803],
Cell[15765, 633, 162, 5, 36, "Output",
 CellID->276977651]
}, Open  ]],
Cell[15942, 641, 125, 3, 70, "ExampleDelimiter",
 CellID->118164365],
Cell[16070, 646, 77, 1, 70, "ExampleText",
 CellID->376679802],
Cell[CellGroupData[{
Cell[16172, 651, 132, 4, 70, "Input",
 CellID->140575763],
Cell[16307, 657, 303, 11, 50, "Output",
 CellID->158962757]
}, Open  ]],
Cell[16625, 671, 125, 3, 70, "ExampleDelimiter",
 CellID->635624897],
Cell[16753, 676, 227, 8, 70, "ExampleText",
 CellID->29363989],
Cell[CellGroupData[{
Cell[17005, 688, 132, 4, 70, "Input",
 CellID->456705345],
Cell[17140, 694, 159, 5, 36, "Output",
 CellID->3664893]
}, Open  ]],
Cell[17314, 702, 98, 1, 70, "ExampleText",
 CellID->12493598],
Cell[CellGroupData[{
Cell[17437, 707, 322, 9, 70, "Input",
 CellID->855040416],
Cell[17762, 718, 324, 11, 54, "Output",
 CellID->181376730]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18135, 735, 226, 7, 70, "ExampleSection",
 CellID->88711246],
Cell[18364, 744, 112, 3, 70, "ExampleText",
 CellID->444628432],
Cell[18479, 749, 271, 10, 70, "Input",
 CellID->103217058],
Cell[CellGroupData[{
Cell[18775, 763, 209, 7, 70, "Input",
 CellID->79833454],
Cell[18987, 772, 163, 5, 36, "Output",
 CellID->1003507338]
}, Open  ]],
Cell[CellGroupData[{
Cell[19187, 782, 239, 8, 70, "Input",
 CellID->603772534],
Cell[19429, 792, 161, 5, 36, "Output",
 CellID->927015130]
}, Open  ]],
Cell[19605, 800, 125, 3, 70, "ExampleDelimiter",
 CellID->516123584],
Cell[19733, 805, 123, 3, 70, "ExampleText",
 CellID->277666339],
Cell[19859, 810, 281, 10, 70, "Input",
 CellID->29330501],
Cell[20143, 822, 88, 1, 70, "ExampleText",
 CellID->24405392],
Cell[CellGroupData[{
Cell[20256, 827, 134, 4, 70, "Input",
 CellID->192035657],
Cell[20393, 833, 163, 5, 36, "Output",
 CellID->149607787]
}, Open  ]],
Cell[20571, 841, 124, 3, 70, "ExampleDelimiter",
 CellID->55314104],
Cell[20698, 846, 87, 1, 70, "ExampleText",
 CellID->265147723],
Cell[20788, 849, 229, 7, 70, "Input",
 CellID->26743356],
Cell[CellGroupData[{
Cell[21042, 860, 175, 6, 70, "Input",
 CellID->241145684],
Cell[21220, 868, 231, 8, 36, "Output",
 CellID->88815864]
}, Open  ]],
Cell[CellGroupData[{
Cell[21488, 881, 211, 7, 70, "Input",
 CellID->996656578],
Cell[21702, 890, 6191, 106, 70, "Output",
 Evaluatable->False,
 CellID->262708113]
}, Open  ]],
Cell[27908, 999, 125, 3, 70, "ExampleDelimiter",
 CellID->357479606],
Cell[28036, 1004, 94, 1, 70, "ExampleText",
 CellID->18770103],
Cell[28133, 1007, 446, 14, 70, "Input",
 CellID->270366039],
Cell[CellGroupData[{
Cell[28604, 1025, 103, 3, 70, "Input",
 CellID->172766271],
Cell[28710, 1030, 224, 6, 36, "Output",
 CellID->719830943]
}, Open  ]],
Cell[28949, 1039, 115, 3, 70, "ExampleText",
 CellID->2662555],
Cell[29067, 1044, 328, 10, 70, "Input",
 CellID->138812556],
Cell[CellGroupData[{
Cell[29420, 1058, 99, 3, 70, "Input",
 CellID->23199625],
Cell[29522, 1063, 174, 5, 36, "Output",
 CellID->7551077]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29745, 1074, 237, 7, 70, "ExampleSection",
 CellID->241131515],
Cell[29985, 1083, 61, 1, 70, "ExampleText",
 CellID->836499264],
Cell[CellGroupData[{
Cell[30071, 1088, 107, 3, 70, "Input",
 CellID->399624644],
Cell[30181, 1093, 161, 5, 36, "Output",
 CellID->173467115]
}, Open  ]],
Cell[30357, 1101, 125, 3, 70, "ExampleDelimiter",
 CellID->254113784],
Cell[30485, 1106, 200, 7, 70, "ExampleText",
 CellID->185187222],
Cell[CellGroupData[{
Cell[30710, 1117, 112, 3, 70, "Input",
 CellID->159211994],
Cell[30825, 1122, 162, 5, 36, "Output",
 CellID->210782962]
}, Open  ]],
Cell[31002, 1130, 124, 3, 70, "ExampleDelimiter",
 CellID->86259080],
Cell[31129, 1135, 91, 1, 70, "ExampleText",
 CellID->174251264],
Cell[CellGroupData[{
Cell[31245, 1140, 105, 3, 70, "Input",
 CellID->867844838],
Cell[31353, 1145, 161, 5, 36, "Output",
 CellID->197411842]
}, Open  ]],
Cell[31529, 1153, 124, 3, 70, "ExampleDelimiter",
 CellID->44735959],
Cell[31656, 1158, 94, 1, 70, "ExampleText",
 CellID->25555655],
Cell[CellGroupData[{
Cell[31775, 1163, 136, 5, 70, "Input",
 CellID->33260180],
Cell[31914, 1170, 190, 6, 36, "Output",
 CellID->3139911]
}, Open  ]],
Cell[CellGroupData[{
Cell[32141, 1181, 319, 11, 70, "Input",
 CellID->621442609],
Cell[32463, 1194, 709, 26, 39, "Output",
 CellID->28027860]
}, Open  ]],
Cell[33187, 1223, 125, 3, 70, "ExampleDelimiter",
 CellID->234839004],
Cell[33315, 1228, 231, 8, 70, "ExampleText",
 CellID->133064286],
Cell[CellGroupData[{
Cell[33571, 1240, 223, 8, 70, "Input",
 CellID->64278095],
Cell[33797, 1250, 266, 8, 36, "Output",
 CellID->68214453]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34112, 1264, 230, 7, 70, "ExampleSection",
 CellID->247082225],
Cell[34345, 1273, 215, 7, 70, "ExampleText",
 CellID->84609984],
Cell[CellGroupData[{
Cell[34585, 1284, 151, 5, 70, "Input",
 CellID->93968348],
Cell[34739, 1291, 162, 5, 36, "Output",
 CellID->871786738]
}, Open  ]],
Cell[34916, 1299, 123, 3, 70, "ExampleText",
 CellID->115771430],
Cell[35042, 1304, 275, 9, 70, "Input",
 CellID->62791448],
Cell[CellGroupData[{
Cell[35342, 1317, 128, 4, 70, "Input",
 CellID->180043250],
Cell[35473, 1323, 161, 5, 36, "Output",
 CellID->550557046]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35695, 1335, 311, 9, 70, "SeeAlsoSection",
 CellID->32300],
Cell[36009, 1346, 1423, 53, 70, "SeeAlso",
 CellID->21986]
}, Open  ]],
Cell[CellGroupData[{
Cell[37469, 1404, 313, 9, 70, "TutorialsSection",
 CellID->2625],
Cell[37785, 1415, 141, 3, 70, "Tutorials",
 CellID->12664],
Cell[37929, 1420, 149, 3, 70, "Tutorials",
 CellID->10926]
}, Open  ]],
Cell[CellGroupData[{
Cell[38115, 1428, 319, 9, 70, "MoreAboutSection",
 CellID->528901402],
Cell[38437, 1439, 168, 3, 70, "MoreAbout",
 CellID->70779444],
Cell[38608, 1444, 151, 3, 70, "MoreAbout",
 CellID->722596507],
Cell[38762, 1449, 159, 3, 70, "MoreAbout",
 CellID->42275757]
}, Open  ]],
Cell[38936, 1455, 50, 0, 70, "History"],
Cell[38989, 1457, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

