(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31398,       1121]
NotebookOptionsPosition[     25146,        904]
NotebookOutlinePosition[     26476,        942]
CellTagsIndexPosition[     26391,        937]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Simplifying with Assumptions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SimplifyingWithAssumptions"], "Using Assumptions" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingAssumptions"], 
          "Equations and Inequalities over Domains" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EquationsAndInequalitiesOverDomains"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Simplifying with Assumptions\"\>", 
       2->"\<\"Using Assumptions\"\>", 
       3->"\<\"Equations and Inequalities over Domains\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Element" :> Documentation`HelpLookup["paclet:ref/Element"], 
          "Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "Real" :> Documentation`HelpLookup["paclet:ref/Real"], "Integers" :> 
          Documentation`HelpLookup["paclet:ref/Integers"], "Complexes" :> 
          Documentation`HelpLookup["paclet:ref/Complexes"], "Algebraics" :> 
          Documentation`HelpLookup["paclet:ref/Algebraics"], "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"], "PowerExpand" :> 
          Documentation`HelpLookup["paclet:ref/PowerExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Element\"\>", 2->"\<\"Simplify\"\>",
        3->"\<\"Real\"\>", 4->"\<\"Integers\"\>", 5->"\<\"Complexes\"\>", 
       6->"\<\"Algebraics\"\>", 7->"\<\"ComplexExpand\"\>", 
       8->"\<\"PowerExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>",
        2->"\<\"Formula Manipulation\"\>", 3->"\<\"Number Theory\"\>", 
       4->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Reals", "ObjectName",
 CellID->1255],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Reals",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
     "\[LineSeparator]represents the domain of real numbers, as in ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], 
       StyleBox["\[Element]", "TR"], "Reals"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18897]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   StyleBox["\[Element]", "TR"], "Reals"}]], "InlineFormula"],
 " evaluates immediately only if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is a numeric quantity. "
}], "Notes",
 CellID->13672],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], 
    StyleBox["\[Element]", "TR"], "Reals"}], "]"}]], "InlineFormula"],
 " can be used to try to determine whether an expression corresponds to a \
real number. "
}], "Notes",
 CellID->14417],

Cell[TextData[{
 "Within ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " and similar functions, objects that satisfy inequalities are always \
assumed to be real. "
}], "Notes",
 CellID->16505],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
 " is output in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalR]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->3982]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->362961438],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->90260319],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Pi]", "\[ExponentialE]"], TraditionalForm]], 
  "InlineMath"],
 " is a real number:"
}], "ExampleText",
 CellID->436130550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{"Pi", "^", "E"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94897371],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13879279]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->156322036],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is a real number, so is ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"sin", "(", "x", ")"}]], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->531594117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"E", "^", 
      RowBox[{"Sin", "[", "x", "]"}]}], ",", "Reals"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Reals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111110433],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7514420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86667040],

Cell["Find real solutions of an equation:", "ExampleText",
 CellID->311965230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"2", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x", ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269611568],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "1"}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", "#1", "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", "#1", "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}]}]], "Output",
 ImageSize->{539, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173644630]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->220047014],

Cell["Test domain membership of a numeric expression:  ", "ExampleText",
 CellID->186508013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "7", "]"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150279975],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->368660750]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113067130],

Cell["Make domain membership assumptions:", "ExampleText",
 CellID->24636061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"x", "+", 
     RowBox[{"I", " ", "y"}]}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"x", "|", "y"}], ",", "Reals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144317606],

Cell[BoxData["y"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->522028369]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"1", "-", 
     RowBox[{"Abs", "[", 
      RowBox[{"x", "+", "2"}], "]"}]}], "]"}], ",", "x", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->214991929],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1u00AQdmI7CUT5KQJRibaEA/1BqlJaKhpoISc4IX7EBQqIqEJqDxVR
6SG3PEIElzxCjnkEHiGPkcdYvPZMvZ6dTdexQAhhKbZ3/O387e58a+dF5/z4
y2nn/OSo03h+1ukenxx9azz7ehaI3JzjOMPgd7roBPciuAt/QyGCa3TeC85u
IPwQtlx59nq93s/wmE6n96VEAkR4qDi33++DdIegDjOgthWUk/Qsta7vrLQI
MZeIDonLB808XIvk+Qb0kzgfrhIXGYgO2dcLrmus5YI8+RcaoRu144WnuK17
eo/xfFYbo6LR2HroQ8S+khnZDtFuMFMg+mKYjXa7DV1v2vipWcviKc0lenxl
ngyynvkzR9djRmu+8ZRee+b8aNIZM07RXBPJOb6g+Xab9EBk5Ex4EB3Spuyw
znpAR2QVei1rlum4t1h9JbB2V9Ej591jFt3UrHxicQ9A63vjU9UzHrVLUO8y
oFSLjtEvO118Ffyz0m2h8Yyh5svbf4llqiK5WuSslov3KtGdJ7gC4CoiZhvb
KihtJmf9IxZXUmwl8WXiXYW0eW9oTMiUaXnjhhqzoq8o4mqehxyqufLn8rIC
Wg6IHLODVrF9zcoKjn9Nyy21Q7nJ1XpgvHVryyqKzkC95q8bMoI9uIyl9wMr
v6zc+lxsWuv0lOq/ClluQttne/1nAaxSEccOh8PRaCRvfyjSGKtKu93uYDCI
pVlYYB/y+8b4VI2DR9HV8zoDSrXoGP2y08VHXICI6Rr3QY6V0fTOgfOb1uP5
2IJ6QXeH/H4zXFMz96/8irZnlzLbPx3HcLvuNJxTTuB0PSbO8bgcGusWHV+T
13SkNpiRm5+b7N6d0IY+ftTrNUDScTUz2QJB5lP4SWOka0HntxXS4zJ+q5F2
LoV3VVa6BJZusU83WensfUUdrsugeUnETOjivNR6t7TcvGVxT0DLK+NTNT88
6ilBvcyAUi06Rr/sdP0N70NbkF9+H7JF4uBR9Nvcxwwo1aJj9MtOFx9xVfCM
t0Pa+K0J8XdYbeEO1IKpdjUJXes89zRYq1jzTRxhyzWLIskpRYPeFdYLWjvR
+kOR5ITrVtrwi5Be5fXcIcvU4cqPDVfbL6/PKoKyH63HfCT8nMDKu59inHHu
YW09ELPm4qYWz2cW95u/gXjj8bgfHpPJhGqLcHuK1LnwpMVio/8HnNwvQd4v
QA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{151, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->222105862]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->671349405],

Cell["\<\
Specify the default domain over which a function should work:\
\>", "ExampleText",
 CellID->24255137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"E", "^", "x"}], "-", 
     RowBox[{"2", "x"}]}], "\[Equal]", "3"}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->421960511],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"3", "/", "2"}]]}]]}], "]"}]}]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"3", "/", "2"}]]}]]}]}], "]"}]}]}], 
     ")"}]}]}]}]], "Output",
 ImageSize->{485, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->579930453]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{"y", "\[Equal]", 
      RowBox[{"Sqrt", "[", "x", "]"}]}]}], "]"}], ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->759693127],

Cell[BoxData[
 RowBox[{"y", "\[GreaterEqual]", "0"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->261660105]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"x", "+", 
     RowBox[{"Sign", "[", "y", "]"}]}], "]"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->69083427],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWc1y0zAQduufxEnzMyWUwClAZzpt4URhKDADJzhQfm6cQ2GmPTBkSg+5
5QiXTo55hBzzCDxCHiOPISRbW8urjS07jgHPJIrWq9WnT9rPkvOuf3n29Vv/
8vy033tz0R+cnZ/+6L3+fsFN9oZlWVf886lr8d+M/wo+V4zxUv22xbczHA5/
B9disXC5xeXOFXHHFq2CK/Dc5NVNWe7wUty2pT/cD0OGl/B1ePks6ssejUYy
YhX1gHt0gq+oblldAlNSHfCqthdGWIAFV47qtknP7nVdUpCvb8zD6hjcNc+B
QOcsZ0CzmmFpsPiKu4Xugz3sOrhQC9GDaPDcqL89bax4/k7IOBXZ2z4vK7x8
T3r9LNX6iIWZ95G8+xiN6wPpBesO2DxArTqSXRg/ZH5sbggblB4LV6Yn4/gk
Ck+blUOlvR2ff9AtbcW5WhRbs+g+OBvo2FUSN7ByqMQQ3p3l+NxrL6ZnT2SF
efFlmRuVNnpTNj3Ei4PqnuylLkuXjEIj1Od7n2x9IxcyfY6rOVjEmbFHcrdN
RoQZgBgO07Mi75p7S/oeZIhwIkfygCXl5P+nZVuI5fuo1apaVkPxnET+Ggyv
wl1Wlqb5Sk9ZclLd4+0qoxWtitO0qlKaomuqqNauabUc/OnzfY9sXZSm1ZEH
vTOkseJM6ZEc5tO2dgYc5WpZuNObTCbT6VT8/KVYI1/VOhgMxuNxZDXTss8s
1LK75N0vaN56pJdYTdQJDbONZxLONOq+y0TrXNTPMq3bItG2kDd1uomv3qZm
wRmAEZgoIazNZP2rk2MAxqjMU5lss7iKkTgzKKKqsRWWpIw07jTuMe6a2gfy
S9NGeleVheUiVgqwhJk30lANJ45C66jZaOAplZSdSWuc0lZdl1srIHyK6rTW
0rFgdMeyfMiSNKHc/WMRmgsKgN9JdFDdR9EcVqbW4rzV82NHs0CmYuTr1tS0
N25dFp3L4Cz5N7UU420hnD6jeSxHO/PMfJpGlq+ZaW8AcbZtI//iNRIjeonq
WTQS0L1i/55GFnHGhn0pftLh5wzWOJ8Ve/aus+i0mv7UC+qxvIDdULJKrHb6
biMUNNYs+05V35L1eNVzOah0On7MNTDb1njxWBLXWc/mZuymr4Tmcv6Udvkw
p5/aG8tH4cxms1FwzefzJvKjdpqmKph2gr9DYrqJrE/I2EdkW9D0Y4nySEEA
/1JaG38ARXn3Fg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->250199745]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->171343793],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " of formatting:"
}], "ExampleText",
 CellID->2113989541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reals", "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1852759619],

Cell[BoxData[
 FormBox[
  TagBox["\[DoubleStruckCapitalR]",
   Function[{}, Reals]], TraditionalForm]], "Output",
 ImageSize->{13, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->481524418]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->516333080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
 " contains ",
 Cell[BoxData[
  ButtonBox["Rationals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationals"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Integers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Primes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Primes"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->112558139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Refine", "[", 
    RowBox[{
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "Reals"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "#"}], "]"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"Rationals", ",", "Integers", ",", "Primes"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155047900],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->398100987]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106210912],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
 " is contained in ",
 Cell[BoxData[
  ButtonBox["Complexes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->356793860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Complexes"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Reals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134385914],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->294156050]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53983531],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
 " neither contains nor is contained in ",
 Cell[BoxData[
  ButtonBox["Algebraics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Algebraics"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->139072146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Element", "[", 
      RowBox[{"#", ",", "Reals"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"#", ",", "Algebraics"}], "]"}]}], "}"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"Pi", ",", "I"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->662754147],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "True"}], "}"}]}], "}"}]], "Output",
 ImageSize->{206, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4947584]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1482],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Real",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Real"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Complexes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complexes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Algebraics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Algebraics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11495]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23828],

Cell[TextData[ButtonBox["Simplifying with Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimplifyingWithAssumptions"]], "Tutorials",
 CellID->12253],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "Tutorials",
 CellID->610],

Cell[TextData[ButtonBox["Equations and Inequalities over Domains",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EquationsAndInequalitiesOverDomains"]], "Tutorials",
 CellID->29538]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->285743904],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->339417665],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->228489897],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->136860444],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->399936589]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Reals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 26.2979812}", "context" -> "System`", 
    "keywords" -> {
     "real range", "real domain", "real axis", "real plane", "real space", 
      "real numbers", "reals", "real variables", "real solutions"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Reals represents the domain of real numbers, as in x \\[Element] Reals. \
", "synonyms" -> {}, "title" -> "Reals", "type" -> "Symbol", "uri" -> 
    "ref/Reals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6365, 195, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->362961438]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26248, 930}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3248, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3871, 95, 42, 1, 70, "ObjectName",
 CellID->1255],
Cell[3916, 98, 563, 18, 70, "Usage",
 CellID->18897]
}, Open  ]],
Cell[CellGroupData[{
Cell[4516, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4994, 138, 279, 10, 70, "Notes",
 CellID->13672],
Cell[5276, 150, 367, 12, 70, "Notes",
 CellID->14417],
Cell[5646, 164, 270, 9, 70, "Notes",
 CellID->16505],
Cell[5919, 175, 409, 15, 70, "Notes",
 CellID->3982]
}, Closed]],
Cell[CellGroupData[{
Cell[6365, 195, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->362961438],
Cell[CellGroupData[{
Cell[6750, 209, 147, 5, 70, "ExampleSection",
 CellID->90260319],
Cell[6900, 216, 186, 7, 70, "ExampleText",
 CellID->436130550],
Cell[CellGroupData[{
Cell[7111, 227, 154, 5, 28, "Input",
 CellID->94897371],
Cell[7268, 234, 160, 5, 36, "Output",
 CellID->13879279]
}, Open  ]],
Cell[7443, 242, 125, 3, 70, "ExampleDelimiter",
 CellID->156322036],
Cell[7571, 247, 289, 11, 70, "ExampleText",
 CellID->531594117],
Cell[CellGroupData[{
Cell[7885, 262, 315, 10, 70, "Input",
 CellID->111110433],
Cell[8203, 274, 159, 5, 36, "Output",
 CellID->7514420]
}, Open  ]],
Cell[8377, 282, 124, 3, 70, "ExampleDelimiter",
 CellID->86667040],
Cell[8504, 287, 78, 1, 70, "ExampleText",
 CellID->311965230],
Cell[CellGroupData[{
Cell[8607, 292, 256, 9, 70, "Input",
 CellID->269611568],
Cell[8866, 303, 781, 25, 39, "Output",
 CellID->173644630]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9696, 334, 220, 7, 70, "ExampleSection",
 CellID->220047014],
Cell[9919, 343, 92, 1, 70, "ExampleText",
 CellID->186508013],
Cell[CellGroupData[{
Cell[10036, 348, 161, 5, 70, "Input",
 CellID->150279975],
Cell[10200, 355, 161, 5, 36, "Output",
 CellID->368660750]
}, Open  ]],
Cell[10376, 363, 125, 3, 70, "ExampleDelimiter",
 CellID->113067130],
Cell[10504, 368, 77, 1, 70, "ExampleText",
 CellID->24636061],
Cell[CellGroupData[{
Cell[10606, 373, 296, 10, 70, "Input",
 CellID->144317606],
Cell[10905, 385, 158, 5, 36, "Output",
 CellID->522028369]
}, Open  ]],
Cell[CellGroupData[{
Cell[11100, 395, 360, 11, 70, "Input",
 CellID->214991929],
Cell[11463, 408, 1437, 28, 70, "Output",
 Evaluatable->False,
 CellID->222105862]
}, Open  ]],
Cell[12915, 439, 125, 3, 70, "ExampleDelimiter",
 CellID->671349405],
Cell[13043, 444, 111, 3, 70, "ExampleText",
 CellID->24255137],
Cell[CellGroupData[{
Cell[13179, 451, 245, 9, 70, "Input",
 CellID->421960511],
Cell[13427, 462, 1011, 35, 53, "Output",
 CellID->579930453]
}, Open  ]],
Cell[CellGroupData[{
Cell[14475, 502, 260, 9, 70, "Input",
 CellID->759693127],
Cell[14738, 513, 194, 6, 36, "Output",
 CellID->261660105]
}, Open  ]],
Cell[CellGroupData[{
Cell[14969, 524, 229, 8, 70, "Input",
 CellID->69083427],
Cell[15201, 534, 1448, 28, 70, "Output",
 Evaluatable->False,
 CellID->250199745]
}, Open  ]],
Cell[16664, 565, 125, 3, 70, "ExampleDelimiter",
 CellID->171343793],
Cell[16792, 570, 207, 7, 70, "ExampleText",
 CellID->2113989541],
Cell[CellGroupData[{
Cell[17024, 581, 112, 3, 70, "Input",
 CellID->1852759619],
Cell[17139, 586, 260, 8, 50, "Output",
 CellID->481524418]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17448, 600, 237, 7, 70, "ExampleSection",
 CellID->516333080],
Cell[17688, 609, 560, 22, 70, "ExampleText",
 CellID->112558139],
Cell[CellGroupData[{
Cell[18273, 635, 379, 12, 70, "Input",
 CellID->155047900],
Cell[18655, 649, 223, 7, 36, "Output",
 CellID->398100987]
}, Open  ]],
Cell[18893, 659, 125, 3, 70, "ExampleDelimiter",
 CellID->106210912],
Cell[19021, 664, 315, 12, 70, "ExampleText",
 CellID->356793860],
Cell[CellGroupData[{
Cell[19361, 680, 257, 8, 70, "Input",
 CellID->134385914],
Cell[19621, 690, 161, 5, 36, "Output",
 CellID->294156050]
}, Open  ]],
Cell[19797, 698, 124, 3, 70, "ExampleDelimiter",
 CellID->53983531],
Cell[19924, 703, 338, 12, 70, "ExampleText",
 CellID->139072146],
Cell[CellGroupData[{
Cell[20287, 719, 349, 12, 70, "Input",
 CellID->662754147],
Cell[20639, 733, 314, 11, 36, "Output",
 CellID->4947584]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21014, 751, 310, 9, 70, "SeeAlsoSection",
 CellID->1482],
Cell[21327, 762, 1933, 71, 70, "SeeAlso",
 CellID->11495]
}, Open  ]],
Cell[CellGroupData[{
Cell[23297, 838, 314, 9, 70, "TutorialsSection",
 CellID->23828],
Cell[23614, 849, 165, 3, 70, "Tutorials",
 CellID->12253],
Cell[23782, 854, 142, 3, 70, "Tutorials",
 CellID->610],
Cell[23927, 859, 188, 4, 70, "Tutorials",
 CellID->29538]
}, Open  ]],
Cell[CellGroupData[{
Cell[24152, 868, 319, 9, 70, "MoreAboutSection",
 CellID->285743904],
Cell[24474, 879, 156, 3, 70, "MoreAbout",
 CellID->339417665],
Cell[24633, 884, 151, 3, 70, "MoreAbout",
 CellID->228489897],
Cell[24787, 889, 137, 3, 70, "MoreAbout",
 CellID->136860444],
Cell[24927, 894, 147, 3, 70, "MoreAbout",
 CellID->399936589]
}, Open  ]],
Cell[25089, 900, 27, 0, 70, "History"],
Cell[25119, 902, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

