(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33344,       1246]
NotebookOptionsPosition[     26612,       1014]
NotebookOutlinePosition[     28298,       1057]
CellTagsIndexPosition[     28212,       1052]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ConstructingLists"], 
          "Collecting Expressions During Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CollectingExpressionsDuringEvaluation"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Collecting Expressions During Evaluation\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sow" :> Documentation`HelpLookup["paclet:ref/Sow"], "Catch" :> 
          Documentation`HelpLookup["paclet:ref/Catch"], "AppendTo" :> 
          Documentation`HelpLookup["paclet:ref/AppendTo"], "Print" :> 
          Documentation`HelpLookup["paclet:ref/Print"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Sow\"\>", 2->"\<\"Catch\"\>", 
       3->"\<\"AppendTo\"\>", 4->"\<\"Print\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Language Overview\"\>", 3->"\<\"List Manipulation\"\>", 
       4->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Reap", "ObjectName",
 CellID->12238],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Reap",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Reap"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the value of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " together with all expressions to which ",
     Cell[BoxData[
      ButtonBox["Sow",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
     " has been applied during its evaluation. Expressions sown using ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sow"], "[", 
       StyleBox["e", "TI"], "]"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sow"], "[", 
       RowBox[{
        StyleBox["e", "TI"], ",", 
        SubscriptBox[
         StyleBox["tag", "TI"], 
         StyleBox["i", "TI"]]}], "]"}]], "InlineFormula"],
     " with different tags are given in different lists. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Reap",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Reap"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reaps only expressions sown with tags that match ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Reap",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Reap"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["patt", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["patt", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]puts expressions associated with each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["patt", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in a separate list. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Reap",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Reap"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["patt", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           StyleBox["f", "TI"], "[", 
           RowBox[{
            SubscriptBox[
             StyleBox["tag", "TI"], 
             StyleBox["1", "TR"]], ",", 
            RowBox[{"{", 
             RowBox[{
              SubscriptBox[
               StyleBox["e", "TI"], 
               StyleBox["11", "TR"]], ",", 
              SubscriptBox[
               StyleBox["e", "TI"], 
               StyleBox["12", "TR"]], ",", 
              StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->24349]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " provide a convenient way to accumulate a list of intermediate results in a \
computation. "
}], "Notes",
 CellID->9869],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " accumulates expressions in the order in which ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " is applied to them. "
}], "Notes",
 CellID->14479],

Cell[TextData[{
 "Expressions sown with a particular tag are collected by the innermost ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " whose pattern matches the tag. "
}], "Notes",
 CellID->20549],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reap",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reap"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reap",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reap"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", "_"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19428],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19700]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56536038],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->211742116],

Cell["\<\
Evaluate a sequence of expressions, \[OpenCurlyDoubleQuote]reaping\
\[CloseCurlyDoubleQuote] ones that have been \[OpenCurlyDoubleQuote]sown\
\[CloseCurlyDoubleQuote]:\
\>", "ExampleText",
 CellID->24951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{"Sow", "[", "a", "]"}], ";", "b", ";", 
   RowBox[{"Sow", "[", "c", "]"}], ";", 
   RowBox[{"Sow", "[", "d", "]"}], ";", "e"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28052],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"e", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", "c", ",", "d"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6719]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9195],

Cell[TextData[{
 "Compute a sum, \[OpenCurlyDoubleQuote]reaping\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  RowBox[{"i", "^", "2"}]], "InlineFormula"],
 " ",
 "\[OpenCurlyDoubleQuote]",
 "sown\[CloseCurlyDoubleQuote] at each step:"
}], "ExampleText",
 CellID->4048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sow", "[", 
      RowBox[{"i", "^", "2"}], "]"}], "+", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18839],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"395", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", "49", ",",
       "64", ",", "81", ",", "100"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6989]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27054],

Cell["Make a separate sublist for each tag being reaped:", "ExampleText",
 CellID->1096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sow", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "x"}], "}"}]}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"2", ",", "y"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"3", ",", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "3"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "3"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", "2", "}"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14321]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31475],

Cell[TextData[{
 "Apply ",
 Cell[BoxData["f"], "InlineFormula"],
 " to each distinct tag and list of values:"
}], "ExampleText",
 CellID->27921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sow", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "x"}], "}"}]}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"2", ",", "y"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"3", ",", "x"}], "]"}]}], ",", "_", ",", "f"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29367],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"y", ",", 
       RowBox[{"{", "2", "}"}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25968]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sow", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "x"}], "}"}]}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"2", ",", "y"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"3", ",", "x"}], "]"}]}], ",", "_", ",", "Rule"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "3"}], "}"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17716]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26519],

Cell["\<\
Find the unique elements in a list, in the order they first occur (unsorted \
union):\
\>", "ExampleText",
 CellID->7096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reap", "[", 
   RowBox[{
    RowBox[{"Sow", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "a", ",", "b", ",", "d", ",", "c", ",", "a"}], 
       "}"}]}], "]"}], ",", "_", ",", 
    RowBox[{"#", "&"}]}], "]"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "d", ",", "c"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13861]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9961],

Cell[TextData[{
 "Find the list of values sampled by ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->24464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reap", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], ";"}], "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19169],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"Null", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"2.0408163265306121`*^-7", ",", 
       RowBox[{"\[LeftSkeleton]", "301", "\[RightSkeleton]"}], ",", 
       "9.999900201158699`"}], "}"}], "}"}]}], "}"}],
  Short]], "Output",
 ImageSize->{284, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->26962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266076260],

Cell["Remove duplicates from a list keeping original order:", "ExampleText",
 CellID->146219154],

Cell[BoxData[
 RowBox[{
  RowBox[{"unsortedUnion", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Reap", "[", 
    RowBox[{
     RowBox[{"Sow", "[", 
      RowBox[{"1", ",", "x"}], "]"}], ",", "_", ",", 
     RowBox[{"#1", "&"}]}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->688757714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"unsortedUnion", "[", 
  RowBox[{"{", 
   RowBox[{
   "b", ",", "b", ",", "c", ",", "a", ",", "c", ",", "a", ",", "b", ",", 
    "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192022355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "a", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16276005]
}, Open  ]],

Cell[TextData[{
 "This is like ",
 Cell[BoxData[
  ButtonBox["Union",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Union"]], "InlineFormula"],
 " without the sorting:"
}], "ExampleText",
 CellID->252658485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"{", 
   RowBox[{
   "b", ",", "b", ",", "c", ",", "a", ",", "c", ",", "a", ",", "b", ",", 
    "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3134434],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->471504779]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20014],

Cell[TextData[{
 "If no expressions are sown, ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " returns an empty list of expressions it has reaped:"
}], "ExampleText",
 CellID->27754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8670],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18290]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24985],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " collects expressions in exactly the order they are sown:"
}], "ExampleText",
 CellID->7278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{"MapAll", "[", 
    RowBox[{"Sow", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"x", "^", "2"}]}], ")"}]}]}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4671],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Null", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", 
      RowBox[{"a", "+", "b"}], ",", "c", ",", "x", ",", "2", ",", 
      SuperscriptBox["x", "2"], ",", 
      RowBox[{"c", "+", 
       SuperscriptBox["x", "2"]}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"c", "+", 
         SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{371, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14156]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2130],

Cell["\<\
The list associated with the first tag to be encountered is given first:\
\>", "ExampleText",
 CellID->6571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{"Sow", "[", 
    RowBox[{"1", ",", "y"}], "]"}], ";", 
   RowBox[{"Sow", "[", 
    RowBox[{"2", ",", "x"}], "]"}], ";", 
   RowBox[{"Sow", "[", 
    RowBox[{"3", ",", "y"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31354]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sow", "[", 
     RowBox[{"1", ",", "y"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"2", ",", "x"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"3", ",", "y"}], "]"}]}], ",", "_", ",", "Rule"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21429]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9773],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Catch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Catch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AppendTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AppendTo"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17367]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31086],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstructingLists"]], "Tutorials",
 CellID->686],

Cell[TextData[ButtonBox["Collecting Expressions During Evaluation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/CollectingExpressionsDuringEvaluation"]], "Tutorials",
 CellID->8661]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Reap",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Reap"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->34298725],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->157681390],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->132951919],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->409596750],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->66001196]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Reap - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 26.8604956}", "context" -> "System`", 
    "keywords" -> {
     "accumulating expressions", "collecting expressions", "growing lists", 
      "linked lists"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Reap[expr] gives the value of expr together with all expressions to \
which Sow has been applied during its evaluation. Expressions sown using \
Sow[e] or Sow[e, tag_i] with different tags are given in different lists. \
Reap[expr, patt] reaps only expressions sown with tags that match patt. \
Reap[expr, {patt_1, patt_2, ...}] puts expressions associated with each of \
the patt_i in a separate list. Reap[expr, patt, f] returns {expr, {f[tag_1, \
{e_11, e_12, ...}], ...}}. ", "synonyms" -> {}, "title" -> "Reap", "type" -> 
    "Symbol", "uri" -> "ref/Reap"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9159, 300, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->56536038]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28070, 1045}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2610, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3233, 86, 42, 1, 70, "ObjectName",
 CellID->12238],
Cell[3278, 89, 3612, 114, 70, "Usage",
 CellID->24349]
}, Open  ]],
Cell[CellGroupData[{
Cell[6927, 208, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7405, 225, 368, 13, 70, "Notes",
 CellID->9869],
Cell[7776, 240, 341, 12, 70, "Notes",
 CellID->14479],
Cell[8120, 254, 266, 8, 70, "Notes",
 CellID->20549],
Cell[8389, 264, 428, 17, 70, "Notes",
 CellID->19428],
Cell[8820, 283, 302, 12, 70, "Notes",
 CellID->19700]
}, Closed]],
Cell[CellGroupData[{
Cell[9159, 300, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56536038],
Cell[CellGroupData[{
Cell[9543, 314, 148, 5, 70, "ExampleSection",
 CellID->211742116],
Cell[9694, 321, 214, 5, 70, "ExampleText",
 CellID->24951],
Cell[CellGroupData[{
Cell[9933, 330, 242, 7, 28, "Input",
 CellID->28052],
Cell[10178, 339, 284, 10, 36, "Output",
 CellID->6719]
}, Open  ]],
Cell[10477, 352, 120, 3, 70, "ExampleDelimiter",
 CellID->9195],
Cell[10600, 357, 265, 8, 70, "ExampleText",
 CellID->4048],
Cell[CellGroupData[{
Cell[10890, 369, 287, 10, 70, "Input",
 CellID->18839],
Cell[11180, 381, 377, 12, 36, "Output",
 CellID->6989]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11606, 399, 216, 7, 70, "ExampleSection",
 CellID->27054],
Cell[11825, 408, 88, 1, 70, "ExampleText",
 CellID->1096],
Cell[CellGroupData[{
Cell[11938, 413, 440, 15, 70, "Input",
 CellID->4251],
Cell[12381, 430, 494, 17, 36, "Output",
 CellID->14321]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12924, 453, 239, 7, 70, "ExampleSection",
 CellID->31475],
Cell[13166, 462, 144, 5, 70, "ExampleText",
 CellID->27921],
Cell[CellGroupData[{
Cell[13335, 471, 392, 13, 70, "Input",
 CellID->29367],
Cell[13730, 486, 460, 16, 36, "Output",
 CellID->25968]
}, Open  ]],
Cell[CellGroupData[{
Cell[14227, 507, 398, 14, 70, "Input",
 CellID->31545],
Cell[14628, 523, 405, 14, 36, "Output",
 CellID->17716]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15082, 543, 223, 7, 70, "ExampleSection",
 CellID->26519],
Cell[15308, 552, 131, 4, 70, "ExampleText",
 CellID->7096],
Cell[CellGroupData[{
Cell[15464, 560, 362, 12, 70, "Input",
 CellID->26135],
Cell[15829, 574, 219, 7, 36, "Output",
 CellID->13861]
}, Open  ]],
Cell[16063, 584, 120, 3, 70, "ExampleDelimiter",
 CellID->9961],
Cell[16186, 589, 206, 8, 70, "ExampleText",
 CellID->24464],
Cell[CellGroupData[{
Cell[16417, 601, 406, 13, 70, "Input",
 CellID->19169],
Cell[16826, 616, 425, 14, 39, "Output",
 CellID->26962]
}, Open  ]],
Cell[17266, 633, 125, 3, 70, "ExampleDelimiter",
 CellID->266076260],
Cell[17394, 638, 96, 1, 70, "ExampleText",
 CellID->146219154],
Cell[17493, 641, 335, 11, 70, "Input",
 CellID->688757714],
Cell[CellGroupData[{
Cell[17853, 656, 225, 7, 70, "Input",
 CellID->192022355],
Cell[18081, 665, 222, 7, 36, "Output",
 CellID->16276005]
}, Open  ]],
Cell[18318, 675, 210, 8, 70, "ExampleText",
 CellID->252658485],
Cell[CellGroupData[{
Cell[18553, 687, 215, 7, 70, "Input",
 CellID->3134434],
Cell[18771, 696, 223, 7, 36, "Output",
 CellID->471504779]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19043, 709, 233, 7, 70, "ExampleSection",
 CellID->20014],
Cell[19279, 718, 250, 8, 70, "ExampleText",
 CellID->27754],
Cell[CellGroupData[{
Cell[19554, 730, 95, 3, 70, "Input",
 CellID->8670],
Cell[19652, 735, 218, 8, 36, "Output",
 CellID->18290]
}, Open  ]],
Cell[19885, 746, 121, 3, 70, "ExampleDelimiter",
 CellID->24985],
Cell[20009, 751, 221, 7, 70, "ExampleText",
 CellID->7278],
Cell[CellGroupData[{
Cell[20255, 762, 334, 12, 70, "Input",
 CellID->4671],
Cell[20592, 776, 634, 21, 39, "Output",
 CellID->14156]
}, Open  ]],
Cell[21241, 800, 120, 3, 70, "ExampleDelimiter",
 CellID->2130],
Cell[21364, 805, 118, 3, 70, "ExampleText",
 CellID->6571],
Cell[CellGroupData[{
Cell[21507, 812, 297, 10, 70, "Input",
 CellID->18834],
Cell[21807, 824, 328, 12, 36, "Output",
 CellID->31354]
}, Open  ]],
Cell[CellGroupData[{
Cell[22172, 841, 342, 12, 70, "Input",
 CellID->8343],
Cell[22517, 855, 395, 14, 36, "Output",
 CellID->21429]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22973, 876, 310, 9, 70, "SeeAlsoSection",
 CellID->9773],
Cell[23286, 887, 919, 35, 70, "SeeAlso",
 CellID->17367]
}, Open  ]],
Cell[CellGroupData[{
Cell[24242, 927, 314, 9, 70, "TutorialsSection",
 CellID->31086],
Cell[24559, 938, 144, 3, 70, "Tutorials",
 CellID->686],
Cell[24706, 943, 190, 4, 70, "Tutorials",
 CellID->8661]
}, Open  ]],
Cell[CellGroupData[{
Cell[24933, 952, 305, 8, 70, "RelatedLinksSection"],
Cell[25241, 962, 348, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25626, 978, 318, 9, 70, "MoreAboutSection",
 CellID->34298725],
Cell[25947, 989, 147, 3, 70, "MoreAbout",
 CellID->157681390],
Cell[26097, 994, 145, 3, 70, "MoreAbout",
 CellID->132951919],
Cell[26245, 999, 145, 3, 70, "MoreAbout",
 CellID->409596750],
Cell[26393, 1004, 147, 3, 70, "MoreAbout",
 CellID->66001196]
}, Open  ]],
Cell[26555, 1010, 27, 0, 70, "History"],
Cell[26585, 1012, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

